/*
#include "sky1.pov"
camera {  
  location  <     38.300,     -54.950,       6.600>
  direction <        0.0,         0.0,      1.8317> 
  sky       <    0.00000,     0.00000,     1.00000> 
  up        <        0.0,         0.0,         1.0> 
  right     <    1.33333,         0.0,         0.0> 
  look_at   <      3.500,       1.200,      11.450>
}

light_source {   
  <-53.600, -105.100, 111.500>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   
  < 38.300, -54.950, 6.600>
  color rgb 0.3
}
*/

#include "1bird.inc"

// ********  REFERENCED OBJECTS  *******

#declare CSG021 = difference {
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <2.2, 2.6, 0.2>
    translate  <-2.2, 0.05, -0.1>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <2.8, 5.1, 1.0>
    translate  <-4.5, 0.05, -0.5>
  }
  translate  -0.6*x
}
#declare CSG031 = union {
  object { CSG021 }
  torus { // Torus002
    0.8, 0.5  rotate -x*90
    material {
      Material2b
    }
    rotate -90.0*y
  }
  cone { // Cone002
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 3.0>
    rotate 90.0*y
    translate  -3.0*x
  }
}
#declare CSG039 = difference {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <3.4, 2.7, 0.2>
    translate  <-2.2, 0.05, -0.1>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <4.4, 2.3, 1.0>
    translate  <-4.5, 0.05, -0.5>
  }
  translate  <7.3, 0.3, 0.0>
}
#declare CSG020 = union {
  cone { // Cone001
    <0,0,0>, 0.8, <0,0,1>, 1.0
    material {
      Material1b
    }
    scale <1.2, 1.2, 3.0>
    translate  <0.0, 0.05, -3.0>
  }
  torus { // Torus001
    1.0, 1.0  rotate -x*90
    material {
      Material2b
    }
  }
  rotate 20.0*x
  translate  <0.0, -0.45, 2.25>
}
#declare Sphere023 = object {
  sphere { // Sphere023
    <0,0,0>,1
    scale <10.0, 15.0, 8.0>
    translate  4.4*x
  }
}
#declare Sphere025 = object {
  sphere { // Sphere025
    <0,0,0>,1
    scale <10.0, 15.0, 8.0>
    translate  3.7*x
  }
}
#declare Sphere027 = object {
  sphere { // Sphere027
    <0,0,0>,1
    scale <10.0, 15.0, 8.0>
    translate  3.7*x
  }
}
#declare Sphere029 = object {
  sphere { // Sphere029
    <0,0,0>,1
    scale <10.0, 15.0, 8.0>
    translate  3.8*x
  }
}
#declare Sphere032 = object {
  sphere { // Sphere032
    <0,0,0>,1
    scale <10.0, 15.0, 8.0>
    translate  4.0*x
  }
}
#declare Sphere033 = object {
  sphere { // Sphere033
    <0,0,0>,1
    scale <10.0, 15.0, 8.0>
    translate  1.0*x
  }
}
#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.054455, -10.059292, -0.686081>, <0.054455, -10.059292, -0.715803>, <0.029722, -10.059292, -0.740536>, <0.000000, -10.059292, -0.740536>, 
      <0.132055, -9.334790, -0.340296>, <0.132055, -9.334790, -0.370018>, <0.029722, -9.334790, -0.499531>, <0.000000, -9.334790, -0.499531>, 
      <0.250935, -8.446618, 0.412790>, <0.250935, -8.446618, 0.215608>, <0.197182, -8.407780, 0.070848>, <0.000000, -8.407780, 0.070848>, 
      <0.313122, -7.644286, 0.466535>, <0.313122, -7.644286, 0.269353>, <0.197182, -7.644286, 0.062814>, <0.000000, -7.644286, 0.062814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -10.059292, -0.631625>, <0.029722, -10.059292, -0.631625>, <0.054455, -10.059292, -0.656359>, <0.054455, -10.059292, -0.686081>, 
      <0.000000, -9.334790, -0.181061>, <0.029722, -9.334790, -0.181061>, <0.132055, -9.334790, -0.310574>, <0.132055, -9.334790, -0.340296>, 
      <0.000000, -8.488694, 0.748244>, <0.197182, -8.488694, 0.748244>, <0.250935, -8.446618, 0.609973>, <0.250935, -8.446618, 0.412790>, 
      <0.000000, -7.644286, 0.870256>, <0.197182, -7.644286, 0.870256>, <0.313122, -7.644286, 0.663717>, <0.313122, -7.644286, 0.466535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.054455, -10.059292, -0.686081>, <-0.054455, -10.059292, -0.656359>, <-0.029722, -10.059292, -0.631625>, <0.000000, -10.059292, -0.631625>, 
      <-0.132055, -9.334790, -0.340296>, <-0.132055, -9.334790, -0.310574>, <-0.029722, -9.334790, -0.181061>, <0.000000, -9.334790, -0.181061>, 
      <-0.250935, -8.446618, 0.412790>, <-0.250935, -8.446618, 0.609973>, <-0.197182, -8.488694, 0.748244>, <0.000000, -8.488694, 0.748244>, 
      <-0.313122, -7.644286, 0.466535>, <-0.313122, -7.644286, 0.663717>, <-0.197182, -7.644286, 0.870256>, <0.000000, -7.644286, 0.870256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.054455, -10.059292, -0.686081>, <-0.132055, -9.334790, -0.340296>, <-0.250935, -8.446618, 0.412790>, <-0.313122, -7.644286, 0.466535>, 
      <-0.054455, -10.059292, -0.715803>, <-0.132055, -9.334790, -0.370018>, <-0.250935, -8.446618, 0.215608>, <-0.313122, -7.644286, 0.269353>, 
      <-0.029722, -10.059292, -0.740536>, <-0.029722, -9.334790, -0.499531>, <-0.197182, -8.407780, 0.070848>, <-0.197182, -7.644286, 0.062814>, 
      <0.000000, -10.059292, -0.740536>, <0.000000, -9.334790, -0.499531>, <0.000000, -8.407780, 0.070848>, <0.000000, -7.644286, 0.062814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.499018, -4.323655, -0.301876>, <0.451602, -5.343758, -0.225815>, <0.392081, -6.625585, 0.534773>, <0.313122, -7.644286, 0.466535>, 
      <0.499018, -4.323655, -0.574239>, <0.451602, -5.343758, -0.498178>, <0.392081, -6.625585, 0.337591>, <0.313122, -7.644286, 0.269353>, 
      <0.272363, -4.323655, -0.800893>, <0.272363, -5.347668, -0.696341>, <0.197182, -6.615008, 0.051982>, <0.197182, -7.644286, 0.062814>, 
      <0.000000, -4.323655, -0.800893>, <0.000000, -5.347668, -0.696341>, <0.000000, -6.615008, 0.051982>, <0.000000, -7.644286, 0.062814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -4.323655, 0.197142>, <0.000000, -5.338882, 0.247012>, <0.000000, -6.638284, 1.015618>, <0.000000, -7.644286, 0.870256>, 
      <0.272363, -4.323655, 0.197142>, <0.272363, -5.338882, 0.247012>, <0.197182, -6.638284, 1.015618>, <0.197182, -7.644286, 0.870256>, 
      <0.499018, -4.323655, -0.029512>, <0.451602, -5.343758, 0.046548>, <0.392081, -6.625585, 0.731956>, <0.313122, -7.644286, 0.663717>, 
      <0.499018, -4.323655, -0.301876>, <0.451602, -5.343758, -0.225815>, <0.392081, -6.625585, 0.534773>, <0.313122, -7.644286, 0.466535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.499018, -4.323655, -0.301876>, <-0.451602, -5.343758, -0.225815>, <-0.392081, -6.625585, 0.534773>, <-0.313122, -7.644286, 0.466535>, 
      <-0.499018, -4.323655, -0.029512>, <-0.451602, -5.343758, 0.046548>, <-0.392081, -6.625585, 0.731956>, <-0.313122, -7.644286, 0.663717>, 
      <-0.272363, -4.323655, 0.197142>, <-0.272363, -5.338882, 0.247012>, <-0.197182, -6.638284, 1.015618>, <-0.197182, -7.644286, 0.870256>, 
      <0.000000, -4.323655, 0.197142>, <0.000000, -5.338882, 0.247012>, <0.000000, -6.638284, 1.015618>, <0.000000, -7.644286, 0.870256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.499018, -4.323655, -0.301876>, <-0.499018, -4.323655, -0.574239>, <-0.272363, -4.323655, -0.800893>, <0.000000, -4.323655, -0.800893>, 
      <-0.451602, -5.343758, -0.225815>, <-0.451602, -5.343758, -0.498178>, <-0.272363, -5.347668, -0.696341>, <0.000000, -5.347668, -0.696341>, 
      <-0.392081, -6.625585, 0.534773>, <-0.392081, -6.625585, 0.337591>, <-0.197182, -6.615008, 0.051982>, <0.000000, -6.615008, 0.051982>, 
      <-0.313122, -7.644286, 0.466535>, <-0.313122, -7.644286, 0.269353>, <-0.197182, -7.644286, 0.062814>, <0.000000, -7.644286, 0.062814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.603960, -1.387229, 0.000000>, <0.541887, -2.218435, 0.300783>, <0.540048, -3.440926, -0.367693>, <0.499018, -4.323655, -0.301876>, 
      <0.603960, -1.522554, -0.300583>, <0.541887, -2.353760, 0.000200>, <0.540048, -3.440926, -0.640056>, <0.499018, -4.323655, -0.574239>, 
      <0.329641, -1.635168, -0.550722>, <0.329641, -2.407882, -0.307694>, <0.272363, -3.517814, -0.883170>, <0.272363, -4.323655, -0.800893>, 
      <0.000000, -1.635168, -0.550722>, <0.000000, -2.407882, -0.307694>, <0.000000, -3.517814, -0.883170>, <0.000000, -4.323655, -0.800893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.139290, 0.550722>, <0.000000, -2.036475, 0.895580>, <0.000000, -3.363632, 0.149985>, <0.000000, -4.323655, 0.197142>, 
      <0.329641, -1.139290, 0.550722>, <0.329641, -2.036475, 0.895580>, <0.272363, -3.363632, 0.149985>, <0.272363, -4.323655, 0.197142>, 
      <0.603960, -1.251905, 0.300583>, <0.541887, -2.083110, 0.601367>, <0.540048, -3.440926, -0.095330>, <0.499018, -4.323655, -0.029512>, 
      <0.603960, -1.387229, 0.000000>, <0.541887, -2.218435, 0.300783>, <0.540048, -3.440926, -0.367693>, <0.499018, -4.323655, -0.301876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.603960, -1.387229, 0.000000>, <-0.541887, -2.218435, 0.300783>, <-0.540048, -3.440926, -0.367693>, <-0.499018, -4.323655, -0.301876>, 
      <-0.603960, -1.251905, 0.300583>, <-0.541887, -2.083110, 0.601367>, <-0.540048, -3.440926, -0.095330>, <-0.499018, -4.323655, -0.029512>, 
      <-0.329641, -1.139290, 0.550722>, <-0.329641, -2.036475, 0.895580>, <-0.272363, -3.363632, 0.149985>, <-0.272363, -4.323655, 0.197142>, 
      <0.000000, -1.139290, 0.550722>, <0.000000, -2.036475, 0.895580>, <0.000000, -3.363632, 0.149985>, <0.000000, -4.323655, 0.197142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.603960, -1.387229, 0.000000>, <-0.603960, -1.522554, -0.300583>, <-0.329641, -1.635168, -0.550722>, <0.000000, -1.635168, -0.550722>, 
      <-0.541887, -2.218435, 0.300783>, <-0.541887, -2.353760, 0.000200>, <-0.329641, -2.407882, -0.307694>, <0.000000, -2.407882, -0.307694>, 
      <-0.540048, -3.440926, -0.367693>, <-0.540048, -3.440926, -0.640056>, <-0.272363, -3.517814, -0.883170>, <0.000000, -3.517814, -0.883170>, 
      <-0.499018, -4.323655, -0.301876>, <-0.499018, -4.323655, -0.574239>, <-0.272363, -4.323655, -0.800893>, <0.000000, -4.323655, -0.800893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.821798, -0.001418, -1.865937>, <0.756447, -0.417161, -1.306156>, <0.653019, -0.730303, -0.237718>, <0.603960, -1.387229, 0.000000>, 
      <0.821798, -0.458598, -1.871690>, <0.756447, -0.874341, -1.311908>, <0.653019, -0.865628, -0.538301>, <0.603960, -1.522554, -0.300583>, 
      <0.457216, -0.854326, -1.892040>, <0.457216, -1.088579, -1.489644>, <0.329641, -1.191004, -0.690417>, <0.329641, -1.635168, -0.550722>, 
      <0.000000, -0.854326, -1.892040>, <0.000000, -1.088579, -1.489644>, <0.000000, -1.191004, -0.690417>, <0.000000, -1.635168, -0.550722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.049265, -1.868088>, <0.000000, 0.392698, -1.142445>, <0.000000, -0.225855, 0.199618>, <0.000000, -1.139290, 0.550722>, 
      <0.514803, 1.049265, -1.868088>, <0.514803, 0.392698, -1.142445>, <0.329641, -0.225855, 0.199618>, <0.329641, -1.139290, 0.550722>, 
      <0.821798, 0.513344, -1.859460>, <0.756447, 0.097601, -1.299679>, <0.653019, -0.594978, 0.062865>, <0.603960, -1.251905, 0.300583>, 
      <0.821798, -0.001418, -1.865937>, <0.756447, -0.417161, -1.306156>, <0.653019, -0.730303, -0.237718>, <0.603960, -1.387229, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.821798, -0.001418, -1.865937>, <-0.756447, -0.417161, -1.306156>, <-0.653019, -0.730303, -0.237718>, <-0.603960, -1.387229, 0.000000>, 
      <-0.821798, 0.513344, -1.859460>, <-0.756447, 0.097601, -1.299679>, <-0.653019, -0.594978, 0.062865>, <-0.603960, -1.251905, 0.300583>, 
      <-0.514803, 1.049265, -1.868088>, <-0.514803, 0.392698, -1.142445>, <-0.329641, -0.225855, 0.199618>, <-0.329641, -1.139290, 0.550722>, 
      <0.000000, 1.049265, -1.868088>, <0.000000, 0.392698, -1.142445>, <0.000000, -0.225855, 0.199618>, <0.000000, -1.139290, 0.550722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.821798, -0.001418, -1.865937>, <-0.821798, -0.458598, -1.871690>, <-0.457216, -0.854326, -1.892040>, <0.000000, -0.854326, -1.892040>, 
      <-0.756447, -0.417161, -1.306156>, <-0.756447, -0.874341, -1.311908>, <-0.457216, -1.088579, -1.489644>, <0.000000, -1.088579, -1.489644>, 
      <-0.653019, -0.730303, -0.237718>, <-0.653019, -0.865628, -0.538301>, <-0.329641, -1.191004, -0.690417>, <0.000000, -1.191004, -0.690417>, 
      <-0.603960, -1.387229, 0.000000>, <-0.603960, -1.522554, -0.300583>, <-0.329641, -1.635168, -0.550722>, <0.000000, -1.635168, -0.550722>
    }
  }
  material {
    Material2b
  }
  rotate <197.088318, -233.775467, 13.928096>
  translate  <-3.9, 7.9, 6.4>
}
#declare CSG028 = union {
  object { sPatchObj1 }
}
#declare Sphere001 = object {
  sphere { // Sphere001
    <0,0,0>,1
    scale <10.0, 20.0, 10.0>
    translate  5.0*x
  }
}
#declare Cylndr017 = object {
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 3.3, 20.0>
    rotate -90.0*y
    translate  <10.4, 1.45, 5.3>
  }
}
#declare Sphere035 = object {
  sphere { // Sphere035
    <0,0,0>,1
    scale <10.0, 15.0, 8.0>
    translate  3.0*x
  }
}
#declare Sphere037 = object {
  sphere { // Sphere037
    <0,0,0>,1
    scale <10.0, 15.0, 8.0>
    translate  3.5*x
  }
}
#declare Sphere039 = object {
  sphere { // Sphere039
    <0,0,0>,1
    scale <25.0, 15.0, 8.0>
    translate  3.8*x
  }
}
#declare DDIF03 = union {
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <13.5, 13.3, 1.0>
    translate  <13.1, -41.6, 0.0>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    scale <13.5, 13.3, 1.0>
    translate  <9.8, -50.4, 0.0>
  }
  translate  -0.5*z
}
#declare DIF01 = union {
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 1.0>
    translate  <7.5, 14.9, 0.0>
  }
  translate  -0.5*z
}
#declare RWING03 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 24.5, 0.1>
    translate  <2.5, -24.5, 0.0>
  }
  object { DDIF03 }
  object { DIF01 }
  material {
    K
  }
}
#declare CONECT = union {
  cone { // Cone003
    <0,0,0>, 2.0, <0,0,1>, 1.5
    scale <1.0, 1.0, 5.0>
    rotate 90.0*y
  }
  sphere { // Sphere016
    <0,0,0>,1
    scale 1.5
    translate  5.0*x
  }
  material {
    K
  }
}
#declare DDIF01 = union {
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 1.0>
    translate  <65.9, 47.8, 0.0>
  }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    scale <10.5, 10.5, 1.0>
    translate  <55.9, 39.6, 0.0>
  }
  translate  <-14.4, -49.5, -0.5>
}
#declare CSG041 = union {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 20.0, 0.1>
    translate  <20.1, -20.0, 0.1>
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 2.0, 40.0>
    rotate 90.0*y
    translate  0.1*z
  }
  rotate -21.0*z
  translate  <8.8, 24.8, 0.0>
}
#declare CSG042 = intersection {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <2.8, 19.6, 0.15>
    translate  <24.8, 3.2, 0.1>
  }
  object { CSG041 }
  bounded_by { // Bound00003
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <3.0, 24.4, 0.8>
      translate  <24.8, -1.2, 0.1>
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <12.311181, -12.587058, 0.0>
}
#declare RWING01 = difference {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    material {
      Material1b
    }
    scale <8.6, 25.6, 0.1>
    rotate 0.0*z
    translate  <31.0, 15.8, 0.0>
  }
  object { DDIF01 }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    scale <9.9, 5.6, 0.2>
    rotate <0.0, -0.0, -30.0>
    translate  <37.6, 24.9, 0.0>
  }
  object { CSG042 }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    material {
      Material1b
    }
    scale <12.0, 12.4, 0.2>
    rotate -0.0*y
    translate  <30.6, -11.5, 0.0>
  }
  material {
    Material2b
  }
  rotate 30.0*z
  translate  <16.05, -29.2, 0.0>
}
#declare W01 = union {
  cone { // Cone004
    <0,0,0>, 0.6, <0,0,1>, 0.0
    scale <1.0, 1.0, 20.0>
    rotate 90.0*y
    translate  35.0*x
  }
  object { RWING01 }
  rotate -30.0*z
  translate  <-30.310889, 17.5, 0.0>
  material {
    Material1b
  }
  rotate 30.0*y
  translate  <29.3, 15.0, 9.3>
}
#declare DDIF02 = union {
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    scale <9.4, 9.5, 1.0>
    translate  <67.5, 31.9, 0.0>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 5.9, 1.0>
    translate  <74.8, 40.1, 0.0>
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    scale <13.5, 12.1, 1.0>
    translate  <57.5, 15.6, 0.0>
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    scale <13.5, 12.1, 1.0>
    translate  <77.4, 24.4, 0.0>
  }
  translate  <-44.5, -55.8, -0.5>
}
#declare CSG043 = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 20.0, 0.1>
    translate  <20.1, -20.0, 0.1>
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 2.0, 40.0>
    rotate 90.0*y
    translate  0.1*z
  }
  rotate 30.0*z
}
#declare CSG057 = intersection {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <2.8, 19.6, 0.15>
    translate  <19.3, -3.6, 0.1>
  }
  object { CSG043 }
  bounded_by { // Bound00004
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <3.0, 22.0, 0.8>
      translate  <19.3, -6.5, 0.1>
    }
  }
  translate  <-8.7, -21.0, 0.0>
}
#declare KRILO01 = union {
  cone { // Cone005
    <0,0,0>, 1.0, <0,0,1>, 0.6
    scale <1.0, 1.0, 30.0>
    rotate 90.0*y
    translate  5.0*x
  }
  sphere { // Sphere019
    <0,0,0>,1
    translate  35.0*x
  }
  translate  <-5.0, -0.0, 0.0>
  rotate 30.0*z
  translate  <5.0, 0.0, 0.0>
}
#declare CSG060 = union {
  object { CSG057 }
  object { // CSG058->CSG057
    CSG057
    translate  <6.9, 3.8, 0.0>
  }
  object { // CSG059->CSG057
    CSG057
    translate  <13.5, 7.5, 0.0>
  }
  rotate 0.0*z
  translate  <0.02, 0.8, 0.0>
}
#declare RWING02 = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*z
    translate  <-0.0, 0.0, 0.0>
    material {
      Material1b
    }
    scale <13.0, 25.700001, 0.1>
    rotate 0.0*z
    translate  <18.0, -9.9, 0.0>
  }
  object { DDIF02 }
  object { // DDIF04->DDIF02
    DDIF02
    translate  0.5*z
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*z
    translate  <-0.0, 0.0, 0.0>
    scale <17.200001, 11.9, 0.2>
    rotate 30.0*z
    translate  <11.8, 18.4, 0.0>
  }
  object { CSG060 }
  material {
    Material2b
  }
  translate  <-0.02, -0.8, 0.0>
}
#declare W02 = union {
  object { KRILO01 }
  object { RWING02 }
  rotate -0.0*z
  translate  <-5.0, 0.0, 0.0>
  material {
    K
  }
  rotate -21.0*y
  translate  5.0*x
}
#declare CSG085 = difference {
  cone { // Cone022
    <0,0,0>, 0.5, <0,0,1>, 0.5
    scale <0.2, 10.0, 30.0>
    rotate <-90.0, -0.0, -0.0>
    translate  <-31.97, 4.6, 1.44>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    scale <5.6, 19.700001, 3.0>
    rotate -90.0*y
    translate  <-30.45, 4.5, 6.3>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 11.0, 3.0>
    rotate -90.0*y
    translate  <-30.45, 33.64, 6.54>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    scale <5.6, 19.700001, 3.0>
    rotate -90.0*y
    translate  <-30.45, 4.5, -2.88>
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 11.0, 3.0>
    rotate -90.0*y
    translate  <-30.45, 33.64, -3.74>
  }
  material {
    Material2b
  }
  scale 1.25
  rotate <0.0, 0.0, 180.0>
  translate  <-10.677584, 38.976688, -1.813351>
}
#declare CSG062 = union {
  cone { // Cone006
    <0,0,0>, 0.6, <0,0,1>, 0.0
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <29.3, 34.6, 0.0>
  }
  cone { // Cone010
    <0,0,0>, 1.5, <0,0,1>, 1.0
    material {
      Material2b
    }
    rotate -90.0*x
    translate  <29.3, 34.6, 0.0>
  }
  cone { // Cone011
    <0,0,0>, 0.5, <0,0,1>, 1.5
    scale <1.0, 1.0, 30.0>
    rotate -90.0*x
    translate  <29.3, 4.6, 0.0>
  }
  cone { // Cone021
    <0,0,0>, 0.5, <0,0,1>, 1.0
    open
    rotate -90.0*x
    translate  <29.3, 34.6, 0.0>
  }
  object { CSG085 }
  cone { // Cone023
    <0,0,0>, 1.8, <0,0,1>, 1.44
    material {
      Material2b
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <29.3, 30.95, 0.0>
  }
  cone { // Cone024
    <0,0,0>, 1.4, <0,0,1>, 1.8
    material {
      Material2b
    }
    scale <1.0, 1.0, 3.0>
    rotate -90.0*x
    translate  <29.3, 27.97, 0.0>
  }
  cone { // Cone025
    <0,0,0>, 1.5, <0,0,1>, 0.5
    open
    material {
      Material2b
    }
    scale <1.0, 1.0, 3.0>
    rotate -90.0*x
    translate  <29.3, 2.59, 0.0>
  }
  cone { // Cone026
    <0,0,0>, 1.5, <0,0,1>, 0.5
    open
    scale <1.0, 1.0, 3.0>
    rotate -90.0*x
    translate  <29.3, 1.22, 0.0>
  }
  cone { // Cone027
    <0,0,0>, 1.0, <0,0,1>, 1.5
    open
    scale <1.0, 1.0, 0.5>
    rotate -90.0*x
    translate  <29.3, 0.71, 0.0>
  }
  cone { // med
    <0,0,0>, 1.5, <0,0,1>, 0.0
    open
    material {
      TMED01
    }
    hollow
    scale <1.0, 1.0, 40.0>
    rotate 90.0*x
    translate  <29.3, 0.71, 0.0>
  }
  translate  <-0.3, -16.9, 9.3>
}
#declare CSG086 = difference {
  cone { // Cone031
    <0,0,0>, 0.5, <0,0,1>, 0.5
    scale <0.2, 10.0, 30.0>
    rotate <-90.0, -0.0, -0.0>
    translate  <-31.97, 4.6, 1.44>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    scale <5.6, 19.700001, 3.0>
    rotate -90.0*y
    translate  <-30.45, 4.5, 6.3>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 11.0, 3.0>
    rotate -90.0*y
    translate  <-30.45, 33.64, 6.54>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    scale <5.6, 19.700001, 3.0>
    rotate -90.0*y
    translate  <-30.45, 4.5, -2.88>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 11.0, 3.0>
    rotate -90.0*y
    translate  <-30.45, 33.64, -3.74>
  }
  material {
    Material2b
  }
  scale 1.25
  rotate <0.0, 0.0, 180.0>
  translate  <-10.677584, 38.976688, -1.813351>
}
#declare CSG087 = union {
  cone { // Cone007
    <0,0,0>, 0.6, <0,0,1>, 0.0
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <29.3, 34.6, 0.0>
  }
  cone { // Cone028
    <0,0,0>, 1.5, <0,0,1>, 1.0
    material {
      Material2b
    }
    rotate -90.0*x
    translate  <29.3, 34.6, 0.0>
  }
  cone { // Cone029
    <0,0,0>, 0.5, <0,0,1>, 1.5
    scale <1.0, 1.0, 35.0>
    rotate -90.0*x
    translate  <29.3, -0.4, 0.0>
  }
  cone { // Cone030
    <0,0,0>, 0.5, <0,0,1>, 1.0
    open
    rotate -90.0*x
    translate  <29.3, 34.6, 0.0>
  }
  object { CSG086 }
  cone { // Cone032
    <0,0,0>, 1.8, <0,0,1>, 1.44
    material {
      Material2b
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <29.3, 30.95, 0.0>
  }
  cone { // Cone033
    <0,0,0>, 1.4, <0,0,1>, 1.8
    material {
      Material2b
    }
    scale <1.0, 1.0, 3.0>
    rotate -90.0*x
    translate  <29.3, 27.97, 0.0>
  }
  cone { // Cone034
    <0,0,0>, 1.5, <0,0,1>, 0.5
    open
    material {
      Material2b
    }
    scale <1.0, 1.0, 3.0>
    rotate -90.0*x
    translate  <29.3, -3.41, 0.0>
  }
  cone { // Cone035
    <0,0,0>, 1.5, <0,0,1>, 0.5
    open
    scale <1.0, 1.0, 3.0>
    rotate -90.0*x
    translate  <29.3, -4.74, 0.0>
  }
  cone { // Cone036
    <0,0,0>, 1.0, <0,0,1>, 1.5
    open
    scale <1.0, 1.0, 0.5>
    rotate -90.0*x
    translate  <29.3, -5.24, 0.0>
  }
  cone { // med1
    <0,0,0>, 1.5, <0,0,1>, 0.0
    open
    material {
      TMED01
    }
    hollow
    scale <1.25, 1.25, 50.0>
    rotate <-90.0, 0.0, -180.0>
    translate  <29.3, -4.75, 0.02>
  }
  translate  <-24.32, -30.07, -0.01>
}
#declare CSG063 = union {
  object { CSG062 }
  object { CSG087 }
  material {
    Material1b
  }
}
#declare CSG064 = union {
  object { RWING03 }
  object { CONECT }
  object { W01 }
  object { W02 }
  object { CSG063 }
  scale 0.8
  rotate -180.0*z
  translate  <0.14, 7.06, -5.28>
}


#declare CSG061 = difference {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.3>
    translate  <11.3, -4.5, 0.0>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 0.7>
    translate  <12.3, -5.5, -0.35>
  }
}
#declare RUBIC = intersection {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.2, 0.3>
    translate  <11.1, -4.3, 0.0>
  }
  torus { // Torus004
    2.0, 0.3  rotate -x*90
    translate  <12.3, -5.5, 0.0>
  }
}
#declare RUBOVI = union {
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 11.6>
    rotate 90.0*y
    translate  <12.3, -3.5, 0.0>
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 6.0>
    rotate <90.0, 90.0, 0.0>
    translate  <25.9, 4.5, 0.0>
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 30.0>
    rotate 90.0*y
    translate  <27.9, 6.5, 0.0>
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 30.0>
    rotate <90.0, 90.0, 0.0>
    translate  <10.3, -5.5, 0.0>
  }
  torus { // Torus003
    2.0, 0.3  rotate -x*90
    translate  <23.9, -1.5, 0.0>
  }
  object { // RUBIC1->RUBIC
    RUBIC
    translate  <15.6, 10.0, 0.0>
  }
  object { RUBIC }
}
#declare CSG073 = difference {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.3>
    translate  <11.3, -4.5, 0.0>
  }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 0.7>
    translate  <12.3, -5.5, -0.35>
  }
}
#declare RUBIC3 = intersection {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.2, 0.3>
    translate  <11.1, -4.3, 0.0>
  }
  torus { // Torus006
    1.4, 0.3  rotate -x*90
    translate  <12.3, -5.5, 0.0>
  }
}
#declare RUBOVI2 = union {
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 11.6>
    rotate 90.0*y
    translate  <12.3, -4.1, 0.0>
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 6.0>
    rotate <90.0, 90.0, 0.0>
    translate  <26.5, 4.5, 0.0>
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 30.0>
    rotate 90.0*y
    translate  <27.9, 5.9, 0.0>
  }
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 30.0>
    rotate <90.0, 90.0, 0.0>
    translate  <10.9, -5.5, 0.0>
  }
  torus { // Torus005
    2.6, 0.3  rotate -x*90
    translate  <23.9, -1.5, 0.0>
  }
  object { RUBIC3 }
  object { // RUBIC4->RUBIC3
    RUBIC3
    translate  <15.6, 10.0, 0.0>
  }
}
#declare CSG083 = object {
  object { // CSG083->CSG073
    CSG073
    scale -1.0
    rotate -180.0*x
  }
}




//
// ********  OBJECTS  *******
//

#declare CSG037 = union {
  object { CSG031 }
  object { // CSG032->CSG031
    CSG031
    scale <1.1, 0.9, 0.9>
    rotate <0.0, 10.0, 0.0>
    translate  -3.0*x
  }
  object { // CSG033->CSG031
    CSG031
    scale <1.2, 0.8, 0.8>
    rotate 15.0*y
    translate  <-6.35, 0.0, 0.65>
  }
  object { // CSG034->CSG031
    CSG031
    scale <1.3, 0.7, 0.7>
    rotate 25.0*y
    translate  <-10.0, 0.0, 1.65>
  }
  object { // CSG035->CSG031
    CSG031
    scale <1.4, 0.6, 0.6>
    rotate 35.0*y
    translate  <-13.7, 0.0, 3.4>
  }
  object { // CSG036->CSG031
    CSG031
    scale <1.5, 0.5, 0.5>
    rotate <-0.0, 45.0, -0.0>
    translate  <-17.2, 0.0, 5.8>
  }
}
#declare CSG040 = union {
  sphere { // Sphere015
    <0,0,0>,1
    material {
      Material2b
    }
    scale <2.5, 0.9, 1.0>
    translate  <7.3, 0.1, -0.1>
  }
  object { // CSG038->CSG039
    CSG039
    rotate -90.0*x
    translate  <0.0, 0.3, 0.3>
  }
  object { CSG039 }
  rotate 45.0*y
  translate  <-25.3, 0.0, 13.9>
}
#declare REPIC = union {
  object { CSG037 }
  object { CSG040 }
  material {
    Material1b
  }
  rotate <0.0, -15.0, -90.0>
  translate  <0.0, 42.9, -3.7>
}
#declare VRATIC = union {
  object { CSG020 }
  object { // CSG022->CSG020
    CSG020
    rotate 20.0*x
    translate  <0.0, 1.7, -2.55>
  }
  object { // CSG025->CSG020
    CSG020
    rotate 35.0*x
    translate  <0.0, 4.0, -4.65>
  }
  object { // CSG026->CSG020
    CSG020
    rotate 45.0*x
    translate  <0.0, 6.65, -6.15>
  }
  object { // CSG027->CSG020
    CSG020
    rotate 55.0*x
    translate  <0.0, 9.5, -7.15>
  }
}
#declare CSG044 = intersection {
  object { Sphere023 }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 14.0, 20.0>
    rotate -90.0*y
    translate  10.0*x
  }
  object { // Sphere024->Sphere023
    Sphere023
    translate  -8.8*x
  }
}
#declare CSG045 = union {
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <8.9, 22.4, 20.0>
    rotate -90.0*y
    translate  <10.0, -13.65, -6.95>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 20.0>
    rotate -90.0*y
    translate  <10.0, 17.15, -2.45>
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <7.2, 10.8, 20.0>
    rotate -90.0*y
    translate  <10.0, 2.15, -9.1>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <5.6, 6.7, 20.0>
    rotate -90.0*y
    translate  <10.0, 12.95, -7.5>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <3.9, 3.9, 20.0>
    rotate -90.0*y
    translate  <10.0, -14.6, 0.0>
  }
}
#declare OSNOVA4 = difference {
  object { CSG044 }
  object { CSG045 }
  material {
    ZUCKA
  }
}
#declare CSG046 = intersection {
  object { Sphere025 }
  object { // Sphere026->Sphere025
    Sphere025
    translate  -7.4*x
  }
}
#declare CSG047 = difference {
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    scale <5.5, 12.5, 15.0>
    rotate -90.0*y
    translate  7.5*x
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <9.4, 22.9, 20.0>
    rotate -90.0*y
    translate  <10.0, -13.65, -6.95>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <8.55, 8.5, 20.0>
    rotate -90.0*y
    translate  <10.0, 17.15, -2.45>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <7.7, 11.33, 20.0>
    rotate -90.0*y
    translate  <10.0, 2.15, -9.1>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <6.6, 7.7, 20.0>
    rotate -90.0*y
    translate  <10.0, 12.95, -7.5>
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <4.4, 4.4, 20.0>
    rotate -90.0*y
    translate  <10.0, -14.6, 0.0>
  }
}
#declare CSG048 = union {
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <9.9, 23.4, 20.0>
    rotate -90.0*y
    translate  <10.0, -13.65, -6.95>
  }
}
#declare OSNOVA3 = intersection {
  object { CSG046 }
  object { CSG047 }
  object { CSG048 }
  material {
    BJELKA
  }
}
#declare CSG049 = intersection {
  object { Sphere027 }
  object { // Sphere028->Sphere027
    Sphere027
    translate  -7.4*x
  }
}
#declare CSG050 = difference {
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <5.5, 12.5, 15.0>
    rotate -90.0*y
    translate  7.5*x
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale <10.4, 23.9, 20.0>
    rotate -90.0*y
    translate  <10.0, -13.65, -6.95>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    scale <8.55, 8.5, 20.0>
    rotate -90.0*y
    translate  <10.0, 17.15, -2.45>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <7.7, 11.33, 20.0>
    rotate -90.0*y
    translate  <10.0, 2.15, -9.1>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    scale <6.6, 7.7, 20.0>
    rotate -90.0*y
    translate  <10.0, 12.95, -7.5>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    scale <4.4, 4.4, 20.0>
    rotate -90.0*y
    translate  <10.0, -14.6, 0.0>
  }
}
#declare OSNOVA2 = intersection {
  object { CSG049 }
  object { CSG050 }
  material {
    BJELKA
  }
}
#declare CSG051 = intersection {
  object { Sphere029 }
  object { // Sphere030->Sphere029
    Sphere029
    translate  -7.6*x
  }
}
#declare CSG052 = difference {
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 13.0, 15.0>
    rotate -90.0*y
    translate  7.5*x
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    scale <8.9, 22.4, 20.0>
    rotate -90.0*y
    translate  <10.0, -13.65, -6.95>
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 20.0>
    rotate -90.0*y
    translate  <10.0, 17.15, -2.45>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale <7.2, 10.8, 20.0>
    rotate -90.0*y
    translate  <10.0, 2.15, -9.1>
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale <6.1, 7.2, 20.0>
    rotate -90.0*y
    translate  <10.0, 12.95, -7.5>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <3.9, 3.9, 20.0>
    rotate -90.0*y
    translate  <10.0, -14.6, 0.0>
  }
}
#declare OSNOVA1 = intersection {
  object { CSG051 }
  object { CSG052 }
  material {
    ZUCKA
  }
}
#declare CSG053 = intersection {
  object { // Sphere031->Sphere032
    Sphere032
    translate  -8.0*x
  }
  object { Sphere032 }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 14.0, 20.0>
    rotate -90.0*y
    translate  10.0*x
  }
  material {
    BJELKA
  }
}
#declare CSG054 = union {
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale <7.9, -21.4, 20.0>
    rotate -90.0*y
    translate  <10.0, -13.65, -6.95>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 7.0, 20.0>
    rotate -90.0*y
    translate  <10.0, 17.15, -2.45>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <6.2, -9.8, 20.0>
    rotate -90.0*y
    translate  <10.0, 2.15, -9.1>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <5.1, -6.2, 20.0>
    rotate -90.0*y
    translate  <10.0, 12.95, -7.5>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <2.9, -2.9, 20.0>
    rotate -90.0*y
    translate  <10.0, -14.6, 0.0>
  }
}
#declare OSNOVA = difference {
  object { CSG053 }
  object { CSG054 }
  material {
    BJELKA
  }
}
#declare CSG055 = difference {
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    scale <9.6, 18.0, 3.0>
    rotate -90.0*y
    translate  1.45*x
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, -11.2, 4.0>
    rotate -90.0*y
    translate  <1.95, 15.05, -5.55>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale <8.6, -22.4, 4.0>
    rotate -90.0*y
    translate  <1.95, -1.85, -3.6>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    scale <7.1, -7.6, 4.0>
    rotate -90.0*y
    translate  <1.95, -8.2, 2.75>
  }
}
#declare CSG056 = intersection {
  object { Sphere033 }
  object { // Sphere034->Sphere033
    Sphere033
    translate  -2.0*x
  }
  object { CSG055 }
  material {
    ZUCKA
  }
  scale <0.1, 1.0, 1.0>
}
#declare TIJELO = union {
  object { OSNOVA4 }
  object { OSNOVA3 }
  object { OSNOVA2 }
  object { OSNOVA1 }
  object { OSNOVA }
  object { CSG056 }
  scale 1.4
  rotate 180.0*z
  translate  <0.0, 26.25, -6.05>
}
#declare CSG029 = union {
  object { CSG028 }
  object { // CSG030->CSG028
    CSG028
    scale -1.0
    rotate -180.0*x
  }
}
#declare CSG023 = intersection {
  object { // Sphere017->Sphere001
    Sphere001
    translate  -12.0*x
  }
  sphere { // Sphere018
    <0,0,0>,1
    scale <10.0, 20.0, 10.0>
    translate  6.0*x
  }
}
#declare CSG024 = union {
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <12.8, -12.6, 30.0>
    rotate -90.0*y
    translate  <14.35, 13.25, 1.1>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <9.8, -22.5, 30.0>
    rotate -90.0*y
    translate  <14.35, 1.85, -6.7>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <8.4, -9.4, 30.0>
    rotate -90.0*y
    translate  <14.35, 6.9, 12.6>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <4.5, -2.9, 30.0>
    rotate -90.0*y
    translate  <14.35, -14.4, -4.55>
  }
}
#declare GLAVNA1 = difference {
  object { CSG023 }
  object { CSG024 }
}
#declare NOSIC = union {
  object { GLAVNA1 }
  material {
    Material2b
  }
  bounded_by { // Bound00002
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <9.0, 17.700001, 6.2>
      translate  <-0.35, -5.65, 4.7>
    }
  }
}
#declare CSG014 = union {
  sphere { // Sphere011
    <0,0,0>,1
    scale <0.6, 1.0, 0.6>
    translate  9.555*x
  }
  rotate -35.0*y
  translate  -5.0*x
}
#declare CSG015 = union {
  sphere { // Sphere012
    <0,0,0>,1
    scale <0.6, 1.0, 0.6>
    translate  -9.55*x
  }
  rotate <-0.0, 35.0, 0.0>
  translate  5.0*x
}
#declare OCIM = union {
  object { CSG014 }
  object { CSG015 }
  material {
    Material2b
  }
}
#declare CSG010 = intersection {
  object { // Sphere007->Sphere001
    Sphere001
    translate  -9.0*x
  }
  sphere { // Sphere008
    <0,0,0>,1
    scale <10.0, 20.0, 10.0>
    translate  4.5*x
  }
}
#declare CSG011 = union {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <9.5, -11.7, 20.0>
    rotate -90.0*y
    translate  <10.2, -13.65, -0.4>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 30.0>
    rotate -90.0*y
    translate  <14.9, -0.05, 0.0>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <12.2, -17.4, 30.0>
    rotate -90.0*y
    translate  <14.9, 25.45, 10.6>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <9.5, -14.9, 30.0>
    rotate -90.0*y
    translate  <14.9, 4.85, -5.1>
  }
}
#declare kapica1 = difference {
  object { CSG010 }
  object { CSG011 }
  material {
    Material2b
  }
}
#declare CSG008 = intersection {
  object { // Sphere005->Sphere001
    Sphere001
    translate  -8.0*x
  }
  sphere { // Sphere006
    <0,0,0>,1
    scale <10.0, 20.0, 10.0>
    translate  4.0*x
  }
}
#declare CSG009 = union {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <9.5, -11.7, 20.0>
    rotate -90.0*y
    translate  <10.2, -11.3, 1.05>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 16.0, 30.0>
    rotate -90.0*y
    translate  <14.9, -0.05, 0.0>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <12.2, -17.4, 30.0>
    rotate -90.0*y
    translate  <14.9, 7.85, -5.5>
  }
}
#declare kapica = difference {
  object { CSG008 }
  object { CSG009 }
  material {
    Material2b
  }
}
#declare CSG004 = intersection {
  object { // Sphere003->Sphere001
    Sphere001
    translate  -9.0*x
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale <10.0, 20.0, 10.0>
    translate  4.5*x
  }
}
#declare CSG006 = difference {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <9.5, -11.7, 20.0>
    rotate -90.0*y
    translate  <10.2, -20.35, 6.95>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <14.3, -15.0, 30.0>
    rotate -90.0*y
    translate  <14.9, -0.5, -2.6>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <1.6, -1.8, 30.0>
    rotate -90.0*y
    translate  <14.9, -18.35, -0.4>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, -6.7, 30.0>
    rotate -90.0*y
    translate  <14.9, -12.6, -2.85>
  }
}
#declare CSG005 = intersection {
  object { CSG004 }
  object { CSG006 }
  material {
    Material2b
  }
}
#declare CSG001 = intersection {
  object { // Sphere002->Sphere001
    Sphere001
    translate  -10.0*x
  }
  object { Sphere001 }
}
#declare CSG002 = union {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <8.5, -11.2, 30.0>
    rotate -90.0*y
    translate  <14.35, 17.85, -1.15>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <8.5, -18.700001, 30.0>
    rotate -90.0*y
    translate  <14.35, 1.85, -6.7>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <8.4, -9.4, 30.0>
    rotate -90.0*y
    translate  <14.35, 11.6, 12.55>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <6.4, -6.6, 30.0>
    rotate -90.0*y
    translate  <14.35, -14.4, -4.55>
  }
}
#declare CSG013 = union {
  sphere { // Sphere010
    <0,0,0>,1
    scale <0.5, 3.0, 0.8>
    translate  -10.0*x
  }
  rotate <-0.0, 35.0, 0.0>
  translate  5.0*x
}
#declare CSG003 = union {
  sphere { // Sphere009
    <0,0,0>,1
    scale <0.55, 3.0, 0.8>
    translate  10.0*x
  }
  rotate -35.0*y
  translate  -5.0*x
}
#declare CSG019 = union {
  object { CSG013 }
  object { CSG003 }
}
#declare CSG012 = intersection {
  object { CSG019 }
  object { Cylndr017 }
  object { // Cylndr018->Cylndr017
    Cylndr017
    rotate 0.0*z
    translate  <0.0, -2.7, 0.95>
  }
}
#declare CSG016 = union {
  sphere { // Sphere013
    <0,0,0>,1
    scale <2.0, 6.0, 3.0>
    translate  10.0*x
  }
  rotate <-20.0, -5.0, 0.0>
  translate  -5.0*x
}
#declare CSG017 = union {
  sphere { // Sphere014
    <0,0,0>,1
    scale <2.0, 6.0, 3.0>
    translate  -10.0*x
  }
  rotate <-20.0, 5.0, 0.0>
  translate  5.0*x
}
#declare CSG018 = union {
  object { CSG016 }
  object { CSG017 }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 3.2, 20.0>
    rotate <-270.0, -105.0, 270.0>
    translate  <9.9, -0.7, 1.35>
  }
}
#declare GLAVNA = difference {
  object { CSG001 }
  object { CSG002 }
  object { CSG012 }
  object { CSG018 }
  material {
    Material1b
  }
}
#declare CSG007 = union {
  object { CSG005 }
  object { GLAVNA }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <9.0, 17.700001, 6.2>
      translate  <-0.35, -5.65, 4.7>
    }
  }
}
#declare GLAVA = union {
  object { CSG029 }
  object { NOSIC }
  object { OCIM }
  object { kapica1 }
  object { kapica }
  object { CSG007 }
  rotate 15.0*x
  translate  <0.0, 1.6, -0.05>
}
#declare CSG077 = intersection {
  object { Sphere035 }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 15.0, 20.0>
    rotate -90.0*y
    translate  10.0*x
  }
  object { // Sphere036->Sphere035
    Sphere035
    translate  -6.0*x
  }
}
#declare CSG078 = union {
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 22.4, 20.0>
    rotate -90.0*y
    translate  <10.0, -13.65, -6.95>
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    scale <7.5, 11.5, 20.0>
    rotate -90.0*y
    translate  10.0*x
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    scale <3.3, 3.9, 20.0>
    rotate -90.0*y
    translate  <10.0, -4.9, 8.7>
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate -90.0*y
    translate  <10.0, -14.6, 0.0>
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    scale <11.3, 11.1, 20.0>
    rotate -90.0*y
    translate  <10.0, 5.9, 0.5>
  }
}
#declare DODREPU = difference {
  object { CSG077 }
  object { CSG078 }
  material {
    Material1b
  }
  scale 1.4
  rotate -180.0*z
  translate  <0.0, 26.25, -6.05>
}
#declare CSG079 = intersection {
  object { Sphere037 }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 15.0, 20.0>
    rotate -90.0*y
    translate  10.0*x
  }
  object { // Sphere038->Sphere037
    Sphere037
    translate  -7.0*x
  }
}
#declare CSG080 = union {
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 22.4, 20.0>
    rotate -90.0*y
    translate  <10.0, -13.65, -6.95>
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 11.0, 20.0>
    rotate -90.0*y
    translate  10.0*x
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    scale <3.3, 3.9, 20.0>
    rotate -90.0*y
    translate  <10.0, -4.1, 8.7>
  }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    scale <2.6, 2.6, 20.0>
    rotate -90.0*y
    translate  <10.0, -14.6, 0.0>
  }
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    scale <11.3, 11.1, 20.0>
    rotate -90.0*y
    translate  <10.0, 5.9, 0.5>
  }
}
#declare DODREPU1 = difference {
  object { CSG079 }
  object { CSG080 }
  material {
    Material2b
  }
  scale 1.4
  rotate -180.0*z
  translate  <0.0, 26.25, -6.05>
}
#declare CSG065 = intersection {
  object { Sphere039 }
  object { // Sphere040->Sphere039
    Sphere039
    translate  -7.6*x
  }
}
#declare CSG081 = difference {
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 13.0, 50.0>
    rotate -90.0*y
    translate  25.0*x
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    scale <8.9, 22.4, 52.0>
    rotate -90.0*y
    translate  <26.0, -13.65, -6.95>
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 52.0>
    rotate -90.0*y
    translate  <26.0, 17.15, -2.45>
  }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    scale <7.2, 10.8, 52.0>
    rotate -90.0*y
    translate  <26.0, 2.15, -9.1>
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    scale <6.1, 7.2, 52.0>
    rotate -90.0*y
    translate  <26.0, 12.95, -7.5>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    scale <3.9, 3.9, 52.0>
    rotate -90.0*y
    translate  <26.0, -14.6, 0.0>
  }
}
#declare OSNOVA5 = intersection {
  object { CSG065 }
  object { CSG081 }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    scale <9.9, 23.4, 52.0>
    rotate -90.0*y
    translate  <26.0, -13.65, -6.95>
  }
  material {
    Material1b
  }
  scale 1.4
  rotate -180.0*z
  translate  <0.0, 26.25, -6.05>
}
#declare krila = union {
  object { CSG064 }
  object { // CSG066->CSG064
    CSG064
    scale -1.0
    rotate <-180.0, 0.0, -0.0>
    translate  -0.35*x
  }
  translate  <0.0, 8.7, -7.35>
}
union { // EMBIRD
  object { REPIC }
  object { VRATIC }
  object { TIJELO }
  object { GLAVA }
  object { DODREPU }
  object { DODREPU1 }
  // object { OSNOVA5 }
  object { krila }
  scale 0.115
  rotate <-1.709638, -18.360153, 75.311043>
  // translate  <16.55, -9.95, 6.25>
  translate  <28.50, -18.95, 16.85>
}


