/*
camera {
   location <0,10,-40>
   look_at <0,0,0>
}    

light_source {
   <10,10,-10>
   color rgb <1,1,1>
}
*/

#declare TWood01 =
texture {
   pigment {
      wood
      pigment_map {
         [ 0.0
            wrinkles
            color_map {
               [ 0 color rgb <.8,.6,.1>*0.6 ]
               [ 1 color rgb <.8,.6,.1>*0.5 ]
            }      
            scale 2
         ]
         [ 0.7
            agate
            color_map {
               [ 0 color rgb <.8,.6,.1>*0.6 ]
               [ 1 color rgb <.8,.6,.1>*0.5 ]
            }
            scale 2
         ]
         [ 0.8 color rgb <.8,.6,.1>*0.5 ]
         [ 1.0 color rgb <.8,.6,.1>*0.5 ]
      }
      scale <1,1,1>
      turbulence 0.03
      octaves 3
      lambda 4
      omega 0.5
   }
   finish {
      ambient 0.2
      diffuse 0.7
      specular 0.1
      roughness .8
      brilliance .5
      crand 0.03
   }
   normal {
      wrinkles
      slope_map {
         [ 0.0 <1,0>]
         [ 0.6 <1,0>]
         [ 0.7 <.9,0>]
         [ 1.0 <.9,0>]
      }
      scale <.1,1,2>
      turbulence 0.03
      octaves 3
      lambda 4
      omega 0.5
   }
}
texture {
   pigment {
      wrinkles
      color_map {
         [ 0.0 color rgbt <.4,.3,.1,.4> ]
         [ 0.6 color rgbt <.4,.3,.1,.4> ]
         [ 0.7 color rgbt <0,0,0,1> ]
         [ 1.0 color rgbt <0,0,0,1> ]
      }
      scale <.1,1,2>
      turbulence 0.03
      octaves 3
      lambda 4
      omega 0.5
   }
   finish {
      ambient 0.2
      diffuse 0.7
      specular 0.1
      roughness .8
      brilliance .5
      crand 0.03
   }
   normal {
      wrinkles
      slope_map {
         [ 0.0 <1,0>]
         [ 0.6 <1,0>]
         [ 0.7 <.9,0>]
         [ 1.0 <.9,0>]
      }
      scale <.1,1,2>
      turbulence 0.03
      octaves 3
      lambda 4
      omega 0.5
   }
}


#declare MStone01 = 
texture {
   pigment {
      wrinkles
      color_map {
         [ 0.0 color rgb <0.7,0.9,0.85>*1.1 ]
         [ 0.4 color rgb <0.7,0.9,0.85>*1.1 ]
         [ 0.6 color rgb <0.7,0.9,0.85> ]
         [ 1.0 color rgb <0.7,0.9,0.85> ]
      }
   
   }
   finish  {
      ambient 0.1
      diffuse 0.7
      specular 0.05
      roughness 0.3
   }
   normal {
      wrinkles
      normal_map {
         [ 0.0 granite 0.2  ]
         [ 0.25 granite 0.2  ]
         [ 0.25 granite 0.05 ]
         [ 1.0 granite 0.05 ]
      }
      scale 0.5
   } 
}
texture {
   pigment {
      bumps
      color_map {
         [ 0.0 color rgbt <0.7,0.9,0.85,0.8>*1.3 ]
         [ 0.4 color rgbt <0.7,0.9,0.85,0.8>*1.3 ]
         [ 0.6 color rgbt <0.7,0.9,0.85,0.8>/0.8 ]
         [ 1.0 color rgbt <0.7,0.9,0.85,0.8>/0.8 ]
      }
      scale 8
   
   }
   finish  {
      ambient 0.1
      diffuse 0.7
      specular 0.05
      roughness 0.3
   }
   normal {
      wrinkles
      normal_map {
      [ 0.0 bumps 0.01 ]
      [ 0.5 bumps 0.01 ]
      [ .6
       agate
       slope_map {
         [ 0.2 <0,.5> ]
         [ 0.4  <1,.5> ]
      }
      scale 3
      ]
      } 
      scale 5
   }

}
texture {
   pigment {
      granite
      color_map {
         [ 0.0 color rgbt <0.7,0.9,0.85,0.5> ]
         [ 1.0 color rgbt <0.7,0.9,0.85,0.5>*0.7 ]
      }
      scale 0.5
   }
   finish  {
      ambient 0.1
      diffuse 0.7
      specular 0.05
      roughness 0.3
   }
   normal {
      granite .15
      scale 1.5
   }
}
texture {
   pigment {
      crackle
      color_map {
         [ 0.01 color rgbt <0.7,0.9,0.85,0.6> ]
         [ 0.02 color rgbt <0.7,0.9,0.85,0.6> ]
         [ 0.03 color rgbt <1,1,1,1> ]
      }
      scale 10
      turbulence 0.2
      octaves 6
      lambda 2
      omega 0.5
   }
   finish  {
      ambient 0.1
      diffuse 0.7
      specular 0.05
      roughness 0.3
   }
   normal {
      wrinkles
      normal_map {
      [ 0.0 bumps 0.01 ]
      [ 0.5 bumps 0.01 ]
      [ .6
       agate
       slope_map {
         [ 0.2 <0,.5> ]
         [ 0.4  <1,.5> ]
      }
      scale 3
      ]
      } 
      scale 5
   }
}

#declare MStone01aa = 
texture {
   pigment {
      wrinkles
      color_map {
         [ 0.0 color rgb <0.7,0.9,0.85>*1.1 ]
         [ 0.4 color rgb <0.7,0.9,0.85>*1.1 ]
         [ 0.6 color rgb <0.7,0.9,0.85> ]
         [ 1.0 color rgb <0.7,0.9,0.85> ]
      }
   
   }
   finish  {
      ambient 0.1
      diffuse 0.7
      specular 0.05
      roughness 0.3
   }
   normal {
      wrinkles
      normal_map {
         [ 0.0 granite 0.2  ]
         [ 0.25 granite 0.2  ]
         [ 0.25 granite 0.05 ]
         [ 1.0 granite 0.05 ]
      }
      scale 0.5
   } 
}
texture {
   pigment {
      bumps
      color_map {
         [ 0.0 color rgbt <0.7,0.9,0.85,0.8>*1.3 ]
         [ 0.4 color rgbt <0.7,0.9,0.85,0.8>*1.2 ]
         [ 0.6 color rgbt <0.7,0.9,0.85,0.8>*0.7 ]
         [ 1.0 color rgbt <0.7,0.9,0.85,0.8>*0.6 ]
      }
      scale 8
   
   }
   finish  {
      ambient 0.1
      diffuse 0.7
      specular 0.05
      roughness 0.3
   }
   normal {
      wrinkles
      normal_map {
      [ 0.0 bumps 0.01 ]
      [ 0.5 bumps 0.01 ]
      [ .6
       agate
       slope_map {
         [ 0.2 <0,.5> ]
         [ 0.4  <1,.5> ]
      }
      scale 3
      ]
      } 
      scale 5
   }

}
texture {
   pigment {
      granite
      color_map {
         [ 0.0 color rgbt <0.7,0.9,0.85,0.5> ]
         [ 1.0 color rgbt <0.9,0.9,0.55,0.5>*0.6 ]
      }
      scale 0.5
   }
   finish  {
      ambient 0.1
      diffuse 0.7
      specular 0.05
      roughness 0.3
   }
   normal {
      granite .15
      scale 0.5
   }
}
texture {
   pigment {
      crackle
      color_map {
         [ 0.01 color rgbt <0.7,0.9,0.85,0.6> ]
         [ 0.02 color rgbt <0.7,0.9,0.85,0.6> ]
         [ 0.03 color rgbt <1,1,1,1> ]
      }
      scale 10
      turbulence 0.2
      octaves 6
      lambda 2
      omega 0.5
   }
   finish  {
      ambient 0.1
      diffuse 0.7
      specular 0.05
      roughness 0.3
   }
   normal {
      agate
      normal_map {
      [ 0.0 bumps 0.01 ]
      [ 0.5 bumps 0.01 ]
      [ .6
       agate
       slope_map {
         [ 0.2 <0,.5> ]
         [ 0.4  <3,.5> ]
      }
      scale 3
      ]
      } 
      scale 5
   }
}


#declare Voda =
material {
   texture {
      pigment { color rgbt <0,0,0,.9> }
      finish {
         ambient 0
         diffuse 0
         reflection 0.3
         phong 1
         phong_size 80
      }
      normal {
        bumps 0.07 scale 0.05
      } 
   
   }
   interior {
      ior 1.33
      media {
         absorption rgb<.1,.1,.2>*0.3
         emission rgb <0.1,0.1,0.2>*0.55
      }
   }
}

#declare MStone02 =
texture { MStone01 }
texture {
   pigment {
      color rgbt <.9,.3,.1,0.8>
   }
}
#declare MStone03 =
texture { MStone01 }
texture {
   pigment {
      color rgbt <.6,.6,.2,0.8>
   }
}

#declare Trava =
texture {
   pigment {
      color rgb <0,1,0>
   }
   normal {
      wrinkles 0.1
      scale 10
   }
   finish {
      ambient 0.1
      diffuse 0.4
      specular 0.05
      roughness 0.5
      crand 0.05
   }
}
texture {
   pigment {
      color rgbt <0,1,0,.5>
   }
   normal {
      bumps 0.1
      scale 0.1
   }
   finish {
      ambient 0.1
      diffuse 0.4
      specular 0.05
      roughness 0.5
      crand 0.05
   }
}

texture {
   pigment {
      gradient z
      pigment_map {
         [ 0
            wrinkles
            color_map {
               [ 0.0 color rgbt <0,0,0,1> ]
               [ 0.5 color rgbt <0.5,0.6,0.5,.7> ]
               [ 1.0 color rgbt <0,0,0,.6> ]
            }
            scale 0.4
          
         ]
         [ 0.5
            wrinkles
            color_map {
               [ 0 color rgbt <0,0,0,1> ]
               [ 1 color rgbt <0,0,0,.6> ]
            }
            scale 0.4
          
         ]
         [ 0.7
            wrinkles
            color_map {
               [ 0 color rgbt <0,0,0,1> ]
               [ 1 color rgbt <0,0,0,.7> ]
            }
            scale 0.4
          
         ]
         [ 1.0 color rgbt <0,0,0,1> ]
      }
      // scale 2.2
      translate <0,-2.0,0>
   }
   finish {
      ambient 0.1
      diffuse 0.4
      specular 0.05
      roughness 0.5
      crand 0.05
   }
}  

#declare BMetal01 =
   texture {
      pigment {
         wrinkles
         color_map {
            [ 0 color rgb <0.75,0.8,0.7>*1.1 ]
            [ 1 color rgb <0.75,0.8,0.7>*0.99 ]
         }
      }
      finish {
         ambient 0.1
         diffuse 0.6
         specular 0.8
         roughness 0.05
         reflection 0.1
      }
      normal {
         granite 0.015
         scale 0.1
      }
   }

#declare CMetal01  =
   texture {
      pigment {
         wrinkles
         color_map {
            [ 0 color rgb <0.9,0.8,0.3>*0.9 ]
            [ 1 color rgb <0.9,0.8,0.3>*0.85 ]
         }
      }
      finish {
         ambient 0.1
         diffuse 0.6
         specular 0.8
         roughness 0.05
         reflection 0.1
      }
      normal {
         granite 0.015
         scale 0.1
      }
   }

#declare OStaklo01  =
material {   
   texture {
      pigment { color rgbt <0.2,0.8,1,0.90> }
      finish {
         ambient 0.1
         diffuse 0
         specular 1
         roughness 0.005
         reflection 0.2
      }
   }
   interior {
      refraction 1
      ior 1.5
   }
}

/*
plane { z,0 texture { MStone01 } rotate y*15 }
plane { z,0 texture { BMetal01 } rotate y*13 rotate z*45 }
plane { z,0 texture { CMetal01 } rotate y*13 rotate 135*z }
plane { z,0 texture { TWood01 } rotate y*13 rotate -45*z }
plane { z,0 texture { TWood01 } rotate y*13 rotate -135*z }
plane { z,0 texture { MStone02 } rotate -15*x }
plane { z,0 texture { MStone03 } rotate 15*x }
plane { z,0 texture { Trava } rotate -15*y }

sphere { <0,0,-5>, 5 material { OStaklo01 } }
*/