#include "sky1.pov"
#include "4textures.inc"
#include "1ograda.pov"
#include "1stapovi.pov"
#include "1szgr.pov"
#include "1lzgr.pov"
#include "1bird.pov"
#include "1trava.pov"
#include "1cvjetici.pov"
#include "1lokva.pov"
#include "1herm2a.pov"
#include "planet1.pov"
#include "1kaciga.pov"
#include "1usta.pov"

global_settings {
  assumed_gamma 2.0
  max_trace_level 20
    radiosity {
        count 300                // Calculate reasonable accurate samples
        error_bound 0.3          // Main quality/time adjustment = sample spacing
        gray_threshold 0.5       // Try 0.33-0.50. Just a matter of taste
        distance_maximum 0       // Scene-dependent!  Leave 0 if unsure of proper value.
        low_error_factor 0.75
        nearest_count 7
        minimum_reuse 0.017      // reasonable number of samples in corners
        brightness 3.3           // doesn't really matter.  Not used in final output.
        recursion_limit 1        // can be 1 (usual) or 2 (for patient people)
    }
}

camera {  
  location  <     38.300,     -54.950,       6.600>
  direction <        0.0,         0.0,      1.8317> 
  sky       <    0.00000,     0.00000,     1.00000> 
  up        <        0.0,         0.0,         1.0> 
  right     <    1.33333,         0.0,         0.0> 
  look_at   <      3.500,       1.200,      11.450>
}
/*
light_source {   
  <-53.600, -105.100, 111.500>
  // <-26.600, -55.100, 37.500>
  color rgb <1.000, 1.000, 1.000>*0.95
}*/

light_source { // Arealight001
  <-53.600, -105.200, 111.500>
  color rgb <1.000, 1.000, 1.000>
  area_light <5.641, 4.734, 3.126>, <-5.142, 6.128, 0.000>, 15, 15
  adaptive 1
  jitter
}

light_source {   
  < 38.300, -54.950, 6.600>
  color rgb 0.30
}

// ********  REFERENCED OBJECTS  *******

#declare CSG002 = difference {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.3>
    translate  <11.3, -4.5, 0.0>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 0.7>
    translate  <12.3, -5.5, -0.35>
  }
}
#declare RUBIC = intersection {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.2, 0.3>
    translate  <11.1, -4.3, 0.0>
  }
  torus { // Torus001
    2.0, 0.3  rotate -x*90
    translate  <12.3, -5.5, 0.0>
  }
}
#declare RUBIC2 = intersection {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 0.7, 0.3>
    translate  <11.6, -4.8, 0.0>
  }
  torus { // Torus006
    1.0, 0.3  rotate -x*90
    translate  <12.3, -5.5, 0.0>
  }
  translate  <-3.0, -12.0, 0.0>
}
#declare RUBOVI = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 11.6>
    rotate 90.0*y
    translate  <12.3, -3.5, 0.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 6.0>
    rotate <90.0, 90.0, 0.0>
    translate  <25.9, 4.5, 0.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 30.0>
    rotate 90.0*y
    translate  <27.9, 6.5, 0.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 10.0>
    rotate <90.0, 90.0, 0.0>
    translate  <10.3, -5.5, 0.0>
  }
  torus { // Torus002
    2.0, 0.3  rotate -x*90
    translate  <23.9, -1.5, 0.0>
  }
  object { // RUBIC1->RUBIC
    RUBIC
    translate  <15.6, 10.0, 0.0>
  }
  object { RUBIC }
  torus { // Torus005
    1.0, 0.3  rotate -x*90
    translate  <9.3, -15.5, 0.0>
  }
  object { RUBIC2 }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 16.0>
    rotate <90.0, 90.0, 0.0>
    translate  <8.3, -17.5, 0.0>
  }
}
#declare CSG005 = difference {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.3>
    translate  <11.3, -4.5, 0.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 0.7>
    translate  <12.3, -5.5, -0.35>
  }
}
#declare RUBIC3 = intersection {
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.2, 0.3>
    translate  <11.1, -4.3, 0.0>
  }
  torus { // Torus004
    1.4, 0.3  rotate -x*90
    translate  <12.3, -5.5, 0.0>
  }
}
#declare RUBOVI2 = union {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 11.6>
    rotate 90.0*y
    translate  <12.3, -4.1, 0.0>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 6.0>
    rotate <90.0, 90.0, 0.0>
    translate  <26.5, 4.5, 0.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 30.0>
    rotate 90.0*y
    translate  <27.9, 5.9, 0.0>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 30.0>
    rotate <90.0, 90.0, 0.0>
    translate  <10.9, -5.5, 0.0>
  }
  torus { // Torus003
    2.6, 0.3  rotate -x*90
    translate  <23.9, -1.5, 0.0>
  }
  object { RUBIC3 }
  object { // RUBIC4->RUBIC3
    RUBIC3
    translate  <15.6, 10.0, 0.0>
  }
}
#declare CSG016 = difference {
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale 0.8
    translate  <9.6, -18.95, -0.55>
  }
  torus { // Torus007
    0.8, 0.2  rotate -x*90
    translate  <9.6, -18.95, -0.55>
  }
}
#declare ULRUPE = union {
  object { CSG016 }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.2>
    translate  <9.6, -18.95, -0.75>
  }
  torus { // Torus008
    0.4, 0.2  rotate -x*90
    translate  <9.6, -18.95, -0.55>
  }
  translate  <0.0, 1.1, 0.05>
}
#declare ULRUPE1 = object {
  object { // ULRUPE1->ULRUPE
    ULRUPE
    translate  -6.0*y
  }
}
#declare ULRUPALL = union {
  object { ULRUPE }
  object { ULRUPE1 }
  object { // ULRUPE2->ULRUPE1
    ULRUPE1
    translate  -6.0*y
  }
  translate  0.6*z
}
#declare CSG013 = object {
  object { // CSG013->CSG005
    CSG005
    scale -1.0
    rotate -180.0*x
  }
}
#declare CSG018 = union {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.3>
    rotate <-90.0, 0.0, -90.0>
    translate  <8.95, -17.85, -0.35>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.3>
    rotate -90.0*x
    translate  <9.6, -18.5, -0.35>
  }
  rotate -0.0*z
  translate  <-9.6, 17.85, 0.0>
  rotate -45.0*z
  translate  <9.6, -17.85, 0.0>
}
#declare CSG017 = union {
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.3>
    rotate <-90.0, 0.0, -90.0>
    translate  <8.95, -17.85, -0.35>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.3>
    rotate -90.0*x
    translate  <9.6, -18.5, -0.35>
  }
}
#declare CSG008 = difference {
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.6
    translate  <9.6, -17.85, -0.7>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.55
    translate  <9.6, -17.85, -0.7>
  }
  object { CSG018 }
  object { CSG017 }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    translate  <9.6, -17.85, -0.35>
  }
}
#declare CSG019 = union {
  object { CSG008 }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      SSGlass01
    }
    hollow
    scale 0.55
    translate  <9.6, -17.85, -0.7>
  }
  translate  -0.1*z
}
#declare CSG020 = object {
  object { // CSG020->CSG019
    CSG019
    translate  -6.0*y
  }
}
#declare MKUGLEULAZ = union {
  object { CSG019 }
  object { CSG020 }
  object { // CSG021->CSG020
    CSG020
    translate  -6.0*y
  }
  translate  1.0*z
}
#declare Cylndr034 = object {
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 0.2>
    translate  <9.6, -22.05, -0.05>
  }
}
#declare CSG024 = difference {
  object { Cylndr034 }
  torus { // Torus011
    0.6, 0.2  rotate -x*90
    translate  <9.6, -22.05, 0.15>
  }
}
#declare Cylndr029 = object {
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.6>
    rotate -90.0*x
    translate  <9.0, -22.1, 0.15>
  }
}
#declare CSG026 = difference {
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 1.2, 0.1>
    translate  <9.6, -20.85, 0.05>
  }
  object { Cylndr029 }
  object { // Cylndr030->Cylndr029
    Cylndr029
    rotate <0.0, -0.0, -0.0>
    translate  1.2*x
  }
}
#declare CSG023 = union {
  /*
  object { // Cylndr035->Cylndr034
    Cylndr034
    rotate <-0.0, 0.0, -0.0>
    translate  2.4*y
  }*/
  object { CSG024 }
  object { CSG026 }
  object { // CSG027->CSG024
    CSG024
    translate  2.4*y
  }
}
#declare Cylndr027 = object {
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.4>
    rotate -90.0*x
    translate  <9.3, -22.05, 0.3>
  }
}
#declare Cylndr025 = object {
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 0.2>
    translate  <9.6, -22.05, 0.2>
  }
}
#declare Torus009 = object {
  torus { // Torus009
    0.3, 0.1  rotate -x*90
    translate  <9.6, -22.05, 0.3>
  }
}
#declare Cylndr023 = object {
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.6>
    translate  <9.6, -22.05, -0.3>
  }
}
#declare CSG022 = union {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 1.2, 0.3>
    translate  <9.6, -20.85, 0.1>
  }
  object { // Cylndr028->Cylndr027
    Cylndr027
    rotate <0.0, 0.0, 0.0>
    translate  0.6*x
  }
  object { Cylndr027 }
  object { // Cylndr026->Cylndr025
    Cylndr025
    rotate <-0.0, 0.0, -0.0>
    translate  2.4*y
  }
  object { Cylndr025 }
  object { // Torus010->Torus009
    Torus009
    rotate <0.0, -0.0, -0.0>
    translate  2.4*y
  }
  object { Torus009 }
  object { // Cylndr024->Cylndr023
    Cylndr023
    translate  2.4*y
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 1.2, 0.3>
    translate  <9.6, -20.85, 0.0>
  }
  object { Cylndr023 }
}
#declare MSTUP = union {
  object { CSG023 }
  object { CSG022 }
  translate  -0.25*z
}
#declare MSTUP1 = object {
  object { // MSTUP1->MSTUP
    MSTUP
    translate  -6.0*y
  }
}
#declare MSTUPULAZALL = union {
  object { MSTUP }
  object { MSTUP1 }
  object { // MSTUP2->MSTUP1
    MSTUP1
    translate  -6.0*y
  }
  translate  0.6*z
}
#declare Sphere004 = object {
  sphere { // Sphere004
    <0,0,0>,1
    scale 0.1
    translate  <9.6, -22.05, 0.0>
  }
}
#declare ULMET = union {
  object { // Sphere005->Sphere004
    Sphere004
    translate  2.4*y
  }
  object { Sphere004 }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.4>
    rotate -90.0*x
    translate  <9.6, -22.05, 0.0>
  }
  material {
    SSGlass01
  }
  hollow
  translate  0.15*z
}
#declare ULMET1 = object {
  object { // ULMET1->ULMET
    ULMET
    translate  -6.0*y
  }
}
#declare ULMETALL = union {
  object { ULMET }
  object { ULMET1 }
  object { // ULMET2->ULMET1
    ULMET1
    translate  -6.0*y
  }
  translate  0.6*z
}




//
// ********  OBJECTS  *******
//

box { // MED01
  <-1, -1, -1>, <1, 1, 1>
  material {
    Voda
  }
  hollow
  scale <2700.299999, 2400.0, 3.6>
  translate  <36.35, -15.75, -5.35>
}

plane { // Plane001
  z,0
  scale <10.0, 10.0, 1.0>
  translate  <0.0, -0.1, -8.85>
  texture {
    Trava scale 0.3
  }
}

object {   // HgtFld001
  height_field {
    tga "1dno1.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <50.0, 30.6, 4.1>
  rotate -180.0*z
  translate  <-1.75, -16.95, -4.75>
  texture { Trava scale 0.3}
  texture {
   pigment {
      gradient z
      pigment_map {
         [ 0.0  color rgbt <0,0,0,1> ]
         [ 0.5  color rgbt <0.1,0.2,0.1,0.3> ]
         [ 1.0  color rgbt <0.1,0.2,0.1,0.7> ]
      }
      scale 2.0
      translate <0,0,-0.9>
      turbulence 0.2
      octaves 6
      lambda 4
      omega 0.5
   }
   finish {
      ambient 0.1
      diffuse 0.6
      specular 0.05
      roughness 0.5
      crand 0.05
   }
  }
}




#declare CSG001 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <65.800003, 10.7, 0.3>
    translate  17.2*y
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <25.9, 20.700001, 0.3>
    translate  17.2*y
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <10.3, 21.0, 0.3>
    translate  -16.5*y
  }
}
#declare CSG009 = difference {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <1.45, 1.45, 0.33>
    translate  <15.85, -4.05, 0.0>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 0.7>
    translate  <14.4, -2.6, -0.35>
  }
  translate  <9.5, 1.1, 0.0>
}
#declare CSG015 = difference {
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <1.45, 1.45, 0.33>
    translate  <15.85, -4.05, 0.0>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.7>
    translate  <14.4, -2.6, -0.35>
  }
  translate  <-5.1, -12.9, 0.0>
}
#declare CSG010 = difference {
  object { CSG001 }
  object { CSG009 }
  object { CSG015 }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    translate  <9.3, -17.5, -0.5>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <1.45, 8.0, 0.33>
    translate  <9.75, -25.55, 0.0>
  }
}
#declare PODALL = union {
  object { CSG002 }
  object { // CSG003->CSG002
    CSG002
    translate  <15.6, 10.0, 0.0>
  }
  object { RUBOVI }
  object { CSG010 }
  object { // RUBOVI1->RUBOVI
    RUBOVI
    scale <-1.0, 1.0, 1.0>
  }
  object { // CSG011->CSG002
    CSG002
    scale -1.0
    rotate -180.0*x
  }
  object { // CSG012->CSG002
    CSG002
    scale <-1.0, 1.0, 1.0>
    translate  <-15.6, 10.0, 0.0>
  }
}
#declare CSG004 = union {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <65.800003, 10.7, 0.3>
    translate  16.6*y
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <25.9, 20.700001, 0.3>
    translate  <0.6, 16.6, 0.0>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <10.6, 21.0, 0.3>
    translate  <0.3, -16.5, 0.0>
  }
}
#declare CSG007 = difference {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <1.45, 1.45, 0.33>
    translate  <15.85, -4.05, 0.0>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <2.6, 2.6, 0.7>
    translate  <14.4, -2.6, -0.35>
  }
  translate  <9.5, 1.1, 0.0>
}
#declare DONPOD = difference {
  object { CSG004 }
  object { CSG007 }
  object { ULRUPALL }
  object { // ULRUPALL1->ULRUPALL
    ULRUPALL
    scale <-1.0, 1.0, 1.0>
  }
}
#declare PODALL1 = union {
  object { CSG005 }
  object { RUBOVI2 }
  object { // CSG006->CSG005
    CSG005
    translate  <15.6, 10.0, 0.0>
  }
  object { DONPOD }
  object { CSG013 }
  object { // RUBOVI3->RUBOVI2
    RUBOVI2
    scale -1.0
    rotate -180.0*x
  }
  object { // CSG014->CSG013
    CSG013
    translate  <-15.6, 10.0, 0.0>
  }
  object { MKUGLEULAZ }
  object { // MKUGLEULAZ1->MKUGLEULAZ
    MKUGLEULAZ
    scale <-1.0, 1.0, 1.0>
  }
  object { MSTUPULAZALL }
  object { // MSTUPULAZALL1->MSTUPULAZALL
    MSTUPULAZALL
    scale <-1.0, 1.0, 1.0>
  }
  object { ULMETALL }
  object { // ULMETALL1->ULMETALL
    ULMETALL
    scale <-1.0, 1.0, 1.0>
  }
  translate  -0.3*z
}
union { // PODFINAL
  object { PODALL }
  object { PODALL1 }
  texture {
    MStone01aa 

  }
  translate  -0.3*z
}


