/*
#include "sky1.pov"
camera {  
  location  <     38.300,     -54.950,       6.600>
  direction <        0.0,         0.0,      1.8317> 
  sky       <    0.00000,     0.00000,     1.00000> 
  up        <        0.0,         0.0,         1.0> 
  right     <    1.33333,         0.0,         0.0> 
  look_at   <      3.500,       1.200,      11.450>
}

light_source {   
  <-53.600, -105.100, 111.500>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   
  < 38.300, -54.950, 6.600>
  color rgb 0.3
}
*/
/*
camera {
   location <0,0,-5>
   look_at  <0,0,0>
}

light_source {
   <0,10,-20>
   color rgb <1,1,1>
}
*/

// background { color rgb <1,0,0> }

#declare clouds1 =
pigment {
   wrinkles
   color_map {
      [ 0 color rgb <0.1,0.3,.6>*1.0 ] 
      [ 1 color rgb <0.7,0.8,.9>*1.0 ] 
   }
   scale <1,.2,1>*0.3
}
#declare clouds2 =
pigment {
   wrinkles
   color_map {
      [ 0 color rgb <0.1,0.3,.6>*0.7 ] 
      [ 1 color rgb <0.7,0.8,.9>*0.7 ] 
   }
   scale <1,.2,1>*0.3
}
#declare clouds1_transp =
pigment {
   wrinkles
   color_map {
      [ 0 color rgbt <0.1,0.3,.6,1>*1.0 ] 
      [ 1 color rgbt <0.7,0.8,.9,1>*1.0 ] 
   }
   scale <1,.2,1>*0.3
}
#declare clouds2_transp =
pigment {
   wrinkles
   color_map {
      [ 0 color rgbt <0.1,0.3,.6,1>*0.7 ] 
      [ 1 color rgbt <0.7,0.8,.9,1>*0.7 ] 
   }
   scale <1,.2,1>*0.3
}

#declare tex_planet =
pigment {
   gradient y
   pigment_map {
      [ 0.0 clouds1 ]
      [ 0.8 clouds2 ]
      [ 0.9 color rgb <0.7,0.8,1>*0.7 ]
      [ 1.0 color rgb <0.7,0.8,1>*0.7 ]
   }
   turbulence 0.3
   octaves 8
   lambda 3
   omega 0.6
   scale 2
   triangle_wave
}

#declare tex_planet_transp =
pigment {
   gradient y
   pigment_map {
      [ 0.0 clouds1_transp ]
      [ 0.8 clouds2_transp ]
      [ 0.9 color rgbt <0.7,0.8,1,1>*0.7 ]
      [ 1.0 color rgbt <0.7,0.8,1,1>*0.7 ]
   }
   turbulence 0.3
   octaves 8
   lambda 3
   omega 0.6
   scale 2
   triangle_wave
}

#declare radpig =
pigment {
   radial
   pigment_map {
      [ 0.00 color rgbt <0,0,0,1>  ]
      [ 0.85 /*color rgbt <0,0,0,.8>*/ tex_planet_transp   ]
      [ 0.90 /*color rgb <1,1,0>*/ tex_planet   ]
      [ 1.00 /*color rgb <1,1,0>*/ tex_planet    ]
   }
   translate <0,0,.1>
   triangle_wave
}

// #declare planet_object = union {

sphere {
   <0,0,0>,1
   texture {
      pigment { radpig }
      finish { ambient 1 }
   }
   rotate x*90
   rotate 30*z
   // rotate -30*y
   scale 200
   translate <-4322,4157,1711>
}

/*
sphere {
   <0,0,0>,1.2
   pigment {
      color rgbt <0,0,0,1>
   }
   finish {
      ambient 0
      diffuse 0
   }
   interior {
    media {
     emission <0,0.1,0.3>
     density {
       radial
       color_map {
        [ 0.00 color rgb 0 ]
        [ 0.65 color rgb 0 ]
        [ 0.70 color rgb 1 ]
        [ 1.00 color rgb 1 ]
       }
       triangle_wave
       rotate x*90
       rotate -0*z
       rotate -30*y
      }
     }
   }
   hollow
}
}
*/