/*
global_settings {
  assumed_gamma 2.0
  max_trace_level 10
}
camera {  //  Camera Camera01
  location  <     38.300,     -54.950,       6.600>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      3.500,       1.200,      11.450>
}

light_source {   // Light001
  <-53.600, -105.100, 111.500>
  color rgb <1.000, 1.000, 1.000>
}
light_source {   // Light001
  <     38.300,     -54.950,       6.600>
  color rgb 0.3
} */

sky_sphere
{
  pigment
  {
    gradient y
    // color_map { [0.0 color rgb <0.7,0.8,1.0>] [0.15 color rgb <0,0.05,0.25> ] [1.0 color rgb <0,0,0.1> ] }
    color_map { [0.0 color rgb <0.15,0.2,0.4>] [0.25 color rgb <0,0.05,0.45> ] [0.4 color rgb <0,0,0.2> ] [1.0 color rgb <0,0,0.3> ] }
    // color_map { [0.0 color rgb <1.0,0.8,0.4>] [0.35 color rgb <0.75,0.15,0> ] [0.6 color rgb <0.1,0,0> ] [1.0 color rgb <0.1,0,0> ] }
  }
  pigment { 
    wrinkles 
    turbulence .4 
    octaves 5 
    lambda 4  
    omega 0.3  
    color_map { 
      [0 color rgbt <1, 1, 1, 1>] 
      [0.5 color rgbt <0.98, 0.99, 0.99, .85>] 
      [1 color rgbt <1, 1, 1, 1>] 
    } 
    scale <.8, .1, .8> 
  }  
   rotate x*90
   translate <0,0,-100>
}
  

#declare cloudo01 =
texture { 
      pigment { 
         gradient z
         pigment_map { 
             [ 0.00
                dents
                color_map {
                   [ 0.0 color rgbt <1,1,1,1> ]
                   [ 0.4 color rgbt <1,1,1,1> ]
                   [ 0.7 color rgbt <1,1,1,.8> ]
                   [ 1.0 color rgbt <1,1,1,.7> ]
                }
                turbulence 0.3
                octaves 6
                lambda 5
                omega 0.5
                scale (1000/50)/900
             ] 
             [ 0.20 color rgbt <1,1,1,1> ] 
             [ 1.00 color rgbt <1,1,1,1> ] 
         }
         scale 50 
      } 
      finish { ambient 1 } 
}

/*
fog
{
  fog_type   2
  distance   50
  up         <0,0,1>
  color      rgb <0,0.2,0.4> 
  fog_offset 1.5
  fog_alt    2.0
  turbulence 0.4
} */

   
box {
   <1,0,1>, <-1,.5,-1> 
   scale <50000,20,50000>
   texture { cloudo01 scale 900 }
   interior {
      media {
         absorption rgb<.1,.1,.2>*0.05
         emission rgb <0.1,0.1,0.1>*0.2
         density{
            wrinkles
            color_map { 
               [ 0.0 color rgb <.3,.8,1>*0.6 ]
               [ 1.0 color rgb <.1,.3,.6> ]
            }
            scale 2000
         } 
      }
   }
   translate <0,900,0>
   hollow 
   rotate x*90
}   
 
 

