//------------------------------------------------------------------------
//
//  Richmond. P O V
//
//  Author:  Robert J Becraft
//  Created: Jan, 1999
//------------------------------------------------------------------------
#include "colors.inc"
#include "stones1.inc"
#include "glass.inc"
#include "woods.inc"
#include "textures.inc"
#include "metals.inc"
//*** Custom Textures ------------------------------------------

#include "richtext.inc"   // city specific textures

//---Uncomment to include these sections-------------------------------
#declare foggie="on"   // uncomment to turn on
//#declare Hills="off"  // uncomment to turn off   Hills
//#declare HillsNorth="off"
#declare HillsSouth="off"
//#declare HillsEast="off"
//#declare City="off"    // uncomment to turn off  City Buildings
//#declare CityBurbsN="off"  // uncomment to turn off Outskirts buildings North
//#declare CityBurbsS="off"  // uncomment to turn off Outskirts buildings South
//#declare Cath="off"    // uncomment to turn off Temples
//#declare Palace="off"   // uncomment to turn off Palace
//#declare Buildings="off"  // do not do buildings
//#declare Trees="off"  // do not do trees
//#declare Wagons="off" // do not do wagons
//#declare People="off" // do not do people

#include "cityric2.inc"   // other specific structures.

  #declare R1=seed(793)
  #include "..\med\maintree.inc"
  #include "..\med\mainpart.inc"          // doors/windows etc.
  #include "..\med\mainbldg.inc"        //residential type buildings (10x10 meter)
  #include "..\med\mainbld2.inc"        // warehouse buildings (20x20 meter)
  #include "..\med\mainbld3.inc"        // desert structures
  #include "..\med\marketde.inc"        // Marketplace objects
  #include "..\med\ships.inc"           // Ship objects
  #include "..\med\people.inc"          // people objects (before wagons!)
  #include "..\med\wagons.inc"          // Wagon objects
//************************* CAMERA ***********************************
camera {
//  right<800/600,0,0>    // make 1200x300 panorama
//  angle 45
//  panoramic

  location  <0,50,-500> look_at <-1,0,0>           // overview          (1)
//  location  <-230,25,-125> look_at<-1,0,50>          // SW Panorama save(2** IRTC)
//  location  <-230,50,-50> look_at<-1,0,-70>          // Test
//  location  <70,15,-90> look_at<-120,0,-80>          // Test
//  location  <150,25,-125> look_at<-50,0,0>          // SE Panorama TEST yuk
//  location  <-230,30,-140> look_at<-25,0,50>       // SW Panorama       (3)
//  location <-250,50,-20> look_at<-100,1.5,-55>         // Boat Closeup     ( )
//  location <-500,50,-50> look_at<-1,0,0>           // West Panorama     (4)
//  location  <-500,40,300> look_at<-200,0,200>      // royal dockyards   (5)
//  location  <-360,10,180> look_at<-285,0,225>      // palace            (6)
//  location  <-320,8,150> look_at<-310,6,170>         // lion            (7)
//  location <-270,28,90> look_at<-200,0,55>         // Isis Temple       (8)
//  location <100,20,395>   look_at<50,3,350>        // Isis Gate         (9)
//  location  <0,20,-50> look_at<50,0,-50>           // bridge            (A)
}

//light_source { <1000,1000,-700 >  color White } // full daylight
light_source { <-1000,200,-700 >  color Orange}     // morning sun

//------------------------------------------------------------------------

#ifdef (foggie)
//fog {                                            // Green ground fog
//  distance 2150
//  colour rgb<0.3, 0.5, 0.2>
//  fog_type 2
//  fog_offset 75
//  fog_alt 10
//  turbulence 0.1
//  turb_depth 0.2
//}

fog {                                                 // White ground fog
  distance 50
  colour Gray50    // rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 1
  fog_alt .5
  turbulence .5
  turb_depth .50
}

fog {                                                 // Gray ground fog
  distance 2000
  colour Violet    //Gray30    //rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 65
  fog_alt 7
  turbulence 20.0
  turb_depth 23.0
}

fog {                                                 // Gray ground fog
  distance 300
  colour Gray30    //rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 25
  fog_alt 4
  turbulence 20.0
  turb_depth 23.0
}

//fog {                                                 // White ground fog
//  distance 100
//  colour rgb<0.52, 0.62, 0.72>
//  fog_type 2
//  fog_offset 2
//  fog_alt 3
//  turbulence 11.0
//  turb_depth 15.0
//}

#end

/*******************************
 * THE SKY
 *******************************/
//#declare SkyBlue = rgb <0.15, 0.4, 0.7>
#declare SkyBlue = rgb <0.25, 0.5, 0.8>


#declare P_Clouds =
pigment {
  wrinkles
  turbulence 0.1
  lambda 2.2
  omega 0.707
  color_map {
    [0.60 SkyBlue ]
    [0.80 White ]
    [1.00 Gray90 ]
  }
  scale <0.5, 0.15, 1>
  rotate  z*180
  rotate  y*60
}
sky_sphere {
  pigment {
    gradient y
    pigment_map {
      [0.00 rgb <0.847, 0.749, 0.847> ] // horizon
      [0.05 SkyBlue ]                   // horizon
      [0.15 P_Clouds ]
      [1.00 SkyBlue ]
    }
  }
}


//--------- City Blocks
  #include "cityrich.inc"

#declare Royal_Gatea=difference{
     union{
        box{<-10,0,-20><10,12,20> texture{White_Stone}}
        box{<-9,12,-19><9,12.2,19> texture{StoneWalk}}
        box{<-6,12.2,-16><6,12.5,16> texture{White_Stone}}  // edge wall

        box{<-11,5,-21><11,5.5,21> texture{White_Stone}}   // reliefs
        box{<-11,11,-21><11,11.5,21> texture{White_Stone}}

        box{<-4,0,-22><4,14,22> texture{White_Stone}}
        box{<-12,0,-4><12,14,4> texture{White_Stone}}

        box{<-4,14,-21><4,14.2,-16> texture{StoneWalk}}
        box{<-11,14,-4><-6,14.2,4> texture{StoneWalk}}
        box{<-4,14,16><4,14.2,21> texture{StoneWalk}}
        box{<6,14,-4><11,14.2,4> texture{StoneWalk}}
     }
     box{<-5,0,-15><5,14.1,15> texture{White_Stone}}   // center courtyard
     box{<-2,.9,-22.1><2,5,22.1> texture{White_Stone}}  // entry
     box{<-8,6,-22.1><-7,8.5,22.1> texture{White_Stone}} // windows
     box{<-6,6,-22.1><-5,8.5,22.1> texture{White_Stone}}
     box{<8,6,-22.1><7,8.5,22.1> texture{White_Stone}}
     box{<6,6,-22.1><5,8.5,22.1> texture{White_Stone}}
}
#declare Royal_Gate=union{
    object{Royal_Gatea}
    box{<-11,.75,-23><11,1,23> texture{T_Stone23}} // stairs
    box{<-12,.5,-24><12,.75,24> texture{T_Stone23}}
    box{<-13,.25,-25><13,.5,25> texture{T_Stone23}}
    box{<-14,0,-26><14,.25,26> texture{T_Stone23}}
}
#declare Royal_Enda=difference{
     union{
        box{<-12.5,0,-30><12.5,8,30> texture{White_Stone}}
        box{<-13,5,-31><13,5.5,31> texture{White_Stone}}
        box{<-13,7.5,-31><13,8,31> texture{White_Stone}}
        box{<-12.5,8,-30><12.5,8.2,30> texture{StoneWalk}}
        box{<-13,0,-5><13,12,5> texture{White_Stone}}
        box{<-12.5,12,-4.5><12.5,12.2,4.5> texture{StoneWalk}}
     }
     box{<-5,0,-25><5,12.3,25> texture{White_Stone}}             // center core
     box{<-12.6,.9,-30.1><-8,4,30.1> texture{White_Stone}}    // front porch
     box{<8,.9,-30.1><12.6,4,30.1> texture{White_Stone}}      // rear porch
     box{<-13.1,0,-2><13.1,5,2> texture{White_Stone}}           // portal
}
#declare Royal_Column=union{
     cone{<0,0,0>1.3<0,16,0>1.  texture{T_Stone23}}
     cylinder{<0,0,0><0,.5,0>,1.4  texture{T_Stone24}}
     cylinder{<0,16,0><0,17,0>,1.1 texture{T_Stone24}}
     sphere{<0,18.3,0>,1.6 texture{T_Stone23}}
}
#declare Royal_End=union{
     object{Royal_Enda}
     object{Royal_Column}
     #declare Count=5
     #while (Count<=29)
          cylinder{<-11.5,1,Count><-11.5,4,Count>,.5 texture{T_Stone23}}
          cylinder{<11.5,1,Count><11.5,4,Count>,.5 texture{T_Stone23}}
          cylinder{<-11.5,1,-Count><-11.5,4,-Count>,.5 texture{T_Stone23}}
          cylinder{<11.5,1,-Count><11.5,4,-Count>,.5 texture{T_Stone23}}
           #declare Count=Count+3
     #end
     box{<-14,.75,-30><14,1,30> texture{T_Stone23}}   // steps
     box{<-15,.5,-31><15,.75,31> texture{T_Stone23}}
     box{<-16,.25,-32><16,.5,32> texture{T_Stone23}}
     box{<-17,0,-33><17,.25,33> texture{T_Stone23}}
}
#declare Royal_Hall=union{
     box{<-23,5,-10><23,7,10> texture{White_Stone}}
     box{<-23,5.25,-11><23,5.75,11> texture{White_Stone}}
     box{<-23,6.25,-11><23,6.75,11> texture{White_Stone}}
     box{<-22,7,-9><22,7.2,9> texture{StoneWalk}}
     #declare Count=-22.5
     #while (Count<=22.5)
          cylinder{<Count,1,-9><Count,5,-9>.5 texture{T_Stone23}}
          cylinder{<Count,1,9><Count,5,9>.5 texture{T_Stone23}}
          #declare Count=Count+3
     #end
    box{<-24,.75,-10><24,1,10> texture{T_Stone23}}     // steps
    box{<-25,.5,-11><25,.75,11> texture{T_Stone23}}
    box{<-26,.25,-12><26,.5,12> texture{T_Stone23}}
    box{<-27,0,-13><27,.25,13> texture{T_Stone23}}
}
#declare Royal_Anti_Side=union{
     box{<-13,5,-5><13,7,5> texture{White_Stone}}
     box{<-13,5.25,-6><13,5.75,6> texture{White_Stone}}
     box{<-13,6.25,-6><13,6.75,6> texture{White_Stone}}
     box{<-12,7,-4><12,7.2,4> texture{StoneWalk}}
     #declare Count=-12.5
     #while (Count<=12.5)
          cylinder{<Count,1,-4><Count,5,-4>.5 texture{T_Stone23}}
          cylinder{<Count,1,4><Count,5,4>.5 texture{T_Stone23}}
          #declare Count=Count+3
     #end
    box{<-14,.75,-5><14,1,5> texture{T_Stone23}}     // steps
    box{<-15,.5,-6><15,.75,6> texture{T_Stone23}}
    box{<-16,.25,-7><16,.5,7> texture{T_Stone23}}
    box{<-17,0,-8><17,.25,8> texture{T_Stone23}}
}

#declare Liona=difference{
      sphere{<0,0,0>.8 texture{T_Stone13}}
      sphere{<0,0,0>.3 texture{T_Stone23} translate<-.3,.3,-.5>}
      sphere{<0,0,0>.3 texture{T_Stone23} translate<.3,.3,-.5>}
}
#declare LionLeg=union{
      sphere{<0,0,0>.8 scale <.9,1.4,1> texture{T_Stone13}}
      cone{<0,0,0>.6 <0,-2,0> .3 texture{T_Stone13}}
      sphere{<0,-2,0>.35 texture{T_Stone13}}
      sphere{<0,-2,-.35>.2 rotate<0,42,0>  texture{T_Stone13}}  // toes
      sphere{<0,-2,-.35>.2 rotate<0,20,0>  texture{T_Stone13}}
      sphere{<0,-2,-.35>.2 rotate<0,-20,0> texture{T_Stone13}}
      sphere{<0,-2,-.35>.2 rotate<0,-42,0> texture{T_Stone13}}
}
#declare Lion=union{
      object{Liona}
      sphere{<0,0,0>,.15 texture{T_Stone13} translate<-.3,.3,-.5>}  // eye
      sphere{<0,0,0>,.15 texture{T_Stone13} translate<.3,.3,-.5>}  // eye
      cylinder{<0,0,0><0,0,.3>1.15 texture{T_Stone13}}    // mane
      cone{<0,-.1,-.9>,.3 <0,.6,0>.05 texture{T_Stone13}}   // nose

      cylinder{<0,-1,1><0,-1,3>.95 scale<1,1.4,1> texture{T_Stone13}}  // body
      object{LionLeg translate<.75,-1,1>}
      object{LionLeg translate<-.75,-1,1>}
      object{LionLeg translate<-.75,-1,3>}
      object{LionLeg translate<.75,-1,3>}
      box{<-1.1,-3.3,-.1><1.1,-3.15,4.1> texture{T_Stone23}}
      box{<-1,-5,0><1,-3.3,4> texture{T_Stone24}}
      box{<-1.1,-6,-.1><1.1,-5,4.1> texture{T_Stone23}}
}
#declare Royal1=union{
     object{Royal_End translate<-69,0,0>}
     object{Royal_End translate<69,0,0>}
     object{Royal_Hall translate<-35,0,-12.5>}
     object{Royal_Hall translate<35,0,-12.5>}
     object{Royal_Gate translate<0,0,-20>}
     object{Royal_Anti_Side translate<-45,0,25>}
     object{Royal_Anti_Side translate<45,0,25>}

     object{Royal_End rotate<0,90,0> translate<0,0,40>}
     object{Royal_Gate translate<0,0,67>}

     box{<-95,0,-70><90,.1,60> texture{checker texture{T_Stone23},texture{T_Stone24} rotate<0,45,0>}}

    #declare Count=0
    #while (Count<110)
       object{Lion rotate<0,90,0> translate<-90,6,-65+Count>}
       object{Lion rotate<0,0,0> translate<-40+Count,6,-65>}
       #declare Count=Count+10
    #end
}


#declare Isis_Templea=difference{
     union{
        box{<-25,0,-30><25,8,30> texture{White_Stone}}
        box{<-26,5,-31><26,5.5,31> texture{White_Stone}}
        box{<-26,7.5,-31><26,8,31> texture{White_Stone}}
        box{<-25,8,-30><25,8.2,30> texture{StoneWalk}}
        box{<-26,0,-5><26,12,5> texture{White_Stone}}
        box{<-25,12,-4.5><25,12.2,4.5> texture{StoneWalk}}
     }
     box{<-16,0,-21><16,12.3,21> texture{White_Stone}}             // center core
     box{<-25.1,.9,-30.1><-18,4,30.1> texture{White_Stone}}    // front porch
     box{<18,.9,-30.1><25.1,4,30.1> texture{White_Stone}}      // rear porch
     box{<-26.1,0,-2><26.1,5,2> texture{White_Stone}}           // portal
}

#declare Isis_Temple=union{
     object{Isis_Templea}
     #declare Count=5
     #while (Count<=29)
          cylinder{<-24.5,1,Count><-24.5,4,Count>,.5 texture{T_Stone23}}
          cylinder{<24.5,1,Count><24.5,4,Count>,.5 texture{T_Stone23}}
          cylinder{<-24.5,1,-Count><-24.5,4,-Count>,.5 texture{T_Stone23}}
          cylinder{<24.5,1,-Count><24.5,4,-Count>,.5 texture{T_Stone23}}
           #declare Count=Count+3
     #end
     box{<-27,.75,-30><27,1,30> texture{T_Stone23}}   // steps
     box{<-28,.5,-31><28,.75,31> texture{T_Stone23}}
     box{<-29,.25,-32><29,.5,32> texture{T_Stone23}}
     box{<-30,0,-33><30,.25,33> texture{T_Stone23}}

     box{<-35,0,-35><35,.1,45> texture{checker texture{T_Stone23},texture{T_Stone24} rotate<0,45,0>}}
     box{<35,0,-35><43,.1,120> texture{CityStreetColor}}

     box{<-55,0,-5><55,.1,5> texture{checker texture{T_Stone23},texture{T_Stone24} rotate<0,45,0>}}
     object{Obelisk translate<-44,0,0>}
     object{Obelisk translate<44,0,0>}
     object{Lion rotate<0,90,0> translate<-53,6,0>}
}


#declare Isis_Gate_Tower=union{
        box{<-3.5,0,-3.5><3.5,6,3.5> texture{White_Stone}}
        box{<-3,6,-3><3,10,3> texture{White_Stone}}
        box{<-2.5,10,-2.5><2.5,14,2.5> texture{White_Stone}}
        cylinder{<0,14,0><0,16,0>,.25 texture{Bright_Bronze}}
        sphere{<0,17,0>,1 texture{T_Old_Glass}}
}
#declare Isis_Gate=union{
        difference{
           box{<-5,0,-3><5,8,3> texture{White_Stone}}
           box{<-2,0,-3.1><2,5,3.1> texture{White_Stone}}           // portal
        }
        box{<-6,5,-4><6,5.5,4> texture{White_Stone}}
        box{<-6,7.5,-4><6,8,4> texture{White_Stone}}
        box{<-5,8,-3><5,8.2,3> texture{StoneWalk}}

        object{Isis_Gate_Tower translate<-7,0,0>}
        object{Isis_Gate_Tower translate<7,0,0>}

        box{<-12,0,-20><12,.1,55> texture{checker texture{T_Stone23},texture{T_Stone24} scale 2 rotate<0,45,0>}}

}


#declare PyramidA=union{
    triangle{<-35,0,-35><-35,0,35><0,60,0> texture{White_Stone_Old}}
    triangle{<-35,0,-35><35,0,-35><0,60,0> texture{White_Stone_Old}}
    triangle{<35,0,-35><35,0,35><0,60,0> texture{White_Stone_Old}}
    triangle{<-35,0,35><35,0,35><0,60,0> texture{White_Stone_Old}}
}
#declare PyramidB=union{
    triangle{<-25,0,-25><-25,0,25><0,40,0> texture{White_Stone_Old}}
    triangle{<-25,0,-25><25,0,-25><0,40,0> texture{White_Stone_Old}}
    triangle{<25,0,-25><25,0,25><0,40,0> texture{White_Stone_Old}}
    triangle{<-25,0,25><25,0,25><0,40,0> texture{White_Stone_Old}}
}
#declare PyramidC=union{
    triangle{<-15,0,-15><-15,0,15><0,25,0> texture{White_Stone_Old}}
    triangle{<-15,0,-15><15,0,-15><0,25,0> texture{White_Stone_Old}}
    triangle{<15,0,-15><15,0,15><0,25,0> texture{White_Stone_Old}}
    triangle{<-15,0,15><15,0,15><0,25,0> texture{White_Stone_Old}}
}
#declare PyramidD=union{
    triangle{<-20,0,-20><-20,0,20><0,35,0> texture{White_Stone_Old}}
    triangle{<-20,0,-20><20,0,-20><0,35,0> texture{White_Stone_Old}}
    triangle{<20,0,-20><20,0,20><0,35,0> texture{White_Stone_Old}}
    triangle{<-20,0,20><20,0,20><0,35,0> texture{White_Stone_Old}}
}
#declare PyramidE=union{
    triangle{<-40,0,-40><-40,0,40><0,70,0> texture{White_Stone_Old}}
    triangle{<-40,0,-40><40,0,-40><0,70,0> texture{White_Stone_Old}}
    triangle{<40,0,-40><40,0,40><0,70,0> texture{White_Stone_Old}}
    triangle{<-40,0,40><40,0,40><0,70,0> texture{White_Stone_Old}}
}
#declare Grain1=union{
    cylinder{<0,0,0><0,8,0>,4 texture{White_Stone}}
    cylinder{<0,0,0><0,2,0>,4.1 texture{White_Stone}}
    sphere{<0,8,0>,4 texture{pigment{color Tan}}}
    cylinder{<0,12,0><0,12.2,0>,1 texture{pigment{color Bronze}}}
    box{<-.75,0,-4.2><.75,2,4.2> texture{pigment{color White}}}
    cylinder{<0,2,-4.2><0,2,4.2>,.75 texture{pigment{color White}}}
    box{<-4.2,0,-.75><4.2,2,.75> texture{pigment{color White}}}
    cylinder{<-4.2,2,0><4.2,2,0>,.75 texture{pigment{color White}}}
}
#declare Grain=union{
    object{Grain1 translate<-5,0,-5>}
    object{Grain1 translate<5,0,-5>}
    object{Grain1 translate<-5,0,5>}
    object{Grain1 translate<5,0,5>}
}


#declare B2Draw_Bridge_Deck=union{
     box{<-3.5,-.17,-3><-3.2,.1,3> texture{T_Wood13}}
     box{<3.2,-.17,-3><3.5,.1,3> texture{T_Wood13}}

     box{<-1.5,-.15,-3><-1.3,.1,3> texture{T_Wood13}}
     box{<1.5,-.15,-3><1.3,.1,3> texture{T_Wood13}}
     box{<-.1,-.15,-4><.1,.1,4> rotate<0,52,0> texture{T_Wood13}}
     box{<-.1,-.15,-4><.1,.1,4> rotate<0,-52,0> texture{T_Wood13}}
     box{<-3.5,-.19,-2.5><4,.1,-2.8> texture{T_Wood13 rotate<0,90,0>}}
     box{<-3.5,-.19,2.5><4,.1,2.8> texture{T_Wood13 rotate<0,90,0>}}
     box{<-3.5,.3,-2.5><3.8,.4,-2.8> texture{T_Wood13 rotate<0,90,0>}}
     box{<-3.5,.3,2.5><3.8,.4,2.8> texture{T_Wood13 rotate<0,90,0>}}

     #declare Count=-3.5
     #while (Count<3.75)
       box{<Count,.1,-3><Count+.23,.3,3> texture{T_Wood13 rotate<0,0,0>}}
       #declare Count=Count+.25
     #end
//     cylinder{<-5,0,-2.650><11,0,-2.650>,.02 rotate<0,0,35> translate<.7,3,0> texture{pigment{color Tan}}}
//     cylinder{<-5,0,2.65><11,0,2.65>,.02 rotate<0,0,35> translate<.7,3,0> texture{pigment{color Tan}}}
}

#declare B2Draw_Bridge=union{
      cylinder{<-3.5,-4,0><-3.5,8,0>,1.2 texture{White_Stone}}
      cone{<-3.5,8,0>,1.3 <-3.5,11>,0 texture{RoofText}}
      cylinder{<3.5,-4,0><3.5,8,0>,1.2 texture{White_Stone}}
      cone{<3.5,8,0>,1.3 <3.5,11>,0 texture{RoofText}}
      box{<-3,6,-.5><3,6.5,.5> texture{T_Wood13}}
      box{<-3,1.5,-1><3,2,1> texture{StoneWalk}}
      object{B2Draw_Bridge_Deck rotate<0,0,15> rotate<0,90,0>  translate<0,2.8,-4.5>}
}

#declare B2Footing=union{
       box{<-2,-4,1><2,-2,-1> texture{White_Stone}}
       cylinder{<-2,-4,0><-2,-2,0> 1 texture{White_Stone}}
       cylinder{<2,-4,0><2,-2,0> 1 texture{White_Stone}}
}
#declare B2_Lamp=union{
       cylinder{<0,3.5,0><0,3.6,0> .20 texture{pigment{color Black}}}
       cylinder{<0,3.6,0><0,5.8,0> .05 texture{pigment{color Black}}}
       sphere{<0,6.15,0>,.35 texture{T_Old_Glass}}
       cylinder{<0,2.5,0><0,3.5,0> .25 texture{White_Stone_Old}}
       cone{<0,2.5,0>.25<0,1,0> 0 texture{White_Stone_Old}}
}
#declare B2=union{
       difference{
              box{<-2,-4,-6><2,2,6> texture{White_Stone}}
              cylinder{<-2.1,-5,0><2.1,-5,0> 5.9 texture{Brick_Text}}
        } // difference
       box{<-2,2,-6><2,2.01,6> texture{StoneWalk}}
       box{<-2.2,2,-6><-1.9,3,6> texture{White_Stone}}
       box{<1.9,2,-6><2.2,3,6> texture{White_Stone}}
       box{<-2,-4,-7><2,-2,-5> texture{White_Stone}}
       cylinder{<-2,-4,-6><-2,-2,-6> 1 texture{White_Stone}}
       cylinder{<2,-4,-6><2,-2,-6> 1 texture{White_Stone}}

      object{B2_Lamp translate<-2,0,5.5>}
      object{B2_Lamp translate<2,0,5.5>}
      object{B2Footing translate<0,0,-6>}
}

#declare B2Ramp=union{
      difference{
           box{<-2.3,-8,-8><2.3,4,8> texture{White_Stone}}
           box{<-2.31,-4,-16><2.31,4,16> rotate<10,0,0> translate<0,3.6,-5> texture{White_Stone}}
           box{<-2.1,-4,-16><2.1,4,16> rotate<10,0,0> translate<0,3.1,-5> texture{White_Stone}}
           box{<-1.9,-4,-16><1.9,4,16> rotate<10,0,0> translate<0,3,-5> texture{StoneWalk}}
       } // difference
      object{B2Footing translate<0,-3,-8>}
}

#declare B2_Bridge=union{
   object{B2Ramp translate<0,3.8,16>}
   object{B2Ramp translate<0,6.55,2>}
   object{B2 translate<0,4,-12>}
   object{B2 translate<0,4,-24>}
//   object{B2 translate<0,4,-36>}
//   object{B2 translate<0,4,-48>}
//   object{B2 translate<0,4,-60>}
   object{B2Draw_Bridge translate<0,4,-30>}
}
//-----------OBJECTS

// Additional Roads... (East/West)
  box{<-310,0,246><300,3.01,254> texture{CityStreetColor}}
  box{<-310,0,196><270,3.01,204> texture{CityStreetColor}}
  box{<-310,0,146><200,3.01,154> texture{CityStreetColor}}
  box{<-310,0,96><350,3.01,104> texture{CityStreetColor}}
  box{<-270,0,75><-200,3.01,73> texture{CityStreetColor}}  // isis temple dock

// Additional Roads... (North/South)
  box{<46,0,50><54,3.01,5000> texture{CityStreetColor}}
  box{<46,0,-200><54,3.01,-5000> texture{CityStreetColor}}

//The Bridge
object{B2_Bridge translate<50,0,-20>}
object{B2_Bridge rotate<0,180,0> translate<50,0,-97>}


// Pyramids
  object{PyramidA rotate<0,-15,0> translate<310,3,-175> }
  object{PyramidB rotate<0,15,0> translate<400,3,-200>}
  object{PyramidC rotate<0,15,0> translate<340,3,-240>}
  object{PyramidD rotate<0,-10,0> translate<410,3,100>}
  object{PyramidE rotate<0,0,0> translate<345,3,250>}

#ifndef(Palace)
// Palace Docks
  box{<-350,0,80><-305,3,275> texture{pigment{color Wheat}}}
  box{<-345,3,85><-310,3.01,270> texture{checker texture{T_Stone23}, texture{T_Stone24} scale 2 rotate<0,45,0>}}
  box{<-340,3.01,90><-315,3.02,265> texture{pigment{color Wheat}}}

  #declare Count=80
  #while (Count<250)
     box{<-380,0,Count><-350,2,Count+4> texture{White_Stone_Old}}
     box{<-380,1.9,Count-.2><-350,2,Count+4.2> texture{pigment{color Wheat}}}
     box{<-378,2.,Count+1><-357,2.01,Count+3> texture{pigment{checker Wheat,Tan rotate<0,45,0> scale 2}}}

     box{<-355,0,Count><-350,2.2,Count+4> texture{pigment{color Wheat}}}  // steps
     box{<-354,0,Count><-350,2.4,Count+4> texture{pigment{color Wheat}}}
     box{<-353,0,Count><-350,2.6,Count+4> texture{pigment{color Wheat}}}
     box{<-352,0,Count><-350,2.8,Count+4> texture{pigment{color Wheat}}}
     #declare Count=Count+15
  #end

    object{Ship1 translate<-365,3,195>}
    object{Ship2 rotate<0,180,0> translate<-364,3,165>}
    object{Ship3 rotate<0,180,0> translate<-367,3,150>}

// PALACE
  object{Royal1 translate<-215,3,225>}

#end // ifndef(Palace)

// Tower
#ifndef(Cath)
  object{Isis_Temple translate<-190,3,30> rotate<0,0,0>}
//  object{Holy_Tower translate<200,3,-230> rotate<0,0,0>}
#end

// RIVER Docks (Northside)
  box{<-55,0,-25><35,2.8,-15> texture{pigment{color Wheat}}}
  box{<-55.1,2.8,-25.1><35.1,3,-15> texture{White_Stone_Old}}
  #declare Count=-50
  #while (Count<35)
     box{<Count,0,-40><Count+4,2.8,-25> texture{pigment{color Wheat}}}
     box{<Count-.1,2.8,-40.1><Count+3.1,3,-25> texture{White_Stone_Old}}
     #declare Count=Count+15
  #end

 // object{Grain translate<-50,3,-5>}
  object{Grain translate<-40,3,-5>}
//  object{Grain translate<-30,3,-5>}
  object{Grain translate<-20,3,-5>}
//  object{Grain translate<-10,3,-5>}

//  object{Grain translate<10,3,-5>}
  object{Grain translate<20,3,-5>}
  object{Grain translate<30,3,-5>}

//  object{Grain translate<70,3,-5>}
  object{Grain translate<80,3,-5>}
  object{Grain translate<90,3,-5>}

  box{<-110,0,-30><-45,2.8,-20> texture{pigment{color Wheat}}}
  box{<-110.1,2.8,-30.1><-44.9,3,-20.1> texture{White_Stone_Old}}

// Inputs: I= X-dimension of block
//         J= Z-dimension of block
//         R5=initialized seed
//         OZ=lower left-hand corner Z-coordinate
//         OX=lower left-hand corner X-coordinate
//         OY=elevation of block
//         SP_Level=the large this value, the lighter the density of booths
//         Streets=1 to generate streets, =0 no streets
  #declare I=60
  #declare J=30
  #declare R5=seed(3839)
  #declare OY=3
  #declare OX=-118
  #declare OZ=-33
  #declare SP_Level=10
  #declare Streets=0
  #include "..\med\market1.inc"

#ifndef(Trees)
  // North Bank
  #declare Count=1
  #while (Count<30)
    #declare RX=rand(R1)*90
    #declare RZ=rand(R1)*5
    #declare ROY=rand(R1)*360
    #declare ROS=rand(R1)*1+.5
    object{Main_Palm rotate<0,ROY,0> scale ROS translate<-138-RX,0,-27+RZ>}
    #declare Count=Count+1
  #end

  // South Bank

  #declare Count=1
  #while (Count<35)
    #declare RX=rand(R1)*115
    #declare RZ=rand(R1)*4
    #declare ROY=rand(R1)*360
    #declare ROS=rand(R1)*1+.5
    object{Main_Palm rotate<0,ROY,0> scale ROS translate<-220+RX,-.5,-97+RZ>}
    #declare Count=Count+1
  #end
#end


  box{<60,0,-25><155,2.8,-15> texture{pigment{color Wheat}}}
  box{<59.9,2.8,-25.1><155.1,3,-14.9> texture{White_Stone_Old}}

  box{<145,0,-37><165,2.8,-20> texture{pigment{color Wheat}}}
  box{<144.9,2.8,-37.1><165.1,3,-14.9> texture{White_Stone_Old}}

// RIVER Docks (Southside)
  box{<-60,0,-84><10,2.8,-95> texture{pigment{color Wheat}}}
  box{<-60.1,2.8,-83.9><10.1,3,-98.1> texture{White_Stone_Old}}

  box{<60,0,-84><150,2.8,-93> texture{pigment{color Wheat}}}
  box{<59.9,2.8,-83.9><150.1,3,-93.1> texture{White_Stone_Old}}

  box{<-250,0,-103><-200,3,-98> texture{CityStreetColor}}

  object{Obelisk translate<50,3,350>}
  object{Obelisk translate<50,3,375>}
  object{Isis_Gate translate<50,3,325>}

#ifndef(City)
// Ships in river
  object{Ship3  rotate<0,180,0> translate<-20,2,-45>}
  object{Ship1  rotate<0,25,0> translate<-48,2,-47>}
  object{Ship2  rotate<0,-10,0> translate<-80,2,-35.8>}
  object{Ship1 translate<-115,2,-35.5>}
  object{Bark  rotate<0,25,0> translate<-128,2,-42>}
  object{Ship3 rotate<0,180,0> translate<-150,2,-45>}
  object{Ship1b rotate<0,180,0> translate<-170,2,-35>}
  object{Bark  rotate<0,175,0> translate<-200,2,-33>}
  object{BarkSail1  rotate<0,160,0> translate<-190,2,-55>}   //sailing out
     object{Bark_Cargo translate<-3,-.50,0> rotate<0,160,0> translate<-190,2,-55>}  //cargo
     object{Bark_Cargo translate<3.5,-.50,0> rotate<0,160,0> translate<-190,2,-55>}

// Ships on southside
  object{BarkMed  rotate<0,0,0> translate<-8,2,-80>}
  object{BarkMed  rotate<0,-170,0> translate<10,2,-82>}
  object{BarkMed  rotate<0,180,0> translate<-25,2,-80>}
  object{Ship1 translate<-53,2,-78>}
  object{Bark rotate<0,25,0> translate<-73,2,-81>}
  object{Bark rotate<0,20,0> translate<-85,2,-82>}
  object{BarkMed rotate<0,25,0> translate<-100,2,-82>}

  object{BarkMed  rotate<0,0,0> translate<68,2,-80>}
  object{Bark  rotate<0,-170,0> translate<80,2,-82>}
  object{BarkMed  rotate<0,180,0> translate<125,2,-80>}

#ifndef(Wagons)
  object{Wagon1Horse translate<-177,3,-100>}
  object{Wagon2Horse rotate<0,180,0> translate<-193,3,-102.5>}

  object{Wagon2 rotate<0,-90,0> translate<-133,3.25,-13>}
  object{Wagon2 rotate<0,-95,0> translate<-140,3.25,-15>}
  object{Wagon1 rotate<0,-90,0> translate<-135,3.25,-2>}

  object{Wagon1 translate<-40,3.25,-23>}
  object{Wagon2 translate<-30,3.25,-21>}
  object{Wagon1 translate<-25,3.25,-23>}
#end

  #declare Count=1
  #declare RBS=seed(3839)
  #declare RX=-150
  #while (Count<17)
     #declare RO=rand(RBS)*360
     #declare RSP=rand(RBS)*8
     #declare ROY=rand(RBS)*5
     #declare ROZ=rand(RBS)*3-3
     object{RowBoat1 rotate<0,RO,ROY> translate<RX,.9,-86.5+ROZ>}
     #declare RX=RX-RSP
     #declare Count=Count+1
  #end

//object{Minuret translate<5,13,-5>}
//object{Minuret translate<5,13,5>}

#end

// add people to scene
#ifndef(People)
// street southside
    #declare OX=-180 // lower left corner
    #declare OZ=-103.5 // lower left corner
    #declare OY=3    // height
    #declare I=220   // width
    #declare J=5     // length
    #declare RM=40   // # of people
    #include "../med/man.inc"  // do it!

// southside dock
    #declare OX=-60 // lower left corner
    #declare OZ=-95 // lower left corner
    #declare OY=3    // height
    #declare I=70   // width
    #declare J=11     // length
    #declare RM=17   // # of people
    #include "../med/man.inc"  // do it!

// add people to scene
//    #declare OX=-200 // lower left corner
//    #declare OZ=-103.5 // lower left corner
//    #declare OY=3    // height
//    #declare I=20   // width
//    #declare J=5     // length
//    #declare RM=8   // # of people
//    #include "../med/man.inc"  // do it!

#end

// Ground, water and mound levels
union {
  object {   //   Land mass  RIVER Mouth
                height_field { gif  "..\graphics\Rivermo.ghf" }
                 scale < 200, 2.99, 200 >   translate < -100, 0, -100>
                texture { Grass_Text }
                 rotate<0,-90,0> translate<-190,0,-25>
          }
  object {   //   Land mass  East part of river
                height_field { gif  "..\graphics\River1.ghf" }
                scale < 300, 3., 300 >   translate < -150, 0, -150>
                texture { Grass_Text }
                rotate<0,90,0> translate<300,0,-145>
          }
  object {   //   Land mass  East part of river
                height_field { gif  "..\graphics\River1.ghf" }
                texture { Grass_Text }
                 scale < 300, 3., 300 >   translate < -150, 0, -150>
                 rotate<0,90,0> translate<600,0,-145>
          }
  object {   //   Land mass  East part of river
                height_field { gif  "..\graphics\River1.ghf" }
                texture { Grass_Text }
                 scale < 300, 3., 300 >   translate < -150, 0, -150>
                 rotate<0,90,0> translate<900,0,-145>
          }
  object {   //   Land mass  East part of river
                height_field { gif  "..\graphics\River1.ghf" }
                texture { Grass_Text }
                 scale < 300, 3., 300 >   translate < -150, 0, -150>
                 rotate<0,90,0> translate<1200,0,-145>
          }
  object {   //   Land mass  East part of river
                height_field { gif  "..\graphics\River1.ghf" }
                texture { Grass_Text }
                 scale < 300, 3., 300 >   translate < -150, 0, -150>
                 rotate<0,90,0> translate<1500,0,-145>
          }
  object {   //   Land mass   Shore north of palace
                height_field { gif  "..\graphics\Shore1.ghf" }
                texture { Grass_Text }
                 scale < 400, 2.99, 400 >   translate < -200, 0, -200>
                 rotate<0,180,0> translate<-450,0,450>
          }
  object {   //   Land mass   2nd shore north of palace
                height_field { gif  "..\graphics\Shore3.ghf" }
                texture { Grass_Text }
                 scale < 400, 2.99, 400 >   translate < -200, 0, -200>
                 rotate<0,180,0> translate<-450,0,850>
          }
  object {   //   Land mass  Shore on southside
                height_field { gif  "..\graphics\Shore2.ghf" }
                 scale < 400, 2.99, 400 >   translate < -200, 0, -200>
                texture { Grass_Text }
                 rotate<0,180,0> translate<-390,0,-325>
          }

#ifndef(Hills)
  object {   //   HILLS
                height_field { gif  "..\graphics\mount2.ghf" }
                texture { Grass_Text }
                 scale < 600, 25., 600 >   translate < -300, 0, -300>
                 rotate<0,180,0> translate<-175,0,750>
          }
   object {   //   HILLS
                height_field { gif  "..\graphics\hills1.ghf" }
                texture { Grass_Text }
                 scale < 600, 25., 600 >   translate < -300, 0, -300>
                 rotate<0,0,0> translate<350,0,750>
          }
  object {   //   HILLS
                height_field { gif  "..\graphics\mount2.ghf" }
                texture { Grass_Text }
                 scale < 600, 30., 600 >   translate < -300, 0, -300>
                 rotate<0,60,0> translate<1500,0,300>
          }
  object {   //   HILLS
                height_field { gif  "..\graphics\mount2.ghf" }
                texture { Grass_Text }
                 scale < 600, 30., 600 >   translate < -300, 0, -160>
                 rotate<0,0,0> translate<1400,0,-500>
          }
  object {   //   HILLS
                height_field { gif  "..\graphics\mount2.ghf" }
                texture { Grass_Text }
                 scale < 1200, 45., 1200 >   translate < -600, 0, -600>
                 rotate<0,60,0> translate<2300,0,600>
          }
  object {   //   HILLS
                height_field { gif  "..\graphics\mount2.ghf" }
                texture { Grass_Text }
                 scale < 1200, 45., 1200 >   translate < -600, 0, -600>
                 rotate<0,0,0> translate<2200,0,-800>
          }

  object {   //   HILLS
                height_field { gif  "..\graphics\mount2.ghf" }
                texture { Grass_Text }
                 scale < 600, 25., 600 >   translate < -300, 0, -300>
                 rotate<0,60,0> translate<750,0,-800>
          }

#ifndef(HillsNorth)
// distant hills.......NORTH
      #declare RH=seed(8239)
      #declare Count=1
      #while (Count<16)
              #declare HR=rand(RH)*360      // rotation
              #declare HH=rand(RH)*40+30        // height
              #declare HX=rand(RH)*6000-3000     // X-coord
              #declare HZ=rand(RH)*3000+2000      // Y-coord North side

  object {   //   HILLS
                height_field { gif  "..\graphics\mount2.ghf" }
                texture { Grass_Text }
                 scale < 1200, HH, 1200 >   translate < -600, 0, -600>
                 rotate<0,HR,0> translate<HX,0,HZ>
          }

              #declare Count=Count+1
       #end
#end // ifndef(HillsNorth)

#ifndef(HillsEast)
// distant hills.......EAST
      #declare RH=seed(5494)
      #declare Count=1
      #while (Count<15)
              #declare HR=rand(RH)*360      // rotation
              #declare HH=rand(RH)*40+30        // height
              #declare HX=rand(RH)*3000+1400     // X-coord
              #declare HZ=rand(RH)*10000-5000      // Y-coord East side

  object {   //   HILLS
                height_field { gif  "..\graphics\mount2.ghf" }
                texture { Grass_Text }
                 scale < 1200, HH, 1200 >   translate < -600, 0, -600>
                 rotate<0,HR,0> translate<HX,0,HZ>
          }

              #declare Count=Count+1
       #end
#end // ifndef(HillsEast)

#ifndef(HillsSouth)
// distant hills.......SOUTH
      #declare RH=seed(9939)
      #declare Count=1
      #while (Count<25)
              #declare HR=rand(RH)*360      // rotation
              #declare HH=rand(RH)*90+10        // height
              #declare HX=rand(RH)*5000-2500     // X-coord
              #declare HZ=rand(RH)*3000-5000      // Y-coord South side

  object {   //   HILLS
                height_field { gif  "..\graphics\mount2.ghf" }
                texture { Grass_Text }
                 scale < 1200, HH, 1200 >   translate < -600, 0, -600>
                 rotate<0,HR,0> translate<HX,0,HZ>
          }

              #declare Count=Count+1
       #end
#end   // ifndef(HillsSouth)

#end // ifndef(Hills)


//**************************
  box{<-200,0,-20><2500,2.9,500> texture{Grass_Text}}  // northside land
  box{<-325,0,100><-200,2.9,500> texture{Grass_Text}}

// outer edges of land
  box{<-5000,0,500><5000,2.9,20000> texture{Grass_Text}}
  box{<2500,0,-20000><20000,2.9,20000> texture{Grass_Text}}
  box{<-5000,0,-20000><20000,2.9,-5000> texture{Grass_Text}}

  box{<-200,0,-96><150,2.9,-5000> texture{Grass_Text}}  // southside land
  box{<150,0,-130><2500,2.9,-5000> texture{Grass_Text}} // southside land
  box{<-100,0,-90><145,2.9,-96> texture{Grass_Text}}

//**************************
// Now for a watery plain
  plane {
               < 0,.08,0 >, 0
                texture {
                  pigment { color rgb< 0.0, 0.1, 0.2 > }
                  normal { bumps 0.2  scale < .5, 0.3, 0.3 > }
                  finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
                 }
               translate < 0, .20 , 0 >
  }
 }
