// Persistence of Vision Ray Tracer Scene Description File
// File: maintree.inc
// Vers: 1
// Desc: POVRay Main Street Tree Defines
// Date: August, 1998
// Auth: Robert J Becraft
// Contact: castlwrks@aol.com
//  Defines for Trees and Shrubberies for POV-main
//  This member is intended to provide defines for standard Trees throughout the POV City.

#declare Main_Evergreen =  // For connifers, pines and the like.
  texture {
  pigment { granite
  color_map {
    [0.3 color Clear]
    [0.4 color Green]
    [0.7 color MediumForestGreen]
    [0.9 color DarkGreen]
    [1.0 color Clear] } }
  finish {
    ambient   0.30
    diffuse   0.50
    brilliance   1.00
    phong   0.1
    phong_size  10.00
  }
  normal { bumps 0.2 }
  scale <.1,.1,.1> }

#declare Main_Decid1 =
  texture {
  pigment { granite
  color_map {
    [0.4 color Clear]
    [0.45 color Goldenrod]
    [0.5 color MediumForestGreen]
    [0.6 color DarkGreen]
    [1.0 color Green] } }
  finish {
    ambient   0.30
    diffuse   0.50
    brilliance   1.00
    phong   0.1
    phong_size  10.00
  }
  normal { bumps 0.2 }
  scale <.31,.1,.31> }

#declare Main_Oak_Leaf =
  texture {
  pigment { granite //crackle
  color_map {
    [0.3 color Clear]
    [0.4 color Green]
    [0.5 color MediumForestGreen]
    [1.0 color DarkGreen] } }
  finish {
    ambient   0.30
    diffuse   0.50
    brilliance   1.00
    phong   0.1
    phong_size  10.00
  }
  normal { bumps 0.2 }
  scale <.3,.1,.3> }

//Defines for the Tree-types, given names by shape
//  Most Trees Sizes: small=30', medium=45', large=60'
//  Shrubbery smaller

#declare Main_Hicory=union{
    cylinder{<0,6,0><0,9,0>,2 texture{Main_Decid1}}
    sphere{<0,6,0>,2 texture{Main_Decid1}}
    sphere{<0,9,0>,2 texture{Main_Decid1}}
    cone{<0,0,0>,.25 <0,6,0>,.18 texture{pigment{color Brown}}}
}

#declare Main_Maple=union{
//     merge{
//     sphere{<0,9,0>,3 texture{Main_Decid1}}
//     sphere{<0,7,0>,3.3 texture{Main_Decid1}}
//     }
//     merge{
//     sphere{<0,9,0>,2 texture{Main_Decid1}}
//     sphere{<0,7,0>,2.3 texture{Main_Decid1}}
//     }
      #declare Count=1
      #while (Count<15)
           #declare BL=rand(R1)*2+2
           #declare BH=rand(R1)*3+2.5
           #declare BRY=rand(R1)*360
           #declare BRX=rand(R1)*30+20
           cone{<0,0,0>.08<0,BL,0>.04 rotate<-BRX,BRY,0> translate<0,BH,0> texture{pigment{color Brown}}}
           #declare Count=Count+1
      #end
     cone{<0,0,0>,.25 <0,7,0>,.15 texture{pigment{color Brown}}}
     cone{<0,0,0>,.35 <0,2,0>,.14 texture{pigment{color Brown}}}
}

#declare Main_Elm=union{
    cone{<0,4,0>,.7 <0,9,0>,3 texture{Main_Decid1}}
    sphere{<0,9,0>,2.8 texture{Main_Decid1}}
    cone{<0,0,0>,.25 <0,4,0>,.15 texture{pigment{color Brown}}}
    cone{<0,0,0>,.35 <0,2,0>,.16 texture{pigment{color Brown}}}
}

#declare Main_Pine=union{
      cone{<0,6,0>,2 <0,12,0>,.15 texture{Main_Evergreen}}
      cone{<0,0,0>,.15 <0,6,0>,.10 texture{pigment{color Brown}}}
     cone{<0,0,0>,.25 <0,2,0>,.09 texture{pigment{color Brown}}}
}

#declare Main_Fir=cone{<0,.1,0>,3 <0,9,0>,.15 texture{Main_Evergreen}}

#declare Main_Shrub=union{
     cone{<0,0,0>.012<0,1.2,0>,.052 texture{pigment {color Brown}}}
     sphere{<0,1.1,0>,1.0 texture{Main_Evergreen}}
     cone{<0,1.1,0>,1.0<0,4,0>,.2 texture{Main_Evergreen}}
}
#declare Main_Shrub2=union{
     cone{<0,0,0>.012<0,1.2,0>,.052 texture{pigment {color Brown}}}
     sphere{<0,1.1,0>,0.5 texture{Main_Evergreen}}
     cone{<0,1.1,0>,0.5<0,4,0>,.2 texture{Main_Evergreen}}
}

#declare Main_Oak=union{
      object{Main_Maple}

      #declare Count=1
      #while (Count<55)
           #declare BL=rand(R1)*1+rand(R1)*.5+rand(R1)*.5
           #declare BX=rand(R1)*3
           #declare BZ=rand(R1)*3
           #declare BY=rand(R1)*8.5+5
           #declare BRY=rand(R1)*360
           #declare BRX=rand(R1)*30+40
           #declare BSc=rand(R1)*.5+.5
           sphere{<0,0,0>BL scale<1,BSc,1> rotate<-BRX,0,0> translate<BX,BY,BZ> rotate<0,BRY,0> texture{Main_Oak_Leaf}}
           #declare Count=Count+1
      #end


//-------- PALM TREE
#declare Main_Palm_Trunk_Chunk=union{
    cylinder{<0,-.4,0><0,.4,0>,.2 texture{pigment{color Gray10}}}
    #declare Count=0
    #while (Count<=360)
       #declare ROY=rand(R1)*.1+.1
       #declare ROX=rand(R1)*.3+.1
       #declare OY1=rand(R1)*.1-.05
       #declare OY2=rand(R1)*.1-.05       
       triangle{<.18,OY1,-.1><.15,OY2,.1><ROX,ROY,0> rotate<0,Count,0> texture{pigment{color Gray50}}}
       #declare Count=Count+(rand(R1)*15+15)
    #end
}
#declare Main_Palm_Trunk=union{
    #declare Count=8
 //   #declare RC=0
    #while (Count>0)
       #declare ROY=rand(R1)*360
       object{Main_Palm_Trunk_Chunk scale 1.3-Count/8 rotate<0,ROY,0> translate<0,Count,0>}
 //      #declare RC=Count/10+.5
       #declare Count=Count-.3
    #end
}
#declare Main_Palm_Leaf=union{
    cone{<0,-.2,0>.015<0,1.5,0>,.008 texture{pigment{color Khaki}}}  // stem
    #declare Count=0
    #while (Count<1.5)
       triangle{<-.3+(Count/10),Count+.3,0><0,Count,0><0,Count+.1,0> texture{pigment{color ForestGreen}}}
       triangle{<.3-(Count/10),Count+.3,0><0,Count,0><0,Count+.1,0> texture{pigment{color ForestGreen}}}
       #declare Count=Count+.15
    #end
//    triangle{<-.3,1.5,0><.3,1.5,0><0,1.7,0> texture{pigment{color GreenYellow}}}
}
#declare Main_Palm=union{
    object{Main_Palm_Trunk}
    #declare Count=0
//    #declare RR=seed(3838)
    #while (Count<25)
       #declare ROY=rand(R1)*360
       #declare ROX=rand(R1)*120+25
       #declare ROZ=rand(R1)*180
       #declare ROS=rand(R1)*.6+.4
       object{Main_Palm_Leaf scale<ROS,ROS,ROS> rotate<ROX,0,ROZ> rotate<0,ROY,0> translate<0,8,0>}
       #declare Count=Count+1
    #end
}

#declare Main_Palm_Grove=union{
    #declare Count=0
    #while (Count<5)
       #declare ROY=rand(R1)*360
       #declare ROX=rand(R1)*20+25
       #declare RX=rand(R1)*4-2
       #declare RZ=rand(R1)*4-2
//       #declare RY=rand(R1)*2
//       #declare ROZ=rand(R1)*10
       #declare ROS=rand(R1)*.4+.6
       object{Main_Palm
//            translate<0,RY,0>  // adjust tree to 0,0,0
            scale<ROS,ROS,ROS>
 //           rotate<0,0,ROZ>
            translate<RX,0,RZ> // adjust positioning
            }
       #declare Count=Count+1
    #end
}


//      sphere{<0,10,0>,3.8 texture{Main_Oak_Leaf}}
//      sphere{<2,7,2>,2 texture{Main_Oak_Leaf}}
//      sphere{<-2,7,0>,2.5 texture{Main_Oak_Leaf}}
//      sphere{<2,10,-2>,2 texture{Main_Oak_Leaf}}
//      sphere{<-2,8,-2>,2.5 texture{Main_Oak_Leaf}}
//      sphere{<0,13,0>,2 texture{Main_Oak_Leaf}}
}

#declare Main_Oak_Medium=object{Main_Oak scale<1.5,1.5,1.5>}
#declare Main_Oak_Large=object{Main_Oak scale<2.2,2.2,2.2>}

#declare Main_Elm_Medium=object{Main_Elm scale<1.5,1.5,1.5>}
#declare Main_Elm_Large=object{Main_Elm scale<2.2,2.2,2.2>}

#declare Main_Maple_Medium=object{Main_Maple scale<1.4,1.4,1.4>}
#declare Main_Maple_Large=object{Main_Maple scale<2.,2.,2.>}

#declare Main_Hicory_Medium=object{Main_Hicory scale<1.5,1.5,1.5>}
#declare Main_Hicory_Large=object{Main_Hicory scale<2.2,2.2,2.2>}

#declare Main_Fir_Medium=object{Main_Fir scale<1.5,1.5,1.5>}
#declare Main_Fir_Large=object{Main_Fir scale<2.2,2.2,2.2>}

#declare Main_Pine_Medium=object{Main_Pine scale<1.5,1.5,1.5>}
#declare Main_Pine_Large=object{Main_Pine scale<2.2,2.2,2.2>}

#declare Main_Shrub_Medium=object{Main_Shrub scale<1.5,1.5,1.5>}
#declare Main_Shrub_Large=object{Main_Shrub scale<2.2,2.2,2.2>}

#declare Main_Shrub2_Medium=object{Main_Shrub2 scale<1.5,1.5,1.5>}
#declare Main_Shrub2_Large=object{Main_Shrub2 scale<2.2,2.2,2.2>}
