#include "colors.inc"	
#include "textures.inc"	 

light_source { 0*x 
               color rgb 1.0  
               area_light
               <8, 0, 0> <0, 0, 8> 
               4, 4                
               adaptive 1          
               jitter             
               translate <400, 100, 100>  
             }
             
light_source { 0*x 
                 color red 0.3  green 0.3  blue 0.3 
                 fade_distance 45
                 fade_power 1
                 translate <30, 40, -15>
             }

light_source { <10, 10, 0> 
               color Red
               spotlight
               radius 05
               falloff 10
               tightness 100
               point_at < 1, 0, 0>
             } 

light_source { 0*x 
                 color red 0.6  green 0.2  blue 0.2 
                 fade_distance 4
                 fade_power 1
                 translate <2.2, 0.2, 1.2>
             }             

camera { location  <-1.0 , 1.3 ,-1.6> look_at   <0.0 , 1.6 , 0.0> } 

sky_sphere {
  pigment { mandel 120
    color_map { [0.08 color Black] 
                [0.30 color Silver] 
                [0.90 color Silver .8] 
                [1.00 color Gray10]
              } 
            scale .9
          }
           rotate <-100,17,0>
           }
                      
#declare Planet= sphere { <0, 1, 0> 165 
                          pigment  { 
                          image_map { gif "lunar.gif"  map_type 0 interpolate 4  } 
                          scale  220 }
                          finish { ambient 0 diffuse 1 }
                          normal { granite scale 35 }
                        }
      
object { Planet  translate < 550.0, 400.0, 540.0> }

difference{
height_field { gif "eye.gif"     
               smooth        
               rotate -2*x
               rotate -3*y
               scale < 100, 1.8, 100 >
               translate < -7, -1,-25> 
               pigment  { image_map { gif "fantasy.gif"  map_type 1 interpolate 4  } 
                          scale 2 
                        }
             }

cylinder { 0*y, -5*y, 1.4  pigment {White} translate <2.2,0,1.8>}
          }
          
difference{
height_field { tga "montagne.tga"     
               smooth        
               rotate -2*x
               rotate 30*y
               scale < 50, 5, 30 >
               translate < -15, -0.15, 0> 
               pigment  {  image_map { gif "dune.gif" map_type 5  interpolate 4  } 
                           scale 2 
                        }
             }

cylinder { 0*y, -5*y, 1.4  pigment {White} translate <2.2,0,1.8>} 
          }   

fog { color Pink
      fog_type 2
      fog_alt 1.3
      fog_offset 1
      distance 38
      turbulence <.8, 1.8, 1.0>
      omega 0.40
      lambda 1.65
      octaves 6
    }

#declare Road= difference{
cylinder { -.1*y, .02*y, 116  } 

cylinder { -.11*y, .11*y, 114.5  } 
box { < 0, -.2, -2.1> <2.1, .2, 2.1>  }
}  
 
#declare FreightRoad= union{
#declare MagnoOrb=
sphere { 0*y, .05  translate -115.275*z texture {Chrome_Texture} pigment {NeonBlue} }  

#declare Count=0;
 #while (Count < 180)
  object{MagnoOrb rotate 1*y*Count}
  #declare Count=Count+1;
 #end 

 object { Road  pigment {image_map { tga "asphalt2.tga"  map_type 0 interpolate 4  } scale .2 rotate <0,90,90>}  }
} 

object { FreightRoad rotate 1*x translate < 115, 0.3, 12.0 > normal {granite scale .2} } 

box { <0, 0, 0> <1.4, .1, .6> pigment {White} rotate -8*z translate <0.63, .2, 5.75> } 

difference{
cylinder { 0*y, -5*y, 1.4  pigment {White} translate <2.2,0,1.8>}
cylinder { .1*y, -5.1*y, 1.25  pigment {White} translate <2.2,0,1.8>}
          }   
          
#declare Slab=box { < -.3, -.5, -.35> <0, .6, .35> rotate -10*z translate -.4*x } 
#declare Control=union{
#declare Count=0;
#while (Count<8)
 object {Slab rotate 45*y*Count }
#declare Count=Count+1;
#end 
  }  
#declare Tower=union{difference{
cylinder {<0, -.45, 0> <0, .55, 0> .5 }
object {Control}
}
torus { .31, .025 rotate 1*z translate .56*y}
}

object {Tower scale <.7, 1.4, .7> translate < 4.85, .3, 1.5> pigment {White} normal { granite } } 
object {Tower rotate 180*z scale <.65, .4, .65> translate < 4.85, 1.32, 1.5> pigment {Green filter .7}}
cylinder { <0,0,0><0,.1,0>.4 translate < 4.85, 1.4, 1.5> pigment {White} normal { granite } } 
cylinder { <0,0,0><0,.65,0>.01 translate < 4.815, 1.49, 1.525> pigment {White}}


     #declare Path= difference {
         torus { 5, 1 }

         box {<-10, 0,-12>< 10, 1.1, 10> }
         box {<-2,-2,-10 >< 10, 2.0, 0> }
         box {<-6,-1,-1><0,2,-6>  rotate -30*y}   }

    #declare Path1= difference {
         torus { 5, .75 }

         box {<-10,0,-12><10,0.7,10> }
         box {<-2,-2,-10><10,2.0, 0> }
         box {<-6,-1,-1><0,2,-6>  rotate -30*y}
             }

    #declare Path3= difference{
        object {Path }

        object {Path1 rotate 1*y translate <-.02,-.15, 0>}
        cylinder {<3.5,-1, 1><6.5,-1, 1> .75 }
               }

    #declare Endpath= difference{
        torus { 0.92, .09 }

        box{ <-2,-1,0><2,1,-2> }
      rotate 90*x
      translate 5*x
           }

    #declare Footwalk= difference {
        torus { 5, 1 }

        box {<-10,-.1,-10><10,-1.1,12> }
        box {<-10,0,-10><10,1.1,12> }
        box {<-2,-2,-10><10,2,0> }
        box {<-6,-1,-1><0,2,-6>  rotate -30*y}
        translate .05*y
            }

    #declare Pathway= union{
                      merge{
        object {Path3}
        object {Endpath translate <0,-.01,.05>}
        cylinder {<4.1,-.08,0.04><5.9,-.08,0.04> .08 }
        pigment {White}
             }
        object {Footwalk  pigment {image_map { tga "peak.tga"
                              map_type 0 interpolate 4 }
                              scale 0.3 rotate 90*x }
                              }
                             }


        object {Pathway
           scale 0.25 rotate 72*y translate <2.175, 0.05, 1.778>
           } 

#declare Window= difference{
            sphere { 0*y, 1  }

            box { <-1, 0.5,-1.1>< 1, 1.1, 1.1>  }   
            box { <-1, 0.0,-1.1>< 1,-1.1, 1.1>  }
            box { <-.6, 0.5,-1.1><-1.1, 1.1, 1.1>  }   
            box { <0.6, 0.0,-1.1>< 1.1,-2.0, 1.1>  }  
                          }

#declare Pillbox= difference{
            sphere { 0*y, 1 pigment {image_map { gif "chains.gif"} scale .7} }

            box { <-0.6, 0.5,-1.1>< 0.6, 0.0, 1.1> pigment {Gray50} } 
            box { <-1, -.2,-1.1>< 1,-1.1, 1.1> pigment {Gray50} }
            box { <-1, 0.85,-1.1>< 1, 1.1, 1.1> pigment {Gray50} }  
                          }                           

#declare Building= union{                        
    object { Window scale < 1, 1.21, 1> 
             pigment {Blue} 
             finish {reflection .4 
                     irid { .35 thickness .4 turbulence .5 }  
                    }
            }
    object { Pillbox rotate -2*x scale <1.1, 1.3, 1.05> translate 0.05*z} 
    box { <-.04, -.28, -.8><.04, .3725, -1.04> pigment {image_map { gif "chains.gif"} scale .75}  rotate 13.5*x}
                    }  

object { Building scale < 1.75, 1, 1> rotate <0, 78, 5> translate <9.6, 1, 8.2>}                               

#declare Top= union{ 
              difference{
                          sphere { 0*y, 1 } 
                          
                          box {<-1.1,.75,-1.1><1.1,1.1,1.1> } 
                          box {<-1.1,-.75,-1.1><1.1,-1.1,1.1> }
                        }
          
              difference{ 
                          cylinder{0.6*y, 1.3*y, .875 }
                          
                          torus {.8, .5 scale <1,2,1>translate 1.58*y} 
                          scale <1,2,1>
                          translate -.49*y
                        }
             difference{
                          cylinder { -7*y, -.4*y .9 pigment {White} normal {granite} }
                          
                          cylinder { -1*z, 1*z .25 pigment {White} scale <1.33, 1, 1> translate -1*y}
                          cylinder { -1*x, 1*x .25 pigment {White} scale <1 , 1, 1.33> translate -1*y}
                       }
              cylinder { -.65*y, -.45*y 1 pigment {White} }
              cylinder { -1.5*y, -1.3*y 1 pigment {White} }
                cone { 2.02*y, .335, 3.9*y, .05 }
                sphere { 3.0*y .3 
                         pigment {BrightGold} 
                         finish  { specular.2 roughness .1 metallic .1  reflection .1 reflection_exponent .5 }
                       }
                   }    
  
  object {Top pigment { Copper } 
              finish  { specular.2 roughness .1 metallic .1  reflection .1 reflection_exponent .3 } 
              rotate 3.5*z translate <3,6,45> 
         } 
  object {Top pigment { Copper } 
              finish  { specular.2 roughness .1 metallic .1  reflection .1 reflection_exponent .7 }  
              rotate 3.5*z translate <7,6,43> 
         }
  object {Top pigment { Copper } 
              finish  { specular.2 roughness .1 metallic .1  reflection .1 reflection_exponent .3 } 
              rotate 3.5*z translate <0,6,55> 
         } 
  object {Top pigment { Copper } 
              finish  { specular.2 roughness .1 metallic .1  reflection .1 reflection_exponent .7 }  
              rotate 3.5*z translate <15,6.5,52> 
         }
                
         
difference{
  cylinder {<0,0.1,0><0,2,0>2 pigment {White} normal {granite scale 2} } 
  
  cylinder {<0,0,0><0,2.1,0>1.75 pigment {Gray} } 
  cylinder {<0,2.5,-2.5><0,2.5,2.5> 1 pigment {Gray} scale <3,1,1> } 
  box {<-.2,-.1,-1.5><.2,.9,-2.5> pigment {Gray} }
  cylinder {<0,.9,0><0,.9,-2.5> .2 pigment {Gray} }
  scale <5,2.25,2>
  rotate 28*y
  translate <7,0,47>  
   }
           
#declare Front=difference{
                 cylinder {< 0, -1, 0> < 0, 1, 0> 1.99 } 
   
                      box {<-2.1,-1.1,0><-1,1.1,2.1> }
                      box {< 2.1,-1.1,0>< 1,1.1,2.1> } 
                         }  

#declare ClipA=difference{
                   cylinder {< 0, -.8, 0> < 0, .8, 0> 2 } 
   
                   cylinder {< 0, -1.1, 0> < 0, 1.1, 0> 1.7 }
                         }
                         
#declare PartA=difference{ 
      object{Front}                   
      object {ClipA translate -.2*z}    
             }
   
    
   
#declare Steps=union{ 
 box { <-0.50, 0.00, -2.5>  < 0.50, 1.50,  1> }
 box { <-0.45, 1.50, -2.0>  < 0.45, 2.50,  1> }
 box { <-0.40, 2.50, -1.5>  < 0.40, 3.50,  1> }
 box { <-0.35, 3.50, -1.0>  < 0.35, 4.50,  1> }
 box { <-0.30, 4.50, -0.5>  < 0.30, 5.50,  1> }
 box { <-0.25, 5.50,  0.0>  < 0.25, 6.50,  1> } 
                   }

#declare Side=union{ 
 object { Steps translate -1.75*x}
 object { Steps scale <9,1,1> translate < 0, 0, 0.5>} 
 object { Steps translate 1.75*x}   
  }

#declare Layer=union{  
  object {Side }
  object {Side rotate 90*y translate <-2.75, 0, 2.75>}
  object {Side rotate -90*y translate <2.75, 0, 2.75>}
  object {Side rotate 180*y translate <0, 0, 5.5>}
  superellipsoid { 0.7 pigment {Clear}
  interior{
         media {
      emission 0.4
      intervals 10
      samples 1, 10
      confidence 0.9999
      variance 1/1000
      density {
        spherical
        ramp_wave
        turbulence 2
        color_map { [0.0 color rgb <0, 0, 0>]
                    [0.1 color rgb <50, 0, 0>]
                    [1.0 color rgb <50, 50, 0>]
                  } } }} 
                                 hollow on
                                 scale <1.8,50,1.8> 
                                 translate <0,10,3>
                                 }
    }

#declare Hub= object {Layer scale .1 } 
 
#declare Ship=union{
           sphere { -1*y, 1 }
           object {PartA scale <1.5,.6,1>}
           object {Hub scale <1.9,.4, 1.2> translate <-1.4, .6, -1.0>}
           object {Hub scale <1.9,.4, 1.2> translate < 1.4, .6, -1.0>}
           pigment { marble turbulence 1.8
                      color_map { [0.0 color Yellow] 
                                  [0.1 color Gold] 
                                  [0.2 color Silver] 
                                  [0.5 color White]
                                }
                       scale .5
                    }
            normal { wrinkles scale .5 } 
            } 

 object {Ship scale <.15,.15,.3> rotate < -20, -100, 170> translate <2.6,0.75,1.3> } 
 
 
#declare Steps2= union{
                difference{ 
                union{ 
 box { <-0.50, 0.00, -2.5>  < 0.50, 1.50,  1> }
 box { <-0.45, 1.50, -2.0>  < 0.45, 2.50,  1> }
 box { <-0.40, 2.50, -1.5>  < 0.40, 3.50,  1> }
 box { <-0.35, 3.50, -1.0>  < 0.35, 4.50,  1> }
 box { <-0.30, 4.50, -0.5>  < 0.30, 5.50,  1> }
 box { <-0.25, 5.50,  0.0>  < 0.25, 6.50,  1> }
                     }
 box { <-0.11, 5.75, -0.1>  < 0.11, 6.25,  1>  pigment {Clear}  } 
                         }
  box { <-0.111, 5.74, -0.11>  < 0.111, 6.26,  1.01> 
   pigment {Clear}
  interior{
         media {
      emission 0.8
      intervals 10
      samples 1, 10
      confidence 0.9999
      variance 1/1000
      density {
        spherical
        ramp_wave
        turbulence 1.6
        color_map { [0.01 color rgb <0, 0, 0>]
                    [0.11 color rgb <2, 8, 0>]
                    [0.16 color rgb <6, 4, 0>]
                  } }scale <0.5, 4.8, 0.5> translate <-0.1, 0.15, 0>} } 
                                 hollow on 
                    }} 
                   

#declare Side2=union{ 
 object { Steps2 translate -1.75*x}
 object { Steps2 scale <9,1,1> translate < 0, 0, 0.5>} 
 object { Steps2 translate 1.75*x}   
  }  

#declare Ziggurat=union{  
  object {Side2 }
  object {Side rotate 90*y translate <-2.75, 0, 2.75>}
  object {Side rotate -90*y translate <2.75, 0, 2.75>}
  object {Side rotate 180*y translate <0, 0, 5.5>}
     }
     
 object {Ziggurat 
    pigment { marble turbulence 1.2
                      color_map { [.05 color Gold 1.1] 
                                  [0.1 color Yellow] 
                                  [0.4 color Wheat] 
                                  [0.6 color Silver]
                                }
                       scale .5
                    }
                     finish { ambient .1 diffuse .8 }
                     rotate 3*z
                     rotate 4*y
                     scale <1,3,1> 
                     translate <6.5,-4,50> 
                     } 
             
#declare Shape= union{ 
                     cylinder { -.5*z, 3.5*z  1 }
                     sphere { -.5*z, 1 }
                     sphere { 3.5*z, 1 }
                     }    
  
#declare Clip= difference{ 
                box { <-1.1,-1.1,-0.4><1.1,1.1,3.4> }
                
             object {Shape scale <.99,.99,1.5> translate -1*z}
                         } 
                       
#declare Tankersign=                       
difference{
       text {  ttf  "crystal.ttf", "POVCODE",  1,  0  rotate 90*y translate <-1, -0.3, 3.2>}  
 
       object { Clip }
       pigment {Maroon}  
          }
#declare Tank=                       
difference{
       object {Shape}  
 
       object { Clip }
       pigment {White}  
          }

#declare Tanker=union{ 
 object {Tank finish  {ambient .3 specular.25 roughness .15 reflection .05 reflection_exponent .6 } }
 object {Tankersign translate -.001*x finish  {ambient .3 } } 
  scale < 1.1, 0.7, 1.0>
  }
  
   

#declare Tyre=union{
cylinder {<-.1,0,0><.1,0,0> .2 pigment {Gray10} }
cylinder {<-.3,0,0><.35,0,0> .12 pigment {Gray70} }
sphere {-.1*x, .2 pigment {Gray10} }
sphere {0.1*x, .2 pigment {Gray10} }
      scale <.2,1,1>
                   }
     

#declare Base=union{   
    box {< 0.02, 0.68,-0.10> < 0.30, 0.70, 1.20> }
    box {<-0.05, 0.75, 0.60> < 0.10, 0.77, 1.10> }
    box {<-0.05, 0.75, 0.10> < 0.10, 0.77,-0.10> }
    box {<-0.05, 0.75, 0.12> < 0.10, 0.77,-0.12> rotate 10*x  translate < 0,-0.009, 0.05>}
    box {<-0.05, 0.75, 0.12> < 0.10, 0.77,-0.12> rotate -10*x translate < 0,-0.009, 00.6>}
     pigment {Gray90} finish {Metal}
     }
 
#declare Tractor= 
difference{
  union{
 superellipsoid { .35 scale .3 translate <0.3, .9, 1.6> pigment {Wheat} finish {ambient .2}}
 superellipsoid { .25 scale <.31,.14,.2> rotate 5*x translate <0.3, .78, 1.88> pigment {Wheat} finish {ambient .2}}
 cylinder { 0.12*x,  0.5*x,  .01 pigment {Wheat} finish { ambient .3} translate < 0.0, 1.12, 1.314>}
 cylinder { 0.12*x,  0.5*x,  .01 pigment {Wheat} finish { ambient .3} translate < 0.0, 1.10, 1.312>}
 cylinder { 0.12*x,  0.5*x,  .01 pigment {Wheat} finish { ambient .3} translate < 0.0, 1.08, 1.311>}
 cylinder { 0.12*x,  0.5*x,  .01 pigment {Wheat} finish { ambient .3} translate < 0.0, 1.06, 1.310>}
 cylinder { 0.12*x,  0.5*x,  .01 pigment {Black} translate < 0.0, 1.11, 1.312>}
 cylinder { 0.12*x,  0.5*x,  .01 pigment {Black} translate < 0.0, 1.09, 1.311>}
 cylinder { 0.12*x,  0.5*x,  .01 pigment {Black} translate < 0.0, 1.07, 1.310>}
 cylinder { 0.12*x,  0.5*x,  .01 pigment {Black} translate < 0.0, 1.05, 1.310>}
 cylinder { <0.45, 0.8, 1.275><0.45,1.35,1.275> 0.025 texture {Polished_Chrome} }
  cylinder {<  0.01, 0.7, 1.44> <  0.01, 1.08, 1.44> 0.01 texture {Polished_Chrome}}
 cylinder {<  0.005, 0.7, 1.70> <  0.005, 1.08, 1.70> 0.01 texture {Polished_Chrome}} 
 cylinder {<  0.005, 0.7, 1.45> <  0.01, 0.7, 1.69> 0.01 texture {Polished_Chrome}}
 difference{
  superellipsoid { .1 scale <.32,.12,.2> translate <0.3, .75, 1.9> }
  box { <.3,.1,.1><-.3,-.1,-.3> translate <0.3, .7, 1.88> }
  box { <.5,.4,.1><-.5, 0,-.4> translate <0.3, .7, 1.88> }
  texture {Polished_Chrome} 
     }
 }
 
 superellipsoid { .2 scale <.4,.1,.1> translate <0.3, 1, 1.575> pigment {Wheat}}
 superellipsoid { .2 scale <.3,.1,.2> translate <0.3, 1, 1.95> pigment {Wheat}}
 superellipsoid { .2 scale <.24,.1,.3> translate <0.3, 1, 1.75> pigment {Wheat}}
 } 

#declare FuelTruck=union{
 object {Tanker scale .3 translate < 0.4, 0.85, 0.1> }              
 object { Tyre scale .6 translate .635*y}
 object { Tyre scale .6 translate < 0, 0.635, 0.7>}
 object { Tyre scale .6 translate < 0, 0.635, 1.0>}
 object { Tyre scale .6 translate < 0.05, 0.635, 1.6>}
 object { Tyre scale .6 translate < 0.3, 0.635, 0.0>}
 object { Tyre scale .6 translate < 0.3, 0.635, 0.7>}
 object { Tyre scale .6 translate < 0.3, 0.635, 1.0>}    
 object {Base}
 object {Tractor}
 superellipsoid { .15 scale <.32,.11,.1> translate <0.3, 1, 1.55> 
                   pigment {White filter .9} interior { ior 1.33} finish { reflection .05 reflection_exponent 0.1} }
 superellipsoid { .15 scale <.3,.11,.1> translate <0.3, 1, 1.8> 
                   pigment {White filter .9} interior { ior 1.33} finish { reflection .05 reflection_exponent 0.1} }
                        }
  
 object {FuelTruck translate -.1*x}
 
 #declare MirrorArm= cylinder { <0.04,1.1,0><0.1,1.1,0> .005 pigment {Black} }

#declare RearView=union{
object {MirrorArm translate <-.32,0,1.35>}
object {MirrorArm rotate -40*y translate <-.3,0,1.33>} 
object {MirrorArm translate <-.32,-.1,1.35>}
object {MirrorArm rotate -40*y translate <-.3,-.1,1.33>}
cylinder {<-.28,1.105,1.34><-.28,.995,1.34> .004 pigment {Blue} }
box {<-0.265, 1.00, 1.320><-0.310, 1.10, 1.34> pigment {Black}}
box {<-0.267, 1.01, 1.315><-0.308, 1.09, 1.33> pigment {White} finish {Mirror}} 
 }
 
 object {RearView scale 1.01 translate <.15,0,.4>} 

#declare Horn= difference {
          sphere { <0, 0, 0>  1.0 }
       
          torus { 1.25, 0.7 scale <1,1.2,1>translate -.2*y}
          box { <-1, 0, -1> < 1,  1,  1> }
                          }
#declare AirHorn= union{
                  object {Horn scale <0.6, 2.0, 0.6> }
                   torus { .31, 0.12 scale <1,1.2,1>translate -1.45*y}
                  sphere { <0, 0.1, 0>  0.36 } 
                 pigment {White}
                  finish {ambient .25 reflection 0.05 reflection_exponent 0.1}
                  rotate <-90, 10, 0>
                   scale <.08,.08,.13>
                       }
     
 object {AirHorn translate <0.10, 1.22, 1.7>} 
 object {AirHorn translate <0.20, 1.22, 1.7>}