#include "colors.inc"

#declare Light_Switch	= on;
#declare Camera_Switch	= on;
#declare Radios_Switch	= on;
#declare Skull_Switch	= on;  
#declare Jaw_Switch		= on;
#declare Test_Switch	= off;

camera {
	location <-2,1,-2>
	look_at  <2,1,0>  
	#if (Camera_Switch = on)
		aperture .1
		blur_samples 500
		focal_point <0,0,0> 
		variance .01
	#end
}


light_source {
	<10,10,-10> 
	color <1.5,1.5,1.5> 
	#if (Light_Switch = on)
		area_light
		<5,0,0>,<0,0,5>,5,5
		jitter
	#end
}

#if (Radios_Switch = on)
	#include "consts.inc"
		#declare Rad_Quality = Radiosity_Final;
	#include "rad_def.inc"
#end

#declare Normal1 = normal{granite .05 scale .4}
#declare Normal2 = normal{dents .2 scale .05}

#declare Skull_Tex1 =
texture{
	pigment{rgb <1,.975,.825>} 
	finish{phong .25 phong_size 10}  
	normal{ 
		average
		normal_map {
			[1 Normal1]
			[2 Normal2]
		}
	}
}

#declare Skull_Tex2 =
texture{
	pigment{rgb <.9,.8,.6>} 
	finish{phong .25 phong_size 10}  
	normal{ 
		average
		normal_map {
			[1 Normal1 scale .8]
			[2 Normal2 scale .8]
		}
	}
}

#declare Skull_Tex =
texture {
	bozo
	texture_map {
		[0.0 Skull_Tex1 scale 2]
		[1.0 Skull_Tex2 scale 2]
	} 
	scale .35
	turbulence .4
}

#declare Skull_Tex1a =
texture{
	pigment{rgb <1,.975,.825>} 
	finish{phong .25 phong_size 10 diffuse .4}  
	normal{ 
		average
		normal_map {
			[1 Normal1]
			[2 Normal2]
		}
	}
}

#declare Skull_Tex2a =
texture{
	pigment{rgb <.9,.8,.6>} 
	finish{phong .25 phong_size 10 diffuse .4}  
	normal{ 
		average
		normal_map {
			[1 Normal1 scale .8]
			[2 Normal2 scale .8]
		}
	}
}

#declare Skull_Texa =
texture {
	bozo
	texture_map {
		[0.0 Skull_Tex1 scale 2]
		[1.0 Skull_Tex2 scale 2]
	} 
	scale .35
	turbulence .4
}

#declare Skull_Rand = seed(31);

#macro Rand_Rotate ()   

	#local Rand_Factor = 5;

	#local S1 = rand(Skull_Rand);
	#if (S1 < .5) #local S1 = 1; #else #local S1 = -1; #end
	#local S2 = rand(Skull_Rand);
	#if (S2 < .5) #local S2 = 1; #else #local S2 = -1; #end
	#local S3 = rand(Skull_Rand);
	#if (S3 < .5) #local S3 = 1; #else #local S3 = -1; #end 
	
	rotate <(rand(Skull_Rand) * Rand_Factor * S1),(rand(Skull_Rand) * Rand_Factor * 2 * S2),(rand(Skull_Rand) * Rand_Factor * S3)>
	
#end

#if (Skull_Switch = on)

#include "upper.inc"
#declare Alpha = object {Skull translate <0,-19,0> scale .3 rotate <0,180,0>}

object {Alpha Rand_Rotate () translate<-2,0,0> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<0,0,0> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<2,0,0> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<4,0,0> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<6,0,0> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<8,0,0> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<10,0,0> texture{Skull_Tex}} 
object {Alpha Rand_Rotate () translate<12,0,0> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<14,0,0> texture{Skull_Tex}}

object {Alpha Rand_Rotate () translate<-.9,1.6,1> texture{Skull_Texa}}
object {Alpha Rand_Rotate () translate<1,1.75,1> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<3,1.75,1> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<5,1.75,1> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<7,1.75,1> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<9,1.75,1> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<11,1.75,1> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<13,1.75,1> texture{Skull_Tex}}  

object {Alpha Rand_Rotate () translate<0,3.5,2> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<2,3.5,2> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<4,3.5,2> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<6,3.5,2> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<8,3.5,2> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<10,3.5,2> texture{Skull_Tex}}
object {Alpha Rand_Rotate () translate<12,3.5,2> texture{Skull_Tex}} 

#end

#if (Jaw_Switch = on)

#declare Teeth_T1 =
texture{
	pigment{White}
	finish{phong .8 phong_size 10}
	
} 

#declare Teeth_T2 =
texture {
	pigment {
		bozo 
		color_map {
			[0.0 rgb <.7,.7,.4>]
			[1.0 rgb <.5,.4,.1>]
		} 
		scale <.1,.2,.1>
		turbulence .5
	}
	finish{phong .2 phong_size 10}
}  

#declare Teeth_T3 =
texture {
	gradient y
	texture_map {
		[0.0 Teeth_T2]
		[0.2 Teeth_T2]
		[0.5 Teeth_T1]
		[1.0 Teeth_T1]
	}
	turbulence .4
}

#include "lower.inc"      

object {Jaw scale .3 rotate <0,0,-2.5> rotate <0,-110,0> translate <3,-.325,-2> texture{Skull_Tex}} 
object {Lower_Teeth scale .3 rotate <0,-110,0> translate <3,-.35,-2> texture{Teeth_T3 scale .1 translate <0,-.55,0>}}

#end

// steel bench 
#include "tex.inc"

#if (Test_Switch = on)

	box {<-2,-.35,-2.25><15,-2,2> texture{Metal_Tex1}} // box for test purposes

#else

	#include "mesh.inc"

	MESH (.02,4.25,17,<-2,-.35,-2.15>,Metal_Tex1)

#end

#declare Steel_Angle =
union {

	box {<6,0,0><47,-6,100>}
	box {<44,-3,0><50,-44,100>} 
	cylinder {<47,-3,0><47,-3,100>,3}  
	
	intersection {
		box {<0,0,0><10,-6,100>}
		cylinder {<6,0,-5><6,0,105>,6}
	}
	intersection {
		box {<44,-50,0><50,-44,100>}
		cylinder {<50,-44,-5><50,-44,105>,6}
	}

}


object {Steel_Angle scale <.01,.01,.5> rotate <0,90,0> translate <0,-.3,-1.8> texture{Metal_Tex1}}

// paint artefacts

#include "paint.inc"          

object {Bubble scale <.1,.04,.1> translate <2,-.3,-2.15> texture{Metal_Tex1}}

object {Bubble scale <.15,.04,.15> translate <1.8,-.3,-2.15> texture{Metal_Tex1}}
object {Bubble scale <.07,.04,.07> translate <1.7,-.3,-2.2> texture{Metal_Tex1}}
object {Bubble scale <.08,.04,.08> translate <1.6,-.3,-1.85> texture{Metal_Tex1}}
object {Bubble scale <.07,.04,.07> translate <1.4,-.3,-1.85> texture{Metal_Tex1}}

object {Bubble scale <.1,.04,.1> translate <1.5,-.3,-2.2> texture{Metal_Tex1}} 
object {Bubble scale <.1,.04,.1> translate <1.2,-.3,-2.2> texture{Metal_Tex1}}
object {Bubble scale <.12,.04,.12> translate <1.1,-.3,-2.2> texture{Metal_Tex1}}

object {Lifter rotate <0,85,0> scale <.5,.1,.5> translate <1.5,-.3,-2.1> texture{Metal_Tex1A}}
object {Lifter rotate <0,90,0> scale <.5,.1,.5> translate <1.7,-.3,-2.1> texture{Metal_Tex1A}}
object {Lifter rotate <0,90,0> scale <.4,.1,.4> translate <1.3,-.3,-2.15> texture{Metal_Tex1A}}
object {Lifter rotate <0,100,0> scale <.3,.1,.3> translate <1.1,-.3,-2.11> texture{Metal_Tex1A}}  
object {Lifter rotate <0,-120,0> scale <.5,.1,.5> translate <1.7,-.3,-1.85> texture{Metal_Tex1A}} 
object {Lifter rotate <0,-80,0> scale <.4,.1,.4> translate <1.5,-.3,-1.9> texture{Metal_Tex1A}} 
object {Lifter rotate <0,-90,0> scale <.5,.1,.5> translate <1.3,-.3,-1.85> texture{Metal_Tex1A}}
object {Lifter rotate <0,-90,0> scale <.4,.1,.4> translate <1.1,-.3,-1.85> texture{Metal_Tex1A}}





#if (Light_Switch = on)

#declare Wall_Tex1 =
texture{
	pigment{rgb <.6,.5,.3>} 
	finish{phong .25 phong_size 10}  
	normal{ 
		average
		normal_map {
			[1 Normal1 scale .8]
			[2 Normal2 scale .8]
		}
	}
}

#declare Wall_Tex2 =
texture {
	crackle
	texture_map {
		[0.0 Skull_Tex1 scale .1]
		[1.0 Skull_Tex2 scale .1]
	} 
	turbulence <.4,.7,.4>
	scale 10
}

#declare Wall_Tex3 =
texture {
	crackle
	texture_map {
		[0.0 Wall_Tex2 scale .05]
		[1.0 Skull_Tex2 scale .05]
	} 
	turbulence <.7,1,.7>
	scale 20
}  

#declare Wall_Tex4 =
texture {
	bozo 
	texture_map {
		[0.0 Wall_Tex2 scale 2] 
		[0.5 Wall_Tex2 scale 2]  
		[0.7 Wall_Tex3 scale <1,2,1>]
		[1.0 Wall_Tex3 scale <1,2,1>]
	} 
	scale .5
	turbulence .5
}

box {<15,-10,-20><16,20,20>
	texture{Wall_Tex4}
} 


cylinder {<14.5,-20,-4><14.5,20,-4>,.2 pigment{White}}  
//cylinder {<13.5,-20,-4><13.5,20,-4>,.2 pigment{White}}
cylinder {<12.5,-20,-4><12.5,20,-4>,.2 pigment{White}} 
//cylinder {<11.5,-20,-4><11.5,20,-4>,.2 pigment{White}} 

cylinder {<15,0,-4><11.5,0,-4>,.1 pigment{White}} 
cylinder {<15,2,-4><11.5,2,-4>,.1 pigment{White}}
cylinder {<15,4,-4><11.5,4,-4>,.1 pigment{White}}
cylinder {<15,6,-4><11.5,6,-4>,.1 pigment{White}}
cylinder {<15,8,-4><11.5,8,-4>,.1 pigment{White}} 
cylinder {<15,10,-4><11.5,10,-4>,.1 pigment{White}}

cylinder {<15,-2,-4><11.5,-2,-4>,.1 pigment{White}}
cylinder {<15,-4,-4><11.5,-4,-4>,.1 pigment{White}}
cylinder {<15,-6,-4><11.5,-6,-4>,.1 pigment{White}}
cylinder {<15,-8,-4><11.5,-8,-4>,.1 pigment{White}}

#end

#include "logo.inc"

object {Logo13 scale .1 rotate <0,30,0>  translate <-.85,0.25,-.2> texture{Skull_Tex1}}

// eof