// mesh include file


#macro WIRE_STRAND (QTY,DIRECTION,STEPS,ORIGIN,OFFSET)
    
    #if (OFFSET = 0)
		#local Flag1 = 0;
	#else
		#local Flag1 = 1;
	#end
	#local Count1 = 0;
	
	#while (Count1 < (QTY + 2))
		
		#if (DIRECTION = 1)
			#if (Flag1 = 0)
				object {XTD translate (<(Count1 * STEPS),0,0> + ORIGIN)}
			#else
				object {XTU translate (<(Count1 * STEPS),0,0> + ORIGIN)}
			#end
		#else
			#if (Flag1 = 0)
				object {ZTD translate (<0,0,(Count1 * STEPS)> + ORIGIN)}
			#else
				object {ZTU translate (<0,0,(Count1 * STEPS)> + ORIGIN)}
			#end
		#end
		
		#local Count1 = (Count1 + 1);
		#if (Flag1 = 0)
			#local Flag1 = 1;
		#else
			#local Flag1 = 0;
		#end
	#end
	
#end

#macro MESH (RADIUS,LENGTH,WIDTH,ORIGIN,TEXTURE)

	#local Wire_Rad		= RADIUS;
	#local Torus_Rad	= (RADIUS * 5.583);
	#local Wire_Trans	= (RADIUS * 6.704);
	#local Torus_Trans	= (RADIUS * 4.464);
	#local Diff_Trans	= (RADIUS * 3.352);
	
	#local Torus_Segment =
	difference {
		torus {Torus_Rad,Wire_Rad sturm rotate <90,0,0> translate <0,Torus_Trans,0>}
		box {<0,10,10><-10,-10,-10> rotate <0,0,-36.9> translate <-Diff_Trans,0,0>}
		box {<0,10,10><10,-10,-10> rotate <0,0,36.9> translate <Diff_Trans,0,0>}
	}
	
	#declare XTD = object {Torus_Segment}
	#declare XTU = object {Torus_Segment scale <1,-1,1>}
	#declare ZTD = object {Torus_Segment rotate <0,90,0>}
	#declare ZTU = object {Torus_Segment rotate <0,90,0> scale <1,-1,1>}
	
	#local Array_X = int(WIDTH / Wire_Trans);
	#local Array_Z = int(LENGTH / Wire_Trans);
	#local Count1 = 0;
	#local Count2 = 0;
	#local Offset1 = 0;
	#local Offset2 = 1;

	#local Temp_Object =
	union {
	
	#while (Count1 < (Array_X + 2))
		
		#local Point1 = <(Count1 * Wire_Trans),0,0>;
		#local Point2 = (Point1 - <Wire_Rad,0,0>);
		#local Point3 = (Point1 + <Wire_Rad,0,0>); 
		
		WIRE_STRAND (Array_Z,0,Wire_Trans,Point2,Offset1)
		WIRE_STRAND (Array_Z,0,Wire_Trans,Point3,Offset1)
		
		#local Count1 = (Count1 + 1); 
		#if (Offset1 = 0)
			#local Offset1 = 1;
		#else
			#local Offset1 = 0;
		#end
	#end
	
	#while (Count2 < (Array_Z + 2))
		
		#local Point1 = <0,0,(Count2 * Wire_Trans)>;
		#local Point2 = (Point1 - <0,0,Wire_Rad>);
		#local Point3 = (Point1 + <0,0,Wire_Rad>); 
		
		WIRE_STRAND (Array_X,1,Wire_Trans,Point2,Offset2)
		WIRE_STRAND (Array_X,1,Wire_Trans,Point3,Offset2)
		
		#local Count2 = (Count2 + 1); 
		#if (Offset2 = 0)
			#local Offset2 = 1;
		#else
			#local Offset2 = 0;
		#end
	#end
    
    }
    
    object {Temp_Object translate ORIGIN texture{TEXTURE}}
    
#end 

// eof