//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 12 textures and 45 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 04/19/1999    (19.04.1999)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.938> }

camera {  //  Camera StdCam
  location  <-9.230, -11.845, 2.979>
  direction <0.0,     0.0,  0.8270>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <6.858, 0.262, 5.647>
}

//    Other cameras are commented out.
/*
camera {  //  Camera testcam
  location  <0.777, -12.296, 1.708>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-3.169, 45.219, 11.787>
}

*/

/*
camera {  //  Camera topcam
  location  <1.000, -8.000, 126.806>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.000, 0.000, 1.000>
}

*/

// *******  L I G H T S *******
light_source {   // FILL_LGHT
  <-24.756, -20.116, 6.992>
  color rgb <0.200, 0.200, 0.200>
  atmosphere off
}

light_source {   // Light1
  <-29.736, 62.657, 75.243>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "1st_hist.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

sphere { // Smokehalo
  <0,0,0>,1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 1
    color_map {
      [ 0 color rgbt <.5, .5, .5 , 1> ]
      [ 1 color rgbt <.5, .5, 1, .3> ]
    } 
    samples 10
    scale 0.75
  }
  hollow
  scale <1.5, 2, 20>


  translate  <-3.044961, -5.968431, 15.284337>
}


sphere { // firehalo
  <0,0,0>,1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    color_map {
      [ 0 color rgbt <1, 0, 0,  1.0> ]
      [ 1 color rgbt <1, 1, 0, -1.0> ]
    } 
    samples 10
    scale 0.5
  }
  hollow
  scale <1.2,0.2,2.0>

translate  <-3.054084, -6.219205, -0.358327>
}


















#declare ashes = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  texture {
    logtxtr
  }
  scale <-1.0, -1.0, -0.25>
  rotate -180.0*z
  translate  <-3.973173, -6.161319, 0.026045>
}
union { // fire
  cylinder { // log3
    <0,0,1>, <0,0,0>, 1 
    texture {
      logtxtr
    }
    scale <0.2, 0.1, 1.5>
    rotate <-84.996796, -0.120205, -79.777908>
    translate  <-5.186691, -5.773337, 0.0>
  }
  cylinder { // log2
    <0,0,1>, <0,0,0>, 1 
    texture {
      logtxtr
    }
    scale <0.35, 0.25, 2.5>
    rotate <-90.0, 0.0, -28.361568>
    translate  <-4.814054, -7.189356, 0.0>
  }
  object { ashes }
  cylinder { // log1
    <0,0,1>, <0,0,0>, 1 
    texture {
      logtxtr
    }
    scale <0.35, 0.25, 2.5>
    rotate <-90.0, 0.0, -29.809126>
    translate  <-4.335884, -7.582165, 0.0>
  }
  translate  <1.016898, -0.026281, -0.179164>
}


#declare coat = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.047799, 0.073722, -1.404875>, <-2.047799, -0.936552, -2.213916>, <2.047799, -0.936552, -2.213916>, <2.047799, 0.073722, -1.404875>, 
      <-1.000000, 0.000000, 3.817724>, <-1.000000, -1.000000, 3.817724>, <1.000000, -1.000000, 3.817724>, <1.000000, 0.000000, 3.817724>, 
      <-2.873272, 0.062139, 5.568296>, <-2.835169, -3.269552, 5.568296>, <3.374190, -3.269552, 5.568296>, <3.419538, 0.062139, 5.568296>, 
      <-0.215590, 0.000000, 5.870442>, <-0.215590, -0.232458, 5.870442>, <0.215590, -0.232458, 5.870442>, <0.215590, 0.000000, 5.870442>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.047799, 0.073722, -1.404875>, <2.047799, 1.083997, -0.595835>, <-2.047799, 1.083997, -0.595835>, <-2.047799, 0.073722, -1.404875>, 
      <1.000000, 0.000000, 3.817724>, <1.000000, 1.000000, 3.817724>, <-1.000000, 1.000000, 3.817724>, <-1.000000, 0.000000, 3.817724>, 
      <3.419538, 0.062139, 5.568296>, <3.464886, 3.393829, 5.568296>, <-2.911376, 3.393829, 5.568296>, <-2.873272, 0.062139, 5.568296>, 
      <0.215590, 0.000000, 5.870442>, <0.215590, 0.232458, 5.870442>, <-0.215590, 0.232458, 5.870442>, <-0.215590, 0.000000, 5.870442>
    }
  }
  texture {
    furtxtr
  }
  scale 0.5
  translate  <-0.030235, 0.0, 1.481507>
}
#declare right_hand = union {
  sphere { // right_wrist
    <0,0,0>,1
    scale <0.42, 0.29, 0.34>
  }
  box { // right_palm
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.3, 0.55>
    translate  -0.55*z
  }
  translate  -2.0*z
}
#declare rlowerarmgrp = union {
  cylinder { // right_lower_arm
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.34, 2.0>
    translate  -2.0*z
  }
  object { right_hand }
  rotate 30.0*x
  translate  -1.75*z
}
#declare right_arm = union {
  sphere { // right_shoulder
    <0,0,0>,1
    scale <0.6, 0.52, 0.52>
  }
  cylinder { // right_upper_arm
    <0,0,1>, <0,0,0>, 1 
    scale <0.32, 0.419921, 1.75>
    translate  -1.75*z
  }
  sphere { // right_elbow
    <0,0,0>,1
    scale 0.443213
    translate  -1.75*z
  }
  object { rlowerarmgrp }
  scale <1.0, 1.0, 0.952776>
  rotate 90.0*x
  translate  <1.6, 0.0, 2.5>
}
#declare left_hand = union {
  sphere { // left_wrist
    <0,0,0>,1
    scale <0.42, 0.29, 0.34>
  }
  box { // left_palm
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.3, 0.55>
    translate  -0.55*z
  }
  translate  -2.0*z
}
#declare llowerarmgrp = union {
  cylinder { // left_lower_arm
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.34, 2.0>
    translate  -2.0*z
  }
  object { left_hand }
  translate  -1.75*z
}
#declare left_arm = union {
  sphere { // left_shoulder
    <0,0,0>,1
    scale <0.6, 0.52, 0.52>
  }
  cylinder { // left_upper_arm
    <0,0,1>, <0,0,0>, 1 
    scale <0.32, 0.419921, 1.75>
    translate  -1.75*z
  }
  sphere { // left_elbow
    <0,0,0>,1
    scale 0.443213
    translate  -1.75*z
  }
  object { llowerarmgrp }
  scale <1.0, 1.0, 0.952776>
  translate  <-1.6, 0.0, 2.5>
}
#declare upper_body = union {
  sphere { // head
    <0,0,0>,1
    texture {
      headtxtr
    }
    scale <0.78, 0.75, 0.75>
    translate  <0.0, 0.0, 3.75>
  }
  cylinder { // neck
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.35, 0.42>
    translate  2.75*z
  }
  cylinder { // shoulders
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.4, 3.2>
    rotate 90.0*y
    translate  <-1.6, 0.0, 2.5>
  }
  sphere { // chest
    <0,0,0>,1
    scale <1.2, 0.65, 1.5>
    translate  1.5*z
  }
  object { right_arm }
  object { left_arm }
  translate  0.5*z
}
#declare ubodygrp = union {
  object { upper_body }
  sphere { // abdomen
    <0,0,0>,1
    scale <1.143152, 0.656822, 0.772906>
    translate  0.319768*z
  }
  translate  5.0*z
}
#declare right_foot = union {
  sphere { // right_heel
    <0,0,0>,1
    scale <0.479022, 0.324405, 0.324405>
  }
  box { // right_sole
    <-1, -1, -1>, <1, 1, 1>
    scale <0.305077, 0.675796, 0.198559>
    translate  -0.673563*y
  }
  rotate -180.0*x
  translate  -2.0*z
}
#declare rlowerleggrp = union {
  cylinder { // right_lower_leg
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.0>
    translate  -2.0*z
  }
  object { right_foot }
  translate  -3.0*z
}
#declare right_leg = union {
  cylinder { // right_upper_leg
    <0,0,1>, <0,0,0>, 1 
    scale <0.425, 0.375, 3.0>
    translate  -3.0*z
  }
  sphere { // right_knee
    <0,0,0>,1
    scale 0.475202
    translate  -3.0*z
  }
  object { rlowerleggrp }
  translate  0.75*x
}
#declare left_foot = union {
  sphere { // left_heel
    <0,0,0>,1
    scale <0.479022, 0.324405, 0.324405>
  }
  box { // left_sole
    <-1, -1, -1>, <1, 1, 1>
    scale <0.305077, 0.675796, 0.198559>
    translate  -0.673563*y
  }
  rotate -180.0*x
  translate  -2.0*z
}
#declare llowerleggrp = union {
  cylinder { // left_lower_leg
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.0>
    translate  -2.0*z
  }
  object { left_foot }
  translate  -3.0*z
}
#declare left_leg = union {
  cylinder { // left_upper_leg
    <0,0,1>, <0,0,0>, 1 
    scale <0.425, 0.375, 3.0>
    translate  -3.0*z
  }
  sphere { // left_knee
    <0,0,0>,1
    scale 0.475202
    translate  -3.0*z
  }
  object { llowerleggrp }
  translate  -0.75*x
}
#declare lower_body = union {
  cylinder { // pelvis
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.5, 1.5>
    rotate -90.0*y
    translate  0.75*x
  }
  sphere { // right_hip
    <0,0,0>,1
    scale <0.425, 0.590583, 0.5>
    translate  0.75*x
  }
  sphere { // left_hip
    <0,0,0>,1
    scale <0.425, 0.590583, 0.5>
    translate  -0.75*x
  }
  object { right_leg }
  object { left_leg }
  translate  5.2*z
}
#declare person = union {
  object { ubodygrp }
  object { lower_body }
  texture {
    fleshtxtr
  }
  scale 0.5
}
#declare caveman = union {
  object { coat }
  object { person }
  rotate -90.0*z
}
//
// Include file contains 'hair'
//
#include "1st_hist.in1"
#declare hair = object {
  hair_Raw
  texture {
    hairtxtr
  }
  scale <0.2, 0.2, 0.5>
  rotate 15.484538*y
  translate  <-0.017912, 0.0, 4.457985>
}
union { // cavemanwithstuff
  object { caveman }
  object { hair }
  rotate -22.26716*z
  translate  <9.075858, -4.629646, 0.0>
}


union { // spear
  cylinder { // spearpole
    <0,0,1>, <0,0,0>, 1 
    texture {
      BLACK
    }
    scale <0.125, 0.125, 6.0>
  }
  cone { // speartip
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      speartiptxtr
    }
    scale <-0.25, -0.05, -1.5>
    rotate -180.0*z
    translate  6.7*z
  }
  rotate <-90.0, -120.0, 127.220467>
  translate  <5.634606, -6.369555, 1000.0>
}


difference { // cavetop
  box { // SUNBLOCKR
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BLACK
    }
    scale <20.0, 1.0, 20.0>
    translate  <0.252195, 22.331583, 67.738507>
  }
  cylinder { // cavetopcutout
    <0,0,1>, <0,0,0>, 1 
    scale 10.0
    rotate <-90.0, 0.0, 0.0>
    translate  <3.230985, 17.612468, 40.907597>
  }
  texture {
    cave_txtr
  }
  translate  <0.687523, 0.0, -7.90651>
}




object {   // caveside
  height_field {
    gif "D:\POVRAY3\MORAY25\POVSCN\CAVE2.GIF"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    cave_txtr
    scale <2.4, 2.0, 1.0>
    rotate <90.0, 0.0, -87.49369>
  translate <0.235383, -0.123455, -0.895154>
  }
  scale 20.0
  translate  <-0.193933, 0.0, 19.43377>
}




