//  Catapult Include File
//  Robert J Becraft
//  March, 1999
//  castlewrks@aol.com
//
//  This include file creates CSG's for a Mangonel and arm.  The arm is rendered separate from the Mangonel so that it can be
//  positioned in a fired position or cocked.
//
//   EXAMPLE:
//                   object{Mangonel translate<.5,0,6.5>}
//                   object{Man_Bucket rotate<0,0,25> translate<.5,0,6.5>}
//
//
 
#declare GearSprocket=difference{
         cylinder{<0,0,-.1><0,0,.1>.1 texture{pigment{color Gray50}}}
         cylinder{<0,0,-.11><0,0,.11>.1 translate<-.1,0,0> texture{pigment{color Gray50}}}
}
#declare Gear=union{
          #declare Count=0
          #while (Count<360)
                   object{GearSprocket rotate<0,0,-25>  scale<.2,.1,.1> translate<0,.12,0> rotate<0,0,Count>}
                   #declare Count=Count+15
           #end
     difference{
        cylinder{<0,0,-.01><0,0,.01>.1175 texture{pigment{color Gray50}}}
        cylinder{<0,0,-.011><0,0,.011>.055 texture{pigment{color Gray50}}}
     }
     difference{
         cylinder{<0,0,-.03><0,0,.03> .075 texture{pigment{color Gray50}}}
         cylinder{<0,0,-.031><0,0,.031> .055 texture{pigment{color Gray50}}}
     }
     box{<-.065,-.0071,-.032><.065,.0071,.032> texture{pigment{color Gray50}}}   // crossbar.
}
#declare Gear2=union{
          #declare Count=0
          #while (Count<360)
                   object{GearSprocket rotate<0,0,-25>  scale<.2,.1,.1> translate<0,.06,0> rotate<0,0,Count>}
                   #declare Count=Count+30
           #end
     difference{
        cylinder{<0,0,-.01><0,0,.01>.0595 texture{pigment{color Gray50}}}
        cylinder{<0,0,-.011><0,0,.011>.025 texture{pigment{color Gray50}}}
     }
     difference{
         cylinder{<0,0,-.03><0,0,.03> .035 texture{pigment{color Gray50}}}
         cylinder{<0,0,-.031><0,0,.031> .025 texture{pigment{color Gray50}}}
     }
    box{<-.023,-.023,.132><.023,.023,-.132> texture{pigment{color Gray50}}}      // nut
}
#declare Ratchet=union{
       cylinder{<0,0,-.01><0,0,.01>.02 texture{pigment{color Gray50}}}
       cylinder{<0,0,-.02><0,0,.02>.01 texture{pigment{color Gray50}}}
       box{<-.01,-.01,-.01><.01,.01,.01> rotate<0,0,45> scale<2,1,1> translate<-.02,0,0>  texture{pigment{color Gray50}}}
}
#declare Nut=union{
       box{<-.0035,-.01,-.01><.0035,.01,.01> texture{pigment{color Gray50}}}
       box{<-.0035,-.01,-.01><.0035,.01,.01> texture{pigment{color Gray50}} scale .95 rotate<0,0,45>}
       box{<-.0035,-.01,-.01><.0035,.01,.01> texture{pigment{color Gray50}} scale .95 rotate<0,0,-45>}
       box{<-.0035,-.01,-.01><.0035,.01,.01> texture{pigment{color Gray50}} rotate<0,0,90>}
}

#declare RightSide=union{
   difference{
       union{
         box{<-1.5,-.2,.03><1.3,.2,.2> texture{T_Wood13 rotate<0,90,0>}}
         box{<-.2,-.17,.02><.28,.17,.03> texture{pigment{color Gray50}}}      // back plate
       }
      cylinder{<0,0,.019><0,0,.0310>.054 texture{pigment{color Gray50}}}   // hole
      cylinder{<0,0,.019><0,0,.40>.054 texture{T_Wood13 rotate<0,90,0>}}   // hole
    }
   object{Nut translate<-.18,-.15,.02>}
   object{Nut translate<-.18,.15,.02>}
   object{Nut translate<.25,-.15,.02>}
   object{Nut translate<.25,.15,.02>}

   object{Gear}
   object{Gear2 translate<.18,.07,0>}
   object{Ratchet rotate<0,0,25> translate<-.15,.045,0>}
}
#declare LeftSide=union{
   difference{
       union{
         box{<-1.5,-.2,-.03><1.3,.2,-.2> texture{T_Wood13 rotate<0,90,0>}}
         box{<-.2,-.17,-.02><.28,.17,-.03> texture{pigment{color Gray50}}}      // back plate
       }
      cylinder{<0,0,-.019><0,0,-.0310>.054 texture{pigment{color Gray50}}}   // hole
      cylinder{<0,0,-.019><0,0,-.40>.054 texture{T_Wood13 rotate<0,90,0>}}   // hole
    }
   object{Nut translate<-.18,-.15,-.02>}
   object{Nut translate<-.18,.15,-.02>}
   object{Nut translate<.25,-.15,-.02>}
   object{Nut translate<.25,.15,-.02>}

   object{Gear}
   object{Gear2 translate<.18,.07,0>}
   object{Ratchet rotate<0,0,25> translate<-.15,.045,0>}
}

// Wheel
#declare Wheelpart=union{
   box{<-.45,-.045,-.03><.45,.045,.03> texture{T_Wood13 rotate<0,90,0>}}
}
#declare Wheel_Rim=difference{
   cylinder{<0,0,-.0305><0,0,.0305> .36 texture{pigment{color Gray50}}}
   cylinder{<0,0,-.03051><0,0,.03051>.35 }
}

#declare Wheela=intersection{
    union{
       cylinder{<0,0,.065><0,0,-.065>,.08 texture{T_Wood13}}
       cone{<0,0,.095> .08 <0,0,-.095> .045 texture{T_Wood13}}
       cylinder{<0,0,.125><0,0,-.125>.025 texture{pigment{color Gray50}}}

      box{<-.15,-.27,-.045><-.1,.27,.045> texture{T_Wood13}}
      cylinder{<-.125,-.27,-.045><-.125,-.27,.045> .025 texture{T_Wood13}}
      cylinder{<-.125,.27,-.045><-.125,.27,.045> .025 texture{T_Wood13}}

      box{<.1,-.27,-.045><.15,.27,.045> texture{T_Wood13}}
      cylinder{<.125,-.47,-.045><.125,-.27,.045> .025 texture{T_Wood13}}
      cylinder{<.125,.47,-.045><.125,.27,.045> .025 texture{T_Wood13}}

      object{Wheelpart translate<0,.5,0>}
      object{Wheelpart translate<0,.4,0>}
      object{Wheelpart translate<0,.3,0>}
      object{Wheelpart translate<0,.2,0>}
      object{Wheelpart translate<0,.1,0>}
      object{Wheelpart translate<0,0,0>}
      object{Wheelpart translate<0,-.1,0>}
      object{Wheelpart translate<0,-.2,0>}
      object{Wheelpart translate<0,-.3,0>}
      object{Wheelpart translate<0,-.4,0>}
      object{Wheelpart translate<0,-.5,0>}
    }
    cylinder{<0,0,-.2><0,0,.2> .35 }
}

#declare Wheel=union{
   object{Wheela}
   object{Wheel_Rim}
}

#declare RopeT=texture{pigment{gradient y color_map{
           [0.0 color Tan]
           [0.99 color Gray10]
           [1.0 color Tan]
           } scale .025 rotate<0,90,0>
           }}

#declare R1=seed(3839)
#declare Rope=union{
    #declare Count=-.72
    #while (Count<0)
             #declare RR=rand(R1)*.008
             #declare R2=rand(R1)*.008
             #declare RO=rand(R1)*4-2
             #declare RS=rand(R1)*.5+.75
             #declare ROT=rand(R1)*360
             torus{.05+RR,.02 scale RS rotate<0,0,90> rotate<0,40+RO,0> translate<0,0,Count> texture{RopeT rotate<ROT,0,0>}}
             torus{.05+R2,.02 scale RS rotate<0,0,90> rotate<0,-40+RO,0> translate<0,0,-Count> texture{RopeT rotate<0,0,ROT>}}
             #declare Count=Count+.028
    #end
    torus{.04+RR,.02  rotate<0,0,90> rotate<0,40+RO,0> translate<0,0,.75> texture{RopeT rotate<ROT,0,0>}}
    torus{.04+R2,.02   rotate<0,0,90> rotate<0,-40+RO,0> translate<0,0,-.75> texture{RopeT rotate<0,0,ROT>}}
}

#declare Hook=union{
     torus{.02,.005 rotate<0,0,-30> translate<.018,0,0> texture{pigment{color Gray50}}}
     torus{.02,.005 rotate<90,0,0> texture{pigment{color Gray50}}}
}

#declare Mangonel=union{
// Mangonel

object{LeftSide    translate<0,0,.75>}
object{RightSide translate<0,0,-.75>}

// cross-braces
box{<-1.45,-.15,-.76><-1.3,.15,.76> texture{T_Wood13 rotate<0,0,0>}}
box{<.45,-.15,-.72><.3,.15,.72> texture{T_Wood13 rotate<0,0,0>}}
box{<1.25,-.15,-.76><1.10,.15,.76> texture{T_Wood13 rotate<0,0,0>}}

object{Hook translate<1.265,0,-.4>}
//object{Hook translate<1.265,0,-.3>}
object{Hook translate<1.265,0,-.25>}
object{Hook translate<1.265,0,-.1>}
object{Hook translate<1.265,0,.1>}
object{Hook translate<1.265,0,.25>}
//object{Hook translate<1.265,0,.3>}
object{Hook translate<1.265,0,.4>}

difference{
     box{<-.45,-.15,-.72><-.3,.15,.72> texture{T_Wood13 rotate<0,0,0>}}
     cylinder{<-.46,.2,0><-.25,.18,0> .16 texture{T_Wood13 rotate<0,0,0>}}  // gouge portion of crossbeam.
}

union{
  box{<.4,1.35,-.76><.24,1.55,.76> texture{T_Wood13 rotate<0,0,0>}}              // top brace

  difference{
     cone{<.32,1.45,-.35>.16 <.32,1.45,-.15>.12 texture{pigment{color DarkBrown}}}
     cone{<.32,1.45,-.351>.159 <.321,1.45,-.151>.119 texture{pigment{color DarkBrown}}}
  }
  difference{
     cone{<.32,1.45,.15>.12 <.32,1.45,.35>.156 texture{pigment{color DarkBrown}}}
     cone{<.32,1.45,.151>.119 <.32,1.45,.351>.155 texture{pigment{color DarkBrown}}}
  }
  cylinder{<.32,1.45,-.15><.32,1.45,.15>.135 texture{pigment{color DarkBrown}}}


  box{<.48,-.15,-.7><.28,1.5,-.58> texture{T_Wood13 rotate<90,0,0>}}         // vertical
  box{<.48,-.15,.58><.28,1.5,.7> texture{T_Wood13 rotate<90,0,0>}} 
  box{<.48,-.55,.6><.28,1,.68> texture{T_Wood13 rotate<90,0,0>} rotate<0,0,45> translate<.8,.25,0> }   // diagonal brace
  box{<.48,-.55,-.6><.28,1,-.68> texture{T_Wood13 rotate<90,0,0>} rotate<0,0,45> translate<.8,.25,0>}
  translate<-.3,0,0>
}

object{Rope}

// add axles and wheels
    cylinder{<-1.2,-.175,-1><-1.2,-.175,1> .025 texture{pigment{color Gray50}}}
    cylinder{<1,-.175,-1><1,-.175,1> .025 texture{pigment{color Gray50}}}

   object{Wheel rotate<0,0,30>   translate<-1.2,-.175,-.861>}
   object{Wheel rotate<0,0,0>     translate<-1.2,-.175,.861>}
   object{Wheel rotate<0,0,134> translate<1,-.175,-.861>}
   object{Wheel rotate<0,0,230> translate<1,-.175,.861>}

}  // end of Mangonel

#declare Man_Bucket=union{
   box{<-.06,-.15,-.05><.06,1.75,.05>  texture{T_Wood13 rotate<0,90,0>}}
   object{Hook rotate<0,90,0> translate<-.06,1,0>}
   difference{
           sphere{<0,1.91,0>.18 texture{T_Wood13 rotate<0,90,0>}}
           sphere{<0,1.91,0>.15 texture{T_Wood13 rotate<0,90,0>}}
           box{<.06,1.7,-.216><.25,2.21,.216> texture{T_Wood13 rotate<0,90,0>}}
   }
//   rotate<0,0,65>   //   translate<-.3,0,0>
}

