#declare MetalTex=texture{
  pigment{P_Chrome2}
  finish{F_MetalA}
 }

#declare ChainTex=texture{
  pigment{P_Chrome2}
  finish{F_MetalA}
  normal{leopard 50 scale .004 turbulence .1}
 }

#declare Roman_Wool=texture{
  pigment { granite
  color_map {
    [0.4 color Red]
    [0.5 color Black]
    [0.6 color Red]
    [0.7 color DarkBrown]
    [0.8 color Red] } }
  normal{bozo .3 scale<.025,.25,.025> turbulence .1}
 }
//#declare Roman_Wool=texture{
//  pigment{color Red }
//  normal{bozo .3 scale<.025,.25,.025> turbulence .1}
// }

#declare ClothTex=texture{
  pigment{color Wheat}
  normal{bozo .03 scale<.025,.25,.025> turbulence .1}
 }

#declare LeatherTex=texture{
  pigment{P_Chrome2}
  finish{F_MetalA}
 }

#declare Helmet_Friz=texture{
              normal{bozo .1 scale<.035,.35,.035> turbulence .05}
              normal{bozo .15 scale<.35,.35,.35> turbulence .01}
              scale .3/2
              pigment{color Red}
}

#declare Head=union{
  difference{
    union{
      sphere{<0,.2,0> .8}                                                         // skull
      sphere{<0,-.35,0> .65 scale<1,1,.8>}                        // chin
//      box{<0,0,0> <-.4,-.4,-.4> rotate<0,-45,0> rotate<10,0,0> translate<0,0,-.25>}
      cone{<0,.45,-.041>0 <0,-.35,-.18>.19 scale<.65,1,1.2> translate<0,0,-.45>}                // nose
      cylinder{<0,0,.2> <0,-1.4,.25> .35}                                                                                           // neck
     }
    sphere{<0,0,0> .4 scale<1,.15,1> translate<0,-.55,-.4> pigment{color Red} scale<1,1,.8>}   // mouth
    sphere{<0,0,0> .164  scale<1.3,1,1> translate<.27,0,-.76>}  // eye sockets
    sphere{<0,0,0> .164 scale<1.3,1,1> translate<-.27,0,-.76>}
   }
  sphere{<.2,0,-.635> .112 pigment{color White}}                            // eyes
  sphere{<.2,0,-.6> .092 pigment{color Black} scale<1,1,1.1>}
  sphere{<-.2,0,-.635> .112 pigment{color White}}
  sphere{<-.2,0,-.6> .092 pigment{color Black} scale <1,1,1.1>}
  pigment{color NewTan}
  scale .3/2
  translate<0,1.8-.15,.02>
 }

#declare Commander_Head=union{
  difference{
    union{
      sphere{<0,.2,0> .8}                                                         // skull
      sphere{<0,-.35,0> .65 scale<1,1,.8>}                        // chin
      sphere{<0,0,0> .35 scale<1.2,0.75,1.0> translate<0,0,-.65> rotate<-45,0,0> translate<0,-.2,.10>}                 // jaw
      cone{<0,.45,-.041>0 <0,-.35,-.18>.19 scale<.65,1,1.2> translate<0,0,-.45>}                // nose
      cylinder{<0,0,.2> <0,-1.4,.25> .35}                                                                                           // neck
     }
    sphere{<0,0,0> .4 scale<.6,.15,1> translate<0,-.55,-.4> pigment{color Red} scale<1,1,.8>}   // mouth
    sphere{<0,0,0> .164  scale<1.3,1,1> translate<.27,0,-.76>}  // eye sockets
    sphere{<0,0,0> .164 scale<1.3,1,1> translate<-.27,0,-.76>}
   }
  sphere{<.2,0,-.635> .112 pigment{color White}}                            // eyes
  sphere{<.2,0,-.6> .092 pigment{color Black} scale<1,1,1.1>}
  torus{.164,.05 scale<1.3,1,1> rotate<0,0,20> translate<.15,.15,-.6>}
  sphere{<-.2,0,-.635> .112 pigment{color White}}
  sphere{<-.2,0,-.6> .092 pigment{color Black} scale <1,1,1.1>}
  torus{.164,.05 scale<1.3,1,1> rotate<0,0,-20> translate<-.15,.15,-.6>}

  pigment{color NewTan}
  scale .3/2
  translate<0,1.8-.15,.02>
 }


/////////////////////////////////////////////// HAIR ///////////////////////////
///////////////////////////////////////////////////////////////////////////////////
#declare Hair=difference
 {
  sphere{<0,.2,0> .82}
  sphere{<0,-.2,-.2> .82}
  normal{bozo .1 scale<.035,.35,.035> turbulence .05}
  normal{bozo .15 scale<.35,.35,.35> turbulence .01}
//  pigment{color Wheat}
  scale .3/2
  translate<0,1.8-.15,.02>
 }
#declare Hair5=object{Hair pigment{color Orange}}
#declare Hair4=object{Hair pigment{color Yellow}}
#declare Hair3=object{Hair pigment{color Gray50}}
#declare Hair2=object{Hair pigment{color DarkBrown}}
#declare Hair1=object{Hair   pigment{color rgb<.55,.35,.15>}}

///////////////////////////////////////////////// LONGHAIR ////////////////////
///////////////////////////////////////////////////////////////////////////////////////
#declare LongHair=union{
  difference{
    sphere{<0,.2,0> .82}
    sphere{<0,-.2,-.2> .82}
   }
  difference{
    cylinder{<0,.2,0> <0,-1,0> .82}
    cylinder{<0,.21,-.2> <0,-1.1,-.2> .72}
   }
  normal{bozo .1 scale<.035,.35,.035> turbulence .05}
  normal{bozo .15 scale<.35,.35,.35> turbulence .01}
//  pigment{color rgb<.55,.35,.15>}
  scale .3/2
  translate<0,1.8-.15,.02>
 }
#declare LongHair1=object{LongHair pigment{color rgb<.55,.35,.15>}}
#declare LongHair2=object{LongHair pigment{color DarkBrown}}
#declare LongHair3=object{LongHair pigment{color Gray50}}
#declare LongHair4=object{LongHair pigment{color Brown}}
#declare LongHair5=object{LongHair pigment{color Orange}}

//////////////////////////////////////////////////////         Beards  /////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
#declare Beard=union{
  cone{<0,0,0> .08 <0,-.15,0> .03}
  normal{bozo .1 scale<.015,.15,.015> turbulence .05}
  normal{bozo .15 scale<.15,.15,.15> turbulence .01}
//  pigment{color rgb<.55,.35,.15>}
  scale<1,1,.7>
  rotate<25,0,0>
  translate<0,1.538,-.0>
 }
#declare Beard1=object{Beard pigment{color rgb<.55,.35,.15>}}
#declare Beard2=object{Beard pigment{color DarkBrown}}
#declare Beard3=object{Beard pigment{color Gray50}}
#declare Beard4=object{Beard pigment{color Brown}}
#declare Beard5=object{Beard pigment{color Orange}}


/////////////////////////////////////////////////////////////////// Helmets //////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////
#declare Roman_Helmet_Ears=difference{
        cylinder{<-.07,0,0><.04,0,0> .14}
        cylinder{<-.071,0,0><.041,0,0>,.13 scale<1,1.2,1>}
        cylinder{<.08,.0510,-.151><.08,.0510,.151> .1}
}
#declare Roman_Helmet_Brow=union{
   difference{
      torus{ .153,.003}
      box{<-.18,-.2,0.03><.18,.2,.17>}
   }
   cylinder{<-.17,0,0.03><.17,0,0.03> .006}
   cylinder{<-.173,0,0.03><.173,0,0.03> .005}
   rotate<7,0,0>
}

#declare Roman_Helmet=union{
  intersection{
    difference{
        union{
           sphere{<0,.12,0> .15}
             object{Roman_Helmet_Brow translate<0,.16,0>}
//           torus{.165,.008 translate<0,.17,0>}
           cylinder{<0,.14,0> <0,.15,0> .16 scale <1,1,1.05> translate<0,0,-.025>}  // brim
         }
        sphere{<0,.12,0> .14}
     }
    box{<-.2,.3,-.25> <.2,.14,.25>}
   } // intersection
  object{Roman_Helmet_Ears rotate<0,90,0> translate<0,.0850,-0.050>}
  translate<0,1.55,.02>
}
#declare Crest=union{
   sphere{<0,.14,0>.02 }
   cylinder{<0,.14,0><0,.16,0> .01}
    difference{
               union{
                   cylinder{<0,0,-.015><0,0,.015> .17}
                   cylinder{<0,0,-.012><0,0,.012>.25  texture{Helmet_Friz}}
               }
              cylinder{<0,0,-.021><0,0,.021> .16}
              box{<-.28,-.28,-.03><.05,0,.03>}
              box{<-.28,-.28,-.03><.28,0,.03> rotate<0,0,40> texture{Helmet_Friz}}
        scale<1.3,1,1>
     }
}
#declare Centaurian_Crest=union{
   sphere{<0,.14,0>.02 }
   cylinder{<0,.14,0><0,.16,0> .01}
    difference{
               union{
                   cylinder{<0,0,-.015><0,0,.015> .17}
                   cylinder{<0,0,-.012><0,0,.012>.25  texture{Helmet_Friz}}
               }
              cylinder{<0,0,-.021><0,0,.021> .16}
              box{<-.28,-.28,-.03><.05,0,.03> rotate<0,0,-20> texture{Helmet_Friz}}
              box{<-.28,-.28,-.03><.28,0,.03> rotate<0,0,20> texture{Helmet_Friz}}
        scale<1,1,1>
     }
}
#declare Roman_Helmet1=object{Roman_Helmet texture{MetalTex}}
#declare Roman_Helmet2=object{Roman_Helmet texture{Bright_Bronze}}
//#declare Roman_Helment3=object{Roman_Helmet1 texture{Gold}}

#declare Roman_Helmet3=union{
     object{Roman_Helmet texture{MetalTex}}
     object{Crest rotate<0,90,0> texture{MetalTex} translate<0,1.7,0.01>}
}
// Centaurian Helmet (Commander of a Century)
#declare Roman_Helmet4=union{
     object{Roman_Helmet texture{Bright_Bronze}}
     object{Centaurian_Crest rotate<0,0,0> texture{Bright_Bronze} translate<0,1.7,0.01>}
}
///////////////////////////////////////////////////////////////////// WEAPONS /////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
#declare ShortSwordHilt=union{
   cylinder{<-.012,.35,0><.012,.35,0> .025 texture{Bright_Bronze}}
   cone{<0,.35,0> .01 <0,.3,0> .016 texture{T_Wood13 rotate<0,0,90>}}
   cylinder{<0,.3,0><0,.265,0> .016 texture{T_Wood13 rotate<0,0,90>}}
   box{<-.0155,.2575,-.07><.0155,.265,.07> texture{pigment{color Gray30}}}
}
#declare ShortSword=union{
   object{ShortSwordHilt}
   box{<-.01,-.15,-.04><.01,.25,.04> texture{Bright_Bronze}}
   cylinder{<-.01,-.15,0><.01,-.15,0> .04 texture{Bright_Bronze}}
   #declare Count=.2
   #while (Count>=-.14)
     torus{.03,.01 rotate<0,0,90> translate<-.01,Count,0> texture{Bright_Bronze}}
     sphere{<-.01,Count,0> .015 texture{Bright_Bronze}}
     #declare Count=Count-.08
   #end
}

#declare Sword=union{
  union{
    box{<-1,-2,-1> <1,.5,1>  }       // blade
    intersection{
      box{<-1,-.5,-1> <1,.5,1>
           rotate<0,45,0>
           rotate<45,0,0>
           rotate<0,-45,0>
           translate<0,.5,0>
           }
       box{<-1,-.5,-1> <1,1.5,1>}
     } // intersection
    rotate<0,45,0>
    translate<0,2,0>
    scale<.07,.5,.011>
    scale .35
   }  // union
//  cylinder{<-.12,0,0> <.12,0,0> .02}       // hilt of sword
//  sphere{<-.12,0,0> .03}
//  sphere{<.12,0,0> .03}
  box{<-.12,-.01,-.031><.12,.01,.031> }    // square crosspiece
  cylinder{<0,0,0> <0,-.2,0> .03 texture{T_Wood13 rotate<0,0,90>}}
  cylinder{<0,-.2,-.01><0,-.2,.010> .04}
  scale .8
  texture{MetalTex}
 }

#declare ShieldRim=difference{
     intersection{
        cylinder{<0,0,0><0,1,0>.355 texture{Bright_Bronze}}
        box{<.2,.02,-.36><.35,.98,.36> texture{Bright_Bronze}}
    } // intersection
    box{<.19,.06,-.26><.35,.47,.26> texture{Bright_Bronze}}
    box{<.19,.53,-.26><.35,.94,.26> texture{Bright_Bronze}}
    #declare Count=.90
    #while (Count>=.10)
        cylinder{<.19,Count,0><.36,Count,0> .035 texture{Bright_Bronze}}
        #declare Count=Count-.1
    #end
}

#declare Shield=union{
     difference{
        union{
             cylinder{<0,0,0><0,1,0> .35   texture{pigment{color Blue}}}
             object{ShieldRim}
       }
       cylinder{<0,-.1,0><0,1.1,0> .33 texture{pigment{color DarkBrown}}}
       box{<-.36,-.1,-.36><.20,1.1,.36> texture{T_Wood13 rotate<90,0,0>}}
     }
    sphere{<.35,.5,0> .075 texture{Bright_Bronze}}                            // shield boss
    cylinder{<.35,.5,0> <.37,.5,0> .077 texture{Bright_Bronze}}
}

#declare Roman_Spear=union{
  cylinder{<0,0,0> <0,1.6,0> .016 texture{T_Wood13 rotate<90,0,0>}}
  sphere{<0,1.65,0>.05 texture{T_Wood13}}
  cylinder{<0,1.3,0><0,1.60,0> .0165 texture{pigment{color DarkBrown}}} // hand grip
  cone{<0,1.7,0> .035 <0,1.8,0> .01 texture{T_Wood13 rotate<90,0,0>}}
  cone{<0,1.8,0> .0166 <0,2,0> .0106 texture{MetalTex}}               // begin metal shaft
  cylinder{<0,2,0><0,2.4,0> .01 texture{MetalTex}}
  cone{<0,2.4,0> .015 <0,2.5,0> 0 texture{MetalTex}}
 }

#declare Horn=difference{
        union{
           union{
               cone{<0,0,0> .015 <-.05,0,0> .005 texture{pigment{color Gray50}}}
               cone{<-.05,0,0> .005 <-.1,0,0> .01 texture{pigment{color Gray50}}}  // mouthpiece
               translate<0,.45,0>
               rotate<10,0,0>
               translate<-.3,-.565,.17>
           }
           intersection{
                torus{.45,.015 rotate<90,0,0>}
                box{<0,-.6,-.1><.6,.6,.1>}
                rotate<10,0,0>
               translate<-.3,-.565,.17>
            }
           cone{<-.4,-1,0> .03 <-.3,-1,0> .015}
           intersection{
                torus{.5,.03 rotate<90,0,0>}
                box{<-.6,-.6,-.1><0,.6,.1>}
                translate<-.4,-.5,0>
           }
           cone{<-.4,0,0> .03 <0,0,0> .04}
           cone{<0,0,0> .04 <0.40,0,0> .09}
           cone{<0.40,0,0> .09 <0.45,0,0> .12}
           torus{.12, .0025 rotate<0,0,90> translate<.45,0,0>}   // rim
        }
        cone{<-0.001,0,0> .02 <.401,0,0> .075}
        cone{<.039,0,0> .075 <.451,0,0> .105}
//        cone{<-.301,-.15,.32> .01 <-.581,-.15,.32> .003 }  // hollow mouthpeice
//        cone{<-.579,-.15,.321> .003 <-.61,-.15,.32> .013}
}

#declare BeltTassle=union{
  box{<-.02,-.3,-.005><.02,0,.005> texture{pigment{color DarkBrown}}}
  #declare Count=-.26
  #while (Count<0)
     cylinder{<0,Count,-.006><0,Count,.006> .015}
     #declare Count=Count+.03
  #end
}
#declare BeltTassles=union{
  object{BeltTassle rotate<15,0,-18> translate<-.06,0,0>}
  object{BeltTassle rotate<15,0,-5> translate<-.03,0,0>}
  object{BeltTassle rotate<15,0,0> translate<0,0,0>}
  object{BeltTassle rotate<15,0,6> translate<.03,0,0>}
  object{BeltTassle rotate<15,0,15> translate<.06,0,0>}
}

#declare ArmorA=union{
  union{
   cone{<0,.7,0> .35 <0,.25,0> .27 scale <1,1,1.15> } // armor
   cylinder{<0,.28,0><0,.32,0> .29 scale <1,1,1.15> texture{pigment{color Tan}}}  // belt
   object{BeltTassles translate<0,.28,-.29>}
   box{<-0.045,.27,-.35><0.045,.33,-.29> texture{Bright_Bronze}}  // buckle
   difference{
     intersection{
         union{
            cylinder{<.1,0,0><.25,0,0> .35 scale<1,.35,1> translate<0,.67,0> }        // shoulder straps
            cylinder{<-.1,0,0><-.25,0,0>.35 scale <1,.35,1> translate<0,.67,0> }

            cylinder{<-.19,-.02,-.36><-.19,-.02,.36>.03 translate<0,.7,0> texture{Bright_Bronze}}
            sphere{<-.19,-.02,-.36> .015 translate<0,.7,0> texture{Bright_Bronze}}
            sphere{<-.19,-.02,.36> .015 translate<0,.7,0> texture{Bright_Bronze}}

            cylinder{<.19,-.02,-.36><.19,-.02,.36>.03 translate<0,.7,0> texture{Bright_Bronze}}
            sphere{<.19,-.02,-.36> .015 translate<0,.7,0> texture{Bright_Bronze}}
            sphere{<.19,-.02,.36> .015 translate<0,.7,0> texture{Bright_Bronze}}
         }
         box{<-.35,.66,-.38><.35,1.06,.38> }
     } // intersection
     cylinder{<-.26,0,0><.26,0,0> .33  scale<1,.35,1> translate<0,.67,0> }
   } // difference
   difference{
     intersection{
         union{
            cylinder{<.2,0,0><.45,0,0> .37 scale<1,.35,1> translate<0,.67,0> }        // shoulder purloins?
            cylinder{<-.2,0,0><-.45,0,0>.37 scale <1,.35,1> translate<0,.67,0> }
         }
         box{<-.55,.72,-.36><.55,1.06,.36> }
     } // intersection
     cylinder{<-.55,0,0><.55,0,0> .35  scale<1,.35,1> translate<0,.67,0> }
   }

  scale<.6,1,.4>
  translate<0,.7,.05>
  }
  object{ShortSword rotate<0,0,0> rotate<-35,0,0> translate<-.19,.90,.075>}
} // Armor

#declare Armor=object{ArmorA texture{LeatherTex}}
#declare Armor_Command=object{ArmorA texture{Bright_Bronze}}

//////////////////////// Standards /////////////
////////////////////////////////////////////////

#declare EagleWing=union{
   #declare Count=0
   #while (Count<110)
     sphere{<0,0,0>.05 translate<0,.04,0> scale <.25,4.3+(Count/20),.5>  rotate<Count,0,0> texture{Bright_Bronze}}
     #declare Count=Count+5
   #end
}
#declare EagleTail=union{
   #declare Count=-50
   #while (Count<=50)
     sphere{<0,0,0>.05 scale <.25,3,.5> translate<0,-.12,0> rotate<Count,0,0> texture{Bright_Bronze}}
     #declare Count=Count+5
   #end
}
#declare Eagle=union{
  object{EagleTail rotate<30,0,0> translate<-.10,-.5,0> rotate<0,90,0>}
  object{EagleWing rotate<0,0,200> rotate<0,80,0> rotate<0,-110,0> translate<-.13,.10,0>}
  object{EagleWing rotate<0,0,200> rotate<0,-80,0> rotate<0,110,0> translate<.13,.10,0>}
  difference{
    sphere{<0,0,0> .12 scale <1,5,1> texture{Bright_Bronze}}  // body
    torus{.15,.08 translate<0,.2,0> texture{Bright_Bronze}}
    box{<-.16,.25,-.16><.16,.80,.16>}  // take off top part
  }
  sphere{<0,.3,0> .1 scale<1,1.1,1> texture{Bright_Bronze}}  // head
  difference{
    sphere{<0,.25,0> .08 scale<.35,1,1> translate<0,0,-.05> texture{Bright_Bronze}}  // nose
    cylinder{<-.3,.2,0><.3,.2,0> .09 translate<0,0,-.05> texture{Bright_Bronze}}
    translate<0,.05,0>
  }
  sphere{<0,0,0> .017 translate<-.04,.37,-.09> texture{Bright_Bronze}}  // eyes
  sphere{<0,0,0> .017 translate< .04,.37,-.09> texture{Bright_Bronze}}
}
// Aquila, //////////////
// supported the eagle, the most prized legion possession, carried by the aquiliferi

#declare Aquila=union{
  object{Eagle scale .5 rotate<-35,0,0> translate<0,.065,.01>}
  sphere{<0,0,0> .035 texture{Bright_Bronze}}  // mounting ball
  cylinder{<0,-.045,0><0,-.05,0> .05 texture{Bright_Bronze}}  // plate
  cylinder{<0,0,0><0,-.2,0> .022 texture{pigment{color Gold}}} // sleeve
  cylinder{<0,0,0><0,-3,0>.02 texture{T_Wood13 rotate<90,0,0>}}  // handle
  cone{<0,-3,0> .022 <0,-3.2,0> 0 texture{MetalTex}}  // base spike
}

// Vexilla, ///////////
// second standard is the legion standard itself.

#declare Vexilla=union{
  box{<-.2,-.3,-.0005><.2,.3,.0005> translate<0,0,-.05> texture{pigment{color Wheat}}}
  box{<-.3,-.3,-.0005><-.22,.3,.0005> translate<0,0,-.05> texture{pigment{color Red}}}
  box{<.22,-.3,-.0005><.3,.3,.0005> translate<0,0,-.05> texture{pigment{color Red}}}
  cylinder{<-.35,.305,0><.35,.305,0> .01 translate<0,0,-.05> texture{T_Wood13}}  // cross support

  cylinder{<0,0,-.001><0,0,.001> .02 scale<1.5,10,.25> translate<0,.75,0> texture{MetalTex}}  // spear blade
  cone{<0,.5,0> .022 <0,.7,0> .012 texture{MetalTex}}
  cylinder{<0,.5,0><0,-2,0> .02 texture{T_Wood13 rotate<90,0,0>}}  // handle
  cone{<0,-2,0> .022 <0,-2.2,0> 0 texture{MetalTex}}  // base spike
}

// Signum, ///////////
// second standard is the century standard.

#declare HalfMoon=difference{  // half moon shape
    cylinder{<0,0,-.005><0,0,.005>.12 texture{Bright_Bronze}}
    cylinder{<0,.06,-.0051><0,.06,.0051> .1 texture{Bright_Bronze}}
    translate<0,0,-.05> // position on front side of handle
}
#declare Disks=union{
  cylinder{<0,0,-.005><0,0,.005> .08 texture{Bright_Bronze}}
  cylinder{<0,0,-.006><0,0,.006> .05 texture{Bright_Bronze}}
  translate<0,0,-.05>
}

#declare Signum=union{
//  box{<-.2,-.3,-.0005><.2,.3,.0005> translate<0,0,-.05> texture{pigment{color Wheat}}}
  box{<-.3,-.3,-.0005><-.22,.3,.0005> translate<0,0,-.05> texture{pigment{color Red}}}
  box{<.22,-.3,-.0005><.3,.3,.0005> translate<0,0,-.05> texture{pigment{color Red}}}
  cylinder{<-.35,.305,0><.35,.305,0> .01 translate<0,0,-.05> texture{T_Wood13}}  // cross support

  cylinder{<0,0,-.001><0,0,.001> .02 scale<1.5,10,.25> translate<0,.75,0> texture{MetalTex}}  // spear blade
  cone{<0,.5,0> .022 <0,.7,0> .012 texture{MetalTex}}

  object{HalfMoon translate<0,.130,0>}
  object{Disks translate<0,-.05,0>}
  object{Disks translate<0,-.21,0>}
  object{Disks translate<0,-.37,0>}
  object{Disks translate<0,-.53,0>}
  object{HalfMoon scale<1.1,1,1> translate<0,-.65,0>}

  cylinder{<0,.5,0><0,-2.5,0> .02 texture{T_Wood13 rotate<90,0,0>}}  // handle
  cone{<0,-2.5,0> .022 <0,-2.7,0> 0 texture{MetalTex}}  // base spike
}

////////////////////////////////////////////////  Body Parts //////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
#declare Body=union
 {
  sphere{<0,0,0> .35 scale<1,.25,1>}
  sphere{<0,0,0> .35 scale<1,.25,1> translate<0,.7,0>}
  cone{<0,.7,0> .35 <0,.3,0> .28}
  cone{<0,-.1,0>,.36 <0,.3,0>.28}
  cone{<0,-.2,0>,.36 <0,.3,0>.28 texture{ClothTex}}   // linen tunic
  sphere{<0,0,0> .45 scale<1.23,.21,.6> translate<0,.7,0>}
  scale<.6,1,.4>
  translate<0,.7,.05>
 }

#declare RFoot=union{
cone{<0,0,0> .08 <0,0,.1> .052 pigment{color NewTan} scale<1,.2,1>}
cone{<0,0,.105> .048 <0,.075,.1> .038 pigment{color NewTan} scale<1,1,1>}
sphere{<0,0,.053>.05 pigment{color NewTan} scale<1,.51,1.5>}
sphere{<.052,0,0> .03 scale<1,.5,1> pigment{color NewTan}}  // big toe
sphere{<-.07,0,0> .02 scale<1,.65,1> pigment{color NewTan}}
sphere{<-.01,0,0> .025 scale<1,.65,1> pigment{color NewTan}}
sphere{<-.03,0,0> .023 scale<1,.65,1> pigment{color NewTan}}
sphere{<.02,0,0> .028 scale<1,.65,1> pigment{color NewTan}}
}
#declare LFoot=union{
cone{<0,0,0> .08 <0,0,.1> .052 pigment{color NewTan} scale<1,.2,1>}
cone{<0,0,.105> .048 <0,.075,.1> .038 pigment{color NewTan} scale<1,1,1>}
sphere{<0,0,.053>.05 pigment{color NewTan} scale<1,.51,1.5>}
sphere{<-.052,0,0> .03 scale<1,.5,1> pigment{color NewTan}}  // big toe
sphere{<.07,0,0> .02 scale<1,.65,1> pigment{color NewTan}}
sphere{<.01,0,0> .025 scale<1,.65,1> pigment{color NewTan}}
sphere{<.03,0,0> .023 scale<1,.65,1> pigment{color NewTan}}
sphere{<-.02,0,0> .028 scale<1,.65,1> pigment{color NewTan}}
}

#declare OldLegs=union
 {
  cylinder{<-.11,0.05,.05> <-.11,1.2,.05> .09}
  cylinder{<.11,0.05,.05> <.11,1.2,.05> .09}
  sphere{<-.11,.05,-.01> .08 scale<1,.6,1.6> pigment{color DarkBrown}}
  sphere{<.11,.05,-.01> .08 scale<1,.6,1.6> pigment{color DarkBrown}}
 }
#declare Legs=union
 {
  cone{<-.09,.8,.05>.095 <-.11,.4,0> .058 texture{pigment{color NewTan}}}
  cone{<-.11,.4,.01>.053 <-.11,.05,.05> .05 texture{pigment{color NewTan}}}
  sphere{<-.11,.4,0>, .059 texture{pigment{color NewTan}}}

  cone{<.09,.8,.05>.095 <.11,.4,0> .058 texture{pigment{color NewTan}}}
  cone{<.11,.4,.01>.053 <.11,.05,.05> .05 texture{pigment{color NewTan}}}
  sphere{<.11,.4,0>, .059 texture{pigment{color NewTan}}}

//  object{RFoot translate<-.11,.05,-.01>}
  sphere{<-.11,.05,-.01> .08 scale<1,.6,1.6> pigment{color DarkBrown}}    // Feet
  sphere{<.11,.05,-.01> .08 scale<1,.6,1.6> pigment{color DarkBrown}}
 }

#declare LegsL=union{
  cylinder{<-.11,.85,.05> <-.11,.85,-.5> .085}
  cylinder{<.11,.85,.05> <.11,.85,-.5> .085}
  sphere{<-.11,.85,-.5> .086}
  sphere{<.11,.85,-.5> .086}
  cylinder{<-.11,.85,-.5> <-.11,.35,-.5> .085}
  cylinder{<.11,.85,-.5> <.11,.35,-.5> .085}
  sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<0,5,0> translate<-.11,.32,-.53> pigment{color DarkBrown}}
  sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<0,-5,0> translate<.11,.32,-.53> pigment{color DarkBrown}}
  translate<0,-.03,0>
 }

#declare Spear_Arm=union{
  cone{<0,0,0> .063 <0,(1.4-.85)/2,-0.2> .054  texture{pigment{color NewTan}} }                    // upper arm
  cone{<0,-.03,.03> .075 <0,(1.4-1.25),-0.1> .068 texture{Roman_Wool}}                                     // shirt sleeve
  cone{<0,(1.4-.85)/2,-0.2>.06  <0,(1.4-.85),.01>.049  texture{pigment{color NewTan}} }       // lower arm
  sphere{<0,(1.4-.85)/2,-0.2>.065   texture{pigment{color NewTan}} }                                        // elbow
  sphere{<0,1.4-.85+.02,.01> .065 pigment{color NewTan} }                                                         // hand
//  rotate<-90,0,0> translate<-.26,1.4,.06>  // spin and move the whole arm
}
#declare Shield_Arm=union{
  cone{<.26,0,.06>.065 <.26,-.35,.05> .056}            // shield arm
  cone{<.26,.01,.06>.07 <.26,-.15,.05> .066 texture{Roman_Wool}}            // shirt sleeve
  sphere{<.26,-.35,.06> .056}
  cone{<.26,-.35,.06>.056 <.26,-.34,-.3> .049}  // lower arm
  sphere{<.26,-.34,-.31> .065 }                 // hand
  texture{pigment{color NewTan}}
}

#declare Arms=union{
  object{Spear_Arm rotate<180,0,0>  translate<-.26,1.4,0>}
  object{Spear_Arm rotate<180,0,0>  translate<.26,1.4,0>}
//  cylinder{<-.26,1.4,.06> <-.26,.77,.05> .065}
//  cylinder{<.26,1.4,.06> <.26,.77,.05> .065}
//  sphere{<-.26,.75,.05> .07 pigment{color NewTan}}
//  sphere{<.26,.75,.05> .07 pigment{color NewTan}}
 }

#declare ArmsL=union{
   object{Shield_Arm}
   object{Shield_Arm translate<-.52,0,0>}
   translate<0,1.4,0>  // temporary adjustment for this set of arms
//  cylinder{<-.26,1.4,.06> <-.26,1.05,.05> .065}
//  cylinder{<.26,1.4,.06> <.26,1.05,.05> .065}
//  sphere{<-.26,1.05,.06> .066}
//  sphere{<.26,1.05,.06> .066}
//  cylinder{<-.26,1.05,.06> <-.26,1.02,-.4> .065}
//  cylinder{<.26,1.05,.06> <.26,1.02,-.4> .065}
//  sphere{<-.26,1.02,-.42> .07 pigment{color NewTan}}
//  sphere{<.26,1.02,-.42> .07 pigment{color NewTan}}
 }

////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////// SOLDIER SETS //////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

#declare SolFix=union{
  object{Roman_Helmet1}
  object{Head}
//  object{Hair1}
  object{Body texture{Roman_Wool}}
  object{Armor}
  object{Legs}
}
// Soldier standing, right fist raised
#declare SolStand1=union{
  object{SolFix}
  object{Hair1}
  object{Spear_Arm   rotate<-40,0,0> translate<-.26,1.4,.06>}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}
 }

// Soldier standing, with beard
#declare SolStand2=union{
  object{SolFix}
  object{Hair2}
  object{Beard2}
  object{Spear_Arm   rotate<-90,0,0> translate<-.26,1.4,.06>}
  object{Shield_Arm rotate<0,0,0> translate<0,1.4,0>}
}

// Soldier w/ spear, holding spear with both hands
#declare SolSpear=union{
  object{SolFix}
  object{Hair3}
  object{Spear_Arm  rotate<-90,-28,0> translate<-.26,1.4,.06> }                 // right arm
  object{Spear_Arm  rotate<-90,20,0> translate<.26,1.4,.06> }                 // left arm
  object{Roman_Spear translate<0,0,-.48>}
 }

// Soldier w/ Raised spear and sheild
#declare SolSpearA=union{
  object{SolFix}
//  object{Hair1}
  object{Spear_Arm  rotate<-90,0,0> translate<-.26,1.4,.06> }                 // right arm
  object{Roman_Spear rotate<-30,0,0>  translate<-.26,.25,.20>}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}                // left arm
  object{Shield rotate<0,35,0> translate<.1,.55,0>}
 }
#declare SolSpearA1=union{
  object{SolSpearA}
  object{Hair1}
}
#declare SolSpearA2=union{
  object{SolSpearA}
  object{Hair2}
}
#declare SolSpearA3=union{
  object{SolSpearA}
  object{Hair3}
}
#declare SolSpearA4=union{
  object{SolSpearA}
  object{Hair4}
}
#declare SolSpearA5=union{
  object{SolSpearA}
  object{Hair5}
}
#declare SolSpearA11=union{
  object{SolSpearA}
  object{Hair1}
  object{Beard1}
}
#declare SolSpearA22=union{
  object{SolSpearA}
  object{Hair2}
  object{Beard2}
}
#declare SolSpearA33=union{
  object{SolSpearA}
  object{Hair3}
  object{Beard3}
}
#declare SolSpearA44=union{
  object{SolSpearA}
  object{Hair4}
  object{Beard4}
}
#declare SolSpearA55=union{
  object{SolSpearA}
  object{Hair5}
  object{Beard5}
}
// Soldier w/ spear and shield
#declare SolSpearB=union{
  object{SolFix}
//  object{Hair5}
  object{Spear_Arm  rotate<-90,0,0> translate<-.26,1.4,.06> }                 // right arm
  object{Roman_Spear translate<-.26,0,-.52>}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}                // left arm
  object{Shield rotate<0,35,0> translate<.1,.55,0>}
 }
#declare SolSpearB1=union{
  object{SolSpearB}
  object{Hair1}
}
#declare SolSpearB2=union{
  object{SolSpearB}
  object{Hair2}
}
#declare SolSpearB3=union{
  object{SolSpearB}
  object{Hair3}
}
#declare SolSpearB4=union{
  object{SolSpearB}
  object{Hair4}
}
#declare SolSpearB5=union{
  object{SolSpearB}
  object{Hair5}
}
#declare SolSpearB11=union{
  object{SolSpearB}
  object{Hair1}
  object{Beard1}
}
#declare SolSpearB22=union{
  object{SolSpearB}
  object{Hair2}
  object{Beard2}
}
#declare SolSpearB33=union{
  object{SolSpearB}
  object{Hair3}
  object{Beard3}
}
#declare SolSpearB44=union{
  object{SolSpearB}
  object{Hair4}
  object{Beard4}
}
#declare SolSpearB55=union{
  object{SolSpearB}
  object{Hair5}
  object{Beard5}
}

// Soldier w/ spear and shield over head (for Tortoise formation)
#declare SolSpearC=union{
  object{SolFix}
  object{Hair1}
  object{Spear_Arm  rotate<-90,0,0> translate<-.26,1.4,.06> }                 // right arm
  object{Roman_Spear rotate<-30,0,0>  translate<-.26,.25,.20>}
  object{Shield_Arm rotate<0,20,0> rotate<90,0,0> translate<0,1.4,0>}                // left arm
  object{Shield rotate<90,0,0> rotate<0,0,80> translate<.1,1.55,-.73>}
}

// Soldier w/ sword and shield sword held vertical
#declare SolSwordA=union{
  object{SolFix}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}                // left arm
  object{Shield rotate<0,35,0> translate<.1,.55,0>}
  object{Spear_Arm  rotate<-90,0,0> translate<-.26,1.4,.06> }                 // right arm
  object{Sword rotate<0,90,0> translate<-.26,1.5,-.5>}
}
#declare SolSwordA1=union{
   object{SolSwordA}
   object{Hair1}
}
#declare SolSwordA2=union{
   object{SolSwordA}
   object{Hair2}
}
#declare SolSwordA3=union{
   object{SolSwordA}
   object{Hair3}
}
#declare SolSwordA4=union{
   object{SolSwordA}
   object{Hair4}
}
#declare SolSwordA5=union{
   object{SolSwordA}
   object{Hair5}
}
#declare SolSwordA11=union{
   object{SolSwordA1}
   object{Beard1}
}
#declare SolSwordA22=union{
   object{SolSwordA2}
   object{Beard2}
}
#declare SolSwordA33=union{
   object{SolSwordA3}
   object{Beard3}
}
#declare SolSwordA44=union{
   object{SolSwordA4}
   object{Beard4}
}
#declare SolSwordA55=union{
   object{SolSwordA5}
   object{Beard5}
}

// Soldier w/ sword and shield ready to thrust
#declare SolSwordB=union{
  object{SolFix}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}                // left arm
  object{Shield rotate<0,35,0> translate<.1,.55,0>}
  object{Spear_Arm  rotate<-130,0,0> translate<-.26,1.4,.06> }                 // right arm
  object{Sword rotate<-90,0,-90>  rotate<30,0,0> translate<-.26,1.05,-.45>}
 }
#declare SolSwordB1=union{
   object{SolSwordB}
   object{Hair1}
}
#declare SolSwordB2=union{
   object{SolSwordB}
   object{Hair2}
}
#declare SolSwordB3=union{
   object{SolSwordB}
   object{Hair3}
}
#declare SolSwordB4=union{
   object{SolSwordB}
   object{Hair4}
}
#declare SolSwordB5=union{
   object{SolSwordB}
   object{Hair5}
}
#declare SolSwordB11=union{
   object{SolSwordB1}
   object{Beard1}
}
#declare SolSwordB22=union{
   object{SolSwordB2}
   object{Beard2}
}
#declare SolSwordB33=union{
   object{SolSwordB3}
   object{Beard3}
}
#declare SolSwordB44=union{
   object{SolSwordB4}
   object{Beard4}
}
#declare SolSwordB55=union{
   object{SolSwordB5}
   object{Beard5}
}

// Soldier w/ sword and shield sword held vertical
#declare SolSword3=union{
  object{SolFix}
  object{Hair1}
  object{Beard1}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}                // left arm
  object{Shield rotate<0,35,0> translate<.1,.55,0>}
  object{Spear_Arm  rotate<-90,0,0> translate<-.26,1.4,.06> }                 // right arm
  object{Sword rotate<0,90,0> translate<-.26,1.5,-.5>}
 }
// Soldier w/ sword and shield sword held vertical
#declare SolSword4=union{
  object{SolFix}
  object{Hair1}
  object{Beard1}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}                // left arm
  object{Shield rotate<0,35,0> translate<.1,.55,0>}
  object{Spear_Arm  rotate<-130,0,0> translate<-.26,1.4,.06> }                 // right arm
  object{Sword rotate<-90,0,-90>  rotate<30,0,0> translate<-.26,1.05,-.45>}
 }


///////////////// SPECIAL COMMANDERS AND OTHER FIGURES ///////////
//////////////////////////////////////////////////////////////////

// Centurian (Commander of a Century)
#declare Centurian=union{
  object{Roman_Helmet4}
  object{Head}
  object{Hair4}
  object{Body texture{Roman_Wool}}
  object{Armor_Command}
  object{Legs}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}                // left arm
  object{Shield rotate<0,35,0> translate<.1,.55,0>}
  object{Spear_Arm  rotate<-90,0,0> translate<-.26,1.4,.06> }                 // right arm
  object{Sword rotate<0,90,0> translate<-.26,1.5,-.5>}
 }

#declare Mad_Commander=union{
  object{Commander_Head}
  object{Hair3}
  object{Body texture{Roman_Wool}}
  object{Armor_Command}
  object{Legs}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}                // left arm
  object{Roman_Helmet4 rotate<0,0,-20,> translate<-.25,-.6,-.1>}   // held in hand
  object{Shield_Arm  rotate<-50,0,0> rotate<0,-90,0> translate<-.15,1.4,-.21> }                 // right arm on hip
}

// Buccina (curved horn blower) Aeneatores
#declare Aeneatores=union{
  object{SolFix}
  object{Hair5}
  object{Spear_Arm  rotate<-108,-24,0> translate<-.26,1.4,.06> }                 // right arm
  object{Spear_Arm  rotate<-82,20,0> translate<.26,1.4,.06> }                 // left arm
  object{Horn rotate<0,90,0> translate<-.25,1.55,-.5> texture{Bright_Bronze}}
 }

// Soldier Aquiliferi
#declare Aquiliferi=union{
  object{SolFix}
  object{Hair2}
  object{Spear_Arm  rotate<-108,-24,0> translate<-.26,1.4,.06> }                 // right arm
  object{Spear_Arm  rotate<-82,20,0> translate<.26,1.4,.06> }                 // left arm
  object{Aquila translate<0,3.5,-.43>}
 }

// Soldier Vexillarius
#declare Vexillarius=union{
  object{SolFix}
  object{Hair2}
  object{Spear_Arm  rotate<-108,-24,0> translate<-.26,1.4,.06> }                 // right arm
  object{Spear_Arm  rotate<-82,20,0> translate<.26,1.4,.06> }                 // left arm
  object{Vexilla translate<0,2.5,-.43>}
 }

// Soldier Signiferi
#declare Signiferi=union{
  object{SolFix}
  object{Hair2}
  object{Spear_Arm  rotate<-108,-24,0> translate<-.26,1.4,.06> }                 // right arm
  object{Spear_Arm  rotate<-82,20,0> translate<.26,1.4,.06> }                 // left arm
  object{Signum translate<0,3,-.43>}
 }


/////////////////////////////////////////////////////// Special Soldier Sitting

#declare LegsCrossed=union{
  sphere{<-.11,.85,.05>,.07 texture{Roman_Wool}}
  cone{<-.11,.85,.05>.055 <-.11,.85,-.35> .065}
  sphere{<-.11,.85,-.35> .067}
  cone{<-.11,.85,-.35>.050 <-.11,.35,-.15> .06}
  sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<0,5,0> translate<-.11,.32,-.153> pigment{color DarkBrown}}
 }

#declare SolFix2=union{
  object{Head}
  object{Hair2}
  object{Body texture{Roman_Wool}}
  object{Armor}
  object{LegsCrossed          // right leg
               rotate<0,0,80>
               rotate<0,25,0>
               rotate<-10,0,0>
        texture{pigment{color NewTan}} translate<.7,.7,-.30>}

  object{LegsCrossed            // left leg
               rotate<0,0,-80>
               rotate<0,-25,0>
               rotate<-5,0,0>
        texture{pigment{color NewTan}} translate<-.62,.45,-.25>}
}

// Soldier sitting crosslegged
#declare SolSit1=union{
  object{SolFix2}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}                // left arm
  object{Spear_Arm  rotate<-90,0,0> translate<-.26,1.4,.06> }                 // right arm
}

// Kneeling Soldier
#declare LegsKneeling=union{
  sphere{<-.11,.85,.05>,.08 texture{Roman_Wool}}
  cone{<-.11,.85,.05>.055 <-.11,.75,-.35> .075}
  sphere{<-.11,.75,-.35> .076}
  cone{<-.11,.75,-.35>.050 <-.11,.65,0> .06}
  sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<0,5,0> rotate<90,0,0> translate<-.11,.62,-.003> pigment{color DarkBrown}}
 }

#declare SolSit=union{
  object{Head}
  object{Hair1}
  object{Body texture{Roman_Wool}}
  object{Armor}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}                // left arm
  object{Spear_Arm  rotate<-130,0,0> translate<-.26,1.4,.06> }                 // right arm
  object{LegsKneeling rotate<0,10,0> translate<0,-.1,0> texture{pigment{color NewTan}}}
  object{LegsKneeling rotate<0,-10,0> translate<.22,-.1,0> texture{pigment{color NewTan}}}
}


//////////////////////////// Calvary /////////////////
//////////////////////////////////////////////////////

#declare RiderLegs= union {
      cylinder{<-.06,.85,.05> <-.45,.7,-.25> .085}
      cylinder{<.06,.85,.05> <.45,.7,-.25> .085}
      sphere{<-.45,.7,-.25> .086}
      sphere{<.45,.7,-.25> .086}
      cylinder{<-.45,.7,-.25> <-.5,.25,-.15> .085}
      cylinder{<.45,.7,-.25> <.5,.25,-.15> .085}
      sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<-15,15,0> translate<-.5,.22,-.15> pigment{color DarkBrown}}
      sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<-15,-15,0> translate<.5,.22,-.15> pigment{color DarkBrown}}
      translate<0,-.05,0>
      texture{ChainTex}
 }
#declare RiderLegs= union {
      cone{<-.06,.85,.05>.095 <-.45,.7,-.25> .065}
      cone{<.06,.85,.05> .095 <.45,.7,-.25> .065}
      cone{<-.03,.85,.05>.15 <-.26,.76,-.12> .092 texture{Roman_Wool}}
      cone{<.03,.85,.05> .15 <.26,.76,-.12> .092 texture{Roman_Wool}}
      sphere{<-.45,.7,-.25> .068}  // knees
      sphere{<.45,.7,-.25> .068}
      cone{<-.45,.7,-.25> .065 <-.5,.25,-.15> .05}
      cone{<.45,.7,-.25> .065 <.5,.25,-.15> .05}
   object{RFoot scale 1.3 rotate<-35,0,0> translate<-.48,.18,-.23>}
   object{LFoot scale 1.3 rotate<-35,0,0> translate<.48,.18,-.23>}
//       sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<-15,15,0> translate<-.5,.22,-.15> pigment{color DarkBrown}}
//       sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<-15,-15,0> translate<.5,.22,-.15> pigment{color DarkBrown}}
      translate<0,-.05,0>
      texture{pigment{color NewTan}}
 }

#declare Reins=union{
  cylinder{<-.26,2.22,-.42> <-.16,2.4,-1> .007}
  cylinder{<.26,2.22,-.42> <.16,2.4,-1> .007}
  pigment{color Gray30}
}
#declare Reins_One_Hand=union{
  cylinder{<.26,2.22,-.42> <-.16,2.4,-1> .007}
  cylinder{<.26,2.22,-.42> <.16,2.4,-1> .007}
  pigment{color Gray30}
}

#declare SolRider=union{
    object{Roman_Helmet1}
    object{Head}
//    object{Hair}
    object{Body texture{Roman_Wool}}
    object{Armor}
//    object{Spear_Arm  rotate<-90,20,0> translate<-.26,1.4,.06> }                 // right arm
//    object{Shield_Arm rotate<-30,0,0> translate<0,1.4,0>}                // left arm
    object{RiderLegs}
    translate<0,1.15,0>
}

#declare SolRiderA=union{
  object{SolRider}
//  object{Reins}
  object{Spear_Arm  rotate<-90,0,0> rotate<0,45,0> translate<-.26,1.4+1.2,.06> }  // right arm
  object{Roman_Spear rotate<0,0,6> translate<-.45,1.2,-.35>}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4+1.2,0>}
//  object{Horse1 rotate<0,-90,0>}
}
#declare SolRiderA1=union{
  object{SolRiderA}
  object{Hair1 translate<0,1.15,0>}
}
#declare SolRiderA2=union{
  object{SolRiderA}
  object{Hair2 translate<0,1.15,0>}
}
#declare SolRiderA3=union{
  object{SolRiderA}
  object{Hair3 translate<0,1.15,0>}
}
#declare SolRiderA4=union{
  object{SolRiderA}
  object{Hair4 translate<0,1.15,0>}
}
#declare SolRiderA5=union{
  object{SolRiderA}
  object{Hair5 translate<0,1.15,0>}
}
#declare SolRiderA11=union{
  object{SolRiderA}
  object{Hair1 translate<0,1.15,0>}
  object{Beard1 translate<0,1.15,0>}
}
#declare SolRiderA22=union{
  object{SolRiderA}
  object{Hair2 translate<0,1.15,0>}
  object{Beard2 translate<0,1.15,0>}
}
#declare SolRiderA33=union{
  object{SolRiderA}
  object{Hair3 translate<0,1.15,0>}
  object{Beard3 translate<0,1.15,0>}
}
#declare SolRiderA44=union{
  object{SolRiderA}
  object{Hair4 translate<0,1.15,0>}
  object{Beard4 translate<0,1.15,0>}
}
#declare SolRiderA55=union{
  object{SolRiderA}
  object{Hair5 translate<0,1.15,0>}
  object{Beard5 translate<0,1.15,0>}
}

#declare SolRiderB=union{
  object{SolRider}
//  object{Reins}
  object{Spear_Arm  rotate<-80,0,0> rotate<0,50,0> translate<-.26,1.4+1.2,.06> }  // right arm
  object{Roman_Spear rotate<0,0,12> translate<-.38,1.2,-.32>}
  object{Shield_Arm rotate<-10,0,0> translate<0,1.4+1.2,0>}
//  object{Roman_Spear translate<-.43,1.15,-.52>}
//  object{Horse2 rotate<0,-90,0>}
}
#declare SolRiderB1=union{
  object{SolRiderB}
  object{Hair1 translate<0,1.15,0>}
}
#declare SolRiderB2=union{
  object{SolRiderB}
  object{Hair2 translate<0,1.15,0>}
}
#declare SolRiderB3=union{
  object{SolRiderB}
  object{Hair3 translate<0,1.15,0>}
}
#declare SolRiderB4=union{
  object{SolRiderB}
  object{Hair4 translate<0,1.15,0>}
}
#declare SolRiderB5=union{
  object{SolRiderB}
  object{Hair5 translate<0,1.15,0>}
}
#declare SolRiderB11=union{
  object{SolRiderB}
  object{Hair1 translate<0,1.15,0>}
  object{Beard1 translate<0,1.15,0>}
}
#declare SolRiderB22=union{
  object{SolRiderB}
  object{Hair2 translate<0,1.15,0>}
  object{Beard2 translate<0,1.15,0>}
}
#declare SolRiderB33=union{
  object{SolRiderB}
  object{Hair3 translate<0,1.15,0>}
  object{Beard3 translate<0,1.15,0>}
}
#declare SolRiderB44=union{
  object{SolRiderB}
  object{Hair4 translate<0,1.15,0>}
  object{Beard4 translate<0,1.15,0>}
}
#declare SolRiderB55=union{
  object{SolRiderB}
  object{Hair5 translate<0,1.15,0>}
  object{Beard5 translate<0,1.15,0>}
}


#declare SolRiderC=union{
  object{SolRider}
//  object{Reins}
  object{Spear_Arm  rotate<-90,0,0> rotate<0,45,0> translate<-.26,1.4+1.2,.06> }  // right arm
  object{Roman_Spear rotate<0,0,6> translate<-.47,1.2,-.35>}
  object{Shield_Arm rotate<-30,0,0> translate<0,1.4+1.2,0>}
//  object{Roman_Spear translate<-.43,1.1,-.52>}
//  object{Horse3 rotate<0,-90,0>}
}
#declare SolRiderC1=union{
  object{SolRiderC}
  object{Hair1 translate<0,1.15,0>}
}
#declare SolRiderC2=union{
  object{SolRiderC}
  object{Hair2 translate<0,1.15,0>}
}
#declare SolRiderC3=union{
  object{SolRiderC}
  object{Hair3 translate<0,1.15,0>}
}
#declare SolRiderC4=union{
  object{SolRiderC}
  object{Hair4 translate<0,1.15,0>}
}
#declare SolRiderC5=union{
  object{SolRiderC}
  object{Hair5 translate<0,1.15,0>}
}
#declare SolRiderC11=union{
  object{SolRiderC}
  object{Hair1 translate<0,1.15,0>}
  object{Beard1 translate<0,1.15,0>}
}
#declare SolRiderC22=union{
  object{SolRiderC}
  object{Hair2 translate<0,1.15,0>}
  object{Beard2 translate<0,1.15,0>}
}
#declare SolRiderC33=union{
  object{SolRiderC}
  object{Hair3 translate<0,1.15,0>}
  object{Beard3 translate<0,1.15,0>}
}
#declare SolRiderC44=union{
  object{SolRiderC}
  object{Hair4 translate<0,1.15,0>}
  object{Beard4 translate<0,1.15,0>}
}
#declare SolRiderC55=union{
  object{SolRiderC}
  object{Hair5 translate<0,1.15,0>}
  object{Beard5 translate<0,1.15,0>}
}



#declare SolRiderD=union{
  object{SolRider}
//  object{Reins}
  object{Spear_Arm  rotate<-90,0,0> rotate<0,45,0> translate<-.26,1.4+1.2,.06> }  // right arm
  object{Roman_Spear rotate<-15,0,6> translate<-.48,1.2,0>}
  object{Shield_Arm rotate<0,0,0> translate<0,1.4+1.2,0>}
//  object{Roman_Spear translate<-.43,1.1,-.52>}
//  object{Horse4 rotate<0,-90,0>}
}
#declare SolRiderD1=union{
  object{SolRiderD}
  object{Hair1 translate<0,1.15,0>}
}
#declare SolRiderD2=union{
  object{SolRiderD}
  object{Hair2 translate<0,1.15,0>}
}
#declare SolRiderD3=union{
  object{SolRiderD}
  object{Hair3 translate<0,1.15,0>}
}
#declare SolRiderD4=union{
  object{SolRiderD}
  object{Hair4 translate<0,1.15,0>}
}
#declare SolRiderD5=union{
  object{SolRiderD}
  object{Hair5 translate<0,1.15,0>}
}
#declare SolRiderD11=union{
  object{SolRiderD}
  object{Hair1 translate<0,1.15,0>}
  object{Beard1 translate<0,1.15,0>}
}
#declare SolRiderD22=union{
  object{SolRiderD}
  object{Hair2 translate<0,1.15,0>}
  object{Beard2 translate<0,1.15,0>}
}
#declare SolRiderD33=union{
  object{SolRiderD}
  object{Hair3 translate<0,1.15,0>}
  object{Beard3 translate<0,1.15,0>}
}
#declare SolRiderD44=union{
  object{SolRiderD}
  object{Hair4 translate<0,1.15,0>}
  object{Beard4 translate<0,1.15,0>}
}
#declare SolRiderD55=union{
  object{SolRiderD}
  object{Hair5 translate<0,1.15,0>}
  object{Beard5 translate<0,1.15,0>}
}


#declare SolRiderVexillarius=union{
  object{SolRider}
  object{Hair3 translate<0,1.15,0>}
//  object{Reins_One_Hand}
  object{Spear_Arm  rotate<-90,0,0> rotate<0,45,0> translate<-.26,1.4+1.2,.06> }  // right arm
  object{Shield_Arm rotate<0,0,0> translate<0,1.4+1.2,0>}
  object{Vexilla translate<-.43,3.25,-.42>}
  object{Horse3 rotate<0,-90,0>}
}



#declare Dummy=union
 {
  cone{<0,0,0> .45 <0,.5,0> .23}
  cylinder{<0,.5,0> <0,1.6,0> .23}
  cone{<0,1.6,0> .1 <0,1.8,0> .15}
  cylinder{<0,1.8,0> <0,1.81,0> .23}
  cone{<0,1.8,0> .15 <0,1.9,0> .01}
  cylinder{<-.9,1.5,0> <.9,1.5,0> .06}
  cylinder{<.9,1.5,0> <.95,1.5,0> .4}
  cylinder{<-.9,1.5,0> <-.9,2.3,0> .02}
  texture{T_Wood35 scale .8}
 }

#declare SolTraining=union
 {
  object{Dummy}
  object{SolSwordA1 rotate<0,180,0> translate<0,0,-1.1>}
 }

// Century of men

#declare Century=union{
object{Aeneatores rotate<0,0,0> translate<-1,0,5.5>}
object{Aquiliferi rotate<0,0,0> translate<-1,0,4.4>}
object{Vexillarius translate<-1,0,3.3>}
object{Signiferi rotate<0,0,0> translate<-1,0,2.2>}
object{Centurian translate<-1,0,1>}

#ifndef(GenMen)
#declare RP=seed(382)
#declare Count=0
#while (Count<=3.5)
   #declare Count2=1
   #while (Count2<=11)
        #declare ROY=rand(RP)*30-15  // rotation of soldier
        #declare RX=rand(RP)*.3-.15   // fudge x
        #declare RZ=rand(RP)*.1-.5   // fudge z
        #declare RW=int(rand(RP)*20+1)   // for select
        #switch (RW)
           #case (1)
              object{SolSwordA1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (2)
              object{SolSwordA2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (3)
              object{SolSwordA3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (4)
              object{SolSwordA4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (5)
              object{SolSwordA5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (6)
              object{SolSwordA11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (7)
              object{SolSwordA22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (8)
              object{SolSwordA33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (9)
              object{SolSwordA44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (10)
              object{SolSwordA55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (11)
              object{SolSwordB1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (12)
              object{SolSwordB2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (13)
              object{SolSwordB3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (14)
              object{SolSwordB4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (15)
              object{SolSwordB5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (16)
              object{SolSwordB11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (17)
              object{SolSwordB22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (18)
              object{SolSwordB33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (19)
              object{SolSwordB44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (20)
              object{SolSwordB55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
        #end
       #declare Count2=Count2+1.1
   #end
   #declare Count=Count+.8
#end
#end // ifndef(GenMen)
}

// Century of Spearmen
#declare CenturySpear=union{
object{Aeneatores rotate<0,0,0> translate<-1,0,5.5>}
object{Aquiliferi rotate<0,0,0> translate<-1,0,4.4>}
object{Vexillarius translate<-1,0,3.3>}
object{Signiferi rotate<0,0,0> translate<-1,0,2.2>}
object{Centurian translate<-1,0,1>}

#ifndef(GenMen)
#declare RP=seed(9382)
#declare Count=0
#while (Count<=3.5)
   #declare Count2=1
   #while (Count2<=11)
        #declare ROY=rand(RP)*30-15  // rotation of soldier
        #declare RX=rand(RP)*.3-.15   // fudge x
        #declare RZ=rand(RP)*.1-.5   // fudge z
        #declare RW=int(rand(RP)*20+1)   // for select
        #switch (RW)
           #case (1)
              object{SolSpearA1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (2)
              object{SolSpearA2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (3)
              object{SolSpearA3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (4)
              object{SolSpearA4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (5)
              object{SolSpearA5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (6)
              object{SolSpearA11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (7)
              object{SolSpearA22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (8)
              object{SolSpearA33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (9)
              object{SolSpearA44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (10)
              object{SolSpearA55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (11)
              object{SolSpearB1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (12)
              object{SolSpearB2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (13)
              object{SolSpearB3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (14)
              object{SolSpearB4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (15)
              object{SolSpearB5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (16)
              object{SolSpearB11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (17)
              object{SolSpearB22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (18)
              object{SolSpearB33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (19)
              object{SolSpearB44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (20)
              object{SolSpearB55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
        #end
       #declare Count2=Count2+1.1
   #end
   #declare Count=Count+.8
#end
#end // ifndef(GenMen)
}

// Thurma of Mounted soldiers
#declare Thurma=union{

object{SolRiderVexillarius translate<-2,0,1>}

#ifndef(GenMen)
#declare RP=seed(426)
#declare Count=0
#while (Count<=6)
   #declare Count2=1
   #while (Count2<=6)
        #declare ROY=rand(RP)*20-10  // rotation of soldier
        #declare RX=rand(RP)*.3-.15   // fudge x
        #declare RZ=rand(RP)*.1-.5   // fudge z
        #declare RW=int(rand(RP)*40+1)   // for select
        #declare RH=int(rand(RP)*4+1)    // for horse select
        #switch (RW)
           #case (1)
              object{SolRiderA1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (2)
              object{SolRiderA2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (3)
              object{SolRiderA3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (4)
              object{SolRiderA4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (5)
              object{SolRiderA5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (6)
              object{SolRiderA11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (7)
              object{SolRiderA22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (8)
              object{SolRiderA33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (9)
              object{SolRiderA44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (10)
              object{SolRiderA55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (11)
              object{SolRiderB1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (12)
              object{SolRiderB2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (13)
              object{SolRiderB3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (14)
              object{SolRiderB4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (15)
              object{SolRiderB5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (16)
              object{SolRiderB11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (17)
              object{SolRiderB22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (18)
              object{SolRiderB33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (19)
              object{SolRiderB44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (20)
              object{SolRiderB55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (21)
              object{SolRiderC1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (22)
              object{SolRiderC2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (23)
              object{SolRiderC3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (24)
              object{SolRiderC4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (25)
              object{SolRiderC5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (26)
              object{SolRiderC11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (27)
              object{SolRiderC22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (28)
              object{SolRiderC33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (29)
              object{SolRiderC44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (30)
              object{SolRiderC55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (31)
              object{SolRiderD1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (32)
              object{SolRiderD2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (33)
              object{SolRiderD3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (34)
              object{SolRiderD4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (35)
              object{SolRiderD5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (36)
              object{SolRiderD11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (37)
              object{SolRiderD22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (38)
              object{SolRiderD33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (39)
              object{SolRiderD44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (40)
              object{SolRiderD55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
        #end
        #switch (RH)
           #case (1)
              object{Horse1 rotate<0,ROY-90,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (2)
              object{Horse2 rotate<0,ROY-90,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (3)
              object{Horse3 rotate<0,ROY-90,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (4)
              object{Horse4 rotate<0,ROY-90,0> translate<RX+Count,0,RZ+Count2>}
           #break
        #end
       #declare Count2=Count2+3
   #end
   #declare Count=Count+2
#end
#end // ifndef(GenMen)
}


/////// Scene Specials... gamblers and mad commander.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#declare Coin=cylinder{<0,-.0025,0><0,.0025,0>.022 texture{Bright_Bronze}}

#declare CS=seed(3838)
#declare Coin_Pile=union{
    #declare Count=1
    #while (Count<25)
        #declare CX=rand(CS)*.2-.1
        #declare CY=rand(CS)*.2-.1
        #declare CZ=int(rand(CS)*4)     // 1-4 in stack
        #declare C2=1
        #while (C2<CZ)
            object{Coin translate<CX,C2*.0025,CY>}
             #declare C2=C2+1
        #end
        #declare Count=Count+1
     #end
} // Coin_Pile

#declare Caught_Gamblers=union{
 // box{<-5,-.01,-5><5,0,5> texture{T_Stone28b}}   // temp base

  object{Roman_Spear rotate<90,0,0>  translate<-3.5,.02,2.20>}
  object{Roman_Spear rotate<90,0,0> rotate<0,30,0> translate<-3,.02,2.5>}
  object{Shield rotate<0,0,90> translate<-2.5,-.17,2.4>}
  object{Shield translate<-4.25,0,2.4>}

  object{Mad_Commander rotate<0,-25,0> translate<-.35,0,.75>}
  object{SolSit1 rotate<0,-90,0> translate<-.75,-.60,0>}
  object{SolSit rotate<0,0,0> translate<0,-.6,.50> }
  object{Coin_Pile translate<0,0,-.25>}
  box{<0,0,0><.027,.027,.027> texture{pigment{color Wheat}}}
  box{<0,0,0><.027,.027,.027> texture{pigment{color Wheat}} rotate<0,45,0> translate<0,0,-.1>}
}
