//------------------------------------------------------------------------
//
//  Roman Fort:   F O R T . P O V --- Source for 1stAtom.jpg (IRTC Submission)
//
//  Author:  Robert J Becraft
//  Created:  April, 1999
//------------------------------------------------------------------------
#include "colors.inc"
#include "stones1.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"
#include "textures.inc"

//************************* CAMERA ***********************************
camera {
//  location  <-450,20,250> look_at <-450,30,140>       // Corner
//  location  <-200,40,-175> look_at <0,1,0>       // Top Shot
//  location  <-20,14,10> look_at <20,1,0>       // Main Administration Building
//  location  <-60,14,10> look_at <20,1,30>       // Administration Buildings
//  location  <-170,18,-3> look_at <20,1,10>       //
//   location  <0,24,-60> look_at <20,1,10>
//   location  <-2,6,-16> look_at <20,1,10>     // view troops in front of admin building
//   location  <33,6,20> look_at <30,1,5>     // view  (Fort4*******)
//   location  <36,4.3,22> look_at <20,1,7>     // view  (Fort)
   location  <-3,5.5,25.5> look_at <10,1,5.5>     // view 1stabomb.jpg  <<< --- IRTC Entry
}
light_source { <-1200,1000,450 >  color White*2 }
//------------------------------------------------------------------------

//*** Custom Textures ------------------------------------------

#include "forttext.inc"   // city specific textures

//---Uncomment to include these sections-------------------------------
#declare foggie="on"   // uncomment to turn off
#declare Sky="off"  // uncomment to turn off
//#declare Sky2="off" // second version of sky

//#declare Soldiers="off" //uncomment to turn soldiers off

#ifndef(Soldiers)
// some interest.... ==================================
  #declare R1=seed(23)
  #include "..\med\people.inc"  // for horses
  #include "romsold.inc"
  //#include "..\med\wagons.inc"
#end

//------ TEXTURES -------
//-----------------------

#ifndef (C1INC)
   #declare R1=seed(4793)
   #include "maintree.inc"

   #include "mainpart.inc"          // doors/windows etc.
   #include "mainbldg.inc"        //residential type buildings (10x10 meter)
   #include "mainbld2.inc"        // warehouse buildings (20x20 meter)
//   #include "marketde.inc"        // Marketplace objects
#end


#ifdef (foggie)
//fog {                                            // Green ground fog
//  distance 150
//  colour rgb<0.3, 0.5, 0.2>
//  fog_type 2
//  fog_offset 75
//  fog_alt 1
//  turbulence 0.1
//  turb_depth 0.2
//}
fog {                                                 // White ground fog
  distance 500
  colour rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 60
  fog_alt 4
  turbulence 1.0
  turb_depth 3.0
}

//fog {                                                 // White ground fog
//  distance 100
//  colour rgb<0.52, 0.62, 0.72>
//  fog_type 2
//  fog_offset 10
//  fog_alt 4
//  turbulence 11.0
//  turb_depth 13.0
//}

#end

#ifndef(Sky2)
   #include "cloud.inc"
#end

#ifndef (Sky)
/*******************************
 * THE SKY
 *******************************/
#declare SkyBlue = rgb <0.15, 0.4, 0.7>
#declare P_Clouds =
pigment {
  wrinkles
  turbulence 0.1
  lambda 2.2
  omega 0.707
  color_map {
    [0.60 SkyBlue ]
    [0.80 White ]
    [1.00 Gray90 ]
  }
  scale <0.5, 0.15, 1>
  rotate  z*180
  rotate  y*60
}
sky_sphere {
  pigment {
    gradient y
    pigment_map {
      [0.00 rgb <0.847, 0.749, 0.847> ] // horizon
      [0.05 SkyBlue ]                   // horizon
      [0.15 P_Clouds ]
      [1.00 SkyBlue ]

    }
  }
}
#end // #ifndef (Sky)

#declare DD=100
#declare DT=-(DD/2)
// Ground, water and mound levels
union {
//**************************
// The main ground level

  object {   //  South
                height_field { gif  "romanga.ghf" }
                texture { pigment { color Khaki } }
                scale < DD, 6, DD >   translate < DT, 0, DT >
                rotate<0,0,0> translate<0,0,-DD>
  }
  object {   //  West
                height_field { gif  "romanga.ghf" }
                texture { pigment { color Khaki } }
                scale < DD, 6, DD >   translate < DT, 0, DT >
                rotate<0,90,0> translate<-DD,0,0>
  }
  object {   //  East
                height_field { gif  "romanga.ghf" }
                texture { pigment { color Khaki } }
                scale < DD, 6, DD >   translate < DT, 0, DT >
                rotate<0,-90,0> translate<DD,0,0>
  }
  object {   //  North
                height_field { gif  "romanga.ghf" }
                texture { pigment { color Khaki } }
                scale < DD, 6, DD >   translate < DT, 0, DT >
                rotate<0,180,0> translate<0,0,DD>
  }
  object {   //  Northwest
                height_field { gif  "romanco.ghf" }
                texture { pigment { color Khaki } }
                scale < DD, 6, DD >   translate < DT, 0, DT >
                rotate<0,180,0> translate<-DD,0,DD>
  }
  object {   //  Northeast
                height_field { gif  "romanco.ghf" }
                texture { pigment { color Khaki } }
                scale < DD, 6, DD >   translate < DT, 0, DT >
                rotate<0,-90,0> translate<DD,0,DD>
  }
  object {   //  Southeast
                height_field { gif  "romanco.ghf" }
                texture { pigment { color Khaki } }
                scale < DD, 6, DD >   translate < DT, 0, DT >
                rotate<0,0,0> translate<DD,0,-DD>
  }
  object {   //  Southwest
                height_field { gif  "romanco.ghf" }
                texture { pigment { color Khaki } }
                scale < DD, 6, DD >   translate < DT, 0, DT >
                rotate<0,90,0> translate<-DD,0,-DD>
  }

  box{<-2000,0,-2000><2000,2,2000> texture{pigment{color Khaki}}}   // East side

  box{<-2000,2,-1.5><2000,2.01,1.5> texture{CityStreetColor}}  // Center road
  box{<-1.5,2,-2000><1.5,2.01,2000> texture{CityStreetColor}}  // Center road
  box{<-200,2,-3><200,2.01,3> texture{CityStreetColor}}  // Center road
  box{<-3,2,-200><3,2.01,200> texture{CityStreetColor}}  // Center road
  box{<0,2,-40><60,2.01,40> texture{CityStreetColor}}

//  box{<0,0,100><2600,6,1200> texture{pigment{color Khaki}}}  // North side

//  box{<-2500,0,250><-600,3,2000> texture{pigment{color Khaki}}}

//**************************
// Now for a watery plain
  plane {
               < 0,.08,0 >, 0
                texture {
                  pigment { color rgb< 0.0, 0.1, 0.2 > }
                  normal { bumps 0.2  scale < .5, 0.25, 0.25 > }
                  finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
                 }
               translate < 0, .20 , 0 >
  }
} // end union

//---------------------------------------- objects

//cylinder{<0,0,0><0,100,0> 10 texture{pigment{color White}}}

#declare GateTop=difference{
  union{
     box{<-5.2,8,-5.2><5.2,13,5.2> texture{WoodSide101}}
     box{<-4.2,10,-5.22><-3.3,12,5.22> texture{T_Wood13}}
     box{<-2.7,10,-5.22><-1.8,12,5.22> texture{T_Wood13}}
     box{<-.45,10,-5.22><.45,12,5.22> texture{T_Wood13}}
     box{<2.7,10,-5.22><1.8,12,5.22> texture{T_Wood13}}
     box{<3.3,10,-5.22><4.2,12,5.22> texture{T_Wood13}}
  }
  box{<-4,10.2,-5.23><-3.5,11.8,5.23> texture{T_Wood13}}
  box{<-2.5,10.2,-5.23><-2,11.8,5.23> texture{T_Wood13}}
  box{<-.25,10.2,-5.23><.25,11.8,5.23> texture{T_Wood13}}
  box{<2.5,10.2,-5.23><2,11.8,5.23> texture{T_Wood13}}
  box{<4,10.2,-5.23><3.5,11.8,5.23> texture{T_Wood13}}
}


#declare Gate1=union{
   triangle{<-5.4,13,-5.4><-5.4,13,5.4><0,20,0> texture{RoofText}}
   triangle{<-5.4,13,-5.4><5.4,13,-5.4><0,20,0> texture{RoofText}}
   triangle{<5.4,13,-5.4><5.4,13,5.4><0,20,0> texture{RoofText}}
   triangle{<-5.4,13,5.4><5.4,13,5.4><0,20,0> texture{RoofText}}

   object{GateTop}
   box{<-5,0,-5><5,8,5> texture{White_Stone}}
//   box{<-5,8,-5><5,8.01,5> texture{StoneWalk}}
   box{<-5.1,1.8,-5.1><5.1,2.2,5.1> texture{Brick_Text}}
   box{<-5.1,3.8,-5.1><5.1,4.2,5.1> texture{Brick_Text}}
   box{<-5.1,5.8,-5.1><5.1,6.2,5.1> texture{Brick_Text}}
   box{<-5.1,7.8,-5.1><5.1,8,5.1> texture{Brick_Text}}
}
#declare Gate_Arch=difference{
   box{<-5,0,-1><5,10,1> texture{White_Stone}}
   box{<-4,0,-1.1><-1,6,1.1> texture{White_Stone}}
   cylinder{<-2.5,6,-1.1><-2.5,6,1.1> 1.5 texture{White_Stone}}

   box{<1,0,-1.1><4,6,1.1> texture{White_Stone}}
   cylinder{<2.5,6,-1.1><2.5,6,1.1> 1.5 texture{White_Stone}}
}
#declare Gate=union{
   object{Gate1 translate<-10,0,0>}
   object{Gate_Arch}
   object{Gate1 translate<10,0,0>}
}
#declare Wall_Section=union{
   box{<-40,0,-1><40,6,1> texture{White_Stone}}
   box{<-40,6,-.9><40,8,-.6> texture{WoodSide101}}
}
#declare Wall=union{
   object{Wall_Section translate<55,0,0>}
   object{Wall_Section translate<-55,0,0>}
}
#declare CornerBase=difference{
   cylinder{<0,0,0><0,6,0> 35 texture{White_Stone}}
   box{<-36,-.1,0><36,6.1,36> texture{White_Stone}}
   box{<0,-.1,-36><36,6.1,36> texture{White_Stone}}
   cylinder{<0,-.1,0><0,6.1,0> 33 texture{White_Stone}}
}
#declare CornerTop=difference{
   cylinder{<0,6,0><0,8,0> 35.1 texture{WoodSide101}}
   box{<-36,5.9,0><36,8.1,36> texture{WoodSide101}}
   box{<0,5.9,-36><36,8.1,36> texture{WoodSide101}}
   cylinder{<0,5.9,0><0,8.1,0> 34.8 texture{WoodSide101}}
}
#declare Corner=union{
   object{CornerTop}
   object{CornerBase}
}

#declare Barracks=union{
//   box{<-40,0,-4><40,4,4> texture{White_Stone}}
   difference{
      box{<-40,0,-4><40,4,4> texture{White_Stone}}
      box{<-40.1,0,-3><40.1,3,-1> texture{White_Stone}}
      #declare Count=-38
      #while (Count<=38)
         box{<Count-1.5,0,-4.1><Count+1.5,2,-2> texture{White_Stone}}
         cylinder{<Count,2,-4.1><Count,2,-2> 1.5 texture{White_Stone}}
         #declare Count=Count+4
      #end
   }
   box{<-40.3,0,-4.3><40.3,.25,-2> texture{Brick_Text}}
   triangle{<-40,4,-4><-40,4,4><-40,6,0> texture{White_Stone}}
   triangle{<40,4,-4><40,4,4><40,6,0> texture{White_Stone}}

   //roof
   box{<-39.99,3.9,-4.2><39.99,4,4.2> texture{Bright_Bronze}}  // trim strip
   triangle{<-40.2,4,-4.2><-40.2,6,0><40.2,6,0> texture{RoofText}}
   triangle{<-40.2,4,-4.2><40.2,6,0><40.2,4,-4.2> texture{RoofText}}
   triangle{<-40.2,4,4.2><-40.2,6,0><40.2,6,0> texture{RoofText}}
   triangle{<-40.2,4,4.2><40.2,6,0><40.2,4,4.2> texture{RoofText}}
}
#declare Workshop=union{
   box{<-20,0,-4><20,4,4> texture{White_Stone}}
   triangle{<-20,4,-4><-20,4,4><-20,6,0> texture{White_Stone}}
   triangle{<20,4,-4><20,4,4><20,6,0> texture{White_Stone}}

   //roof
   box{<-19.99,3.9,-4.2><19.99,4,4.2> texture{Bright_Bronze}}  // trim strip
   triangle{<-20.2,4,-4.2><-20.2,6,0><20.2,6,0> texture{RoofText}}
   triangle{<-20.2,4,-4.2><20.2,6,0><20.2,4,-4.2> texture{RoofText}}
   triangle{<-20.2,4,4.2><-20.2,6,0><20.2,6,0> texture{RoofText}}
   triangle{<-20.2,4,4.2><20.2,6,0><20.2,4,4.2> texture{RoofText}}
}
#declare Workshop2=union{
   object{Workshop}
   object{Workshop rotate<0,90,0>}
}

#declare ArchTopWindow=difference{
         cylinder{<-.27,0,0><.27,0,0>,.8 }
         cylinder{<-.271,0,0><.271,0,0>.5 }
         box{<-.271,-1,-1.1><.271,0,1.1> }  // trim off bottom
         #declare Count=0
         #while (Count<180)
               box{<-.271,-1,-.015><.271,1,.015> rotate<Count,0,0> }
               #declare Count=Count+10
         #end
}  // ArchTop

#declare ArchTopDoor=difference{
         cylinder{<-.27,0,0><.27,0,0>,1.8}
         cylinder{<-.271,0,0><.271,0,0>1.5 }
         box{<-.271,-1.81,-1.81><.271,0,1.81> }  // trim off bottom
         #declare Count=0
         #while (Count<180)
               box{<-.271,-1.81,-.015><.271,1.81,.015> rotate<Count,0,0> }
               #declare Count=Count+10
         #end
}  // ArchTop

#declare Admin_Top=union{
    difference{
      box{<-36,0,-5><36,4,5> texture{White_Stone}}
      #declare Count=-32
      #while (Count<=32)
         box{<Count-.5,2,-8.1><Count+.5,3,8.1> texture{White_Stone}}
         cylinder{<Count,3,-8.1><Count,3,8.1> .5 texture{White_Stone}}
         #declare Count=Count+4
      #end
   }
   triangle{<-36,4,-5><-36,4,5><-36,9,0> texture{White_Stone}}
   triangle{<36,4,-5><36,4,5><36,9,0> texture{White_Stone}}

   //roof
   box{<-36.19,3.9,-5.1975><36.19,4,5.1975> texture{Bright_Bronze}}  // trim strip
   box{<-36.19,3.975,-5.2><36.19,4,5.2> texture{Bright_Bronze}}  // trim strip
   triangle{<-36.2,4,-5.2><-36.2,9,0><36.2,9,0> texture{RoofText}}
   triangle{<-36.2,4,-5.2><36.2,9,0><36.2,4,-5.2> texture{RoofText}}
   triangle{<-36.2,4,5.2><-36.2,9,0><36.2,9,0> texture{RoofText}}
   triangle{<-36.2,4,5.2><36.2,9,0><36.2,4,5.2> texture{RoofText}}

   #declare Count=-34
   #while (Count<=34)
        cylinder{<Count,0,-5><Count,.2,-5> 0.25 texture{White_Stone}}     // base
        cone{<Count,.2,-5>0.2 <Count,3.5,-5> 0.18 texture{T_Stone8}}   // column
        cylinder{<Count,3.5,-5><Count,3.7,-5> 0.25 texture{White_Stone}}     // top
        cylinder{<Count,3.7,-5><Count,4,-5> 0.3 texture{White_Stone}}     // top
        #declare Count=Count+4
   #end
      #declare Count=-32
      #while (Count<=32)
         object{ArchTopWindow rotate<0,90,0> translate<Count,2.95,-4.75> texture{T_Stone8}}  // add arch
//         triangle{<Count,4.1,-5.2><Count,9.1,0><Count,4.1,5.2> texture{RoofText}}
         #declare Count=Count+4
      #end
      #declare Count=-31
      #while (Count<=31)
//         object{ArchTopWindow rotate<0,90,0> translate<Count,2.95,-4.75> texture{T_Stone8}}  // add arch
         triangle{<Count,4.1,-5.2><Count,9.1,0><Count,4.1,5.2> texture{RoofText}}
         #declare Count=Count+2
      #end
}
#declare Admin_Bottom_A=union{
   difference{
     box{<-36,0,-8><36,4,8> texture{White_Stone}}
     box{<-36.1,0,-7.5><36.1,2,-4.5> texture{White_Stone}} // main collonade
     cylinder{<-36.1,2,-6><36.1,2,-6>1.5 texture{White_Stone}} // arch'ed roof
     #declare Count=-32
     #while (Count<=32)
        box{<Count-1.5,0,-8.1><Count+1.5,2,-4.3> texture{White_Stone}}
        cylinder{<Count,2,-8.1><Count,2,-4.3> 1.5 texture{White_Stone}}
        #declare Count=Count+4
     #end
   }
   triangle{<-36,4,-8><-36,4,8><-36,8,0> texture{White_Stone}}
   triangle{<36,4,-8><36,4,8><36,8,0> texture{White_Stone}}

   //roof
   box{<-35.99,3.9,-8.175><35.99,4,8.175> texture{Bright_Bronze}}  // trim strip
   box{<-35.99,3.975,-8.2><19.99,4,8.2> texture{Bright_Bronze}}  // trim strip
   triangle{<-36.2,4,-8.2><-36.2,8,0><36.2,8,0> texture{RoofText}}
   triangle{<-36.2,4,-8.2><36.2,8,0><36.2,4,-8.2> texture{RoofText}}
   triangle{<-36.2,4,8.2><-36.2,8,0><36.2,8,0> texture{RoofText}}
   triangle{<-36.2,4,8.2><36.2,8,0><36.2,4,8.2> texture{RoofText}}
}
#declare Admin_Bottom=union{
     object{Admin_Bottom_A}
     #declare Count=-34
     #while (Count<=34)
        cylinder{<Count,0,-8><Count,.2,-8> 0.25 texture{White_Stone}}     // base
        cone{<Count,.2,-8>0.2 <Count,3.5,-8> 0.18 texture{T_Stone8}}   // column
        cylinder{<Count,3.5,-8><Count,3.7,-8> 0.25 texture{White_Stone}}     // top
        cylinder{<Count,3.7,-8><Count,4,-8> 0.3 texture{White_Stone}}     // top
        #declare Count=Count+4
     #end
     #declare Count=-32
     #while (Count<=32)
        object{ArchTopDoor rotate<0,90,0> translate<Count,1.95,-7.75> texture{T_Stone8}}  // add arch
//        triangle{<Count,4.1,-8.2><Count,8.1,0><Count,4.1,8.2> texture{RoofText}}
        #declare Count=Count+4
     #end
     #declare Count=-31
     #while (Count<=31)
//        object{ArchTopDoor rotate<0,90,0> translate<Count,1.95,-7.75> texture{T_Stone8}}  // add arch
        triangle{<Count,4.1,-8.2><Count,8.1,0><Count,4.1,8.2> texture{RoofText}}
        #declare Count=Count+2
     #end
}
#declare Admin_Wing_A=union{
//   box{<-20,0,-8><20,4,8> texture{White_Stone}}
   difference{
     box{<-20,0,-6><20,4,6> texture{White_Stone}}
     box{<-20.1,0,-5><20.1,2,-2> texture{White_Stone}} // main collonade
     cylinder{<-20.1,2,-3.5><20.1,2,-3.5>1.5 texture{White_Stone}} // arch'ed roof
     #declare Count=-16
     #while (Count<=16)
        box{<Count-1.5,0,-6.1><Count+1.5,2,-2.3> texture{White_Stone}}
        cylinder{<Count,2,-6.1><Count,2,-2.3> 1.5 texture{White_Stone}}
        #declare Count=Count+4
     #end
   }

   triangle{<-20,4,-6.2><-20,4,6.2><-20,8,0> texture{White_Stone}}
   triangle{<20,4,-6.2><20,4,6.2><20,8,0> texture{White_Stone}}

   //roof
   box{<-19.99,3.9,-6.175><19.99,4,6.175> texture{Bright_Bronze}}  // trim strip
   box{<-19.99,3.975,-6.2><19.99,4,6.2> texture{Bright_Bronze}}  // trim strip
   triangle{<-20.2,4,-6.2><-20.2,8,0><20.2,8,0> texture{RoofText}}
   triangle{<-20.2,4,-6.2><20.2,8,0><20.2,4,-6.2> texture{RoofText}}
   triangle{<-20.2,4,6.2><-20.2,8,0><20.2,8,0> texture{RoofText}}
   triangle{<-20.2,4,6.2><20.2,8,0><20.2,4,6.2> texture{RoofText}}
}
#declare Admin_Wing=union{
    object{Admin_Wing_A}
     #declare Count=-18
     #while (Count<=18)
        cylinder{<Count,0,-6><Count,.2,-6> 0.25 texture{White_Stone}}     // base
        cone{<Count,.2,-6>0.2 <Count,3.5,-6> 0.18 texture{T_Stone8}}   // column
        cylinder{<Count,3.5,-6><Count,3.7,-6> 0.25 texture{White_Stone}}     // top
        cylinder{<Count,3.7,-6><Count,4,-6> 0.3 texture{White_Stone}}     // top
        #declare Count=Count+4
     #end
     #declare Count=-16
     #while (Count<=16)
        object{ArchTopDoor rotate<0,90,0> translate<Count,1.95,-5.75> texture{T_Stone8}}  // add arch
 //       triangle{<Count,4.1,-6.2><Count,8.1,0><Count,4.1,6.2> texture{RoofText}}
        #declare Count=Count+4
     #end
     #declare Count=-19
     #while (Count<=19)
 //       object{ArchTopDoor rotate<0,90,0> translate<Count,1.95,-5.75> texture{T_Stone8}}  // add arch
        triangle{<Count,4.1,-6.2><Count,8.1,0><Count,4.1,6.2> texture{RoofText}}
        #declare Count=Count+2
     #end
     object{ArchTopDoor rotate<0,0,0> translate<19.75,1.95,-3.5> texture{T_Stone8}}  // add arch
     object{ArchTopDoor rotate<0,0,0> translate<-19.75,1.95,-3.5> texture{T_Stone8}}  // add arch
}

#ifndef(Soldiers)
  #include "statue.inc"
#end

#declare Admin_Deco=union{
   cylinder{<0,0,0>,<0,.25,0>4 texture{pigment{color White}}}
   cylinder{<0,.25><0,.50,0> 3 texture{pigment{color White}}}
   cylinder{<0,.5,0><0,.75,0> 2 texture{pigment{color White}}}
   cylinder{<0,.75,0><0,1.25,0> .75 texture{T_Stone12}}
   cylinder{<0,1.23,0><0,1.25,0> .78 texture{T_Stone12}}

   #ifndef(Soldiers)
     object{Statue scale 1.5 rotate<0,90,0> translate<0,1.25,0>}
   #end
//   cone{<0,0,0> .4 <0,6.2,0> .3 texture{T_Stone13}}
//   sphere{<0,6.5,0>.5 texture{T_Stone18}}
}

#declare Admin=union{
   object{Admin_Bottom rotate<0,90,0> translate<-28,0,0>}
   object{Admin_Top rotate<0,90,0> translate<-28,4,0>}

   object{Admin_Wing rotate<0,180,0> translate<-46,0,-28>}
   object{Admin_Wing rotate<0,0,0> translate<-46,0,28>}

   object{Admin_Deco translate<-61,0,0>}
}
#declare Admin2_Back=union{
//   box{<-15,0,-6><15,12,6> texture{White_Stone}}
  difference{
     box{<-15,0,-6><15,12,6> texture{White_Stone}}
     box{<-15.1,0,-5><15.1,2,-2> texture{White_Stone}} // main collonade
     cylinder{<-15.1,2,-3.5><15.1,2,-3.5>1.5 texture{White_Stone}} // arch'ed roof
     #declare Count=-12
     #while (Count<=12)
        box{<Count-1.5,0,-6.1><Count+1.5,2,-2.3> texture{White_Stone}}     // arches
        cylinder{<Count,2,-6.1><Count,2,-2.3> 1.5 texture{White_Stone}}
        box{<Count-.5,8,-6.1><Count+.5,10,-2.3> texture{White_Stone}}      // windows
        cylinder{<Count,10,-6.1><Count,10,-2.3> .5 texture{White_Stone}}
        #declare Count=Count+4
     #end
   }

   triangle{<-15,12,-6><-15,12,6><-15,16,0> texture{White_Stone}}
   triangle{<15,12,-6><15,12,6><15,16,0> texture{White_Stone}}

   // roof
   box{<-14.99,11.9,-6.2><14.99,12,6.2> texture{Bright_Bronze}}  // trim strip
   triangle{<-15.2,12,-6.2><-15.2,16,0><15.2,16,0> texture{RoofText}}
   triangle{<-15.2,12,-6.2><15.2,16,0><15.2,12,-6.2> texture{RoofText}}
   triangle{<-15.2,12,6.2><-15.2,16,0><15.2,16,0> texture{RoofText}}
   triangle{<-15.2,12,6.2><15.2,16,0><15.2,12,6.2> texture{RoofText}}
}

#declare Admin2=union{
   object{Admin_Wing rotate<0,0,0> translate<-46,0,25> }
   object{Admin2_Back rotate<0,90,0> translate<-28,0,10>}
}

#declare Grass1=union{
  cone{<0,0,0>.0025<0,.15,0>.001 texture{pigment{color Khaki}}}
  triangle{<0,0,-.003><0,.2,0><0,0,.003> texture{pigment{color Khaki}}}
}

#declare GrassTuft=union{
  #declare GS=seed(983)
  #declare Count=1
  #while (Count<75)
     #declare GZ=rand(GS)*.25
     #declare GX=rand(GS)*.25
     #declare GOX=rand(GS)*75
     #declare GOY=rand(GS)*360
     object{Grass1 rotate<GOX,0,0> rotate<0,GOY,0> translate<GX,0,GZ>}
     #declare Count=Count+1
  #end
}

#declare GrassStuff=union{
  #declare GS=seed(283)
  #declare Count=1
  #while (Count<35)
     #declare GZ=rand(GS)*20
     #declare GX=rand(GS)*.25
     #declare GOX=rand(GS)*75
     #declare GOY=rand(GS)*360
     object{GrassTuft rotate<GOX,0,0> rotate<0,GOY,0> translate<GX,0,GZ>}
     #declare Count=Count+1
  #end
}


//-------------------------   Actual Object Placement

object{Gate translate<0,2,-130>}
object{Wall translate<0,2,-130>}
object{Corner translate<-94,2,-94>}

object{Gate translate<0,2,130>}
object{Wall translate<0,2,130>}
object{Corner rotate<0,90,0> translate<-94,2,94>}

object{Gate rotate<0,90,0> translate<130,2,0>}
object{Wall rotate<0,90,0> translate<130,2,0>}
object{Corner rotate<0,180,0> translate<94,2,94>}

object{Gate rotate<0,90,0> translate<-130,2,0>}
object{Wall rotate<0,90,0> translate<-130,2,0>}
object{Corner rotate<0,-90,0> translate<94,2,-94>}

// Barracks placement (SW Corner)

object{Barracks translate<-75,2,-15>}
object{Barracks rotate<0,180,0> translate<-75,2,-30>}
object{Barracks translate<-75,2,-45>}
object{Barracks rotate<0,180,0> translate<-75,2,-60>}
object{Barracks translate<-75,2,-75>}
object{Barracks rotate<0,180,0> translate<-75,2,-90>}
object{Barracks translate<-75,2,-105>}
//object{Barracks translate<-75,2,-120>}
//object{Barracks translate<-75,2,-104>}

object{Workshop rotate<0,90,0> translate<-10,2,-30>}
object{Workshop rotate<0,90,0> translate<-21,2,-30>}
object{Workshop rotate<0,90,0> translate<-10,2,-80>}
object{Workshop rotate<0,90,0> translate<-21,2,-80>}

//  Barracks placement (SE Corner)

object{Barracks translate<75,2,-60>}
object{Barracks rotate<0,180,0> translate<75,2,-75>}
object{Barracks translate<75,2,-90>}
object{Barracks rotate<0,180,0> translate<75,2,-105>}

// (NE Corner)

object{Workshop2 translate<80,2,50>}

// Main Administration

box{<-20,0,-26><20,2.02,26> texture{checker texture{T_Stone8},texture{T_Stone12}}
             //pigment{checker color White,Wheat}}
      translate<24,0,0> }

#declare Count=2                                  // Curbs for IRTC View
#declare RSS=seed(930) // stone rotation seed
#while (Count<40)
  #declare RSOZ=rand(RSS)*20-10
  #declare RSOY=rand(RSS)*5-2.5
  #declare ROX=rand(RSS)*.005
  #declare ROG=rand(RSS)*.0025
  box{<-.1,-.02,.17><.1,.02,-.17> rotate<0,0,RSOZ>  rotate<0,RSOY,0>
        translate<-3+ROX,2.01,Count>
        texture{pigment{color Tan}}}                                 // curbing
  box{<-.2,-.005,-.083><.2,.005,.084> rotate<0,RSOY,0>
        translate<-2.8+ROX,2.01,Count-.0025>
        texture{pigment{color Tan}}}
  box{<-.2,-.005,-.083><.2,.005,.084> rotate<0,RSOY,0>
        translate<-2.8+ROX,2.01,Count+.17>
        texture{pigment{color Tan}}}
              
  #declare Count=Count+.35
#end

object{Admin translate<70,2,0>}

box{<-20,0,-13><20,2.02,13> texture{checker texture{T_Stone6},texture{T_Stone8}} translate<24,0,56>}
object{Admin2 translate<70,2,50>}

#ifndef(Soldiers)
// some interest.... ==================================
//#declare R1=seed(23)
//#include "..\med\mainpart.inc"
//#include "..\med\people.inc"
//#include "romsold.inc"

#include "cat.inc"
object{Mangonel translate<22,2.51,0>}
object{Man_Bucket rotate<0,0,15> translate<22,2.51,0>}


object{CenturySpear rotate<0,0,0> translate<25,2.01,8>}
object{Century rotate<0,0,0> translate<16,2.01,8>}
object{CenturySpear translate<7,2.01,8>}

object{CenturySpear rotate<0,180,0> translate<12,2.01,-8>}
object{Century rotate<0,180,0> translate<20,2.01,-8>}
object{CenturySpear rotate<0,180,0> translate<29,2.01,-8>}

object{Thurma rotate<0,-90,0> translate<0,2.01,-12>}
object{Thurma rotate<0,-90,0> translate<1,2.01,0>}
object{Thurma rotate<0,-90,0> translate<.3,2.01,12>}

//object{Wagon2Horse translate<-20,2,0>}
//object{Wagon1Horse translate<-35,2,0.3>}

//object{Caught_Gamblers rotate<0,-140,0> translate<33,2.02,19>}  // in corner
object{Caught_Gamblers rotate<0,-170,0> translate<3,2.02,22.5>}  // by horse thurmas
#end

object{GrassStuff translate<-3.25,2.04,4>}  // details
object{GrassStuff translate<3.5,2.04,4>}  // details
