
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	
 
 
global_settings { ambient_light 1.0 } 
 
// final_run = 1 includes the following :
// 
// embossed text on the stones
// 25 * 25 stones instead of 5 * 5   
//                    
  
#declare final_run = 1 ;
//#declare final_run = 0 ;    

//
// Optional rounded intersections (1 = on , 0 = off)
//
#declare rounded_intersections = 1 ;

camera
{
  location  <5.0, 12, -40.0> // position of camera <X Y Z>
  direction 2.0*z            // which way are we looking <X Y Z> & zoom
  up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <20, 0.0,  0.0> // point center of view at this point <X Y Z>
}


light_source
{
  0*x
  color red 2.0  green 2.0  blue 2.0  
  translate <-20, 20, -40>
}


//
// Modified versions of Stones.inc textures
//

//----- Translucent T_Grnt0
#declare T_Grnt0a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.306>
                    color rgbf <0.769, 0.686, 0.592, 0.792>]
    [0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.792>
                    color rgbf <0.843, 0.753, 0.718, 0.396>]
    [0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.396>
                    color rgbf <0.780, 0.667, 0.561, 0.976>]
    [0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.976>
                    color rgbf <0.741, 0.659, 0.576, 0.820>]
    [0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.820>
                    color rgbf <0.729, 0.502, 0.451, 0.306>]
   }
 }
 }

//-----Filter Creams With T_Cracks
#declare T_Grnt9a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.216   color rgbf <0.812, 0.812, 0.812, 0.835>
                    color rgbf <0.745, 0.843, 0.835, 0.847>]
    [0.216, 0.241   color rgbf <0.745, 0.843, 0.835, 0.847>
                    color rgbf <0.404, 0.337, 0.337, 0.463>]
    [0.241, 0.267   color rgbf <0.404, 0.337, 0.337, 0.463>
                    color rgbf <0.773, 0.729, 0.745, 0.622>]
    [0.267, 0.759   color rgbf <0.773, 0.729, 0.745, 0.622>
                    color rgbf <0.914, 0.843, 0.725, 0.651>]
    [0.759, 0.784   color rgbf <0.914, 0.843, 0.725, 0.651>
                    color rgbf <0.153, 0.133, 0.208, 0.437>]
    [0.784, 0.810   color rgbf <0.153, 0.133, 0.208, 0.437>
                    color rgbf <0.812, 0.812, 0.812, 0.835>]
    [0.810, 1.001   color rgbf <0.812, 0.812, 0.812, 0.835>
                    color rgbf <0.812, 0.812, 0.812, 0.835>]
   }
 }
 }

//------------- Gray Granite with white patches
#declare T_Stone8 =
texture{pigment{color White}
        finish{ambient 0.6 crand 0.06 diffuse 0.7}
}
texture{T_Grnt0a scale <.1, .1, .1> rotate <0, 0, -30>}
texture{T_Grnt9a scale <.1, .1, .1> rotate <0, 0, 40>
        finish{phong 1.0 ambient 0.2 diffuse 0.5 phong_size 90}
}

                                  
                                  
//
// Basic Building Block for the Stones
//


#declare unitbox =

                    box
                    {
                      < 0, 0, 0>  
                      < 1, 1, 1>  
                    }

//
// Cut cylinder used for rounding intersections
//

#declare cylbit =

        difference
                  {
                    cylinder { <-0.5,1.5,0>,<-0.5,1.5,1>,1}
                    cylinder { <-0.5,1.5,-0.1>,<-0.5,1.5,1.1>,0.5 }
                    plane {y,1.5}
                    plane {x,-0.5}
                 
                  }

                                               
#declare fourcyls =
        
        union {   
               object {cylbit rotate <0,0,0> translate <0,-2,0> }
               object {cylbit rotate <0,0,-90> translate <-2,1,0> }
               object {cylbit rotate <0,0,90> translate <3,0,0> }
               object {cylbit rotate <0,0,180> translate <1,3,0> }
              }
                                             
//
// Stone object definitions
//



 #if (final_run)            

        #declare cross =

           difference
                {
                 union
                        {
                        object { unitbox }
                        object { unitbox translate <1,0,0> }
                        object { unitbox translate <0,1,0> }
                        object { unitbox translate <-1,0,0> }
                        object { unitbox translate <0,-1,0> }
                        object { unitbox translate <0,-2,0> }
                        object { unitbox translate <0,-3,0> }
                        #if (rounded_intersections)
                                object { fourcyls }
                        #end        
              
                        texture {T_Stone8}
                        }
        
                union
                        {
                        text { ttf "timrom.ttf" "Here Lies the 20th Century"  .3, 0
                               pigment { White }
                               scale <0.22,0.22,1>
                               translate <-.7,.65,-0.08>
                             }
                        text { ttf "timrom.ttf" "1900-1999"  .3, 0
                               pigment { White }
                               scale <0.3,0.3,1>
                               translate <-.1,0.25,-0.05>
                             }
                        text { ttf "timrom.ttf" "R.I.P"  .3, 0
                               pigment { White }
                               scale <0.3,0.3,1>
                               translate <0.15,-0.2,-0.05>
                             }
                        }
                        
                }
        
                
#else
    
        #declare cross =
                                               
                 union
                        {
                        object { unitbox }
                        object { unitbox translate <1,0,0> }
                        object { unitbox translate <0,1,0> }
                        object { unitbox translate <-1,0,0> }
                        object { unitbox translate <0,-1,0> }
                        object { unitbox translate <0,-2,0> }
                        object { unitbox translate <0,-3,0> }
                        #if (rounded_intersections)
                                object { fourcyls }
                        #end 

                        texture {T_Stone8}
                        }
        
    
#end            

//
// Setup rows/columns of stones 
//


#if (final_run)


        #declare R1 = seed(0) ;
        #declare Rows = 25 ;
        #declare Cols = 25 ;
        #declare ColSpace = 8 ;
        #declare RowSpace = 14 ;
        #declare Row = 1 ;
        #declare Maxpert = .8 ;

#else

        #declare R1 = seed(0) ;
        #declare Rows = 5 ;
        #declare Cols = 5 ;
        #declare ColSpace = 8 ;
        #declare RowSpace = 14 ;
        #declare Row = 1 ;    
        #declare Maxpert = .8 ;
 
#end 
 
#while (Row <= Rows)
  #declare Col = 1 ;
  #while (Col <= Cols)
    object {
            cross translate < (Col-2.2)*ColSpace+rand(R1)*Maxpert, 1.5, (Row-1.5)*RowSpace+rand(R1)*Maxpert >
           }
    #declare Col = Col+1 ;
  #end

  #declare Row=Row+1 ;
#end

//
// Grassy base
//


plane { y, -1
texture {

        pigment {ForestGreen }
        normal {bump_map {tga "jademap.tga"
        bump_size 5.0
                }
                turbulence 0.5
                }
        }
        translate <0,-.4,0>

}
                                                         

//
// Foreground Stone - lying down 
//                                            
                    
                    
                                                         
                                                         
object { cross scale 4 rotate < 90,0,0 >translate <16,1,-17>   }