 brokenbridge.povր 8"`J J Px4   րlTEXTPOV3       ;|  fO                         #declare Final_Render = 1;
#declare do_Fog = 1;
//units in feet
//east is negative x
//north is positive z

#include "colors.inc"
#include "skies.inc"
#include "woods.inc"
#include "flags.inc"

#declare startx = -30;
#declare decx = 5/6;
#declare endx = -10;

#declare farx = 210;
#declare farzstart = -100;
#declare farzend = 800;
#declare farzinc = 15;
#declare fary = 0;
#declare maxradius = 20;
#declare minradius = 10;

#declare bridge_height = 20;
#declare bridge_depth = 11;
#declare bridge_support_x = .14;
#declare bridge_support_z = .2;
#declare bridge_spacing = 30;
#declare bridge_z = 40;
#declare bridge_x_off = -10;

#declare grassy_p = pigment {
	gradient y
	turbulence .5
	color_map {
		[0.0	color Tan*.7]
		[0.2	color Tan*.7]
		[1.0	color Green*.5]
	}
	scale 8
	//color Green*.5
}
#declare grassy_n = normal {
	gradient y
	turbulence .5
	normal_map {
		[0.0	ripples .5 turbulence .25 scale 1]
		[0.2	ripples .5 turbulence .25 scale 1]
		[1.0	wrinkles 2 turbulence .25 scale .2]
	}
}
#declare grassy_f = finish {
	ambient .45
}
#declare bumpy_n = normal {
	wrinkles 1
	turbulence .25
	scale .2
}
#declare bumpy_f = finish {
	ambient .5
}
#declare grass = texture {
	pigment { grassy_p }
	normal { grassy_n }
	finish { grassy_f }
}
#declare grassybump = texture {
	pigment { grassy_p }
	normal { bumpy_n }
	finish { bumpy_f }
}

//the camera
camera {
	//this side
//	location <-30,10,-20>
//	look_at <0,1,0>
	location <-30,10,-25>
	look_at <0,1,0>

#if (Final_Render > 0)
	aperture .4
	blur_samples 40
	focal_point <2*bridge_spacing+bridge_x_off,0,bridge_z>
	confidence .992
	variance 1/256
#end

	//close up on bridge supports
/*	location <bridge_spacing-bridge_x_off-10,12,bridge_z-10>
	look_at <bridge_spacing-bridge_x_off-15,12,bridge_z>
*/	
	//the other side
/*	location <farx-40, 12, -20>
	look_at <farx-30,0,0>
*/
}


//the morning sunlight
light_source {
	<-100,500,-75>,
	color White
}


//the skylight (no shadows)
light_source {
	<-30,12,-25>
	color White*.25
	shadowless
}
light_source {
	<30,12,250>
	color White*.25
	shadowless
}

//the sky (modified from skies.inc)

#declare P_Cloud2 = pigment {
	wrinkles
	turbulence 0.65
	octaves 6
	omega 0.7
	lambda 2
	color_map {
		[0.0, 0.1	color red 0.85 green 0.85 blue 0.85
					color red 0.75 green 0.75 blue 0.75]
		[0.1, 0.5	color red 0.75 green 0.75 blue 0.75
                    color rgb <0.258, 0.258, 0.435>  ]
		[0.5, 1.001 color rgb <0.258, 0.258, 0.435>
					color rgb <0.258, 0.258, 0.435> ]
	}
	scale <6, 1, 6>
}
#declare P_Cloud3 = pigment {
	bozo
	color_map {
		[0.0, 0.1	color red 0.85 green 0.85 blue 0.85
					color red 0.55 green 0.60 blue 0.65]
		[0.1, 0.5	color red 0.55 green 0.60 blue 0.65
					color rgb <0.184, 0.184, 0.309> ]
		[0.5, 1.001	color rgb <0.184, 0.184, 0.309>
					color rgb <0.1, 0.1, 0.2>]
	}
	turbulence 0.65
	octaves 6
	omega 0.707
	lambda 2
	scale <6, 4, 6>
}


sky_sphere {
	pigment {
		gradient y
		pigment_map {
			[0.01 rgb <0.847, 0.749, 0.747> ] // horizon
			[0.25 P_Cloud2 scale 0.25 rotate z*5]
			[0.60 P_Cloud3 scale <0.25, 0.15, 0.25> rotate z*10]
		}
	}
}

//the bridge
//the mounds
#declare mound_rand = seed(55);
#macro make_mound(mound_diameter)
	blob {
		threshold .5
		sphere {
			<0,0,0>,mound_diameter
			strength 1
		}
		#declare bump_count = 20;
		#while (bump_count > 0)
			sphere {
				<0,mound_diameter*(1-.2-rand(mound_rand)/4),0>,mound_diameter*(.5+rand(mound_rand)/2)/4
				#if (rand(mound_rand) > .5)
					strength rand(mound_rand)/2
				#else
					strength -(rand(mound_rand)/2)
				#end
				rotate <rand(mound_rand)*180-90,rand(mound_rand)*180-90,rand(mound_rand)*180-90>
			}
			#declare bump_count = bump_count - 1;
		#end
		
		scale <.8,.2+rand(mound_rand)/20,.8>
	}
#end

//the supports
#declare beam_wood = texture {
	T_Wood1
	rotate <90,0,0>
}

#declare bridge_bricks = texture {
	pigment {
		brick Gray80, Red*.9
	}
	normal {
		brick
	}
	scale .01*bridge_height
}
#declare bridge_soot = texture {
	pigment {
		bozo
		color_map {
			[0.0	color Gray50 filter .5]
			[0.5	color White transmit 1]
			[1.0	color White transmit 1]
		}
	}
	scale .1*bridge_height
}
#declare support_slope = 4;
#declare bridge_support = intersection {
	plane { y,0
		texture { bridge_bricks }
		texture { bridge_soot }
		inverse
	}
	plane { y,bridge_height
		texture { bridge_bricks }
		texture { bridge_soot }
	}
	
	plane { x,bridge_support_x *bridge_height
		texture { bridge_bricks }
		texture { bridge_soot }
		rotate <0,0,support_slope>
	}
	plane { x, -bridge_support_x *bridge_height
		texture { bridge_bricks }
		texture { bridge_soot }
		rotate <0,0,-support_slope>
		inverse
	}

	plane { z, bridge_support_z *bridge_height
		texture { bridge_bricks }
		texture { bridge_soot }
		rotate <-support_slope,0,0>
	}
	plane { z, -bridge_support_z *bridge_height
		texture { bridge_bricks }
		texture { bridge_soot }
		rotate <support_slope, 0, 0>
		inverse
	}
	bounded_by {
		box {
			<-bridge_height* bridge_support_x,0,-bridge_support_z *bridge_height>,
			<bridge_height* bridge_support_x,bridge_height,bridge_support_z *bridge_height>
		}
	}
}


#declare lacing_height = 5;
#declare lacing_x_count = 9;
#declare lacing_width = .8;
#declare lacing_base = bridge_height-bridge_depth;
#declare vertical_lace = box {
	<-lacing_width/5,0,-lacing_width/3>,
	<lacing_width/5,lacing_height,lacing_width/3>
	texture { beam_wood }
}

//the diagonal lacing
#declare lacingxwidth = bridge_spacing/lacing_x_count;
#declare beamlength = sqrt(lacing_height*lacing_height+lacingxwidth*lacingxwidth);
#declare beamangle = 90-degrees(asin(lacing_height/beamlength));
#declare diagonal_beam = box {
	<-lacing_width/5,0,-lacing_width/3>,
	<lacing_width/5,beamlength,lacing_width/3>
	texture { beam_wood }
	rotate <0,0,beamangle>
}
#declare diagonal_x = union {
	object { diagonal_beam
	}
	object { diagonal_beam
		scale <-1,1,1>
		translate <-lacingxwidth,0,0>
	}
}
#declare bridge_lacing = union {
	object { vertical_lace
		translate <0,lacing_base,0>
	}
	#declare current_lace = 1;
	#while (current_lace <= lacing_x_count)
		object { diagonal_x
			translate <current_lace*lacingxwidth,lacing_base,0>
		}
		#declare current_lace = current_lace + 1;
	#end
}
#declare top_width = bridge_height*bridge_support_z*.57;
#declare plank_rand = seed(23);
#macro make_flooring(flooring_base)
union {
	#declare current_plank = 1;
	#declare current_length = 0;
	#while (current_length <= bridge_spacing)
		#declare plank_width = 1+rand(plank_rand)/4-.125;
		#declare plank_spacer = rand(plank_rand)/5+.02;
		#if (current_length+plank_width <= bridge_spacing)
			box {
				<0,0,-top_width>,<plank_width,2/12,top_width>
				translate <current_length,flooring_base,0>
				texture { beam_wood
					rotate <-90,0,0>
					translate <rand(plank_rand)*100,rand(plank_rand)*100,rand(plank_rand)*100>
				}
			}
		#end
		#declare current_length = current_length+plank_width + plank_spacer;
	#end
}
#end
#declare bridge_floor = make_flooring(lacing_base)
#declare bridge_ceiling = make_flooring(lacing_base+lacing_height)
#declare bridge_piece = union {
	object { bridge_lacing
		translate <0,0,top_width>
	}
	object { bridge_lacing
		translate <0,0,-top_width>
	}
	object { bridge_floor }
	object { bridge_ceiling }
}
#declare current_bridge = 1;
#declare mound_radius = bridge_support_z*70;
#while (current_bridge*bridge_spacing+bridge_x_off < farx-minradius)
	union {
		object { bridge_support
			translate <0,-bridge_depth,0>
		}
		#if ((current_bridge+1)*bridge_spacing+bridge_x_off < farx-minradius)
			object { bridge_piece }
		#end
		object { make_mound(mound_radius)
			texture { grass }
		}
		translate < current_bridge*bridge_spacing+bridge_x_off,0,bridge_z>
	}
	#declare current_bridge = current_bridge + 1;
#end

//a piece of broken lacing
difference {
	object { bridge_lacing }
	box { <-lacing_width,-.01,-lacing_width>,<bridge_spacing*.3,lacing_height+lacing_base+.01,lacing_width>}
	translate <0,-lacing_base-lacing_height/2,0>
	translate <-bridge_spacing*.6,0,0>
	rotate <-45,0,0>
	rotate <0,-35,0>
	translate <0,-lacing_height*.15,mound_radius*.7>
	translate <bridge_spacing+bridge_x_off,0,bridge_z>
}
difference {
	object { bridge_lacing }
	box { <-lacing_width,-.01,-lacing_width>,<bridge_spacing*.2,lacing_height+lacing_base+.01,lacing_width>}
	translate <0,-lacing_base-lacing_height/2,0>
	translate <-bridge_spacing*.6,0,0>
	rotate <-80,0,0>
	rotate <0,-90,0>
	rotate <-5,0,0>
	translate <bridge_spacing+bridge_x_off,0,bridge_z*.75>
}
union {
	object { vertical_lace
		translate <0,-lacing_height/2,0>
	}
	object { vertical_lace
		translate <0,-lacing_height/2,0>
		translate <0,0,-lacing_width/2>
		rotate <0,0,-90>
		translate <-lacing_height/2,lacing_height/6,0>
		rotate <0,90,0>
		translate <0,0,-lacing_height>
	}
	rotate <0,0,-75>
	translate <-mound_radius*.35+bridge_spacing+bridge_x_off,lacing_height*.2,bridge_z>
}
//broken lacing at the bank
difference {
	object { bridge_lacing }
	box { <-lacing_width,-.01,-lacing_width>,<bridge_spacing*.7,lacing_height+lacing_base+.1,lacing_width>}
	translate <0,-lacing_base-lacing_height/2,0>
	translate <-bridge_spacing*.6,0,0>
	rotate <60,0,0>
	rotate <0,-90,0>
	//rotate <-5,0,0>
	translate <endx+2,1,-20>
}


//flags at the bank
#declare flag_wood = texture {
	beam_wood
	normal {
		gradient x
		scale .1
		turbulence .35
	}
	scale .1
}
#declare flagpole = cylinder {
	<0,.25,0>,<0,4,0>,.025
	texture {
		flag_wood
	}
}

#declare confederate_flag = union {
	object {
		make_flag(1.5,1,0.1,0.05,.1,conf_flag_pigment,<.025,.025,0>,<0,0,0>,<0,0,0>,<10,10,0>)
	}
	object { flagpole
		rotate <0,0,1>
		rotate <-6,0,0>
		translate <1.4,0,.2>
	}
	scale <1/.825,1,1>
	scale 1/2
	translate <-1,-.5,0>
}

object { confederate_flag
	scale 8
	rotate <85,45,-15>
	translate <-bridge_spacing*.6,3.405,-15>
}

#declare flagpole_top = difference {
	object { flagpole }
	box {
		<-.5,-2.5,-.5>,<.5,0,.5>
		rotate <0,0,45>
		translate <0,2.5,0>
		texture { flag_wood }
	}
	box {
		<-.5,0,-.5>,<.5,2,.5>
	}
}
#declare flagpole_bottom = intersection {
	object { flagpole }
	union {
		box {
			<-.5,-2.5,-.5>,<.5,0,.5>
			rotate <0,0,45>
			translate <0,2.5,0>
			texture { flag_wood }
		}
		box {
			<-.5,0,-.5>,<.5,2,.5>
		}
	}
}

#declare federal_flag = union {
	object {
		make_flag(1,1,0.1,0.05,.1,fed_flag_pigment,<.05,.1,0>,<0,0,0>,<140,180,0>,<4,3,0>)
	}
	object { flagpole_top
		translate <.05,-3,0>
		rotate <0,0,-2>
		rotate <6,0,0>
		translate <0,0,.05>
	}
	object { flagpole_bottom
		translate <.05,-3,0>
		rotate <0,0,32>
		rotate <-32,0,0>
		translate <-.25,-.5,-.6>
	}
	scale <1/.825,1,1>
  	scale 1/2
  	translate <-1,-.5,0>
}

object { federal_flag
	scale 8
	rotate <0,.5,0>
	rotate <83,20,-15>
	translate <-bridge_spacing*.6,3.4,-12.5>
}

//the river
plane {
	y,0
	texture {
		pigment {
			color White filter .5
		}
		normal {
			gradient x, 3
			sine_wave
			turbulence <.4,.1,0>
			scale <2,1,2>
		}
		finish {
			reflection .7
			specular 0.4
			roughness 0.2
		}

	}
	clipped_by {
		plane { x, farx}
	}

}

//the riverbed
plane {
	y,-5
	texture {
		pigment {
			color Tan*.25
		}
		normal {
			gradient x, 1
			sine_wave
			turbulence <.3,.1,0>
		}
		finish {
			ambient .5
		}
	}
	clipped_by {
		plane { x, farx}
	}
}

//the land
//the near bank
#macro makebumps(bumpcount,bumpheight,bumpthreshold,bumpx,bumpzstart,bumpzend,dropdown)
		#while (bumpcount > 0)
			#local bumpradius = rand(RB)*bumpheight;
			#local bumpy = bumpheight*rand(RB)*(1-bumpthreshold);
			#local bumpz = rand(RB)*(abs(bumpzstart)+abs(bumpzend))-bumpzend;
			sphere {
				<bumpx,bumpy-dropdown,bumpz>, bumpradius,bumpthreshold*.98
				texture { grassybump }
			}
			#local bumpcount = bumpcount - 1;
		#end
#end
#declare bthresh = .5;
blob {
	threshold bthresh
	#declare RB = seed(1);
	#declare startheight = 8;
	#declare decheight = 5/6;
	#declare startx = -30;
	#declare decx = 5/6;
	#declare endx = -10;
	#declare startz = -50;
	#declare endz = 50;
	#declare currentx = startx;
	#declare currentheight= startheight;
	#while (currentx < endx)
		//make the cylinder
		cylinder {
			< currentx,0,startz >,< currentx,0,endz >,currentheight, 1
			texture { grass }
		}
		//make the bumps
		#declare bumpcount = rand(RB)*20+20;
		makebumps(bumpcount,currentheight,bthresh,currentx,startz,endz,0)
		//make some depressions
		#declare holecount = rand(RB)*10;
		makebumps(holecount,currentheight,-bthresh*3/4,currentx,startz,endz,0)
		
		#declare currentx = currentx *decx;
		#declare currentheight = currentheight *decheight;
	#end
	#declare bumpcount = 500;
	makebumps(bumpcount,currentheight*.8,bthresh,currentx+1,startz,endz,.75)
}

//the far bank
#declare far_grass = texture {
	pigment { grassy_p scale 2}
	normal {
		wrinkles 5
		turbulence .25
		scale 10
	}
	finish { grassy_f }
}
#declare currentz = farzstart;
blob {
	threshold bthresh
	#while (currentz < farzend)
		#declare farradius1 = maxradius*rand(RB)/2+minradius;
		#declare farradius2 = maxradius*rand(RB)+minradius;
		sphere {
			<0,0,currentz>, farradius1, 1
			texture { far_grass }
		}
		sphere {
			<farradius1+rand(RB)*farradius1,0,currentz+rand(RB)*maxradius-maxradius/2>, farradius2, 1
			texture { far_grass }
		}
		#declare currentz = currentz + farzinc;
	#end
	translate <0,-5,0>
	scale <1.5,1,1>
	translate <farx,fary,0>
}


//the fog
#if (do_Fog = 1)
#if (Final_Render > 0)
	#declare minsamples = 2;
	#declare maxsamples = 12;
	#declare fogvariance = 40/1000;
	#declare fogconfidence = 0.98;
	#declare fogintervals=10;
#else
	#declare minsamples = 1;
	#declare maxsamples = 4;
	#declare fogvariance = 100/1000;
	#declare fogconfidence = 0.7;
	#declare fogintervals=4;
#end
//fog rolling up the beach
cylinder {
	<0,startz/10, 0>,<0,endz/10,0>, 1.05
	pigment {
		color rgbf <1,1,1,1>
	}
	interior {
		media {
			scattering {  1, .25*2}
			intervals fogintervals
			samples minsamples, maxsamples
			confidence fogconfidence
			variance fogvariance
			density {  
				cylindrical
				turbulence <.5,.0,.5>
				color_map {
					[-.0001 color rgb <0,0,0>]
					[0.15 color rgb <.3,.3,.3>]
					[0.4 color rgb <1,1,1>]
					[1 color rgb <1,1,1>] 
				}
			}

			density {
				bozo
				turbulence <.3,.1,.3>
				color_map {
					[0.0	color rgb <1,1,1>]
					[0.3	color rgb <1,1,1>]
					[0.6	color rgb <0,0,0>]
					[1.0	color rgb <0,0,0>]
				}
			}
		}
	}
	hollow
	rotate <-90,0,0>
	scale <20,4,10>
	rotate <0,0,-20>
	translate <endx+.4,-1.6,0>
}


box {
	<endx/8,0,farzstart/12>,<farx/8,1,farzend/12>
	pigment {
		color rgbf <1,1,1,1>
	}
	interior {
		media {
			scattering {  1, .06}
			intervals 5
			samples minsamples, maxsamples
			confidence fogconfidence
			variance fogvariance
			density {  
				gradient y
				turbulence <.3,.9,.3>
				color_map {
					[0 color rgb <1, 1, 1>]
					[0.25 color rgb <1, 1, 1>]
					[0.35 color rgb <.2,.2,.2>]
					[0.7 color rgb <0, 0, 0>]
					[1.0001 color rgb <0, 0, 0>] 
				}
			}
			density {
				bozo
				turbulence <0,0,.2>
				color_map {
					[0.0	color rgb <1,1,1>]
					[0.3	color rgb <1,1,1>]
					[0.6	color rgb <0,0,0>]
					[1.0	color rgb <0,0,0>]
				}
			}
		}
	}
	hollow
	scale <8,6,12>
}

fog {
	fog_type 1
	distance farx/2
	turbulence .7
	turb_depth .4
	color White*.3 transmit .55
}

#end


//end of fog


//the gun


//the horn


//the cannon
         8  8   f                 m40   CT   j#   m34  0 m6п   m4  	 j#dWhatRoute 1.4.3(PPC) alias x l0! N  H }A AD d  |}  x l0! N  H mA A d  |}  x l0!    l     Bridge  B  BBroken Crap    Lacing    Mounds  #  #Flags  3  3Fog  @  @Camera    X      ttxt8BIMGKONGKONTVOD     	                         >                               ?  rpza                  @ #Y  +  ^ C        d     l       8  8   fy9J    F MPSR   FPRF             6 
   p Text MarkersPOV-Ray File Prefs                                                                                                  