//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 71 textures and 2701 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 04/30/1999    (30.04.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
    finish { diffuse 0.4 ambient 0.3 specular 0.6 roughness 0.001 }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <    -58.953,     -98.306,       3.299>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <    -53.229,      21.473,      -1.292>
}

//
// *******  L I G H T S *******
//

light_source { // Arealight001
  <-64.582, 137.818, 100.000>
  color  rgb<1.000, 1.000, 1.000>
  area_light <400.000, 0.000, 0.000>, <0.000, 400.000, 0.000>, 3, 3
  adaptive 1
  jitter
}


light_source {   // Light003
  <-165.126, -106.107, 70.809>
  color rgb <1.000, 1.000, 1.000>
}


//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//
// ********  TEXTURES  *******
//

#include "americo12.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

text {   // Sign_M99
  ttf    "C:\WINDOWS\Fonts\Oldengl.ttf",
  "Emil Roijer -99",
  1.0,  // Depth
  <0.0,   0.0, 0.0> // Offset
  material {
    kyrkbordertex
  }
  scale <1.25, 1.25, 0.125>
  rotate <90.0, 0.0, -310.0>
  translate  <-72.196979, -30.04509, -3.40093>
}



union { // CSG274
  box { // Cube1566
    <-1, -1, -1>, <1, 1, 1>
    material {
      borgartaktex3
    }
    scale <9.3, 0.06, 1.8>
    rotate <59.0, 0.0, -59.810375>
    translate  <-46.284944, 74.091589, 3.1>
  }
  box { // Cube1565
    <-1, -1, -1>, <1, 1, 1>
    material {
      borgartaktex3
    }
    scale <9.3, 0.06, 1.8>
    rotate <-59.0, 0.0, -59.810375>
    translate  <-48.878042, 72.582998, 3.1>
  }
  scale 1.5
  rotate 49.394341*z
  translate  <38.322937, 123.198671, -0.800092>
}


box { // Cube1561
  <-1, -1, -1>, <1, 1, 1>
  material {
    svarttex
  }
  scale <5.0, 1.0, 3.0>
  rotate -60.0*z
  translate  <-27.479644, 57.257719, 1.0>
}


#declare CSG255 = union {
  box { // Cube1120
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 2.0, 3.0>
    translate  <-9.6, -5.0, -5.5>
  }
  box { // Cube1121
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 2.0, 3.0>
    translate  <-9.6, -5.0, 5.5>
  }
  box { // Cube1122
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 3.0>
    translate  <-5.0, -9.6, -5.5>
  }
  box { // Cube1123
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 3.0>
    translate  <-5.0, -9.6, 5.5>
  }
  box { // Cube1124
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 3.0>
    translate  <5.0, -9.6, 5.5>
  }
  material {
    glastex_2
  }
}
#declare listCSG01 = union {
  box { // Cube1125
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <-9.7, -3.1, -5.5>
  }
  box { // Cube1126
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 0.1>
    translate  <-9.7, -5.0, -8.4>
  }
  box { // Cube1127
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.2, 0.1>
    translate  <-5.0, -9.7, -2.6>
  }
  box { // Cube1128
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-3.1, -9.7, -5.5>
  }
  box { // Cube1129
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.25, 0.1>
    translate  <5.0, -9.75, -14.4>
  }
  box { // Cube1130
    <-1, -1, -1>, <1, 1, 1>
    scale <9.7, 9.7, 0.2>
    translate  -14.6*z
  }
  box { // Cube1131
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-6.9, -9.7, -5.5>
  }
  box { // Cube1132
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.2, 0.1>
    translate  <-5.0, -9.7, -8.4>
  }
  box { // Cube1133
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 0.1>
    translate  <-9.7, -5.0, -2.6>
  }
  box { // Cube1134
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 0.1>
    translate  <-9.7, -5.0, 2.6>
  }
  box { // Cube1135
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 0.1>
    translate  <-9.7, -5.0, 8.4>
  }
  box { // Cube1136
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.2, 0.1>
    translate  <-5.0, -9.7, 2.6>
  }
  box { // Cube1137
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.2, 0.1>
    translate  <-5.0, -9.7, 8.4>
  }
  box { // Cube1138
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.2, 0.1>
    translate  <5.0, -9.7, 8.4>
  }
  box { // Cube1139
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.2, 0.1>
    translate  <5.0, -9.7, 2.6>
  }
  box { // Cube1140
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-3.1, -9.7, 5.5>
  }
  box { // Cube1141
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-6.9, -9.7, 5.5>
  }
  box { // Cube1142
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <6.9, -9.7, 5.5>
  }
  box { // Cube1143
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <3.1, -9.7, 5.5>
  }
  box { // Cube1144
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <-9.7, -6.9, -5.5>
  }
  box { // Cube1145
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <-9.7, -3.1, 5.5>
  }
  box { // Cube1146
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <-9.7, -6.9, 5.5>
  }
  material {
    traeex_3
  }
}
#declare CSG256 = difference {
  box { // Cube1147
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 15.0>
  }
  box { // Cube1148
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 3.0>
    translate  <-10.0, -5.0, -5.5>
  }
  box { // Cube1149
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.0>
    translate  <-5.0, -10.0, -5.5>
  }
  box { // Cube1150
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 6.0>
    translate  <5.0, -10.0, -8.5>
  }
  box { // Cube1151
    <-1, -1, -1>, <1, 1, 1>
    scale <9.5, 9.5, 14.5>
  }
  box { // Cube1152
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 3.0>
    translate  <-10.0, -5.0, 5.5>
  }
  box { // Cube1153
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.0>
    translate  <-5.0, -10.0, 5.5>
  }
  box { // Cube1154
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.0>
    translate  <5.0, -10.0, 5.5>
  }
  box { // Cube1155
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 12.0, 5.0>
    rotate 13.0*x
    translate  <0.0, -1.0, 17.0>
  }
  material {
    hustex_2
  }
}
#declare smutsCSG01 = difference {
  box { // Cube1156
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 15.0>
  }
  box { // Cube1157
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 3.0>
    translate  <-10.0, -5.0, -5.5>
  }
  box { // Cube1158
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.0>
    translate  <-5.0, -10.0, -5.5>
  }
  box { // Cube1159
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 6.0>
    translate  <5.0, -10.0, -8.5>
  }
  box { // Cube1160
    <-1, -1, -1>, <1, 1, 1>
    scale <9.5, 9.5, 14.5>
  }
  box { // Cube1161
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 3.0>
    translate  <-10.0, -5.0, 5.5>
  }
  box { // Cube1519
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.0>
    translate  <-5.0, -10.0, 5.5>
  }
  box { // Cube1520
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.0>
    translate  <5.0, -10.0, 5.5>
  }
  box { // Cube1521
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 12.0, 5.0>
    rotate 13.0*x
    translate  <0.0, -1.0, 17.0>
  }
  material {
    smutstex
  }
  scale 1.001
}
#declare borgarhus01 = union {
  object { CSG255 }
  object { listCSG01 }
  object { CSG256 }
  object { smutsCSG01 }
  box { // Cube1522
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_3
    }
    scale <3.0, 0.2, 6.0>
    rotate 21.212563*z
    translate  <5.1, -10.5, -8.5>
  }
  box { // tak01
    <-1, -1, -1>, <1, 1, 1>
    material {
      plattex
    }
    scale <10.5, 11.0, 0.2>
    rotate 13.0*x
    translate  <0.0, 0.2, 12.2>
  }
  box { // Cube1523
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_3
    }
    scale <9.7, 9.7, 0.5>
  }
  rotate 90.0*z
  translate  <8.229155, 19.991752, 5.0>
}
#declare TransSweep016 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  24  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.789017, 0.91581>,
  <0.759559, 0.686711>,
  <0.371929, 0.710129>,
  <0.817218, 0.416538>,
  <0.355994, 0.363677>,
  <0.58117, 0.196048>,
  <0.210734, 0.280928>,
  <0.204325, -0.14162>,
  <-0.246872, 0.0956>,
  <-0.171849, -0.000771>,
  <-0.192235, -0.297295>,
  <-0.497907, -0.215751>,
  <-0.340233, -0.586407>,
  <0.186099, -0.593666>,
  <-0.369885, -0.694207>,
  <-0.614518, -0.509899>,
  <-0.76278, -0.511961>,
  <-0.78502, -0.796195>,
  <-1.0, -0.739081>,
  <-1.266872, -0.954791>,
  <-1.0, -1.0>
  rotate -x*90
  scale <2.0, 1.8, 0.1>
  rotate 90.0*y
  translate  <9.7, 5.0, -0.8>
}
#declare TransSweep017 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.668342, 0.867065>,
  <0.774747, 0.759554>,
  <0.377736, 0.785111>,
  <0.438675, 0.626246>,
  <0.339533, 0.416136>,
  <-0.178769, 0.278132>,
  <0.118641, 0.087049>,
  <0.433121, -0.613588>,
  <-0.023355, -0.030488>,
  <-0.458599, 0.026752>,
  <-0.416136, -0.336476>,
  <-0.692144, -0.593491>,
  <-1.0, -0.496>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.8, 2.0, 0.1>
  rotate 90.0*x
  translate  <-5.0, -9.7, -0.8>
}
#declare CSG250 = union {
  object { TransSweep016 }
  object { TransSweep017 }
  material {
    glastex_2
  }
}
#declare skorstenCSG01 = union {
  cylinder { // Cylndr469
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 3.0>
    rotate <-21.276442, -0.0, -0.0>
    translate  <-5.876522, 3.928305, 12.413453>
  }
  cylinder { // Cylndr470
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 3.0>
    rotate <21.92598, -18.7621, -1.526154>
    translate  <-5.0, 5.0, 10.2>
  }
  cylinder { // Cylndr471
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 3.0>
    translate  <-5.0, 5.0, 7.5>
  }
  superellipsoid { // SuperQ001
    <1.0, 2.0>
    scale 1.5
    translate  <-5.893357, 5.220814, 16.103812>
  }
  material {
    plattex
  }
}
#declare CSG253 = union {
  box { // Cube1100
    <-1, -1, -1>, <1, 1, 1>
    scale <9.7, 9.7, 0.1>
    translate  -9.5*z
  }
  box { // Cube1101
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.3, 0.2>
    translate  <5.0, -9.7, -9.5>
  }
  box { // Cube1102
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <9.7, 6.9, 0.0>
  }
  box { // Cube1103
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 2.0, 0.1>
    translate  <9.8, 5.0, -2.9>
  }
  box { // Cube1104
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.3, 0.1>
    translate  <-5.0, -9.8, -2.9>
  }
  box { // Cube1105
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-3.1, -9.7, 0.0>
  }
  box { // Cube1106
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-6.9, -9.7, 0.0>
  }
  box { // Cube1107
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.2, 0.1>
    translate  <-5.0, -9.7, 2.9>
  }
  box { // Cube1108
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 0.1>
    translate  <9.7, 5.0, 2.9>
  }
  box { // Cube1109
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <9.7, 3.1, 0.0>
  }
  material {
    traeex2_2
  }
}
#declare CSG254 = difference {
  box { // Cube1111
    <-1, -1, -1>, <1, 1, 1>
    scale 10.0
  }
  box { // Cube1112
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 6.5>
    translate  <5.0, -9.5, -3.5>
  }
  box { // Cube1113
    <-1, -1, -1>, <1, 1, 1>
    scale 9.5
  }
  box { // Cube1114
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.0>
    translate  <-5.0, -9.5, 0.0>
  }
  box { // Cube1115
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 3.0>
    translate  <9.5, 5.0, 0.0>
  }
  box { // Cube1116
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 12.0, 3.0>
    rotate 28.0*y
    translate  <7.58, 0.0, 9.37>
  }
  box { // Cube1117
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 12.0, 3.0>
    rotate -28.0*y
    translate  <-7.58, 0.0, 9.37>
  }
  material {
    hustex2_1
  }
}
#declare litethusCSG02 = union {
  object { CSG250 }
  object { skorstenCSG01 }
  object { CSG253 }
  box { // Cube1110
    <-1, -1, -1>, <1, 1, 1>
    material {
      taktex
    }
    scale <6.0, 10.0, 0.2>
    rotate 28.0*y
    translate  <5.2, 0.0, 7.3>
  }
  object { CSG254 }
  box { // Cube1118
    <-1, -1, -1>, <1, 1, 1>
    material {
      taktex
    }
    scale <6.0, 10.0, 0.2>
    rotate -28.0*y
    translate  <-5.2, 0.0, 7.3>
  }
  box { // Cube1119
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_3
    }
    scale <3.0, 0.2, 6.5>
    translate  <5.0, -9.7, -3.5>
  }
}
union { // CSG257
  object { borgarhus01 }
  object { litethusCSG02 }
  scale 0.15
  rotate -60.0*z
  translate  <-43.178708, 63.504837, -0.519533>
}


object {   // HgtFld001
  height_field {
    tga "C:\Terrain Maker\Hill2.tga"
    water_level 0.001
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    marktex
  }
  scale <100.0, 100.0, 13.0>
  translate  <-70.252683, 261.556995, 8.742392>
}




#declare CSG133 = difference {
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, -0.5, 1.0>
  }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, 0.5, 1.0>
  }
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, 0.43, 1.0>
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, 0.43, 1.0>
  }
}
#declare CSG134 = union {
  object { CSG133 }
  torus { // Torus015
    1.1, 0.2  rotate -x*90
    scale 0.5
    translate  10.0*z
  }
  torus { // Torus016
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  9.0*z
  }
  torus { // Torus017
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  2.0*z
  }
  sphere { // Sphere025
    <0,0,0>,1
    scale <1.0, 1.0, 0.2>
    translate  11.5*z
  }
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  1.0*z
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
  }
  torus { // Torus018
    1.0, 0.2  rotate -x*90
    translate  0.8*z
  }
  cone { // Cone029
    <0,0,0>, 0.5, <0,0,1>, 1.0
    rotate <180.0, 0.0, 180.0>
    translate  2.0*z
  }
  torus { // Torus019
    1.0, 0.2  rotate -x*90
    translate  0.2*z
  }
  material {
    lamptex
  }
}
union { // gatlyktaCSG01
  object { CSG134 }
  cone { // Cone030
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      lamplamptex
    }
    scale <1.0, 1.0, 1.5>
    translate  10.0*z
  }
  scale 0.25
  translate  <-32.231734, 52.526266, -2.0>
}


sphere { // himmelsphere
  <0,0,0>,1
  material {
    Carribean_Cloud_Sky
  }
  no_shadow
  scale <1000.0, 1000.0, 300.0>
  translate  -100.0*z
}


union { // kajCSG01
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    material {
      kajtex
    }
    scale <50.0, 30.0, 1.0>
    translate  <-55.0, 63.0, -3.0>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    material {
      kajtex
    }
    scale <15.0, 10.0, 1.0>
    rotate -40.0*z
    translate  <-83.138058, -19.849237, -3.0>
  }
  box { // Cube233
    <-1, -1, -1>, <1, 1, 1>
    material {
      kajtex
    }
    scale <5.0, 10.0, 1.0>
    translate  <-25.0, 34.0, -3.0>
  }
}


plane { // hav1
  z,0
  material {
    havstex
  }
  translate  -4.0*z
}




#declare RndCube004 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
// Attributes returned success!
  scale <2.5, 2.5, 1.0>
  translate  11.5*z
}
#declare RndCube005 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
// Attributes returned success!
  scale <2.5, 2.5, 1.0>
  translate  <-20.0, 0.0, 11.5>
}
#declare RndCube006 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
// Attributes returned success!
  scale <2.5, 2.5, 1.0>
  translate  <20.0, 0.0, 11.5>
}
#declare borgarskorstenCSG02 = union {
  object { RndCube004 }
  cone { // Cone018
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <1.5, 1.5, 2.0>
    rotate <180.0, 0.0, 180.0>
    translate  11.0*z
  }
  cone { // Cone019
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <1.5, 1.5, 2.0>
    rotate <180.0, 0.0, 180.0>
    translate  <20.0, 0.0, 11.0>
  }
  cone { // Cone020
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <1.5, 1.5, 2.0>
    rotate <180.0, 0.0, 180.0>
    translate  <-20.0, 0.0, 11.0>
  }
  object { RndCube005 }
  object { RndCube006 }
  material {
    svarttex
  }
}
#declare alltannatCSG02 = union {
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <0.2, 0.2, 60.0>
    rotate -90.0*y
    translate  <30.0, -10.0, -2.0>
  }
  box { // Cube766
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <0.9, 0.2, 3.0>
    translate  <-17.0, -13.0, -6.5>
  }
  box { // Cube767
    <-1, -1, -1>, <1, 1, 1>
    material {
      borgartaktex3
    }
    scale <31.0, 0.2, 6.0>
    rotate -59.0*x
    translate  <0.0, -5.0, 7.0>
  }
  box { // Cube768
    <-1, -1, -1>, <1, 1, 1>
    material {
      borgartaktex3
    }
    scale <31.0, 0.2, 6.0>
    rotate 59.0*x
    translate  <0.0, 5.0, 7.0>
  }
  box { // Cube769
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <0.9, 0.2, 3.0>
    translate  <17.0, -13.0, -6.5>
  }
  box { // Cube770
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <0.9, 0.2, 3.0>
    translate  <19.0, -13.0, -6.5>
  }
  box { // Cube771
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <1.0, 0.2, 3.0>
    translate  <-19.0, -13.0, -6.5>
  }
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <0.2, 0.2, 20.0>
    rotate -90.0*x
    translate  <-30.0, -10.0, -2.0>
  }
}
#declare foesterkarmtvaesCSG02 = union {
  box { // Cube772
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <27.0, -9.7, 2.4>
  }
  box { // Cube773
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <24.0, -9.7, 2.4>
  }
  box { // Cube774
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <21.0, -9.7, 2.4>
  }
  box { // Cube775
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <15.0, -9.7, 2.4>
  }
  box { // Cube776
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <12.0, -9.7, 2.4>
  }
  box { // Cube777
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <9.0, -9.7, 2.4>
  }
  box { // Cube778
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <6.0, -9.7, 2.4>
  }
  box { // Cube779
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <3.0, -9.7, 2.4>
  }
  box { // Cube780
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <0.0, -9.7, 2.4>
  }
  box { // Cube781
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-3.0, -9.7, 2.4>
  }
  box { // Cube782
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-6.0, -9.7, 2.4>
  }
  box { // Cube783
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-9.0, -9.7, 2.4>
  }
  box { // Cube784
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-12.0, -9.7, 2.4>
  }
  box { // Cube785
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-15.0, -9.7, 2.4>
  }
  box { // Cube786
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-21.0, -9.7, 2.4>
  }
  box { // Cube787
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-24.0, -9.7, 2.4>
  }
  box { // Cube788
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-27.0, -9.7, 2.4>
  }
}
#declare foesterkarmtvaes3CSG02 = union {
  box { // Cube789
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <27.0, -9.75, -0.4>
  }
  box { // Cube790
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <24.0, -9.75, -0.4>
  }
  box { // Cube791
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <21.0, -9.75, -0.4>
  }
  box { // Cube792
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <15.0, -9.75, -0.4>
  }
  box { // Cube793
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <12.0, -9.75, -0.4>
  }
  box { // Cube794
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <9.0, -9.75, -0.4>
  }
  box { // Cube795
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <6.0, -9.75, -0.4>
  }
  box { // Cube796
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <3.0, -9.75, -0.4>
  }
  box { // Cube797
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <0.0, -9.75, -0.4>
  }
  box { // Cube798
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-3.0, -9.75, -0.4>
  }
  box { // Cube799
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-6.0, -9.75, -0.4>
  }
  box { // Cube800
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-9.0, -9.75, -0.4>
  }
  box { // Cube801
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-12.0, -9.75, -0.4>
  }
  box { // Cube802
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-15.0, -9.75, -0.4>
  }
  box { // Cube803
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-21.0, -9.75, -0.4>
  }
  box { // Cube804
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-24.0, -9.75, -0.4>
  }
  box { // Cube805
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-27.0, -9.75, -0.4>
  }
}
#declare foesterkarmnedlodCSG02 = union {
  box { // Cube806
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <0.65, -9.7, -5.0>
  }
  box { // Cube807
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <2.35, -9.7, -5.0>
  }
  box { // Cube808
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <3.65, -9.7, -5.0>
  }
  box { // Cube809
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <5.35, -9.7, -5.0>
  }
  box { // Cube810
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <6.65, -9.7, -5.0>
  }
  box { // Cube811
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <8.35, -9.7, -5.0>
  }
  box { // Cube812
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <9.65, -9.7, -5.0>
  }
  box { // Cube813
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <11.35, -9.7, -5.0>
  }
  box { // Cube814
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <12.65, -9.7, -5.0>
  }
  box { // Cube815
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <23.35, -9.7, -5.0>
  }
  box { // Cube816
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <24.65, -9.7, -5.0>
  }
  box { // Cube817
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <26.35, -9.7, -5.0>
  }
  box { // Cube818
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <27.65, -9.7, -5.0>
  }
  box { // Cube819
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-0.65, -9.7, -5.0>
  }
  box { // Cube820
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-2.35, -9.7, -5.0>
  }
  box { // Cube821
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-3.65, -9.7, -5.0>
  }
  box { // Cube822
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-5.35, -9.7, -5.0>
  }
  box { // Cube823
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-6.65, -9.7, -5.0>
  }
  box { // Cube824
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-8.35, -9.7, -5.0>
  }
  box { // Cube825
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-9.65, -9.7, -5.0>
  }
  box { // Cube826
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-11.35, -9.7, -5.0>
  }
  box { // Cube827
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-12.65, -9.7, -5.0>
  }
  box { // Cube828
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-23.35, -9.7, -5.0>
  }
  box { // Cube829
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-24.65, -9.7, -5.0>
  }
  box { // Cube830
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-26.35, -9.7, -5.0>
  }
  box { // Cube831
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-27.65, -9.7, -5.0>
  }
}
#declare foesterkarmupplodCSG03 = union {
  box { // Cube832
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <0.65, -9.7, -5.0>
  }
  box { // Cube833
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <2.35, -9.7, -5.0>
  }
  box { // Cube834
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <3.65, -9.7, -5.0>
  }
  box { // Cube835
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <5.35, -9.7, -5.0>
  }
  box { // Cube836
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <6.65, -9.7, -5.0>
  }
  box { // Cube837
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <8.35, -9.7, -5.0>
  }
  box { // Cube838
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <9.65, -9.7, -5.0>
  }
  box { // Cube839
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <11.35, -9.7, -5.0>
  }
  box { // Cube840
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <12.65, -9.7, -5.0>
  }
  box { // Cube841
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <23.35, -9.7, -5.0>
  }
  box { // Cube842
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <24.65, -9.7, -5.0>
  }
  box { // Cube843
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <26.35, -9.7, -5.0>
  }
  box { // Cube844
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <27.65, -9.7, -5.0>
  }
  box { // Cube845
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-0.65, -9.7, -5.0>
  }
  box { // Cube846
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-2.35, -9.7, -5.0>
  }
  box { // Cube847
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-3.65, -9.7, -5.0>
  }
  box { // Cube848
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-5.35, -9.7, -5.0>
  }
  box { // Cube849
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-6.65, -9.7, -5.0>
  }
  box { // Cube850
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-8.35, -9.7, -5.0>
  }
  box { // Cube851
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-9.65, -9.7, -5.0>
  }
  box { // Cube852
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-11.35, -9.7, -5.0>
  }
  box { // Cube853
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-12.65, -9.7, -5.0>
  }
  box { // Cube854
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-23.35, -9.7, -5.0>
  }
  box { // Cube855
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-24.65, -9.7, -5.0>
  }
  box { // Cube856
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-26.35, -9.7, -5.0>
  }
  box { // Cube857
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-27.65, -9.7, -5.0>
  }
  box { // Cube858
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <14.35, -9.7, -5.0>
  }
  box { // Cube859
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <15.65, -9.7, -5.0>
  }
  box { // Cube860
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <20.35, -9.7, -5.0>
  }
  box { // Cube861
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <21.65, -9.7, -5.0>
  }
  box { // Cube862
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-14.35, -9.7, -5.0>
  }
  box { // Cube863
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-15.65, -9.7, -5.0>
  }
  box { // Cube864
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-20.35, -9.7, -5.0>
  }
  box { // Cube865
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-21.65, -9.7, -5.0>
  }
  translate  6.0*z
}
#declare foesterkarmtvaes1CSG02 = union {
  box { // Cube866
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <27.0, -9.75, -0.4>
  }
  box { // Cube867
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <24.0, -9.75, -0.4>
  }
  box { // Cube868
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <12.0, -9.75, -0.4>
  }
  box { // Cube869
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <9.0, -9.75, -0.4>
  }
  box { // Cube870
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <6.0, -9.75, -0.4>
  }
  box { // Cube871
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <3.0, -9.75, -0.4>
  }
  box { // Cube872
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <0.0, -9.75, -0.4>
  }
  box { // Cube873
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-3.0, -9.75, -0.4>
  }
  box { // Cube874
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-6.0, -9.75, -0.4>
  }
  box { // Cube875
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-9.0, -9.75, -0.4>
  }
  box { // Cube876
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-12.0, -9.75, -0.4>
  }
  box { // Cube877
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-24.0, -9.75, -0.4>
  }
  box { // Cube878
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-27.0, -9.75, -0.4>
  }
  translate  -6.0*z
}
#declare foesterkarmtvaes2CSG02 = union {
  box { // Cube879
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <27.0, -9.7, 2.4>
  }
  box { // Cube880
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <24.0, -9.7, 2.4>
  }
  box { // Cube881
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <12.0, -9.7, 2.4>
  }
  box { // Cube882
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <9.0, -9.7, 2.4>
  }
  box { // Cube883
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <6.0, -9.7, 2.4>
  }
  box { // Cube884
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <3.0, -9.7, 2.4>
  }
  box { // Cube885
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <0.0, -9.7, 2.4>
  }
  box { // Cube886
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-3.0, -9.7, 2.4>
  }
  box { // Cube887
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-6.0, -9.7, 2.4>
  }
  box { // Cube888
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-9.0, -9.7, 2.4>
  }
  box { // Cube889
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-12.0, -9.7, 2.4>
  }
  box { // Cube890
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-24.0, -9.7, 2.4>
  }
  box { // Cube891
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-27.0, -9.7, 2.4>
  }
  translate  -6.0*z
}
#declare glaslodCSG02 = union {
  box { // Cube892
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <27.0, -9.7, -2.0>
  }
  box { // Cube893
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <24.0, -9.7, -2.0>
  }
  box { // Cube894
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <12.0, -9.7, -2.0>
  }
  box { // Cube895
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <9.0, -9.7, -2.0>
  }
  box { // Cube896
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <6.0, -9.7, -2.0>
  }
  box { // Cube897
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <3.0, -9.7, -2.0>
  }
  box { // Cube898
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <0.0, -9.7, -2.0>
  }
  box { // Cube899
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-3.0, -9.7, -2.0>
  }
  box { // Cube900
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-6.0, -9.7, -2.0>
  }
  box { // Cube901
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-9.0, -9.7, -2.0>
  }
  box { // Cube902
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-12.0, -9.7, -2.0>
  }
  box { // Cube903
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-24.0, -9.7, -2.0>
  }
  box { // Cube904
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-27.0, -9.7, -2.0>
  }
  box { // Cube905
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <21.0, -9.7, 1.0>
  }
  box { // Cube906
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <15.0, -9.7, 1.0>
  }
  box { // Cube907
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-21.0, -9.7, 1.0>
  }
  box { // Cube908
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-15.0, -9.7, 1.0>
  }
}
#declare glastvaesCSG02 = union {
  box { // Cube909
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, 1.5>
  }
  box { // Cube910
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, 0.5>
  }
  box { // Cube911
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, -4.5>
  }
  box { // Cube912
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, -5.5>
  }
}
#declare glasgavellodCSG02 = union {
  box { // Cube913
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, 0.0, -2.0>
  }
  box { // Cube914
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, 3.0, -2.0>
  }
  box { // Cube915
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, 6.0, -2.0>
  }
  box { // Cube916
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, -3.0, -2.0>
  }
  box { // Cube917
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, -6.0, -2.0>
  }
  translate  0.1*x
}
#declare foesterkarmgavellodCSG02 = union {
  box { // Cube918
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 0.65, 1.0>
  }
  box { // Cube919
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 2.35, 1.0>
  }
  box { // Cube920
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 3.65, 1.0>
  }
  box { // Cube921
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 5.35, 1.0>
  }
  box { // Cube922
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 6.65, 1.0>
  }
  box { // Cube923
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -0.65, 1.0>
  }
  box { // Cube924
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -2.35, 1.0>
  }
  box { // Cube925
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -3.65, 1.0>
  }
  box { // Cube926
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -5.35, 1.0>
  }
  box { // Cube927
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -6.65, 1.0>
  }
  box { // Cube928
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 0.65, -5.0>
  }
  box { // Cube929
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 2.35, -5.0>
  }
  box { // Cube930
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 3.65, -5.0>
  }
  box { // Cube931
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 5.35, -5.0>
  }
  box { // Cube932
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 6.65, -5.0>
  }
  box { // Cube933
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -2.35, -5.0>
  }
  box { // Cube934
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -0.65, -5.0>
  }
  box { // Cube935
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -3.65, -5.0>
  }
  box { // Cube936
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -5.35, -5.0>
  }
  box { // Cube937
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -6.65, -5.0>
  }
  box { // Cube938
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 0.5>
    translate  <-29.7, -1.4, 6.0>
  }
  box { // Cube939
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 0.5>
    translate  <-29.7, 1.4, 6.0>
  }
}
#declare foesterkarmgaveltvaesCSG02 = union {
  box { // Cube940
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 0.0, 2.4>
  }
  box { // Cube941
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 3.0, 2.4>
  }
  box { // Cube942
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 6.0, 2.4>
  }
  box { // Cube943
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -3.0, 2.4>
  }
  box { // Cube944
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -6.0, 2.4>
  }
  box { // Cube945
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 0.0, -3.6>
  }
  box { // Cube946
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 3.0, -3.6>
  }
  box { // Cube947
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 6.0, -3.6>
  }
  box { // Cube948
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -3.0, -3.6>
  }
  box { // Cube949
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -6.0, -3.6>
  }
  box { // Cube950
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 0.0, -6.4>
  }
  box { // Cube951
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 3.0, -6.4>
  }
  box { // Cube952
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 6.0, -6.4>
  }
  box { // Cube953
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -3.0, -6.4>
  }
  box { // Cube954
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -6.0, -6.4>
  }
  box { // Cube955
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 0.0, -0.4>
  }
  box { // Cube956
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 3.0, -0.4>
  }
  box { // Cube957
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 6.0, -0.4>
  }
  box { // Cube958
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -3.0, -0.4>
  }
  box { // Cube959
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -6.0, -0.4>
  }
  box { // Cube960
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.5, 0.1>
    translate  <-29.75, 0.0, 5.6>
  }
  box { // Cube961
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.5, 0.1>
    translate  <-29.7, 0.0, 6.4>
  }
}
#declare gavelglastvaesCSG02 = union {
  box { // Cube962
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  1.5*z
  }
  box { // Cube963
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  0.5*z
  }
  box { // Cube964
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  -4.5*z
  }
  box { // Cube965
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  -5.5*z
  }
  translate  -29.6*x
}
#declare gavel1 = union {
  object { glasgavellodCSG02 }
  object { foesterkarmgavellodCSG02 }
  object { foesterkarmgaveltvaesCSG02 }
  object { gavelglastvaesCSG02 }
}
#declare foesterkarmCSG02 = union {
  object { foesterkarmtvaesCSG02 }
  object { foesterkarmtvaes3CSG02 }
  object { foesterkarmnedlodCSG02 }
  object { foesterkarmupplodCSG03 }
  object { foesterkarmtvaes1CSG02 }
  object { foesterkarmtvaes2CSG02 }
  object { glaslodCSG02 }
  object { glastvaesCSG02 }
  object { gavel1 }
  material {
    traeex
  }
}
#declare CSG106 = union {
  torus { // Torus011
    1.85, 0.15  rotate -x*90
    scale 1.622
    translate  <-18.0, -12.0, -3.0>
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <-21.0, -12.0, -3.0>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <-15.0, -12.0, -3.0>
  }
  material {
    bordertex01
  }
}
#declare CSG107 = union {
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <3.0, 3.0, 2.0>
    rotate -90.0*x
    translate  <-18.0, -12.0, -3.0>
  }
  sphere { // Sphere020
    <0,0,0>,1
    material {
      bordertex01
    }
    scale 3.0
    translate  <-18.0, -12.0, -3.0>
  }
  box { // Cube966
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 3.5>
    translate  <-18.0, -11.0, -6.5>
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 7.0>
    translate  <-18.0, -12.0, -10.0>
  }
  object { CSG106 }
  box { // Cube967
    <-1, -1, -1>, <1, 1, 1>
    material {
      bordertex01
    }
    scale <4.444445, 1.666667, 0.555556>
    translate  <-18.0, -11.666667, -10.555556>
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <4.444445, 4.0, 1.111111>
    translate  <-18.0, -13.333334, -11.111111>
  }
}
#declare doeroepnCSG03 = difference {
  object { CSG107 }
  box { // Cube968
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 3.0>
    translate  <-18.0, -13.0, -7.0>
  }
  material {
    hustex3
  }
  scale 0.9
  translate  <-1.8, -1.0, 0.0>
}
#declare CSG108 = union {
  box { // Cube977
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <0.0, -10.0, -5.0>
  }
  box { // Cube978
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <0.0, -10.0, 1.0>
  }
  box { // Cube979
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <3.0, -10.0, -5.0>
  }
  box { // Cube980
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <6.0, -10.0, -5.0>
  }
  box { // Cube981
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <9.0, -10.0, -5.0>
  }
  box { // Cube982
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <12.0, -10.0, -5.0>
  }
  box { // Cube983
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <24.0, -10.0, -5.0>
  }
  box { // Cube984
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <27.0, -10.0, -5.0>
  }
  box { // Cube985
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-3.0, -10.0, -5.0>
  }
  box { // Cube986
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-6.0, -10.0, -5.0>
  }
  box { // Cube987
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-9.0, -10.0, -5.0>
  }
  box { // Cube988
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-12.0, -10.0, -5.0>
  }
  box { // Cube989
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-24.0, -10.0, -5.0>
  }
  box { // Cube990
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-27.0, -10.0, -5.0>
  }
  box { // Cube991
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <3.0, -10.0, 1.0>
  }
  box { // Cube992
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <6.0, -10.0, 1.0>
  }
  box { // Cube993
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <9.0, -10.0, 1.0>
  }
  box { // Cube994
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <12.0, -10.0, 1.0>
  }
  box { // Cube995
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <15.0, -10.0, 1.0>
  }
  box { // Cube996
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <21.0, -10.0, 1.0>
  }
  box { // Cube997
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <24.0, -10.0, 1.0>
  }
  box { // Cube998
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <27.0, -10.0, 1.0>
  }
  box { // Cube999
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-3.0, -10.0, 1.0>
  }
  box { // Cube1000
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-6.0, -10.0, 1.0>
  }
  box { // Cube1001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-9.0, -10.0, 1.0>
  }
  box { // Cube1002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-12.0, -10.0, 1.0>
  }
  box { // Cube1003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-15.0, -10.0, 1.0>
  }
  box { // Cube1004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-21.0, -10.0, 1.0>
  }
  box { // Cube1005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-24.0, -10.0, 1.0>
  }
  box { // Cube1006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-27.0, -10.0, 1.0>
  }
  box { // Cube1007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 3.0, 1.0>
  }
  box { // Cube1008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 6.0, 1.0>
  }
  box { // Cube1009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -3.0, 1.0>
  }
  box { // Cube1010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -6.0, 1.0>
  }
  box { // Cube1011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 0.0, -5.0>
  }
  box { // Cube1012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 3.0, -5.0>
  }
  box { // Cube1013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 6.0, -5.0>
  }
  box { // Cube1014
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -3.0, -5.0>
  }
  box { // Cube1015
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -6.0, -5.0>
  }
  box { // Cube1016
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.5, 0.5>
    translate  <-29.75, 0.0, 6.0>
  }
  box { // Cube1017
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 0.0, 1.0>
  }
}
#declare borgargrundCSG02 = difference {
  box { // Cube969
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 10.0, 10.0>
  }
  box { // Cube970
    <-1, -1, -1>, <1, 1, 1>
    scale <29.5, 9.5, 9.5>
  }
  box { // Cube971
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.0, 6.0>
    rotate -59.0*x
    translate  <0.0, -5.4, 8.0>
  }
  box { // Cube972
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 3.5, 1.5>
    translate  <0.0, -7.2, 9.5>
  }
  box { // Cube973
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.7, 1.0>
    translate  <0.0, -9.0, 7.2>
  }
  box { // Cube974
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.0, 6.0>
    rotate 59.0*x
    translate  <0.0, 5.4, 8.0>
  }
  box { // Cube975
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 3.5, 1.5>
    translate  <0.0, 7.2, 9.5>
  }
  box { // Cube976
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.7, 1.0>
    translate  <0.0, 9.0, 7.2>
  }
  object { CSG108 }
  material {
    hustex3
  }
}
#declare CSG109 = union {
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <21.0, -12.0, -3.0>
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <15.0, -12.0, -3.0>
  }
  torus { // Torus012
    1.85, 0.15  rotate -x*90
    scale 1.622
    translate  <18.0, -12.0, -3.0>
  }
  material {
    bordertex01
  }
  translate  -36.0*x
}
#declare CSG110 = union {
  sphere { // Sphere021
    <0,0,0>,1
    scale 3.0
    translate  <-18.0, -13.0, -3.0>
  }
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    scale 3.0
    rotate -90.0*x
    translate  <-18.0, -13.0, -3.0>
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    scale <4.444445, 4.0, 1.111111>
    rotate -0.0*z
    translate  <-18.0, -13.333334, -11.111111>
  }
  box { // Cube1019
    <-1, -1, -1>, <1, 1, 1>
    scale <4.444445, 1.666667, 0.555556>
    rotate -0.0*z
    translate  <-18.0, -11.666667, -10.555556>
  }
  material {
    bordertex01
  }
  translate  1.0*y
}
#declare CSG111 = union {
  box { // Cube1018
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 3.5>
    translate  <-18.0, -11.0, -6.5>
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 7.0>
    translate  <-18.0, -12.0, -10.0>
  }
  object { CSG109 }
  object { CSG110 }
}
#declare doeroepnCSG04 = difference {
  object { CSG111 }
  box { // Cube1020
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 3.0>
    translate  <-18.0, -13.0, -7.0>
  }
  material {
    hustex3
  }
  scale 0.9
  translate  <34.2, -1.0, 0.0>
}
union { // borgarhusCSG02
  box { // gavelglastop02
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <0.1, 1.5, 0.5>
    translate  <-29.7, 0.0, 6.0>
  }
  box { // gavelglas02
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <0.1, 6.75, 4.5>
    translate  <-29.6, 0.0, -2.0>
  }
  object { borgarskorstenCSG02 }
  box { // borgarglas02
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <28.0, 0.1, 4.5>
    translate  <0.0, -9.7, -2.0>
  }
  object { alltannatCSG02 }
  object { foesterkarmCSG02 }
  object { doeroepnCSG03 }
  object { borgargrundCSG02 }
  object { doeroepnCSG04 }
  scale 0.3
  rotate -59.810375*z
  translate  <-47.581493, 73.337293, 1.0>
}


#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.03241, 2.044144, -178.183289>
  translate  <-11.0, 8.575172, 31.682788>
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.09613, 0.291702, 178.559814>
  translate  <-6.075543, 8.823844, 31.682788>
}
#declare TransSweep003 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.051514, 1.483963, -179.223679>
  translate  <-1.621355, 8.715152, 31.682788>
}
#declare TransSweep004 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.107529, 0.528687, 178.999954>
  translate  <3.21203, 8.845877, 31.682788>
}
#declare TransSweep005 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.03241, 2.044144, -178.183289>
  translate  <8.325805, 8.881286, 31.682788>
}
#declare TransSweep006 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.625168, -3.250809, 171.895752>
  translate  <13.009868, 9.011715, 31.682788>
}
#declare TransSweep007 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.03241, 2.044144, -178.183289>
  translate  <19.4125, 9.011715, 31.682788>
}
#declare TransSweep008 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.112305, 0.465256, 178.881882>
  translate  <24.505502, 8.866201, 31.682788>
}
#declare TransSweep009 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.115692, 0.421402, 178.800201>
  translate  <30.01474, 8.773311, 31.682788>
}
#declare TransSweep010 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.260956, -1.012573, 176.122299>
  translate  <34.683463, 8.744999, 31.682788>
}
#declare TransSweep011 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.848785, -4.271851, 169.939911>
  translate  <39.608446, 8.914826, 31.682788>
}
#declare TransSweep012 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.21698, -0.642441, 176.81514>
  translate  <45.892045, 8.744999, 31.682788>
}
#declare TransSweep013 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.03241, 2.044144, -178.183289>
  translate  <51.666163, 8.914826, 31.682788>
}
#declare TransSweep014 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.03241, 2.044144, -178.183289>
  translate  <57.270455, 8.914826, 31.682788>
}
#declare TransSweep015 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.522293, 0.031847>,
  <0.002123, 0.989384>,
  <-0.477707, -0.021231>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
  rotate <55.03241, 2.044144, -178.183289>
  translate  <62.874746, 8.914826, 31.682788>
}
#declare CSG099 = union {
  object { TransSweep001 }
  object { TransSweep002 }
  object { TransSweep003 }
  object { TransSweep004 }
  object { TransSweep005 }
  object { TransSweep006 }
  object { TransSweep007 }
  object { TransSweep008 }
  object { TransSweep009 }
  object { TransSweep010 }
  object { TransSweep011 }
  object { TransSweep012 }
  object { TransSweep013 }
  object { TransSweep014 }
  object { TransSweep015 }
  material {
    korstraeex
  }
}
#declare CSG100 = difference {
  box { // Cube648
    <-1, -1, -1>, <1, 1, 1>
    scale <40.75, 13.75, 7.0>
    translate  <27.0, 13.5, 25.5>
  }
  box { // Cube649
    <-1, -1, -1>, <1, 1, 1>
    scale <42.0, 10.0, 3.0>
    rotate 35.0*x
    translate  <27.0, 4.6, 30.0>
  }
  box { // Cube650
    <-1, -1, -1>, <1, 1, 1>
    scale <42.0, 3.5, 3.0>
    translate  <27.0, 0.0, 32.5>
  }
  box { // Cube651
    <-1, -1, -1>, <1, 1, 1>
    scale <42.0, 3.5, 3.0>
    translate  <27.0, 27.0, 32.5>
  }
  box { // Cube652
    <-1, -1, -1>, <1, 1, 1>
    scale <42.0, 10.0, 3.0>
    rotate -35.0*x
    translate  <27.0, 22.4, 30.0>
  }
  material {
    korshustex
  }
}
#declare korsgrundCSG01 = difference {
  box { // Cube653
    <-1, -1, -1>, <1, 1, 1>
    scale <40.75, 13.75, 9.5>
    translate  <27.0, 13.5, 9.0>
  }
  box { // Cube654
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 1.0, 8.5>
    translate  <27.0, 0.0, 9.0>
  }
  box { // Cube655
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 1.0, 4.0>
    translate  13.5*z
  }
  box { // Cube656
    <-1, -1, -1>, <1, 1, 1>
    material {
      korshustex
    }
    scale <40.0, 13.0, 9.5>
    translate  <27.0, 13.5, 9.0>
  }
  box { // Cube657
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 1.0, 4.0>
    translate  <9.0, 0.0, 13.5>
  }
  box { // Cube658
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 1.0, 4.0>
    translate  <45.0, 0.0, 13.5>
  }
  box { // Cube659
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 1.0, 4.0>
    translate  <54.0, 0.0, 13.5>
  }
  material {
    korshustex
  }
}
#declare kortsidfasadCSG01 = union {
  box { // Cube660
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -45.0*x
    translate  <-13.5, 4.5, 4.5>
  }
  box { // Cube661
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 13.5, 0.5>
    translate  <-13.5, 13.5, 9.0>
  }
  box { // Cube662
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 15.0>
    translate  <-13.5, 9.0, 14.5>
  }
  box { // Cube663
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 15.0>
    translate  <-13.5, 18.0, 14.5>
  }
  box { // Cube664
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 11.5>
    translate  <-13.5, 27.0, 11.0>
  }
  box { // Cube665
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate 45.0*x
    translate  <-13.5, 13.5, 4.5>
  }
  box { // Cube666
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -45.0*x
    translate  <-13.5, 22.5, 4.5>
  }
  box { // Cube667
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate 45.0*x
    translate  <-13.5, 4.5, 13.5>
  }
  box { // Cube668
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate 45.0*x
    translate  <-13.5, 13.5, 13.5>
  }
  box { // Cube669
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate 45.0*x
    translate  <-13.5, 22.5, 13.5>
  }
  box { // Cube670
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 13.5, 0.5>
    translate  <-13.5, 13.5, 0.0>
  }
  box { // Cube671
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 13.5, 0.5>
    translate  <-13.5, 13.5, 18.0>
  }
  material {
    korstraeex
  }
}
#declare fasadCSG01 = union {
  box { // Cube672
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -45.0*y
    translate  4.5*z
  }
  box { // Cube673
    <-1, -1, -1>, <1, 1, 1>
    scale <18.5, 0.5, 0.5>
    translate  <4.5, 0.0, 9.0>
  }
  box { // Cube674
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 11.5>
    translate  <-13.5, 0.0, 11.0>
  }
  box { // Cube675
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 11.5>
    translate  <4.5, 0.0, 11.0>
  }
  box { // Cube676
    <-1, -1, -1>, <1, 1, 1>
    scale <41.0, 0.5, 0.5>
    translate  27.0*x
  }
  box { // Cube677
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 11.5>
    translate  <13.5, 0.0, 11.0>
  }
  box { // Cube678
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 11.5>
    translate  <22.5, 0.0, 11.0>
  }
  box { // Cube679
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -45.0*y
    translate  <9.0, 0.0, 4.5>
  }
  box { // Cube680
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate 45.0*y
    translate  <18.0, 0.0, 4.5>
  }
  box { // Cube681
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 11.5>
    translate  <-4.5, 0.0, 11.0>
  }
  box { // Cube682
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate 45.0*y
    translate  <-9.0, 0.0, 4.5>
  }
  box { // Cube683
    <-1, -1, -1>, <1, 1, 1>
    scale <18.5, 0.5, 0.5>
    translate  <49.5, 0.0, 9.0>
  }
  box { // Cube684
    <-1, -1, -1>, <1, 1, 1>
    scale <41.0, 0.5, 0.5>
    translate  <27.0, 0.0, 18.0>
  }
  box { // Cube685
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -45.0*y
    translate  <-9.0, 0.0, 13.5>
  }
  box { // Cube686
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 11.5>
    translate  <31.5, 0.0, 11.0>
  }
  box { // Cube687
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 11.5>
    translate  <40.5, 0.0, 11.0>
  }
  box { // Cube688
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 11.5>
    translate  <49.5, 0.0, 11.0>
  }
  box { // Cube689
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 11.5>
    translate  <58.5, 0.0, 11.0>
  }
  box { // Cube690
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 11.5>
    translate  <67.5, 0.0, 11.0>
  }
  box { // Cube691
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate 45.0*y
    translate  <36.0, 0.0, 4.5>
  }
  box { // Cube692
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate 45.0*y
    translate  <63.0, 0.0, 4.5>
  }
  box { // Cube693
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -45.0*y
    translate  <45.0, 0.0, 4.5>
  }
  box { // Cube694
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -45.0*y
    translate  <54.0, 0.0, 4.5>
  }
  box { // Cube695
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -45.0*y
    translate  <18.0, 0.0, 13.5>
  }
  box { // Cube696
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -45.0*y
    translate  <36.0, 0.0, 13.5>
  }
  box { // Cube697
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 6.0>
    rotate -45.0*y
    translate  <63.0, 0.0, 13.5>
  }
  material {
    korstraeex
  }
}
union { // korsvirkeCSG01
  object { CSG099 }
  box { // Cube647
    <-1, -1, -1>, <1, 1, 1>
    material {
      korstaktex
    }
    scale <41.5, 9.4, 1.0>
    rotate 35.0*x
    translate  <27.0, 6.1, 28.0>
  }
  object { CSG100 }
  box { // korsdoer01
    <-1, -1, -1>, <1, 1, 1>
    material {
      korstraeex
    }
    scale <4.0, 0.3, 8.5>
    translate  <27.0, 0.0, 9.0>
  }
  object { korsgrundCSG01 }
  object { kortsidfasadCSG01 }
  object { fasadCSG01 }
  box { // Cube698
    <-1, -1, -1>, <1, 1, 1>
    material {
      korstaktex
    }
    scale <41.5, 9.4, 1.0>
    rotate -35.0*x
    translate  <27.0, 21.0, 28.0>
  }
  scale 0.1125
  rotate 24.057705*z
  translate  <-89.438957, 48.348341, -2.0>
}


#declare CSG014 = union {
  box { // Cube621
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 15.0, 0.5>
    rotate -40.0*x
    translate  <0.0, 115.0, 20.0>
  }
  box { // Cube622
    <-1, -1, -1>, <1, 1, 1>
    material {
      raadtaktex
    }
    scale <60.0, 15.0, 0.5>
    rotate <-40.0, 0.0, 90.0>
    translate  <-11.2, 67.0, 20.0>
  }
  box { // Cube623
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 15.0, 0.5>
    rotate 40.0*x
    translate  <0.0, 92.5, 20.0>
  }
  box { // Cube624
    <-1, -1, -1>, <1, 1, 1>
    material {
      raadtaktex
    }
    scale <60.0, 15.0, 0.5>
    rotate <-40.0, 0.0, -90.0>
    translate  <11.2, 67.0, 20.0>
  }
  material {
    raadtaktex
  }
}
#declare CSG097 = difference {
  box { // Cube625
    <-1, -1, -1>, <1, 1, 1>
    scale <39.0, 20.0, 24.0>
    translate  103.7*y
  }
  box { // Cube626
    <-1, -1, -1>, <1, 1, 1>
    scale <41.0, 12.0, 6.0>
    rotate 40.0*x
    translate  <0.0, 86.5, 22.0>
  }
  box { // Cube627
    <-1, -1, -1>, <1, 1, 1>
    scale <41.0, 12.0, 6.0>
    rotate -40.0*x
    translate  <0.0, 120.5, 22.0>
  }
}
#declare CSG34 = difference {
  box { // Cube628
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 60.0, 24.0>
    translate  67.0*y
  }
  box { // Cube629
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 65.0, 6.0>
    rotate 40.0*y
    translate  <18.8, 67.0, 21.0>
  }
  box { // Cube630
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 65.0, 6.0>
    rotate -40.0*y
    translate  <-18.8, 67.0, 21.0>
  }
  material {
    kyrktex
  }
}
#declare kyrkskeppsgrundCSG01 = union {
  object { CSG097 }
  object { CSG34 }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    material {
      raadtaktex
    }
    scale <1.0, 1.0, 120.0>
    rotate -90.0*x
    translate  <0.0, 7.0, 29.3>
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    material {
      raadtaktex
    }
    scale <1.0, 1.0, 80.0>
    rotate -90.0*y
    translate  <40.0, 103.75, 29.3>
  }
  box { // Cube631
    <-1, -1, -1>, <1, 1, 1>
    scale <39.0, 4.0, 4.0>
    rotate -45.0*x
    translate  <0.0, 103.75, 24.0>
  }
  material {
    kyrktex
  }
}
#declare kyrksidogrejCSG01 = union {
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 64.0>
    translate  <7.0, -3.5, -24.0>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 58.0>
    translate  <8.0, -3.5, -24.0>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 53.0>
    translate  <9.0, -3.5, -24.0>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 47.0>
    translate  <10.0, -3.5, -24.0>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 43.0>
    translate  <11.0, -3.5, -24.0>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 39.0>
    translate  <12.0, -3.5, -24.0>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 36.0>
    translate  <13.0, -3.5, -24.0>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 33.0>
    translate  <14.0, -3.5, -24.0>
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 30.0>
    translate  <15.0, -3.5, -24.0>
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 27.0>
    translate  <16.0, -3.5, -24.0>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 24.0>
    translate  <17.0, -3.5, -24.0>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 21.0>
    translate  <18.0, -3.5, -24.0>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 18.0>
    translate  <19.0, -3.5, -24.0>
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 15.0>
    translate  <20.0, -3.5, -24.0>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.0>
    translate  <21.0, -3.5, -24.0>
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 11.0>
    translate  <22.0, -3.5, -24.0>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    translate  <23.0, -3.5, -24.0>
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.0>
    translate  <14.0, -3.5, -24.0>
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.0>
    translate  <24.0, -3.5, -24.0>
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 5.0>
    translate  <25.0, -3.5, -24.0>
  }
  material {
    kyrktex
  }
}
#declare CSG098 = union {
  box { // Cube632
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 39.5>
    translate  <7.0, 7.0, 15.5>
  }
  box { // Cube633
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 39.5>
    translate  <-7.0, 7.0, 15.5>
  }
  box { // Cube634
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 39.5>
    translate  <7.0, -7.0, 15.5>
  }
  box { // Cube635
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 39.5>
    translate  <-7.0, -7.0, 15.5>
  }
  material {
    kyrktex
  }
}
#declare kyrkcirkelborderCSG01 = difference {
  box { // Cube636
    <-1, -1, -1>, <1, 1, 1>
    scale <7.25, 7.25, 1.5>
    translate  53.5*z
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*y
    translate  <8.0, 0.0, 52.0>
  }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*y
    translate  <8.0, 2.8, 52.0>
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*y
    translate  <8.0, 5.6, 52.0>
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*y
    translate  <8.0, -2.8, 52.0>
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*y
    translate  <8.0, -5.6, 52.0>
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*x
    translate  <0.0, -8.0, 52.0>
  }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*x
    translate  <-2.8, -8.0, 52.0>
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*x
    translate  <-5.6, -8.0, 52.0>
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*x
    translate  <2.8, -8.0, 52.0>
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*x
    translate  <5.6, -8.0, 52.0>
  }
  material {
    kyrktex
  }
}
#declare kyrkborderCSG01 = union {
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*x
    translate  <7.0, -7.0, 55.0>
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*x
    translate  <-7.0, -7.0, 55.0>
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*y
    translate  <7.0, -7.0, 55.0>
  }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*y
    translate  <7.0, 7.0, 55.0>
  }
  material {
    kyrktex
  }
}
#declare korsCSG01 = union {
  box { // Cube637
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.3, 0.7>
    translate  73.0*z
  }
  box { // Cube638
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 0.3, 3.0>
    translate  72.0*z
  }
  material {
    kyrkbordertex
  }
  translate  -1.0*z
}
#declare kyrkborderCSG02 = union {
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*y
    translate  <7.0, -7.0, 40.0>
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*y
    translate  <7.0, 7.0, 40.0>
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*x
    translate  <7.0, -7.0, 40.0>
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*x
    translate  <-7.0, -7.0, 40.0>
  }
  material {
    kyrktex
  }
}
#declare kyrkgrundCSG01 = difference {
  box { // Cube639
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 7.0, 47.0>
    translate  23.0*z
  }
  box { // Cube640
    <-1, -1, -1>, <1, 1, 1>
    material {
      raadtaktex
    }
    scale <10.0, 10.0, 12.0>
    rotate 25.0*x
    translate  <0.0, 13.4, 65.0>
  }
  box { // Cube641
    <-1, -1, -1>, <1, 1, 1>
    material {
      raadtaktex
    }
    scale <10.0, 10.0, 12.0>
    rotate -25.0*x
    translate  <0.0, -13.4, 65.0>
  }
  box { // Cube642
    <-1, -1, -1>, <1, 1, 1>
    material {
      raadtaktex
    }
    scale <10.0, 10.0, 12.0>
    rotate <-25.0, 0.0, -90.0>
    translate  <-13.4, 0.0, 65.0>
  }
  box { // Cube643
    <-1, -1, -1>, <1, 1, 1>
    material {
      raadtaktex
    }
    scale <10.0, 10.0, 12.0>
    rotate <25.0, 0.0, -90.0>
    translate  <13.4, 0.0, 65.0>
  }
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 62.0>
    translate  <0.0, -7.0, -24.0>
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 62.0>
    translate  <2.0, -7.0, -24.0>
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 62.0>
    translate  <4.0, -7.0, -24.0>
  }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 62.0>
    translate  <-2.0, -7.0, -24.0>
  }
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 62.0>
    translate  <-4.0, -7.0, -24.0>
  }
  material {
    kyrktex
  }
}
#declare kyrkcirkelborderCSG02 = difference {
  box { // Cube644
    <-1, -1, -1>, <1, 1, 1>
    scale <7.25, 7.25, 1.5>
    translate  53.5*z
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*y
    translate  <8.0, 0.0, 52.0>
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*y
    translate  <8.0, 2.8, 52.0>
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*y
    translate  <8.0, 5.6, 52.0>
  }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*y
    translate  <8.0, -2.8, 52.0>
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*y
    translate  <8.0, -5.6, 52.0>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*x
    translate  <0.0, -8.0, 52.0>
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*x
    translate  <-2.8, -8.0, 52.0>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*x
    translate  <-5.6, -8.0, 52.0>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*x
    translate  <2.8, -8.0, 52.0>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    scale <1.4, 1.4, 16.0>
    rotate -90.0*x
    translate  <5.6, -8.0, 52.0>
  }
  material {
    kyrktex
  }
  rotate <180.0, 0.0, 180.0>
  translate  95.0*z
}
#declare kyrksidogrejCSG02 = union {
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 64.0>
    translate  <7.0, -3.5, -24.0>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 58.0>
    translate  <8.0, -3.5, -24.0>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 53.0>
    translate  <9.0, -3.5, -24.0>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 47.0>
    translate  <10.0, -3.5, -24.0>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 43.0>
    translate  <11.0, -3.5, -24.0>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 39.0>
    translate  <12.0, -3.5, -24.0>
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 36.0>
    translate  <13.0, -3.5, -24.0>
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 33.0>
    translate  <14.0, -3.5, -24.0>
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 30.0>
    translate  <15.0, -3.5, -24.0>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 27.0>
    translate  <16.0, -3.5, -24.0>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 24.0>
    translate  <17.0, -3.5, -24.0>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 21.0>
    translate  <18.0, -3.5, -24.0>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 18.0>
    translate  <19.0, -3.5, -24.0>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 15.0>
    translate  <20.0, -3.5, -24.0>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.0>
    translate  <21.0, -3.5, -24.0>
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 11.0>
    translate  <22.0, -3.5, -24.0>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    translate  <23.0, -3.5, -24.0>
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.0>
    translate  <14.0, -3.5, -24.0>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.0>
    translate  <24.0, -3.5, -24.0>
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 5.0>
    translate  <25.0, -3.5, -24.0>
  }
  material {
    kyrktex
  }
  translate  7.0*y
}
#declare kyrksidogrejCSG03 = union {
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 64.0>
    translate  <7.0, -3.5, -24.0>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 58.0>
    translate  <8.0, -3.5, -24.0>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 53.0>
    translate  <9.0, -3.5, -24.0>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 47.0>
    translate  <10.0, -3.5, -24.0>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 43.0>
    translate  <11.0, -3.5, -24.0>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 39.0>
    translate  <12.0, -3.5, -24.0>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 36.0>
    translate  <13.0, -3.5, -24.0>
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 33.0>
    translate  <14.0, -3.5, -24.0>
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 30.0>
    translate  <15.0, -3.5, -24.0>
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 27.0>
    translate  <16.0, -3.5, -24.0>
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 24.0>
    translate  <17.0, -3.5, -24.0>
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 21.0>
    translate  <18.0, -3.5, -24.0>
  }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 18.0>
    translate  <19.0, -3.5, -24.0>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 15.0>
    translate  <20.0, -3.5, -24.0>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.0>
    translate  <21.0, -3.5, -24.0>
  }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 11.0>
    translate  <22.0, -3.5, -24.0>
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    translate  <23.0, -3.5, -24.0>
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.0>
    translate  <14.0, -3.5, -24.0>
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.0>
    translate  <24.0, -3.5, -24.0>
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 5.0>
    translate  <25.0, -3.5, -24.0>
  }
  material {
    kyrktex
  }
  rotate 180.0*z
}
#declare kyrksidogrejCSG04 = union {
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 64.0>
    translate  <7.0, -3.5, -24.0>
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 58.0>
    translate  <8.0, -3.5, -24.0>
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 53.0>
    translate  <9.0, -3.5, -24.0>
  }
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 47.0>
    translate  <10.0, -3.5, -24.0>
  }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 43.0>
    translate  <11.0, -3.5, -24.0>
  }
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 39.0>
    translate  <12.0, -3.5, -24.0>
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 36.0>
    translate  <13.0, -3.5, -24.0>
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 33.0>
    translate  <14.0, -3.5, -24.0>
  }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 30.0>
    translate  <15.0, -3.5, -24.0>
  }
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 27.0>
    translate  <16.0, -3.5, -24.0>
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 24.0>
    translate  <17.0, -3.5, -24.0>
  }
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 21.0>
    translate  <18.0, -3.5, -24.0>
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 18.0>
    translate  <19.0, -3.5, -24.0>
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 15.0>
    translate  <20.0, -3.5, -24.0>
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.0>
    translate  <21.0, -3.5, -24.0>
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 11.0>
    translate  <22.0, -3.5, -24.0>
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    translate  <23.0, -3.5, -24.0>
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.0>
    translate  <14.0, -3.5, -24.0>
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.0>
    translate  <24.0, -3.5, -24.0>
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 5.0>
    translate  <25.0, -3.5, -24.0>
  }
  material {
    kyrktex
  }
  rotate 180.0*z
  translate  -7.0*y
}
#declare kyrkborderCSG03 = union {
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*y
    translate  <7.0, -7.0, 40.0>
  }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*y
    translate  <7.0, 7.0, 40.0>
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*x
    translate  <7.0, -7.0, 40.0>
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 14.0>
    rotate -90.0*x
    translate  <-7.0, -7.0, 40.0>
  }
  material {
    kyrktex
  }
  translate  -15.0*z
}
#declare korsCSG02 = union {
  box { // Cube645
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.3, 0.7>
    translate  73.0*z
  }
  box { // Cube646
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 0.3, 3.0>
    translate  72.0*z
  }
  material {
    kyrkbordertex
  }
  scale 1.5
  translate  <0.0, 103.75, -75.0>
}
union { // cathedralCSG01
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    material {
      kyrktex
    }
    scale <20.0, 20.0, 19.0>
    translate  <0.0, 127.0, -24.0>
  }
  sphere { // Sphere019
    <0,0,0>,1
    material {
      kyrktex
    }
    scale 20.0
    translate  <0.0, 127.0, -5.0>
  }
  object { CSG014 }
  object { kyrkskeppsgrundCSG01 }
  object { kyrksidogrejCSG01 }
  object { CSG098 }
  object { kyrkcirkelborderCSG01 }
  object { kyrkborderCSG01 }
  object { korsCSG01 }
  object { kyrkborderCSG02 }
  object { kyrkgrundCSG01 }
  object { kyrkcirkelborderCSG02 }
  object { kyrksidogrejCSG02 }
  object { kyrksidogrejCSG03 }
  object { kyrksidogrejCSG04 }
  object { kyrkborderCSG03 }
  object { korsCSG02 }
  scale 0.25
  rotate -10.0*z
  translate  <-89.93722, 99.512207, 2.0>
}


#declare CSG012 = union {
  box { // Cube573
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.0, 6.0>
    translate  <-13.25, -8.5, 6.0>
  }
  box { // Cube574
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 1.0, 0.5>
    translate  <-10.0, -8.5, 12.5>
  }
  box { // Cube575
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_1
    }
    scale <3.0, 0.5, 6.0>
    translate  <-10.0, -8.0, 6.0>
  }
  box { // Cube576
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.0, 6.0>
    translate  <-6.75, -8.5, 6.0>
  }
  material {
    gaardshustex
  }
}
#declare gaardsfoesterlistCSG02 = union {
  box { // Cube577
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, -4.0, 6.1>
  }
  box { // Cube578
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <0.0, -9.75, 6.1>
  }
  box { // Cube579
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -6.4, 9.0>
  }
  box { // Cube580
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-2.4, -9.7, 9.0>
  }
  box { // Cube581
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <2.4, -9.7, 9.0>
  }
  box { // Cube582
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <7.6, -9.7, 9.0>
  }
  box { // Cube583
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <12.4, -9.7, 9.0>
  }
  box { // Cube584
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-2.4, -9.7, 21.0>
  }
  box { // Cube585
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <2.4, -9.7, 21.0>
  }
  box { // Cube586
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <7.6, -9.7, 21.0>
  }
  box { // Cube587
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <12.4, -9.7, 21.0>
  }
  box { // Cube588
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -1.6, 9.0>
  }
  box { // Cube589
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 1.6, 9.0>
  }
  box { // Cube590
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 6.4, 9.0>
  }
  box { // Cube591
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -6.4, 21.0>
  }
  box { // Cube592
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -1.6, 21.0>
  }
  box { // Cube593
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 1.6, 21.0>
  }
  box { // Cube594
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 6.4, 21.0>
  }
  box { // Cube595
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <10.0, -9.75, 6.1>
  }
  box { // Cube596
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <0.0, -9.75, 18.1>
  }
  box { // Cube597
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <10.0, -9.75, 18.1>
  }
  box { // Cube598
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <0.0, -9.7, 23.9>
  }
  box { // Cube599
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <10.0, -9.7, 23.9>
  }
  box { // Cube600
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <0.0, -9.7, 11.9>
  }
  box { // Cube601
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <10.0, -9.7, 11.9>
  }
  box { // Cube602
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, 4.0, 6.1>
  }
  box { // Cube603
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, -4.0, 18.1>
  }
  box { // Cube604
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, 4.0, 18.1>
  }
  box { // Cube605
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, -4.0, 23.9>
  }
  box { // Cube606
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, 4.0, 23.9>
  }
  box { // Cube607
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, -4.0, 11.9>
  }
  box { // Cube608
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, 4.0, 11.9>
  }
  material {
    traeex_1
  }
}
#declare CSG013 = difference {
  box { // Cube609
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 10.0, 14.0>
    translate  14.0*z
  }
  box { // Cube610
    <-1, -1, -1>, <1, 1, 1>
    scale <19.5, 9.5, 14.0>
    translate  13.5*z
  }
  box { // Cube611
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 6.0>
    translate  <-10.0, -9.75, 6.0>
  }
  box { // Cube612
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <0.0, -9.75, 9.0>
  }
  box { // Cube613
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <10.0, -9.75, 9.0>
  }
  box { // Cube614
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <0.0, -9.75, 21.0>
  }
  box { // Cube615
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <10.0, -9.75, 21.0>
  }
  box { // Cube616
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, 4.0, 9.0>
  }
  box { // Cube617
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, -4.0, 9.0>
  }
  box { // Cube618
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, 4.0, 21.0>
  }
  box { // Cube619
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, -4.0, 21.0>
  }
  box { // Cube620
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 12.0, 1.5>
    rotate 7.0*x
    translate  28.5*z
  }
  material {
    gaardshustex
  }
}
union { // gaardshusCSG02
  box { // Cube570
    <-1, -1, -1>, <1, 1, 1>
    material {
      gaardtaktex
    }
    scale <21.0, 11.0, 0.2>
    rotate 7.0*x
    translate  27.0*z
  }
  box { // Cube571
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <0.1, 7.0, 9.0>
    translate  <19.6, 0.0, 15.0>
  }
  box { // Cube572
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <8.0, 0.1, 9.0>
    translate  <5.0, -9.6, 15.0>
  }
  object { CSG012 }
  object { gaardsfoesterlistCSG02 }
  object { CSG013 }
  scale 0.15
  rotate 24.342661*z
  translate  <-89.032015, 45.236424, -2.0>
}


#declare RndCube001 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
// Attributes returned success!
  scale <2.5, 2.5, 1.0>
  translate  11.5*z
}
#declare RndCube003 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
// Attributes returned success!
  scale <2.5, 2.5, 1.0>
  translate  <-20.0, 0.0, 11.5>
}
#declare RndCube002 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
// Attributes returned success!
  scale <2.5, 2.5, 1.0>
  translate  <20.0, 0.0, 11.5>
}
#declare borgarskorstenCSG01 = union {
  object { RndCube001 }
  cone { // Cone001
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <1.5, 1.5, 2.0>
    rotate <180.0, 0.0, 180.0>
    translate  11.0*z
  }
  cone { // Cone016
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <1.5, 1.5, 2.0>
    rotate <180.0, 0.0, 180.0>
    translate  <20.0, 0.0, 11.0>
  }
  cone { // Cone017
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <1.5, 1.5, 2.0>
    rotate <180.0, 0.0, 180.0>
    translate  <-20.0, 0.0, 11.0>
  }
  object { RndCube003 }
  object { RndCube002 }
  material {
    svarttex
  }
}
#declare alltannatCSG01 = union {
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <0.2, 0.2, 60.0>
    rotate -90.0*y
    translate  <30.0, -10.0, -2.0>
  }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <0.9, 0.2, 3.0>
    translate  <-17.0, -13.0, -6.5>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    material {
      borgartaktex3
    }
    scale <31.0, 0.2, 6.0>
    rotate -59.0*x
    translate  <0.0, -5.0, 7.0>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    material {
      borgartaktex3
    }
    scale <31.0, 0.2, 6.0>
    rotate 59.0*x
    translate  <0.0, 5.0, 7.0>
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <0.9, 0.2, 3.0>
    translate  <17.0, -13.0, -6.5>
  }
  box { // Cube287
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <0.9, 0.2, 3.0>
    translate  <19.0, -13.0, -6.5>
  }
  box { // Cube288
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <1.0, 0.2, 3.0>
    translate  <-19.0, -13.0, -6.5>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <0.2, 0.2, 20.0>
    rotate -90.0*x
    translate  <-30.0, -10.0, -2.0>
  }
}
#declare foesterkarmtvaesCSG01 = union {
  box { // Cube289
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <27.0, -9.7, 2.4>
  }
  box { // Cube290
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <24.0, -9.7, 2.4>
  }
  box { // Cube291
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <21.0, -9.7, 2.4>
  }
  box { // Cube292
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <15.0, -9.7, 2.4>
  }
  box { // Cube293
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <12.0, -9.7, 2.4>
  }
  box { // Cube294
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <9.0, -9.7, 2.4>
  }
  box { // Cube295
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <6.0, -9.7, 2.4>
  }
  box { // Cube296
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <3.0, -9.7, 2.4>
  }
  box { // Cube297
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <0.0, -9.7, 2.4>
  }
  box { // Cube298
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-3.0, -9.7, 2.4>
  }
  box { // Cube299
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-6.0, -9.7, 2.4>
  }
  box { // Cube300
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-9.0, -9.7, 2.4>
  }
  box { // Cube301
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-12.0, -9.7, 2.4>
  }
  box { // Cube302
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-15.0, -9.7, 2.4>
  }
  box { // Cube303
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-21.0, -9.7, 2.4>
  }
  box { // Cube304
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-24.0, -9.7, 2.4>
  }
  box { // Cube305
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-27.0, -9.7, 2.4>
  }
}
#declare foesterkarmtvaes3CSG01 = union {
  box { // Cube306
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <27.0, -9.75, -0.4>
  }
  box { // Cube307
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <24.0, -9.75, -0.4>
  }
  box { // Cube308
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <21.0, -9.75, -0.4>
  }
  box { // Cube309
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <15.0, -9.75, -0.4>
  }
  box { // Cube310
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <12.0, -9.75, -0.4>
  }
  box { // Cube311
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <9.0, -9.75, -0.4>
  }
  box { // Cube312
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <6.0, -9.75, -0.4>
  }
  box { // Cube313
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <3.0, -9.75, -0.4>
  }
  box { // Cube314
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <0.0, -9.75, -0.4>
  }
  box { // Cube315
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-3.0, -9.75, -0.4>
  }
  box { // Cube316
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-6.0, -9.75, -0.4>
  }
  box { // Cube317
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-9.0, -9.75, -0.4>
  }
  box { // Cube318
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-12.0, -9.75, -0.4>
  }
  box { // Cube319
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-15.0, -9.75, -0.4>
  }
  box { // Cube320
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-21.0, -9.75, -0.4>
  }
  box { // Cube321
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-24.0, -9.75, -0.4>
  }
  box { // Cube322
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-27.0, -9.75, -0.4>
  }
}
#declare foesterkarmnedlodCSG01 = union {
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <0.65, -9.7, -5.0>
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <2.35, -9.7, -5.0>
  }
  box { // Cube323
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <3.65, -9.7, -5.0>
  }
  box { // Cube324
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <5.35, -9.7, -5.0>
  }
  box { // Cube325
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <6.65, -9.7, -5.0>
  }
  box { // Cube326
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <8.35, -9.7, -5.0>
  }
  box { // Cube327
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <9.65, -9.7, -5.0>
  }
  box { // Cube328
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <11.35, -9.7, -5.0>
  }
  box { // Cube329
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <12.65, -9.7, -5.0>
  }
  box { // Cube330
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <23.35, -9.7, -5.0>
  }
  box { // Cube331
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <24.65, -9.7, -5.0>
  }
  box { // Cube332
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <26.35, -9.7, -5.0>
  }
  box { // Cube333
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <27.65, -9.7, -5.0>
  }
  box { // Cube334
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-0.65, -9.7, -5.0>
  }
  box { // Cube335
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-2.35, -9.7, -5.0>
  }
  box { // Cube336
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-3.65, -9.7, -5.0>
  }
  box { // Cube337
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-5.35, -9.7, -5.0>
  }
  box { // Cube338
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-6.65, -9.7, -5.0>
  }
  box { // Cube339
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-8.35, -9.7, -5.0>
  }
  box { // Cube340
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-9.65, -9.7, -5.0>
  }
  box { // Cube341
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-11.35, -9.7, -5.0>
  }
  box { // Cube342
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-12.65, -9.7, -5.0>
  }
  box { // Cube343
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-23.35, -9.7, -5.0>
  }
  box { // Cube344
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-24.65, -9.7, -5.0>
  }
  box { // Cube345
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-26.35, -9.7, -5.0>
  }
  box { // Cube346
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-27.65, -9.7, -5.0>
  }
}
#declare foesterkarmupplodCSG02 = union {
  box { // Cube347
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <0.65, -9.7, -5.0>
  }
  box { // Cube348
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <2.35, -9.7, -5.0>
  }
  box { // Cube349
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <3.65, -9.7, -5.0>
  }
  box { // Cube350
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <5.35, -9.7, -5.0>
  }
  box { // Cube351
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <6.65, -9.7, -5.0>
  }
  box { // Cube352
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <8.35, -9.7, -5.0>
  }
  box { // Cube353
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <9.65, -9.7, -5.0>
  }
  box { // Cube354
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <11.35, -9.7, -5.0>
  }
  box { // Cube355
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <12.65, -9.7, -5.0>
  }
  box { // Cube356
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <23.35, -9.7, -5.0>
  }
  box { // Cube357
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <24.65, -9.7, -5.0>
  }
  box { // Cube358
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <26.35, -9.7, -5.0>
  }
  box { // Cube359
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <27.65, -9.7, -5.0>
  }
  box { // Cube360
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-0.65, -9.7, -5.0>
  }
  box { // Cube361
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-2.35, -9.7, -5.0>
  }
  box { // Cube362
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-3.65, -9.7, -5.0>
  }
  box { // Cube363
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-5.35, -9.7, -5.0>
  }
  box { // Cube364
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-6.65, -9.7, -5.0>
  }
  box { // Cube365
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-8.35, -9.7, -5.0>
  }
  box { // Cube366
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-9.65, -9.7, -5.0>
  }
  box { // Cube367
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-11.35, -9.7, -5.0>
  }
  box { // Cube368
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-12.65, -9.7, -5.0>
  }
  box { // Cube369
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-23.35, -9.7, -5.0>
  }
  box { // Cube370
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-24.65, -9.7, -5.0>
  }
  box { // Cube371
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-26.35, -9.7, -5.0>
  }
  box { // Cube372
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-27.65, -9.7, -5.0>
  }
  box { // Cube373
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <14.35, -9.7, -5.0>
  }
  box { // Cube374
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <15.65, -9.7, -5.0>
  }
  box { // Cube375
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <20.35, -9.7, -5.0>
  }
  box { // Cube376
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <21.65, -9.7, -5.0>
  }
  box { // Cube377
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-14.35, -9.7, -5.0>
  }
  box { // Cube378
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-15.65, -9.7, -5.0>
  }
  box { // Cube379
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-20.35, -9.7, -5.0>
  }
  box { // Cube380
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-21.65, -9.7, -5.0>
  }
  translate  6.0*z
}
#declare foesterkarmtvaes1CSG01 = union {
  box { // Cube381
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <27.0, -9.75, -0.4>
  }
  box { // Cube382
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <24.0, -9.75, -0.4>
  }
  box { // Cube383
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <12.0, -9.75, -0.4>
  }
  box { // Cube384
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <9.0, -9.75, -0.4>
  }
  box { // Cube385
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <6.0, -9.75, -0.4>
  }
  box { // Cube386
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <3.0, -9.75, -0.4>
  }
  box { // Cube387
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <0.0, -9.75, -0.4>
  }
  box { // Cube388
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-3.0, -9.75, -0.4>
  }
  box { // Cube389
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-6.0, -9.75, -0.4>
  }
  box { // Cube390
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-9.0, -9.75, -0.4>
  }
  box { // Cube391
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-12.0, -9.75, -0.4>
  }
  box { // Cube392
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-24.0, -9.75, -0.4>
  }
  box { // Cube393
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-27.0, -9.75, -0.4>
  }
  translate  -6.0*z
}
#declare foesterkarmtvaes2CSG01 = union {
  box { // Cube394
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <27.0, -9.7, 2.4>
  }
  box { // Cube395
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <24.0, -9.7, 2.4>
  }
  box { // Cube396
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <12.0, -9.7, 2.4>
  }
  box { // Cube397
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <9.0, -9.7, 2.4>
  }
  box { // Cube398
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <6.0, -9.7, 2.4>
  }
  box { // Cube399
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <3.0, -9.7, 2.4>
  }
  box { // Cube400
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <0.0, -9.7, 2.4>
  }
  box { // Cube401
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-3.0, -9.7, 2.4>
  }
  box { // Cube402
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-6.0, -9.7, 2.4>
  }
  box { // Cube403
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-9.0, -9.7, 2.4>
  }
  box { // Cube404
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-12.0, -9.7, 2.4>
  }
  box { // Cube405
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-24.0, -9.7, 2.4>
  }
  box { // Cube406
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-27.0, -9.7, 2.4>
  }
  translate  -6.0*z
}
#declare glaslodCSG01 = union {
  box { // Cube407
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <27.0, -9.7, -2.0>
  }
  box { // Cube408
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <24.0, -9.7, -2.0>
  }
  box { // Cube409
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <12.0, -9.7, -2.0>
  }
  box { // Cube410
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <9.0, -9.7, -2.0>
  }
  box { // Cube411
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <6.0, -9.7, -2.0>
  }
  box { // Cube412
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <3.0, -9.7, -2.0>
  }
  box { // Cube413
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <0.0, -9.7, -2.0>
  }
  box { // Cube414
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-3.0, -9.7, -2.0>
  }
  box { // Cube415
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-6.0, -9.7, -2.0>
  }
  box { // Cube416
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-9.0, -9.7, -2.0>
  }
  box { // Cube417
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-12.0, -9.7, -2.0>
  }
  box { // Cube418
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-24.0, -9.7, -2.0>
  }
  box { // Cube419
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-27.0, -9.7, -2.0>
  }
  box { // Cube420
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <21.0, -9.7, 1.0>
  }
  box { // Cube421
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <15.0, -9.7, 1.0>
  }
  box { // Cube422
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-21.0, -9.7, 1.0>
  }
  box { // Cube423
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-15.0, -9.7, 1.0>
  }
}
#declare glastvaesCSG01 = union {
  box { // Cube424
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, 1.5>
  }
  box { // Cube425
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, 0.5>
  }
  box { // Cube426
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, -4.5>
  }
  box { // Cube427
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, -5.5>
  }
}
#declare glasgavellodCSG01 = union {
  box { // Cube428
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, 0.0, -2.0>
  }
  box { // Cube429
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, 3.0, -2.0>
  }
  box { // Cube430
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, 6.0, -2.0>
  }
  box { // Cube431
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, -3.0, -2.0>
  }
  box { // Cube432
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, -6.0, -2.0>
  }
  translate  0.1*x
}
#declare foesterkarmgavellodCSG01 = union {
  box { // Cube433
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 0.65, 1.0>
  }
  box { // Cube434
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 2.35, 1.0>
  }
  box { // Cube435
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 3.65, 1.0>
  }
  box { // Cube436
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 5.35, 1.0>
  }
  box { // Cube437
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 6.65, 1.0>
  }
  box { // Cube438
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -0.65, 1.0>
  }
  box { // Cube439
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -2.35, 1.0>
  }
  box { // Cube440
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -3.65, 1.0>
  }
  box { // Cube441
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -5.35, 1.0>
  }
  box { // Cube442
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -6.65, 1.0>
  }
  box { // Cube443
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 0.65, -5.0>
  }
  box { // Cube444
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 2.35, -5.0>
  }
  box { // Cube445
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 3.65, -5.0>
  }
  box { // Cube446
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 5.35, -5.0>
  }
  box { // Cube447
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 6.65, -5.0>
  }
  box { // Cube448
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -2.35, -5.0>
  }
  box { // Cube449
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -0.65, -5.0>
  }
  box { // Cube450
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -3.65, -5.0>
  }
  box { // Cube451
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -5.35, -5.0>
  }
  box { // Cube452
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -6.65, -5.0>
  }
  box { // Cube453
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 0.5>
    translate  <-29.7, -1.4, 6.0>
  }
  box { // Cube454
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 0.5>
    translate  <-29.7, 1.4, 6.0>
  }
}
#declare foesterkarmgaveltvaesCSG01 = union {
  box { // Cube455
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 0.0, 2.4>
  }
  box { // Cube456
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 3.0, 2.4>
  }
  box { // Cube457
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 6.0, 2.4>
  }
  box { // Cube458
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -3.0, 2.4>
  }
  box { // Cube459
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -6.0, 2.4>
  }
  box { // Cube460
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 0.0, -3.6>
  }
  box { // Cube461
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 3.0, -3.6>
  }
  box { // Cube462
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 6.0, -3.6>
  }
  box { // Cube463
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -3.0, -3.6>
  }
  box { // Cube464
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -6.0, -3.6>
  }
  box { // Cube465
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 0.0, -6.4>
  }
  box { // Cube466
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 3.0, -6.4>
  }
  box { // Cube467
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 6.0, -6.4>
  }
  box { // Cube468
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -3.0, -6.4>
  }
  box { // Cube469
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -6.0, -6.4>
  }
  box { // Cube470
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 0.0, -0.4>
  }
  box { // Cube471
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 3.0, -0.4>
  }
  box { // Cube472
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 6.0, -0.4>
  }
  box { // Cube473
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -3.0, -0.4>
  }
  box { // Cube474
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -6.0, -0.4>
  }
  box { // Cube475
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.5, 0.1>
    translate  <-29.75, 0.0, 5.6>
  }
  box { // Cube476
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.5, 0.1>
    translate  <-29.7, 0.0, 6.4>
  }
}
#declare gavelglastvaesCSG01 = union {
  box { // Cube477
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  1.5*z
  }
  box { // Cube478
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  0.5*z
  }
  box { // Cube479
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  -4.5*z
  }
  box { // Cube480
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  -5.5*z
  }
  translate  -29.6*x
}
#declare gavel = union {
  object { glasgavellodCSG01 }
  object { foesterkarmgavellodCSG01 }
  object { foesterkarmgaveltvaesCSG01 }
  object { gavelglastvaesCSG01 }
}
#declare foesterkarmCSG01 = union {
  object { foesterkarmtvaesCSG01 }
  object { foesterkarmtvaes3CSG01 }
  object { foesterkarmnedlodCSG01 }
  object { foesterkarmupplodCSG02 }
  object { foesterkarmtvaes1CSG01 }
  object { foesterkarmtvaes2CSG01 }
  object { glaslodCSG01 }
  object { glastvaesCSG01 }
  object { gavel }
  material {
    traeex
  }
}
#declare CSG005 = union {
  torus { // Torus009
    1.85, 0.15  rotate -x*90
    scale 1.622
    translate  <-18.0, -12.0, -3.0>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <-21.0, -12.0, -3.0>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <-15.0, -12.0, -3.0>
  }
  material {
    bordertex01
  }
}
#declare CSG004 = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <3.0, 3.0, 2.0>
    rotate -90.0*x
    translate  <-18.0, -12.0, -3.0>
  }
  sphere { // Sphere017
    <0,0,0>,1
    material {
      bordertex01
    }
    scale 3.0
    translate  <-18.0, -12.0, -3.0>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 3.5>
    translate  <-18.0, -11.0, -6.5>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 7.0>
    translate  <-18.0, -12.0, -10.0>
  }
  object { CSG005 }
  box { // Cube481
    <-1, -1, -1>, <1, 1, 1>
    material {
      bordertex01
    }
    scale <4.444445, 1.666667, 0.555556>
    translate  <-18.0, -11.666667, -10.555556>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <4.444445, 4.0, 1.111111>
    translate  <-18.0, -13.333334, -11.111111>
  }
}
#declare doeroepnCSG01 = difference {
  object { CSG004 }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 3.0>
    translate  <-18.0, -13.0, -7.0>
  }
  material {
    hustex3
  }
  scale 0.9
  translate  <-1.8, -1.0, 0.0>
}
#declare CSG006 = union {
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <0.0, -10.0, -5.0>
  }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <0.0, -10.0, 1.0>
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <3.0, -10.0, -5.0>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <6.0, -10.0, -5.0>
  }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <9.0, -10.0, -5.0>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <12.0, -10.0, -5.0>
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <24.0, -10.0, -5.0>
  }
  box { // Cube482
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <27.0, -10.0, -5.0>
  }
  box { // Cube483
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-3.0, -10.0, -5.0>
  }
  box { // Cube484
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-6.0, -10.0, -5.0>
  }
  box { // Cube485
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-9.0, -10.0, -5.0>
  }
  box { // Cube486
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-12.0, -10.0, -5.0>
  }
  box { // Cube487
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-24.0, -10.0, -5.0>
  }
  box { // Cube488
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-27.0, -10.0, -5.0>
  }
  box { // Cube489
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <3.0, -10.0, 1.0>
  }
  box { // Cube490
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <6.0, -10.0, 1.0>
  }
  box { // Cube491
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <9.0, -10.0, 1.0>
  }
  box { // Cube492
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <12.0, -10.0, 1.0>
  }
  box { // Cube493
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <15.0, -10.0, 1.0>
  }
  box { // Cube494
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <21.0, -10.0, 1.0>
  }
  box { // Cube495
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <24.0, -10.0, 1.0>
  }
  box { // Cube496
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <27.0, -10.0, 1.0>
  }
  box { // Cube497
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-3.0, -10.0, 1.0>
  }
  box { // Cube498
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-6.0, -10.0, 1.0>
  }
  box { // Cube499
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-9.0, -10.0, 1.0>
  }
  box { // Cube500
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-12.0, -10.0, 1.0>
  }
  box { // Cube501
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-15.0, -10.0, 1.0>
  }
  box { // Cube502
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-21.0, -10.0, 1.0>
  }
  box { // Cube503
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-24.0, -10.0, 1.0>
  }
  box { // Cube504
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-27.0, -10.0, 1.0>
  }
  box { // Cube505
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 3.0, 1.0>
  }
  box { // Cube506
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 6.0, 1.0>
  }
  box { // Cube507
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -3.0, 1.0>
  }
  box { // Cube508
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -6.0, 1.0>
  }
  box { // Cube509
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 0.0, -5.0>
  }
  box { // Cube510
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 3.0, -5.0>
  }
  box { // Cube511
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 6.0, -5.0>
  }
  box { // Cube512
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -3.0, -5.0>
  }
  box { // Cube513
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -6.0, -5.0>
  }
  box { // Cube514
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.5, 0.5>
    translate  <-29.75, 0.0, 6.0>
  }
  box { // Cube515
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 0.0, 1.0>
  }
}
#declare borgargrundCSG01 = difference {
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 10.0, 10.0>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <29.5, 9.5, 9.5>
  }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.0, 6.0>
    rotate -59.0*x
    translate  <0.0, -5.4, 8.0>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 3.5, 1.5>
    translate  <0.0, -7.2, 9.5>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.7, 1.0>
    translate  <0.0, -9.0, 7.2>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.0, 6.0>
    rotate 59.0*x
    translate  <0.0, 5.4, 8.0>
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 3.5, 1.5>
    translate  <0.0, 7.2, 9.5>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.7, 1.0>
    translate  <0.0, 9.0, 7.2>
  }
  object { CSG006 }
  material {
    hustex3
  }
}
#declare CSG007 = union {
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <21.0, -12.0, -3.0>
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <15.0, -12.0, -3.0>
  }
  torus { // Torus010
    1.85, 0.15  rotate -x*90
    scale 1.622
    translate  <18.0, -12.0, -3.0>
  }
  material {
    bordertex01
  }
  translate  -36.0*x
}
#declare CSG008 = union {
  sphere { // Sphere018
    <0,0,0>,1
    scale 3.0
    translate  <-18.0, -13.0, -3.0>
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    scale 3.0
    rotate -90.0*x
    translate  <-18.0, -13.0, -3.0>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale <4.444445, 4.0, 1.111111>
    rotate -0.0*z
    translate  <-18.0, -13.333334, -11.111111>
  }
  box { // Cube517
    <-1, -1, -1>, <1, 1, 1>
    scale <4.444445, 1.666667, 0.555556>
    rotate -0.0*z
    translate  <-18.0, -11.666667, -10.555556>
  }
  material {
    bordertex01
  }
  translate  1.0*y
}
#declare CSG009 = union {
  box { // Cube516
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 3.5>
    translate  <-18.0, -11.0, -6.5>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 7.0>
    translate  <-18.0, -12.0, -10.0>
  }
  object { CSG007 }
  object { CSG008 }
}
#declare doeroepnCSG02 = difference {
  object { CSG009 }
  box { // Cube518
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 3.0>
    translate  <-18.0, -13.0, -7.0>
  }
  material {
    hustex3
  }
  scale 0.9
  translate  <34.2, -1.0, 0.0>
}
union { // borgarhusCSG01
  box { // gavelglastop01
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <0.1, 1.5, 0.5>
    translate  <-29.7, 0.0, 6.0>
  }
  box { // gavelglas01
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <0.1, 6.75, 4.5>
    translate  <-29.6, 0.0, -2.0>
  }
  object { borgarskorstenCSG01 }
  box { // borgarglas01
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <28.0, 0.1, 4.5>
    translate  <0.0, -9.7, -2.0>
  }
  object { alltannatCSG01 }
  object { foesterkarmCSG01 }
  object { doeroepnCSG01 }
  object { borgargrundCSG01 }
  object { doeroepnCSG02 }
  scale 0.3
  rotate 112.109116*z
  translate  <-96.349711, 69.019408, 1.0>
}


#declare CSG037 = difference {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.5>
    rotate -90.0*x
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 3.0>
    rotate -90.0*x
    translate  -0.25*y
  }
}
#declare kanonCSG04 = union {
  object { CSG037 }
  sphere { // Sphere007
    <0,0,0>,1
    scale 0.07
    translate  2.85*y
  }
  sphere { // Sphere008
    <0,0,0>,1
    scale 0.3
    translate  2.5*y
  }
  torus { // Torus004
    1.925, 0.275  rotate -x*90
    scale 0.15
    rotate -90.0*x
  }
  material {
    kanontex
  }
  scale 0.6
  rotate -10.0*x
  translate  <2.25, -1.1, 6.25>
}
#declare CSG035 = difference {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.5>
    rotate -90.0*x
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 3.0>
    rotate -90.0*x
    translate  -0.25*y
  }
}
#declare kanonCSG03 = union {
  object { CSG035 }
  sphere { // Sphere005
    <0,0,0>,1
    scale 0.07
    translate  2.85*y
  }
  sphere { // Sphere006
    <0,0,0>,1
    scale 0.3
    translate  2.5*y
  }
  torus { // Torus003
    1.925, 0.275  rotate -x*90
    scale 0.15
    rotate -90.0*x
  }
  material {
    kanontex
  }
  scale 0.6
  rotate -10.0*x
  translate  <6.75, -1.1, 6.25>
}
#declare CSG031 = difference {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.5>
    rotate -90.0*x
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 3.0>
    rotate -90.0*x
    translate  -0.25*y
  }
}
#declare kanonCSG01 = union {
  object { CSG031 }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.07
    translate  2.85*y
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.3
    translate  2.5*y
  }
  torus { // Torus001
    1.925, 0.275  rotate -x*90
    scale 0.15
    rotate -90.0*x
  }
  material {
    kanontex
  }
  scale 0.6
  rotate -10.0*x
  translate  <-6.75, -1.1, 6.25>
}
#declare CSG033 = difference {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.5>
    rotate -90.0*x
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 3.0>
    rotate -90.0*x
    translate  -0.25*y
  }
}
#declare kanonCSG02 = union {
  object { CSG033 }
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.07
    translate  2.85*y
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale 0.3
    translate  2.5*y
  }
  torus { // Torus002
    1.925, 0.275  rotate -x*90
    scale 0.15
    rotate -90.0*x
  }
  material {
    kanontex
  }
  scale 0.6
  rotate -10.0*x
  translate  <-2.25, -1.1, 6.25>
}
#declare CSG032 = difference {
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.5>
    rotate -90.0*x
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 3.0>
    rotate -90.0*x
    translate  -0.25*y
  }
}
#declare kanonCSG05 = union {
  object { CSG032 }
  sphere { // Sphere009
    <0,0,0>,1
    scale 0.07
    translate  2.85*y
  }
  sphere { // Sphere010
    <0,0,0>,1
    scale 0.3
    translate  2.5*y
  }
  torus { // Torus005
    1.925, 0.275  rotate -x*90
    scale 0.15
    rotate -90.0*x
  }
  material {
    kanontex
  }
  scale 0.6
  rotate <-10.0, 0.0, -60.0>
  translate  <-12.6, 2.1, 6.25>
}
#declare CSG002 = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-7.5, -0.8, 6.4>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-6.0, -0.8, 6.4>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-4.5, -0.8, 6.4>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-3.0, -0.8, 6.4>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-1.5, -0.8, 6.4>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <1.5, -0.8, 6.4>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <3.0, -0.8, 6.4>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <4.5, -0.8, 6.4>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <6.0, -0.8, 6.4>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <7.5, -0.8, 6.4>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <0.0, -0.8, 6.4>
  }
}
#declare CSG003 = union {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <0.0, -0.8, 6.8>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <1.5, -0.8, 6.8>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <3.0, -0.8, 6.8>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <4.5, -0.8, 6.8>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <6.0, -0.8, 6.8>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <7.5, -0.8, 6.8>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-1.5, -0.8, 6.8>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-3.0, -0.8, 6.8>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-4.5, -0.8, 6.8>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-6.0, -0.8, 6.8>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-7.5, -0.8, 6.8>
  }
}
#declare CSG001 = difference {
  object { CSG002 }
  object { CSG003 }
}
#declare CSG029 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 0.2, 5.0>
    translate  <0.0, -0.8, 1.0>
  }
  box { // Cube081
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-7.0, -0.8, 4.0>
  }
  box { // Cube082
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-6.0, -0.8, 4.0>
  }
  box { // Cube083
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-5.0, -0.8, 4.0>
  }
  box { // Cube084
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-4.0, -0.8, 4.0>
  }
  box { // Cube085
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <7.0, -0.8, 4.0>
  }
  box { // Cube086
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <6.0, -0.8, 4.0>
  }
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <5.0, -0.8, 4.0>
  }
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <4.0, -0.8, 4.0>
  }
}
#declare langsidCSG01 = union {
  object { CSG001 }
  object { CSG029 }
  box { // Cube080
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.5, 0.2>
    translate  <0.0, 0.5, 5.4>
  }
  material {
    stenmurtex
  }
}
#declare CSG015 = union {
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, -1.8, 9.4>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 0.0, 9.4>
  }
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, 1.8, 9.4>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 0.0, 9.4>
  }
}
#declare CSG016 = union {
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-11.8, 0.0, 9.8>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-8.2, 0.0, 9.8>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, 1.8, 9.8>
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, -1.8, 9.8>
  }
}
#declare CSG017 = difference {
  object { CSG015 }
  object { CSG016 }
}
#declare CSG018 = difference {
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, -1.6, 9.4>
  }
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-8.2, -1.9, 9.8>
  }
}
#declare CSG019 = difference {
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 1.6, 9.4>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-8.2, 1.9, 9.8>
  }
}
#declare CSG020 = difference {
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 1.6, 9.4>
  }
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-11.8, 1.9, 9.8>
  }
}
#declare CSG021 = difference {
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, -1.8, 9.4>
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, -1.8, 9.8>
  }
}
#declare CSG022 = difference {
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, 1.8, 9.4>
  }
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, 1.8, 9.8>
  }
}
#declare CSG023 = difference {
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, 1.8, 9.4>
  }
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, 1.8, 9.8>
  }
}
#declare CSG024 = difference {
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, -1.6, 9.4>
  }
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-11.8, -1.9, 9.8>
  }
}
#declare CSG025 = difference {
  box { // Cube071
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, -1.8, 9.4>
  }
  box { // Cube072
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, -1.8, 9.8>
  }
}
#declare torntop1 = union {
  object { CSG017 }
  object { CSG018 }
  object { CSG019 }
  object { CSG020 }
  object { CSG021 }
  object { CSG022 }
  object { CSG023 }
  object { CSG024 }
  object { CSG025 }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 0.5>
    translate  <-10.0, 0.0, 8.5>
  }
}
#declare CSG028 = difference {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 12.0>
    translate  <10.0, 0.0, -4.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <1.35, 1.35, 8.0>
    translate  10.0*x
  }
  box { // Cube075
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    rotate 40.0*z
    translate  <10.8, -1.0, 5.0>
  }
  box { // Cube078
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    rotate -40.0*z
    translate  <9.2, -1.0, 3.6>
  }
  box { // Cube079
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <10.0, -1.3, 4.3>
  }
  translate  -20.0*x
}
#declare tornCSG02 = union {
  object { torntop1 }
  cone { // Cone002
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.8, 1.8, 2.0>
    translate  <-10.0, 0.0, 6.0>
  }
  object { CSG028 }
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <30.0, -30.0, 0.0>
    translate  <-11.3, -1.3, 7.5>
  }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <-30.0, -30.0, 0.0>
    translate  <-11.3, 1.3, 7.5>
  }
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <-30.0, 30.0, 0.0>
    translate  <-8.7, 1.3, 7.5>
  }
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <30.0, 30.0, 0.0>
    translate  <-8.7, -1.3, 7.5>
  }
  material {
    stenmurtex
  }
  translate  20.0*x
}
#declare CSG026 = union {
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-7.5, -0.8, 6.4>
  }
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-6.0, -0.8, 6.4>
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-4.5, -0.8, 6.4>
  }
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-3.0, -0.8, 6.4>
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-1.5, -0.8, 6.4>
  }
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <1.5, -0.8, 6.4>
  }
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <3.0, -0.8, 6.4>
  }
  box { // Cube108
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <4.5, -0.8, 6.4>
  }
  box { // Cube109
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <6.0, -0.8, 6.4>
  }
  box { // Cube110
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <7.5, -0.8, 6.4>
  }
  box { // Cube111
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <0.0, -0.8, 6.4>
  }
}
#declare CSG038 = union {
  box { // Cube112
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <0.0, -0.8, 6.8>
  }
  box { // Cube113
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <1.5, -0.8, 6.8>
  }
  box { // Cube114
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <3.0, -0.8, 6.8>
  }
  box { // Cube115
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <4.5, -0.8, 6.8>
  }
  box { // Cube116
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <6.0, -0.8, 6.8>
  }
  box { // Cube117
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <7.5, -0.8, 6.8>
  }
  box { // Cube118
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-1.5, -0.8, 6.8>
  }
  box { // Cube119
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-3.0, -0.8, 6.8>
  }
  box { // Cube120
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-4.5, -0.8, 6.8>
  }
  box { // Cube121
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-6.0, -0.8, 6.8>
  }
  box { // Cube122
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-7.5, -0.8, 6.8>
  }
}
#declare CSG039 = difference {
  object { CSG026 }
  object { CSG038 }
}
#declare CSG040 = difference {
  box { // Cube123
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 0.2, 4.0>
    translate  <0.0, -0.8, 2.0>
  }
  box { // Cube124
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-7.0, -0.8, 4.0>
  }
  box { // Cube125
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-6.0, -0.8, 4.0>
  }
  box { // Cube126
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-5.0, -0.8, 4.0>
  }
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-4.0, -0.8, 4.0>
  }
  box { // Cube128
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <7.0, -0.8, 4.0>
  }
  box { // Cube129
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <6.0, -0.8, 4.0>
  }
  box { // Cube130
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <5.0, -0.8, 4.0>
  }
  box { // Cube131
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <4.0, -0.8, 4.0>
  }
}
#declare langsidCSG02 = union {
  object { CSG039 }
  object { CSG040 }
  box { // Cube132
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.5, 0.2>
    translate  <0.0, 0.5, 5.4>
  }
  material {
    stenmurtex
  }
  rotate -60.0*z
  translate  <-15.0, 8.5, 0.0>
}
#declare CSG041 = union {
  box { // Cube137
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.5, 8.0>
    translate  <-10.0, 2.0, -2.0>
  }
  box { // Cube138
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.5, 8.0>
    translate  <-10.0, -2.0, -2.0>
  }
}
#declare CSG042 = difference {
  object { CSG041 }
  box { // Cube139
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <-10.0, 0.0, -7.0>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 6.0>
    rotate -90.0*x
    translate  <-10.0, -3.0, -4.0>
  }
}
#declare CSG043 = union {
  cone { // Cone003
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale 0.3
    translate  <-7.5, -2.0, -10.1>
  }
  cone { // Cone004
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale 0.3
    translate  <-8.0, -2.0, -10.1>
  }
  cone { // Cone005
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale 0.3
    translate  <-8.5, -2.0, -10.1>
  }
  cone { // Cone006
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale 0.3
    translate  <-9.0, -2.0, -10.1>
  }
  cone { // Cone007
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale 0.3
    translate  <-9.5, -2.0, -10.1>
  }
  cone { // Cone008
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale 0.3
    translate  <-10.0, -2.0, -10.1>
  }
  cone { // Cone009
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale 0.3
    translate  <-10.5, -2.0, -10.1>
  }
  cone { // Cone010
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale 0.3
    translate  <-11.0, -2.0, -10.1>
  }
  cone { // Cone011
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale 0.3
    translate  <-11.5, -2.0, -10.1>
  }
  cone { // Cone012
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale 0.3
    translate  <-12.0, -2.0, -10.1>
  }
  cone { // Cone013
    <0,0,0>, 0.2, <0,0,1>, 0.5
    scale 0.3
    translate  <-12.5, -2.0, -10.1>
  }
  translate  2.0*y
}
#declare CSG044 = union {
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 10.0>
    translate  <-7.5, 0.0, -10.0>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 10.0>
    translate  <-8.0, 0.0, -10.0>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 10.0>
    translate  <-8.5, 0.0, -10.0>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 10.0>
    translate  <-9.0, 0.0, -10.0>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 10.0>
    translate  <-9.5, 0.0, -10.0>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 10.0>
    translate  <-10.0, 0.0, -10.0>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 10.0>
    translate  <-10.5, 0.0, -10.0>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 10.0>
    translate  <-11.0, 0.0, -10.0>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 10.0>
    translate  <-11.5, 0.0, -10.0>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 10.0>
    translate  <-12.5, 0.0, -10.0>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.07, 0.07, 10.0>
    translate  <-12.0, 0.0, -10.0>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.0>
    rotate -90.0*y
    translate  <-7.0, 0.0, -9.0>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.0>
    rotate -90.0*y
    translate  <-7.0, 0.0, -7.0>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.0>
    rotate -90.0*y
    translate  <-7.0, 0.0, -5.0>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.0>
    rotate -90.0*y
    translate  <-7.0, 0.0, -3.0>
  }
  object { CSG043 }
  material {
    jaentex
  }
  translate  -2.0*y
}
#declare mittpartiCSG01 = union {
  box { // Cube133
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 2.7, 0.2>
    translate  <-10.0, 0.0, 3.0>
  }
  box { // Cube134
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 2.7, 0.2>
    translate  -10.0*x
  }
  box { // Cube135
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 8.0>
    translate  <-14.5, 0.0, -2.0>
  }
  box { // Cube136
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 8.0>
    translate  <-5.5, 0.0, -2.0>
  }
  object { CSG042 }
  object { CSG044 }
  material {
    stenmurtex
  }
}
#declare CSG048 = union {
  box { // Cube150
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, -1.8, 9.4>
  }
  box { // Cube151
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 0.0, 9.4>
  }
  box { // Cube152
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, 1.8, 9.4>
  }
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 0.0, 9.4>
  }
}
#declare CSG049 = union {
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-11.8, 0.0, 9.8>
  }
  box { // Cube155
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-8.2, 0.0, 9.8>
  }
  box { // Cube156
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, 1.8, 9.8>
  }
  box { // Cube157
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, -1.8, 9.8>
  }
}
#declare CSG050 = difference {
  object { CSG048 }
  object { CSG049 }
}
#declare CSG051 = difference {
  box { // Cube158
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, -1.6, 9.4>
  }
  box { // Cube159
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-8.2, -1.9, 9.8>
  }
}
#declare CSG052 = difference {
  box { // Cube160
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 1.6, 9.4>
  }
  box { // Cube161
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-8.2, 1.9, 9.8>
  }
}
#declare CSG053 = difference {
  box { // Cube162
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 1.6, 9.4>
  }
  box { // Cube163
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-11.8, 1.9, 9.8>
  }
}
#declare CSG054 = difference {
  box { // Cube164
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, -1.8, 9.4>
  }
  box { // Cube165
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, -1.8, 9.8>
  }
}
#declare CSG055 = difference {
  box { // Cube166
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, 1.8, 9.4>
  }
  box { // Cube167
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, 1.8, 9.8>
  }
}
#declare CSG056 = difference {
  box { // Cube168
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, 1.8, 9.4>
  }
  box { // Cube169
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, 1.8, 9.8>
  }
}
#declare CSG057 = difference {
  box { // Cube170
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, -1.6, 9.4>
  }
  box { // Cube171
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-11.8, -1.9, 9.8>
  }
}
#declare CSG058 = difference {
  box { // Cube172
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, -1.8, 9.4>
  }
  box { // Cube173
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, -1.8, 9.8>
  }
}
#declare torntop2 = union {
  object { CSG050 }
  object { CSG051 }
  object { CSG052 }
  object { CSG053 }
  object { CSG054 }
  object { CSG055 }
  object { CSG056 }
  object { CSG057 }
  object { CSG058 }
  box { // Cube174
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 0.5>
    translate  <-10.0, 0.0, 8.5>
  }
  scale 2.0
  translate  <20.0, 0.0, -6.0>
}
#declare CSG068 = difference {
  box { // Cube140
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 4.0, 10.0>
  }
  box { // Cube141
    <-1, -1, -1>, <1, 1, 1>
    scale <3.7, 3.7, 10.0>
  }
  box { // Cube142
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.5, 0.8>
    translate  <2.0, -4.0, 3.0>
  }
  box { // Cube143
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.5, 0.8>
    translate  <0.0, -4.0, 3.0>
  }
  box { // Cube144
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.5, 0.8>
    translate  <-2.0, -4.0, 3.0>
  }
  material {
    stenmurtex
  }
}
#declare gatetornCSG01 = union {
  object { torntop2 }
  object { CSG068 }
  material {
    stenmurtex
  }
}
#declare CSG045 = union {
  box { // Cube175
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, -1.8, 9.4>
  }
  box { // Cube176
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 0.0, 9.4>
  }
  box { // Cube177
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, 1.8, 9.4>
  }
  box { // Cube178
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 0.0, 9.4>
  }
}
#declare CSG046 = union {
  box { // Cube179
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-11.8, 0.0, 9.8>
  }
  box { // Cube180
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-8.2, 0.0, 9.8>
  }
  box { // Cube181
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, 1.8, 9.8>
  }
  box { // Cube182
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, -1.8, 9.8>
  }
}
#declare CSG059 = difference {
  object { CSG045 }
  object { CSG046 }
}
#declare CSG060 = difference {
  box { // Cube183
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, -1.6, 9.4>
  }
  box { // Cube184
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-8.2, -1.9, 9.8>
  }
}
#declare CSG061 = difference {
  box { // Cube185
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 1.6, 9.4>
  }
  box { // Cube186
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-8.2, 1.9, 9.8>
  }
}
#declare CSG062 = difference {
  box { // Cube187
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 1.6, 9.4>
  }
  box { // Cube188
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-11.8, 1.9, 9.8>
  }
}
#declare CSG063 = difference {
  box { // Cube189
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, -1.8, 9.4>
  }
  box { // Cube190
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, -1.8, 9.8>
  }
}
#declare CSG064 = difference {
  box { // Cube191
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, 1.8, 9.4>
  }
  box { // Cube192
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, 1.8, 9.8>
  }
}
#declare CSG065 = difference {
  box { // Cube193
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, 1.8, 9.4>
  }
  box { // Cube194
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, 1.8, 9.8>
  }
}
#declare CSG066 = difference {
  box { // Cube195
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, -1.6, 9.4>
  }
  box { // Cube196
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-11.8, -1.9, 9.8>
  }
}
#declare CSG067 = difference {
  box { // Cube197
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, -1.8, 9.4>
  }
  box { // Cube198
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, -1.8, 9.8>
  }
}
#declare torntop3 = union {
  object { CSG059 }
  object { CSG060 }
  object { CSG061 }
  object { CSG062 }
  object { CSG063 }
  object { CSG064 }
  object { CSG065 }
  object { CSG066 }
  object { CSG067 }
  box { // Cube199
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 0.5>
    translate  <-10.0, 0.0, 8.5>
  }
  scale 2.0
  translate  -6.0*z
}
#declare CSG069 = difference {
  box { // Cube145
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 4.0, 10.0>
  }
  box { // Cube146
    <-1, -1, -1>, <1, 1, 1>
    scale <3.7, 3.7, 10.0>
  }
  box { // Cube147
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.5, 0.8>
    translate  <2.0, -4.0, 3.0>
  }
  box { // Cube148
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.5, 0.8>
    translate  <0.0, -4.0, 3.0>
  }
  box { // Cube149
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.5, 0.8>
    translate  <-2.0, -4.0, 3.0>
  }
  material {
    stenmurtex
  }
  translate  -20.0*x
}
#declare gatetornCSG02 = union {
  object { torntop3 }
  object { CSG069 }
  material {
    stenmurtex
  }
}
#declare CSG047 = union {
  object { mittpartiCSG01 }
  object { gatetornCSG01 }
  object { gatetornCSG02 }
  scale 0.5
  rotate -60.0*z
  translate  <-20.0, 18.0, 3.0>
}
#declare CSG070 = union {
  box { // Cube201
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-7.5, -0.8, 6.4>
  }
  box { // Cube202
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-6.0, -0.8, 6.4>
  }
  box { // Cube203
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-4.5, -0.8, 6.4>
  }
  box { // Cube204
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-3.0, -0.8, 6.4>
  }
  box { // Cube205
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-1.5, -0.8, 6.4>
  }
  box { // Cube206
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <1.5, -0.8, 6.4>
  }
  box { // Cube207
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <3.0, -0.8, 6.4>
  }
  box { // Cube208
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <4.5, -0.8, 6.4>
  }
  box { // Cube209
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <6.0, -0.8, 6.4>
  }
  box { // Cube210
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <7.5, -0.8, 6.4>
  }
  box { // Cube211
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <0.0, -0.8, 6.4>
  }
}
#declare CSG071 = union {
  box { // Cube212
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <0.0, -0.8, 6.8>
  }
  box { // Cube213
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <1.5, -0.8, 6.8>
  }
  box { // Cube214
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <3.0, -0.8, 6.8>
  }
  box { // Cube215
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <4.5, -0.8, 6.8>
  }
  box { // Cube216
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <6.0, -0.8, 6.8>
  }
  box { // Cube217
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <7.5, -0.8, 6.8>
  }
  box { // Cube218
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-1.5, -0.8, 6.8>
  }
  box { // Cube219
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-3.0, -0.8, 6.8>
  }
  box { // Cube220
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-4.5, -0.8, 6.8>
  }
  box { // Cube221
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-6.0, -0.8, 6.8>
  }
  box { // Cube222
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-7.5, -0.8, 6.8>
  }
}
#declare CSG072 = difference {
  object { CSG070 }
  object { CSG071 }
}
#declare CSG073 = difference {
  box { // Cube223
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 0.2, 4.0>
    translate  <0.0, -0.8, 2.0>
  }
  box { // Cube224
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-7.0, -0.8, 4.0>
  }
  box { // Cube225
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-6.0, -0.8, 4.0>
  }
  box { // Cube226
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-5.0, -0.8, 4.0>
  }
  box { // Cube227
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <-4.0, -0.8, 4.0>
  }
  box { // Cube228
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <7.0, -0.8, 4.0>
  }
  box { // Cube229
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <6.0, -0.8, 4.0>
  }
  box { // Cube230
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <5.0, -0.8, 4.0>
  }
  box { // Cube231
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <4.0, -0.8, 4.0>
  }
}
#declare langsidCSG03 = union {
  object { CSG072 }
  object { CSG073 }
  box { // Cube232
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.5, 0.2>
    translate  <0.0, 0.5, 5.4>
  }
  material {
    stenmurtex
  }
  rotate -60.0*z
  translate  <-30.7, 35.5, 0.0>
}
#declare CSG034 = difference {
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.5>
    rotate -90.0*x
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 3.0>
    rotate -90.0*x
    translate  -0.25*y
  }
}
#declare kanonCSG06 = union {
  object { CSG034 }
  sphere { // Sphere011
    <0,0,0>,1
    scale 0.07
    translate  2.85*y
  }
  sphere { // Sphere012
    <0,0,0>,1
    scale 0.3
    translate  2.5*y
  }
  torus { // Torus006
    1.925, 0.275  rotate -x*90
    scale 0.15
    rotate -90.0*x
  }
  material {
    kanontex
  }
  scale 0.6
  rotate <-10.0, 0.0, -60.0>
  translate  <-14.8, 6.0, 6.25>
}
#declare CSG036 = difference {
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.5>
    rotate -90.0*x
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 3.0>
    rotate -90.0*x
    translate  -0.25*y
  }
}
#declare kanonCSG07 = union {
  object { CSG036 }
  sphere { // Sphere013
    <0,0,0>,1
    scale 0.07
    translate  2.85*y
  }
  sphere { // Sphere014
    <0,0,0>,1
    scale 0.3
    translate  2.5*y
  }
  torus { // Torus007
    1.925, 0.275  rotate -x*90
    scale 0.15
    rotate -90.0*x
  }
  material {
    kanontex
  }
  scale 0.6
  rotate <-10.0, 0.0, -60.0>
  translate  <-17.1, 9.9, 6.25>
}
#declare CSG074 = difference {
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.5>
    rotate -90.0*x
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 3.0>
    rotate -90.0*x
    translate  -0.25*y
  }
}
#declare kanonCSG08 = union {
  object { CSG074 }
  sphere { // Sphere015
    <0,0,0>,1
    scale 0.07
    translate  2.85*y
  }
  sphere { // Sphere016
    <0,0,0>,1
    scale 0.3
    translate  2.5*y
  }
  torus { // Torus008
    1.925, 0.275  rotate -x*90
    scale 0.15
    rotate -90.0*x
  }
  material {
    kanontex
  }
  scale 0.6
  rotate <-10.0, 0.0, -60.0>
  translate  <-19.35, 13.8, 6.25>
}
#declare CSG027 = union {
  box { // Cube074
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, -1.8, 9.4>
  }
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 0.0, 9.4>
  }
  box { // Cube077
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, 1.8, 9.4>
  }
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 0.0, 9.4>
  }
}
#declare CSG030 = union {
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-11.8, 0.0, 9.8>
  }
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-8.2, 0.0, 9.8>
  }
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, 1.8, 9.8>
  }
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, -1.8, 9.8>
  }
}
#declare CSG075 = difference {
  object { CSG027 }
  object { CSG030 }
}
#declare CSG076 = difference {
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, -1.6, 9.4>
  }
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-8.2, -1.9, 9.8>
  }
}
#declare CSG077 = difference {
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 1.6, 9.4>
  }
  box { // Cube234
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-8.2, 1.9, 9.8>
  }
}
#declare CSG078 = difference {
  box { // Cube235
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 1.6, 9.4>
  }
  box { // Cube236
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-11.8, 1.9, 9.8>
  }
}
#declare CSG079 = difference {
  box { // Cube237
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, -1.8, 9.4>
  }
  box { // Cube238
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, -1.8, 9.8>
  }
}
#declare CSG080 = difference {
  box { // Cube239
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, 1.8, 9.4>
  }
  box { // Cube240
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, 1.8, 9.8>
  }
}
#declare CSG081 = difference {
  box { // Cube241
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, 1.8, 9.4>
  }
  box { // Cube242
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, 1.8, 9.8>
  }
}
#declare CSG082 = difference {
  box { // Cube243
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, -1.6, 9.4>
  }
  box { // Cube244
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-11.8, -1.9, 9.8>
  }
}
#declare CSG083 = difference {
  box { // Cube245
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, -1.8, 9.4>
  }
  box { // Cube246
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, -1.8, 9.8>
  }
}
#declare torntop4 = union {
  object { CSG075 }
  object { CSG076 }
  object { CSG077 }
  object { CSG078 }
  object { CSG079 }
  object { CSG080 }
  object { CSG081 }
  object { CSG082 }
  object { CSG083 }
  box { // Cube247
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 0.5>
    translate  <-10.0, 0.0, 8.5>
  }
}
#declare CSG084 = difference {
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 12.0>
    translate  <10.0, 0.0, -4.0>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <1.35, 1.35, 8.0>
    translate  10.0*x
  }
  box { // Cube248
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    rotate 40.0*z
    translate  <10.8, -1.0, 5.0>
  }
  box { // Cube249
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    rotate -40.0*z
    translate  <9.2, -1.0, 3.6>
  }
  box { // Cube250
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <10.0, -1.3, 4.3>
  }
  translate  -20.0*x
}
#declare tornCSG03 = union {
  object { torntop4 }
  cone { // Cone014
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.8, 1.8, 2.0>
    translate  <-10.0, 0.0, 6.0>
  }
  object { CSG084 }
  box { // Cube251
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <30.0, -30.0, 0.0>
    translate  <-11.3, -1.3, 7.5>
  }
  box { // Cube252
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <-30.0, -30.0, 0.0>
    translate  <-11.3, 1.3, 7.5>
  }
  box { // Cube253
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <-30.0, 30.0, 0.0>
    translate  <-8.7, 1.3, 7.5>
  }
  box { // Cube254
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <30.0, 30.0, 0.0>
    translate  <-8.7, -1.3, 7.5>
  }
  material {
    stenmurtex
  }
}
#declare CSG085 = union {
  box { // Cube255
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, -1.8, 9.4>
  }
  box { // Cube256
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 0.0, 9.4>
  }
  box { // Cube257
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, 1.8, 9.4>
  }
  box { // Cube258
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 0.0, 9.4>
  }
}
#declare CSG086 = union {
  box { // Cube259
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-11.8, 0.0, 9.8>
  }
  box { // Cube260
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-8.2, 0.0, 9.8>
  }
  box { // Cube261
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, 1.8, 9.8>
  }
  box { // Cube262
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, -1.8, 9.8>
  }
}
#declare CSG087 = difference {
  object { CSG085 }
  object { CSG086 }
}
#declare CSG088 = difference {
  box { // Cube263
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, -1.6, 9.4>
  }
  box { // Cube264
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-8.2, -1.9, 9.8>
  }
}
#declare CSG089 = difference {
  box { // Cube265
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 1.6, 9.4>
  }
  box { // Cube266
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-8.2, 1.9, 9.8>
  }
}
#declare CSG090 = difference {
  box { // Cube267
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 1.6, 9.4>
  }
  box { // Cube268
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-11.8, 1.9, 9.8>
  }
}
#declare CSG091 = difference {
  box { // Cube269
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, -1.8, 9.4>
  }
  box { // Cube270
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, -1.8, 9.8>
  }
}
#declare CSG092 = difference {
  box { // Cube271
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, 1.8, 9.4>
  }
  box { // Cube272
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, 1.8, 9.8>
  }
}
#declare CSG093 = difference {
  box { // Cube273
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, 1.8, 9.4>
  }
  box { // Cube274
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, 1.8, 9.8>
  }
}
#declare CSG094 = difference {
  box { // Cube275
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, -1.6, 9.4>
  }
  box { // Cube276
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-11.8, -1.9, 9.8>
  }
}
#declare CSG095 = difference {
  box { // Cube277
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, -1.8, 9.4>
  }
  box { // Cube278
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, -1.8, 9.8>
  }
}
#declare torntop5 = union {
  object { CSG087 }
  object { CSG088 }
  object { CSG089 }
  object { CSG090 }
  object { CSG091 }
  object { CSG092 }
  object { CSG093 }
  object { CSG094 }
  object { CSG095 }
  box { // Cube279
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 0.5>
    translate  <-10.0, 0.0, 8.5>
  }
}
#declare CSG096 = difference {
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 12.0>
    translate  <10.0, 0.0, -4.0>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <1.35, 1.35, 8.0>
    translate  10.0*x
  }
  box { // Cube280
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    rotate 40.0*z
    translate  <10.8, -1.0, 5.0>
  }
  box { // Cube281
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    rotate -40.0*z
    translate  <9.2, -1.0, 3.6>
  }
  box { // Cube282
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <10.0, -1.3, 4.3>
  }
  translate  -20.0*x
}
#declare tornCSG01 = union {
  object { torntop5 }
  cone { // Cone015
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.8, 1.8, 2.0>
    translate  <-10.0, 0.0, 6.0>
  }
  object { CSG096 }
  box { // Cube283
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <30.0, -30.0, 0.0>
    translate  <-11.3, -1.3, 7.5>
  }
  box { // Cube284
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <-30.0, -30.0, 0.0>
    translate  <-11.3, 1.3, 7.5>
  }
  box { // Cube285
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <-30.0, 30.0, 0.0>
    translate  <-8.7, 1.3, 7.5>
  }
  box { // Cube286
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <30.0, 30.0, 0.0>
    translate  <-8.7, -1.3, 7.5>
  }
  material {
    stenmurtex
  }
  rotate -60.0*z
  translate  <-30.4, 36.0, 0.0>
}
union { // borgCSG01
  object { kanonCSG04 }
  object { kanonCSG03 }
  object { kanonCSG01 }
  object { kanonCSG02 }
  object { kanonCSG05 }
  object { langsidCSG01 }
  object { tornCSG02 }
  object { langsidCSG02 }
  object { CSG047 }
  object { langsidCSG03 }
  object { kanonCSG06 }
  object { kanonCSG07 }
  object { kanonCSG08 }
  object { tornCSG03 }
  object { tornCSG01 }
  translate  <-9.0, 33.0, 0.0>
}


#declare RndCube007 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
// Attributes returned success!
  scale <2.5, 2.5, 1.0>
  translate  11.5*z
}
#declare RndCube008 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
// Attributes returned success!
  scale <2.5, 2.5, 1.0>
  translate  <-20.0, 0.0, 11.5>
}
#declare RndCube009 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
// Attributes returned success!
  scale <2.5, 2.5, 1.0>
  translate  <20.0, 0.0, 11.5>
}
#declare borgarskorstenCSG03 = union {
  object { RndCube007 }
  cone { // Cone021
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <1.5, 1.5, 2.0>
    rotate <180.0, 0.0, 180.0>
    translate  11.0*z
  }
  cone { // Cone022
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <1.5, 1.5, 2.0>
    rotate <180.0, 0.0, 180.0>
    translate  <20.0, 0.0, 11.0>
  }
  cone { // Cone023
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <1.5, 1.5, 2.0>
    rotate <180.0, 0.0, 180.0>
    translate  <-20.0, 0.0, 11.0>
  }
  object { RndCube008 }
  object { RndCube009 }
  material {
    svarttex
  }
}
#declare alltannatCSG03 = union {
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <0.2, 0.2, 60.0>
    rotate -90.0*y
    translate  <30.0, -10.0, -2.0>
  }
  box { // Cube1162
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <0.9, 0.2, 3.0>
    translate  <-17.0, -13.0, -6.5>
  }
  box { // Cube1163
    <-1, -1, -1>, <1, 1, 1>
    material {
      borgartaktex3
    }
    scale <31.0, 0.2, 6.0>
    rotate -59.0*x
    translate  <0.0, -5.0, 7.0>
  }
  box { // Cube1164
    <-1, -1, -1>, <1, 1, 1>
    material {
      borgartaktex3
    }
    scale <31.0, 0.2, 6.0>
    rotate 59.0*x
    translate  <0.0, 5.0, 7.0>
  }
  box { // Cube1165
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <0.9, 0.2, 3.0>
    translate  <17.0, -13.0, -6.5>
  }
  box { // Cube1166
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <0.9, 0.2, 3.0>
    translate  <19.0, -13.0, -6.5>
  }
  box { // Cube1167
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex
    }
    scale <1.0, 0.2, 3.0>
    translate  <-19.0, -13.0, -6.5>
  }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <0.2, 0.2, 20.0>
    rotate -90.0*x
    translate  <-30.0, -10.0, -2.0>
  }
}
#declare foesterkarmtvaesCSG03 = union {
  box { // Cube1168
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <27.0, -9.7, 2.4>
  }
  box { // Cube1169
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <24.0, -9.7, 2.4>
  }
  box { // Cube1170
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <21.0, -9.7, 2.4>
  }
  box { // Cube1171
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <15.0, -9.7, 2.4>
  }
  box { // Cube1172
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <12.0, -9.7, 2.4>
  }
  box { // Cube1173
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <9.0, -9.7, 2.4>
  }
  box { // Cube1174
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <6.0, -9.7, 2.4>
  }
  box { // Cube1175
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <3.0, -9.7, 2.4>
  }
  box { // Cube1176
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <0.0, -9.7, 2.4>
  }
  box { // Cube1177
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-3.0, -9.7, 2.4>
  }
  box { // Cube1178
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-6.0, -9.7, 2.4>
  }
  box { // Cube1179
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-9.0, -9.7, 2.4>
  }
  box { // Cube1180
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-12.0, -9.7, 2.4>
  }
  box { // Cube1181
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-15.0, -9.7, 2.4>
  }
  box { // Cube1182
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-21.0, -9.7, 2.4>
  }
  box { // Cube1183
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-24.0, -9.7, 2.4>
  }
  box { // Cube1184
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-27.0, -9.7, 2.4>
  }
}
#declare foesterkarmtvaes3CSG03 = union {
  box { // Cube1185
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <27.0, -9.75, -0.4>
  }
  box { // Cube1186
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <24.0, -9.75, -0.4>
  }
  box { // Cube1187
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <21.0, -9.75, -0.4>
  }
  box { // Cube1188
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <15.0, -9.75, -0.4>
  }
  box { // Cube1189
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <12.0, -9.75, -0.4>
  }
  box { // Cube1190
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <9.0, -9.75, -0.4>
  }
  box { // Cube1191
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <6.0, -9.75, -0.4>
  }
  box { // Cube1192
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <3.0, -9.75, -0.4>
  }
  box { // Cube1193
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <0.0, -9.75, -0.4>
  }
  box { // Cube1194
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-3.0, -9.75, -0.4>
  }
  box { // Cube1195
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-6.0, -9.75, -0.4>
  }
  box { // Cube1196
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-9.0, -9.75, -0.4>
  }
  box { // Cube1197
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-12.0, -9.75, -0.4>
  }
  box { // Cube1198
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-15.0, -9.75, -0.4>
  }
  box { // Cube1199
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-21.0, -9.75, -0.4>
  }
  box { // Cube1200
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-24.0, -9.75, -0.4>
  }
  box { // Cube1201
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-27.0, -9.75, -0.4>
  }
}
#declare foesterkarmnedlodCSG03 = union {
  box { // Cube1202
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <0.65, -9.7, -5.0>
  }
  box { // Cube1203
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <2.35, -9.7, -5.0>
  }
  box { // Cube1204
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <3.65, -9.7, -5.0>
  }
  box { // Cube1205
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <5.35, -9.7, -5.0>
  }
  box { // Cube1206
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <6.65, -9.7, -5.0>
  }
  box { // Cube1207
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <8.35, -9.7, -5.0>
  }
  box { // Cube1208
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <9.65, -9.7, -5.0>
  }
  box { // Cube1209
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <11.35, -9.7, -5.0>
  }
  box { // Cube1210
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <12.65, -9.7, -5.0>
  }
  box { // Cube1211
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <23.35, -9.7, -5.0>
  }
  box { // Cube1212
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <24.65, -9.7, -5.0>
  }
  box { // Cube1213
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <26.35, -9.7, -5.0>
  }
  box { // Cube1214
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <27.65, -9.7, -5.0>
  }
  box { // Cube1215
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-0.65, -9.7, -5.0>
  }
  box { // Cube1216
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-2.35, -9.7, -5.0>
  }
  box { // Cube1217
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-3.65, -9.7, -5.0>
  }
  box { // Cube1218
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-5.35, -9.7, -5.0>
  }
  box { // Cube1219
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-6.65, -9.7, -5.0>
  }
  box { // Cube1220
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-8.35, -9.7, -5.0>
  }
  box { // Cube1221
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-9.65, -9.7, -5.0>
  }
  box { // Cube1222
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-11.35, -9.7, -5.0>
  }
  box { // Cube1223
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-12.65, -9.7, -5.0>
  }
  box { // Cube1224
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-23.35, -9.7, -5.0>
  }
  box { // Cube1225
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-24.65, -9.7, -5.0>
  }
  box { // Cube1226
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-26.35, -9.7, -5.0>
  }
  box { // Cube1227
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-27.65, -9.7, -5.0>
  }
}
#declare foesterkarmupplodCSG04 = union {
  box { // Cube1228
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <0.65, -9.7, -5.0>
  }
  box { // Cube1229
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <2.35, -9.7, -5.0>
  }
  box { // Cube1230
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <3.65, -9.7, -5.0>
  }
  box { // Cube1231
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <5.35, -9.7, -5.0>
  }
  box { // Cube1232
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <6.65, -9.7, -5.0>
  }
  box { // Cube1233
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <8.35, -9.7, -5.0>
  }
  box { // Cube1234
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <9.65, -9.7, -5.0>
  }
  box { // Cube1235
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <11.35, -9.7, -5.0>
  }
  box { // Cube1236
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <12.65, -9.7, -5.0>
  }
  box { // Cube1237
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <23.35, -9.7, -5.0>
  }
  box { // Cube1238
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <24.65, -9.7, -5.0>
  }
  box { // Cube1239
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <26.35, -9.7, -5.0>
  }
  box { // Cube1240
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <27.65, -9.7, -5.0>
  }
  box { // Cube1241
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-0.65, -9.7, -5.0>
  }
  box { // Cube1242
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-2.35, -9.7, -5.0>
  }
  box { // Cube1243
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-3.65, -9.7, -5.0>
  }
  box { // Cube1244
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-5.35, -9.7, -5.0>
  }
  box { // Cube1245
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-6.65, -9.7, -5.0>
  }
  box { // Cube1246
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-8.35, -9.7, -5.0>
  }
  box { // Cube1247
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-9.65, -9.7, -5.0>
  }
  box { // Cube1248
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-11.35, -9.7, -5.0>
  }
  box { // Cube1249
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-12.65, -9.7, -5.0>
  }
  box { // Cube1250
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-23.35, -9.7, -5.0>
  }
  box { // Cube1251
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-24.65, -9.7, -5.0>
  }
  box { // Cube1252
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-26.35, -9.7, -5.0>
  }
  box { // Cube1253
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-27.65, -9.7, -5.0>
  }
  box { // Cube1254
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <14.35, -9.7, -5.0>
  }
  box { // Cube1255
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <15.65, -9.7, -5.0>
  }
  box { // Cube1256
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <20.35, -9.7, -5.0>
  }
  box { // Cube1257
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <21.65, -9.7, -5.0>
  }
  box { // Cube1258
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-14.35, -9.7, -5.0>
  }
  box { // Cube1259
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-15.65, -9.7, -5.0>
  }
  box { // Cube1260
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-20.35, -9.7, -5.0>
  }
  box { // Cube1261
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-21.65, -9.7, -5.0>
  }
  translate  6.0*z
}
#declare foesterkarmtvaes1CSG03 = union {
  box { // Cube1262
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <27.0, -9.75, -0.4>
  }
  box { // Cube1263
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <24.0, -9.75, -0.4>
  }
  box { // Cube1264
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <12.0, -9.75, -0.4>
  }
  box { // Cube1265
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <9.0, -9.75, -0.4>
  }
  box { // Cube1266
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <6.0, -9.75, -0.4>
  }
  box { // Cube1267
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <3.0, -9.75, -0.4>
  }
  box { // Cube1268
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <0.0, -9.75, -0.4>
  }
  box { // Cube1269
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-3.0, -9.75, -0.4>
  }
  box { // Cube1270
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-6.0, -9.75, -0.4>
  }
  box { // Cube1271
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-9.0, -9.75, -0.4>
  }
  box { // Cube1272
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-12.0, -9.75, -0.4>
  }
  box { // Cube1273
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-24.0, -9.75, -0.4>
  }
  box { // Cube1274
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.1>
    translate  <-27.0, -9.75, -0.4>
  }
  translate  -6.0*z
}
#declare foesterkarmtvaes2CSG03 = union {
  box { // Cube1275
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <27.0, -9.7, 2.4>
  }
  box { // Cube1276
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <24.0, -9.7, 2.4>
  }
  box { // Cube1277
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <12.0, -9.7, 2.4>
  }
  box { // Cube1278
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <9.0, -9.7, 2.4>
  }
  box { // Cube1279
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <6.0, -9.7, 2.4>
  }
  box { // Cube1280
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <3.0, -9.7, 2.4>
  }
  box { // Cube1281
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <0.0, -9.7, 2.4>
  }
  box { // Cube1282
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-3.0, -9.7, 2.4>
  }
  box { // Cube1283
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-6.0, -9.7, 2.4>
  }
  box { // Cube1284
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-9.0, -9.7, 2.4>
  }
  box { // Cube1285
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-12.0, -9.7, 2.4>
  }
  box { // Cube1286
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-24.0, -9.7, 2.4>
  }
  box { // Cube1287
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.2, 0.1>
    translate  <-27.0, -9.7, 2.4>
  }
  translate  -6.0*z
}
#declare glaslodCSG03 = union {
  box { // Cube1288
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <27.0, -9.7, -2.0>
  }
  box { // Cube1289
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <24.0, -9.7, -2.0>
  }
  box { // Cube1290
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <12.0, -9.7, -2.0>
  }
  box { // Cube1291
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <9.0, -9.7, -2.0>
  }
  box { // Cube1292
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <6.0, -9.7, -2.0>
  }
  box { // Cube1293
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <3.0, -9.7, -2.0>
  }
  box { // Cube1294
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <0.0, -9.7, -2.0>
  }
  box { // Cube1295
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-3.0, -9.7, -2.0>
  }
  box { // Cube1296
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-6.0, -9.7, -2.0>
  }
  box { // Cube1297
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-9.0, -9.7, -2.0>
  }
  box { // Cube1298
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-12.0, -9.7, -2.0>
  }
  box { // Cube1299
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-24.0, -9.7, -2.0>
  }
  box { // Cube1300
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 4.5>
    translate  <-27.0, -9.7, -2.0>
  }
  box { // Cube1301
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <21.0, -9.7, 1.0>
  }
  box { // Cube1302
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <15.0, -9.7, 1.0>
  }
  box { // Cube1303
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-21.0, -9.7, 1.0>
  }
  box { // Cube1304
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 1.5>
    translate  <-15.0, -9.7, 1.0>
  }
}
#declare glastvaesCSG03 = union {
  box { // Cube1305
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, 1.5>
  }
  box { // Cube1306
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, 0.5>
  }
  box { // Cube1307
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, -4.5>
  }
  box { // Cube1308
    <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 0.2, 0.1>
    translate  <0.0, -9.7, -5.5>
  }
}
#declare glasgavellodCSG03 = union {
  box { // Cube1309
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, 0.0, -2.0>
  }
  box { // Cube1310
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, 3.0, -2.0>
  }
  box { // Cube1311
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, 6.0, -2.0>
  }
  box { // Cube1312
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, -3.0, -2.0>
  }
  box { // Cube1313
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 4.5>
    translate  <-29.7, -6.0, -2.0>
  }
  translate  0.1*x
}
#declare foesterkarmgavellodCSG03 = union {
  box { // Cube1314
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 0.65, 1.0>
  }
  box { // Cube1315
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 2.35, 1.0>
  }
  box { // Cube1316
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 3.65, 1.0>
  }
  box { // Cube1317
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 5.35, 1.0>
  }
  box { // Cube1318
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 6.65, 1.0>
  }
  box { // Cube1319
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -0.65, 1.0>
  }
  box { // Cube1320
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -2.35, 1.0>
  }
  box { // Cube1321
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -3.65, 1.0>
  }
  box { // Cube1322
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -5.35, 1.0>
  }
  box { // Cube1323
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -6.65, 1.0>
  }
  box { // Cube1324
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 0.65, -5.0>
  }
  box { // Cube1325
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 2.35, -5.0>
  }
  box { // Cube1326
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 3.65, -5.0>
  }
  box { // Cube1327
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 5.35, -5.0>
  }
  box { // Cube1328
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, 6.65, -5.0>
  }
  box { // Cube1329
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -2.35, -5.0>
  }
  box { // Cube1330
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -0.65, -5.0>
  }
  box { // Cube1331
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -3.65, -5.0>
  }
  box { // Cube1332
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -5.35, -5.0>
  }
  box { // Cube1333
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 1.5>
    translate  <-29.7, -6.65, -5.0>
  }
  box { // Cube1334
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 0.5>
    translate  <-29.7, -1.4, 6.0>
  }
  box { // Cube1335
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 0.5>
    translate  <-29.7, 1.4, 6.0>
  }
}
#declare foesterkarmgaveltvaesCSG03 = union {
  box { // Cube1336
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 0.0, 2.4>
  }
  box { // Cube1337
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 3.0, 2.4>
  }
  box { // Cube1338
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 6.0, 2.4>
  }
  box { // Cube1339
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -3.0, 2.4>
  }
  box { // Cube1340
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -6.0, 2.4>
  }
  box { // Cube1341
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 0.0, -3.6>
  }
  box { // Cube1342
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 3.0, -3.6>
  }
  box { // Cube1343
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, 6.0, -3.6>
  }
  box { // Cube1344
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -3.0, -3.6>
  }
  box { // Cube1345
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.75, 0.1>
    translate  <-29.7, -6.0, -3.6>
  }
  box { // Cube1346
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 0.0, -6.4>
  }
  box { // Cube1347
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 3.0, -6.4>
  }
  box { // Cube1348
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 6.0, -6.4>
  }
  box { // Cube1349
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -3.0, -6.4>
  }
  box { // Cube1350
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -6.0, -6.4>
  }
  box { // Cube1351
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 0.0, -0.4>
  }
  box { // Cube1352
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 3.0, -0.4>
  }
  box { // Cube1353
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, 6.0, -0.4>
  }
  box { // Cube1354
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -3.0, -0.4>
  }
  box { // Cube1355
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.75, 0.1>
    translate  <-29.75, -6.0, -0.4>
  }
  box { // Cube1356
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.5, 0.1>
    translate  <-29.75, 0.0, 5.6>
  }
  box { // Cube1357
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.5, 0.1>
    translate  <-29.7, 0.0, 6.4>
  }
}
#declare gavelglastvaesCSG03 = union {
  box { // Cube1358
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  1.5*z
  }
  box { // Cube1359
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  0.5*z
  }
  box { // Cube1360
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  -4.5*z
  }
  box { // Cube1361
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.0, 0.1>
    translate  -5.5*z
  }
  translate  -29.6*x
}
#declare gavel2 = union {
  object { glasgavellodCSG03 }
  object { foesterkarmgavellodCSG03 }
  object { foesterkarmgaveltvaesCSG03 }
  object { gavelglastvaesCSG03 }
}
#declare foesterkarmCSG03 = union {
  object { foesterkarmtvaesCSG03 }
  object { foesterkarmtvaes3CSG03 }
  object { foesterkarmnedlodCSG03 }
  object { foesterkarmupplodCSG04 }
  object { foesterkarmtvaes1CSG03 }
  object { foesterkarmtvaes2CSG03 }
  object { glaslodCSG03 }
  object { glastvaesCSG03 }
  object { gavel2 }
  material {
    traeex
  }
}
#declare CSG118 = union {
  torus { // Torus013
    1.85, 0.15  rotate -x*90
    scale 1.622
    translate  <-18.0, -12.0, -3.0>
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <-21.0, -12.0, -3.0>
  }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <-15.0, -12.0, -3.0>
  }
  material {
    bordertex01
  }
}
#declare CSG120 = union {
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <3.0, 3.0, 2.0>
    rotate -90.0*x
    translate  <-18.0, -12.0, -3.0>
  }
  sphere { // Sphere022
    <0,0,0>,1
    material {
      bordertex01
    }
    scale 3.0
    translate  <-18.0, -12.0, -3.0>
  }
  box { // Cube1362
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 3.5>
    translate  <-18.0, -11.0, -6.5>
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 7.0>
    translate  <-18.0, -12.0, -10.0>
  }
  object { CSG118 }
  box { // Cube1363
    <-1, -1, -1>, <1, 1, 1>
    material {
      bordertex01
    }
    scale <4.444445, 1.666667, 0.555556>
    translate  <-18.0, -11.666667, -10.555556>
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    material {
      bordertex01
    }
    scale <4.444445, 4.0, 1.111111>
    translate  <-18.0, -13.333334, -11.111111>
  }
}
#declare doeroepnCSG05 = difference {
  object { CSG120 }
  box { // Cube1364
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 3.0>
    translate  <-18.0, -13.0, -7.0>
  }
  material {
    hustex3_1
  }
  scale 0.9
  translate  <-1.8, -1.0, 0.0>
}
#declare CSG121 = union {
  box { // Cube1373
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <0.0, -10.0, -5.0>
  }
  box { // Cube1374
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <0.0, -10.0, 1.0>
  }
  box { // Cube1375
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <3.0, -10.0, -5.0>
  }
  box { // Cube1376
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <6.0, -10.0, -5.0>
  }
  box { // Cube1377
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <9.0, -10.0, -5.0>
  }
  box { // Cube1378
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <12.0, -10.0, -5.0>
  }
  box { // Cube1379
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <24.0, -10.0, -5.0>
  }
  box { // Cube1380
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <27.0, -10.0, -5.0>
  }
  box { // Cube1381
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-3.0, -10.0, -5.0>
  }
  box { // Cube1382
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-6.0, -10.0, -5.0>
  }
  box { // Cube1383
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-9.0, -10.0, -5.0>
  }
  box { // Cube1384
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-12.0, -10.0, -5.0>
  }
  box { // Cube1385
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-24.0, -10.0, -5.0>
  }
  box { // Cube1386
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-27.0, -10.0, -5.0>
  }
  box { // Cube1387
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <3.0, -10.0, 1.0>
  }
  box { // Cube1388
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <6.0, -10.0, 1.0>
  }
  box { // Cube1389
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <9.0, -10.0, 1.0>
  }
  box { // Cube1390
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <12.0, -10.0, 1.0>
  }
  box { // Cube1391
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <15.0, -10.0, 1.0>
  }
  box { // Cube1392
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <21.0, -10.0, 1.0>
  }
  box { // Cube1393
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <24.0, -10.0, 1.0>
  }
  box { // Cube1394
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <27.0, -10.0, 1.0>
  }
  box { // Cube1395
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-3.0, -10.0, 1.0>
  }
  box { // Cube1396
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-6.0, -10.0, 1.0>
  }
  box { // Cube1397
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-9.0, -10.0, 1.0>
  }
  box { // Cube1398
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-12.0, -10.0, 1.0>
  }
  box { // Cube1399
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-15.0, -10.0, 1.0>
  }
  box { // Cube1400
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-21.0, -10.0, 1.0>
  }
  box { // Cube1401
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-24.0, -10.0, 1.0>
  }
  box { // Cube1402
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 1.5>
    translate  <-27.0, -10.0, 1.0>
  }
  box { // Cube1403
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 3.0, 1.0>
  }
  box { // Cube1404
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 6.0, 1.0>
  }
  box { // Cube1405
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -3.0, 1.0>
  }
  box { // Cube1406
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -6.0, 1.0>
  }
  box { // Cube1407
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 0.0, -5.0>
  }
  box { // Cube1408
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 3.0, -5.0>
  }
  box { // Cube1409
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 6.0, -5.0>
  }
  box { // Cube1410
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -3.0, -5.0>
  }
  box { // Cube1411
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, -6.0, -5.0>
  }
  box { // Cube1412
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.5, 0.5>
    translate  <-29.75, 0.0, 6.0>
  }
  box { // Cube1413
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 1.5>
    translate  <-29.75, 0.0, 1.0>
  }
}
#declare borgargrundCSG03 = difference {
  box { // Cube1365
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 10.0, 10.0>
  }
  box { // Cube1366
    <-1, -1, -1>, <1, 1, 1>
    scale <29.5, 9.5, 9.5>
  }
  box { // Cube1367
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.0, 6.0>
    rotate -59.0*x
    translate  <0.0, -5.4, 8.0>
  }
  box { // Cube1368
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 3.5, 1.5>
    translate  <0.0, -7.2, 9.5>
  }
  box { // Cube1369
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.7, 1.0>
    translate  <0.0, -9.0, 7.2>
  }
  box { // Cube1370
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.0, 6.0>
    rotate 59.0*x
    translate  <0.0, 5.4, 8.0>
  }
  box { // Cube1371
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 3.5, 1.5>
    translate  <0.0, 7.2, 9.5>
  }
  box { // Cube1372
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 1.7, 1.0>
    translate  <0.0, 9.0, 7.2>
  }
  object { CSG121 }
  material {
    hustex3_1
  }
}
#declare CSG122 = union {
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <21.0, -12.0, -3.0>
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    scale <0.245, 0.245, 2.0>
    rotate -90.0*x
    translate  <15.0, -12.0, -3.0>
  }
  torus { // Torus014
    1.85, 0.15  rotate -x*90
    scale 1.622
    translate  <18.0, -12.0, -3.0>
  }
  material {
    bordertex01
  }
  translate  -36.0*x
}
#declare CSG123 = union {
  sphere { // Sphere023
    <0,0,0>,1
    scale 3.0
    translate  <-18.0, -13.0, -3.0>
  }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    scale 3.0
    rotate -90.0*x
    translate  <-18.0, -13.0, -3.0>
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    scale <4.444445, 4.0, 1.111111>
    rotate -0.0*z
    translate  <-18.0, -13.333334, -11.111111>
  }
  box { // Cube1415
    <-1, -1, -1>, <1, 1, 1>
    scale <4.444445, 1.666667, 0.555556>
    rotate -0.0*z
    translate  <-18.0, -11.666667, -10.555556>
  }
  material {
    bordertex01
  }
  translate  1.0*y
}
#declare CSG124 = union {
  box { // Cube1414
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 3.5>
    translate  <-18.0, -11.0, -6.5>
  }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 7.0>
    translate  <-18.0, -12.0, -10.0>
  }
  object { CSG122 }
  object { CSG123 }
}
#declare doeroepnCSG06 = difference {
  object { CSG124 }
  box { // Cube1416
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 3.0>
    translate  <-18.0, -13.0, -7.0>
  }
  material {
    hustex3_1
  }
  scale 0.9
  translate  <34.2, -1.0, 0.0>
}
union { // borgarhusCSG03
  box { // gavelglastop03
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <0.1, 1.5, 0.5>
    translate  <-29.7, 0.0, 6.0>
  }
  box { // gavelglas03
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <0.1, 6.75, 4.5>
    translate  <-29.6, 0.0, -2.0>
  }
  object { borgarskorstenCSG03 }
  box { // borgarglas03
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <28.0, 0.1, 4.5>
    translate  <0.0, -9.7, -2.0>
  }
  object { alltannatCSG03 }
  object { foesterkarmCSG03 }
  object { doeroepnCSG05 }
  object { borgargrundCSG03 }
  object { doeroepnCSG06 }
  scale 0.3
  rotate 47.146648*z
  translate  <-78.801374, 76.696001, 0.0>
}


#declare CSG125 = union {
  box { // Cube1420
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.0, 6.0>
    translate  <-13.25, -8.5, 6.0>
  }
  box { // Cube1421
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 1.0, 0.5>
    translate  <-10.0, -8.5, 12.5>
  }
  box { // Cube1422
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_1
    }
    scale <3.0, 0.5, 6.0>
    translate  <-10.0, -8.0, 6.0>
  }
  box { // Cube1423
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.0, 6.0>
    translate  <-6.75, -8.5, 6.0>
  }
  material {
    gaardshustex
  }
}
#declare gaardsfoesterlistCSG03 = union {
  box { // Cube1424
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, -4.0, 6.1>
  }
  box { // Cube1425
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <0.0, -9.75, 6.1>
  }
  box { // Cube1426
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -6.4, 9.0>
  }
  box { // Cube1427
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-2.4, -9.7, 9.0>
  }
  box { // Cube1428
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <2.4, -9.7, 9.0>
  }
  box { // Cube1429
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <7.6, -9.7, 9.0>
  }
  box { // Cube1430
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <12.4, -9.7, 9.0>
  }
  box { // Cube1431
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-2.4, -9.7, 21.0>
  }
  box { // Cube1432
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <2.4, -9.7, 21.0>
  }
  box { // Cube1433
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <7.6, -9.7, 21.0>
  }
  box { // Cube1434
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <12.4, -9.7, 21.0>
  }
  box { // Cube1435
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -1.6, 9.0>
  }
  box { // Cube1436
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 1.6, 9.0>
  }
  box { // Cube1437
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 6.4, 9.0>
  }
  box { // Cube1438
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -6.4, 21.0>
  }
  box { // Cube1439
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -1.6, 21.0>
  }
  box { // Cube1440
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 1.6, 21.0>
  }
  box { // Cube1441
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 6.4, 21.0>
  }
  box { // Cube1442
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <10.0, -9.75, 6.1>
  }
  box { // Cube1443
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <0.0, -9.75, 18.1>
  }
  box { // Cube1444
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <10.0, -9.75, 18.1>
  }
  box { // Cube1445
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <0.0, -9.7, 23.9>
  }
  box { // Cube1446
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <10.0, -9.7, 23.9>
  }
  box { // Cube1447
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <0.0, -9.7, 11.9>
  }
  box { // Cube1448
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <10.0, -9.7, 11.9>
  }
  box { // Cube1449
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, 4.0, 6.1>
  }
  box { // Cube1450
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, -4.0, 18.1>
  }
  box { // Cube1451
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, 4.0, 18.1>
  }
  box { // Cube1452
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, -4.0, 23.9>
  }
  box { // Cube1453
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, 4.0, 23.9>
  }
  box { // Cube1454
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, -4.0, 11.9>
  }
  box { // Cube1455
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, 4.0, 11.9>
  }
  material {
    traeex_1
  }
}
#declare CSG126 = difference {
  box { // Cube1456
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 10.0, 14.0>
    translate  14.0*z
  }
  box { // Cube1457
    <-1, -1, -1>, <1, 1, 1>
    scale <19.5, 9.5, 14.0>
    translate  13.5*z
  }
  box { // Cube1458
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 6.0>
    translate  <-10.0, -9.75, 6.0>
  }
  box { // Cube1459
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <0.0, -9.75, 9.0>
  }
  box { // Cube1460
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <10.0, -9.75, 9.0>
  }
  box { // Cube1461
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <0.0, -9.75, 21.0>
  }
  box { // Cube1462
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <10.0, -9.75, 21.0>
  }
  box { // Cube1463
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, 4.0, 9.0>
  }
  box { // Cube1464
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, -4.0, 9.0>
  }
  box { // Cube1465
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, 4.0, 21.0>
  }
  box { // Cube1466
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, -4.0, 21.0>
  }
  box { // Cube1467
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 12.0, 1.5>
    rotate 7.0*x
    translate  28.5*z
  }
  material {
    gaardshustex
  }
}
union { // gaardshusCSG03
  box { // Cube1417
    <-1, -1, -1>, <1, 1, 1>
    material {
      gaardtaktex
    }
    scale <21.0, 11.0, 0.2>
    rotate 7.0*x
    translate  27.0*z
  }
  box { // Cube1418
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <0.1, 7.0, 9.0>
    translate  <19.6, 0.0, 15.0>
  }
  box { // Cube1419
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <8.0, 0.1, 9.0>
    translate  <5.0, -9.6, 15.0>
  }
  object { CSG125 }
  object { gaardsfoesterlistCSG03 }
  object { CSG126 }
  scale 0.15
  rotate -57.984211*z
  translate  <-56.717009, 83.270928, -2.0>
}


#declare CSG127 = union {
  box { // Cube1471
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.0, 6.0>
    translate  <-13.25, -8.5, 6.0>
  }
  box { // Cube1472
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 1.0, 0.5>
    translate  <-10.0, -8.5, 12.5>
  }
  box { // Cube1473
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_1
    }
    scale <3.0, 0.5, 6.0>
    translate  <-10.0, -8.0, 6.0>
  }
  box { // Cube1474
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.0, 6.0>
    translate  <-6.75, -8.5, 6.0>
  }
  material {
    gaardshustex
  }
}
#declare gaardsfoesterlistCSG04 = union {
  box { // Cube1475
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, -4.0, 6.1>
  }
  box { // Cube1476
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <0.0, -9.75, 6.1>
  }
  box { // Cube1477
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -6.4, 9.0>
  }
  box { // Cube1478
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-2.4, -9.7, 9.0>
  }
  box { // Cube1479
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <2.4, -9.7, 9.0>
  }
  box { // Cube1480
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <7.6, -9.7, 9.0>
  }
  box { // Cube1481
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <12.4, -9.7, 9.0>
  }
  box { // Cube1482
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-2.4, -9.7, 21.0>
  }
  box { // Cube1483
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <2.4, -9.7, 21.0>
  }
  box { // Cube1484
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <7.6, -9.7, 21.0>
  }
  box { // Cube1485
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <12.4, -9.7, 21.0>
  }
  box { // Cube1486
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -1.6, 9.0>
  }
  box { // Cube1487
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 1.6, 9.0>
  }
  box { // Cube1488
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 6.4, 9.0>
  }
  box { // Cube1489
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -6.4, 21.0>
  }
  box { // Cube1490
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -1.6, 21.0>
  }
  box { // Cube1491
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 1.6, 21.0>
  }
  box { // Cube1492
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 6.4, 21.0>
  }
  box { // Cube1493
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <10.0, -9.75, 6.1>
  }
  box { // Cube1494
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <0.0, -9.75, 18.1>
  }
  box { // Cube1495
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <10.0, -9.75, 18.1>
  }
  box { // Cube1496
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <0.0, -9.7, 23.9>
  }
  box { // Cube1497
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <10.0, -9.7, 23.9>
  }
  box { // Cube1498
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <0.0, -9.7, 11.9>
  }
  box { // Cube1499
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <10.0, -9.7, 11.9>
  }
  box { // Cube1500
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, 4.0, 6.1>
  }
  box { // Cube1501
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, -4.0, 18.1>
  }
  box { // Cube1502
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, 4.0, 18.1>
  }
  box { // Cube1503
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, -4.0, 23.9>
  }
  box { // Cube1504
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, 4.0, 23.9>
  }
  box { // Cube1505
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, -4.0, 11.9>
  }
  box { // Cube1506
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, 4.0, 11.9>
  }
  material {
    traeex_1
  }
}
#declare CSG128 = difference {
  box { // Cube1507
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 10.0, 14.0>
    translate  14.0*z
  }
  box { // Cube1508
    <-1, -1, -1>, <1, 1, 1>
    scale <19.5, 9.5, 14.0>
    translate  13.5*z
  }
  box { // Cube1509
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 6.0>
    translate  <-10.0, -9.75, 6.0>
  }
  box { // Cube1510
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <0.0, -9.75, 9.0>
  }
  box { // Cube1511
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <10.0, -9.75, 9.0>
  }
  box { // Cube1512
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <0.0, -9.75, 21.0>
  }
  box { // Cube1513
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <10.0, -9.75, 21.0>
  }
  box { // Cube1514
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, 4.0, 9.0>
  }
  box { // Cube1515
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, -4.0, 9.0>
  }
  box { // Cube1516
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, 4.0, 21.0>
  }
  box { // Cube1517
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, -4.0, 21.0>
  }
  box { // Cube1518
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 12.0, 1.5>
    rotate 7.0*x
    translate  28.5*z
  }
  material {
    gaardshustex
  }
}
union { // gaardshusCSG04
  box { // Cube1468
    <-1, -1, -1>, <1, 1, 1>
    material {
      gaardtaktex
    }
    scale <21.0, 11.0, 0.2>
    rotate 7.0*x
    translate  27.0*z
  }
  box { // Cube1469
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <0.1, 7.0, 9.0>
    translate  <19.6, 0.0, 15.0>
  }
  box { // Cube1470
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <8.0, 0.1, 9.0>
    translate  <5.0, -9.6, 15.0>
  }
  object { CSG127 }
  object { gaardsfoesterlistCSG04 }
  object { CSG128 }
  scale 0.15
  rotate 2.67021*z
  translate  <-61.679359, 84.79196, -2.0>
}


#declare CSG131 = union {
  box { // Cube1573
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.0, 6.0>
    translate  <-13.25, -8.5, 6.0>
  }
  box { // Cube1574
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 1.0, 0.5>
    translate  <-10.0, -8.5, 12.5>
  }
  box { // Cube1575
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_1
    }
    scale <3.0, 0.5, 6.0>
    translate  <-10.0, -8.0, 6.0>
  }
  box { // Cube1576
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.0, 6.0>
    translate  <-6.75, -8.5, 6.0>
  }
  material {
    gaardshustex
  }
}
#declare gaardsfoesterlistCSG06 = union {
  box { // Cube1577
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, -4.0, 6.1>
  }
  box { // Cube1578
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <0.0, -9.75, 6.1>
  }
  box { // Cube1579
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -6.4, 9.0>
  }
  box { // Cube1580
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-2.4, -9.7, 9.0>
  }
  box { // Cube1581
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <2.4, -9.7, 9.0>
  }
  box { // Cube1582
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <7.6, -9.7, 9.0>
  }
  box { // Cube1583
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <12.4, -9.7, 9.0>
  }
  box { // Cube1584
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <-2.4, -9.7, 21.0>
  }
  box { // Cube1585
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <2.4, -9.7, 21.0>
  }
  box { // Cube1586
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <7.6, -9.7, 21.0>
  }
  box { // Cube1587
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.2, 3.0>
    translate  <12.4, -9.7, 21.0>
  }
  box { // Cube1588
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -1.6, 9.0>
  }
  box { // Cube1589
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 1.6, 9.0>
  }
  box { // Cube1590
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 6.4, 9.0>
  }
  box { // Cube1591
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -6.4, 21.0>
  }
  box { // Cube1592
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, -1.6, 21.0>
  }
  box { // Cube1593
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 1.6, 21.0>
  }
  box { // Cube1594
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 3.0>
    translate  <19.7, 6.4, 21.0>
  }
  box { // Cube1595
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <10.0, -9.75, 6.1>
  }
  box { // Cube1596
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <0.0, -9.75, 18.1>
  }
  box { // Cube1597
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.25, 0.1>
    translate  <10.0, -9.75, 18.1>
  }
  box { // Cube1598
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <0.0, -9.7, 23.9>
  }
  box { // Cube1599
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <10.0, -9.7, 23.9>
  }
  box { // Cube1600
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <0.0, -9.7, 11.9>
  }
  box { // Cube1601
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.2, 0.1>
    translate  <10.0, -9.7, 11.9>
  }
  box { // Cube1602
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, 4.0, 6.1>
  }
  box { // Cube1603
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, -4.0, 18.1>
  }
  box { // Cube1604
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.5, 0.1>
    translate  <19.75, 4.0, 18.1>
  }
  box { // Cube1605
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, -4.0, 23.9>
  }
  box { // Cube1606
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, 4.0, 23.9>
  }
  box { // Cube1607
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, -4.0, 11.9>
  }
  box { // Cube1608
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 0.1>
    translate  <19.7, 4.0, 11.9>
  }
  material {
    traeex_1
  }
}
#declare CSG132 = difference {
  box { // Cube1609
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 10.0, 14.0>
    translate  14.0*z
  }
  box { // Cube1610
    <-1, -1, -1>, <1, 1, 1>
    scale <19.5, 9.5, 14.0>
    translate  13.5*z
  }
  box { // Cube1611
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 6.0>
    translate  <-10.0, -9.75, 6.0>
  }
  box { // Cube1612
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <0.0, -9.75, 9.0>
  }
  box { // Cube1613
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <10.0, -9.75, 9.0>
  }
  box { // Cube1614
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <0.0, -9.75, 21.0>
  }
  box { // Cube1615
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.5, 3.0>
    translate  <10.0, -9.75, 21.0>
  }
  box { // Cube1616
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, 4.0, 9.0>
  }
  box { // Cube1617
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, -4.0, 9.0>
  }
  box { // Cube1618
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, 4.0, 21.0>
  }
  box { // Cube1619
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.5, 3.0>
    translate  <19.75, -4.0, 21.0>
  }
  box { // Cube1620
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 12.0, 1.5>
    rotate 7.0*x
    translate  28.5*z
  }
  material {
    gaardshustex
  }
}
union { // gaardshusCSG06
  box { // Cube1570
    <-1, -1, -1>, <1, 1, 1>
    material {
      gaardtaktex
    }
    scale <21.0, 11.0, 0.2>
    rotate 7.0*x
    translate  27.0*z
  }
  box { // Cube1571
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <0.1, 7.0, 9.0>
    translate  <19.6, 0.0, 15.0>
  }
  box { // Cube1572
    <-1, -1, -1>, <1, 1, 1>
    material {
      glastex
    }
    scale <8.0, 0.1, 9.0>
    translate  <5.0, -9.6, 15.0>
  }
  object { CSG131 }
  object { gaardsfoesterlistCSG06 }
  object { CSG132 }
  scale <0.15, 0.3, 0.18>
  rotate 103.06028*z
  translate  <-72.043446, 90.910951, -2.0>
}


union { // takCSG02
  box { // Cube1623
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 0.2, 6.0>
    rotate -59.0*x
    translate  <0.0, -5.0, 5.921646>
  }
  box { // Cube1624
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 0.2, 6.0>
    rotate 59.0*x
    translate  <0.0, 5.0, 7.0>
  }
  material {
    plattex
  }
  scale <0.25, 0.2, 0.35>
  translate  <-60.092777, 97.837494, 1.112214>
}


union { // takCSG03
  box { // Cube1625
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 0.2, 6.0>
    rotate -59.0*x
    translate  <0.0, -5.0, 7.0>
  }
  box { // Cube1626
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 0.2, 6.0>
    rotate 59.0*x
    translate  <0.0, 5.0, 7.0>
  }
  material {
    svarttex
  }
  scale <0.2, 0.2, 0.3>
  translate  <-94.3709, 82.997772, 0.223843>
}


union { // takCSG04
  box { // Cube1627
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 0.2, 6.0>
    rotate -59.0*x
    translate  <0.0, -5.0, 7.0>
  }
  box { // Cube1628
    <-1, -1, -1>, <1, 1, 1>
    scale <31.0, 0.2, 6.0>
    rotate 59.0*x
    translate  <0.0, 5.0, 7.0>
  }
  material {
    jaentex
  }
  scale <0.1, 0.2, 0.4>
  translate  <-43.609228, 108.752017, 1.511126>
}


#declare RndDisc001 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7000, 0.7000, 1.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.4000> translate 0.3000*z }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.7000*z bounded_by { box { <-1.0060, -1.0060, 0.3940>, <1.0060, 1.0060, 1.0060> } } }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.3000*z bounded_by { box { <-1.0060, -1.0060, -0.0060>, <1.0060, 1.0060, 0.6060> } } }
  scale <1.0, 1.25, 0.5>
  translate  <0.0, 0.2, 1.0>
}
union { // kajsakCSG01
  object { RndDisc001 }
  cone { // Cone024
    <0,0,0>, 1.0, <0,0,1>, 0.7
  }
  material {
    svarttex
  }
  scale 0.4
  rotate 90.0*z
  translate  <-22.0, 25.0, -2.0>
}


#declare RndDisc002 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7000, 0.7000, 1.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.4000> translate 0.3000*z }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.7000*z bounded_by { box { <-1.0060, -1.0060, 0.3940>, <1.0060, 1.0060, 1.0060> } } }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.3000*z bounded_by { box { <-1.0060, -1.0060, -0.0060>, <1.0060, 1.0060, 0.6060> } } }
  scale <1.0, 1.25, 0.5>
  translate  <0.0, 0.2, 1.0>
}
union { // kajsakCSG02
  object { RndDisc002 }
  cone { // Cone025
    <0,0,0>, 1.0, <0,0,1>, 0.7
  }
  material {
    svarttex
  }
  scale 0.4
  rotate 90.0*z
  translate  <-30.0, 35.0, -2.0>
}


#declare RndDisc003 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7000, 0.7000, 1.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.4000> translate 0.3000*z }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.7000*z bounded_by { box { <-1.0060, -1.0060, 0.3940>, <1.0060, 1.0060, 1.0060> } } }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.3000*z bounded_by { box { <-1.0060, -1.0060, -0.0060>, <1.0060, 1.0060, 0.6060> } } }
  scale <1.0, 1.25, 0.5>
  translate  <0.0, 0.2, 1.0>
}
union { // kajsakCSG03
  object { RndDisc003 }
  cone { // Cone026
    <0,0,0>, 1.0, <0,0,1>, 0.7
  }
  material {
    svarttex
  }
  scale 0.4
  rotate -40.0*z
  translate  <-68.5, -23.5, -2.0>
}


#declare RndDisc004 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7000, 0.7000, 1.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.4000> translate 0.3000*z }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.7000*z bounded_by { box { <-1.0060, -1.0060, 0.3940>, <1.0060, 1.0060, 1.0060> } } }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.3000*z bounded_by { box { <-1.0060, -1.0060, -0.0060>, <1.0060, 1.0060, 0.6060> } } }
  scale <1.0, 1.25, 0.5>
  translate  <0.0, 0.2, 1.0>
}
union { // kajsakCSG04
  object { RndDisc004 }
  cone { // Cone027
    <0,0,0>, 1.0, <0,0,1>, 0.7
  }
  material {
    svarttex
  }
  scale 0.4
  rotate 90.0*z
  translate  <-86.0, 35.0, -2.0>
}


#declare RndDisc005 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7000, 0.7000, 1.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.4000> translate 0.3000*z }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.7000*z bounded_by { box { <-1.0060, -1.0060, 0.3940>, <1.0060, 1.0060, 1.0060> } } }
  torus { 0.7000, 0.3000  rotate -x*90 translate  0.3000*z bounded_by { box { <-1.0060, -1.0060, -0.0060>, <1.0060, 1.0060, 0.6060> } } }
  scale <1.0, 1.25, 0.5>
  translate  <0.0, 0.2, 1.0>
}
union { // kajsakCSG05
  object { RndDisc005 }
  cone { // Cone028
    <0,0,0>, 1.0, <0,0,1>, 0.7
  }
  material {
    svarttex
  }
  scale 0.4
  rotate 90.0*z
  translate  <-70.0, 35.0, -2.0>
}


#declare CSG135 = difference {
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
  }
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, -0.5, 1.0>
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, 0.5, 1.0>
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, 0.43, 1.0>
  }
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, 0.43, 1.0>
  }
}
#declare CSG136 = union {
  object { CSG135 }
  torus { // Torus020
    1.1, 0.2  rotate -x*90
    scale 0.5
    translate  10.0*z
  }
  torus { // Torus021
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  9.0*z
  }
  torus { // Torus022
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  2.0*z
  }
  sphere { // Sphere026
    <0,0,0>,1
    scale <1.0, 1.0, 0.2>
    translate  11.5*z
  }
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  1.0*z
  }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1 
  }
  torus { // Torus023
    1.0, 0.2  rotate -x*90
    translate  0.8*z
  }
  cone { // Cone031
    <0,0,0>, 0.5, <0,0,1>, 1.0
    rotate <180.0, 0.0, 180.0>
    translate  2.0*z
  }
  torus { // Torus024
    1.0, 0.2  rotate -x*90
    translate  0.2*z
  }
  material {
    lamptex
  }
}
union { // gatlyktaCSG02
  object { CSG136 }
  cone { // Cone032
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      lamplamptex
    }
    scale <1.0, 1.0, 1.5>
    translate  10.0*z
  }
  scale 0.25
  translate  <-63.377115, 54.533584, -2.0>
}


#declare CSG137 = difference {
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
  }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, -0.5, 1.0>
  }
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, 0.5, 1.0>
  }
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, 0.43, 1.0>
  }
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, 0.43, 1.0>
  }
}
#declare CSG138 = union {
  object { CSG137 }
  torus { // Torus025
    1.1, 0.2  rotate -x*90
    scale 0.5
    translate  10.0*z
  }
  torus { // Torus026
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  9.0*z
  }
  torus { // Torus027
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  2.0*z
  }
  sphere { // Sphere027
    <0,0,0>,1
    scale <1.0, 1.0, 0.2>
    translate  11.5*z
  }
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  1.0*z
  }
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1 
  }
  torus { // Torus028
    1.0, 0.2  rotate -x*90
    translate  0.8*z
  }
  cone { // Cone033
    <0,0,0>, 0.5, <0,0,1>, 1.0
    rotate <180.0, 0.0, 180.0>
    translate  2.0*z
  }
  torus { // Torus029
    1.0, 0.2  rotate -x*90
    translate  0.2*z
  }
  material {
    lamptex
  }
}
union { // gatlyktaCSG03
  object { CSG138 }
  cone { // Cone034
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      lamplamptex
    }
    scale <1.0, 1.0, 1.5>
    translate  10.0*z
  }
  scale 0.25
  translate  <-59.566083, 65.879254, -2.0>
}


#declare CSG139 = difference {
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
  }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, -0.5, 1.0>
  }
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, 0.5, 1.0>
  }
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, 0.43, 1.0>
  }
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, 0.43, 1.0>
  }
}
#declare CSG140 = union {
  object { CSG139 }
  torus { // Torus030
    1.1, 0.2  rotate -x*90
    scale 0.5
    translate  10.0*z
  }
  torus { // Torus031
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  9.0*z
  }
  torus { // Torus032
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  2.0*z
  }
  sphere { // Sphere028
    <0,0,0>,1
    scale <1.0, 1.0, 0.2>
    translate  11.5*z
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  1.0*z
  }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
  }
  torus { // Torus033
    1.0, 0.2  rotate -x*90
    translate  0.8*z
  }
  cone { // Cone035
    <0,0,0>, 0.5, <0,0,1>, 1.0
    rotate <180.0, 0.0, 180.0>
    translate  2.0*z
  }
  torus { // Torus034
    1.0, 0.2  rotate -x*90
    translate  0.2*z
  }
  material {
    lamptex
  }
}
union { // gatlyktaCSG04
  object { CSG140 }
  cone { // Cone036
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      lamplamptex
    }
    scale <1.0, 1.0, 1.5>
    translate  10.0*z
  }
  scale 0.25
  translate  <-47.407215, 65.234289, -2.0>
}


#declare CSG141 = difference {
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
  }
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, -0.5, 1.0>
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, 0.5, 1.0>
  }
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, 0.43, 1.0>
  }
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, 0.43, 1.0>
  }
}
#declare CSG142 = union {
  object { CSG141 }
  torus { // Torus035
    1.1, 0.2  rotate -x*90
    scale 0.5
    translate  10.0*z
  }
  torus { // Torus036
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  9.0*z
  }
  torus { // Torus037
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  2.0*z
  }
  sphere { // Sphere029
    <0,0,0>,1
    scale <1.0, 1.0, 0.2>
    translate  11.5*z
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  1.0*z
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1 
  }
  torus { // Torus038
    1.0, 0.2  rotate -x*90
    translate  0.8*z
  }
  cone { // Cone037
    <0,0,0>, 0.5, <0,0,1>, 1.0
    rotate <180.0, 0.0, 180.0>
    translate  2.0*z
  }
  torus { // Torus039
    1.0, 0.2  rotate -x*90
    translate  0.2*z
  }
  material {
    lamptex
  }
  translate  <1.044796, 33.433468, 0.0>
}
union { // gatlyktaCSG05
  object { CSG142 }
  cone { // Cone038
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      lamplamptex
    }
    scale <1.0, 1.0, 1.5>
    translate  10.0*z
  }
  scale 0.25
  translate  <-70.527357, 42.967074, -2.0>
}


#declare CSG143 = difference {
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
  }
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, -0.5, 1.0>
  }
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, 0.5, 1.0>
  }
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, 0.43, 1.0>
  }
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, 0.43, 1.0>
  }
}
#declare CSG144 = union {
  object { CSG143 }
  torus { // Torus040
    1.1, 0.2  rotate -x*90
    scale 0.5
    translate  10.0*z
  }
  torus { // Torus041
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  9.0*z
  }
  torus { // Torus042
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  2.0*z
  }
  sphere { // Sphere030
    <0,0,0>,1
    scale <1.0, 1.0, 0.2>
    translate  11.5*z
  }
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  1.0*z
  }
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1 
  }
  torus { // Torus043
    1.0, 0.2  rotate -x*90
    translate  0.8*z
  }
  cone { // Cone039
    <0,0,0>, 0.5, <0,0,1>, 1.0
    rotate <180.0, 0.0, 180.0>
    translate  2.0*z
  }
  torus { // Torus044
    1.0, 0.2  rotate -x*90
    translate  0.2*z
  }
  material {
    lamptex
  }
}
union { // gatlyktaCSG06
  object { CSG144 }
  cone { // Cone040
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      lamplamptex
    }
    scale <1.0, 1.0, 1.5>
    translate  10.0*z
  }
  scale 0.25
  translate  <-85.679232, 43.972249, -2.0>
}


#declare CSG145 = difference {
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
  }
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, -0.5, 1.0>
  }
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, 0.5, 1.0>
  }
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr296
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr297
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr298
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, 0.43, 1.0>
  }
  cylinder { // Cylndr299
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr300
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, 0.43, 1.0>
  }
}
#declare CSG146 = union {
  object { CSG145 }
  torus { // Torus045
    1.1, 0.2  rotate -x*90
    scale 0.5
    translate  10.0*z
  }
  torus { // Torus046
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  9.0*z
  }
  torus { // Torus047
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  2.0*z
  }
  sphere { // Sphere031
    <0,0,0>,1
    scale <1.0, 1.0, 0.2>
    translate  11.5*z
  }
  cylinder { // Cylndr301
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  1.0*z
  }
  cylinder { // Cylndr302
    <0,0,1>, <0,0,0>, 1 
  }
  torus { // Torus048
    1.0, 0.2  rotate -x*90
    translate  0.8*z
  }
  cone { // Cone041
    <0,0,0>, 0.5, <0,0,1>, 1.0
    rotate <180.0, 0.0, 180.0>
    translate  2.0*z
  }
  torus { // Torus049
    1.0, 0.2  rotate -x*90
    translate  0.2*z
  }
  material {
    lamptex
  }
}
union { // gatlyktaCSG07
  object { CSG146 }
  cone { // Cone042
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      lamplamptex
    }
    scale <1.0, 1.0, 1.5>
    translate  10.0*z
  }
  scale 0.25
  translate  <-77.789063, 71.487447, -2.0>
}


#declare CSG147 = difference {
  cylinder { // Cylndr303
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
  }
  cylinder { // Cylndr304
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, -0.5, 1.0>
  }
  cylinder { // Cylndr305
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr306
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, 0.5, 1.0>
  }
  cylinder { // Cylndr307
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr308
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr309
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr310
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr311
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr312
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr313
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, 0.43, 1.0>
  }
  cylinder { // Cylndr314
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr315
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, 0.43, 1.0>
  }
}
#declare CSG148 = union {
  object { CSG147 }
  torus { // Torus050
    1.1, 0.2  rotate -x*90
    scale 0.5
    translate  10.0*z
  }
  torus { // Torus051
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  9.0*z
  }
  torus { // Torus052
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  2.0*z
  }
  sphere { // Sphere032
    <0,0,0>,1
    scale <1.0, 1.0, 0.2>
    translate  11.5*z
  }
  cylinder { // Cylndr316
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  1.0*z
  }
  cylinder { // Cylndr317
    <0,0,1>, <0,0,0>, 1 
  }
  torus { // Torus053
    1.0, 0.2  rotate -x*90
    translate  0.8*z
  }
  cone { // Cone043
    <0,0,0>, 0.5, <0,0,1>, 1.0
    rotate <180.0, 0.0, 180.0>
    translate  2.0*z
  }
  torus { // Torus054
    1.0, 0.2  rotate -x*90
    translate  0.2*z
  }
  material {
    lamptex
  }
}
union { // gatlyktaCSG08
  object { CSG148 }
  cone { // Cone044
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      lamplamptex
    }
    scale <1.0, 1.0, 1.5>
    translate  10.0*z
  }
  scale 0.25
  translate  <-70.560762, 78.971246, -2.0>
}


#declare CSG149 = union {
  box { // Cube1629
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.0, 5.0, 3.0>
  }
  box { // Cube1630
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.5, 5.5, 1.0>
    translate  -4.0*z
  }
  box { // Cube1631
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, 4.5, 0.0>
  }
  box { // Cube1632
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, 4.5, 0.0>
  }
  box { // Cube1633
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, 4.5, 0.0>
  }
  box { // Cube1634
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, -4.5, 0.0>
  }
  box { // Cube1635
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, -4.5, 0.0>
  }
  box { // Cube1636
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, 4.5, 0.0>
  }
  box { // Cube1637
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, -4.5, 0.0>
  }
  box { // Cube1638
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, -4.5, 0.0>
  }
  box { // Cube1639
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, 1.5, 0.0>
  }
  box { // Cube1640
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, -1.5, 0.0>
  }
  box { // Cube1641
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, 1.5, 0.0>
  }
  box { // Cube1642
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, -1.5, 0.0>
  }
  box { // Cube1643
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <5.5, 5.5, 1.0>
    translate  4.0*z
  }
}
#declare RndCube010 = merge {
  sphere { <0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, 0.4400, -0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  box { <-0.4400, -0.4400, -0.5000> <0.4400, 0.4400, 0.5000> }
  box { <-0.4400, -0.5000, -0.4400> <0.4400, 0.5000, 0.4400> }
  box { <-0.5000, -0.4400, -0.4400> <0.5000, 0.4400, 0.4400> }
// Attributes returned success!
  material {
    boxtex1
  }
  scale <11.0, 11.0, 10.0>
}
intersection { // boxCSG01
  object { CSG149 }
  object { RndCube010 }
  scale 0.1
  translate  <-75.011771, -19.559098, -1.5>
}


#declare CSG150 = union {
  box { // Cube1644
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1_1
    }
    scale <5.0, 5.0, 3.0>
  }
  box { // Cube1645
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1_1
    }
    scale <5.5, 5.5, 1.0>
    translate  -4.0*z
  }
  box { // Cube1646
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1_1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, 4.5, 0.0>
  }
  box { // Cube1647
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1_1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, 4.5, 0.0>
  }
  box { // Cube1648
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2_1
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, 4.5, 0.0>
  }
  box { // Cube1649
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1_1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, -4.5, 0.0>
  }
  box { // Cube1650
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2_1
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, -4.5, 0.0>
  }
  box { // Cube1651
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2_1
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, 4.5, 0.0>
  }
  box { // Cube1652
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1_1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, -4.5, 0.0>
  }
  box { // Cube1653
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2_1
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, -4.5, 0.0>
  }
  box { // Cube1654
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1_1
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, 1.5, 0.0>
  }
  box { // Cube1655
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2_1
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, -1.5, 0.0>
  }
  box { // Cube1656
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2_1
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, 1.5, 0.0>
  }
  box { // Cube1657
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1_1
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, -1.5, 0.0>
  }
  box { // Cube1658
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2_1
    }
    scale <5.5, 5.5, 1.0>
    translate  4.0*z
  }
}
#declare RndCube011 = merge {
  sphere { <0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, 0.4400, -0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  box { <-0.4400, -0.4400, -0.5000> <0.4400, 0.4400, 0.5000> }
  box { <-0.4400, -0.5000, -0.4400> <0.4400, 0.5000, 0.4400> }
  box { <-0.5000, -0.4400, -0.4400> <0.5000, 0.4400, 0.4400> }
// Attributes returned success!
  material {
    boxtex1_1
  }
  scale <11.0, 11.0, 10.0>
}
intersection { // boxCSG02
  object { CSG150 }
  object { RndCube011 }
  scale 0.1
  translate  <-76.388008, -19.013255, -1.5>
}


#declare CSG151 = union {
  box { // Cube1659
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.0, 5.0, 3.0>
  }
  box { // Cube1660
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.5, 5.5, 1.0>
    translate  -4.0*z
  }
  box { // Cube1661
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, 4.5, 0.0>
  }
  box { // Cube1662
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, 4.5, 0.0>
  }
  box { // Cube1663
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, 4.5, 0.0>
  }
  box { // Cube1664
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, -4.5, 0.0>
  }
  box { // Cube1665
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, -4.5, 0.0>
  }
  box { // Cube1666
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, 4.5, 0.0>
  }
  box { // Cube1667
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, -4.5, 0.0>
  }
  box { // Cube1668
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, -4.5, 0.0>
  }
  box { // Cube1669
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, 1.5, 0.0>
  }
  box { // Cube1670
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, -1.5, 0.0>
  }
  box { // Cube1671
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, 1.5, 0.0>
  }
  box { // Cube1672
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, -1.5, 0.0>
  }
  box { // Cube1673
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <5.5, 5.5, 1.0>
    translate  4.0*z
  }
}
#declare RndCube012 = merge {
  sphere { <0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, 0.4400, -0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  box { <-0.4400, -0.4400, -0.5000> <0.4400, 0.4400, 0.5000> }
  box { <-0.4400, -0.5000, -0.4400> <0.4400, 0.5000, 0.4400> }
  box { <-0.5000, -0.4400, -0.4400> <0.5000, 0.4400, 0.4400> }
// Attributes returned success!
  material {
    boxtex1
  }
  scale <11.0, 11.0, 10.0>
}
intersection { // boxCSG03
  object { CSG151 }
  object { RndCube012 }
  scale 0.1
  translate  <-75.571679, -18.690225, -0.5>
}


#declare CSG152 = union {
  box { // Cube1674
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.0, 5.0, 3.0>
  }
  box { // Cube1675
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.5, 5.5, 1.0>
    translate  -4.0*z
  }
  box { // Cube1676
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, 4.5, 0.0>
  }
  box { // Cube1677
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, 4.5, 0.0>
  }
  box { // Cube1678
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, 4.5, 0.0>
  }
  box { // Cube1679
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, -4.5, 0.0>
  }
  box { // Cube1680
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, -4.5, 0.0>
  }
  box { // Cube1681
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, 4.5, 0.0>
  }
  box { // Cube1682
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, -4.5, 0.0>
  }
  box { // Cube1683
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, -4.5, 0.0>
  }
  box { // Cube1684
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, 1.5, 0.0>
  }
  box { // Cube1685
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, -1.5, 0.0>
  }
  box { // Cube1686
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, 1.5, 0.0>
  }
  box { // Cube1687
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, -1.5, 0.0>
  }
  box { // Cube1688
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <5.5, 5.5, 1.0>
    translate  4.0*z
  }
}
#declare RndCube013 = merge {
  sphere { <0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, 0.4400, -0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  box { <-0.4400, -0.4400, -0.5000> <0.4400, 0.4400, 0.5000> }
  box { <-0.4400, -0.5000, -0.4400> <0.4400, 0.5000, 0.4400> }
  box { <-0.5000, -0.4400, -0.4400> <0.5000, 0.4400, 0.4400> }
// Attributes returned success!
  material {
    boxtex1
  }
  scale <11.0, 11.0, 10.0>
}
intersection { // boxCSG04
  object { CSG152 }
  object { RndCube013 }
  scale 0.15
  translate  <-72.643429, -18.43593, -1.25>
}


#declare CSG101 = union {
  torus { // Torus055
    1.9, 0.4  rotate -x*90
    scale <1.0, 1.0, 0.5>
    rotate -90.0*x
    translate  <0.0, -5.0, -2.0>
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    scale <1.7, 1.7, 1.0>
    rotate -90.0*x
    translate  <0.0, -5.05, -2.0>
  }
}
#declare CSG010 = difference {
  object { CSG101 }
  box { // Cube200
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 1.5>
    translate  <0.0, -5.0, -3.5>
  }
}
#declare CSG345 = union {
  object { CSG010 }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.2, 3.0>
    translate  <-1.9, -5.0, -5.0>
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.2, 3.0>
    translate  <1.9, -5.0, -5.0>
  }
  material {
    raadgrundtex
  }
}
#declare raadportCSG01 = union {
  object { CSG345 }
  cylinder { // raadtrappaned01
    <0,0,1>, <0,0,0>, 1 
    material {
      raadgrundtex
    }
    scale <4.5, 3.0, 0.5>
    translate  <0.0, -5.0, -6.0>
  }
  cylinder { // raadtrappaupp01
    <0,0,1>, <0,0,0>, 1 
    material {
      raadgrundtex
    }
    scale <3.0, 2.0, 0.5>
    translate  <0.0, -5.0, -5.5>
  }
  box { // raadmellandoer01
    <-1, -1, -1>, <1, 1, 1>
    material {
      svarttex
    }
    scale <0.1, 0.1, 1.5>
    translate  <0.0, -4.85, -3.5>
  }
  box { // raaddoerleft
    <-1, -1, -1>, <1, 1, 1>
    material {
      raadjaentex
    }
    scale <0.7, 0.1, 1.5>
    translate  <-0.8, -4.85, -3.5>
  }
  box { // raaddoerright
    <-1, -1, -1>, <1, 1, 1>
    material {
      raadjaentex
    }
    scale <0.7, 0.1, 1.5>
    translate  <0.8, -4.85, -3.5>
  }
}
#declare CSG102 = union {
  torus { // Torus056
    1.95, 0.05  rotate -x*90
    scale <1.54, 1.54, 1.5>
    rotate <-90.0, 0.0, -15.0>
    translate  6.0*z
  }
  torus { // Torus057
    1.95, 0.05  rotate -x*90
    scale <1.54, 1.54, 1.5>
    rotate <-90.0, 0.0, -45.0>
    translate  6.0*z
  }
  torus { // Torus058
    1.95, 0.05  rotate -x*90
    scale <1.54, 1.54, 1.5>
    rotate <-90.0, 0.0, -75.0>
    translate  6.0*z
  }
  torus { // Torus059
    1.95, 0.05  rotate -x*90
    scale <1.54, 1.54, 1.5>
    rotate <-90.0, 0.0, 15.0>
    translate  6.0*z
  }
  torus { // Torus060
    1.95, 0.05  rotate -x*90
    scale <1.54, 1.54, 1.5>
    rotate <-90.0, 0.0, 45.0>
    translate  6.0*z
  }
  torus { // Torus061
    1.95, 0.05  rotate -x*90
    scale <1.54, 1.54, 1.5>
    rotate <-90.0, 0.0, 75.0>
    translate  6.0*z
  }
  material {
    raadtaktex
  }
}
#declare raadtoptopCSG01 = union {
  sphere { // Sphere024
    <0,0,0>,1
    material {
      raadtaktex
    }
    scale <0.7, 0.7, 0.4>
    translate  8.87*z
  }
  sphere { // Sphere033
    <0,0,0>,1
    material {
      raadtaktex
    }
    scale 3.0
    translate  6.0*z
  }
  cone { // Cone045
    <0,0,0>, 0.2, <0,0,1>, 0.05
    material {
      kyrkbordertex_1
    }
    scale <1.0, 1.0, 3.5>
    translate  8.5*z
  }
  sphere { // Sphere034
    <0,0,0>,1
    material {
      kyrkbordertex_1
    }
    scale 0.3
    translate  11.0*z
  }
  object { CSG102 }
}
#declare CSG103 = difference {
  cylinder { // Cylndr318
    <0,0,1>, <0,0,0>, 1 
    scale <3.08, 3.08, 3.0>
    translate  3.0*z
  }
  box { // Cube519
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 3.5, 2.0>
    translate  3.2*z
  }
  cylinder { // Cylndr319
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 7.0>
    rotate -90.0*y
    translate  <3.5, 0.0, 5.2>
  }
  cylinder { // Cylndr320
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 7.0>
    rotate -90.0*x
    translate  <0.0, -3.5, 5.2>
  }
  cylinder { // Cylndr321
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 7.0>
    rotate <-90.0, 0.0, -30.0>
    translate  <-1.8, -3.0, 5.2>
  }
  cylinder { // Cylndr322
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 7.0>
    rotate <-90.0, 0.0, 30.0>
    translate  <1.8, -3.0, 5.2>
  }
  cylinder { // Cylndr323
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 7.0>
    rotate <-90.0, 0.0, -60.0>
    translate  <-3.0, -1.7, 5.2>
  }
  cylinder { // Cylndr324
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 7.0>
    rotate <-90.0, 0.0, 60.0>
    translate  <3.0, -1.7, 5.2>
  }
}
#declare raadtaktopnerCSG01 = union {
  object { CSG103 }
  cylinder { // Cylndr325
    <0,0,1>, <0,0,0>, 1 
    scale 3.0
    translate  3.0*z
  }
  torus { // Torus062
    1.9, 0.1  rotate -x*90
    scale 1.58
    translate  6.0*z
  }
  torus { // Torus063
    1.9, 0.1  rotate -x*90
    scale 1.58
    translate  4.25*z
  }
  material {
    raadgrundtex
  }
}
#declare raadkupolCSG01 = union {
  object { raadtoptopCSG01 }
  object { raadtaktopnerCSG01 }
}
#declare raadfoesterkarmCSG02 = union {
  box { // Cube520
    <-1, -1, -1>, <1, 1, 1>
    scale <14.0, 0.1, 0.05>
    translate  <0.0, -4.8, 0.25>
  }
  box { // Cube521
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <-3.0, -4.8, -1.35>
  }
  box { // Cube522
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <-4.5, -4.8, -1.35>
  }
  box { // Cube523
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <-6.0, -4.8, -1.35>
  }
  box { // Cube524
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <-7.5, -4.8, -1.35>
  }
  box { // Cube525
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <-9.0, -4.8, -1.35>
  }
  box { // Cube526
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <-10.5, -4.8, -1.35>
  }
  box { // Cube527
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <-12.0, -4.8, -1.35>
  }
  box { // Cube528
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <-13.5, -4.8, -1.35>
  }
  box { // Cube529
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <3.0, -4.8, -1.35>
  }
  box { // Cube530
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <4.5, -4.8, -1.35>
  }
  box { // Cube531
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <6.0, -4.8, -1.35>
  }
  box { // Cube532
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <7.5, -4.8, -1.35>
  }
  box { // Cube533
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <9.0, -4.8, -1.35>
  }
  box { // Cube534
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <10.5, -4.8, -1.35>
  }
  box { // Cube535
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <12.0, -4.8, -1.35>
  }
  box { // Cube536
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 2.1>
    translate  <13.5, -4.8, -1.35>
  }
  box { // Cube537
    <-1, -1, -1>, <1, 1, 1>
    scale <14.0, 0.1, 0.05>
    translate  <0.0, -4.8, -0.25>
  }
  box { // Cube538
    <-1, -1, -1>, <1, 1, 1>
    scale <14.0, 0.1, 0.05>
    translate  <0.0, -4.8, -2.45>
  }
  box { // Cube539
    <-1, -1, -1>, <1, 1, 1>
    scale <14.0, 0.1, 0.05>
    translate  <0.0, -4.8, -2.95>
  }
  material {
    raadjaentex
  }
  translate  -0.05*y
}
#declare raadfoesterkarmCSG01 = union {
  box { // Cube540
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-11.6, -4.9, -1.3>
  }
  box { // Cube541
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-3.4, -4.9, -1.3>
  }
  box { // Cube542
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-4.1, -4.9, -1.3>
  }
  box { // Cube543
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-4.9, -4.9, -1.3>
  }
  box { // Cube544
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-5.6, -4.9, -1.3>
  }
  box { // Cube545
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-6.4, -4.9, -1.3>
  }
  box { // Cube546
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-7.1, -4.9, -1.3>
  }
  box { // Cube547
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-7.9, -4.9, -1.3>
  }
  box { // Cube548
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-8.6, -4.9, -1.3>
  }
  box { // Cube549
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-9.4, -4.9, -1.3>
  }
  box { // Cube550
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-10.1, -4.9, -1.3>
  }
  box { // Cube551
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-2.6, -4.9, -1.3>
  }
  box { // Cube552
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-10.9, -4.9, -1.3>
  }
  box { // Cube553
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-12.4, -4.9, -1.3>
  }
  box { // Cube554
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-13.1, -4.9, -1.3>
  }
  box { // Cube555
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <-13.9, -4.9, -1.3>
  }
  box { // Cube556
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <2.6, -4.9, -1.3>
  }
  box { // Cube557
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <3.4, -4.9, -1.3>
  }
  box { // Cube558
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <4.1, -4.9, -1.3>
  }
  box { // Cube559
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <4.9, -4.9, -1.3>
  }
  box { // Cube560
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <5.6, -4.9, -1.3>
  }
  box { // Cube561
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <6.4, -4.9, -1.3>
  }
  box { // Cube562
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <7.1, -4.9, -1.3>
  }
  box { // Cube563
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <7.9, -4.9, -1.3>
  }
  box { // Cube564
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <8.6, -4.9, -1.3>
  }
  box { // Cube565
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <9.4, -4.9, -1.3>
  }
  box { // Cube566
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <10.1, -4.9, -1.3>
  }
  box { // Cube567
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <10.9, -4.9, -1.3>
  }
  box { // Cube568
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <11.6, -4.9, -1.3>
  }
  box { // Cube569
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <12.4, -4.9, -1.3>
  }
  box { // Cube699
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <13.1, -4.9, -1.3>
  }
  box { // Cube700
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.1, 2.05>
    translate  <13.9, -4.9, -1.3>
  }
  material {
    raadgrundtex
  }
}
#declare CSG011 = union {
  cylinder { // Cylndr327
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus064
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG104 = difference {
  object { CSG011 }
  box { // Cube701
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG105 = union {
  cylinder { // Cylndr326
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG104 }
  cylinder { // Cylndr328
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
}
#declare CSG112 = union {
  cylinder { // Cylndr330
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus065
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG113 = difference {
  object { CSG112 }
  box { // Cube702
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG114 = union {
  cylinder { // Cylndr329
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG113 }
  cylinder { // Cylndr331
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  -1.5*x
}
#declare CSG115 = union {
  cylinder { // Cylndr333
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus066
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG116 = difference {
  object { CSG115 }
  box { // Cube703
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG117 = union {
  cylinder { // Cylndr332
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG116 }
  cylinder { // Cylndr334
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  -3.0*x
}
#declare CSG119 = union {
  cylinder { // Cylndr336
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus067
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG153 = difference {
  object { CSG119 }
  box { // Cube704
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG154 = union {
  cylinder { // Cylndr335
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG153 }
  cylinder { // Cylndr337
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  -4.5*x
}
#declare CSG155 = union {
  cylinder { // Cylndr339
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus068
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG156 = difference {
  object { CSG155 }
  box { // Cube705
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG157 = union {
  cylinder { // Cylndr338
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG156 }
  cylinder { // Cylndr340
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  -6.0*x
}
#declare CSG158 = union {
  cylinder { // Cylndr342
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus069
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG159 = difference {
  object { CSG158 }
  box { // Cube706
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG160 = union {
  cylinder { // Cylndr341
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG159 }
  cylinder { // Cylndr343
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  -7.5*x
}
#declare CSG161 = union {
  cylinder { // Cylndr345
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus070
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG162 = difference {
  object { CSG161 }
  box { // Cube707
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG163 = union {
  cylinder { // Cylndr344
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG162 }
  cylinder { // Cylndr346
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  -9.0*x
}
#declare CSG164 = union {
  cylinder { // Cylndr348
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus071
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG165 = difference {
  object { CSG164 }
  box { // Cube708
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG166 = union {
  cylinder { // Cylndr347
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG165 }
  cylinder { // Cylndr349
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  -10.5*x
}
#declare CSG167 = union {
  cylinder { // Cylndr351
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus072
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG168 = difference {
  object { CSG167 }
  box { // Cube709
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG169 = union {
  cylinder { // Cylndr350
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG168 }
  cylinder { // Cylndr352
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  6.0*x
}
#declare CSG170 = union {
  cylinder { // Cylndr354
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus073
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG171 = difference {
  object { CSG170 }
  box { // Cube710
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG172 = union {
  cylinder { // Cylndr353
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG171 }
  cylinder { // Cylndr355
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  7.5*x
}
#declare CSG173 = union {
  cylinder { // Cylndr357
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus074
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG174 = difference {
  object { CSG173 }
  box { // Cube711
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG175 = union {
  cylinder { // Cylndr356
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG174 }
  cylinder { // Cylndr358
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  9.0*x
}
#declare CSG176 = union {
  cylinder { // Cylndr360
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus075
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG177 = difference {
  object { CSG176 }
  box { // Cube712
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG178 = union {
  cylinder { // Cylndr359
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG177 }
  cylinder { // Cylndr361
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  10.5*x
}
#declare CSG179 = union {
  cylinder { // Cylndr363
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus076
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG180 = difference {
  object { CSG179 }
  box { // Cube713
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG181 = union {
  cylinder { // Cylndr362
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG180 }
  cylinder { // Cylndr364
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  12.0*x
}
#declare CSG182 = union {
  cylinder { // Cylndr366
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus077
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG183 = difference {
  object { CSG182 }
  box { // Cube714
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG184 = union {
  cylinder { // Cylndr365
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG183 }
  cylinder { // Cylndr367
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  13.5*x
}
#declare CSG185 = union {
  cylinder { // Cylndr369
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus078
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG186 = difference {
  object { CSG185 }
  box { // Cube715
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG187 = union {
  cylinder { // Cylndr368
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG186 }
  cylinder { // Cylndr370
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  15.0*x
}
#declare CSG188 = union {
  cylinder { // Cylndr372
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus079
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG189 = difference {
  object { CSG188 }
  box { // Cube716
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG190 = union {
  cylinder { // Cylndr371
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG189 }
  cylinder { // Cylndr373
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  16.5*x
}
#declare CSG191 = union {
  cylinder { // Cylndr375
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus080
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG192 = difference {
  object { CSG191 }
  box { // Cube717
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG193 = union {
  cylinder { // Cylndr374
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG192 }
  cylinder { // Cylndr376
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <6.0, 0.0, 2.7>
}
#declare CSG194 = union {
  cylinder { // Cylndr378
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus081
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG195 = difference {
  object { CSG194 }
  box { // Cube718
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG196 = union {
  cylinder { // Cylndr377
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG195 }
  cylinder { // Cylndr379
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <7.5, 0.0, 2.7>
}
#declare CSG197 = union {
  cylinder { // Cylndr381
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus082
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG198 = difference {
  object { CSG197 }
  box { // Cube719
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG199 = union {
  cylinder { // Cylndr380
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG198 }
  cylinder { // Cylndr382
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <9.0, 0.0, 2.7>
}
#declare CSG200 = union {
  cylinder { // Cylndr384
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus083
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG201 = difference {
  object { CSG200 }
  box { // Cube720
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG202 = union {
  cylinder { // Cylndr383
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG201 }
  cylinder { // Cylndr385
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <12.0, 0.0, 2.7>
}
#declare CSG203 = union {
  cylinder { // Cylndr387
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus084
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG204 = difference {
  object { CSG203 }
  box { // Cube721
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG205 = union {
  cylinder { // Cylndr386
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG204 }
  cylinder { // Cylndr388
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <15.0, 0.0, 2.7>
}
#declare CSG206 = union {
  cylinder { // Cylndr390
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus085
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG207 = difference {
  object { CSG206 }
  box { // Cube722
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG208 = union {
  cylinder { // Cylndr389
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG207 }
  cylinder { // Cylndr391
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <10.5, 0.0, 2.7>
}
#declare CSG209 = union {
  cylinder { // Cylndr393
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus086
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG210 = difference {
  object { CSG209 }
  box { // Cube723
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG211 = union {
  cylinder { // Cylndr392
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG210 }
  cylinder { // Cylndr394
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <13.5, 0.0, 2.7>
}
#declare CSG212 = union {
  cylinder { // Cylndr396
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus087
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG213 = difference {
  object { CSG212 }
  box { // Cube724
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG214 = union {
  cylinder { // Cylndr395
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG213 }
  cylinder { // Cylndr397
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <16.5, 0.0, 2.7>
}
#declare CSG215 = union {
  cylinder { // Cylndr399
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus088
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG216 = difference {
  object { CSG215 }
  box { // Cube725
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG217 = union {
  cylinder { // Cylndr398
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG216 }
  cylinder { // Cylndr400
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  2.7*z
}
#declare CSG218 = union {
  cylinder { // Cylndr402
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus089
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG219 = difference {
  object { CSG218 }
  box { // Cube726
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG220 = union {
  cylinder { // Cylndr401
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG219 }
  cylinder { // Cylndr403
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <-1.5, 0.0, 2.7>
}
#declare CSG221 = union {
  cylinder { // Cylndr405
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus090
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG222 = difference {
  object { CSG221 }
  box { // Cube727
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG223 = union {
  cylinder { // Cylndr404
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG222 }
  cylinder { // Cylndr406
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <-3.0, 0.0, 2.7>
}
#declare CSG224 = union {
  cylinder { // Cylndr408
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus091
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG225 = difference {
  object { CSG224 }
  box { // Cube728
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG226 = union {
  cylinder { // Cylndr407
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG225 }
  cylinder { // Cylndr409
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <-4.5, 0.0, 2.7>
}
#declare CSG227 = union {
  cylinder { // Cylndr411
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus092
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG228 = difference {
  object { CSG227 }
  box { // Cube729
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG229 = union {
  cylinder { // Cylndr410
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG228 }
  cylinder { // Cylndr412
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <-6.0, 0.0, 2.7>
}
#declare CSG230 = union {
  cylinder { // Cylndr414
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus093
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG231 = difference {
  object { CSG230 }
  box { // Cube730
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG232 = union {
  cylinder { // Cylndr413
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG231 }
  cylinder { // Cylndr415
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <-7.5, 0.0, 2.7>
}
#declare CSG233 = union {
  cylinder { // Cylndr417
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus094
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG234 = difference {
  object { CSG233 }
  box { // Cube731
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG235 = union {
  cylinder { // Cylndr416
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG234 }
  cylinder { // Cylndr418
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <-9.0, 0.0, 2.7>
}
#declare CSG236 = union {
  cylinder { // Cylndr420
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.2>
    rotate -90.0*x
    translate  <-3.0, -5.02, -2.0>
  }
  torus { // Torus095
    1.8, 0.2  rotate -x*90
    scale 0.25
    rotate -90.0*x
    translate  <-3.0, -5.0, -2.0>
  }
}
#declare CSG237 = difference {
  object { CSG236 }
  box { // Cube732
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.0, -5.0, -3.0>
  }
}
#declare CSG238 = union {
  cylinder { // Cylndr419
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-3.45, -5.0, -3.4>
  }
  object { CSG237 }
  cylinder { // Cylndr421
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.4>
    translate  <-2.55, -5.0, -3.4>
  }
  translate  <-10.5, 0.0, 2.7>
}
#declare raadfasadCSG01 = union {
  object { CSG105 }
  object { CSG114 }
  object { CSG117 }
  object { CSG154 }
  object { CSG157 }
  object { CSG160 }
  object { CSG163 }
  object { CSG166 }
  object { CSG169 }
  object { CSG172 }
  object { CSG175 }
  object { CSG178 }
  object { CSG181 }
  object { CSG184 }
  object { CSG187 }
  object { CSG190 }
  object { CSG193 }
  object { CSG196 }
  object { CSG199 }
  object { CSG202 }
  object { CSG205 }
  object { CSG208 }
  object { CSG211 }
  object { CSG214 }
  object { CSG217 }
  object { CSG220 }
  object { CSG223 }
  object { CSG226 }
  object { CSG229 }
  object { CSG232 }
  object { CSG235 }
  object { CSG238 }
  material {
    raadgrundtex
  }
}
#declare raadfoesterbleckCSG01 = union {
  box { // Cube733
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <3.0, -4.9, -0.65>
  }
  box { // Cube734
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <6.0, -4.9, -0.65>
  }
  box { // Cube735
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <4.5, -4.9, -0.65>
  }
  box { // Cube736
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <7.5, -4.9, -0.65>
  }
  box { // Cube737
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <9.0, -4.9, -0.65>
  }
  box { // Cube738
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <10.5, -4.9, -0.65>
  }
  box { // Cube739
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <12.0, -4.9, -0.65>
  }
  box { // Cube740
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <13.5, -4.9, -0.65>
  }
  box { // Cube741
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-3.0, -4.9, -0.65>
  }
  box { // Cube742
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-4.5, -4.9, -0.65>
  }
  box { // Cube743
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-6.0, -4.9, -0.65>
  }
  box { // Cube744
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-7.5, -4.9, -0.65>
  }
  box { // Cube745
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-9.0, -4.9, -0.65>
  }
  box { // Cube746
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-10.5, -4.9, -0.65>
  }
  box { // Cube747
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-12.0, -4.9, -0.65>
  }
  box { // Cube748
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-13.5, -4.9, -0.65>
  }
  box { // Cube749
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-3.0, -4.9, -3.35>
  }
  box { // Cube750
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-4.5, -4.9, -3.35>
  }
  box { // Cube751
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-6.0, -4.9, -3.35>
  }
  box { // Cube752
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-7.5, -4.9, -3.35>
  }
  box { // Cube753
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-9.0, -4.9, -3.35>
  }
  box { // Cube754
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-10.5, -4.9, -3.35>
  }
  box { // Cube755
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-12.0, -4.9, -3.35>
  }
  box { // Cube756
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <-13.5, -4.9, -3.35>
  }
  box { // Cube757
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <3.0, -4.9, -3.35>
  }
  box { // Cube758
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <4.5, -4.9, -3.35>
  }
  box { // Cube759
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <6.0, -4.9, -3.35>
  }
  box { // Cube760
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <7.5, -4.9, -3.35>
  }
  box { // Cube761
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <9.0, -4.9, -3.35>
  }
  box { // Cube762
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <12.0, -4.9, -3.35>
  }
  box { // Cube763
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <10.5, -4.9, -3.35>
  }
  box { // Cube764
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.15, 0.05>
    translate  <13.5, -4.9, -3.35>
  }
  material {
    raadtaktex
  }
}
#declare raadtakCSG01 = difference {
  box { // Cube765
    <-1, -1, -1>, <1, 1, 1>
    scale <15.3, 5.3, 1.8>
    translate  3.2*z
  }
  box { // Cube1021
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.5, 4.0>
    rotate -57.0*x
    translate  <0.0, -3.8, 4.325>
  }
  box { // Cube1022
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.5, 4.0>
    rotate 57.0*x
    translate  <0.0, 3.8, 4.325>
  }
  box { // Cube1023
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 5.5, 3.0>
    rotate -45.0*y
    translate  <15.0, 0.0, 4.15>
  }
  box { // Cube1024
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 5.5, 3.0>
    rotate 45.0*y
    translate  <-15.0, 0.0, 4.15>
  }
  material {
    raadtaktex
  }
  translate  0.02*z
}
#declare CSG239 = union {
  cylinder { // Cylndr422
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <0.0, -5.3, 1.55>
  }
  cylinder { // Cylndr423
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <0.0, 5.3, 1.55>
  }
  cylinder { // Cylndr424
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <2.0, 5.3, 1.55>
  }
  cylinder { // Cylndr425
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <4.0, 5.3, 1.55>
  }
  cylinder { // Cylndr426
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <6.0, 5.3, 1.55>
  }
  cylinder { // Cylndr427
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <8.0, 5.3, 1.55>
  }
  cylinder { // Cylndr428
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <10.0, 5.3, 1.55>
  }
  cylinder { // Cylndr429
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <12.0, 5.3, 1.55>
  }
  cylinder { // Cylndr430
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <14.0, 5.3, 1.55>
  }
  cylinder { // Cylndr431
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <-2.0, 5.3, 1.55>
  }
  cylinder { // Cylndr432
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <-4.0, 5.3, 1.55>
  }
  cylinder { // Cylndr433
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <-6.0, 5.3, 1.55>
  }
  cylinder { // Cylndr434
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <-8.0, 5.3, 1.55>
  }
  cylinder { // Cylndr435
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <-10.0, 5.3, 1.55>
  }
  cylinder { // Cylndr436
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <-12.0, 5.3, 1.55>
  }
  cylinder { // Cylndr437
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate 57.0*x
    translate  <-14.0, 5.3, 1.55>
  }
  cylinder { // Cylndr438
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <2.0, -5.3, 1.55>
  }
  cylinder { // Cylndr439
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <4.0, -5.3, 1.55>
  }
  cylinder { // Cylndr440
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <6.0, -5.3, 1.55>
  }
  cylinder { // Cylndr441
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <8.0, -5.3, 1.55>
  }
  cylinder { // Cylndr442
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <10.0, -5.3, 1.55>
  }
  cylinder { // Cylndr443
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <12.0, -5.3, 1.55>
  }
  cylinder { // Cylndr444
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <14.0, -5.3, 1.55>
  }
  cylinder { // Cylndr445
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <-2.0, -5.3, 1.55>
  }
  cylinder { // Cylndr446
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <-4.0, -5.3, 1.55>
  }
  cylinder { // Cylndr447
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <-6.0, -5.3, 1.55>
  }
  cylinder { // Cylndr448
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <-8.0, -5.3, 1.55>
  }
  cylinder { // Cylndr449
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <-10.0, -5.3, 1.55>
  }
  cylinder { // Cylndr450
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <-12.0, -5.3, 1.55>
  }
  cylinder { // Cylndr451
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.35>
    rotate -57.0*x
    translate  <-14.0, -5.3, 1.55>
  }
  translate  0.02*z
}
#declare raadtaksakCSG01 = difference {
  object { CSG239 }
  box { // Cube1025
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 5.5, 3.0>
    rotate 45.0*y
    translate  <-15.0, 0.0, 4.15>
  }
  box { // Cube1026
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 5.5, 3.0>
    rotate -45.0*y
    translate  <15.0, 0.0, 4.15>
  }
  material {
    raadtaktex
  }
}
#declare raadgrundCSG01 = difference {
  box { // Cube1027
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 5.0, 5.0>
  }
  box { // Cube1028
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.5, 1.5>
    translate  <0.0, -5.0, -3.5>
  }
  box { // Cube1029
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <3.0, -5.0, -2.7>
  }
  box { // Cube1030
    <-1, -1, -1>, <1, 1, 1>
    scale <14.5, 4.7, 4.7>
  }
  box { // Cube1031
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <6.0, -5.0, -2.7>
  }
  box { // Cube1032
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <4.5, -5.0, -2.7>
  }
  box { // Cube1033
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <7.5, -5.0, -2.7>
  }
  box { // Cube1034
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <9.0, -5.0, -2.7>
  }
  box { // Cube1035
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <10.5, -5.0, -2.7>
  }
  box { // Cube1036
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <12.0, -5.0, -2.7>
  }
  box { // Cube1037
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <13.5, -5.0, -2.7>
  }
  box { // Cube1038
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-3.0, -5.0, -2.7>
  }
  box { // Cube1039
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-4.5, -5.0, -2.7>
  }
  box { // Cube1040
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-6.0, -5.0, -2.7>
  }
  box { // Cube1041
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-7.5, -5.0, -2.7>
  }
  box { // Cube1042
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-9.0, -5.0, -2.7>
  }
  box { // Cube1043
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-10.5, -5.0, -2.7>
  }
  box { // Cube1044
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-12.0, -5.0, -2.7>
  }
  box { // Cube1045
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-13.5, -5.0, -2.7>
  }
  box { // Cube1046
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-3.0, -5.0, 0.0>
  }
  box { // Cube1047
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-3.0, -5.0, 0.0>
  }
  box { // Cube1048
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-4.5, -5.0, 0.0>
  }
  box { // Cube1049
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-6.0, -5.0, 0.0>
  }
  box { // Cube1050
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-6.0, -5.0, 0.0>
  }
  box { // Cube1051
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-7.5, -5.0, 0.0>
  }
  box { // Cube1052
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-9.0, -5.0, 0.0>
  }
  box { // Cube1053
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-10.5, -5.0, 0.0>
  }
  box { // Cube1054
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-12.0, -5.0, 0.0>
  }
  box { // Cube1055
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <-13.5, -5.0, 0.0>
  }
  box { // Cube1056
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <3.0, -5.0, 0.0>
  }
  box { // Cube1057
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <4.5, -5.0, 0.0>
  }
  box { // Cube1058
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <6.0, -5.0, 0.0>
  }
  box { // Cube1059
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <7.5, -5.0, 0.0>
  }
  box { // Cube1060
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <9.0, -5.0, 0.0>
  }
  box { // Cube1061
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <10.5, -5.0, 0.0>
  }
  box { // Cube1062
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <12.0, -5.0, 0.0>
  }
  box { // Cube1063
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.5, 0.7>
    translate  <13.5, -5.0, 0.0>
  }
  box { // Cube1064
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.5, 4.0>
    rotate -57.0*x
    translate  <0.0, -3.8, 4.325>
  }
  box { // Cube1065
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.5, 4.0>
    rotate 57.0*x
    translate  <0.0, 3.8, 4.325>
  }
  box { // Cube1066
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 5.5, 3.0>
    rotate 45.0*y
    translate  <-15.0, 0.0, 4.15>
  }
  box { // Cube1067
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 5.5, 3.0>
    rotate -45.0*y
    translate  <15.0, 0.0, 4.15>
  }
  material {
    raadhustex3
  }
}
union { // raadhusCSG01
  cylinder { // raadtaknock01
    <0,0,1>, <0,0,0>, 1 
    material {
      raadtaktex
    }
    scale <0.2, 0.2, 24.0>
    rotate -90.0*y
    translate  <12.0, 0.0, 5.0>
  }
  object { raadportCSG01 }
  object { raadkupolCSG01 }
  object { raadfoesterkarmCSG02 }
  object { raadfoesterkarmCSG01 }
  object { raadfasadCSG01 }
  box { // raadglas01
    <-1, -1, -1>, <1, 1, 1>
    material {
      raadglastex
    }
    scale <14.0, 0.05, 2.5>
    translate  <0.0, -4.85, -1.5>
  }
  object { raadfoesterbleckCSG01 }
  object { raadtakCSG01 }
  object { raadtaksakCSG01 }
  object { raadgrundCSG01 }
  box { // raadgrundcube01
    <-1, -1, -1>, <1, 1, 1>
    material {
      raadgrundtex
    }
    scale <14.8, 4.8, 0.5>
    translate  -5.5*z
  }
  text {   // 1486
    ttf      "C:\WINDOWS\Fonts\Oldengl.ttf",
    "1486",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      kyrkbordertex_1
    }
    scale <0.7, 0.7, 0.05>
    rotate <90.0, -0.0, 0.0>
    translate  <-0.7, -5.02, -1.8>
  }

  scale 0.65
  rotate 24.270483*z
  translate  <-68.860625, 57.275093, 1.9>
}


#declare CSG251 = difference {
  cylinder { // Cylndr453
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
  }
  cylinder { // Cylndr454
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, -0.5, 1.0>
  }
  cylinder { // Cylndr455
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr456
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.0, 0.5, 1.0>
  }
  cylinder { // Cylndr457
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.5, 0.0, 1.0>
  }
  cylinder { // Cylndr458
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr459
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr460
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr461
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, -0.25, 1.0>
  }
  cylinder { // Cylndr462
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.43, 0.25, 1.0>
  }
  cylinder { // Cylndr463
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <0.25, 0.43, 1.0>
  }
  cylinder { // Cylndr464
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, -0.43, 1.0>
  }
  cylinder { // Cylndr465
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    translate  <-0.25, 0.43, 1.0>
  }
}
#declare CSG252 = union {
  object { CSG251 }
  torus { // Torus108
    1.1, 0.2  rotate -x*90
    scale 0.5
    translate  10.0*z
  }
  torus { // Torus109
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  9.0*z
  }
  torus { // Torus110
    1.05, 0.15  rotate -x*90
    scale 0.5
    translate  2.0*z
  }
  sphere { // Sphere035
    <0,0,0>,1
    scale <1.0, 1.0, 0.2>
    translate  11.5*z
  }
  cylinder { // Cylndr466
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    translate  1.0*z
  }
  cylinder { // Cylndr467
    <0,0,1>, <0,0,0>, 1 
  }
  torus { // Torus111
    1.0, 0.2  rotate -x*90
    translate  0.8*z
  }
  cone { // Cone046
    <0,0,0>, 0.5, <0,0,1>, 1.0
    rotate <180.0, 0.0, 180.0>
    translate  2.0*z
  }
  torus { // Torus112
    1.0, 0.2  rotate -x*90
    translate  0.2*z
  }
  material {
    lamptex
  }
}
union { // gatlyktaCSG09
  object { CSG252 }
  cone { // Cone047
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      lamplamptex
    }
    scale <1.0, 1.0, 1.5>
    translate  10.0*z
  }
  scale 0.25
  translate  <-34.182273, 56.138624, -2.0>
}


#declare CSG129 = union {
  box { // Cube1068
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, -1.8, 9.4>
  }
  box { // Cube1069
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 0.0, 9.4>
  }
  box { // Cube1070
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-10.0, 1.8, 9.4>
  }
  box { // Cube1071
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 0.0, 9.4>
  }
}
#declare CSG130 = union {
  box { // Cube1072
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-11.8, 0.0, 9.8>
  }
  box { // Cube1073
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.25, 0.25>
    rotate -45.0*x
    translate  <-8.2, 0.0, 9.8>
  }
  box { // Cube1074
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, 1.8, 9.8>
  }
  box { // Cube1075
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.25>
    rotate -45.0*y
    translate  <-10.0, -1.8, 9.8>
  }
}
#declare CSG240 = difference {
  object { CSG129 }
  object { CSG130 }
}
#declare CSG241 = difference {
  box { // Cube1076
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, -1.6, 9.4>
  }
  box { // Cube1077
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-8.2, -1.9, 9.8>
  }
}
#declare CSG242 = difference {
  box { // Cube1078
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-8.2, 1.6, 9.4>
  }
  box { // Cube1079
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-8.2, 1.9, 9.8>
  }
}
#declare CSG243 = difference {
  box { // Cube1080
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, 1.6, 9.4>
  }
  box { // Cube1081
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.2>
    rotate -45.0*x
    translate  <-11.8, 1.9, 9.8>
  }
}
#declare CSG244 = difference {
  box { // Cube1082
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, -1.8, 9.4>
  }
  box { // Cube1083
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, -1.8, 9.8>
  }
}
#declare CSG245 = difference {
  box { // Cube1084
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-8.4, 1.8, 9.4>
  }
  box { // Cube1085
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.4>
    rotate -45.0*y
    translate  <-8.1, 1.8, 9.8>
  }
}
#declare CSG246 = difference {
  box { // Cube1086
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, 1.8, 9.4>
  }
  box { // Cube1087
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, 1.8, 9.8>
  }
}
#declare CSG247 = difference {
  box { // Cube1088
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.4, 0.4>
    translate  <-11.8, -1.6, 9.4>
  }
  box { // Cube1089
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.4>
    rotate -45.0*x
    translate  <-11.8, -1.9, 9.8>
  }
}
#declare CSG248 = difference {
  box { // Cube1090
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.2, 0.4>
    translate  <-11.6, -1.8, 9.4>
  }
  box { // Cube1091
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.2>
    rotate -45.0*y
    translate  <-11.9, -1.8, 9.8>
  }
}
#declare torntop6 = union {
  object { CSG240 }
  object { CSG241 }
  object { CSG242 }
  object { CSG243 }
  object { CSG244 }
  object { CSG245 }
  object { CSG246 }
  object { CSG247 }
  object { CSG248 }
  box { // Cube1092
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 0.5>
    translate  <-10.0, 0.0, 8.5>
  }
}
#declare CSG249 = difference {
  cylinder { // Cylndr452
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 12.0>
    translate  <10.0, 0.0, -4.0>
  }
  cylinder { // Cylndr468
    <0,0,1>, <0,0,0>, 1 
    scale <1.35, 1.35, 8.0>
    translate  10.0*x
  }
  box { // Cube1093
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    rotate 40.0*z
    translate  <10.8, -1.0, 5.0>
  }
  box { // Cube1094
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    rotate -40.0*z
    translate  <9.2, -1.0, 3.6>
  }
  box { // Cube1095
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.4, 0.4>
    translate  <10.0, -1.3, 4.3>
  }
  translate  -20.0*x
}
union { // tornCSG04
  object { torntop6 }
  cone { // Cone048
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.8, 1.8, 2.0>
    translate  <-10.0, 0.0, 6.0>
  }
  object { CSG249 }
  box { // Cube1096
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <30.0, -30.0, 0.0>
    translate  <-11.3, -1.3, 7.5>
  }
  box { // Cube1097
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <-30.0, -30.0, 0.0>
    translate  <-11.3, 1.3, 7.5>
  }
  box { // Cube1098
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <-30.0, 30.0, 0.0>
    translate  <-8.7, 1.3, 7.5>
  }
  box { // Cube1099
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    rotate <30.0, 30.0, 0.0>
    translate  <-8.7, -1.3, 7.5>
  }
  material {
    stenmurtex
  }
  rotate -60.0*z
  translate  <-7.005578, 85.798275, 0.0>
}


#declare CSG258 = union {
  cylinder { // Cylndr472
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr473
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr474
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  rotate -18.0*y
  translate  <0.7, 1.0, 0.0>
}
#declare CSG259 = union {
  cylinder { // Cylndr478
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr479
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr480
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  rotate 18.0*y
  translate  <-0.7, 1.0, 0.0>
}
#declare CSG260 = union {
  cylinder { // Cylndr481
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr482
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr483
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  scale <1.0, 1.0, 1.5>
  rotate 13.0*y
  translate  <-0.7, 4.0, 0.0>
}
#declare CSG261 = union {
  cylinder { // Cylndr484
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr485
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr486
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  scale <1.0, 1.0, 1.5>
  rotate -13.0*y
  translate  <0.7, 4.0, 0.0>
}
#declare CSG262 = union {
  object { CSG258 }
  cylinder { // Cylndr475
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 5.76>
    rotate 43.400002*x
    translate  <0.0, 7.98, 0.3>
  }
  cylinder { // Cylndr476
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 3.146175>
    rotate -74.199997*x
    translate  <0.0, 1.0, 3.625>
  }
  cylinder { // Cylndr477
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 5.675>
    rotate -58.25*x
    translate  <0.0, -3.83, 0.655>
  }
  object { CSG259 }
  object { CSG260 }
  object { CSG261 }
  material {
    traeex_5
  }
}
#declare TransSweep018 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  19  // control points
  <-0.306994, -1.070416>,
  <0.786608, -1.084395>,
  <0.56051, -0.522293>,
  <0.798301, -0.214437>,
  <1.559616, -0.517281>,
  <1.517421, 0.429722>,
  <0.807007, 0.228163>,
  <0.553785, 0.577583>,
  <0.808917, 1.021231>,
  <-0.267516, 1.031847>,
  <-0.048712, 0.579817>,
  <-0.237449, 0.238188>,
  <-0.979242, 0.43418>,
  <-0.935697, -0.45408>,
  <-0.293275, -0.224623>,
  <-0.068971, -0.516262>,
  <-0.306994, -1.070416>,
  <0.786608, -1.084395>,
  <0.56051, -0.522293>
  rotate -x*90
  material {
    rodtex
  }
  scale 0.55
  rotate -90.0*x
  translate  <-0.2, 5.563545, 1.329189>
}
#declare BezPtch006 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.728985>, <0.000000, -2.000000, 0.728985>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.728985>, <-1.000000, -1.000000, 0.728985>, <0.000000, -1.000000, 0.728985>, <1.000000, -1.000000, 0.728985>, 
      <-2.000000, 0.000000, 0.728985>, <-1.000000, 0.000000, 0.728985>, <0.000000, 0.000000, 0.728985>, <1.000000, 0.000000, 0.728985>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.242995>, <0.000000, 1.000000, 0.242995>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale <0.75625, 0.55, 0.825>
  rotate 90.0*x
  translate  <0.275, 6.15, 1.65>
}
#declare CSG263 = intersection {
  object { TransSweep018 }
  object { BezPtch006 }
  material {
    rodtex
  }
  scale 1.8
  translate  <0.175, -12.053956, -0.8365>
}
#declare BezPtch005 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.214690, -0.035782>, <-1.000000, -2.000000, 0.728985>, <0.000000, -2.000000, 0.728985>, <1.000000, -2.214690, -0.035782>, 
      <-2.000000, -1.000000, 0.728985>, <-1.000000, -1.000000, 0.728985>, <0.000000, -1.000000, 0.728985>, <1.000000, -1.000000, 0.728985>, 
      <-2.000000, 0.000000, 0.728985>, <-1.000000, 0.000000, 0.728985>, <0.000000, 0.000000, 0.728985>, <1.000000, 0.000000, 0.728985>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.242995>, <0.000000, 1.000000, 0.242995>, <1.000000, 1.000000, 0.000000>
    }
  }
  material {
    segeltex
  }
  scale <1.375, 0.99, 1.5>
  rotate 90.0*x
  translate  <0.7, -0.965, 2.133317>
}
#declare fockCSG01 = union {
  cylinder { // Cylndr487
    <0,0,1>, <0,0,0>, 1 
    material {
      traeex_5
    }
    scale <0.05, 0.05, 4.5>
    rotate -90.0*y
    translate  <2.25, -1.075832, 3.183959>
  }
  object { CSG263 }
  object { BezPtch005 }
  scale 0.9
  rotate <1.325072, 4.83294, 15.35224>
  translate  <-0.509284, 1.842061, 0.328602>
}
#declare TransSweep019 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  19  // control points
  <-0.306994, -1.070416>,
  <0.786608, -1.084395>,
  <0.56051, -0.522293>,
  <0.798301, -0.214437>,
  <1.559616, -0.517281>,
  <1.517421, 0.429722>,
  <0.807007, 0.228163>,
  <0.553785, 0.577583>,
  <0.808917, 1.021231>,
  <-0.267516, 1.031847>,
  <-0.048712, 0.579817>,
  <-0.237449, 0.238188>,
  <-0.979242, 0.43418>,
  <-0.935697, -0.45408>,
  <-0.293275, -0.224623>,
  <-0.068971, -0.516262>,
  <-0.306994, -1.070416>,
  <0.786608, -1.084395>,
  <0.56051, -0.522293>
  rotate -x*90
  material {
    rodtex
  }
  scale 0.7
  rotate -90.0*x
  translate  <-0.2, 2.2, 1.6>
}
#declare BezPtch002 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.728985>, <0.000000, -2.000000, 0.728985>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.728985>, <-1.000000, -1.000000, 0.728985>, <0.000000, -1.000000, 0.728985>, <1.000000, -1.000000, 0.728985>, 
      <-2.000000, 0.000000, 0.728985>, <-1.000000, 0.000000, 0.728985>, <0.000000, 0.000000, 0.728985>, <1.000000, 0.000000, 0.728985>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.242995>, <0.000000, 1.000000, 0.242995>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale <0.98, 0.7, 0.98>
  rotate 90.0*x
  translate  <0.5, 2.9, 1.992224>
}
#declare CSG264 = intersection {
  object { TransSweep019 }
  object { BezPtch002 }
  material {
    rodtex
  }
  scale <2.0, 2.1, 2.0>
  translate  <0.0, -3.102177, -1.074984>
}
#declare BezPtch003 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.731576, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.728985>, <0.000000, -2.000000, 0.728985>, <0.804783, -1.975598, 0.000000>, 
      <-2.000000, -1.000000, 0.728985>, <-1.000000, -1.000000, 0.728985>, <0.000000, -1.000000, 0.728985>, <1.000000, -1.000000, 0.728985>, 
      <-2.000000, 0.000000, 0.728985>, <-1.000000, 0.000000, 0.728985>, <0.000000, 0.000000, 0.728985>, <1.000000, 0.000000, 0.728985>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.242995>, <0.000000, 1.000000, 0.242995>, <1.000000, 1.000000, 0.000000>
    }
  }
  material {
    segeltex
  }
  scale <1.8, 1.4, 2.05>
  rotate 90.0*x
  translate  <0.9, 3.0, 2.9>
}
#declare storsegelCSG01 = union {
  cylinder { // Cylndr488
    <0,0,1>, <0,0,0>, 1 
    material {
      traeex_5
    }
    scale <0.05, 0.05, 6.0>
    rotate -90.0*y
    translate  <3.0, 2.913792, 4.391897>
  }
  object { CSG264 }
  object { BezPtch003 }
  scale 0.9
  rotate <1.260605, 3.399977, 16.677643>
  translate  <0.439904, 1.510888, 0.077012>
}
#declare skeppglasrutorCSG01 = union {
  cylinder { // Cylndr489
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 6.7, -0.1>
  }
  cylinder { // Cylndr490
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.05, -0.1>
  }
  cylinder { // Cylndr491
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.4, -0.1>
  }
  cylinder { // Cylndr492
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.75, -0.1>
  }
  cylinder { // Cylndr493
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 6.7, -0.1>
  }
  cylinder { // Cylndr494
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.05, -0.1>
  }
  cylinder { // Cylndr495
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.4, -0.1>
  }
  cylinder { // Cylndr496
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.75, -0.1>
  }
  material {
    glastex_4
  }
}
#declare skeppfoesterringarCSG01 = union {
  torus { // Torus096
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 6.7, -0.1>
  }
  torus { // Torus097
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.05, -0.1>
  }
  torus { // Torus098
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.4, -0.1>
  }
  torus { // Torus099
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.75, -0.1>
  }
  torus { // Torus100
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 6.7, -0.1>
  }
  torus { // Torus101
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.05, -0.1>
  }
  torus { // Torus102
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.4, -0.1>
  }
  torus { // Torus103
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.75, -0.1>
  }
  material {
    kyrkbordertex_3
  }
}
#declare skeppfoesterCSG01 = union {
  object { skeppglasrutorCSG01 }
  object { skeppfoesterringarCSG01 }
}
#declare mastCSG01 = union {
  cone { // Cone049
    <0,0,0>, 0.25, <0,0,1>, 0.08
    scale <0.5, 0.5, 5.0>
    translate  <0.0, 4.0, -0.5>
  }
  cone { // Cone050
    <0,0,0>, 0.15, <0,0,1>, 0.05
    scale <0.5, 0.5, 4.0>
    translate  <0.0, 1.0, -0.35>
  }
  cone { // Cone051
    <0,0,0>, 0.25, <0,0,1>, 0.05
    scale <0.25, 0.25, 1.5>
    rotate 70.0*x
    translate  <0.0, -2.427924, 0.147778>
  }
  material {
    traeex_5
  }
}
#declare CSG265 = union {
  cylinder { // Cylndr499
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.75, -0.1>
  }
  cylinder { // Cylndr500
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.4, -0.1>
  }
  cylinder { // Cylndr501
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.05, -0.1>
  }
  cylinder { // Cylndr502
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 6.7, -0.1>
  }
}
#declare akterCSG01 = difference {
  cylinder { // Cylndr497
    <0,0,1>, <0,0,0>, 1 
    scale <0.725, 0.975, 2.0>
    rotate -90.0*x
    translate  <0.0, 6.0, -0.35>
  }
  box { // Cube1525
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    rotate -35.0*x
    translate  <0.0, 8.043279, -2.131496>
  }
  box { // Cube1526
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_5
    }
    scale <1.0, 1.5, 1.0>
    translate  <0.0, 7.0, 1.35>
  }
  cylinder { // Cylndr498
    <0,0,1>, <0,0,0>, 1 
    material {
      traeex_5
    }
    scale <0.7, 0.95, 2.0>
    rotate -90.0*x
    translate  <0.0, 5.95, -0.35>
  }
  box { // Cube1527
    <-1, -1, -1>, <1, 1, 1>
    scale <0.13, 0.1, 0.3>
    translate  <0.4, 6.0, -0.15>
  }
  object { CSG265 }
}
#declare foeCSG01 = difference {
  torus { // Torus104
    1.5, 0.5  rotate -x*90
    scale <2.0, 1.8, 1.5>
    rotate -90.0*y
    translate  2.65*z
  }
  box { // Cube1528
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.0, 2.0>
    translate  <0.0, 3.0, -1.0>
  }
  box { // Cube1529
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 3.5>
    translate  4.0*z
  }
  cylinder { // Cylndr503
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 4.0, 2.0>
    rotate -90.0*y
    translate  <1.0, 0.0, 1.0>
  }
}
#declare CSG266 = union {
  box { // Cube1532
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.375, -0.175>
  }
  box { // Cube1533
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.625, -0.175>
  }
  box { // Cube1534
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.875, -0.175>
  }
  box { // Cube1535
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.125, -0.175>
  }
  box { // Cube1536
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.375, -0.175>
  }
  box { // Cube1537
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.625, -0.175>
  }
  box { // Cube1538
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.875, -0.175>
  }
  box { // Cube1539
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.125, -0.175>
  }
  box { // Cube1540
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.375, -0.175>
  }
  box { // Cube1541
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.625, -0.175>
  }
  box { // Cube1542
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.875, -0.175>
  }
  box { // Cube1543
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.125, -0.175>
  }
  box { // Cube1544
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.375, -0.175>
  }
  box { // Cube1545
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.625, -0.175>
  }
  box { // Cube1546
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.875, -0.175>
  }
  box { // Cube1547
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.125, -0.175>
  }
  box { // Cube1548
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.375, -0.175>
  }
  box { // Cube1549
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.625, -0.175>
  }
  box { // Cube1550
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.875, -0.175>
  }
  box { // Cube1551
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.125, -0.175>
  }
  box { // Cube1552
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.375, -0.175>
  }
  box { // Cube1553
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.625, -0.175>
  }
  box { // Cube1554
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.875, -0.175>
  }
  box { // Cube1555
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.125, -0.175>
  }
  material {
    traeex_5
  }
  scale <1.0, 1.0, 0.5>
  translate  -0.02*z
}
#declare CSG267 = union {
  cylinder { // Cylndr505
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.75, -0.1>
  }
  cylinder { // Cylndr506
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.4, -0.1>
  }
  cylinder { // Cylndr507
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.05, -0.1>
  }
  cylinder { // Cylndr508
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 6.7, -0.1>
  }
}
#declare skrovCSG01 = difference {
  cylinder { // Cylndr504
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 1.0, 8.0>
    rotate -90.0*x
    translate  -0.35*z
  }
  box { // Cube1530
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 4.0, 1.0>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube1531
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_5
    }
    scale <0.65, 2.95, 0.3>
    translate  3.0*y
  }
  object { CSG266 }
  box { // Cube1556
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    rotate -35.0*x
    translate  <0.0, 8.043279, -2.131496>
  }
  box { // Cube1557
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 1.0>
    translate  <0.0, 7.0, 1.2>
  }
  box { // Cube1558
    <-1, -1, -1>, <1, 1, 1>
    scale <0.13, 0.1, 0.3>
    translate  <0.4, 6.0, -0.15>
  }
  object { CSG267 }
}
#declare plankCSG01 = union {
  object { akterCSG01 }
  object { foeCSG01 }
  object { skrovCSG01 }
  material {
    planktex_1
  }
}
#declare foetorusCSG01 = difference {
  torus { // Torus105
    1.975, 0.025  rotate -x*90
    scale <2.0, 1.8, 2.5>
    rotate -90.0*y
    translate  2.6*z
  }
  box { // Cube1559
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 3.5>
    translate  4.0*z
  }
  box { // Cube1560
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.0, 2.0>
    translate  <0.0, 3.0, -1.0>
  }
  cylinder { // Cylndr509
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 4.0, 2.0>
    rotate -90.0*y
    translate  <1.0, 0.0, 1.0>
  }
  material {
    kyrkbordertex_3
  }
}
union { // CSG268
  object { CSG262 }
  box { // Cube1524
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_5
    }
    scale <0.4, 0.5, 0.15>
    translate  <0.0, -1.8, 0.12>
  }
  object { fockCSG01 }
  object { storsegelCSG01 }
  object { skeppfoesterCSG01 }
  object { mastCSG01 }
  box { // skeppdoer01
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_5
    }
    scale <0.13, 0.05, 0.3>
    rotate -9.0*x
    translate  <0.4, 6.1, -0.17>
  }
  object { plankCSG01 }
  object { foetorusCSG01 }
  box { // durk01
    <-1, -1, -1>, <1, 1, 1>
    material {
      planktex_1
    }
    scale <3.0, 0.05, 0.7>
    rotate <-90.0, 0.0, -90.0>
    translate  <0.0, 3.0, -0.34>
  }
  scale <2.5, 2.0, 2.5>
  rotate <0.4, 5.969552, 14.062823>
  translate  <-49.487954, 4.447984, -1.538145>
}


#declare CSG269 = union {
  cylinder { // Cylndr510
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr511
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr512
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  rotate -18.0*y
  translate  <0.7, 1.0, 0.0>
}
#declare CSG270 = union {
  cylinder { // Cylndr516
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr517
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr518
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  rotate 18.0*y
  translate  <-0.7, 1.0, 0.0>
}
#declare CSG271 = union {
  cylinder { // Cylndr519
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr520
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr521
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  scale <1.0, 1.0, 1.5>
  rotate 13.0*y
  translate  <-0.7, 4.0, 0.0>
}
#declare CSG272 = union {
  cylinder { // Cylndr522
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr523
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr524
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  scale <1.0, 1.0, 1.5>
  rotate -13.0*y
  translate  <0.7, 4.0, 0.0>
}
#declare CSG273 = union {
  object { CSG269 }
  cylinder { // Cylndr513
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 5.76>
    rotate 43.400002*x
    translate  <0.0, 7.98, 0.3>
  }
  cylinder { // Cylndr514
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 3.146175>
    rotate -74.199997*x
    translate  <0.0, 1.0, 3.625>
  }
  cylinder { // Cylndr515
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 5.675>
    rotate -58.25*x
    translate  <0.0, -3.83, 0.655>
  }
  object { CSG270 }
  object { CSG271 }
  object { CSG272 }
  material {
    traeex_5
  }
}
#declare fockCSG02 = union {
  cylinder { // Cylndr525
    <0,0,1>, <0,0,0>, 1 
    material {
      traeex_5
    }
    scale <0.05, 0.05, 4.5>
    rotate -90.0*y
    translate  <2.25, -1.075832, 3.183959>
  }
  scale 0.9
  rotate <1.325072, 4.83294, 15.35224>
  translate  <-0.509284, 1.842061, 0.328602>
}
#declare storsegelCSG02 = union {
  cylinder { // Cylndr526
    <0,0,1>, <0,0,0>, 1 
    material {
      traeex_5
    }
    scale <0.05, 0.05, 6.0>
    rotate -90.0*y
    translate  <3.0, 2.913792, 4.391897>
  }
  scale 0.9
  rotate <1.260605, 3.399977, 16.677643>
  translate  <0.439904, 1.510888, 0.077012>
}
#declare skeppglasrutorCSG02 = union {
  cylinder { // Cylndr527
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 6.7, -0.1>
  }
  cylinder { // Cylndr528
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.05, -0.1>
  }
  cylinder { // Cylndr529
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.4, -0.1>
  }
  cylinder { // Cylndr530
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.75, -0.1>
  }
  cylinder { // Cylndr531
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 6.7, -0.1>
  }
  cylinder { // Cylndr532
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.05, -0.1>
  }
  cylinder { // Cylndr533
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.4, -0.1>
  }
  cylinder { // Cylndr534
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.75, -0.1>
  }
  material {
    glastex_5
  }
}
#declare skeppfoesterringarCSG02 = union {
  torus { // Torus106
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 6.7, -0.1>
  }
  torus { // Torus107
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.05, -0.1>
  }
  torus { // Torus113
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.4, -0.1>
  }
  torus { // Torus114
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.75, -0.1>
  }
  torus { // Torus115
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 6.7, -0.1>
  }
  torus { // Torus116
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.05, -0.1>
  }
  torus { // Torus117
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.4, -0.1>
  }
  torus { // Torus118
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.75, -0.1>
  }
  material {
    kyrkbordertex_3
  }
}
#declare skeppfoesterCSG02 = union {
  object { skeppglasrutorCSG02 }
  object { skeppfoesterringarCSG02 }
}
#declare mastCSG02 = union {
  cone { // Cone052
    <0,0,0>, 0.25, <0,0,1>, 0.08
    scale <0.5, 0.5, 5.0>
    translate  <0.0, 4.0, -0.5>
  }
  cone { // Cone053
    <0,0,0>, 0.15, <0,0,1>, 0.05
    scale <0.5, 0.5, 4.0>
    translate  <0.0, 1.0, -0.35>
  }
  cone { // Cone054
    <0,0,0>, 0.25, <0,0,1>, 0.05
    scale <0.25, 0.25, 1.5>
    rotate 70.0*x
    translate  <0.0, -2.427924, 0.147778>
  }
  material {
    traeex_5
  }
}
#declare CSG276 = union {
  cylinder { // Cylndr537
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.75, -0.1>
  }
  cylinder { // Cylndr538
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.4, -0.1>
  }
  cylinder { // Cylndr539
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.05, -0.1>
  }
  cylinder { // Cylndr540
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 6.7, -0.1>
  }
}
#declare akterCSG02 = difference {
  cylinder { // Cylndr535
    <0,0,1>, <0,0,0>, 1 
    scale <0.725, 0.975, 2.0>
    rotate -90.0*x
    translate  <0.0, 6.0, -0.35>
  }
  box { // Cube1562
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    rotate -35.0*x
    translate  <0.0, 8.043279, -2.131496>
  }
  box { // Cube1563
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_5
    }
    scale <1.0, 1.5, 1.0>
    translate  <0.0, 7.0, 1.35>
  }
  cylinder { // Cylndr536
    <0,0,1>, <0,0,0>, 1 
    material {
      traeex_5
    }
    scale <0.7, 0.95, 2.0>
    rotate -90.0*x
    translate  <0.0, 5.95, -0.35>
  }
  box { // Cube1564
    <-1, -1, -1>, <1, 1, 1>
    scale <0.13, 0.1, 0.3>
    translate  <0.4, 6.0, -0.15>
  }
  object { CSG276 }
}
#declare CSG277 = union {
  box { // Cube1569
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.375, -0.175>
  }
  box { // Cube1621
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.625, -0.175>
  }
  box { // Cube1622
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.875, -0.175>
  }
  box { // Cube1689
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.125, -0.175>
  }
  box { // Cube1690
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.375, -0.175>
  }
  box { // Cube1691
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.625, -0.175>
  }
  box { // Cube1692
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.875, -0.175>
  }
  box { // Cube1693
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.125, -0.175>
  }
  box { // Cube1694
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.375, -0.175>
  }
  box { // Cube1695
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.625, -0.175>
  }
  box { // Cube1696
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.875, -0.175>
  }
  box { // Cube1697
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.125, -0.175>
  }
  box { // Cube1698
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.375, -0.175>
  }
  box { // Cube1699
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.625, -0.175>
  }
  box { // Cube1700
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.875, -0.175>
  }
  box { // Cube1701
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.125, -0.175>
  }
  box { // Cube1702
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.375, -0.175>
  }
  box { // Cube1703
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.625, -0.175>
  }
  box { // Cube1704
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.875, -0.175>
  }
  box { // Cube1705
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.125, -0.175>
  }
  box { // Cube1706
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.375, -0.175>
  }
  box { // Cube1707
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.625, -0.175>
  }
  box { // Cube1708
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.875, -0.175>
  }
  box { // Cube1709
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.125, -0.175>
  }
  material {
    traeex_5
  }
  scale <1.0, 1.0, 0.5>
  translate  -0.02*z
}
#declare CSG278 = union {
  cylinder { // Cylndr543
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.75, -0.1>
  }
  cylinder { // Cylndr544
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.4, -0.1>
  }
  cylinder { // Cylndr545
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.05, -0.1>
  }
  cylinder { // Cylndr546
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 6.7, -0.1>
  }
}
#declare skrovCSG02 = difference {
  cylinder { // Cylndr542
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 1.0, 8.0>
    rotate -90.0*x
    translate  -0.35*z
  }
  box { // Cube1567
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 4.0, 1.0>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube1568
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_5
    }
    scale <0.65, 2.95, 0.3>
    translate  3.0*y
  }
  object { CSG277 }
  box { // Cube1710
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    rotate -35.0*x
    translate  <0.0, 8.043279, -2.131496>
  }
  box { // Cube1711
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 1.0>
    translate  <0.0, 7.0, 1.2>
  }
  box { // Cube1712
    <-1, -1, -1>, <1, 1, 1>
    scale <0.13, 0.1, 0.3>
    translate  <0.4, 6.0, -0.15>
  }
  object { CSG278 }
}
#declare plankCSG02 = union {
  object { akterCSG02 }
  object { skrovCSG02 }
  material {
    planktex_1
  }
}
union { // CSG279
  object { CSG273 }
  object { fockCSG02 }
  object { storsegelCSG02 }
  object { skeppfoesterCSG02 }
  object { mastCSG02 }
  object { plankCSG02 }
  box { // durk02
    <-1, -1, -1>, <1, 1, 1>
    material {
      planktex_1
    }
    scale <3.0, 0.05, 0.7>
    rotate <-90.0, 0.0, -90.0>
    translate  <0.0, 3.0, -0.34>
  }
  scale 2.5
  rotate <0.4, 5.969552, -129.9272>
  translate  <-89.580891, 1.815198, -1.538145>
}


#declare CSG275 = union {
  cylinder { // Cylndr541
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr547
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr548
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  rotate -18.0*y
  translate  <0.7, 1.0, 0.0>
}
#declare CSG280 = union {
  cylinder { // Cylndr552
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr553
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr554
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  rotate 18.0*y
  translate  <-0.7, 1.0, 0.0>
}
#declare CSG281 = union {
  cylinder { // Cylndr555
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr556
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr557
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  scale <1.0, 1.0, 1.5>
  rotate 13.0*y
  translate  <-0.7, 4.0, 0.0>
}
#declare CSG282 = union {
  cylinder { // Cylndr558
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate 5.7*x
    translate  0.2*y
  }
  cylinder { // Cylndr559
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
    rotate -5.7*x
    translate  -0.2*y
  }
  cylinder { // Cylndr560
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 2.0>
  }
  scale <1.0, 1.0, 1.5>
  rotate -13.0*y
  translate  <0.7, 4.0, 0.0>
}
#declare CSG283 = union {
  object { CSG275 }
  cylinder { // Cylndr549
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 5.76>
    rotate 43.400002*x
    translate  <0.0, 7.98, 0.3>
  }
  cylinder { // Cylndr550
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 3.146175>
    rotate -74.199997*x
    translate  <0.0, 1.0, 3.625>
  }
  cylinder { // Cylndr551
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 5.675>
    rotate -58.25*x
    translate  <0.0, -3.83, 0.655>
  }
  object { CSG280 }
  object { CSG281 }
  object { CSG282 }
  material {
    traeex_5
  }
}
#declare fockCSG03 = union {
  cylinder { // Cylndr561
    <0,0,1>, <0,0,0>, 1 
    material {
      traeex_5
    }
    scale <0.05, 0.05, 4.5>
    rotate -90.0*y
    translate  <2.25, -1.075832, 3.183959>
  }
  scale 0.9
  rotate <1.325072, 4.83294, 15.35224>
  translate  <-0.509284, 1.842061, 0.328602>
}
#declare storsegelCSG03 = union {
  cylinder { // Cylndr562
    <0,0,1>, <0,0,0>, 1 
    material {
      traeex_5
    }
    scale <0.05, 0.05, 6.0>
    rotate -90.0*y
    translate  <3.0, 2.913792, 4.391897>
  }
  scale 0.9
  rotate <1.260605, 3.399977, 16.677643>
  translate  <0.439904, 1.510888, 0.077012>
}
#declare skeppglasrutorCSG03 = union {
  cylinder { // Cylndr563
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 6.7, -0.1>
  }
  cylinder { // Cylndr564
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.05, -0.1>
  }
  cylinder { // Cylndr565
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.4, -0.1>
  }
  cylinder { // Cylndr566
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.75, -0.1>
  }
  cylinder { // Cylndr567
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 6.7, -0.1>
  }
  cylinder { // Cylndr568
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.05, -0.1>
  }
  cylinder { // Cylndr569
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.4, -0.1>
  }
  cylinder { // Cylndr570
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.01>
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.75, -0.1>
  }
  material {
    glastex_5
  }
}
#declare skeppfoesterringarCSG03 = union {
  torus { // Torus119
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 6.7, -0.1>
  }
  torus { // Torus120
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.05, -0.1>
  }
  torus { // Torus121
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.4, -0.1>
  }
  torus { // Torus122
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, -80.0, 180.0>
    translate  <0.725, 7.75, -0.1>
  }
  torus { // Torus123
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 6.7, -0.1>
  }
  torus { // Torus124
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.05, -0.1>
  }
  torus { // Torus125
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.4, -0.1>
  }
  torus { // Torus126
    2.0, 0.2  rotate -x*90
    scale 0.05
    rotate <180.0, 80.0, 180.0>
    translate  <-0.725, 7.75, -0.1>
  }
  material {
    kyrkbordertex_3
  }
}
#declare skeppfoesterCSG03 = union {
  object { skeppglasrutorCSG03 }
  object { skeppfoesterringarCSG03 }
}
#declare mastCSG03 = union {
  cone { // Cone055
    <0,0,0>, 0.25, <0,0,1>, 0.08
    scale <0.5, 0.5, 5.0>
    translate  <0.0, 4.0, -0.5>
  }
  cone { // Cone056
    <0,0,0>, 0.15, <0,0,1>, 0.05
    scale <0.5, 0.5, 4.0>
    translate  <0.0, 1.0, -0.35>
  }
  cone { // Cone057
    <0,0,0>, 0.25, <0,0,1>, 0.05
    scale <0.25, 0.25, 1.5>
    rotate 70.0*x
    translate  <0.0, -2.427924, 0.147778>
  }
  material {
    traeex_5
  }
}
#declare CSG284 = union {
  cylinder { // Cylndr573
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.75, -0.1>
  }
  cylinder { // Cylndr574
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.4, -0.1>
  }
  cylinder { // Cylndr575
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.05, -0.1>
  }
  cylinder { // Cylndr576
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 6.7, -0.1>
  }
}
#declare akterCSG03 = difference {
  cylinder { // Cylndr571
    <0,0,1>, <0,0,0>, 1 
    scale <0.725, 0.975, 2.0>
    rotate -90.0*x
    translate  <0.0, 6.0, -0.35>
  }
  box { // Cube1713
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    rotate -35.0*x
    translate  <0.0, 8.043279, -2.131496>
  }
  box { // Cube1714
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_5
    }
    scale <1.0, 1.5, 1.0>
    translate  <0.0, 7.0, 1.35>
  }
  cylinder { // Cylndr572
    <0,0,1>, <0,0,0>, 1 
    material {
      traeex_5
    }
    scale <0.7, 0.95, 2.0>
    rotate -90.0*x
    translate  <0.0, 5.95, -0.35>
  }
  box { // Cube1715
    <-1, -1, -1>, <1, 1, 1>
    scale <0.13, 0.1, 0.3>
    translate  <0.4, 6.0, -0.15>
  }
  object { CSG284 }
}
#declare CSG285 = union {
  box { // Cube1718
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.375, -0.175>
  }
  box { // Cube1719
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.625, -0.175>
  }
  box { // Cube1720
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.875, -0.175>
  }
  box { // Cube1721
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.125, -0.175>
  }
  box { // Cube1722
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.375, -0.175>
  }
  box { // Cube1723
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.625, -0.175>
  }
  box { // Cube1724
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 1.875, -0.175>
  }
  box { // Cube1725
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.125, -0.175>
  }
  box { // Cube1726
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.375, -0.175>
  }
  box { // Cube1727
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.625, -0.175>
  }
  box { // Cube1728
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 2.875, -0.175>
  }
  box { // Cube1729
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.125, -0.175>
  }
  box { // Cube1730
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.375, -0.175>
  }
  box { // Cube1731
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.625, -0.175>
  }
  box { // Cube1732
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 3.875, -0.175>
  }
  box { // Cube1733
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.125, -0.175>
  }
  box { // Cube1734
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.375, -0.175>
  }
  box { // Cube1735
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.625, -0.175>
  }
  box { // Cube1736
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 4.875, -0.175>
  }
  box { // Cube1737
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.125, -0.175>
  }
  box { // Cube1738
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.375, -0.175>
  }
  box { // Cube1739
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.625, -0.175>
  }
  box { // Cube1740
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 5.875, -0.175>
  }
  box { // Cube1741
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.15>
    translate  <0.0, 0.125, -0.175>
  }
  material {
    traeex_5
  }
  scale <1.0, 1.0, 0.5>
  translate  -0.02*z
}
#declare CSG286 = union {
  cylinder { // Cylndr578
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.75, -0.1>
  }
  cylinder { // Cylndr579
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.4, -0.1>
  }
  cylinder { // Cylndr580
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 7.05, -0.1>
  }
  cylinder { // Cylndr581
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*y
    translate  <1.0, 6.7, -0.1>
  }
}
#declare skrovCSG03 = difference {
  cylinder { // Cylndr577
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 1.0, 8.0>
    rotate -90.0*x
    translate  -0.35*z
  }
  box { // Cube1716
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 4.0, 1.0>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube1717
    <-1, -1, -1>, <1, 1, 1>
    material {
      traeex_5
    }
    scale <0.65, 2.95, 0.3>
    translate  3.0*y
  }
  object { CSG285 }
  box { // Cube1742
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    rotate -35.0*x
    translate  <0.0, 8.043279, -2.131496>
  }
  box { // Cube1743
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 1.0>
    translate  <0.0, 7.0, 1.2>
  }
  box { // Cube1744
    <-1, -1, -1>, <1, 1, 1>
    scale <0.13, 0.1, 0.3>
    translate  <0.4, 6.0, -0.15>
  }
  object { CSG286 }
}
#declare plankCSG03 = union {
  object { akterCSG03 }
  object { skrovCSG03 }
  material {
    planktex_1
  }
}
union { // CSG287
  object { CSG283 }
  object { fockCSG03 }
  object { storsegelCSG03 }
  object { skeppfoesterCSG03 }
  object { mastCSG03 }
  object { plankCSG03 }
  box { // durk03
    <-1, -1, -1>, <1, 1, 1>
    material {
      planktex_1
    }
    scale <3.0, 0.05, 0.7>
    rotate <-90.0, 0.0, -90.0>
    translate  <0.0, 3.0, -0.34>
  }
  scale 2.8
  rotate <0.4, 2.0, -90.0>
  translate  <-105.660095, 30.126824, -1.5>
}


#declare CSG288 = union {
  box { // Cube1745
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.0, 5.0, 3.0>
  }
  box { // Cube1746
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.5, 5.5, 1.0>
    translate  -4.0*z
  }
  box { // Cube1747
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, 4.5, 0.0>
  }
  box { // Cube1748
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, 4.5, 0.0>
  }
  box { // Cube1749
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, 4.5, 0.0>
  }
  box { // Cube1750
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, -4.5, 0.0>
  }
  box { // Cube1751
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, -4.5, 0.0>
  }
  box { // Cube1752
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, 4.5, 0.0>
  }
  box { // Cube1753
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, -4.5, 0.0>
  }
  box { // Cube1754
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, -4.5, 0.0>
  }
  box { // Cube1755
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, 1.5, 0.0>
  }
  box { // Cube1756
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, -1.5, 0.0>
  }
  box { // Cube1757
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, 1.5, 0.0>
  }
  box { // Cube1758
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, -1.5, 0.0>
  }
  box { // Cube1759
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <5.5, 5.5, 1.0>
    translate  4.0*z
  }
}
#declare RndCube014 = merge {
  sphere { <0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, 0.4400, -0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  box { <-0.4400, -0.4400, -0.5000> <0.4400, 0.4400, 0.5000> }
  box { <-0.4400, -0.5000, -0.4400> <0.4400, 0.5000, 0.4400> }
  box { <-0.5000, -0.4400, -0.4400> <0.5000, 0.4400, 0.4400> }
// Attributes returned success!
  material {
    boxtex1
  }
  scale <11.0, 11.0, 10.0>
}
intersection { // boxCSG05
  object { CSG288 }
  object { RndCube014 }
  material {
    boxtex1
  }
  scale 0.15
  rotate -60.0*z
  translate  <-25.311964, 39.993088, -1.25>
}


#declare CSG289 = union {
  box { // Cube1760
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.0, 5.0, 3.0>
  }
  box { // Cube1761
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.5, 5.5, 1.0>
    translate  -4.0*z
  }
  box { // Cube1762
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, 4.5, 0.0>
  }
  box { // Cube1763
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, 4.5, 0.0>
  }
  box { // Cube1764
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, 4.5, 0.0>
  }
  box { // Cube1765
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, -4.5, 0.0>
  }
  box { // Cube1766
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, -4.5, 0.0>
  }
  box { // Cube1767
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, 4.5, 0.0>
  }
  box { // Cube1768
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, -4.5, 0.0>
  }
  box { // Cube1769
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, -4.5, 0.0>
  }
  box { // Cube1770
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, 1.5, 0.0>
  }
  box { // Cube1771
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, -1.5, 0.0>
  }
  box { // Cube1772
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, 1.5, 0.0>
  }
  box { // Cube1773
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, -1.5, 0.0>
  }
  box { // Cube1774
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <5.5, 5.5, 1.0>
    translate  4.0*z
  }
}
#declare RndCube015 = merge {
  sphere { <0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, 0.4400, -0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  box { <-0.4400, -0.4400, -0.5000> <0.4400, 0.4400, 0.5000> }
  box { <-0.4400, -0.5000, -0.4400> <0.4400, 0.5000, 0.4400> }
  box { <-0.5000, -0.4400, -0.4400> <0.5000, 0.4400, 0.4400> }
// Attributes returned success!
  material {
    boxtex1
  }
  scale <11.0, 11.0, 10.0>
}
intersection { // boxCSG06
  object { CSG289 }
  object { RndCube015 }
  material {
    boxtex2
  }
  scale 0.1
  rotate -60.0*z
  translate  <-26.961094, 40.684911, -1.5>
}


#declare CSG290 = union {
  box { // Cube1775
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.0, 5.0, 3.0>
  }
  box { // Cube1776
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <5.5, 5.5, 1.0>
    translate  -4.0*z
  }
  box { // Cube1777
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, 4.5, 0.0>
  }
  box { // Cube1778
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, 4.5, 0.0>
  }
  box { // Cube1779
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, 4.5, 0.0>
  }
  box { // Cube1780
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 1.0, 3.0>
    translate  <-4.5, -4.5, 0.0>
  }
  box { // Cube1781
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 1.0, 3.0>
    translate  <4.5, -4.5, 0.0>
  }
  box { // Cube1782
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, 4.5, 0.0>
  }
  box { // Cube1783
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <1.0, 0.7, 3.0>
    translate  <1.5, -4.5, 0.0>
  }
  box { // Cube1784
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <1.0, 0.7, 3.0>
    translate  <-1.5, -4.5, 0.0>
  }
  box { // Cube1785
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, 1.5, 0.0>
  }
  box { // Cube1786
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <4.5, -1.5, 0.0>
  }
  box { // Cube1787
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, 1.5, 0.0>
  }
  box { // Cube1788
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex1
    }
    scale <0.7, 1.0, 3.0>
    translate  <-4.5, -1.5, 0.0>
  }
  box { // Cube1789
    <-1, -1, -1>, <1, 1, 1>
    material {
      boxtex2
    }
    scale <5.5, 5.5, 1.0>
    translate  4.0*z
  }
}
#declare RndCube016 = merge {
  sphere { <0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, 0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, 0.4400>, 0.0600 }
  sphere { <0.4400, 0.4400, -0.4400>, 0.0600 }
  sphere { <0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, -0.4400, -0.4400>, 0.0600 }
  sphere { <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, -0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, -0.4400, -0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, -0.4400, -0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, 0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, 0.4400>, <0.4400, -0.4400, 0.4400>, 0.0600 }
  cylinder { <0.4400, 0.4400, -0.4400>, <0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, -0.4400>, <-0.4400, -0.4400, -0.4400>, 0.0600 }
  cylinder { <-0.4400, 0.4400, 0.4400>, <-0.4400, -0.4400, 0.4400>, 0.0600 }
  box { <-0.4400, -0.4400, -0.5000> <0.4400, 0.4400, 0.5000> }
  box { <-0.4400, -0.5000, -0.4400> <0.4400, 0.5000, 0.4400> }
  box { <-0.5000, -0.4400, -0.4400> <0.5000, 0.4400, 0.4400> }
// Attributes returned success!
  material {
    boxtex1
  }
  scale <11.0, 11.0, 10.0>
}
intersection { // boxCSG07
  object { CSG290 }
  object { RndCube016 }
  material {
    boxtex2_1
  }
  scale 0.1
  rotate -80.0*z
  translate  <-24.445117, 38.670177, -1.5>
}


#declare CSG291 = difference {
  torus { // Torus127
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1790
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1791
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  scale 1.02
}
#declare CSG292 = difference {
  torus { // Torus128
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1792
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1793
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  rotate 34.158123*z
}
#declare CSG293 = difference {
  torus { // Torus129
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1794
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1795
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  scale 1.04
  rotate 81.231888*z
}
#declare CSG294 = difference {
  torus { // Torus130
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1796
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1797
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  scale 0.9
  rotate 62.798817*z
}
#declare CSG295 = difference {
  torus { // Torus131
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1798
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1799
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  scale 0.97
  rotate 114.154213*z
}
#declare CSG296 = difference {
  torus { // Torus132
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1800
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1801
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  scale 1.03
  rotate 139.778519*z
}
#declare CSG297 = difference {
  torus { // Torus133
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1802
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1803
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  scale 1.03
  rotate -170.858597*z
}
#declare CSG298 = difference {
  torus { // Torus134
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1804
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1805
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  scale <1.15, 1.07, 1.07>
  rotate -48.844906*z
}
#declare CSG299 = difference {
  torus { // Torus135
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1806
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1807
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  scale 0.97
  rotate -9.276788*z
}
#declare CSG300 = difference {
  torus { // Torus136
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1808
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1809
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  scale <1.1, 0.96, 0.96>
  rotate -83.593781*z
}
#declare CSG301 = difference {
  torus { // Torus137
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1810
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1811
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  scale <0.97, 1.01, 1.01>
  rotate -113.108772*z
}
#declare CSG302 = difference {
  torus { // Torus138
    1.95, 0.05  rotate -x*90
    scale <0.6, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.87, 0.0, -0.5>
  }
  box { // Cube1812
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 3.5>
    translate  <-1.5, 0.0, -3.75>
  }
  box { // Cube1813
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 4.0>
    translate  -1.0*z
  }
  scale <1.3, 1.0, 1.0>
  rotate -152.624283*z
}
#declare CSG303 = union {
  object { CSG291 }
  object { CSG292 }
  object { CSG293 }
  object { CSG294 }
  object { CSG295 }
  object { CSG296 }
  object { CSG297 }
  object { CSG298 }
  object { CSG299 }
  object { CSG300 }
  object { CSG301 }
  object { CSG302 }
  material {
    vattentex
  }
}
#declare RotSweep001 = lathe {
  quadratic_spline
  24  // control points
  <0.299363, -1.010616>,
  <2.575026, -0.998938>,
  <3.336968, -0.996683>,
  <3.783425, -0.911525>,
  <3.830388, -0.783493>,
  <3.82768, -0.54034>,
  <3.725081, -0.437547>,
  <3.795481, -0.29804>,
  <3.701572, -0.041792>,
  <3.286185, -0.048062>,
  <3.143754, -0.258099>,
  <3.345779, -0.402957>,
  <3.402667, -0.597173>,
  <3.250476, -0.727214>,
  <2.713002, -0.740524>,
  <0.844455, -0.597069>,
  <0.359241, 0.587285>,
  <1.00349, 1.627219>,
  <0.602706, 2.000307>,
  <0.383357, 2.298909>,
  <0.465103, 2.735433>,
  <0.257343, 2.884504>,
  <0.410217, 3.081823>,
  <0.016937, 3.234981>
  rotate <90,0,90>
  material {
    fontaetex
  }
}
union { // fontanCSG01
  object { CSG303 }
  cylinder { // Cylndr582
    <0,0,1>, <0,0,0>, 1 
    material {
      vattentex
    }
    scale <3.5, 3.5, 0.7>
    translate  -0.9*z
  }
  object { RotSweep001 }
  scale 0.75
  translate  <-63.832089, 46.716876, -1.25>
}


