// zeppelin.inc
// Defines a Zeppelin declaration
// tail is down - rotate to get desired orientation

// number of ribs spaced radially about gasbag
#declare NumRibs = 30;
#declare ZeppLength = 245;

#declare NumZeppG = 10;
#declare ZeppGR = array[NumZeppG] {
    3.1, 6.75, 10.0, 12.5, 14.1, 15.65, 17.35, 18.60, 19.55, 20.05
}
#declare ZeppGY = array[NumZeppG] {
    5, 15, 25, 35, 45, 55, 65, 75, 85, 95
}
#declare ZeppGX = array[NumZeppG]
#declare ZeppGZ = array[NumZeppG]
#declare ZeppGXX = array[NumZeppG]
#declare ZeppGZZ = array[NumZeppG]

#declare Zeppelin =
sor { 32,
    <0,0>          // tail end
    <00.01,0.01>
    <ZeppGR[0],ZeppGY[0]>
    <ZeppGR[1],ZeppGY[1]>
    <ZeppGR[2],ZeppGY[2]>
    <ZeppGR[3],ZeppGY[3]>
    <ZeppGR[4],ZeppGY[4]>
    <ZeppGR[5],ZeppGY[5]>
    <ZeppGR[6],ZeppGY[6]>
    <ZeppGR[7],ZeppGY[7]>
    <ZeppGR[8],ZeppGY[8]>
    <ZeppGR[9],ZeppGY[9]>
    <20.50,105>
    <20.60,115>
    <20.60,125>
    <20.60,135>
    <20.60,145>
    <20.60,155>
    <20.60,165>
    <20.50,175>
    <20.20,185>
    <19.45,195>
    <18.60,205>
    <16.90,215>
    <15.00,225>
    <10.95,235>
    <07.35,240>
    <00.40,ZeppLength>  // nose end
    <00.25,ZeppLength+1> // spike
    <00.10,ZeppLength+2>
    <00.01,ZeppLength+3>
    <00.00,ZeppLength+3.01>
    sturm
    hollow
}

#declare EngineCar =
union {
    superellipsoid { <1,0.8>
        texture {
            pigment { rgb <0.89,0.9,0.91> }
        }
        scale <1.5,1.5,3>
    }
    union {
        superellipsoid { <1,0.2>
            scale <4,0.3,0.1>
        }
        superellipsoid { <1,0.2>
            scale <0.3,4,0.1>
        }
        texture {
            pigment { rgb <0.8,0.6,0.1> }
        }
        translate <0,0,3>
    }
}

#if (!FastZepp)
#declare NumGirds = 15;
#declare ZeppGW = 0.1;
#declare ZeppGRW = 0.2;
#declare Angle = 0;
#declare NextAngle = 2 * pi / NumGirds;

#declare ZeppGirders =
union {
    #while (Angle < 2 * pi)
        #declare ZeppGX[0] = ZeppGR[0] * cos(Angle);
        #declare ZeppGZ[0] = ZeppGR[0] * sin(Angle);
        #declare ZeppGXX[0] = ZeppGR[0] * cos(NextAngle);
        #declare ZeppGZZ[0] = ZeppGR[0] * sin(NextAngle);
        Girder(0, 0, 0, ZeppGX[0], ZeppGY[0], ZeppGZ[0], ZeppGW)
        Girder(ZeppGX[0], ZeppGY[0], ZeppGZ[0], ZeppGXX[0], ZeppGY[0], ZeppGZZ[0], ZeppGRW)
        
        #declare Zeppi = 1;
        #while (Zeppi < NumZeppG)
            #declare ZeppGX[Zeppi] = ZeppGR[Zeppi] * cos(Angle);
            #declare ZeppGZ[Zeppi] = ZeppGR[Zeppi] * sin(Angle);
            #declare ZeppGXX[Zeppi] = ZeppGR[Zeppi] * cos(NextAngle);
            #declare ZeppGZZ[Zeppi] = ZeppGR[Zeppi] * sin(NextAngle);
            Girder(0, 0, 0, ZeppGX[Zeppi], ZeppGY[Zeppi], ZeppGZ[Zeppi], ZeppGW)
            Girder(ZeppGX[Zeppi], ZeppGY[Zeppi], ZeppGZ[Zeppi],
                ZeppGXX[Zeppi], ZeppGY[Zeppi], ZeppGZZ[Zeppi], ZeppGRW)
            Girder((ZeppGX[Zeppi-1]+ZeppGX[Zeppi])/2,
                (ZeppGY[Zeppi-1]+ZeppGY[Zeppi])/2,
                (ZeppGZ[Zeppi-1]+ZeppGZ[Zeppi])/2,
                (ZeppGXX[Zeppi-1]+ZeppGXX[Zeppi])/2,
                (ZeppGY[Zeppi-1]+ZeppGY[Zeppi])/2,
                (ZeppGZZ[Zeppi-1]+ZeppGZZ[Zeppi])/2,
                ZeppGRW)
            #declare Zeppi = Zeppi + 1;
        #end // #while
        
        #declare Angle = NextAngle;
        #declare NextAngle = NextAngle + 2 * pi / NumGirds;
    #end // #while
    // tailfin
    Girder(0,4,3,0,8,22,ZeppGRW)
    Girder(0,8,22,0,42,22,ZeppGRW)
    Girder(0,42,22,0,46,15,ZeppGRW)
    #declare Zeppi = 10;
    #while (Zeppi < 45)
        Girder(0,Zeppi,22,0,Zeppi,5,ZeppGRW)
        #declare Zeppi = Zeppi + 5;
    #end
    Girder(0,5,7,0,15,7,ZeppGRW)
    Girder(0,6,12,0,34,12,ZeppGRW)
    Girder(0,7,17,0,45,17,ZeppGRW)
}

#end // #if (!FastZepp)
