#declare Step = 100*m ;
#declare StepVar = 20*m ;
#declare AngleMax = 200*m ;
#declare AngleMin = 100*m ;
#declare VarR = 10*m ;
#declare DeltaR = 0.65 ;//0.7 ;
#declare Prob = 12/13 ;//0.9434515 ;
#declare P2 = 0.4 ;
#declare NbBranches = 0 ;

#declare Seed = seed (1564) ;

#macro LavaBranch (Start, Angle, R, StartPos)
  #declare NbBranches = NbBranches + 1 ;
  #if ((Start>0)*(rand(Seed)>(1-Prob))*(R>10*m))
    #local Test = rand (Seed) ;
    #if (Test>P2)
      #if (Test<(1-P2))
	#local End = Start - Step - (rand(Seed)-0.5)*StepVar ;
	#local Angle2 = Angle + 2*(AngleMin + (AngleMin-AngleMax)*rand(Seed))/(7*km-End*6*km/(2540*m))*180/pi ;
	#local EndPos = vaxis_rotate(<7*km-End*6*km/(2540*m), End, 0>, y, Angle2) ;
	#local EndR = R*DeltaR + VarR*(rand(Seed)-0.5) ;
      #else
	#local End = Start - Step - (rand(Seed)-0.5)*StepVar ;
	#local Angle2 = Angle + (AngleMin + (AngleMin-AngleMax)*rand(Seed))/(7*km-End*6*km/(2540*m))*180/pi ;
	#local EndPos = vaxis_rotate(<7*km-End*6*km/(2540*m), End, 0>, y, Angle2) ;
	#local EndR = R + VarR*(rand(Seed)-0.5) ;
      #end
      cone {StartPos, R, EndPos, EndR}
      sphere {EndPos, EndR}
      LavaBranch (End, Angle2, EndR, EndPos)
    #end
    #if (Test<(1-P2))
      #if (Test>P2)
	#local End = Start - Step - (rand(Seed)-0.5)*StepVar ;
	#local Angle2 = Angle - 2*(AngleMin + (AngleMin-AngleMax)*rand(Seed))/(7*km-End*6*km/(2540*m))*180/pi ;
	#local EndPos = vaxis_rotate(<7*km-End*6*km/(2540*m), End, 0>, y, Angle2) ;
	#local EndR = R*DeltaR + VarR*(rand(Seed)-0.5) ;
      #else
	#local End = Start - Step - (rand(Seed)-0.5)*StepVar ;
	#local Angle2 = Angle - (AngleMin + (AngleMin-AngleMax)*rand(Seed))/(7*km-End*6*km/(2540*m))*180/pi ;
	#local EndPos = vaxis_rotate(<7*km-End*6*km/(2540*m), End, 0>, y, Angle2) ;
	#local EndR = R + VarR*(rand(Seed)-0.5) ;
      #end
      cone {StartPos, R, EndPos, EndR}
      sphere {EndPos, EndR}
      LavaBranch (End, Angle2, EndR, EndPos)
    #end
  #end
#end

/*#declare Lava = union {
  sphere { <1000, 2540, 0>*m, 200*m }
  LavaBranch (2540*m, 0, 200*m, <1000, 2540, 0>*m)
  #render concat("\nDeltaR: ", str(DeltaR, 4, 2), ", NbBranches: ", str(NbBranches, 0, 0), "\n")
  scale <1, 0.5, 1>
  bounded_by {
    cone { 0, (7*km+150*m), (1270*m+150*m)*y, (1*km+150*m) }
  }
  
  texture {
    pigment {
      bozo
      color_map {
	[ 0.00 color rgb <1.0, 0.0, 0.0> ]
	[ 0.05 color rgb <1.0, 0.0, 0.0> ]
	[ 0.50 color rgb <0.8, 0.2, 0.0>*2 ]
	[ 0.90 color rgb <0.8, 0.5, 0.0>*2 ]
	[ 0.98 color rgb <0.5, 0.0, 0.0> ]
	[ 0.99 color rgb <0.8, 0.7, 0.1>*2 ]
	[ 1.00 color rgb <1.0, 1.0, 0.4>*3 ]
      }
      scale 50*m
    }
    finish {
      ambient 0.5
    }
  }
  rotate 40*y
}*/
#declare LavaPigment = pigment {
  bozo
  color_map {
    [ 0.00 color rgb <1.0, 0.0, 0.0> ]
    [ 0.05 color rgb <1.0, 0.0, 0.0> ]
    [ 0.50 color rgb <0.8, 0.2, 0.0>*2 ]
    [ 0.90 color rgb <0.8, 0.5, 0.0>*2 ]
    [ 0.98 color rgb <0.5, 0.0, 0.0> ]
    [ 0.99 color rgb <0.8, 0.7, 0.1>*2 ]
    [ 1.00 color rgb <1.0, 1.0, 0.4>*3 ]
  }
  scale 50*m
  scale 1/(7*km)
}

#macro LavaP2 (T1, T2)
  gradient y
  pigment_map {
    [ 0.0  color White/50 ]
    [ 1-T2 color White/50 ]
    [ 1-T1 LavaPigment scale 7 ]
    [ 1.0  LavaPigment scale 7 ]
  }
  scale 1.270/7
#end

#declare Lava = cone {
  0, 7000*m, 1270*m*y, 1000*m
  
  texture {
    pigment {
      radial
      pigment_map {
	[ 0.000 color White/50 ]
	[ 0.500 color White/50 ]
	[ 0.505 LavaP2 (0.4, 0.5) ]
	[ 0.510 color White/50 ]
	[ 0.512 color White/50 ]
	[ 0.520 LavaP2 (0.9, 1.0) ]
	[ 0.528 color White/50 ]
	[ 0.532 color White/50 ]
	[ 0.540 LavaP2 (0.9, 1.0) ]
	[ 0.548 color White/50 ]
	[ 0.550 color White/50 ]
	[ 0.555 LavaP2 (0.3, 0.5) ]
	[ 0.560 color White/50 ]
	[ 1.000 color White/50 ]
      }
      turbulence 0.3
      octaves 4
      
    }
    scale 7*km
  }
  finish {
    ambient 0.5
  }
  rotate -140*y
}