// Reed Plugin - Creates a mesh object representing a patch of reeds

#declare XI = 0;
#declare XSteps = (XEnd-XStart)/XStep;
#declare YSteps = (YEnd-YStart)/YStep;
#declare ZT0 = ZPos - MeanBladeWidth/4; // Just below the ground

// Mesh object definition starts here

mesh{
#while (XI < XSteps)
       #declare YI = 0;
       #while (YI < YSteps)
          #declare XOff = XStart + (XStep * (XI + ((rand(R1)*XStepRand*2)-XStepRand)));
          #declare YOff = YStart + (YStep * (YI + ((rand(R1)*YStepRand*2)-YStepRand)));
          #declare NumBlades = MinBlades + ((MaxBlades-MinBlades)*rand(R1));
          #declare BladeNum = 1;
          #while (BladeNum <= NumBlades)
              #declare BladeAngle = MinAngle + ((MaxAngle-MinAngle)*rand(R1));
              #declare BladeHeight = MeanBladeHeight*(1+((rand(R1)-0.5)*HeightVar*2));
              #declare BladeWidth = MeanBladeWidth*(1+((rand(R1)-0.5)*WidthVar*2));
              #declare BladeBearing = rand(R1)*360;
              #declare BladeCurve = MinCurve + ((MaxCurve-MinCurve)*rand(R1));
              #declare BladeSegs = MinBladeSegs + ((MaxBladeSegs-MinBladeSegs)*rand(R1));
              #declare CurvePerSeg = BladeCurve/BladeSegs;
              #declare SegCurve = CurvePerSeg;
              #declare PT0 = <XOff + (XStep * (1+((rand(R1)*XStepRand*2)-XStepRand))),
                              YOff + (YStep * (1+((rand(R1)*YStepRand*2)-YStepRand))), ZT0>;
              #declare SegLen = BladeHeight * (pow(1.25,BladeSegs-1)/(pow(1.25,BladeSegs)-1)) *(1.25-1);
              #declare SegTaper = (SegLen/BladeHeight)/pow(1.25,BladeSegs);
              #declare SegWidth = BladeWidth * (1-SegTaper);
              #declare PT1 = PT0 + vrotate(<BladeWidth,0,0>,<0,0,BladeBearing>);
              #declare PT3 = PT0 + vrotate(<0,0,SegLen>,<BladeAngle,0,BladeBearing>);
              #declare PT2 = PT3 + vrotate(<SegWidth,0,0>,<0,0,BladeBearing>);
              #declare NT0 = vrotate(<0,-1,0>,<BladeAngle/2,0,BladeBearing>);
              #declare NT1 = vrotate(<0,-1,0>,<(BladeAngle+SegCurve)/2,0,BladeBearing>);
              #declare BladeSeg = 0;
              #while (BladeSeg<BladeSegs-1)
                    smooth_triangle{
                       PT0, NT0,
                       PT1, NT0,
                       PT2, NT1
                     }
                     smooth_triangle{
                       PT2, NT1,
                       PT3, NT1,
                       PT0, NT0
                     }
                     #declare SegLen = SegLen /1.25;
                     #declare PT0 = PT3;
                     #declare PT1 = PT2;
                     #declare NT0 = NT1;
                     #declare NT1 = vrotate(
                                      vrotate(
                                        vrotate(NT1
                                               ,<0,0,BladeBearing*-1>
                                               )
                                             ,<CurvePerSeg,0,0>
                                             )
                                           ,<0,0,BladeBearing>
                                           );
                     #declare PT3 = PT0 + vrotate(vrotate(<0,0,SegLen>, <SegCurve,0,0>), <BladeAngle,0,BladeBearing>);
                     #declare PT2 = PT3 + vrotate(<SegWidth,0,0>,<0,0,BladeBearing>);
                     #declare SegCurve = SegCurve + CurvePerSeg;
                     #declare SegTaper = SegTaper * 1.25;
                     #declare SegWidth = SegWidth - (BladeWidth * SegTaper);
                     #declare BladeSeg = BladeSeg + 1;
                     #declare NumTri = NumTri + 2;
              #end
              smooth_triangle{
                PT0, NT0,
                PT1, NT0,
                (PT2+PT3)/2, NT1
              }
              #declare BladeNum = BladeNum + 1;
              #declare NumTri = NumTri + 1;
          #end
          #declare YI = YI + 1;
       #end
       #declare XI = XI + 1;
#end
texture{ Grass_Text}
}
#debug concat("Number of triangles = ", str(NumTri,0,0), "\n")
