#include "torche.inc"

#declare Column = union {
  union {
    torus { 35*cm, 10*cm scale <1, 2, 1> }
    torus { 35*cm, 2*cm translate 20*cm*y }
    torus { 35*cm, 2*cm translate (4.5*m-20*cm)*y }
    torus { 35*cm, 10*cm scale <1, 2, 1> translate 4.5*m*y }
    
    pigment {
      Blood_Marble
      scale 20*cm
    }
  }
  cylinder {
    0*y, 4.5*m*y, 35*cm
    pigment {
      White_Marble
      scale 20*cm
    }
  }
}

union {
  union {
    box { <-5, 0, -5>*m, <5, 1, 5>*m }
    difference {
      box { <-5, 0.9, -5>*m, <5, 1.75, 5>*m }
      box { <-4, 0, -4>*m, <4, 3, 4>*m }
      box { <-3, 0, -6>*m, <3, 3, -3>*m }
      bounded_by { box { <-5, 0.9, -5>*m, <5, 1.75, 5>*m } }
    }
    #local NbSteps = 6 ;
    #local i = 0 ;
    #while (i<NbSteps)
      box { <-5+i*2/NbSteps, 0, -5-(NbSteps-i)*2/NbSteps>*m, <5-i*2/NbSteps, (i+1)/(NbSteps-1), -5>*m }
      #local i = i+1 ;
    #end
    difference {
      cylinder { 0*y, 6.5*m*y, 3*m }
      box { <-1.01, 0.5, -3.1>*m, <1.01, 5.01, -2>*m }
    }
    box { <-5, 6.4, -5>*m, <5, 7, 5>*m }

    texture {
      T_Stone7
      normal { dents scale 0.1 }
      finish { phong 0 specular 0 }
      pigment { color <1,0.9,.7> }
    }
  }
  difference {
    box { <-5.1, 1.75, -5.1>*m, <5.1, 1.9, 5.1>*m }
    box { <-4, 0, -4>*m, <4, 3, 4>*m }
    box { <-3, 0, -6>*m, <3, 3, -3>*m }
    bounded_by { box { <-5.1, 1.75, -5.1>*m, <5.1, 1.9, 5.1>*m } }
    
    texture {
      pigment { White_Marble scale 20*cm }
      normal { dents scale 0.1 }
    }
  }
  
  difference {
    box { <-1.3, 0.5, -3.1>*m, <1.3, 5.3, -2>*m }
    box { <-1.0, 0.5, -3.2>*m, <1.0, 5, -1.9>*m }

    texture {
      pigment { White_Marble scale 20*cm }
      normal { dents scale 0.1 }
    }
  }
  object {
    Torch
    rotate 45*y
    translate <-1.3, 3, -3.1>*m
  }
  object {
    Torch
    rotate -45*y
    translate <1.3, 3, -3.1>*m
  }
  union {
    difference {
      box { <-1.01, 0.6, -3>*m, <1.01, 5.05, -2>*m }
      #local i = 0 ;
      #while (i<4)
	#local j = 0 ;
	#while (j < 8)
	  box { <-0.95+0.5*i, 1.05+0.5*j, -3.1>*m, <-0.55+0.5*i, 1.45+0.5*j, -2.9>*m }
	  #local j = j+1 ;
	#end
	#local i = i+1 ;
      #end
    }
    cylinder { 0*y, 5.05*m*y, 5*cm translate -3*m*z }
    //pigment { DMFDarkOak scale 50*cm rotate 90*x translate 4*m*x }
    pigment {
      wood
      turbulence 0.04            // For best results,  keep this low!
      octaves 3
      scale <0.2, 0.2, 1>        // Scaled for a unit object
      color_map {
	[0.1 rgb <0.60, 0.30, 0.18>*1.3]
	[0.9 rgb <0.30, 0.15, 0.09>*1.3]
      }
      scale 50*cm
      rotate 90*x
      translate 4*m*x
    }
    translate 50*cm*z
  }
  
  #local NbCols = 4 ;
  #local i = -4.5*m ;
  #while (i<=4.5*m)
    object {
      Column
      translate <4.5*m, 1.9*m, i>
    }
    #local i = i+9*m/NbCols ;
  #end
  #local i = -4.5*m ;
  #while (i<=4.5*m)
    object {
      Column
      translate <-4.5*m, 1.9*m, i>
    }
    #local i = i+9*m/NbCols ;
  #end
  #local i = -4.5*m+9*m/NbCols ;
  #while (i<4.5*m)
    object {
      Column
      translate <i, 1.9*m, 4.5*m>
    }
    #local i = i+9*m/NbCols ;
  #end
  
  /*difference {
    sphere { 0, 3.25*m }
    plane { y, 1.25*m }
    translate 5.75*m*y
    
    texture { Gold_Metal }
  }*/
  sphere {
    0, 3.25*m
    clipped_by { box { <-3, 1.25, -3>*m, <3, 3.25, 3>*m } }
    translate 5.75*m*y
    texture { Gold_Metal }
  }
}