#declare Torch = union {
  union {
    cone {
      -30*cm*y, 1*cm, 30*cm*y, 5*cm
    }
    sphere {
      -30*cm*y, 1*cm
    }
    sphere {
      31*cm*y, 5*cm
    }
    pigment {
      DMFDarkOak
      scale 30*cm
      rotate 90*x
    }
  }
  cylinder {
    0, 30*cm*z, 2*cm
    pigment { color Black }
    rotate 45*x
  }
  union {
    cylinder {
      0, 100*cm*y, 10*cm
      pigment { color rgbf 1 }
      hollow
      interior {
	media {
	  emission 100
	  density {
	    cylindrical
	    color_map {
	      [ 0.00 color rgb <0.0, 0.0, 0.0> ]
	      [ 0.20 color rgb <0.0, 0.0, 0.0> ]
	      [ 0.50 color rgb <1.0, 0.1, 0.0> ]
	      [ 0.80 color rgb <1.0, 0.2, 0.0> ]
	      [ 1.00 color rgb <1.0, 0.9, 0.2> ]
	    }
	    turbulence 1.0
	    scale 10*cm
	  }
	  density {
	    gradient y
	    color_map {
	      [ 0.00 color rgb 1 ]
	      [ 1.00 color rgb 0 ]
	    }
	    scale 100*cm
	  }
	}
      }
    }
    light_source {
      10*cm*y
      color rgb <1.0, 0.9, 0.2>/3
      media_interaction off
      fade_distance 3*m
      fade_power 2
    }
    rotate 45*x
    translate 30*cm*y
  }
  translate 30*cm*y
  rotate -45*x
}
