/******************** Included files ********************/
        
#include "colors.inc" 
#include "textures.inc"
#include "woods.inc"   
#include "metals.inc"    
#include "stones1.inc"     
#include "skies.inc"

#declare R1=seed(0);
#declare R2=seed(71376);                   
                   
/******************** Textures ********************/

#declare CarBlackRubber =
texture
{ 
  pigment { color rgb 0 }
  finish {
    roughness .1
    reflection 0
    specular .2
  }
  normal {
    bumps -.5
    scale .01
  }
}

#declare CarWhiteMetal =
texture
{
  pigment { color rgb 1 }
  finish { F_MetalB }
}

#declare CarBlackMetal =
texture
{
  pigment { color rgb 0 }
  finish { F_MetalA }
}

#declare CarSteel =
texture
{
  T_Chrome_2B
}

#declare CarWood = texture { T_Wood13 scale .5 }
     
#declare CarBodyPaint =
texture
{
  finish {
    diffuse .7
    brilliance 6.0
    reflection 0.1
    phong 0.6
    phong_size 120
  }
  pigment { color rgb <.02,.01,.02> }
}      

#declare CarGold =
texture
{
  T_Gold_2E
}

#declare CarReflector =
texture
{
  T_Chrome_5E
}
  
#declare CarGlass =
texture
{
  NBglass
}  

#declare CarBlackLeather =
texture {
  pigment {
    rgb .05 
  }
  finish {
    ambient 0.1
    diffuse 0.7
    brilliance 6.0
    phong 0.2
    phong_size 120
  }
}


#declare PoleMetal =
texture {
  pigment { rgb <.05,.05,.05> }
  finish {
    roughness .1
    reflection 0
    specular .2
  }
  normal {
    bumps -.5
    scale .01
  }
}


#declare PoleGlass =
texture {
  pigment { rgbf <.9,.9,.9,.3> }
  
  finish {
    roughness .2
    reflection .3
  }
}
 
 
#declare BuildingMetal =
texture {
  pigment { rgb <.05,.1,.05> }
  finish {
    roughness .1
    reflection 0
    specular .2
  }
  normal {
    bumps -.5
    scale .01
  }
}
 

#declare BuildingBrick =
texture
{
  pigment {
    brick .05, <.8,.2,.2>
    brick_size <1,.5,1>
    mortar .03
  }
  
  finish {
    ambient 0.2 diffuse 0.4 
  }

  normal {
    wrinkles 5
    scale .05
  }
}


#declare BuildingStone =
texture
{
  pigment {
    brick pigment { rgb .05 },
      pigment {
        granite
        turbulence .6
        color_map {  
          [0 color rgb .2]
          [.2 color rgb <.7,.65,.6>]
          [1 color rgb .8]
        }
      }
    brick_size <2,2,.5>
    mortar .2
  }

  finish {
    ambient 0.2 diffuse 0.4 
  }

  normal {
    wrinkles 5
    scale .1
  }
}


#declare BuildingWood =
texture
{
  T_Wood15
}

#declare BuildingGlass =
texture
{
  Glass
}
 
#declare StreetStone =
texture
{
  pigment {
    brick .1, .2
    brick_size <.5,.3,.5>
    mortar .05
    rotate 90*x
    turbulence .1
  }
 
  normal {
    wrinkles 5
    scale .05
  }
}

#declare StreetSidewalk =
texture
{ 
  pigment { color rgb <.9,.9,.9> }
}


#declare BackWallStone =
texture
{
  pigment {
    brick pigment { rgb 0 },
      pigment {
        granite
        turbulence .6
        color_map {  
          [0 color rgb .2*.05]
          [.2 color rgb <.7,.65,.6>*.05]
          [1 color rgb .8*.05]
        }
      }
    brick_size <3,2,.5>
    mortar .2
  }
  
  finish {
    reflection 0
    ambient 0
    diffuse 1
  }
/*
  finish {
    ambient 0.2 diffuse 0.4 
  }
  */
}
 
 
/******************** Model T design ********************/
 
#declare TempWheel =
cylinder
{
  <0,-.1,0>, <0,.1,0>, 1  
  pigment { color rgb .5 }
}
 
            
#declare Wheel =
union
{
  difference {
    intersection {
      torus {
        .9, .2
        scale <1,.5,1>
      }
      sphere { <0,0,0>, 1 }
    }
    #declare N=0;
    #while (N<40)
      union {
        box {
          <-.03,-.03,0>, <.03,.2,.2>
          rotate 45*z
        }           
        box {
          <-.03,-.2,0>, <.03,-.03,.2>
          rotate -45*z      
        }                  
        translate <0,0,.97>
        rotate (N/40)*360*y
      }
      #declare N=N+1;
    #end                      
    cylinder { <0,-1,0>, <0,1,0>, .75 }
    bounded_by { box { <-1.05,-.15,-1.05>, <1.05,.15,1.05> } }
    texture { CarBlackRubber }
  }
  
  difference {
    cylinder { <0,-.08,0>, <0,.09,0>, .97 }
    cylinder { <0,-1,0>, <0,1,0>, .73 }
    texture { CarWhiteMetal }
  }
  
  #declare N=0;
  #while (N<12)
    cylinder {
      <0,0,0>, <0,0,.75>, .05
      texture { CarWood }
      rotate (N/12)*360*y
    }
    #declare N=N+1;
  #end             
  
  cylinder {
    <0,-.08,0>, <0,.08,0>, .2
    texture { CarWood }
  }
  
  union {
    cylinder { <0,-.082,0>, <0,.082,0>, .18 }
    cylinder { <0,-.15,0>, <0,.15,0>, .075 }
    texture { CarBlackMetal }
  }

  union {  
    #declare N=0;
    #while (N<6)
      sphere {
        <0,.082,.1275>, .02
        rotate (N/6)*360*y
      }           
      sphere {
        <0,-.082,.1275>, .02
        rotate (N/6)*360*y
      }
      #declare N=N+1;
    #end
    texture { T_Copper_5B }
  }
}
 
             
#declare Axle =
union
{
  object {
    Wheel
    rotate -90*z
    translate <2,0,0>
  }  
  object {
    Wheel
    rotate -90*z
    translate <-2,0,0>
  }
  cylinder {
    <-2.15,0,0>, <2.15,0,0>, .07
    texture { CarSteel }
  }
  sphere {
    <-2.15,0,0>, .07
    texture { CarSteel }
  } 
  sphere {
    <2.15,0,0>, .07
    texture { CarSteel }
  }
}


#declare UnderCarriage =
union
{
  object {
    Axle
    translate 0*z
  }                
  object {
    Axle
    translate 6*z
  }
  box {
    <-.3,-.1,0>, <.3,.1,6>
    texture { CarSteel }
  }
}
 
 
#declare SideRail =
union
{
  difference {
    cylinder { <-2.25,0,0>, <2.25,0,0>, 1.2 }  
    cylinder { <-3,0,0>, <3,0,0>, 1.15 }
    plane { z, 0 }
    plane {
      -z, 0
      rotate 45*x
    }
    translate <0,0,.3>
  }                           
  
  box {
    <-2.25,0,0>, <2.25,.05,1.2>
    rotate 45*x
    translate <0,cos(radians(45))*1.15,.3+sin(radians(45))*1.15>
  }
  cylinder {
    <-2.25,0,0>, <2.25,0,0>, .025
    translate <0,-.025*cos(radians(45)),.3+(2.4-.025)*cos(radians(45))>
  }
  box { <-2.25,-.05,.3+(2.4-.025)*cos(radians(45))>, <2.25,0,3> }

  box { <-2.25,-.05,2.5>, <2.25,0,4.825> }
  cylinder { <-2.25,-.025,4.825>, <2.25,-.025,4.825>, .025 }
  box { <-2.25,-.025,4.8>, <2.25,0.001,4.85> }
  difference {
    cylinder { <-2.25,0,6>, <2.25,0,6>, 1.2 }
    cylinder { <-3,0,6>, <3,0,6>, 1.15 } 
    plane { y, 0 }
    plane {
      y, 0
      rotate -20*x
      translate <0,0,6>
    }
    cylinder {
      <0,0,2.1>, <0,0,6.4>, 1.65
      scale <1,2,1>
      translate <0,2,0>
    }

  }
  cylinder {
    <-2.25,0,6>, <2.25,0,6>, .025
    translate 1.175*<0,sin(radians(20)),cos(radians(20))>
  }
          
  texture { CarBodyPaint }
}                                      
 
        
#declare Headlight =
union
{
  difference {
    sphere {
      <0,0,0>, .25
      scale <1,1,1.5>        
    }             
    sphere {
      <0,0,0>, .24
      scale <1,1,1.5>
    }
    plane { z, 0 }
    texture { CarGold }
  }
  difference {
    sphere { <0,0,0>, .24 }             
    sphere { <0,0,0>, .23 }
    plane { z, 0 }
    texture { CarReflector }
  }
  
  #declare R = (.24*.24+.024*.024)/.048;
  difference {
    difference {
      sphere { <0,0,0>, R }
      sphere { <0,0,0>, R-.005 }
      translate -(.024-R)*z 
    }
    plane { -z, 0 }
    texture { CarGlass }
  }
  
  union {
    difference {
      torus { .2, .04 }
      plane { z, 0 }
      plane { x, 0 }
    } 
    cylinder { <0,0,.2>, <-.1,0,.2>, .04 }
    cylinder { <.2,0,0>, <.2,0,-.25>, .04 }
    rotate 90*z
    translate <0,-.2,.6>
    texture { CarBlackMetal }
  }
}
 
        
#declare FrontRail =
union
{
  box { <-.25,1.15,-.3>, <.25,1.2,.3> }

  difference {
    cylinder { <-.25,0,0>, <.25,0,0>, .6 }  
    cylinder { <-1,0,0>, <1,0,0>, .55 }
    plane { -z, 0 }
    plane {
      z, 0
      rotate -60*x
    }
    translate <0,.6,-.3>
  }
  cylinder {
    <-.25,1.175,-.3>, <.25,1.175,-.3>, .025
    translate .575*<0,-cos(radians(60)),-sin(radians(60))>
  }
}       

       
#declare FrontBodyWork =
union
{
  union {
    object {
      FrontRail
      translate <2,0,0> 
    }
    object {
      FrontRail
      translate <-2,0,0>
    }

    box {
      <-(1.175-.2)/cos(radians(45)),-.025,-.3>, <0,.025,.3>
      rotate 45*z
      translate <1.75,1.175,0>
    }
    cylinder { <1.75,1.175,-.3>, <1.75,1.175,.3>, .025 }                      
    box {
      <(1.175-.2)/cos(radians(45)),-.025,-.3>, <0,.025,.3>
      rotate -45*z
      translate <-1.75,1.175,0>
    }
    cylinder { <-1.75,1.175,-.3>, <-1.75,1.175,.3>, .025 }                      

    box { <-.775,.175,-.3>, <.775,.225,.3> }
    cylinder { <-.775,.2,-.3>, <-.775,.2,.3>, .025 }
    cylinder { <.775,.2,-.3>, <.775,.2,.3>, .025 }
  
    difference {
      box { <-1.75,.2,.3>, <1.75,1.2,.31> }   
      plane {
        y, 0
        rotate 45*z
        translate <.775,.2,0>
      }
      plane {    
        y, 0
        rotate -45*z
        translate <-.775,.2,0>
      } 
    }

    texture { CarBodyPaint }
  }
  
  object {
    Headlight
    rotate -90*z
    translate <1.0,1.2,-.8>
  }
  object {
    Headlight
    rotate 90*z
    translate <-1.0,1.2,-.8>
  }

}
 
 
#declare Engine =  
union
{
  difference {
    box { <-.7,.225,-.1>, <.7,1.75,1.5> }
    plane {
      -y, 0
      rotate 45*z
      translate <-.7,1.5,0>
    }
    plane {
      -y, 0
      rotate -45*z
      translate <.7,1.5,0>
    }       
    box { <-1,.5,.1>, <1,1.3,1.3> }         
    texture { CarBodyPaint }
  }
  
  union {
    #declare N=0;
    #while (N<12)
      box {
        <-.01,.5,0>, <0,1.3,.05>
        rotate 45*y
        translate <.7,0,.1+(N/12)*1.2>
      }
      box {
        <.01,.5,0>, <0,1.3,.05>
        rotate -45*y
        translate <-.7,0,.1+(N/12)*1.2>
      }   
      #declare N=N+1;
    #end
    texture { CarBodyPaint }
  }    

  union {
    #declare N=0;
    #while (N<15)
      union {
        sphere { <.4,1.75,0>, .03 }   
        sphere { <-.4,1.75,0>, .03 }   
        sphere { <.5,1.7,0>, .03 }   
        sphere { <.5,1.7,0>, .03 }
        sphere { <.65,1.55,0>, .03 }
        sphere { <-.65,1.55,0>, .03 }
        sphere { <.7,1.45,0>, .03 }
        sphere { <-.7,1.45,0>, .03 }

        translate <0,0,.1*N>
      }
      #declare N=N+1;
    #end
    texture { CarBodyPaint }                 
  }

  difference {
    box { <-.7,.225,-.5>, <.7,1.75,-.1> }
    plane {
      -y, 0
      rotate 45*z
      translate <-.7,1.5,0>
    }
    plane {
      -y, 0
      rotate -45*z
      translate <.7,1.5,0>
    }
    box { <-.6,.325,-1>, <.6,1.4,1> }                
    texture { CarGold }
  }
  union {
    cylinder { <0,1.74,-.3>, <0,1.95,-.3>, .05 }
    cone { <0,1.74,-.3>, .08 <0,1.78,-.3>, .04 }
    sphere  { <0,1.95,-.3>, .075 }
    texture { CarGold }
  }
  
  union {
    #declare N=-7;
    #while (N<8)
      cylinder {
        <0,.32,-.43>, <0,1.41,-.43>, .05
        scale <.5,1,1>
        translate (N/8)*.6*x
      }      
      #declare N=N+1;  
    #end  
    cylinder { <-.605,.5,-.43>, <.605,.5,-.43>, .025 }
    cylinder { <-.605,1.2,-.43>, <.605,1.2,-.43>, .025 }   
    texture { CarBlackMetal }
  }
}
 
 
#declare Z1 = 1.3;
#declare Z2 = 2;
#declare Y2 = 2.3;
#declare Shroud =
union
{
  triangle { <.7,.225,Z1>, <.7,1.5,Z1>, <1.75,0,Z2> }
  triangle { <.7,1.5,Z1>, <1.75,0,Z2>, <1.75,Y2,Z2> }
  triangle { <.7,1.5,Z1>, <.45,1.75,Z1>, <1.75,Y2,Z2> }
  triangle { <-.45,1.75,Z1>, <.45,1.75,Z1>, <1.75,Y2,Z2> }
  triangle { <-.45,1.75,Z1>, <-1.75,Y2,Z2>, <1.75,Y2,Z2> }
  triangle { <-.7,.225,Z1>, <-.7,1.5,Z1>, <-1.75,0,Z2> }
  triangle { <-.7,1.5,Z1>, <-1.75,0,Z2>, <-1.75,Y2,Z2> }
  triangle { <-.7,1.5,Z1>, <-.45,1.75,Z1>, <-1.75,Y2,Z2> }

  triangle { <.7,0,Z2>, <.7,Y2,Z2>, <-.7,0,Z2> }
  triangle { <-.7,0,Z2>, <-.7,Y2,Z2>, <.7,Y2,Z2> }

  texture { CarBodyPaint } 
}
 
  
#declare WindShield =
union
{
  union {
    cylinder { <1.75,0,2>, <1.75,3.9,2>, .03 }
    cylinder { <-1.75,0,2>, <-1.75,3.9,2>, .03 }
    cylinder { <1.75,2.3,2>, <-1.75,2.3,2>, .03 }
    cylinder { <1.75,3.2,2>, <-1.75,3.2,2>, .03 }
    difference {
      torus { .2, .03
        rotate 90*x
      }
      plane { y, 0 }
      plane { x, 0 }
      translate <1.55,3.9,2>
    }
    difference {
      torus { .2, .03
        rotate 90*x
      }
      plane { y, 0 }
      plane { -x, 0 }
      translate <-1.55,3.9,2>
    }
    cylinder { <-1.55,4.1,2>, <1.55,4.1,2>, .03 }

    texture { CarBlackMetal }
  }
  
  union {
    box { <1.75,2.3,1.99>, <-1.75,3.9,2.01> }
    box { <1.55,2.3,1.99>, <-1.55,4.1,2.01> }
    cylinder { <1.55,3.9,1.99>, <1.55,3.9,2.01>, .2 }
    cylinder { <-1.55,3.9,1.99>, <-1.55,3.9,2.01>, .2 }
    texture { CarGlass }
  }
} 
 
 
#declare LicensePlate =
box
{
  <0,0,0>, <1,1,-.01>
  pigment {
    image_map { sys "modeltpl.bmp" }
  }             
  translate <-.5,-1,0>
  scale <1,.5,1>
  translate <0,.2,-.3>
}


#declare Body =
difference {
  cylinder {
    <0,0,2>, <0,0,6.5>, 1.75
    scale <1,2,1>
    translate <0,2,0>
  }

  box { <-1.75,0,1.9>, <1.75,2,6.6> inverse }
  intersection {
    cylinder {
      <0,0,2.1>, <0,0,6.4>, 1.65
      scale <1,2,1>
      translate <0,2,0>
    }
    plane { -y, 0 translate <0,.1,0> }
  }
  torus {
    1.75, .1
    scale <1,.2,2>
    rotate 90*x
    translate <0,2,2.5>
  }
  torus {
    1.75, .1
    scale <1,.2,2>
    rotate 90*x
    translate <0,2,4>
  }
  torus {
    1.75, .1
    scale <1,.2,2>
    rotate 90*x
    translate <0,2,5.5>
  }

  texture { CarBodyPaint }
}
 
 
#declare Seat1 =
blob {
  threshold .5
  #declare N = -7;
  #while (N<8)
    cylinder { <.2*N,0,0>, <.2*N,1,0>, .3 1 }
    #declare N=N+1;
  #end                     
  sphere { <-1.5,0,0>, .3 1 scale <1,1.5,1> translate .85*y } 
  sphere { <1.5,0,0>, .3 1 scale <1,1.5,1> translate .85*y }
                           
  rotate 15*x
}
  
  
#declare Seat2 =
blob {
  threshold .5
  #declare N = -7;
  #while (N<8)
    cylinder { <.2*N,0,0>, <.2*N,1,0>, .3 1 }
    #declare N=N+1;
  #end
  sphere { <-1.5,0,0>, .3 1 scale <1,2,1> translate .7*y } 
  sphere { <1.5,0,0>, .3 1 scale <1,2,1> translate .7*y }
                           
  rotate 15*x
}

#declare Seats =
union
{
  object { Seat1         
    translate <0,1.2,4>
  }

  object { Seat2         
    translate <0,1.4,6>
  }
              
  texture { CarBlackLeather }
}
    

#declare SteeringWheel =
union
{
  torus {
    .5, .05
    texture { CarWood }
  }
  
  union {
    cylinder { <0,-.3,0>, <0,0,.5>, .03 }
    cylinder { <0,-.3,0>, <.5,0,0>, .03 }
    cylinder { <0,-.3,0>, <0,0,-.5>, .03 }
    cylinder { <0,-.3,0>, <-.5,0,0>, .03 }
    sphere { <0,-.3,0>, .05 }
    cylinder { <0,-.3,0>, <0,-1.5,0>, .05 }
    
    texture { CarWhiteMetal }
  }
  
  rotate 45*x
  translate <.7,2.5,3>
}

 
#declare ModelT =
union
{
  object { UnderCarriage }
  object { SideRail }       
  object { FrontBodyWork }  
  object { Engine }
  object { Shroud }
  object { WindShield }
  object { LicensePlate }
  object { Body }
  object { Seats }
  object { SteeringWheel }
  
  translate y
  scale 1.2
}


/******************** Building designs ********************/

#declare FireEscape =
union
{
  //platform
  union {
    box { <-6,0,0>, <6,.2,-.2> } 
    box { <-6,0,-3.8>, <6,.2,-4> }
    box { <-6,0,0>, <-5.8,.2,-4> }
    box { <5.8,0,0>, <6,.2,-4> }
  
    #declare N=-9;
    #while (N<7)
      box {
        <-.02,0,0>, <.02,.2,-4>
        translate (N/10)*(6)*x
      }
      #declare N=N+1;
    #end
   
    #declare N=1;
    #while (N<11)
      box {
        <-6,0,-.02>, <3.6,.2,.02>
        translate (N/10)*(-4)*z
      }
      #declare N=N+1;
    #end
    
    //platform rail   
    box { <-6,3,-3.8>, <6,3.05,-4> }
    box { <-6,3,0>, <-5.8,3.05,-4> }
    box { <5.8,3,0>, <6,3.05,-4> }
    
    #declare N=-10;
    #while (N<11)
      cylinder {
        <0,0,-3.9>, <0,3,-3.9>, .05
        translate (N/10)*5.9*x
      }
      #declare N=N+1;
    #end 
    
    #declare N=0;
    #while (N<7)
      cylinder {
        <-5.9,0,0>, <-5.9,3,0>, .05
        translate (-3.9+(N/7)*4)*z
      }
      #declare N=N+1;
    #end 
        
    #declare N=0;
    #while (N<7)
      cylinder {
        <5.9,0,0>, <5.9,3,0>, .05
        translate (-3.9+(N/7)*4)*z
      }
      #declare N=N+1;
    #end 
        
    translate 10*y
  }
  
  //stair sides
  difference {
    box { <-6,0,-2>, <6,10.01,-2.02> }
    plane { -y, 0
      rotate 45*z
      translate <-4,.5,0>
    }
    plane { y, 0
      rotate 45*z
      translate <-4,-.5,0>
    }
  } 
 
  difference {
    box { <-6,0,-4>, <6,10.01,-3.98> }
    plane { -y, 0
      rotate 45*z
      translate <-4,.5,0>
    }
    plane { y, 0
      rotate 45*z
      translate <-4,-.5,0>
    }
  }        
  
  //steps
  #declare N=1;
  #while (N<10)
    box {
      <-.45,0,-2>, <.5,.1,-4>
      translate <-4,0,0>+<1,1,0>*N
    }
    #declare N=N+1;
  #end
  
  //stair rails
  #declare N=1;
  #while (N<10)
    cylinder {
      <0,0,-3.95>, <0,2.5,-3.95>, .05
      translate <-4,0,0>+<1,1,0>*N
    }
    #declare N=N+1;
  #end
 
  #declare N=1;
  #while (N<10)
    cylinder {
      <0,0,-2.05>, <0,2.5,-2.05>, .05
      translate <-4,0,0>+<1,1,0>*N
    }
    #declare N=N+1;
  #end
  
  cylinder { <-3.5,3,-3.95>, <5.5,12,-3.95>, .05 } 
  cylinder { <-3.5,3,-2.05>, <5.5,12,-2.05>, .05 } 
 
  texture { BuildingMetal }  
}


#declare B1LowerWindow =
union
{
  union {
    difference {
      box { <-4,0,0>, <4,5,.4> }
    
      box { <-3.7,.3,-1>, <3.7,4.7,1> }     
      box { <-3.8,.2,-1>, <3.8,4.8,.3> }
    }
    box { <-.15,0,0>, <.15,5,.4> }  
    box { <-.2,0,.3>, <.2,5,.4> }   
    box { <1.85,0,0>, <2.15,5,.4> }  
    box { <1.8,0,.3>, <2.2,5,.4> }    
    box { <-1.85,0,0>, <-2.15,5,.4> }  
    box { <-1.8,0,.3>, <-2.2,5,.4> }  
    
    texture { BuildingWood }
  }
  
  box {
    <-4,0,.35>, <4,5,.4>
    texture { BuildingGlass }
  }
}


#declare B1UpperWindow =
union
{
  union {
    difference {
      box { <-4,0,0>, <4,8,.4> }
    
      box { <-3.7,.3,-1>, <3.7,7.7,1> }     
      box { <-3.8,.2,-1>, <3.8,7.8,.35> } 
    }
    box { <-.15,0,0>, <.15,8,.4> }  
    box { <-.2,0,.3>, <.2,8,.4> }
    box { <-4,4.85,0>, <4,5.15,.4> } 
    box { <-4,4.8,.3>, <4,5.2,.4> }
    
    texture { BuildingWood }
  }
  
  box {
    <-4,0,.35>, <4,8,.4>
    texture { BuildingGlass }
  }
} 
            
            
#declare Awning1 =
union
{
  union {
    box { <-10,0,-4>, <10,.4,0> }
    box { <-9.8,0,-3.8>, <9.8,.6,0> }
    
    texture { PoleMetal }    
  }
  
  #declare N=-1;
  #while (N<2)
    cylinder {
      <0,.1,-3.95>, <0,6,.08>, .07
      clipped_by { plane { z, 0 } }
      clipped_by { plane { -y, 0 } }
    
      translate 9.8*x*N
      texture { PoleMetal }
    }
    #declare N=N+1;
  #end

  box {
    <0,0,0>, <1,.1,0>
    pigment {
      image_map { sys "market.bmp" }
    }
    translate <-.5,-.1,0>
    scale <20,10,1>
    translate <0,0,-4>
  }
}


#declare RentSign =
box {
  <0,0,0>, <1,1,0>
  pigment {
    image_map { sys "forrent.bmp" }
  }
  translate <-1,0,0>
  scale 4
}


#declare Shelves1 =
union
{
  union {
    box { <-5,0,-1>, <-4.9,7.1,0> }
    box { <4,0,-1>, <4.9,7.1,0> }
    box { <-5,0,-.1>, <5,7.1,0> }
    box { <-5,0,-1>, <5,.1,0> }
    box { <-5,1,-1>, <5,1.1,0> }
    box { <-5,2,-1>, <5,2.1,0> }
    box { <-5,3,-1>, <5,3.1,0> }
    box { <-5,4,-1>, <5,4.1,0> }
    box { <-5,5,-1>, <5,5.1,0> }
    box { <-5,6,-1>, <5,6.1,0> } 
    box { <-5,7,-1>, <5,7.1,0> }
    
    texture { BuildingWood }
  }
  
  #declare N=0;
  #while (N<30)
    box {
      <-.3,0,-.9>, <.3,.8,-.1>
      scale (rand(R1)/2+.5)
      translate <(rand(R1)-.5)*8,.1+int(rand(R1)*7),0>
      pigment { color rgb (.5*<1,1,1>+.5*<rand(R1),rand(R1),rand(R1)>)*rand(R1) }
    }
    cylinder {
      <0,0,-.5>, <0,.8,-.5>, .4
      scale (rand(R1)/2+.5)
      translate <(rand(R1)-.5)*8,.1+int(rand(R1)*7),0>
      pigment { color rgb (.5*<1,1,1>+.5*<rand(R1),rand(R1),rand(R1)>)*rand(R1) }
    }
    #declare N=N+1;
  #end
  
}


#declare Building1 =
union
{
  difference {
    box { <-100,0,0>, <0,30,52> }
   
    //entry
    box { <-20,-1,-1>, <-2,9,50> }
    box { <-40,-1,2>, <1,9,20> }
          
    //ground level windows
    box { <-4,0,-10>, <4,5,10> translate <-26,4,0> }
    box { <-4,0,-10>, <4,5,10> translate <-36,4,0> } 
    box { <-4,0,-10>, <4,5,10> translate <-46,4,0> } 
    
    box { <1,0,-4>, <-10,5,4> translate <0,4,26> } 
    box { <1,0,-4>, <-10,5,4> translate <0,4,36> } 
    box { <1,0,-4>, <-10,5,4> translate <0,4,46> }
    
    //upper story windows
    box { <-4,0,-10>, <4,8,10> translate <-6,11,0> }
    box { <-4,0,-10>, <4,8,10> translate <-16,11,0> }
    box { <-4,0,-10>, <4,8,10> translate <-26,11,0> } 
    box { <-4,0,-10>, <4,8,10> translate <-36,11,0> }
    box { <-4,0,-10>, <4,8,10> translate <-46,11,0> }
    
    box { <1,0,-4>, <-10,8,4> translate <0,11,6> } 
    box { <1,0,-4>, <-10,8,4> translate <0,11,16> }  
    box { <1,0,-4>, <-10,8,4> translate <0,11,26> } 
    box { <1,0,-4>, <-10,8,4> translate <0,11,36> } 
    box { <1,0,-4>, <-10,8,4> translate <0,11,46> } 
 
    box { <-4,0,-10>, <4,8,10> translate <-6,21,0> }
    box { <-4,0,-10>, <4,8,10> translate <-16,21,0> }
    box { <-4,0,-10>, <4,8,10> translate <-26,21,0> } 
    box { <-4,0,-10>, <4,8,10> translate <-36,21,0> }
    box { <-4,0,-10>, <4,8,10> translate <-46,21,0> }
    
    box { <1,0,-4>, <-10,8,4> translate <0,21,6> } 
    box { <1,0,-4>, <-10,8,4> translate <0,21,16> }  
    box { <1,0,-4>, <-10,8,4> translate <0,21,26> } 
    box { <1,0,-4>, <-10,8,4> translate <0,21,36> } 
    box { <1,0,-4>, <-10,8,4> translate <0,21,46> }
 
    texture { BuildingBrick }
  }
  
  //Put in the windows, into the holes above 
  object { B1LowerWindow translate <-26,4,0> }
  object { B1LowerWindow translate <-36,4,0> } 
  object { B1LowerWindow translate <-46,4,0> } 
    
  object { B1LowerWindow rotate -90*y translate <0,4,26> } 
  object { B1LowerWindow rotate -90*y translate <0,4,36> } 
  object { B1LowerWindow rotate -90*y translate <0,4,46> } 
    
  object { B1UpperWindow translate <-6,11,0> }
  object { B1UpperWindow translate <-16,11,0> }
  object { B1UpperWindow translate <-26,11,0> } 
  object { B1UpperWindow translate <-36,11,0> }
  object { B1UpperWindow translate <-46,11,0> }
  
  object { B1UpperWindow rotate -90*y translate <0,11,6> } 
  object { B1UpperWindow rotate -90*y translate <0,11,16> }  
  object { B1UpperWindow rotate -90*y translate <0,11,26> } 
  object { B1UpperWindow rotate -90*y translate <0,11,36> } 
  object { B1UpperWindow rotate -90*y translate <0,11,46> } 
 
  object { B1UpperWindow translate <-6,21,0> }
  object { B1UpperWindow translate <-16,21,0> }
  object { B1UpperWindow translate <-26,21,0> } 
  object { B1UpperWindow translate <-36,21,0> }
  object { B1UpperWindow translate <-46,21,0> }
    
  object { B1UpperWindow rotate -90*y translate <0,21,6> } 
  object { B1UpperWindow rotate -90*y translate <0,21,16> }  
  object { B1UpperWindow rotate -90*y translate <0,21,26> } 
  object { B1UpperWindow rotate -90*y translate <0,21,36> } 
  object { B1UpperWindow rotate -90*y translate <0,21,46> } 

  union {
    object { FireEscape }
    object { FireEscape translate 10*y }
    object { FireEscape translate 20*y }
    
    rotate -90*y
    translate <0,0,16>
  }
  
  object {
    Awning1 
    translate <-11,9,0>
  }
  
  object {
    RentSign
    translate <-21.8,11.4,.5>
  }   
  
  object {
    Shelves1
    rotate -90*y
    translate <-20,0,7>
  }
  object {
    Shelves1
    translate <-7,0,20>
  }
}


#declare Building2 =
box
{
  <18,0,0>, <50,30,50>
  texture { BuildingStone }
}

/******************** Street design ********************/


#declare Street =
plane {
  y, 0
  texture { StreetStone }
}            


#declare Sidewalk =
union
{  
  union {
    box { <-100,0,-5>, <5,.3,100> }
    cylinder { <-100,0,-5>, <5,0,-5>, .3 }
    cylinder { <5,0,-5>, <5,0,100>, .3 }
    sphere { <5,0,-5>, .3 }
  }
  union {
    box { <15,0,-5>, <100,.3,100> }
    cylinder { <100,0,-5>, <15,0,-5>, .3 }
    cylinder { <15,0,-5>, <15,0,100>, .3 }
    sphere { <15,0,-5>, .3 }
  }                          
  texture { StreetSidewalk }
}


#declare LampPost =
union
{
  union {
    cone { <0,0,0>, .3, <0,10,0>, .2 }
    cone { <0,10,0>, .2, <0,10.5,0>, .15 }
    difference {
      //cylinder { <0,0,0>, <0,2,0>, .5 }
      cone { <0,0,0>, .76, <0,2,0>, .28 }
      #declare N=0;
      #while (N<13)
        cylinder { <0,-1,0>, <0,3,0>, .2
          translate .7*x
          rotate (N/12)*360*y
        }
        #declare N=N+1;
      #end
    }
    
    //Top globe
    difference {
      cylinder { <0,0,0>, <0,.5,0>, .3 }
      torus { .3, .15
        scale <1,1.5,1>
      }
      translate <0,12.6,0>
    }
    cylinder { <0,10,0>, <0,12.6,0>, .15 }

    //Second globes
    difference {
      cylinder { <0,0,0>, <0,.5,0>, .3 }
      torus { .3, .15
        scale <1,1.5,1>
      }
      translate <-.9,11.5,0>
    }
    cylinder { <-.9,11.5,0>, <-.9,11.2,0>, .15 }
    sphere { <-.9,11.2,0>, .15 }
    difference {
      cylinder { <0,0,0>, <0,.5,0>, .3 }
      torus { .3, .15
        scale <1,1.5,1>
      }
      translate <.9,11.5,0>
    }                     
    cylinder { <.9,11.5,0>, <.9,11.2,0>, .15 }
    sphere { <.9,11.2,0>, .15 }
    cylinder { <-.9,11.2,0>, <.9,11.2,0> , .15 }
    
    //Third globes 
    difference { 
      cylinder { <0,0,0>, <0,.5,0>, .3 }
      torus { .3, .15
        scale <1,1.5,1>
      }
      rotate 90*z
      translate <-1.1,10.7,0>
    }  
    difference { 
      cylinder { <0,0,0>, <0,.5,0>, .3 }
      torus { .3, .15
        scale <1,1.5,1>
      }
      rotate -90*z
      translate <1.1,10.7,0>
    }
    cylinder { <-1.1,10.7,0>, <1.1,10.7,0>, .15 }
    
    texture { PoleMetal }
  }
  
  //Globes
  union {
    sphere { <0,13.4,0>, .6 }
    sphere { <-.9,12.3,0>, .55 }
    sphere { <.9,12.3,0>, .55 }
    sphere { <-1.8,10.7,0>, .5 } 
    sphere { <1.8,10.7,0>, .5 }
    
    texture { PoleGlass }
  }
}


#declare MainStreet =
union
{
  object { Street }
  object { Sidewalk }  
  object { Building1 translate .29*y }
  object { Building2 }
  object { LampPost translate <-30,.29,-4> }
  object { LampPost
    rotate -45*y
    translate <4,.29,-4>
  }                                      
  object { LampPost
    rotate 45*y
    translate <16,.29,-4>
  }
  
  object { ModelT
    rotate -90*y
    translate <-3,0,-10.5>
  }

  object { ModelT
    rotate -90*y
    translate <27,0,-10.5>
  }

  object { ModelT
    rotate 0*y
    translate <11,0,10>
  }
    
  box {
    <-100,0,170>, <100,100,180>  
    texture { BackWallStone }
  }
}

         
/******************** The scene for street viewing ********************/

background { color rgb 1 }                  
      
#declare CameraLoc = <20,8,-30>*1.5;
                  
camera
{
  location CameraLoc
  look_at <0,5,0>
  angle 45
}

/*
light_source
{
  CameraLoc
  rgb 2
} 
*/
   
light_source
{
  0*x
  color rgb 10.0
  area_light
  <40, 0, 0> <0, 0, 40>
  3, 3
  adaptive 1
  jitter
  translate <-20,50,-20>
}    
     
object { MainStreet }

sky_sphere {
  pigment { P_Cloud3 scale .2 }
}
                 
global_settings
{
  assumed_gamma 1 
}
