// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1a
//
// Fichier       :Colones.inc by  Martial Rameaux
// Date          :
//
// Description:
//
//                              
//
// mile ;) -> M.R@lemel.fr
//==========================================  

//=========== Texture de colonne===============================
#ifndef (Colone_Texture)
#declare Colone_Texture= texture { pigment {
                        granite  color_map {
                                [0.0  color rgb<0.8509,0.7333,0.6588> ]
                                [0.5  color rgb<0.9803,0.7764,0.6784> ]
                                [1.0  color rgb<0.9490,0.9372,0.9333> ]
                        }
            turbulence 0.5
            lambda 0.6
            omega 1.2
            octaves 0.2
            
          } 
        finish {   metallic 1 specular 0.1 roughness 1/20  brilliance 2 reflection <0.8509,0.7333,0.6588>/100 }
}
//texture {pigment {color rgbf  <0.6,0.5,0.5,0.8>}
 texture { pigment {
                        granite  color_map {
                                [0.0  color rgbf<0.8509,0.7333,0.6588,0.8> ]
                                [0.5  color rgbf<0.9803,0.7764,0.6784,0.3> ]
                                [1.0  color rgbf<0.9490,0.9372,0.9333,0.8> ]
                        }
            turbulence 0.6
            lambda 0.6
            omega 1.2
            octaves 0.2
            
          }         
finish {   phong 1 phong_size 100 }

}
#end

//==========================================

#ifndef (Flute_radius)
#declare Flute_radius=0.25;
#end
#ifndef (Nombre_de_Flute)
#declare Nombre_de_Flute=20;
#end
#if (Nombre_de_Flute=0)
#declare Nombre_de_Flute=1;
#end
#ifndef (Colone_radius)
#declare Colone_radius=2.5;
#end
#ifndef (Hauteur_Colone)
#declare Hauteur_Colone=20;//>3
#end

#declare Bord_Pied=Colone_radius*1.3;

//==========================================
#declare Flute= 
union {
        cylinder { <0,2,0>,<0,Hauteur_Colone-2,0>Flute_radius}
        sphere {<0,Hauteur_Colone-2,0>Flute_radius}
        sphere {<0,2,0>Flute_radius}
}

#declare Colonne=
        difference {
                union {
                cylinder { <0,1.1,0>,<0,Hauteur_Colone-1.1,0>,Colone_radius }        
                cone {<0,1.0,0>Colone_radius+0.5<0,1.2,0>Colone_radius}
                box{<-Bord_Pied,0,-Bord_Pied>,<Bord_Pied,1,Bord_Pied>}
                box{<-Bord_Pied,Hauteur_Colone-1,-Bord_Pied>,<Bord_Pied,Hauteur_Colone,Bord_Pied>}
                cone {<0,Hauteur_Colone-1.0,0>Colone_radius+0.5<0,Hauteur_Colone-1.2,0>Colone_radius}
        }
        #declare Compte=0;
        #while (Compte<=Nombre_de_Flute)
        object { Flute
        translate x*Colone_radius
        rotate y*(Compte*(360/Nombre_de_Flute))
        }
        #declare Compte=Compte+1;
        #end
        texture {Colone_Texture }
        
        }      
        
//================Fin du Fichier ==================
        
        