// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1a
//
// Fichier       : Lion.inc by  Martial Rameaux
// Date          : Janvier 99
//
// Description:  Statue de Lion en Marbre 
//
//                              
//
// mile ;) -> M.R@lemel.fr
//==========================================  

    

//==================================
#declare T_Or = texture {
  pigment {
    color rgb <1,0.57,0.1> 
  }
  finish {
    brilliance 2 diffuse 0.5 ambient 0.2 reflection <0.8,0.6,0.5> metallic 1 specular 0.2 roughness 1/20 } 
}       
//==================================       
#declare  RF=0.3;   
#declare T_Lion=
 texture {pigment { color rgb<0.8078,0.4039,0.1333> } finish { ambient 0.5 diffuse 0.5 brilliance 3 metallic  specular 1 roughness 0.0001 reflection RF  }}
                         texture {pigment {color rgbf <0.8,0.3,0.3,0.7>} finish {ambient 0.3 diffuse 0.3 brilliance 1  reflection RF phong 1 phong_size 40 metallic }  }
                         texture {pigment { color rgbf <0.5,0.2,0.2,0.8> } finish {ambient 0.3 diffuse 0.3 phong 1 phong_size 40  metallic }}  
//============== LE LION ================  
//======= criniere ============================
#declare Criniere= merge {
         // 1er couche
        #declare Nbr_Crete=30;
        #declare Compte=0;
        #while (Compte<=Nbr_Crete)
        union {
                cone   {<0,0,0.1>0.2<0,1.1,0.7>0.05}
                sphere {<0,1.1,0.7>,0.1}
                         
                translate y*0.9 rotate z*Compte*(360/Nbr_Crete)  
        #declare Compte=Compte+1;
        
        }
        #end
  
        // 2eme couche
         #declare Nbr_Crete=20;
        #declare Compte=0;
        #while (Compte<=Nbr_Crete)
        union {
                cone   {<0,0,0.1>0.2<0,0.5,-0.1>0.05}
                sphere {<0,0.5,-0.1>,0.1}   // ici texture Or
                     
                translate y*0.8 rotate z*Compte*(360/Nbr_Crete)  
                #declare Compte=Compte+1;
        
        }
        #end
}

//============ Pattes ==============================
#declare Pavd=
union { 
cylinder { <0,0,0>,<0,3,0>,0.5  }
sphere   { <0,3,0>,0.5 }
       
cylinder { <0,0,0>,<0,0,-0.5>,0.3 } 
sphere   { <0,0,-0.5>0.3 }
cylinder { <0.3,0,0>,<0.3,0,-0.5>,0.2 }
sphere   { <0.3,0,-0.5>,0.2 }
cylinder { <-0.3,0,0>,<-0.3,0,-0.5>,0.2 } 
sphere   { <-0.3,0,-0.5>,0.2 }
scale <1,0.7,1>
}
#declare Pavg=object { Pavd }
//============== corps ============================
#declare Corps=merge { 
                sphere   {<0,1,0>0.8 scale <1.3,0.8,1.8> }
                cylinder {<0,0.8,0><0,3,0>,0.8 scale <1.3,1,1.8> }
                sphere   {<0,3.8,0>0.8 scale <1.3,0.8,1.8> }
                rotate x*-10
                translate z*0.8 
                 scale <1,1,0.8>
                 }
                 //---- tte --------
 #declare Tete = merge {              
           difference {
                merge {
                sphere { <0,4.3,0.5>,1.3 scale <0.8,1,1> }        
                //cylinder {<-0.4,4,-.0>,<0.4,4,-.00>,1 scale <1,1,1.0> }
                box { <-0.3,2.8,2>,<0.3,3.8,3> rotate x*-45}// nez
                     // joues
        // cylinder { <-0.4,0,0>,< 0.5,0,0>0.8  rotate z* 20  translate <-0.2,4.1,-.1>  }
        // cylinder { < 0.4,0,0>,<-0.5,0,0>0.8  rotate z*-20  translate < 0.2,4.1,-.1>}
                }
                merge {
                cylinder {<-0.45,3.8,-0.6>,<0.45,3.8,-0.6>,0.35 scale <1.2,1,1.2>} 
                //sphere{ <0,3.9,-0>,0.6 scale <1,0.9,1>}
                // yeux 
         cylinder {<-0.5,4.50,-5><-0.5,4.50,1.5>0.1 }
         cylinder {< 0.5,4.50,-5>< 0.5,4.50,1.5>0.1}
                }
               
         translate z*-0.5
           }
        
           //--- criniere --
            object {Criniere translate <0,4.5,-0.3> }
                      
           //---- langue-----
             merge {
           cone { <0,0,1.5>0.3<0,0.1,1>0.2}
           sphere {<0,0.1,1>0.2}
           cone { <0,0.1,1.>0.2<0,-0.2,0.2>0.1}
           sphere {<0,-0.2,0.2>0.1}
           cone { <0,-0.2,0.2>0.1<0,0.0,0>0.05}
           sphere { <0,0.0,0>0.05}
                     scale <1.2,0.3,0.4>
                     rotate x*-15
          translate <0,3.7,-1.5>

//pigment { rgb <1,0,0>}
             }
           //-----Queue----  
      
}
          
           
//==========================================
#ifndef (Tourne_Tete)
#declare Tourne_Tete=45;
#end

#declare Lion_droit=
merge {
        object {Pavd  translate <-0.5,0,-0.5>}
        object {Pavg  translate < 0.5,0,-0.5>}
        object {Pavd rotate y* 20 translate <-0.8,0,1> scale 1.2}
        object {Pavg rotate y*-20 translate < 0.8,0,1> scale 1.2 }
        object {Corps }
        object {Tete rotate y*-Tourne_Tete}
     texture { T_marbreblanc}
     scale 1.5
     
}
        #declare Lion_gauche=
merge {
        object {Pavd  translate <-0.5,0,-0.5>}
        object {Pavg  translate < 0.5,0,-0.5>}
        object {Pavd rotate y* 20 translate <-0.8,0,1> scale 1.2}
        object {Pavg rotate y*-20 translate < 0.8,0,1> scale 1.2 }
        object {Corps }
        object {Tete rotate y* Tourne_Tete}
     texture { T_marbreblanc}
     scale 1.5
     
}

//=====Fin du Fichier ================ 
