 framepic.incNYframepic.inc   :Hh asl     TEXTMPS           
  ulNY                        // Persistence Of Vision INCLUDE file
// File:        framepic.inc
// Vers:        3.1 Mac PPC
// Desc:        A framed picture.
// Auth:        Peter Murray

#debug "\r  framepic.inc - Macro to create a framed picture.\r"

// Measurements might already be defined.
#ifndef(in)
  #declare in = 1;
#end

/* Passed parameter values:
   pWhere:   Location of final picture
   pRotn:    Its rotation about its own axis
   pFrame:   Frame type (0 plain)
   pFrameSz: width,height above 0,thickness
   pPicSz:   width,height above 0,thickness
   pPicture: PNG picture to use (for no picture).
   pTitle:   Title to use on the picture ("" for no title).
*/
#macro FramePic(pWhere,pRotn,pFrame,pFrameSz,pPicSz,pPicture,pTitle)
  object{
    union{
      difference{
        box{
          <-pFrameSz.x/2,0,0>,<pFrameSz.x/2,pFrameSz.y,-pFrameSz.z>
        }//box
        #local OffHt = (pFrameSz.y-pPicSz.y)/2;
        box{
          <-pPicSz.x/2,OffHt,-pPicSz.z>,<pPicSz.x/2,OffHt+pPicSz.y,-pFrameSz.z-1>
          texture{
            pigment{colour rgb <.9, .9, .8>}
            normal{
              bumps 1 turbulence 0.75 octaves 5 omega 0.6 lambda 1.5
              scale <100 10 100>
            }//normal
          }//texture
  		  #local FrameThck=pFrameSz.y-pPicSz.y;
          #if (strlen(pPicture)>0)
            texture{
              pigment{
                image_map{
                  png pPicture interpolate 2
                }//image_map
                scale pPicSz
                translate <-pPicSz.x/2,FrameThck/2,0>
              }//pigment
			  finish{
			    reflection .2
			  }
            }//texture
          #end//#if picture
        }//box
        texture{
          Gold_Metal
          normal{
            bumps -0.5
            scale <1, 0.001, 0.001>
          }//normal
        }//texture
      }//difference
      // Title
      #if (strlen(pTitle)>0)
        #local NameLn=strlen(pTitle);
        #local NameWd=NameLn*.4*FrameThck;
        box{
          <-NameWd/2,-.1*FrameThck,-pFrameSz.z>,<NameWd/2,1.1*FrameThck,-pFrameSz.z-.15*in>
          texture{
            Gold_Metal
            normal{
              bumps -0.05
              scale <1, 0.01, 0.01>
            }//normal
          }//texture
        }//box
		text{
		  ttf "TIMES.TTF" pTitle .1*in,0
		  texture{pigment{colour rgb<.1,.1,0>}}
		  scale (pFrameSz.z/1.2)
		  translate <-NameWd/2.6,.21*FrameThck,-.2*in-pFrameSz.z>
		}//text
      #end//#if title
    }//union
	rotate x*-5
    rotate pRotn
    translate pWhere
  }//Object FramePic
  #declare SamplerBBox=array[2]
    {<-pFrameSz.x/2,0,0>,<pFrameSz.x/2,pFrameSz.y,-pFrameSz.z>}
#end//#macro FramePic

/*
#declare SamplerName=object{
  FramePic(<0,0,0>,<0,0,0>,0,<8.5*in,6.5*in,.5*in>,<8*in,6*in,.1*in>,"","")
}
*/                                                       e  Icon
           @         framepic.inc-1ocuments.htmletio TEXTMPS                       l  
  u  
   Include    C  [
fl     '   h @         [                       poser rib read.pl   TEXTMPS   h         <    (         x       x ttxt8BIM   	                           >                               ?  f$` 9  FhR     H 	Monaco 
 !             
  ""NY  	  	  	     ""  	                     e (S    R MPSR  FPRF   *          X,          POV-Ray File Prefs           