 pdmirtch.povN5pdmirtch.pov   :Hl     TEXTPOV3         !h  N5                      .H  // POV-Ray file
// Standard pre-defined colors
#include "colors.inc"
#include "textures.inc"

/* 320x240:
Time For Parse:    0 hours  0 minutes  12.0 seconds (12 seconds)
Time For Trace:    0 hours  4 minutes  19.0 seconds (259 seconds)
    Total Time:    0 hours  4 minutes  31.0 seconds (271 seconds)
 800x600:
Time For Parse:    0 hours  0 minutes  33.0 seconds (33 seconds)
Time For Trace:    1 hours 22 minutes  32.0 seconds (4952 seconds)
    Total Time:    1 hours 23 minutes   5.0 seconds (4985 seconds)
*/

// Units
#declare in = 1;
#declare ft = 12;
#declare yd = 36;

background{colour rgb<.2,.2,.25>*.75}

#declare Detailed=1;

#declare VPdoor    =<-11.0*in,3*in,-12.5*in>;
#declare LAdoor    =<5*in,3*in,0>;
#declare VPimage   =<-5*in,3*in,-1.5*ft>;
#declare LAimage   =<5*in,3*in,0>;
#declare VPoverview=<0*in,25*in,-2.8*ft>;
#declare LAoverview=<4*in,3*in,-6*in>;
#declare VPpainting=<8.5*in,8.125*in,-3*in>;
#declare LApainting=<13*in,8.125*in,-3*in>;
#declare VPpicture =<-5*in,4.125*in,-4.5*in>;
#declare LApicture =<-5*in,4.125*in,0>;

//#declare ViewPoint=VPdoor;#declare LookAt=LAdoor;
#declare ViewPoint=VPimage;#declare LookAt=LAimage;
//#declare ViewPoint=VPoverview;#declare LookAt=LAoverview;
//#declare ViewPoint=VPpainting;#declare LookAt=LApainting;
//#declare ViewPoint=VPpicture;#declare LookAt=LApicture;

// Files define SamplerName and SamplerBBox[2]
#include "tedbearm.inc"
#include "framepic.inc"

camera{
  perspective
  location    ViewPoint // position of camera <X Y Z>
  look_at     LookAt // point center of view at this point <X Y Z>
}

/*
light_source{// Light on camera
  ViewPoint
  colour rgb <1,1,1>
}*/

// textures

#declare WallPaint=
texture{
  pigment{
    colour rgb <.95,.95,.8>
  }
  normal{bumps .1 scale .125}
}

#declare CeilingPaint=
texture{
  pigment{
    colour rgb <.95,.95,.8>
  }
  normal{bumps .1 scale .33}
  finish{ambient .1 brilliance .2 diffuse .4
    specular .0 roughness .5 reflection .0}
}

#declare Carpet=
texture{
  pigment{
    hexagon
    colour rgb<.5,.5,.9>
    colour rgb<.7,.8,.6>
    colour rgb<.5,.5,.9>
    scale .1
  }
  finish{ambient .3 brilliance .2 diffuse .4
    specular .0 roughness .5 reflection .0}
  normal{bumps .25 scale .4}
}

#declare Paper=
texture{
  pigment{
    colour rgb <.95,.95,.9>*1.2
  }
  finish{
    brilliance .3
  }
}
texture{
  pigment{
    image_map{
      png "pdmirtch.png" once interpolate 2
    }
    rotate z*-90
    scale 1.25
    translate <-1.02*in,-.3*in,0>
  }
  finish{
    reflection .1 brilliance .4
  }
}

#declare dBear2Tx=
texture{
  normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
  }
  pigment{
	granite
	colour_map{
	  [0.0 colour rgb <.65,.65,.35>]
	  [0.3 colour rgb <.75,.75,.45>]
	  [0.6 colour rgb <.75,.80,.45>]
	  [1.0 colour rgb <.75,.75,.45>]
	}
	scale .5
  }
}


// more objects

#declare LightFitting=
union{
  cylinder{
    <0,.2*in,0>,<0,.5*in,0>,.4*in
    texture{
      pigment{colour rgb <.6,.6,.6>}
    }
  }
  cylinder{
    <0,.1*in,0>,<0,2*in,0>,.1*in
    texture{
      pigment{colour rgb <.6,.6,.6>}
    }
  }
  cone{
    <0,1.9*in,0>,.3*in,<0,2*in,0>,.4*in
    texture{
      pigment{colour rgb <.6,.6,.6>}
    }
  }
  sphere{
    <0,0*in,0>,.75*in scale <1,.5,1>
    texture{
      pigment{colour rgb <.8,.8,.8>}
      finish{ambient 1.5}
    }
  }
}

#declare CeilingLight=
light_source{
  <0,9*in,0> colour rgb <.8,.8,.75> looks_like{LightFitting}
  fade_distance 6*in fade_power 2
}

// room

box{// Wall with first eight paintings
  <-8.1*in,0,.1*in>,<13.1*in,11*in,1.1*in>
  texture{WallPaint}
}

box{// Wall with next four
  <13.1*in,0,1.1*in>,<14.1*in,11*in,-22.1*in>
  texture{WallPaint}
}

box{// Wall opposite 8
  <-8.1*in,0,-21.1*in>,<13.1*in,11*in,-22.1*in>
  texture{WallPaint}
}

// Wall opposite 4
difference{
  box{
    <-8.1*in,0,1.1*in>,<-9.1*in,11*in,-22.1*in>
  }
  box{
    <-9.2*in,-.1*in,-8.5*in>,<-8*in,8*in,-12.5*in>
  }
  cylinder{
    <-9.2*in,8*in,-10.5*in>,<-8*in,8*in,-10.5*in>,2*in
  }
  texture{WallPaint}
}

box{// Wall of outside corridor
  <-18.1*in,0,1.1*in>,<-17.1*in,11*in,-22.1*in>
  texture{WallPaint}
}

// light in room
object{
  CeilingLight
  translate <-2*in,0,-5*in>
}

object{
  CeilingLight
  translate <7*in,0,-5*in>
}

object{
  CeilingLight
  translate <-2*in,0,-16*in>
}

object{
  CeilingLight
  translate <7*in,0,-16*in>
}

// light in corridor
object{
  CeilingLight
  translate <-13.1*in,0,-5*in>
}

object{
  CeilingLight
  translate <-13.1*in,0,-16*in>
}

#if (ViewPoint.y < 10*in)
  box{// Ceiling
    <-18.1*in,11*in,1.1*in>,<14.1*in,12*in,-22.1*in>
    texture{CeilingPaint}
  }
#end

box{// Floor
  <-18.1*in,0,1.1*in>,< 14.1*in,-1*in,-22.1*in>
  texture{Carpet}
}

box{// Column left of 8-wall
  <-.5*in,0,-.5*in>,<.5*in,11*in,.5*in>
  translate <-8.1*in,0,.1*in>
  texture{WallPaint}
}

box{// Column between 8- and 4-walls
  <-.5*in,0,-.5*in>,<.5*in,11*in,.5*in>
  translate <13.1*in,0,.1*in>
  texture{WallPaint}
}

box{// Column right of 4-wall
  <-.5*in,0,-.5*in>,<.5*in,11*in,.5*in>
  translate <-8.1*in,0,-21.1*in>
  texture{WallPaint}
}

box{// Column near camera
  <-.5*in,0,-.5*in>,<.5*in,11*in,.5*in>
  translate <13.1*in,0,-21.1*in>
  texture{WallPaint}
}

// visitors

object{
  TeddyBear(
    <0,-.25*in,-5*in>,<0,70,0>,
    <0,30,0>,<-90,40,0>,<-180,0,0>,<10,30,0>,<-10,-30,0>,
	array[5]{dFurTx,dContrastTx,dEyeTx,dMouthTx,dNoseTx}
  )
}

object{
  TeddyBear(
    <7.5*in,-.3*in,-7.5*in>,<0,-50,0>,
    <0,-10,0>,<-10,0,0>,<-60,0,0>,<-15,30,0>,<45,-0,0>,
	array[5]{dBear2Tx,dContrastTx,dEyeTx,dMouthTx,dNoseTx}
  )
}

// paintings

object{
  FramePic(
    <-5*in,2.5*in,0>,<0,0,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmschol.png","Cutest scholar"
  )
}

object{
  FramePic(
    <-5*in,6.5*in,0>,<0,0,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmnewtn.png","Newton, physicist and mathematician"
  )
}

object{
  FramePic(
    <0,2.5*in,0>,<0,0,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmmagic.png","Ouch!"
  )
}

object{
  FramePic(
    <0,6.5*in,0>,<0,0,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmbooks.png","Wanna book..."
  )
}

object{
  FramePic(
    <5*in,2.5*in,0>,<0,0,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmsnset.png","Time to go home"
  )
}

object{
  FramePic(
    <5*in,6.5*in,0>,<0,0,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmfctry.png","After years in the deserted factory"
  )
}

object{
  FramePic(
    <10*in,2.5*in,0>,<0,0,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmddark.png","It's d-dark..."
  )
}

object{
  FramePic(
    <10*in,6.5*in,0>,<0,0,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmnatur.png","Musings"
  )
}

object{
  FramePic(
    <13*in,2.5*in,-3*in>,<0,90,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmelem.png","Sorting the new coins"
  )
}

object{
  FramePic(
    <13*in,6.5*in,-3*in>,<0,90,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmawash.png","Safely afloat in the basket"
  )
}

object{
  FramePic(
    <13*in,2.5*in,-8*in>,<0,90,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmcstl.png","Attack on the mountain castle"
  )
}

object{
  FramePic(
    <13*in,6.5*in,-8*in>,<0,90,0>,0,<4.25*in,3.25*in,.25*in>,<4*in,3*in,.1*in>,
    "pdmirtch.png","This one's nasty!"
  )
}

#declare TxtOffset=<0,-.1,-.01>;
union{
  union{
    box{
      <-1.5*in,-2*in,0>,<1.5*in,0,0>
    }
	text{
	  ttf "TIMES.TTF" "pdmirtch.jpg" .1*in,0
	  texture{pigment{colour rgb<.1,.1,0>}}
	  rotate z*-90
	  scale .35
	  translate <1.2,0,0>+TxtOffset
	}
	text{
	  ttf "TIMES.TTF" "Peter Murray" .1*in,0
	  texture{pigment{colour rgb<.1,.1,0>}}
	  rotate z*-90
	  scale .3
	  translate <0.9,-.12,0>+TxtOffset
	}
	text{
	  ttf "TIMES.TTF" " 29Apr1999" .1*in,0
	  texture{pigment{colour rgb<.1,.1,0>}}
	  rotate z*-90
	  scale .3
	  translate <0.6,-.05,0>+TxtOffset
	}
	text{
	  ttf "TIMES.TTF" "History" .1*in,0
	  texture{pigment{colour rgb<.1,.1,0>}}
	  rotate z*-90
	  scale .3
	  translate <0.3,-.45,0>+TxtOffset
	}
	text{
	  ttf "TIMES.TTF" "Internet  Raytracing" .1*in,0
	  texture{pigment{colour rgb<.1,.1,0>}}
	  rotate z*-90
	  scale .2
	  translate <-1.2,0-.1,0>+TxtOffset
	}
	text{
	  ttf "TIMES.TTF" "Competition" .1*in,0
	  texture{pigment{colour rgb<.1,.1,0>}}
	  rotate z*-90
	  scale .2
	  translate <-1.4,-.4,0>+TxtOffset
	}
    rotate x*20
  }
  box{
    <-1.5*in,-2*in,0>,<1.5*in,0,0>
    rotate x*-20
  }
  texture{
    Paper
  }
  scale .5
  rotate y*5
  translate <1*in,.01+(1*in*cos(radians(20))),-13*in>
}
                             6  6   e u i l t - i n )        s0pdmirtch.pov(EX)porary FileetioiTEXTPOV3                      !h  r                                                                                                                          X  )ttxt8BIMGKONGKONTVOD     	                         >                               ?  rpza                  <   I      d     F     H 	Monaco hec1t:
  Floor basic t   P   P  N5             P   P                     6  6   e (M    R MPSR  FPRF   *         6          POV-Ray File Prefs                                                                                                     