// Persistence of Vision Ray Tracer Scene Description File
// File: TestStnd.inc
// Vers: 3.1
// Desc: Redstone rocket test stand scene
// Date: 4/17/99
// Auth: Steve Sloan II

//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//  Date : 04/17/1999    (17.04.1999)

// Modified by Steve Sloan: added smoky rocket
// exhaust, modified to be a single include file

// Parameters used to create a smoky media

#declare EmissValue = 1.5;
#declare Pulverization = 10;
#declare SColor1 = <0, 0, 0>;
#declare SColor2 = <1, 1, 1>;
#declare TurbValue = 1;
#declare Size = 1;

//
// ********  TEXTURES  *******
//

#declare WhiteTexture = texture { pigment { color rgb <1.0, 1.0, 1.0> } }

#declare BlackTexture = texture { pigment { color rgb <0.0, 0.0, 0.0> } }

#declare Stripe1Texture = 
texture {   
    pigment {
        gradient z
        color_map {
            [ 0.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.95    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.95    rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
            [ 1.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
        }
    }
}

#declare Stripe2Texture = 
texture {   
    pigment {
        image_map {
            gif   "Rocket.gif"
            map_type 2
            once
        }
        scale  <-1,1,1>
        rotate 90*x
    }
}

#declare RocketTexture = 
texture { pigment { color rgb <0.0, 0.0, 0.0> } }
texture {   
    pigment {
         gradient z
         pigment_map {
            [0.0   
               image_map {
                  gif   "redstone.gif"
                  once
                  transmit 0, 1.0
               }
               scale  <-2.0, 49.05, 1.0>
               translate    <1.0, 5.45, 0.0>
            ]
            [0.5   
               image_map
               {
                  gif   "redstone.gif"
                  once
                  transmit 0, 1.0
               }               scale  <-2.0, 49.05, 1.0>
               translate    <1.0, 5.45, 0.0>
            ]
            [0.5   
               image_map
               {
                  gif   "redstone.gif"
                  once   
                  transmit 0, 1.0
               }               scale  <2.0, 49.05, 1.0>
               translate    <-1.0, 5.45, 0.0>
            ]
            [1.0   
               image_map
               {
                  gif   "redstone.gif"
                  once
                  transmit 0, 1.0
               }               scale  <2.0, 49.05, 1.0>
               translate    <-1.0, 5.45, 0.0>
            ]
         }
         scale  <1.0, 1.0, 10.0>
         translate -5.0 * z
    }   
    rotate -45.0 * y
}

#declare StandTexture = texture { pigment { color rgb <1.0, 1.0, 1.0> } }

#declare SmokeTexture = texture { pigment { color rgbf <1.0, 1.0, 1.0, 0.1> } }


//
// ********  REFERENCED OBJECTS  *******
//

#declare TailFinMain1 = intersection {
  box { // TailFin1MainBody
    <-1, -1, -1>, <1, 1, 1>
    scale <1.34, 4.635, 0.25>
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 4.635, -0.0>
  }
  plane { // TailFin1MainClip
    z,0
    scale 0.1
    rotate <-15.75, 90.0, 0.0>
    translate  <1.34, 3.34, 0.0>
  }
}
#declare TailFin1 = union {
  object { TailFinMain1 }
  box { // TailFin1Part2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.67, 1.17, 0.25>
    translate  <2.01, 1.17, 0.0>
  }
  rotate <-0.0, 0.0, -0.0>
  translate  3.09*x
}
#declare MidStabilizer1 = object {
  box { // MidStabilizer1
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.67, 0.15>
  }
}
#declare StandLevel2Brace1 = object {
  box { // StandLevel2Brace1
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.4, 0.4>
    translate  <0.0, 25.0, 5.0>
  }
}
#declare StandLevel3Brace1 = object {
  box { // StandLevel3Brace1
    <-1, -1, -1>, <1, 1, 1>
    scale <4.4, 0.4, 0.4>
    translate  <0.0, 37.0, 4.4>
  }
}
#declare StandLevel4Brace1 = object {
  box { // StandLevel4Brace1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.8, 0.4, 0.4>
    translate  <0.0, 48.0, 3.8>
  }
}
#declare GuardRail4 = object {
  cylinder { // GuardRail4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -86.5*x
    translate  <-2.25, 0.5, -3.3>
  }
}
#declare Stairway1Side1 = intersection {
  box { // Stairway1Side1Body
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 3.1, 3.1>
  }
  plane { // Stairway1Side1Clip1
    z,0
    rotate -45.0*x
    translate  <0.0, 3.1, -3.1>
  }
  plane { // Stairway1Side1Clip2
    z,0
    rotate -225.0*x
    translate  <0.0, 2.165, -3.1>
  }
  translate  -1.225*x
}
#declare Stairway1Side2 = intersection {
  box { // Stairway1Side1Body1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 3.1, 3.1>
  }
  plane { // Stairway1Side1Clip3
    z,0
    rotate -45.0*x
    translate  <0.0, 3.1, -3.1>
  }
  plane { // Stairway1Side1Clip4
    z,0
    rotate -225.0*x
    translate  <0.0, 2.165, -3.1>
  }
  translate  1.225*x
}
#declare Stairway1Step1 = object {
  box { // Stairway1Step1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.075, 0.4>
    translate  <0.0, -2.325, 1.825>
  }
}
#declare Stairway1Rail1 = union {
  cylinder { // Stairway1Rail1Part1
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <0.0, -3.1, 3.1>
  }
  cylinder { // Stairway1Rail1Part2
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <0.0, 3.1, -3.1>
  }
  cylinder { // Stairway1Rail1Part3
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 8.75>
    rotate -135.0*x
    translate  3.1*z
  }
  cylinder { // Stairway1Rail1Part4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 8.75>
    rotate -135.0*x
    translate  <0.0, -1.55, 3.1>
  }
  sphere { // Stairway1Rail1Part5
    <0,0,0>,1
    scale 0.075
    translate  3.1*z
  }
  sphere { // Stairway1Rail1Part6
    <0,0,0>,1
    scale 0.075
    translate  <0.0, 6.2, -3.1>
  }
  translate  -1.225*x
}
#declare Stairway1 = union {
  object { Stairway1Side1 }
  object { Stairway1Side2 }
  object { Stairway1Step1 }
  object { // Stairway1Step2->Stairway1Step1
    Stairway1Step1
    rotate 0.0*x
    translate  <0.0, 0.775, -0.775>
  }
  object { // Stairway1Step3->Stairway1Step1
    Stairway1Step1
    rotate 0.0*x
    translate  <0.0, 1.55, -1.55>
  }
  object { // Stairway1Step4->Stairway1Step1
    Stairway1Step1
    rotate 0.0*x
    translate  <0.0, 2.325, -2.325>
  }
  object { // Stairway1Step5->Stairway1Step1
    Stairway1Step1
    rotate 0.0*x
    translate  <0.0, 3.1, -3.1>
  }
  object { // Stairway1Step6->Stairway1Step1
    Stairway1Step1
    rotate 0.0*x
    translate  <0.0, 3.875, -3.875>
  }
  object { // Stairway1Step7->Stairway1Step1
    Stairway1Step1
    rotate 0.0*x
    translate  <0.0, 4.65, -4.65>
  }
  object { Stairway1Rail1 }
  object { // Stairway1Rail2->Stairway1Rail1
    Stairway1Rail1
    translate  2.45*x
  }
  translate  <5.3, -2.63, 2.2>
}
#declare LeftBottomLeg1 = object {
  box { // LeftBottomLeg1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 7.5, 0.5>
    translate  <5.5, 7.5, 5.5>
  }
}
#declare BottomStairSide1 = intersection {
  box { // BottomStairSide1Body
    <-1, -1, -1>, <1, 1, 1>
    scale <7.9, 7.9, 0.075>
  }
  plane { // BottomStairSide1Clip1
    z,0
    rotate <-90.0, 0.0, -45.0>
    translate  <-7.9, 7.9, 0.0>
  }
  plane { // BottomStairSide1Clip2
    z,0
    rotate <-90.0, 0.0, -225.0>
    translate  <-7.9, 6.8, 0.0>
  }
  translate  <7.9, 7.9, -1.225>
}
#declare BottomStairSide2 = intersection {
  box { // BottomStairSide1Body1
    <-1, -1, -1>, <1, 1, 1>
    scale <7.9, 7.9, 0.075>
  }
  plane { // BottomStairSide1Clip3
    z,0
    rotate <-90.0, 0.0, -45.0>
    translate  <-7.9, 7.9, 0.0>
  }
  plane { // BottomStairSide1Clip4
    z,0
    rotate <-90.0, 0.0, -225.0>
    translate  <-7.9, 6.8, 0.0>
  }
  translate  <7.9, 7.9, 1.225>
}
#declare BottomStairStep1 = object {
  box { // BottomStairStep1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.075, 1.2>
    rotate <0.0, -0.0, -0.0>
    translate  <14.45, 0.79, 0.0>
  }
}
#declare BottomStairSteps = union {
  object { BottomStairStep1 }
  object { // BottomStairStep2->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-0.79, 0.79, -0.0>
  }
  object { // BottomStairStep3->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-1.58, 1.58, -0.0>
  }
  object { // BottomStairStep4->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-2.37, 2.37, -0.0>
  }
  object { // BottomStairStep5->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-3.16, 3.16, -0.0>
  }
  object { // BottomStairStep6->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-3.95, 3.95, -0.0>
  }
  object { // BottomStairStep7->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-4.74, 4.74, -0.0>
  }
  object { // BottomStairStep8->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-5.53, 5.53, -0.0>
  }
  object { // BottomStairStep9->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-6.32, 6.32, -0.0>
  }
  object { // BottomStairStep10->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-7.11, 7.11, -0.0>
  }
  object { // BottomStairStep11->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-7.9, 7.9, -0.0>
  }
  object { // BottomStairStep12->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-8.69, 8.69, -0.0>
  }
  object { // BottomStairStep13->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-9.48, 9.48, -0.0>
  }
  object { // BottomStairStep14->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-10.27, 10.27, -0.0>
  }
  object { // BottomStairStep15->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-11.06, 11.06, -0.0>
  }
  object { // BottomStairStep16->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-11.85, 11.85, -0.0>
  }
  object { // BottomStairStep17->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-12.64, 12.64, -0.0>
  }
  object { // BottomStairStep18->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-13.43, 13.43, -0.0>
  }
  object { // BottomStairStep19->BottomStairStep1
    BottomStairStep1
    rotate <-0.0, -0.0, 0.0>
    translate  <-14.22, 14.22, -0.0>
  }
  translate  0.0*y
}
#declare BottomStairRail1 = union {
  cylinder { // BottomStairRail1Part1
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  15.8*x
  }
  cylinder { // BottomStairRail1Part2
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  15.8*y
  }
  cylinder { // BottomStairRail1Part3
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 22.344999>
    rotate <-135.0, 90.0, 0.0>
    translate  <15.8, 3.1, 0.0>
  }
  cylinder { // BottomStairRail1Part4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 22.344999>
    rotate <-135.0, 90.0, 0.0>
    translate  <15.8, 1.55, 0.0>
  }
  sphere { // BottomStairRail1Part5
    <0,0,0>,1
    scale 0.075
    translate  <15.8, 3.1, 0.0>
  }
  sphere { // BottomStairRail1Part6
    <0,0,0>,1
    scale 0.075
    translate  18.9*y
  }
  cylinder { // BottomStairRail1Part7
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <7.9, 7.9, 0.0>
  }
  translate  <-0.2, 0.0, 1.225>
}
#declare BottomStairRail3 = union {
  cylinder { // BottomStairRail3Part1
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.325>
    rotate <0.0, -90.0, -0.0>
    translate  <-0.2, 18.9, -1.225>
  }
  cylinder { // BottomStairRail3Part2
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate <-90.0, 0.0, -0.0>
    translate  <-2.525, 15.8, -1.225>
  }
  sphere { // BottomStairRail3Part3
    <0,0,0>,1
    scale 0.075
    translate  <-2.525, 18.9, -1.225>
  }
  cylinder { // BottomStairRail3Part4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.325>
    rotate <0.0, -90.0, -0.0>
    translate  <-0.2, 17.35, -1.225>
  }
  cylinder { // BottomStairRail3Part5
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate <-90.0, 0.0, -0.0>
    translate  <-2.525, 15.8, 1.375>
  }
  cylinder { // BottomStairRail3Part6
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate <-90.0, 0.0, -0.0>
    translate  <-7.8, 15.8, 1.375>
  }
  sphere { // BottomStairRail3Part7
    <0,0,0>,1
    scale 0.075
    translate  <-2.525, 18.9, 1.375>
  }
  sphere { // BottomStairRail3Part8
    <0,0,0>,1
    scale 0.075
    translate  <-7.8, 18.9, 1.375>
  }
  cylinder { // BottomStairRail3Part9
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.6>
    rotate -0.0*z
    translate  <-2.525, 18.9, -1.225>
  }
  cylinder { // BottomStairRail3Part10
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.6>
    rotate -0.0*z
    translate  <-2.525, 17.35, -1.225>
  }
  cylinder { // BottomStairRail3Part11
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 5.275>
    rotate <0.0, -90.0, -0.0>
    translate  <-2.525, 18.9, 1.375>
  }
  cylinder { // BottomStairRail3Part12
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 5.275>
    rotate <0.0, -90.0, -0.0>
    translate  <-2.525, 17.35, 1.375>
  }
}
#declare BottomStair = union {
  object { BottomStairSide1 }
  object { BottomStairSide2 }
  box { // BottomStairPlatform
    <-1, -1, -1>, <1, 1, 1>
    scale <1.3, 0.8, 2.6>
    translate  <-1.3, 15.0, 1.3>
  }
  object { BottomStairSteps }
  object { BottomStairRail1 }
  object { // BottomStairRail2->BottomStairRail1
    BottomStairRail1
    translate  -2.45*z
  }
  object { BottomStairRail3 }
  translate  <8.8, 0.0, -7.5>
}
#declare BottomStair2Side1 = intersection {
  box { // BottomStair2Side1Body
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 5.7, 4.9>
    translate  <0.0, -0.9, -6.2>
  }
  plane { // BottomStair2Side1Clip1
    z,0
    rotate -135.0*x
    translate  <0.0, 4.8, -1.3>
  }
  plane { // BottomStair2Side1Clip2
    z,0
    rotate 45.0*x
    translate  <0.0, 3.2, -1.3>
  }
  translate  <-1.225, -4.0, 0.0>
}
#declare BottomStair2Step1 = object {
  box { // BottomStair2Step1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.075, 0.4>
    translate  <0.0, 0.04, -1.3>
  }
}
#declare BottomStair2Rail1 = union {
  cylinder { // BottomStair2Rail1Part1
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <0.0, -9.8, -9.8>
  }
  cylinder { // BottomStair2Rail1Part2
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
  }
  cylinder { // BottomStair2Rail1Part3
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 13.86>
    rotate <45.0, -180.0, 0.0>
    translate  3.1*y
  }
  cylinder { // BottomStair2Rail1Part4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 13.86>
    rotate <45.0, -180.0, 0.0>
    translate  1.55*y
  }
  sphere { // BottomStair2Rail1Part5
    <0,0,0>,1
    scale 0.075
    translate  3.1*y
  }
  sphere { // BottomStair2Rail1Part6
    <0,0,0>,1
    scale 0.075
    translate  <0.0, -6.7, -9.8>
  }
  cylinder { // BottomStair2Rail1Part7
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <0.0, -4.9, -4.9>
  }
  translate  <-1.225, 0.8, -1.3>
}
#declare StandRightPartScaffoldFront6 = 
box { // StandRightPartScaffoldFrontMain6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.2, 0.2>
    rotate -90.0*x
    translate  0.5*x
    scale <10.5, 1.0, 1.0>
    rotate 62.0*z
    translate  <-20.6, 15.0, 0.0>
}
#declare StandRightPartScaffoldFront7 = 
box { // StandRightPartScaffoldFrontMain7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.2, 0.2>
    rotate -90.0*x
    translate  0.5*x
    scale <12.0, 1.0, 1.0>
    rotate 113.5*z
    translate  <-15.5, 24.2, 0.0>
}
#declare StandRightPartScaffoldFront8 = 
box { // StandRightPartScaffoldFrontMain8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.2, 0.2>
    rotate -90.0*x
    translate  0.5*x
    scale <10.0, 1.0, 1.0>
    rotate 60.0*z
    translate  <-20.6, 35.4, 0.0>
}
#declare StandRightPartScaffoldFront11 = 
box { // StandRightPartScaffoldFrontMain9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.2, 0.2>
    rotate -90.0*x
    translate  0.5*x
    scale <10.0, 1.0, 1.0>
    rotate 106.0*z
    translate  <-6.0, 15.0, 0.0>
}
#declare StandRightPartScaffoldFront12 = 
box { // StandRightPartScaffoldFrontMain10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.2, 0.2>
    rotate -90.0*x
    translate  0.5*x
    scale <12.0, 1.0, 1.0>
    rotate 70.0*z
    translate  <-8.7, 24.2, 0.0>
}
#declare StandRightPartScaffoldFront13 = 
box { // StandRightPartScaffoldFrontMain11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.2, 0.2>
    rotate -90.0*x
    translate  0.5*x
    scale <9.5, 1.0, 1.0>
    rotate 116.0*z
    translate  <-4.5, 35.4, 0.0>
}
#declare StandRightPartScaffoldFront = union {
  box { // StandRightPartScaffoldFront1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 14.5, 0.4>
    translate  <-20.6, 29.5, 0.0>
  }
  box { // StandRightPartScaffoldFront2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 19.200001, 0.4>
    translate  <-15.5, 34.2, 0.0>
  }
  box { // StandRightPartScaffoldFront3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 19.200001, 0.4>
    translate  <-8.7, 34.2, 0.0>
  }
  box { // StandRightPartScaffoldFront4
    <-1, -1, -1>, <1, 1, 1>
    scale <2.55, 0.3, 0.3>
    translate  <-18.05, 24.2, 0.0>
  }
  box { // StandRightPartScaffoldFront5
    <-1, -1, -1>, <1, 1, 1>
    scale <2.55, 0.3, 0.3>
    translate  <-18.05, 35.4, 0.0>
  }
  object { StandRightPartScaffoldFront6 }
  object { StandRightPartScaffoldFront7 }
  object { StandRightPartScaffoldFront8 }
  box { // StandRightPartScaffoldFront9
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.3, 0.3>
    translate  <-7.0, 24.2, 0.0>
  }
  box { // StandRightPartScaffoldFront10
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 0.3, 0.3>
    translate  <-6.7, 35.4, 0.0>
  }
  object { StandRightPartScaffoldFront11 }
  object { StandRightPartScaffoldFront12 }
  object { StandRightPartScaffoldFront13 }
  box { // StandRightPartScaffoldFront14
    <-1, -1, -1>, <1, 1, 1>
    scale <3.4, 0.1, 0.1>
    translate  <-12.1, 53.3, 0.0>
  }
  box { // StandRightPartScaffoldFront15
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.1, 0.1>
    rotate -45.0*z
    translate  <-12.1, 49.0, 0.0>
  }
  box { // StandRightPartScaffoldFront16
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.1, 0.1>
    rotate 45.0*z
    translate  <-12.1, 49.0, 0.0>
  }
  translate  3.4*z
}
#declare StandRightPartScaffoldLeft3 = 
box { // StandRightPartScaffoldLeftMain3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 0.5>
    translate  0.5*z
    scale <1.0, 1.0, 11.5>
    rotate -126.5*x
    translate  <-20.6, 15.0, 3.4>
}
#declare StandRightPartScaffoldLeft4 = 
box { // StandRightPartScaffoldLeftMain4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 0.5>
    translate  0.5*z
    scale <1.0, 1.0, 13.2>
    rotate -58.799999*x
    translate  <-20.6, 24.2, -3.4>
}
#declare StandRightPartScaffoldLeft5 = 
box { // StandRightPartScaffoldLeftMain5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 0.5>
    translate  0.5*z
    scale <1.0, 1.0, 11.0>
    rotate -128.0*x
    translate  <-20.6, 35.4, 3.4>
}
#declare StandRightPartScaffoldLeft = union {
  box { // StandRightPartScaffoldLeft1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.3, 3.4>
    translate  <-20.6, 24.2, 0.0>
  }
  box { // StandRightPartScaffoldLeft2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.3, 3.4>
    translate  <-20.6, 35.4, 0.0>
  }
  object { StandRightPartScaffoldLeft3 }
  object { StandRightPartScaffoldLeft4 }
  object { StandRightPartScaffoldLeft5 }
}
#declare StandRightPartBottomPlatformLeft = union {
  box { // StandRightPartBottomPlatformLeg1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 2.8, 0.15>
    translate  <0.0, 2.8, 5.6>
  }
  box { // StandRightPartBottomPlatformLeg2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 2.8, 0.15>
    translate  2.8*y
  }
  box { // StandRightPartBottomPlatformLeg3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 2.8, 0.15>
    translate  <0.0, 2.8, -5.6>
  }
  box { // StandRightPartBottomPlatformLeftStrut1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.3>
    rotate -32.0*x
    translate  <0.0, 3.65, 2.8>
  }
  box { // StandRightPartBottomPlatformLeftStrut2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.3>
    rotate 32.0*x
    translate  <0.0, 3.65, 2.8>
  }
  box { // StandRightPartBottomPlatformLeftStrut3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.3>
    rotate -32.0*x
    translate  <0.0, 3.65, -2.8>
  }
  box { // StandRightPartBottomPlatformLeftStrut4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.3>
    rotate 32.0*x
    translate  <0.0, 3.65, -2.8>
  }
  translate  <-2.8, 0.0, 0.0>
}
#declare StandRightPartUpperPlatform1 = union {
  box { // StandRightPartUpperPlatform1Deck
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.15, 6.2>
  }
  cylinder { // StandRightPartUpperPlatform1Rail1
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <0.9, 0.0, 6.1>
  }
  cylinder { // StandRightPartUpperPlatform1Rail2
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <-0.9, 0.0, 6.1>
  }
  cylinder { // StandRightPartUpperPlatform1Rail3
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <0.9, 0.0, -6.1>
  }
  cylinder { // StandRightPartUpperPlatform1Rail4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <-0.9, 0.0, -6.1>
  }
  cylinder { // StandRightPartUpperPlatform1Rail5
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  -0.9*x
  }
  sphere { // StandRightPartUpperPlatform1Rail6
    <0,0,0>,1
    scale 0.075
    translate  <0.9, 3.1, 6.1>
  }
  sphere { // StandRightPartUpperPlatform1Rail7
    <0,0,0>,1
    scale 0.075
    translate  <-0.9, 3.1, 6.1>
  }
  sphere { // StandRightPartUpperPlatform1Rail8
    <0,0,0>,1
    scale 0.075
    translate  <-0.9, 3.1, 0.0>
  }
  sphere { // StandRightPartUpperPlatform1Rail9
    <0,0,0>,1
    scale 0.075
    translate  <-0.9, 3.1, -6.1>
  }
  sphere { // StandRightPartUpperPlatform1Rail10
    <0,0,0>,1
    scale 0.075
    translate  <0.9, 3.1, -6.1>
  }
  cylinder { // StandRightPartUpperPlatform1Rail11
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 1.8>
    rotate -90.0*y
    translate  <0.9, 3.1, 6.1>
  }
  cylinder { // StandRightPartUpperPlatform1Rail12
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 1.8>
    rotate -90.0*y
    translate  <0.9, 1.55, 6.1>
  }
  cylinder { // StandRightPartUpperPlatform1Rail13
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 1.8>
    rotate -90.0*y
    translate  <0.9, 3.1, -6.1>
  }
  cylinder { // StandRightPartUpperPlatform1Rail14
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 1.8>
    rotate -90.0*y
    translate  <0.9, 1.55, -6.1>
  }
  cylinder { // StandRightPartUpperPlatform1Rail15
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 12.2>
    rotate -180.0*y
    translate  <-0.9, 3.1, 6.1>
  }
  cylinder { // StandRightPartUpperPlatform1Rail16
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 12.2>
    rotate -180.0*y
    translate  <-0.9, 1.55, 6.1>
  }
  translate  <-15.5, 53.3, 0.0>
}
#declare TestStandFencingRailArea1 = union {
  cylinder { // TestStandFencingRailArea1Part1
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
  }
  cylinder { // TestStandFencingRailArea1Part2
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 10.0>
    rotate -90.0*y
    translate  3.1*y
  }
  cylinder { // TestStandFencingRailArea1Part3
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 10.0>
    rotate -90.0*y
    translate  1.55*y
  }
  sphere { // TestStandFencingRailArea1Part4
    <0,0,0>,1
    scale 0.075
    translate  3.1*y
  }
  cylinder { // TestStandFencingRailArea1Part5
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  -10.0*x
  }
  sphere { // TestStandFencingRailArea1Part6
    <0,0,0>,1
    scale 0.075
    translate  <-10.0, 3.1, 0.0>
  }
  translate  -40.0*x
}




//
// ********  OBJECTS  *******
//

#declare TailFins = union {
  object { TailFin1 }
  object { // TailFin2->TailFin1
    TailFin1
    rotate -90.0*y
  }
  object { // TailFin3->TailFin1
    TailFin1
    rotate <180.0, 0.0, 180.0>
    translate  0.0*z
  }
  object { // TailFin4->TailFin1
    TailFin1
    rotate 90.0*y
  }
}
#declare MidStabilizers = union {
  object { MidStabilizer1 }
  object { MidStabilizer1 rotate -90.0*y }
  translate  42.52*y
}
#declare LeftLeg1 = 
box { // LeftLegBody1
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <1.0, 42.0, 1.0>
    rotate <-3.0, 0.0, 3.0>
    translate  <5.5, 15.0, 5.5>
}
#declare LeftLeg2 = 
box { // LeftLegBody2
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <1.0, 42.0, 1.0>
    rotate <-3.0, 0.0, -3.0>
    translate  <-5.5, 15.0, 5.5>
}
#declare LeftLeg3 = 
box { // LeftLegBody3
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <1.0, 42.0, 1.0>
    rotate <3.0, 0.0, 3.0>
    translate  <5.5, 15.0, -5.5>
}
#declare LeftLeg4 = 
box { // LeftLegBody4
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <1.0, 42.0, 1.0>
    rotate <3.0, 0.0, -3.0>
    translate  <-5.5, 15.0, -5.5>
}
#declare Level1Brace1 = 
box { // Level2Brace1Body9
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 14.5, 0.3>
    rotate <-46.5, 0.0, 3.0>
    translate  <5.5, 15.0, 5.5>
}
#declare Level1Brace2 = 
box { // Level2Brace1Body10
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 14.5, 0.3>
    rotate <-3.0, 0.0, 46.5>
    translate  <5.5, 15.0, 5.5>
}
#declare Level1Brace3 = 
box { // Level2Brace1Body11
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 14.5, 0.3>
    rotate <46.5, 0.0, -3.0>
    translate  <-5.5, 15.0, -5.5>
}
#declare Level2Brace1 = 
box { // Level2Brace1Body
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 15.5, 0.3>
    rotate <-38.0, 0.0, 3.0>
    translate  <5.0, 25.0, 5.0>
}
#declare Level2Brace2 = 
box { // Level2Brace1Body1
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 15.5, 0.3>
    rotate <-3.0, 0.0, 38.0>
    translate  <5.0, 25.0, 5.0>
}
#declare Level2Brace3 = 
box { // Level2Brace1Body2
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 15.5, 0.3>
    rotate <38.0, 0.0, -3.0>
    translate  <-5.0, 25.0, -5.0>
}
#declare Level3Brace1 = 
box { // Level2Brace1Body3
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 13.5, 0.3>
    rotate <-36.0, 0.0, 3.0>
    translate  <4.4, 37.0, 4.4>
}
#declare Level3Brace2 = 
box { // Level2Brace1Body4
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 13.5, 0.3>
    rotate <-3.0, 0.0, 36.0>
    translate  <4.4, 37.0, 4.4>
}
#declare Level3Brace3 = 
box { // Level2Brace1Body5
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 13.5, 0.3>
    rotate <36.0, 0.0, -3.0>
    translate  <-4.4, 37.0, -4.4>
}
#declare Level4Brace1 = 
box { // Level2Brace1Body6
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 11.0, 0.3>
    rotate <-39.0, 0.0, 3.0>
    translate  <3.8, 48.0, 3.8>
}
#declare Level4Brace2 = 
  box { // Level2Brace1Body7
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 11.0, 0.3>
    rotate <-3.0, 0.0, 39.0>
    translate  <3.8, 48.0, 3.8>
}
#declare Level4Brace3 = 
box { // Level2Brace1Body8
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    translate  0.5*y
    scale <0.3, 11.0, 0.3>
    rotate <39.0, 0.0, -3.0>
    translate  <-3.8, 48.0, -3.8>
}
#declare DiagonalBracing = union {
  object { Level1Brace1 }
  object { Level1Brace2 }
  object { Level1Brace3 }
  object { Level2Brace1 }
  object { Level2Brace2 }
  object { Level2Brace3 }
  object { Level3Brace1 }
  object { Level3Brace2 }
  object { Level3Brace3 }
  object { Level4Brace1 }
  object { Level4Brace2 }
  object { Level4Brace3 }
}
#declare HorizontalBracing = union {
  object { StandLevel2Brace1 }
  object { // StandLevel2Brace2->StandLevel2Brace1
    StandLevel2Brace1
    rotate 90.0*y
    translate  0.0*z
  }
  object { // StandLevel2Brace3->StandLevel2Brace1
    StandLevel2Brace1
    rotate -180.0*y
    translate  0.0*x
  }
  object { // StandLevel2Brace4->StandLevel2Brace1
    StandLevel2Brace1
    rotate -90.0*y
    translate  0.0*z
  }
  object { StandLevel3Brace1 }
  object { // StandLevel3Brace2->StandLevel3Brace1
    StandLevel3Brace1
    rotate 90.0*y
  }
  object { // StandLevel3Brace3->StandLevel3Brace1
    StandLevel3Brace1
    rotate -180.0*y
    translate  0.0*x
  }
  object { // StandLevel3Brace4->StandLevel3Brace1
    StandLevel3Brace1
    rotate -90.0*y
  }
  object { StandLevel4Brace1 }
  object { // StandLevel4Brace2->StandLevel4Brace1
    StandLevel4Brace1
    rotate 90.0*y
  }
  object { // StandLevel4Brace3->StandLevel4Brace1
    StandLevel4Brace1
    rotate -180.0*y
    translate  0.0*x
  }
  object { // StandLevel4Brace4->StandLevel4Brace1
    StandLevel4Brace1
    rotate -90.0*y
  }
}
#declare TowerBoxWall1 = intersection {
  box { // TowerBoxWall1Body
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 0.5, -0.5>
  }
  plane { // TowerBoxWall1Clip1
    z,0
    scale 0.1
    rotate <0.0, -90.0, -177.0>
    translate  0.5*x
  }
  plane { // TowerBoxWall1Clip2
    z,0
    scale 0.1
    rotate <0.0, -90.0, -3.0>
    translate  -0.5*x
  }
  scale <7.0, 7.0, 0.2>
  rotate -3.0*x
  translate  3.5*z
}
#declare TowerBoxWall2 = intersection {
  box { // TowerBoxWall1Body1
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 0.5, -0.5>
  }
  plane { // TowerBoxWall1Clip3
    z,0
    scale 0.1
    rotate <0.0, -90.0, -177.0>
    translate  0.5*x
  }
  plane { // TowerBoxWall1Clip4
    z,0
    scale 0.1
    rotate <0.0, -90.0, -3.0>
    translate  -0.5*x
  }
  scale <7.0, 7.0, 0.2>
  rotate <-3.0, -90.0, 0.0>
  translate  -3.5*x
}
#declare TowerBoxWall3 = intersection {
  box { // TowerBoxWall1Body2
    <-1, -1, -1>, <1, 1, 1>
    scale 0.5
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 0.5, -0.5>
  }
  plane { // TowerBoxWall1Clip5
    z,0
    scale <0.1, 1.0, 0.1>
    rotate <0.0, -90.0, -177.0>
    translate  0.5*x
  }
  plane { // TowerBoxWall1Clip6
    z,0
    scale 0.1
    rotate <0.0, -90.0, -3.0>
    translate  -0.5*x
  }
  scale <7.0, 7.0, 0.2>
  rotate <-3.0, 90.0, 0.0>
  translate  3.5*x
}
#declare TowerBox = union {
  box { // TowerBoxFloor
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 0.1, 3.5>
    translate  -0.1*y
  }
  object { TowerBoxWall1 }
  object { TowerBoxWall2 }
  object { TowerBoxWall3 }
  cylinder { // GuardRail1
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 6.8>
    rotate -90.0*y
    translate  <3.4, 0.5, -3.3>
  }
  cylinder { // GuardRail2
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 6.6>
    rotate -90.0*y
    translate  <3.3, 2.05, -3.2>
  }
  cylinder { // GuardRail3
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 6.4>
    rotate -90.0*y
    translate  <3.2, 3.6, -3.1>
  }
  object { GuardRail4 }
  object { // GuardRail5->GuardRail4
    GuardRail4
    rotate <-0.0, 0.0, -0.0>
    translate  <1.5, 0.0, -0.0>
  }
  object { // GuardRail6->GuardRail4
    GuardRail4
    rotate <-0.0, 0.0, -0.0>
    translate  <3.0, 0.0, -0.0>
  }
  object { // GuardRail7->GuardRail4
    GuardRail4
    rotate <-0.0, 0.0, -0.0>
    translate  <4.5, 0.0, -0.0>
  }
  translate  50.5*y
}
#declare TowerHouseFloor = difference {
  box { // TowerHouseFloorBody
    <-1, -1, -1>, <1, 1, 1>
    scale <6.3, 0.47, 5.3>
    translate  0.3*x
  }
  box { // TowerHouseFloorCut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.4, 0.5, 3.2>
    translate  <5.4, 0.0, 2.3>
  }
  translate  0.0*z
}
#declare TowerHouseBuildingMain = intersection {
  box { // TowerHouseBuildingMainBody
    <-1, -1, -1>, <1, 1, 1>
    scale <3.57, 5.75, 3.57>
    translate  5.75*y
  }
  plane { // TowerHouseBuildingMainClip1
    z,0
    rotate <-90.0, 0.0, -20.0>
    translate  11.5*y
  }
  plane { // TowerHouseBuildingMainClip2
    z,0
    rotate <-90.0, 0.0, 20.0>
    translate  11.5*y
  }
}
#declare TowerHouseBuildingRoof1 = 
box { // TowerHouseBuildingRoofBody1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.075, 4.0>
    rotate -0.0*y
    translate  <0.5, 0.0, 0.0>
    scale <4.65, 1.0, 1.0>
    rotate -20.0*z
    translate  11.5*y
}
#declare TowerHouseBuildingRoof2 =
box { // TowerHouseBuildingRoofBody2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.075, 4.0>
    rotate -0.0*y
    translate  <-0.5, 0.0, 0.0>
    scale <4.65, 1.0, 1.0>
    rotate 20.0*z
    translate  11.5*y
}
#declare TowerHouseBuilding = union {
  object { TowerHouseBuildingMain }
  object { TowerHouseBuildingRoof1 }
  object { TowerHouseBuildingRoof2 }
  box { // TowerHouseBuildingRoofMiddle
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 4.0>
    translate  11.5*y
  }
  translate  0.0*z
}
#declare Stairway1FloorRail = union {
  cylinder { // Stairway1FloorRailPart1
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.57>
    rotate -90.0*x
    translate  <1.225, 0.0, 1.77>
  }
  cylinder { // Stairway1FloorRailPart2
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.671>
    rotate -180.0*x
    translate  <1.225, 3.57, 1.77>
  }
  cylinder { // Stairway1FloorRailPart3
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.671>
    rotate -180.0*x
    translate  <1.225, 2.02, 1.77>
  }
  cylinder { // Stairway1FloorRailPart4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.9>
    rotate <-180.0, 90.0, 0.0>
    translate  <1.225, 3.57, 1.77>
  }
  cylinder { // Stairway1FloorRailPart5
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.9>
    rotate <-180.0, 90.0, 0.0>
    translate  <1.225, 2.02, 1.77>
  }
  sphere { // Stairway1FloorRailPart6
    <0,0,0>,1
    scale 0.075
    translate  <1.225, 3.57, 0.0>
  }
}
#declare Stairway1Floor = union {
  box { // Stairway1FloorMain
    <-1, -1, -1>, <1, 1, 1>
    scale <1.3, 0.47, 1.77>
  }
  object { Stairway1FloorRail }
  translate  <5.3, -6.2, 6.2>
}
#declare TowerHouseFloorRailing = union {
  cylinder { // TowerHouseFloorRailL1
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 4.25>
    rotate -180.0*y
    translate  <6.525, 2.0, -0.9>
  }
  cylinder { // TowerHouseFloorRailH1
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 4.25>
    rotate -180.0*y
    translate  <6.525, 3.55, -0.9>
  }
  cylinder { // TowerHouseFloorRailL2
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 12.425>
    rotate -90.0*y
    translate  <6.525, 2.0, -5.15>
  }
  cylinder { // TowerHouseFloorRailH2
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 12.425>
    rotate -90.0*y
    translate  <6.525, 3.55, -5.15>
  }
  cylinder { // TowerHouseFloorRailL3
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 10.3>
    translate  <-5.9, 2.0, -5.15>
  }
  cylinder { // TowerHouseFloorRailH3
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 10.3>
    translate  <-5.9, 3.55, -5.15>
  }
  cylinder { // TowerHouseFloorRailVert1
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <6.525, 0.47, -0.9>
  }
  cylinder { // TowerHouseFloorRailVert2
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <6.525, 0.47, -5.15>
  }
  sphere { // TowerHouseFloorRailVertSphere1
    <0,0,0>,1
    scale 0.075
    translate  <6.525, 3.57, -0.9>
  }
  sphere { // TowerHouseFloorRailVertSphere2
    <0,0,0>,1
    scale 0.075
    translate  <6.525, 3.57, -5.15>
  }
  cylinder { // TowerHouseFloorRailVert3
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <-5.9, 0.47, -5.15>
  }
  sphere { // TowerHouseFloorRailVertSphere3
    <0,0,0>,1
    scale 0.075
    translate  <-5.9, 3.57, -5.15>
  }
  cylinder { // TowerHouseFloorRailVert4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <-5.9, 0.47, 5.15>
  }
  sphere { // TowerHouseFloorRailVertSphere4
    <0,0,0>,1
    scale 0.075
    translate  <-5.9, 3.57, 5.15>
  }
  cylinder { // TowerHouseFloorRailVert5
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <-5.9, 0.47, 0.0>
  }
  cylinder { // TowerHouseFloorRailVert6
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <-1.8, 0.47, -5.15>
  }
  cylinder { // TowerHouseFloorRailVert7
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <2.125, 0.47, -5.15>
  }
  cylinder { // TowerHouseFloorRailVert8
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <3.85, 0.47, 5.15>
  }
  sphere { // TowerHouseFloorRailVertSphere8
    <0,0,0>,1
    scale 0.075
    translate  <3.85, 3.57, 5.15>
  }
  cylinder { // TowerHouseFloorRailL4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 9.75>
    rotate 90.0*y
    translate  <-5.9, 2.0, 5.15>
  }
  cylinder { // TowerHouseFloorRailH4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 9.75>
    rotate 90.0*y
    translate  <-5.9, 3.55, 5.15>
  }
  cylinder { // TowerHouseFloorRailVert9
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <-1.025, 0.47, 5.15>
  }
  cylinder { // TowerHouseFloorRailVert10
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <3.85, 0.47, -0.9>
  }
  sphere { // TowerHouseFloorRailVertSphere10
    <0,0,0>,1
    scale 0.075
    translate  <3.85, 3.57, -0.9>
  }
  cylinder { // TowerHouseFloorRailL8
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 6.05>
    rotate -180.0*y
    translate  <3.85, 2.0, 5.15>
  }
  cylinder { // TowerHouseFloorRailH8
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 6.05>
    rotate -180.0*y
    translate  <3.85, 3.55, 5.15>
  }
  cylinder { // TowerHouseFloorRailL10
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 0.225>
    rotate 90.0*y
    translate  <3.85, 2.0, -0.9>
  }
  cylinder { // TowerHouseFloorRailH10
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 0.225>
    rotate 90.0*y
    translate  <3.85, 3.55, -0.9>
  }
  translate  0.0*z
}
#declare TowerHouse = union {
  box { // TowerHouseLeg1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 1.25, 3.6>
    translate  <-3.2, -1.25, 0.0>
  }
  box { // TowerHouseLeg2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 1.25, 3.6>
    translate  <3.2, -1.25, 0.0>
  }
  object { TowerHouseFloor }
  object { Stairway1 }
  object { // Stairway2->Stairway1
    Stairway1
    rotate -90.0*y
    translate  <2.7, -6.2, 1.7>
  }
  object { TowerHouseBuilding }
  object { Stairway1Floor }
  object { TowerHouseFloorRailing }
  translate  60.3*y
}
#declare StandLeftPartShed1Body = intersection {
  box { // StandLeftPartShed1BodyMain
    <-1, -1, -1>, <1, 1, 1>
    scale <3.4, 4.4, 9.3>
    translate  4.4*y
  }
  plane { // StandLeftPartShed1BodyClip
    z,0
    scale <4.0, 1.0, 1.0>
    rotate <-90.0, 0.0, -10.0>
    translate  <-3.4, 8.8, 0.0>
  }
}
#declare StandLeftPartShed1Roof =
box { // StandLeftPartShed1RoofMain
    <-1, -1, -1>, <1, 1, 1>
    scale <3.6, 0.23, 9.8>
    rotate <0.0, -0.0, -0.0>
    translate  3.5*x
    rotate -10.0*z
    translate  <-3.4, 8.8, 0.0>
}
#declare StandLeftPartShed1 = union {
  object { StandLeftPartShed1Body }
  object { StandLeftPartShed1Roof }
  translate  <9.6, 0.0, 3.1>
}
#declare LeftBottomLegs = union {
  object { LeftBottomLeg1 }
  object { // LeftBottomLeg2->LeftBottomLeg1
    LeftBottomLeg1
    rotate -0.0*y
    translate  <0.0, 0.0, -11.0>
  }
  object { // LeftBottomLeg3->LeftBottomLeg1
    LeftBottomLeg1
    rotate -0.0*y
    translate  <-11.0, 0.0, -11.0>
  }
  object { // LeftBottomLeg4->LeftBottomLeg1
    LeftBottomLeg1
    translate  -11.0*x
  }
  box { // LeftBottomLegBrace1
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 0.4, 0.4>
    rotate -54.0*z
    translate  <0.0, 7.0, -5.5>
  }
  box { // LeftBottomLegBrace2
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 0.4, 0.4>
    rotate 54.0*z
    translate  <0.0, 7.0, 5.5>
  }
  box { // LeftBottomLegBrace3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.4, 9.0>
    rotate -54.0*x
    translate  <5.5, 7.0, 0.0>
  }
  box { // LeftBottomLegBrace4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.4, 9.0>
    rotate 54.0*x
    translate  <-5.5, 7.0, 0.0>
  }
}
#declare BottomStair2Steps = union {
  object { BottomStair2Step1 }
  object { // BottomStair2Step2->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -0.76, -0.76>
  }
  object { // BottomStair2Step3->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -1.52, -1.52>
  }
  object { // BottomStair2Step4->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -2.28, -2.28>
  }
  object { // BottomStair2Step5->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -3.04, -3.04>
  }
  object { // BottomStair2Step6->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -3.8, -3.8>
  }
  object { // BottomStair2Step7->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -4.56, -4.56>
  }
  object { // BottomStair2Step8->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -5.32, -5.32>
  }
  object { // BottomStair2Step9->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -6.08, -6.08>
  }
  object { // BottomStair2Step10->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -6.84, -6.84>
  }
  object { // BottomStair2Step11->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -7.6, -7.6>
  }
  object { // BottomStair2Step12->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -8.36, -8.36>
  }
  object { // BottomStair2Step13->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -9.12, -9.12>
  }
  object { // BottomStair2Step14->BottomStair2Step1
    BottomStair2Step1
    translate  <0.0, -9.88, -9.88>
  }
}
#declare BottomStair2Rail5 = union {
  cylinder { // BottomStair2Rail5Part1
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 3.1>
    rotate -90.0*x
    translate  <1.0, 0.8, 1.225>
  }
  sphere { // BottomStair2Rail5Part2
    <0,0,0>,1
    scale 0.075
    translate  <1.0, 3.9, 1.225>
  }
  cylinder { // BottomStair2Rail5Part3
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.525>
    rotate -180.0*y
    translate  <1.0, 3.9, 1.225>
  }
  cylinder { // BottomStair2Rail5Part4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.525>
    rotate -180.0*y
    translate  <1.0, 2.35, 1.225>
  }
  cylinder { // BottomStair2Rail5Part5
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.225>
    rotate -90.0*y
    translate  <1.0, 3.9, 1.225>
  }
  cylinder { // BottomStair2Rail5Part6
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.225>
    rotate -90.0*y
    translate  <1.0, 2.35, 1.225>
  }
}
#declare BottomStair2 = union {
  box { // BottomStair2Platform
    <-1, -1, -1>, <1, 1, 1>
    scale <1.3, 0.8, 1.3>
  }
  object { BottomStair2Side1 }
  object { // BottomStair2Side2->BottomStair2Side1
    BottomStair2Side1
    translate  2.45*x
  }
  object { BottomStair2Steps }
  object { BottomStair2Rail1 }
  object { // BottomStair2Rail2->BottomStair2Rail1
    BottomStair2Rail1
    rotate <0.0, 0.0, 0.0>
    translate  <2.25, 0.0, -0.0>
  }
  cylinder { // BottomStair2Rail3
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.675>
    rotate -180.0*x
    translate  <1.225, -5.9, -11.1>
  }
  cylinder { // BottomStair2Rail4
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 2.675>
    rotate -180.0*x
    translate  <1.225, -7.45, -11.1>
  }
  object { BottomStair2Rail5 }
  translate  <7.5, 24.8, 7.5>
}
#declare StandLeftPartShed2 = union {
  box { // StandLeftPartShed2Body
    <-1, -1, -1>, <1, 1, 1>
    scale <0.95, 2.8, 4.2>
    rotate -0.0*y
    translate  <0.95, 2.8, 0.0>
  }
  box { // StandLeftPartShed2Roof
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 4.4>
    rotate -0.0*y
    translate  <1.1, 5.6, 0.0>
  }
  translate  <-4.5, 16.0, 0.0>
}
#declare StandLeftPart = union {
  box { // StandLevel1Floor
    <-1, -1, -1>, <1, 1, 1>
    scale <6.2, 0.8, 6.2>
    translate  15.0*y
  }
  box { // StandLevel5Floor
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.8, 4.0>
    translate  57.0*y
  }
  object { LeftLeg1 }
  object { LeftLeg2 }
  object { LeftLeg3 }
  object { LeftLeg4 }
  object { DiagonalBracing }
  object { HorizontalBracing }
  object { TowerBox }
  object { TowerHouse }
  cone { // StandLeftPartCone
    <0,0,0>, 1.0, <0,0,1>, 0.4
    scale <6.0, 6.0, 1.0>
    rotate -90.0*x
    translate  26.8*y
  }
  object { StandLeftPartShed1 }
  object { LeftBottomLegs }
  object { BottomStair }
  object { BottomStair2 }
  object { // BackStair->BottomStair
    BottomStair
    translate  <-18.125, 25.6, 15.0>
  }
  object { StandLeftPartShed2 }
  box { // StandLeftPartShed3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.7, 3.7, 1.25>
    translate  <0.0, 3.7, 6.25>
  }
}
#declare RocketUpperDeck = union {
  box { // RocketUpperDeckBody1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.65, 0.5, 4.0>
    translate  -6.65*x
  }
  box { // RocketUpperDeckBody2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.2, 0.5, 4.0>
    translate  -18.0*x
  }
  box { // RocketUpperDeckBody3
    <-1, -1, -1>, <1, 1, 1>
    scale <8.6, 0.5, 0.5>
    translate  <-12.6, 0.0, 3.5>
  }
  box { // RocketUpperDeckBody4
    <-1, -1, -1>, <1, 1, 1>
    scale <8.6, 0.5, 0.5>
    translate  <-12.6, 0.0, -3.5>
  }
  rotate -0.0*y
  translate  44.0*y
}
#declare RocketMidDeck = union {
  box { // RocketMidDeckBody1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.8, 6.2>
    translate  -5.5*x
  }
  box { // RocketMidDeckBody2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 0.8, 6.2>
    translate  -19.0*x
  }
  box { // RocketMidDeckBody3
    <-1, -1, -1>, <1, 1, 1>
    scale <8.6, 0.8, 0.9>
    translate  <-12.6, 0.0, 5.3>
  }
  box { // RocketMidDeckBody4
    <-1, -1, -1>, <1, 1, 1>
    scale <8.6, 0.8, 0.9>
    translate  <-12.6, 0.0, -5.3>
  }
  rotate -0.0*y
  translate  15.0*y
}
#declare StandRightPartScaffold = union {
  object { StandRightPartScaffoldFront }
  object { // StandRightPartScaffoldRear->StandRightPartScaffoldFront
    StandRightPartScaffoldFront
    translate  -6.8*z
  }
  object { StandRightPartScaffoldLeft }
  object { // StandRightPartScaffoldLeft6->StandRightPartScaffoldLeft
    StandRightPartScaffoldLeft
    translate  5.1*x
  }
  object { // StandRightPartScaffoldLeft7->StandRightPartScaffoldLeft
    StandRightPartScaffoldLeft
    translate  11.9*x
  }
}
#declare StandRightPartBottomPlatform = union {
  box { // StandRightPartBottomPlatformTop
    <-1, -1, -1>, <1, 1, 1>
    scale <3.1, 0.3, 5.9>
    translate  5.6*y
  }
  box { // StandRightPartBottomPlatformBottom
    <-1, -1, -1>, <1, 1, 1>
    scale <3.1, 0.3, 5.9>
    translate  1.7*y
  }
  object { StandRightPartBottomPlatformLeft }
  object { // StandRightPartBottomPlatformLeft1->StandRightPartBottomPlatformLeft
    StandRightPartBottomPlatformLeft
    translate  <5.6, -0.0, 0.0>
  }
  box { // StandRightPartBottomPlatformFrontStrut1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 0.1, 0.1>
    rotate -32.0*z
    translate  <0.0, 3.65, -5.6>
  }
  box { // StandRightPartBottomPlatformFrontStrut2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 0.1, 0.1>
    rotate 32.0*z
    translate  <0.0, 3.65, -5.6>
  }
  translate  <-12.0, 0.0, -12.1>
}
#declare StandRightPart = union {
  object { RocketUpperDeck }
  box { // RocketLowerPlatform
    <-1, -1, -1>, <1, 1, 1>
    scale <7.8, 0.6, 6.2>
    translate  <-13.4, 6.2, 0.0>
  }
  object { RocketMidDeck }
  object { StandRightPartScaffold }
  object { StandRightPartBottomPlatform }
  box { // StandRightPartMainLeg1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 7.5, 0.6>
    translate  <-20.4, 7.5, -5.4>
  }
  box { // StandRightPartMainLeg2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 7.5, 0.6>
    translate  <-20.4, 7.5, 5.4>
  }
  box { // StandRightPartShed2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.7, 4.3>
    translate  <-23.2, 3.7, -6.0>
  }
  object { StandRightPartUpperPlatform1 }
  object { // StandRightPartUpperPlatform2->StandRightPartUpperPlatform1
    StandRightPartUpperPlatform1
    scale <-1.0, 1.0, 1.0>
    translate  -24.2*x
  }
}
#declare TestStandFencing = union {
  object { TestStandFencingRailArea1 }
  object { // TestStandFencingRailArea2->TestStandFencingRailArea1
    TestStandFencingRailArea1
    translate  10.0*x
  }
  object { // TestStandFencingRailArea3->TestStandFencingRailArea1
    TestStandFencingRailArea1
    translate  20.0*x
  }
  object { // TestStandFencingRailArea4->TestStandFencingRailArea1
    TestStandFencingRailArea1
    translate  30.0*x
  }
  object { // TestStandFencingRailArea5->TestStandFencingRailArea1
    TestStandFencingRailArea1
    translate  40.0*x
  }
  object { // TestStandFencingRailArea6->TestStandFencingRailArea1
    TestStandFencingRailArea1
    translate  50.0*x
  }
  object { // TestStandFencingRailArea7->TestStandFencingRailArea1
    TestStandFencingRailArea1
    translate  60.0*x
  }
  object { // TestStandFencingRailArea8->TestStandFencingRailArea1
    TestStandFencingRailArea1
    translate  70.0*x
  }
  object { // TestStandFencingRailArea9->TestStandFencingRailArea1
    TestStandFencingRailArea1
    translate  80.0*x
  }
  object { // TestStandFencingRailArea10->TestStandFencingRailArea1
    TestStandFencingRailArea1
    translate  90.0*x
  }
  object { // TestStandFencingRailArea11->TestStandFencingRailArea1
    TestStandFencingRailArea1
    translate -10.0*x
  }
  object { // TestStandFencingRailArea12->TestStandFencingRailArea1
    TestStandFencingRailArea1
    translate -20.0*x
  }
}
#declare TestStand = union {
  object { StandLeftPart }
  object { StandRightPart }
  object { TestStandFencing }
  texture {
    StandTexture
  }
}

#declare RedstoneRocket = union {
  cone { // NoseCone
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <2.17, 2.17, 7.35>
    rotate 90.0*x
    translate  69.48*y
  }
  cone { // Segment1
    <0,0,0>, 2.5, <0,0,1>, 2.17
    scale <1.0, 1.0, 12.1>
    rotate -90.0*x
    translate  50.03*y
  }
  cone { // Segment2
    <0,0,0>, 2.76, <0,0,1>, 2.5
    scale <1.0, 1.0, 8.68>
    rotate -90.0*x
    translate  41.35*y
  }
  cylinder { // Segment3
    <0,0,1>, <0,0,0>, 1 
    scale <2.76, 2.76, 32.080002>
    rotate -90.0*x
    translate  9.27*y
  }
  cone { // ExhaustCone
    <0,0,0>, 2.67, <0,0,1>, 2.76
    scale <1.0, 1.0, 7.52>
    rotate -90.0*x
    translate  1.75*y
  }
  object { TailFins }
  object { MidStabilizers }
  texture {
    RocketTexture
  }
  rotate 45.0*y
  translate  <-12.0, 6.8, 0.0>
}

#declare ExhaustSmoke =
union {
    sphere { // ExhaustSmoke1
        <0,0,0>,1
        hollow
        pigment { color rgbf<1, 1, 1, 1> }
        interior {
            media {		      
                emission EmissValue
                absorption EmissValue 	// To make the smoke cast shadows
                intervals Pulverization	// New to v1.1
                samples 1, 10				// possibly: implement "SDensity" or something
                confidence 0.9
                variance 1/1000
                density {
                    spherical
                    triangle_wave		// possibly: implement "SType
                    color_map {			// possibly: #ifdef ClrMap #include "smokecolorX.map"
                        [0.0 color rgb SColor1]
                        [1.0 color rgb SColor2]
                    }
          	        warp {turbulence TurbValue}
                }
                scale Size
                scale 0.5
            }
        }
        scale <1.5, 1.0, 1.5>
        translate  0.8*y
    }

    sphere { // ExhaustSmoke2
        <0,0,0>,1
        hollow
        pigment { color rgbf<1, 1, 1, 1> }
        interior {
            media {		      
                emission EmissValue
                absorption EmissValue 	// To make the smoke cast shadows
                intervals Pulverization	// New to v1.1
                samples 1, 10				// possibly: implement "SDensity" or something
                confidence 0.9
                variance 1/1000
                density {
                    spherical
                    triangle_wave		// possibly: implement "SType
                    color_map {			// possibly: #ifdef ClrMap #include "smokecolorX.map"
                        [0.0 color rgb SColor1]
                        [1.0 color rgb SColor2]
                    }
            	    warp {turbulence TurbValue}
                }
                scale Size
                scale 0.5
            }
        }
        scale 2
        scale <15.0, 7.5, 15.0>
        translate  -6.0*y
        translate  -1.5*y
    }
    translate  <-12.0, 6.8, 0.0>
}

#declare TestStandScene = 
union { // TestStandScene
    object { RedstoneRocket }
    object { TestStand }
    #if (UseSmoke)
        object { ExhaustSmoke }
    #end
}
