// Persistence of Vision Ray Tracer Scene Description File
// File: Redstone.pov
// Vers: 3.1
// Desc: Redstone rocket test-firing scene
// Date: 4/17/99
// Auth: Steve Sloan II

#include "colors.inc"

global_settings { assumed_gamma 1.0 }

// Set to 1 for final render. Set to 0 for test renders
#declare UseSmoke = 1;

/*********/
/* Units */
/*********/

// Feet
#declare feet = 1;
#declare ft = feet;

// Miles
#declare miles = 5280*ft;
#declare mi = miles;

/**********/
/* CAMERA */
/**********/

camera {
    location  <8,  6, -80>
    right     <1.33333,  0.0,  0.0>
    look_at   <10, 30,   0>
}

/*******************************************/
/* Sky technique from a February 1998 post */
/* to comp.graphics.rendering.raytracing   */
/* by A.A.M. v.d. Wouden <aamw@doge.nl>    */
/*******************************************/

// Set a color of the background (sky)
background { color SkyBlue }

// Set the sky's pigment
sky_sphere {
    pigment {
        bozo
        turbulence 0.65
        octaves 4
        lambda 4
        color_map {
            [0     color SkyBlue ]
            [0.60  color SkyBlue ]
            [0.70  color rgbt <0.7, 0.7, 0.7, 0.65>  ]
            [0.80  color rgbt <0.8, 0.8, 0.8, 0.50>  ]
            [0.90  color rgbt <0.9, 0.9, 0.9, 0.35>  ]
            [1.0   color rgbt <1.0, 1.0, 1.0, 0.15>  ]
        }
        scale 0.5
    }
}

  
/**********/
/* LIGHTS */
/**********/

light_source { <2, 1.8, -2.5>*mi color White }

/**********/
/* GROUND */
/**********/

// Distant terrain
union {
    height_field {
        tga "mountain.tga"
        water_level 0.01
        translate -0.02*y
        scale <1, 0.1, 1> // y was 0.1
        translate <-0.4, 0, 0>
        scale mi
    }
    sphere { -1*y, 1 scale 3963*mi }
    pigment {
        bumps
        color_map {
            [0.0 color Gray50]
            [1.0 color SpringGreen]
        }
        scale 0.1
    }
    normal { bumps bump_size 5.0 scale 0.1 }
}


/*****************/
/* DISTANT TREES */
/* Less Detailed */
/*****************/

#declare xmin = -2;
#declare xmax =  2;
#declare zmin =  0;
#declare zmax =  3;

#include "TreeLine.inc"

object {
    DistantTrees
    scale 500*ft
    translate <0, 0, 1000>*ft
}


/**************************************/
/* Add the Redstone rocket test stand */
/**************************************/

#include "Redstone.inc"

object { TestStandScene scale <-1, 1, 1>*ft }

/********************/
/* PICTURE TIMELINE */
/********************/

#declare picture_ambient = 0.3;

#declare ApolloPicture = 
cylinder {
    -0.01*z, 0.01*z, 0.5
    pigment {
        image_map {
            gif "redstone\apollo.gif"
            map_type 0
            interpolate 2
            once
        }
        translate <-0.5, -0.5, 0>
        scale 1.01
    }
    finish { ambient picture_ambient }
    scale <337/260, 1, 1>
}

#declare MarshallPicture = 
cylinder {
    -0.01*z, 0.01*z, 0.5
    pigment {
        image_map {
            gif "redstone\marshall.gif"
            map_type 0
            interpolate 2
            once
        }
        translate <-0.5, -0.5, 0>
        scale 1.01
    }
    finish { ambient picture_ambient }
    scale <209/288, 1, 1>
}

#declare MercuryPicture = 
union {
    cylinder { -0.02*z, 0.02*z, 0.5 }
    torus { 0.48, 0.02 rotate 90*x translate -0.02*z }
    pigment {
        image_map {
            gif "redstone\mercury.gif"
            map_type 0
            interpolate 2
            once
        }
        translate <-0.5, -0.5, 0>
        scale <476/477, 1, 1>
    }
    finish { ambient picture_ambient }
}

#declare vonBraunPicture = 
cylinder {
    -0.01*z, 0.01*z, 0.5
    pigment {
        image_map {
            gif "redstone\vonbraun.gif"
            map_type 0
            interpolate 2
            once
        }
        translate <-0.5, -0.5, 0>
        scale 1.01
    }
    finish { ambient picture_ambient }
    scale <232/330, 1, 1>
}

object { vonBraunPicture scale 20*ft translate <-25, 25, 0>*ft }
object { MarshallPicture scale 20*ft translate <-25, 55, 0>*ft }
object { MercuryPicture  scale 20*ft translate < 40, 55, 0>*ft }
object { ApolloPicture   scale 20*ft translate < 40, 25, 0>*ft }


