// Persistence of Vision Ray Tracer Scene Description File
// File: TreeLine.inc
// Vers: 3.1
// Desc: Creates a semi-rectangular forest of height-field-generated trees
// Date: 4/18/99
// Auth: Steve Sloan II

#declare DistantTree = 
union {
    intersection {
        height_field {
            tga "foresthf.tga"
            smooth
            water_level 0.01
            scale <1, 0.4, 1>
        }
        union {
            box { <0, 0, 0>, <1, 10, 1> }
            height_field {
                tga "bumpy.tga"
                smooth
                water_level 0.01
                scale <1, -1, 1>
            }
            scale <1, 0.1, 1>
            translate 0.2*y
        }
        translate -0.1*y
        pigment { color rgb <0.237255, 0.656863, 0.237255> }
        normal { bumps bump_size 5.0 scale 0.01 }
    }
    intersection {
        height_field {
            tga "foresthf.tga"
            smooth
            water_level 0.01
            scale <1, 2, 1>
            translate -1.9*y
        }
        plane { -y, 0 }
        pigment { color Brown }
        normal { bumps bump_size 5.0 scale <0.01, 0.05, 0.01> }
    }
    translate <-0.5, 0, -0.5>
}

#declare DistantTrees = 
union {
    #declare zcount = zmin;
    #while (zcount <= zmax)
        #declare xcount = xmin;
        #while (xcount <= xmax)
            object { DistantTree rotate 90*(xcount+ zcount)*y translate <xcount, 0, zcount> }
            #declare xcount = xcount + 1;
        #end
        #declare zcount = zcount + 1;
    #end
}
