
// Persistence of Vision Ray Tracer Scene Description File
// File: Sextant.pov
// Vers: 3.1
// Desc: Old brass sextant
// Date: 04/1999
// Auth: Bruno Lailler

#include "colors.inc"	// Standard Color definitions
#include "skies.inc"
#include "metals.inc"
#include "golds.inc"
#include "glass.inc"
#include "woods.inc"

global_settings { assumed_gamma 2.2 }

//background { color red 0.1 green 0.3 blue 0.8 }
sky_sphere { S_Cloud2 }

camera {
  location  < 180, 200, -150>
  look_at   < 0, 20, -60>
  angle 50
}
/*
camera {
  location  < 0, 4, 0.5>
  look_at   < 0, 1.5, 0>
  aperture .5
  focal_point <0,1.6,0>
  blur_samples 19
  confidence 0.90            // default is 0.9
  variance 1/128             // default is 1/128 (0.0078125)
  rotate 30*y
  angle 25
}
*/

light_source { < -100, 500, -800> color White adaptive 1 jitter }
light_source { < -800, 2000, -500> color White adaptive 1 jitter }

#declare Parquet = texture { T_Wood5 scale 15 rotate 90*y finish { phong 1.0 phong_size 90 } }

//box { <-1000, -50, -1000>, <1000, -60, 1000> texture { T_Wood5 scale 20 } } // sous le plancher

#declare Lame = box { <0,-38,0> <5000,-50, 148> }
#declare Rangee = 0;
#while (Rangee < 50 )
  #declare LameCount = 0;
  #while (LameCount < 20)
    #declare xx=-2000; //-(800*mod(Rangee,4))+(200*LameCount);
    #declare zz=1000-(150*Rangee);
    #declare R1=seed(Rangee+(LameCount*100));
    object {
      Lame
      texture {
        Parquet
        translate <0,0,rand(R1)*200>
      }
      //rotate 33*y
      translate <xx,0,zz>
    }
    #declare LameCount = LameCount+1;
  #end
  #declare Rangee = Rangee+1;
#end

#declare Laiton = texture {T_Gold_3A}
#declare Invisible = texture { pigment { color rgbf <1, 1, 1, 1.0> } }
#declare Mirror = 
texture {
  finish { reflection < 0.990, 0.990, 0.990 > }
  pigment { Black }
}
#declare NBglass=
texture {
  pigment {color green 1 blue .99 red .98 filter .95}
  finish{
    ambient 0.1
    diffuse 0.1
    reflection .25
    refraction 1
    ior 1.5
    specular 1
    roughness .001
  }
}

// gouttes d'eau
sphere { <50,0,50> 10 scale <1,.3,1> translate <0,-38,0> texture { T_Glass3 } }
sphere { <20,0,40>  5 scale <1,.5,1> translate <0,-38,0> texture { T_Glass3 } }
sphere { <20,0,10>  4 scale <1,.5,1> translate <0,-38,0> texture { T_Glass3 } }
sphere { <60,0,20>  3 scale <1,.9,1> translate <0,-38,0> texture { T_Glass3 } }
sphere { <55,0,10>  2 scale <1,.9,1> translate <0,-38,0> texture { T_Glass3 } }
sphere { <65,0,15>  4 scale <1,.5,1> translate <0,-38,0> texture { T_Glass3 } }

//-----------------------------------------------------------------------------                 
#declare VisA =
difference {
  cylinder { <0,0,0> <0,3,0> 2.8 }
  box { <-3,2,-0.5> <3,4,0.5> }
  rotate 30*y
  texture { Laiton }
}
                 
//-----------------------------------------------------------------------------                 
#declare VisB =
difference {
  cylinder { <0,0,0> <0,2,0> 2.2 }
  box { <-3,1,-0.5> <3,3,0.5> }
  rotate -40*y
  texture { Laiton }
}
                 
//-----------------------------------------------------------------------------                 
#declare Corps =
union {
  difference {
    cylinder { < 0, 0,  0> < 0, 4,  0> 140 }
    box { < 150,-1, 0> <-150, 5,-150> rotate -135*y }
    box { < 150,-1, 0> <-150, 5, 150> rotate -45*y }
    cylinder { < 0, -1, -50> < 0, 5, -50> 27 rotate 4*y }
    cylinder { < 0, -1, -105> < 0, 5, -105> 27 rotate  17*y }
    cylinder { < 0, -1, -105> < 0, 5, -105> 27 rotate -17*y }
    cylinder { < 0, -1, -114> < 0, 5, -114> 18 rotate -45*y }
    box { <0,-1,0> <20,5,-114> rotate -36*y }
    cylinder { <0,-1,-132> <0, 5,-132> 2.8 rotate  38*y } // trous des
    cylinder { <0,-1,-132> <0, 5,-132> 2.8 rotate -38*y } // pieds
    cylinder { <0,-1,-120> <0,5,-120> 9 scale <1.8,1,1> rotate 45*y }
    cylinder { <0,-1, -25> <0,5, -25> 3.5 } // trous de la
    cylinder { <0,-1,-118> <0,5,-118> 3.5 } // poigne
  }
  difference {
    cylinder { < 0, 4, 0> < 0, 6, 0> 152 }
    cone { < 0, 3.9, 0> 138 < 0, 6.1, 0> 140 }
    box { < 153, 3, 0> <-153, 7,-153> rotate -135*y }
    box { < 153, 3, 0> <-153, 7, 153> rotate -45*y }
  }
  difference {
    cylinder { < 0, 0,-25> < 0, 4,-25> 7 }  
    cylinder { <0,-1, -25> <0,5, -25> 3.5 }
  }
  cylinder { <0,0,0> <0,4,0> 17 }
  cylinder { <0,0,-60> <0,4,-60> 14 rotate -47*y}
  cone { <0,4,0> 16 <0,5,0> 14 }
  texture { Laiton }
}                 

//-----------------------------------------------------------------------------                 
#declare Lunette =
union {
  difference {
    cylinder { <58,0,0> <60,0,0> 9 }
    cone { <60,0,0> 9 <59,0,0> 2 }
    cylinder { <61,0,0> <50,0,0> 2 }
  }
  difference {
    cylinder { <-4,0,0> <4,0,0> 13 }
    cylinder { <-5,0,0> <5,0,0> 8.5 }
  }
  difference {
    cone { <-4,0,0> 12 <-32,0,0> 13 }
    cone { <-3.9,0,0> 11 <-32.1,0,0> 12 }
  }
  cylinder { <4,0,0> <39,0,0> 8.5 open }
  cylinder { <38,0,0> <58,0,0> 8 open }
  intersection { // oculaire
    cylinder { <59,0,0> <58,0,0> 2.5 }
    sphere { <39,0,0> 20 }
    texture { NBglass } 
  }
  intersection { // objectif
    cylinder { <-28,0,0> <-25,0,0> 12 }
    sphere { <22,0,0> 50 }
    texture { NBglass } 
  }
  difference { // bague d'objectif
    union {
      cylinder { <-32,0,0> <-34,0,0> 13.5 }
      cylinder { <-32,0,0> <-28,0,0> 11 }
    }
    cylinder { <-35,0,0> <-27,0,0> 9 }
    cone { <-34.1,0,0> 10 <-33,0,0> 9 }
    // rainures
    #declare RainureCount = 0;
    #while (RainureCount < 360)
      box { <-35,-0.5,-0.5> <-31,0.5,0.5> rotate 45*x translate <0,13.5,0> rotate RainureCount*x }
      #declare RainureCount = RainureCount+4;
    #end
  }
  cylinder { <0,-29,0> <0,-27,0> 8 }
  cone { <0,-27,0> 7.5 <0,-13,0> 4.5 }
  cylinder { <0,-33,0> <0,-35,0> 10 }
  object { VisA rotate 180*x translate <0,-35,0> }
  rotate 45*y
  translate <0,33,-60>  
  rotate -47*y
  texture { Laiton }
}

//-----------------------------------------------------------------------------                 
#declare FiltreA =
union {
  cylinder { <0,0,0> <2,0,0> 5 }
  difference {
    box { <0,-3,-3> <2,43,36> }
    cylinder { <-1,28,20> <3,28,20> 13 }
    box { <-1,10,13> <3,-5,40> }
  }
  cylinder { <0,28,20> <2,28,20> 13 texture { T_Green_Glass } }
  texture { Laiton }
}

#declare FiltreB =
union {
  cylinder { <0,0,0> <2,0,0> 5 }
  difference {
    box { <0,-3,-3> <2,43,36> }
    cylinder { <-1,28,20> <3,28,20> 13 }
    box { <-1,10,13> <3,-5,40> }
  }
  cylinder { <0,28,20> <2,28,20> 13 texture { T_Yellow_Glass } }
  texture { Laiton }
}

#declare FiltreC =
union {
  cylinder { <0,0,0> <2,0,0> 5 }
  difference {
    box { <0,-3,-3> <2,43,36> }
    cylinder { <-1,28,20> <3,28,20> 13 }
    box { <-1,10,13> <3,-5,40> }
  }
  cylinder { <0,28,20> <2,28,20> 13 texture { T_Old_Glass } }
  texture { Laiton }
}

//-----------------------------------------------------------------------------                 
#declare Miroir1 =
union {
  difference {
    cylinder { <0,0,0> <-7,0,0> 22 }
    cylinder { <-1,0,0> <-8,0,0> 19.1 } 
  }
  cylinder { <-1.1,0,0> <-6.5,0,0> 19 texture { NBglass } }
  cylinder { <-1.01,0,0> <-1,0,0> 19 texture { Mirror } } 
  box { <0,-24,-11> < 2,-7,11> }
  box { <0,-24,-11> <16,-22,11> }
  object { VisB rotate -90*z translate <2,-10, 8> }
  object { VisB rotate -90*z translate <2,-10,-8> }
  object { VisB translate <10,-22, 8> }
  object { VisB translate <10,-22,-8> }
  translate <0,33,0>
  texture { Laiton }
}

//-----------------------------------------------------------------------------                 
#declare Miroir2 =
union {
  difference {
    cylinder { <0,0,0> <-7,0,0> 22 }
    cylinder { <-1,0,0> <-8,0,0> 19.1 }
    difference {
      cylinder { <1,0,0> <-8,0,0> 19.1 }
      box { <2,0,23> <-9,-23,-23> }
    }
  }
  cylinder { <-1.2,0,0> <-6.5,0,0> 19 texture { NBglass } }
  intersection {
    cylinder { <-6.5,0,0> <-6.51,0,0> 19 texture { Mirror } } 
    box { <2,0,23> <-9,-23,-23> }
  }
  difference {
    box { <0,-29,-13> <-7,-15,13> }
    cylinder { <-1,0,0> <-8,0,0> 22 }
  }
  object { VisB rotate 180*x translate <0,-35, 4> }
  object { VisB rotate -90*z translate <0,-35,-4> }
  difference {
    union {
      box { <4,-33,-14> <-45,-29,-2> }
      box { <4,-33,-14> <-20,-29,15> }
      box { <-10,-33,-14> <-30,-29,15> }
    }
    cylinder { <-19,-34,-14> <-19,-28,-14> 6 }
  }
  object { VisB translate <-30,-29,-10> }
  object { VisB translate <-40,-29,-10> }
  box { <-26,-33.1,-15> <-44,-37,-6> }        //
  box { <-26,-37,-15> <-31,-25,-25> }         // support filtres astre
  cylinder { <-26,-25,-20> <-31,-25,-20> 5 }  //
  object { FiltreA rotate 180*y rotate -10*x translate <-32,-25,-20> }
  object { FiltreB rotate 180*y rotate  20*x translate <-35,-25,-20> }
  object { FiltreC rotate 180*y rotate  50*x translate <-38,-25,-20> }
  cylinder { <-31,-25,-20> <-40.5,-25,-20> 4 texture { T_Wood20 } } // rondelles fibre
  object { VisB rotate 90*z translate <-40.5,-25,-20> }
  rotate -200*y
  translate <-66,33,-50>
  texture { Laiton }
}

//-----------------------------------------------------------------------------                 
#declare Arc =
union {
  difference {
    cylinder { < 0, 5, 0> < 0, 6.01, 0> 148 }
    cylinder { < 0, 3, 0> < 0, 7, 0> 141 }
    box { < 153, 3, 0> <-153, 7,-153> rotate -135.1*y }
    box { < 153, 3, 0> <-153, 7, 153> rotate -44.9*y }
    }
    union {
    #declare Trait=0;
    #while (Trait <= 130)
      cylinder { <0,6.01,-144> <0,6.01,-147.5> 0.1 rotate (Trait/2-32.5)*y }
      //text { ttf "timrom.ttf" str(Trait,3,0) 0.2, 0 scale 2 rotate 90*x translate <0,6.1,-145> rotate (Trait/2-32.5)*y }
      #declare Trait=Trait+10;
    #end
    #declare Trait=0;
    #while (Trait < 130)
      cylinder { <0,6.01,-145> <0,6.01,-147.5> 0.1 rotate (Trait/2-32.5)*y }
      #declare Trait=Trait+5;
    #end
    #declare Trait=0;
    #while (Trait < 130)
      cylinder { <0,6.01,-146> <0,6.01,-147.5> 0.1 rotate (Trait/2-32.5)*y }
      #declare Trait=Trait+1;
    #end
  
  #declare Trait=0;
  #while (Trait <= 130)
    text { ttf "timrom.ttf" str(Trait,3,0) 0.2, 0 scale 3 rotate 90*x translate <0,6.1,-145> rotate (Trait/2-32.5)*y }
    #declare Trait=Trait+10;
  #end
  pigment { Black }
  }
  texture { T_Chrome_4B }
}

//-----------------------------------------------------------------------------                 
#declare Pied =
union {
  cylinder { <0,2,-132> <0,-35,-132> 2.8 }
  cone { <0,-35,-132> 2.8 <0,-38,-132> 2.2 }
  texture { Laiton }
}

//-----------------------------------------------------------------------------                 
#declare Poignee =
union {
  cylinder { <0,0,-25> <0,-18,-25> 5 }
  cylinder { <0,0,-118> <0,-18,-118> 5 }
  cylinder { <0,-25,-25> <0,-25,-118> 8 }
  cylinder { <0,-25,-24.9> <0,-25,-22> 8 }
  cone { <0,-25,-22> 8 <0,-25,-14> 0.1 }
  cylinder { <0,-25,-118.1> <0,-25,-121> 8 }
  cone { <0,-25,-121> 8 <0,-25,-129> 0.1 }
  object { VisA translate <0,0.8, -25> }
  object { VisA translate <0,0.8,-118> }
  texture { Laiton }
}

//-----------------------------------------------------------------------------                 
#declare Loupe =
union {
  box { <-4,9,-116> <4,11,-128> }
  box { <-4,9,0> <4,12,-25> rotate 45*x translate <0,0,-132> }
  difference {
    cylinder { <0,24,-150> <0,28,-150> 8.5 }
    cylinder { <0,23,-150> <0,29,-150> 5.5 }
    cylinder { <0,25,-150> <0,29,-150> 8.0 }
  }
  intersection { // objectif
    cylinder { <0,25.1,-150> <0,28,-150> 7.9 }
    sphere { <0,-12,-150> 40 }
    texture { NBglass } 
  }
  cone { <0,11,-120> 3.5 <0,21,-120> 2 }
  difference {
    intersection {
      cylinder { <0,21,-120> <0,24,-120> 4 }
      sphere { <0,4,-120> 20 }
    }
    // rainures
    #declare RainureCount = 0;
    #while (RainureCount < 360)
      box { <-0.5,20,-0.5> <0.5,25,0.5> rotate 45*y translate <4,0,0> rotate RainureCount*y translate <0,0,-120> }
      #declare RainureCount = RainureCount+8;
    #end
  }
  texture { Laiton }
}

//-----------------------------------------------------------------------------                 
#declare Bras =
union {
  cylinder { <0,5,0> <0,9,0> 17 }
  difference {
    box { <-9,5,-15> <9,9,-120> }
    box { <-9,4.9,-15> <-20,9.1,-121> rotate -2.5*y }
    box { < 9,4.9,-15> < 20,9.1,-121> rotate  2.5*y }
  }
  difference {
    union {
      box { <-23,5,-120> < 23,9,-175> }
      cylinder { <0,5,-170> <0,9,-170> 9 }
    }
    cylinder { <-19,4,-120> <-19,10,-120> 13 }
    cylinder { < 19,4,-120> < 19,10,-120> 13 }
    box { <-13,4,-138> < 13,10,-152> }
    box { <0,4,-180> <-10,10,-120> rotate  8*y }
    box { <0,4,-180> < 10,10,-120> rotate -8*y }
    cylinder { <-35,4,-190> <-35,10,-190> 31.4 }
    cylinder { < 35,4,-190> < 35,10,-190> 31.4 }
    cylinder { <-15,4,-160> <-15,10,-160> 2.4 }
    cylinder { < 15,4,-160> < 15,10,-160> 2.4 }
  }
  object { VisA translate <0,9,-170> }
  object { Miroir1 }
  object { Loupe }
  texture { Laiton }
}

//-----------------------------------------------------------------------------                 
//-----------------------------------------------------------------------------                 
#declare Sextant =
union {
  object { Corps }
  object { Lunette }
  object { Miroir2 }
  object { Arc }
  object { Pied rotate  38*y }
  object { Pied rotate -38*y }
  object { Poignee }
  object { Bras rotate 15*y }
}
 
object { Sextant rotate 60*y rotate -0*x translate <0, 0, 0> } 
 
/*
cylinder { -100*x,  100*x,  0.001 texture { Red_Plastic } no_shadow }
cylinder { -100*y,  100*y,  0.001 texture { Blue_Plastic } no_shadow }
cylinder { -100*z,  100*z,  0.001 texture { Green_Plastic } no_shadow }
*/
