// reorient macro from www.twysted.net

#macro Reorient(Axis1,Axis2)

	#local vX1=vnormalize(Axis1);
	#local vX2=vnormalize(Axis2);
	#local vY=vnormalize(vcross(vX1,vX2));
	#local vZ1=vnormalize(vcross(vX1,vY));
	#local vZ2=vnormalize(vcross(vX2,vY));
	matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
	matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >

#end

// background image macro

#macro BACKGROUND (Eye_Point,Look_Point,Image_Name)     

	// global user variables
	#ifndef (Image_Ratio)
		#declare Image_Ratio = .75;
	#end
	
	#ifndef (View_Ratio)
		#declare View_Ratio = .74;
	#end
	
	#ifndef (Image_Type)
		#declare Image_Type = 1;
	#end   
	
	#ifndef (Map_Distance)
		#declare Map_Distance = 100000;
	#end   
	
	#ifndef (Map_Options)
		#declare Map_Options = 0;
	#end

	#ifndef (Map_Rotate)
		#declare Map_Rotate = 0;
	#end

	// local variables
	#local View_Normal = vnormalize(Look_Point - Eye_Point);
	
	#local X1 = View_Normal.x;
	#local X2 = View_Normal.y;
	#local X3 = View_Normal.z;
	
	#if (X1 = 0)
		#if (X2 = 0)
			#if (X3 = 1)
				#local X4 = 1;
			#else
				#local X4 = 0;
			#end
		#else
			#local X4 = 0;
		#end
	#else
		#local X4 = 0;
	#end    
	
	#local Initial_Normal = <0,0,1>;  
	#local Scale_Factor1 = <1,Image_Ratio,.1>;     

	#local Scale_Factor2 = (vlength(Look_Point - Eye_Point) * Map_Distance);

	#local Scale_Factor3 = (Scale_Factor1 * Scale_Factor2);

	box {<0,0,0><1,1,1>
		texture{pigment{
			#if (Image_Type = 1)
				image_map {tga Image_Name}
			#end 
			#if (Image_Type = 2)
				image_map {gif Image_Name}
			#end
			#if (Map_Options = 1)
				interpolate 1
			#end
			#if (Map_Options = 2)
				interpolate 2
			#end
		}}
		finish {ambient .7 diffuse 0}
		translate <-.5,-.5,0>
		scale Scale_Factor3  
		
		#if (Map_Rotate != 0)
			rotate <0,0,Map_Rotate>
		#end
		
		#if (X4 = 0)		
			Reorient(Initial_Normal,View_Normal)
		#end

		translate (Look_Point + (View_Normal * (Scale_Factor2 * View_Ratio)))
	}

#end  

// eof