/*
#include "colors.inc"


camera {
	location <0,1.25,-5>
	look_at  <0,1.25,0>
}


light_source {<50,100,-200> color White}  
light_source {<0.1,1.25,-5> Gray30 shadowless}

*/

#include "sandy.inc"
#include "stones.inc"
#include "skies.inc"

#declare Part_Landform1 = 
height_field
{
  tga               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "land4.tga"     // the file name to read
  translate <-.5,0,-.5>
  scale <10,1,10>
  translate <0,0,6.5> 
  texture{T_Grassy1}	
}

#declare Landform =
union {

height_field
{
  tga               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "land3a.tga"     // the file name to read
  translate <-.5,0,-.5>
  scale <20,.2,5>
  translate <0,-.2,-1> 
  texture{Sandy scale <2,.5,.5>}
  finish {crand .2}
  normal {bumps .5 scale .05}	
} 



height_field
{
  tga               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "land5.tga"     // the file name to read
  translate <-.5,0,-.5>
  scale <50,2,30>
  translate <-5,0,27.5> 
  texture{Sandy scale 5}	
} 

#if (Land_Speed_Switch = off)

object {Part_Landform1 translate <5,0,0>} 
object {Part_Landform1 translate <-5,0,0>}
object {Part_Landform1 translate <-15,0,0>}  

object {Part_Landform1 translate <5,0,10>} 
object {Part_Landform1 translate <-5,0,10>}
object {Part_Landform1 translate <-15,0,10>}
object {Part_Landform1 translate <-25,0,10>} 
object {Part_Landform1 translate <-35,0,10>} 

object {Part_Landform1 translate <5,0,20>} 
object {Part_Landform1 translate <-5,0,20>}
object {Part_Landform1 translate <-15,0,20>}
object {Part_Landform1 translate <-25,0,20>} 
object {Part_Landform1 translate <-35,0,20>} 

#end

box {<-20,0,0><20,-2,20> 
  texture{Sandy scale <2,.5,.5>}
  finish {crand .2}
  normal {bumps .5 scale .05}	
} 
 
//sphere {<0,0,1.5>,.25 pigment{Red}}   
//sphere {<0,0,-1.75>,.25 pigment{Red}} 
//sphere {<-6,0,0>,.25 pigment{Red}}
//sphere {<3,0,0>,.25 pigment{Red}} 
// object{Plant1 scale .001}   

#declare Rand13 = seed(13);

#if (Land_Speed_Switch = off)

#include "plants1.inc"

// weed locator

	#local Limit = 200;
	#local Count1 = 0; 
	#local Xrange = 10;
	#local Xmin = -7;
	#local Yrange = 0.1;
	#local Ymin = -0.1;
	#local Zrange = 3;
	#local Zmin = -2;
	

#while (Count1 < Limit) 

	#local Xpoint = rand(Rand13);
	#local Ypoint = 0;
	#local Zpoint = rand(Rand13);
	
	#local Xpoint = ((Xpoint * Xrange) + Xmin);
	#local Zpoint = ((Zpoint * Zrange) + Zmin);

	
	#local Type = int(rand(Rand13) * 11);
	
	#if (Type = 0)object {Plant1 scale .003 rotate <0,(360 * rand(Rand13)),0> translate <Xpoint,Ypoint,Zpoint>} #end
	#if (Type = 1)object {Plant2 scale .004 rotate <0,(360 * rand(Rand13)),0> translate <Xpoint,Ypoint,Zpoint>} #end
	#if (Type = 2)object {Plant3 scale .002 rotate <0,(360 * rand(Rand13)),0> translate <Xpoint,Ypoint,Zpoint>} #end
	#if (Type = 3)object {Plant4 scale .005 rotate <0,(360 * rand(Rand13)),0> translate <Xpoint,Ypoint,Zpoint>} #end
	#if (Type = 4)object {Plant5 scale .005 rotate <0,(360 * rand(Rand13)),0> translate <Xpoint,Ypoint,Zpoint>} #end
	#if (Type = 5)object {Plant6 scale .011 rotate <0,(360 * rand(Rand13)),0> translate <Xpoint,Ypoint,Zpoint>} #end
	#if (Type = 6)object {Plant7 scale .005 rotate <0,(360 * rand(Rand13)),0> translate <Xpoint,Ypoint,Zpoint>} #end
	#if (Type = 7)object {Plant8 scale .005 rotate <0,(360 * rand(Rand13)),0> translate <Xpoint,Ypoint,Zpoint>} #end
	#if (Type = 8)object {Plant9 scale .007 rotate <0,(360 * rand(Rand13)),0> translate <Xpoint,Ypoint,Zpoint>} #end
	#if (Type = 9)object {Plant10 scale .005 rotate <0,(360 * rand(Rand13)),0> translate <Xpoint,Ypoint,Zpoint>} #end
	#if (Type = 10)object {Plant11 scale .005 rotate <0,(360 * rand(Rand13)),0> translate <Xpoint,Ypoint,Zpoint>} #end
	
	#local Count1 = (Count1 + 1);

#end

// grass locator

	#local Limit = 900;
	#local Count1 = 0; 
	#local Xrange = 10;
	#local Xmin = -7;
	#local Yrange = 0.1;
	#local Ymin = -0.1;
	#local Zrange = 3.5;
	#local Zmin = -2;
	

#while (Count1 < Limit) 

	#local Xpoint = rand(Rand13);
	#local Ypoint = rand(Rand13);
	#local Zpoint = rand(Rand13);
	
	#local Xpoint = ((Xpoint * Xrange) + Xmin);
	#local Ypoint = ((Ypoint * Yrange) + Ymin);
	#local Zpoint = ((Zpoint * Zrange) + Zmin);
	
	cone {<Xpoint,Ypoint,Zpoint>,.005,
		<(Xpoint + (rand(Rand13) * .05)),(Ypoint + (rand(Rand13) * .8)),(Zpoint + (rand(Rand13) * .05))>,0 
		texture{T_Grassy1}
	}
	
	#local Count1 = (Count1 + 1);

#end

//sphere {<0,0,-1.5>,.2 pigment{Blue}}
//sphere {<0,0,-3>,.2 pigment{Blue}} 

// pebble locator

	#local Limit = 2000;
	#local Count1 = 0; 
	#local Xrange = 4;
	#local Xmin = -3;
	#local Yrange = 0.05;
	#local Ymin = -0.1;
	#local Zrange = 1.5;
	#local Zmin = -3;
	#local RadMax = .05;
	

#while (Count1 < Limit) 

	#local Xpoint = rand(Rand13);
	#local Ypoint = rand(Rand13);
	#local Zpoint = rand(Rand13);
	
	#local Xpoint = ((Xpoint * Xrange) + Xmin);
	#local Ypoint = ((Ypoint * Yrange) + Ymin);
	#local Zpoint = ((Zpoint * Zrange) + Zmin);

	#local Type = int(rand(Rand13) * 4);
	
	#if (Type = 1)
	sphere {<0,0,0>,(RadMax * rand(Rand13)) scale <1,.1,1> translate <Xpoint,Ypoint,Zpoint> 
	texture{T_Stone2 scale .01}}
	#end
	
	#if (Type = 2)
	sphere {<0,0,0>,(RadMax * rand(Rand13)) scale <1,.1,1> translate <Xpoint,Ypoint,Zpoint> 
	texture{T_Stone6 scale .01}}
	#end
	
	#if (Type = 3)
	sphere {<0,0,0>,(RadMax * rand(Rand13)) scale <1,.1,1> translate <Xpoint,Ypoint,Zpoint> 
	texture{T_Stone11 scale .01}}
	#end 
	
	#if (Type = 0)
	sphere {<0,0,0>,(RadMax * rand(Rand13)) scale <1,.1,1> translate <Xpoint,Ypoint,Zpoint> 
	texture{T_Stone16 scale .01}}
	#end
	
	#local Count1 = (Count1 + 1);

#end 

#end

plane {y,-.055 
	pigment{rgbft<.7,.75,.85,.5,.4>}
	finish{phong 1 reflection .5}
//	normal {agate .05 scale .05}
}

}

object {Landform rotate <0,30,0>} 
sky_sphere {S_Cloud1}  



/// temp stuff
// pebble locator

	#local Limit = 2000;
	#local Count1 = 0; 
	#local Xrange = 4;
	#local Xmin = -3;
	#local Yrange = 0.05;
	#local Ymin = -0.1;
	#local Zrange = 1.5;
	#local Zmin = -3;
	#local RadMax = .05;
	

#while (Count1 < Limit) 

	#local Xpoint = rand(Rand13);
	#local Ypoint = rand(Rand13);
	#local Zpoint = rand(Rand13);
	
	#local Xpoint = ((Xpoint * Xrange) + Xmin);
	#local Ypoint = ((Ypoint * Yrange) + Ymin);
	#local Zpoint = ((Zpoint * Zrange) + Zmin);

	#local Type = int(rand(Rand13) * 4);
	
	#if (Type = 1)
	sphere {<0,0,0>,(RadMax * rand(Rand13)) scale <1,.1,1> translate <Xpoint,Ypoint,Zpoint> 
	texture{T_Stone2 scale .01}}
	#end
	
	#if (Type = 2)
	sphere {<0,0,0>,(RadMax * rand(Rand13)) scale <1,.1,1> translate <Xpoint,Ypoint,Zpoint> 
	texture{T_Stone6 scale .01}}
	#end
	
	#if (Type = 3)
	sphere {<0,0,0>,(RadMax * rand(Rand13)) scale <1,.1,1> translate <Xpoint,Ypoint,Zpoint> 
	texture{T_Stone11 scale .01}}
	#end 
	
	#if (Type = 0)
	sphere {<0,0,0>,(RadMax * rand(Rand13)) scale <1,.1,1> translate <Xpoint,Ypoint,Zpoint> 
	texture{T_Stone16 scale .01}}
	#end
	
	#local Count1 = (Count1 + 1);

#end 
