// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio

#declare Plant1 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.08419, 7.6284, 0.1672>, 0.3 }
		cylinder { <-0.08419, 7.6284, 0.1672>, <-0.2525, 15.2499, 0.5017>, 0.3 }
		cylinder { <-0.2525, 15.2499, 0.5017>, <-0.5049, 22.8599, 1.003123>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.5049, 22.8599, 1.003123>, <-0.5806, 23.6101, 1.1535>, 0.2496 }
			cylinder { <-0.5806, 23.6101, 1.1535>, <-0.705, 24.3274, 1.4007>, 0.2496 }
			cylinder { <-0.705, 24.3274, 1.4007>, <-0.8754, 24.9964, 1.7392>, 0.2496 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // seedling leaf
			triangle { <-0.8754, 24.9964, 1.7392>, <0.3573, 28.2131, 6.0619>, <-1.9435, 29.3769, 3.8611> }
			triangle { <-1.9435, 29.3769, 3.8611>, <0.3573, 28.2131, 6.0619>, <-0.884, 30.6697, 7.7073> }
			triangle { <-1.9435, 29.3769, 3.8611>, <-0.884, 30.6697, 7.7073>, <-3.3628, 32.8905, 6.6809> }
			triangle { <-3.3628, 32.8905, 6.6809>, <-0.884, 30.6697, 7.7073>, <-2.8202, 33.3002, 9.7069> }
			triangle { <-3.3628, 32.8905, 6.6809>, <-2.8202, 33.3002, 9.7069>, <-4.517, 34.9378, 9.1791> }
			triangle { <-4.517, 34.9378, 9.1791>, <-2.8202, 33.3002, 9.7069>, <-6.06288, 36.7016, 12.25> }
			triangle { <-6.07582, 33.1397, 7.9664>, <-4.517, 34.9378, 9.1791>, <-6.06288, 36.7016, 12.25> }
			triangle { <-6.07582, 33.1397, 7.9664>, <-3.3628, 32.8905, 6.6809>, <-4.517, 34.9378, 9.1791> }
			triangle { <-6.07582, 33.1397, 7.9664>, <-5.5298, 30.8409, 5.24>, <-3.3628, 32.8905, 6.6809> }
			triangle { <-3.3628, 32.8905, 6.6809>, <-5.5298, 30.8409, 5.24>, <-1.9435, 29.3769, 3.8611> }
			triangle { <-1.9435, 29.3769, 3.8611>, <-5.5298, 30.8409, 5.24>, <-4.9013, 28.4405, 2.9654> }
			triangle { <-1.9435, 29.3769, 3.8611>, <-4.9013, 28.4405, 2.9654>, <-0.8754, 24.9964, 1.7392> }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.5049, 22.8599, 1.003123>, <-0.4794, 23.6267, 0.9526>, 0.2496 }
			cylinder { <-0.4794, 23.6267, 0.9526>, <-0.4037, 24.3769, 0.8021>, 0.2496 }
			cylinder { <-0.4037, 24.3769, 0.8021>, <-0.2793, 25.09425, 0.5549>, 0.2496 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // seedling leaf
			triangle { <-0.2793, 25.09425, 0.5549>, <-1.7995, 28.7883, -3.2653>, <0.4901, 29.7758, -0.9687> }
			triangle { <0.4901, 29.7758, -0.9687>, <-1.7995, 28.7883, -3.2653>, <-0.7385, 31.5126, -4.5827> }
			triangle { <0.4901, 29.7758, -0.9687>, <-0.7385, 31.5126, -4.5827>, <1.64, 33.7148, -3.3085> }
			triangle { <1.64, 33.7148, -3.3085>, <-0.7385, 31.5126, -4.5827>, <0.9971, 34.4973, -6.24> }
			triangle { <1.64, 33.7148, -3.3085>, <0.9971, 34.4973, -6.24>, <2.6143, 36.1444, -5.5248> }
			triangle { <2.6143, 36.1444, -5.5248>, <0.9971, 34.4973, -6.24>, <3.9802, 38.3938, -8.3542> }
			triangle { <4.3007, 34.2926, -4.5973>, <2.6143, 36.1444, -5.5248>, <3.9802, 38.3938, -8.3542> }
			triangle { <4.3007, 34.2926, -4.5973>, <1.64, 33.7148, -3.3085>, <2.6143, 36.1444, -5.5248> }
			triangle { <4.3007, 34.2926, -4.5973>, <3.9533, 31.6187, -2.2004>, <1.64, 33.7148, -3.3085> }
			triangle { <1.64, 33.7148, -3.3085>, <3.9533, 31.6187, -2.2004>, <0.4901, 29.7758, -0.9687> }
			triangle { <0.4901, 29.7758, -0.9687>, <3.9533, 31.6187, -2.2004>, <3.5174, 28.9005, -0.2634> }
			triangle { <0.4901, 29.7758, -0.9687>, <3.5174, 28.9005, -0.2634>, <-0.2793, 25.09425, 0.5549> }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		}
	union { // internode
		cylinder { <-0.5049, 22.8599, 1.003123>, <-0.5826, 30.4778, 1.4373>, 0.3 }
		cylinder { <-0.5826, 30.4778, 1.4373>, <-0.4857, 38.09914, 1.804>, 0.3 }
		cylinder { <-0.4857, 38.09914, 1.804>, <-0.2142, 45.7191, 2.103>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.2142, 45.7191, 2.103>, <0.04983, 47.2319, 2.08104>, 0.2493 }
			cylinder { <0.04983, 47.2319, 2.08104>, <0.5176, 48.6912, 1.9772>, 0.2493 }
			cylinder { <0.5176, 48.6912, 1.9772>, <1.179, 50.06522, 1.7939>, 0.2493 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <1.179, 50.06522, 1.7939>, <4.1018, 55.3149, -3.9047>, <4.278, 56.8044, 0.9475> }
			triangle { <4.278, 56.8044, 0.9475>, <4.1018, 55.3149, -3.9047>, <7.007216, 59.1288, -4.2123> }
			triangle { <4.278, 56.8044, 0.9475>, <7.007216, 59.1288, -4.2123>, <8.5255, 62.3104, -0.3653> }
			triangle { <8.5255, 62.3104, -0.3653>, <7.007216, 59.1288, -4.2123>, <11.02321, 63.2267, -4.1749> }
			triangle { <8.5255, 62.3104, -0.3653>, <11.02321, 63.2267, -4.1749>, <12.2356, 65.5971, -1.7216> }
			triangle { <12.2356, 65.5971, -1.7216>, <11.02321, 63.2267, -4.1749>, <16.9767, 68.5097, -3.3195> }
			triangle { <12.7857, 62.7665, 1.05285>, <12.2356, 65.5971, -1.7216>, <16.9767, 68.5097, -3.3195> }
			triangle { <12.7857, 62.7665, 1.05285>, <8.5255, 62.3104, -0.3653>, <12.2356, 65.5971, -1.7216> }
			triangle { <12.7857, 62.7665, 1.05285>, <9.5169, 59.07231, 3.2625>, <8.5255, 62.3104, -0.3653> }
			triangle { <8.5255, 62.3104, -0.3653>, <9.5169, 59.07231, 3.2625>, <4.278, 56.8044, 0.9475> }
			triangle { <4.278, 56.8044, 0.9475>, <9.5169, 59.07231, 3.2625>, <6.6287, 55.2714, 4.8885> }
			triangle { <4.278, 56.8044, 0.9475>, <6.6287, 55.2714, 4.8885>, <1.179, 50.06522, 1.7939> }
			pigment { color rgb <0.0, 0.5, 0.0> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-0.2142, 45.7191, 2.103>, <1.6254, 53.1894, 1.7868>, 0.15 }
			cylinder { <1.6254, 53.1894, 1.7868>, <4.9414, 60.07784, 0.8679>, 0.15 }
			cylinder { <4.9414, 60.07784, 0.8679>, <9.5725, 66.04956, -0.6088>, 0.15 }
			pigment { color rgb <0.0078, 0.58, 0.0> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.7348, 65.3283, -0.3936>, 0.15 }
				cylinder { <9.7348, 65.3283, -0.3936>, <9.9192, 64.6357, -0.112>, 0.15 }
				cylinder { <9.9192, 64.6357, -0.112>, <10.124, 63.9786, 0.233>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.7956, 65.4341, -0.2034>, 0.15 }
				cylinder { <9.7956, 65.4341, -0.2034>, <10.03492, 64.8663, 0.2583>, 0.15 }
				cylinder { <10.03492, 64.8663, 0.2583>, <10.2881, 64.3516, 0.772>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.8371, 65.5929, -0.04819>, 0.15 }
				cylinder { <9.8371, 65.5929, -0.04819>, <10.1107, 65.1988, 0.554>, 0.15 }
				cylinder { <10.1107, 65.1988, 0.554>, <10.3905, 64.8709, 1.1921>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.8559, 65.7911, 0.05878>, 0.15 }
				cylinder { <9.8559, 65.7911, 0.05878>, <10.1401, 65.6045, 0.7496>, 0.15 }
				cylinder { <10.1401, 65.6045, 0.7496>, <10.4225, 65.4917, 1.457>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.8502, 66.01152, 0.1082>, 0.15 }
				cylinder { <9.8502, 66.01152, 0.1082>, <10.1207, 66.04864, 0.8282>, 0.15 }
				cylinder { <10.1207, 66.04864, 0.8282>, <10.3813, 66.1605, 1.5441>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.8172, 66.2533, 0.09215>, 0.15 }
				cylinder { <9.8172, 66.2533, 0.09215>, <10.04659, 66.5285, 0.7737>, 0.15 }
				cylinder { <10.04659, 66.5285, 0.7737>, <10.2583, 66.8725, 1.4293>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.7647, 66.4589, 0.01432>, 0.15 }
				cylinder { <9.7647, 66.4589, 0.01432>, <9.9353, 66.9297, 0.5992>, 0.15 }
				cylinder { <9.9353, 66.9297, 0.5992>, <10.08299, 67.4575, 1.1401>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.6956, 66.6291, -0.1171>, 0.15 }
				cylinder { <9.6956, 66.6291, -0.1171>, <9.7929, 67.255, 0.3206>, 0.15 }
				cylinder { <9.7929, 67.255, 0.3206>, <9.8636, 67.9212, 0.7002>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.6159, 66.7495, -0.291>, 0.15 }
				cylinder { <9.6159, 66.7495, -0.291>, <9.6315, 67.4766, -0.038>, 0.15 }
				cylinder { <9.6315, 67.4766, -0.038>, <9.6192, 68.2237, 0.1477>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.5324, 66.8096, -0.4922>, 0.15 }
				cylinder { <9.5324, 66.8096, -0.4922>, <9.465, 67.5752, -0.4457>, 0.15 }
				cylinder { <9.465, 67.5752, -0.4457>, <9.3708, 68.339, -0.47>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.4462, 66.8008, -0.721>, 0.15 }
				cylinder { <9.4462, 66.8008, -0.721>, <9.2955, 67.5338, -0.9022>, 0.15 }
				cylinder { <9.2955, 67.5338, -0.9022>, <9.1219, 68.2415, -1.1509>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.3777, 66.7252, -0.9226>, 0.15 }
				cylinder { <9.3777, 66.7252, -0.9226>, <9.1635, 67.3622, -1.2983>, 0.15 }
				cylinder { <9.1635, 67.3622, -1.2983>, <8.932, 67.9546, -1.7325>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.326, 66.5914, -1.09724>, 0.15 }
				cylinder { <9.326, 66.5914, -1.09724>, <9.06678, 67.07766, -1.6351>, 0.15 }
				cylinder { <9.06678, 67.07766, -1.6351>, <8.7973, 67.5035, -2.2172>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.2955, 66.411, -1.2298>, 0.15 }
				cylinder { <9.2955, 66.411, -1.2298>, <9.01357, 66.7045, -1.8834>, 0.15 }
				cylinder { <9.01357, 66.7045, -1.8834>, <8.7294, 66.9272, -2.5635>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.2888, 66.1994, -1.3088>, 0.15 }
				cylinder { <9.2888, 66.1994, -1.3088>, <9.008508, 66.2749, -2.02203>, 0.15 }
				cylinder { <9.008508, 66.2749, -2.02203>, <8.734, 66.2754, -2.7414>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.3092, 65.9562, -1.3264>, 0.15 }
				cylinder { <9.3092, 65.9562, -1.3264>, <9.05774, 65.7889, -2.0347>, 0.15 }
				cylinder { <9.05774, 65.7889, -2.0347>, <8.8204, 65.5491, -2.7268>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.3517, 65.7396, -1.2782>, 0.15 }
				cylinder { <9.3517, 65.7396, -1.2782>, <9.1495, 65.3625, -1.9184>, 0.15 }
				cylinder { <9.1495, 65.3625, -1.9184>, <8.9678, 64.9219, -2.5232>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.4132, 65.5496, -1.1724>, 0.15 }
				cylinder { <9.4132, 65.5496, -1.1724>, <9.2777, 64.9952, -1.6894>, 0.15 }
				cylinder { <9.2777, 64.9952, -1.6894>, <9.1673, 64.3918, -2.1547>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.4884, 65.4027, -1.01812>, 0.15 }
				cylinder { <9.4884, 65.4027, -1.01812>, <9.4313, 64.7188, -1.3673>, 0.15 }
				cylinder { <9.4313, 64.7188, -1.3673>, <9.4017, 64.00448, -1.6531>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.5708, 65.3115, -0.8285>, 0.15 }
				cylinder { <9.5708, 65.3115, -0.8285>, <9.597, 64.557, -0.9799>, 0.15 }
				cylinder { <9.597, 64.557, -0.9799>, <9.6508, 63.7932, -1.06155>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.5725, 66.04956, -0.6088>, <9.6601, 65.2845, -0.6023>, 0.15 }
				cylinder { <9.6601, 65.2845, -0.6023>, <9.7738, 64.5269, -0.5252>, 0.15 }
				cylinder { <9.7738, 64.5269, -0.5252>, <9.9124, 63.7839, -0.3784>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		}
	union { // internode
		cylinder { <-0.2142, 45.7191, 2.103>, <-0.1175, 53.3457, 2.3351>, 0.3 }
		cylinder { <-0.1175, 53.3457, 2.3351>, <-0.1955, 60.9742, 2.5>, 0.3 }
		cylinder { <-0.1955, 60.9742, 2.5>, <-0.4484, 68.6001, 2.5976>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.4484, 68.6001, 2.5976>, <-0.7041, 70.08462, 2.5373>, 0.2447 }
			cylinder { <-0.7041, 70.08462, 2.5373>, <-1.1602, 71.5148, 2.3985>, 0.2447 }
			cylinder { <-1.1602, 71.5148, 2.3985>, <-1.8067, 72.8598, 2.1845>, 0.2447 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-1.8067, 72.8598, 2.1845>, <-7.8538, 77.6585, 4.73>, <-4.8373, 79.4578, 1.1919> }
			triangle { <-4.8373, 79.4578, 1.1919>, <-7.8538, 77.6585, 4.73>, <-10.294, 81.4266, 3.2856> }
			triangle { <-4.8373, 79.4578, 1.1919>, <-10.294, 81.4266, 3.2856>, <-8.9706, 84.8382, -0.2982> }
			triangle { <-8.9706, 84.8382, -0.2982>, <-10.294, 81.4266, 3.2856>, <-13.3246, 85.5181, 0.8781> }
			triangle { <-8.9706, 84.8382, -0.2982>, <-13.3246, 85.5181, 0.8781>, <-12.6694, 88.03265, -1.5462> }
			triangle { <-12.6694, 88.03265, -1.5462>, <-13.3246, 85.5181, 0.8781>, <-17.2651, 90.864, -3.322> }
			triangle { <-11.152, 85.4654, -4.1025>, <-12.6694, 88.03265, -1.5462>, <-17.2651, 90.864, -3.322> }
			triangle { <-11.152, 85.4654, -4.1025>, <-8.9706, 84.8382, -0.2982>, <-12.6694, 88.03265, -1.5462> }
			triangle { <-11.152, 85.4654, -4.1025>, <-7.1996, 81.9398, -3.7901>, <-8.9706, 84.8382, -0.2982> }
			triangle { <-8.9706, 84.8382, -0.2982>, <-7.1996, 81.9398, -3.7901>, <-4.8373, 79.4578, 1.1919> }
			triangle { <-4.8373, 79.4578, 1.1919>, <-7.1996, 81.9398, -3.7901>, <-3.9046, 78.2767, -3.3121> }
			triangle { <-4.8373, 79.4578, 1.1919>, <-3.9046, 78.2767, -3.3121>, <-1.8067, 72.8598, 2.1845> }
			pigment { color rgb <0.0, 0.5, 0.0> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-0.4484, 68.6001, 2.5976>, <-2.2712, 76.06384, 2.08787>, 0.15 }
			cylinder { <-2.2712, 76.06384, 2.08787>, <-5.5731, 82.9334, 0.9944>, 0.15 }
			cylinder { <-5.5731, 82.9334, 0.9944>, <-10.1936, 88.8751, -0.6293>, 0.15 }
			pigment { color rgb <0.0078, 0.58, 0.0> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.1458, 88.1743, -0.9446>, 0.15 }
				cylinder { <-10.1458, 88.1743, -0.9446>, <-10.07086, 87.5072, -1.3218>, 0.15 }
				cylinder { <-10.07086, 87.5072, -1.3218>, <-9.9694, 86.8803, -1.7573>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.06686, 88.2945, -1.1189>, 0.15 }
				cylinder { <-10.06686, 88.2945, -1.1189>, <-9.9158, 87.7657, -1.6579>, 0.15 }
				cylinder { <-9.9158, 87.7657, -1.6579>, <-9.7421, 87.2938, -2.241>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-9.9988, 88.4647, -1.251>, 0.15 }
				cylinder { <-9.9988, 88.4647, -1.251>, <-9.7848, 88.1197, -1.9053>, 0.15 }
				cylinder { <-9.7848, 88.1197, -1.9053>, <-9.5536, 87.8435, -2.5859>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-9.9475, 88.6703, -1.3296>, 0.15 }
				cylinder { <-9.9475, 88.6703, -1.3296>, <-9.6889, 88.5388, -2.04291>, 0.15 }
				cylinder { <-9.6889, 88.5388, -2.04291>, <-9.4202, 88.482, -2.7622>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-9.9175, 88.8935, -1.3479>, 0.15 }
				cylinder { <-9.9175, 88.8935, -1.3479>, <-9.6365, 88.9869, -2.05874>, 0.15 }
				cylinder { <-9.6365, 88.9869, -2.05874>, <-9.3535, 89.1544, -2.7549>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-9.9117, 89.1329, -1.2979>, 0.15 }
				cylinder { <-9.9117, 89.1329, -1.2979>, <-9.6339, 89.4602, -1.9372>, 0.15 }
				cylinder { <-9.6339, 89.4602, -1.9372>, <-9.3628, 89.8538, -2.5408>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-9.9318, 89.3313, -1.1917>, 0.15 }
				cylinder { <-9.9318, 89.3313, -1.1917>, <-9.6818, 89.8457, -1.7073>, 0.15 }
				cylinder { <-9.6818, 89.8457, -1.7073>, <-9.446, 90.4133, -2.1711>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-9.9743, 89.4905, -1.03706>, 0.15 }
				cylinder { <-9.9743, 89.4905, -1.03706>, <-9.7737, 90.1476, -1.3846>, 0.15 }
				cylinder { <-9.7737, 90.1476, -1.3846>, <-9.5936, 90.8403, -1.6687>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.03584, 89.5966, -0.8472>, 0.15 }
				cylinder { <-10.03584, 89.5966, -0.8472>, <-9.9018, 90.34, -0.9968>, 0.15 }
				cylinder { <-9.9018, 90.34, -0.9968>, <-9.7929, 91.09807, -1.07671>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.1108, 89.6406, -0.6387>, 0.15 }
				cylinder { <-10.1108, 89.6406, -0.6387>, <-10.05507, 90.4061, -0.5774>, 0.15 }
				cylinder { <-10.05507, 90.4061, -0.5774>, <-10.02674, 91.1643, -0.4462>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.2, 89.6139, -0.4124>, 0.15 }
				cylinder { <-10.2, 89.6139, -0.4124>, <-10.234, 90.3292, -0.1293>, 0.15 }
				cylinder { <-10.234, 90.3292, -0.1293>, <-10.2955, 91.01399, 0.2173>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.2819, 89.5229, -0.2225>, 0.15 }
				cylinder { <-10.2819, 89.5229, -0.2225>, <-10.3961, 90.1274, 0.2405>, 0.15 }
				cylinder { <-10.3961, 90.1274, 0.2405>, <-10.5351, 90.6828, 0.7554>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.3562, 89.3761, -0.06767>, 0.15 }
				cylinder { <-10.3562, 89.3761, -0.06767>, <-10.5407, 89.8178, 0.5354>, 0.15 }
				cylinder { <-10.5407, 89.8178, 0.5354>, <-10.7453, 90.1959, 1.1742>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.4165, 89.1861, 0.03882>, 0.15 }
				cylinder { <-10.4165, 89.1861, 0.03882>, <-10.6554, 89.427, 0.73>, 0.15 }
				cylinder { <-10.6554, 89.427, 0.73>, <-10.908, 89.5953, 1.4376>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.4576, 88.9694, 0.08778>, 0.15 }
				cylinder { <-10.4576, 88.9694, 0.08778>, <-10.7303, 88.9887, 0.8076>, 0.15 }
				cylinder { <-10.7303, 88.9887, 0.8076>, <-11.00921, 88.9327, 1.5231>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.4764, 88.7261, 0.07112>, 0.15 }
				cylinder { <-10.4764, 88.7261, 0.07112>, <-10.7592, 88.504, 0.752>, 0.15 }
				cylinder { <-10.7592, 88.504, 0.752>, <-11.03942, 88.2111, 1.4066>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.4684, 88.5142, -0.007183>, 0.15 }
				cylinder { <-10.4684, 88.5142, -0.007183>, <-10.7352, 88.08886, 0.5765>, 0.15 }
				cylinder { <-10.7352, 88.08886, 0.5765>, <-10.9914, 87.6029, 1.1161>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.4368, 88.3335, -0.139>, 0.15 }
				cylinder { <-10.4368, 88.3335, -0.139>, <-10.6645, 87.7413, 0.2972>, 0.15 }
				cylinder { <-10.6645, 87.7413, 0.2972>, <-10.8747, 87.1043, 0.6752>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.3842, 88.1994, -0.3131>, 0.15 }
				cylinder { <-10.3842, 88.1994, -0.3131>, <-10.5533, 87.4915, -0.06189>, 0.15 }
				cylinder { <-10.5533, 87.4915, -0.06189>, <-10.6994, 86.7582, 0.122>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.3152, 88.1235, -0.5145>, 0.15 }
				cylinder { <-10.3152, 88.1235, -0.5145>, <-10.4111, 87.3608, -0.4698>, 0.15 }
				cylinder { <-10.4111, 87.3608, -0.4698>, <-10.4805, 86.5944, -0.4958>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-10.1936, 88.8751, -0.6293>, <-10.2288, 88.1144, -0.7432>, 0.15 }
				cylinder { <-10.2288, 88.1144, -0.7432>, <-10.2364, 87.3665, -0.9262>, 0.15 }
				cylinder { <-10.2364, 87.3665, -0.9262>, <-10.2161, 86.6386, -1.1765>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		}
	union { // internode
		cylinder { <-0.4484, 68.6001, 2.5976>, <-0.7012, 76.2259, 2.6953>, 0.3 }
		cylinder { <-0.7012, 76.2259, 2.6953>, <-0.954, 83.8518, 2.793>, 0.3 }
		cylinder { <-0.954, 83.8518, 2.793>, <-1.2069, 91.4777, 2.8906>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.2069, 91.4777, 2.8906>, <-1.1606, 92.8508, 3.09014>, 0.2253 }
			cylinder { <-1.1606, 92.8508, 3.09014>, <-1.0232, 94.1798, 3.4669>, 0.2253 }
			cylinder { <-1.0232, 94.1798, 3.4669>, <-0.7974, 95.4361, 4.01294>, 0.2253 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-0.7974, 95.4361, 4.01294>, <4.5878, 100.3117, 5.8172>, <0.2443, 101.5944, 6.5677> }
			triangle { <0.2443, 101.5944, 6.5677>, <4.5878, 100.3117, 5.8172>, <5.1701, 103.8157, 8.3152> }
			triangle { <0.2443, 101.5944, 6.5677>, <5.1701, 103.8157, 8.3152>, <1.8691, 106.666, 10.111> }
			triangle { <1.8691, 106.666, 10.111>, <5.1701, 103.8157, 8.3152>, <5.5801, 107.5922, 11.8462> }
			triangle { <1.8691, 106.666, 10.111>, <5.5801, 107.5922, 11.8462>, <3.5005, 109.7229, 13.2043> }
			triangle { <3.5005, 109.7229, 13.2043>, <5.5801, 107.5922, 11.8462>, <5.4849, 112.4642, 17.1954> }
			triangle { <1.1335, 107.1375, 14.09571>, <3.5005, 109.7229, 13.2043>, <5.4849, 112.4642, 17.1954> }
			triangle { <1.1335, 107.1375, 14.09571>, <1.8691, 106.666, 10.111>, <3.5005, 109.7229, 13.2043> }
			triangle { <1.1335, 107.1375, 14.09571>, <-1.1988, 103.7087, 11.5124>, <1.8691, 106.666, 10.111> }
			triangle { <1.8691, 106.666, 10.111>, <-1.1988, 103.7087, 11.5124>, <0.2443, 101.5944, 6.5677> }
			triangle { <0.2443, 101.5944, 6.5677>, <-1.1988, 103.7087, 11.5124>, <-2.9589, 100.1988, 9.1973> }
			triangle { <0.2443, 101.5944, 6.5677>, <-2.9589, 100.1988, 9.1973>, <-0.7974, 95.4361, 4.01294> }
			pigment { color rgb <0.0, 0.5, 0.0> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-1.2069, 91.4777, 2.8906>, <-0.696, 98.9918, 4.4931>, 0.15 }
			cylinder { <-0.696, 98.9918, 4.4931>, <0.5561, 105.9597, 7.5215>, 0.15 }
			cylinder { <0.5561, 105.9597, 7.5215>, <2.4886, 112.0427, 11.8287>, 0.15 }
			pigment { color rgb <0.0078, 0.58, 0.0> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <2.2883, 111.327, 12.03017>, 0.15 }
				cylinder { <2.2883, 111.327, 12.03017>, <2.02425, 110.6409, 12.2591>, 0.15 }
				cylinder { <2.02425, 110.6409, 12.2591>, <1.6989, 109.991, 12.5136>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <2.1051, 111.4353, 12.1062>, 0.15 }
				cylinder { <2.1051, 111.4353, 12.1062>, <1.6673, 110.8762, 12.4039>, 0.15 }
				cylinder { <1.6673, 110.8762, 12.4039>, <1.1792, 110.3709, 12.7191>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <1.955, 111.5959, 12.1583>, 0.15 }
				cylinder { <1.955, 111.5959, 12.1583>, <1.3811, 111.2121, 12.4991>, 0.15 }
				cylinder { <1.3811, 111.2121, 12.4991>, <0.7723, 110.8948, 12.8479>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <1.8508, 111.795, 12.1821>, 0.15 }
				cylinder { <1.8508, 111.795, 12.1821>, <1.1902, 111.6194, 12.5366>, 0.15 }
				cylinder { <1.1902, 111.6194, 12.5366>, <0.5132, 111.5175, 12.8889>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <1.8016, 112.0154, 12.1754>, 0.15 }
				cylinder { <1.8016, 112.0154, 12.1754>, <1.1112, 112.0632, 12.5131>, 0.15 }
				cylinder { <1.1112, 112.0632, 12.5131>, <0.4242, 112.1854, 12.8386>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <1.815, 112.2563, 12.1346>, 0.15 }
				cylinder { <1.815, 112.2563, 12.1346>, <1.1594, 112.5408, 12.4214>, 0.15 }
				cylinder { <1.1594, 112.5408, 12.4214>, <0.5283, 112.8934, 12.6864>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <1.8879, 112.46, 12.0694>, 0.15 }
				cylinder { <1.8879, 112.46, 12.0694>, <1.3234, 112.938, 12.2833>, 0.15 }
				cylinder { <1.3234, 112.938, 12.2833>, <0.8006, 113.4721, 12.4685>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <2.01252, 112.6277, 11.9834>, 0.15 }
				cylinder { <2.01252, 112.6277, 11.9834>, <1.5877, 113.2581, 12.106>, 0.15 }
				cylinder { <1.5877, 113.2581, 12.106>, <1.2182, 113.9278, 12.1955>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <2.1781, 112.7451, 11.8841>, 0.15 }
				cylinder { <2.1781, 112.7451, 11.8841>, <1.9295, 113.4736, 11.9049>, 0.15 }
				cylinder { <1.9295, 113.4736, 11.9049>, <1.7453, 114.2211, 11.8909>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <2.3704, 112.802, 11.7801>, 0.15 }
				cylinder { <2.3704, 112.802, 11.7801>, <2.3195, 113.5658, 11.6972>, 0.15 }
				cylinder { <2.3195, 113.5658, 11.6972>, <2.3364, 114.3268, 11.581>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <2.5898, 112.7898, 11.6724>, 0.15 }
				cylinder { <2.5898, 112.7898, 11.6724>, <2.7574, 113.5177, 11.4856>, 0.15 }
				cylinder { <2.7574, 113.5177, 11.4856>, <2.9899, 114.2195, 11.2701>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <2.7836, 112.7114, 11.5867>, 0.15 }
				cylinder { <2.7836, 112.7114, 11.5867>, <3.1384, 113.3408, 11.3205>, 0.15 }
				cylinder { <3.1384, 113.3408, 11.3205>, <3.5496, 113.9247, 11.0326>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <2.9521, 112.5755, 11.5219>, 0.15 }
				cylinder { <2.9521, 112.5755, 11.5219>, <3.4635, 113.0521, 11.1992>, 0.15 }
				cylinder { <3.4635, 113.0521, 11.1992>, <4.01799, 113.4679, 10.8636>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <3.08068, 112.3937, 11.4836>, 0.15 }
				cylinder { <3.08068, 112.3937, 11.4836>, <3.7047, 112.6765, 11.1321>, 0.15 }
				cylinder { <3.7047, 112.6765, 11.1321>, <4.3546, 112.8884, 10.7777>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <3.1582, 112.1816, 11.4749>, 0.15 }
				cylinder { <3.1582, 112.1816, 11.4749>, <3.841, 112.2463, 11.125>, 0.15 }
				cylinder { <3.841, 112.2463, 11.125>, <4.5306, 112.236, 10.7824>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <3.177, 111.939, 11.4999>, 0.15 }
				cylinder { <3.177, 111.939, 11.4999>, <3.8572, 111.7616, 11.1856>, 0.15 }
				cylinder { <3.8572, 111.7616, 11.1856>, <4.5226, 111.5123, 10.8889>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <3.1327, 111.7238, 11.5525>, 0.15 }
				cylinder { <3.1327, 111.7238, 11.5525>, <3.7494, 111.3383, 11.2994>, 0.15 }
				cylinder { <3.7494, 111.3383, 11.2994>, <4.3327, 110.8901, 11.07193>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <3.03291, 111.536, 11.629>, 0.15 }
				cylinder { <3.03291, 111.536, 11.629>, <3.5329, 110.9757, 11.4588>, 0.15 }
				cylinder { <3.5329, 110.9757, 11.4588>, <3.9839, 110.3672, 11.32>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <2.8862, 111.3919, 11.7226>, 0.15 }
				cylinder { <2.8862, 111.3919, 11.7226>, <3.2265, 110.705, 11.6501>, 0.15 }
				cylinder { <3.2265, 110.705, 11.6501>, <3.5064, 109.9887, 11.612>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <2.7052, 111.3038, 11.8254>, 0.15 }
				cylinder { <2.7052, 111.3038, 11.8254>, <2.8566, 110.5495, 11.8567>, 0.15 }
				cylinder { <2.8566, 110.5495, 11.8567>, <2.9412, 109.787, 11.9226>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4886, 112.0427, 11.8287>, <2.4887, 111.2803, 11.9367>, 0.15 }
				cylinder { <2.4887, 111.2803, 11.9367>, <2.4211, 110.5262, 12.07736>, 0.15 }
				cylinder { <2.4211, 110.5262, 12.07736>, <2.2866, 109.7878, 12.2491>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		}
	union { // internode
		cylinder { <-1.2069, 91.4777, 2.8906>, <-1.4597, 99.1036, 2.9883>, 0.3 }
		cylinder { <-1.4597, 99.1036, 2.9883>, <-1.7126, 106.7295, 3.08603>, 0.3 }
		cylinder { <-1.7126, 106.7295, 3.08603>, <-1.9654, 114.3554, 3.1837>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.9654, 114.3554, 3.1837>, <-1.9594, 115.3219, 3.05819>, 0.1582 }
			cylinder { <-1.9594, 115.3219, 3.05819>, <-1.9152, 116.26, 2.7974>, 0.1582 }
			cylinder { <-1.9152, 116.26, 2.7974>, <-1.8338, 117.1493, 2.407>, 0.1582 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-1.8338, 117.1493, 2.407>, <-4.005532, 120.4357, -1.07138>, <-1.4583, 121.5073, 0.5871> }
			triangle { <-1.4583, 121.5073, 0.5871>, <-4.005532, 120.4357, -1.07138>, <-3.2949, 122.9484, -2.645> }
			triangle { <-1.4583, 121.5073, 0.5871>, <-3.2949, 122.9484, -2.645>, <-0.8695, 125.1149, -2.02167> }
			triangle { <-0.8695, 125.1149, -2.02167>, <-3.2949, 122.9484, -2.645>, <-2.02141, 125.6902, -4.6744> }
			triangle { <-0.8695, 125.1149, -2.02167>, <-2.02141, 125.6902, -4.6744>, <-0.4022, 127.2968, -4.3996> }
			triangle { <-0.4022, 127.2968, -4.3996>, <-2.02141, 125.6902, -4.6744>, <0.319, 129.2735, -7.411> }
			triangle { <1.3656, 125.595, -3.7466>, <-0.4022, 127.2968, -4.3996>, <0.319, 129.2735, -7.411> }
			triangle { <1.3656, 125.595, -3.7466>, <-0.8695, 125.1149, -2.02167>, <-0.4022, 127.2968, -4.3996> }
			triangle { <1.3656, 125.595, -3.7466>, <1.5194, 123.1927, -1.3032>, <-0.8695, 125.1149, -2.02167> }
			triangle { <-0.8695, 125.1149, -2.02167>, <1.5194, 123.1927, -1.3032>, <-1.4583, 121.5073, 0.5871> }
			triangle { <-1.4583, 121.5073, 0.5871>, <1.5194, 123.1927, -1.3032>, <1.5062, 120.7221, 0.7308> }
			triangle { <-1.4583, 121.5073, 0.5871>, <1.5062, 120.7221, 0.7308>, <-1.8338, 117.1493, 2.407> }
			pigment { color rgb <0.0, 0.5, 0.0> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-1.9654, 114.3554, 3.1837>, <-1.7665, 121.8992, 1.6537>, 0.15 }
			cylinder { <-1.7665, 121.8992, 1.6537>, <-1.1232, 128.9252, -1.4305>, 0.15 }
			cylinder { <-1.1232, 128.9252, -1.4305>, <-0.06688, 135.0918, -5.919>, 0.15 }
			pigment { color rgb <0.0078, 0.58, 0.0> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <0.2635, 134.3965, -5.9336>, 0.15 }
				cylinder { <0.2635, 134.3965, -5.9336>, <0.6576, 133.735, -5.9258>, 0.15 }
				cylinder { <0.6576, 133.735, -5.9258>, <1.1117, 133.1139, -5.8957>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <0.4427, 134.5169, -5.8668>, 0.15 }
				cylinder { <0.4427, 134.5169, -5.8668>, <1.002933, 133.9938, -5.7932>, 0.15 }
				cylinder { <1.002933, 133.9938, -5.7932>, <1.6083, 133.5276, -5.6987>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <0.5779, 134.6869, -5.8046>, 0.15 }
				cylinder { <0.5779, 134.6869, -5.8046>, <1.256, 134.3472, -5.6714>, 0.15 }
				cylinder { <1.256, 134.3472, -5.6714>, <1.9607, 134.076, -5.5207>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <0.6577, 134.8917, -5.7522>, 0.15 }
				cylinder { <0.6577, 134.8917, -5.7522>, <1.3952, 134.7646, -5.571>, 0.15 }
				cylinder { <1.3952, 134.7646, -5.571>, <2.1385, 134.7119, -5.377>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <0.675, 135.1138, -5.7142>, 0.15 }
				cylinder { <0.675, 135.1138, -5.7142>, <1.4084, 135.2103, -5.5005>, 0.15 }
				cylinder { <1.4084, 135.2103, -5.5005>, <2.1263, 135.3805, -5.28>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <0.6218, 135.3516, -5.6929>, 0.15 }
				cylinder { <0.6218, 135.3516, -5.6929>, <1.2796, 135.6804, -5.4649>, 0.15 }
				cylinder { <1.2796, 135.6804, -5.4649>, <1.9004, 136.075, -5.2371>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <0.5107, 135.5484, -5.6936>, 0.15 }
				cylinder { <0.5107, 135.5484, -5.6936>, <1.03963, 136.0626, -5.4728>, 0.15 }
				cylinder { <1.03963, 136.0626, -5.4728>, <1.5147, 136.6294, -5.2587>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <0.3498, 135.7058, -5.7136>, 0.15 }
				cylinder { <0.3498, 135.7058, -5.7136>, <0.7042, 136.3611, -5.5191>, 0.15 }
				cylinder { <0.7042, 136.3611, -5.5191>, <0.9929, 137.0514, -5.3371>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <0.1531, 135.8104, -5.7514>, 0.15 }
				cylinder { <0.1531, 135.8104, -5.7514>, <0.3025, 136.5504, -5.5998>, 0.15 }
				cylinder { <0.3025, 136.5504, -5.5998>, <0.3797, 137.3047, -5.4656>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <-0.06251, 135.8531, -5.8036>, 0.15 }
				cylinder { <-0.06251, 135.8531, -5.8036>, <-0.131, 136.6141, -5.708>, 0.15 }
				cylinder { <-0.131, 136.6141, -5.708>, <-0.2718, 137.3674, -5.6332>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <-0.2959, 135.8254, -5.8711>, 0.15 }
				cylinder { <-0.2959, 135.8254, -5.8711>, <-0.5933, 136.5352, -5.8454>, 0.15 }
				cylinder { <-0.5933, 136.5352, -5.8454>, <-0.956, 137.2144, -5.842>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <-0.4914, 135.7339, -5.938>, 0.15 }
				cylinder { <-0.4914, 135.7339, -5.938>, <-0.9739, 136.3326, -5.9791>, 0.15 }
				cylinder { <-0.9739, 136.3326, -5.9791>, <-1.5094, 136.8822, -6.04216>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <-0.6504, 135.5871, -6.003207>, 0.15 }
				cylinder { <-0.6504, 135.5871, -6.003207>, <-1.2763, 136.0232, -6.1077>, 0.15 }
				cylinder { <-1.2763, 136.0232, -6.1077>, <-1.9386, 136.3959, -6.2317>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <-0.7591, 135.3976, -6.06115>, 0.15 }
				cylinder { <-0.7591, 135.3976, -6.06115>, <-1.4746, 135.6335, -6.22>, 0.15 }
				cylinder { <-1.4746, 135.6335, -6.22>, <-2.2065, 135.7973, -6.3943>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <-0.8081, 135.1818, -6.1068>, 0.15 }
				cylinder { <-0.8081, 135.1818, -6.1068>, <-1.5516, 135.1973, -6.3064>, 0.15 }
				cylinder { <-1.5516, 135.1973, -6.3064>, <-2.2902, 135.1379, -6.5159>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <-0.7892, 134.9399, -6.138>, 0.15 }
				cylinder { <-0.7892, 134.9399, -6.138>, <-1.4909, 134.7156, -6.3622>, 0.15 }
				cylinder { <-1.4909, 134.7156, -6.3622>, <-2.165, 134.4209, -6.5895>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <-0.7069, 134.7297, -6.1472>, 0.15 }
				cylinder { <-0.7069, 134.7297, -6.1472>, <-1.3068, 134.3036, -6.374>, 0.15 }
				cylinder { <-1.3068, 134.3036, -6.374>, <-1.8607, 133.8176, -6.5974>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <-0.5695, 134.5506, -6.1367>, 0.15 }
				cylinder { <-0.5695, 134.5506, -6.1367>, <-1.01601, 133.9595, -6.3467>, 0.15 }
				cylinder { <-1.01601, 133.9595, -6.3467>, <-1.402, 133.3241, -6.5469>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <-0.3887, 134.4182, -6.1075>, 0.15 }
				cylinder { <-0.3887, 134.4182, -6.1075>, <-0.6434, 133.7129, -6.2825>, 0.15 }
				cylinder { <-0.6434, 133.7129, -6.2825>, <-0.8283, 132.9827, -6.4423>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <-0.1803, 134.3438, -6.06209>, 0.15 }
				cylinder { <-0.1803, 134.3438, -6.06209>, <-0.2211, 133.5851, -6.187>, 0.15 }
				cylinder { <-0.2211, 133.5851, -6.187>, <-0.189, 132.823, -6.2926>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.06688, 135.0918, -5.919>, <0.05593, 134.3359, -5.9991>, 0.15 }
				cylinder { <0.05593, 134.3359, -5.9991>, <0.25, 133.5931, -6.05785>, 0.15 }
				cylinder { <0.25, 133.5931, -6.05785>, <0.5136, 132.8705, -6.0947>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		}
	union { // internode
		cylinder { <-1.9654, 114.3554, 3.1837>, <-2.3762, 121.9725, 3.3816>, 0.3 }
		cylinder { <-2.3762, 121.9725, 3.3816>, <-2.9447, 129.5761, 3.6797>, 0.3 }
		cylinder { <-2.9447, 129.5761, 3.6797>, <-3.6705, 137.1618, 4.07776>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.6705, 137.1618, 4.07776>, <-3.7474, 137.5044, 4.1237>, 0.05749 }
			cylinder { <-3.7474, 137.5044, 4.1237>, <-3.8659, 137.8302, 4.1962>, 0.05749 }
			cylinder { <-3.8659, 137.8302, 4.1962>, <-4.02342, 138.1321, 4.2936>, 0.05749 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-4.02342, 138.1321, 4.2936>, <-4.4851, 139.1966, 5.8101>, <-4.7655, 139.6158, 4.7532> }
			triangle { <-4.7655, 139.6158, 4.7532>, <-4.4851, 139.1966, 5.8101>, <-5.1729, 140.0211, 6.08318> }
			triangle { <-4.7655, 139.6158, 4.7532>, <-5.1729, 140.0211, 6.08318>, <-5.7305, 140.7909, 5.3455> }
			triangle { <-5.7305, 140.7909, 5.3455>, <-5.1729, 140.0211, 6.08318>, <-6.1305, 140.899, 6.3336> }
			triangle { <-5.7305, 140.7909, 5.3455>, <-6.1305, 140.899, 6.3336>, <-6.5453, 141.4644, 5.8807> }
			triangle { <-6.5453, 141.4644, 5.8807>, <-6.1305, 140.899, 6.3336>, <-7.5772, 142.032, 6.5093> }
			triangle { <-6.7624, 140.8522, 5.2254>, <-6.5453, 141.4644, 5.8807>, <-7.5772, 142.032, 6.5093> }
			triangle { <-6.7624, 140.8522, 5.2254>, <-5.7305, 140.7909, 5.3455>, <-6.5453, 141.4644, 5.8807> }
			triangle { <-6.7624, 140.8522, 5.2254>, <-6.08142, 140.0923, 4.5098>, <-5.7305, 140.7909, 5.3455> }
			triangle { <-5.7305, 140.7909, 5.3455>, <-6.08142, 140.0923, 4.5098>, <-4.7655, 139.6158, 4.7532> }
			triangle { <-4.7655, 139.6158, 4.7532>, <-6.08142, 140.0923, 4.5098>, <-5.4582, 139.2923, 3.9407> }
			triangle { <-4.7655, 139.6158, 4.7532>, <-5.4582, 139.2923, 3.9407>, <-4.02342, 138.1321, 4.2936> }
			pigment { color rgb <0.0, 0.5, 0.0> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-3.6705, 137.1618, 4.07776>, <-5.8006, 144.4477, 5.3691>, 0.15 }
			cylinder { <-5.8006, 144.4477, 5.3691>, <-9.225, 151.0109, 7.4875>, 0.15 }
			cylinder { <-9.225, 151.0109, 7.4875>, <-13.7772, 156.5325, 10.33>, 0.15 }
			pigment { color rgb <0.0078, 0.58, 0.0> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.9409, 155.8192, 10.09084>, 0.15 }
				cylinder { <-13.9409, 155.8192, 10.09084>, <-14.141, 155.1377, 9.7935>, 0.15 }
				cylinder { <-14.141, 155.1377, 9.7935>, <-14.3755, 154.4945, 9.4409>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-14.04383, 155.934, 9.9256>, 0.15 }
				cylinder { <-14.04383, 155.934, 9.9256>, <-14.34, 155.3858, 9.4732>, 0.15 }
				cylinder { <-14.34, 155.3858, 9.4732>, <-14.6629, 154.8932, 8.9772>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-14.1237, 156.1003, 9.7952>, 0.15 }
				cylinder { <-14.1237, 156.1003, 9.7952>, <-14.4905, 155.7327, 9.2267>, 0.15 }
				cylinder { <-14.4905, 155.7327, 9.2267>, <-14.874, 155.4331, 8.6299>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-14.1737, 156.3039, 9.7108>, 0.15 }
				cylinder { <-14.1737, 156.3039, 9.7108>, <-14.5795, 156.1485, 9.07521>, 0.15 }
				cylinder { <-14.5795, 156.1485, 9.07521>, <-14.9907, 156.0677, 8.4291>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-14.1896, 156.5272, 9.6798>, 0.15 }
				cylinder { <-14.1896, 156.5272, 9.6798>, <-14.5995, 156.5973, 9.03179>, 0.15 }
				cylinder { <-14.5995, 156.5973, 9.03179>, <-15.00285, 156.7423, 8.392>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-14.1668, 156.769, 9.7094>, 0.15 }
				cylinder { <-14.1668, 156.769, 9.7094>, <-14.5413, 157.0761, 9.1108>, 0.15 }
				cylinder { <-14.5413, 157.0761, 9.1108>, <-14.8971, 157.4509, 8.5399>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-14.1107, 156.9715, 9.7924>, 0.15 }
				cylinder { <-14.1107, 156.9715, 9.7924>, <-14.4189, 157.4703, 9.2933>, 0.15 }
				cylinder { <-14.4189, 157.4703, 9.2933>, <-14.6987, 158.0242, 8.8375>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-14.02594, 157.1362, 9.9218>, 0.15 }
				cylinder { <-14.02594, 157.1362, 9.9218>, <-14.2412, 157.7838, 9.5652>, 0.15 }
				cylinder { <-14.2412, 157.7838, 9.5652>, <-14.4209, 158.4691, 9.2636>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.9197, 157.2489, 10.08636>, 0.15 }
				cylinder { <-13.9197, 157.2489, 10.08636>, <-14.02355, 157.9895, 9.9029>, 0.15 }
				cylinder { <-14.02355, 157.9895, 9.9029>, <-14.08776, 158.7472, 9.7815>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.8011, 157.3, 10.2718>, 0.15 }
				cylinder { <-13.8011, 157.3, 10.2718>, <-13.7846, 158.0698, 10.2774>, 0.15 }
				cylinder { <-13.7846, 158.0698, 10.2774>, <-13.7278, 158.8345, 10.3467>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.6707, 157.2807, 10.4779>, 0.15 }
				cylinder { <-13.6707, 157.2807, 10.4779>, <-13.5258, 158.0074, 10.6872>, 0.15 }
				cylinder { <-13.5258, 158.0074, 10.6872>, <-13.3436, 158.7056, 10.9558>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.5596, 157.1956, 10.6554>, 0.15 }
				cylinder { <-13.5596, 157.1956, 10.6554>, <-13.3088, 157.8172, 11.03436>, 0.15 }
				cylinder { <-13.3088, 157.8172, 11.03436>, <-13.02709, 158.3913, 11.4633>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.4673, 157.0535, 10.8048>, 0.15 }
				cylinder { <-13.4673, 157.0535, 10.8048>, <-13.1321, 157.5164, 11.3208>, 0.15 }
				cylinder { <-13.1321, 157.5164, 11.3208>, <-12.7751, 157.9168, 11.8732>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.4016, 156.8665, 10.9133>, 0.15 }
				cylinder { <-13.4016, 156.8665, 10.9133>, <-13.0111, 157.131, 11.522>, 0.15 }
				cylinder { <-13.0111, 157.131, 11.522>, <-12.6094, 157.3232, 12.1502>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.3682, 156.6508, 10.9716>, 0.15 }
				cylinder { <-13.3682, 156.6508, 10.9716>, <-12.9559, 156.6939, 11.6205>, 0.15 }
				cylinder { <-12.9559, 156.6939, 11.6205>, <-12.5443, 156.6615, 12.2704>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.3719, 156.4062, 10.9724>, 0.15 }
				cylinder { <-13.3719, 156.4062, 10.9724>, <-12.976, 156.206, 11.6018>, 0.15 }
				cylinder { <-12.976, 156.206, 11.6018>, <-12.5935, 155.9339, 12.2122>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.4116, 156.1911, 10.9154>, 0.15 }
				cylinder { <-13.4116, 156.1911, 10.9154>, <-13.06661, 155.7838, 11.4703>, 0.15 }
				cylinder { <-13.06661, 155.7838, 11.4703>, <-12.7453, 155.3143, 11.9893>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.4829, 156.0055, 10.8081>, 0.15 }
				cylinder { <-13.4829, 156.0055, 10.8081>, <-13.2183, 155.426, 11.2406>, 0.15 }
				cylinder { <-13.2183, 155.426, 11.2406>, <-12.986, 154.7997, 11.6235>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.5794, 155.8653, 10.6595>, 0.15 }
				cylinder { <-13.5794, 155.8653, 10.6595>, <-13.4181, 155.1636, 10.9325>, 0.15 }
				cylinder { <-13.4181, 155.1636, 10.9325>, <-13.2948, 154.4342, 11.1463>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.693, 155.7825, 10.4826>, 0.15 }
				cylinder { <-13.693, 155.7825, 10.4826>, <-13.6489, 155.019, 10.5725>, 0.15 }
				cylinder { <-13.6489, 155.019, 10.5725>, <-13.6452, 154.2495, 10.5988>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-13.7772, 156.5325, 10.33>, <-13.824, 155.7658, 10.2766>, 0.15 }
				cylinder { <-13.824, 155.7658, 10.2766>, <-13.9107, 155.0097, 10.16>, 0.15 }
				cylinder { <-13.9107, 155.0097, 10.16>, <-14.03661, 154.2714, 9.9812>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		}
	union { // internode
		cylinder { <-3.6705, 137.1618, 4.07776>, <-4.205, 144.6598, 4.5021>, 0.296 }
		cylinder { <-4.205, 144.6598, 4.5021>, <-4.5577, 152.1667, 4.9579>, 0.296 }
		cylinder { <-4.5577, 152.1667, 4.9579>, <-4.7284, 159.678, 5.4449>, 0.296 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.7284, 159.678, 5.4449>, <-4.6964, 159.9368, 5.4681>, 0.0425 }
			cylinder { <-4.6964, 159.9368, 5.4681>, <-4.6271, 160.1876, 5.497>, 0.0425 }
			cylinder { <-4.6271, 160.1876, 5.497>, <-4.5221, 160.425, 5.5311>, 0.0425 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-4.5221, 160.425, 5.5311>, <-3.6579, 161.3744, 4.9442>, <-4.0333, 161.5885, 5.6944> }
			triangle { <-4.0333, 161.5885, 5.6944>, <-3.6579, 161.3744, 4.9442>, <-3.2224, 162.0349, 5.1555> }
			triangle { <-4.0333, 161.5885, 5.6944>, <-3.2224, 162.0349, 5.1555>, <-3.3264, 162.5494, 5.8736> }
			triangle { <-3.3264, 162.5494, 5.8736>, <-3.2224, 162.0349, 5.1555>, <-2.6501, 162.7443, 5.5102> }
			triangle { <-3.3264, 162.5494, 5.8736>, <-2.6501, 162.7443, 5.5102>, <-2.682, 163.1313, 5.9899> }
			triangle { <-2.682, 163.1313, 5.9899>, <-2.6501, 162.7443, 5.5102>, <-1.8611, 163.6545, 6.1513> }
			triangle { <-2.8051, 162.6283, 6.4338>, <-2.682, 163.1313, 5.9899>, <-1.8611, 163.6545, 6.1513> }
			triangle { <-2.8051, 162.6283, 6.4338>, <-3.3264, 162.5494, 5.8736>, <-2.682, 163.1313, 5.9899> }
			triangle { <-2.8051, 162.6283, 6.4338>, <-3.4495, 161.9714, 6.4788>, <-3.3264, 162.5494, 5.8736> }
			triangle { <-3.3264, 162.5494, 5.8736>, <-3.4495, 161.9714, 6.4788>, <-4.0333, 161.5885, 5.6944> }
			triangle { <-4.0333, 161.5885, 5.6944>, <-3.4495, 161.9714, 6.4788>, <-3.9891, 161.3023, 6.4665> }
			triangle { <-4.0333, 161.5885, 5.6944>, <-3.9891, 161.3023, 6.4665>, <-4.5221, 160.425, 5.5311> }
			pigment { color rgb <0.0, 0.5, 0.0> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-4.7284, 159.678, 5.4449>, <-3.2355, 167.1927, 6.2137>, 0.15 }
			cylinder { <-3.2355, 167.1927, 6.2137>, <-0.1479, 174.175, 7.216>, 0.15 }
			cylinder { <-0.1479, 174.175, 7.216>, <4.3843, 180.2855, 8.403>, 0.15 }
			pigment { color rgb <0.0078, 0.58, 0.0> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.441, 179.5565, 8.6442>, 0.15 }
				cylinder { <4.441, 179.5565, 8.6442>, <4.4858, 178.846, 8.9377>, 0.15 }
				cylinder { <4.4858, 178.846, 8.9377>, <4.5185, 178.158, 9.2818>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.3923, 179.6534, 8.8425>, 0.15 }
				cylinder { <4.3923, 179.6534, 8.8425>, <4.3878, 179.0543, 9.3263>, 0.15 }
				cylinder { <4.3878, 179.0543, 9.3263>, <4.371, 178.4917, 9.8517>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.3429, 179.8046, 9.002986>, 0.15 }
				cylinder { <4.3429, 179.8046, 9.002986>, <4.2896, 179.3686, 9.6353>, 0.15 }
				cylinder { <4.2896, 179.3686, 9.6353>, <4.2246, 178.9798, 10.2968>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.2971, 179.9973, 9.1117>, 0.15 }
				cylinder { <4.2971, 179.9973, 9.1117>, <4.1995, 179.7619, 9.8383>, 0.15 }
				cylinder { <4.1995, 179.7619, 9.8383>, <4.09201, 179.5805, 10.5788>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.2588, 180.2149, 9.1594>, 0.15 }
				cylinder { <4.2588, 180.2149, 9.1594>, <4.1253, 180.2003, 9.9176>, 0.15 }
				cylinder { <4.1253, 180.2003, 9.9176>, <3.9845, 180.2418, 10.6735>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.2296, 180.4568, 9.1376>, 0.15 }
				cylinder { <4.2296, 180.4568, 9.1376>, <4.07029, 180.6822, 9.8564>, 0.15 }
				cylinder { <4.07029, 180.6822, 9.8564>, <3.9072, 180.9607, 10.5555>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.2164, 180.6653, 9.05153>, 0.15 }
				cylinder { <4.2164, 180.6653, 9.05153>, <4.04754, 181.0926, 9.6693>, 0.15 }
				cylinder { <4.04754, 181.0926, 9.6693>, <3.8784, 181.5654, 10.2531>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.2177, 180.841, 8.9095>, 0.15 }
				cylinder { <4.2177, 180.841, 8.9095>, <4.0538, 181.4335, 9.3732>, 0.15 }
				cylinder { <4.0538, 181.4335, 9.3732>, <3.8933, 182.0598, 9.7914>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.2334, 180.969, 8.7239>, 0.15 }
				cylinder { <4.2334, 180.969, 8.7239>, <4.08853, 181.6756, 8.9935>, 0.15 }
				cylinder { <4.08853, 181.6756, 8.9935>, <3.9504, 182.4015, 9.2101>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.262, 181.0381, 8.5107>, 0.15 }
				cylinder { <4.262, 181.0381, 8.5107>, <4.1487, 181.7979, 8.5629>, 0.15 }
				cylinder { <4.1487, 181.7979, 8.5629>, <4.04492, 182.5609, 8.5593>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.3048, 181.0398, 8.2698>, 0.15 }
				cylinder { <4.3048, 181.0398, 8.2698>, <4.2366, 181.7834, 8.08219>, 0.15 }
				cylinder { <4.2366, 181.7834, 8.08219>, <4.1799, 182.5124, 7.8409>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.3516, 180.9736, 8.05895>, 0.15 }
				cylinder { <4.3516, 180.9736, 8.05895>, <4.3312, 181.6355, 7.666>, 0.15 }
				cylinder { <4.3312, 181.6355, 7.666>, <4.3232, 182.2677, 7.2265>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.4012, 180.8482, 7.8776>, 0.15 }
				cylinder { <4.4012, 180.8482, 7.8776>, <4.4304, 181.3714, 7.3134>, 0.15 }
				cylinder { <4.4304, 181.3714, 7.3134>, <4.4718, 181.8523, 6.7135>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.4493, 180.6743, 7.7415>, 0.15 }
				cylinder { <4.4493, 180.6743, 7.7415>, <4.5256, 181.0137, 7.05465>, 0.15 }
				cylinder { <4.5256, 181.0137, 7.05465>, <4.6128, 181.3019, 6.3459>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.4918, 180.4669, 7.6624>, 0.15 }
				cylinder { <4.4918, 180.4669, 7.6624>, <4.6086, 180.5933, 6.9119>, 0.15 }
				cylinder { <4.6086, 180.5933, 6.9119>, <4.7342, 180.664, 6.1555>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.5273, 180.2253, 7.6488>, 0.15 }
				cylinder { <4.5273, 180.2253, 7.6488>, <4.6766, 180.1092, 6.9024>, 0.15 }
				cylinder { <4.6766, 180.1092, 6.9024>, <4.8313, 179.938, 6.1678>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.5474, 180.007, 7.7039>, 0.15 }
				cylinder { <4.5474, 180.007, 7.7039>, <4.7133, 179.677, 7.02831>, 0.15 }
				cylinder { <4.7133, 179.677, 7.02831>, <4.8812, 179.2973, 6.3798>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.5534, 179.8128, 7.8192>, 0.15 }
				cylinder { <4.5534, 179.8128, 7.8192>, <4.7216, 179.2973, 7.2725>, 0.15 }
				cylinder { <4.7216, 179.2973, 7.2725>, <4.8882, 178.7418, 6.766>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.5448, 179.6593, 7.9848>, 0.15 }
				cylinder { <4.5448, 179.6593, 7.9848>, <4.7009, 179.0026, 7.6142>, 0.15 }
				cylinder { <4.7009, 179.0026, 7.6142>, <4.8518, 178.3192, 7.2932>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.5224, 179.5597, 8.1863>, 0.15 }
				cylinder { <4.5224, 179.5597, 8.1863>, <4.6529, 178.8184, 8.02377>, 0.15 }
				cylinder { <4.6529, 178.8184, 8.02377>, <4.7752, 178.0659, 7.916>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.3843, 180.2855, 8.403>, <4.4848, 179.5224, 8.4252>, 0.15 }
				cylinder { <4.4848, 179.5224, 8.4252>, <4.575, 178.7617, 8.5031>, 0.15 }
				cylinder { <4.575, 178.7617, 8.5031>, <4.6545, 178.0075, 8.6362>, 0.15 }
				pigment { color rgb <0.95, 0.86, 0.26> }}
			}
		}
scale 2.31
} // end fleabane

#declare Plant2 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.301, 6.1572, -0.02964>, 0.2668 }
		cylinder { <-0.301, 6.1572, -0.02964>, <-0.9023, 12.2921, -0.08887>, 0.2668 }
		cylinder { <-0.9023, 12.2921, -0.08887>, <-1.8025, 18.39, -0.1775>, 0.2668 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // internode
		cylinder { <-1.8025, 18.39, -0.1775>, <-2.3589, 25.2862, 0.226>, 0.3 }
		cylinder { <-2.3589, 25.2862, 0.226>, <-2.4542, 32.1569, 1.129>, 0.3 }
		cylinder { <-2.4542, 32.1569, 1.129>, <-2.08771, 38.9358, 2.5227>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.08771, 38.9358, 2.5227>, <0.09689, 49.9003, 6.5141>, 0.2496 }
			cylinder { <0.09689, 49.9003, 6.5141>, <3.7543, 59.7964, 11.9563>, 0.2496 }
			cylinder { <3.7543, 59.7964, 11.9563>, <8.7439, 68.2435, 18.6402>, 0.2496 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <8.7439, 68.2435, 18.6402>, <8.7584, 70.2755, 21.5649>, 0.2496 }
				cylinder { <8.7584, 70.2755, 21.5649>, <7.2867, 71.2773, 24.6494>, 0.2496 }
				cylinder { <7.2867, 71.2773, 24.6494>, <4.7112, 70.9887, 27.09209>, 0.2496 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <4.7112, 70.9887, 27.09209>, <0.8229, 73.4391, 33.911>, <2.4464, 70.1765, 29.7394> }
				triangle { <2.4464, 70.1765, 29.7394>, <0.8229, 73.4391, 33.911>, <-1.2694, 70.979, 35.8123> }
				triangle { <2.4464, 70.1765, 29.7394>, <-1.2694, 70.979, 35.8123>, <-0.7273, 69.2625, 33.2489> }
				triangle { <-1.2694, 70.979, 35.8123>, <-1.4425, 69.00385, 33.9303>, <-0.7273, 69.2625, 33.2489> }
				triangle { <2.4464, 70.1765, 29.7394>, <-2.3788, 67.8891, 29.696>, <4.7112, 70.9887, 27.09209> }
				triangle { <-3.1731, 67.4845, 33.3921>, <-0.7273, 69.2625, 33.2489>, <-1.4425, 69.00385, 33.9303> }
				triangle { <-1.4425, 69.00385, 33.9303>, <-1.9328, 69.03244, 34.5163>, <-3.1731, 67.4845, 33.3921> }
				triangle { <-1.2694, 70.979, 35.8123>, <-1.9328, 69.03244, 34.5163>, <-1.4425, 69.00385, 33.9303> }
				triangle { <-2.3788, 67.8891, 29.696>, <2.1162, 69.5967, 26.3906>, <4.7112, 70.9887, 27.09209> }
				triangle { <4.7112, 70.9887, 27.09209>, <4.2522, 73.2729, 29.07721>, <0.8229, 73.4391, 33.911> }
				triangle { <2.4464, 70.1765, 29.7394>, <-0.7273, 69.2625, 33.2489>, <-3.1731, 67.4845, 33.3921> }
				triangle { <-3.1731, 67.4845, 33.3921>, <-2.3788, 67.8891, 29.696>, <2.4464, 70.1765, 29.7394> }
				triangle { <2.1162, 69.5967, 26.3906>, <-2.3788, 67.8891, 29.696>, <-0.4701, 68.555, 27.7554> }
				triangle { <4.2522, 73.2729, 29.07721>, <2.3337, 74.1061, 31.3678>, <0.8229, 73.4391, 33.911> }
				triangle { <0.8229, 73.4391, 33.911>, <-0.8156, 72.3858, 34.9909>, <-1.2694, 70.979, 35.8123> }
				triangle { <-3.1731, 67.4845, 33.3921>, <-3.3758, 67.7431, 31.3764>, <-2.3788, 67.8891, 29.696> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <8.7439, 68.2435, 18.6402>, <11.03366, 70.7478, 19.7215>, 0.2496 }
				cylinder { <11.03366, 70.7478, 19.7215>, <13.8484, 72.9293, 19.7527>, 0.2496 }
				cylinder { <13.8484, 72.9293, 19.7527>, <16.8593, 74.5331, 18.73>, 0.2496 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <16.8593, 74.5331, 18.73>, <22.8171, 76.05562, 13.2704>, <20.1681, 75.7512, 18.1255> }
				triangle { <20.1681, 75.7512, 18.1255>, <22.8171, 76.05562, 13.2704>, <26.1454, 77.2793, 14.483> }
				triangle { <20.1681, 75.7512, 18.1255>, <26.1454, 77.2793, 14.483>, <24.5395, 77.5354, 17.1601> }
				triangle { <26.1454, 77.2793, 14.483>, <25.4547, 77.9711, 17.03594>, <24.5395, 77.5354, 17.1601> }
				triangle { <20.1681, 75.7512, 18.1255>, <22.65, 80.2028, 19.7197>, <16.8593, 74.5331, 18.73> }
				triangle { <26.202, 79.7073, 18.4572>, <24.5395, 77.5354, 17.1601>, <25.4547, 77.9711, 17.03594> }
				triangle { <25.4547, 77.9711, 17.03594>, <26.09439, 78.2404, 16.7152>, <26.202, 79.7073, 18.4572> }
				triangle { <26.1454, 77.2793, 14.483>, <26.09439, 78.2404, 16.7152>, <25.4547, 77.9711, 17.03594> }
				triangle { <22.65, 80.2028, 19.7197>, <17.6899, 77.144, 20.01722>, <16.8593, 74.5331, 18.73> }
				triangle { <16.8593, 74.5331, 18.73>, <17.7067, 74.4175, 15.791>, <22.8171, 76.05562, 13.2704> }
				triangle { <20.1681, 75.7512, 18.1255>, <24.5395, 77.5354, 17.1601>, <26.202, 79.7073, 18.4572> }
				triangle { <26.202, 79.7073, 18.4572>, <22.65, 80.2028, 19.7197>, <20.1681, 75.7512, 18.1255> }
				triangle { <17.6899, 77.144, 20.01722>, <22.65, 80.2028, 19.7197>, <20.1151, 79.07912, 20.1243> }
				triangle { <17.7067, 74.4175, 15.791>, <19.8991, 75.5064, 13.886>, <22.8171, 76.05562, 13.2704> }
				triangle { <22.8171, 76.05562, 13.2704>, <24.704, 77.1914, 13.6031>, <26.1454, 77.2793, 14.483> }
				triangle { <26.202, 79.7073, 18.4572>, <24.4516, 80.5785, 19.04712>, <22.65, 80.2028, 19.7197> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <8.7439, 68.2435, 18.6402>, <10.2408, 70.7777, 20.6453>, 0.2496 }
				cylinder { <10.2408, 70.7777, 20.6453>, <11.7377, 73.3118, 22.6505>, 0.2496 }
				cylinder { <11.7377, 73.3118, 22.6505>, <13.2346, 75.846, 24.6556>, 0.2496 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <13.2346, 75.846, 24.6556>, <18.7972, 81.7549, 25.9836>, <14.9572, 77.9007, 27.02384> }
				triangle { <14.9572, 77.9007, 27.02384>, <18.7972, 81.7549, 25.9836>, <19.6714, 82.6911, 29.5056> }
				triangle { <14.9572, 77.9007, 27.02384>, <19.6714, 82.6911, 29.5056>, <17.2081, 80.8499, 30.0997> }
				triangle { <19.6714, 82.6911, 29.5056>, <17.6056, 81.4656, 30.8107>, <17.2081, 80.8499, 30.0997> }
				triangle { <14.9572, 77.9007, 27.02384>, <13.1857, 80.8225, 31.1278>, <13.2346, 75.846, 24.6556> }
				triangle { <16.3933, 82.05801, 32.753>, <17.2081, 80.8499, 30.0997>, <17.6056, 81.4656, 30.8107> }
				triangle { <17.6056, 81.4656, 30.8107>, <18.01486, 82.01463, 31.1509>, <16.3933, 82.05801, 32.753> }
				triangle { <19.6714, 82.6911, 29.5056>, <18.01486, 82.01463, 31.1509>, <17.6056, 81.4656, 30.8107> }
				triangle { <13.1857, 80.8225, 31.1278>, <11.6215, 77.1962, 26.8324>, <13.2346, 75.846, 24.6556> }
				triangle { <13.2346, 75.846, 24.6556>, <15.2434, 77.7791, 23.3919>, <18.7972, 81.7549, 25.9836> }
				triangle { <14.9572, 77.9007, 27.02384>, <17.2081, 80.8499, 30.0997>, <16.3933, 82.05801, 32.753> }
				triangle { <16.3933, 82.05801, 32.753>, <13.1857, 80.8225, 31.1278>, <14.9572, 77.9007, 27.02384> }
				triangle { <11.6215, 77.1962, 26.8324>, <13.1857, 80.8225, 31.1278>, <12.00663, 79.1419, 29.2206> }
				triangle { <15.2434, 77.7791, 23.3919>, <16.9279, 80.2851, 24.102>, <18.7972, 81.7549, 25.9836> }
				triangle { <18.7972, 81.7549, 25.9836>, <19.1982, 82.8369, 27.8887>, <19.6714, 82.6911, 29.5056> }
				triangle { <16.3933, 82.05801, 32.753>, <14.4562, 81.9389, 32.1171>, <13.1857, 80.8225, 31.1278> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			}
		}
	union { // internode
		cylinder { <-2.08771, 38.9358, 2.5227>, <-0.267, 44.9745, 5.3949>, 0.3 }
		cylinder { <-0.267, 44.9745, 5.3949>, <2.8239, 49.6635, 9.4557>, 0.3 }
		cylinder { <2.8239, 49.6635, 9.4557>, <6.8732, 52.5293, 14.2951>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <6.8732, 52.5293, 14.2951>, <8.994, 53.2873, 16.7209>, 0.0696 }
			cylinder { <8.994, 53.2873, 16.7209>, <11.2201, 53.4053, 19.1677>, 0.0696 }
			cylinder { <11.2201, 53.4053, 19.1677>, <13.4659, 52.8788, 21.5417>, 0.0696 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <13.4659, 52.8788, 21.5417>, <13.693, 52.6932, 22.4904>, 0.0696 }
				cylinder { <13.693, 52.6932, 22.4904>, <13.4145, 52.5281, 23.4292>, 0.0696 }
				cylinder { <13.4145, 52.5281, 23.4292>, <12.7026, 52.4264, 24.114>, 0.0696 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <12.7026, 52.4264, 24.114>, <11.9826, 52.1913, 26.2782>, <11.9684, 52.1592, 24.7341> }
				triangle { <11.9684, 52.1592, 24.7341>, <11.9826, 52.1913, 26.2782>, <11.04721, 51.7633, 26.462> }
				triangle { <11.9684, 52.1592, 24.7341>, <11.04721, 51.7633, 26.462>, <10.9829, 51.8562, 25.5959> }
				triangle { <11.04721, 51.7633, 26.462>, <10.7563, 51.7985, 25.7583>, <10.9829, 51.8562, 25.5959> }
				triangle { <11.9684, 52.1592, 24.7341>, <10.5179, 52.4952, 24.75>, <12.7026, 52.4264, 24.114> }
				triangle { <10.1417, 51.8975, 25.5407>, <10.9829, 51.8562, 25.5959>, <10.7563, 51.7985, 25.7583> }
				triangle { <10.7563, 51.7985, 25.7583>, <10.6299, 51.7715, 25.9279>, <10.1417, 51.8975, 25.5407> }
				triangle { <11.04721, 51.7633, 26.462>, <10.6299, 51.7715, 25.9279>, <10.7563, 51.7985, 25.7583> }
				triangle { <10.5179, 52.4952, 24.75>, <11.9207, 52.6996, 23.9517>, <12.7026, 52.4264, 24.114> }
				triangle { <12.7026, 52.4264, 24.114>, <12.8981, 52.5146, 24.9401>, <11.9826, 52.1913, 26.2782> }
				triangle { <11.9684, 52.1592, 24.7341>, <10.9829, 51.8562, 25.5959>, <10.1417, 51.8975, 25.5407> }
				triangle { <10.1417, 51.8975, 25.5407>, <10.5179, 52.4952, 24.75>, <11.9684, 52.1592, 24.7341> }
				triangle { <11.9207, 52.6996, 23.9517>, <10.5179, 52.4952, 24.75>, <11.1232, 52.6665, 24.2867> }
				triangle { <12.8981, 52.5146, 24.9401>, <12.5206, 52.5258, 25.7182>, <11.9826, 52.1913, 26.2782> }
				triangle { <11.9826, 52.1913, 26.2782>, <11.406, 52.06903, 26.4738>, <11.04721, 51.7633, 26.462> }
				triangle { <10.1417, 51.8975, 25.5407>, <10.2104, 52.3216, 25.167>, <10.5179, 52.4952, 24.75> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <13.4659, 52.8788, 21.5417>, <14.3458, 52.7631, 21.9874>, 0.0696 }
				cylinder { <14.3458, 52.7631, 21.9874>, <15.3288, 52.7031, 22.1144>, 0.0696 }
				cylinder { <15.3288, 52.7031, 22.1144>, <16.3001, 52.7058, 21.9079>, 0.0696 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <16.3001, 52.7058, 21.9079>, <18.07831, 53.04589, 20.5008>, <17.2608, 52.5298, 21.7054> }
				triangle { <17.2608, 52.5298, 21.7054>, <18.07831, 53.04589, 20.5008>, <18.9791, 52.5498, 20.6865> }
				triangle { <17.2608, 52.5298, 21.7054>, <18.9791, 52.5498, 20.6865>, <18.5644, 52.3548, 21.43> }
				triangle { <18.9791, 52.5498, 20.6865>, <18.8445, 52.3146, 21.3989>, <18.5644, 52.3548, 21.43> }
				triangle { <17.2608, 52.5298, 21.7054>, <18.4805, 52.6114, 22.5557>, <16.3001, 52.7058, 21.9079> }
				triangle { <19.2421, 52.2383, 21.9195>, <18.5644, 52.3548, 21.43>, <18.8445, 52.3146, 21.3989> }
				triangle { <18.8445, 52.3146, 21.3989>, <19.04309, 52.3217, 21.3215>, <19.2421, 52.2383, 21.9195> }
				triangle { <18.9791, 52.5498, 20.6865>, <19.04309, 52.3217, 21.3215>, <18.8445, 52.3146, 21.3989> }
				triangle { <18.4805, 52.6114, 22.5557>, <16.8626, 52.7824, 22.5325>, <16.3001, 52.7058, 21.9079> }
				triangle { <16.3001, 52.7058, 21.9079>, <16.5769, 53.07918, 21.192>, <18.07831, 53.04589, 20.5008> }
				triangle { <17.2608, 52.5298, 21.7054>, <18.5644, 52.3548, 21.43>, <19.2421, 52.2383, 21.9195> }
				triangle { <19.2421, 52.2383, 21.9195>, <18.4805, 52.6114, 22.5557>, <17.2608, 52.5298, 21.7054> }
				triangle { <16.8626, 52.7824, 22.5325>, <18.4805, 52.6114, 22.5557>, <17.7157, 52.7256, 22.668> }
				triangle { <16.5769, 53.07918, 21.192>, <17.313, 53.2715, 20.7808>, <18.07831, 53.04589, 20.5008> }
				triangle { <18.07831, 53.04589, 20.5008>, <18.6732, 52.8982, 20.6006>, <18.9791, 52.5498, 20.6865> }
				triangle { <19.2421, 52.2383, 21.9195>, <18.9693, 52.5292, 22.3261>, <18.4805, 52.6114, 22.5557> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <13.4659, 52.8788, 21.5417>, <14.1397, 52.7209, 22.2539>, 0.0696 }
				cylinder { <14.1397, 52.7209, 22.2539>, <14.8134, 52.563, 22.9661>, 0.0696 }
				cylinder { <14.8134, 52.563, 22.9661>, <15.4872, 52.405, 23.6783>, 0.0696 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <15.4872, 52.405, 23.6783>, <17.643, 52.3231, 24.455>, <16.121, 52.07341, 24.3735> }
				triangle { <16.121, 52.07341, 24.3735>, <17.643, 52.3231, 24.455>, <17.8641, 51.7312, 25.2874> }
				triangle { <16.121, 52.07341, 24.3735>, <17.8641, 51.7312, 25.2874>, <16.9925, 51.6859, 25.32> }
				triangle { <17.8641, 51.7312, 25.2874>, <17.1558, 51.6035, 25.5382>, <16.9925, 51.6859, 25.32> }
				triangle { <16.121, 52.07341, 24.3735>, <16.04932, 52.08358, 25.8607>, <15.4872, 52.405, 23.6783> }
				triangle { <16.9101, 51.5346, 26.1463>, <16.9925, 51.6859, 25.32>, <17.1558, 51.6035, 25.5382> }
				triangle { <17.1558, 51.6035, 25.5382>, <17.3242, 51.5735, 25.6655>, <16.9101, 51.5346, 26.1463> }
				triangle { <17.8641, 51.7312, 25.2874>, <17.3242, 51.5735, 25.6655>, <17.1558, 51.6035, 25.5382> }
				triangle { <16.04932, 52.08358, 25.8607>, <15.2659, 52.4757, 24.4897>, <15.4872, 52.405, 23.6783> }
				triangle { <15.4872, 52.405, 23.6783>, <16.2958, 52.6482, 23.5537>, <17.643, 52.3231, 24.455> }
				triangle { <16.121, 52.07341, 24.3735>, <16.9925, 51.6859, 25.32>, <16.9101, 51.5346, 26.1463> }
				triangle { <16.9101, 51.5346, 26.1463>, <16.04932, 52.08358, 25.8607>, <16.121, 52.07341, 24.3735> }
				triangle { <15.2659, 52.4757, 24.4897>, <16.04932, 52.08358, 25.8607>, <15.5814, 52.3164, 25.2799> }
				triangle { <16.2958, 52.6482, 23.5537>, <17.05353, 52.6854, 23.9691>, <17.643, 52.3231, 24.455> }
				triangle { <17.643, 52.3231, 24.455>, <17.8396, 52.1064, 25.00288>, <17.8641, 51.7312, 25.2874> }
				triangle { <16.9101, 51.5346, 26.1463>, <16.4793, 51.907, 26.1478>, <16.04932, 52.08358, 25.8607> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			}
		}
	union { // internode
		cylinder { <6.8732, 52.5293, 14.2951>, <10.7335, 55.9549, 17.7951>, 0.2699 }
		cylinder { <10.7335, 55.9549, 17.7951>, <14.6624, 60.09571, 20.3061>, 0.2699 }
		cylinder { <14.6624, 60.09571, 20.3061>, <18.5087, 64.7926, 21.7316>, 0.2699 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <18.5087, 64.7926, 21.7316>, <19.8882, 66.7277, 21.8404>, 0.05002 }
			cylinder { <19.8882, 66.7277, 21.8404>, <21.1268, 68.7318, 21.51>, 0.05002 }
			cylinder { <21.1268, 68.7318, 21.51>, <22.1769, 70.7278, 20.7531>, 0.05002 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <22.1769, 70.7278, 20.7531>, <22.7242, 71.06068, 20.4384>, 0.05002 }
				cylinder { <22.7242, 71.06068, 20.4384>, <23.3615, 71.04111, 20.1178>, 0.05002 }
				cylinder { <23.3615, 71.04111, 20.1178>, <23.9233, 70.6741, 19.8746>, 0.05002 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <23.9233, 70.6741, 19.8746>, <25.4377, 70.5769, 19.232>, <24.4113, 70.2775, 19.5303> }
				triangle { <24.4113, 70.2775, 19.5303>, <25.4377, 70.5769, 19.232>, <25.6394, 69.9569, 18.8592> }
				triangle { <24.4113, 70.2775, 19.5303>, <25.6394, 69.9569, 18.8592>, <25.0975, 69.7513, 19.1002> }
				triangle { <25.6394, 69.9569, 18.8592>, <25.2341, 69.6238, 19.01698>, <25.0975, 69.7513, 19.1002> }
				triangle { <24.4113, 70.2775, 19.5303>, <24.7578, 69.2784, 19.6944>, <23.9233, 70.6741, 19.8746> }
				triangle { <25.2233, 69.1579, 19.1033>, <25.0975, 69.7513, 19.1002>, <25.2341, 69.6238, 19.01698> }
				triangle { <25.2341, 69.6238, 19.01698>, <25.3637, 69.5675, 18.9576>, <25.2233, 69.1579, 19.1033> }
				triangle { <25.6394, 69.9569, 18.8592>, <25.3637, 69.5675, 18.9576>, <25.2341, 69.6238, 19.01698> }
				triangle { <24.7578, 69.2784, 19.6944>, <24.01655, 70.1047, 20.06193>, <23.9233, 70.6741, 19.8746> }
				triangle { <23.9233, 70.6741, 19.8746>, <24.4533, 70.9656, 19.772>, <25.4377, 70.5769, 19.232> }
				triangle { <24.4113, 70.2775, 19.5303>, <25.0975, 69.7513, 19.1002>, <25.2233, 69.1579, 19.1033> }
				triangle { <25.2233, 69.1579, 19.1033>, <24.7578, 69.2784, 19.6944>, <24.4113, 70.2775, 19.5303> }
				triangle { <24.01655, 70.1047, 20.06193>, <24.7578, 69.2784, 19.6944>, <24.3768, 69.6137, 19.9347> }
				triangle { <24.4533, 70.9656, 19.772>, <25.03972, 70.8495, 19.6016>, <25.4377, 70.5769, 19.232> }
				triangle { <25.4377, 70.5769, 19.232>, <25.6465, 70.2119, 19.08233>, <25.6394, 69.9569, 18.8592> }
				triangle { <25.2233, 69.1579, 19.1033>, <25.05319, 69.1409, 19.4752>, <24.7578, 69.2784, 19.6944> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <22.1769, 70.7278, 20.7531>, <22.2868, 71.4202, 20.6194>, 0.05002 }
				cylinder { <22.2868, 71.4202, 20.6194>, <22.1788, 72.1252, 20.5947>, 0.05002 }
				cylinder { <22.1788, 72.1252, 20.5947>, <21.8654, 72.7605, 20.6818>, 0.05002 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <21.8654, 72.7605, 20.6818>, <20.6813, 73.7349, 21.2852>, <21.5186, 73.3868, 20.6449> }
				triangle { <21.5186, 73.3868, 20.6449>, <20.6813, 73.7349, 21.2852>, <20.5346, 74.3884, 20.9453> }
				triangle { <21.5186, 73.3868, 20.6449>, <20.5346, 74.3884, 20.9453>, <21.06128, 74.2374, 20.6388> }
				triangle { <20.5346, 74.3884, 20.9453>, <20.981, 74.4255, 20.6298>, <21.06128, 74.2374, 20.6388> }
				triangle { <21.5186, 73.3868, 20.6449>, <21.8762, 74.3932, 20.5773>, <21.8654, 72.7605, 20.6818> }
				triangle { <21.2369, 74.7978, 20.4866>, <21.06128, 74.2374, 20.6388>, <20.981, 74.4255, 20.6298> }
				triangle { <20.981, 74.4255, 20.6298>, <20.895, 74.5488, 20.6595>, <21.2369, 74.7978, 20.4866> }
				triangle { <20.5346, 74.3884, 20.9453>, <20.895, 74.5488, 20.6595>, <20.981, 74.4255, 20.6298> }
				triangle { <21.8762, 74.3932, 20.5773>, <22.1924, 73.2687, 20.6291>, <21.8654, 72.7605, 20.6818> }
				triangle { <21.8654, 72.7605, 20.6818>, <21.42, 72.8231, 21.09897>, <20.6813, 73.7349, 21.2852> }
				triangle { <21.5186, 73.3868, 20.6449>, <21.06128, 74.2374, 20.6388>, <21.2369, 74.7978, 20.4866> }
				triangle { <21.2369, 74.7978, 20.4866>, <21.8762, 74.3932, 20.5773>, <21.5186, 73.3868, 20.6449> }
				triangle { <22.1924, 73.2687, 20.6291>, <21.8762, 74.3932, 20.5773>, <22.1144, 73.8851, 20.5991> }
				triangle { <21.42, 72.8231, 21.09897>, <21.0542, 73.2593, 21.3486>, <20.6813, 73.7349, 21.2852> }
				triangle { <20.6813, 73.7349, 21.2852>, <20.6075, 74.1645, 21.189>, <20.5346, 74.3884, 20.9453> }
				triangle { <21.2369, 74.7978, 20.4866>, <21.6175, 74.6884, 20.59>, <21.8762, 74.3932, 20.5773> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <22.1769, 70.7278, 20.7531>, <22.492, 71.3266, 20.526>, 0.05002 }
				cylinder { <22.492, 71.3266, 20.526>, <22.807, 71.9254, 20.299>, 0.05002 }
				cylinder { <22.807, 71.9254, 20.299>, <23.122, 72.5242, 20.07195>, 0.05002 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <23.122, 72.5242, 20.07195>, <23.2254, 74.1642, 19.9482>, <23.3963, 73.08987, 19.7273> }
				triangle { <23.3963, 73.08987, 19.7273>, <23.2254, 74.1642, 19.9482>, <23.6107, 74.466, 19.3785> }
				triangle { <23.3963, 73.08987, 19.7273>, <23.6107, 74.466, 19.3785>, <23.7818, 73.8668, 19.3026> }
				triangle { <23.6107, 74.466, 19.3785>, <23.879, 74.01997, 19.2077>, <23.7818, 73.8668, 19.3026> }
				triangle { <23.3963, 73.08987, 19.7273>, <24.3962, 73.3187, 19.4221>, <23.122, 72.5242, 20.07195> }
				triangle { <24.3118, 73.9625, 19.02341>, <23.7818, 73.8668, 19.3026>, <23.879, 74.01997, 19.2077> }
				triangle { <23.879, 74.01997, 19.2077>, <23.9261, 74.1602, 19.168>, <24.3118, 73.9625, 19.02341> }
				triangle { <23.6107, 74.466, 19.3785>, <23.9261, 74.1602, 19.168>, <23.879, 74.01997, 19.2077> }
				triangle { <24.3962, 73.3187, 19.4221>, <23.7146, 72.5234, 19.9421>, <23.122, 72.5242, 20.07195> }
				triangle { <23.122, 72.5242, 20.07195>, <22.9435, 73.0649, 20.3>, <23.2254, 74.1642, 19.9482> }
				triangle { <23.3963, 73.08987, 19.7273>, <23.7818, 73.8668, 19.3026>, <24.3118, 73.9625, 19.02341> }
				triangle { <24.3118, 73.9625, 19.02341>, <24.3962, 73.3187, 19.4221>, <23.3963, 73.08987, 19.7273> }
				triangle { <23.7146, 72.5234, 19.9421>, <24.3962, 73.3187, 19.4221>, <24.1464, 72.8883, 19.6823> }
				triangle { <22.9435, 73.0649, 20.3>, <23.08812, 73.6688, 20.2722>, <23.2254, 74.1642, 19.9482> }
				triangle { <23.2254, 74.1642, 19.9482>, <23.5063, 74.4005, 19.6941>, <23.6107, 74.466, 19.3785> }
				triangle { <24.3118, 73.9625, 19.02341>, <24.4703, 73.6686, 19.26>, <24.3962, 73.3187, 19.4221> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			}
		}
	union { // internode
		cylinder { <18.5087, 64.7926, 21.7316>, <19.1625, 65.8072, 22.3582>, 0.05887 }
		cylinder { <19.1625, 65.8072, 22.3582>, <19.584, 66.7385, 23.2552>, 0.05887 }
		cylinder { <19.584, 66.7385, 23.2552>, <19.7426, 67.5192, 24.3575>, 0.05887 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <19.7426, 67.5192, 24.3575>, <19.6967, 68.2305, 25.7045>, 0.03204 }
			cylinder { <19.6967, 68.2305, 25.7045>, <19.429, 68.7509, 27.1117>, 0.03204 }
			cylinder { <19.429, 68.7509, 27.1117>, <18.9496, 69.06046, 28.5249>, 0.03204 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <18.9496, 69.06046, 28.5249>, <18.6754, 69.2885, 28.8109>, 0.03204 }
				cylinder { <18.6754, 69.2885, 28.8109>, <18.342, 69.5925, 28.8848>, 0.03204 }
				cylinder { <18.342, 69.5925, 28.8848>, <18.03603, 69.8934, 28.7272>, 0.03204 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // compound leaf petiolet
				cylinder { <18.9496, 69.06046, 28.5249>, <18.9162, 69.04724, 28.9807>, 0.03204 }
				cylinder { <18.9162, 69.04724, 28.9807>, <18.997, 68.9294, 29.415>, 0.03204 }
				cylinder { <18.997, 68.9294, 29.415>, <19.1825, 68.7209, 29.7771>, 0.03204 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // compound leaf petiolet
				cylinder { <18.9496, 69.06046, 28.5249>, <18.8058, 69.1533, 28.9489>, 0.03204 }
				cylinder { <18.8058, 69.1533, 28.9489>, <18.6621, 69.2461, 29.3728>, 0.03204 }
				cylinder { <18.6621, 69.2461, 29.3728>, <18.5183, 69.339, 29.7968>, 0.03204 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			}
		}
	union { // inflorescence
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.7426, 67.5192, 24.3575>, <19.7454, 67.5399, 24.3848>, 0.09849 }
				cylinder { <19.7454, 67.5399, 24.3848>, <19.7469, 67.5617, 24.4115>, 0.09849 }
				cylinder { <19.7469, 67.5617, 24.4115>, <19.7472, 67.5843, 24.4375>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.7472, 67.5843, 24.4375>, <18.7875, 70.7122, 28.3172>, <20.2245, 71.431, 27.7602> }
					triangle { <18.7875, 70.7122, 28.3172>, <18.3976, 75.9026, 30.7312>, <20.2245, 71.431, 27.7602> }
					triangle { <18.7875, 70.7122, 28.3172>, <17.9804, 74.1629, 29.9129>, <18.3976, 75.9026, 30.7312> }
					triangle { <18.3976, 75.9026, 30.7312>, <19.1243, 75.05036, 29.3793>, <20.2245, 71.431, 27.7602> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7472, 67.5843, 24.4375>, <20.4412, 70.2556, 28.6966>, <18.9438, 70.9103, 28.2267> }
					triangle { <20.4412, 70.2556, 28.6966>, <18.6665, 72.5413, 33.6509>, <18.9438, 70.9103, 28.2267> }
					triangle { <20.4412, 70.2556, 28.6966>, <19.5261, 71.4044, 32.2949>, <18.6665, 72.5413, 33.6509> }
					triangle { <18.6665, 72.5413, 33.6509>, <18.07726, 71.9067, 32.1238>, <18.9438, 70.9103, 28.2267> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7472, 67.5843, 24.4375>, <20.119, 71.5702, 27.5569>, <20.2014, 70.3302, 28.7177> }
					triangle { <20.119, 71.5702, 27.5569>, <22.4039, 74.4019, 31.9932>, <20.2014, 70.3302, 28.7177> }
					triangle { <20.119, 71.5702, 27.5569>, <21.9132, 73.8014, 30.1852>, <22.4039, 74.4019, 31.9932> }
					triangle { <22.4039, 74.4019, 31.9932>, <22.239, 72.7941, 31.3077>, <20.2014, 70.3302, 28.7177> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.7426, 67.5192, 24.3575>, <19.7468, 67.5375, 24.3863>, 0.09849 }
				cylinder { <19.7468, 67.5375, 24.3863>, <19.7511, 67.5545, 24.416>, 0.09849 }
				cylinder { <19.7511, 67.5545, 24.416>, <19.7555, 67.5699, 24.4465>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.7555, 67.5699, 24.4465>, <21.2398, 69.2508, 28.9993>, <19.5952, 69.6727, 29.09612> }
					triangle { <21.2398, 69.2508, 28.9993>, <20.6269, 69.8909, 34.6681>, <19.5952, 69.6727, 29.09612> }
					triangle { <21.2398, 69.2508, 28.9993>, <21.2203, 69.3075, 32.8854>, <20.6269, 69.8909, 34.6681> }
					triangle { <20.6269, 69.8909, 34.6681>, <19.7267, 69.5245, 33.2061>, <19.5952, 69.6727, 29.09612> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7555, 67.5699, 24.4465>, <20.4576, 70.6976, 28.3811>, <20.9932, 69.2547, 29.1043> }
					triangle { <20.4576, 70.6976, 28.3811>, <23.4778, 72.7672, 32.7987>, <20.9932, 69.2547, 29.1043> }
					triangle { <20.4576, 70.6976, 28.3811>, <22.6017, 72.5333, 31.05287>, <23.4778, 72.7672, 32.7987> }
					triangle { <23.4778, 72.7672, 32.7987>, <23.332, 71.3666, 31.7503>, <20.9932, 69.2547, 29.1043> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7555, 67.5699, 24.4465>, <19.4995, 69.4309, 29.1612>, <20.6093, 70.5421, 28.5089> }
					triangle { <19.4995, 69.4309, 29.1612>, <19.08944, 73.7128, 32.9581>, <20.6093, 70.5421, 28.5089> }
					triangle { <19.4995, 69.4309, 29.1612>, <18.7037, 72.1662, 31.805>, <19.08944, 73.7128, 32.9581> }
					triangle { <19.08944, 73.7128, 32.9581>, <19.5184, 73.3713, 31.2904>, <20.6093, 70.5421, 28.5089> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.7426, 67.5192, 24.3575>, <19.7476, 67.54, 24.3845>, 0.09849 }
				cylinder { <19.7476, 67.54, 24.3845>, <19.7536, 67.5617, 24.4105>, 0.09849 }
				cylinder { <19.7536, 67.5617, 24.4105>, <19.7606, 67.5843, 24.4355>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.7606, 67.5843, 24.4355>, <20.4811, 71.615, 27.4342>, <21.5335, 70.5284, 28.2112> }
					triangle { <20.4811, 71.615, 27.4342>, <23.7649, 75.2503, 30.421>, <21.5335, 70.5284, 28.2112> }
					triangle { <20.4811, 71.615, 27.4342>, <22.6082, 74.4358, 29.05384>, <23.7649, 75.2503, 30.421> }
					triangle { <23.7649, 75.2503, 30.421>, <23.7631, 73.6471, 29.7057>, <21.5335, 70.5284, 28.2112> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7606, 67.5843, 24.4355>, <20.08329, 70.4037, 28.6431>, <20.7141, 71.5282, 27.5344> }
					triangle { <20.08329, 70.4037, 28.6431>, <19.4614, 75.2853, 31.5932>, <20.7141, 71.5282, 27.5344> }
					triangle { <20.08329, 70.4037, 28.6431>, <19.2295, 73.4681, 30.8759>, <19.4614, 75.2853, 31.5932> }
					triangle { <19.4614, 75.2853, 31.5932>, <19.5884, 74.6562, 29.9591>, <20.7141, 71.5282, 27.5344> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7606, 67.5843, 24.4355>, <21.7414, 70.5532, 28.04382>, <20.1112, 70.6234, 28.5229> }
					triangle { <21.7414, 70.5532, 28.04382>, <22.2923, 72.3437, 33.4669>, <20.1112, 70.6234, 28.5229> }
					triangle { <21.7414, 70.5532, 28.04382>, <22.5962, 71.504, 31.7139>, <22.2923, 72.3437, 33.4669> }
					triangle { <22.2923, 72.3437, 33.4669>, <21.2133, 71.4641, 32.3972>, <20.1112, 70.6234, 28.5229> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.7426, 67.5192, 24.3575>, <19.745, 67.5388, 24.3857>, 0.09849 }
				cylinder { <19.745, 67.5388, 24.3857>, <19.7457, 67.5582, 24.4141>, 0.09849 }
				cylinder { <19.7457, 67.5582, 24.4141>, <19.7447, 67.5773, 24.4428>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.7447, 67.5773, 24.4428>, <19.1531, 69.5729, 29.0715>, <19.2904, 71.0187, 28.1867> }
					triangle { <19.1531, 69.5729, 29.0715>, <16.8854, 73.3198, 32.7779>, <19.2904, 71.0187, 28.1867> }
					triangle { <19.1531, 69.5729, 29.0715>, <17.3115, 71.6915, 31.7594>, <16.8854, 73.3198, 32.7779> }
					triangle { <16.8854, 73.3198, 32.7779>, <17.1791, 73.06368, 31.0662>, <19.2904, 71.0187, 28.1867> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7447, 67.5773, 24.4428>, <20.6216, 70.3972, 28.5703>, <19.07827, 69.8147, 28.9833> }
					triangle { <20.6216, 70.3972, 28.5703>, <20.602, 71.3278, 34.2318>, <19.07827, 69.8147, 28.9833> }
					triangle { <20.6216, 70.3972, 28.5703>, <21.1511, 70.9538, 32.3801>, <20.602, 71.3278, 34.2318> }
					triangle { <20.602, 71.3278, 34.2318>, <19.8813, 70.3214, 32.987>, <19.07827, 69.8147, 28.9833> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7447, 67.5773, 24.4428>, <19.03869, 71.02943, 28.09544>, <20.4414, 70.291, 28.7109> }
					triangle { <19.03869, 71.02943, 28.09544>, <20.8604, 75.06165, 31.7481>, <20.4414, 70.291, 28.7109> }
					triangle { <19.03869, 71.02943, 28.09544>, <20.03746, 74.1205, 30.2291>, <20.8604, 75.06165, 31.7481> }
					triangle { <20.8604, 75.06165, 31.7481>, <21.4222, 73.7132, 30.7744>, <20.4414, 70.291, 28.7109> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.7426, 67.5192, 24.3575>, <19.7481, 67.5381, 24.3857>, 0.09849 }
				cylinder { <19.7481, 67.5381, 24.3857>, <19.7549, 67.5562, 24.4142>, 0.09849 }
				cylinder { <19.7549, 67.5562, 24.4142>, <19.7632, 67.5733, 24.443>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.7632, 67.5733, 24.443>, <21.8797, 70.2349, 28.2103>, <20.6761, 69.4364, 29.1079> }
					triangle { <21.8797, 70.2349, 28.2103>, <23.9421, 70.8212, 33.5322>, <20.6761, 69.4364, 29.1079> }
					triangle { <21.8797, 70.2349, 28.2103>, <23.7728, 70.63, 31.5816>, <23.9421, 70.8212, 33.5322> }
					triangle { <23.9421, 70.8212, 33.5322>, <22.8996, 69.8057, 32.5504>, <20.6761, 69.4364, 29.1079> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7632, 67.5733, 24.443>, <20.1982, 70.7007, 28.4162>, <21.7815, 70.08048, 28.4061> }
					triangle { <20.1982, 70.7007, 28.4162>, <22.9281, 74.6743, 31.5272>, <21.7815, 70.08048, 28.4061> }
					triangle { <20.1982, 70.7007, 28.4162>, <21.6757, 73.745, 30.328>, <22.9281, 74.6743, 31.5272> }
					triangle { <22.9281, 74.6743, 31.5272>, <23.1909, 73.4556, 30.2911>, <21.7815, 70.08048, 28.4061> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7632, 67.5733, 24.443>, <20.8019, 69.2014, 29.1363>, <20.4502, 70.7023, 28.4183> }
					triangle { <20.8019, 69.2014, 29.1363>, <19.7794, 72.403, 33.7864>, <20.4502, 70.7023, 28.4183> }
					triangle { <20.8019, 69.2014, 29.1363>, <19.9369, 70.9053, 32.5206>, <19.7794, 72.403, 33.7864> }
					triangle { <19.7794, 72.403, 33.7864>, <19.4177, 72.2875, 32.07246>, <20.4502, 70.7023, 28.4183> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.7426, 67.5192, 24.3575>, <19.7461, 67.5403, 24.3844>, 0.09849 }
				cylinder { <19.7461, 67.5403, 24.3844>, <19.7492, 67.5627, 24.4104>, 0.09849 }
				cylinder { <19.7492, 67.5627, 24.4104>, <19.7517, 67.5863, 24.4354>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.7517, 67.5863, 24.4354>, <19.1672, 71.296, 27.8492>, <20.8657, 71.2909, 27.7672> }
					triangle { <19.1672, 71.296, 27.8492>, <20.3643, 76.4544, 30.0575>, <20.8657, 71.2909, 27.7672> }
					triangle { <19.1672, 71.296, 27.8492>, <19.4945, 74.9474, 29.1395>, <20.3643, 76.4544, 30.0575> }
					triangle { <20.3643, 76.4544, 30.0575>, <21.00647, 75.2171, 28.9904>, <20.8657, 71.2909, 27.7672> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7517, 67.5863, 24.4354>, <20.2873, 70.2574, 28.7174>, <19.4114, 71.4001, 27.8125> }
					triangle { <20.2873, 70.2574, 28.7174>, <18.3405, 73.6726, 32.8966>, <19.4114, 71.4001, 27.8125> }
					triangle { <20.2873, 70.2574, 28.7174>, <18.9768, 72.1231, 31.8649>, <18.3405, 73.6726, 32.8966> }
					triangle { <18.3405, 73.6726, 32.8966>, <17.9935, 73.1459, 31.2583>, <19.4114, 71.4001, 27.8125> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7517, 67.5863, 24.4354>, <20.8916, 71.4341, 27.5422>, <20.107, 70.4252, 28.6639> }
					triangle { <20.8916, 71.4341, 27.5422>, <22.8132, 73.6249, 32.4846>, <20.107, 70.4252, 28.6639> }
					triangle { <20.8916, 71.4341, 27.5422>, <22.6447, 73.05345, 30.6097>, <22.8132, 73.6249, 32.4846> }
					triangle { <22.8132, 73.6249, 32.4846>, <22.1793, 72.1512, 31.7717>, <20.107, 70.4252, 28.6639> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.7426, 67.5192, 24.3575>, <19.7459, 67.5377, 24.3863>, 0.09849 }
				cylinder { <19.7459, 67.5377, 24.3863>, <19.7484, 67.555, 24.416>, 0.09849 }
				cylinder { <19.7484, 67.555, 24.416>, <19.7502, 67.571, 24.4464>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.7502, 67.571, 24.4464>, <20.4603, 69.06165, 29.2455>, <19.1991, 70.125, 28.8327> }
					triangle { <20.4603, 69.06165, 29.2455>, <18.6096, 70.6052, 34.4524>, <19.1991, 70.125, 28.8327> }
					triangle { <20.4603, 69.06165, 29.2455>, <19.3732, 69.611, 32.9362>, <18.6096, 70.6052, 34.4524> }
					triangle { <18.6096, 70.6052, 34.4524>, <18.09143, 70.4559, 32.7817>, <19.1991, 70.125, 28.8327> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7502, 67.571, 24.4464>, <20.5786, 70.6108, 28.4252>, <20.2204, 69.1787, 29.2693> }
					triangle { <20.5786, 70.6108, 28.4252>, <22.8128, 71.8105, 33.5719>, <20.2204, 69.1787, 29.2693> }
					triangle { <20.5786, 70.6108, 28.4252>, <22.4518, 71.7354, 31.6395>, <22.8128, 71.8105, 33.5719> }
					triangle { <22.8128, 71.8105, 33.5719>, <22.3859, 70.4707, 32.5209>, <20.2204, 69.1787, 29.2693> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7502, 67.571, 24.4464>, <18.9954, 69.9535, 28.8636>, <20.6068, 70.4245, 28.5925> }
					triangle { <18.9954, 69.9535, 28.8636>, <19.3984, 74.4728, 32.3754>, <20.6068, 70.4245, 28.5925> }
					triangle { <18.9954, 69.9535, 28.8636>, <18.7325, 73.08534, 31.15>, <19.3984, 74.4728, 32.3754> }
					triangle { <19.3984, 74.4728, 32.3754>, <20.09143, 73.7789, 30.9193>, <20.6068, 70.4245, 28.5925> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.7426, 67.5192, 24.3575>, <19.7482, 67.5393, 24.3848>, 0.09849 }
				cylinder { <19.7482, 67.5393, 24.3848>, <19.7553, 67.5598, 24.4116>, 0.09849 }
				cylinder { <19.7553, 67.5598, 24.4116>, <19.7639, 67.5806, 24.4376>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.7639, 67.5806, 24.4376>, <21.2566, 71.3116, 27.5374>, <21.4793, 69.9982, 28.5944> }
					triangle { <21.2566, 71.3116, 27.5374>, <24.7877, 73.64, 31.4143>, <21.4793, 69.9982, 28.5944> }
					triangle { <21.2566, 71.3116, 27.5374>, <23.8313, 73.2016, 29.7519>, <24.7877, 73.64, 31.4143> }
					triangle { <24.7877, 73.64, 31.4143>, <24.3043, 72.1001, 30.7234>, <21.4793, 69.9982, 28.5944> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7639, 67.5806, 24.4376>, <20.05781, 70.5304, 28.5571>, <21.3916, 71.1509, 27.7041> }
					triangle { <20.05781, 70.5304, 28.5571>, <20.7729, 75.5716, 31.2017>, <21.3916, 71.1509, 27.7041> }
					triangle { <20.05781, 70.5304, 28.5571>, <20.00113, 73.9318, 30.4366>, <20.7729, 75.5716, 31.2017> }
					triangle { <20.7729, 75.5716, 31.2017>, <21.07422, 74.7448, 29.6827>, <21.3916, 71.1509, 27.7041> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7639, 67.5806, 24.4376>, <21.7157, 69.915, 28.4995>, <20.2093, 70.7026, 28.4527> }
					triangle { <21.7157, 69.915, 28.4995>, <21.425, 71.9944, 33.839>, <20.2093, 70.7026, 28.4527> }
					triangle { <21.7157, 69.915, 28.4995>, <21.8222, 70.8899, 32.2602>, <21.425, 71.9944, 33.839> }
					triangle { <21.425, 71.9944, 33.839>, <20.4239, 71.5031, 32.4832>, <20.2093, 70.7026, 28.4527> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.7426, 67.5192, 24.3575>, <19.745, 67.5395, 24.3851>, 0.09849 }
				cylinder { <19.745, 67.5395, 24.3851>, <19.7459, 67.5603, 24.4126>, 0.09849 }
				cylinder { <19.7459, 67.5603, 24.4126>, <19.7452, 67.5816, 24.4396>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.7452, 67.5816, 24.4396>, <18.7834, 70.2116, 28.6723>, <19.7669, 71.3519, 27.8821> }
					triangle { <18.7834, 70.2116, 28.6723>, <17.387, 74.992, 31.5215>, <19.7669, 71.3519, 27.8821> }
					triangle { <18.7834, 70.2116, 28.6723>, <17.3462, 73.217, 30.674>, <17.387, 74.992, 31.5215> }
					triangle { <17.387, 74.992, 31.5215>, <18.01245, 74.4247, 29.9823>, <19.7669, 71.3519, 27.8821> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7452, 67.5816, 24.4396>, <20.5383, 70.2962, 28.6538>, <18.847, 70.4497, 28.5668> }
					triangle { <20.5383, 70.2962, 28.6538>, <19.3235, 71.8601, 34.03883>, <18.847, 70.4497, 28.5668> }
					triangle { <20.5383, 70.2962, 28.6538>, <20.1577, 71.06472, 32.4445>, <19.3235, 71.8601, 34.03883> }
					triangle { <19.3235, 71.8601, 34.03883>, <18.6256, 71.08622, 32.626>, <18.847, 70.4497, 28.5668> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7452, 67.5816, 24.4396>, <19.5807, 71.4527, 27.7176>, <20.2985, 70.2912, 28.7313> }
					triangle { <19.5807, 71.4527, 27.7176>, <21.8366, 74.8192, 31.7793>, <20.2985, 70.2912, 28.7313> }
					triangle { <19.5807, 71.4527, 27.7176>, <21.1558, 74.1114, 30.07468>, <21.8366, 74.8192, 31.7793> }
					triangle { <21.8366, 74.8192, 31.7793>, <22.01909, 73.2478, 31.01807>, <20.2985, 70.2912, 28.7313> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.7426, 67.5192, 24.3575>, <19.7474, 67.5377, 24.3861>, 0.09849 }
				cylinder { <19.7474, 67.5377, 24.3861>, <19.753, 67.5548, 24.4155>, 0.09849 }
				cylinder { <19.753, 67.5548, 24.4155>, <19.7593, 67.5705, 24.4455>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.7593, 67.5705, 24.4455>, <21.6521, 69.5917, 28.6986>, <20.02434, 69.4726, 29.176> }
					triangle { <21.6521, 69.5917, 28.6986>, <22.176, 69.9536, 34.4007>, <20.02434, 69.4726, 29.176> }
					triangle { <21.6521, 69.5917, 28.6986>, <22.4984, 69.6036, 32.4919>, <22.176, 69.9536, 34.4007> }
					triangle { <22.176, 69.9536, 34.4007>, <21.1235, 69.3357, 33.1389>, <20.02434, 69.4726, 29.176> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7593, 67.5705, 24.4455>, <20.3471, 70.7237, 28.3785>, <21.4467, 69.5166, 28.8536> }
					triangle { <20.3471, 70.7237, 28.3785>, <23.5113, 73.5991, 32.2047>, <21.4467, 69.5166, 28.8536> }
					triangle { <20.3471, 70.7237, 28.3785>, <22.3763, 73.1171, 30.6718>, <23.5113, 73.5991, 32.2047> }
					triangle { <23.5113, 73.5991, 32.2047>, <23.5658, 72.2338, 31.1025>, <21.4467, 69.5166, 28.8536> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7593, 67.5705, 24.4455>, <20.02434, 69.2124, 29.2404>, <20.5638, 70.6228, 28.4583> }
					triangle { <20.02434, 69.2124, 29.2404>, <19.2001, 73.1115, 33.368>, <20.5638, 70.6228, 28.4583> }
					triangle { <20.02434, 69.2124, 29.2404>, <19.05366, 71.5329, 32.2032>, <19.2001, 73.1115, 33.368> }
					triangle { <19.2001, 73.1115, 33.368>, <19.3227, 72.9381, 31.6254>, <20.5638, 70.6228, 28.4583> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.7426, 67.5192, 24.3575>, <19.747, 67.5402, 24.3843>, 0.09849 }
				cylinder { <19.747, 67.5402, 24.3843>, <19.7519, 67.5625, 24.4102>, 0.09849 }
				cylinder { <19.7519, 67.5625, 24.4102>, <19.7571, 67.586, 24.4348>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.7571, 67.586, 24.4348>, <19.8742, 71.6104, 27.5247>, <21.3553, 70.9039, 27.9709> }
					triangle { <19.8742, 71.6104, 27.5247>, <22.4799, 76.06799, 30.02684>, <21.3553, 70.9039, 27.9709> }
					triangle { <19.8742, 71.6104, 27.5247>, <21.3484, 74.943, 28.8759>, <22.4799, 76.06799, 30.02684> }
					triangle { <22.4799, 76.06799, 30.02684>, <22.8051, 74.5526, 29.2022>, <21.3553, 70.9039, 27.9709> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7571, 67.586, 24.4348>, <20.1499, 70.3244, 28.6897>, <20.1388, 71.6006, 27.5659> }
					triangle { <20.1499, 70.3244, 28.6897>, <18.7548, 74.7336, 32.0856>, <20.1388, 71.6006, 27.5659> }
					triangle { <20.1499, 70.3244, 28.6897>, <18.932, 72.9427, 31.2909>, <18.7548, 74.7336, 32.0856> }
					triangle { <18.7548, 74.7336, 32.0856>, <18.6935, 74.1917, 30.4168>, <20.1388, 71.6006, 27.5659> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <19.7571, 67.586, 24.4348>, <21.502, 70.9945, 27.7657>, <20.08156, 70.5428, 28.5843> }
					triangle { <21.502, 70.9945, 27.7657>, <22.6955, 72.8174, 33.07347>, <20.08156, 70.5428, 28.5843> }
					triangle { <21.502, 70.9945, 27.7657>, <22.8352, 72.1325, 31.2345>, <22.6955, 72.8174, 33.07347> }
					triangle { <22.6955, 72.8174, 33.07347>, <21.7233, 71.6524, 32.1905>, <20.08156, 70.5428, 28.5843> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		}
	union { // internode
		cylinder { <-2.08771, 38.9358, 2.5227>, <-1.7317, 45.835, 3.07505>, 0.3 }
		cylinder { <-1.7317, 45.835, 3.07505>, <-1.3916, 52.7506, 2.7777>, 0.3 }
		cylinder { <-1.3916, 52.7506, 2.7777>, <-1.07251, 59.5788, 1.6352>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.07251, 59.5788, 1.6352>, <-0.612, 70.3956, -2.4635>, 0.2434 }
			cylinder { <-0.612, 70.3956, -2.4635>, <-0.2419, 80.2078, -8.5953>, 0.2434 }
			cylinder { <-0.2419, 80.2078, -8.5953>, <0.02374, 88.6384, -16.5244>, 0.2434 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <0.02374, 88.6384, -16.5244>, <1.8024, 90.7535, -18.6278>, 0.2434 }
				cylinder { <1.8024, 90.7535, -18.6278>, <4.8179, 91.9049, -19.9092>, 0.2434 }
				cylinder { <4.8179, 91.9049, -19.9092>, <8.2868, 91.7935, -20.03591>, 0.2434 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <8.2868, 91.7935, -20.03591>, <15.4058, 94.5823, -22.4541>, <11.6853, 91.1752, -20.5235> }
				triangle { <11.6853, 91.1752, -20.5235>, <15.4058, 94.5823, -22.4541>, <18.2752, 92.3206, -22.5423> }
				triangle { <11.6853, 91.1752, -20.5235>, <18.2752, 92.3206, -22.5423>, <16.3081, 90.5176, -21.05589> }
				triangle { <18.2752, 92.3206, -22.5423>, <17.2818, 90.313, -21.09704>, <16.3081, 90.5176, -21.05589> }
				triangle { <11.6853, 91.1752, -20.5235>, <15.2891, 89.04984, -17.4228>, <8.2868, 91.7935, -20.03591> }
				triangle { <18.2704, 88.8457, -19.6177>, <16.3081, 90.5176, -21.05589>, <17.2818, 90.313, -21.09704> }
				triangle { <17.2818, 90.313, -21.09704>, <18.01621, 90.3788, -21.2077>, <18.2704, 88.8457, -19.6177> }
				triangle { <18.2752, 92.3206, -22.5423>, <18.01621, 90.3788, -21.2077>, <17.2818, 90.313, -21.09704> }
				triangle { <15.2891, 89.04984, -17.4228>, <9.7955, 90.4613, -17.8764>, <8.2868, 91.7935, -20.03591> }
				triangle { <8.2868, 91.7935, -20.03591>, <9.7938, 94.1206, -21.142>, <15.4058, 94.5823, -22.4541> }
				triangle { <11.6853, 91.1752, -20.5235>, <16.3081, 90.5176, -21.05589>, <18.2704, 88.8457, -19.6177> }
				triangle { <18.2704, 88.8457, -19.6177>, <15.2891, 89.04984, -17.4228>, <11.6853, 91.1752, -20.5235> }
				triangle { <9.7955, 90.4613, -17.8764>, <15.2891, 89.04984, -17.4228>, <12.6131, 89.5664, -17.2244> }
				triangle { <9.7938, 94.1206, -21.142>, <12.6319, 95.08046, -21.5586>, <15.4058, 94.5823, -22.4541> }
				triangle { <15.4058, 94.5823, -22.4541>, <17.3482, 93.6424, -22.2063>, <18.2752, 92.3206, -22.5423> }
				triangle { <18.2704, 88.8457, -19.6177>, <17.1071, 89.00771, -18.00929>, <15.2891, 89.04984, -17.4228> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <0.02374, 88.6384, -16.5244>, <-1.06952, 91.07819, -18.7411>, 0.2434 }
				cylinder { <-1.06952, 91.07819, -18.7411>, <-3.2079, 93.1433, -20.5366>, 0.2434 }
				cylinder { <-3.2079, 93.1433, -20.5366>, <-6.1415, 94.5923, -21.701>, 0.2434 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <-6.1415, 94.5923, -21.701>, <-14.08311, 95.6912, -21.5299>, <-9.00502, 95.6789, -23.3713> }
				triangle { <-9.00502, 95.6789, -23.3713>, <-14.08311, 95.6912, -21.5299>, <-15.79, 96.8678, -24.5397> }
				triangle { <-9.00502, 95.6789, -23.3713>, <-15.79, 96.8678, -24.5397>, <-12.9038, 97.2768, -25.4525> }
				triangle { <-15.79, 96.8678, -24.5397>, <-13.6728, 97.6756, -25.9438>, <-12.9038, 97.2768, -25.4525> }
				triangle { <-9.00502, 95.6789, -23.3713>, <-9.9999, 100.0348, -26.04632>, <-6.1415, 94.5923, -21.701> }
				triangle { <-13.3844, 99.4166, -27.4285>, <-12.9038, 97.2768, -25.4525>, <-13.6728, 97.6756, -25.9438> }
				triangle { <-13.6728, 97.6756, -25.9438>, <-14.3593, 97.9091, -26.1171>, <-13.3844, 99.4166, -27.4285> }
				triangle { <-15.79, 96.8678, -24.5397>, <-14.3593, 97.9091, -26.1171>, <-13.6728, 97.6756, -25.9438> }
				triangle { <-9.9999, 100.0348, -26.04632>, <-6.04155, 97.1771, -23.1234>, <-6.1415, 94.5923, -21.701> }
				triangle { <-6.1415, 94.5923, -21.701>, <-8.6491, 94.3242, -20.1042>, <-14.08311, 95.6912, -21.5299> }
				triangle { <-9.00502, 95.6789, -23.3713>, <-12.9038, 97.2768, -25.4525>, <-13.3844, 99.4166, -27.4285> }
				triangle { <-13.3844, 99.4166, -27.4285>, <-9.9999, 100.0348, -26.04632>, <-9.00502, 95.6789, -23.3713> }
				triangle { <-6.04155, 97.1771, -23.1234>, <-9.9999, 100.0348, -26.04632>, <-7.8348, 99.01418, -24.7279> }
				triangle { <-8.6491, 94.3242, -20.1042>, <-11.5294, 95.2482, -20.1063>, <-14.08311, 95.6912, -21.5299> }
				triangle { <-14.08311, 95.6912, -21.5299>, <-15.3002, 96.7721, -22.968>, <-15.79, 96.8678, -24.5397> }
				triangle { <-13.3844, 99.4166, -27.4285>, <-11.7668, 100.3304, -26.7108>, <-9.9999, 100.0348, -26.04632> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <0.02374, 88.6384, -16.5244>, <0.1034, 91.1675, -18.9032>, 0.2434 }
				cylinder { <0.1034, 91.1675, -18.9032>, <0.1831, 93.6967, -21.2819>, 0.2434 }
				cylinder { <0.1831, 93.6967, -21.2819>, <0.2628, 96.2259, -23.6606>, 0.2434 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <0.2628, 96.2259, -23.6606>, <-3.2221, 101.9221, -28.1006>, <0.4342, 98.3003, -26.4602> }
				triangle { <0.4342, 98.3003, -26.4602>, <-3.2221, 101.9221, -28.1006>, <-1.6348, 102.9795, -31.2182> }
				triangle { <0.4342, 98.3003, -26.4602>, <-1.6348, 102.9795, -31.2182>, <0.6338, 101.2674, -30.09929> }
				triangle { <-1.6348, 102.9795, -31.2182>, <0.7727, 101.8916, -30.8626>, <0.6338, 101.2674, -30.09929> }
				triangle { <0.4342, 98.3003, -26.4602>, <4.2353, 101.3756, -28.2529>, <0.2628, 96.2259, -23.6606> }
				triangle { <2.8819, 102.5854, -31.4859>, <0.6338, 101.2674, -30.09929>, <0.7727, 101.8916, -30.8626> }
				triangle { <0.7727, 101.8916, -30.8626>, <0.6672, 102.4333, -31.3639>, <2.8819, 102.5854, -31.4859> }
				triangle { <-1.6348, 102.9795, -31.2182>, <0.6672, 102.4333, -31.3639>, <0.7727, 101.8916, -30.8626> }
				triangle { <4.2353, 101.3756, -28.2529>, <2.7802, 97.6773, -24.1806>, <0.2628, 96.2259, -23.6606> }
				triangle { <0.2628, 96.2259, -23.6606>, <-2.1097, 98.00603, -23.995>, <-3.2221, 101.9221, -28.1006> }
				triangle { <0.4342, 98.3003, -26.4602>, <0.6338, 101.2674, -30.09929>, <2.8819, 102.5854, -31.4859> }
				triangle { <2.8819, 102.5854, -31.4859>, <4.2353, 101.3756, -28.2529>, <0.4342, 98.3003, -26.4602> }
				triangle { <2.7802, 97.6773, -24.1806>, <4.2353, 101.3756, -28.2529>, <3.9465, 99.6753, -26.1333> }
				triangle { <-2.1097, 98.00603, -23.995>, <-3.000414, 100.4432, -25.5496>, <-3.2221, 101.9221, -28.1006> }
				triangle { <-3.2221, 101.9221, -28.1006>, <-2.3382, 103.0562, -29.7286>, <-1.6348, 102.9795, -31.2182> }
				triangle { <2.8819, 102.5854, -31.4859>, <3.8925, 102.4816, -29.7729>, <4.2353, 101.3756, -28.2529> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			}
		}
	union { // internode
		cylinder { <-1.07251, 59.5788, 1.6352>, <-0.864, 66.4312, 0.6196>, 0.3 }
		cylinder { <-0.864, 66.4312, 0.6196>, <-0.7664, 73.3037, -0.2685>, 0.3 }
		cylinder { <-0.7664, 73.3037, -0.2685>, <-0.7797, 80.1923, -1.02864>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.7797, 80.1923, -1.02864>, <-2.1428, 90.6604, -0.6111>, 0.2221 }
			cylinder { <-2.1428, 90.6604, -0.6111>, <-4.7965, 100.6935, 1.3666>, 0.2221 }
			cylinder { <-4.7965, 100.6935, 1.3666>, <-8.6388, 109.9058, 4.8286>, 0.2221 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-8.6388, 109.9058, 4.8286>, <-10.8266, 112.1965, 4.7204>, 0.2221 }
				cylinder { <-10.8266, 112.1965, 4.7204>, <-13.481, 113.4191, 3.4937>, 0.2221 }
				cylinder { <-13.481, 113.4191, 3.4937>, <-15.9123, 113.2558, 1.467>, 0.2221 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <-15.9123, 113.2558, 1.467>, <-21.805, 116.0696, -1.8367>, <-18.5789, 112.7261, -0.1894> }
				triangle { <-18.5789, 112.7261, -0.1894>, <-21.805, 116.0696, -1.8367>, <-24.0889, 114.0113, -3.1295> }
				triangle { <-18.5789, 112.7261, -0.1894>, <-24.0889, 114.0113, -3.1295>, <-22.1037, 112.1386, -2.5612> }
				triangle { <-24.0889, 114.0113, -3.1295>, <-22.8121, 111.9407, -3.09499>, <-22.1037, 112.1386, -2.5612> }
				triangle { <-18.5789, 112.7261, -0.1894>, <-19.4258, 110.0608, -4.03207>, <-15.9123, 113.2558, 1.467> }
				triangle { <-22.7821, 110.2876, -4.3973>, <-22.1037, 112.1386, -2.5612>, <-22.8121, 111.9407, -3.09499> }
				triangle { <-22.8121, 111.9407, -3.09499>, <-23.3656, 112.0038, -3.4857>, <-22.7821, 110.2876, -4.3973> }
				triangle { <-24.0889, 114.0113, -3.1295>, <-23.3656, 112.0038, -3.4857>, <-22.8121, 111.9407, -3.09499> }
				triangle { <-19.4258, 110.0608, -4.03207>, <-15.8072, 111.5573, -0.6214>, <-15.9123, 113.2558, 1.467> }
				triangle { <-15.9123, 113.2558, 1.467>, <-17.2903, 115.52, 0.8385>, <-21.805, 116.0696, -1.8367> }
				triangle { <-18.5789, 112.7261, -0.1894>, <-22.1037, 112.1386, -2.5612>, <-22.7821, 110.2876, -4.3973> }
				triangle { <-22.7821, 110.2876, -4.3973>, <-19.4258, 110.0608, -4.03207>, <-18.5789, 112.7261, -0.1894> }
				triangle { <-15.8072, 111.5573, -0.6214>, <-19.4258, 110.0608, -4.03207>, <-17.4336, 110.5454, -2.6124> }
				triangle { <-17.2903, 115.52, 0.8385>, <-19.3307, 116.3858, -0.8069>, <-21.805, 116.0696, -1.8367> }
				triangle { <-21.805, 116.0696, -1.8367>, <-23.08942, 115.131, -3.01931>, <-24.0889, 114.0113, -3.1295> }
				triangle { <-22.7821, 110.2876, -4.3973>, <-21.01027, 110.105, -4.7589>, <-19.4258, 110.0608, -4.03207> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <-8.6388, 109.9058, 4.8286>, <-8.9143, 112.5858, 6.498>, 0.2221 }
				cylinder { <-8.9143, 112.5858, 6.498>, <-8.2804, 114.8688, 8.6031>, 0.2221 }
				cylinder { <-8.2804, 114.8688, 8.6031>, <-6.8113, 116.4879, 10.8978>, 0.2221 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <-6.8113, 116.4879, 10.8978>, <-1.2065, 117.6347, 15.4615>, <-5.7404, 117.8966, 13.5444> }
				triangle { <-5.7404, 117.8966, 13.5444>, <-1.2065, 117.6347, 15.4615>, <-1.7086, 119.3894, 18.2531> }
				triangle { <-5.7404, 117.8966, 13.5444>, <-1.7086, 119.3894, 18.2531>, <-4.151, 119.8768, 17.00091> }
				triangle { <-1.7086, 119.3894, 18.2531>, <-3.8752, 120.3593, 17.7199>, <-4.151, 119.8768, 17.00091> }
				triangle { <-5.7404, 117.8966, 13.5444>, <-6.108, 122.3711, 15.1033>, <-6.8113, 116.4879, 10.8978> }
				triangle { <-4.7346, 122.2216, 18.1922>, <-4.151, 119.8768, 17.00091>, <-3.8752, 120.3593, 17.7199> }
				triangle { <-3.8752, 120.3593, 17.7199>, <-3.4856, 120.6227, 18.2116>, <-4.7346, 122.2216, 18.1922> }
				triangle { <-1.7086, 119.3894, 18.2531>, <-3.4856, 120.6227, 18.2116>, <-3.8752, 120.3593, 17.7199> }
				triangle { <-6.108, 122.3711, 15.1033>, <-7.3962, 119.0879, 11.2919>, <-6.8113, 116.4879, 10.8978> }
				triangle { <-6.8113, 116.4879, 10.8978>, <-4.1953, 115.9632, 11.4472>, <-1.2065, 117.6347, 15.4615> }
				triangle { <-5.7404, 117.8966, 13.5444>, <-4.151, 119.8768, 17.00091>, <-4.7346, 122.2216, 18.1922> }
				triangle { <-4.7346, 122.2216, 18.1922>, <-6.108, 122.3711, 15.1033>, <-5.7404, 117.8966, 13.5444> }
				triangle { <-7.3962, 119.0879, 11.2919>, <-6.108, 122.3711, 15.1033>, <-6.9102, 121.1174, 13.1024> }
				triangle { <-4.1953, 115.9632, 11.4472>, <-2.1326, 116.8584, 13.04862>, <-1.2065, 117.6347, 15.4615> }
				triangle { <-1.2065, 117.6347, 15.4615>, <-1.1079, 118.9428, 16.9475>, <-1.7086, 119.3894, 18.2531> }
				triangle { <-4.7346, 122.2216, 18.1922>, <-5.2762, 122.8274, 16.5664>, <-6.108, 122.3711, 15.1033> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <-8.6388, 109.9058, 4.8286>, <-9.7915, 112.6695, 5.8672>, 0.2221 }
				cylinder { <-9.7915, 112.6695, 5.8672>, <-10.9442, 115.4332, 6.9058>, 0.2221 }
				cylinder { <-10.9442, 115.4332, 6.9058>, <-12.09695, 118.1969, 7.9444>, 0.2221 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <-12.09695, 118.1969, 7.9444>, <-11.6694, 124.3156, 11.9362>, <-13.6234, 120.6491, 9.283> }
				triangle { <-13.6234, 120.6491, 9.283>, <-11.6694, 124.3156, 11.9362>, <-14.4747, 125.9008, 12.7974> }
				triangle { <-13.6234, 120.6491, 9.283>, <-14.4747, 125.9008, 12.7974>, <-15.5567, 124.0768, 10.9883> }
				triangle { <-14.4747, 125.9008, 12.7974>, <-16.02755, 124.7948, 11.286>, <-15.5567, 124.0768, 10.9883> }
				triangle { <-13.6234, 120.6491, 9.283>, <-16.8643, 123.6663, 7.557>, <-12.09695, 118.1969, 7.9444> }
				triangle { <-17.7347, 125.4906, 10.2706>, <-15.5567, 124.0768, 10.9883>, <-16.02755, 124.7948, 11.286> }
				triangle { <-16.02755, 124.7948, 11.286>, <-16.1868, 125.3882, 11.5784>, <-17.7347, 125.4906, 10.2706> }
				triangle { <-14.4747, 125.9008, 12.7974>, <-16.1868, 125.3882, 11.5784>, <-16.02755, 124.7948, 11.286> }
				triangle { <-16.8643, 123.6663, 7.557>, <-13.9189, 119.5291, 6.4736>, <-12.09695, 118.1969, 7.9444> }
				triangle { <-12.09695, 118.1969, 7.9444>, <-10.4648, 119.9096, 9.2947>, <-11.6694, 124.3156, 11.9362> }
				triangle { <-13.6234, 120.6491, 9.283>, <-15.5567, 124.0768, 10.9883>, <-17.7347, 125.4906, 10.2706> }
				triangle { <-17.7347, 125.4906, 10.2706>, <-16.8643, 123.6663, 7.557>, <-13.6234, 120.6491, 9.283> }
				triangle { <-13.9189, 119.5291, 6.4736>, <-16.8643, 123.6663, 7.557>, <-15.6181, 121.6992, 6.6646> }
				triangle { <-10.4648, 119.9096, 9.2947>, <-10.4798, 122.4349, 10.4096>, <-11.6694, 124.3156, 11.9362> }
				triangle { <-11.6694, 124.3156, 11.9362>, <-13.09572, 125.6567, 12.2464>, <-14.4747, 125.9008, 12.7974> }
				triangle { <-17.7347, 125.4906, 10.2706>, <-17.4016, 124.9915, 8.555>, <-16.8643, 123.6663, 7.557> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			}
		}
	union { // internode
		cylinder { <-0.7797, 80.1923, -1.02864>, <-2.6177, 85.9585, 0.4743>, 0.2699 }
		cylinder { <-2.6177, 85.9585, 0.4743>, <-5.8893, 90.06136, 3.8434>, 0.2699 }
		cylinder { <-5.8893, 90.06136, 3.8434>, <-9.8959, 91.6245, 8.359>, 0.2699 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.8959, 91.6245, 8.359>, <-11.4459, 91.7613, 10.1586>, 0.05002 }
			cylinder { <-11.4459, 91.7613, 10.1586>, <-12.9578, 91.4335, 11.9659>, 0.05002 }
			cylinder { <-12.9578, 91.4335, 11.9659>, <-14.3734, 90.6534, 13.7115>, 0.05002 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-14.3734, 90.6534, 13.7115>, <-15.00982, 90.4242, 13.9393>, 0.05002 }
				cylinder { <-15.00982, 90.4242, 13.9393>, <-15.6924, 90.2592, 13.812>, 0.05002 }
				cylinder { <-15.6924, 90.2592, 13.812>, <-16.2439, 90.2015, 13.3628>, 0.05002 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <-16.2439, 90.2015, 13.3628>, <-17.8353, 89.9317, 13.03019>, <-16.741, 90.03399, 12.8741> }
				triangle { <-16.741, 90.03399, 12.8741>, <-17.8353, 89.9317, 13.03019>, <-18.03341, 89.7048, 12.3421> }
				triangle { <-16.741, 90.03399, 12.8741>, <-18.03341, 89.7048, 12.3421>, <-17.4327, 89.846, 12.2268> }
				triangle { <-18.03341, 89.7048, 12.3421>, <-17.5672, 89.8142, 12.07598>, <-17.4327, 89.846, 12.2268> }
				triangle { <-16.741, 90.03399, 12.8741>, <-16.9236, 90.411, 11.8893>, <-16.2439, 90.2015, 13.3628> }
				triangle { <-17.4829, 89.9612, 11.6333>, <-17.4327, 89.846, 12.2268>, <-17.5672, 89.8142, 12.07598> }
				triangle { <-17.5672, 89.8142, 12.07598>, <-17.6985, 89.7938, 11.9997>, <-17.4829, 89.9612, 11.6333> }
				triangle { <-18.03341, 89.7048, 12.3421>, <-17.6985, 89.7938, 11.9997>, <-17.5672, 89.8142, 12.07598> }
				triangle { <-16.9236, 90.411, 11.8893>, <-16.2274, 90.4836, 12.826>, <-16.2439, 90.2015, 13.3628> }
				triangle { <-16.2439, 90.2015, 13.3628>, <-16.8147, 90.1788, 13.5863>, <-17.8353, 89.9317, 13.03019> }
				triangle { <-16.741, 90.03399, 12.8741>, <-17.4327, 89.846, 12.2268>, <-17.4829, 89.9612, 11.6333> }
				triangle { <-17.4829, 89.9612, 11.6333>, <-16.9236, 90.411, 11.8893>, <-16.741, 90.03399, 12.8741> }
				triangle { <-16.2274, 90.4836, 12.826>, <-16.9236, 90.411, 11.8893>, <-16.5445, 90.5106, 12.2914> }
				triangle { <-16.8147, 90.1788, 13.5863>, <-17.4054, 90.1611, 13.3933>, <-17.8353, 89.9317, 13.03019> }
				triangle { <-17.8353, 89.9317, 13.03019>, <-18.02505, 89.8854, 12.6288>, <-18.03341, 89.7048, 12.3421> }
				triangle { <-17.4829, 89.9612, 11.6333>, <-17.2391, 90.2846, 11.6926>, <-16.9236, 90.411, 11.8893> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <-14.3734, 90.6534, 13.7115>, <-14.591, 90.4506, 14.3603>, 0.05002 }
				cylinder { <-14.591, 90.4506, 14.3603>, <-14.5759, 90.3028, 15.05839>, 0.05002 }
				cylinder { <-14.5759, 90.3028, 15.05839>, <-14.33, 90.2271, 15.724>, 0.05002 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <-14.33, 90.2271, 15.724>, <-13.173, 90.408, 16.8835>, <-14.07616, 90.02573, 16.3635> }
				triangle { <-14.07616, 90.02573, 16.3635>, <-13.173, 90.408, 16.8835>, <-13.1791, 89.9548, 17.4824> }
				triangle { <-14.07616, 90.02573, 16.3635>, <-13.1791, 89.9548, 17.4824>, <-13.7355, 89.7976, 17.238> }
				triangle { <-13.1791, 89.9548, 17.4824>, <-13.682, 89.7444, 17.4282>, <-13.7355, 89.7976, 17.238> }
				triangle { <-14.07616, 90.02573, 16.3635>, <-14.5583, 89.8972, 17.3102>, <-14.33, 90.2271, 15.724> }
				triangle { <-14.00485, 89.6103, 17.7483>, <-13.7355, 89.7976, 17.238>, <-13.682, 89.7444, 17.4282> }
				triangle { <-13.682, 89.7444, 17.4282>, <-13.6073, 89.7364, 17.5617>, <-14.00485, 89.6103, 17.7483> }
				triangle { <-13.1791, 89.9548, 17.4824>, <-13.6073, 89.7364, 17.5617>, <-13.682, 89.7444, 17.4282> }
				triangle { <-14.5583, 89.8972, 17.3102>, <-14.7196, 90.1769, 16.1863>, <-14.33, 90.2271, 15.724> }
				triangle { <-14.33, 90.2271, 15.724>, <-13.8191, 90.5217, 15.8929>, <-13.173, 90.408, 16.8835> }
				triangle { <-14.07616, 90.02573, 16.3635>, <-13.7355, 89.7976, 17.238>, <-14.00485, 89.6103, 17.7483> }
				triangle { <-14.00485, 89.6103, 17.7483>, <-14.5583, 89.8972, 17.3102>, <-14.07616, 90.02573, 16.3635> }
				triangle { <-14.7196, 90.1769, 16.1863>, <-14.5583, 89.8972, 17.3102>, <-14.724, 90.04323, 16.7939> }
				triangle { <-13.8191, 90.5217, 15.8929>, <-13.4648, 90.6194, 16.3942>, <-13.173, 90.408, 16.8835> }
				triangle { <-13.173, 90.408, 16.8835>, <-13.1727, 90.2379, 17.2962>, <-13.1791, 89.9548, 17.4824> }
				triangle { <-14.00485, 89.6103, 17.7483>, <-14.34, 89.8101, 17.6248>, <-14.5583, 89.8972, 17.3102> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <-14.3734, 90.6534, 13.7115>, <-14.7982, 90.4194, 14.2352>, 0.05002 }
				cylinder { <-14.7982, 90.4194, 14.2352>, <-15.2229, 90.1854, 14.7589>, 0.05002 }
				cylinder { <-15.2229, 90.1854, 14.7589>, <-15.6476, 89.9514, 15.2825>, 0.05002 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <-15.6476, 89.9514, 15.2825>, <-15.9706, 89.6224, 16.8646>, <-16.05294, 89.5997, 15.7579> }
				triangle { <-16.05294, 89.5997, 15.7579>, <-15.9706, 89.6224, 16.8646>, <-16.4984, 89.1156, 17.03412> }
				triangle { <-16.05294, 89.5997, 15.7579>, <-16.4984, 89.1156, 17.03412>, <-16.6081, 89.1654, 16.418> }
				triangle { <-16.4984, 89.1156, 17.03412>, <-16.7404, 89.07379, 16.5444>, <-16.6081, 89.1654, 16.418> }
				triangle { <-16.05294, 89.5997, 15.7579>, <-17.1143, 89.4949, 15.8458>, <-15.6476, 89.9514, 15.2825> }
				triangle { <-17.1918, 89.00022, 16.4201>, <-16.6081, 89.1654, 16.418>, <-16.7404, 89.07379, 16.5444> }
				triangle { <-16.7404, 89.07379, 16.5444>, <-16.8113, 89.02608, 16.6716>, <-17.1918, 89.00022, 16.4201> }
				triangle { <-16.4984, 89.1156, 17.03412>, <-16.8113, 89.02608, 16.6716>, <-16.7404, 89.07379, 16.5444> }
				triangle { <-17.1143, 89.4949, 15.8458>, <-16.2497, 89.9579, 15.209>, <-15.6476, 89.9514, 15.2825> }
				triangle { <-15.6476, 89.9514, 15.2825>, <-15.4922, 90.05518, 15.8668>, <-15.9706, 89.6224, 16.8646> }
				triangle { <-16.05294, 89.5997, 15.7579>, <-16.6081, 89.1654, 16.418>, <-17.1918, 89.00022, 16.4201> }
				triangle { <-17.1918, 89.00022, 16.4201>, <-17.1143, 89.4949, 15.8458>, <-16.05294, 89.5997, 15.7579> }
				triangle { <-16.2497, 89.9579, 15.209>, <-17.1143, 89.4949, 15.8458>, <-16.7664, 89.7514, 15.4873> }
				triangle { <-15.4922, 90.05518, 15.8668>, <-15.711, 89.9748, 16.4431>, <-15.9706, 89.6224, 16.8646> }
				triangle { <-15.9706, 89.6224, 16.8646>, <-16.3241, 89.4062, 17.03069>, <-16.4984, 89.1156, 17.03412> }
				triangle { <-17.1918, 89.00022, 16.4201>, <-17.2617, 89.3053, 16.1565>, <-17.1143, 89.4949, 15.8458> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			}
		}
	union { // internode
		cylinder { <-9.8959, 91.6245, 8.359>, <-10.5725, 92.1848, 9.3972>, 0.05887 }
		cylinder { <-10.5725, 92.1848, 9.3972>, <-11.0191, 92.9374, 10.4383>, 0.05887 }
		cylinder { <-11.0191, 92.9374, 10.4383>, <-11.2138, 93.8456, 11.4317>, 0.05887 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.2138, 93.8456, 11.4317>, <-11.172, 94.977, 12.4518>, 0.03204 }
			cylinder { <-11.172, 94.977, 12.4518>, <-10.8716, 96.1787, 13.3397>, 0.03204 }
			cylinder { <-10.8716, 96.1787, 13.3397>, <-10.3243, 97.4045, 14.06126>, 0.03204 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-10.3243, 97.4045, 14.06126>, <-10.07137, 97.5905, 14.3936>, 0.03204 }
				cylinder { <-10.07137, 97.5905, 14.3936>, <-9.7954, 97.5466, 14.7554>, 0.03204 }
				cylinder { <-9.7954, 97.5466, 14.7554>, <-9.5681, 97.284, 15.05289>, 0.03204 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // compound leaf petiolet
				cylinder { <-10.3243, 97.4045, 14.06126>, <-10.2449, 97.8423, 14.1666>, 0.03204 }
				cylinder { <-10.2449, 97.8423, 14.1666>, <-10.2596, 98.2989, 14.1486>, 0.03204 }
				cylinder { <-10.2596, 98.2989, 14.1486>, <-10.3667, 98.721, 14.00928>, 0.03204 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // compound leaf petiolet
				cylinder { <-10.3243, 97.4045, 14.06126>, <-10.16, 97.7722, 14.2777>, 0.03204 }
				cylinder { <-10.16, 97.7722, 14.2777>, <-9.9958, 98.14, 14.4941>, 0.03204 }
				cylinder { <-9.9958, 98.14, 14.4941>, <-9.8316, 98.5077, 14.7106>, 0.03204 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			}
		}
	union { // inflorescence
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.2138, 93.8456, 11.4317>, <-11.2178, 93.8676, 11.4578>, 0.09849 }
				cylinder { <-11.2178, 93.8676, 11.4578>, <-11.2208, 93.8887, 11.4849>, 0.09849 }
				cylinder { <-11.2208, 93.8887, 11.4849>, <-11.2228, 93.9087, 11.5129>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.2228, 93.9087, 11.5129>, <-10.4962, 96.8081, 15.6145>, <-12.08982, 96.3084, 15.9351> }
					triangle { <-10.4962, 96.8081, 15.6145>, <-10.8561, 97.9072, 21.2342>, <-12.08982, 96.3084, 15.9351> }
					triangle { <-10.4962, 96.8081, 15.6145>, <-10.2008, 97.4538, 19.4356>, <-10.8561, 97.9072, 21.2342> }
					triangle { <-10.8561, 97.9072, 21.2342>, <-11.5373, 96.8977, 19.9698>, <-12.08982, 96.3084, 15.9351> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2228, 93.9087, 11.5129>, <-11.99, 97.5072, 15.00859>, <-10.6949, 96.6977, 15.7566> }
					triangle { <-11.99, 97.5072, 15.00859>, <-10.2044, 101.5198, 18.7005>, <-10.6949, 96.6977, 15.7566> }
					triangle { <-11.99, 97.5072, 15.00859>, <-10.9625, 100.5892, 17.1418>, <-10.2044, 101.5198, 18.7005> }
					triangle { <-10.2044, 101.5198, 18.7005>, <-9.6573, 100.1091, 17.8102>, <-10.6949, 96.6977, 15.7566> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2228, 93.9087, 11.5129>, <-12.03257, 96.06629, 16.03472>, <-11.7676, 97.4773, 15.1232> }
					triangle { <-12.03257, 96.06629, 16.03472>, <-14.3676, 100.0207, 19.4741>, <-11.7676, 97.4773, 15.1232> }
					triangle { <-12.03257, 96.06629, 16.03472>, <-13.9505, 98.3451, 18.5313>, <-14.3676, 100.0207, 19.4741> }
					triangle { <-14.3676, 100.0207, 19.4741>, <-13.9708, 99.7005, 17.7942>, <-11.7676, 97.4773, 15.1232> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.2138, 93.8456, 11.4317>, <-11.2186, 93.8698, 11.4557>, 0.09849 }
				cylinder { <-11.2186, 93.8698, 11.4557>, <-11.2231, 93.8952, 11.4785>, 0.09849 }
				cylinder { <-11.2231, 93.8952, 11.4785>, <-11.2273, 93.9217, 11.5001>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.2273, 93.9217, 11.5001>, <-12.5524, 98.1374, 13.996>, <-11.01491, 97.9065, 14.6849> }
					triangle { <-12.5524, 98.1374, 13.996>, <-11.524, 103.3726, 16.1066>, <-11.01491, 97.9065, 14.6849> }
					triangle { <-12.5524, 98.1374, 13.996>, <-12.1673, 101.8685, 15.01397>, <-11.524, 103.3726, 16.1066> }
					triangle { <-11.524, 103.3726, 16.1066>, <-10.7171, 101.9208, 15.5384>, <-11.01491, 97.9065, 14.6849> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2273, 93.9217, 11.5001>, <-12.1196, 97.1053, 15.3505>, <-12.3019, 98.2035, 14.06493> }
					triangle { <-12.1196, 97.1053, 15.3505>, <-15.03204, 101.3164, 17.9399>, <-12.3019, 98.2035, 14.06493> }
					triangle { <-12.1196, 97.1053, 15.3505>, <-14.3011, 99.5642, 17.4242>, <-15.03204, 101.3164, 17.9399> }
					triangle { <-15.03204, 101.3164, 17.9399>, <-14.7281, 100.6021, 16.3653>, <-12.3019, 98.2035, 14.06493> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2273, 93.9217, 11.5001>, <-10.8696, 98.01065, 14.4851>, <-12.2263, 97.2848, 15.2093> }
					triangle { <-10.8696, 98.01065, 14.4851>, <-10.905, 100.6457, 19.5816>, <-12.2263, 97.2848, 15.2093> }
					triangle { <-10.8696, 98.01065, 14.4851>, <-10.3493, 99.8302, 17.8797>, <-10.905, 100.6457, 19.5816> }
					triangle { <-10.905, 100.6457, 19.5816>, <-11.4218, 99.1747, 18.7747>, <-12.2263, 97.2848, 15.2093> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.2138, 93.8456, 11.4317>, <-11.22, 93.8676, 11.4574>, 0.09849 }
				cylinder { <-11.22, 93.8676, 11.4574>, <-11.2275, 93.8886, 11.4837>, 0.09849 }
				cylinder { <-11.2275, 93.8886, 11.4837>, <-11.2361, 93.9086, 11.5104>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.2361, 93.9086, 11.5104>, <-12.4068, 95.9882, 15.9894>, <-13.1559, 97.1294, 14.9755> }
					triangle { <-12.4068, 95.9882, 15.9894>, <-16.00967, 98.5022, 19.6798>, <-13.1559, 97.1294, 14.9755> }
					triangle { <-12.4068, 95.9882, 15.9894>, <-14.8587, 97.2075, 18.7474>, <-16.00967, 98.5022, 19.6798> }
					triangle { <-16.00967, 98.5022, 19.6798>, <-15.7761, 98.175, 17.9709>, <-13.1559, 97.1294, 14.9755> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2361, 93.9086, 11.5104>, <-11.6731, 97.3724, 15.1939>, <-12.6085, 96.1368, 15.8942> }
					triangle { <-11.6731, 97.3724, 15.1939>, <-11.6964, 99.02588, 20.688>, <-12.6085, 96.1368, 15.8942> }
					triangle { <-11.6731, 97.3724, 15.1939>, <-11.1979, 98.7131, 18.8108>, <-11.6964, 99.02588, 20.688> }
					triangle { <-11.6964, 99.02588, 20.688>, <-11.8607, 97.6104, 19.6626>, <-12.6085, 96.1368, 15.8942> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2361, 93.9086, 11.5104>, <-13.38, 96.9913, 14.9247>, <-11.7534, 97.2107, 15.3698> }
					triangle { <-13.38, 96.9913, 14.9247>, <-13.729, 101.8915, 17.889>, <-11.7534, 97.2107, 15.3698> }
					triangle { <-13.38, 96.9913, 14.9247>, <-14.03834, 100.4337, 16.6047>, <-13.729, 101.8915, 17.889> }
					triangle { <-13.729, 101.8915, 17.889>, <-12.6129, 100.909, 16.9556>, <-11.7534, 97.2107, 15.3698> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.2138, 93.8456, 11.4317>, <-11.2171, 93.8687, 11.457>, 0.09849 }
				cylinder { <-11.2171, 93.8687, 11.457>, <-11.2187, 93.8918, 11.4824>, 0.09849 }
				cylinder { <-11.2187, 93.8918, 11.4824>, <-11.2185, 93.915, 11.5079>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.2185, 93.915, 11.5079>, <-10.5664, 97.8438, 14.6538>, <-11.05805, 96.6829, 15.795> }
					triangle { <-10.5664, 97.8438, 14.6538>, <-8.6945, 100.2543, 19.5123>, <-11.05805, 96.6829, 15.795> }
					triangle { <-10.5664, 97.8438, 14.6538>, <-8.9038, 99.6999, 17.6364>, <-8.6945, 100.2543, 19.5123> }
					triangle { <-8.6945, 100.2543, 19.5123>, <-9.09938, 98.7027, 18.7976>, <-11.05805, 96.6829, 15.795> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2185, 93.915, 11.5079>, <-12.2052, 97.3785, 15.08404>, <-10.5472, 97.6937, 14.875> }
					triangle { <-12.2052, 97.3785, 15.08404>, <-11.8119, 102.6236, 17.3762>, <-10.5472, 97.6937, 14.875> }
					triangle { <-12.2052, 97.3785, 15.08404>, <-12.4579, 100.9993, 16.4736>, <-11.8119, 102.6236, 17.3762> }
					triangle { <-11.8119, 102.6236, 17.3762>, <-11.03912, 101.5508, 16.2213>, <-10.5472, 97.6937, 14.875> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2185, 93.915, 11.5079>, <-10.8228, 96.5574, 15.8228>, <-11.9954, 97.513, 15.04595> }
					triangle { <-10.8228, 96.5574, 15.8228>, <-13.00673, 99.4203, 20.2898>, <-11.9954, 97.513, 15.04595> }
					triangle { <-10.8228, 96.5574, 15.8228>, <-12.1728, 98.05434, 19.1458>, <-13.00673, 99.4203, 20.2898> }
					triangle { <-13.00673, 99.4203, 20.2898>, <-13.3969, 98.8648, 18.6708>, <-11.9954, 97.513, 15.04595> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.2138, 93.8456, 11.4317>, <-11.22, 93.8693, 11.4559>, 0.09849 }
				cylinder { <-11.22, 93.8693, 11.4559>, <-11.2273, 93.8937, 11.4791>, 0.09849 }
				cylinder { <-11.2273, 93.8937, 11.4791>, <-11.2358, 93.9186, 11.5012>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.2358, 93.9186, 11.5012>, <-13.4393, 97.2432, 14.6396>, <-12.02589, 98.1217, 14.2899> }
					triangle { <-13.4393, 97.2432, 14.6396>, <-15.04921, 102.5283, 16.1873>, <-12.02589, 98.1217, 14.2899> }
					triangle { <-13.4393, 97.2432, 14.6396>, <-15.03697, 100.6674, 15.5493>, <-15.04921, 102.5283, 16.1873> }
					triangle { <-15.04921, 102.5283, 16.1873>, <-13.9346, 101.6665, 15.14>, <-12.02589, 98.1217, 14.2899> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2358, 93.9186, 11.5012>, <-11.8632, 97.1024, 15.4034>, <-13.2952, 97.4532, 14.556> }
					triangle { <-11.8632, 97.1024, 15.4034>, <-14.9763, 99.5826, 19.5358>, <-13.2952, 97.4532, 14.556> }
					triangle { <-11.8632, 97.1024, 15.4034>, <-13.6939, 98.4625, 18.5505>, <-14.9763, 99.5826, 19.5358> }
					triangle { <-14.9763, 99.5826, 19.5358>, <-15.124, 98.7032, 18.02368>, <-13.2952, 97.4532, 14.556> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2358, 93.9186, 11.5012>, <-12.1019, 98.2197, 14.05234>, <-12.1096, 97.1391, 15.3653> }
					triangle { <-12.1019, 98.2197, 14.05234>, <-11.2531, 101.8366, 18.4247>, <-12.1096, 97.1391, 15.3653> }
					triangle { <-12.1019, 98.2197, 14.05234>, <-11.2483, 100.9768, 16.6552>, <-11.2531, 101.8366, 18.4247> }
					triangle { <-11.2531, 101.8366, 18.4247>, <-11.04409, 100.1599, 17.9481>, <-12.1096, 97.1391, 15.3653> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.2138, 93.8456, 11.4317>, <-11.2186, 93.8673, 11.4579>, 0.09849 }
				cylinder { <-11.2186, 93.8673, 11.4579>, <-11.2233, 93.8878, 11.4853>, 0.09849 }
				cylinder { <-11.2233, 93.8878, 11.4853>, <-11.2278, 93.9068, 11.5136>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.2278, 93.9068, 11.5136>, <-11.02238, 96.2776, 15.9963>, <-12.6895, 96.4361, 15.7008> }
					triangle { <-11.02238, 96.2776, 15.9963>, <-12.9473, 97.4064, 21.2821>, <-12.6895, 96.4361, 15.7008> }
					triangle { <-11.02238, 96.2776, 15.9963>, <-11.9031, 96.7413, 19.7532>, <-12.9473, 97.4064, 21.2821> }
					triangle { <-12.9473, 97.4064, 21.2821>, <-13.446, 96.7468, 19.7335>, <-12.6895, 96.4361, 15.7008> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2278, 93.9068, 11.5136>, <-11.8379, 97.5054, 15.04001>, <-11.2842, 96.2527, 16.04796> }
					triangle { <-11.8379, 97.5054, 15.04001>, <-10.1714, 100.4913, 19.6473>, <-11.2842, 96.2527, 16.04796> }
					triangle { <-11.8379, 97.5054, 15.04001>, <-10.6023, 99.9356, 17.8099>, <-10.1714, 100.4913, 19.6473> }
					triangle { <-10.1714, 100.4913, 19.6473>, <-9.8922, 98.9826, 18.794>, <-11.2842, 96.2527, 16.04796> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2278, 93.9068, 11.5136>, <-12.7635, 96.1903, 15.7779>, <-11.6984, 97.3908, 15.2158> }
					triangle { <-12.7635, 96.1903, 15.7779>, <-14.574, 100.7271, 18.7878>, <-11.6984, 97.3908, 15.2158> }
					triangle { <-12.7635, 96.1903, 15.7779>, <-14.4838, 99.02533, 17.8049>, <-14.574, 100.7271, 18.7878> }
					triangle { <-14.574, 100.7271, 18.7878>, <-13.7467, 100.2849, 17.3039>, <-11.6984, 97.3908, 15.2158> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.2138, 93.8456, 11.4317>, <-11.2177, 93.8696, 11.456>, 0.09849 }
				cylinder { <-11.2177, 93.8696, 11.456>, <-11.2206, 93.8947, 11.4795>, 0.09849 }
				cylinder { <-11.2206, 93.8947, 11.4795>, <-11.2224, 93.9207, 11.502>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.2224, 93.9207, 11.502>, <-11.7311, 98.3091, 14.00007>, <-10.7382, 97.4952, 15.1151> }
					triangle { <-11.7311, 98.3091, 14.00007>, <-9.7074, 102.7226, 17.05719>, <-10.7382, 97.4952, 15.1151> }
					triangle { <-11.7311, 98.3091, 14.00007>, <-10.414, 101.5919, 15.6105>, <-9.7074, 102.7226, 17.05719> }
					triangle { <-9.7074, 102.7226, 17.05719>, <-9.3348, 101.0735, 16.5839>, <-10.7382, 97.4952, 15.1151> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2224, 93.9207, 11.502>, <-12.2174, 97.1843, 15.2592>, <-11.5163, 98.2722, 14.1561> }
					triangle { <-12.2174, 97.1843, 15.2592>, <-14.1274, 102.1857, 17.3225>, <-11.5163, 98.2722, 14.1561> }
					triangle { <-12.2174, 97.1843, 15.2592>, <-13.9478, 100.2894, 16.8305>, <-14.1274, 102.1857, 17.3225> }
					triangle { <-14.1274, 102.1857, 17.3225>, <-13.5603, 101.4161, 15.85>, <-11.5163, 98.2722, 14.1561> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2224, 93.9207, 11.502>, <-10.5039, 97.5354, 14.9912>, <-12.1936, 97.3917, 15.118> }
					triangle { <-10.5039, 97.5354, 14.9912>, <-11.4063, 99.955, 20.1148>, <-12.1936, 97.3917, 15.118> }
					triangle { <-10.5039, 97.5354, 14.9912>, <-10.6136, 98.9947, 18.5917>, <-11.4063, 99.955, 20.1148> }
					triangle { <-11.4063, 99.955, 20.1148>, <-12.09447, 98.8045, 18.9813>, <-12.1936, 97.3917, 15.118> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.2138, 93.8456, 11.4317>, <-11.2204, 93.8682, 11.4568>, 0.09849 }
				cylinder { <-11.2204, 93.8682, 11.4568>, <-11.2286, 93.8903, 11.4819>, 0.09849 }
				cylinder { <-11.2286, 93.8903, 11.4819>, <-11.2384, 93.9119, 11.5068>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.2384, 93.9119, 11.5068>, <-13.09774, 96.2642, 15.6016>, <-12.9662, 97.6113, 14.5721> }
					triangle { <-13.09774, 96.2642, 15.6016>, <-16.6105, 99.9664, 18.2233>, <-12.9662, 97.6113, 14.5721> }
					triangle { <-13.09774, 96.2642, 15.6016>, <-15.7545, 98.3298, 17.5457>, <-16.6105, 99.9664, 18.2233> }
					triangle { <-16.6105, 99.9664, 18.2233>, <-15.9158, 99.5814, 16.6577>, <-12.9662, 97.6113, 14.5721> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2384, 93.9119, 11.5068>, <-11.6804, 97.2572, 15.2978>, <-13.1834, 96.48, 15.4677> }
					triangle { <-11.6804, 97.2572, 15.2978>, <-13.06999, 98.7661, 20.6562>, <-13.1834, 96.48, 15.4677> }
					triangle { <-11.6804, 97.2572, 15.2978>, <-12.08174, 98.292, 19.02252>, <-13.06999, 98.7661, 20.6562> }
					triangle { <-13.06999, 98.7661, 20.6562>, <-13.3563, 97.5305, 19.4423>, <-13.1834, 96.48, 15.4677> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2384, 93.9119, 11.5068>, <-13.1908, 97.5715, 14.4314>, <-11.871, 97.1387, 15.4125> }
					triangle { <-13.1908, 97.5715, 14.4314>, <-12.7796, 102.2086, 17.7852>, <-11.871, 97.1387, 15.4125> }
					triangle { <-13.1908, 97.5715, 14.4314>, <-13.1134, 100.9915, 16.276>, <-12.7796, 102.2086, 17.7852> }
					triangle { <-12.7796, 102.2086, 17.7852>, <-11.8403, 100.8733, 17.1398>, <-11.871, 97.1387, 15.4125> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.2138, 93.8456, 11.4317>, <-11.2173, 93.868, 11.4575>, 0.09849 }
				cylinder { <-11.2173, 93.868, 11.4575>, <-11.2194, 93.8899, 11.4841>, 0.09849 }
				cylinder { <-11.2194, 93.8899, 11.4841>, <-11.2201, 93.911, 11.5113>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.2201, 93.911, 11.5113>, <-10.3638, 97.2631, 15.2245>, <-11.6158, 96.3801, 15.9625> }
					triangle { <-10.3638, 97.2631, 15.2245>, <-9.6207, 98.7346, 20.7201>, <-11.6158, 96.3801, 15.9625> }
					triangle { <-10.3638, 97.2631, 15.2245>, <-9.3295, 98.3133, 18.8206>, <-9.6207, 98.7346, 20.7201> }
					triangle { <-9.6207, 98.7346, 20.7201>, <-10.2746, 97.4659, 19.6979>, <-11.6158, 96.3801, 15.9625> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2201, 93.911, 11.5113>, <-12.09672, 97.4703, 15.02138>, <-10.4808, 97.1164, 15.4158> }
					triangle { <-12.09672, 97.4703, 15.02138>, <-10.681, 102.1392, 18.04079>, <-10.4808, 97.1164, 15.4158> }
					triangle { <-12.09672, 97.4703, 15.02138>, <-11.5015, 100.8982, 16.7536>, <-10.681, 102.1392, 18.04079> }
					triangle { <-10.681, 102.1392, 18.04079>, <-9.9905, 100.8551, 17.06289>, <-10.4808, 97.1164, 15.4158> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2201, 93.911, 11.5113>, <-11.4687, 96.1729, 16.04776>, <-11.8539, 97.5127, 15.07393> }
					triangle { <-11.4687, 96.1729, 16.04776>, <-13.9122, 99.6411, 19.9105>, <-11.8539, 97.5127, 15.07393> }
					triangle { <-11.4687, 96.1729, 16.04776>, <-13.2791, 98.06309, 18.9208>, <-13.9122, 99.6411, 19.9105> }
					triangle { <-13.9122, 99.6411, 19.9105>, <-13.8692, 99.288, 18.1913>, <-11.8539, 97.5127, 15.07393> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.2138, 93.8456, 11.4317>, <-11.2192, 93.8697, 11.4556>, 0.09849 }
				cylinder { <-11.2192, 93.8697, 11.4556>, <-11.225, 93.8949, 11.4784>, 0.09849 }
				cylinder { <-11.225, 93.8949, 11.4784>, <-11.2312, 93.9211, 11.4998>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.2312, 93.9211, 11.4998>, <-13.04865, 97.8277, 14.1818>, <-11.3889, 98.08852, 14.4451> }
					triangle { <-13.04865, 97.8277, 14.1818>, <-13.07584, 103.3162, 15.8539>, <-11.3889, 98.08852, 14.4451> }
					triangle { <-13.04865, 97.8277, 14.1818>, <-13.5102, 101.5999, 14.9961>, <-13.07584, 103.3162, 15.8539> }
					triangle { <-13.07584, 103.3162, 15.8539>, <-12.05337, 102.093, 15.1189>, <-11.3889, 98.08852, 14.4451> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2312, 93.9211, 11.4998>, <-12.01679, 97.0816, 15.3924>, <-12.8187, 97.9655, 14.1811> }
					triangle { <-12.01679, 97.0816, 15.3924>, <-15.2786, 100.5602, 18.5828>, <-12.8187, 97.9655, 14.1811> }
					triangle { <-12.01679, 97.0816, 15.3924>, <-14.2273, 99.03349, 17.9239>, <-15.2786, 100.5602, 18.5828> }
					triangle { <-15.2786, 100.5602, 18.5828>, <-15.1823, 99.8139, 16.9967>, <-12.8187, 97.9655, 14.1811> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.2312, 93.9211, 11.4998>, <-11.3338, 98.2094, 14.2123>, <-12.2019, 97.2114, 15.2811> }
					triangle { <-11.3338, 98.2094, 14.2123>, <-10.8605, 101.1923, 19.09069>, <-12.2019, 97.2114, 15.2811> }
					triangle { <-11.3338, 98.2094, 14.2123>, <-10.5337, 100.406, 17.3172>, <-10.8605, 101.1923, 19.09069> }
					triangle { <-10.8605, 101.1923, 19.09069>, <-11.1167, 99.5685, 18.4746>, <-12.2019, 97.2114, 15.2811> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-11.2138, 93.8456, 11.4317>, <-11.2195, 93.8674, 11.4577>, 0.09849 }
				cylinder { <-11.2195, 93.8674, 11.4577>, <-11.2259, 93.8879, 11.4846>, 0.09849 }
				cylinder { <-11.2259, 93.8879, 11.4846>, <-11.233, 93.9071, 11.5123>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.233, 93.9071, 11.5123>, <-11.8039, 95.9921, 16.1041>, <-13.07556, 96.788, 15.3033> }
					triangle { <-11.8039, 95.9921, 16.1041>, <-14.9455, 97.7585, 20.5684>, <-13.07556, 96.788, 15.3033> }
					triangle { <-11.8039, 95.9921, 16.1041>, <-13.7398, 96.746, 19.3887>, <-14.9455, 97.7585, 20.5684> }
					triangle { <-14.9455, 97.7585, 20.5684>, <-15.05866, 97.3516, 18.8644>, <-13.07556, 96.788, 15.3033> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.233, 93.9071, 11.5123>, <-11.7189, 97.4445, 15.119>, <-12.05679, 96.07082, 16.06279> }
					triangle { <-11.7189, 97.4445, 15.119>, <-10.8543, 99.527, 20.3949>, <-12.05679, 96.07082, 16.06279> }
					triangle { <-11.7189, 97.4445, 15.119>, <-10.7681, 99.1906, 18.4585>, <-10.8543, 99.527, 20.3949> }
					triangle { <-10.8543, 99.527, 20.3949>, <-10.8544, 98.03228, 19.4742>, <-12.05679, 96.07082, 16.06279> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <-11.233, 93.9071, 11.5123>, <-13.2558, 96.5901, 15.3159>, <-11.7033, 97.2839, 15.3126> }
					triangle { <-13.2558, 96.5901, 15.3159>, <-14.2503, 101.4611, 18.1803>, <-11.7033, 97.2839, 15.3126> }
					triangle { <-13.2558, 96.5901, 15.3159>, <-14.4364, 99.8624, 17.04889>, <-14.2503, 101.4611, 18.1803> }
					triangle { <-14.2503, 101.4611, 18.1803>, <-13.1667, 100.7381, 17.00335>, <-11.7033, 97.2839, 15.3126> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		}
	union { // internode
		cylinder { <-0.7797, 80.1923, -1.02864>, <1.04162, 86.8096, -1.9899>, 0.3 }
		cylinder { <1.04162, 86.8096, -1.9899>, <4.5655, 92.6763, -3.08268>, 0.3 }
		cylinder { <4.5655, 92.6763, -3.08268>, <9.5368, 97.3673, -4.2277>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <9.5368, 97.3673, -4.2277>, <15.7067, 101.2127, -5.4303>, 0.1549 }
			cylinder { <15.7067, 101.2127, -5.4303>, <22.5235, 103.768, -6.5717>, 0.1549 }
			cylinder { <22.5235, 103.768, -6.5717>, <29.7252, 104.9349, -7.6081>, 0.1549 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <29.7252, 104.9349, -7.6081>, <31.7404, 105.3584, -6.8039>, 0.1549 }
				cylinder { <31.7404, 105.3584, -6.8039>, <33.08677, 105.7452, -5.09377>, 0.1549 }
				cylinder { <33.08677, 105.7452, -5.09377>, <33.4143, 105.9948, -2.9218>, 0.1549 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <33.4143, 105.9948, -2.9218>, <36.3112, 107.1764, 1.1114>, <33.729, 105.8465, -0.7286> }
				triangle { <33.729, 105.8465, -0.7286>, <36.3112, 107.1764, 1.1114>, <35.7614, 106.3112, 3.1997> }
				triangle { <33.729, 105.8465, -0.7286>, <35.7614, 106.3112, 3.1997>, <34.1593, 105.7863, 2.2311> }
				triangle { <35.7614, 106.3112, 3.1997>, <34.1892, 105.7681, 2.864>, <34.1593, 105.7863, 2.2311> }
				triangle { <33.729, 105.8465, -0.7286>, <31.6775, 106.3503, 1.8259>, <33.4143, 105.9948, -2.9218> }
				triangle { <32.9765, 105.7087, 3.689>, <34.1593, 105.7863, 2.2311>, <34.1892, 105.7681, 2.864> }
				triangle { <34.1892, 105.7681, 2.864>, <34.3346, 105.8331, 3.311>, <32.9765, 105.7087, 3.689> }
				triangle { <35.7614, 106.3112, 3.1997>, <34.3346, 105.8331, 3.311>, <34.1892, 105.7681, 2.864> }
				triangle { <31.6775, 106.3503, 1.8259>, <31.953, 106.3171, -1.7854>, <33.4143, 105.9948, -2.9218> }
				triangle { <33.4143, 105.9948, -2.9218>, <34.9793, 106.8794, -2.3065>, <36.3112, 107.1764, 1.1114> }
				triangle { <33.729, 105.8465, -0.7286>, <34.1593, 105.7863, 2.2311>, <32.9765, 105.7087, 3.689> }
				triangle { <32.9765, 105.7087, 3.689>, <31.6775, 106.3503, 1.8259>, <33.729, 105.8465, -0.7286> }
				triangle { <31.953, 106.3171, -1.7854>, <31.6775, 106.3503, 1.8259>, <31.535, 106.4104, 0.09339> }
				triangle { <34.9793, 106.8794, -2.3065>, <35.7996, 107.4854, -0.6734>, <36.3112, 107.1764, 1.1114> }
				triangle { <36.3112, 107.1764, 1.1114>, <36.0045, 107.0026, 2.4483>, <35.7614, 106.3112, 3.1997> }
				triangle { <32.9765, 105.7087, 3.689>, <32.1191, 106.2892, 2.9575>, <31.6775, 106.3503, 1.8259> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <29.7252, 104.9349, -7.6081>, <31.6669, 105.1833, -8.6353>, 0.1549 }
				cylinder { <31.6669, 105.1833, -8.6353>, <33.1627, 105.301, -10.2588>, 0.1549 }
				cylinder { <33.1627, 105.301, -10.2588>, <34.03788, 105.2741, -12.2887>, 0.1549 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <34.03788, 105.2741, -12.2887>, <33.6641, 105.0763, -17.3756>, <35.04001, 104.8798, -14.2306> }
				triangle { <35.04001, 104.8798, -14.2306>, <33.6641, 105.0763, -17.3756>, <35.481, 104.3294, -18.6217> }
				triangle { <35.04001, 104.8798, -14.2306>, <35.481, 104.3294, -18.6217>, <36.351, 104.4759, -16.889> }
				triangle { <35.481, 104.3294, -18.6217>, <36.6818, 104.4067, -17.4252>, <36.351, 104.4759, -16.889> }
				triangle { <35.04001, 104.8798, -14.2306>, <37.9403, 105.914, -15.4581>, <34.03788, 105.2741, -12.2887> }
				triangle { <38.1122, 104.7303, -17.4927>, <36.351, 104.4759, -16.889>, <36.6818, 104.4067, -17.4252> }
				triangle { <36.6818, 104.4067, -17.4252>, <36.7968, 104.3861, -17.8853>, <38.1122, 104.7303, -17.4927> }
				triangle { <35.481, 104.3294, -18.6217>, <36.7968, 104.3861, -17.8853>, <36.6818, 104.4067, -17.4252> }
				triangle { <37.9403, 105.914, -15.4581>, <35.736, 106.0216, -12.5861>, <34.03788, 105.2741, -12.2887> }
				triangle { <34.03788, 105.2741, -12.2887>, <32.907, 105.4993, -13.7988>, <33.6641, 105.0763, -17.3756> }
				triangle { <35.04001, 104.8798, -14.2306>, <36.351, 104.4759, -16.889>, <38.1122, 104.7303, -17.4927> }
				triangle { <38.1122, 104.7303, -17.4927>, <37.9403, 105.914, -15.4581>, <35.04001, 104.8798, -14.2306> }
				triangle { <35.736, 106.0216, -12.5861>, <37.9403, 105.914, -15.4581>, <37.0799, 106.1346, -13.9626> }
				triangle { <32.907, 105.4993, -13.7988>, <33.00082, 105.664, -15.7149>, <33.6641, 105.0763, -17.3756> }
				triangle { <33.6641, 105.0763, -17.3756>, <34.6911, 104.9363, -18.2905>, <35.481, 104.3294, -18.6217> }
				triangle { <38.1122, 104.7303, -17.4927>, <38.2326, 105.6252, -16.6029>, <37.9403, 105.914, -15.4581> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <29.7252, 104.9349, -7.6081>, <31.8857, 105.285, -7.919>, 0.1549 }
				cylinder { <31.8857, 105.285, -7.919>, <34.04625, 105.6351, -8.2299>, 0.1549 }
				cylinder { <34.04625, 105.6351, -8.2299>, <36.2067, 105.9852, -8.5408>, 0.1549 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <36.2067, 105.9852, -8.5408>, <40.2851, 106.7528, -11.5129>, <38.4184, 105.9568, -8.7372> }
				triangle { <38.4184, 105.9568, -8.7372>, <40.2851, 106.7528, -11.5129>, <42.4018, 106.2411, -10.6945> }
				triangle { <38.4184, 105.9568, -8.7372>, <42.4018, 106.2411, -10.6945>, <41.3927, 106.052, -9.04335> }
				triangle { <42.4018, 106.2411, -10.6945>, <42.02582, 106.0828, -9.04741>, <41.3927, 106.052, -9.04335> }
				triangle { <38.4184, 105.9568, -8.7372>, <40.8136, 107.183, -6.8012>, <36.2067, 105.9852, -8.5408> }
				triangle { <42.7872, 106.4029, -7.8338>, <41.3927, 106.052, -9.04335>, <42.02582, 106.0828, -9.04741> }
				triangle { <42.02582, 106.0828, -9.04741>, <42.4736, 106.1484, -9.1902>, <42.7872, 106.4029, -7.8338> }
				triangle { <42.4018, 106.2411, -10.6945>, <42.4736, 106.1484, -9.1902>, <42.02582, 106.0828, -9.04741> }
				triangle { <40.8136, 107.183, -6.8012>, <37.2354, 106.763, -7.1742>, <36.2067, 105.9852, -8.5408> }
				triangle { <36.2067, 105.9852, -8.5408>, <36.8342, 106.4992, -10.2589>, <40.2851, 106.7528, -11.5129> }
				triangle { <38.4184, 105.9568, -8.7372>, <41.3927, 106.052, -9.04335>, <42.7872, 106.4029, -7.8338> }
				triangle { <42.7872, 106.4029, -7.8338>, <40.8136, 107.183, -6.8012>, <38.4184, 105.9568, -8.7372> }
				triangle { <37.2354, 106.763, -7.1742>, <40.8136, 107.183, -6.8012>, <39.07648, 107.1238, -6.734> }
				triangle { <36.8342, 106.4992, -10.2589>, <38.4569, 107.0216, -11.154>, <40.2851, 106.7528, -11.5129> }
				triangle { <40.2851, 106.7528, -11.5129>, <41.6131, 106.7803, -11.1294>, <42.4018, 106.2411, -10.6945> }
				triangle { <42.7872, 106.4029, -7.8338>, <41.9684, 107.1131, -7.1763>, <40.8136, 107.183, -6.8012> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			}
		}
	union { // internode
		cylinder { <9.5368, 97.3673, -4.2277>, <12.9715, 102.8349, -6.7454>, 0.3 }
		cylinder { <12.9715, 102.8349, -6.7454>, <14.5228, 108.5272, -10.3815>, 0.3 }
		cylinder { <14.5228, 108.5272, -10.3815>, <14.03426, 113.8696, -14.7691>, 0.3 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <14.03426, 113.8696, -14.7691>, <13.2067, 116.1882, -16.9818>, 0.0696 }
			cylinder { <13.2067, 116.1882, -16.9818>, <11.8168, 118.1846, -19.2266>, 0.0696 }
			cylinder { <11.8168, 118.1846, -19.2266>, <9.918, 119.7821, -21.4173>, 0.0696 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <9.918, 119.7821, -21.4173>, <9.6027, 119.9202, -22.3488>, 0.0696 }
				cylinder { <9.6027, 119.9202, -22.3488>, <9.6236, 119.6814, -23.3124>, 0.0696 }
				cylinder { <9.6236, 119.6814, -23.3124>, <9.9753, 119.1276, -24.05794>, 0.0696 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <9.9753, 119.1276, -24.05794>, <10.1853, 118.6092, -26.2815>, <10.215, 118.4464, -24.7459> }
				triangle { <10.215, 118.4464, -24.7459>, <10.1853, 118.6092, -26.2815>, <10.4409, 117.6342, -26.5571> }
				triangle { <10.215, 118.4464, -24.7459>, <10.4409, 117.6342, -26.5571>, <10.5789, 117.5697, -25.6971> }
				triangle { <10.4409, 117.6342, -26.5571>, <10.673, 117.3726, -25.8798>, <10.5789, 117.5697, -25.6971> }
				triangle { <10.215, 118.4464, -24.7459>, <11.3926, 117.5441, -24.874>, <9.9753, 119.1276, -24.05794> }
				triangle { <11.145, 116.9437, -25.712>, <10.5789, 117.5697, -25.6971>, <10.673, 117.3726, -25.8798> }
				triangle { <10.673, 117.3726, -25.8798>, <10.727, 117.2727, -26.06025>, <11.145, 116.9437, -25.712> }
				triangle { <10.4409, 117.6342, -26.5571>, <10.727, 117.2727, -26.06025>, <10.673, 117.3726, -25.8798> }
				triangle { <11.3926, 117.5441, -24.874>, <10.6864, 118.685, -23.9538>, <9.9753, 119.1276, -24.05794> }
				triangle { <9.9753, 119.1276, -24.05794>, <9.8954, 119.4043, -24.8613>, <10.1853, 118.6092, -26.2815> }
				triangle { <10.215, 118.4464, -24.7459>, <10.5789, 117.5697, -25.6971>, <11.145, 116.9437, -25.712> }
				triangle { <11.145, 116.9437, -25.712>, <11.3926, 117.5441, -24.874>, <10.215, 118.4464, -24.7459> }
				triangle { <10.6864, 118.685, -23.9538>, <11.3926, 117.5441, -24.874>, <11.1556, 118.0788, -24.356> }
				triangle { <9.8954, 119.4043, -24.8613>, <10.1201, 119.1872, -25.6678>, <10.1853, 118.6092, -26.2815> }
				triangle { <10.1853, 118.6092, -26.2815>, <10.4499, 118.1048, -26.5289>, <10.4409, 117.6342, -26.5571> }
				triangle { <11.145, 116.9437, -25.712>, <11.4406, 117.2331, -25.3207>, <11.3926, 117.5441, -24.874> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <9.918, 119.7821, -21.4173>, <9.2585, 120.4239, -21.7903>, 0.0696 }
				cylinder { <9.2585, 120.4239, -21.7903>, <8.5861, 121.1533, -21.8355>, 0.0696 }
				cylinder { <8.5861, 121.1533, -21.8355>, <7.9795, 121.8849, -21.5476>, 0.0696 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <7.9795, 121.8849, -21.5476>, <7.1586, 123.3485, -19.9852>, <7.2412, 122.4956, -21.2702> }
				triangle { <7.2412, 122.4956, -21.2702>, <7.1586, 123.3485, -19.9852>, <6.1992, 123.7436, -20.1094> }
				triangle { <7.2412, 122.4956, -21.2702>, <6.1992, 123.7436, -20.1094>, <6.2889, 123.3645, -20.891> }
				triangle { <6.1992, 123.7436, -20.1094>, <6.0814, 123.552, -20.8377>, <6.2889, 123.3645, -20.891> }
				triangle { <7.2412, 122.4956, -21.2702>, <6.5073, 123.5582, -22.01131>, <7.9795, 121.8849, -21.5476> }
				triangle { <5.7554, 123.854, -21.3249>, <6.2889, 123.3645, -20.891>, <6.0814, 123.552, -20.8377> }
				triangle { <6.0814, 123.552, -20.8377>, <5.9635, 123.7026, -20.7436>, <5.7554, 123.854, -21.3249> }
				triangle { <6.1992, 123.7436, -20.1094>, <5.9635, 123.7026, -20.7436>, <6.0814, 123.552, -20.8377> }
				triangle { <6.5073, 123.5582, -22.01131>, <7.6643, 122.4195, -22.1197>, <7.9795, 121.8849, -21.5476> }
				triangle { <7.9795, 121.8849, -21.5476>, <8.1142, 122.2731, -20.7996>, <7.1586, 123.3485, -19.9852> }
				triangle { <7.2412, 122.4956, -21.2702>, <6.2889, 123.3645, -20.891>, <5.7554, 123.854, -21.3249> }
				triangle { <5.7554, 123.854, -21.3249>, <6.5073, 123.5582, -22.01131>, <7.2412, 122.4956, -21.2702> }
				triangle { <7.6643, 122.4195, -22.1197>, <6.5073, 123.5582, -22.01131>, <7.07646, 123.0516, -22.1842> }
				triangle { <8.1142, 122.2731, -20.7996>, <7.8093, 122.9263, -20.3217>, <7.1586, 123.3485, -19.9852> }
				triangle { <7.1586, 123.3485, -19.9852>, <6.6649, 123.7214, -20.03892>, <6.1992, 123.7436, -20.1094> }
				triangle { <5.7554, 123.854, -21.3249>, <6.141, 123.8629, -21.7438>, <6.5073, 123.5582, -22.01131> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <9.918, 119.7821, -21.4173>, <9.3484, 120.2613, -22.0746>, 0.0696 }
				cylinder { <9.3484, 120.2613, -22.0746>, <8.7788, 120.7406, -22.7318>, 0.0696 }
				cylinder { <8.7788, 120.7406, -22.7318>, <8.2091, 121.2198, -23.389>, 0.0696 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <8.2091, 121.2198, -23.389>, <6.7583, 122.8932, -23.9827>, <7.5309, 121.5569, -24.03813> }
				triangle { <7.5309, 121.5569, -24.03813>, <6.7583, 122.8932, -23.9827>, <6.1359, 122.7598, -24.8115> }
				triangle { <7.5309, 121.5569, -24.03813>, <6.1359, 122.7598, -24.8115>, <6.6516, 122.0631, -24.9192> }
				triangle { <6.1359, 122.7598, -24.8115>, <6.478, 122.1552, -25.1252>, <6.6516, 122.0631, -24.9192> }
				triangle { <7.5309, 121.5569, -24.03813>, <7.5403, 121.635, -25.525>, <8.2091, 121.2198, -23.389> }
				triangle { <6.5623, 121.9744, -25.7538>, <6.6516, 122.0631, -24.9192>, <6.478, 122.1552, -25.1252> }
				triangle { <6.478, 122.1552, -25.1252>, <6.3445, 122.2766, -25.2387>, <6.5623, 121.9744, -25.7538> }
				triangle { <6.1359, 122.7598, -24.8115>, <6.3445, 122.2766, -25.2387>, <6.478, 122.1552, -25.1252> }
				triangle { <7.5403, 121.635, -25.525>, <8.3799, 121.1634, -24.2137>, <8.2091, 121.2198, -23.389> }
				triangle { <8.2091, 121.2198, -23.389>, <7.8892, 121.9854, -23.1889>, <6.7583, 122.8932, -23.9827> }
				triangle { <7.5309, 121.5569, -24.03813>, <6.6516, 122.0631, -24.9192>, <6.5623, 121.9744, -25.7538> }
				triangle { <6.5623, 121.9744, -25.7538>, <7.5403, 121.635, -25.525>, <7.5309, 121.5569, -24.03813> }
				triangle { <8.3799, 121.1634, -24.2137>, <7.5403, 121.635, -25.525>, <8.03372, 121.3727, -24.9789> }
				triangle { <7.8892, 121.9854, -23.1889>, <7.426, 122.6274, -23.5373>, <6.7583, 122.8932, -23.9827> }
				triangle { <6.7583, 122.8932, -23.9827>, <6.4501, 122.9541, -24.5184>, <6.1359, 122.7598, -24.8115> }
				triangle { <6.5623, 121.9744, -25.7538>, <7.123, 121.8786, -25.78>, <7.5403, 121.635, -25.525> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			}
		}
	union { // internode
		cylinder { <14.03426, 113.8696, -14.7691>, <14.2737, 119.4323, -17.5774>, 0.2699 }
		cylinder { <14.2737, 119.4323, -17.5774>, <15.1779, 125.4171, -19.07779>, 0.2699 }
		cylinder { <15.1779, 125.4171, -19.07779>, <16.6928, 131.4654, -19.1803>, 0.2699 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <16.6928, 131.4654, -19.1803>, <17.4327, 133.6924, -18.7895>, 0.05002 }
			cylinder { <17.4327, 133.6924, -18.7895>, <18.3062, 135.7534, -17.9839>, 0.05002 }
			cylinder { <18.3062, 135.7534, -17.9839>, <19.2797, 137.5692, -16.7945>, 0.05002 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <19.2797, 137.5692, -16.7945>, <19.2188, 138.1243, -16.3501>, 0.05002 }
				cylinder { <19.2188, 138.1243, -16.3501>, <18.8207, 138.5456, -15.9336>, 0.05002 }
				cylinder { <18.8207, 138.5456, -15.9336>, <18.189, 138.7236, -15.6532>, 0.05002 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <18.189, 138.7236, -15.6532>, <17.2039, 139.7211, -14.7871>, <17.5759, 138.8044, -15.2906> }
				triangle { <17.5759, 138.8044, -15.2906>, <17.2039, 139.7211, -14.7871>, <16.5806, 139.4414, -14.4751> }
				triangle { <17.5759, 138.8044, -15.2906>, <16.5806, 139.4414, -14.4751>, <16.7398, 138.948, -14.8289> }
				triangle { <16.5806, 139.4414, -14.4751>, <16.555, 138.964, -14.7425>, <16.7398, 138.948, -14.8289> }
				triangle { <17.5759, 138.8044, -15.2906>, <16.5683, 138.5359, -15.531>, <18.189, 138.7236, -15.6532> }
				triangle { <16.1876, 138.7051, -14.893>, <16.7398, 138.948, -14.8289>, <16.555, 138.964, -14.7425> }
				triangle { <16.555, 138.964, -14.7425>, <16.4321, 139.0208, -14.6708>, <16.1876, 138.7051, -14.893> }
				triangle { <16.5806, 139.4414, -14.4751>, <16.4321, 139.0208, -14.6708>, <16.555, 138.964, -14.7425> }
				triangle { <16.5683, 138.5359, -15.531>, <17.6778, 138.5086, -15.8992>, <18.189, 138.7236, -15.6532> }
				triangle { <18.189, 138.7236, -15.6532>, <18.1077, 139.2869, -15.4246>, <17.2039, 139.7211, -14.7871> }
				triangle { <17.5759, 138.8044, -15.2906>, <16.7398, 138.948, -14.8289>, <16.1876, 138.7051, -14.893> }
				triangle { <16.1876, 138.7051, -14.893>, <16.5683, 138.5359, -15.531>, <17.5759, 138.8044, -15.2906> }
				triangle { <17.6778, 138.5086, -15.8992>, <16.5683, 138.5359, -15.531>, <17.0673, 138.4814, -15.7828> }
				triangle { <18.1077, 139.2869, -15.4246>, <17.6641, 139.6449, -15.1765>, <17.2039, 139.7211, -14.7871> }
				triangle { <17.2039, 139.7211, -14.7871>, <16.7844, 139.6424, -14.6564>, <16.5806, 139.4414, -14.4751> }
				triangle { <16.1876, 138.7051, -14.893>, <16.2796, 138.6417, -15.2868>, <16.5683, 138.5359, -15.531> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <19.2797, 137.5692, -16.7945>, <19.7699, 138.0266, -16.55>, 0.05002 }
				cylinder { <19.7699, 138.0266, -16.55>, <20.4011, 138.3432, -16.4465>, 0.05002 }
				cylinder { <20.4011, 138.3432, -16.4465>, <21.0995, 138.482, -16.4961>, 0.05002 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <21.0995, 138.482, -16.4961>, <22.594, 138.2426, -17.1479>, <21.8089, 138.5627, -16.4314> }
				triangle { <21.8089, 138.5627, -16.4314>, <22.594, 138.2426, -17.1479>, <23.2026, 138.431, -16.7502> }
				triangle { <21.8089, 138.5627, -16.4314>, <23.2026, 138.431, -16.7502>, <22.7647, 138.6923, -16.3842> }
				triangle { <23.2026, 138.431, -16.7502>, <22.9636, 138.7358, -16.3628>, <22.7647, 138.6923, -16.3842> }
				triangle { <21.8089, 138.5627, -16.4314>, <22.4057, 139.4107, -16.1669>, <21.0995, 138.482, -16.4961> }
				triangle { <23.1095, 139.1213, -16.129>, <22.7647, 138.6923, -16.3842>, <22.9636, 138.7358, -16.3628> }
				triangle { <22.9636, 138.7358, -16.3628>, <23.1142, 138.7457, -16.3891>, <23.1095, 139.1213, -16.129> }
				triangle { <23.2026, 138.431, -16.7502>, <23.1142, 138.7457, -16.3891>, <22.9636, 138.7358, -16.3628> }
				triangle { <22.4057, 139.4107, -16.1669>, <21.3136, 139.0216, -16.32>, <21.0995, 138.482, -16.4961> }
				triangle { <21.0995, 138.482, -16.4961>, <21.4194, 138.2576, -16.9689>, <22.594, 138.2426, -17.1479> }
				triangle { <21.8089, 138.5627, -16.4314>, <22.7647, 138.6923, -16.3842>, <23.1095, 139.1213, -16.129> }
				triangle { <23.1095, 139.1213, -16.129>, <22.4057, 139.4107, -16.1669>, <21.8089, 138.5627, -16.4314> }
				triangle { <21.3136, 139.0216, -16.32>, <22.4057, 139.4107, -16.1669>, <21.8557, 139.3096, -16.2187> }
				triangle { <21.4194, 138.2576, -16.9689>, <21.9907, 138.2753, -17.2134>, <22.594, 138.2426, -17.1479> }
				triangle { <22.594, 138.2426, -17.1479>, <22.9822, 138.4117, -17.00704>, <23.2026, 138.431, -16.7502> }
				triangle { <23.1095, 139.1213, -16.129>, <22.7969, 139.3801, -16.1816>, <22.4057, 139.4107, -16.1669> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			union { // compound leaf petiolet
				cylinder { <19.2797, 137.5692, -16.7945>, <19.5717, 138.1139, -16.4376>, 0.05002 }
				cylinder { <19.5717, 138.1139, -16.4376>, <19.8638, 138.6586, -16.08082>, 0.05002 }
				cylinder { <19.8638, 138.6586, -16.08082>, <20.1558, 139.2034, -15.7239>, 0.05002 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			mesh { // leaf
				triangle { <20.1558, 139.2034, -15.7239>, <21.4127, 140.2049, -15.3595>, <20.4439, 139.6715, -15.2637> }
				triangle { <20.4439, 139.6715, -15.2637>, <21.4127, 140.2049, -15.3595>, <21.4198, 140.5595, -14.6974> }
				triangle { <20.4439, 139.6715, -15.2637>, <21.4198, 140.5595, -14.6974>, <20.8351, 140.3319, -14.6776> }
				triangle { <21.4198, 140.5595, -14.6974>, <20.8995, 140.4763, -14.5476>, <20.8351, 140.3319, -14.6776> }
				triangle { <20.4439, 139.6715, -15.2637>, <20.03092, 140.525, -14.7676>, <20.1558, 139.2034, -15.7239> }
				triangle { <20.594, 140.7441, -14.3035>, <20.8351, 140.3319, -14.6776>, <20.8995, 140.4763, -14.5476> }
				triangle { <20.8995, 140.4763, -14.5476>, <20.9839, 140.5859, -14.4817>, <20.594, 140.7441, -14.3035> }
				triangle { <21.4198, 140.5595, -14.6974>, <20.9839, 140.5859, -14.4817>, <20.8995, 140.4763, -14.5476> }
				triangle { <20.03092, 140.525, -14.7676>, <19.8019, 139.6415, -15.4986>, <20.1558, 139.2034, -15.7239> }
				triangle { <20.1558, 139.2034, -15.7239>, <20.6997, 139.4243, -15.9017>, <21.4127, 140.2049, -15.3595> }
				triangle { <20.4439, 139.6715, -15.2637>, <20.8351, 140.3319, -14.6776>, <20.594, 140.7441, -14.3035> }
				triangle { <20.594, 140.7441, -14.3035>, <20.03092, 140.525, -14.7676>, <20.4439, 139.6715, -15.2637> }
				triangle { <19.8019, 139.6415, -15.4986>, <20.03092, 140.525, -14.7676>, <19.836, 140.136, -15.1226> }
				triangle { <20.6997, 139.4243, -15.9017>, <21.09967, 139.8808, -15.7671>, <21.4127, 140.2049, -15.3595> }
				triangle { <21.4127, 140.2049, -15.3595>, <21.433, 140.5076, -15.03212>, <21.4198, 140.5595, -14.6974> }
				triangle { <20.594, 140.7441, -14.3035>, <20.2664, 140.7504, -14.5486>, <20.03092, 140.525, -14.7676> }
				pigment { color rgb <0.0, 0.5, 0.0> }}
			}
		}
	union { // internode
		cylinder { <16.6928, 131.4654, -19.1803>, <17.103, 132.7333, -19.4518>, 0.05887 }
		cylinder { <17.103, 132.7333, -19.4518>, <17.5774, 133.9013, -19.962>, 0.05887 }
		cylinder { <17.5774, 133.9013, -19.962>, <18.09764, 134.9245, -20.6914>, 0.05887 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <18.09764, 134.9245, -20.6914>, <18.7096, 135.8648, -21.7229>, 0.03204 }
			cylinder { <18.7096, 135.8648, -21.7229>, <19.3271, 136.5627, -22.9288>, 0.03204 }
			cylinder { <19.3271, 136.5627, -22.9288>, <19.9263, 136.9913, -24.2629>, 0.03204 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <19.9263, 136.9913, -24.2629>, <20.2887, 137.0529, -24.5348>, 0.03204 }
				cylinder { <20.2887, 137.0529, -24.5348>, <20.7396, 137.0315, -24.6077>, 0.03204 }
				cylinder { <20.7396, 137.0315, -24.6077>, <21.1618, 136.9326, -24.4626>, 0.03204 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // compound leaf petiolet
				cylinder { <19.9263, 136.9913, -24.2629>, <19.9548, 137.1468, -24.692>, 0.03204 }
				cylinder { <19.9548, 137.1468, -24.692>, <19.8287, 137.3109, -25.09967>, 0.03204 }
				cylinder { <19.8287, 137.3109, -25.09967>, <19.5627, 137.4645, -25.4383>, 0.03204 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // compound leaf petiolet
				cylinder { <19.9263, 136.9913, -24.2629>, <20.1061, 137.1199, -24.6632>, 0.03204 }
				cylinder { <20.1061, 137.1199, -24.6632>, <20.2859, 137.2485, -25.06344>, 0.03204 }
				cylinder { <20.2859, 137.2485, -25.06344>, <20.4657, 137.3771, -25.4636>, 0.03204 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			}
		}
	union { // inflorescence
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <18.09764, 134.9245, -20.6914>, <18.1123, 134.9499, -20.7094>, 0.09849 }
				cylinder { <18.1123, 134.9499, -20.7094>, <18.1285, 134.9747, -20.7269>, 0.09849 }
				cylinder { <18.1285, 134.9747, -20.7269>, <18.1462, 134.9989, -20.7439>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.1462, 134.9989, -20.7439>, <21.265, 137.7714, -23.6325>, <20.8352, 138.9669, -22.502> }
					triangle { <21.265, 137.7714, -23.6325>, <25.5019, 141.5605, -24.4135>, <20.8352, 138.9669, -22.502> }
					triangle { <21.265, 137.7714, -23.6325>, <24.4433, 139.9062, -24.3>, <25.5019, 141.5605, -24.4135> }
					triangle { <25.5019, 141.5605, -24.4135>, <24.3345, 141.0075, -23.2247>, <20.8352, 138.9669, -22.502> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1462, 134.9989, -20.7439>, <19.8439, 138.8047, -23.6406>, <21.3071, 137.9601, -23.4469> }
					triangle { <19.8439, 138.8047, -23.6406>, <22.9076, 140.9525, -27.9904>, <21.3071, 137.9601, -23.4469> }
					triangle { <19.8439, 138.8047, -23.6406>, <21.4386, 140.3216, -26.8439>, <22.9076, 140.9525, -27.9904> }
					triangle { <22.9076, 140.9525, -27.9904>, <22.7661, 139.5427, -26.9537>, <21.3071, 137.9601, -23.4469> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1462, 134.9989, -20.7439>, <21.00211, 138.8928, -22.3057>, <20.05906, 138.691, -23.7063> }
					triangle { <21.00211, 138.8928, -22.3057>, <21.7758, 143.9708, -24.8621>, <20.05906, 138.691, -23.7063> }
					triangle { <21.00211, 138.8928, -22.3057>, <21.5847, 142.5348, -23.531>, <21.7758, 143.9708, -24.8621> }
					triangle { <21.7758, 143.9708, -24.8621>, <20.6542, 142.6242, -24.7586>, <20.05906, 138.691, -23.7063> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <18.09764, 134.9245, -20.6914>, <18.1096, 134.9501, -20.7111>, 0.09849 }
				cylinder { <18.1096, 134.9501, -20.7111>, <18.1206, 134.9752, -20.7319>, 0.09849 }
				cylinder { <18.1206, 134.9752, -20.7319>, <18.1303, 134.9999, -20.7539>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.1303, 134.9999, -20.7539>, <18.5738, 138.8885, -23.9849>, <19.9797, 138.0357, -24.4186> }
					triangle { <18.5738, 138.8885, -23.9849>, <19.6613, 141.1613, -29.1397>, <19.9797, 138.0357, -24.4186> }
					triangle { <18.5738, 138.8885, -23.9849>, <18.7682, 140.4987, -27.5169>, <19.6613, 141.1613, -29.1397> }
					triangle { <19.6613, 141.1613, -29.1397>, <19.9287, 139.7211, -28.172>, <19.9797, 138.0357, -24.4186> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1303, 134.9999, -20.7539>, <20.1534, 138.9487, -23.2179>, <18.7433, 138.7625, -24.15> }
					triangle { <20.1534, 138.9487, -23.2179>, <19.8693, 144.0786, -25.772>, <18.7433, 138.7625, -24.15> }
					triangle { <20.1534, 138.9487, -23.2179>, <20.2099, 142.6174, -24.4995>, <19.8693, 144.0786, -25.772> }
					triangle { <19.8693, 144.0786, -25.772>, <18.8775, 142.7194, -25.2709>, <18.7433, 138.7625, -24.15> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1303, 134.9999, -20.7539>, <19.8639, 137.8528, -24.5766>, <19.9412, 139.0143, -23.3369> }
					triangle { <19.8639, 137.8528, -24.5766>, <23.4823, 141.656, -26.8923>, <19.9412, 139.0143, -23.3369> }
					triangle { <19.8639, 137.8528, -24.5766>, <22.5356, 140.001, -26.4075>, <23.4823, 141.656, -26.8923> }
					triangle { <23.4823, 141.656, -26.8923>, <22.8832, 141.0694, -25.3499>, <19.9412, 139.0143, -23.3369> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <18.09764, 134.9245, -20.6914>, <18.1108, 134.9514, -20.7085>, 0.09849 }
				cylinder { <18.1108, 134.9514, -20.7085>, <18.1241, 134.979, -20.7241>, 0.09849 }
				cylinder { <18.1241, 134.979, -20.7241>, <18.1374, 135.0075, -20.7382>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.1374, 135.0075, -20.7382>, <20.7921, 139.1206, -22.07715>, <19.3099, 139.5262, -22.8054> }
					triangle { <20.7921, 139.1206, -22.07715>, <21.4572, 144.7748, -22.7893>, <19.3099, 139.5262, -22.8054> }
					triangle { <20.7921, 139.1206, -22.07715>, <21.5612, 142.93, -22.1137>, <21.4572, 144.7748, -22.7893> }
					triangle { <21.4572, 144.7748, -22.7893>, <20.2302, 143.5319, -22.6107>, <19.3099, 139.5262, -22.8054> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1374, 135.0075, -20.7382>, <20.1895, 138.622, -23.6505>, <20.5767, 139.272, -22.1275> }
					triangle { <20.1895, 138.622, -23.6505>, <24.3673, 142.2867, -25.07757>, <20.5767, 139.272, -22.1275> }
					triangle { <20.1895, 138.622, -23.6505>, <23.1317, 140.7566, -25.02602>, <24.3673, 142.2867, -25.07757> }
					triangle { <24.3673, 142.2867, -25.07757>, <23.7531, 141.3339, -23.737>, <20.5767, 139.272, -22.1275> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1374, 135.0075, -20.7382>, <19.1853, 139.6167, -22.5861>, <20.3316, 138.7223, -23.468> }
					triangle { <19.1853, 139.6167, -22.5861>, <20.3584, 143.2781, -26.8449>, <20.3316, 138.7223, -23.468> }
					triangle { <19.1853, 139.6167, -22.5861>, <19.4651, 142.2749, -25.4075>, <20.3584, 143.2781, -26.8449> }
					triangle { <20.3584, 143.2781, -26.8449>, <20.3729, 141.5705, -26.4374>, <20.3316, 138.7223, -23.468> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <18.09764, 134.9245, -20.6914>, <18.1117, 134.9493, -20.7107>, 0.09849 }
				cylinder { <18.1117, 134.9493, -20.7107>, <18.1268, 134.9729, -20.7307>, 0.09849 }
				cylinder { <18.1268, 134.9729, -20.7307>, <18.1428, 134.9953, -20.7515>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.1428, 134.9953, -20.7515>, <20.196, 137.6596, -24.5519>, <21.158, 138.2487, -23.2794> }
					triangle { <20.196, 137.6596, -24.5519>, <24.6365, 139.8192, -27.4737>, <21.158, 138.2487, -23.2794> }
					triangle { <20.196, 137.6596, -24.5519>, <23.0974, 138.7346, -26.9038>, <24.6365, 139.8192, -27.4737> }
					triangle { <24.6365, 139.8192, -27.4737>, <24.1892, 139.1711, -25.9047>, <21.158, 138.2487, -23.2794> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1428, 134.9953, -20.7515>, <19.8265, 138.9622, -23.4321>, <20.4236, 137.7146, -24.4215> }
					triangle { <19.8265, 138.9622, -23.4321>, <20.74, 141.816, -28.3251>, <20.4236, 137.7146, -24.4215> }
					triangle { <19.8265, 138.9622, -23.4321>, <20.03067, 141.2183, -26.5902>, <20.74, 141.816, -28.3251> }
					triangle { <20.74, 141.816, -28.3251>, <20.4166, 140.2104, -27.6929>, <20.4236, 137.7146, -24.4215> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1428, 134.9953, -20.7515>, <21.3291, 138.0428, -23.2649>, <19.8709, 138.8317, -23.6431> }
					triangle { <21.3291, 138.0428, -23.2649>, <23.2811, 143.1891, -24.885>, <19.8709, 138.8317, -23.6431> }
					triangle { <21.3291, 138.0428, -23.2649>, <23.06443, 141.439, -24.01295>, <23.2811, 143.1891, -24.885> }
					triangle { <23.2811, 143.1891, -24.885>, <21.8639, 142.3827, -24.2345>, <19.8709, 138.8317, -23.6431> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <18.09764, 134.9245, -20.6914>, <18.1092, 134.9511, -20.71>, 0.09849 }
				cylinder { <18.1092, 134.9511, -20.71>, <18.1192, 134.9782, -20.7287>, 0.09849 }
				cylinder { <18.1192, 134.9782, -20.7287>, <18.1276, 135.0058, -20.7475>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.1276, 135.0058, -20.7475>, <18.8611, 139.5925, -22.7923>, <19.08912, 138.6514, -24.1902> }
					triangle { <18.8611, 139.5925, -22.7923>, <18.1292, 143.5493, -26.8822>, <19.08912, 138.6514, -24.1902> }
					triangle { <18.8611, 139.5925, -22.7923>, <18.0279, 142.5205, -25.2085>, <18.1292, 143.5493, -26.8822> }
					triangle { <18.1292, 143.5493, -26.8822>, <18.02094, 141.8226, -26.5846>, <19.08912, 138.6514, -24.1902> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1276, 135.0058, -20.7475>, <20.3283, 138.7848, -23.3231>, <18.8171, 139.513, -23.04452> }
					triangle { <20.3283, 138.7848, -23.3231>, <21.6172, 144.3054, -24.207>, <18.8171, 139.513, -23.04452> }
					triangle { <20.3283, 138.7848, -23.3231>, <21.7044, 142.3949, -23.7457>, <21.6172, 144.3054, -24.207> }
					triangle { <21.6172, 144.3054, -24.207>, <20.4854, 143.2607, -23.3646>, <18.8171, 139.513, -23.04452> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1276, 135.0058, -20.7475>, <18.8308, 138.6113, -24.2495>, <20.1632, 138.9615, -23.2525> }
					triangle { <18.8308, 138.6113, -24.2495>, <22.07382, 141.6989, -27.8368>, <20.1632, 138.9615, -23.2525> }
					triangle { <18.8308, 138.6113, -24.2495>, <20.8011, 140.4038, -27.0796>, <22.07382, 141.6989, -27.8368> }
					triangle { <22.07382, 141.6989, -27.8368>, <22.1647, 140.678, -26.4114>, <20.1632, 138.9615, -23.2525> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <18.09764, 134.9245, -20.6914>, <18.112, 134.9505, -20.7088>, 0.09849 }
				cylinder { <18.112, 134.9505, -20.7088>, <18.1278, 134.9765, -20.725>, 0.09849 }
				cylinder { <18.1278, 134.9765, -20.725>, <18.1447, 135.0025, -20.7401>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.1447, 135.0025, -20.7401>, <21.4354, 138.1891, -22.9251>, <20.3069, 139.3321, -22.3665> }
					triangle { <21.4354, 138.1891, -22.9251>, <24.5931, 142.9772, -23.07442>, <20.3069, 139.3321, -22.3665> }
					triangle { <21.4354, 138.1891, -22.9251>, <24.00422, 141.1056, -22.9306>, <24.5931, 142.9772, -23.07442> }
					triangle { <24.5931, 142.9772, -23.07442>, <23.2027, 142.2542, -22.2831>, <20.3069, 139.3321, -22.3665> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1447, 135.0025, -20.7401>, <19.9477, 138.7075, -23.703>, <21.3509, 138.4053, -22.7911> }
					triangle { <19.9477, 138.7075, -23.703>, <23.9445, 141.087, -27.06208>, <21.3509, 138.4053, -22.7911> }
					triangle { <19.9477, 138.7075, -23.703>, <22.3252, 140.1896, -26.3967>, <23.9445, 141.087, -27.06208> }
					triangle { <23.9445, 141.087, -27.06208>, <23.7199, 139.8639, -25.8229>, <21.3509, 138.4053, -22.7911> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1447, 135.0025, -20.7401>, <20.3892, 139.3428, -22.1116>, <20.1907, 138.6597, -23.6563> }
					triangle { <20.3892, 139.3428, -22.1116>, <20.9402, 143.9962, -25.4224>, <20.1907, 138.6597, -23.6563> }
					triangle { <20.3892, 139.3428, -22.1116>, <20.5558, 142.7738, -23.9297>, <20.9402, 143.9962, -25.4224> }
					triangle { <20.9402, 143.9962, -25.4224>, <20.228, 142.392, -25.3883>, <20.1907, 138.6597, -23.6563> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <18.09764, 134.9245, -20.6914>, <18.1104, 134.9496, -20.7113>, 0.09849 }
				cylinder { <18.1104, 134.9496, -20.7113>, <18.1227, 134.9737, -20.7325>, 0.09849 }
				cylinder { <18.1227, 134.9737, -20.7325>, <18.1346, 134.9969, -20.755>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.1346, 134.9969, -20.755>, <18.9554, 138.3359, -24.4879>, <20.5711, 137.9206, -24.1582> }
					triangle { <18.9554, 138.3359, -24.4879>, <21.5216, 140.0949, -29.3087>, <20.5711, 137.9206, -24.1582> }
					triangle { <18.9554, 138.3359, -24.4879>, <20.2174, 139.4164, -28.00152>, <21.5216, 140.0949, -29.3087> }
					triangle { <21.5216, 140.0949, -29.3087>, <21.6921, 138.9631, -27.9776>, <20.5711, 137.9206, -24.1582> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1346, 134.9969, -20.755>, <20.01, 138.9994, -23.249>, <19.2026, 138.2484, -24.5436> }
					triangle { <20.01, 138.9994, -23.249>, <19.6185, 143.3669, -26.9492>, <19.2026, 138.2484, -24.5436> }
					triangle { <20.01, 138.9994, -23.249>, <19.7315, 142.2811, -25.3126>, <19.6185, 143.3669, -26.9492> }
					triangle { <19.6185, 143.3669, -26.9492>, <18.8578, 141.8474, -26.5083>, <19.2026, 138.2484, -24.5436> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1346, 134.9969, -20.755>, <20.5781, 137.6903, -24.2952>, <19.8576, 138.9772, -23.4486> }
					triangle { <20.5781, 137.6903, -24.2952>, <23.8274, 142.082, -26.0485>, <19.8576, 138.9772, -23.4486> }
					triangle { <20.5781, 137.6903, -24.2952>, <23.1826, 140.2969, -25.5308>, <23.8274, 142.082, -26.0485> }
					triangle { <23.8274, 142.082, -26.0485>, <22.7972, 141.5567, -24.7276>, <19.8576, 138.9772, -23.4486> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <18.09764, 134.9245, -20.6914>, <18.11, 134.9515, -20.7088>, 0.09849 }
				cylinder { <18.11, 134.9515, -20.7088>, <18.1217, 134.9795, -20.7251>, 0.09849 }
				cylinder { <18.1217, 134.9795, -20.7251>, <18.1325, 135.0085, -20.7403>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.1325, 135.0085, -20.7403>, <20.05622, 139.5218, -22.0392>, <18.9617, 139.3315, -23.3267> }
					triangle { <20.05622, 139.5218, -22.0392>, <19.6094, 144.9383, -23.8779>, <18.9617, 139.3315, -23.3267> }
					triangle { <20.05622, 139.5218, -22.0392>, <19.8527, 143.3345, -22.7648>, <19.6094, 144.9383, -23.8779> }
					triangle { <19.6094, 144.9383, -23.8779>, <18.7489, 143.4086, -23.8404>, <18.9617, 139.3315, -23.3267> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1325, 135.0085, -20.7403>, <20.2983, 138.6441, -23.5419>, <19.8524, 139.5886, -22.1999> }
					triangle { <20.2983, 138.6441, -23.5419>, <23.702, 143.2067, -24.2614>, <19.8524, 139.5886, -22.1999> }
					triangle { <20.2983, 138.6441, -23.5419>, <22.9543, 141.387, -24.2681>, <23.702, 143.2067, -24.2614> }
					triangle { <23.702, 143.2067, -24.2614>, <22.8285, 142.3049, -23.0343>, <19.8524, 139.5886, -22.1999> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1325, 135.0085, -20.7403>, <18.7397, 139.4076, -23.1972>, <20.3237, 138.8086, -23.3526> }
					triangle { <18.7397, 139.4076, -23.1972>, <20.6825, 142.6214, -27.5351>, <20.3237, 138.8086, -23.3526> }
					triangle { <18.7397, 139.4076, -23.1972>, <19.5353, 141.5974, -26.308>, <20.6825, 142.6214, -27.5351> }
					triangle { <20.6825, 142.6214, -27.5351>, <20.9266, 141.0806, -26.7299>, <20.3237, 138.8086, -23.3526> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <18.09764, 134.9245, -20.6914>, <18.1122, 134.9496, -20.71>, 0.09849 }
				cylinder { <18.1122, 134.9496, -20.71>, <18.1283, 134.9737, -20.7286>, 0.09849 }
				cylinder { <18.1283, 134.9737, -20.7286>, <18.1457, 134.9969, -20.7472>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.1457, 134.9969, -20.7472>, <20.9049, 137.6176, -24.1051>, <21.08254, 138.6521, -22.7672> }
					triangle { <20.9049, 137.6176, -24.1051>, <25.5146, 140.6432, -25.6915>, <21.08254, 138.6521, -22.7672> }
					triangle { <20.9049, 137.6176, -24.1051>, <24.1799, 139.2175, -25.4542>, <25.5146, 140.6432, -25.6915> }
					triangle { <25.5146, 140.6432, -25.6915>, <24.6211, 140.1119, -24.2768>, <21.08254, 138.6521, -22.7672> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1457, 134.9969, -20.7472>, <19.8087, 138.8787, -23.5619>, <21.0378, 137.7595, -23.9205> }
					triangle { <19.8087, 138.8787, -23.5619>, <21.9767, 141.1642, -28.3573>, <21.0378, 137.7595, -23.9205> }
					triangle { <19.8087, 138.8787, -23.5619>, <20.7721, 140.6204, -26.9001>, <21.9767, 141.1642, -28.3573> }
					triangle { <21.9767, 141.1642, -28.3573>, <21.8065, 139.6434, -27.497>, <21.0378, 137.7595, -23.9205> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1457, 134.9969, -20.7472>, <21.2751, 138.5152, -22.6407>, <19.9661, 138.741, -23.7025> }
					triangle { <21.2751, 138.5152, -22.6407>, <22.4558, 143.7363, -24.706>, <19.9661, 138.741, -23.7025> }
					triangle { <21.2751, 138.5152, -22.6407>, <22.3135, 142.1471, -23.5552>, <22.4558, 143.7363, -24.706> }
					triangle { <22.4558, 143.7363, -24.706>, <21.1294, 142.6215, -24.4234>, <19.9661, 138.741, -23.7025> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <18.09764, 134.9245, -20.6914>, <18.1093, 134.9505, -20.7107>, 0.09849 }
				cylinder { <18.1093, 134.9505, -20.7107>, <18.1195, 134.9765, -20.7308>, 0.09849 }
				cylinder { <18.1195, 134.9765, -20.7308>, <18.1283, 135.0025, -20.7517>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.1283, 135.0025, -20.7517>, <18.5464, 139.2536, -23.4923>, <19.5492, 138.248, -24.4279> }
					triangle { <18.5464, 139.2536, -23.4923>, <18.6759, 142.1648, -28.4348>, <19.5492, 138.248, -24.4279> }
					triangle { <18.5464, 139.2536, -23.4923>, <18.1321, 141.4004, -26.7055>, <18.6759, 142.1648, -28.4348> }
					triangle { <18.6759, 142.1648, -28.4348>, <18.8623, 140.5518, -27.7673>, <19.5492, 138.248, -24.4279> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1283, 135.0025, -20.7517>, <20.2459, 138.8864, -23.2394>, <18.6313, 139.1299, -23.7145> }
					triangle { <20.2459, 138.8864, -23.2394>, <20.4499, 144.3512, -24.9754>, <18.6313, 139.1299, -23.7145> }
					triangle { <20.2459, 138.8864, -23.2394>, <20.7831, 142.6505, -24.04434>, <20.4499, 144.3512, -24.9754> }
					triangle { <20.4499, 144.3512, -24.9754>, <19.3503, 143.13, -24.3577>, <18.6313, 139.1299, -23.7145> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1283, 135.0025, -20.7517>, <19.3563, 138.1203, -24.5633>, <20.02996, 139.0097, -23.28> }
					triangle { <19.3563, 138.1203, -24.5633>, <22.9728, 141.5447, -27.4118>, <20.02996, 139.0097, -23.28> }
					triangle { <19.3563, 138.1203, -24.5633>, <21.8438, 140.032, -26.8574>, <22.9728, 141.5447, -27.4118> }
					triangle { <22.9728, 141.5447, -27.4118>, <22.6994, 140.8142, -25.8391>, <20.02996, 139.0097, -23.28> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <18.09764, 134.9245, -20.6914>, <18.1114, 134.9511, -20.7084>, 0.09849 }
				cylinder { <18.1114, 134.9511, -20.7084>, <18.1259, 134.9782, -20.724>, 0.09849 }
				cylinder { <18.1259, 134.9782, -20.724>, <18.1409, 135.0058, -20.7381>, 0.09849 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.1409, 135.0058, -20.7381>, <21.1927, 138.7334, -22.3345>, <19.7007, 139.5263, -22.5265> }
					triangle { <21.1927, 138.7334, -22.3345>, <22.905, 144.205, -22.5559>, <19.7007, 139.5263, -22.5265> }
					triangle { <21.1927, 138.7334, -22.3345>, <22.7672, 142.2825, -22.1618>, <22.905, 144.205, -22.5559> }
					triangle { <22.905, 144.205, -22.5559>, <21.5241, 143.1966, -22.1583>, <19.7007, 139.5263, -22.5265> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1409, 135.0058, -20.7381>, <20.08771, 138.6404, -23.6973>, <21.01209, 138.9282, -22.2992> }
					triangle { <20.08771, 138.6404, -23.6973>, <24.4377, 141.6709, -25.8911>, <21.01209, 138.9282, -22.2992> }
					triangle { <20.08771, 138.6404, -23.6973>, <22.949, 140.4087, -25.6443>, <24.4377, 141.6709, -25.8911> }
					triangle { <24.4377, 141.6709, -25.8911>, <24.01213, 140.6247, -24.5471>, <21.01209, 138.9282, -22.2992> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				mesh { // flower petal
					triangle { <18.1409, 135.0058, -20.7381>, <19.6644, 139.5979, -22.2707>, <20.2929, 138.6791, -23.5563> }
					triangle { <19.6644, 139.5979, -22.2707>, <20.4333, 143.6775, -26.2312>, <20.2929, 138.6791, -23.5563> }
					triangle { <19.6644, 139.5979, -22.2707>, <19.7616, 142.6166, -24.7166>, <20.4333, 143.6775, -26.2312> }
					triangle { <20.4333, 143.6775, -26.2312>, <20.17, 141.9515, -26.04773>, <20.2929, 138.6791, -23.5563> }
					pigment { color rgb <0.99, 0.5, 0.75> }}
				}
			}
		}
scale 2.098
} // end clover

#declare Plant3 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.2308, 5.8361, -0.8343>, 0.7999 }
		cylinder { <0.2308, 5.8361, -0.8343>, <0.6876, 11.482, -2.4849>, 0.7999 }
		cylinder { <0.6876, 11.482, -2.4849>, <1.3604, 16.8156, -4.9161>, 0.7999 }
		pigment { color rgb <0.3, 0.58, 0.25> }}
	union { // internode
		cylinder { <1.3604, 16.8156, -4.9161>, <1.8764, 22.3188, -6.9796>, 0.8 }
		cylinder { <1.8764, 22.3188, -6.9796>, <2.2326, 27.962, -8.6642>, 0.8 }
		cylinder { <2.2326, 27.962, -8.6642>, <2.4272, 33.7145, -9.9607>, 0.8 }
		pigment { color rgb <0.3, 0.58, 0.25> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.4272, 33.7145, -9.9607>, <2.3049, 34.8795, -9.8196>, 0.9998 }
			cylinder { <2.3049, 34.8795, -9.8196>, <2.03776, 35.903, -9.2969>, 0.9998 }
			cylinder { <2.03776, 35.903, -9.2969>, <1.6615, 36.6478, -8.4628>, 0.9998 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <1.6615, 36.6478, -8.4628>, <-11.3265, 47.9825, 5.348>, <-13.478, 50.3571, 11.1942> }
			triangle { <1.6615, 36.6478, -8.4628>, <-8.8548, 44.7082, 0.4496>, <-11.3265, 47.9825, 5.348> }
			triangle { <1.6615, 36.6478, -8.4628>, <-6.3238, 41.6666, -4.6298>, <-8.8548, 44.7082, 0.4496> }
			triangle { <1.6615, 36.6478, -8.4628>, <-3.2113, 38.9122, -7.15>, <-6.3238, 41.6666, -4.6298> }
			triangle { <1.6615, 36.6478, -8.4628>, <-13.478, 50.3571, 11.1942>, <-8.471, 48.9995, 15.09026> }
			triangle { <-13.478, 50.3571, 11.1942>, <-16.3419, 47.2187, 21.2162>, <-8.471, 48.9995, 15.09026> }
			triangle { <-8.471, 48.9995, 15.09026>, <-16.3419, 47.2187, 21.2162>, <-15.6141, 48.1342, 24.1315> }
			triangle { <-8.471, 48.9995, 15.09026>, <-15.6141, 48.1342, 24.1315>, <-15.1686, 38.6494, 34.07832> }
			triangle { <-2.3811, 50.7542, 15.8445>, <0.3281, 48.4111, 10.2217>, <1.6615, 36.6478, -8.4628> }
			triangle { <0.3281, 48.4111, 10.2217>, <2.4202, 45.8037, 4.5566>, <1.6615, 36.6478, -8.4628> }
			triangle { <2.4202, 45.8037, 4.5566>, <4.2747, 42.265, -0.3841>, <1.6615, 36.6478, -8.4628> }
			triangle { <4.2747, 42.265, -0.3841>, <4.04024, 39.3216, -4.2451>, <1.6615, 36.6478, -8.4628> }
			triangle { <-8.471, 48.9995, 15.09026>, <-2.3811, 50.7542, 15.8445>, <1.6615, 36.6478, -8.4628> }
			triangle { <-8.471, 48.9995, 15.09026>, <-6.859, 47.7541, 25.01505>, <-2.3811, 50.7542, 15.8445> }
			triangle { <-10.01755, 46.8781, 27.3516>, <-6.859, 47.7541, 25.01505>, <-8.471, 48.9995, 15.09026> }
			triangle { <-15.1686, 38.6494, 34.07832>, <-10.01755, 46.8781, 27.3516>, <-8.471, 48.9995, 15.09026> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <2.4272, 33.7145, -9.9607>, <2.0872, 34.6292, -9.2408>, 0.08564 }
			cylinder { <2.0872, 34.6292, -9.2408>, <1.642, 34.5366, -8.1166>, 0.08564 }
			cylinder { <1.642, 34.5366, -8.1166>, <1.4518, 33.5116, -7.4971>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // inflor. internode
			cylinder { <1.4518, 33.5116, -7.4971>, <1.3883, 33.1699, -7.2906>, 0.08564 }
			cylinder { <1.3883, 33.1699, -7.2906>, <1.3249, 32.8282, -7.0842>, 0.08564 }
			cylinder { <1.3249, 32.8282, -7.0842>, <1.2615, 32.4866, -6.8777>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.2615, 32.4866, -6.8777>, <1.1722, 31.8508, -6.3863>, 0.08564 }
				cylinder { <1.1722, 31.8508, -6.3863>, <1.1219, 31.2723, -5.8238>, 0.08564 }
				cylinder { <1.1219, 31.2723, -5.8238>, <1.1112, 30.7596, -5.1988>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <1.1112, 30.7596, -5.1988>, <1.2158, 30.918, -3.2117>, <2.3819, 30.1452, -3.8257> }
					triangle { <1.2158, 30.918, -3.2117>, <1.2552, 29.8849, -1.8438>, <2.3819, 30.1452, -3.8257> }
					triangle { <2.3819, 30.1452, -3.8257>, <1.2552, 29.8849, -1.8438>, <2.5313, 28.9384, -2.5985> }
					triangle { <2.5313, 28.9384, -2.5985>, <1.2552, 29.8849, -1.8438>, <1.08021, 28.01954, -1.701> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.1112, 30.7596, -5.1988>, <-0.1816, 30.2866, -3.7534>, <1.121, 30.8925, -3.2342> }
					triangle { <-0.1816, 30.2866, -3.7534>, <-0.2501, 29.2634, -2.3792>, <1.121, 30.8925, -3.2342> }
					triangle { <1.121, 30.8925, -3.2342>, <-0.2501, 29.2634, -2.3792>, <1.2994, 29.8939, -1.8357> }
					triangle { <1.2994, 29.8939, -1.8357>, <-0.2501, 29.2634, -2.3792>, <0.9666, 27.9877, -1.729> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.1112, 30.7596, -5.1988>, <0.1695, 29.05594, -4.7569>, <-0.1792, 30.2088, -3.8172> }
					triangle { <0.1695, 29.05594, -4.7569>, <0.05628, 27.9567, -3.4459>, <-0.1792, 30.2088, -3.8172> }
					triangle { <-0.1792, 30.2088, -3.8172>, <0.05628, 27.9567, -3.4459>, <-0.2477, 29.2988, -2.3502> }
					triangle { <-0.2477, 29.2988, -2.3502>, <0.05628, 27.9567, -3.4459>, <0.9712, 27.894, -1.8058> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.1112, 30.7596, -5.1988>, <1.7874, 28.9151, -4.8448>, <0.2658, 29.03253, -4.7745> }
					triangle { <1.7874, 28.9151, -4.8448>, <1.7538, 27.7584, -3.5796>, <0.2658, 29.03253, -4.7745> }
					triangle { <0.2658, 29.03253, -4.7745>, <1.7538, 27.7584, -3.5796>, <0.01361, 27.9699, -3.4358> }
					triangle { <0.01361, 27.9699, -3.4358>, <1.7538, 27.7584, -3.5796>, <1.08767, 27.867, -1.826> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.1112, 30.7596, -5.1988>, <2.4438, 30.08333, -3.8754>, <1.8726, 28.9926, -4.7798> }
					triangle { <2.4438, 30.08333, -3.8754>, <2.506, 28.9681, -2.5745>, <1.8726, 28.9926, -4.7798> }
					triangle { <1.8726, 28.9926, -4.7798>, <2.506, 28.9681, -2.5745>, <1.7571, 27.7438, -3.5915> }
					triangle { <1.7571, 27.7438, -3.5915>, <2.506, 28.9681, -2.5745>, <1.156, 27.9457, -1.7602> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		union { // inflor. internode
			cylinder { <1.2615, 32.4866, -6.8777>, <1.198, 32.1449, -6.6712>, 0.08564 }
			cylinder { <1.198, 32.1449, -6.6712>, <1.1346, 31.8032, -6.4647>, 0.08564 }
			cylinder { <1.1346, 31.8032, -6.4647>, <1.07123, 31.4615, -6.2582>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.07123, 31.4615, -6.2582>, <0.8573, 30.773, -5.8924>, 0.08564 }
				cylinder { <0.8573, 30.773, -5.8924>, <0.5596, 30.08974, -5.5794>, 0.08564 }
				cylinder { <0.5596, 30.08974, -5.5794>, <0.1825, 29.4218, -5.3237>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <0.1825, 29.4218, -5.3237>, <-1.004406, 28.5137, -5.8478>, <-1.2369, 29.05125, -4.7866> }
					triangle { <-1.004406, 28.5137, -5.8478>, <-1.7017, 27.418, -5.4431>, <-1.2369, 29.05125, -4.7866> }
					triangle { <-1.2369, 29.05125, -4.7866>, <-1.7017, 27.418, -5.4431>, <-1.9009, 28.00851, -4.1944> }
					triangle { <-1.9009, 28.00851, -4.1944>, <-1.7017, 27.418, -5.4431>, <-1.5189, 26.5209, -4.2666> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <0.1825, 29.4218, -5.3237>, <0.1297, 27.9032, -5.77>, <-0.937, 28.4719, -5.8576> }
					triangle { <0.1297, 27.9032, -5.77>, <-0.5122, 26.7591, -5.41>, <-0.937, 28.4719, -5.8576> }
					triangle { <-0.937, 28.4719, -5.8576>, <-0.5122, 26.7591, -5.41>, <-1.7315, 27.4375, -5.4361> }
					triangle { <-1.7315, 27.4375, -5.4361>, <-0.5122, 26.7591, -5.41>, <-1.4375, 26.4708, -4.2771> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <0.1825, 29.4218, -5.3237>, <0.6077, 28.08671, -4.5856>, <0.1711, 27.9059, -5.7017> }
					triangle { <0.6077, 28.08671, -4.5856>, <0.03272, 26.9243, -4.1748>, <0.1711, 27.9059, -5.7017> }
					triangle { <0.1711, 27.9059, -5.7017>, <0.03272, 26.9243, -4.1748>, <-0.533, 26.7594, -5.4398> }
					triangle { <-0.533, 26.7594, -5.4398>, <0.03272, 26.9243, -4.1748>, <-1.3886, 26.4749, -4.1944> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <0.1825, 29.4218, -5.3237>, <-0.2264, 28.8123, -3.9203>, <0.5663, 28.1302, -4.5329> }
					triangle { <-0.2264, 28.8123, -3.9203>, <-0.8148, 27.6868, -3.433>, <0.5663, 28.1302, -4.5329> }
					triangle { <0.5663, 28.1302, -4.5329>, <-0.8148, 27.6868, -3.433>, <0.04951, 26.9049, -4.2006> }
					triangle { <0.04951, 26.9049, -4.2006>, <-0.8148, 27.6868, -3.433>, <-1.4394, 26.5275, -4.1319> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <0.1825, 29.4218, -5.3237>, <-1.2378, 29.08025, -4.7122>, <-0.317, 28.8487, -3.9588> }
					triangle { <-1.2378, 29.08025, -4.7122>, <-1.9029, 27.9965, -4.2287>, <-0.317, 28.8487, -3.9588> }
					triangle { <-0.317, 28.8487, -3.9588>, <-1.9029, 27.9965, -4.2287>, <-0.8086, 27.6885, -3.4192> }
					triangle { <-0.8086, 27.6885, -3.4192>, <-1.9029, 27.9965, -4.2287>, <-1.5211, 26.5563, -4.1772> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		}
	union { // internode
		cylinder { <2.4272, 33.7145, -9.9607>, <2.6919, 39.4351, -11.3799>, 0.8 }
		cylinder { <2.6919, 39.4351, -11.3799>, <3.02648, 45.1205, -12.921>, 0.8 }
		cylinder { <3.02648, 45.1205, -12.921>, <3.4307, 50.7671, -14.5829>, 0.8 }
		pigment { color rgb <0.3, 0.58, 0.25> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <3.4307, 50.7671, -14.5829>, <3.7102, 51.7022, -15.246>, 0.9998 }
			cylinder { <3.7102, 51.7022, -15.246>, <4.1508, 52.3177, -16.151>, 0.9998 }
			cylinder { <4.1508, 52.3177, -16.151>, <4.6935, 52.5313, -17.1766>, 0.9998 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <4.6935, 52.5313, -17.1766>, <20.2317, 54.774, -32.7151>, <23.2011, 53.8294, -38.6088> }
			triangle { <4.6935, 52.5313, -17.1766>, <16.9225, 54.4916, -27.2567>, <20.2317, 54.774, -32.7151> }
			triangle { <4.6935, 52.5313, -17.1766>, <13.5667, 54.5042, -21.7615>, <16.9225, 54.4916, -27.2567> }
			triangle { <4.6935, 52.5313, -17.1766>, <9.9124, 53.5458, -18.7031>, <13.5667, 54.5042, -21.7615> }
			triangle { <4.6935, 52.5313, -17.1766>, <23.2011, 53.8294, -38.6088>, <18.4512, 51.05262, -42.04678> }
			triangle { <23.2011, 53.8294, -38.6088>, <26.5775, 45.9992, -45.3749>, <18.4512, 51.05262, -42.04678> }
			triangle { <18.4512, 51.05262, -42.04678>, <26.5775, 45.9992, -45.3749>, <26.2462, 45.4085, -48.4421> }
			triangle { <18.4512, 51.05262, -42.04678>, <26.2462, 45.4085, -48.4421>, <25.5545, 32.3108, -52.5738> }
			triangle { <12.7256, 52.5912, -44.4101>, <9.2301, 53.4886, -38.8046>, <4.6935, 52.5313, -17.1766> }
			triangle { <9.2301, 53.4886, -38.8046>, <6.3072, 54.1383, -32.9476>, <4.6935, 52.5313, -17.1766> }
			triangle { <6.3072, 54.1383, -32.9476>, <3.5707, 53.6081, -27.2377>, <4.6935, 52.5313, -17.1766> }
			triangle { <3.5707, 53.6081, -27.2377>, <3.0731, 52.9327, -22.45>, <4.6935, 52.5313, -17.1766> }
			triangle { <18.4512, 51.05262, -42.04678>, <12.7256, 52.5912, -44.4101>, <4.6935, 52.5313, -17.1766> }
			triangle { <18.4512, 51.05262, -42.04678>, <17.6337, 45.1974, -50.2747>, <12.7256, 52.5912, -44.4101> }
			triangle { <20.8632, 43.08913, -51.4276>, <17.6337, 45.1974, -50.2747>, <18.4512, 51.05262, -42.04678> }
			triangle { <25.5545, 32.3108, -52.5738>, <20.8632, 43.08913, -51.4276>, <18.4512, 51.05262, -42.04678> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <3.4307, 50.7671, -14.5829>, <3.9482, 51.1867, -15.5962>, 0.08564 }
			cylinder { <3.9482, 51.1867, -15.5962>, <4.4817, 50.5259, -16.4618>, 0.08564 }
			cylinder { <4.4817, 50.5259, -16.4618>, <4.5998, 49.3191, -16.4798>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // inflor. internode
			cylinder { <4.5998, 49.3191, -16.4798>, <4.6391, 48.9168, -16.4859>, 0.08564 }
			cylinder { <4.6391, 48.9168, -16.4859>, <4.6785, 48.5146, -16.4919>, 0.08564 }
			cylinder { <4.6785, 48.5146, -16.4919>, <4.7178, 48.1123, -16.4979>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.7178, 48.1123, -16.4979>, <4.7727, 47.313, -16.606>, 0.08564 }
				cylinder { <4.7727, 47.313, -16.606>, <4.8029, 46.531, -16.8086>, 0.08564 }
				cylinder { <4.8029, 46.531, -16.8086>, <4.8081, 45.7779, -17.1027>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <4.8081, 45.7779, -17.1027>, <4.9107, 44.946, -18.9143>, <3.6049, 44.6499, -18.1787> }
					triangle { <4.9107, 44.946, -18.9143>, <4.8711, 43.3791, -19.6094>, <3.6049, 44.6499, -18.1787> }
					triangle { <3.6049, 44.6499, -18.1787>, <4.8711, 43.3791, -19.6094>, <3.4217, 43.00816, -18.6844> }
					triangle { <3.4217, 43.00816, -18.6844>, <4.8711, 43.3791, -19.6094>, <4.8245, 41.6773, -18.8141> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <4.8081, 45.7779, -17.1027>, <6.1616, 44.5753, -17.9432>, <4.9991, 44.9289, -18.8691> }
					triangle { <6.1616, 44.5753, -17.9432>, <6.2303, 43.00715, -18.633>, <4.9991, 44.9289, -18.8691> }
					triangle { <4.9991, 44.9289, -18.8691>, <6.2303, 43.00715, -18.633>, <4.8294, 43.3857, -19.627> }
					triangle { <4.8294, 43.3857, -19.627>, <6.2303, 43.00715, -18.633>, <4.9301, 41.6563, -18.7584> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <4.8081, 45.7779, -17.1027>, <5.567, 44.02127, -16.5344>, <6.1435, 44.5392, -17.851> }
					triangle { <5.567, 44.02127, -16.5344>, <5.6645, 42.4152, -17.1268>, <6.1435, 44.5392, -17.851> }
					triangle { <6.1435, 44.5392, -17.851>, <5.6645, 42.4152, -17.1268>, <6.235, 43.02375, -18.6754> }
					triangle { <6.235, 43.02375, -18.6754>, <5.6645, 42.4152, -17.1268>, <4.9067, 41.6129, -18.6476> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <4.8081, 45.7779, -17.1027>, <3.9431, 44.04434, -16.6217>, <5.4673, 44.01564, -16.5218> }
					triangle { <3.9431, 44.04434, -16.6217>, <3.9505, 42.4158, -17.1583>, <5.4673, 44.01564, -16.5218> }
					triangle { <5.4673, 44.01564, -16.5218>, <3.9505, 42.4158, -17.1583>, <5.7093, 42.419, -17.1358> }
					triangle { <5.7093, 42.419, -17.1358>, <3.9505, 42.4158, -17.1583>, <4.7864, 41.6067, -18.6339> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <4.8081, 45.7779, -17.1027>, <3.5314, 44.6245, -18.1148>, <3.8747, 44.0851, -16.7273> }
					triangle { <3.5314, 44.6245, -18.1148>, <3.4527, 43.02061, -18.7158>, <3.8747, 44.0851, -16.7273> }
					triangle { <3.8747, 44.0851, -16.7273>, <3.4527, 43.02061, -18.7158>, <3.9443, 42.4092, -17.1414> }
					triangle { <3.9443, 42.4092, -17.1414>, <3.4527, 43.02061, -18.7158>, <4.7349, 41.6471, -18.7383> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		union { // inflor. internode
			cylinder { <4.7178, 48.1123, -16.4979>, <4.7572, 47.7101, -16.5039>, 0.08564 }
			cylinder { <4.7572, 47.7101, -16.5039>, <4.7966, 47.3078, -16.5099>, 0.08564 }
			cylinder { <4.7966, 47.3078, -16.5099>, <4.8359, 46.9055, -16.5159>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.8359, 46.9055, -16.5159>, <4.9955, 46.1142, -16.4722>, 0.08564 }
				cylinder { <4.9955, 46.1142, -16.4722>, <5.2336, 45.348, -16.3733>, 0.08564 }
				cylinder { <5.2336, 45.348, -16.3733>, <5.5467, 44.6184, -16.2208>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <5.5467, 44.6184, -16.2208>, <6.5566, 44.01191, -15.1623>, <6.9529, 43.9429, -16.3057> }
					triangle { <6.5566, 44.01191, -15.1623>, <7.1466, 42.8172, -14.8881>, <6.9529, 43.9429, -16.3057> }
					triangle { <6.9529, 43.9429, -16.3057>, <7.1466, 42.8172, -14.8881>, <7.5341, 42.7042, -16.224> }
					triangle { <7.5341, 42.7042, -16.224>, <7.1466, 42.8172, -14.8881>, <6.9643, 41.4714, -15.5031> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <5.5467, 44.6184, -16.2208>, <5.3675, 43.5149, -15.09899>, <6.4839, 43.9846, -15.1434> }
					triangle { <5.3675, 43.5149, -15.09899>, <5.8926, 42.3036, -14.7708>, <6.4839, 43.9846, -15.1434> }
					triangle { <6.4839, 43.9846, -15.1434>, <5.8926, 42.3036, -14.7708>, <7.1792, 42.8288, -14.8993> }
					triangle { <7.1792, 42.8288, -14.8993>, <5.8926, 42.3036, -14.7708>, <6.8766, 41.4383, -15.4816> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <5.5467, 44.6184, -16.2208>, <5.02925, 43.1227, -16.2808>, <5.3334, 43.4864, -15.1653> }
					triangle { <5.02925, 43.1227, -16.2808>, <5.4906, 41.8748, -15.9974>, <5.3334, 43.4864, -15.1653> }
					triangle { <5.3334, 43.4864, -15.1653>, <5.4906, 41.8748, -15.9974>, <5.9103, 42.3172, -14.7421> }
					triangle { <5.9103, 42.3172, -14.7421>, <5.4906, 41.8748, -15.9974>, <6.8366, 41.4042, -15.5622> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <5.5467, 44.6184, -16.2208>, <6.006196, 43.3737, -17.08568>, <5.08053, 43.1321, -16.3414> }
					triangle { <6.006196, 43.3737, -17.08568>, <6.4925, 42.1193, -16.8843>, <5.08053, 43.1321, -16.3414> }
					triangle { <5.08053, 43.1321, -16.3414>, <6.4925, 42.1193, -16.8843>, <5.4692, 41.8717, -15.9682> }
					triangle { <5.4692, 41.8717, -15.9682>, <6.4925, 42.1193, -16.8843>, <6.8992, 41.416, -15.6342> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <5.5467, 44.6184, -16.2208>, <6.9644, 43.9315, -16.3839>, <6.09658, 43.4185, -17.05682> }
					triangle { <6.9644, 43.9315, -16.3839>, <7.5314, 42.7105, -16.1883>, <6.09658, 43.4185, -17.05682> }
					triangle { <6.09658, 43.4185, -17.05682>, <7.5314, 42.7105, -16.1883>, <6.4879, 42.1145, -16.8979> }
					triangle { <6.4879, 42.1145, -16.8979>, <7.5314, 42.7105, -16.1883>, <6.9793, 41.4581, -15.5972> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		}
	union { // internode
		cylinder { <3.4307, 50.7671, -14.5829>, <3.7503, 56.4508, -16.1333>, 0.8 }
		cylinder { <3.7503, 56.4508, -16.1333>, <3.985, 62.1681, -17.5713>, 0.8 }
		cylinder { <3.985, 62.1681, -17.5713>, <4.1348, 67.9155, -18.896>, 0.8 }
		pigment { color rgb <0.3, 0.58, 0.25> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <4.1348, 67.9155, -18.896>, <3.9133, 69.07121, -18.8097>, 0.9998 }
			cylinder { <3.9133, 69.07121, -18.8097>, <3.4701, 70.07835, -18.3839>, 0.9998 }
			cylinder { <3.4701, 70.07835, -18.3839>, <2.8645, 70.8019, -17.6756>, 0.9998 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <2.8645, 70.8019, -17.6756>, <-13.6595, 81.3643, -7.5121>, <-17.2629, 83.6263, -2.3793> }
			triangle { <2.8645, 70.8019, -17.6756>, <-9.9145, 78.2288, -11.6314>, <-13.6595, 81.3643, -7.5121> }
			triangle { <2.8645, 70.8019, -17.6756>, <-6.08332, 75.3285, -15.9172>, <-9.9145, 78.2288, -11.6314> }
			triangle { <2.8645, 70.8019, -17.6756>, <-2.3067, 72.7628, -17.5848>, <-6.08332, 75.3285, -15.9172> }
			triangle { <2.8645, 70.8019, -17.6756>, <-17.2629, 83.6263, -2.3793>, <-13.24, 82.6025, 2.6066> }
			triangle { <-17.2629, 83.6263, -2.3793>, <-22.2094, 80.3605, 6.7507>, <-13.24, 82.6025, 2.6066> }
			triangle { <-13.24, 82.6025, 2.6066>, <-22.2094, 80.3605, 6.7507>, <-22.2433, 81.3331, 9.7373> }
			triangle { <-13.24, 82.6025, 2.6066>, <-22.2433, 81.3331, 9.7373>, <-23.5821, 71.9402, 19.6912> }
			triangle { <-7.6141, 84.7384, 4.7331>, <-3.524, 82.5438, -0.05231>, <2.8645, 70.8019, -17.6756> }
			triangle { <-3.524, 82.5438, -0.05231>, <-0.00695, 80.04667, -5.01854>, <2.8645, 70.8019, -17.6756> }
			triangle { <-0.00695, 80.04667, -5.01854>, <3.165, 76.6085, -9.3185>, <2.8645, 70.8019, -17.6756> }
			triangle { <3.165, 76.6085, -9.3185>, <4.02101, 73.6386, -13.06994>, <2.8645, 70.8019, -17.6756> }
			triangle { <-13.24, 82.6025, 2.6066>, <-7.6141, 84.7384, 4.7331>, <2.8645, 70.8019, -17.6756> }
			triangle { <-13.24, 82.6025, 2.6066>, <-13.9346, 81.5058, 12.6548>, <-7.6141, 84.7384, 4.7331> }
			triangle { <-17.4956, 80.4444, 14.2026>, <-13.9346, 81.5058, 12.6548>, <-13.24, 82.6025, 2.6066> }
			triangle { <-23.5821, 71.9402, 19.6912>, <-17.4956, 80.4444, 14.2026>, <-13.24, 82.6025, 2.6066> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <4.1348, 67.9155, -18.896>, <3.581, 68.8104, -18.2934>, 0.08564 }
			cylinder { <3.581, 68.8104, -18.2934>, <2.8904, 68.6952, -17.3032>, 0.08564 }
			cylinder { <2.8904, 68.6952, -17.3032>, <2.6215, 67.6631, -16.7261>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // inflor. internode
			cylinder { <2.6215, 67.6631, -16.7261>, <2.5318, 67.3191, -16.5337>, 0.08564 }
			cylinder { <2.5318, 67.3191, -16.5337>, <2.4422, 66.9751, -16.3414>, 0.08564 }
			cylinder { <2.4422, 66.9751, -16.3414>, <2.3525, 66.6311, -16.149>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.3525, 66.6311, -16.149>, <2.1884, 65.9932, -15.6801>, 0.08564 }
				cylinder { <2.1884, 65.9932, -15.6801>, <2.04202, 65.4153, -15.1342>, 0.08564 }
				cylinder { <2.04202, 65.4153, -15.1342>, <1.9154, 64.9058, -14.5193>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <1.9154, 64.9058, -14.5193>, <1.5403, 65.07948, -12.5664>, <2.8621, 64.3784, -12.8752> }
					triangle { <1.5403, 65.07948, -12.5664>, <1.3187, 64.05718, -11.2079>, <2.8621, 64.3784, -12.8752> }
					triangle { <2.8621, 64.3784, -12.8752>, <1.3187, 64.05718, -11.2079>, <2.7907, 63.1889, -11.6242> }
					triangle { <2.7907, 63.1889, -11.6242>, <1.3187, 64.05718, -11.2079>, <1.2269, 62.1851, -11.07445> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.9154, 64.9058, -14.5193>, <0.3496, 64.3594, -13.4083>, <1.4552, 65.04807, -12.61> }
					triangle { <0.3496, 64.3594, -13.4083>, <0.02134, 63.3402, -12.0692>, <1.4552, 65.04807, -12.61> }
					triangle { <1.4552, 65.04807, -12.61>, <0.02134, 63.3402, -12.0692>, <1.3591, 64.06893, -11.1898> }
					triangle { <1.3591, 64.06893, -11.1898>, <0.02134, 63.3402, -12.0692>, <1.1252, 62.1461, -11.1276> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.9154, 64.9058, -14.5193>, <0.9997, 63.1485, -14.2779>, <0.3716, 64.2816, -13.4682> }
					triangle { <0.9997, 63.1485, -14.2779>, <0.6474, 62.05043, -13.00911>, <0.3716, 64.2816, -13.4682> }
					triangle { <0.3716, 64.2816, -13.4682>, <0.6474, 62.05043, -13.00911>, <0.01473, 63.3758, -12.04109> }
					triangle { <0.01473, 63.3758, -12.04109>, <0.6474, 62.05043, -13.00911>, <1.1533, 62.05259, -11.1994> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.9154, 64.9058, -14.5193>, <2.5984, 63.1089, -13.9815>, <1.09876, 63.1311, -14.2719> }
					triangle { <2.5984, 63.1089, -13.9815>, <2.3376, 61.9581, -12.7375>, <1.09876, 63.1311, -14.2719> }
					triangle { <1.09876, 63.1311, -14.2719>, <2.3376, 61.9581, -12.7375>, <0.6028, 62.06099, -13.00954> }
					triangle { <0.6028, 62.06099, -13.00954>, <2.3376, 61.9581, -12.7375>, <1.2726, 62.03285, -11.1912> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.9154, 64.9058, -14.5193>, <2.9376, 64.3203, -12.9078>, <2.6612, 63.1918, -13.8998> }
					triangle { <2.9376, 64.3203, -12.9078>, <2.7588, 63.2171, -11.6075>, <2.6612, 63.1918, -13.8998> }
					triangle { <2.6612, 63.1918, -13.8998>, <2.7588, 63.2171, -11.6075>, <2.3444, 61.9437, -12.748> }
					triangle { <2.3444, 61.9437, -12.748>, <2.7588, 63.2171, -11.6075>, <1.3188, 62.116, -11.1128> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		union { // inflor. internode
			cylinder { <2.3525, 66.6311, -16.149>, <2.2629, 66.287, -15.9566>, 0.08564 }
			cylinder { <2.2629, 66.287, -15.9566>, <2.1733, 65.943, -15.7642>, 0.08564 }
			cylinder { <2.1733, 65.943, -15.7642>, <2.08365, 65.599, -15.5719>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.08365, 65.599, -15.5719>, <1.8313, 64.9001, -15.2533>, 0.08564 }
				cylinder { <1.8313, 64.9001, -15.2533>, <1.5097, 64.2009, -15.00571>, 0.08564 }
				cylinder { <1.5097, 64.2009, -15.00571>, <1.1237, 63.5119, -14.8327>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <1.1237, 63.5119, -14.8327>, <0.1497, 62.5289, -15.6029>, <-0.3574, 63.05568, -14.6362> }
					triangle { <0.1497, 62.5289, -15.6029>, <-0.5564, 61.3936, -15.352>, <-0.3574, 63.05568, -14.6362> }
					triangle { <-0.3574, 63.05568, -14.6362>, <-0.5564, 61.3936, -15.352>, <-1.07849, 61.9761, -14.1962> }
					triangle { <-1.07849, 61.9761, -14.1962>, <-0.5564, 61.3936, -15.352>, <-0.602, 60.515, -14.1484> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.1237, 63.5119, -14.8327>, <1.2681, 61.9909, -15.2498>, <0.2198, 62.4914, -15.5958> }
					triangle { <1.2681, 61.9909, -15.2498>, <0.6291, 60.8106, -15.02852>, <0.2198, 62.4914, -15.5958> }
					triangle { <0.2198, 62.4914, -15.5958>, <0.6291, 60.8106, -15.02852>, <-0.5882, 61.4112, -15.3525> }
					triangle { <-0.5882, 61.4112, -15.3525>, <0.6291, 60.8106, -15.02852>, <-0.5175, 60.4701, -14.1386> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.1237, 63.5119, -14.8327>, <1.4425, 62.2094, -13.9901>, <1.2921, 61.9966, -15.1738> }
					triangle { <1.4425, 62.2094, -13.9901>, <0.8576, 61.01522, -13.7033>, <1.2921, 61.9966, -15.1738> }
					triangle { <1.2921, 61.9966, -15.1738>, <0.8576, 61.01522, -13.7033>, <0.6159, 60.8095, -15.06238> }
					triangle { <0.6159, 60.8095, -15.06238>, <0.8576, 61.01522, -13.7033>, <-0.4898, 60.4776, -14.04689> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.1237, 63.5119, -14.8327>, <0.4335, 62.8844, -13.5529>, <1.3874, 62.2505, -13.9495> }
					triangle { <0.4335, 62.8844, -13.5529>, <-0.1845, 61.7265, -13.1955>, <1.3874, 62.2505, -13.9495> }
					triangle { <1.3874, 62.2505, -13.9495>, <-0.1845, 61.7265, -13.1955>, <0.8811, 60.9968, -13.7241> }
					triangle { <0.8811, 60.9968, -13.7241>, <-0.1845, 61.7265, -13.1955>, <-0.5569, 60.5272, -13.999> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <1.1237, 63.5119, -14.8327>, <-0.3775, 63.08491, -14.5647>, <0.3525, 62.9149, -13.6122> }
					triangle { <-0.3775, 63.08491, -14.5647>, <-1.07172, 61.9639, -14.2298>, <0.3525, 62.9149, -13.6122> }
					triangle { <0.3525, 62.9149, -13.6122>, <-1.07172, 61.9639, -14.2298>, <-0.1819, 61.7287, -13.1807> }
					triangle { <-0.1819, 61.7287, -13.1807>, <-1.07172, 61.9639, -14.2298>, <-0.6273, 60.5507, -14.06277> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		}
	union { // internode
		cylinder { <4.1348, 67.9155, -18.896>, <4.7759, 73.4889, -20.7225>, 0.8 }
		cylinder { <4.7759, 73.4889, -20.7225>, <5.8988, 78.8044, -23.02339>, 0.8 }
		cylinder { <5.8988, 78.8044, -23.02339>, <7.4866, 83.7822, -25.7639>, 0.8 }
		pigment { color rgb <0.3, 0.58, 0.25> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <7.4866, 83.7822, -25.7639>, <8.04908, 84.4902, -26.5215>, 0.9996 }
			cylinder { <8.04908, 84.4902, -26.5215>, <8.7811, 84.816, -27.3872>, 0.9996 }
			cylinder { <8.7811, 84.816, -27.3872>, <9.5846, 84.7161, -28.245>, 0.9996 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <9.5846, 84.7161, -28.245>, <28.6324, 81.7068, -39.00726>, <32.803, 79.05231, -43.4778> }
			triangle { <9.5846, 84.7161, -28.245>, <24.07211, 83.09235, -34.7538>, <28.6324, 81.7068, -39.00726> }
			triangle { <9.5846, 84.7161, -28.245>, <19.4993, 84.7747, -30.5467>, <24.07211, 83.09235, -34.7538> }
			triangle { <9.5846, 84.7161, -28.245>, <15.1066, 84.9132, -28.4729>, <19.4993, 84.7747, -30.5467> }
			triangle { <9.5846, 84.7161, -28.245>, <32.803, 79.05231, -43.4778>, <28.7106, 75.8382, -47.3503> }
			triangle { <32.803, 79.05231, -43.4778>, <36.6167, 69.512, -47.0667>, <28.7106, 75.8382, -47.3503> }
			triangle { <28.7106, 75.8382, -47.3503>, <36.6167, 69.512, -47.0667>, <36.9742, 68.1734, -49.8849> }
			triangle { <28.7106, 75.8382, -47.3503>, <36.9742, 68.1734, -49.8849>, <35.5009, 54.5433, -50.9176> }
			triangle { <24.02083, 77.1293, -51.4801>, <19.4105, 79.7026, -47.412>, <9.5846, 84.7161, -28.245> }
			triangle { <19.4105, 79.7026, -47.412>, <15.2524, 82.06026, -42.8951>, <9.5846, 84.7161, -28.245> }
			triangle { <15.2524, 82.06026, -42.8951>, <11.1443, 83.23, -38.1929>, <9.5846, 84.7161, -28.245> }
			triangle { <11.1443, 83.23, -38.1929>, <9.39, 83.8563, -33.7045>, <9.5846, 84.7161, -28.245> }
			triangle { <28.7106, 75.8382, -47.3503>, <24.02083, 77.1293, -51.4801>, <9.5846, 84.7161, -28.245> }
			triangle { <28.7106, 75.8382, -47.3503>, <29.1412, 68.1299, -53.908>, <24.02083, 77.1293, -51.4801> }
			triangle { <32.2271, 65.5635, -53.6138>, <29.1412, 68.1299, -53.908>, <28.7106, 75.8382, -47.3503> }
			triangle { <35.5009, 54.5433, -50.9176>, <32.2271, 65.5635, -53.6138>, <28.7106, 75.8382, -47.3503> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <7.4866, 83.7822, -25.7639>, <8.2919, 83.8856, -26.6647>, 0.08564 }
			cylinder { <8.2919, 83.8856, -26.6647>, <8.9249, 82.9857, -27.1746>, 0.08564 }
			cylinder { <8.9249, 82.9857, -27.1746>, <8.8738, 81.8102, -26.8814>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // inflor. internode
			cylinder { <8.8738, 81.8102, -26.8814>, <8.8568, 81.4183, -26.7836>, 0.08564 }
			cylinder { <8.8568, 81.4183, -26.7836>, <8.8398, 81.0265, -26.6858>, 0.08564 }
			cylinder { <8.8398, 81.0265, -26.6858>, <8.8228, 80.6346, -26.5881>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <8.8228, 80.6346, -26.5881>, <8.7904, 79.8328, -26.49>, 0.08564 }
				cylinder { <8.7904, 79.8328, -26.49>, <8.7601, 79.02494, -26.4909>, 0.08564 }
				cylinder { <8.7601, 79.02494, -26.4909>, <8.7323, 78.2231, -26.5907>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <8.7323, 78.2231, -26.5907>, <9.1621, 76.9451, -28.06274>, <7.6869, 76.9467, -27.6657> }
					triangle { <9.1621, 76.9451, -28.06274>, <9.07688, 75.259, -28.3619>, <7.6869, 76.9467, -27.6657> }
					triangle { <7.6869, 76.9467, -27.6657>, <9.07688, 75.259, -28.3619>, <7.4066, 75.2481, -27.8103> }
					triangle { <7.4066, 75.2481, -27.8103>, <9.07688, 75.259, -28.3619>, <8.5977, 73.8295, -27.2404> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <8.7323, 78.2231, -26.5907>, <10.06975, 76.7475, -26.7276>, <9.2333, 76.9339, -27.9924> }
					triangle { <10.06975, 76.7475, -26.7276>, <10.08682, 75.05354, -26.992>, <9.2333, 76.9339, -27.9924> }
					triangle { <9.2333, 76.9339, -27.9924>, <10.08682, 75.05354, -26.992>, <9.04211, 75.2638, -28.3914> }
					triangle { <9.04211, 75.2638, -28.3914>, <10.08682, 75.05354, -26.992>, <8.6822, 73.8159, -27.1546> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <8.7323, 78.2231, -26.5907>, <9.07406, 76.6226, -25.4477>, <10.02454, 76.7379, -26.6382> }
					triangle { <9.07406, 76.6226, -25.4477>, <9.08941, 74.9153, -25.6045>, <10.02454, 76.7379, -26.6382> }
					triangle { <10.02454, 76.7379, -26.6382>, <9.08941, 74.9153, -25.6045>, <10.1041, 75.05818, -27.03413> }
					triangle { <10.1041, 75.05818, -27.03413>, <9.08941, 74.9153, -25.6045>, <8.6263, 73.8045, -27.04766> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <8.7323, 78.2231, -26.5907>, <7.5418, 76.7419, -25.9798>, <8.9745, 76.6278, -25.4619> }
					triangle { <7.5418, 76.7419, -25.9798>, <7.4537, 75.03408, -26.104>, <8.9745, 76.6278, -25.4619> }
					triangle { <8.9745, 76.6278, -25.4619>, <7.4537, 75.03408, -26.104>, <9.135, 74.9133, -25.6015> }
					triangle { <9.135, 74.9133, -25.6015>, <7.4537, 75.03408, -26.104>, <8.5067, 73.811, -27.06636> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <8.7323, 78.2231, -26.5907>, <7.597, 76.9442, -27.6204>, <7.508, 76.7588, -26.1066> }
					triangle { <7.597, 76.9442, -27.6204>, <7.4458, 75.2497, -27.8339>, <7.508, 76.7588, -26.1066> }
					triangle { <7.508, 76.7588, -26.1066>, <7.4458, 75.2497, -27.8339>, <7.4427, 75.03252, -26.08846> }
					triangle { <7.4427, 75.03252, -26.08846>, <7.4458, 75.2497, -27.8339>, <8.4888, 73.8267, -27.1873> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		union { // inflor. internode
			cylinder { <8.8228, 80.6346, -26.5881>, <8.8058, 80.2428, -26.4903>, 0.08564 }
			cylinder { <8.8058, 80.2428, -26.4903>, <8.7887, 79.8509, -26.3925>, 0.08564 }
			cylinder { <8.7887, 79.8509, -26.3925>, <8.7717, 79.459, -26.2948>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <8.7717, 79.459, -26.2948>, <8.8033, 78.6965, -26.02808>, 0.08564 }
				cylinder { <8.8033, 78.6965, -26.02808>, <8.9001, 77.9667, -25.6941>, 0.08564 }
				cylinder { <8.9001, 77.9667, -25.6941>, <9.06058, 77.2804, -25.2979>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <9.06058, 77.2804, -25.2979>, <9.6826, 76.8961, -23.893>, <10.3354, 76.5043, -24.8361> }
					triangle { <9.6826, 76.8961, -23.893>, <10.01351, 75.7731, -23.2003>, <10.3354, 76.5043, -24.8361> }
					triangle { <10.3354, 76.5043, -24.8361>, <10.01351, 75.7731, -23.2003>, <10.6993, 75.2897, -24.3154> }
					triangle { <10.6993, 75.2897, -24.3154>, <10.01351, 75.7731, -23.2003>, <9.8025, 74.3312, -23.5147> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <9.06058, 77.2804, -25.2979>, <8.4572, 76.5215, -24.0456>, <9.6044, 76.8802, -23.889> }
					triangle { <8.4572, 76.5215, -24.0456>, <8.7102, 75.4014, -23.3164>, <9.6044, 76.8802, -23.889> }
					triangle { <9.6044, 76.8802, -23.889>, <8.7102, 75.4014, -23.3164>, <10.04912, 75.779, -23.2045> }
					triangle { <10.04912, 75.779, -23.2045>, <8.7102, 75.4014, -23.3164>, <9.7085, 74.3113, -23.5111> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <9.06058, 77.2804, -25.2979>, <8.3701, 75.8626, -25.1516>, <8.4369, 76.4794, -24.1103> }
					triangle { <8.3701, 75.8626, -25.1516>, <8.568, 74.7002, -24.4732>, <8.4369, 76.4794, -24.1103> }
					triangle { <8.4369, 76.4794, -24.1103>, <8.568, 74.7002, -24.4732>, <8.7221, 75.4206, -23.2879> }
					triangle { <8.7221, 75.4206, -23.2879>, <8.568, 74.7002, -24.4732>, <9.6853, 74.2606, -23.5894> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <9.06058, 77.2804, -25.2979>, <9.5408, 75.8239, -25.693>, <8.4355, 75.8522, -25.1962> }
					triangle { <9.5408, 75.8239, -25.693>, <9.782, 74.6321, -25.08292>, <8.4355, 75.8522, -25.1962> }
					triangle { <8.4355, 75.8522, -25.1962>, <9.782, 74.6321, -25.08292>, <8.5398, 74.7064, -24.4511> }
					triangle { <8.5398, 74.7064, -24.4511>, <9.782, 74.6321, -25.08292>, <9.7647, 74.2487, -23.6423> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <9.06058, 77.2804, -25.2979>, <10.3642, 76.4722, -24.9034>, <9.6266, 75.8678, -25.6515> }
					triangle { <10.3642, 76.4722, -24.9034>, <10.6888, 75.3052, -24.2843>, <9.6266, 75.8678, -25.6515> }
					triangle { <9.6266, 75.8678, -25.6515>, <10.6888, 75.3052, -24.2843>, <9.7802, 74.6243, -25.09579> }
					triangle { <9.7802, 74.6243, -25.09579>, <10.6888, 75.3052, -24.2843>, <9.8383, 74.293, -23.5954> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		}
	union { // internode
		cylinder { <7.4866, 83.7822, -25.7639>, <8.6551, 89.02468, -28.2056>, 0.8 }
		cylinder { <8.6551, 89.02468, -28.2056>, <9.3929, 94.4812, -30.3248>, 0.8 }
		cylinder { <9.3929, 94.4812, -30.3248>, <9.6931, 100.0995, -32.1012>, 0.8 }
		pigment { color rgb <0.3, 0.58, 0.25> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <9.6931, 100.0995, -32.1012>, <9.4274, 101.2432, -32.1744>, 0.9969 }
			cylinder { <9.4274, 101.2432, -32.1744>, <8.8718, 102.257, -31.9568>, 0.9969 }
			cylinder { <8.8718, 102.257, -31.9568>, <8.1008, 103.0052, -31.4776>, 0.9969 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <8.1008, 103.0052, -31.4776>, <-10.5606, 113.5481, -26.4145>, <-15.3073, 116.0475, -22.4893> }
			triangle { <8.1008, 103.0052, -31.4776>, <-5.889, 110.2723, -29.2483>, <-10.5606, 113.5481, -26.4145> }
			triangle { <8.1008, 103.0052, -31.4776>, <-1.1014, 107.2202, -32.2447>, <-5.889, 110.2723, -29.2483> }
			triangle { <8.1008, 103.0052, -31.4776>, <3.01525, 104.7143, -32.755>, <-1.1014, 107.2202, -32.2447> }
			triangle { <8.1008, 103.0052, -31.4776>, <-15.3073, 116.0475, -22.4893>, <-12.5405, 115.6344, -16.6567> }
			triangle { <-15.3073, 116.0475, -22.4893>, <-22.1373, 113.328, -14.5049>, <-12.5405, 115.6344, -16.6567> }
			triangle { <-12.5405, 115.6344, -16.6567>, <-22.1373, 113.328, -14.5049>, <-22.8908, 114.5389, -11.7166> }
			triangle { <-12.5405, 115.6344, -16.6567>, <-22.8908, 114.5389, -11.7166>, <-26.2518, 105.9771, -1.5486> }
			triangle { <-7.6397, 118.1962, -13.508>, <-2.504, 115.8155, -16.9922>, <8.1008, 103.0052, -31.4776> }
			triangle { <-2.504, 115.8155, -16.9922>, <2.1265, 113.0923, -20.7548>, <8.1008, 103.0052, -31.4776> }
			triangle { <2.1265, 113.0923, -20.7548>, <6.2929, 109.4741, -23.8669>, <8.1008, 103.0052, -31.4776> }
			triangle { <6.2929, 109.4741, -23.8669>, <8.07456, 106.2564, -27.02284>, <8.1008, 103.0052, -31.4776> }
			triangle { <-12.5405, 115.6344, -16.6567>, <-7.6397, 118.1962, -13.508>, <8.1008, 103.0052, -31.4776> }
			triangle { <-12.5405, 115.6344, -16.6567>, <-15.5213, 115.3447, -7.009032>, <-7.6397, 118.1962, -13.508> }
			triangle { <-19.3041, 114.251, -6.2331>, <-15.5213, 115.3447, -7.009032>, <-12.5405, 115.6344, -16.6567> }
			triangle { <-26.2518, 105.9771, -1.5486>, <-19.3041, 114.251, -6.2331>, <-12.5405, 115.6344, -16.6567> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <9.6931, 100.0995, -32.1012>, <8.9902, 101.014, -31.7269>, 0.08564 }
			cylinder { <8.9902, 101.014, -31.7269>, <8.0911, 100.9489, -30.9157>, 0.08564 }
			cylinder { <8.0911, 100.9489, -30.9157>, <7.7227, 99.9566, -30.3237>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // inflor. internode
			cylinder { <7.7227, 99.9566, -30.3237>, <7.6, 99.6259, -30.1264>, 0.08564 }
			cylinder { <7.6, 99.6259, -30.1264>, <7.4772, 99.2952, -29.929>, 0.08564 }
			cylinder { <7.4772, 99.2952, -29.929>, <7.3544, 98.9644, -29.7317>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.3544, 98.9644, -29.7317>, <7.1027, 98.3607, -29.2566>, 0.08564 }
				cylinder { <7.1027, 98.3607, -29.2566>, <6.8485, 97.8237, -28.7083>, 0.08564 }
				cylinder { <6.8485, 97.8237, -28.7083>, <6.5957, 97.3616, -28.09508>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <6.5957, 97.3616, -28.09508>, <5.7709, 97.6788, -26.3051>, <7.1466, 97.01804, -26.236> }
					triangle { <5.7709, 97.6788, -26.3051>, <5.2661, 96.7634, -24.946>, <7.1466, 97.01804, -26.236> }
					triangle { <7.1466, 97.01804, -26.236>, <5.2661, 96.7634, -24.946>, <6.8174, 95.9344, -24.9312> }
					triangle { <6.8174, 95.9344, -24.9312>, <5.2661, 96.7634, -24.946>, <5.1959, 94.9067, -24.666> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <6.5957, 97.3616, -28.09508>, <4.8292, 96.8357, -27.3285>, <5.6992, 97.6399, -26.364> }
					triangle { <4.8292, 96.8357, -27.3285>, <4.2251, 95.9168, -26.01309>, <5.6992, 97.6399, -26.364> }
					triangle { <5.6992, 97.6399, -26.364>, <4.2251, 95.9168, -26.01309>, <5.3008, 96.7785, -24.9203> }
					triangle { <5.3008, 96.7785, -24.9203>, <4.2251, 95.9168, -26.01309>, <5.1105, 94.8587, -24.7374> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <6.5957, 97.3616, -28.09508>, <5.6965, 95.589, -27.9104>, <4.8667, 96.7543, -27.3744> }
					triangle { <5.6965, 95.589, -27.9104>, <5.08761, 94.5845, -26.6614>, <4.8667, 96.7543, -27.3744> }
					triangle { <4.8667, 96.7543, -27.3744>, <5.08761, 94.5845, -26.6614>, <4.2111, 95.9542, -25.9906> }
					triangle { <4.2111, 95.9542, -25.9906>, <5.08761, 94.5845, -26.6614>, <5.1571, 94.7609, -24.7919> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <6.5957, 97.3616, -28.09508>, <7.1824, 95.6499, -27.252>, <5.7918, 95.5768, -27.8803> }
					triangle { <7.1824, 95.6499, -27.252>, <6.6696, 94.5954, -26.00112>, <5.7918, 95.5768, -27.8803> }
					triangle { <5.7918, 95.5768, -27.8803>, <6.6696, 94.5954, -26.00112>, <5.0441, 94.5929, -26.673> }
					triangle { <5.0441, 94.5929, -26.673>, <6.6696, 94.5954, -26.00112>, <5.2717, 94.7476, -24.7547> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <6.5957, 97.3616, -28.09508>, <7.2291, 96.961, -26.2449>, <7.2222, 95.7423, -27.1661> }
					triangle { <7.2291, 96.961, -26.2449>, <6.7816, 95.9624, -24.9249>, <7.2222, 95.7423, -27.1661> }
					triangle { <7.2222, 95.7423, -27.1661>, <6.7816, 95.9624, -24.9249>, <6.6791, 94.5805, -26.00844> }
					triangle { <6.6791, 94.5805, -26.00844>, <6.7816, 95.9624, -24.9249>, <5.2961, 94.8391, -24.6757> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		union { // inflor. internode
			cylinder { <7.3544, 98.9644, -29.7317>, <7.2316, 98.6337, -29.5344>, 0.08564 }
			cylinder { <7.2316, 98.6337, -29.5344>, <7.1089, 98.303, -29.337>, 0.08564 }
			cylinder { <7.1089, 98.303, -29.337>, <6.9861, 97.9723, -29.1397>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <6.9861, 97.9723, -29.1397>, <6.6853, 97.2911, -28.8249>, 0.08564 }
				cylinder { <6.6853, 97.2911, -28.8249>, <6.3337, 96.6004, -28.5948>, 0.08564 }
				cylinder { <6.3337, 96.6004, -28.5948>, <5.9367, 95.9106, -28.4528>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <5.9367, 95.9106, -28.4528>, <5.1959, 94.8219, -29.3328>, <4.4633, 95.4024, -28.5612> }
					triangle { <5.1959, 94.8219, -29.3328>, <4.4815, 93.6791, -29.1479>, <4.4633, 95.4024, -28.5612> }
					triangle { <4.4633, 95.4024, -28.5612>, <4.4815, 93.6791, -29.1479>, <3.6888, 94.3302, -28.2016> }
					triangle { <3.6888, 94.3302, -28.2016>, <4.4815, 93.6791, -29.1479>, <4.18, 92.9023, -27.9117> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <5.9367, 95.9106, -28.4528>, <6.2152, 94.3688, -28.6842>, <5.2635, 94.7885, -29.3064> }
					triangle { <6.2152, 94.3688, -28.6842>, <5.5741, 93.1819, -28.5084>, <5.2635, 94.7885, -29.3064> }
					triangle { <5.2635, 94.7885, -29.3064>, <5.5741, 93.1819, -28.5084>, <4.4502, 93.6952, -29.1573> }
					triangle { <4.4502, 93.6952, -29.1573>, <5.5741, 93.1819, -28.5084>, <4.2611, 92.8625, -27.8787> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <5.9367, 95.9106, -28.4528>, <6.0851, 94.6991, -27.4436>, <6.2206, 94.3819, -28.6055> }
					triangle { <6.0851, 94.6991, -27.4436>, <5.4816, 93.5064, -27.1907>, <6.2206, 94.3819, -28.6055> }
					triangle { <6.2206, 94.3819, -28.6055>, <5.4816, 93.5064, -27.1907>, <5.5692, 93.1774, -28.5441> }
					triangle { <5.5692, 93.1774, -28.5441>, <5.4816, 93.5064, -27.1907>, <4.2664, 92.8789, -27.784> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <5.9367, 95.9106, -28.4528>, <4.9841, 95.3595, -27.3139>, <6.0209, 94.7407, -27.4207> }
					triangle { <4.9841, 95.3595, -27.3139>, <4.331, 94.2072, -27.00363>, <6.0209, 94.7407, -27.4207> }
					triangle { <6.0209, 94.7407, -27.4207>, <4.331, 94.2072, -27.00363>, <5.5098, 93.4875, -27.2037> }
					triangle { <5.5098, 93.4875, -27.2037>, <4.331, 94.2072, -27.00363>, <4.1887, 92.929, -27.7577> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <5.9367, 95.9106, -28.4528>, <4.4263, 95.4365, -28.4992>, <4.9184, 95.381, -27.3929> }
					triangle { <4.4263, 95.4365, -28.4992>, <3.7035, 94.3156, -28.2315>, <4.9184, 95.381, -27.3929> }
					triangle { <4.9184, 95.381, -27.3929>, <3.7035, 94.3156, -28.2315>, <4.3301, 94.2107, -26.9889> }
					triangle { <4.3301, 94.2107, -26.9889>, <3.7035, 94.3156, -28.2315>, <4.1345, 92.9438, -27.8378> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		}
	union { // internode
		cylinder { <9.6931, 100.0995, -32.1012>, <10.4735, 105.5711, -34.1658>, 0.8 }
		cylinder { <10.4735, 105.5711, -34.1658>, <11.7268, 110.8434, -36.4986>, 0.8 }
		cylinder { <11.7268, 110.8434, -36.4986>, <13.4408, 115.8656, -39.07732>, 0.8 }
		pigment { color rgb <0.3, 0.58, 0.25> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <13.4408, 115.8656, -39.07732>, <14.07433, 116.5803, -39.7112>, 0.9714 }
			cylinder { <14.07433, 116.5803, -39.7112>, <14.9233, 116.9382, -40.3931>, 0.9714 }
			cylinder { <14.9233, 116.9382, -40.3931>, <15.8741, 116.8913, -41.03161>, 0.9714 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <15.8741, 116.8913, -41.03161>, <36.4162, 115.4418, -47.06722>, <41.5356, 113.1331, -50.2937> }
			triangle { <15.8741, 116.8913, -41.03161>, <31.08266, 116.4809, -44.06629>, <36.4162, 115.4418, -47.06722> }
			triangle { <15.8741, 116.8913, -41.03161>, <25.7221, 117.8046, -41.1264>, <31.08266, 116.4809, -44.06629> }
			triangle { <15.8741, 116.8913, -41.03161>, <21.1192, 117.5898, -40.0939>, <25.7221, 117.8046, -41.1264> }
			triangle { <15.8741, 116.8913, -41.03161>, <41.5356, 113.1331, -50.2937>, <38.7738, 109.5309, -54.6669> }
			triangle { <41.5356, 113.1331, -50.2937>, <46.7111, 104.1599, -52.4227>, <38.7738, 109.5309, -54.6669> }
			triangle { <38.7738, 109.5309, -54.6669>, <46.7111, 104.1599, -52.4227>, <47.7656, 102.8165, -54.9517> }
			triangle { <38.7738, 109.5309, -54.6669>, <47.7656, 102.8165, -54.9517>, <47.7479, 89.4713, -55.5724> }
			triangle { <35.1223, 110.2212, -59.6304>, <29.6808, 112.3986, -56.8738>, <15.8741, 116.8913, -41.03161> }
			triangle { <29.6808, 112.3986, -56.8738>, <24.5884, 114.4227, -53.5862>, <15.8741, 116.8913, -41.03161> }
			triangle { <24.5884, 114.4227, -53.5862>, <19.6038, 115.3086, -50.05434>, <15.8741, 116.8913, -41.03161> }
			triangle { <19.6038, 115.3086, -50.05434>, <16.933, 115.882, -46.2024>, <15.8741, 116.8913, -41.03161> }
			triangle { <38.7738, 109.5309, -54.6669>, <35.1223, 110.2212, -59.6304>, <15.8741, 116.8913, -41.03161> }
			triangle { <38.7738, 109.5309, -54.6669>, <41.2368, 101.9267, -60.4109>, <35.1223, 110.2212, -59.6304> }
			triangle { <44.3039, 99.7416, -59.3563>, <41.2368, 101.9267, -60.4109>, <38.7738, 109.5309, -54.6669> }
			triangle { <47.7479, 89.4713, -55.5724>, <44.3039, 99.7416, -59.3563>, <38.7738, 109.5309, -54.6669> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <13.4408, 115.8656, -39.07732>, <14.4128, 116.0186, -39.7861>, 0.08564 }
			cylinder { <14.4128, 116.0186, -39.7861>, <15.2185, 115.1686, -40.1006>, 0.08564 }
			cylinder { <15.2185, 115.1686, -40.1006>, <15.2064, 114.0029, -39.7665>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // inflor. internode
			cylinder { <15.2064, 114.0029, -39.7665>, <15.2024, 113.6144, -39.6551>, 0.08564 }
			cylinder { <15.2024, 113.6144, -39.6551>, <15.1984, 113.2258, -39.5437>, 0.08564 }
			cylinder { <15.1984, 113.2258, -39.5437>, <15.1944, 112.8372, -39.4323>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <15.1944, 112.8372, -39.4323>, <15.211, 112.0393, -39.3033>, 0.08564 }
				cylinder { <15.211, 112.0393, -39.3033>, <15.252, 111.2326, -39.27>, 0.08564 }
				cylinder { <15.252, 111.2326, -39.27>, <15.3168, 110.4292, -39.3329>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <15.3168, 110.4292, -39.3329>, <16.1701, 109.1545, -40.6104>, <14.6492, 109.0266, -40.5432> }
					triangle { <16.1701, 109.1545, -40.6104>, <16.2999, 107.4597, -40.8355>, <14.6492, 109.0266, -40.5432> }
					triangle { <14.6492, 109.0266, -40.5432>, <16.2999, 107.4597, -40.8355>, <14.5566, 107.3054, -40.6592> }
					triangle { <14.5566, 107.3054, -40.6592>, <16.2999, 107.4597, -40.8355>, <15.7114, 106.0254, -39.7739> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <15.3168, 110.4292, -39.3329>, <16.7746, 109.0852, -39.1021>, <16.2247, 109.1523, -40.5258> }
					triangle { <16.7746, 109.0852, -39.1021>, <16.9968, 107.3934, -39.2706>, <16.2247, 109.1523, -40.5258> }
					triangle { <16.2247, 109.1523, -40.5258>, <16.9968, 107.3934, -39.2706>, <16.2721, 107.4604, -40.872> }
					triangle { <16.2721, 107.4604, -40.872>, <16.9968, 107.3934, -39.2706>, <15.7757, 106.0225, -39.6712> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <15.3168, 110.4292, -39.3329>, <15.5359, 108.904, -38.06387>, <16.7118, 109.0741, -39.02423> }
					triangle { <15.5359, 108.904, -38.06387>, <15.7338, 107.2021, -38.1272>, <16.7118, 109.0741, -39.02423> }
					triangle { <16.7118, 109.0741, -39.02423>, <15.7338, 107.2021, -38.1272>, <17.02258, 107.3985, -39.3082> }
					triangle { <17.02258, 107.3985, -39.3082>, <15.7338, 107.2021, -38.1272>, <15.6988, 106.0091, -39.5785> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <15.3168, 110.4292, -39.3329>, <14.1543, 108.8597, -38.9207>, <15.4419, 108.8993, -38.09956> }
					triangle { <14.1543, 108.8597, -38.9207>, <14.2446, 107.1483, -38.9747>, <15.4419, 108.8993, -38.09956> }
					triangle { <15.4419, 108.8993, -38.09956>, <14.2446, 107.1483, -38.9747>, <15.7777, 107.2046, -38.1143> }
					triangle { <15.7777, 107.2046, -38.1143>, <14.2446, 107.1483, -38.9747>, <15.5862, 106.0035, -39.623> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <15.3168, 110.4292, -39.3329>, <14.5521, 109.0168, -40.5183>, <14.1479, 108.8695, -39.05252> }
					triangle { <14.5521, 109.0168, -40.5183>, <14.5997, 107.31, -40.6739>, <14.1479, 108.8695, -39.05252> }
					triangle { <14.1479, 108.8695, -39.05252>, <14.5997, 107.31, -40.6739>, <14.2307, 107.1462, -38.9619> }
					triangle { <14.2307, 107.1462, -38.9619>, <14.5997, 107.31, -40.6739>, <15.5941, 106.0137, -39.7456> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		union { // inflor. internode
			cylinder { <15.1944, 112.8372, -39.4323>, <15.1904, 112.4487, -39.321>, 0.08564 }
			cylinder { <15.1904, 112.4487, -39.321>, <15.1864, 112.0601, -39.2096>, 0.08564 }
			cylinder { <15.1864, 112.0601, -39.2096>, <15.1823, 111.6716, -39.09824>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <15.1823, 111.6716, -39.09824>, <15.2205, 110.924, -38.7928>, 0.08564 }
				cylinder { <15.2205, 110.924, -38.7928>, <15.3043, 110.2172, -38.4095>, 0.08564 }
				cylinder { <15.3043, 110.2172, -38.4095>, <15.4325, 109.5617, -37.9538>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <15.4325, 109.5617, -37.9538>, <15.7605, 109.2814, -36.43>, <16.6367, 108.9258, -37.1881> }
					triangle { <15.7605, 109.2814, -36.43>, <16.02687, 108.2167, -35.6262>, <16.6367, 108.9258, -37.1881> }
					triangle { <16.6367, 108.9258, -37.1881>, <16.02687, 108.2167, -35.6262>, <16.9811, 107.7679, -36.5403> }
					triangle { <16.9811, 107.7679, -36.5403>, <16.02687, 108.2167, -35.6262>, <16.01666, 106.7523, -35.9058> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <15.4325, 109.5617, -37.9538>, <14.6362, 108.7866, -36.8254>, <15.685, 109.2581, -36.4422> }
					triangle { <14.6362, 108.7866, -36.8254>, <14.8187, 107.7183, -36.00322>, <15.685, 109.2581, -36.4422> }
					triangle { <15.685, 109.2581, -36.4422>, <14.8187, 107.7183, -36.00322>, <16.06189, 108.2258, -35.6229> }
					triangle { <16.06189, 108.2258, -35.6229>, <14.8187, 107.7183, -36.00322>, <15.9262, 106.7236, -35.9216> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <15.4325, 109.5617, -37.9538>, <14.8528, 108.0893, -37.8894>, <14.6345, 108.7408, -36.8908> }
					triangle { <14.8528, 108.0893, -37.8894>, <14.9966, 106.9722, -37.1265>, <14.6345, 108.7408, -36.8908> }
					triangle { <14.6345, 108.7408, -36.8908>, <14.9966, 106.9722, -37.1265>, <14.8222, 107.7394, -35.9738> }
					triangle { <14.8222, 107.7394, -35.9738>, <14.9966, 106.9722, -37.1265>, <15.9253, 106.6686, -36.00056> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <15.4325, 109.5617, -37.9538>, <16.1129, 108.1467, -38.1614>, <14.9271, 108.0838, -37.9182> }
					triangle { <16.1129, 108.1467, -38.1614>, <16.3163, 107.0025, -37.4542>, <14.9271, 108.0838, -37.9182> }
					triangle { <14.9271, 108.0838, -37.9182>, <16.3163, 107.0025, -37.4542>, <14.9638, 106.9763, -37.1114> }
					triangle { <14.9638, 106.9763, -37.1114>, <16.3163, 107.0025, -37.4542>, <16.01527, 106.6628, -36.03425> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <15.4325, 109.5617, -37.9538>, <16.6823, 108.8945, -37.2458>, <16.1833, 108.1999, -38.1047> }
					triangle { <16.6823, 108.8945, -37.2458>, <16.9627, 107.7832, -36.513>, <16.1833, 108.1999, -38.1047> }
					triangle { <16.1833, 108.1999, -38.1047>, <16.9627, 107.7832, -36.513>, <16.3181, 106.9942, -37.4668> }
					triangle { <16.3181, 106.9942, -37.4668>, <16.9627, 107.7832, -36.513>, <16.07254, 106.7153, -35.9748> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		}
	union { // internode
		cylinder { <13.4408, 115.8656, -39.07732>, <15.03216, 120.9505, -41.6114>, 0.8 }
		cylinder { <15.03216, 120.9505, -41.6114>, <16.4997, 126.095, -44.09954>, 0.8 }
		cylinder { <16.4997, 126.095, -44.09954>, <17.8428, 131.2959, -46.54>, 0.8 }
		pigment { color rgb <0.3, 0.58, 0.25> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <17.8428, 131.2959, -46.54>, <17.7527, 132.1755, -46.7839>, 0.7773 }
			cylinder { <17.7527, 132.1755, -46.7839>, <17.3758, 133.0083, -46.8596>, 0.7773 }
			cylinder { <17.3758, 133.0083, -46.8596>, <16.7626, 133.6826, -46.757>, 0.7773 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <16.7626, 133.6826, -46.757>, <2.6338, 143.3291, -48.2352>, <-1.5126, 145.996, -46.6369> }
			triangle { <16.7626, 133.6826, -46.757>, <6.4379, 140.2166, -48.9512>, <2.6338, 143.3291, -48.2352> }
			triangle { <16.7626, 133.6826, -46.757>, <10.3804, 137.2483, -49.7887>, <6.4379, 140.2166, -48.9512> }
			triangle { <16.7626, 133.6826, -46.757>, <13.3587, 135.0634, -48.9925>, <10.3804, 137.2483, -49.7887> }
			triangle { <16.7626, 133.6826, -46.757>, <-1.5126, 145.996, -46.6369>, <-0.6662, 146.3287, -41.6759> }
			triangle { <-1.5126, 145.996, -46.6369>, <-8.473, 145.3043, -41.8742>, <-0.6662, 146.3287, -41.6759> }
			triangle { <-0.6662, 146.3287, -41.6759>, <-8.473, 145.3043, -41.8742>, <-9.5061, 146.6416, -40.1115> }
			triangle { <-0.6662, 146.3287, -41.6759>, <-9.5061, 146.6416, -40.1115>, <-14.7955, 141.5984, -32.3097> }
			triangle { <2.5676, 148.4815, -38.5897>, <6.925, 145.946, -39.7917>, <16.7626, 133.6826, -46.757> }
			triangle { <6.925, 145.946, -39.7917>, <10.9332, 143.1348, -41.2685>, <16.7626, 133.6826, -46.757> }
			triangle { <10.9332, 143.1348, -41.2685>, <14.3881, 139.7465, -42.2593>, <16.7626, 133.6826, -46.757> }
			triangle { <14.3881, 139.7465, -42.2593>, <16.1008, 136.7727, -43.8408>, <16.7626, 133.6826, -46.757> }
			triangle { <-0.6662, 146.3287, -41.6759>, <2.5676, 148.4815, -38.5897>, <16.7626, 133.6826, -46.757> }
			triangle { <-0.6662, 146.3287, -41.6759>, <-4.8872, 147.5395, -35.1374>, <2.5676, 148.4815, -38.5897> }
			triangle { <-7.9649, 146.9846, -35.2477>, <-4.8872, 147.5395, -35.1374>, <-0.6662, 146.3287, -41.6759> }
			triangle { <-14.7955, 141.5984, -32.3097>, <-7.9649, 146.9846, -35.2477>, <-0.6662, 146.3287, -41.6759> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <17.8428, 131.2959, -46.54>, <17.1666, 132.3022, -46.514>, 0.08564 }
			cylinder { <17.1666, 132.3022, -46.514>, <16.08496, 132.4322, -45.9814>, 0.08564 }
			cylinder { <16.08496, 132.4322, -45.9814>, <15.4724, 131.5807, -45.3728>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // inflor. internode
			cylinder { <15.4724, 131.5807, -45.3728>, <15.2682, 131.2968, -45.17>, 0.08564 }
			cylinder { <15.2682, 131.2968, -45.17>, <15.06413, 131.013, -44.9671>, 0.08564 }
			cylinder { <15.06413, 131.013, -44.9671>, <14.8599, 130.7291, -44.7643>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <14.8599, 130.7291, -44.7643>, <14.4307, 130.2324, -44.2925>, 0.08564 }
				cylinder { <14.4307, 130.2324, -44.2925>, <13.9869, 129.814, -43.7618>, 0.08564 }
				cylinder { <13.9869, 129.814, -43.7618>, <13.5354, 129.4803, -43.1801>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <13.5354, 129.4803, -43.1801>, <12.3093, 130.1497, -41.7542>, <13.5416, 129.428, -41.2116> }
					triangle { <12.3093, 130.1497, -41.7542>, <11.3732, 129.5137, -40.4661>, <13.5416, 129.428, -41.2116> }
					triangle { <13.5416, 129.428, -41.2116>, <11.3732, 129.5137, -40.4661>, <12.7706, 128.6067, -39.9018> }
					triangle { <12.7706, 128.6067, -39.9018>, <11.3732, 129.5137, -40.4661>, <11.03761, 127.7404, -39.9432> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <13.5354, 129.4803, -43.1801>, <11.5848, 129.2024, -42.86>, <12.2517, 130.1057, -41.8241> }
					triangle { <11.5848, 129.2024, -42.86>, <10.5645, 128.5614, -41.6401>, <12.2517, 130.1057, -41.8241> }
					triangle { <12.2517, 130.1057, -41.8241>, <10.5645, 128.5614, -41.6401>, <11.4014, 129.5309, -40.4343> }
					triangle { <11.4014, 129.5309, -40.4343>, <10.5645, 128.5614, -41.6401>, <10.9693, 127.6861, -40.02742> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <13.5354, 129.4803, -43.1801>, <12.4381, 127.8238, -42.9884>, <11.6242, 129.1122, -42.8811> }
					triangle { <12.4381, 127.8238, -42.9884>, <11.4216, 127.0877, -41.8203>, <11.6242, 129.1122, -42.8811> }
					triangle { <11.6242, 129.1122, -42.8811>, <11.4216, 127.0877, -41.8203>, <10.5492, 128.6029, -41.6282> }
					triangle { <10.5492, 128.6029, -41.6282>, <11.4216, 127.0877, -41.8203>, <11.01796, 127.5778, -40.0518> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <13.5354, 129.4803, -43.1801>, <13.698, 127.9063, -41.9632>, <12.5204, 127.8112, -42.9318> }
					triangle { <13.698, 127.9063, -41.9632>, <12.768, 127.1154, -40.7593>, <12.5204, 127.8112, -42.9318> }
					triangle { <12.5204, 127.8112, -42.9318>, <12.768, 127.1154, -40.7593>, <11.3838, 127.0965, -41.8445> }
					triangle { <11.3838, 127.0965, -41.8445>, <12.768, 127.1154, -40.7593>, <11.1167, 127.5641, -39.9829> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <13.5354, 129.4803, -43.1801>, <13.6172, 129.3655, -41.1889>, <13.7233, 128.0094, -41.8844> }
					triangle { <13.6172, 129.3655, -41.1889>, <12.7376, 128.6374, -39.9098>, <13.7233, 128.0094, -41.8844> }
					triangle { <13.7233, 128.0094, -41.8844>, <12.7376, 128.6374, -39.9098>, <12.7774, 127.0989, -40.7614> }
					triangle { <12.7774, 127.0989, -40.7614>, <12.7376, 128.6374, -39.9098>, <11.1291, 127.6661, -39.9148> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		union { // inflor. internode
			cylinder { <14.8599, 130.7291, -44.7643>, <14.6557, 130.4453, -44.5614>, 0.08564 }
			cylinder { <14.6557, 130.4453, -44.5614>, <14.4516, 130.1614, -44.3586>, 0.08564 }
			cylinder { <14.4516, 130.1614, -44.3586>, <14.2474, 129.8776, -44.1557>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <14.2474, 129.8776, -44.1557>, <13.8049, 129.2802, -43.8382>, 0.08564 }
				cylinder { <13.8049, 129.2802, -43.8382>, <13.3348, 128.6619, -43.6136>, 0.08564 }
				cylinder { <13.3348, 128.6619, -43.6136>, <12.8443, 128.0323, -43.4854>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <12.8443, 128.0323, -43.4854>, <12.2493, 126.8558, -44.3631>, <11.4055, 127.6037, -43.9182> }
					triangle { <12.2493, 126.8558, -44.3631>, <11.3953, 125.8074, -44.2141>, <11.4055, 127.6037, -43.9182> }
					triangle { <11.4055, 127.6037, -43.9182>, <11.3953, 125.8074, -44.2141>, <10.4557, 126.6583, -43.6303> }
					triangle { <10.4557, 126.6583, -43.6303>, <11.3953, 125.8074, -44.2141>, <10.7011, 125.2742, -43.00733> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <12.8443, 128.0323, -43.4854>, <13.01001, 126.4595, -43.399>, <12.3037, 126.8234, -44.3144> }
					triangle { <13.01001, 126.4595, -43.399>, <12.2241, 125.3618, -43.2319>, <12.3037, 126.8234, -44.3144> }
					triangle { <12.3037, 126.8234, -44.3144>, <12.2241, 125.3618, -43.2319>, <11.3695, 125.8235, -44.234> }
					triangle { <11.3695, 125.8235, -44.234>, <12.2241, 125.3618, -43.2319>, <10.7661, 125.2358, -42.9477> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <12.8443, 128.0323, -43.4854>, <12.5953, 127.0052, -42.3057>, <12.9959, 126.4856, -43.3248> }
					triangle { <12.5953, 127.0052, -42.3057>, <11.8248, 125.9127, -42.05418>, <12.9959, 126.4856, -43.3248> }
					triangle { <12.9959, 126.4856, -43.3248>, <11.8248, 125.9127, -42.05418>, <12.2283, 125.3515, -43.2665> }
					triangle { <12.2283, 125.3515, -43.2665>, <11.8248, 125.9127, -42.05418>, <10.7482, 125.2678, -42.8588> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <12.8443, 128.0323, -43.4854>, <11.5744, 127.7439, -42.5839>, <12.5321, 127.0541, -42.3078> }
					triangle { <11.5744, 127.7439, -42.5839>, <10.7456, 126.7039, -42.2974>, <12.5321, 127.0541, -42.3078> }
					triangle { <12.5321, 127.0541, -42.3078>, <10.7456, 126.7039, -42.2974>, <11.8533, 125.8902, -42.05598> }
					triangle { <11.8533, 125.8902, -42.05598>, <10.7456, 126.7039, -42.2974>, <10.672, 125.3264, -42.8626> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <12.8443, 128.0323, -43.4854>, <11.3574, 127.6501, -43.8746>, <11.5343, 127.7555, -42.6801> }
					triangle { <11.3574, 127.6501, -43.8746>, <10.4761, 126.6379, -43.6524>, <11.5343, 127.7555, -42.6801> }
					triangle { <11.5343, 127.7555, -42.6801>, <10.4761, 126.6379, -43.6524>, <10.7412, 126.71, -42.2842> }
					triangle { <10.7412, 126.71, -42.2842>, <10.4761, 126.6379, -43.6524>, <10.6425, 125.3304, -42.9558> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		}
	union { // internode
		cylinder { <17.8428, 131.2959, -46.54>, <19.5779, 136.3343, -49.07264>, 0.8 }
		cylinder { <19.5779, 136.3343, -49.07264>, <21.6957, 141.1828, -51.6835>, 0.8 }
		cylinder { <21.6957, 141.1828, -51.6835>, <24.1848, 145.8152, -54.3585>, 0.8 }
		pigment { color rgb <0.3, 0.58, 0.25> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <24.1848, 145.8152, -54.3585>, <24.4029, 145.9854, -54.506>, 0.2656 }
			cylinder { <24.4029, 145.9854, -54.506>, <24.6777, 146.0568, -54.6389>, 0.2656 }
			cylinder { <24.6777, 146.0568, -54.6389>, <24.9723, 146.0199, -54.7395>, 0.2656 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <24.9723, 146.0199, -54.7395>, <30.8056, 145.3828, -54.8621>, <32.3564, 144.6342, -55.2779> }
			triangle { <24.9723, 146.0199, -54.7395>, <29.2004, 145.7793, -54.4767>, <30.8056, 145.3828, -54.8621> }
			triangle { <24.9723, 146.0199, -54.7395>, <27.5952, 146.2508, -54.1189>, <29.2004, 145.7793, -54.4767> }
			triangle { <24.9723, 146.0199, -54.7395>, <26.3043, 146.2359, -54.1569>, <27.5952, 146.2508, -54.1189> }
			triangle { <24.9723, 146.0199, -54.7395>, <32.3564, 144.6342, -55.2779>, <31.8853, 143.5044, -56.4918> }
			triangle { <32.3564, 144.6342, -55.2779>, <33.7787, 142.1178, -55.1727>, <31.8853, 143.5044, -56.4918> }
			triangle { <31.8853, 143.5044, -56.4918>, <33.7787, 142.1178, -55.1727>, <34.2159, 141.6615, -55.7179> }
			triangle { <31.8853, 143.5044, -56.4918>, <34.2159, 141.6615, -55.7179>, <34.1158, 138.0208, -55.4235> }
			triangle { <31.2632, 143.5186, -58.06945>, <29.6578, 144.2152, -57.7946>, <24.9723, 146.0199, -54.7395> }
			triangle { <29.6578, 144.2152, -57.7946>, <28.1071, 144.8887, -57.3512>, <24.9723, 146.0199, -54.7395> }
			triangle { <28.1071, 144.8887, -57.3512>, <26.5566, 145.2623, -56.7972>, <24.9723, 146.0199, -54.7395> }
			triangle { <26.5566, 145.2623, -56.7972>, <25.5937, 145.5595, -55.9894>, <24.9723, 146.0199, -54.7395> }
			triangle { <31.8853, 143.5044, -56.4918>, <31.2632, 143.5186, -58.06945>, <24.9723, 146.0199, -54.7395> }
			triangle { <31.8853, 143.5044, -56.4918>, <32.8494, 141.2334, -57.569>, <31.2632, 143.5186, -58.06945> }
			triangle { <33.5671, 140.6745, -57.00635>, <32.8494, 141.2334, -57.569>, <31.8853, 143.5044, -56.4918> }
			triangle { <34.1158, 138.0208, -55.4235>, <33.5671, 140.6745, -57.00635>, <31.8853, 143.5044, -56.4918> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <24.1848, 145.8152, -54.3585>, <25.3075, 145.8691, -54.8138>, 0.08564 }
			cylinder { <25.3075, 145.8691, -54.8138>, <26.1334, 144.9813, -54.8064>, 0.08564 }
			cylinder { <26.1334, 144.9813, -54.8064>, <25.9948, 143.8695, -54.3423>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // inflor. internode
			cylinder { <25.9948, 143.8695, -54.3423>, <25.9486, 143.4989, -54.1876>, 0.08564 }
			cylinder { <25.9486, 143.4989, -54.1876>, <25.9024, 143.1284, -54.03293>, 0.08564 }
			cylinder { <25.9024, 143.1284, -54.03293>, <25.8562, 142.7578, -53.8782>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <25.8562, 142.7578, -53.8782>, <25.8101, 141.9836, -53.6499>, 0.08564 }
				cylinder { <25.8101, 141.9836, -53.6499>, <25.8111, 141.188, -53.5063>, 0.08564 }
				cylinder { <25.8111, 141.188, -53.5063>, <25.8592, 140.383, -53.4495>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <25.8592, 140.383, -53.4495>, <26.9545, 138.9477, -54.3009>, <25.4609, 138.8372, -54.6025> }
					triangle { <26.9545, 138.9477, -54.3009>, <27.07224, 137.2374, -54.2715>, <25.4609, 138.8372, -54.6025> }
					triangle { <25.4609, 138.8372, -54.6025>, <27.07224, 137.2374, -54.2715>, <25.3352, 137.116, -54.5209> }
					triangle { <25.3352, 137.116, -54.5209>, <27.07224, 137.2374, -54.2715>, <26.1847, 135.9575, -53.2203> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <25.8592, 140.383, -53.4495>, <27.1622, 139.0737, -52.6927>, <26.9863, 138.9563, -54.2057> }
					triangle { <27.1622, 139.0737, -52.6927>, <27.3554, 137.3733, -52.5861>, <26.9863, 138.9563, -54.2057> }
					triangle { <26.9863, 138.9563, -54.2057>, <27.3554, 137.3733, -52.5861>, <27.0545, 137.2333, -54.3135> }
					triangle { <27.0545, 137.2333, -54.3135>, <27.3554, 137.3733, -52.5861>, <26.2214, 135.9678, -53.1052> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <25.8592, 140.383, -53.4495>, <25.6984, 139.0363, -51.9848>, <27.08163, 139.0731, -52.6324> }
					triangle { <25.6984, 139.0363, -51.9848>, <25.8416, 137.3397, -51.782>, <27.08163, 139.0731, -52.6324> }
					triangle { <27.08163, 139.0731, -52.6324>, <25.8416, 137.3397, -51.782>, <27.3898, 137.3732, -52.6163> }
					triangle { <27.3898, 137.3732, -52.6163>, <25.8416, 137.3397, -51.782>, <26.1234, 135.967, -53.03386> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <25.8592, 140.383, -53.4495>, <24.5724, 138.8868, -53.1488>, <25.6161, 139.0273, -52.04214> }
					triangle { <24.5724, 138.8868, -53.1488>, <24.6088, 137.1827, -52.963>, <25.6161, 139.0273, -52.04214> }
					triangle { <25.6161, 139.0273, -52.04214>, <24.6088, 137.1827, -52.963>, <25.881, 137.3437, -51.7589> }
					triangle { <25.881, 137.3437, -51.7589>, <24.6088, 137.1827, -52.963>, <26.02531, 135.9561, -53.1041> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <25.8592, 140.383, -53.4495>, <25.3604, 138.8312, -54.6019>, <24.5994, 138.8793, -53.2781> }
					triangle { <25.3604, 138.8312, -54.6019>, <25.3808, 137.1185, -54.5247>, <24.5994, 138.8793, -53.2781> }
					triangle { <24.5994, 138.8793, -53.2781>, <25.3808, 137.1185, -54.5247>, <24.592, 137.1824, -52.9538> }
					triangle { <24.592, 137.1824, -52.9538>, <25.3808, 137.1185, -54.5247>, <26.06376, 135.9502, -53.2211> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		union { // inflor. internode
			cylinder { <25.8562, 142.7578, -53.8782>, <25.81, 142.3872, -53.7235>, 0.08564 }
			cylinder { <25.81, 142.3872, -53.7235>, <25.7638, 142.0166, -53.5688>, 0.08564 }
			cylinder { <25.7638, 142.0166, -53.5688>, <25.7175, 141.6461, -53.4141>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <25.7175, 141.6461, -53.4141>, <25.6504, 140.9448, -53.01754>, 0.08564 }
				cylinder { <25.6504, 140.9448, -53.01754>, <25.6097, 140.2939, -52.5397>, 0.08564 }
				cylinder { <25.6097, 140.2939, -52.5397>, <25.5958, 139.7032, -51.9879>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <25.5958, 139.7032, -51.9879>, <25.524, 139.6234, -50.4077>, <26.5471, 139.1671, -50.8705> }
					triangle { <25.524, 139.6234, -50.4077>, <25.5419, 138.6719, -49.4357>, <26.5471, 139.1671, -50.8705> }
					triangle { <26.5471, 139.1671, -50.8705>, <25.5419, 138.6719, -49.4357>, <26.6758, 138.1025, -50.01683> }
					triangle { <26.6758, 138.1025, -50.01683>, <25.5419, 138.6719, -49.4357>, <25.5464, 137.1836, -49.5226> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <25.5958, 139.7032, -51.9879>, <24.5155, 139.0866, -51.00766>, <25.4531, 139.5991, -50.4355> }
					triangle { <24.5155, 139.0866, -51.00766>, <24.4475, 138.1344, -50.03848>, <25.4531, 139.5991, -50.4355> }
					triangle { <25.4531, 139.5991, -50.4355>, <24.4475, 138.1344, -50.03848>, <25.5754, 138.6812, -49.4249> }
					triangle { <25.5754, 138.6812, -49.4249>, <24.4475, 138.1344, -50.03848>, <25.4617, 137.1536, -49.5569> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <25.5958, 139.7032, -51.9879>, <24.9632, 138.2548, -51.8867>, <24.5283, 139.0326, -51.06513> }
					triangle { <24.9632, 138.2548, -51.8867>, <24.8707, 137.2467, -50.9781>, <24.5283, 139.0326, -51.06513> }
					triangle { <24.5283, 139.0326, -51.06513>, <24.8707, 137.2467, -50.9781>, <24.4444, 138.1592, -50.01205> }
					triangle { <24.4444, 138.1592, -50.01205>, <24.8707, 137.2467, -50.9781>, <25.4784, 137.0887, -49.6259> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <25.5958, 139.7032, -51.9879>, <26.2526, 138.2698, -51.8383>, <25.04211, 138.2453, -51.895> }
					triangle { <26.2526, 138.2698, -51.8383>, <26.2306, 137.2272, -50.9648>, <25.04211, 138.2453, -51.895> }
					triangle { <25.04211, 138.2453, -51.895>, <26.2306, 137.2272, -50.9648>, <24.8353, 137.2529, -50.9723> }
					triangle { <24.8353, 137.2529, -50.9723>, <26.2306, 137.2272, -50.9648>, <25.5735, 137.0781, -49.6349> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <25.5958, 139.7032, -51.9879>, <26.6044, 139.1284, -50.9105>, <26.3086, 138.3297, -51.7729> }
					triangle { <26.6044, 139.1284, -50.9105>, <26.6518, 138.1214, -49.9972>, <26.3086, 138.3297, -51.7729> }
					triangle { <26.3086, 138.3297, -51.7729>, <26.6518, 138.1214, -49.9972>, <26.2352, 137.2173, -50.9753> }
					triangle { <26.2352, 137.2173, -50.9753>, <26.6518, 138.1214, -49.9972>, <25.6162, 137.1376, -49.5701> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		}
	union { // internode
		cylinder { <24.1848, 145.8152, -54.3585>, <26.2872, 150.6447, -57.01674>, 0.8 }
		cylinder { <26.2872, 150.6447, -57.01674>, <27.9916, 155.6452, -59.6435>, 0.8 }
		cylinder { <27.9916, 155.6452, -59.6435>, <29.2887, 160.7895, -62.2249>, 0.8 }
		pigment { color rgb <0.3, 0.58, 0.25> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <29.2887, 160.7895, -62.2249>, <29.2567, 161.0069, -62.3109>, 0.2 }
			cylinder { <29.2567, 161.0069, -62.3109>, <29.1452, 161.2068, -62.3682>, 0.2 }
			cylinder { <29.1452, 161.2068, -62.3682>, <28.969, 161.3625, -62.3891>, 0.2 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <28.969, 161.3625, -62.3891>, <25.2633, 163.3793, -63.7009>, <24.07214, 163.9646, -63.5716> }
			triangle { <28.969, 161.3625, -62.3891>, <26.3332, 162.6856, -63.6156>, <25.2633, 163.3793, -63.7009> }
			triangle { <28.969, 161.3625, -62.3891>, <27.4406, 162.0306, -63.5572>, <26.3332, 162.6856, -63.6156> }
			triangle { <28.969, 161.3625, -62.3891>, <28.1999, 161.5752, -63.1555>, <27.4406, 162.0306, -63.5572> }
			triangle { <28.969, 161.3625, -62.3891>, <24.07214, 163.9646, -63.5716>, <24.01247, 164.1605, -62.2902> }
			triangle { <24.07214, 163.9646, -63.5716>, <22.09354, 163.6652, -62.7136>, <24.01247, 164.1605, -62.2902> }
			triangle { <24.01247, 164.1605, -62.2902>, <22.09354, 163.6652, -62.7136>, <21.7072, 164.0063, -62.3541> }
			triangle { <24.01247, 164.1605, -62.2902>, <21.7072, 164.0063, -62.3541>, <20.09654, 162.6993, -60.5478> }
			triangle { <24.604, 164.8586, -61.4>, <25.8237, 164.3199, -61.4219>, <28.969, 161.3625, -62.3891> }
			triangle { <25.8237, 164.3199, -61.4219>, <26.9774, 163.6958, -61.5243>, <28.969, 161.3625, -62.3891> }
			triangle { <26.9774, 163.6958, -61.5243>, <27.9815, 162.9167, -61.5196>, <28.969, 161.3625, -62.3891> }
			triangle { <27.9815, 162.9167, -61.5196>, <28.57, 162.1815, -61.7614>, <28.969, 161.3625, -62.3891> }
			triangle { <24.01247, 164.1605, -62.2902>, <24.604, 164.8586, -61.4>, <28.969, 161.3625, -62.3891> }
			triangle { <24.01247, 164.1605, -62.2902>, <22.5774, 164.458, -60.8905>, <24.604, 164.8586, -61.4> }
			triangle { <21.8265, 164.2236, -61.06204>, <22.5774, 164.458, -60.8905>, <24.01247, 164.1605, -62.2902> }
			triangle { <20.09654, 162.6993, -60.5478>, <21.8265, 164.2236, -61.06204>, <24.01247, 164.1605, -62.2902> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <29.2887, 160.7895, -62.2249>, <28.5257, 161.711, -62.423>, 0.08564 }
			cylinder { <28.5257, 161.711, -62.423>, <27.35, 161.7514, -62.1285>, 0.08564 }
			cylinder { <27.35, 161.7514, -62.1285>, <26.7123, 160.8782, -61.5795>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // inflor. internode
			cylinder { <26.7123, 160.8782, -61.5795>, <26.4998, 160.5871, -61.3965>, 0.08564 }
			cylinder { <26.4998, 160.5871, -61.3965>, <26.2872, 160.296, -61.2135>, 0.08564 }
			cylinder { <26.2872, 160.296, -61.2135>, <26.07468, 160.005, -61.03059>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <26.07468, 160.005, -61.03059>, <25.6085, 159.4951, -60.6105>, 0.08564 }
				cylinder { <25.6085, 159.4951, -60.6105>, <25.1084, 159.0653, -60.1428>, 0.08564 }
				cylinder { <25.1084, 159.0653, -60.1428>, <24.5819, 158.722, -59.6345>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <24.5819, 158.722, -59.6345>, <23.0281, 159.3407, -58.5448>, <24.1871, 158.8036, -57.707> }
					triangle { <23.0281, 159.3407, -58.5448>, <21.914, 158.6898, -57.4156>, <24.1871, 158.8036, -57.707> }
					triangle { <24.1871, 158.8036, -57.707>, <21.914, 158.6898, -57.4156>, <23.2476, 157.9893, -56.5074> }
					triangle { <23.2476, 157.9893, -56.5074>, <21.914, 158.6898, -57.4156>, <21.6545, 156.9289, -56.8132> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <24.5819, 158.722, -59.6345>, <22.6443, 158.2441, -59.6829>, <22.9908, 159.2858, -58.6204> }
					triangle { <22.6443, 158.2441, -59.6829>, <21.4629, 157.574, -58.6365>, <22.9908, 159.2858, -58.6204> }
					triangle { <22.9908, 159.2858, -58.6204>, <21.4629, 157.574, -58.6365>, <21.9332, 158.7122, -57.3806> }
					triangle { <21.9332, 158.7122, -57.3806>, <21.4629, 157.574, -58.6365>, <21.6108, 156.8616, -56.904> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <24.5819, 158.722, -59.6345>, <23.6377, 156.9671, -59.5164>, <22.696, 158.1578, -59.6877> }
					triangle { <23.6377, 156.9671, -59.5164>, <22.4799, 156.1996, -58.5113>, <22.696, 158.1578, -59.6877> }
					triangle { <22.696, 158.1578, -59.6877>, <22.4799, 156.1996, -58.5113>, <21.4414, 157.6141, -58.6316> }
					triangle { <21.4414, 157.6141, -58.6316>, <22.4799, 156.1996, -58.5113>, <21.6738, 156.7582, -56.9085> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <24.5819, 158.722, -59.6345>, <24.6446, 157.2626, -58.2739>, <23.7074, 156.9679, -59.4437> }
					triangle { <24.6446, 157.2626, -58.2739>, <23.5691, 156.4532, -57.2119>, <23.7074, 156.9679, -59.4437> }
					triangle { <23.7074, 156.9679, -59.4437>, <23.5691, 156.4532, -57.2119>, <22.4473, 156.2024, -58.5433> }
					triangle { <22.4473, 156.2024, -58.5433>, <23.5691, 156.4532, -57.2119>, <21.7572, 156.7607, -56.8205> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <24.5819, 158.722, -59.6345>, <24.2622, 158.7518, -57.6643>, <24.6429, 157.3731, -58.2011> }
					triangle { <24.2622, 158.7518, -57.6643>, <23.2141, 158.0154, -56.5245>, <24.6429, 157.3731, -58.2011> }
					triangle { <24.6429, 157.3731, -58.2011>, <23.2141, 158.0154, -56.5245>, <23.5804, 156.4378, -57.2106> }
					triangle { <23.5804, 156.4378, -57.2106>, <23.2141, 158.0154, -56.5245>, <21.7451, 156.8678, -56.7607> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		union { // inflor. internode
			cylinder { <26.07468, 160.005, -61.03059>, <25.8621, 159.7139, -60.8475>, 0.08564 }
			cylinder { <25.8621, 159.7139, -60.8475>, <25.6495, 159.4228, -60.6645>, 0.08564 }
			cylinder { <25.6495, 159.4228, -60.6645>, <25.437, 159.1317, -60.4815>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <25.437, 159.1317, -60.4815>, <24.9997, 158.5102, -60.2057>, 0.08564 }
				cylinder { <24.9997, 158.5102, -60.2057>, <24.5568, 157.8586, -60.0243>, 0.08564 }
				cylinder { <24.5568, 157.8586, -60.0243>, <24.115, 157.1869, -59.9398>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <24.115, 157.1869, -59.9398>, <23.8329, 155.8934, -60.8092>, <22.846, 156.5678, -60.6086> }
					triangle { <23.8329, 155.8934, -60.8092>, <23.07447, 154.7664, -60.739>, <22.846, 156.5678, -60.6086> }
					triangle { <22.846, 156.5678, -60.6086>, <23.07447, 154.7664, -60.739>, <21.9553, 155.5411, -60.4309> }
					triangle { <21.9553, 155.5411, -60.4309>, <23.07447, 154.7664, -60.739>, <22.2024, 154.2395, -59.6506> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <24.115, 157.1869, -59.9398>, <24.4138, 155.653, -59.6823>, <23.8791, 155.8708, -60.748> }
					triangle { <24.4138, 155.653, -59.6823>, <23.7227, 154.4861, -59.5766>, <23.8791, 155.8708, -60.748> }
					triangle { <23.8791, 155.8708, -60.748>, <23.7227, 154.4861, -59.5766>, <23.05186, 154.778, -60.7649> }
					triangle { <23.05186, 154.778, -60.7649>, <23.7227, 154.4861, -59.5766>, <22.2571, 154.2129, -59.5761> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <24.115, 157.1869, -59.9398>, <23.7308, 156.22, -58.7458>, <24.3823, 155.6822, -59.615> }
					triangle { <23.7308, 156.22, -58.7458>, <23.0368, 155.0656, -58.555>, <24.3823, 155.6822, -59.615> }
					triangle { <24.3823, 155.6822, -59.615>, <23.0368, 155.0656, -58.555>, <23.735, 154.474, -59.6086> }
					triangle { <23.735, 154.474, -59.6086>, <23.0368, 155.0656, -58.555>, <22.2182, 154.2486, -59.4957> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <24.115, 157.1869, -59.9398>, <22.7214, 156.816, -59.2851>, <23.6649, 156.2609, -58.7647> }
					triangle { <22.7214, 156.816, -59.2851>, <21.9581, 155.7095, -59.07651>, <23.6649, 156.2609, -58.7647> }
					triangle { <23.6649, 156.2609, -58.7647>, <21.9581, 155.7095, -59.07651>, <23.0671, 155.0464, -58.5491> }
					triangle { <23.0671, 155.0464, -58.5491>, <21.9581, 155.7095, -59.07651>, <22.1391, 154.2977, -59.5198> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <24.115, 157.1869, -59.9398>, <22.7855, 156.6112, -60.5796>, <22.701, 156.8165, -59.388> }
					triangle { <22.7855, 156.6112, -60.5796>, <21.9817, 155.5218, -60.4466>, <22.701, 156.8165, -59.388> }
					triangle { <22.701, 156.8165, -59.388>, <21.9817, 155.5218, -60.4466>, <21.9505, 155.7159, -59.06503> }
					triangle { <21.9505, 155.7159, -59.06503>, <21.9817, 155.5218, -60.4466>, <22.1291, 154.292, -59.6169> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		}
	union { // internode
		cylinder { <29.2887, 160.7895, -62.2249>, <31.41, 165.662, -64.7878>, 0.8 }
		cylinder { <31.41, 165.662, -64.7878>, <34.3096, 170.1572, -67.2769>, 0.8 }
		cylinder { <34.3096, 170.1572, -67.2769>, <37.9247, 174.1778, -69.6383>, 0.8 }
		pigment { color rgb <0.3, 0.58, 0.25> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <37.9247, 174.1778, -69.6383>, <38.126, 174.277, -69.7114>, 0.2 }
			cylinder { <38.126, 174.277, -69.7114>, <38.3569, 174.3013, -69.7533>, 0.2 }
			cylinder { <38.3569, 174.3013, -69.7533>, <38.5866, 174.2474, -69.7584>, 0.2 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <38.5866, 174.2474, -69.7584>, <42.7547, 173.4486, -68.5298>, <43.8951, 172.765, -68.4273> }
			triangle { <38.5866, 174.2474, -69.7584>, <41.5528, 173.8701, -68.6353>, <42.7547, 173.4486, -68.5298> }
			triangle { <38.5866, 174.2474, -69.7584>, <40.3627, 174.3445, -68.767>, <41.5528, 173.8701, -68.6353> }
			triangle { <38.5866, 174.2474, -69.7584>, <39.4412, 174.3984, -69.07208>, <40.3627, 174.3445, -68.767> }
			triangle { <38.5866, 174.2474, -69.7584>, <43.8951, 172.765, -68.4273>, <43.7162, 171.8217, -69.3004> }
			triangle { <43.8951, 172.765, -68.4273>, <44.6913, 170.8295, -67.8267>, <43.7162, 171.8217, -69.3004> }
			triangle { <43.7162, 171.8217, -69.3004>, <44.6913, 170.8295, -67.8267>, <45.08163, 170.4091, -68.08298> }
			triangle { <43.7162, 171.8217, -69.3004>, <45.08163, 170.4091, -68.08298>, <44.6524, 167.7394, -67.5788> }
			triangle { <43.5971, 171.6983, -70.5654>, <42.4424, 172.3311, -70.7761>, <38.5866, 174.2474, -69.7584> }
			triangle { <42.4424, 172.3311, -70.7761>, <41.2902, 172.9619, -70.8523>, <38.5866, 174.2474, -69.7584> }
			triangle { <41.2902, 172.9619, -70.8523>, <40.09091, 173.3813, -70.8233>, <38.5866, 174.2474, -69.7584> }
			triangle { <40.09091, 173.3813, -70.8233>, <39.2551, 173.7394, -70.4789>, <38.5866, 174.2474, -69.7584> }
			triangle { <43.7162, 171.8217, -69.3004>, <43.5971, 171.6983, -70.5654>, <38.5866, 174.2474, -69.7584> }
			triangle { <43.7162, 171.8217, -69.3004>, <44.448, 169.9677, -69.6665>, <43.5971, 171.6983, -70.5654> }
			triangle { <44.802, 169.5736, -69.06017>, <44.448, 169.9677, -69.6665>, <43.7162, 171.8217, -69.3004> }
			triangle { <44.6524, 167.7394, -67.5788>, <44.802, 169.5736, -69.06017>, <43.7162, 171.8217, -69.3004> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <37.9247, 174.1778, -69.6383>, <39.1283, 174.0871, -69.7549>, 0.08564 }
			cylinder { <39.1283, 174.0871, -69.7549>, <39.8193, 173.1526, -69.4086>, 0.08564 }
			cylinder { <39.8193, 173.1526, -69.4086>, <39.4389, 172.1301, -68.8793>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // inflor. internode
			cylinder { <39.4389, 172.1301, -68.8793>, <39.3121, 171.7892, -68.7028>, 0.08564 }
			cylinder { <39.3121, 171.7892, -68.7028>, <39.1853, 171.4483, -68.5264>, 0.08564 }
			cylinder { <39.1853, 171.4483, -68.5264>, <39.05851, 171.1075, -68.3499>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <39.05851, 171.1075, -68.3499>, <38.8679, 170.3784, -68.05717>, 0.08564 }
				cylinder { <38.8679, 170.3784, -68.05717>, <38.7434, 169.6129, -67.8288>, 0.08564 }
				cylinder { <38.7434, 169.6129, -67.8288>, <38.6866, 168.8226, -67.6684>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <38.6866, 168.8226, -67.6684>, <39.8123, 167.2074, -67.9984>, <38.4568, 167.162, -68.7016> }
					triangle { <39.8123, 167.2074, -67.9984>, <39.7318, 165.5143, -67.74>, <38.4568, 167.162, -68.7016> }
					triangle { <38.4568, 167.162, -68.7016>, <39.7318, 165.5143, -67.74>, <38.1282, 165.4829, -68.4622> }
					triangle { <38.1282, 165.4829, -68.4622>, <39.7318, 165.5143, -67.74>, <38.4561, 164.4616, -66.8482> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <38.6866, 168.8226, -67.6684>, <39.5813, 167.5436, -66.424>, <39.8173, 167.2271, -67.8998> }
					triangle { <39.5813, 167.5436, -66.424>, <39.5527, 165.8658, -66.07172>, <39.8173, 167.2271, -67.8998> }
					triangle { <39.8173, 167.2271, -67.8998>, <39.5527, 165.8658, -66.07172>, <39.726, 165.5057, -67.7847> }
					triangle { <39.726, 165.5057, -67.7847>, <39.5527, 165.8658, -66.07172>, <38.4606, 164.4854, -66.7294> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <38.6866, 168.8226, -67.6684>, <37.984, 167.7104, -66.167>, <39.4876, 167.5573, -66.3897> }
					triangle { <37.984, 167.7104, -66.167>, <37.8816, 166.0535, -65.738>, <39.4876, 167.5573, -66.3897> }
					triangle { <39.4876, 167.5573, -66.3897>, <37.8816, 166.0535, -65.738>, <39.5939, 165.859, -66.09052> }
					triangle { <39.5939, 165.859, -66.09052>, <37.8816, 166.0535, -65.738>, <38.3473, 164.5016, -66.6896> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <38.6866, 168.8226, -67.6684>, <37.2129, 167.479, -67.5801>, <37.9202, 167.6994, -66.2441> }
					triangle { <37.2129, 167.479, -67.5801>, <37.01236, 165.8198, -67.197>, <37.9202, 167.6994, -66.2441> }
					triangle { <37.9202, 167.6994, -66.2441>, <37.01236, 165.8198, -67.197>, <37.9133, 166.0579, -65.7052> }
					triangle { <37.9133, 166.0579, -65.7052>, <37.01236, 165.8198, -67.197>, <38.2717, 164.488, -66.7834> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <38.6866, 168.8226, -67.6684>, <38.3599, 167.1634, -68.7291>, <37.2735, 167.4514, -67.6945> }
					triangle { <38.3599, 167.1634, -68.7291>, <38.173, 165.4815, -68.453>, <37.2735, 167.4514, -67.6945> }
					triangle { <37.2735, 167.4514, -67.6945>, <38.173, 165.4815, -68.453>, <36.9937, 165.8219, -67.1931> }
					triangle { <36.9937, 165.8219, -67.1931>, <38.173, 165.4815, -68.453>, <38.34, 164.4629, -66.8829> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		union { // inflor. internode
			cylinder { <39.05851, 171.1075, -68.3499>, <38.9317, 170.7666, -68.1735>, 0.08564 }
			cylinder { <38.9317, 170.7666, -68.1735>, <38.8049, 170.4257, -67.9971>, 0.08564 }
			cylinder { <38.8049, 170.4257, -67.9971>, <38.6781, 170.0849, -67.8206>, 0.08564 }
			pigment { color rgb <0.0, 0.76, 0.25> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <38.6781, 170.0849, -67.8206>, <38.4289, 169.453, -67.3822>, 0.08564 }
				cylinder { <38.4289, 169.453, -67.3822>, <38.188, 168.8805, -66.8647>, 0.08564 }
				cylinder { <38.188, 168.8805, -66.8647>, <37.959, 168.3759, -66.276>, 0.08564 }
				pigment { color rgb <0.44, 0.82, 0.19> }}
			union { // fruit
				mesh { // fruit section
					triangle { <37.959, 168.3759, -66.276>, <37.4464, 168.5247, -64.7849>, <38.5019, 167.9363, -64.8786> }
					triangle { <37.4464, 168.5247, -64.7849>, <37.09301, 167.7208, -63.746>, <38.5019, 167.9363, -64.8786> }
					triangle { <38.5019, 167.9363, -64.8786>, <37.09301, 167.7208, -63.746>, <38.2746, 166.996, -63.9074> }
					triangle { <38.2746, 166.996, -63.9074>, <37.09301, 167.7208, -63.746>, <36.9603, 166.2386, -63.6563> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <37.959, 168.3759, -66.276>, <36.5903, 167.9819, -65.5833>, <37.3838, 168.5019, -64.8289> }
					triangle { <36.5903, 167.9819, -65.5833>, <36.1555, 167.183, -64.5717>, <37.3838, 168.5019, -64.8289> }
					triangle { <37.3838, 168.5019, -64.8289>, <36.1555, 167.183, -64.5717>, <37.1229, 167.7292, -63.7272> }
					triangle { <37.1229, 167.7292, -63.7272>, <36.1555, 167.183, -64.5717>, <36.8856, 166.2101, -63.7098> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <37.959, 168.3759, -66.276>, <37.1702, 167.0049, -66.195>, <36.6125, 167.9196, -65.6281> }
					triangle { <37.1702, 167.0049, -66.195>, <36.7226, 166.1439, -65.2417>, <36.6125, 167.9196, -65.6281> }
					triangle { <36.6125, 167.9196, -65.6281>, <36.7226, 166.1439, -65.2417>, <36.1479, 167.2114, -64.5503> }
					triangle { <36.1479, 167.2114, -64.5503>, <36.7226, 166.1439, -65.2417>, <36.9136, 166.1352, -63.7631> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <37.959, 168.3759, -66.276>, <38.3902, 166.9348, -65.7804>, <37.2468, 166.9887, -66.1791> }
					triangle { <38.3902, 166.9348, -65.7804>, <38.01596, 166.0299, -64.8362>, <37.2468, 166.9887, -66.1791> }
					triangle { <37.2468, 166.9887, -66.1791>, <38.01596, 166.0299, -64.8362>, <36.6879, 166.1534, -65.247> }
					triangle { <36.6879, 166.1534, -65.247>, <38.01596, 166.0299, -64.8362>, <37.00583, 166.1166, -63.7431> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				mesh { // fruit section
					triangle { <37.959, 168.3759, -66.276>, <38.5634, 167.8883, -64.8957>, <38.4321, 166.9991, -65.7089> }
					triangle { <38.5634, 167.8883, -64.8957>, <38.2483, 167.0192, -63.8978>, <38.4321, 166.9991, -65.7089> }
					triangle { <38.4321, 166.9991, -65.7089>, <38.2483, 167.0192, -63.8978>, <38.02216, 166.0183, -64.8437> }
					triangle { <38.02216, 166.0183, -64.8437>, <38.2483, 167.0192, -63.8978>, <37.03516, 166.1815, -63.6761> }
					pigment { color rgb <0.0, 0.0, 0.99> }}
				}
			}
		}
scale 1.77
} // end Solomon_s_seal

#declare Plant4 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.5879, 5.9765, 0.02888>, 0.458 }
		cylinder { <-0.5879, 5.9765, 0.02888>, <-1.7581, 11.8667, 0.08637>, 0.458 }
		cylinder { <-1.7581, 11.8667, 0.08637>, <-3.4993, 17.6136, 0.1719>, 0.458 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // internode
		cylinder { <-3.4993, 17.6136, 0.1719>, <-5.04932, 25.292, 0.8955>, 0.6 }
		cylinder { <-5.04932, 25.292, 0.8955>, <-5.8451, 33.00551, 2.2198>, 0.6 }
		cylinder { <-5.8451, 33.00551, 2.2198>, <-5.8748, 40.6379, 4.1248>, 0.6 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.8748, 40.6379, 4.1248>, <-4.9859, 43.3196, 5.4999>, 0.2995 }
			cylinder { <-4.9859, 43.3196, 5.4999>, <-3.3154, 45.2751, 7.3049>, 0.2995 }
			cylinder { <-3.3154, 45.2751, 7.3049>, <-1.08728, 46.2424, 9.2978>, 0.2995 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-1.08728, 46.2424, 9.2978>, <7.8371, 50.5497, 10.9759>, <4.7861, 48.8081, 14.8607> }
			triangle { <4.7861, 48.8081, 14.8607>, <7.8371, 50.5497, 10.9759>, <14.7445, 50.8078, 17.9888> }
			triangle { <4.7861, 48.8081, 14.8607>, <14.7445, 50.8078, 17.9888>, <12.2705, 48.2271, 20.8927> }
			triangle { <14.7445, 50.8078, 17.9888>, <19.00137, 47.5754, 26.3155>, <12.2705, 48.2271, 20.8927> }
			triangle { <4.7861, 48.8081, 14.8607>, <0.6775, 49.9726, 19.2606>, <-1.08728, 46.2424, 9.2978> }
			triangle { <0.6775, 49.9726, 19.2606>, <4.7861, 48.8081, 14.8607>, <12.2705, 48.2271, 20.8927> }
			triangle { <9.9205, 48.761, 24.3755>, <0.6775, 49.9726, 19.2606>, <12.2705, 48.2271, 20.8927> }
			triangle { <9.9205, 48.761, 24.3755>, <12.2705, 48.2271, 20.8927>, <19.00137, 47.5754, 26.3155> }
			triangle { <19.00137, 47.5754, 26.3155>, <28.504, 41.7009, 32.2887>, <9.9205, 48.761, 24.3755> }
			triangle { <14.7445, 50.8078, 17.9888>, <28.504, 41.7009, 32.2887>, <19.00137, 47.5754, 26.3155> }
			triangle { <0.6775, 49.9726, 19.2606>, <-6.1715, 50.605, 14.3509>, <-1.08728, 46.2424, 9.2978> }
			triangle { <-6.1715, 50.605, 14.3509>, <-9.1708, 49.5114, 10.8046>, <-1.08728, 46.2424, 9.2978> }
			triangle { <-1.08728, 46.2424, 9.2978>, <1.07877, 51.6862, 5.3486>, <7.8371, 50.5497, 10.9759> }
			triangle { <1.07877, 51.6862, 5.3486>, <-1.08728, 46.2424, 9.2978>, <-3.196, 50.3913, 2.583> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.8748, 40.6379, 4.1248>, <-6.7858, 43.6447, 4.1696>, 0.2995 }
			cylinder { <-6.7858, 43.6447, 4.1696>, <-8.4738, 46.2067, 3.4922>, 0.2995 }
			cylinder { <-8.4738, 46.2067, 3.4922>, <-10.7127, 47.9807, 2.1834>, 0.2995 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-10.7127, 47.9807, 2.1834>, <-19.6714, 52.5059, 2.7099>, <-16.6149, 52.8165, -1.5319> }
			triangle { <-16.6149, 52.8165, -1.5319>, <-19.6714, 52.5059, 2.7099>, <-26.5933, 55.9786, -3.3717> }
			triangle { <-16.6149, 52.8165, -1.5319>, <-26.5933, 55.9786, -3.3717>, <-24.1058, 55.08344, -7.1432> }
			triangle { <-26.5933, 55.9786, -3.3717>, <-30.8416, 57.00714, -12.2485>, <-24.1058, 55.08344, -7.1432> }
			triangle { <-16.6149, 52.8165, -1.5319>, <-12.523, 55.942, -4.861>, <-10.7127, 47.9807, 2.1834> }
			triangle { <-12.523, 55.942, -4.861>, <-16.6149, 52.8165, -1.5319>, <-24.1058, 55.08344, -7.1432> }
			triangle { <-21.7662, 57.2085, -9.9622>, <-12.523, 55.942, -4.861>, <-24.1058, 55.08344, -7.1432> }
			triangle { <-21.7662, 57.2085, -9.9622>, <-24.1058, 55.08344, -7.1432>, <-30.8416, 57.00714, -12.2485> }
			triangle { <-30.8416, 57.00714, -12.2485>, <-40.3119, 54.5591, -20.2989>, <-21.7662, 57.2085, -9.9622> }
			triangle { <-26.5933, 55.9786, -3.3717>, <-40.3119, 54.5591, -20.2989>, <-30.8416, 57.00714, -12.2485> }
			triangle { <-12.523, 55.942, -4.861>, <-5.6697, 54.2433, -0.2175>, <-10.7127, 47.9807, 2.1834> }
			triangle { <-5.6697, 54.2433, -0.2175>, <-2.656, 51.6334, 2.4043>, <-10.7127, 47.9807, 2.1834> }
			triangle { <-10.7127, 47.9807, 2.1834>, <-12.9113, 50.9142, 8.2236>, <-19.6714, 52.5059, 2.7099> }
			triangle { <-12.9113, 50.9142, 8.2236>, <-10.7127, 47.9807, 2.1834>, <-8.6221, 48.5029, 10.06426> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-5.8748, 40.6379, 4.1248>, <-5.7642, 41.7534, 4.4934>, 0.3 }
			cylinder { <-5.7642, 41.7534, 4.4934>, <-5.5404, 42.8228, 4.9392>, 0.3 }
			cylinder { <-5.5404, 42.8228, 4.9392>, <-5.2066, 43.8299, 5.4556>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <-5.2066, 43.8299, 5.4556>, <-4.7615, 45.1727, 6.1442>, 0.3 }
			cylinder { <-4.7615, 45.1727, 6.1442>, <-4.3164, 46.5155, 6.8327>, 0.3 }
			cylinder { <-4.3164, 46.5155, 6.8327>, <-3.8713, 47.8584, 7.5213>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.8713, 47.8584, 7.5213>, <-3.04354, 50.7122, 8.5567>, 0.3 }
				cylinder { <-3.04354, 50.7122, 8.5567>, <-2.2905, 53.6912, 9.2348>, 0.3 }
				cylinder { <-2.2905, 53.6912, 9.2348>, <-1.6236, 56.7507, 9.5455>, 0.3 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-1.6236, 56.7507, 9.5455>, <-1.5702, 62.8039, 10.7727>, <-0.242, 62.5224, 10.6947> }
					triangle { <-1.5702, 62.8039, 10.7727>, <-4.4371, 64.1623, 14.3065>, <-0.242, 62.5224, 10.6947> }
					triangle { <-1.5702, 62.8039, 10.7727>, <-4.4322, 64.1334, 13.1457>, <-4.4371, 64.1623, 14.3065> }
					triangle { <-4.4371, 64.1623, 14.3065>, <-3.6408, 63.6652, 14.6245>, <-0.242, 62.5224, 10.6947> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-1.6236, 56.7507, 9.5455>, <-0.166, 62.4233, 11.5069>, <0.2049, 62.4752, 10.1995> }
					triangle { <-0.166, 62.4233, 11.5069>, <2.2242, 62.5782, 15.6075>, <0.2049, 62.4752, 10.1995> }
					triangle { <-0.166, 62.4233, 11.5069>, <1.1362, 62.7088, 15.2234>, <2.2242, 62.5782, 15.6075> }
					triangle { <2.2242, 62.5782, 15.6075>, <2.773, 62.244, 14.8528>, <0.2049, 62.4752, 10.1995> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-1.6236, 56.7507, 9.5455>, <0.9879, 62.2878, 10.3642>, <-0.1075, 62.6019, 9.622> }
					triangle { <0.9879, 62.2878, 10.3642>, <5.6633, 62.444, 9.5469>, <-0.1075, 62.6019, 9.622> }
					triangle { <0.9879, 62.2878, 10.3642>, <4.9346, 62.3657, 10.4476>, <5.6633, 62.444, 9.5469> }
					triangle { <5.6633, 62.444, 9.5469>, <5.1289, 62.3535, 8.717>, <-0.1075, 62.6019, 9.622> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-1.6236, 56.7507, 9.5455>, <0.3076, 62.5834, 8.9131>, <-0.7505, 62.7286, 9.7549> }
					triangle { <0.3076, 62.5834, 8.9131>, <1.1595, 63.9438, 4.4437>, <-0.7505, 62.7286, 9.7549> }
					triangle { <0.3076, 62.5834, 8.9131>, <1.7492, 63.5752, 5.3737>, <1.1595, 63.9438, 4.4437> }
					triangle { <1.1595, 63.9438, 4.4437>, <0.193, 63.8433, 4.6394>, <-0.7505, 62.7286, 9.7549> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-1.6236, 56.7507, 9.5455>, <-1.2972, 62.9072, 9.1694>, <-0.8349, 62.6787, 10.4279> }
					triangle { <-1.2972, 62.9072, 9.1694>, <-5.1771, 65.02187, 7.4297>, <-0.8349, 62.6787, 10.4279> }
					triangle { <-1.2972, 62.9072, 9.1694>, <-4.1272, 64.6842, 7.06641>, <-5.1771, 65.02187, 7.4297> }
					triangle { <-5.1771, 65.02187, 7.4297>, <-5.3087, 64.6662, 8.3456>, <-0.8349, 62.6787, 10.4279> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				}
			}
		union { // inflor. internode
			cylinder { <-3.8713, 47.8584, 7.5213>, <-3.4262, 49.2012, 8.2098>, 0.3 }
			cylinder { <-3.4262, 49.2012, 8.2098>, <-2.9811, 50.544, 8.8984>, 0.3 }
			cylinder { <-2.9811, 50.544, 8.8984>, <-2.536, 51.8868, 9.5869>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.536, 51.8868, 9.5869>, <-1.8566, 54.4593, 11.2669>, 0.3 }
				cylinder { <-1.8566, 54.4593, 11.2669>, <-1.3981, 56.8799, 13.2244>, 0.3 }
				cylinder { <-1.3981, 56.8799, 13.2244>, <-1.1674, 59.1123, 15.4301>, 0.3 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-1.1674, 59.1123, 15.4301>, <0.5338, 62.9068, 19.9972>, <-0.3624, 63.6711, 19.3173> }
					triangle { <0.5338, 62.9068, 19.9972>, <5.2174, 63.2019, 20.7238>, <-0.3624, 63.6711, 19.3173> }
					triangle { <0.5338, 62.9068, 19.9972>, <4.2953, 62.6559, 21.1708>, <5.2174, 63.2019, 20.7238> }
					triangle { <5.2174, 63.2019, 20.7238>, <4.9263, 63.655, 19.8917>, <-0.3624, 63.6711, 19.3173> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-1.1674, 59.1123, 15.4301>, <0.2199, 64.04713, 18.8759>, <-1.0279, 63.7376, 19.3196> }
					triangle { <0.2199, 64.04713, 18.8759>, <2.03558, 67.7235, 16.4803>, <-1.0279, 63.7376, 19.3196> }
					triangle { <0.2199, 64.04713, 18.8759>, <2.4037, 66.8384, 17.1356>, <2.03558, 67.7235, 16.4803> }
					triangle { <2.03558, 67.7235, 16.4803>, <1.06791, 67.5919, 16.3107>, <-1.0279, 63.7376, 19.3196> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-1.1674, 59.1123, 15.4301>, <-1.3927, 64.2739, 18.8151>, <-1.2793, 63.3154, 19.7733> }
					triangle { <-1.3927, 64.2739, 18.8151>, <-4.8305, 67.3194, 17.6073>, <-1.2793, 63.3154, 19.7733> }
					triangle { <-1.3927, 64.2739, 18.8151>, <-3.6915, 67.1723, 17.4351>, <-4.8305, 67.3194, 17.6073> }
					triangle { <-4.8305, 67.3194, 17.6073>, <-5.1749, 66.508, 18.06059>, <-1.2793, 63.3154, 19.7733> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-1.1674, 59.1123, 15.4301>, <-2.09061, 63.2759, 19.8981>, <-0.7716, 62.9841, 20.05557> }
					triangle { <-2.09061, 63.2759, 19.8981>, <-5.9561, 62.5443, 22.5579>, <-0.7716, 62.9841, 20.05557> }
					triangle { <-2.09061, 63.2759, 19.8981>, <-5.624, 63.1992, 21.6583>, <-5.9561, 62.5443, 22.5579> }
					triangle { <-5.9561, 62.5443, 22.5579>, <-5.233, 61.8911, 22.7393>, <-0.7716, 62.9841, 20.05557> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-1.1674, 59.1123, 15.4301>, <-0.8819, 62.4183, 20.6397>, <-0.1964, 63.2072, 19.7695> }
					triangle { <-0.8819, 62.4183, 20.6397>, <0.3476, 59.9612, 24.513>, <-0.1964, 63.2072, 19.7695> }
					triangle { <-0.8819, 62.4183, 20.6397>, <-0.6133, 60.3658, 24.00199>, <0.3476, 59.9612, 24.513> }
					triangle { <0.3476, 59.9612, 24.513>, <1.1041, 60.1013, 23.8881>, <-0.1964, 63.2072, 19.7695> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				}
			}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-5.8748, 40.6379, 4.1248>, <-5.9941, 41.7949, 4.3235>, 0.3 }
			cylinder { <-5.9941, 41.7949, 4.3235>, <-6.2266, 42.9467, 4.432>, 0.3 }
			cylinder { <-6.2266, 42.9467, 4.432>, <-6.5688, 44.07594, 4.4488>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <-6.5688, 44.07594, 4.4488>, <-7.02497, 45.5815, 4.4712>, 0.3 }
			cylinder { <-7.02497, 45.5815, 4.4712>, <-7.4811, 47.0871, 4.4936>, 0.3 }
			cylinder { <-7.4811, 47.0871, 4.4936>, <-7.9373, 48.5926, 4.516>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-7.9373, 48.5926, 4.516>, <-8.7878, 51.5921, 4.9416>, 0.3 }
				cylinder { <-8.7878, 51.5921, 4.9416>, <-9.5639, 54.5348, 5.7416>, 0.3 }
				cylinder { <-9.5639, 54.5348, 5.7416>, <-10.2537, 57.3764, 6.9038>, 0.3 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-10.2537, 57.3764, 6.9038>, <-10.3536, 63.2959, 8.6649>, <-11.6797, 63.00098, 8.599> }
					triangle { <-10.3536, 63.2959, 8.6649>, <-7.5032, 66.1764, 6.1892>, <-11.6797, 63.00098, 8.599> }
					triangle { <-10.3536, 63.2959, 8.6649>, <-7.5058, 65.6054, 7.2003>, <-7.5032, 66.1764, 6.1892> }
					triangle { <-7.5032, 66.1764, 6.1892>, <-8.2965, 65.8812, 5.6734>, <-11.6797, 63.00098, 8.599> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-10.2537, 57.3764, 6.9038>, <-11.7564, 63.2946, 7.8354>, <-12.1254, 62.7234, 9.01321> }
					triangle { <-11.7564, 63.2946, 7.8354>, <-14.1552, 65.3408, 4.2842>, <-12.1254, 62.7234, 9.01321> }
					triangle { <-11.7564, 63.2946, 7.8354>, <-13.06753, 65.2835, 4.6866>, <-14.1552, 65.3408, 4.2842> }
					triangle { <-14.1552, 65.3408, 4.2842>, <-14.7002, 64.6871, 4.7923>, <-12.1254, 62.7234, 9.01321> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-10.2537, 57.3764, 6.9038>, <-12.9073, 62.6296, 8.7783>, <-11.8128, 62.5661, 9.5831> }
					triangle { <-12.9073, 62.6296, 8.7783>, <-17.5822, 62.3492, 9.5646>, <-11.8128, 62.5661, 9.5831> }
					triangle { <-12.9073, 62.6296, 8.7783>, <-16.8546, 62.7087, 8.7341>, <-17.5822, 62.3492, 9.5646> }
					triangle { <-17.5822, 62.3492, 9.5646>, <-17.04566, 61.8832, 10.2556>, <-11.8128, 62.5661, 9.5831> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-10.2537, 57.3764, 6.9038>, <-12.2265, 62.2136, 10.1994>, <-11.1709, 62.7451, 9.5265> }
					triangle { <-12.2265, 62.2136, 10.1994>, <-13.0802, 61.3079, 14.7823>, <-11.1709, 62.7451, 9.5265> }
					triangle { <-12.2265, 62.2136, 10.1994>, <-13.6688, 61.4153, 13.7871>, <-13.0802, 61.3079, 14.7823> }
					triangle { <-13.0802, 61.3079, 14.7823>, <-12.1133, 61.3183, 14.5641>, <-11.1709, 62.7451, 9.5265> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-10.2537, 57.3764, 6.9038>, <-10.6245, 62.6316, 10.1282>, <-11.08743, 63.01792, 8.9091> }
					triangle { <-10.6245, 62.6316, 10.1282>, <-6.7569, 63.709, 12.6646>, <-11.08743, 63.01792, 8.9091> }
					triangle { <-10.6245, 62.6316, 10.1282>, <-7.8037, 63.2326, 12.8248>, <-6.7569, 63.709, 12.6646> }
					triangle { <-6.7569, 63.709, 12.6646>, <-6.6244, 63.8265, 11.6894>, <-11.08743, 63.01792, 8.9091> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				}
			}
		union { // inflor. internode
			cylinder { <-7.9373, 48.5926, 4.516>, <-8.3934, 50.09827, 4.5385>, 0.3 }
			cylinder { <-8.3934, 50.09827, 4.5385>, <-8.8496, 51.6038, 4.5609>, 0.3 }
			cylinder { <-8.8496, 51.6038, 4.5609>, <-9.3057, 53.1094, 4.5833>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.3057, 53.1094, 4.5833>, <-10.00714, 56.1645, 4.308>, 0.3 }
				cylinder { <-10.00714, 56.1645, 4.308>, <-10.4869, 59.2177, 3.7167>, 0.3 }
				cylinder { <-10.4869, 59.2177, 3.7167>, <-10.7379, 62.2229, 2.8183>, 0.3 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-10.7379, 62.2229, 2.8183>, <-12.4753, 67.706, 0.5669>, <-11.5834, 68.06778, 1.5278> }
					triangle { <-12.4753, 67.706, 0.5669>, <-17.1623, 68.2736, 0.05569>, <-11.5834, 68.06778, 1.5278> }
					triangle { <-12.4753, 67.706, 0.5669>, <-16.237, 68.00851, -0.5938>, <-17.1623, 68.2736, 0.05569> }
					triangle { <-17.1623, 68.2736, 0.05569>, <-16.873, 68.2846, 1.003656>, <-11.5834, 68.06778, 1.5278> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-10.7379, 62.2229, 2.8183>, <-12.1677, 68.1879, 2.09309>, <-10.9185, 68.1324, 1.5582> }
					triangle { <-12.1677, 68.1879, 2.09309>, <-14.00589, 70.2939, 5.932>, <-10.9185, 68.1324, 1.5582> }
					triangle { <-12.1677, 68.1879, 2.09309>, <-14.3687, 69.8179, 4.937>, <-14.00589, 70.2939, 5.932> }
					triangle { <-14.00589, 70.2939, 5.932>, <-13.03698, 70.1051, 6.02166>, <-10.9185, 68.1324, 1.5582> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-10.7379, 62.2229, 2.8183>, <-10.5566, 68.3713, 2.2563>, <-10.6648, 67.9747, 0.9599> }
					triangle { <-10.5566, 68.3713, 2.2563>, <-7.1391, 70.5171, 4.7598>, <-10.6648, 67.9747, 0.9599> }
					triangle { <-10.5566, 68.3713, 2.2563>, <-8.2765, 70.298, 4.8406>, <-7.1391, 70.5171, 4.7598> }
					triangle { <-7.1391, 70.5171, 4.7598>, <-6.7895, 70.01646, 3.9791>, <-10.6648, 67.9747, 0.9599> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-10.7379, 62.2229, 2.8183>, <-9.8534, 68.00447, 0.8326>, <-11.1705, 67.8111, 0.5541> }
					triangle { <-9.8534, 68.00447, 0.8326>, <-5.9875, 68.6368, -1.8518>, <-11.1705, 67.8111, 0.5541> }
					triangle { <-9.8534, 68.00447, 0.8326>, <-6.3228, 68.7898, -0.7506>, <-5.9875, 68.6368, -1.8518> }
					triangle { <-5.9875, 68.6368, -1.8518>, <-6.7062, 68.1402, -2.3203>, <-11.1705, 67.8111, 0.5541> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-10.7379, 62.2229, 2.8183>, <-11.0572, 67.587, -0.2271>, <-11.7468, 67.8695, 0.9104> }
					triangle { <-11.0572, 67.587, -0.2271>, <-12.2758, 67.2293, -4.803>, <-11.7468, 67.8695, 0.9104> }
					triangle { <-11.0572, 67.587, -0.2271>, <-11.3169, 67.3534, -4.16>, <-12.2758, 67.2293, -4.803> }
					triangle { <-12.2758, 67.2293, -4.803>, <-13.03218, 67.05383, -4.187>, <-11.7468, 67.8695, 0.9104> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				}
			}
		}
	union { // internode
		cylinder { <-5.8748, 40.6379, 4.1248>, <-5.9751, 48.3528, 5.6593>, 0.6 }
		cylinder { <-5.9751, 48.3528, 5.6593>, <-6.1457, 56.1316, 6.8196>, 0.6 }
		cylinder { <-6.1457, 56.1316, 6.8196>, <-6.3864, 63.9555, 7.6028>, 0.6 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-6.3864, 63.9555, 7.6028>, <-6.6785, 66.9588, 6.7919>, 0.2978 }
			cylinder { <-6.6785, 66.9588, 6.7919>, <-7.1281, 69.4554, 4.9677>, 0.2978 }
			cylinder { <-7.1281, 69.4554, 4.9677>, <-7.6748, 71.1106, 2.3747>, 0.2978 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-7.6748, 71.1106, 2.3747>, <-13.9921, 76.06357, -3.5794>, <-8.9206, 75.5911, -4.6678> }
			triangle { <-8.9206, 75.5911, -4.6678>, <-13.9921, 76.06357, -3.5794>, <-14.6192, 78.9027, -12.9297> }
			triangle { <-8.9206, 75.5911, -4.6678>, <-14.6192, 78.9027, -12.9297>, <-10.4376, 77.3434, -13.9596> }
			triangle { <-14.6192, 78.9027, -12.9297>, <-11.778, 78.7975, -22.3495>, <-10.4376, 77.3434, -13.9596> }
			triangle { <-8.9206, 75.5911, -4.6678>, <-3.3063, 77.9692, -4.6159>, <-7.6748, 71.1106, 2.3747> }
			triangle { <-3.3063, 77.9692, -4.6159>, <-8.9206, 75.5911, -4.6678>, <-10.4376, 77.3434, -13.9596> }
			triangle { <-6.5811, 78.8989, -14.6269>, <-3.3063, 77.9692, -4.6159>, <-10.4376, 77.3434, -13.9596> }
			triangle { <-6.5811, 78.8989, -14.6269>, <-10.4376, 77.3434, -13.9596>, <-11.778, 78.7975, -22.3495> }
			triangle { <-11.778, 78.7975, -22.3495>, <-13.7872, 75.6518, -34.3817>, <-6.5811, 78.8989, -14.6269> }
			triangle { <-14.6192, 78.9027, -12.9297>, <-13.7872, 75.6518, -34.3817>, <-11.778, 78.7975, -22.3495> }
			triangle { <-3.3063, 77.9692, -4.6159>, <-1.5462, 76.6617, 3.4966>, <-7.6748, 71.1106, 2.3747> }
			triangle { <-1.5462, 76.6617, 3.4966>, <-1.4046, 74.3435, 7.6344>, <-7.6748, 71.1106, 2.3747> }
			triangle { <-7.6748, 71.1106, 2.3747>, <-12.8569, 74.9951, 5.09987>, <-13.9921, 76.06357, -3.5794> }
			triangle { <-12.8569, 74.9951, 5.09987>, <-7.6748, 71.1106, 2.3747>, <-11.2384, 72.6944, 9.5022> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-6.3864, 63.9555, 7.6028>, <-6.2726, 66.7508, 8.9942>, 0.2978 }
			cylinder { <-6.2726, 66.7508, 8.9942>, <-5.9646, 68.8593, 11.2794>, 0.2978 }
			cylinder { <-5.9646, 68.8593, 11.2794>, <-5.5039, 69.9984, 14.1522>, 0.2978 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-5.5039, 69.9984, 14.1522>, <0.5364, 74.04903, 21.00776>, <-4.4901, 73.06275, 21.9502> }
			triangle { <-4.4901, 73.06275, 21.9502>, <0.5364, 74.04903, 21.00776>, <1.04656, 75.013, 30.7388> }
			triangle { <-4.4901, 73.06275, 21.9502>, <1.04656, 75.013, 30.7388>, <-3.02601, 73.02908, 31.414> }
			triangle { <1.04656, 75.013, 30.7388>, <-1.7255, 72.8716, 39.9337>, <-3.02601, 73.02908, 31.414> }
			triangle { <-4.4901, 73.06275, 21.9502>, <-10.2389, 75.05789, 22.336>, <-5.5039, 69.9984, 14.1522> }
			triangle { <-10.2389, 75.05789, 22.336>, <-4.4901, 73.06275, 21.9502>, <-3.02601, 73.02908, 31.414> }
			triangle { <-6.9659, 74.184, 32.3526>, <-10.2389, 75.05789, 22.336>, <-3.02601, 73.02908, 31.414> }
			triangle { <-6.9659, 74.184, 32.3526>, <-3.02601, 73.02908, 31.414>, <-1.7255, 72.8716, 39.9337> }
			triangle { <-1.7255, 72.8716, 39.9337>, <0.5445, 67.5335, 51.1166>, <-6.9659, 74.184, 32.3526> }
			triangle { <1.04656, 75.013, 30.7388>, <0.5445, 67.5335, 51.1166>, <-1.7255, 72.8716, 39.9337> }
			triangle { <-10.2389, 75.05789, 22.336>, <-11.9656, 75.2783, 14.1146>, <-5.5039, 69.9984, 14.1522> }
			triangle { <-11.9656, 75.2783, 14.1146>, <-11.9911, 73.8213, 9.5989>, <-5.5039, 69.9984, 14.1522> }
			triangle { <-5.5039, 69.9984, 14.1522>, <-0.5844, 74.6535, 12.282>, <0.5364, 74.04903, 21.00776> }
			triangle { <-0.5844, 74.6535, 12.282>, <-5.5039, 69.9984, 14.1522>, <-2.08675, 73.1762, 7.5014> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-6.3864, 63.9555, 7.6028>, <-6.4483, 65.1336, 7.578>, 0.3 }
			cylinder { <-6.4483, 65.1336, 7.578>, <-6.535, 66.2985, 7.4112>, 0.3 }
			cylinder { <-6.535, 66.2985, 7.4112>, <-6.6454, 67.4327, 7.105>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <-6.6454, 67.4327, 7.105>, <-6.7925, 68.945, 6.6966>, 0.3 }
			cylinder { <-6.7925, 68.945, 6.6966>, <-6.9396, 70.4573, 6.2883>, 0.3 }
			cylinder { <-6.9396, 70.4573, 6.2883>, <-7.08673, 71.9696, 5.88>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-7.08673, 71.9696, 5.88>, <-7.5881, 75.0366, 5.3862>, 0.3 }
				cylinder { <-7.5881, 75.0366, 5.3862>, <-8.2891, 78.09982, 5.2226>, 0.3 }
				cylinder { <-8.2891, 78.09982, 5.2226>, <-9.1792, 81.1132, 5.3918>, 0.3 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-9.1792, 81.1132, 5.3918>, <-9.6098, 87.2272, 6.1564>, <-10.5864, 86.9902, 5.24> }
					triangle { <-9.6098, 87.2272, 6.1564>, <-5.4779, 89.5642, 6.0221>, <-10.5864, 86.9902, 5.24> }
					triangle { <-9.6098, 87.2272, 6.1564>, <-6.2246, 89.1515, 6.8098>, <-5.4779, 89.5642, 6.0221> }
					triangle { <-5.4779, 89.5642, 6.0221>, <-5.764, 89.2339, 5.1324>, <-10.5864, 86.9902, 5.24> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-9.1792, 81.1132, 5.3918>, <-10.09941, 87.1698, 4.603>, <-11.2269, 86.7995, 5.2673> }
					triangle { <-10.09941, 87.1698, 4.603>, <-9.2509, 88.7757, 0.2152>, <-11.2269, 86.7995, 5.2673> }
					triangle { <-10.09941, 87.1698, 4.603>, <-8.7202, 88.7266, 1.2469>, <-9.2509, 88.7757, 0.2152> }
					triangle { <-9.2509, 88.7757, 0.2152>, <-10.07781, 88.2324, 0.2746>, <-11.2269, 86.7995, 5.2673> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-9.1792, 81.1132, 5.3918>, <-11.6625, 86.7096, 4.5764>, <-11.3932, 86.7143, 5.9094> }
					triangle { <-11.6625, 86.7096, 4.5764>, <-15.6744, 86.7761, 2.0363>, <-11.3932, 86.7143, 5.9094> }
					triangle { <-11.6625, 86.7096, 4.5764>, <-14.5398, 86.9718, 1.8853>, <-15.6744, 86.7761, 2.0363> }
					triangle { <-15.6744, 86.7761, 2.0363>, <-15.7971, 86.3933, 2.9423>, <-11.3932, 86.7143, 5.9094> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-9.1792, 81.1132, 5.3918>, <-12.1536, 86.4783, 6.113>, <-10.8571, 86.8515, 6.285> }
					triangle { <-12.1536, 86.4783, 6.113>, <-15.9314, 86.3101, 8.9856>, <-10.8571, 86.8515, 6.285> }
					triangle { <-12.1536, 86.4783, 6.113>, <-15.6952, 86.2958, 7.8488>, <-15.9314, 86.3101, 8.9856> }
					triangle { <-15.9314, 86.3101, 8.9856>, <-15.07151, 86.241, 9.4737>, <-10.8571, 86.8515, 6.285> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-9.1792, 81.1132, 5.3918>, <-10.8658, 86.803, 7.1042>, <-10.351, 87.02467, 5.865> }
					triangle { <-10.8658, 86.803, 7.1042>, <-9.5345, 88.05931, 11.4862>, <-10.351, 87.02467, 5.865> }
					triangle { <-10.8658, 86.803, 7.1042>, <-10.4786, 87.6633, 10.9382>, <-9.5345, 88.05931, 11.4862> }
					triangle { <-9.5345, 88.05931, 11.4862>, <-8.7771, 88.02313, 10.8477>, <-10.351, 87.02467, 5.865> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				}
			}
		union { // inflor. internode
			cylinder { <-7.08673, 71.9696, 5.88>, <-7.2338, 73.4819, 5.4717>, 0.3 }
			cylinder { <-7.2338, 73.4819, 5.4717>, <-7.3809, 74.9942, 5.06343>, 0.3 }
			cylinder { <-7.3809, 74.9942, 5.06343>, <-7.528, 76.5065, 4.6551>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-7.528, 76.5065, 4.6551>, <-7.4491, 79.5164, 3.741>, 0.3 }
				cylinder { <-7.4491, 79.5164, 3.741>, <-6.9982, 82.4664, 2.7432>, 0.3 }
				cylinder { <-6.9982, 82.4664, 2.7432>, <-6.1822, 85.3122, 1.6768>, 0.3 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-6.1822, 85.3122, 1.6768>, <-5.2349, 90.4746, -1.5793>, <-5.1606, 90.9324, -0.3008> }
					triangle { <-5.2349, 90.4746, -1.5793>, <-8.2843, 91.1853, -5.1498>, <-5.1606, 90.9324, -0.3008> }
					triangle { <-5.2349, 90.4746, -1.5793>, <-7.2079, 90.7817, -4.9855>, <-8.2843, 91.1853, -5.1498> }
					triangle { <-8.2843, 91.1853, -5.1498>, <-8.6944, 91.3239, -4.2581>, <-5.1606, 90.9324, -0.3008> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-6.1822, 85.3122, 1.6768>, <-5.949, 91.1638, -0.2866>, <-4.6804, 90.9687, 0.1632> }
					triangle { <-5.949, 91.1638, -0.2866>, <-9.5539, 93.9064, 1.1398>, <-4.6804, 90.9687, 0.1632> }
					triangle { <-5.949, 91.1638, -0.2866>, <-9.2303, 93.3051, 0.2006>, <-9.5539, 93.9064, 1.1398> }
					triangle { <-9.5539, 93.9064, 1.1398>, <-8.9226, 93.6865, 1.8717>, <-4.6804, 90.9687, 0.1632> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-6.1822, 85.3122, 1.6768>, <-4.8411, 91.2915, 0.9016>, <-4.1196, 90.7113, -0.09455> }
					triangle { <-4.8411, 91.2915, 0.9016>, <-3.6753, 93.6197, 4.873>, <-4.1196, 90.7113, -0.09455> }
					triangle { <-4.8411, 91.2915, 0.9016>, <-4.599, 93.4704, 4.1854>, <-3.6753, 93.6197, 4.873> }
					triangle { <-3.6753, 93.6197, 4.873>, <-2.97, 92.9916, 4.5723>, <-4.1196, 90.7113, -0.09455> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-6.1822, 85.3122, 1.6768>, <-3.432, 90.6824, 0.3545>, <-4.2479, 90.5135, -0.7203> }
					triangle { <-3.432, 90.6824, 0.3545>, <1.2822, 90.7188, 0.9254>, <-4.2479, 90.5135, -0.7203> }
					triangle { <-3.432, 90.6824, 0.3545>, <0.3287, 91.05071, 1.4991>, <1.2822, 90.7188, 0.9254> }
					triangle { <1.2822, 90.7188, 0.9254>, <0.9926, 90.1931, 0.1366>, <-4.2479, 90.5135, -0.7203> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-6.1822, 85.3122, 1.6768>, <-3.6791, 90.1699, -1.202>, <-4.901, 90.6523, -0.8498> }
					triangle { <-3.6791, 90.1699, -1.202>, <-1.6092, 89.1916, -5.3625>, <-4.901, 90.6523, -0.8498> }
					triangle { <-3.6791, 90.1699, -1.202>, <-1.308, 89.3639, -4.2544>, <-1.6092, 89.1916, -5.3625> }
					triangle { <-1.6092, 89.1916, -5.3625>, <-2.5986, 89.1469, -5.4033>, <-4.901, 90.6523, -0.8498> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				}
			}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-6.3864, 63.9555, 7.6028>, <-6.3961, 65.1069, 7.8609>, 0.3 }
			cylinder { <-6.3961, 65.1069, 7.8609>, <-6.3794, 66.2188, 8.2556>, 0.3 }
			cylinder { <-6.3794, 66.2188, 8.2556>, <-6.3364, 67.2744, 8.7811>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <-6.3364, 67.2744, 8.7811>, <-6.2791, 68.682, 9.4817>, 0.3 }
			cylinder { <-6.2791, 68.682, 9.4817>, <-6.2218, 70.0896, 10.1823>, 0.3 }
			cylinder { <-6.2218, 70.0896, 10.1823>, <-6.1645, 71.4971, 10.8829>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-6.1645, 71.4971, 10.8829>, <-5.8477, 74.4302, 11.9774>, 0.3 }
				cylinder { <-5.8477, 74.4302, 11.9774>, <-5.3333, 77.4373, 12.7487>, 0.3 }
				cylinder { <-5.3333, 77.4373, 12.7487>, <-4.6293, 80.4729, 13.1851>, 0.3 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-4.6293, 80.4729, 13.1851>, <-4.5762, 86.6319, 13.6491>, <-3.5813, 86.278, 14.5063> }
					triangle { <-4.5762, 86.6319, 13.6491>, <-8.8417, 88.6402, 14.2184>, <-3.5813, 86.278, 14.5063> }
					triangle { <-4.5762, 86.6319, 13.6491>, <-8.07609, 88.4379, 13.3691>, <-8.8417, 88.6402, 14.2184> }
					triangle { <-8.8417, 88.6402, 14.2184>, <-8.5306, 88.1583, 15.02683>, <-3.5813, 86.278, 14.5063> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-4.6293, 80.4729, 13.1851>, <-4.07459, 86.2979, 15.1633>, <-2.9307, 86.1358, 14.4457> }
					triangle { <-4.07459, 86.2979, 15.1633>, <-4.9924, 86.9483, 19.777>, <-2.9307, 86.1358, 14.4457> }
					triangle { <-4.07459, 86.2979, 15.1633>, <-5.5254, 87.07244, 18.7528>, <-4.9924, 86.9483, 19.777> }
					triangle { <-4.9924, 86.9483, 19.777>, <-4.1344, 86.4789, 19.6162>, <-2.9307, 86.1358, 14.4457> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-4.6293, 80.4729, 13.1851>, <-2.4862, 85.9375, 15.1078>, <-2.7634, 86.1898, 13.8004> }
					triangle { <-2.4862, 85.9375, 15.1078>, <1.5295, 85.7436, 17.6351>, <-2.7634, 86.1898, 13.8004> }
					triangle { <-2.4862, 85.9375, 15.1078>, <0.3861, 85.8362, 17.8149>, <1.5295, 85.7436, 17.6351> }
					triangle { <1.5295, 85.7436, 17.6351>, <1.6698, 85.556, 16.672>, <-2.7634, 86.1898, 13.8004> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-4.6293, 80.4729, 13.1851>, <-1.9913, 86.04547, 13.5588>, <-3.3091, 86.3658, 13.4562> }
					triangle { <-1.9913, 86.04547, 13.5588>, <1.772, 86.6797, 10.7329>, <-3.3091, 86.3658, 13.4562> }
					triangle { <-1.9913, 86.04547, 13.5588>, <1.5441, 86.4262, 11.8429>, <1.772, 86.6797, 10.7329> }
					triangle { <1.772, 86.6797, 10.7329>, <0.915, 86.6564, 10.2355>, <-3.3091, 86.3658, 13.4562> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-4.6293, 80.4729, 13.1851>, <-3.3025, 86.4811, 12.6437>, <-3.8222, 86.4211, 13.8991> }
					triangle { <-3.3025, 86.4811, 12.6437>, <-4.7344, 88.4969, 8.5893>, <-3.8222, 86.4211, 13.8991> }
					triangle { <-3.3025, 86.4811, 12.6437>, <-3.7647, 88.05848, 9.0538>, <-4.7344, 88.4969, 8.5893> }
					triangle { <-4.7344, 88.4969, 8.5893>, <-5.4843, 88.289, 9.2033>, <-3.8222, 86.4211, 13.8991> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				}
			}
		union { // inflor. internode
			cylinder { <-6.1645, 71.4971, 10.8829>, <-6.1072, 72.9047, 11.5835>, 0.3 }
			cylinder { <-6.1072, 72.9047, 11.5835>, <-6.04994, 74.3122, 12.2842>, 0.3 }
			cylinder { <-6.04994, 74.3122, 12.2842>, <-5.9926, 75.7198, 12.9848>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-5.9926, 75.7198, 12.9848>, <-6.2489, 78.4786, 14.4764>, 0.3 }
				cylinder { <-6.2489, 78.4786, 14.4764>, <-6.8723, 81.1396, 16.03587>, 0.3 }
				cylinder { <-6.8723, 81.1396, 16.03587>, <-7.8535, 83.6628, 17.6397>, 0.3 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.8535, 83.6628, 17.6397>, <-9.09336, 88.01073, 21.848>, <-9.2032, 88.7072, 20.6851> }
					triangle { <-9.09336, 88.01073, 21.848>, <-6.0712, 88.1843, 25.507>, <-9.2032, 88.7072, 20.6851> }
					triangle { <-9.09336, 88.01073, 21.848>, <-7.1219, 87.7565, 25.2595>, <-6.0712, 88.1843, 25.507> }
					triangle { <-6.0712, 88.1843, 25.507>, <-5.6757, 88.5215, 24.663>, <-9.2032, 88.7072, 20.6851> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-7.8535, 83.6628, 17.6397>, <-8.4304, 88.9844, 20.7218>, <-9.6874, 88.8054, 20.2344> }
					triangle { <-8.4304, 88.9844, 20.7218>, <-5.00788, 92.1693, 19.8886>, <-9.6874, 88.8054, 20.2344> }
					triangle { <-8.4304, 88.9844, 20.7218>, <-5.2885, 91.3753, 20.6882>, <-5.00788, 92.1693, 19.8886> }
					triangle { <-5.00788, 92.1693, 19.8886>, <-5.629, 92.06074, 19.1239>, <-9.6874, 88.8054, 20.2344> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-7.8535, 83.6628, 17.6397>, <-9.5512, 89.2772, 19.5755>, <-10.23, 88.4684, 20.4327> }
					triangle { <-9.5512, 89.2772, 19.5755>, <-10.8807, 92.2705, 16.1369>, <-10.23, 88.4684, 20.4327> }
					triangle { <-9.5512, 89.2772, 19.5755>, <-9.9454, 92.04445, 16.7869>, <-10.8807, 92.2705, 16.1369> }
					triangle { <-10.8807, 92.2705, 16.1369>, <-11.5447, 91.5536, 16.303>, <-10.23, 88.4684, 20.4327> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-7.8535, 83.6628, 17.6397>, <-10.9173, 88.4872, 19.9826>, <-10.08612, 88.1588, 21.00782> }
					triangle { <-10.9173, 88.4872, 19.9826>, <-15.6284, 88.3491, 19.4015>, <-10.08612, 88.1588, 21.00782> }
					triangle { <-10.9173, 88.4872, 19.9826>, <-14.7004, 88.8454, 18.9107>, <-15.6284, 88.3491, 19.4015> }
					triangle { <-15.6284, 88.3491, 19.4015>, <-15.3026, 87.6962, 20.07242>, <-10.08612, 88.1588, 21.00782> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-7.8535, 83.6628, 17.6397>, <-10.63, 87.6927, 21.4083>, <-9.4419, 88.3086, 21.1661> }
					triangle { <-10.63, 87.6927, 21.4083>, <-12.6111, 85.7856, 25.28>, <-9.4419, 88.3086, 21.1661> }
					triangle { <-10.63, 87.6927, 21.4083>, <-12.929, 86.1553, 24.2262>, <-12.6111, 85.7856, 25.28> }
					triangle { <-12.6111, 85.7856, 25.28>, <-11.6206, 85.794, 25.3171>, <-9.4419, 88.3086, 21.1661> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				}
			}
		}
	union { // internode
		cylinder { <-6.3864, 63.9555, 7.6028>, <-7.1322, 71.6235, 9.1931>, 0.6 }
		cylinder { <-7.1322, 71.6235, 9.1931>, <-8.3719, 79.02049, 11.5666>, 0.6 }
		cylinder { <-8.3719, 79.02049, 11.5666>, <-10.08699, 86.035, 14.6874>, 0.6 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.08699, 86.035, 14.6874>, <-11.2306, 88.06952, 16.635>, 0.2898 }
			cylinder { <-11.2306, 88.06952, 16.635>, <-12.7019, 89.1553, 19.06339>, 0.2898 }
			cylinder { <-12.7019, 89.1553, 19.06339>, <-14.3036, 89.147, 21.6469>, 0.2898 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-14.3036, 89.147, 21.6469>, <-14.6662, 89.6803, 31.349>, <-18.8221, 89.1306, 28.5024> }
			triangle { <-18.8221, 89.1306, 28.5024>, <-14.6662, 89.6803, 31.349>, <-20.4932, 87.1787, 38.4583> }
			triangle { <-18.8221, 89.1306, 28.5024>, <-20.4932, 87.1787, 38.4583>, <-23.6532, 85.6944, 35.6895> }
			triangle { <-20.4932, 87.1787, 38.4583>, <-27.999, 82.4886, 42.1053>, <-23.6532, 85.6944, 35.6895> }
			triangle { <-18.8221, 89.1306, 28.5024>, <-23.543, 91.5546, 25.8515>, <-14.3036, 89.147, 21.6469> }
			triangle { <-23.543, 91.5546, 25.8515>, <-18.8221, 89.1306, 28.5024>, <-23.6532, 85.6944, 35.6895> }
			triangle { <-27.2825, 86.9352, 34.2481>, <-23.543, 91.5546, 25.8515>, <-23.6532, 85.6944, 35.6895> }
			triangle { <-27.2825, 86.9352, 34.2481>, <-23.6532, 85.6944, 35.6895>, <-27.999, 82.4886, 42.1053> }
			triangle { <-27.999, 82.4886, 42.1053>, <-32.6321, 73.5773, 49.1294>, <-27.2825, 86.9352, 34.2481> }
			triangle { <-20.4932, 87.1787, 38.4583>, <-32.6321, 73.5773, 49.1294>, <-27.999, 82.4886, 42.1053> }
			triangle { <-23.543, 91.5546, 25.8515>, <-19.7048, 94.7719, 19.3893>, <-14.3036, 89.147, 21.6469> }
			triangle { <-19.7048, 94.7719, 19.3893>, <-16.7162, 94.994, 15.878>, <-14.3036, 89.147, 21.6469> }
			triangle { <-14.3036, 89.147, 21.6469>, <-10.1171, 93.3359, 25.06076>, <-14.6662, 89.6803, 31.349> }
			triangle { <-10.1171, 93.3359, 25.06076>, <-14.3036, 89.147, 21.6469>, <-8.04571, 93.8236, 20.4451> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.08699, 86.035, 14.6874>, <-10.1799, 89.05827, 14.9901>, 0.2898 }
			cylinder { <-10.1799, 89.05827, 14.9901>, <-9.6907, 91.9891, 14.3489>, 0.2898 }
			cylinder { <-9.6907, 91.9891, 14.3489>, <-8.6849, 94.4348, 12.8497>, 0.2898 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-8.6849, 94.4348, 12.8497>, <-10.2424, 101.7547, 6.6416>, <-5.7754, 101.0321, 8.9222> }
			triangle { <-5.7754, 101.0321, 8.9222>, <-10.2424, 101.7547, 6.6416>, <-5.2265, 107.5735, 1.008303> }
			triangle { <-5.7754, 101.0321, 8.9222>, <-5.2265, 107.5735, 1.008303>, <-1.3108, 105.9673, 2.402> }
			triangle { <-5.2265, 107.5735, 1.008303>, <2.7584, 110.304, -3.5106>, <-1.3108, 105.9673, 2.402> }
			triangle { <-5.7754, 101.0321, 8.9222>, <-1.9872, 102.4226, 13.2701>, <-8.6849, 94.4348, 12.8497> }
			triangle { <-1.9872, 102.4226, 13.2701>, <-5.7754, 101.0321, 8.9222>, <-1.3108, 105.9673, 2.402> }
			triangle { <1.7404, 107.0908, 4.8952>, <-1.9872, 102.4226, 13.2701>, <-1.3108, 105.9673, 2.402> }
			triangle { <1.7404, 107.0908, 4.8952>, <-1.3108, 105.9673, 2.402>, <2.7584, 110.304, -3.5106> }
			triangle { <2.7584, 110.304, -3.5106>, <9.2007, 111.8156, -13.8269>, <1.7404, 107.0908, 4.8952> }
			triangle { <-5.2265, 107.5735, 1.008303>, <9.2007, 111.8156, -13.8269>, <2.7584, 110.304, -3.5106> }
			triangle { <-1.9872, 102.4226, 13.2701>, <-5.5936, 98.2571, 19.3105>, <-8.6849, 94.4348, 12.8497> }
			triangle { <-5.5936, 98.2571, 19.3105>, <-7.7771, 94.742, 21.3568>, <-8.6849, 94.4348, 12.8497> }
			triangle { <-8.6849, 94.4348, 12.8497>, <-14.6925, 97.6945, 12.7499>, <-10.2424, 101.7547, 6.6416> }
			triangle { <-14.6925, 97.6945, 12.7499>, <-8.6849, 94.4348, 12.8497>, <-15.9583, 93.9114, 15.8994> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // internode
		cylinder { <-10.08699, 86.035, 14.6874>, <-11.07946, 93.2601, 17.6364>, 0.6 }
		cylinder { <-11.07946, 93.2601, 17.6364>, <-11.3398, 100.6263, 20.3853>, 0.6 }
		cylinder { <-11.3398, 100.6263, 20.3853>, <-10.8655, 108.0626, 22.9074>, 0.6 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.8655, 108.0626, 22.9074>, <-9.8066, 110.4512, 23.4065>, 0.2536 }
			cylinder { <-9.8066, 110.4512, 23.4065>, <-7.9912, 112.3938, 23.485>, 0.2536 }
			cylinder { <-7.9912, 112.3938, 23.485>, <-5.6624, 113.63, 23.1325>, 0.2536 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-5.6624, 113.63, 23.1325>, <-0.71, 118.9079, 18.6588>, <0.6864, 116.9034, 22.3592> }
			triangle { <0.6864, 116.9034, 22.3592>, <-0.71, 118.9079, 18.6588>, <7.4015, 120.4852, 17.5599> }
			triangle { <0.6864, 116.9034, 22.3592>, <7.4015, 120.4852, 17.5599>, <8.5014, 117.8953, 20.2593> }
			triangle { <7.4015, 120.4852, 17.5599>, <15.5433, 118.6808, 18.35>, <8.5014, 117.8953, 20.2593> }
			triangle { <0.6864, 116.9034, 22.3592>, <1.5868, 117.0933, 27.4679>, <-5.6624, 113.63, 23.1325> }
			triangle { <1.5868, 117.0933, 27.4679>, <0.6864, 116.9034, 22.3592>, <8.5014, 117.8953, 20.2593> }
			triangle { <9.6945, 117.8997, 23.6404>, <1.5868, 117.0933, 27.4679>, <8.5014, 117.8953, 20.2593> }
			triangle { <9.6945, 117.8997, 23.6404>, <8.5014, 117.8953, 20.2593>, <15.5433, 118.6808, 18.35> }
			triangle { <15.5433, 118.6808, 18.35>, <24.9091, 115.6974, 14.06002>, <9.6945, 117.8997, 23.6404> }
			triangle { <7.4015, 120.4852, 17.5599>, <24.9091, 115.6974, 14.06002>, <15.5433, 118.6808, 18.35> }
			triangle { <1.5868, 117.0933, 27.4679>, <-5.1578, 116.2716, 29.7078>, <-5.6624, 113.63, 23.1325> }
			triangle { <-5.1578, 116.2716, 29.7078>, <-8.9092, 114.7751, 29.7858>, <-5.6624, 113.63, 23.1325> }
			triangle { <-5.6624, 113.63, 23.1325>, <-7.962, 118.5159, 20.5593>, <-0.71, 118.9079, 18.6588> }
			triangle { <-7.962, 118.5159, 20.5593>, <-5.6624, 113.63, 23.1325>, <-11.7696, 116.6116, 21.8465> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.8655, 108.0626, 22.9074>, <-11.6251, 110.3661, 23.9996>, 0.2536 }
			cylinder { <-11.6251, 110.3661, 23.9996>, <-13.2029, 112.1497, 25.1848>, 0.2536 }
			cylinder { <-13.2029, 112.1497, 25.1848>, <-15.3875, 113.1746, 26.3042>, 0.2536 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-15.3875, 113.1746, 26.3042>, <-19.8753, 115.1819, 33.2488>, <-21.3471, 116.0061, 29.1481> }
			triangle { <-21.3471, 116.0061, 29.1481>, <-19.8753, 115.1819, 33.2488>, <-27.7906, 116.682, 35.3914> }
			triangle { <-21.3471, 116.0061, 29.1481>, <-27.7906, 116.682, 35.3914>, <-29.07339, 116.4048, 31.7196> }
			triangle { <-27.7906, 116.682, 35.3914>, <-36.04837, 116.6685, 33.9847>, <-29.07339, 116.4048, 31.7196> }
			triangle { <-21.3471, 116.0061, 29.1481>, <-22.02186, 119.3548, 25.2396>, <-15.3875, 113.1746, 26.3042> }
			triangle { <-22.02186, 119.3548, 25.2396>, <-21.3471, 116.0061, 29.1481>, <-29.07339, 116.4048, 31.7196> }
			triangle { <-30.1266, 118.5937, 29.08243>, <-22.02186, 119.3548, 25.2396>, <-29.07339, 116.4048, 31.7196> }
			triangle { <-30.1266, 118.5937, 29.08243>, <-29.07339, 116.4048, 31.7196>, <-36.04837, 116.6685, 33.9847> }
			triangle { <-36.04837, 116.6685, 33.9847>, <-45.852, 112.7873, 35.9466>, <-30.1266, 118.5937, 29.08243> }
			triangle { <-27.7906, 116.682, 35.3914>, <-45.852, 112.7873, 35.9466>, <-36.04837, 116.6685, 33.9847> }
			triangle { <-22.02186, 119.3548, 25.2396>, <-15.3332, 119.2969, 22.7013>, <-15.3875, 113.1746, 26.3042> }
			triangle { <-15.3332, 119.2969, 22.7013>, <-11.7766, 117.7387, 21.5873>, <-15.3875, 113.1746, 26.3042> }
			triangle { <-15.3875, 113.1746, 26.3042>, <-12.6472, 115.1986, 31.221>, <-19.8753, 115.1819, 33.2488> }
			triangle { <-12.6472, 115.1986, 31.221>, <-15.3875, 113.1746, 26.3042>, <-9.03466, 114.0459, 28.8969> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // internode
		cylinder { <-10.8655, 108.0626, 22.9074>, <-11.09521, 115.605, 25.1308>, 0.6 }
		cylinder { <-11.09521, 115.605, 25.1308>, <-12.02657, 123.181, 27.03413>, 0.6 }
		cylinder { <-12.02657, 123.181, 27.03413>, <-13.6506, 130.7174, 28.599>, 0.6 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-13.6506, 130.7174, 28.599>, <-14.4453, 132.049, 28.6364>, 0.1478 }
			cylinder { <-14.4453, 132.049, 28.6364>, <-15.6079, 133.0477, 28.3976>, 0.1478 }
			cylinder { <-15.6079, 133.0477, 28.3976>, <-16.9825, 133.5797, 27.9147>, 0.1478 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-16.9825, 133.5797, 27.9147>, <-21.7247, 134.7121, 28.8356>, <-20.6465, 135.0474, 26.5095> }
			triangle { <-20.6465, 135.0474, 26.5095>, <-21.7247, 134.7121, 28.8356>, <-25.8852, 135.3131, 26.3945> }
			triangle { <-20.6465, 135.0474, 26.5095>, <-25.8852, 135.3131, 26.3945>, <-24.8917, 135.0246, 24.3697> }
			triangle { <-25.8852, 135.3131, 26.3945>, <-28.6996, 134.9468, 22.4189>, <-24.8917, 135.0246, 24.3697> }
			triangle { <-20.6465, 135.0474, 26.5095>, <-19.3539, 136.8862, 24.482>, <-16.9825, 133.5797, 27.9147> }
			triangle { <-19.3539, 136.8862, 24.482>, <-20.6465, 135.0474, 26.5095>, <-24.8917, 135.0246, 24.3697> }
			triangle { <-24.2646, 136.2004, 22.7586>, <-19.3539, 136.8862, 24.482>, <-24.8917, 135.0246, 24.3697> }
			triangle { <-24.2646, 136.2004, 22.7586>, <-24.8917, 135.0246, 24.3697>, <-28.6996, 134.9468, 22.4189> }
			triangle { <-28.6996, 134.9468, 22.4189>, <-33.4897, 132.3402, 19.3573>, <-24.2646, 136.2004, 22.7586> }
			triangle { <-25.8852, 135.3131, 26.3945>, <-33.4897, 132.3402, 19.3573>, <-28.6996, 134.9468, 22.4189> }
			triangle { <-19.3539, 136.8862, 24.482>, <-15.5537, 137.0665, 26.1938>, <-16.9825, 133.5797, 27.9147> }
			triangle { <-15.5537, 137.0665, 26.1938>, <-13.6099, 136.2792, 27.2664>, <-16.9825, 133.5797, 27.9147> }
			triangle { <-16.9825, 133.5797, 27.9147>, <-17.9145, 134.9679, 30.976>, <-21.7247, 134.7121, 28.8356> }
			triangle { <-17.9145, 134.9679, 30.976>, <-16.9825, 133.5797, 27.9147>, <-15.4531, 134.3934, 31.557> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-13.6506, 130.7174, 28.599>, <-13.4535, 132.1587, 29.1373>, 0.1478 }
			cylinder { <-13.4535, 132.1587, 29.1373>, <-12.7655, 133.3621, 29.8333>, 0.1478 }
			cylinder { <-12.7655, 133.3621, 29.8333>, <-11.6788, 134.1664, 30.5937>, 0.1478 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-11.6788, 134.1664, 30.5937>, <-7.8645, 137.3394, 30.5669>, <-8.7924, 136.3065, 32.7481> }
			triangle { <-8.7924, 136.3065, 32.7481>, <-7.8645, 137.3394, 30.5669>, <-4.09594, 138.557, 33.3856> }
			triangle { <-8.7924, 136.3065, 32.7481>, <-4.09594, 138.557, 33.3856>, <-4.7242, 137.1512, 35.05862> }
			triangle { <-4.09594, 138.557, 33.3856>, <-1.05001, 137.849, 37.1381>, <-4.7242, 137.1512, 35.05862> }
			triangle { <-8.7924, 136.3065, 32.7481>, <-10.5356, 136.559, 35.2098>, <-11.6788, 134.1664, 30.5937> }
			triangle { <-10.5356, 136.559, 35.2098>, <-8.7924, 136.3065, 32.7481>, <-4.7242, 137.1512, 35.05862> }
			triangle { <-5.6307, 137.2716, 36.9388>, <-10.5356, 136.559, 35.2098>, <-4.7242, 137.1512, 35.05862> }
			triangle { <-5.6307, 137.2716, 36.9388>, <-4.7242, 137.1512, 35.05862>, <-1.05001, 137.849, 37.1381> }
			triangle { <-1.05001, 137.849, 37.1381>, <4.6143, 136.3988, 39.3573>, <-5.6307, 137.2716, 36.9388> }
			triangle { <-4.09594, 138.557, 33.3856>, <4.6143, 136.3988, 39.3573>, <-1.05001, 137.849, 37.1381> }
			triangle { <-10.5356, 136.559, 35.2098>, <-14.2238, 135.8589, 33.39>, <-11.6788, 134.1664, 30.5937> }
			triangle { <-14.2238, 135.8589, 33.39>, <-15.7786, 134.8409, 31.9426>, <-11.6788, 134.1664, 30.5937> }
			triangle { <-11.6788, 134.1664, 30.5937>, <-11.6268, 136.8618, 28.3804>, <-7.8645, 137.3394, 30.5669> }
			triangle { <-11.6268, 136.8618, 28.3804>, <-11.6788, 134.1664, 30.5937>, <-13.6989, 135.6296, 27.4243> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // internode
		cylinder { <-13.6506, 130.7174, 28.599>, <-14.4131, 137.7541, 32.03239>, 0.6 }
		cylinder { <-14.4131, 137.7541, 32.03239>, <-14.2587, 143.7813, 37.08551>, 0.6 }
		cylinder { <-14.2587, 143.7813, 37.08551>, <-13.1986, 148.3622, 43.3922>, 0.6 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-13.1986, 148.3622, 43.3922>, <-13.05183, 148.5049, 43.8864>, 0.051 }
			cylinder { <-13.05183, 148.5049, 43.8864>, <-12.8499, 148.4597, 44.3797>, 0.051 }
			cylinder { <-12.8499, 148.4597, 44.3797>, <-12.62, 148.2326, 44.806>, 0.051 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-12.62, 148.2326, 44.806>, <-11.2311, 147.9304, 45.7587>, <-12.03535, 147.6089, 45.9708> }
			triangle { <-12.03535, 147.6089, 45.9708>, <-11.2311, 147.9304, 45.7587>, <-10.6931, 146.8139, 46.8876> }
			triangle { <-12.03535, 147.6089, 45.9708>, <-10.6931, 146.8139, 46.8876>, <-11.3768, 146.4301, 46.9008> }
			triangle { <-10.6931, 146.8139, 46.8876>, <-10.7898, 145.3542, 47.7229>, <-11.3768, 146.4301, 46.9008> }
			triangle { <-12.03535, 147.6089, 45.9708>, <-12.9115, 147.6834, 46.5334>, <-12.62, 148.2326, 44.806> }
			triangle { <-12.9115, 147.6834, 46.5334>, <-12.03535, 147.6089, 45.9708>, <-11.3768, 146.4301, 46.9008> }
			triangle { <-11.9524, 146.3715, 47.3311>, <-12.9115, 147.6834, 46.5334>, <-11.3768, 146.4301, 46.9008> }
			triangle { <-11.9524, 146.3715, 47.3311>, <-11.3768, 146.4301, 46.9008>, <-10.7898, 145.3542, 47.7229> }
			triangle { <-10.7898, 145.3542, 47.7229>, <-10.04937, 143.3696, 48.1291>, <-11.9524, 146.3715, 47.3311> }
			triangle { <-10.6931, 146.8139, 46.8876>, <-10.04937, 143.3696, 48.1291>, <-10.7898, 145.3542, 47.7229> }
			triangle { <-12.9115, 147.6834, 46.5334>, <-13.5534, 148.721, 45.771>, <-12.62, 148.2326, 44.806> }
			triangle { <-13.5534, 148.721, 45.771>, <-13.7925, 149.1283, 45.11>, <-12.62, 148.2326, 44.806> }
			triangle { <-12.62, 148.2326, 44.806>, <-11.7872, 149.0864, 44.9627>, <-11.2311, 147.9304, 45.7587> }
			triangle { <-11.7872, 149.0864, 44.9627>, <-12.62, 148.2326, 44.806>, <-12.2802, 149.4986, 44.3406> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-13.1986, 148.3622, 43.3922>, <-13.2109, 148.8008, 43.6983>, 0.051 }
			cylinder { <-13.2109, 148.8008, 43.6983>, <-13.306, 149.3076, 43.8405>, 0.051 }
			cylinder { <-13.306, 149.3076, 43.8405>, <-13.4711, 149.8148, 43.7999>, 0.051 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-13.4711, 149.8148, 43.7999>, <-14.6511, 151.0195, 44.08979>, <-13.8808, 151.1949, 43.6763> }
			triangle { <-13.8808, 151.1949, 43.6763>, <-14.6511, 151.0195, 44.08979>, <-15.1009, 152.5173, 43.4857> }
			triangle { <-13.8808, 151.1949, 43.6763>, <-15.1009, 152.5173, 43.4857>, <-14.4994, 152.5459, 42.9835> }
			triangle { <-15.1009, 152.5173, 43.4857>, <-15.05636, 153.7518, 42.3404>, <-14.4994, 152.5459, 42.9835> }
			triangle { <-13.8808, 151.1949, 43.6763>, <-12.9032, 151.5587, 43.7172>, <-13.4711, 149.8148, 43.7999> }
			triangle { <-12.9032, 151.5587, 43.7172>, <-13.8808, 151.1949, 43.6763>, <-14.4994, 152.5459, 42.9835> }
			triangle { <-13.861, 152.8762, 42.9273>, <-12.9032, 151.5587, 43.7172>, <-14.4994, 152.5459, 42.9835> }
			triangle { <-13.861, 152.8762, 42.9273>, <-14.4994, 152.5459, 42.9835>, <-15.05636, 153.7518, 42.3404> }
			triangle { <-15.05636, 153.7518, 42.3404>, <-15.9936, 154.8859, 40.7634>, <-13.861, 152.8762, 42.9273> }
			triangle { <-15.1009, 152.5173, 43.4857>, <-15.9936, 154.8859, 40.7634>, <-15.05636, 153.7518, 42.3404> }
			triangle { <-12.9032, 151.5587, 43.7172>, <-12.2864, 150.4121, 44.3296>, <-13.4711, 149.8148, 43.7999> }
			triangle { <-12.2864, 150.4121, 44.3296>, <-12.1349, 149.6264, 44.4696>, <-13.4711, 149.8148, 43.7999> }
			triangle { <-13.4711, 149.8148, 43.7999>, <-14.1058, 149.817, 44.8217>, <-14.6511, 151.0195, 44.08979> }
			triangle { <-14.1058, 149.817, 44.8217>, <-13.4711, 149.8148, 43.7999>, <-13.7005, 149.0261, 44.9225> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // internode
		cylinder { <-13.1986, 148.3622, 43.3922>, <-12.02063, 153.0697, 48.7263>, 0.55 }
		cylinder { <-12.02063, 153.0697, 48.7263>, <-10.6476, 158.24, 53.5619>, 0.55 }
		cylinder { <-10.6476, 158.24, 53.5619>, <-9.09292, 163.8234, 57.8524>, 0.55 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.09292, 163.8234, 57.8524>, <-8.9378, 164.3151, 57.9952>, 0.051 }
			cylinder { <-8.9378, 164.3151, 57.9952>, <-8.7638, 164.8183, 57.9435>, 0.051 }
			cylinder { <-8.7638, 164.8183, 57.9435>, <-8.5941, 165.2656, 57.7041>, 0.051 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-8.5941, 165.2656, 57.7041>, <-8.9096, 166.8295, 57.08572>, <-8.09825, 166.4605, 57.06088> }
			triangle { <-8.09825, 166.4605, 57.06088>, <-8.9096, 166.8295, 57.08572>, <-8.2472, 167.9106, 55.9889> }
			triangle { <-8.09825, 166.4605, 57.06088>, <-8.2472, 167.9106, 55.9889>, <-7.626, 167.4542, 55.8452> }
			triangle { <-8.2472, 167.9106, 55.9889>, <-7.2014, 168.3315, 54.7372>, <-7.626, 167.4542, 55.8452> }
			triangle { <-8.09825, 166.4605, 57.06088>, <-7.1429, 166.3656, 57.4708>, <-8.5941, 165.2656, 57.7041> }
			triangle { <-7.1429, 166.3656, 57.4708>, <-8.09825, 166.4605, 57.06088>, <-7.626, 167.4542, 55.8452> }
			triangle { <-6.927, 167.4265, 56.02005>, <-7.1429, 166.3656, 57.4708>, <-7.626, 167.4542, 55.8452> }
			triangle { <-6.927, 167.4265, 56.02005>, <-7.626, 167.4542, 55.8452>, <-7.2014, 168.3315, 54.7372> }
			triangle { <-7.2014, 168.3315, 54.7372>, <-6.8585, 168.8751, 52.6783>, <-6.927, 167.4265, 56.02005> }
			triangle { <-8.2472, 167.9106, 55.9889>, <-6.8585, 168.8751, 52.6783>, <-7.2014, 168.3315, 54.7372> }
			triangle { <-7.1429, 166.3656, 57.4708>, <-7.479, 165.4961, 58.5668>, <-8.5941, 165.2656, 57.7041> }
			triangle { <-7.479, 165.4961, 58.5668>, <-7.8439, 164.8815, 58.9528>, <-8.5941, 165.2656, 57.7041> }
			triangle { <-8.5941, 165.2656, 57.7041>, <-9.3655, 166.0007, 58.2623>, <-8.9096, 166.8295, 57.08572> }
			triangle { <-9.3655, 166.0007, 58.2623>, <-8.5941, 165.2656, 57.7041>, <-9.5252, 165.26, 58.7375> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.09292, 163.8234, 57.8524>, <-9.03277, 164.1047, 58.3034>, 0.051 }
			cylinder { <-9.03277, 164.1047, 58.3034>, <-9.03588, 164.2153, 58.8268>, 0.051 }
			cylinder { <-9.03588, 164.2153, 58.8268>, <-9.1018, 164.1404, 59.3523>, 0.051 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-9.1018, 164.1404, 59.3523>, <-8.4522, 163.7765, 60.8929>, <-9.3177, 163.9511, 60.7684> }
			triangle { <-9.3177, 163.9511, 60.7684>, <-8.4522, 163.7765, 60.8929>, <-8.9734, 163.2023, 62.3792> }
			triangle { <-9.3177, 163.9511, 60.7684>, <-8.9734, 163.2023, 62.3792>, <-9.7261, 163.1865, 62.16> }
			triangle { <-8.9734, 163.2023, 62.3792>, <-10.1026, 162.4819, 63.4008>, <-9.7261, 163.1865, 62.16> }
			triangle { <-9.3177, 163.9511, 60.7684>, <-10.1107, 164.6289, 60.8063>, <-9.1018, 164.1404, 59.3523> }
			triangle { <-10.1107, 164.6289, 60.8063>, <-9.3177, 163.9511, 60.7684>, <-9.7261, 163.1865, 62.16> }
			triangle { <-10.3245, 163.5754, 62.2628>, <-10.1107, 164.6289, 60.8063>, <-9.7261, 163.1865, 62.16> }
			triangle { <-10.3245, 163.5754, 62.2628>, <-9.7261, 163.1865, 62.16>, <-10.1026, 162.4819, 63.4008> }
			triangle { <-10.1026, 162.4819, 63.4008>, <-10.7603, 160.8076, 64.5908>, <-10.3245, 163.5754, 62.2628> }
			triangle { <-8.9734, 163.2023, 62.3792>, <-10.7603, 160.8076, 64.5908>, <-10.1026, 162.4819, 63.4008> }
			triangle { <-10.1107, 164.6289, 60.8063>, <-9.815, 165.3534, 59.599>, <-9.1018, 164.1404, 59.3523> }
			triangle { <-9.815, 165.3534, 59.599>, <-9.5902, 165.4649, 58.8263>, <-9.1018, 164.1404, 59.3523> }
			triangle { <-9.1018, 164.1404, 59.3523>, <-8.01349, 164.5434, 59.6688>, <-8.4522, 163.7765, 60.8929> }
			triangle { <-8.01349, 164.5434, 59.6688>, <-9.1018, 164.1404, 59.3523>, <-7.994, 164.7806, 58.8066> }
			pigment { color rgb <0.19, 0.79, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-9.09292, 163.8234, 57.8524>, <-9.05052, 163.9757, 57.9694>, 0.3 }
			cylinder { <-9.05052, 163.9757, 57.9694>, <-9.008119, 164.128, 58.08643>, 0.3 }
			cylinder { <-9.008119, 164.128, 58.08643>, <-8.9657, 164.2803, 58.2034>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // inflor. internode
			cylinder { <-8.9657, 164.2803, 58.2034>, <-8.6265, 165.4985, 59.1395>, 0.3 }
			cylinder { <-8.6265, 165.4985, 59.1395>, <-8.2872, 166.7167, 60.07565>, 0.3 }
			cylinder { <-8.2872, 166.7167, 60.07565>, <-7.948, 167.9349, 61.01175>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-7.948, 167.9349, 61.01175>, <-6.9032, 170.2512, 62.8676>, 0.3 }
				cylinder { <-6.9032, 170.2512, 62.8676>, <-5.5077, 172.4127, 64.6793>, 0.3 }
				cylinder { <-5.5077, 172.4127, 64.6793>, <-3.7825, 174.3867, 66.4196>, 0.3 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-3.7825, 174.3867, 66.4196>, <-0.5126, 179.0961, 68.7175>, <-0.9472, 178.4786, 69.8487> }
					triangle { <-0.5126, 179.0961, 68.7175>, <-1.4019, 183.317, 66.7315>, <-0.9472, 178.4786, 69.8487> }
					triangle { <-0.5126, 179.0961, 68.7175>, <-0.6155, 182.4655, 66.6619>, <-1.4019, 183.317, 66.7315> }
					triangle { <-1.4019, 183.317, 66.7315>, <-2.1404, 182.9997, 67.3115>, <-0.9472, 178.4786, 69.8487> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-3.7825, 174.3867, 66.4196>, <-1.5966, 178.9758, 69.9285>, <-0.7349, 177.9651, 70.2208> }
					triangle { <-1.5966, 178.9758, 69.9285>, <-4.8756, 181.324, 72.4357>, <-0.7349, 177.9651, 70.2208> }
					triangle { <-1.5966, 178.9758, 69.9285>, <-4.2765, 181.4451, 71.4484>, <-4.8756, 181.324, 72.4357> }
					triangle { <-4.8756, 181.324, 72.4357>, <-4.7016, 180.4128, 72.7849>, <-0.7349, 177.9651, 70.2208> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-3.7825, 174.3867, 66.4196>, <-1.1522, 177.7385, 70.8915>, <-0.177, 177.7218, 69.9437> }
					triangle { <-1.1522, 177.7385, 70.8915>, <-1.5207, 175.9052, 75.2567>, <-0.177, 177.7218, 69.9437> }
					triangle { <-1.1522, 177.7385, 70.8915>, <-2.03785, 176.7108, 74.5994>, <-1.5207, 175.9052, 75.2567> }
					triangle { <-1.5207, 175.9052, 75.2567>, <-0.8862, 175.407, 74.6807>, <-0.177, 177.7218, 69.9437> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-3.7825, 174.3867, 66.4196>, <0.2105, 177.0824, 70.2847>, <-0.03932, 178.0827, 69.3978> }
					triangle { <0.2105, 177.0824, 70.2847>, <4.05756, 174.4986, 71.3222>, <-0.03932, 178.0827, 69.3978> }
					triangle { <0.2105, 177.0824, 70.2847>, <3.0275, 174.7609, 71.7897>, <4.05756, 174.4986, 71.3222> }
					triangle { <4.05756, 174.4986, 71.3222>, <4.06856, 174.8534, 70.3967>, <-0.03932, 178.0827, 69.3978> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-3.7825, 174.3867, 66.4196>, <0.6118, 177.9341, 68.9208>, <-0.5225, 178.5575, 69.3382> }
					triangle { <0.6118, 177.9341, 68.9208>, <4.132, 179.1485, 65.9738>, <-0.5225, 178.5575, 69.3382> }
					triangle { <0.6118, 177.9341, 68.9208>, <3.9197, 178.3712, 66.8099>, <4.132, 179.1485, 65.9738> }
					triangle { <4.132, 179.1485, 65.9738>, <3.2817, 179.6168, 65.7735>, <-0.5225, 178.5575, 69.3382> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				}
			}
		union { // inflor. internode
			cylinder { <-7.948, 167.9349, 61.01175>, <-7.6088, 169.1531, 61.9478>, 0.3 }
			cylinder { <-7.6088, 169.1531, 61.9478>, <-7.2696, 170.3713, 62.8839>, 0.3 }
			cylinder { <-7.2696, 170.3713, 62.8839>, <-6.9304, 171.5895, 63.82>, 0.3 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-6.9304, 171.5895, 63.82>, <-6.4928, 174.2317, 65.4719>, 0.3 }
				cylinder { <-6.4928, 174.2317, 65.4719>, <-6.3027, 177.04, 66.8786>, 0.3 }
				cylinder { <-6.3027, 177.04, 66.8786>, <-6.3629, 179.9722, 68.01893>, 0.3 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-6.3629, 179.9722, 68.01893>, <-7.3261, 185.1652, 71.2213>, <-6.1312, 185.4218, 70.6247> }
					triangle { <-7.3261, 185.1652, 71.2213>, <-8.6752, 184.5241, 75.7292>, <-6.1312, 185.4218, 70.6247> }
					triangle { <-7.3261, 185.1652, 71.2213>, <-9.1532, 184.7633, 74.6983>, <-8.6752, 184.5241, 75.7292> }
					triangle { <-8.6752, 184.5241, 75.7292>, <-7.7221, 184.2995, 75.5755>, <-6.1312, 185.4218, 70.6247> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-6.3629, 179.9722, 68.01893>, <-5.6974, 185.1766, 71.2781>, <-5.9388, 185.6574, 70.02911> }
					triangle { <-5.6974, 185.1766, 71.2781>, <-1.9254, 185.2723, 74.1616>, <-5.9388, 185.6574, 70.02911> }
					triangle { <-5.6974, 185.1766, 71.2781>, <-3.06794, 185.0735, 74.2216>, <-1.9254, 185.2723, 74.1616> }
					triangle { <-1.9254, 185.2723, 74.1616>, <-1.6814, 185.3459, 73.2038>, <-5.9388, 185.6574, 70.02911> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-6.3629, 179.9722, 68.01893>, <-5.1402, 185.7416, 69.8547>, <-6.4865, 185.7867, 69.6678> }
					triangle { <-5.1402, 185.7416, 69.8547>, <-1.4525, 187.8011, 67.6841>, <-6.4865, 185.7867, 69.6678> }
					triangle { <-5.1402, 185.7416, 69.8547>, <-1.6876, 187.2562, 68.6822>, <-1.4525, 187.8011, 67.6841> }
					triangle { <-1.4525, 187.8011, 67.6841>, <-2.2451, 187.7096, 67.09605>, <-6.4865, 185.7867, 69.6678> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-6.3629, 179.9722, 68.01893>, <-6.4193, 186.0847, 68.9049>, <-7.02255, 185.6322, 70.03675> }
					triangle { <-6.4193, 186.0847, 68.9049>, <-7.9057, 188.6394, 65.188>, <-7.02255, 185.6322, 70.03675> }
					triangle { <-6.4193, 186.0847, 68.9049>, <-6.9069, 188.3152, 65.6837>, <-7.9057, 188.6394, 65.188> }
					triangle { <-7.9057, 188.6394, 65.188>, <-8.6395, 188.1462, 65.636>, <-7.02255, 185.6322, 70.03675> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				mesh { // flower petal
					triangle { <-6.3629, 179.9722, 68.01893>, <-7.7906, 185.7231, 69.7623>, <-6.7996, 185.4033, 70.637> }
					triangle { <-7.7906, 185.7231, 69.7623>, <-12.4369, 186.5836, 70.2351>, <-6.7996, 185.4033, 70.637> }
					triangle { <-7.7906, 185.7231, 69.7623>, <-11.5906, 186.7512, 69.4579>, <-12.4369, 186.5836, 70.2351> }
					triangle { <-12.4369, 186.5836, 70.2351>, <-12.07555, 186.0068, 70.9557>, <-6.7996, 185.4033, 70.637> }
					pigment { color rgb <0.99, 0.0, 0.5> }}
				}
			}
		}
scale 1.18
} // end wild_pink

#declare Plant5 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.004212, 0.2705, 0.005133>, 0.7188 }
		cylinder { <0.004212, 0.2705, 0.005133>, <0.01263, 0.5407, 0.01539>, 0.7188 }
		cylinder { <0.01263, 0.5407, 0.01539>, <0.02526, 0.8106, 0.03078>, 0.7188 }
		cylinder { <0.02526, 0.8106, 0.03078>, <0.04209, 1.07995, 0.05128>, 0.7188 }
		cylinder { <0.04209, 1.07995, 0.05128>, <0.0631, 1.3485, 0.07689>, 0.7188 }
		cylinder { <0.0631, 1.3485, 0.07689>, <0.08829, 1.6161, 0.1075>, 0.7188 }
		cylinder { <0.08829, 1.6161, 0.1075>, <0.1176, 1.8828, 0.1433>, 0.7188 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // internode
		cylinder { <0.1176, 1.8828, 0.1433>, <0.1211, 1.9147, 0.1468>, 0.08575 }
		cylinder { <0.1211, 1.9147, 0.1468>, <0.1247, 1.9466, 0.1495>, 0.08575 }
		cylinder { <0.1247, 1.9466, 0.1495>, <0.1283, 1.9786, 0.1514>, 0.08575 }
		cylinder { <0.1283, 1.9786, 0.1514>, <0.132, 2.01074, 0.1525>, 0.08575 }
		cylinder { <0.132, 2.01074, 0.1525>, <0.1357, 2.0428, 0.1528>, 0.08575 }
		cylinder { <0.1357, 2.0428, 0.1528>, <0.1394, 2.07486, 0.1523>, 0.08575 }
		cylinder { <0.1394, 2.07486, 0.1523>, <0.1432, 2.1069, 0.1511>, 0.08575 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.1432, 2.1069, 0.1511>, <1.3802, 13.3448, 1.6584>, 0.897 }
			cylinder { <1.3802, 13.3448, 1.6584>, <2.4899, 24.1703, 5.0748>, 0.897 }
			cylinder { <2.4899, 24.1703, 5.0748>, <3.4395, 34.2646, 10.2995>, 0.897 }
			cylinder { <3.4395, 34.2646, 10.2995>, <4.2011, 43.3304, 17.1788>, 0.897 }
			cylinder { <4.2011, 43.3304, 17.1788>, <4.7522, 51.1009, 25.51>, 0.897 }
			cylinder { <4.7522, 51.1009, 25.51>, <5.07671, 57.3472, 35.04805>, 0.897 }
			cylinder { <5.07671, 57.3472, 35.04805>, <5.1649, 61.8854, 45.5118>, 0.897 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <5.1649, 61.8854, 45.5118>, <11.6667, 53.7104, 39.5552>, <18.3465, 60.4072, 48.3091> }
			triangle { <5.1649, 61.8854, 45.5118>, <18.3465, 60.4072, 48.3091>, <17.05054, 65.3008, 56.4007> }
			triangle { <11.6667, 53.7104, 39.5552>, <17.7974, 50.6924, 38.5451>, <18.3465, 60.4072, 48.3091> }
			triangle { <17.7974, 50.6924, 38.5451>, <21.8524, 52.08837, 44.7075>, <18.3465, 60.4072, 48.3091> }
			triangle { <21.8524, 52.08837, 44.7075>, <23.2296, 55.9032, 54.756>, <18.3465, 60.4072, 48.3091> }
			triangle { <23.2296, 55.9032, 54.756>, <22.9946, 60.5705, 65.2042>, <17.05054, 65.3008, 56.4007> }
			triangle { <18.3465, 60.4072, 48.3091>, <23.2296, 55.9032, 54.756>, <17.05054, 65.3008, 56.4007> }
			triangle { <17.05054, 65.3008, 56.4007>, <17.02792, 67.2918, 66.4962>, <10.149, 69.8692, 63.9248> }
			triangle { <17.02792, 67.2918, 66.4962>, <16.6871, 66.7199, 75.06077>, <11.7332, 70.7321, 72.9845> }
			triangle { <17.02792, 67.2918, 66.4962>, <11.7332, 70.7321, 72.9845>, <10.149, 69.8692, 63.9248> }
			triangle { <10.149, 69.8692, 63.9248>, <11.7332, 70.7321, 72.9845>, <4.9977, 71.6172, 70.3901> }
			triangle { <16.6871, 66.7199, 75.06077>, <8.1447, 69.2854, 83.8453>, <11.7332, 70.7321, 72.9845> }
			triangle { <11.7332, 70.7321, 72.9845>, <8.1447, 69.2854, 83.8453>, <4.9977, 71.6172, 70.3901> }
			triangle { <5.1649, 61.8854, 45.5118>, <17.05054, 65.3008, 56.4007>, <5.4999, 66.8922, 55.43> }
			triangle { <5.4999, 66.8922, 55.43>, <17.05054, 65.3008, 56.4007>, <10.149, 69.8692, 63.9248> }
			triangle { <5.4999, 66.8922, 55.43>, <10.149, 69.8692, 63.9248>, <5.5669, 70.3406, 63.3811> }
			triangle { <10.149, 69.8692, 63.9248>, <4.9977, 71.6172, 70.3901>, <5.5669, 70.3406, 63.3811> }
			triangle { <22.9946, 60.5705, 65.2042>, <17.02792, 67.2918, 66.4962>, <17.05054, 65.3008, 56.4007> }
			triangle { <22.9946, 60.5705, 65.2042>, <16.6871, 66.7199, 75.06077>, <17.02792, 67.2918, 66.4962> }
			triangle { <-6.2405, 69.1688, 44.7165>, <-3.2149, 59.01352, 37.3807>, <5.1649, 61.8854, 45.5118> }
			triangle { <-4.3013, 72.9095, 53.2808>, <-6.2405, 69.1688, 44.7165>, <5.1649, 61.8854, 45.5118> }
			triangle { <-6.2405, 69.1688, 44.7165>, <-9.3777, 60.3762, 34.5743>, <-3.2149, 59.01352, 37.3807> }
			triangle { <-6.2405, 69.1688, 44.7165>, <-13.08708, 64.5389, 39.6023>, <-9.3777, 60.3762, 34.5743> }
			triangle { <-6.2405, 69.1688, 44.7165>, <-14.298, 69.2761, 49.2726>, <-13.08708, 64.5389, 39.6023> }
			triangle { <-4.3013, 72.9095, 53.2808>, <-13.8859, 73.7128, 59.8153>, <-14.298, 69.2761, 49.2726> }
			triangle { <-4.3013, 72.9095, 53.2808>, <-14.298, 69.2761, 49.2726>, <-6.2405, 69.1688, 44.7165> }
			triangle { <1.7376, 72.8665, 62.6958>, <-4.746, 77.4367, 62.2799>, <-4.3013, 72.9095, 53.2808> }
			triangle { <-1.3318, 75.04701, 71.2233>, <-7.8998, 75.4814, 71.4681>, <-4.746, 77.4367, 62.2799> }
			triangle { <1.7376, 72.8665, 62.6958>, <-1.3318, 75.04701, 71.2233>, <-4.746, 77.4367, 62.2799> }
			triangle { <4.9977, 71.6172, 70.3901>, <-1.3318, 75.04701, 71.2233>, <1.7376, 72.8665, 62.6958> }
			triangle { <-1.3318, 75.04701, 71.2233>, <-2.0831, 73.2709, 82.203>, <-7.8998, 75.4814, 71.4681> }
			triangle { <4.9977, 71.6172, 70.3901>, <-2.0831, 73.2709, 82.203>, <-1.3318, 75.04701, 71.2233> }
			triangle { <5.4999, 66.8922, 55.43>, <-4.3013, 72.9095, 53.2808>, <5.1649, 61.8854, 45.5118> }
			triangle { <1.7376, 72.8665, 62.6958>, <-4.3013, 72.9095, 53.2808>, <5.4999, 66.8922, 55.43> }
			triangle { <5.5669, 70.3406, 63.3811>, <1.7376, 72.8665, 62.6958>, <5.4999, 66.8922, 55.43> }
			triangle { <5.5669, 70.3406, 63.3811>, <4.9977, 71.6172, 70.3901>, <1.7376, 72.8665, 62.6958> }
			triangle { <-4.3013, 72.9095, 53.2808>, <-4.746, 77.4367, 62.2799>, <-13.8859, 73.7128, 59.8153> }
			triangle { <-4.746, 77.4367, 62.2799>, <-7.8998, 75.4814, 71.4681>, <-13.8859, 73.7128, 59.8153> }
			triangle { <4.9977, 71.6172, 70.3901>, <8.1447, 69.2854, 83.8453>, <3.0958, 71.5643, 83.2774> }
			triangle { <8.1447, 69.2854, 83.8453>, <0.8937, 68.2976, 90.381>, <3.0958, 71.5643, 83.2774> }
			triangle { <4.9977, 71.6172, 70.3901>, <3.0958, 71.5643, 83.2774>, <-2.0831, 73.2709, 82.203> }
			triangle { <3.0958, 71.5643, 83.2774>, <0.8937, 68.2976, 90.381>, <-2.0831, 73.2709, 82.203> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <0.1432, 2.1069, 0.1511>, <0.2947, 3.3982, 0.1002>, 0.3888 }
			cylinder { <0.2947, 3.3982, 0.1002>, <0.4462, 4.6895, 0.04935>, 0.3888 }
			cylinder { <0.4462, 4.6895, 0.04935>, <0.5977, 5.9808, -0.001522>, 0.3888 }
			cylinder { <0.5977, 5.9808, -0.001522>, <0.7492, 7.2721, -0.0524>, 0.3888 }
			cylinder { <0.7492, 7.2721, -0.0524>, <0.9007, 8.5634, -0.1032>, 0.3888 }
			cylinder { <0.9007, 8.5634, -0.1032>, <1.05221, 9.8547, -0.1541>, 0.3888 }
			cylinder { <1.05221, 9.8547, -0.1541>, <1.2037, 11.146, -0.205>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.2037, 11.146, -0.205>, <2.7945, 17.2157, -1.335>, 0.3888 }
				cylinder { <2.7945, 17.2157, -1.335>, <5.1728, 22.7944, -3.3024>, 0.3888 }
				cylinder { <5.1728, 22.7944, -3.3024>, <8.2471, 27.6678, -6.03148>, 0.3888 }
				cylinder { <8.2471, 27.6678, -6.03148>, <11.8993, 31.6486, -9.4173>, 0.3888 }
				cylinder { <11.8993, 31.6486, -9.4173>, <15.989, 34.5838, -13.3299>, 0.3888 }
				cylinder { <15.989, 34.5838, -13.3299>, <20.3591, 36.3606, -17.6188>, 0.3888 }
				cylinder { <20.3591, 36.3606, -17.6188>, <24.8416, 36.9107, -22.1192>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <24.8416, 36.9107, -22.1192>, <25.2991, 36.7088, -23.03278>, <25.4294, 37.1391, -23.04251> }
					triangle { <25.2991, 36.7088, -23.03278>, <25.6982, 36.5727, -23.7083>, <25.4294, 37.1391, -23.04251> }
					triangle { <25.4294, 37.1391, -23.04251>, <25.8433, 36.9708, -23.9953>, <25.9656, 37.322, -23.8306> }
					triangle { <25.8433, 36.9708, -23.9953>, <25.4287, 37.494, -25.3047>, <25.9656, 37.322, -23.8306> }
					triangle { <25.4294, 37.1391, -23.04251>, <25.6982, 36.5727, -23.7083>, <25.8433, 36.9708, -23.9953> }
					triangle { <25.6982, 36.5727, -23.7083>, <25.2383, 37.07842, -25.4491>, <25.8433, 36.9708, -23.9953> }
					triangle { <25.8433, 36.9708, -23.9953>, <25.2383, 37.07842, -25.4491>, <25.4287, 37.494, -25.3047> }
					triangle { <25.9656, 37.322, -23.8306>, <25.4287, 37.494, -25.3047>, <25.5725, 38.09405, -25.1842> }
					triangle { <25.2383, 37.07842, -25.4491>, <25.3287, 37.3289, -26.3849>, <25.4287, 37.494, -25.3047> }
					triangle { <25.3287, 37.3289, -26.3849>, <24.6051, 38.6308, -27.6188>, <25.6075, 37.8674, -26.2335> }
					triangle { <25.4287, 37.494, -25.3047>, <25.3287, 37.3289, -26.3849>, <25.6075, 37.8674, -26.2335> }
					triangle { <25.5725, 38.09405, -25.1842>, <25.4287, 37.494, -25.3047>, <25.6075, 37.8674, -26.2335> }
					triangle { <25.5725, 38.09405, -25.1842>, <25.6075, 37.8674, -26.2335>, <25.7036, 38.4616, -26.06521> }
					triangle { <25.6075, 37.8674, -26.2335>, <24.6051, 38.6308, -27.6188>, <24.4645, 39.7156, -27.8183> }
					triangle { <25.7036, 38.4616, -26.06521>, <25.6075, 37.8674, -26.2335>, <24.4645, 39.7156, -27.8183> }
					triangle { <25.4294, 37.1391, -23.04251>, <25.6828, 37.3892, -22.7595>, <24.8416, 36.9107, -22.1192> }
					triangle { <25.4294, 37.1391, -23.04251>, <25.9505, 37.7464, -23.2176>, <25.6828, 37.3892, -22.7595> }
					triangle { <25.9656, 37.322, -23.8306>, <26.2463, 37.5195, -23.623>, <25.4294, 37.1391, -23.04251> }
					triangle { <25.9656, 37.322, -23.8306>, <25.7792, 38.5286, -24.9252>, <26.2463, 37.5195, -23.623> }
					triangle { <26.2463, 37.5195, -23.623>, <25.9505, 37.7464, -23.2176>, <25.4294, 37.1391, -23.04251> }
					triangle { <26.2463, 37.5195, -23.623>, <25.9315, 39.06856, -24.5155>, <25.9505, 37.7464, -23.2176> }
					triangle { <25.7792, 38.5286, -24.9252>, <25.9315, 39.06856, -24.5155>, <26.2463, 37.5195, -23.623> }
					triangle { <25.5725, 38.09405, -25.1842>, <25.7792, 38.5286, -24.9252>, <25.9656, 37.322, -23.8306> }
					triangle { <25.7792, 38.5286, -24.9252>, <25.9683, 39.6147, -25.3724>, <25.9315, 39.06856, -24.5155> }
					triangle { <25.8201, 39.1143, -25.8694>, <24.9876, 40.2348, -27.1377>, <25.9683, 39.6147, -25.3724> }
					triangle { <25.8201, 39.1143, -25.8694>, <25.9683, 39.6147, -25.3724>, <25.7792, 38.5286, -24.9252> }
					triangle { <25.8201, 39.1143, -25.8694>, <25.7792, 38.5286, -24.9252>, <25.5725, 38.09405, -25.1842> }
					triangle { <25.7036, 38.4616, -26.06521>, <25.8201, 39.1143, -25.8694>, <25.5725, 38.09405, -25.1842> }
					triangle { <24.4645, 39.7156, -27.8183>, <24.9876, 40.2348, -27.1377>, <25.8201, 39.1143, -25.8694> }
					triangle { <24.4645, 39.7156, -27.8183>, <25.8201, 39.1143, -25.8694>, <25.7036, 38.4616, -26.06521> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <24.8416, 36.9107, -22.1192>, <25.2329, 37.2067, -23.03791>, <25.6268, 37.2689, -22.83> }
					triangle { <25.2329, 37.2067, -23.03791>, <25.5713, 37.3917, -23.7346>, <25.6268, 37.2689, -22.83> }
					triangle { <25.6268, 37.2689, -22.83>, <26.02378, 37.631, -23.7349>, <26.311, 37.5492, -23.4588> }
					triangle { <26.02378, 37.631, -23.7349>, <26.4641, 38.9873, -24.09096>, <26.311, 37.5492, -23.4588> }
					triangle { <25.6268, 37.2689, -22.83>, <25.5713, 37.3917, -23.7346>, <26.02378, 37.631, -23.7349> }
					triangle { <25.5713, 37.3917, -23.7346>, <26.08138, 39.07689, -24.3652>, <26.02378, 37.631, -23.7349> }
					triangle { <26.02378, 37.631, -23.7349>, <26.08138, 39.07689, -24.3652>, <26.4641, 38.9873, -24.09096> }
					triangle { <26.311, 37.5492, -23.4588>, <26.4641, 38.9873, -24.09096>, <26.954, 39.00274, -23.6972> }
					triangle { <26.08138, 39.07689, -24.3652>, <26.5607, 39.7638, -24.8602>, <26.4641, 38.9873, -24.09096> }
					triangle { <26.5607, 39.7638, -24.8602>, <27.3343, 41.509, -24.5487>, <27.08701, 39.6528, -24.5417> }
					triangle { <26.4641, 38.9873, -24.09096>, <26.5607, 39.7638, -24.8602>, <27.08701, 39.6528, -24.5417> }
					triangle { <26.954, 39.00274, -23.6972>, <26.4641, 38.9873, -24.09096>, <27.08701, 39.6528, -24.5417> }
					triangle { <26.954, 39.00274, -23.6972>, <27.08701, 39.6528, -24.5417>, <27.5292, 39.6624, -24.1001> }
					triangle { <27.08701, 39.6528, -24.5417>, <27.3343, 41.509, -24.5487>, <28.06636, 42.08473, -23.9413> }
					triangle { <27.5292, 39.6624, -24.1001>, <27.08701, 39.6528, -24.5417>, <28.06636, 42.08473, -23.9413> }
					triangle { <25.6268, 37.2689, -22.83>, <25.8971, 36.9886, -22.5951>, <24.8416, 36.9107, -22.1192> }
					triangle { <25.6268, 37.2689, -22.83>, <26.4446, 37.2591, -22.785>, <25.8971, 36.9886, -22.5951> }
					triangle { <26.311, 37.5492, -23.4588>, <26.5811, 37.2885, -23.3177>, <25.6268, 37.2689, -22.83> }
					triangle { <26.311, 37.5492, -23.4588>, <27.3314, 38.8275, -23.3427>, <26.5811, 37.2885, -23.3177> }
					triangle { <26.5811, 37.2885, -23.3177>, <26.4446, 37.2591, -22.785>, <25.6268, 37.2689, -22.83> }
					triangle { <26.5811, 37.2885, -23.3177>, <27.7091, 38.6133, -22.8005>, <26.4446, 37.2591, -22.785> }
					triangle { <27.3314, 38.8275, -23.3427>, <27.7091, 38.6133, -22.8005>, <26.5811, 37.2885, -23.3177> }
					triangle { <26.954, 39.00274, -23.6972>, <27.3314, 38.8275, -23.3427>, <26.311, 37.5492, -23.4588> }
					triangle { <27.3314, 38.8275, -23.3427>, <28.3437, 39.3721, -23.0362>, <27.7091, 38.6133, -22.8005> }
					triangle { <28.01928, 39.6583, -23.6125>, <28.6015, 41.4385, -23.3912>, <28.3437, 39.3721, -23.0362> }
					triangle { <28.01928, 39.6583, -23.6125>, <28.3437, 39.3721, -23.0362>, <27.3314, 38.8275, -23.3427> }
					triangle { <28.01928, 39.6583, -23.6125>, <27.3314, 38.8275, -23.3427>, <26.954, 39.00274, -23.6972> }
					triangle { <27.5292, 39.6624, -24.1001>, <28.01928, 39.6583, -23.6125>, <26.954, 39.00274, -23.6972> }
					triangle { <28.06636, 42.08473, -23.9413>, <28.6015, 41.4385, -23.3912>, <28.01928, 39.6583, -23.6125> }
					triangle { <28.06636, 42.08473, -23.9413>, <28.01928, 39.6583, -23.6125>, <27.5292, 39.6624, -24.1001> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <24.8416, 36.9107, -22.1192>, <25.5454, 37.4107, -22.7017>, <25.7931, 37.03555, -22.6929> }
					triangle { <25.5454, 37.4107, -22.7017>, <26.07835, 37.7512, -23.1857>, <25.7931, 37.03555, -22.6929> }
					triangle { <25.7931, 37.03555, -22.6929>, <26.5442, 37.5433, -23.2273>, <26.6021, 37.1408, -23.2188> }
					triangle { <26.5442, 37.5433, -23.2273>, <27.8893, 37.9514, -22.7981>, <26.6021, 37.1408, -23.2188> }
					triangle { <25.7931, 37.03555, -22.6929>, <26.07835, 37.7512, -23.1857>, <26.5442, 37.5433, -23.2273> }
					triangle { <26.07835, 37.7512, -23.1857>, <27.774, 38.4151, -22.7601>, <26.5442, 37.5433, -23.2273> }
					triangle { <26.5442, 37.5433, -23.2273>, <27.774, 38.4151, -22.7601>, <27.8893, 37.9514, -22.7981> }
					triangle { <26.6021, 37.1408, -23.2188>, <27.8893, 37.9514, -22.7981>, <28.1182, 37.369, -22.7373> }
					triangle { <27.774, 38.4151, -22.7601>, <28.7041, 38.6839, -22.8573>, <27.8893, 37.9514, -22.7981> }
					triangle { <28.7041, 38.6839, -22.8573>, <30.371, 38.533, -21.8879>, <28.8863, 38.09182, -22.9403> }
					triangle { <27.8893, 37.9514, -22.7981>, <28.7041, 38.6839, -22.8573>, <28.8863, 38.09182, -22.9403> }
					triangle { <28.1182, 37.369, -22.7373>, <27.8893, 37.9514, -22.7981>, <28.8863, 38.09182, -22.9403> }
					triangle { <28.1182, 37.369, -22.7373>, <28.8863, 38.09182, -22.9403>, <29.06767, 37.5036, -22.8316> }
					triangle { <28.8863, 38.09182, -22.9403>, <30.371, 38.533, -21.8879>, <31.1017, 37.8255, -21.4387> }
					triangle { <29.06767, 37.5036, -22.8316>, <28.8863, 38.09182, -22.9403>, <31.1017, 37.8255, -21.4387> }
					triangle { <25.7931, 37.03555, -22.6929>, <25.7093, 36.6096, -22.8284>, <24.8416, 36.9107, -22.1192> }
					triangle { <25.7931, 37.03555, -22.6929>, <26.3085, 36.4863, -23.01507>, <25.7093, 36.6096, -22.8284> }
					triangle { <26.6021, 37.1408, -23.2188>, <26.5563, 36.7878, -23.4036>, <25.7931, 37.03555, -22.6929> }
					triangle { <26.6021, 37.1408, -23.2188>, <28.1482, 36.8245, -22.774>, <26.5563, 36.7878, -23.4036> }
					triangle { <26.5563, 36.7878, -23.4036>, <26.3085, 36.4863, -23.01507>, <25.7931, 37.03555, -22.6929> }
					triangle { <26.5563, 36.7878, -23.4036>, <28.1021, 36.1342, -22.7121>, <26.3085, 36.4863, -23.01507> }
					triangle { <28.1482, 36.8245, -22.774>, <28.1021, 36.1342, -22.7121>, <26.5563, 36.7878, -23.4036> }
					triangle { <28.1182, 37.369, -22.7373>, <28.1482, 36.8245, -22.774>, <26.6021, 37.1408, -23.2188> }
					triangle { <28.1482, 36.8245, -22.774>, <29.1176, 36.1443, -22.6599>, <28.1021, 36.1342, -22.7121> }
					triangle { <29.2586, 36.8483, -22.7215>, <30.8488, 36.8929, -21.7085>, <29.1176, 36.1443, -22.6599> }
					triangle { <29.2586, 36.8483, -22.7215>, <29.1176, 36.1443, -22.6599>, <28.1482, 36.8245, -22.774> }
					triangle { <29.2586, 36.8483, -22.7215>, <28.1482, 36.8245, -22.774>, <28.1182, 37.369, -22.7373> }
					triangle { <29.06767, 37.5036, -22.8316>, <29.2586, 36.8483, -22.7215>, <28.1182, 37.369, -22.7373> }
					triangle { <31.1017, 37.8255, -21.4387>, <30.8488, 36.8929, -21.7085>, <29.2586, 36.8483, -22.7215> }
					triangle { <31.1017, 37.8255, -21.4387>, <29.2586, 36.8483, -22.7215>, <29.06767, 37.5036, -22.8316> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <24.8416, 36.9107, -22.1192>, <25.8077, 37.04086, -22.4856>, <25.7001, 36.7593, -22.8193> }
					triangle { <25.8077, 37.04086, -22.4856>, <26.5233, 37.1577, -22.815>, <25.7001, 36.7593, -22.8193> }
					triangle { <25.7001, 36.7593, -22.8193>, <26.6902, 36.8281, -23.1693>, <26.4393, 36.6574, -23.4401> }
					triangle { <26.6902, 36.8281, -23.1693>, <27.7479, 35.8082, -23.2009>, <26.4393, 36.6574, -23.4401> }
					triangle { <25.7001, 36.7593, -22.8193>, <26.5233, 37.1577, -22.815>, <26.6902, 36.8281, -23.1693> }
					triangle { <26.5233, 37.1577, -22.815>, <27.993, 36.00154, -22.8371>, <26.6902, 36.8281, -23.1693> }
					triangle { <26.6902, 36.8281, -23.1693>, <27.993, 36.00154, -22.8371>, <27.7479, 35.8082, -23.2009> }
					triangle { <26.4393, 36.6574, -23.4401>, <27.7479, 35.8082, -23.2009>, <27.4671, 35.4354, -23.6221> }
					triangle { <27.993, 36.00154, -22.8371>, <28.8167, 35.5715, -23.1256>, <27.7479, 35.8082, -23.2009> }
					triangle { <28.8167, 35.5715, -23.1256>, <29.5469, 33.7879, -23.2887>, <28.5357, 35.3271, -23.6275> }
					triangle { <27.7479, 35.8082, -23.2009>, <28.8167, 35.5715, -23.1256>, <28.5357, 35.3271, -23.6275> }
					triangle { <27.4671, 35.4354, -23.6221>, <27.7479, 35.8082, -23.2009>, <28.5357, 35.3271, -23.6275> }
					triangle { <27.4671, 35.4354, -23.6221>, <28.5357, 35.3271, -23.6275>, <28.2072, 34.9485, -24.00099> }
					triangle { <28.5357, 35.3271, -23.6275>, <29.5469, 33.7879, -23.2887>, <29.4041, 32.7843, -23.7457> }
					triangle { <28.2072, 34.9485, -24.00099>, <28.5357, 35.3271, -23.6275>, <29.4041, 32.7843, -23.7457> }
					triangle { <25.7001, 36.7593, -22.8193>, <25.3772, 36.7723, -23.1393>, <24.8416, 36.9107, -22.1192> }
					triangle { <25.7001, 36.7593, -22.8193>, <25.7289, 36.4887, -23.5919>, <25.3772, 36.7723, -23.1393> }
					triangle { <26.4393, 36.6574, -23.4401>, <26.2059, 36.7047, -23.7628>, <25.7001, 36.7593, -22.8193> }
					triangle { <26.4393, 36.6574, -23.4401>, <27.1086, 35.2691, -23.9996>, <26.2059, 36.7047, -23.7628> }
					triangle { <26.2059, 36.7047, -23.7628>, <25.7289, 36.4887, -23.5919>, <25.7001, 36.7593, -22.8193> }
					triangle { <26.2059, 36.7047, -23.7628>, <26.571, 35.03411, -24.3716>, <25.7289, 36.4887, -23.5919> }
					triangle { <27.1086, 35.2691, -23.9996>, <26.571, 35.03411, -24.3716>, <26.2059, 36.7047, -23.7628> }
					triangle { <27.4671, 35.4354, -23.6221>, <27.1086, 35.2691, -23.9996>, <26.4393, 36.6574, -23.4401> }
					triangle { <27.1086, 35.2691, -23.9996>, <27.2278, 34.3619, -24.7601>, <26.571, 35.03411, -24.3716> }
					triangle { <27.8369, 34.5414, -24.4195>, <28.6449, 32.8373, -24.3993>, <27.2278, 34.3619, -24.7601> }
					triangle { <27.8369, 34.5414, -24.4195>, <27.2278, 34.3619, -24.7601>, <27.1086, 35.2691, -23.9996> }
					triangle { <27.8369, 34.5414, -24.4195>, <27.1086, 35.2691, -23.9996>, <27.4671, 35.4354, -23.6221> }
					triangle { <28.2072, 34.9485, -24.00099>, <27.8369, 34.5414, -24.4195>, <27.4671, 35.4354, -23.6221> }
					triangle { <29.4041, 32.7843, -23.7457>, <28.6449, 32.8373, -24.3993>, <27.8369, 34.5414, -24.4195> }
					triangle { <29.4041, 32.7843, -23.7457>, <27.8369, 34.5414, -24.4195>, <28.2072, 34.9485, -24.00099> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <24.8416, 36.9107, -22.1192>, <25.6532, 36.6004, -22.6933>, <25.4719, 36.8243, -23.03866> }
					triangle { <25.6532, 36.6004, -22.6933>, <26.2848, 36.4183, -23.1429>, <25.4719, 36.8243, -23.03866> }
					triangle { <25.4719, 36.8243, -23.03866>, <26.2505, 36.469, -23.6511>, <26.04004, 36.7711, -23.8239> }
					triangle { <26.2505, 36.469, -23.6511>, <26.2042, 35.5212, -24.7734>, <26.04004, 36.7711, -23.8239> }
					triangle { <25.4719, 36.8243, -23.03866>, <26.2848, 36.4183, -23.1429>, <26.2505, 36.469, -23.6511> }
					triangle { <26.2848, 36.4183, -23.1429>, <26.4022, 35.1629, -24.524>, <26.2505, 36.469, -23.6511> }
					triangle { <26.2505, 36.469, -23.6511>, <26.4022, 35.1629, -24.524>, <26.2042, 35.5212, -24.7734> }
					triangle { <26.04004, 36.7711, -23.8239>, <26.2042, 35.5212, -24.7734>, <25.87, 35.8903, -25.1573> }
					triangle { <26.4022, 35.1629, -24.524>, <26.6991, 34.7214, -25.3387>, <26.2042, 35.5212, -24.7734> }
					triangle { <26.6991, 34.7214, -25.3387>, <25.9296, 33.8492, -26.8841>, <26.4786, 35.1863, -25.6935> }
					triangle { <26.2042, 35.5212, -24.7734>, <26.6991, 34.7214, -25.3387>, <26.4786, 35.1863, -25.6935> }
					triangle { <25.87, 35.8903, -25.1573>, <26.2042, 35.5212, -24.7734>, <26.4786, 35.1863, -25.6935> }
					triangle { <25.87, 35.8903, -25.1573>, <26.4786, 35.1863, -25.6935>, <26.09677, 35.5495, -26.02958> }
					triangle { <26.4786, 35.1863, -25.6935>, <25.9296, 33.8492, -26.8841>, <25.2402, 33.9701, -27.748> }
					triangle { <26.09677, 35.5495, -26.02958>, <26.4786, 35.1863, -25.6935>, <25.2402, 33.9701, -27.748> }
					triangle { <25.4719, 36.8243, -23.03866>, <25.3606, 37.2614, -23.09612>, <24.8416, 36.9107, -22.1192> }
					triangle { <25.4719, 36.8243, -23.03866>, <25.5044, 37.2792, -23.719>, <25.3606, 37.2614, -23.09612> }
					triangle { <26.04004, 36.7711, -23.8239>, <26.01144, 37.1638, -23.9004>, <25.4719, 36.8243, -23.03866> }
					triangle { <26.04004, 36.7711, -23.8239>, <25.6224, 36.3381, -25.3492>, <26.01144, 37.1638, -23.9004> }
					triangle { <26.01144, 37.1638, -23.9004>, <25.5044, 37.2792, -23.719>, <25.4719, 36.8243, -23.03866> }
					triangle { <26.01144, 37.1638, -23.9004>, <25.2092, 36.875, -25.503>, <25.5044, 37.2792, -23.719> }
					triangle { <25.6224, 36.3381, -25.3492>, <25.2092, 36.875, -25.503>, <26.01144, 37.1638, -23.9004> }
					triangle { <25.87, 35.8903, -25.1573>, <25.6224, 36.3381, -25.3492>, <26.04004, 36.7711, -23.8239> }
					triangle { <25.6224, 36.3381, -25.3492>, <25.252, 36.5391, -26.4618>, <25.2092, 36.875, -25.503> }
					triangle { <25.6797, 35.963, -26.3943>, <24.9678, 34.934, -27.8054>, <25.252, 36.5391, -26.4618> }
					triangle { <25.6797, 35.963, -26.3943>, <25.252, 36.5391, -26.4618>, <25.6224, 36.3381, -25.3492> }
					triangle { <25.6797, 35.963, -26.3943>, <25.6224, 36.3381, -25.3492>, <25.87, 35.8903, -25.1573> }
					triangle { <26.09677, 35.5495, -26.02958>, <25.6797, 35.963, -26.3943>, <25.87, 35.8903, -25.1573> }
					triangle { <25.2402, 33.9701, -27.748>, <24.9678, 34.934, -27.8054>, <25.6797, 35.963, -26.3943> }
					triangle { <25.2402, 33.9701, -27.748>, <25.6797, 35.963, -26.3943>, <26.09677, 35.5495, -26.02958> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		union { // inflor. internode
			cylinder { <1.2037, 11.146, -0.205>, <1.3552, 12.4373, -0.2559>, 0.3888 }
			cylinder { <1.3552, 12.4373, -0.2559>, <1.5067, 13.7286, -0.3068>, 0.3888 }
			cylinder { <1.5067, 13.7286, -0.3068>, <1.6582, 15.01996, -0.3576>, 0.3888 }
			cylinder { <1.6582, 15.01996, -0.3576>, <1.8097, 16.3112, -0.4085>, 0.3888 }
			cylinder { <1.8097, 16.3112, -0.4085>, <1.9611, 17.6025, -0.4594>, 0.3888 }
			cylinder { <1.9611, 17.6025, -0.4594>, <2.1126, 18.8938, -0.5103>, 0.3888 }
			cylinder { <2.1126, 18.8938, -0.5103>, <2.2641, 20.1851, -0.5612>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.2641, 20.1851, -0.5612>, <1.7592, 26.5384, -0.7353>, 0.3888 }
				cylinder { <1.7592, 26.5384, -0.7353>, <0.02631, 32.6733, -0.8274>, 0.3888 }
				cylinder { <0.02631, 32.6733, -0.8274>, <-2.8678, 38.3543, -0.8341>, 0.3888 }
				cylinder { <-2.8678, 38.3543, -0.8341>, <-6.8121, 43.3628, -0.7551>, 0.3888 }
				cylinder { <-6.8121, 43.3628, -0.7551>, <-11.655, 47.5065, -0.5934>, 0.3888 }
				cylinder { <-11.655, 47.5065, -0.5934>, <-17.2102, 50.6261, -0.3552>, 0.3888 }
				cylinder { <-17.2102, 50.6261, -0.3552>, <-23.2643, 52.6017, -0.04977>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-23.2643, 52.6017, -0.04977>, <-24.1625, 52.617, 0.2849>, <-24.1643, 53.02494, 0.2149> }
					triangle { <-24.1625, 52.617, 0.2849>, <-24.864, 52.6499, 0.495>, <-24.1643, 53.02494, 0.2149> }
					triangle { <-24.1643, 53.02494, 0.2149>, <-25.05045, 53.06863, 0.6039>, <-24.9578, 53.381, 0.4194> }
					triangle { <-25.05045, 53.06863, 0.6039>, <-25.4609, 53.6464, 1.7561>, <-24.9578, 53.381, 0.4194> }
					triangle { <-24.1643, 53.02494, 0.2149>, <-24.864, 52.6499, 0.495>, <-25.05045, 53.06863, 0.6039> }
					triangle { <-24.864, 52.6499, 0.495>, <-25.5097, 53.2626, 1.9684>, <-25.05045, 53.06863, 0.6039> }
					triangle { <-25.05045, 53.06863, 0.6039>, <-25.5097, 53.2626, 1.9684>, <-25.4609, 53.6464, 1.7561> }
					triangle { <-24.9578, 53.381, 0.4194>, <-25.4609, 53.6464, 1.7561>, <-25.3571, 54.1912, 1.5909> }
					triangle { <-25.5097, 53.2626, 1.9684>, <-26.08418, 53.6273, 2.5507>, <-25.4609, 53.6464, 1.7561> }
					triangle { <-26.08418, 53.6273, 2.5507>, <-26.08177, 54.8432, 3.8511>, <-26.06375, 54.1345, 2.28> }
					triangle { <-25.4609, 53.6464, 1.7561>, <-26.08418, 53.6273, 2.5507>, <-26.06375, 54.1345, 2.28> }
					triangle { <-25.3571, 54.1912, 1.5909>, <-25.4609, 53.6464, 1.7561>, <-26.06375, 54.1345, 2.28> }
					triangle { <-25.3571, 54.1912, 1.5909>, <-26.06375, 54.1345, 2.28>, <-25.9007, 54.6599, 2.1118> }
					triangle { <-26.06375, 54.1345, 2.28>, <-26.08177, 54.8432, 3.8511>, <-25.8828, 55.8196, 4.08461> }
					triangle { <-25.9007, 54.6599, 2.1118>, <-26.06375, 54.1345, 2.28>, <-25.8828, 55.8196, 4.08461> }
					triangle { <-24.1643, 53.02494, 0.2149>, <-24.1077, 53.2519, -0.1321>, <-23.2643, 52.6017, -0.04977> }
					triangle { <-24.1643, 53.02494, 0.2149>, <-24.4874, 53.6766, 0.01639>, <-24.1077, 53.2519, -0.1321> }
					triangle { <-24.9578, 53.381, 0.4194>, <-24.9759, 53.5752, 0.106>, <-24.1643, 53.02494, 0.2149> }
					triangle { <-24.9578, 53.381, 0.4194>, <-25.2457, 54.5792, 1.2907>, <-24.9759, 53.5752, 0.106> }
					triangle { <-24.9759, 53.5752, 0.106>, <-24.4874, 53.6766, 0.01639>, <-24.1643, 53.02494, 0.2149> }
					triangle { <-24.9759, 53.5752, 0.106>, <-24.9848, 55.03271, 0.9231>, <-24.4874, 53.6766, 0.01639> }
					triangle { <-25.2457, 54.5792, 1.2907>, <-24.9848, 55.03271, 0.9231>, <-24.9759, 53.5752, 0.106> }
					triangle { <-25.3571, 54.1912, 1.5909>, <-25.2457, 54.5792, 1.2907>, <-24.9578, 53.381, 0.4194> }
					triangle { <-25.2457, 54.5792, 1.2907>, <-25.4142, 55.6431, 1.4879>, <-24.9848, 55.03271, 0.9231> }
					triangle { <-25.7223, 55.2374, 1.9128>, <-25.707, 56.2779, 3.3024>, <-25.4142, 55.6431, 1.4879> }
					triangle { <-25.7223, 55.2374, 1.9128>, <-25.4142, 55.6431, 1.4879>, <-25.2457, 54.5792, 1.2907> }
					triangle { <-25.7223, 55.2374, 1.9128>, <-25.2457, 54.5792, 1.2907>, <-25.3571, 54.1912, 1.5909> }
					triangle { <-25.9007, 54.6599, 2.1118>, <-25.7223, 55.2374, 1.9128>, <-25.3571, 54.1912, 1.5909> }
					triangle { <-25.8828, 55.8196, 4.08461>, <-25.707, 56.2779, 3.3024>, <-25.7223, 55.2374, 1.9128> }
					triangle { <-25.8828, 55.8196, 4.08461>, <-25.7223, 55.2374, 1.9128>, <-25.9007, 54.6599, 2.1118> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-23.2643, 52.6017, -0.04977>, <-24.01763, 53.05329, 0.3344>, <-24.1387, 53.1445, -0.05067> }
					triangle { <-24.01763, 53.05329, 0.3344>, <-24.6247, 53.367, 0.5996>, <-24.1387, 53.1445, -0.05067> }
					triangle { <-24.1387, 53.1445, -0.05067>, <-24.8735, 53.6544, 0.3213>, <-24.9129, 53.5903, -0.04536> }
					triangle { <-24.8735, 53.6544, 0.3213>, <-25.0962, 54.9886, 0.3031>, <-24.9129, 53.5903, -0.04536> }
					triangle { <-24.1387, 53.1445, -0.05067>, <-24.6247, 53.367, 0.5996>, <-24.8735, 53.6544, 0.3213> }
					triangle { <-24.6247, 53.367, 0.5996>, <-24.9909, 55.04414, 0.728>, <-24.8735, 53.6544, 0.3213> }
					triangle { <-24.8735, 53.6544, 0.3213>, <-24.9909, 55.04414, 0.728>, <-25.0962, 54.9886, 0.3031> }
					triangle { <-24.9129, 53.5903, -0.04536>, <-25.0962, 54.9886, 0.3031>, <-25.1777, 55.02856, -0.2683> }
					triangle { <-24.9909, 55.04414, 0.728>, <-25.4637, 55.8034, 0.7735>, <-25.0962, 54.9886, 0.3031> }
					triangle { <-25.4637, 55.8034, 0.7735>, <-25.4203, 57.4503, 0.09877>, <-25.6413, 55.7459, 0.2294> }
					triangle { <-25.0962, 54.9886, 0.3031>, <-25.4637, 55.8034, 0.7735>, <-25.6413, 55.7459, 0.2294> }
					triangle { <-25.1777, 55.02856, -0.2683>, <-25.0962, 54.9886, 0.3031>, <-25.6413, 55.7459, 0.2294> }
					triangle { <-25.1777, 55.02856, -0.2683>, <-25.6413, 55.7459, 0.2294>, <-25.6636, 55.7664, -0.345> }
					triangle { <-25.6413, 55.7459, 0.2294>, <-25.4203, 57.4503, 0.09877>, <-25.4149, 58.00272, -0.7627> }
					triangle { <-25.6636, 55.7664, -0.345>, <-25.6413, 55.7459, 0.2294>, <-25.4149, 58.00272, -0.7627> }
					triangle { <-24.1387, 53.1445, -0.05067>, <-24.2334, 52.9053, -0.3808>, <-23.2643, 52.6017, -0.04977> }
					triangle { <-24.1387, 53.1445, -0.05067>, <-24.6534, 53.2614, -0.589>, <-24.2334, 52.9053, -0.3808> }
					triangle { <-24.9129, 53.5903, -0.04536>, <-25.06037, 53.3811, -0.3114>, <-24.1387, 53.1445, -0.05067> }
					triangle { <-24.9129, 53.5903, -0.04536>, <-25.2487, 54.8847, -0.7451>, <-25.06037, 53.3811, -0.3114> }
					triangle { <-25.06037, 53.3811, -0.3114>, <-24.6534, 53.2614, -0.589>, <-24.1387, 53.1445, -0.05067> }
					triangle { <-25.06037, 53.3811, -0.3114>, <-25.2143, 54.6808, -1.3502>, <-24.6534, 53.2614, -0.589> }
					triangle { <-25.2487, 54.8847, -0.7451>, <-25.2143, 54.6808, -1.3502>, <-25.06037, 53.3811, -0.3114> }
					triangle { <-25.1777, 55.02856, -0.2683>, <-25.2487, 54.8847, -0.7451>, <-24.9129, 53.5903, -0.04536> }
					triangle { <-25.2487, 54.8847, -0.7451>, <-25.6173, 55.4947, -1.5765>, <-25.2143, 54.6808, -1.3502> }
					triangle { <-25.6925, 55.7763, -0.9807>, <-25.5701, 57.4359, -1.4751>, <-25.6173, 55.4947, -1.5765> }
					triangle { <-25.6925, 55.7763, -0.9807>, <-25.6173, 55.4947, -1.5765>, <-25.2487, 54.8847, -0.7451> }
					triangle { <-25.6925, 55.7763, -0.9807>, <-25.2487, 54.8847, -0.7451>, <-25.1777, 55.02856, -0.2683> }
					triangle { <-25.6636, 55.7664, -0.345>, <-25.6925, 55.7763, -0.9807>, <-25.1777, 55.02856, -0.2683> }
					triangle { <-25.4149, 58.00272, -0.7627>, <-25.5701, 57.4359, -1.4751>, <-25.6925, 55.7763, -0.9807> }
					triangle { <-25.4149, 58.00272, -0.7627>, <-25.6925, 55.7763, -0.9807>, <-25.6636, 55.7664, -0.345> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-23.2643, 52.6017, -0.04977>, <-23.9774, 53.2413, -0.086>, <-24.2142, 52.9437, -0.2493> }
					triangle { <-23.9774, 53.2413, -0.086>, <-24.5514, 53.6972, -0.08456>, <-24.2142, 52.9437, -0.2493> }
					triangle { <-24.2142, 52.9437, -0.2493>, <-24.9278, 53.5915, -0.3474>, <-25.04519, 53.2389, -0.3931> }
					triangle { <-24.9278, 53.5915, -0.3474>, <-25.4703, 54.1162, -1.4701>, <-25.04519, 53.2389, -0.3931> }
					triangle { <-24.2142, 52.9437, -0.2493>, <-24.5514, 53.6972, -0.08456>, <-24.9278, 53.5915, -0.3474> }
					triangle { <-24.5514, 53.6972, -0.08456>, <-25.2742, 54.5082, -1.4199>, <-24.9278, 53.5915, -0.3474> }
					triangle { <-24.9278, 53.5915, -0.3474>, <-25.2742, 54.5082, -1.4199>, <-25.4703, 54.1162, -1.4701> }
					triangle { <-25.04519, 53.2389, -0.3931>, <-25.4703, 54.1162, -1.4701>, <-25.7066, 53.6229, -1.6593> }
					triangle { <-25.2742, 54.5082, -1.4199>, <-25.891, 54.9118, -1.9285>, <-25.4703, 54.1162, -1.4701> }
					triangle { <-25.891, 54.9118, -1.9285>, <-26.4355, 54.9149, -3.6235>, <-26.1855, 54.4216, -1.991> }
					triangle { <-25.4703, 54.1162, -1.4701>, <-25.891, 54.9118, -1.9285>, <-26.1855, 54.4216, -1.991> }
					triangle { <-25.7066, 53.6229, -1.6593>, <-25.4703, 54.1162, -1.4701>, <-26.1855, 54.4216, -1.991> }
					triangle { <-25.7066, 53.6229, -1.6593>, <-26.1855, 54.4216, -1.991>, <-26.3625, 53.9091, -2.1832> }
					triangle { <-26.1855, 54.4216, -1.991>, <-26.4355, 54.9149, -3.6235>, <-26.7938, 54.3381, -4.3893> }
					triangle { <-26.3625, 53.9091, -2.1832>, <-26.1855, 54.4216, -1.991>, <-26.7938, 54.3381, -4.3893> }
					triangle { <-24.2142, 52.9437, -0.2493>, <-24.3302, 52.5667, -0.1094>, <-23.2643, 52.6017, -0.04977> }
					triangle { <-24.2142, 52.9437, -0.2493>, <-24.8647, 52.5777, -0.3557>, <-24.3302, 52.5667, -0.1094> }
					triangle { <-25.04519, 53.2389, -0.3931>, <-25.2008, 52.9399, -0.2425>, <-24.2142, 52.9437, -0.2493> }
					triangle { <-25.04519, 53.2389, -0.3931>, <-25.8626, 53.1447, -1.6583>, <-25.2008, 52.9399, -0.2425> }
					triangle { <-25.2008, 52.9399, -0.2425>, <-24.8647, 52.5777, -0.3557>, <-24.2142, 52.9437, -0.2493> }
					triangle { <-25.2008, 52.9399, -0.2425>, <-25.9392, 52.5102, -1.6784>, <-24.8647, 52.5777, -0.3557> }
					triangle { <-25.8626, 53.1447, -1.6583>, <-25.9392, 52.5102, -1.6784>, <-25.2008, 52.9399, -0.2425> }
					triangle { <-25.7066, 53.6229, -1.6593>, <-25.8626, 53.1447, -1.6583>, <-25.04519, 53.2389, -0.3931> }
					triangle { <-25.8626, 53.1447, -1.6583>, <-26.5759, 52.6758, -2.3442>, <-25.9392, 52.5102, -1.6784> }
					triangle { <-26.559, 53.3377, -2.3829>, <-26.9856, 53.4978, -4.05815>, <-26.5759, 52.6758, -2.3442> }
					triangle { <-26.559, 53.3377, -2.3829>, <-26.5759, 52.6758, -2.3442>, <-25.8626, 53.1447, -1.6583> }
					triangle { <-26.559, 53.3377, -2.3829>, <-25.8626, 53.1447, -1.6583>, <-25.7066, 53.6229, -1.6593> }
					triangle { <-26.3625, 53.9091, -2.1832>, <-26.559, 53.3377, -2.3829>, <-25.7066, 53.6229, -1.6593> }
					triangle { <-26.7938, 54.3381, -4.3893>, <-26.9856, 53.4978, -4.05815>, <-26.559, 53.3377, -2.3829> }
					triangle { <-26.7938, 54.3381, -4.3893>, <-26.559, 53.3377, -2.3829>, <-26.3625, 53.9091, -2.1832> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-23.2643, 52.6017, -0.04977>, <-24.09716, 52.923, -0.3992>, <-24.2873, 52.6981, -0.1084> }
					triangle { <-24.09716, 52.923, -0.3992>, <-24.7448, 53.1872, -0.6184>, <-24.2873, 52.6981, -0.1084> }
					triangle { <-24.2873, 52.6981, -0.1084>, <-25.1387, 52.9662, -0.4845>, <-25.1729, 52.8091, -0.1464> }
					triangle { <-25.1387, 52.9662, -0.4845>, <-26.06985, 52.2265, -1.1296>, <-25.1729, 52.8091, -0.1464> }
					triangle { <-24.2873, 52.6981, -0.1084>, <-24.7448, 53.1872, -0.6184>, <-25.1387, 52.9662, -0.4845> }
					triangle { <-24.7448, 53.1872, -0.6184>, <-25.9707, 52.3905, -1.5271>, <-25.1387, 52.9662, -0.4845> }
					triangle { <-25.1387, 52.9662, -0.4845>, <-25.9707, 52.3905, -1.5271>, <-26.06985, 52.2265, -1.1296> }
					triangle { <-25.1729, 52.8091, -0.1464>, <-26.06985, 52.2265, -1.1296>, <-26.2178, 51.9038, -0.6727> }
					triangle { <-25.9707, 52.3905, -1.5271>, <-26.7795, 52.1764, -1.8465>, <-26.06985, 52.2265, -1.1296> }
					triangle { <-26.7795, 52.1764, -1.8465>, <-27.7338, 50.7172, -2.2064>, <-26.9493, 51.9794, -1.3334> }
					triangle { <-26.06985, 52.2265, -1.1296>, <-26.7795, 52.1764, -1.8465>, <-26.9493, 51.9794, -1.3334> }
					triangle { <-26.2178, 51.9038, -0.6727>, <-26.06985, 52.2265, -1.1296>, <-26.9493, 51.9794, -1.3334> }
					triangle { <-26.2178, 51.9038, -0.6727>, <-26.9493, 51.9794, -1.3334>, <-27.03807, 51.6373, -0.8794> }
					triangle { <-26.9493, 51.9794, -1.3334>, <-27.7338, 50.7172, -2.2064>, <-28.1266, 49.856, -1.8171> }
					triangle { <-27.03807, 51.6373, -0.8794>, <-26.9493, 51.9794, -1.3334>, <-28.1266, 49.856, -1.8171> }
					triangle { <-24.2873, 52.6981, -0.1084>, <-24.2653, 52.7008, 0.3095>, <-23.2643, 52.6017, -0.04977> }
					triangle { <-24.2873, 52.6981, -0.1084>, <-24.8313, 52.5639, 0.396>, <-24.2653, 52.7008, 0.3095> }
					triangle { <-25.1729, 52.8091, -0.1464>, <-25.2045, 52.8573, 0.2181>, <-24.2873, 52.6981, -0.1084> }
					triangle { <-25.1729, 52.8091, -0.1464>, <-26.2447, 51.7476, -0.1952>, <-25.2045, 52.8573, 0.2181> }
					triangle { <-25.2045, 52.8573, 0.2181>, <-24.8313, 52.5639, 0.396>, <-24.2873, 52.6981, -0.1084> }
					triangle { <-25.2045, 52.8573, 0.2181>, <-26.1644, 51.5003, 0.3889>, <-24.8313, 52.5639, 0.396> }
					triangle { <-26.2447, 51.7476, -0.1952>, <-26.1644, 51.5003, 0.3889>, <-25.2045, 52.8573, 0.2181> }
					triangle { <-26.2178, 51.9038, -0.6727>, <-26.2447, 51.7476, -0.1952>, <-25.1729, 52.8091, -0.1464> }
					triangle { <-26.2447, 51.7476, -0.1952>, <-26.9743, 51.05574, 0.2386>, <-26.1644, 51.5003, 0.3889> }
					triangle { <-27.1325, 51.269, -0.3691>, <-28.01048, 49.869, -0.9011>, <-26.9743, 51.05574, 0.2386> }
					triangle { <-27.1325, 51.269, -0.3691>, <-26.9743, 51.05574, 0.2386>, <-26.2447, 51.7476, -0.1952> }
					triangle { <-27.1325, 51.269, -0.3691>, <-26.2447, 51.7476, -0.1952>, <-26.2178, 51.9038, -0.6727> }
					triangle { <-27.03807, 51.6373, -0.8794>, <-27.1325, 51.269, -0.3691>, <-26.2178, 51.9038, -0.6727> }
					triangle { <-28.1266, 49.856, -1.8171>, <-28.01048, 49.869, -0.9011>, <-27.1325, 51.269, -0.3691> }
					triangle { <-28.1266, 49.856, -1.8171>, <-27.1325, 51.269, -0.3691>, <-27.03807, 51.6373, -0.8794> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-23.2643, 52.6017, -0.04977>, <-24.2132, 52.5313, -0.1665>, <-24.2559, 52.7491, 0.1828> }
					triangle { <-24.2132, 52.5313, -0.1665>, <-24.9409, 52.5301, -0.2548>, <-24.2559, 52.7491, 0.1828> }
					triangle { <-24.2559, 52.7491, 0.1828>, <-25.2157, 52.6381, 0.1122>, <-25.1181, 52.8982, 0.3633> }
					triangle { <-25.2157, 52.6381, 0.1122>, <-26.06389, 51.9318, 0.8944>, <-25.1181, 52.8982, 0.3633> }
					triangle { <-24.2559, 52.7491, 0.1828>, <-24.9409, 52.5301, -0.2548>, <-25.2157, 52.6381, 0.1122> }
					triangle { <-24.9409, 52.5301, -0.2548>, <-26.1184, 51.609, 0.5985>, <-25.2157, 52.6381, 0.1122> }
					triangle { <-25.2157, 52.6381, 0.1122>, <-26.1184, 51.609, 0.5985>, <-26.06389, 51.9318, 0.8944> }
					triangle { <-25.1181, 52.8982, 0.3633>, <-26.06389, 51.9318, 0.8944>, <-25.9986, 52.2603, 1.3663> }
					triangle { <-26.1184, 51.609, 0.5985>, <-26.9007, 51.3705, 0.9635>, <-26.06389, 51.9318, 0.8944> }
					triangle { <-26.9007, 51.3705, 0.9635>, <-27.5119, 50.6722, 2.4828>, <-26.8729, 51.7993, 1.346> }
					triangle { <-26.06389, 51.9318, 0.8944>, <-26.9007, 51.3705, 0.9635>, <-26.8729, 51.7993, 1.346> }
					triangle { <-25.9986, 52.2603, 1.3663>, <-26.06389, 51.9318, 0.8944>, <-26.8729, 51.7993, 1.346> }
					triangle { <-25.9986, 52.2603, 1.3663>, <-26.8729, 51.7993, 1.346>, <-26.7483, 52.1084, 1.815> }
					triangle { <-26.8729, 51.7993, 1.346>, <-27.5119, 50.6722, 2.4828>, <-27.5551, 50.7854, 3.4991> }
					triangle { <-26.7483, 52.1084, 1.815>, <-26.8729, 51.7993, 1.346>, <-27.5551, 50.7854, 3.4991> }
					triangle { <-24.2559, 52.7491, 0.1828>, <-24.1257, 53.1307, 0.2952>, <-23.2643, 52.6017, -0.04977> }
					triangle { <-24.2559, 52.7491, 0.1828>, <-24.5945, 53.2534, 0.6295>, <-24.1257, 53.1307, 0.2952> }
					triangle { <-25.1181, 52.8982, 0.3633>, <-25.06349, 53.2558, 0.4369>, <-24.2559, 52.7491, 0.1828> }
					triangle { <-25.1181, 52.8982, 0.3633>, <-25.8576, 52.6475, 1.6548>, <-25.06349, 53.2558, 0.4369> }
					triangle { <-25.06349, 53.2558, 0.4369>, <-24.5945, 53.2534, 0.6295>, <-24.2559, 52.7491, 0.1828> }
					triangle { <-25.06349, 53.2558, 0.4369>, <-25.5657, 53.08289, 2.02109>, <-24.5945, 53.2534, 0.6295> }
					triangle { <-25.8576, 52.6475, 1.6548>, <-25.5657, 53.08289, 2.02109>, <-25.06349, 53.2558, 0.4369> }
					triangle { <-25.9986, 52.2603, 1.3663>, <-25.8576, 52.6475, 1.6548>, <-25.1181, 52.8982, 0.3633> }
					triangle { <-25.8576, 52.6475, 1.6548>, <-26.2454, 52.9173, 2.6428>, <-25.5657, 53.08289, 2.02109> }
					triangle { <-26.6076, 52.4608, 2.3258>, <-27.2083, 51.6132, 3.7166>, <-26.2454, 52.9173, 2.6428> }
					triangle { <-26.6076, 52.4608, 2.3258>, <-26.2454, 52.9173, 2.6428>, <-25.8576, 52.6475, 1.6548> }
					triangle { <-26.6076, 52.4608, 2.3258>, <-25.8576, 52.6475, 1.6548>, <-25.9986, 52.2603, 1.3663> }
					triangle { <-26.7483, 52.1084, 1.815>, <-26.6076, 52.4608, 2.3258>, <-25.9986, 52.2603, 1.3663> }
					triangle { <-27.5551, 50.7854, 3.4991>, <-27.2083, 51.6132, 3.7166>, <-26.6076, 52.4608, 2.3258> }
					triangle { <-27.5551, 50.7854, 3.4991>, <-26.6076, 52.4608, 2.3258>, <-26.7483, 52.1084, 1.815> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		union { // inflor. internode
			cylinder { <2.2641, 20.1851, -0.5612>, <2.4156, 21.4764, -0.612>, 0.3888 }
			cylinder { <2.4156, 21.4764, -0.612>, <2.5671, 22.7677, -0.6629>, 0.3888 }
			cylinder { <2.5671, 22.7677, -0.6629>, <2.7186, 24.05909, -0.7138>, 0.3888 }
			cylinder { <2.7186, 24.05909, -0.7138>, <2.8701, 25.3504, -0.7647>, 0.3888 }
			cylinder { <2.8701, 25.3504, -0.7647>, <3.02167, 26.6417, -0.8156>, 0.3888 }
			cylinder { <3.02167, 26.6417, -0.8156>, <3.1731, 27.933, -0.8665>, 0.3888 }
			cylinder { <3.1731, 27.933, -0.8665>, <3.3246, 29.2243, -0.9173>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.3246, 29.2243, -0.9173>, <5.01718, 35.3477, -0.3807>, 0.3888 }
				cylinder { <5.01718, 35.3477, -0.3807>, <7.5948, 41.03194, 0.9211>, 0.3888 }
				cylinder { <7.5948, 41.03194, 0.9211>, <10.9586, 46.05841, 2.9383>, 0.3888 }
				cylinder { <10.9586, 46.05841, 2.9383>, <14.9791, 50.234, 5.5932>, 0.3888 }
				cylinder { <14.9791, 50.234, 5.5932>, <19.502, 53.3982, 8.7838>, 0.3888 }
				cylinder { <19.502, 53.3982, 8.7838>, <24.3534, 55.4295, 12.3876>, 0.3888 }
				cylinder { <24.3534, 55.4295, 12.3876>, <29.3468, 56.2498, 16.266>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <29.3468, 56.2498, 16.266>, <30.215, 56.05883, 16.6247>, <30.263, 56.4659, 16.682> }
					triangle { <30.215, 56.05883, 16.6247>, <30.8641, 55.9375, 16.943>, <30.263, 56.4659, 16.682> }
					triangle { <30.263, 56.4659, 16.682>, <31.1647, 56.2968, 16.9928>, <31.04789, 56.644, 17.06993> }
					triangle { <31.1647, 56.2968, 16.9928>, <32.3494, 56.6196, 16.4251>, <31.04789, 56.644, 17.06993> }
					triangle { <30.263, 56.4659, 16.682>, <30.8641, 55.9375, 16.943>, <31.1647, 56.2968, 16.9928> }
					triangle { <30.8641, 55.9375, 16.943>, <32.4369, 56.2065, 16.2972>, <31.1647, 56.2968, 16.9928> }
					triangle { <31.1647, 56.2968, 16.9928>, <32.4369, 56.2065, 16.2972>, <32.3494, 56.6196, 16.4251> }
					triangle { <31.04789, 56.644, 17.06993>, <32.3494, 56.6196, 16.4251>, <32.2901, 57.1923, 16.4829> }
					triangle { <32.4369, 56.2065, 16.2972>, <33.3154, 56.3762, 16.2586>, <32.3494, 56.6196, 16.4251> }
					triangle { <33.3154, 56.3762, 16.2586>, <34.4466, 57.3711, 15.3098>, <33.2378, 56.9131, 16.4501> }
					triangle { <32.3494, 56.6196, 16.4251>, <33.3154, 56.3762, 16.2586>, <33.2378, 56.9131, 16.4501> }
					triangle { <32.2901, 57.1923, 16.4829>, <32.3494, 56.6196, 16.4251>, <33.2378, 56.9131, 16.4501> }
					triangle { <32.2901, 57.1923, 16.4829>, <33.2378, 56.9131, 16.4501>, <33.1296, 57.4778, 16.47> }
					triangle { <33.2378, 56.9131, 16.4501>, <34.4466, 57.3711, 15.3098>, <34.6797, 58.3226, 15.0137> }
					triangle { <33.1296, 57.4778, 16.47>, <33.2378, 56.9131, 16.4501>, <34.6797, 58.3226, 15.0137> }
					triangle { <30.263, 56.4659, 16.682>, <30.04549, 56.7474, 16.9025>, <29.3468, 56.2498, 16.266> }
					triangle { <30.263, 56.4659, 16.682>, <30.5122, 57.07295, 17.0534>, <30.04549, 56.7474, 16.9025> }
					triangle { <31.04789, 56.644, 17.06993>, <30.8987, 56.8757, 17.3155>, <30.263, 56.4659, 16.682> }
					triangle { <31.04789, 56.644, 17.06993>, <32.1007, 57.6334, 16.6335>, <30.8987, 56.8757, 17.3155> }
					triangle { <30.8987, 56.8757, 17.3155>, <30.5122, 57.07295, 17.0534>, <30.263, 56.4659, 16.682> }
					triangle { <30.8987, 56.8757, 17.3155>, <31.7746, 58.1742, 16.7338>, <30.5122, 57.07295, 17.0534> }
					triangle { <32.1007, 57.6334, 16.6335>, <31.7746, 58.1742, 16.7338>, <30.8987, 56.8757, 17.3155> }
					triangle { <32.2901, 57.1923, 16.4829>, <32.1007, 57.6334, 16.6335>, <31.04789, 56.644, 17.06993> }
					triangle { <32.1007, 57.6334, 16.6335>, <32.5934, 58.6112, 16.6129>, <31.7746, 58.1742, 16.7338> }
					triangle { <33.00199, 58.1004, 16.5027>, <34.1427, 58.9136, 15.4774>, <32.5934, 58.6112, 16.6129> }
					triangle { <33.00199, 58.1004, 16.5027>, <32.5934, 58.6112, 16.6129>, <32.1007, 57.6334, 16.6335> }
					triangle { <33.00199, 58.1004, 16.5027>, <32.1007, 57.6334, 16.6335>, <32.2901, 57.1923, 16.4829> }
					triangle { <33.1296, 57.4778, 16.47>, <33.00199, 58.1004, 16.5027>, <32.2901, 57.1923, 16.4829> }
					triangle { <34.6797, 58.3226, 15.0137>, <34.1427, 58.9136, 15.4774>, <33.00199, 58.1004, 16.5027> }
					triangle { <34.6797, 58.3226, 15.0137>, <33.00199, 58.1004, 16.5027>, <33.1296, 57.4778, 16.47> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <29.3468, 56.2498, 16.266>, <30.2429, 56.5017, 16.4951>, <30.09693, 56.6256, 16.862> }
					triangle { <30.2429, 56.5017, 16.4951>, <30.9244, 56.6625, 16.712>, <30.09693, 56.6256, 16.862> }
					triangle { <30.09693, 56.6256, 16.862>, <30.985, 56.9393, 17.08839>, <30.7572, 56.9235, 17.385> }
					triangle { <30.985, 56.9393, 17.08839>, <31.4362, 58.2022, 17.2661>, <30.7572, 56.9235, 17.385> }
					triangle { <30.09693, 56.6256, 16.862>, <30.9244, 56.6625, 16.712>, <30.985, 56.9393, 17.08839> }
					triangle { <30.9244, 56.6625, 16.712>, <31.6531, 58.2127, 16.882>, <30.985, 56.9393, 17.08839> }
					triangle { <30.985, 56.9393, 17.08839>, <31.6531, 58.2127, 16.882>, <31.4362, 58.2022, 17.2661> }
					triangle { <30.7572, 56.9235, 17.385>, <31.4362, 58.2022, 17.2661>, <31.1274, 58.3101, 17.7435> }
					triangle { <31.6531, 58.2127, 16.882>, <32.1949, 58.8627, 17.1754>, <31.4362, 58.2022, 17.2661> }
					triangle { <32.1949, 58.8627, 17.1754>, <32.09399, 60.5723, 17.6618>, <31.9509, 58.855, 17.6963> }
					triangle { <31.4362, 58.2022, 17.2661>, <32.1949, 58.8627, 17.1754>, <31.9509, 58.855, 17.6963> }
					triangle { <31.1274, 58.3101, 17.7435>, <31.4362, 58.2022, 17.2661>, <31.9509, 58.855, 17.6963> }
					triangle { <31.1274, 58.3101, 17.7435>, <31.9509, 58.855, 17.6963>, <31.5932, 58.9548, 18.1357> }
					triangle { <31.9509, 58.855, 17.6963>, <32.09399, 60.5723, 17.6618>, <31.6484, 61.2367, 18.3001> }
					triangle { <31.5932, 58.9548, 18.1357>, <31.9509, 58.855, 17.6963>, <31.6484, 61.2367, 18.3001> }
					triangle { <30.09693, 56.6256, 16.862>, <29.893, 56.4242, 17.1672>, <29.3468, 56.2498, 16.266> }
					triangle { <30.09693, 56.6256, 16.862>, <30.1382, 56.7278, 17.6079>, <29.893, 56.4242, 17.1672> }
					triangle { <30.7572, 56.9235, 17.385>, <30.6401, 56.7328, 17.6787>, <30.09693, 56.6256, 16.862> }
					triangle { <30.7572, 56.9235, 17.385>, <30.8316, 58.2271, 18.1419>, <30.6401, 56.7328, 17.6787> }
					triangle { <30.6401, 56.7328, 17.6787>, <30.1382, 56.7278, 17.6079>, <30.09693, 56.6256, 16.862> }
					triangle { <30.6401, 56.7328, 17.6787>, <30.3621, 58.1228, 18.5632>, <30.1382, 56.7278, 17.6079> }
					triangle { <30.8316, 58.2271, 18.1419>, <30.3621, 58.1228, 18.5632>, <30.6401, 56.7328, 17.6787> }
					triangle { <31.1274, 58.3101, 17.7435>, <30.8316, 58.2271, 18.1419>, <30.7572, 56.9235, 17.385> }
					triangle { <30.8316, 58.2271, 18.1419>, <30.6872, 58.8778, 19.01081>, <30.3621, 58.1228, 18.5632> }
					triangle { <31.1976, 59.05206, 18.6245>, <31.1617, 60.7615, 18.9247>, <30.6872, 58.8778, 19.01081> }
					triangle { <31.1976, 59.05206, 18.6245>, <30.6872, 58.8778, 19.01081>, <30.8316, 58.2271, 18.1419> }
					triangle { <31.1976, 59.05206, 18.6245>, <30.8316, 58.2271, 18.1419>, <31.1274, 58.3101, 17.7435> }
					triangle { <31.5932, 58.9548, 18.1357>, <31.1976, 59.05206, 18.6245>, <31.1274, 58.3101, 17.7435> }
					triangle { <31.6484, 61.2367, 18.3001>, <31.1617, 60.7615, 18.9247>, <31.1976, 59.05206, 18.6245> }
					triangle { <31.6484, 61.2367, 18.3001>, <31.1976, 59.05206, 18.6245>, <31.5932, 58.9548, 18.1357> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <29.3468, 56.2498, 16.266>, <29.98, 56.7532, 16.7804>, <29.9745, 56.4458, 17.05762> }
					triangle { <29.98, 56.7532, 16.7804>, <30.4964, 57.09657, 17.1713>, <29.9745, 56.4458, 17.05762> }
					triangle { <29.9745, 56.4458, 17.05762>, <30.5691, 56.966, 17.6181>, <30.5431, 56.6088, 17.7272> }
					triangle { <30.5691, 56.966, 17.6181>, <30.3383, 57.5457, 18.8184>, <30.5431, 56.6088, 17.7272> }
					triangle { <29.9745, 56.4458, 17.05762>, <30.4964, 57.09657, 17.1713>, <30.5691, 56.966, 17.6181> }
					triangle { <30.4964, 57.09657, 17.1713>, <30.3199, 57.9544, 18.6532>, <30.5691, 56.966, 17.6181> }
					triangle { <30.5691, 56.966, 17.6181>, <30.3199, 57.9544, 18.6532>, <30.3383, 57.5457, 18.8184> }
					triangle { <30.5431, 56.6088, 17.7272>, <30.3383, 57.5457, 18.8184>, <30.271, 57.05171, 19.1122> }
					triangle { <30.3199, 57.9544, 18.6532>, <30.5192, 58.3137, 19.449>, <30.3383, 57.5457, 18.8184> }
					triangle { <30.5192, 58.3137, 19.449>, <29.7942, 58.4685, 21.06771>, <30.5778, 57.794, 19.6886> }
					triangle { <30.3383, 57.5457, 18.8184>, <30.5192, 58.3137, 19.449>, <30.5778, 57.794, 19.6886> }
					triangle { <30.271, 57.05171, 19.1122>, <30.3383, 57.5457, 18.8184>, <30.5778, 57.794, 19.6886> }
					triangle { <30.271, 57.05171, 19.1122>, <30.5778, 57.794, 19.6886>, <30.4616, 57.2919, 19.9443> }
					triangle { <30.5778, 57.794, 19.6886>, <29.7942, 58.4685, 21.06771>, <29.4158, 57.9558, 21.8685> }
					triangle { <30.4616, 57.2919, 19.9443>, <30.5778, 57.794, 19.6886>, <29.4158, 57.9558, 21.8685> }
					triangle { <29.9745, 56.4458, 17.05762>, <30.06421, 56.038, 17.02851>, <29.3468, 56.2498, 16.266> }
					triangle { <29.9745, 56.4458, 17.05762>, <30.2879, 55.9911, 17.5709>, <30.06421, 56.038, 17.02851> }
					triangle { <30.5431, 56.6088, 17.7272>, <30.6859, 56.2686, 17.7179>, <29.9745, 56.4458, 17.05762> }
					triangle { <30.5431, 56.6088, 17.7272>, <30.2749, 56.5585, 19.2116>, <30.6859, 56.2686, 17.7179> }
					triangle { <30.6859, 56.2686, 17.7179>, <30.2879, 55.9911, 17.5709>, <29.9745, 56.4458, 17.05762> }
					triangle { <30.6859, 56.2686, 17.7179>, <30.1722, 55.9302, 19.2714>, <30.2879, 55.9911, 17.5709> }
					triangle { <30.2749, 56.5585, 19.2116>, <30.1722, 55.9302, 19.2714>, <30.6859, 56.2686, 17.7179> }
					triangle { <30.271, 57.05171, 19.1122>, <30.2749, 56.5585, 19.2116>, <30.5431, 56.6088, 17.7272> }
					triangle { <30.2749, 56.5585, 19.2116>, <30.2282, 56.07719, 20.1941>, <30.1722, 55.9302, 19.2714> }
					triangle { <30.3411, 56.7303, 20.2183>, <29.5803, 57.05574, 21.7445>, <30.2282, 56.07719, 20.1941> }
					triangle { <30.3411, 56.7303, 20.2183>, <30.2282, 56.07719, 20.1941>, <30.2749, 56.5585, 19.2116> }
					triangle { <30.3411, 56.7303, 20.2183>, <30.2749, 56.5585, 19.2116>, <30.271, 57.05171, 19.1122> }
					triangle { <30.4616, 57.2919, 19.9443>, <30.3411, 56.7303, 20.2183>, <30.271, 57.05171, 19.1122> }
					triangle { <29.4158, 57.9558, 21.8685>, <29.5803, 57.05574, 21.7445>, <30.3411, 56.7303, 20.2183> }
					triangle { <29.4158, 57.9558, 21.8685>, <30.3411, 56.7303, 20.2183>, <30.4616, 57.2919, 19.9443> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <29.3468, 56.2498, 16.266>, <29.7871, 56.468, 17.0891>, <30.06395, 56.1733, 17.00021> }
					triangle { <29.7871, 56.468, 17.0891>, <30.1675, 56.6439, 17.6905>, <30.06395, 56.1733, 17.00021> }
					triangle { <30.06395, 56.1733, 17.00021>, <30.488, 56.3403, 17.855>, <30.6995, 56.132, 17.6267> }
					triangle { <30.488, 56.3403, 17.855>, <30.5628, 55.5512, 18.9513>, <30.6995, 56.132, 17.6267> }
					triangle { <30.06395, 56.1733, 17.00021>, <30.1675, 56.6439, 17.6905>, <30.488, 56.3403, 17.855> }
					triangle { <30.1675, 56.6439, 17.6905>, <30.2672, 55.7861, 19.1796>, <30.488, 56.3403, 17.855> }
					triangle { <30.488, 56.3403, 17.855>, <30.2672, 55.7861, 19.1796>, <30.5628, 55.5512, 18.9513> }
					triangle { <30.6995, 56.132, 17.6267>, <30.5628, 55.5512, 18.9513>, <30.8965, 55.1444, 18.7103> }
					triangle { <30.2672, 55.7861, 19.1796>, <30.5884, 55.4827, 19.9586>, <30.5628, 55.5512, 18.9513> }
					triangle { <30.5884, 55.4827, 19.9586>, <30.7041, 53.9474, 20.8524>, <31.0034, 55.1865, 19.6922> }
					triangle { <30.5628, 55.5512, 18.9513>, <30.5884, 55.4827, 19.9586>, <31.0034, 55.1865, 19.6922> }
					triangle { <30.8965, 55.1444, 18.7103>, <30.5628, 55.5512, 18.9513>, <31.0034, 55.1865, 19.6922> }
					triangle { <30.8965, 55.1444, 18.7103>, <31.0034, 55.1865, 19.6922>, <31.2881, 54.7716, 19.4133> }
					triangle { <31.0034, 55.1865, 19.6922>, <30.7041, 53.9474, 20.8524>, <31.0465, 52.9834, 20.8207> }
					triangle { <31.2881, 54.7716, 19.4133>, <31.0034, 55.1865, 19.6922>, <31.0465, 52.9834, 20.8207> }
					triangle { <30.06395, 56.1733, 17.00021>, <30.324, 56.1188, 16.6768>, <29.3468, 56.2498, 16.266> }
					triangle { <30.06395, 56.1733, 17.00021>, <30.7559, 55.874, 16.9932>, <30.324, 56.1188, 16.6768> }
					triangle { <30.6995, 56.132, 17.6267>, <30.9732, 56.1202, 17.3793>, <30.06395, 56.1733, 17.00021> }
					triangle { <30.6995, 56.132, 17.6267>, <31.1947, 54.918, 18.3743>, <30.9732, 56.1202, 17.3793> }
					triangle { <30.9732, 56.1202, 17.3793>, <30.7559, 55.874, 16.9932>, <30.06395, 56.1733, 17.00021> }
					triangle { <30.9732, 56.1202, 17.3793>, <31.4656, 54.6062, 17.8862>, <30.7559, 55.874, 16.9932> }
					triangle { <31.1947, 54.918, 18.3743>, <31.4656, 54.6062, 17.8862>, <30.9732, 56.1202, 17.3793> }
					triangle { <30.8965, 55.1444, 18.7103>, <31.1947, 54.918, 18.3743>, <30.6995, 56.132, 17.6267> }
					triangle { <31.1947, 54.918, 18.3743>, <31.8465, 54.05352, 18.5386>, <31.4656, 54.6062, 17.8862> }
					triangle { <31.6082, 54.3221, 19.09634>, <31.5693, 52.8829, 20.06628>, <31.8465, 54.05352, 18.5386> }
					triangle { <31.6082, 54.3221, 19.09634>, <31.8465, 54.05352, 18.5386>, <31.1947, 54.918, 18.3743> }
					triangle { <31.6082, 54.3221, 19.09634>, <31.1947, 54.918, 18.3743>, <30.8965, 55.1444, 18.7103> }
					triangle { <31.2881, 54.7716, 19.4133>, <31.6082, 54.3221, 19.09634>, <30.8965, 55.1444, 18.7103> }
					triangle { <31.0465, 52.9834, 20.8207>, <31.5693, 52.8829, 20.06628>, <31.6082, 54.3221, 19.09634> }
					triangle { <31.0465, 52.9834, 20.8207>, <31.6082, 54.3221, 19.09634>, <31.2881, 54.7716, 19.4133> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <29.3468, 56.2498, 16.266>, <29.9346, 56.03238, 16.9913>, <30.2449, 56.1859, 16.7645> }
					triangle { <29.9346, 56.03238, 16.9913>, <30.3982, 55.9167, 17.5473>, <30.2449, 56.1859, 16.7645> }
					triangle { <30.2449, 56.1859, 16.7645>, <30.8616, 55.9204, 17.4627>, <31.01617, 56.1541, 17.2143> }
					triangle { <30.8616, 55.9204, 17.4627>, <31.8245, 54.9702, 17.4497>, <31.01617, 56.1541, 17.2143> }
					triangle { <30.2449, 56.1859, 16.7645>, <30.3982, 55.9167, 17.5473>, <30.8616, 55.9204, 17.4627> }
					triangle { <30.3982, 55.9167, 17.5473>, <31.5954, 54.6895, 17.7015>, <30.8616, 55.9204, 17.4627> }
					triangle { <30.8616, 55.9204, 17.4627>, <31.5954, 54.6895, 17.7015>, <31.8245, 54.9702, 17.4497> }
					triangle { <31.01617, 56.1541, 17.2143>, <31.8245, 54.9702, 17.4497>, <32.1632, 55.2327, 17.06083> }
					triangle { <31.5954, 54.6895, 17.7015>, <32.3427, 54.2672, 17.9571>, <31.8245, 54.9702, 17.4497> }
					triangle { <32.3427, 54.2672, 17.9571>, <33.6228, 53.2589, 17.2402>, <32.6722, 54.6338, 17.6605> }
					triangle { <31.8245, 54.9702, 17.4497>, <32.3427, 54.2672, 17.9571>, <32.6722, 54.6338, 17.6605> }
					triangle { <32.1632, 55.2327, 17.06083>, <31.8245, 54.9702, 17.4497>, <32.6722, 54.6338, 17.6605> }
					triangle { <32.1632, 55.2327, 17.06083>, <32.6722, 54.6338, 17.6605>, <32.9619, 54.8883, 17.2336> }
					triangle { <32.6722, 54.6338, 17.6605>, <33.6228, 53.2589, 17.2402>, <34.3488, 53.2135, 16.5202> }
					triangle { <32.9619, 54.8883, 17.2336>, <32.6722, 54.6338, 17.6605>, <34.3488, 53.2135, 16.5202> }
					triangle { <30.2449, 56.1859, 16.7645>, <30.3123, 56.5639, 16.5978>, <29.3468, 56.2498, 16.266> }
					triangle { <30.2449, 56.1859, 16.7645>, <30.8966, 56.5527, 16.6685>, <30.3123, 56.5639, 16.5978> }
					triangle { <31.01617, 56.1541, 17.2143>, <31.1067, 56.5011, 17.1269>, <30.2449, 56.1859, 16.7645> }
					triangle { <31.01617, 56.1541, 17.2143>, <32.3401, 55.5924, 16.7568>, <31.1067, 56.5011, 17.1269> }
					triangle { <31.1067, 56.5011, 17.1269>, <30.8966, 56.5527, 16.6685>, <30.2449, 56.1859, 16.7645> }
					triangle { <31.1067, 56.5011, 17.1269>, <32.4709, 56.01401, 16.2942>, <30.8966, 56.5527, 16.6685> }
					triangle { <32.3401, 55.5924, 16.7568>, <32.4709, 56.01401, 16.2942>, <31.1067, 56.5011, 17.1269> }
					triangle { <32.1632, 55.2327, 17.06083>, <32.3401, 55.5924, 16.7568>, <31.01617, 56.1541, 17.2143> }
					triangle { <32.3401, 55.5924, 16.7568>, <33.3303, 55.6433, 16.2918>, <32.4709, 56.01401, 16.2942> }
					triangle { <33.2775, 55.1816, 16.7653>, <34.4315, 54.0485, 16.1345>, <33.3303, 55.6433, 16.2918> }
					triangle { <33.2775, 55.1816, 16.7653>, <33.3303, 55.6433, 16.2918>, <32.3401, 55.5924, 16.7568> }
					triangle { <33.2775, 55.1816, 16.7653>, <32.3401, 55.5924, 16.7568>, <32.1632, 55.2327, 17.06083> }
					triangle { <32.9619, 54.8883, 17.2336>, <33.2775, 55.1816, 16.7653>, <32.1632, 55.2327, 17.06083> }
					triangle { <34.3488, 53.2135, 16.5202>, <34.4315, 54.0485, 16.1345>, <33.2775, 55.1816, 16.7653> }
					triangle { <34.3488, 53.2135, 16.5202>, <33.2775, 55.1816, 16.7653>, <32.9619, 54.8883, 17.2336> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		}
	union { // internode
		cylinder { <0.1432, 2.1069, 0.1511>, <0.1556, 2.2569, 0.1505>, 0.4 }
		cylinder { <0.1556, 2.2569, 0.1505>, <0.1628, 2.4072, 0.1551>, 0.4 }
		cylinder { <0.1628, 2.4072, 0.1551>, <0.1648, 2.5575, 0.165>, 0.4 }
		cylinder { <0.1648, 2.5575, 0.165>, <0.1616, 2.7072, 0.1801>, 0.4 }
		cylinder { <0.1616, 2.7072, 0.1801>, <0.1532, 2.8562, 0.2005>, 0.4 }
		cylinder { <0.1532, 2.8562, 0.2005>, <0.1397, 3.004032, 0.226>, 0.4 }
		cylinder { <0.1397, 3.004032, 0.226>, <0.121, 3.1502, 0.2565>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.121, 3.1502, 0.2565>, <0.07751, 14.3561, 1.1919>, 0.8843 }
			cylinder { <0.07751, 14.3561, 1.1919>, <1.3867, 25.5159, 0.7522>, 0.8843 }
			cylinder { <1.3867, 25.5159, 0.7522>, <4.01033, 36.301, -1.04966>, 0.8843 }
			cylinder { <4.01033, 36.301, -1.04966>, <7.8709, 46.3939, -4.1606>, 0.8843 }
			cylinder { <7.8709, 46.3939, -4.1606>, <12.8548, 55.4973, -8.4892>, 0.8843 }
			cylinder { <12.8548, 55.4973, -8.4892>, <18.8154, 63.3433, -13.9078>, 0.8843 }
			cylinder { <18.8154, 63.3433, -13.9078>, <25.577, 69.7008, -20.2569>, 0.8843 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <25.577, 69.7008, -20.2569>, <17.2537, 61.4886, -22.2104>, <18.02233, 70.3734, -31.261> }
			triangle { <25.577, 69.7008, -20.2569>, <18.02233, 70.3734, -31.261>, <24.1729, 76.4572, -34.9631> }
			triangle { <17.2537, 61.4886, -22.2104>, <12.2913, 59.1244, -26.2306>, <18.02233, 70.3734, -31.261> }
			triangle { <12.2913, 59.1244, -26.2306>, <13.4454, 62.1164, -32.9017>, <18.02233, 70.3734, -31.261> }
			triangle { <13.4454, 62.1164, -32.9017>, <19.03137, 67.853, -39.9742>, <18.02233, 70.3734, -31.261> }
			triangle { <19.03137, 67.853, -39.9742>, <26.00976, 74.2931, -46.07006>, <24.1729, 76.4572, -34.9631> }
			triangle { <18.02233, 70.3734, -31.261>, <19.03137, 67.853, -39.9742>, <24.1729, 76.4572, -34.9631> }
			triangle { <24.1729, 76.4572, -34.9631>, <30.8797, 80.286, -41.5416>, <33.996, 81.4575, -34.6284> }
			triangle { <30.8797, 80.286, -41.5416>, <36.9009, 81.3252, -47.406>, <38.8993, 84.1963, -41.7976> }
			triangle { <30.8797, 80.286, -41.5416>, <38.8993, 84.1963, -41.7976>, <33.996, 81.4575, -34.6284> }
			triangle { <33.996, 81.4575, -34.6284>, <38.8993, 84.1963, -41.7976>, <41.9715, 83.7557, -35.3349> }
			triangle { <36.9009, 81.3252, -47.406>, <48.8411, 84.448, -47.302>, <38.8993, 84.1963, -41.7976> }
			triangle { <38.8993, 84.1963, -41.7976>, <48.8411, 84.448, -47.302>, <41.9715, 83.7557, -35.3349> }
			triangle { <25.577, 69.7008, -20.2569>, <24.1729, 76.4572, -34.9631>, <31.7738, 76.4336, -26.2866> }
			triangle { <31.7738, 76.4336, -26.2866>, <24.1729, 76.4572, -34.9631>, <33.996, 81.4575, -34.6284> }
			triangle { <31.7738, 76.4336, -26.2866>, <33.996, 81.4575, -34.6284>, <36.9118, 81.2645, -31.1111> }
			triangle { <33.996, 81.4575, -34.6284>, <41.9715, 83.7557, -35.3349>, <36.9118, 81.2645, -31.1111> }
			triangle { <26.00976, 74.2931, -46.07006>, <30.8797, 80.286, -41.5416>, <24.1729, 76.4572, -34.9631> }
			triangle { <26.00976, 74.2931, -46.07006>, <36.9009, 81.3252, -47.406>, <30.8797, 80.286, -41.5416> }
			triangle { <32.9396, 75.1927, -10.5489>, <26.2827, 64.4055, -9.6742>, <25.577, 69.7008, -20.2569> }
			triangle { <37.1274, 80.6423, -16.9763>, <32.9396, 75.1927, -10.5489>, <25.577, 69.7008, -20.2569> }
			triangle { <32.9396, 75.1927, -10.5489>, <28.7789, 64.4509, -3.3383>, <26.2827, 64.4055, -9.6742> }
			triangle { <32.9396, 75.1927, -10.5489>, <34.6437, 68.9647, -3.4687>, <28.7789, 64.4509, -3.3383> }
			triangle { <32.9396, 75.1927, -10.5489>, <41.7999, 75.2086, -8.361>, <34.6437, 68.9647, -3.4687> }
			triangle { <37.1274, 80.6423, -16.9763>, <48.3857, 81.5219, -15.00192>, <41.7999, 75.2086, -8.361> }
			triangle { <37.1274, 80.6423, -16.9763>, <41.7999, 75.2086, -8.361>, <32.9396, 75.1927, -10.5489> }
			triangle { <39.09935, 83.1061, -27.5427>, <43.2902, 86.6476, -21.9548>, <37.1274, 80.6423, -16.9763> }
			triangle { <46.9404, 86.458, -30.9694>, <51.8182, 86.1444, -26.6939>, <43.2902, 86.6476, -21.9548> }
			triangle { <39.09935, 83.1061, -27.5427>, <46.9404, 86.458, -30.9694>, <43.2902, 86.6476, -21.9548> }
			triangle { <41.9715, 83.7557, -35.3349>, <46.9404, 86.458, -30.9694>, <39.09935, 83.1061, -27.5427> }
			triangle { <46.9404, 86.458, -30.9694>, <54.9322, 86.7518, -38.5082>, <51.8182, 86.1444, -26.6939> }
			triangle { <41.9715, 83.7557, -35.3349>, <54.9322, 86.7518, -38.5082>, <46.9404, 86.458, -30.9694> }
			triangle { <31.7738, 76.4336, -26.2866>, <37.1274, 80.6423, -16.9763>, <25.577, 69.7008, -20.2569> }
			triangle { <39.09935, 83.1061, -27.5427>, <37.1274, 80.6423, -16.9763>, <31.7738, 76.4336, -26.2866> }
			triangle { <36.9118, 81.2645, -31.1111>, <39.09935, 83.1061, -27.5427>, <31.7738, 76.4336, -26.2866> }
			triangle { <36.9118, 81.2645, -31.1111>, <41.9715, 83.7557, -35.3349>, <39.09935, 83.1061, -27.5427> }
			triangle { <37.1274, 80.6423, -16.9763>, <43.2902, 86.6476, -21.9548>, <48.3857, 81.5219, -15.00192> }
			triangle { <43.2902, 86.6476, -21.9548>, <51.8182, 86.1444, -26.6939>, <48.3857, 81.5219, -15.00192> }
			triangle { <41.9715, 83.7557, -35.3349>, <48.8411, 84.448, -47.302>, <51.9973, 85.9305, -43.06171> }
			triangle { <48.8411, 84.448, -47.302>, <58.4979, 83.8844, -47.2675>, <51.9973, 85.9305, -43.06171> }
			triangle { <41.9715, 83.7557, -35.3349>, <51.9973, 85.9305, -43.06171>, <54.9322, 86.7518, -38.5082> }
			triangle { <51.9973, 85.9305, -43.06171>, <58.4979, 83.8844, -47.2675>, <54.9322, 86.7518, -38.5082> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <0.121, 3.1502, 0.2565>, <0.01932, 4.4321, 0.4554>, 0.3888 }
			cylinder { <0.01932, 4.4321, 0.4554>, <-0.02217, 5.7258, 0.5881>, 0.3888 }
			cylinder { <-0.02217, 5.7258, 0.5881>, <-0.003133, 7.02517, 0.654>, 0.3888 }
			cylinder { <-0.003133, 7.02517, 0.654>, <0.07642, 8.3238, 0.6529>, 0.3888 }
			cylinder { <0.07642, 8.3238, 0.6529>, <0.2162, 9.6157, 0.5849>, 0.3888 }
			cylinder { <0.2162, 9.6157, 0.5849>, <0.4156, 10.8944, 0.4503>, 0.3888 }
			cylinder { <0.4156, 10.8944, 0.4503>, <0.6737, 12.1539, 0.25>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.6737, 12.1539, 0.25>, <1.1659, 18.4397, -0.6963>, 0.3888 }
				cylinder { <1.1659, 18.4397, -0.6963>, <0.8781, 24.7454, -1.5932>, 0.3888 }
				cylinder { <0.8781, 24.7454, -1.5932>, <-0.1854, 30.9761, -2.4271>, 0.3888 }
				cylinder { <-0.1854, 30.9761, -2.4271>, <-2.008903, 37.03829, -3.1855>, 0.3888 }
				cylinder { <-2.008903, 37.03829, -3.1855>, <-4.5646, 42.8405, -3.8571>, 0.3888 }
				cylinder { <-4.5646, 42.8405, -3.8571>, <-7.8143, 48.2957, -4.4315>, 0.3888 }
				cylinder { <-7.8143, 48.2957, -4.4315>, <-11.709, 53.3217, -4.9004>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.709, 53.3217, -4.9004>, <-12.5071, 53.9326, -4.6277>, <-12.2593, 54.2845, -4.758> }
					triangle { <-12.5071, 53.9326, -4.6277>, <-13.1176, 54.4199, -4.4727>, <-12.2593, 54.2845, -4.758> }
					triangle { <-12.2593, 54.2845, -4.758>, <-13.02946, 54.9223, -4.4298>, <-12.7549, 55.1134, -4.6612> }
					triangle { <-13.02946, 54.9223, -4.4298>, <-13.04768, 55.8727, -3.3089>, <-12.7549, 55.1134, -4.6612> }
					triangle { <-12.2593, 54.2845, -4.758>, <-13.1176, 54.4199, -4.4727>, <-13.02946, 54.9223, -4.4298> }
					triangle { <-13.1176, 54.4199, -4.4727>, <-13.3265, 55.5962, -3.03401>, <-13.02946, 54.9223, -4.4298> }
					triangle { <-13.02946, 54.9223, -4.4298>, <-13.3265, 55.5962, -3.03401>, <-13.04768, 55.8727, -3.3089> }
					triangle { <-12.7549, 55.1134, -4.6612>, <-13.04768, 55.8727, -3.3089>, <-12.6211, 56.2667, -3.55> }
					triangle { <-13.3265, 55.5962, -3.03401>, <-13.621, 56.3627, -2.5119>, <-13.04768, 55.8727, -3.3089> }
					triangle { <-13.621, 56.3627, -2.5119>, <-12.8787, 57.6549, -1.2789>, <-13.292, 56.7563, -2.869> }
					triangle { <-13.04768, 55.8727, -3.3089>, <-13.621, 56.3627, -2.5119>, <-13.292, 56.7563, -2.869> }
					triangle { <-12.6211, 56.2667, -3.55>, <-13.04768, 55.8727, -3.3089>, <-13.292, 56.7563, -2.869> }
					triangle { <-12.6211, 56.2667, -3.55>, <-13.292, 56.7563, -2.869>, <-12.8241, 57.09691, -3.1051> }
					triangle { <-13.292, 56.7563, -2.869>, <-12.8787, 57.6549, -1.2789>, <-12.1038, 58.4402, -1.1409> }
					triangle { <-12.8241, 57.09691, -3.1051>, <-13.292, 56.7563, -2.869>, <-12.1038, 58.4402, -1.1409> }
					triangle { <-12.2593, 54.2845, -4.758>, <-12.06902, 54.3948, -5.156>, <-11.709, 53.3217, -4.9004> }
					triangle { <-12.2593, 54.2845, -4.758>, <-12.1508, 55.02567, -5.08955>, <-12.06902, 54.3948, -5.156> }
					triangle { <-12.7549, 55.1134, -4.6612>, <-12.6517, 55.2454, -5.0257>, <-12.2593, 54.2845, -4.758> }
					triangle { <-12.7549, 55.1134, -4.6612>, <-12.2832, 56.4946, -3.9141>, <-12.6517, 55.2454, -5.0257> }
					triangle { <-12.6517, 55.2454, -5.0257>, <-12.1508, 55.02567, -5.08955>, <-12.2593, 54.2845, -4.758> }
					triangle { <-12.6517, 55.2454, -5.0257>, <-11.7709, 56.6794, -4.3453>, <-12.1508, 55.02567, -5.08955> }
					triangle { <-12.2832, 56.4946, -3.9141>, <-11.7709, 56.6794, -4.3453>, <-12.6517, 55.2454, -5.0257> }
					triangle { <-12.6211, 56.2667, -3.55>, <-12.2832, 56.4946, -3.9141>, <-12.7549, 55.1134, -4.6612> }
					triangle { <-12.2832, 56.4946, -3.9141>, <-11.7848, 57.5737, -3.8615>, <-11.7709, 56.6794, -4.3453> }
					triangle { <-12.3105, 57.4693, -3.3797>, <-11.664, 58.6125, -2.02607>, <-11.7848, 57.5737, -3.8615> }
					triangle { <-12.3105, 57.4693, -3.3797>, <-11.7848, 57.5737, -3.8615>, <-12.2832, 56.4946, -3.9141> }
					triangle { <-12.3105, 57.4693, -3.3797>, <-12.2832, 56.4946, -3.9141>, <-12.6211, 56.2667, -3.55> }
					triangle { <-12.8241, 57.09691, -3.1051>, <-12.3105, 57.4693, -3.3797>, <-12.6211, 56.2667, -3.55> }
					triangle { <-12.1038, 58.4402, -1.1409>, <-11.664, 58.6125, -2.02607>, <-12.3105, 57.4693, -3.3797> }
					triangle { <-12.1038, 58.4402, -1.1409>, <-12.3105, 57.4693, -3.3797>, <-12.8241, 57.09691, -3.1051> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-11.709, 53.3217, -4.9004>, <-12.1105, 54.2407, -4.6196>, <-12.1626, 54.3315, -5.057> }
					triangle { <-12.1105, 54.2407, -4.6196>, <-12.4646, 54.9295, -4.4344>, <-12.1626, 54.3315, -5.057> }
					triangle { <-12.1626, 54.3315, -5.057>, <-12.5118, 55.2892, -4.7954>, <-12.5856, 55.1958, -5.1844> }
					triangle { <-12.5118, 55.2892, -4.7954>, <-11.8964, 56.6056, -5.01571>, <-12.5856, 55.1958, -5.1844> }
					triangle { <-12.1626, 54.3315, -5.057>, <-12.4646, 54.9295, -4.4344>, <-12.5118, 55.2892, -4.7954> }
					triangle { <-12.4646, 54.9295, -4.4344>, <-11.7689, 56.6611, -4.5569>, <-12.5118, 55.2892, -4.7954> }
					triangle { <-12.5118, 55.2892, -4.7954>, <-11.7689, 56.6611, -4.5569>, <-11.8964, 56.6056, -5.01571> }
					triangle { <-12.5856, 55.1958, -5.1844>, <-11.8964, 56.6056, -5.01571>, <-11.9439, 56.5963, -5.6425> }
					triangle { <-11.7689, 56.6611, -4.5569>, <-11.7297, 57.6284, -4.6549>, <-11.8964, 56.6056, -5.01571> }
					triangle { <-11.7297, 57.6284, -4.6549>, <-10.6826, 58.9538, -5.5973>, <-11.9231, 57.5951, -5.2483> }
					triangle { <-11.8964, 56.6056, -5.01571>, <-11.7297, 57.6284, -4.6549>, <-11.9231, 57.5951, -5.2483> }
					triangle { <-11.9439, 56.5963, -5.6425>, <-11.8964, 56.6056, -5.01571>, <-11.9231, 57.5951, -5.2483> }
					triangle { <-11.9439, 56.5963, -5.6425>, <-11.9231, 57.5951, -5.2483>, <-11.9293, 57.5324, -5.8701> }
					triangle { <-11.9231, 57.5951, -5.2483>, <-10.6826, 58.9538, -5.5973>, <-10.3383, 59.2995, -6.5964> }
					triangle { <-11.9293, 57.5324, -5.8701>, <-11.9231, 57.5951, -5.2483>, <-10.3383, 59.2995, -6.5964> }
					triangle { <-12.1626, 54.3315, -5.057>, <-12.3931, 54.122, -5.3883>, <-11.709, 53.3217, -4.9004> }
					triangle { <-12.1626, 54.3315, -5.057>, <-12.5523, 54.6576, -5.6995>, <-12.3931, 54.122, -5.3883> }
					triangle { <-12.5856, 55.1958, -5.1844>, <-12.8452, 55.05534, -5.4559>, <-12.1626, 54.3315, -5.057> }
					triangle { <-12.5856, 55.1958, -5.1844>, <-12.09458, 56.433, -6.1419>, <-12.8452, 55.05534, -5.4559> }
					triangle { <-12.8452, 55.05534, -5.4559>, <-12.5523, 54.6576, -5.6995>, <-12.1626, 54.3315, -5.057> }
					triangle { <-12.8452, 55.05534, -5.4559>, <-12.1869, 56.1317, -6.7609>, <-12.5523, 54.6576, -5.6995> }
					triangle { <-12.09458, 56.433, -6.1419>, <-12.1869, 56.1317, -6.7609>, <-12.8452, 55.05534, -5.4559> }
					triangle { <-11.9439, 56.5963, -5.6425>, <-12.09458, 56.433, -6.1419>, <-12.5856, 55.1958, -5.1844> }
					triangle { <-12.09458, 56.433, -6.1419>, <-12.05093, 57.06063, -7.1517>, <-12.1869, 56.1317, -6.7609> }
					triangle { <-11.9477, 57.454, -6.5568>, <-10.8224, 58.7727, -7.2997>, <-12.05093, 57.06063, -7.1517> }
					triangle { <-11.9477, 57.454, -6.5568>, <-12.05093, 57.06063, -7.1517>, <-12.09458, 56.433, -6.1419> }
					triangle { <-11.9477, 57.454, -6.5568>, <-12.09458, 56.433, -6.1419>, <-11.9439, 56.5963, -5.6425> }
					triangle { <-11.9293, 57.5324, -5.8701>, <-11.9477, 57.454, -6.5568>, <-11.9439, 56.5963, -5.6425> }
					triangle { <-10.3383, 59.2995, -6.5964>, <-10.8224, 58.7727, -7.2997>, <-11.9477, 57.454, -6.5568> }
					triangle { <-10.3383, 59.2995, -6.5964>, <-11.9477, 57.454, -6.5568>, <-11.9293, 57.5324, -5.8701> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-11.709, 53.3217, -4.9004>, <-11.9585, 54.3143, -5.09277>, <-12.3527, 54.1662, -5.2504> }
					triangle { <-11.9585, 54.3143, -5.09277>, <-12.1955, 55.0661, -5.2067>, <-12.3527, 54.1662, -5.2504> }
					triangle { <-12.3527, 54.1662, -5.2504>, <-12.5975, 55.1562, -5.5104>, <-12.9183, 54.9064, -5.523> }
					triangle { <-12.5975, 55.1562, -5.5104>, <-12.7616, 55.7651, -6.8379>, <-12.9183, 54.9064, -5.523> }
					triangle { <-12.3527, 54.1662, -5.2504>, <-12.1955, 55.0661, -5.2067>, <-12.5975, 55.1562, -5.5104> }
					triangle { <-12.1955, 55.0661, -5.2067>, <-12.346, 56.00312, -6.8182>, <-12.5975, 55.1562, -5.5104> }
					triangle { <-12.5975, 55.1562, -5.5104>, <-12.346, 56.00312, -6.8182>, <-12.7616, 55.7651, -6.8379> }
					triangle { <-12.9183, 54.9064, -5.523>, <-12.7616, 55.7651, -6.8379>, <-13.2748, 55.4386, -6.9969> }
					triangle { <-12.346, 56.00312, -6.8182>, <-12.6521, 56.6503, -7.477>, <-12.7616, 55.7651, -6.8379> }
					triangle { <-12.6521, 56.6503, -7.477>, <-13.1355, 56.7031, -9.3491>, <-13.2161, 56.3826, -7.5059> }
					triangle { <-12.7616, 55.7651, -6.8379>, <-12.6521, 56.6503, -7.477>, <-13.2161, 56.3826, -7.5059> }
					triangle { <-13.2748, 55.4386, -6.9969>, <-12.7616, 55.7651, -6.8379>, <-13.2161, 56.3826, -7.5059> }
					triangle { <-13.2748, 55.4386, -6.9969>, <-13.2161, 56.3826, -7.5059>, <-13.6879, 56.00269, -7.6599> }
					triangle { <-13.2161, 56.3826, -7.5059>, <-13.1355, 56.7031, -9.3491>, <-13.808, 56.2814, -10.1276> }
					triangle { <-13.6879, 56.00269, -7.6599>, <-13.2161, 56.3826, -7.5059>, <-13.808, 56.2814, -10.1276> }
					triangle { <-12.3527, 54.1662, -5.2504>, <-12.6876, 53.9244, -5.06036>, <-11.709, 53.3217, -4.9004> }
					triangle { <-12.3527, 54.1662, -5.2504>, <-13.1605, 54.2164, -5.3768>, <-12.6876, 53.9244, -5.06036> }
					triangle { <-12.9183, 54.9064, -5.523>, <-13.2412, 54.7597, -5.3357>, <-12.3527, 54.1662, -5.2504> }
					triangle { <-12.9183, 54.9064, -5.523>, <-13.7072, 55.1083, -6.9461>, <-13.2412, 54.7597, -5.3357> }
					triangle { <-13.2412, 54.7597, -5.3357>, <-13.1605, 54.2164, -5.3768>, <-12.3527, 54.1662, -5.2504> }
					triangle { <-13.2412, 54.7597, -5.3357>, <-14.1638, 54.5878, -6.8896>, <-13.1605, 54.2164, -5.3768> }
					triangle { <-13.7072, 55.1083, -6.9461>, <-14.1638, 54.5878, -6.8896>, <-13.2412, 54.7597, -5.3357> }
					triangle { <-13.2748, 55.4386, -6.9969>, <-13.7072, 55.1083, -6.9461>, <-12.9183, 54.9064, -5.523> }
					triangle { <-13.7072, 55.1083, -6.9461>, <-14.633, 55.00983, -7.687>, <-14.1638, 54.5878, -6.8896> }
					triangle { <-14.2131, 55.5811, -7.8161>, <-14.4946, 55.7053, -9.6768>, <-14.633, 55.00983, -7.687> }
					triangle { <-14.2131, 55.5811, -7.8161>, <-14.633, 55.00983, -7.687>, <-13.7072, 55.1083, -6.9461> }
					triangle { <-14.2131, 55.5811, -7.8161>, <-13.7072, 55.1083, -6.9461>, <-13.2748, 55.4386, -6.9969> }
					triangle { <-13.6879, 56.00269, -7.6599>, <-14.2131, 55.5811, -7.8161>, <-13.2748, 55.4386, -6.9969> }
					triangle { <-13.808, 56.2814, -10.1276>, <-14.4946, 55.7053, -9.6768>, <-14.2131, 55.5811, -7.8161> }
					triangle { <-13.808, 56.2814, -10.1276>, <-14.2131, 55.5811, -7.8161>, <-13.6879, 56.00269, -7.6599> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-11.709, 53.3217, -4.9004>, <-12.2598, 54.05246, -5.3976>, <-12.5687, 54.01538, -5.07295> }
					triangle { <-12.2598, 54.05246, -5.3976>, <-12.6796, 54.6421, -5.7297>, <-12.5687, 54.01538, -5.07295> }
					triangle { <-12.5687, 54.01538, -5.07295>, <-13.1688, 54.7057, -5.5933>, <-13.2963, 54.6424, -5.2123> }
					triangle { <-13.1688, 54.7057, -5.5933>, <-14.4557, 54.505, -6.2743>, <-13.2963, 54.6424, -5.2123> }
					triangle { <-12.5687, 54.01538, -5.07295>, <-12.6796, 54.6421, -5.7297>, <-13.1688, 54.7057, -5.5933> }
					triangle { <-12.6796, 54.6421, -5.7297>, <-14.2655, 54.5253, -6.7139>, <-13.1688, 54.7057, -5.5933> }
					triangle { <-13.1688, 54.7057, -5.5933>, <-14.2655, 54.5253, -6.7139>, <-14.4557, 54.505, -6.2743> }
					triangle { <-13.2963, 54.6424, -5.2123>, <-14.4557, 54.505, -6.2743>, <-14.7869, 54.3828, -5.7541> }
					triangle { <-14.2655, 54.5253, -6.7139>, <-15.1222, 54.771, -7.1045>, <-14.4557, 54.505, -6.2743> }
					triangle { <-15.1222, 54.771, -7.1045>, <-16.8703, 53.9922, -7.3845>, <-15.3962, 54.783, -6.5429> }
					triangle { <-14.4557, 54.505, -6.2743>, <-15.1222, 54.771, -7.1045>, <-15.3962, 54.783, -6.5429> }
					triangle { <-14.7869, 54.3828, -5.7541>, <-14.4557, 54.505, -6.2743>, <-15.3962, 54.783, -6.5429> }
					triangle { <-14.7869, 54.3828, -5.7541>, <-15.3962, 54.783, -6.5429>, <-15.686, 54.6074, -6.01773> }
					triangle { <-15.3962, 54.783, -6.5429>, <-16.8703, 53.9922, -7.3845>, <-17.7503, 53.5287, -6.8875> }
					triangle { <-15.686, 54.6074, -6.01773>, <-15.3962, 54.783, -6.5429>, <-17.7503, 53.5287, -6.8875> }
					triangle { <-12.5687, 54.01538, -5.07295>, <-12.5483, 54.0732, -4.6223>, <-11.709, 53.3217, -4.9004> }
					triangle { <-12.5687, 54.01538, -5.07295>, <-13.1405, 54.3076, -4.5644>, <-12.5483, 54.0732, -4.6223> }
					triangle { <-13.2963, 54.6424, -5.2123>, <-13.2961, 54.7642, -4.8302>, <-12.5687, 54.01538, -5.07295> }
					triangle { <-13.2963, 54.6424, -5.2123>, <-14.9076, 54.3388, -5.2229>, <-13.2961, 54.7642, -4.8302> }
					triangle { <-13.2961, 54.7642, -4.8302>, <-13.1405, 54.3076, -4.5644>, <-12.5687, 54.01538, -5.07295> }
					triangle { <-13.2961, 54.7642, -4.8302>, <-14.988, 54.1669, -4.5546>, <-13.1405, 54.3076, -4.5644> }
					triangle { <-14.9076, 54.3388, -5.2229>, <-14.988, 54.1669, -4.5546>, <-13.2961, 54.7642, -4.8302> }
					triangle { <-14.7869, 54.3828, -5.7541>, <-14.9076, 54.3388, -5.2229>, <-13.2963, 54.6424, -5.2123> }
					triangle { <-14.9076, 54.3388, -5.2229>, <-15.9868, 54.2363, -4.7326>, <-14.988, 54.1669, -4.5546> }
					triangle { <-15.9971, 54.4213, -5.429>, <-17.6401, 53.6207, -5.8945>, <-15.9868, 54.2363, -4.7326> }
					triangle { <-15.9971, 54.4213, -5.429>, <-15.9868, 54.2363, -4.7326>, <-14.9076, 54.3388, -5.2229> }
					triangle { <-15.9971, 54.4213, -5.429>, <-14.9076, 54.3388, -5.2229>, <-14.7869, 54.3828, -5.7541> }
					triangle { <-15.686, 54.6074, -6.01773>, <-15.9971, 54.4213, -5.429>, <-14.7869, 54.3828, -5.7541> }
					triangle { <-17.7503, 53.5287, -6.8875>, <-17.6401, 53.6207, -5.8945>, <-15.9971, 54.4213, -5.429> }
					triangle { <-17.7503, 53.5287, -6.8875>, <-15.9971, 54.4213, -5.429>, <-15.686, 54.6074, -6.01773> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-11.709, 53.3217, -4.9004>, <-12.604, 53.8129, -5.1059>, <-12.5101, 54.08959, -4.764> }
					triangle { <-12.604, 53.8129, -5.1059>, <-13.2582, 54.2367, -5.2692>, <-12.5101, 54.08959, -4.764> }
					triangle { <-12.5101, 54.08959, -4.764>, <-13.4398, 54.559, -4.9154>, <-13.1938, 54.7723, -4.6717> }
					triangle { <-13.4398, 54.559, -4.9154>, <-14.6351, 54.5724, -4.06044>, <-13.1938, 54.7723, -4.6717> }
					triangle { <-12.5101, 54.08959, -4.764>, <-13.2582, 54.2367, -5.2692>, <-13.4398, 54.559, -4.9154> }
					triangle { <-13.2582, 54.2367, -5.2692>, <-14.8807, 54.2701, -4.3398>, <-13.4398, 54.559, -4.9154> }
					triangle { <-13.4398, 54.559, -4.9154>, <-14.8807, 54.2701, -4.3398>, <-14.6351, 54.5724, -4.06044> }
					triangle { <-13.1938, 54.7723, -4.6717>, <-14.6351, 54.5724, -4.06044>, <-14.3768, 54.9023, -3.5916> }
					triangle { <-14.8807, 54.2701, -4.3398>, <-15.73, 54.5906, -3.9895>, <-14.6351, 54.5724, -4.06044> }
					triangle { <-15.73, 54.5906, -3.9895>, <-16.7092, 54.5893, -2.3216>, <-15.4438, 55.01755, -3.6338> }
					triangle { <-14.6351, 54.5724, -4.06044>, <-15.73, 54.5906, -3.9895>, <-15.4438, 55.01755, -3.6338> }
					triangle { <-14.3768, 54.9023, -3.5916>, <-14.6351, 54.5724, -4.06044>, <-15.4438, 55.01755, -3.6338> }
					triangle { <-14.3768, 54.9023, -3.5916>, <-15.4438, 55.01755, -3.6338>, <-15.1441, 55.2939, -3.1601> }
					triangle { <-15.4438, 55.01755, -3.6338>, <-16.7092, 54.5893, -2.3216>, <-16.6811, 54.8831, -1.2496> }
					triangle { <-15.1441, 55.2939, -3.1601>, <-15.4438, 55.01755, -3.6338>, <-16.6811, 54.8831, -1.2496> }
					triangle { <-12.5101, 54.08959, -4.764>, <-12.1602, 54.3683, -4.6823>, <-11.709, 53.3217, -4.9004> }
					triangle { <-12.5101, 54.08959, -4.764>, <-12.5071, 54.8153, -4.3842>, <-12.1602, 54.3683, -4.6823> }
					triangle { <-13.1938, 54.7723, -4.6717>, <-12.9263, 55.06901, -4.6356>, <-12.5101, 54.08959, -4.764> }
					triangle { <-13.1938, 54.7723, -4.6717>, <-14.01426, 55.2086, -3.3207>, <-12.9263, 55.06901, -4.6356> }
					triangle { <-12.9263, 55.06901, -4.6356>, <-12.5071, 54.8153, -4.3842>, <-12.5101, 54.08959, -4.764> }
					triangle { <-12.9263, 55.06901, -4.6356>, <-13.4868, 55.4791, -2.9585>, <-12.5071, 54.8153, -4.3842> }
					triangle { <-14.01426, 55.2086, -3.3207>, <-13.4868, 55.4791, -2.9585>, <-12.9263, 55.06901, -4.6356> }
					triangle { <-14.3768, 54.9023, -3.5916>, <-14.01426, 55.2086, -3.3207>, <-13.1938, 54.7723, -4.6717> }
					triangle { <-14.01426, 55.2086, -3.3207>, <-14.2, 55.8448, -2.3326>, <-13.4868, 55.4791, -2.9585> }
					triangle { <-14.8035, 55.6059, -2.6458>, <-15.8643, 55.4445, -1.09475>, <-14.2, 55.8448, -2.3326> }
					triangle { <-14.8035, 55.6059, -2.6458>, <-14.2, 55.8448, -2.3326>, <-14.01426, 55.2086, -3.3207> }
					triangle { <-14.8035, 55.6059, -2.6458>, <-14.01426, 55.2086, -3.3207>, <-14.3768, 54.9023, -3.5916> }
					triangle { <-15.1441, 55.2939, -3.1601>, <-14.8035, 55.6059, -2.6458>, <-14.3768, 54.9023, -3.5916> }
					triangle { <-16.6811, 54.8831, -1.2496>, <-15.8643, 55.4445, -1.09475>, <-14.8035, 55.6059, -2.6458> }
					triangle { <-16.6811, 54.8831, -1.2496>, <-14.8035, 55.6059, -2.6458>, <-15.1441, 55.2939, -3.1601> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		union { // inflor. internode
			cylinder { <0.6737, 12.1539, 0.25>, <0.8434, 13.4295, 0.05774>, 0.3888 }
			cylinder { <0.8434, 13.4295, 0.05774>, <0.9238, 14.7152, -0.1257>, 0.3888 }
			cylinder { <0.9238, 14.7152, -0.1257>, <0.9145, 16.00465, -0.2995>, 0.3888 }
			cylinder { <0.9145, 16.00465, -0.2995>, <0.8155, 17.2916, -0.4631>, 0.3888 }
			cylinder { <0.8155, 17.2916, -0.4631>, <0.6273, 18.5701, -0.6156>, 0.3888 }
			cylinder { <0.6273, 18.5701, -0.6156>, <0.3508, 19.8337, -0.7564>, 0.3888 }
			cylinder { <0.3508, 19.8337, -0.7564>, <-0.01256, 21.07645, -0.885>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.01256, 21.07645, -0.885>, <-1.195, 27.3395, -1.04306>, 0.3888 }
				cylinder { <-1.195, 27.3395, -1.04306>, <-1.7612, 33.6821, -0.7264>, 0.3888 }
				cylinder { <-1.7612, 33.6821, -0.7264>, <-1.7025, 40.0088, 0.06007>, 0.3888 }
				cylinder { <-1.7025, 40.0088, 0.06007>, <-1.02005, 46.2244, 1.3046>, 0.3888 }
				cylinder { <-1.02005, 46.2244, 1.3046>, <0.2761, 52.2355, 2.9885>, 0.3888 }
				cylinder { <0.2761, 52.2355, 2.9885>, <2.1664, 57.9517, 5.08636>, 0.3888 }
				cylinder { <2.1664, 57.9517, 5.08636>, <4.6225, 63.287, 7.5666>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <4.6225, 63.287, 7.5666>, <5.322, 63.894, 7.8139>, <5.06218, 64.2038, 7.7256> }
					triangle { <5.322, 63.894, 7.8139>, <5.8239, 64.3789, 8.03833>, <5.06218, 64.2038, 7.7256> }
					triangle { <5.06218, 64.2038, 7.7256>, <5.7755, 64.8311, 7.9154>, <5.44, 64.9958, 7.8933> }
					triangle { <5.7755, 64.8311, 7.9154>, <6.4451, 65.6572, 7.07935>, <5.44, 64.9958, 7.8933> }
					triangle { <5.06218, 64.2038, 7.7256>, <5.8239, 64.3789, 8.03833>, <5.7755, 64.8311, 7.9154> }
					triangle { <5.8239, 64.3789, 8.03833>, <6.8125, 65.4128, 7.08088>, <5.7755, 64.8311, 7.9154> }
					triangle { <5.7755, 64.8311, 7.9154>, <6.8125, 65.4128, 7.08088>, <6.4451, 65.6572, 7.07935> }
					triangle { <5.44, 64.9958, 7.8933>, <6.4451, 65.6572, 7.07935>, <5.9935, 65.9972, 6.9557> }
					triangle { <6.8125, 65.4128, 7.08088>, <7.3126, 66.1153, 6.8389>, <6.4451, 65.6572, 7.07935> }
					triangle { <7.3126, 66.1153, 6.8389>, <7.5171, 67.1945, 5.4379>, <6.8575, 66.4668, 6.8543> }
					triangle { <6.4451, 65.6572, 7.07935>, <7.3126, 66.1153, 6.8389>, <6.8575, 66.4668, 6.8543> }
					triangle { <5.9935, 65.9972, 6.9557>, <6.4451, 65.6572, 7.07935>, <6.8575, 66.4668, 6.8543> }
					triangle { <5.9935, 65.9972, 6.9557>, <6.8575, 66.4668, 6.8543>, <6.3818, 66.7546, 6.7064> }
					triangle { <6.8575, 66.4668, 6.8543>, <7.5171, 67.1945, 5.4379>, <7.04568, 67.852, 4.8111> }
					triangle { <6.3818, 66.7546, 6.7064>, <6.8575, 66.4668, 6.8543>, <7.04568, 67.852, 4.8111> }
					triangle { <5.06218, 64.2038, 7.7256>, <4.6854, 64.3075, 7.8755>, <4.6225, 63.287, 7.5666> }
					triangle { <5.06218, 64.2038, 7.7256>, <4.765, 64.8889, 7.8292>, <4.6854, 64.3075, 7.8755> }
					triangle { <5.44, 64.9958, 7.8933>, <5.1431, 65.1243, 8.0713>, <5.06218, 64.2038, 7.7256> }
					triangle { <5.44, 64.9958, 7.8933>, <5.5324, 66.1965, 6.9835>, <5.1431, 65.1243, 8.0713> }
					triangle { <5.1431, 65.1243, 8.0713>, <4.765, 64.8889, 7.8292>, <5.06218, 64.2038, 7.7256> }
					triangle { <5.1431, 65.1243, 8.0713>, <4.9114, 66.3463, 6.9555>, <4.765, 64.8889, 7.8292> }
					triangle { <5.5324, 66.1965, 6.9835>, <4.9114, 66.3463, 6.9555>, <5.1431, 65.1243, 8.0713> }
					triangle { <5.9935, 65.9972, 6.9557>, <5.5324, 66.1965, 6.9835>, <5.44, 64.9958, 7.8933> }
					triangle { <5.5324, 66.1965, 6.9835>, <5.1914, 67.147, 6.5598>, <4.9114, 66.3463, 6.9555> }
					triangle { <5.8502, 67.06981, 6.5548>, <6.1983, 68.01443, 5.1405>, <5.1914, 67.147, 6.5598> }
					triangle { <5.8502, 67.06981, 6.5548>, <5.1914, 67.147, 6.5598>, <5.5324, 66.1965, 6.9835> }
					triangle { <5.8502, 67.06981, 6.5548>, <5.5324, 66.1965, 6.9835>, <5.9935, 65.9972, 6.9557> }
					triangle { <6.3818, 66.7546, 6.7064>, <5.8502, 67.06981, 6.5548>, <5.9935, 65.9972, 6.9557> }
					triangle { <7.04568, 67.852, 4.8111>, <6.1983, 68.01443, 5.1405>, <5.8502, 67.06981, 6.5548> }
					triangle { <7.04568, 67.852, 4.8111>, <5.8502, 67.06981, 6.5548>, <6.3818, 66.7546, 6.7064> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <4.6225, 63.287, 7.5666>, <5.04516, 64.1471, 7.5436>, <4.812, 64.2522, 7.869> }
					triangle { <5.04516, 64.1471, 7.5436>, <5.3832, 64.7967, 7.5759>, <4.812, 64.2522, 7.869> }
					triangle { <4.812, 64.2522, 7.869>, <5.1859, 65.1448, 7.8245>, <5.002235, 65.08067, 8.1444> }
					triangle { <5.1859, 65.1448, 7.8245>, <4.5914, 66.3155, 7.4989>, <5.002235, 65.08067, 8.1444> }
					triangle { <4.812, 64.2522, 7.869>, <5.3832, 64.7967, 7.5759>, <5.1859, 65.1448, 7.8245> }
					triangle { <5.3832, 64.7967, 7.5759>, <4.7816, 66.3382, 7.1014>, <5.1859, 65.1448, 7.8245> }
					triangle { <5.1859, 65.1448, 7.8245>, <4.7816, 66.3382, 7.1014>, <4.5914, 66.3155, 7.4989> }
					triangle { <5.002235, 65.08067, 8.1444>, <4.5914, 66.3155, 7.4989>, <4.2423, 66.3364, 7.96> }
					triangle { <4.7816, 66.3382, 7.1014>, <4.6683, 67.226, 7.06842>, <4.5914, 66.3155, 7.4989> }
					triangle { <4.6683, 67.226, 7.06842>, <3.336, 68.4034, 6.9778>, <4.4408, 67.2341, 7.5967> }
					triangle { <4.5914, 66.3155, 7.4989>, <4.6683, 67.226, 7.06842>, <4.4408, 67.2341, 7.5967> }
					triangle { <4.2423, 66.3364, 7.96>, <4.5914, 66.3155, 7.4989>, <4.4408, 67.2341, 7.5967> }
					triangle { <4.2423, 66.3364, 7.96>, <4.4408, 67.2341, 7.5967>, <4.06784, 67.2028, 8.03363> }
					triangle { <4.4408, 67.2341, 7.5967>, <3.336, 68.4034, 6.9778>, <2.4802, 68.7364, 7.4296> }
					triangle { <4.06784, 67.2028, 8.03363>, <4.4408, 67.2341, 7.5967>, <2.4802, 68.7364, 7.4296> }
					triangle { <4.812, 64.2522, 7.869>, <4.7746, 64.09079, 8.2534>, <4.6225, 63.287, 7.5666> }
					triangle { <4.812, 64.2522, 7.869>, <4.68, 64.6062, 8.5216>, <4.7746, 64.09079, 8.2534> }
					triangle { <5.002235, 65.08067, 8.1444>, <5.01954, 64.982, 8.4997>, <4.812, 64.2522, 7.869> }
					triangle { <5.002235, 65.08067, 8.1444>, <4.04628, 66.2184, 8.408>, <5.01954, 64.982, 8.4997> }
					triangle { <5.01954, 64.982, 8.4997>, <4.68, 64.6062, 8.5216>, <4.812, 64.2522, 7.869> }
					triangle { <5.01954, 64.982, 8.4997>, <3.7408, 65.9746, 8.9141>, <4.68, 64.6062, 8.5216> }
					triangle { <4.04628, 66.2184, 8.408>, <3.7408, 65.9746, 8.9141>, <5.01954, 64.982, 8.4997> }
					triangle { <4.2423, 66.3364, 7.96>, <4.04628, 66.2184, 8.408>, <5.002235, 65.08067, 8.1444> }
					triangle { <4.04628, 66.2184, 8.408>, <3.3835, 66.8323, 9.02708>, <3.7408, 65.9746, 8.9141> }
					triangle { <3.6641, 67.1607, 8.5237>, <2.3996, 68.318, 8.2489>, <3.3835, 66.8323, 9.02708> }
					triangle { <3.6641, 67.1607, 8.5237>, <3.3835, 66.8323, 9.02708>, <4.04628, 66.2184, 8.408> }
					triangle { <3.6641, 67.1607, 8.5237>, <4.04628, 66.2184, 8.408>, <4.2423, 66.3364, 7.96> }
					triangle { <4.06784, 67.2028, 8.03363>, <3.6641, 67.1607, 8.5237>, <4.2423, 66.3364, 7.96> }
					triangle { <2.4802, 68.7364, 7.4296>, <2.3996, 68.318, 8.2489>, <3.6641, 67.1607, 8.5237> }
					triangle { <2.4802, 68.7364, 7.4296>, <3.6641, 67.1607, 8.5237>, <4.06784, 67.2028, 8.03363> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <4.6225, 63.287, 7.5666>, <4.65, 64.2231, 7.7714>, <4.8296, 64.1226, 8.1305> }
					triangle { <4.65, 64.2231, 7.7714>, <4.7232, 64.9341, 7.9338>, <4.8296, 64.1226, 8.1305> }
					triangle { <4.8296, 64.1226, 8.1305>, <4.8128, 65.05869, 8.3792>, <5.03309, 64.8537, 8.602> }
					triangle { <4.8128, 65.05869, 8.3792>, <4.1001, 65.6838, 9.3443>, <5.03309, 64.8537, 8.602> }
					triangle { <4.8296, 64.1226, 8.1305>, <4.7232, 64.9341, 7.9338>, <4.8128, 65.05869, 8.3792> }
					triangle { <4.7232, 64.9341, 7.9338>, <3.8191, 65.8707, 9.06013>, <4.8128, 65.05869, 8.3792> }
					triangle { <4.8128, 65.05869, 8.3792>, <3.8191, 65.8707, 9.06013>, <4.1001, 65.6838, 9.3443> }
					triangle { <5.03309, 64.8537, 8.602>, <4.1001, 65.6838, 9.3443>, <4.3658, 65.4286, 9.7906> }
					triangle { <3.8191, 65.8707, 9.06013>, <3.6108, 66.5136, 9.6478>, <4.1001, 65.6838, 9.3443> }
					triangle { <3.6108, 66.5136, 9.6478>, <2.8015, 66.6748, 11.2253>, <3.9893, 66.3106, 10.03058> }
					triangle { <4.1001, 65.6838, 9.3443>, <3.6108, 66.5136, 9.6478>, <3.9893, 66.3106, 10.03058> }
					triangle { <4.3658, 65.4286, 9.7906>, <4.1001, 65.6838, 9.3443>, <3.9893, 66.3106, 10.03058> }
					triangle { <4.3658, 65.4286, 9.7906>, <3.9893, 66.3106, 10.03058>, <4.2309, 66.00321, 10.4525> }
					triangle { <3.9893, 66.3106, 10.03058>, <2.8015, 66.6748, 11.2253>, <2.802, 66.3695, 12.2021> }
					triangle { <4.2309, 66.00321, 10.4525>, <3.9893, 66.3106, 10.03058>, <2.802, 66.3695, 12.2021> }
					triangle { <4.8296, 64.1226, 8.1305>, <5.183, 63.9175, 8.2217>, <4.6225, 63.287, 7.5666> }
					triangle { <4.8296, 64.1226, 8.1305>, <5.3079, 64.2328, 8.7028>, <5.183, 63.9175, 8.2217> }
					triangle { <5.03309, 64.8537, 8.602>, <5.3737, 64.735, 8.6804>, <4.8296, 64.1226, 8.1305> }
					triangle { <5.03309, 64.8537, 8.602>, <4.7038, 65.1552, 10.0438>, <5.3737, 64.735, 8.6804> }
					triangle { <5.3737, 64.735, 8.6804>, <5.3079, 64.2328, 8.7028>, <4.8296, 64.1226, 8.1305> }
					triangle { <5.3737, 64.735, 8.6804>, <5.06728, 64.7091, 10.3227>, <5.3079, 64.2328, 8.7028> }
					triangle { <4.7038, 65.1552, 10.0438>, <5.06728, 64.7091, 10.3227>, <5.3737, 64.735, 8.6804> }
					triangle { <4.3658, 65.4286, 9.7906>, <4.7038, 65.1552, 10.0438>, <5.03309, 64.8537, 8.602> }
					triangle { <4.7038, 65.1552, 10.0438>, <4.893, 65.1633, 11.1224>, <5.06728, 64.7091, 10.3227> }
					triangle { <4.5093, 65.6616, 10.9116>, <3.5658, 65.873, 12.3534>, <4.893, 65.1633, 11.1224> }
					triangle { <4.5093, 65.6616, 10.9116>, <4.893, 65.1633, 11.1224>, <4.7038, 65.1552, 10.0438> }
					triangle { <4.5093, 65.6616, 10.9116>, <4.7038, 65.1552, 10.0438>, <4.3658, 65.4286, 9.7906> }
					triangle { <4.2309, 66.00321, 10.4525>, <4.5093, 65.6616, 10.9116>, <4.3658, 65.4286, 9.7906> }
					triangle { <2.802, 66.3695, 12.2021>, <3.5658, 65.873, 12.3534>, <4.5093, 65.6616, 10.9116> }
					triangle { <2.802, 66.3695, 12.2021>, <4.5093, 65.6616, 10.9116>, <4.2309, 66.00321, 10.4525> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <4.6225, 63.287, 7.5666>, <4.679, 64.01764, 8.1846>, <5.09088, 63.9927, 8.1511> }
					triangle { <4.679, 64.01764, 8.1846>, <4.7498, 64.6025, 8.6207>, <5.09088, 63.9927, 8.1511> }
					triangle { <5.09088, 63.9927, 8.1511>, <5.1683, 64.6909, 8.8182>, <5.4902, 64.6265, 8.6381> }
					triangle { <5.1683, 64.6909, 8.8182>, <5.6457, 64.6291, 10.08248>, <5.4902, 64.6265, 8.6381> }
					triangle { <5.09088, 63.9927, 8.1511>, <4.7498, 64.6025, 8.6207>, <5.1683, 64.6909, 8.8182> }
					triangle { <4.7498, 64.6025, 8.6207>, <5.2461, 64.6521, 10.2683>, <5.1683, 64.6909, 8.8182> }
					triangle { <5.1683, 64.6909, 8.8182>, <5.2461, 64.6521, 10.2683>, <5.6457, 64.6291, 10.08248> }
					triangle { <5.4902, 64.6265, 8.6381>, <5.6457, 64.6291, 10.08248>, <6.1944, 64.5198, 9.9346> }
					triangle { <5.2461, 64.6521, 10.2683>, <5.5918, 64.9561, 11.03661>, <5.6457, 64.6291, 10.08248> }
					triangle { <5.5918, 64.9561, 11.03661>, <6.6473, 64.3815, 12.3501>, <6.1226, 64.9638, 10.815> }
					triangle { <5.6457, 64.6291, 10.08248>, <5.5918, 64.9561, 11.03661>, <6.1226, 64.9638, 10.815> }
					triangle { <6.1944, 64.5198, 9.9346>, <5.6457, 64.6291, 10.08248>, <6.1226, 64.9638, 10.815> }
					triangle { <6.1944, 64.5198, 9.9346>, <6.1226, 64.9638, 10.815>, <6.6473, 64.8023, 10.6429> }
					triangle { <6.1226, 64.9638, 10.815>, <6.6473, 64.3815, 12.3501>, <7.5694, 64.00037, 12.5777> }
					triangle { <6.6473, 64.8023, 10.6429>, <6.1226, 64.9638, 10.815>, <7.5694, 64.00037, 12.5777> }
					triangle { <5.09088, 63.9927, 8.1511>, <5.3499, 64.02564, 7.8239>, <4.6225, 63.287, 7.5666> }
					triangle { <5.09088, 63.9927, 8.1511>, <5.7869, 64.2814, 8.1242>, <5.3499, 64.02564, 7.8239> }
					triangle { <5.4902, 64.6265, 8.6381>, <5.7196, 64.7223, 8.3652>, <5.09088, 63.9927, 8.1511> }
					triangle { <5.4902, 64.6265, 8.6381>, <6.6026, 64.4663, 9.6454>, <5.7196, 64.7223, 8.3652> }
					triangle { <5.7196, 64.7223, 8.3652>, <5.7869, 64.2814, 8.1242>, <5.09088, 63.9927, 8.1511> }
					triangle { <5.7196, 64.7223, 8.3652>, <7.07, 64.2869, 9.2477>, <5.7869, 64.2814, 8.1242> }
					triangle { <6.6026, 64.4663, 9.6454>, <7.07, 64.2869, 9.2477>, <5.7196, 64.7223, 8.3652> }
					triangle { <6.1944, 64.5198, 9.9346>, <6.6026, 64.4663, 9.6454>, <5.4902, 64.6265, 8.6381> }
					triangle { <6.6026, 64.4663, 9.6454>, <7.648, 64.4309, 9.9697>, <7.07, 64.2869, 9.2477> }
					triangle { <7.2256, 64.6301, 10.4407>, <8.09616, 64.03557, 11.82>, <7.648, 64.4309, 9.9697> }
					triangle { <7.2256, 64.6301, 10.4407>, <7.648, 64.4309, 9.9697>, <6.6026, 64.4663, 9.6454> }
					triangle { <7.2256, 64.6301, 10.4407>, <6.6026, 64.4663, 9.6454>, <6.1944, 64.5198, 9.9346> }
					triangle { <6.6473, 64.8023, 10.6429>, <7.2256, 64.6301, 10.4407>, <6.1944, 64.5198, 9.9346> }
					triangle { <7.5694, 64.00037, 12.5777>, <8.09616, 64.03557, 11.82>, <7.2256, 64.6301, 10.4407> }
					triangle { <7.5694, 64.00037, 12.5777>, <7.2256, 64.6301, 10.4407>, <6.6473, 64.8023, 10.6429> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <4.6225, 63.287, 7.5666>, <5.1006, 63.8111, 8.2113>, <5.2367, 64.04374, 7.8971> }
					triangle { <5.1006, 63.8111, 8.2113>, <5.4403, 64.2542, 8.6863>, <5.2367, 64.04374, 7.8971> }
					triangle { <5.2367, 64.04374, 7.8971>, <5.7723, 64.5482, 8.5272>, <5.7455, 64.7157, 8.1934> }
					triangle { <5.7723, 64.5482, 8.5272>, <7.1169, 64.6125, 8.6615>, <5.7455, 64.7157, 8.1934> }
					triangle { <5.2367, 64.04374, 7.8971>, <5.4403, 64.2542, 8.6863>, <5.7723, 64.5482, 8.5272> }
					triangle { <5.4403, 64.2542, 8.6863>, <7.1241, 64.3648, 9.02661>, <5.7723, 64.5482, 8.5272> }
					triangle { <5.7723, 64.5482, 8.5272>, <7.1241, 64.3648, 9.02661>, <7.1169, 64.6125, 8.6615> }
					triangle { <5.7455, 64.7157, 8.1934>, <7.1169, 64.6125, 8.6615>, <7.2155, 64.8765, 8.1561> }
					triangle { <7.1241, 64.3648, 9.02661>, <7.9142, 64.7062, 9.2744>, <7.1169, 64.6125, 8.6615> }
					triangle { <7.9142, 64.7062, 9.2744>, <9.6057, 64.7075, 8.7193>, <7.922, 65.0619, 8.8223> }
					triangle { <7.1169, 64.6125, 8.6615>, <7.9142, 64.7062, 9.2744>, <7.922, 65.0619, 8.8223> }
					triangle { <7.2155, 64.8765, 8.1561>, <7.1169, 64.6125, 8.6615>, <7.922, 65.0619, 8.8223> }
					triangle { <7.2155, 64.8765, 8.1561>, <7.922, 65.0619, 8.8223>, <7.9966, 65.2737, 8.2927> }
					triangle { <7.922, 65.0619, 8.8223>, <9.6057, 64.7075, 8.7193>, <10.2317, 64.9304, 7.9409> }
					triangle { <7.9966, 65.2737, 8.2927>, <7.922, 65.0619, 8.8223>, <10.2317, 64.9304, 7.9409> }
					triangle { <5.2367, 64.04374, 7.8971>, <5.03772, 64.2703, 7.6068>, <4.6225, 63.287, 7.5666> }
					triangle { <5.2367, 64.04374, 7.8971>, <5.4462, 64.693, 7.5761>, <5.03772, 64.2703, 7.6068> }
					triangle { <5.7455, 64.7157, 8.1934>, <5.5749, 64.9665, 7.983>, <5.2367, 64.04374, 7.8971> }
					triangle { <5.7455, 64.7157, 8.1934>, <7.1224, 65.1196, 7.7256>, <5.5749, 64.9665, 7.983> }
					triangle { <5.5749, 64.9665, 7.983>, <5.4462, 64.693, 7.5761>, <5.2367, 64.04374, 7.8971> }
					triangle { <5.5749, 64.9665, 7.983>, <6.9722, 65.314, 7.1352>, <5.4462, 64.693, 7.5761> }
					triangle { <7.1224, 65.1196, 7.7256>, <6.9722, 65.314, 7.1352>, <5.5749, 64.9665, 7.983> }
					triangle { <7.2155, 64.8765, 8.1561>, <7.1224, 65.1196, 7.7256>, <5.7455, 64.7157, 8.1934> }
					triangle { <7.1224, 65.1196, 7.7256>, <7.8352, 65.6754, 7.1073>, <6.9722, 65.314, 7.1352> }
					triangle { <8.06681, 65.5135, 7.7074>, <9.7477, 65.3789, 7.2949>, <7.8352, 65.6754, 7.1073> }
					triangle { <8.06681, 65.5135, 7.7074>, <7.8352, 65.6754, 7.1073>, <7.1224, 65.1196, 7.7256> }
					triangle { <8.06681, 65.5135, 7.7074>, <7.1224, 65.1196, 7.7256>, <7.2155, 64.8765, 8.1561> }
					triangle { <7.9966, 65.2737, 8.2927>, <8.06681, 65.5135, 7.7074>, <7.2155, 64.8765, 8.1561> }
					triangle { <10.2317, 64.9304, 7.9409>, <9.7477, 65.3789, 7.2949>, <8.06681, 65.5135, 7.7074> }
					triangle { <10.2317, 64.9304, 7.9409>, <8.06681, 65.5135, 7.7074>, <7.9966, 65.2737, 8.2927> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		union { // inflor. internode
			cylinder { <-0.01256, 21.07645, -0.885>, <-0.3049, 22.3419, -0.9628>, 0.3888 }
			cylinder { <-0.3049, 22.3419, -0.9628>, <-0.5249, 23.6241, -0.9893>, 0.3888 }
			cylinder { <-0.5249, 23.6241, -0.9893>, <-0.6714, 24.9167, -0.9643>, 0.3888 }
			cylinder { <-0.6714, 24.9167, -0.9643>, <-0.7439, 26.2136, -0.8879>, 0.3888 }
			cylinder { <-0.7439, 26.2136, -0.8879>, <-0.7421, 27.5084, -0.7602>, 0.3888 }
			cylinder { <-0.7421, 27.5084, -0.7602>, <-0.666, 28.7951, -0.5818>, 0.3888 }
			cylinder { <-0.666, 28.7951, -0.5818>, <-0.516, 30.06729, -0.3536>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.516, 30.06729, -0.3536>, <0.07813, 36.4052, 0.002658>, 0.3888 }
				cylinder { <0.07813, 36.4052, 0.002658>, <0.5228, 42.752, -0.4084>, 0.3888 }
				cylinder { <0.5228, 42.752, -0.4084>, <0.8112, 49.01235, -1.5808>, 0.3888 }
				cylinder { <0.8112, 49.01235, -1.5808>, <0.9391, 55.09196, -3.4968>, 0.3888 }
				cylinder { <0.9391, 55.09196, -3.4968>, <0.9046, 60.8994, -6.1276>, 0.3888 }
				cylinder { <0.9046, 60.8994, -6.1276>, <0.708, 66.3474, -9.4337>, 0.3888 }
				cylinder { <0.708, 66.3474, -9.4337>, <0.3525, 71.354, -13.3652>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <0.3525, 71.354, -13.3652>, <-0.02562, 71.8918, -14.06288>, <0.1012, 72.2249, -13.8525> }
					triangle { <-0.02562, 71.8918, -14.06288>, <-0.2672, 72.3247, -14.6028>, <0.1012, 72.2249, -13.8525> }
					triangle { <0.1012, 72.2249, -13.8525>, <-0.3257, 72.7844, -14.518>, <-0.09414, 72.9761, -14.2949> }
					triangle { <-0.3257, 72.7844, -14.518>, <-1.4054, 73.5915, -14.4045>, <-0.09414, 72.9761, -14.2949> }
					triangle { <0.1012, 72.2249, -13.8525>, <-0.2672, 72.3247, -14.6028>, <-0.3257, 72.7844, -14.518> }
					triangle { <-0.2672, 72.3247, -14.6028>, <-1.6722, 73.3189, -14.6263>, <-0.3257, 72.7844, -14.518> }
					triangle { <-0.3257, 72.7844, -14.518>, <-1.6722, 73.3189, -14.6263>, <-1.4054, 73.5915, -14.4045> }
					triangle { <-0.09414, 72.9761, -14.2949>, <-1.4054, 73.5915, -14.4045>, <-1.1593, 73.9715, -14.04414> }
					triangle { <-1.6722, 73.3189, -14.6263>, <-2.2278, 73.9897, -14.8351>, <-1.4054, 73.5915, -14.4045> }
					triangle { <-2.2278, 73.9897, -14.8351>, <-3.3408, 75.1111, -14.0147>, <-1.8873, 74.3751, -14.5774> }
					triangle { <-1.4054, 73.5915, -14.4045>, <-2.2278, 73.9897, -14.8351>, <-1.8873, 74.3751, -14.5774> }
					triangle { <-1.1593, 73.9715, -14.04414>, <-1.4054, 73.5915, -14.4045>, <-1.8873, 74.3751, -14.5774> }
					triangle { <-1.1593, 73.9715, -14.04414>, <-1.8873, 74.3751, -14.5774>, <-1.6376, 74.7061, -14.1785> }
					triangle { <-1.8873, 74.3751, -14.5774>, <-3.3408, 75.1111, -14.0147>, <-3.4224, 75.8315, -13.2923> }
					triangle { <-1.6376, 74.7061, -14.1785>, <-1.8873, 74.3751, -14.5774>, <-3.4224, 75.8315, -13.2923> }
					triangle { <0.1012, 72.2249, -13.8525>, <0.4796, 72.3514, -13.7257>, <0.3525, 71.354, -13.3652> }
					triangle { <0.1012, 72.2249, -13.8525>, <0.3719, 72.9261, -13.7935>, <0.4796, 72.3514, -13.7257> }
					triangle { <-0.09414, 72.9761, -14.2949>, <0.2421, 73.1196, -14.2437>, <0.1012, 72.2249, -13.8525> }
					triangle { <-0.09414, 72.9761, -14.2949>, <-0.8015, 74.2053, -13.7787>, <0.2421, 73.1196, -14.2437> }
					triangle { <0.2421, 73.1196, -14.2437>, <0.3719, 72.9261, -13.7935>, <0.1012, 72.2249, -13.8525> }
					triangle { <0.2421, 73.1196, -14.2437>, <-0.3596, 74.405, -13.362>, <0.3719, 72.9261, -13.7935> }
					triangle { <-0.8015, 74.2053, -13.7787>, <-0.3596, 74.405, -13.362>, <0.2421, 73.1196, -14.2437> }
					triangle { <-1.1593, 73.9715, -14.04414>, <-0.8015, 74.2053, -13.7787>, <-0.09414, 72.9761, -14.2949> }
					triangle { <-0.8015, 74.2053, -13.7787>, <-0.855, 75.198, -13.3193>, <-0.3596, 74.405, -13.362> }
					triangle { <-1.3494, 75.06905, -13.7424>, <-2.5747, 76.04568, -12.9951>, <-0.855, 75.198, -13.3193> }
					triangle { <-1.3494, 75.06905, -13.7424>, <-0.855, 75.198, -13.3193>, <-0.8015, 74.2053, -13.7787> }
					triangle { <-1.3494, 75.06905, -13.7424>, <-0.8015, 74.2053, -13.7787>, <-1.1593, 73.9715, -14.04414> }
					triangle { <-1.6376, 74.7061, -14.1785>, <-1.3494, 75.06905, -13.7424>, <-1.1593, 73.9715, -14.04414> }
					triangle { <-3.4224, 75.8315, -13.2923>, <-2.5747, 76.04568, -12.9951>, <-1.3494, 75.06905, -13.7424> }
					triangle { <-3.4224, 75.8315, -13.2923>, <-1.3494, 75.06905, -13.7424>, <-1.6376, 74.7061, -14.1785> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <0.3525, 71.354, -13.3652>, <-0.004787, 72.178, -13.7003>, <0.3821, 72.2866, -13.7994> }
					triangle { <-0.004787, 72.178, -13.7003>, <-0.2559, 72.7966, -14.00296>, <0.3821, 72.2866, -13.7994> }
					triangle { <0.3821, 72.2866, -13.7994>, <0.04613, 73.1477, -14.08909>, <0.3973, 73.08405, -14.2019> }
					triangle { <0.04613, 73.1477, -14.08909>, <0.2407, 74.3754, -13.5552>, <0.3973, 73.08405, -14.2019> }
					triangle { <0.3821, 72.2866, -13.7994>, <-0.2559, 72.7966, -14.00296>, <0.04613, 73.1477, -14.08909> }
					triangle { <-0.2559, 72.7966, -14.00296>, <-0.1655, 74.4007, -13.385>, <0.04613, 73.1477, -14.08909> }
					triangle { <0.04613, 73.1477, -14.08909>, <-0.1655, 74.4007, -13.385>, <0.2407, 74.3754, -13.5552> }
					triangle { <0.3973, 73.08405, -14.2019>, <0.2407, 74.3754, -13.5552>, <0.8068, 74.4031, -13.6723> }
					triangle { <-0.1655, 74.4007, -13.385>, <-0.1289, 75.2953, -13.3623>, <0.2407, 74.3754, -13.5552> }
					triangle { <-0.1289, 75.2953, -13.3623>, <0.7735, 76.5776, -12.5193>, <0.3909, 75.2977, -13.6085> }
					triangle { <0.2407, 74.3754, -13.5552>, <-0.1289, 75.2953, -13.3623>, <0.3909, 75.2977, -13.6085> }
					triangle { <0.8068, 74.4031, -13.6723>, <0.2407, 74.3754, -13.5552>, <0.3909, 75.2977, -13.6085> }
					triangle { <0.8068, 74.4031, -13.6723>, <0.3909, 75.2977, -13.6085>, <0.9604, 75.2765, -13.6871> }
					triangle { <0.3909, 75.2977, -13.6085>, <0.7735, 76.5776, -12.5193>, <1.7035, 76.9568, -12.3228> }
					triangle { <0.9604, 75.2765, -13.6871>, <0.3909, 75.2977, -13.6085>, <1.7035, 76.9568, -12.3228> }
					triangle { <0.3821, 72.2866, -13.7994>, <0.6694, 72.1114, -14.04842>, <0.3525, 71.354, -13.3652> }
					triangle { <0.3821, 72.2866, -13.7994>, <0.9024, 72.6202, -14.2311>, <0.6694, 72.1114, -14.04842> }
					triangle { <0.3973, 73.08405, -14.2019>, <0.6226, 72.9685, -14.4706>, <0.3821, 72.2866, -13.7994> }
					triangle { <0.3973, 73.08405, -14.2019>, <1.2538, 74.2811, -13.8681>, <0.6226, 72.9685, -14.4706> }
					triangle { <0.6226, 72.9685, -14.4706>, <0.9024, 72.6202, -14.2311>, <0.3821, 72.2866, -13.7994> }
					triangle { <0.6226, 72.9685, -14.4706>, <1.8248, 74.03978, -14.02473>, <0.9024, 72.6202, -14.2311> }
					triangle { <1.2538, 74.2811, -13.8681>, <1.8248, 74.03978, -14.02473>, <0.6226, 72.9685, -14.4706> }
					triangle { <0.8068, 74.4031, -13.6723>, <1.2538, 74.2811, -13.8681>, <0.3973, 73.08405, -14.2019> }
					triangle { <1.2538, 74.2811, -13.8681>, <2.1416, 74.9171, -13.9479>, <1.8248, 74.03978, -14.02473> }
					triangle { <1.5884, 75.2446, -13.7845>, <2.3188, 76.5098, -12.8466>, <2.1416, 74.9171, -13.9479> }
					triangle { <1.5884, 75.2446, -13.7845>, <2.1416, 74.9171, -13.9479>, <1.2538, 74.2811, -13.8681> }
					triangle { <1.5884, 75.2446, -13.7845>, <1.2538, 74.2811, -13.8681>, <0.8068, 74.4031, -13.6723> }
					triangle { <0.9604, 75.2765, -13.6871>, <1.5884, 75.2446, -13.7845>, <0.8068, 74.4031, -13.6723> }
					triangle { <1.7035, 76.9568, -12.3228>, <2.3188, 76.5098, -12.8466>, <1.5884, 75.2446, -13.7845> }
					triangle { <1.7035, 76.9568, -12.3228>, <1.5884, 75.2446, -13.7845>, <0.9604, 75.2765, -13.6871> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <0.3525, 71.354, -13.3652>, <0.4396, 72.2747, -13.6172>, <0.5459, 72.1442, -13.9954> }
					triangle { <0.4396, 72.2747, -13.6172>, <0.4711, 72.9697, -13.8482>, <0.5459, 72.1442, -13.9954> }
					triangle { <0.5459, 72.1442, -13.9954>, <0.6953, 73.06664, -14.251>, <0.684, 72.835, -14.545> }
					triangle { <0.6953, 73.06664, -14.251>, <1.8494, 73.7023, -14.5578>, <0.684, 72.835, -14.545> }
					triangle { <0.5459, 72.1442, -13.9954>, <0.4711, 72.9697, -13.8482>, <0.6953, 73.06664, -14.251> }
					triangle { <0.4711, 72.9697, -13.8482>, <1.866, 73.9235, -14.1764>, <0.6953, 73.06664, -14.251> }
					triangle { <0.6953, 73.06664, -14.251>, <1.866, 73.9235, -14.1764>, <1.8494, 73.7023, -14.5578> }
					triangle { <0.684, 72.835, -14.545>, <1.8494, 73.7023, -14.5578>, <1.9535, 73.407, -15.04451> }
					triangle { <1.866, 73.9235, -14.1764>, <2.392, 74.5539, -14.5344>, <1.8494, 73.7023, -14.5578> }
					triangle { <2.392, 74.5539, -14.5344>, <4.03777, 74.7077, -15.1957>, <2.3681, 74.3044, -15.05228> }
					triangle { <1.8494, 73.7023, -14.5578>, <2.392, 74.5539, -14.5344>, <2.3681, 74.3044, -15.05228> }
					triangle { <1.9535, 73.407, -15.04451>, <1.8494, 73.7023, -14.5578>, <2.3681, 74.3044, -15.05228> }
					triangle { <1.9535, 73.407, -15.04451>, <2.3681, 74.3044, -15.05228>, <2.4757, 73.9601, -15.5004> }
					triangle { <2.3681, 74.3044, -15.05228>, <4.03777, 74.7077, -15.1957>, <4.6932, 74.3597, -15.9004> }
					triangle { <2.4757, 73.9601, -15.5004>, <2.3681, 74.3044, -15.05228>, <4.6932, 74.3597, -15.9004> }
					triangle { <0.5459, 72.1442, -13.9954>, <0.3478, 71.9079, -14.2784>, <0.3525, 71.354, -13.3652> }
					triangle { <0.5459, 72.1442, -13.9954>, <0.5634, 72.1904, -14.7478>, <0.3478, 71.9079, -14.2784> }
					triangle { <0.684, 72.835, -14.545>, <0.4843, 72.6862, -14.8175>, <0.5459, 72.1442, -13.9954> }
					triangle { <0.684, 72.835, -14.545>, <1.8762, 73.09663, -15.4328>, <0.4843, 72.6862, -14.8175> }
					triangle { <0.4843, 72.6862, -14.8175>, <0.5634, 72.1904, -14.7478>, <0.5459, 72.1442, -13.9954> }
					triangle { <0.4843, 72.6862, -14.8175>, <1.8021, 72.611, -15.8421>, <0.5634, 72.1904, -14.7478> }
					triangle { <1.8762, 73.09663, -15.4328>, <1.8021, 72.611, -15.8421>, <0.4843, 72.6862, -14.8175> }
					triangle { <1.9535, 73.407, -15.04451>, <1.8762, 73.09663, -15.4328>, <0.684, 72.835, -14.545> }
					triangle { <1.8762, 73.09663, -15.4328>, <2.4485, 73.04111, -16.3648>, <1.8021, 72.611, -15.8421> }
					triangle { <2.5814, 73.5773, -15.9976>, <4.2363, 73.7979, -16.4734>, <2.4485, 73.04111, -16.3648> }
					triangle { <2.5814, 73.5773, -15.9976>, <2.4485, 73.04111, -16.3648>, <1.8762, 73.09663, -15.4328> }
					triangle { <2.5814, 73.5773, -15.9976>, <1.8762, 73.09663, -15.4328>, <1.9535, 73.407, -15.04451> }
					triangle { <2.4757, 73.9601, -15.5004>, <2.5814, 73.5773, -15.9976>, <1.9535, 73.407, -15.04451> }
					triangle { <4.6932, 74.3597, -15.9004>, <4.2363, 73.7979, -16.4734>, <2.5814, 73.5773, -15.9976> }
					triangle { <4.6932, 74.3597, -15.9004>, <2.5814, 73.5773, -15.9976>, <2.4757, 73.9601, -15.5004> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <0.3525, 71.354, -13.3652>, <0.6976, 72.04929, -13.9277>, <0.3678, 71.9933, -14.1715> }
					triangle { <0.6976, 72.04929, -13.9277>, <0.916, 72.6065, -14.3509>, <0.3678, 71.9933, -14.1715> }
					triangle { <0.3678, 71.9933, -14.1715>, <0.7307, 72.6524, -14.7816>, <0.3723, 72.5708, -14.8532> }
					triangle { <0.7307, 72.6524, -14.7816>, <1.2123, 72.4962, -16.03616>, <0.3723, 72.5708, -14.8532> }
					triangle { <0.3678, 71.9933, -14.1715>, <0.916, 72.6065, -14.3509>, <0.7307, 72.6524, -14.7816> }
					triangle { <0.916, 72.6065, -14.3509>, <1.6338, 72.5424, -15.9142>, <0.7307, 72.6524, -14.7816> }
					triangle { <0.7307, 72.6524, -14.7816>, <1.6338, 72.5424, -15.9142>, <1.2123, 72.4962, -16.03616> }
					triangle { <0.3723, 72.5708, -14.8532>, <1.2123, 72.4962, -16.03616>, <0.7068, 72.3504, -16.2772> }
					triangle { <1.6338, 72.5424, -15.9142>, <1.8747, 72.7831, -16.7425>, <1.2123, 72.4962, -16.03616> }
					triangle { <1.8747, 72.7831, -16.7425>, <1.9712, 72.06818, -18.3701>, <1.3302, 72.7587, -16.9268> }
					triangle { <1.2123, 72.4962, -16.03616>, <1.8747, 72.7831, -16.7425>, <1.3302, 72.7587, -16.9268> }
					triangle { <0.7068, 72.3504, -16.2772>, <1.2123, 72.4962, -16.03616>, <1.3302, 72.7587, -16.9268> }
					triangle { <0.7068, 72.3504, -16.2772>, <1.3302, 72.7587, -16.9268>, <0.8282, 72.564, -17.1294> }
					triangle { <1.3302, 72.7587, -16.9268>, <1.9712, 72.06818, -18.3701>, <1.4428, 71.6051, -19.1143> }
					triangle { <0.8282, 72.564, -17.1294>, <1.3302, 72.7587, -16.9268>, <1.4428, 71.6051, -19.1143> }
					triangle { <0.3678, 71.9933, -14.1715>, <-0.04371, 72.02023, -14.1001>, <0.3525, 71.354, -13.3652> }
					triangle { <0.3678, 71.9933, -14.1715>, <-0.1797, 72.2267, -14.6343>, <-0.04371, 72.02023, -14.1001> }
					triangle { <0.3723, 72.5708, -14.8532>, <0.01705, 72.6603, -14.8083>, <0.3678, 71.9933, -14.1715> }
					triangle { <0.3723, 72.5708, -14.8532>, <0.2113, 72.2778, -16.3249>, <0.01705, 72.6603, -14.8083> }
					triangle { <0.01705, 72.6603, -14.8083>, <-0.1797, 72.2267, -14.6343>, <0.3678, 71.9933, -14.1715> }
					triangle { <0.01705, 72.6603, -14.8083>, <-0.3966, 72.07996, -16.3195>, <-0.1797, 72.2267, -14.6343> }
					triangle { <0.2113, 72.2778, -16.3249>, <-0.3966, 72.07996, -16.3195>, <0.01705, 72.6603, -14.8083> }
					triangle { <0.7068, 72.3504, -16.2772>, <0.2113, 72.2778, -16.3249>, <0.3723, 72.5708, -14.8532> }
					triangle { <0.2113, 72.2778, -16.3249>, <-0.3556, 72.1449, -17.2523>, <-0.3966, 72.07996, -16.3195> }
					triangle { <0.2665, 72.3556, -17.3439>, <0.5457, 71.6324, -18.8972>, <-0.3556, 72.1449, -17.2523> }
					triangle { <0.2665, 72.3556, -17.3439>, <-0.3556, 72.1449, -17.2523>, <0.2113, 72.2778, -16.3249> }
					triangle { <0.2665, 72.3556, -17.3439>, <0.2113, 72.2778, -16.3249>, <0.7068, 72.3504, -16.2772> }
					triangle { <0.8282, 72.564, -17.1294>, <0.2665, 72.3556, -17.3439>, <0.7068, 72.3504, -16.2772> }
					triangle { <1.4428, 71.6051, -19.1143>, <0.5457, 71.6324, -18.8972>, <0.2665, 72.3556, -17.3439> }
					triangle { <1.4428, 71.6051, -19.1143>, <0.2665, 72.3556, -17.3439>, <0.8282, 72.564, -17.1294> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <0.3525, 71.354, -13.3652>, <0.4057, 71.809, -14.2073>, <0.08887, 72.04395, -14.08188> }
					triangle { <0.4057, 71.809, -14.2073>, <0.4527, 72.2019, -14.8243>, <0.08887, 72.04395, -14.08188> }
					triangle { <0.08887, 72.04395, -14.08188>, <0.09008, 72.4754, -14.9491>, <-0.1158, 72.6594, -14.6963> }
					triangle { <0.09008, 72.4754, -14.9491>, <-0.8297, 72.4267, -15.9399>, <-0.1158, 72.6594, -14.6963> }
					triangle { <0.08887, 72.04395, -14.08188>, <0.4527, 72.2019, -14.8243>, <0.09008, 72.4754, -14.9491> }
					triangle { <0.4527, 72.2019, -14.8243>, <-0.5859, 72.1631, -16.1964>, <0.09008, 72.4754, -14.9491> }
					triangle { <0.09008, 72.4754, -14.9491>, <-0.5859, 72.1631, -16.1964>, <-0.8297, 72.4267, -15.9399> }
					triangle { <-0.1158, 72.6594, -14.6963>, <-0.8297, 72.4267, -15.9399>, <-1.246, 72.7046, -15.6496> }
					triangle { <-0.5859, 72.1631, -16.1964>, <-1.02358, 72.4292, -16.9312>, <-0.8297, 72.4267, -15.9399> }
					triangle { <-1.02358, 72.4292, -16.9312>, <-2.6578, 72.3212, -17.6292>, <-1.3394, 72.8031, -16.6288> }
					triangle { <-0.8297, 72.4267, -15.9399>, <-1.02358, 72.4292, -16.9312>, <-1.3394, 72.8031, -16.6288> }
					triangle { <-1.246, 72.7046, -15.6496>, <-0.8297, 72.4267, -15.9399>, <-1.3394, 72.8031, -16.6288> }
					triangle { <-1.246, 72.7046, -15.6496>, <-1.3394, 72.8031, -16.6288>, <-1.7523, 73.032, -16.3> }
					triangle { <-1.3394, 72.8031, -16.6288>, <-2.6578, 72.3212, -17.6292>, <-3.6485, 72.5285, -17.4781> }
					triangle { <-1.7523, 73.032, -16.3>, <-1.3394, 72.8031, -16.6288>, <-3.6485, 72.5285, -17.4781> }
					triangle { <0.08887, 72.04395, -14.08188>, <0.03894, 72.2984, -13.7533>, <0.3525, 71.354, -13.3652> }
					triangle { <0.08887, 72.04395, -14.08188>, <-0.2998, 72.6883, -14.03567>, <0.03894, 72.2984, -13.7533> }
					triangle { <-0.1158, 72.6594, -14.6963>, <-0.1349, 72.9322, -14.4483>, <0.08887, 72.04395, -14.08188> }
					triangle { <-0.1158, 72.6594, -14.6963>, <-1.4686, 72.9733, -15.2872>, <-0.1349, 72.9322, -14.4483> }
					triangle { <-0.1349, 72.9322, -14.4483>, <-0.2998, 72.6883, -14.03567>, <0.08887, 72.04395, -14.08188> }
					triangle { <-0.1349, 72.9322, -14.4483>, <-1.7528, 73.2054, -14.7636>, <-0.2998, 72.6883, -14.03567> }
					triangle { <-1.4686, 72.9733, -15.2872>, <-1.7528, 73.2054, -14.7636>, <-0.1349, 72.9322, -14.4483> }
					triangle { <-1.246, 72.7046, -15.6496>, <-1.4686, 72.9733, -15.2872>, <-0.1158, 72.6594, -14.6963> }
					triangle { <-1.4686, 72.9733, -15.2872>, <-2.4282, 73.4981, -15.3417>, <-1.7528, 73.2054, -14.7636> }
					triangle { <-2.1995, 73.2915, -15.9291>, <-3.7272, 73.04263, -16.715>, <-2.4282, 73.4981, -15.3417> }
					triangle { <-2.1995, 73.2915, -15.9291>, <-2.4282, 73.4981, -15.3417>, <-1.4686, 72.9733, -15.2872> }
					triangle { <-2.1995, 73.2915, -15.9291>, <-1.4686, 72.9733, -15.2872>, <-1.246, 72.7046, -15.6496> }
					triangle { <-1.7523, 73.032, -16.3>, <-2.1995, 73.2915, -15.9291>, <-1.246, 72.7046, -15.6496> }
					triangle { <-3.6485, 72.5285, -17.4781>, <-3.7272, 73.04263, -16.715>, <-2.1995, 73.2915, -15.9291> }
					triangle { <-3.6485, 72.5285, -17.4781>, <-2.1995, 73.2915, -15.9291>, <-1.7523, 73.032, -16.3> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		}
	union { // internode
		cylinder { <0.121, 3.1502, 0.2565>, <0.106, 3.2969, 0.287>, 0.4 }
		cylinder { <0.106, 3.2969, 0.287>, <0.09471, 3.444, 0.3172>, 0.4 }
		cylinder { <0.09471, 3.444, 0.3172>, <0.08705, 3.5913, 0.3473>, 0.4 }
		cylinder { <0.08705, 3.5913, 0.3473>, <0.08308, 3.7388, 0.3772>, 0.4 }
		cylinder { <0.08308, 3.7388, 0.3772>, <0.08279, 3.8865, 0.4069>, 0.4 }
		cylinder { <0.08279, 3.8865, 0.4069>, <0.08619, 4.03413, 0.4364>, 0.4 }
		cylinder { <0.08619, 4.03413, 0.4364>, <0.09328, 4.1816, 0.4656>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.09328, 4.1816, 0.4656>, <-1.2411, 14.6285, 2.6492>, 0.8459 }
			cylinder { <-1.2411, 14.6285, 2.6492>, <-4.3769, 24.6753, 4.8661>, 0.8459 }
			cylinder { <-4.3769, 24.6753, 4.8661>, <-9.2219, 34.0263, 7.05104>, 0.8459 }
			cylinder { <-9.2219, 34.0263, 7.05104>, <-15.6333, 42.4059, 9.1395>, 0.8459 }
			cylinder { <-15.6333, 42.4059, 9.1395>, <-23.4224, 49.5676, 11.07016>, 0.8459 }
			cylinder { <-23.4224, 49.5676, 11.07016>, <-32.3598, 55.3004, 12.786>, 0.8459 }
			cylinder { <-32.3598, 55.3004, 12.786>, <-42.1824, 59.4356, 14.2367>, 0.8459 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-42.1824, 59.4356, 14.2367>, <-35.9324, 51.3184, 19.09677>, <-43.5172, 56.9902, 26.7128> }
			triangle { <-42.1824, 59.4356, 14.2367>, <-43.5172, 56.9902, 26.7128>, <-51.2508, 61.5947, 26.6679> }
			triangle { <-35.9324, 51.3184, 19.09677>, <-34.377, 48.0181, 24.4929>, <-43.5172, 56.9902, 26.7128> }
			triangle { <-34.377, 48.0181, 24.4929>, <-39.7673, 48.9427, 28.9889>, <-43.5172, 56.9902, 26.7128> }
			triangle { <-39.7673, 48.9427, 28.9889>, <-49.07221, 52.303, 31.5475>, <-43.5172, 56.9902, 26.7128> }
			triangle { <-49.07221, 52.303, 31.5475>, <-58.912, 56.5847, 32.7046>, <-51.2508, 61.5947, 26.6679> }
			triangle { <-43.5172, 56.9902, 26.7128>, <-49.07221, 52.303, 31.5475>, <-51.2508, 61.5947, 26.6679> }
			triangle { <-51.2508, 61.5947, 26.6679>, <-60.7294, 63.3491, 27.7795>, <-58.9969, 66.3354, 21.303> }
			triangle { <-60.7294, 63.3491, 27.7795>, <-68.7937, 62.7377, 28.2447>, <-67.3433, 66.9171, 23.7279> }
			triangle { <-60.7294, 63.3491, 27.7795>, <-67.3433, 66.9171, 23.7279>, <-58.9969, 66.3354, 21.303> }
			triangle { <-58.9969, 66.3354, 21.303>, <-67.3433, 66.9171, 23.7279>, <-65.5689, 68.3023, 17.2504> }
			triangle { <-68.7937, 62.7377, 28.2447>, <-77.8744, 65.7089, 21.3107>, <-67.3433, 66.9171, 23.7279> }
			triangle { <-67.3433, 66.9171, 23.7279>, <-77.8744, 65.7089, 21.3107>, <-65.5689, 68.3023, 17.2504> }
			triangle { <-42.1824, 59.4356, 14.2367>, <-51.2508, 61.5947, 26.6679>, <-51.4709, 63.9984, 15.902> }
			triangle { <-51.4709, 63.9984, 15.902>, <-51.2508, 61.5947, 26.6679>, <-58.9969, 66.3354, 21.303> }
			triangle { <-51.4709, 63.9984, 15.902>, <-58.9969, 66.3354, 21.303>, <-58.9348, 67.1406, 17.00434> }
			triangle { <-58.9969, 66.3354, 21.303>, <-65.5689, 68.3023, 17.2504>, <-58.9348, 67.1406, 17.00434> }
			triangle { <-58.912, 56.5847, 32.7046>, <-60.7294, 63.3491, 27.7795>, <-51.2508, 61.5947, 26.6679> }
			triangle { <-58.912, 56.5847, 32.7046>, <-68.7937, 62.7377, 28.2447>, <-60.7294, 63.3491, 27.7795> }
			triangle { <-42.5736, 67.1749, 4.06996>, <-35.3613, 57.4828, 5.3919>, <-42.1824, 59.4356, 14.2367> }
			triangle { <-50.4314, 70.4393, 7.004444>, <-42.5736, 67.1749, 4.06996>, <-42.1824, 59.4356, 14.2367> }
			triangle { <-42.5736, 67.1749, 4.06996>, <-33.3341, 59.2748, -0.5333>, <-35.3613, 57.4828, 5.3919> }
			triangle { <-42.5736, 67.1749, 4.06996>, <-38.4265, 63.4157, -3.1877>, <-33.3341, 59.2748, -0.5333> }
			triangle { <-42.5736, 67.1749, 4.06996>, <-47.632, 67.8481, -3.01257>, <-38.4265, 63.4157, -3.1877> }
			triangle { <-50.4314, 70.4393, 7.004444>, <-57.4967, 71.8617, -1.2595>, <-47.632, 67.8481, -3.01257> }
			triangle { <-50.4314, 70.4393, 7.004444>, <-47.632, 67.8481, -3.01257>, <-42.5736, 67.1749, 4.06996> }
			triangle { <-58.6741, 69.8196, 13.5567>, <-58.9321, 74.6226, 7.8144>, <-50.4314, 70.4393, 7.004444> }
			triangle { <-66.9793, 72.00708, 11.6834>, <-67.8501, 72.9224, 5.6018>, <-58.9321, 74.6226, 7.8144> }
			triangle { <-58.6741, 69.8196, 13.5567>, <-66.9793, 72.00708, 11.6834>, <-58.9321, 74.6226, 7.8144> }
			triangle { <-65.5689, 68.3023, 17.2504>, <-66.9793, 72.00708, 11.6834>, <-58.6741, 69.8196, 13.5567> }
			triangle { <-66.9793, 72.00708, 11.6834>, <-77.3445, 70.2676, 11.904>, <-67.8501, 72.9224, 5.6018> }
			triangle { <-65.5689, 68.3023, 17.2504>, <-77.3445, 70.2676, 11.904>, <-66.9793, 72.00708, 11.6834> }
			triangle { <-51.4709, 63.9984, 15.902>, <-50.4314, 70.4393, 7.004444>, <-42.1824, 59.4356, 14.2367> }
			triangle { <-58.6741, 69.8196, 13.5567>, <-50.4314, 70.4393, 7.004444>, <-51.4709, 63.9984, 15.902> }
			triangle { <-58.9348, 67.1406, 17.00434>, <-58.6741, 69.8196, 13.5567>, <-51.4709, 63.9984, 15.902> }
			triangle { <-58.9348, 67.1406, 17.00434>, <-65.5689, 68.3023, 17.2504>, <-58.6741, 69.8196, 13.5567> }
			triangle { <-50.4314, 70.4393, 7.004444>, <-58.9321, 74.6226, 7.8144>, <-57.4967, 71.8617, -1.2595> }
			triangle { <-58.9321, 74.6226, 7.8144>, <-67.8501, 72.9224, 5.6018>, <-57.4967, 71.8617, -1.2595> }
			triangle { <-65.5689, 68.3023, 17.2504>, <-77.8744, 65.7089, 21.3107>, <-77.8417, 68.2492, 16.715> }
			triangle { <-77.8744, 65.7089, 21.3107>, <-84.7071, 65.2671, 15.08769>, <-77.8417, 68.2492, 16.715> }
			triangle { <-65.5689, 68.3023, 17.2504>, <-77.8417, 68.2492, 16.715>, <-77.3445, 70.2676, 11.904> }
			triangle { <-77.8417, 68.2492, 16.715>, <-84.7071, 65.2671, 15.08769>, <-77.3445, 70.2676, 11.904> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <0.09328, 4.1816, 0.4656>, <0.1993, 5.4547, 0.7125>, 0.3888 }
			cylinder { <0.1993, 5.4547, 0.7125>, <0.35, 6.7244, 0.9536>, 0.3888 }
			cylinder { <0.35, 6.7244, 0.9536>, <0.5452, 7.9892, 1.1888>, 0.3888 }
			cylinder { <0.5452, 7.9892, 1.1888>, <0.7846, 9.2475, 1.4176>, 0.3888 }
			cylinder { <0.7846, 9.2475, 1.4176>, <1.06803, 10.4978, 1.6399>, 0.3888 }
			cylinder { <1.06803, 10.4978, 1.6399>, <1.395, 11.7386, 1.8554>, 0.3888 }
			cylinder { <1.395, 11.7386, 1.8554>, <1.7652, 12.9685, 2.06391>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.7652, 12.9685, 2.06391>, <4.4778, 18.4763, 3.7827>, 0.3888 }
				cylinder { <4.4778, 18.4763, 3.7827>, <7.9844, 23.2543, 6.1331>, 0.3888 }
				cylinder { <7.9844, 23.2543, 6.1331>, <12.1503, 27.1187, 9.02461>, 0.3888 }
				cylinder { <12.1503, 27.1187, 9.02461>, <16.8155, 29.921, 12.3461>, 0.3888 }
				cylinder { <16.8155, 29.921, 12.3461>, <21.8006, 31.5536, 15.9699>, 0.3888 }
				cylinder { <21.8006, 31.5536, 15.9699>, <26.9141, 31.9537, 19.7569>, 0.3888 }
				cylinder { <26.9141, 31.9537, 19.7569>, <31.9595, 31.1059, 23.5615>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <31.9595, 31.1059, 23.5615>, <32.8518, 30.667, 23.8708>, <32.9785, 31.07178, 24.02018> }
					triangle { <32.8518, 30.667, 23.8708>, <33.5227, 30.3501, 24.1601>, <32.9785, 31.07178, 24.02018> }
					triangle { <32.9785, 31.07178, 24.02018>, <33.9111, 30.6603, 24.2823>, <33.8502, 31.02815, 24.445> }
					triangle { <33.9111, 30.6603, 24.2823>, <35.2415, 30.9093, 23.7095>, <33.8502, 31.02815, 24.445> }
					triangle { <32.9785, 31.07178, 24.02018>, <33.5227, 30.3501, 24.1601>, <33.9111, 30.6603, 24.2823> }
					triangle { <33.5227, 30.3501, 24.1601>, <35.2589, 30.4892, 23.4792>, <33.9111, 30.6603, 24.2823> }
					triangle { <33.9111, 30.6603, 24.2823>, <35.2589, 30.4892, 23.4792>, <35.2415, 30.9093, 23.7095> }
					triangle { <33.8502, 31.02815, 24.445>, <35.2415, 30.9093, 23.7095>, <35.2841, 31.5069, 23.8998> }
					triangle { <35.2589, 30.4892, 23.4792>, <36.231, 30.5152, 23.4455>, <35.2415, 30.9093, 23.7095> }
					triangle { <36.231, 30.5152, 23.4455>, <37.6305, 31.563, 22.6183>, <36.2469, 31.04883, 23.7706> }
					triangle { <35.2415, 30.9093, 23.7095>, <36.231, 30.5152, 23.4455>, <36.2469, 31.04883, 23.7706> }
					triangle { <35.2841, 31.5069, 23.8998>, <35.2415, 30.9093, 23.7095>, <36.2469, 31.04883, 23.7706> }
					triangle { <35.2841, 31.5069, 23.8998>, <36.2469, 31.04883, 23.7706>, <36.2359, 31.6555, 23.9204> }
					triangle { <36.2469, 31.04883, 23.7706>, <37.6305, 31.563, 22.6183>, <38.05805, 32.5832, 22.506> }
					triangle { <36.2359, 31.6555, 23.9204>, <36.2469, 31.04883, 23.7706>, <38.05805, 32.5832, 22.506> }
					triangle { <32.9785, 31.07178, 24.02018>, <32.7971, 31.3569, 24.3243>, <31.9595, 31.1059, 23.5615> }
					triangle { <32.9785, 31.07178, 24.02018>, <33.3565, 31.5788, 24.5407>, <32.7971, 31.3569, 24.3243> }
					triangle { <33.8502, 31.02815, 24.445>, <33.7325, 31.243, 24.7626>, <32.9785, 31.07178, 24.02018> }
					triangle { <33.8502, 31.02815, 24.445>, <35.1627, 31.9698, 24.1639>, <33.7325, 31.243, 24.7626> }
					triangle { <33.7325, 31.243, 24.7626>, <33.3565, 31.5788, 24.5407>, <32.9785, 31.07178, 24.02018> }
					triangle { <33.7325, 31.243, 24.7626>, <34.9137, 32.5732, 24.4014>, <33.3565, 31.5788, 24.5407> }
					triangle { <35.1627, 31.9698, 24.1639>, <34.9137, 32.5732, 24.4014>, <33.7325, 31.243, 24.7626> }
					triangle { <35.2841, 31.5069, 23.8998>, <35.1627, 31.9698, 24.1639>, <33.8502, 31.02815, 24.445> }
					triangle { <35.1627, 31.9698, 24.1639>, <35.8719, 32.9084, 24.3415>, <34.9137, 32.5732, 24.4014> }
					triangle { <36.2147, 32.3235, 24.09733>, <37.5911, 33.1964, 23.1482>, <35.8719, 32.9084, 24.3415> }
					triangle { <36.2147, 32.3235, 24.09733>, <35.8719, 32.9084, 24.3415>, <35.1627, 31.9698, 24.1639> }
					triangle { <36.2147, 32.3235, 24.09733>, <35.1627, 31.9698, 24.1639>, <35.2841, 31.5069, 23.8998> }
					triangle { <36.2359, 31.6555, 23.9204>, <36.2147, 32.3235, 24.09733>, <35.2841, 31.5069, 23.8998> }
					triangle { <38.05805, 32.5832, 22.506>, <37.5911, 33.1964, 23.1482>, <36.2147, 32.3235, 24.09733> }
					triangle { <38.05805, 32.5832, 22.506>, <36.2147, 32.3235, 24.09733>, <36.2359, 31.6555, 23.9204> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <31.9595, 31.1059, 23.5615>, <32.9645, 31.1548, 23.8301>, <32.8297, 31.229, 24.2526> }
					triangle { <32.9645, 31.1548, 23.8301>, <33.7229, 31.1501, 24.07294>, <32.8297, 31.229, 24.2526> }
					triangle { <32.8297, 31.229, 24.2526>, <33.8377, 31.3447, 24.5321>, <33.5896, 31.3033, 24.8518> }
					triangle { <33.8377, 31.3447, 24.5321>, <34.5545, 32.5452, 24.9851>, <33.5896, 31.3033, 24.8518> }
					triangle { <32.8297, 31.229, 24.2526>, <33.7229, 31.1501, 24.07294>, <33.8377, 31.3447, 24.5321> }
					triangle { <33.7229, 31.1501, 24.07294>, <34.7902, 32.6025, 24.5717>, <33.8377, 31.3447, 24.5321> }
					triangle { <33.8377, 31.3447, 24.5321>, <34.7902, 32.6025, 24.5717>, <34.5545, 32.5452, 24.9851> }
					triangle { <33.5896, 31.3033, 24.8518>, <34.5545, 32.5452, 24.9851>, <34.242, 32.6076, 25.5271> }
					triangle { <34.7902, 32.6025, 24.5717>, <35.4897, 33.1187, 25.00884>, <34.5545, 32.5452, 24.9851> }
					triangle { <35.4897, 33.1187, 25.00884>, <35.6972, 34.8187, 25.9077>, <35.2249, 33.03853, 25.5693> }
					triangle { <34.5545, 32.5452, 24.9851>, <35.4897, 33.1187, 25.00884>, <35.2249, 33.03853, 25.5693> }
					triangle { <34.242, 32.6076, 25.5271>, <34.5545, 32.5452, 24.9851>, <35.2249, 33.03853, 25.5693> }
					triangle { <34.242, 32.6076, 25.5271>, <35.2249, 33.03853, 25.5693>, <34.8588, 33.11, 26.07077> }
					triangle { <35.2249, 33.03853, 25.5693>, <35.6972, 34.8187, 25.9077>, <35.341, 35.4529, 26.7486> }
					triangle { <34.8588, 33.11, 26.07077>, <35.2249, 33.03853, 25.5693>, <35.341, 35.4529, 26.7486> }
					triangle { <32.8297, 31.229, 24.2526>, <32.5727, 30.987, 24.5394>, <31.9595, 31.1059, 23.5615> }
					triangle { <32.8297, 31.229, 24.2526>, <32.8897, 31.1615, 25.06679>, <32.5727, 30.987, 24.5394> }
					triangle { <33.5896, 31.3033, 24.8518>, <33.4277, 31.05927, 25.1258>, <32.8297, 31.229, 24.2526> }
					triangle { <33.5896, 31.3033, 24.8518>, <33.9083, 32.4856, 25.9424>, <33.4277, 31.05927, 25.1258> }
					triangle { <33.4277, 31.05927, 25.1258>, <32.8897, 31.1615, 25.06679>, <32.8297, 31.229, 24.2526> }
					triangle { <33.4277, 31.05927, 25.1258>, <33.3846, 32.3677, 26.3833>, <32.8897, 31.1615, 25.06679> }
					triangle { <33.9083, 32.4856, 25.9424>, <33.3846, 32.3677, 26.3833>, <33.4277, 31.05927, 25.1258> }
					triangle { <34.242, 32.6076, 25.5271>, <33.9083, 32.4856, 25.9424>, <33.5896, 31.3033, 24.8518> }
					triangle { <33.9083, 32.4856, 25.9424>, <33.871, 32.9989, 27.01507>, <33.3846, 32.3677, 26.3833> }
					triangle { <34.4513, 33.1746, 26.6255>, <34.7292, 34.9043, 27.3241>, <33.871, 32.9989, 27.01507> }
					triangle { <34.4513, 33.1746, 26.6255>, <33.871, 32.9989, 27.01507>, <33.9083, 32.4856, 25.9424> }
					triangle { <34.4513, 33.1746, 26.6255>, <33.9083, 32.4856, 25.9424>, <34.242, 32.6076, 25.5271> }
					triangle { <34.8588, 33.11, 26.07077>, <34.4513, 33.1746, 26.6255>, <34.242, 32.6076, 25.5271> }
					triangle { <35.341, 35.4529, 26.7486>, <34.7292, 34.9043, 27.3241>, <34.4513, 33.1746, 26.6255> }
					triangle { <35.341, 35.4529, 26.7486>, <34.4513, 33.1746, 26.6255>, <34.8588, 33.11, 26.07077> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <31.9595, 31.1059, 23.5615>, <32.7286, 31.4022, 24.1981>, <32.6645, 31.01931, 24.4249> }
					triangle { <32.7286, 31.4022, 24.1981>, <33.3435, 31.58, 24.6719>, <32.6645, 31.01931, 24.4249> }
					triangle { <32.6645, 31.01931, 24.4249>, <33.3953, 31.33, 25.1155>, <33.3006, 30.9363, 25.1533> }
					triangle { <33.3953, 31.33, 25.1155>, <33.251, 31.7105, 26.5278>, <33.3006, 30.9363, 25.1533> }
					triangle { <32.6645, 31.01931, 24.4249>, <33.3435, 31.58, 24.6719>, <33.3953, 31.33, 25.1155> }
					triangle { <33.3435, 31.58, 24.6719>, <33.3078, 32.1789, 26.4432>, <33.3953, 31.33, 25.1155> }
					triangle { <33.3953, 31.33, 25.1155>, <33.3078, 32.1789, 26.4432>, <33.251, 31.7105, 26.5278> }
					triangle { <33.3006, 30.9363, 25.1533>, <33.251, 31.7105, 26.5278>, <33.08597, 31.1397, 26.733> }
					triangle { <33.3078, 32.1789, 26.4432>, <33.5845, 32.3407, 27.3619>, <33.251, 31.7105, 26.5278> }
					triangle { <33.5845, 32.3407, 27.3619>, <32.8306, 32.2728, 29.1417>, <33.5498, 31.732, 27.4995> }
					triangle { <33.251, 31.7105, 26.5278>, <33.5845, 32.3407, 27.3619>, <33.5498, 31.732, 27.4995> }
					triangle { <33.08597, 31.1397, 26.733>, <33.251, 31.7105, 26.5278>, <33.5498, 31.732, 27.4995> }
					triangle { <33.08597, 31.1397, 26.733>, <33.5498, 31.732, 27.4995>, <33.3311, 31.1701, 27.6643> }
					triangle { <33.5498, 31.732, 27.4995>, <32.8306, 32.2728, 29.1417>, <32.327, 31.6257, 29.8927> }
					triangle { <33.3311, 31.1701, 27.6643>, <33.5498, 31.732, 27.4995>, <32.327, 31.6257, 29.8927> }
					triangle { <32.6645, 31.01931, 24.4249>, <32.6848, 30.5823, 24.3006>, <31.9595, 31.1059, 23.5615> }
					triangle { <32.6645, 31.01931, 24.4249>, <32.9133, 30.3709, 24.8593>, <32.6848, 30.5823, 24.3006> }
					triangle { <33.3006, 30.9363, 25.1533>, <33.3903, 30.5559, 25.06326>, <32.6645, 31.01931, 24.4249> }
					triangle { <33.3006, 30.9363, 25.1533>, <32.998, 30.6002, 26.7294>, <33.3903, 30.5559, 25.06326> }
					triangle { <33.3903, 30.5559, 25.06326>, <32.9133, 30.3709, 24.8593>, <32.6645, 31.01931, 24.4249> }
					triangle { <33.3903, 30.5559, 25.06326>, <32.7712, 29.9476, 26.6575>, <32.9133, 30.3709, 24.8593> }
					triangle { <32.998, 30.6002, 26.7294>, <32.7712, 29.9476, 26.6575>, <33.3903, 30.5559, 25.06326> }
					triangle { <33.08597, 31.1397, 26.733>, <32.998, 30.6002, 26.7294>, <33.3006, 30.9363, 25.1533> }
					triangle { <32.998, 30.6002, 26.7294>, <32.8546, 29.8846, 27.669>, <32.7712, 29.9476, 26.6575> }
					triangle { <33.09671, 30.5427, 27.8354>, <32.3365, 30.6807, 29.5559>, <32.8546, 29.8846, 27.669> }
					triangle { <33.09671, 30.5427, 27.8354>, <32.8546, 29.8846, 27.669>, <32.998, 30.6002, 26.7294> }
					triangle { <33.09671, 30.5427, 27.8354>, <32.998, 30.6002, 26.7294>, <33.08597, 31.1397, 26.733> }
					triangle { <33.3311, 31.1701, 27.6643>, <33.09671, 30.5427, 27.8354>, <33.08597, 31.1397, 26.733> }
					triangle { <32.327, 31.6257, 29.8927>, <32.3365, 30.6807, 29.5559>, <33.09671, 30.5427, 27.8354> }
					triangle { <32.327, 31.6257, 29.8927>, <33.09671, 30.5427, 27.8354>, <33.3311, 31.1701, 27.6643> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <31.9595, 31.1059, 23.5615>, <32.4679, 31.06972, 24.4697>, <32.7098, 30.7305, 24.3005> }
					triangle { <32.4679, 31.06972, 24.4697>, <32.9052, 31.04982, 25.1349>, <32.7098, 30.7305, 24.3005> }
					triangle { <32.7098, 30.7305, 24.3005>, <33.1912, 30.6365, 25.2316>, <33.3798, 30.4309, 24.9357> }
					triangle { <33.1912, 30.6365, 25.2316>, <33.1202, 29.551, 26.2199>, <33.3798, 30.4309, 24.9357> }
					triangle { <32.7098, 30.7305, 24.3005>, <32.9052, 31.04982, 25.1349>, <33.1912, 30.6365, 25.2316> }
					triangle { <32.9052, 31.04982, 25.1349>, <32.8465, 29.7998, 26.5248>, <33.1912, 30.6365, 25.2316> }
					triangle { <33.1912, 30.6365, 25.2316>, <32.8465, 29.7998, 26.5248>, <33.1202, 29.551, 26.2199> }
					triangle { <33.3798, 30.4309, 24.9357>, <33.1202, 29.551, 26.2199>, <33.4028, 29.118, 25.8623> }
					triangle { <32.8465, 29.7998, 26.5248>, <33.1307, 29.249, 27.2748>, <33.1202, 29.551, 26.2199> }
					triangle { <33.1307, 29.249, 27.2748>, <32.9657, 27.4199, 27.8813>, <33.5209, 28.9226, 26.9118> }
					triangle { <33.1202, 29.551, 26.2199>, <33.1307, 29.249, 27.2748>, <33.5209, 28.9226, 26.9118> }
					triangle { <33.4028, 29.118, 25.8623>, <33.1202, 29.551, 26.2199>, <33.5209, 28.9226, 26.9118> }
					triangle { <33.4028, 29.118, 25.8623>, <33.5209, 28.9226, 26.9118>, <33.7499, 28.4987, 26.5137> }
					triangle { <33.5209, 28.9226, 26.9118>, <32.9657, 27.4199, 27.8813>, <33.1532, 26.3549, 27.6225> }
					triangle { <33.7499, 28.4987, 26.5137>, <33.5209, 28.9226, 26.9118>, <33.1532, 26.3549, 27.6225> }
					triangle { <32.7098, 30.7305, 24.3005>, <32.9794, 30.6983, 23.9357>, <31.9595, 31.1059, 23.5615> }
					triangle { <32.7098, 30.7305, 24.3005>, <33.3949, 30.2922, 24.2031>, <32.9794, 30.6983, 23.9357> }
					triangle { <33.3798, 30.4309, 24.9357>, <33.6717, 30.4239, 24.6607>, <32.7098, 30.7305, 24.3005> }
					triangle { <33.3798, 30.4309, 24.9357>, <33.6813, 28.9017, 25.4447>, <33.6717, 30.4239, 24.6607> }
					triangle { <33.6717, 30.4239, 24.6607>, <33.3949, 30.2922, 24.2031>, <32.7098, 30.7305, 24.3005> }
					triangle { <33.6717, 30.4239, 24.6607>, <33.9154, 28.6348, 24.8476>, <33.3949, 30.2922, 24.2031> }
					triangle { <33.6813, 28.9017, 25.4447>, <33.9154, 28.6348, 24.8476>, <33.6717, 30.4239, 24.6607> }
					triangle { <33.4028, 29.118, 25.8623>, <33.6813, 28.9017, 25.4447>, <33.3798, 30.4309, 24.9357> }
					triangle { <33.6813, 28.9017, 25.4447>, <34.2177, 27.8404, 25.4058>, <33.9154, 28.6348, 24.8476> }
					triangle { <34.0103, 28.04045, 26.06633>, <33.6973, 26.323, 26.7803>, <34.2177, 27.8404, 25.4058> }
					triangle { <34.0103, 28.04045, 26.06633>, <34.2177, 27.8404, 25.4058>, <33.6813, 28.9017, 25.4447> }
					triangle { <34.0103, 28.04045, 26.06633>, <33.6813, 28.9017, 25.4447>, <33.4028, 29.118, 25.8623> }
					triangle { <33.7499, 28.4987, 26.5137>, <34.0103, 28.04045, 26.06633>, <33.4028, 29.118, 25.8623> }
					triangle { <33.1532, 26.3549, 27.6225>, <33.6973, 26.323, 26.7803>, <34.0103, 28.04045, 26.06633> }
					triangle { <33.1532, 26.3549, 27.6225>, <34.0103, 28.04045, 26.06633>, <33.7499, 28.4987, 26.5137> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <31.9595, 31.1059, 23.5615>, <32.5452, 30.6084, 24.2644>, <32.9068, 30.7634, 24.04661> }
					triangle { <32.5452, 30.6084, 24.2644>, <33.01772, 30.2782, 24.8139>, <32.9068, 30.7634, 24.04661> }
					triangle { <32.9068, 30.7634, 24.04661>, <33.5148, 30.2163, 24.7089>, <33.7246, 30.4885, 24.4913> }
					triangle { <33.5148, 30.2163, 24.7089>, <34.369, 29.04834, 24.4518>, <33.7246, 30.4885, 24.4913> }
					triangle { <32.9068, 30.7634, 24.04661>, <33.01772, 30.2782, 24.8139>, <33.5148, 30.2163, 24.7089> }
					triangle { <33.01772, 30.2782, 24.8139>, <34.07062, 28.7398, 24.6653>, <33.5148, 30.2163, 24.7089> }
					triangle { <33.5148, 30.2163, 24.7089>, <34.07062, 28.7398, 24.6653>, <34.369, 29.04834, 24.4518> }
					triangle { <33.7246, 30.4885, 24.4913>, <34.369, 29.04834, 24.4518>, <34.7819, 29.3484, 24.08485> }
					triangle { <34.07062, 28.7398, 24.6653>, <34.791, 28.1038, 24.8179>, <34.369, 29.04834, 24.4518> }
					triangle { <34.791, 28.1038, 24.8179>, <35.977, 26.9746, 23.7887>, <35.213, 28.494, 24.5724> }
					triangle { <34.369, 29.04834, 24.4518>, <34.791, 28.1038, 24.8179>, <35.213, 28.494, 24.5724> }
					triangle { <34.7819, 29.3484, 24.08485>, <34.369, 29.04834, 24.4518>, <35.213, 28.494, 24.5724> }
					triangle { <34.7819, 29.3484, 24.08485>, <35.213, 28.494, 24.5724>, <35.5722, 28.8031, 24.1649> }
					triangle { <35.213, 28.494, 24.5724>, <35.977, 26.9746, 23.7887>, <36.7486, 26.9556, 22.9884> }
					triangle { <35.5722, 28.8031, 24.1649>, <35.213, 28.494, 24.5724>, <36.7486, 26.9556, 22.9884> }
					triangle { <32.9068, 30.7634, 24.04661>, <33.04992, 31.1842, 23.9506>, <31.9595, 31.1059, 23.5615> }
					triangle { <32.9068, 30.7634, 24.04661>, <33.673, 31.04999, 24.0033>, <33.04992, 31.1842, 23.9506> }
					triangle { <33.7246, 30.4885, 24.4913>, <33.8864, 30.855, 24.472>, <32.9068, 30.7634, 24.04661> }
					triangle { <33.7246, 30.4885, 24.4913>, <35.03944, 29.7609, 23.8352>, <33.8864, 30.855, 24.472> }
					triangle { <33.8864, 30.855, 24.472>, <33.673, 31.04999, 24.0033>, <32.9068, 30.7634, 24.04661> }
					triangle { <33.8864, 30.855, 24.472>, <35.2596, 30.2821, 23.4322>, <33.673, 31.04999, 24.0033> }
					triangle { <35.03944, 29.7609, 23.8352>, <35.2596, 30.2821, 23.4322>, <33.8864, 30.855, 24.472> }
					triangle { <34.7819, 29.3484, 24.08485>, <35.03944, 29.7609, 23.8352>, <33.7246, 30.4885, 24.4913> }
					triangle { <35.03944, 29.7609, 23.8352>, <36.1107, 29.7374, 23.3182>, <35.2596, 30.2821, 23.4322> }
					triangle { <35.9664, 29.1576, 23.7211>, <36.9938, 27.9013, 22.7603>, <36.1107, 29.7374, 23.3182> }
					triangle { <35.9664, 29.1576, 23.7211>, <36.1107, 29.7374, 23.3182>, <35.03944, 29.7609, 23.8352> }
					triangle { <35.9664, 29.1576, 23.7211>, <35.03944, 29.7609, 23.8352>, <34.7819, 29.3484, 24.08485> }
					triangle { <35.5722, 28.8031, 24.1649>, <35.9664, 29.1576, 23.7211>, <34.7819, 29.3484, 24.08485> }
					triangle { <36.7486, 26.9556, 22.9884>, <36.9938, 27.9013, 22.7603>, <35.9664, 29.1576, 23.7211> }
					triangle { <36.7486, 26.9556, 22.9884>, <35.9664, 29.1576, 23.7211>, <35.5722, 28.8031, 24.1649> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		union { // inflor. internode
			cylinder { <1.7652, 12.9685, 2.06391>, <2.1001, 14.2122, 2.248>, 0.3888 }
			cylinder { <2.1001, 14.2122, 2.248>, <2.3992, 15.4685, 2.4074>, 0.3888 }
			cylinder { <2.3992, 15.4685, 2.4074>, <2.6622, 16.7356, 2.5421>, 0.3888 }
			cylinder { <2.6622, 16.7356, 2.5421>, <2.8887, 18.01225, 2.6519>, 0.3888 }
			cylinder { <2.8887, 18.01225, 2.6519>, <3.07861, 19.2967, 2.7365>, 0.3888 }
			cylinder { <3.07861, 19.2967, 2.7365>, <3.2315, 20.5874, 2.7959>, 0.3888 }
			cylinder { <3.2315, 20.5874, 2.7959>, <3.3473, 21.883, 2.83>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.3473, 21.883, 2.83>, <3.6734, 28.1619, 1.7727>, 0.3888 }
				cylinder { <3.6734, 28.1619, 1.7727>, <3.7456, 34.1303, -0.4682>, 0.3888 }
				cylinder { <3.7456, 34.1303, -0.4682>, <3.561, 39.5588, -3.8069>, 0.3888 }
				cylinder { <3.561, 39.5588, -3.8069>, <3.1269, 44.2388, -8.1148>, 0.3888 }
				cylinder { <3.1269, 44.2388, -8.1148>, <2.4597, 47.9904, -13.2265>, 0.3888 }
				cylinder { <2.4597, 47.9904, -13.2265>, <1.5853, 50.6695, -18.9455>, 0.3888 }
				cylinder { <1.5853, 50.6695, -18.9455>, <0.5371, 52.1731, -25.05206>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <0.5371, 52.1731, -25.05206>, <0.08533, 52.1328, -25.8965>, <0.1686, 52.5357, -25.9419> }
					triangle { <0.08533, 52.1328, -25.8965>, <-0.2159, 52.1198, -26.5646>, <0.1686, 52.5357, -25.9419> }
					triangle { <0.1686, 52.5357, -25.9419>, <-0.3342, 52.5271, -26.7698>, <-0.1281, 52.837, -26.7289> }
					triangle { <-0.3342, 52.5271, -26.7698>, <-1.5103, 53.1228, -27.07278>, <-0.1281, 52.837, -26.7289> }
					triangle { <0.1686, 52.5357, -25.9419>, <-0.2159, 52.1198, -26.5646>, <-0.3342, 52.5271, -26.7698> }
					triangle { <-0.2159, 52.1198, -26.5646>, <-1.7404, 52.7465, -27.06078>, <-0.3342, 52.5271, -26.7698> }
					triangle { <-0.3342, 52.5271, -26.7698>, <-1.7404, 52.7465, -27.06078>, <-1.5103, 53.1228, -27.07278> }
					triangle { <-0.1281, 52.837, -26.7289>, <-1.5103, 53.1228, -27.07278>, <-1.3137, 53.666, -27.03794> }
					triangle { <-1.7404, 52.7465, -27.06078>, <-2.3817, 53.09106, -27.5825>, <-1.5103, 53.1228, -27.07278> }
					triangle { <-2.3817, 53.09106, -27.5825>, <-3.6267, 54.3616, -27.512>, <-2.09323, 53.5853, -27.6406> }
					triangle { <-1.5103, 53.1228, -27.07278>, <-2.3817, 53.09106, -27.5825>, <-2.09323, 53.5853, -27.6406> }
					triangle { <-1.3137, 53.666, -27.03794>, <-1.5103, 53.1228, -27.07278>, <-2.09323, 53.5853, -27.6406> }
					triangle { <-1.3137, 53.666, -27.03794>, <-2.09323, 53.5853, -27.6406>, <-1.8863, 54.1137, -27.546> }
					triangle { <-2.09323, 53.5853, -27.6406>, <-3.6267, 54.3616, -27.512>, <-3.7971, 55.3603, -27.3671> }
					triangle { <-1.8863, 54.1137, -27.546>, <-2.09323, 53.5853, -27.6406>, <-3.7971, 55.3603, -27.3671> }
					triangle { <0.1686, 52.5357, -25.9419>, <0.5279, 52.7503, -25.9507>, <0.5371, 52.1731, -25.05206> }
					triangle { <0.1686, 52.5357, -25.9419>, <0.3445, 53.15, -26.342>, <0.5279, 52.7503, -25.9507> }
					triangle { <-0.1281, 52.837, -26.7289>, <0.1864, 53.01472, -26.8043>, <0.1686, 52.5357, -25.9419> }
					triangle { <-0.1281, 52.837, -26.7289>, <-0.9879, 54.04747, -26.9999>, <0.1864, 53.01472, -26.8043> }
					triangle { <0.1864, 53.01472, -26.8043>, <0.3445, 53.15, -26.342>, <0.1686, 52.5357, -25.9419> }
					triangle { <0.1864, 53.01472, -26.8043>, <-0.573, 54.5028, -26.8287>, <0.3445, 53.15, -26.342> }
					triangle { <-0.9879, 54.04747, -26.9999>, <-0.573, 54.5028, -26.8287>, <0.1864, 53.01472, -26.8043> }
					triangle { <-1.3137, 53.666, -27.03794>, <-0.9879, 54.04747, -26.9999>, <-0.1281, 52.837, -26.7289> }
					triangle { <-0.9879, 54.04747, -26.9999>, <-1.1688, 55.1027, -27.2302>, <-0.573, 54.5028, -26.8287> }
					triangle { <-1.6451, 54.6938, -27.4446>, <-2.9829, 55.7948, -27.3348>, <-1.1688, 55.1027, -27.2302> }
					triangle { <-1.6451, 54.6938, -27.4446>, <-1.1688, 55.1027, -27.2302>, <-0.9879, 54.04747, -26.9999> }
					triangle { <-1.6451, 54.6938, -27.4446>, <-0.9879, 54.04747, -26.9999>, <-1.3137, 53.666, -27.03794> }
					triangle { <-1.8863, 54.1137, -27.546>, <-1.6451, 54.6938, -27.4446>, <-1.3137, 53.666, -27.03794> }
					triangle { <-3.7971, 55.3603, -27.3671>, <-2.9829, 55.7948, -27.3348>, <-1.6451, 54.6938, -27.4446> }
					triangle { <-3.7971, 55.3603, -27.3671>, <-1.6451, 54.6938, -27.4446>, <-1.8863, 54.1137, -27.546> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <0.5371, 52.1731, -25.05206>, <0.07103, 52.581, -25.7837>, <0.4393, 52.6447, -25.9615> }
					triangle { <0.07103, 52.581, -25.7837>, <-0.2623, 52.8577, -26.375>, <0.4393, 52.6447, -25.9615> }
					triangle { <0.4393, 52.6447, -25.9615>, <-0.01019, 53.1115, -26.6815>, <0.3454, 53.02776, -26.7632> }
					triangle { <-0.01019, 53.1115, -26.6815>, <0.02442, 54.4217, -27.01639>, <0.3454, 53.02776, -26.7632> }
					triangle { <0.4393, 52.6447, -25.9615>, <-0.2623, 52.8577, -26.375>, <-0.01019, 53.1115, -26.6815> }
					triangle { <-0.2623, 52.8577, -26.375>, <-0.3802, 54.5047, -26.8613>, <-0.01019, 53.1115, -26.6815> }
					triangle { <-0.01019, 53.1115, -26.6815>, <-0.3802, 54.5047, -26.8613>, <0.02442, 54.4217, -27.01639> }
					triangle { <0.3454, 53.02776, -26.7632>, <0.02442, 54.4217, -27.01639>, <0.5808, 54.4288, -27.1753> }
					triangle { <-0.3802, 54.5047, -26.8613>, <-0.4624, 55.2256, -27.3863>, <0.02442, 54.4217, -27.01639> }
					triangle { <-0.4624, 55.2256, -27.3863>, <0.2691, 56.8382, -27.5709>, <0.05055, 55.1294, -27.6284> }
					triangle { <0.02442, 54.4217, -27.01639>, <-0.4624, 55.2256, -27.3863>, <0.05055, 55.1294, -27.6284> }
					triangle { <0.5808, 54.4288, -27.1753>, <0.02442, 54.4217, -27.01639>, <0.05055, 55.1294, -27.6284> }
					triangle { <0.5808, 54.4288, -27.1753>, <0.05055, 55.1294, -27.6284>, <0.6171, 55.1218, -27.7275> }
					triangle { <0.05055, 55.1294, -27.6284>, <0.2691, 56.8382, -27.5709>, <1.1423, 57.3492, -27.7252> }
					triangle { <0.6171, 55.1218, -27.7275>, <0.05055, 55.1294, -27.6284>, <1.1423, 57.3492, -27.7252> }
					triangle { <0.4393, 52.6447, -25.9615>, <0.7452, 52.3839, -26.0783>, <0.5371, 52.1731, -25.05206> }
					triangle { <0.4393, 52.6447, -25.9615>, <0.9073, 52.6957, -26.5505>, <0.7452, 52.3839, -26.0783> }
					triangle { <0.3454, 53.02776, -26.7632>, <0.5818, 52.7956, -26.9261>, <0.4393, 52.6447, -25.9615> }
					triangle { <0.3454, 53.02776, -26.7632>, <1.03843, 54.2581, -27.2958>, <0.5818, 52.7956, -26.9261> }
					triangle { <0.5818, 52.7956, -26.9261>, <0.9073, 52.6957, -26.5505>, <0.4393, 52.6447, -25.9615> }
					triangle { <0.5818, 52.7956, -26.9261>, <1.6351, 54.03012, -27.3241>, <0.9073, 52.6957, -26.5505> }
					triangle { <1.03843, 54.2581, -27.2958>, <1.6351, 54.03012, -27.3241>, <0.5818, 52.7956, -26.9261> }
					triangle { <0.5808, 54.4288, -27.1753>, <1.03843, 54.2581, -27.2958>, <0.3454, 53.02776, -26.7632> }
					triangle { <1.03843, 54.2581, -27.2958>, <1.8334, 54.7984, -27.8205>, <1.6351, 54.03012, -27.3241> }
					triangle { <1.2431, 55.1002, -27.8403>, <1.807, 56.7399, -27.9242>, <1.8334, 54.7984, -27.8205> }
					triangle { <1.2431, 55.1002, -27.8403>, <1.8334, 54.7984, -27.8205>, <1.03843, 54.2581, -27.2958> }
					triangle { <1.2431, 55.1002, -27.8403>, <1.03843, 54.2581, -27.2958>, <0.5808, 54.4288, -27.1753> }
					triangle { <0.6171, 55.1218, -27.7275>, <1.2431, 55.1002, -27.8403>, <0.5808, 54.4288, -27.1753> }
					triangle { <1.1423, 57.3492, -27.7252>, <1.807, 56.7399, -27.9242>, <1.2431, 55.1002, -27.8403> }
					triangle { <1.1423, 57.3492, -27.7252>, <1.2431, 55.1002, -27.8403>, <0.6171, 55.1218, -27.7275> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <0.5371, 52.1731, -25.05206>, <0.4993, 52.7522, -25.8151>, <0.6189, 52.4296, -26.04535> }
					triangle { <0.4993, 52.7522, -25.8151>, <0.4366, 53.1609, -26.4203>, <0.6189, 52.4296, -26.04535> }
					triangle { <0.6189, 52.4296, -26.04535>, <0.6426, 53.01393, -26.8176>, <0.6597, 52.6514, -26.9098> }
					triangle { <0.6426, 53.01393, -26.8176>, <1.6997, 53.4421, -27.5451>, <0.6597, 52.6514, -26.9098> }
					triangle { <0.6189, 52.4296, -26.04535>, <0.4366, 53.1609, -26.4203>, <0.6426, 53.01393, -26.8176> }
					triangle { <0.4366, 53.1609, -26.4203>, <1.69, 53.8503, -27.3778>, <0.6426, 53.01393, -26.8176> }
					triangle { <0.6426, 53.01393, -26.8176>, <1.69, 53.8503, -27.3778>, <1.6997, 53.4421, -27.5451> }
					triangle { <0.6597, 52.6514, -26.9098>, <1.6997, 53.4421, -27.5451>, <1.8381, 52.9237, -27.7617> }
					triangle { <1.69, 53.8503, -27.3778>, <2.1248, 54.1803, -28.08788>, <1.6997, 53.4421, -27.5451> }
					triangle { <2.1248, 54.1803, -28.08788>, <3.7302, 54.06277, -28.8484>, <2.13, 53.666, -28.3456> }
					triangle { <1.6997, 53.4421, -27.5451>, <2.1248, 54.1803, -28.08788>, <2.13, 53.666, -28.3456> }
					triangle { <1.8381, 52.9237, -27.7617>, <1.6997, 53.4421, -27.5451>, <2.13, 53.666, -28.3456> }
					triangle { <1.8381, 52.9237, -27.7617>, <2.13, 53.666, -28.3456>, <2.2786, 53.1328, -28.5024> }
					triangle { <2.13, 53.666, -28.3456>, <3.7302, 54.06277, -28.8484>, <4.4202, 53.425, -29.2542> }
					triangle { <2.2786, 53.1328, -28.5024>, <2.13, 53.666, -28.3456>, <4.4202, 53.425, -29.2542> }
					triangle { <0.6189, 52.4296, -26.04535>, <0.4515, 52.05144, -26.1097>, <0.5371, 52.1731, -25.05206> }
					triangle { <0.6189, 52.4296, -26.04535>, <0.624, 52.00895, -26.671>, <0.4515, 52.05144, -26.1097> }
					triangle { <0.6597, 52.6514, -26.9098>, <0.4793, 52.3483, -27.01866>, <0.6189, 52.4296, -26.04535> }
					triangle { <0.6597, 52.6514, -26.9098>, <1.7994, 52.4351, -27.8753>, <0.4793, 52.3483, -27.01866> }
					triangle { <0.4793, 52.3483, -27.01866>, <0.624, 52.00895, -26.671>, <0.6189, 52.4296, -26.04535> }
					triangle { <0.4793, 52.3483, -27.01866>, <1.7869, 51.7963, -27.9002>, <0.624, 52.00895, -26.671> }
					triangle { <1.7994, 52.4351, -27.8753>, <1.7869, 51.7963, -27.9002>, <0.4793, 52.3483, -27.01866> }
					triangle { <1.8381, 52.9237, -27.7617>, <1.7994, 52.4351, -27.8753>, <0.6597, 52.6514, -26.9098> }
					triangle { <1.7994, 52.4351, -27.8753>, <2.3664, 51.8804, -28.6304>, <1.7869, 51.7963, -27.9002> }
					triangle { <2.4301, 52.5392, -28.6746>, <4.03719, 52.5882, -29.3293>, <2.3664, 51.8804, -28.6304> }
					triangle { <2.4301, 52.5392, -28.6746>, <2.3664, 51.8804, -28.6304>, <1.7994, 52.4351, -27.8753> }
					triangle { <2.4301, 52.5392, -28.6746>, <1.7994, 52.4351, -27.8753>, <1.8381, 52.9237, -27.7617> }
					triangle { <2.2786, 53.1328, -28.5024>, <2.4301, 52.5392, -28.6746>, <1.8381, 52.9237, -27.7617> }
					triangle { <4.4202, 53.425, -29.2542>, <4.03719, 52.5882, -29.3293>, <2.4301, 52.5392, -28.6746> }
					triangle { <4.4202, 53.425, -29.2542>, <2.4301, 52.5392, -28.6746>, <2.2786, 53.1328, -28.5024> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <0.5371, 52.1731, -25.05206>, <0.7824, 52.4114, -25.9476>, <0.4609, 52.1857, -26.07829> }
					triangle { <0.7824, 52.4114, -25.9476>, <0.9215, 52.6133, -26.6384>, <0.4609, 52.1857, -26.07829> }
					triangle { <0.4609, 52.1857, -26.07829>, <0.7282, 52.3683, -26.9913>, <0.3833, 52.2246, -26.9674> }
					triangle { <0.7282, 52.3683, -26.9913>, <1.2159, 51.5287, -27.9332>, <0.3833, 52.2246, -26.9674> }
					triangle { <0.4609, 52.1857, -26.07829>, <0.9215, 52.6133, -26.6384>, <0.7282, 52.3683, -26.9913> }
					triangle { <0.9215, 52.6133, -26.6384>, <1.6286, 51.6815, -27.9013>, <0.7282, 52.3683, -26.9913> }
					triangle { <0.7282, 52.3683, -26.9913>, <1.6286, 51.6815, -27.9013>, <1.2159, 51.5287, -27.9332> }
					triangle { <0.3833, 52.2246, -26.9674>, <1.2159, 51.5287, -27.9332>, <0.7323, 51.2165, -27.9922> }
					triangle { <1.6286, 51.6815, -27.9013>, <1.8287, 51.3899, -28.7241>, <1.2159, 51.5287, -27.9332> }
					triangle { <1.8287, 51.3899, -28.7241>, <2.005783, 49.845, -29.5909>, <1.2908, 51.2039, -28.8079> }
					triangle { <1.2159, 51.5287, -27.9332>, <1.8287, 51.3899, -28.7241>, <1.2908, 51.2039, -28.8079> }
					triangle { <0.7323, 51.2165, -27.9922>, <1.2159, 51.5287, -27.9332>, <1.2908, 51.2039, -28.8079> }
					triangle { <0.7323, 51.2165, -27.9922>, <1.2908, 51.2039, -28.8079>, <0.8174, 50.877, -28.8071> }
					triangle { <1.2908, 51.2039, -28.8079>, <2.005783, 49.845, -29.5909>, <1.5373, 48.9743, -29.8552> }
					triangle { <0.8174, 50.877, -28.8071>, <1.2908, 51.2039, -28.8079>, <1.5373, 48.9743, -29.8552> }
					triangle { <0.4609, 52.1857, -26.07829>, <0.05007, 52.2093, -26.00197>, <0.5371, 52.1731, -25.05206> }
					triangle { <0.4609, 52.1857, -26.07829>, <-0.1164, 52.03235, -26.5381>, <0.05007, 52.2093, -26.00197> }
					triangle { <0.3833, 52.2246, -26.9674>, <0.01965, 52.2868, -26.9549>, <0.4609, 52.1857, -26.07829> }
					triangle { <0.3833, 52.2246, -26.9674>, <0.2504, 51.08076, -27.943>, <0.01965, 52.2868, -26.9549> }
					triangle { <0.01965, 52.2868, -26.9549>, <-0.1164, 52.03235, -26.5381>, <0.4609, 52.1857, -26.07829> }
					triangle { <0.01965, 52.2868, -26.9549>, <-0.3259, 50.8676, -27.7662>, <-0.1164, 52.03235, -26.5381> }
					triangle { <0.2504, 51.08076, -27.943>, <-0.3259, 50.8676, -27.7662>, <0.01965, 52.2868, -26.9549> }
					triangle { <0.7323, 51.2165, -27.9922>, <0.2504, 51.08076, -27.943>, <0.3833, 52.2246, -26.9674> }
					triangle { <0.2504, 51.08076, -27.943>, <-0.3015, 50.354, -28.5483>, <-0.3259, 50.8676, -27.7662> }
					triangle { <0.2865, 50.5261, -28.8024>, <0.6462, 49.03838, -29.6214>, <-0.3015, 50.354, -28.5483> }
					triangle { <0.2865, 50.5261, -28.8024>, <-0.3015, 50.354, -28.5483>, <0.2504, 51.08076, -27.943> }
					triangle { <0.2865, 50.5261, -28.8024>, <0.2504, 51.08076, -27.943>, <0.7323, 51.2165, -27.9922> }
					triangle { <0.8174, 50.877, -28.8071>, <0.2865, 50.5261, -28.8024>, <0.7323, 51.2165, -27.9922> }
					triangle { <1.5373, 48.9743, -29.8552>, <0.6462, 49.03838, -29.6214>, <0.2865, 50.5261, -28.8024> }
					triangle { <1.5373, 48.9743, -29.8552>, <0.2865, 50.5261, -28.8024>, <0.8174, 50.877, -28.8071> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <0.5371, 52.1731, -25.05206>, <0.5226, 52.02286, -25.9987>, <0.1784, 52.2523, -26.01342> }
					triangle { <0.5226, 52.02286, -25.9987>, <0.5121, 51.9601, -26.7289>, <0.1784, 52.2523, -26.01342> }
					triangle { <0.1784, 52.2523, -26.01342>, <0.1153, 52.06291, -26.9613>, <-0.111, 52.3411, -26.8539> }
					triangle { <0.1153, 52.06291, -26.9613>, <-0.7979, 51.3284, -27.6369>, <-0.111, 52.3411, -26.8539> }
					triangle { <0.1784, 52.2523, -26.01342>, <0.5121, 51.9601, -26.7289>, <0.1153, 52.06291, -26.9613> }
					triangle { <0.5121, 51.9601, -26.7289>, <-0.5235, 50.9891, -27.7024>, <0.1153, 52.06291, -26.9613> }
					triangle { <0.1153, 52.06291, -26.9613>, <-0.5235, 50.9891, -27.7024>, <-0.7979, 51.3284, -27.6369> }
					triangle { <-0.111, 52.3411, -26.8539>, <-0.7979, 51.3284, -27.6369>, <-1.245, 51.6822, -27.5382> }
					triangle { <-0.5235, 50.9891, -27.7024>, <-0.9985, 50.7065, -28.4071>, <-0.7979, 51.3284, -27.6369> }
					triangle { <-0.9985, 50.7065, -28.4071>, <-2.6097, 50.03254, -28.7525>, <-1.3586, 51.1532, -28.3655> }
					triangle { <-0.7979, 51.3284, -27.6369>, <-0.9985, 50.7065, -28.4071>, <-1.3586, 51.1532, -28.3655> }
					triangle { <-1.245, 51.6822, -27.5382>, <-0.7979, 51.3284, -27.6369>, <-1.3586, 51.1532, -28.3655> }
					triangle { <-1.245, 51.6822, -27.5382>, <-1.3586, 51.1532, -28.3655>, <-1.7955, 51.4924, -28.2071> }
					triangle { <-1.3586, 51.1532, -28.3655>, <-2.6097, 50.03254, -28.7525>, <-3.6179, 50.1884, -28.6714> }
					triangle { <-1.7955, 51.4924, -28.2071>, <-1.3586, 51.1532, -28.3655>, <-3.6179, 50.1884, -28.6714> }
					triangle { <0.1784, 52.2523, -26.01342>, <0.09797, 52.6477, -25.9022>, <0.5371, 52.1731, -25.05206> }
					triangle { <0.1784, 52.2523, -26.01342>, <-0.2918, 52.7482, -26.3317>, <0.09797, 52.6477, -25.9022> }
					triangle { <-0.111, 52.3411, -26.8539>, <-0.164, 52.7049, -26.8204>, <0.1784, 52.2523, -26.01342> }
					triangle { <-0.111, 52.3411, -26.8539>, <-1.4982, 52.09227, -27.3937>, <-0.164, 52.7049, -26.8204> }
					triangle { <-0.164, 52.7049, -26.8204>, <-0.2918, 52.7482, -26.3317>, <0.1784, 52.2523, -26.01342> }
					triangle { <-0.164, 52.7049, -26.8204>, <-1.8064, 52.5655, -27.09403>, <-0.2918, 52.7482, -26.3317> }
					triangle { <-1.4982, 52.09227, -27.3937>, <-1.8064, 52.5655, -27.09403>, <-0.164, 52.7049, -26.8204> }
					triangle { <-1.245, 51.6822, -27.5382>, <-1.4982, 52.09227, -27.3937>, <-0.111, 52.3411, -26.8539> }
					triangle { <-1.4982, 52.09227, -27.3937>, <-2.5194, 52.3755, -27.6699>, <-1.8064, 52.5655, -27.09403> }
					triangle { <-2.2701, 51.8779, -28.03073>, <-3.7578, 51.05008, -28.3701>, <-2.5194, 52.3755, -27.6699> }
					triangle { <-2.2701, 51.8779, -28.03073>, <-2.5194, 52.3755, -27.6699>, <-1.4982, 52.09227, -27.3937> }
					triangle { <-2.2701, 51.8779, -28.03073>, <-1.4982, 52.09227, -27.3937>, <-1.245, 51.6822, -27.5382> }
					triangle { <-1.7955, 51.4924, -28.2071>, <-2.2701, 51.8779, -28.03073>, <-1.245, 51.6822, -27.5382> }
					triangle { <-3.6179, 50.1884, -28.6714>, <-3.7578, 51.05008, -28.3701>, <-2.2701, 51.8779, -28.03073> }
					triangle { <-3.6179, 50.1884, -28.6714>, <-2.2701, 51.8779, -28.03073>, <-1.7955, 51.4924, -28.2071> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		union { // inflor. internode
			cylinder { <3.3473, 21.883, 2.83>, <3.4736, 23.1756, 2.9079>, 0.3888 }
			cylinder { <3.4736, 23.1756, 2.9079>, <3.6101, 24.4639, 3.02964>, 0.3888 }
			cylinder { <3.6101, 24.4639, 3.02964>, <3.7568, 25.7461, 3.1949>, 0.3888 }
			cylinder { <3.7568, 25.7461, 3.1949>, <3.9134, 27.0209, 3.4036>, 0.3888 }
			cylinder { <3.9134, 27.0209, 3.4036>, <4.07974, 28.2865, 3.6554>, 0.3888 }
			cylinder { <4.07974, 28.2865, 3.6554>, <4.2555, 29.5416, 3.9501>, 0.3888 }
			cylinder { <4.2555, 29.5416, 3.9501>, <4.4406, 30.7846, 4.2874>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.4406, 30.7846, 4.2874>, <4.6563, 36.5791, 6.9381>, 0.3888 }
				cylinder { <4.6563, 36.5791, 6.9381>, <4.1727, 41.8547, 10.4854>, 0.3888 }
				cylinder { <4.1727, 41.8547, 10.4854>, <3.008201, 46.4087, 14.7928>, 0.3888 }
				cylinder { <3.008201, 46.4087, 14.7928>, <1.2076, 50.06618, 19.6949>, 0.3888 }
				cylinder { <1.2076, 50.06618, 19.6949>, <-1.1598, 52.6864, 25.00332>, 0.3888 }
				cylinder { <-1.1598, 52.6864, 25.00332>, <-4.003212, 54.1687, 30.5139>, 0.3888 }
				cylinder { <-4.003212, 54.1687, 30.5139>, <-7.2132, 54.4563, 36.01507>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.2132, 54.4563, 36.01507>, <-7.4894, 54.1549, 36.8821>, <-7.5036, 54.552, 36.9977> }
					triangle { <-7.4894, 54.1549, 36.8821>, <-7.7436, 53.9544, 37.5397>, <-7.5036, 54.552, 36.9977> }
					triangle { <-7.5036, 54.552, 36.9977>, <-7.7268, 54.2633, 37.895>, <-7.7843, 54.6295, 37.8423> }
					triangle { <-7.7268, 54.2633, 37.895>, <-7.00422, 54.3494, 39.03541>, <-7.7843, 54.6295, 37.8423> }
					triangle { <-7.5036, 54.552, 36.9977>, <-7.7436, 53.9544, 37.5397>, <-7.7268, 54.2633, 37.895> }
					triangle { <-7.7436, 53.9544, 37.5397>, <-6.9057, 53.9193, 39.04303>, <-7.7268, 54.2633, 37.895> }
					triangle { <-7.7268, 54.2633, 37.895>, <-6.9057, 53.9193, 39.04303>, <-7.00422, 54.3494, 39.03541> }
					triangle { <-7.7843, 54.6295, 37.8423>, <-7.00422, 54.3494, 39.03541>, <-7.01573, 54.9268, 39.07083> }
					triangle { <-6.9057, 53.9193, 39.04303>, <-6.7546, 53.9424, 39.9255>, <-7.00422, 54.3494, 39.03541> }
					triangle { <-6.7546, 53.9424, 39.9255>, <-5.5995, 54.6708, 41.06771>, <-6.9037, 54.4973, 39.9541> }
					triangle { <-7.00422, 54.3494, 39.03541>, <-6.7546, 53.9424, 39.9255>, <-6.9037, 54.4973, 39.9541> }
					triangle { <-7.01573, 54.9268, 39.07083>, <-7.00422, 54.3494, 39.03541>, <-6.9037, 54.4973, 39.9541> }
					triangle { <-7.01573, 54.9268, 39.07083>, <-6.9037, 54.4973, 39.9541>, <-6.8838, 55.07201, 39.9357> }
					triangle { <-6.9037, 54.4973, 39.9541>, <-5.5995, 54.6708, 41.06771>, <-5.1937, 55.5483, 41.4032> }
					triangle { <-6.8838, 55.07201, 39.9357>, <-6.9037, 54.4973, 39.9541>, <-5.1937, 55.5483, 41.4032> }
					triangle { <-7.5036, 54.552, 36.9977>, <-7.7203, 54.8802, 36.8541>, <-7.2132, 54.4563, 36.01507> }
					triangle { <-7.5036, 54.552, 36.9977>, <-7.7881, 55.1365, 37.3797>, <-7.7203, 54.8802, 36.8541> }
					triangle { <-7.7843, 54.6295, 37.8423>, <-8.0228, 54.8994, 37.7614>, <-7.5036, 54.552, 36.9977> }
					triangle { <-7.7843, 54.6295, 37.8423>, <-7.1454, 55.4024, 38.9703>, <-8.0228, 54.8994, 37.7614> }
					triangle { <-8.0228, 54.8994, 37.7614>, <-7.7881, 55.1365, 37.3797>, <-7.5036, 54.552, 36.9977> }
					triangle { <-8.0228, 54.8994, 37.7614>, <-7.2314, 55.9944, 38.7445>, <-7.7881, 55.1365, 37.3797> }
					triangle { <-7.1454, 55.4024, 38.9703>, <-7.2314, 55.9944, 38.7445>, <-8.0228, 54.8994, 37.7614> }
					triangle { <-7.01573, 54.9268, 39.07083>, <-7.1454, 55.4024, 38.9703>, <-7.7843, 54.6295, 37.8423> }
					triangle { <-7.1454, 55.4024, 38.9703>, <-6.9811, 56.2842, 39.5986>, <-7.2314, 55.9944, 38.7445> }
					triangle { <-6.8734, 55.7077, 39.9085>, <-5.6582, 56.2501, 41.02325>, <-6.9811, 56.2842, 39.5986> }
					triangle { <-6.8734, 55.7077, 39.9085>, <-6.9811, 56.2842, 39.5986>, <-7.1454, 55.4024, 38.9703> }
					triangle { <-6.8734, 55.7077, 39.9085>, <-7.1454, 55.4024, 38.9703>, <-7.01573, 54.9268, 39.07083> }
					triangle { <-6.8838, 55.07201, 39.9357>, <-6.8734, 55.7077, 39.9085>, <-7.01573, 54.9268, 39.07083> }
					triangle { <-5.1937, 55.5483, 41.4032>, <-5.6582, 56.2501, 41.02325>, <-6.8734, 55.7077, 39.9085> }
					triangle { <-5.1937, 55.5483, 41.4032>, <-6.8734, 55.7077, 39.9085>, <-6.8838, 55.07201, 39.9357> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-7.2132, 54.4563, 36.01507>, <-7.3176, 54.5769, 36.9603>, <-7.6856, 54.749, 36.8811> }
					triangle { <-7.3176, 54.5769, 36.9603>, <-7.4421, 54.6414, 37.6798>, <-7.6856, 54.749, 36.8811> }
					triangle { <-7.6856, 54.749, 36.8811>, <-7.7825, 54.9316, 37.8275>, <-8.1028, 54.9742, 37.6384> }
					triangle { <-7.7825, 54.9316, 37.8275>, <-7.7932, 56.1151, 38.4827>, <-8.1028, 54.9742, 37.6384> }
					triangle { <-7.6856, 54.749, 36.8811>, <-7.4421, 54.6414, 37.6798>, <-7.7825, 54.9316, 37.8275> }
					triangle { <-7.4421, 54.6414, 37.6798>, <-7.3881, 56.06268, 38.6495>, <-7.7825, 54.9316, 37.8275> }
					triangle { <-7.7825, 54.9316, 37.8275>, <-7.3881, 56.06268, 38.6495>, <-7.7932, 56.1151, 38.4827> }
					triangle { <-8.1028, 54.9742, 37.6384>, <-7.7932, 56.1151, 38.4827>, <-8.2899, 56.3057, 38.2552> }
					triangle { <-7.3881, 56.06268, 38.6495>, <-7.559, 56.6368, 39.3153>, <-7.7932, 56.1151, 38.4827> }
					triangle { <-7.559, 56.6368, 39.3153>, <-7.8954, 58.3712, 39.5346>, <-8.1022, 56.7063, 39.1393> }
					triangle { <-7.7932, 56.1151, 38.4827>, <-7.559, 56.6368, 39.3153>, <-8.1022, 56.7063, 39.1393> }
					triangle { <-8.2899, 56.3057, 38.2552>, <-7.7932, 56.1151, 38.4827>, <-8.1022, 56.7063, 39.1393> }
					triangle { <-8.2899, 56.3057, 38.2552>, <-8.1022, 56.7063, 39.1393>, <-8.5676, 56.8941, 38.8579> }
					triangle { <-8.1022, 56.7063, 39.1393>, <-7.8954, 58.3712, 39.5346>, <-8.5158, 59.1433, 39.2768> }
					triangle { <-8.5676, 56.8941, 38.8579>, <-8.1022, 56.7063, 39.1393>, <-8.5158, 59.1433, 39.2768> }
					triangle { <-7.6856, 54.749, 36.8811>, <-8.02863, 54.6058, 36.6885>, <-7.2132, 54.4563, 36.01507> }
					triangle { <-7.6856, 54.749, 36.8811>, <-8.4099, 54.8974, 37.02939>, <-8.02863, 54.6058, 36.6885> }
					triangle { <-8.1028, 54.9742, 37.6384>, <-8.4238, 54.8267, 37.5311>, <-7.6856, 54.749, 36.8811> }
					triangle { <-8.1028, 54.9742, 37.6384>, <-8.7245, 56.3006, 38.00188>, <-8.4238, 54.8267, 37.5311> }
					triangle { <-8.4238, 54.8267, 37.5311>, <-8.4099, 54.8974, 37.02939>, <-7.6856, 54.749, 36.8811> }
					triangle { <-8.4238, 54.8267, 37.5311>, <-9.2031, 56.304, 37.5778>, <-8.4099, 54.8974, 37.02939> }
					triangle { <-8.7245, 56.3006, 38.00188>, <-9.2031, 56.304, 37.5778>, <-8.4238, 54.8267, 37.5311> }
					triangle { <-8.2899, 56.3057, 38.2552>, <-8.7245, 56.3006, 38.00188>, <-8.1028, 54.9742, 37.6384> }
					triangle { <-8.7245, 56.3006, 38.00188>, <-9.541, 57.02766, 38.06602>, <-9.2031, 56.304, 37.5778> }
					triangle { <-9.08637, 57.08896, 38.545>, <-9.2312, 58.7992, 38.805>, <-9.541, 57.02766, 38.06602> }
					triangle { <-9.08637, 57.08896, 38.545>, <-9.541, 57.02766, 38.06602>, <-8.7245, 56.3006, 38.00188> }
					triangle { <-9.08637, 57.08896, 38.545>, <-8.7245, 56.3006, 38.00188>, <-8.2899, 56.3057, 38.2552> }
					triangle { <-8.5676, 56.8941, 38.8579>, <-9.08637, 57.08896, 38.545>, <-8.2899, 56.3057, 38.2552> }
					triangle { <-8.5158, 59.1433, 39.2768>, <-9.2312, 58.7992, 38.805>, <-9.08637, 57.08896, 38.545> }
					triangle { <-8.5158, 59.1433, 39.2768>, <-9.08637, 57.08896, 38.545>, <-8.5676, 56.8941, 38.8579> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-7.2132, 54.4563, 36.01507>, <-7.6062, 54.8875, 36.7756>, <-7.9091, 54.606, 36.7582> }
					triangle { <-7.6062, 54.8875, 36.7756>, <-7.9044, 55.1709, 37.3823>, <-7.9091, 54.606, 36.7582> }
					triangle { <-7.9091, 54.606, 36.7582>, <-8.3505, 55.06339, 37.4893>, <-8.4939, 54.7239, 37.4233> }
					triangle { <-8.3505, 55.06339, 37.4893>, <-9.511, 55.7584, 37.4989>, <-8.4939, 54.7239, 37.4233> }
					triangle { <-7.9091, 54.606, 36.7582>, <-7.9044, 55.1709, 37.3823>, <-8.3505, 55.06339, 37.4893> }
					triangle { <-7.9044, 55.1709, 37.3823>, <-9.3122, 56.1517, 37.5221>, <-8.3505, 55.06339, 37.4893> }
					triangle { <-8.3505, 55.06339, 37.4893>, <-9.3122, 56.1517, 37.5221>, <-9.511, 55.7584, 37.4989> }
					triangle { <-8.4939, 54.7239, 37.4233>, <-9.511, 55.7584, 37.4989>, <-9.8543, 55.3044, 37.3947> }
					triangle { <-9.3122, 56.1517, 37.5221>, <-10.04489, 56.5313, 37.8702>, <-9.511, 55.7584, 37.4989> }
					triangle { <-10.04489, 56.5313, 37.8702>, <-11.7129, 56.918, 37.3829>, <-10.3229, 56.02775, 37.879> }
					triangle { <-9.511, 55.7584, 37.4989>, <-10.04489, 56.5313, 37.8702>, <-10.3229, 56.02775, 37.879> }
					triangle { <-9.8543, 55.3044, 37.3947>, <-9.511, 55.7584, 37.4989>, <-10.3229, 56.02775, 37.879> }
					triangle { <-9.8543, 55.3044, 37.3947>, <-10.3229, 56.02775, 37.879>, <-10.6347, 55.5708, 37.7209> }
					triangle { <-10.3229, 56.02775, 37.879>, <-11.7129, 56.918, 37.3829>, <-12.5942, 56.5326, 37.03349> }
					triangle { <-10.6347, 55.5708, 37.7209>, <-10.3229, 56.02775, 37.879>, <-12.5942, 56.5326, 37.03349> }
					triangle { <-7.9091, 54.606, 36.7582>, <-7.9076, 54.188, 36.7809>, <-7.2132, 54.4563, 36.01507> }
					triangle { <-7.9091, 54.606, 36.7582>, <-8.424, 54.1455, 37.06046>, <-7.9076, 54.188, 36.7809> }
					triangle { <-8.4939, 54.7239, 37.4233>, <-8.4999, 54.3653, 37.5108>, <-7.9091, 54.606, 36.7582> }
					triangle { <-8.4939, 54.7239, 37.4233>, <-9.9972, 54.8256, 37.3363>, <-8.4999, 54.3653, 37.5108> }
					triangle { <-8.4999, 54.3653, 37.5108>, <-8.424, 54.1455, 37.06046>, <-7.9091, 54.606, 36.7582> }
					triangle { <-8.4999, 54.3653, 37.5108>, <-10.1252, 54.228, 37.1482>, <-8.424, 54.1455, 37.06046> }
					triangle { <-9.9972, 54.8256, 37.3363>, <-10.1252, 54.228, 37.1482>, <-8.4999, 54.3653, 37.5108> }
					triangle { <-9.8543, 55.3044, 37.3947>, <-9.9972, 54.8256, 37.3363>, <-8.4939, 54.7239, 37.4233> }
					triangle { <-9.9972, 54.8256, 37.3363>, <-11.01877, 54.4308, 37.3394>, <-10.1252, 54.228, 37.1482> }
					triangle { <-10.9705, 55.05744, 37.5518>, <-12.5354, 55.6111, 37.04365>, <-11.01877, 54.4308, 37.3394> }
					triangle { <-10.9705, 55.05744, 37.5518>, <-11.01877, 54.4308, 37.3394>, <-9.9972, 54.8256, 37.3363> }
					triangle { <-10.9705, 55.05744, 37.5518>, <-9.9972, 54.8256, 37.3363>, <-9.8543, 55.3044, 37.3947> }
					triangle { <-10.6347, 55.5708, 37.7209>, <-10.9705, 55.05744, 37.5518>, <-9.8543, 55.3044, 37.3947> }
					triangle { <-12.5942, 56.5326, 37.03349>, <-12.5354, 55.6111, 37.04365>, <-10.9705, 55.05744, 37.5518> }
					triangle { <-12.5942, 56.5326, 37.03349>, <-10.9705, 55.05744, 37.5518>, <-10.6347, 55.5708, 37.7209> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-7.2132, 54.4563, 36.01507>, <-7.959, 54.6602, 36.5816>, <-7.8673, 54.3192, 36.7976> }
					triangle { <-7.959, 54.6602, 36.5816>, <-8.496, 54.816, 37.05571>, <-7.8673, 54.3192, 36.7976> }
					triangle { <-7.8673, 54.3192, 36.7976>, <-8.651, 54.4777, 37.3445>, <-8.4207, 54.2221, 37.4922> }
					triangle { <-8.651, 54.4777, 37.3445>, <-9.7997, 53.7688, 37.4345>, <-8.4207, 54.2221, 37.4922> }
					triangle { <-7.8673, 54.3192, 36.7976>, <-8.496, 54.816, 37.05571>, <-8.651, 54.4777, 37.3445> }
					triangle { <-8.496, 54.816, 37.05571>, <-10.03701, 54.06424, 37.2083>, <-8.651, 54.4777, 37.3445> }
					triangle { <-8.651, 54.4777, 37.3445>, <-10.03701, 54.06424, 37.2083>, <-9.7997, 53.7688, 37.4345> }
					triangle { <-8.4207, 54.2221, 37.4922>, <-9.7997, 53.7688, 37.4345>, <-9.5614, 53.2973, 37.6705> }
					triangle { <-10.03701, 54.06424, 37.2083>, <-10.8001, 53.7707, 37.5738>, <-9.7997, 53.7688, 37.4345> }
					triangle { <-10.8001, 53.7707, 37.5738>, <-11.812, 52.306, 37.5662>, <-10.5175, 53.393, 37.9031> }
					triangle { <-9.7997, 53.7688, 37.4345>, <-10.8001, 53.7707, 37.5738>, <-10.5175, 53.393, 37.9031> }
					triangle { <-9.5614, 53.2973, 37.6705>, <-9.7997, 53.7688, 37.4345>, <-10.5175, 53.393, 37.9031> }
					triangle { <-9.5614, 53.2973, 37.6705>, <-10.5175, 53.393, 37.9031>, <-10.2478, 52.9186, 38.08534> }
					triangle { <-10.5175, 53.393, 37.9031>, <-11.812, 52.306, 37.5662>, <-11.8307, 51.2998, 37.7525> }
					triangle { <-10.2478, 52.9186, 38.08534>, <-10.5175, 53.393, 37.9031>, <-11.8307, 51.2998, 37.7525> }
					triangle { <-7.8673, 54.3192, 36.7976>, <-7.5234, 54.2002, 37.00454>, <-7.2132, 54.4563, 36.01507> }
					triangle { <-7.8673, 54.3192, 36.7976>, <-7.8111, 53.9129, 37.4302>, <-7.5234, 54.2002, 37.00454> }
					triangle { <-8.4207, 54.2221, 37.4922>, <-8.1466, 54.1485, 37.7283>, <-7.8673, 54.3192, 36.7976> }
					triangle { <-8.4207, 54.2221, 37.4922>, <-9.2165, 53.00208, 37.8872>, <-8.1466, 54.1485, 37.7283> }
					triangle { <-8.1466, 54.1485, 37.7283>, <-7.8111, 53.9129, 37.4302>, <-7.8673, 54.3192, 36.7976> }
					triangle { <-8.1466, 54.1485, 37.7283>, <-8.732, 52.616, 38.04549>, <-7.8111, 53.9129, 37.4302> }
					triangle { <-9.2165, 53.00208, 37.8872>, <-8.732, 52.616, 38.04549>, <-8.1466, 54.1485, 37.7283> }
					triangle { <-9.5614, 53.2973, 37.6705>, <-9.2165, 53.00208, 37.8872>, <-8.4207, 54.2221, 37.4922> }
					triangle { <-9.2165, 53.00208, 37.8872>, <-9.3859, 52.05831, 38.4162>, <-8.732, 52.616, 38.04549> }
					triangle { <-9.9397, 52.4016, 38.2921>, <-11.03537, 51.0619, 38.1567>, <-9.3859, 52.05831, 38.4162> }
					triangle { <-9.9397, 52.4016, 38.2921>, <-9.3859, 52.05831, 38.4162>, <-9.2165, 53.00208, 37.8872> }
					triangle { <-9.9397, 52.4016, 38.2921>, <-9.2165, 53.00208, 37.8872>, <-9.5614, 53.2973, 37.6705> }
					triangle { <-10.2478, 52.9186, 38.08534>, <-9.9397, 52.4016, 38.2921>, <-9.5614, 53.2973, 37.6705> }
					triangle { <-11.8307, 51.2998, 37.7525>, <-11.03537, 51.0619, 38.1567>, <-9.9397, 52.4016, 38.2921> }
					triangle { <-11.8307, 51.2998, 37.7525>, <-9.9397, 52.4016, 38.2921>, <-10.2478, 52.9186, 38.08534> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-7.2132, 54.4563, 36.01507>, <-7.8858, 54.2006, 36.6484>, <-7.6129, 54.2854, 36.9478> }
					triangle { <-7.8858, 54.2006, 36.6484>, <-8.3951, 54.05286, 37.1544>, <-7.6129, 54.2854, 36.9478> }
					triangle { <-7.6129, 54.2854, 36.9478>, <-8.2598, 53.9758, 37.599>, <-7.9755, 54.1629, 37.7551> }
					triangle { <-8.2598, 53.9758, 37.599>, <-8.227, 52.8849, 38.3984>, <-7.9755, 54.1629, 37.7551> }
					triangle { <-7.6129, 54.2854, 36.9478>, <-8.3951, 54.05286, 37.1544>, <-8.2598, 53.9758, 37.599> }
					triangle { <-8.3951, 54.05286, 37.1544>, <-8.5272, 52.6637, 38.1624>, <-8.2598, 53.9758, 37.599> }
					triangle { <-8.2598, 53.9758, 37.599>, <-8.5272, 52.6637, 38.1624>, <-8.227, 52.8849, 38.3984> }
					triangle { <-7.9755, 54.1629, 37.7551>, <-8.227, 52.8849, 38.3984>, <-7.7806, 53.06047, 38.722> }
					triangle { <-8.5272, 52.6637, 38.1624>, <-8.7359, 52.1465, 38.8632>, <-8.227, 52.8849, 38.3984> }
					triangle { <-8.7359, 52.1465, 38.8632>, <-7.9767, 50.8961, 39.8778>, <-8.3724, 52.4329, 39.205> }
					triangle { <-8.227, 52.8849, 38.3984>, <-8.7359, 52.1465, 38.8632>, <-8.3724, 52.4329, 39.205> }
					triangle { <-7.7806, 53.06047, 38.722>, <-8.227, 52.8849, 38.3984>, <-8.3724, 52.4329, 39.205> }
					triangle { <-7.7806, 53.06047, 38.722>, <-8.3724, 52.4329, 39.205>, <-7.8945, 52.6056, 39.4748> }
					triangle { <-8.3724, 52.4329, 39.205>, <-7.9767, 50.8961, 39.8778>, <-7.1879, 50.6823, 40.4939> }
					triangle { <-7.8945, 52.6056, 39.4748>, <-8.3724, 52.4329, 39.205>, <-7.1879, 50.6823, 40.4939> }
					triangle { <-7.6129, 54.2854, 36.9478>, <-7.4059, 54.6345, 37.05044>, <-7.2132, 54.4563, 36.01507> }
					triangle { <-7.6129, 54.2854, 36.9478>, <-7.4121, 54.5347, 37.6305>, <-7.4059, 54.6345, 37.05044> }
					triangle { <-7.9755, 54.1629, 37.7551>, <-7.8473, 54.4836, 37.8855>, <-7.6129, 54.2854, 36.9478> }
					triangle { <-7.9755, 54.1629, 37.7551>, <-7.4273, 53.3639, 38.9123>, <-7.8473, 54.4836, 37.8855> }
					triangle { <-7.8473, 54.4836, 37.8855>, <-7.4121, 54.5347, 37.6305>, <-7.6129, 54.2854, 36.9478> }
					triangle { <-7.8473, 54.4836, 37.8855>, <-6.9165, 53.7242, 39.04692>, <-7.4121, 54.5347, 37.6305> }
					triangle { <-7.4273, 53.3639, 38.9123>, <-6.9165, 53.7242, 39.04692>, <-7.8473, 54.4836, 37.8855> }
					triangle { <-7.7806, 53.06047, 38.722>, <-7.4273, 53.3639, 38.9123>, <-7.9755, 54.1629, 37.7551> }
					triangle { <-7.4273, 53.3639, 38.9123>, <-6.8528, 53.221, 39.8336>, <-6.9165, 53.7242, 39.04692> }
					triangle { <-7.3693, 52.8096, 39.7706>, <-6.7208, 51.4628, 40.6534>, <-6.8528, 53.221, 39.8336> }
					triangle { <-7.3693, 52.8096, 39.7706>, <-6.8528, 53.221, 39.8336>, <-7.4273, 53.3639, 38.9123> }
					triangle { <-7.3693, 52.8096, 39.7706>, <-7.4273, 53.3639, 38.9123>, <-7.7806, 53.06047, 38.722> }
					triangle { <-7.8945, 52.6056, 39.4748>, <-7.3693, 52.8096, 39.7706>, <-7.7806, 53.06047, 38.722> }
					triangle { <-7.1879, 50.6823, 40.4939>, <-6.7208, 51.4628, 40.6534>, <-7.3693, 52.8096, 39.7706> }
					triangle { <-7.1879, 50.6823, 40.4939>, <-7.3693, 52.8096, 39.7706>, <-7.8945, 52.6056, 39.4748> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		}
	union { // internode
		cylinder { <0.09328, 4.1816, 0.4656>, <0.09459, 4.3302, 0.4903>, 0.4 }
		cylinder { <0.09459, 4.3302, 0.4903>, <0.09013, 4.4793, 0.5104>, 0.4 }
		cylinder { <0.09013, 4.4793, 0.5104>, <0.07991, 4.6287, 0.5259>, 0.4 }
		cylinder { <0.07991, 4.6287, 0.5259>, <0.06394, 4.7781, 0.5367>, 0.4 }
		cylinder { <0.06394, 4.7781, 0.5367>, <0.04227, 4.9269, 0.5429>, 0.4 }
		cylinder { <0.04227, 4.9269, 0.5429>, <0.01496, 5.07504, 0.5444>, 0.4 }
		cylinder { <0.01496, 5.07504, 0.5444>, <-0.01793, 5.2219, 0.5412>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.01793, 5.2219, 0.5412>, <-0.1144, 14.3559, 1.9165>, 0.7265 }
			cylinder { <-0.1144, 14.3559, 1.9165>, <1.718, 22.9501, 4.7649>, 0.7265 }
			cylinder { <1.718, 22.9501, 4.7649>, <5.3466, 30.3818, 8.8799>, 0.7265 }
			cylinder { <5.3466, 30.3818, 8.8799>, <10.5086, 36.1127, 13.9634>, 0.7265 }
			cylinder { <10.5086, 36.1127, 13.9634>, <16.83, 39.7275, 19.6472>, 0.7265 }
			cylinder { <16.83, 39.7275, 19.6472>, <23.8527, 40.9643, 25.5194>, 0.7265 }
			cylinder { <23.8527, 40.9643, 25.5194>, <31.068, 39.7336, 31.1546>, 0.7265 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <31.068, 39.7336, 31.1546>, <29.7785, 42.457, 21.8942>, <38.05303, 46.824, 26.521> }
			triangle { <31.068, 39.7336, 31.1546>, <38.05303, 46.824, 26.521>, <43.03033, 45.5376, 32.2939> }
			triangle { <29.7785, 42.457, 21.8942>, <31.5345, 45.5168, 17.5525>, <38.05303, 46.824, 26.521> }
			triangle { <31.5345, 45.5168, 17.5525>, <37.3544, 46.8691, 18.6806>, <38.05303, 46.824, 26.521> }
			triangle { <37.3544, 46.8691, 18.6806>, <44.7996, 46.3064, 23.2927>, <38.05303, 46.824, 26.521> }
			triangle { <44.7996, 46.3064, 23.2927>, <51.8751, 44.9228, 29.1194>, <43.03033, 45.5376, 32.2939> }
			triangle { <38.05303, 46.824, 26.521>, <44.7996, 46.3064, 23.2927>, <43.03033, 45.5376, 32.2939> }
			triangle { <43.03033, 45.5376, 32.2939>, <50.1203, 43.3421, 36.08369>, <45.5506, 40.6784, 39.512> }
			triangle { <50.1203, 43.3421, 36.08369>, <56.1759, 40.3833, 37.8094>, <52.5718, 39.3786, 41.7445> }
			triangle { <50.1203, 43.3421, 36.08369>, <52.5718, 39.3786, 41.7445>, <45.5506, 40.6784, 39.512> }
			triangle { <45.5506, 40.6784, 39.512>, <52.5718, 39.3786, 41.7445>, <48.158, 36.1487, 43.929> }
			triangle { <56.1759, 40.3833, 37.8094>, <59.1346, 33.3092, 44.4428>, <52.5718, 39.3786, 41.7445> }
			triangle { <52.5718, 39.3786, 41.7445>, <59.1346, 33.3092, 44.4428>, <48.158, 36.1487, 43.929> }
			triangle { <31.068, 39.7336, 31.1546>, <43.03033, 45.5376, 32.2939>, <37.9502, 39.00639, 36.9118> }
			triangle { <37.9502, 39.00639, 36.9118>, <43.03033, 45.5376, 32.2939>, <45.5506, 40.6784, 39.512> }
			triangle { <37.9502, 39.00639, 36.9118>, <45.5506, 40.6784, 39.512>, <43.4329, 38.07122, 41.1939> }
			triangle { <45.5506, 40.6784, 39.512>, <48.158, 36.1487, 43.929>, <43.4329, 38.07122, 41.1939> }
			triangle { <51.8751, 44.9228, 29.1194>, <50.1203, 43.3421, 36.08369>, <43.03033, 45.5376, 32.2939> }
			triangle { <51.8751, 44.9228, 29.1194>, <56.1759, 40.3833, 37.8094>, <50.1203, 43.3421, 36.08369> }
			triangle { <25.7654, 35.4825, 39.777>, <22.3413, 35.5924, 29.9175>, <31.068, 39.7336, 31.1546> }
			triangle { <32.3595, 35.6884, 43.8057>, <25.7654, 35.4825, 39.777>, <31.068, 39.7336, 31.1546> }
			triangle { <25.7654, 35.4825, 39.777>, <17.9535, 32.9815, 32.2039>, <22.3413, 35.5924, 29.9175> }
			triangle { <25.7654, 35.4825, 39.777>, <19.8931, 30.7523, 37.5181>, <17.9535, 32.9815, 32.2039> }
			triangle { <25.7654, 35.4825, 39.777>, <26.04496, 28.9957, 43.5255>, <19.8931, 30.7523, 37.5181> }
			triangle { <32.3595, 35.6884, 43.8057>, <33.4437, 27.9105, 49.00339>, <26.04496, 28.9957, 43.5255> }
			triangle { <32.3595, 35.6884, 43.8057>, <26.04496, 28.9957, 43.5255>, <25.7654, 35.4825, 39.777> }
			triangle { <41.3469, 36.7984, 44.04697>, <38.3283, 34.54, 49.2598>, <32.3595, 35.6884, 43.8057> }
			triangle { <46.1725, 33.1745, 48.5832>, <43.8883, 29.04181, 51.06547>, <38.3283, 34.54, 49.2598> }
			triangle { <41.3469, 36.7984, 44.04697>, <46.1725, 33.1745, 48.5832>, <38.3283, 34.54, 49.2598> }
			triangle { <48.158, 36.1487, 43.929>, <46.1725, 33.1745, 48.5832>, <41.3469, 36.7984, 44.04697> }
			triangle { <46.1725, 33.1745, 48.5832>, <53.893, 28.7687, 50.1624>, <43.8883, 29.04181, 51.06547> }
			triangle { <48.158, 36.1487, 43.929>, <53.893, 28.7687, 50.1624>, <46.1725, 33.1745, 48.5832> }
			triangle { <37.9502, 39.00639, 36.9118>, <32.3595, 35.6884, 43.8057>, <31.068, 39.7336, 31.1546> }
			triangle { <41.3469, 36.7984, 44.04697>, <32.3595, 35.6884, 43.8057>, <37.9502, 39.00639, 36.9118> }
			triangle { <43.4329, 38.07122, 41.1939>, <41.3469, 36.7984, 44.04697>, <37.9502, 39.00639, 36.9118> }
			triangle { <43.4329, 38.07122, 41.1939>, <48.158, 36.1487, 43.929>, <41.3469, 36.7984, 44.04697> }
			triangle { <32.3595, 35.6884, 43.8057>, <38.3283, 34.54, 49.2598>, <33.4437, 27.9105, 49.00339> }
			triangle { <38.3283, 34.54, 49.2598>, <43.8883, 29.04181, 51.06547>, <33.4437, 27.9105, 49.00339> }
			triangle { <48.158, 36.1487, 43.929>, <59.1346, 33.3092, 44.4428>, <56.6992, 31.119, 47.5429> }
			triangle { <59.1346, 33.3092, 44.4428>, <61.2092, 26.3302, 47.6263>, <56.6992, 31.119, 47.5429> }
			triangle { <48.158, 36.1487, 43.929>, <56.6992, 31.119, 47.5429>, <53.893, 28.7687, 50.1624> }
			triangle { <56.6992, 31.119, 47.5429>, <61.2092, 26.3302, 47.6263>, <53.893, 28.7687, 50.1624> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <-0.01793, 5.2219, 0.5412>, <-0.3022, 6.4913, 0.5134>, 0.3888 }
			cylinder { <-0.3022, 6.4913, 0.5134>, <-0.5865, 7.7607, 0.4856>, 0.3888 }
			cylinder { <-0.5865, 7.7607, 0.4856>, <-0.8708, 9.03017, 0.4578>, 0.3888 }
			cylinder { <-0.8708, 9.03017, 0.4578>, <-1.1551, 10.2995, 0.43>, 0.3888 }
			cylinder { <-1.1551, 10.2995, 0.43>, <-1.4395, 11.5689, 0.4022>, 0.3888 }
			cylinder { <-1.4395, 11.5689, 0.4022>, <-1.7238, 12.8384, 0.3745>, 0.3888 }
			cylinder { <-1.7238, 12.8384, 0.3745>, <-2.008142, 14.1078, 0.3467>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.008142, 14.1078, 0.3467>, <-3.5302, 20.1792, -0.8656>, 0.3888 }
				cylinder { <-3.5302, 20.1792, -0.8656>, <-5.1364, 25.9233, -3.1184>, 0.3888 }
				cylinder { <-5.1364, 25.9233, -3.1184>, <-6.7794, 31.1707, -6.3454>, 0.3888 }
				cylinder { <-6.7794, 31.1707, -6.3454>, <-8.4109, 35.7672, -10.4516>, 0.3888 }
				cylinder { <-8.4109, 35.7672, -10.4516>, <-9.9828, 39.5772, -15.316>, 0.3888 }
				cylinder { <-9.9828, 39.5772, -15.316>, <-11.4488, 42.4886, -20.7953>, 0.3888 }
				cylinder { <-11.4488, 42.4886, -20.7953>, <-12.7658, 44.4157, -26.7284>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-12.7658, 44.4157, -26.7284>, <-13.2088, 44.3568, -27.669>, <-13.2427, 44.8052, -27.6616> }
					triangle { <-13.2088, 44.3568, -27.669>, <-13.5065, 44.3466, -28.4077>, <-13.2427, 44.8052, -27.6616> }
					triangle { <-13.2427, 44.8052, -27.6616>, <-13.749, 44.7617, -28.5832>, <-13.6284, 45.1383, -28.4877> }
					triangle { <-13.749, 44.7617, -28.5832>, <-15.1503, 45.07114, -28.9002>, <-13.6284, 45.1383, -28.4877> }
					triangle { <-13.2427, 44.8052, -27.6616>, <-13.5065, 44.3466, -28.4077>, <-13.749, 44.7617, -28.5832> }
					triangle { <-13.5065, 44.3466, -28.4077>, <-15.277, 44.6113, -28.9486>, <-13.749, 44.7617, -28.5832> }
					triangle { <-13.749, 44.7617, -28.5832>, <-15.277, 44.6113, -28.9486>, <-15.1503, 45.07114, -28.9002> }
					triangle { <-13.6284, 45.1383, -28.4877>, <-15.1503, 45.07114, -28.9002>, <-15.11, 45.6872, -28.7819> }
					triangle { <-15.277, 44.6113, -28.9486>, <-16.04018, 44.8499, -29.503>, <-15.1503, 45.07114, -28.9002> }
					triangle { <-16.04018, 44.8499, -29.503>, <-17.7244, 45.7858, -29.3351>, <-15.8873, 45.4557, -29.4859> }
					triangle { <-15.1503, 45.07114, -28.9002>, <-16.04018, 44.8499, -29.503>, <-15.8873, 45.4557, -29.4859> }
					triangle { <-15.11, 45.6872, -28.7819>, <-15.1503, 45.07114, -28.9002>, <-15.8873, 45.4557, -29.4859> }
					triangle { <-15.11, 45.6872, -28.7819>, <-15.8873, 45.4557, -29.4859>, <-15.8329, 46.05133, -29.3045> }
					triangle { <-15.8873, 45.4557, -29.4859>, <-17.7244, 45.7858, -29.3351>, <-18.2067, 46.7494, -29.06083> }
					triangle { <-15.8329, 46.05133, -29.3045>, <-15.8873, 45.4557, -29.4859>, <-18.2067, 46.7494, -29.06083> }
					triangle { <-13.2427, 44.8052, -27.6616>, <-12.9325, 45.1355, -27.6232>, <-12.7658, 44.4157, -26.7284> }
					triangle { <-13.2427, 44.8052, -27.6616>, <-13.2371, 45.5493, -28.00397>, <-12.9325, 45.1355, -27.6232> }
					triangle { <-13.6284, 45.1383, -28.4877>, <-13.3523, 45.4263, -28.5283>, <-13.2427, 44.8052, -27.6616> }
					triangle { <-13.6284, 45.1383, -28.4877>, <-14.886, 46.1739, -28.6735>, <-13.3523, 45.4263, -28.5283> }
					triangle { <-13.3523, 45.4263, -28.5283>, <-13.2371, 45.5493, -28.00397>, <-13.2427, 44.8052, -27.6616> }
					triangle { <-13.3523, 45.4263, -28.5283>, <-14.5939, 46.7451, -28.4071>, <-13.2371, 45.5493, -28.00397> }
					triangle { <-14.886, 46.1739, -28.6735>, <-14.5939, 46.7451, -28.4071>, <-13.3523, 45.4263, -28.5283> }
					triangle { <-15.11, 45.6872, -28.7819>, <-14.886, 46.1739, -28.6735>, <-13.6284, 45.1383, -28.4877> }
					triangle { <-14.886, 46.1739, -28.6735>, <-15.3891, 47.245, -28.7967>, <-14.5939, 46.7451, -28.4071> }
					triangle { <-15.7584, 46.7097, -29.1072>, <-17.489, 47.4369, -28.9239>, <-15.3891, 47.245, -28.7967> }
					triangle { <-15.7584, 46.7097, -29.1072>, <-15.3891, 47.245, -28.7967>, <-14.886, 46.1739, -28.6735> }
					triangle { <-15.7584, 46.7097, -29.1072>, <-14.886, 46.1739, -28.6735>, <-15.11, 45.6872, -28.7819> }
					triangle { <-15.8329, 46.05133, -29.3045>, <-15.7584, 46.7097, -29.1072>, <-15.11, 45.6872, -28.7819> }
					triangle { <-18.2067, 46.7494, -29.06083>, <-17.489, 47.4369, -28.9239>, <-15.7584, 46.7097, -29.1072> }
					triangle { <-18.2067, 46.7494, -29.06083>, <-15.7584, 46.7097, -29.1072>, <-15.8329, 46.05133, -29.3045> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-12.7658, 44.4157, -26.7284>, <-13.3613, 44.8011, -27.4909>, <-12.9929, 45.00129, -27.6534> }
					triangle { <-13.3613, 44.8011, -27.4909>, <-13.7814, 45.07072, -28.1114>, <-12.9929, 45.00129, -27.6534> }
					triangle { <-12.9929, 45.00129, -27.6534>, <-13.5891, 45.451, -28.3948>, <-13.1912, 45.4814, -28.4733> }
					triangle { <-13.5891, 45.451, -28.3948>, <-13.9424, 46.8648, -28.5857>, <-13.1912, 45.4814, -28.4733> }
					triangle { <-12.9929, 45.00129, -27.6534>, <-13.7814, 45.07072, -28.1114>, <-13.5891, 45.451, -28.3948> }
					triangle { <-13.7814, 45.07072, -28.1114>, <-14.3927, 46.8089, -28.431>, <-13.5891, 45.451, -28.3948> }
					triangle { <-13.5891, 45.451, -28.3948>, <-14.3927, 46.8089, -28.431>, <-13.9424, 46.8648, -28.5857> }
					triangle { <-13.1912, 45.4814, -28.4733>, <-13.9424, 46.8648, -28.5857>, <-13.361, 47.05972, -28.7243> }
					triangle { <-14.3927, 46.8089, -28.431>, <-14.6862, 47.604, -28.909>, <-13.9424, 46.8648, -28.5857> }
					triangle { <-14.6862, 47.604, -28.909>, <-14.4065, 49.5172, -28.8596>, <-14.1172, 47.6905, -29.1529> }
					triangle { <-13.9424, 46.8648, -28.5857>, <-14.6862, 47.604, -28.909>, <-14.1172, 47.6905, -29.1529> }
					triangle { <-13.361, 47.05972, -28.7243>, <-13.9424, 46.8648, -28.5857>, <-14.1172, 47.6905, -29.1529> }
					triangle { <-13.361, 47.05972, -28.7243>, <-14.1172, 47.6905, -29.1529>, <-13.5218, 47.8649, -29.2284> }
					triangle { <-14.1172, 47.6905, -29.1529>, <-14.4065, 49.5172, -28.8596>, <-13.6469, 50.3275, -28.9107> }
					triangle { <-13.5218, 47.8649, -29.2284>, <-14.1172, 47.6905, -29.1529>, <-13.6469, 50.3275, -28.9107> }
					triangle { <-12.9929, 45.00129, -27.6534>, <-12.5927, 44.8383, -27.7951>, <-12.7658, 44.4157, -26.7284> }
					triangle { <-12.9929, 45.00129, -27.6534>, <-12.5087, 45.2751, -28.2547>, <-12.5927, 44.8383, -27.7951> }
					triangle { <-13.1912, 45.4814, -28.4733>, <-12.8713, 45.3339, -28.6651>, <-12.9929, 45.00129, -27.6534> }
					triangle { <-13.1912, 45.4814, -28.4733>, <-12.8296, 47.03574, -28.8501>, <-12.8713, 45.3339, -28.6651> }
					triangle { <-12.8713, 45.3339, -28.6651>, <-12.5087, 45.2751, -28.2547>, <-12.9929, 45.00129, -27.6534> }
					triangle { <-12.8713, 45.3339, -28.6651>, <-12.1376, 46.9809, -28.8758>, <-12.5087, 45.2751, -28.2547> }
					triangle { <-12.8296, 47.03574, -28.8501>, <-12.1376, 46.9809, -28.8758>, <-12.8713, 45.3339, -28.6651> }
					triangle { <-13.361, 47.05972, -28.7243>, <-12.8296, 47.03574, -28.8501>, <-13.1912, 45.4814, -28.4733> }
					triangle { <-12.8296, 47.03574, -28.8501>, <-12.1533, 47.9045, -29.3008>, <-12.1376, 46.9809, -28.8758> }
					triangle { <-12.86, 48.04433, -29.3171>, <-12.7654, 49.9218, -29.1653>, <-12.1533, 47.9045, -29.3008> }
					triangle { <-12.86, 48.04433, -29.3171>, <-12.1533, 47.9045, -29.3008>, <-12.8296, 47.03574, -28.8501> }
					triangle { <-12.86, 48.04433, -29.3171>, <-12.8296, 47.03574, -28.8501>, <-13.361, 47.05972, -28.7243> }
					triangle { <-13.5218, 47.8649, -29.2284>, <-12.86, 48.04433, -29.3171>, <-13.361, 47.05972, -28.7243> }
					triangle { <-13.6469, 50.3275, -28.9107>, <-12.7654, 49.9218, -29.1653>, <-12.86, 48.04433, -29.3171> }
					triangle { <-13.6469, 50.3275, -28.9107>, <-12.86, 48.04433, -29.3171>, <-13.5218, 47.8649, -29.2284> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-12.7658, 44.4157, -26.7284>, <-12.9655, 45.1101, -27.4784>, <-12.7389, 44.8436, -27.761> }
					triangle { <-12.9655, 45.1101, -27.4784>, <-13.1429, 45.5988, -28.08167>, <-12.7389, 44.8436, -27.761> }
					triangle { <-12.7389, 44.8436, -27.761>, <-12.8758, 45.563, -28.5168>, <-12.7467, 45.2055, -28.6616> }
					triangle { <-12.8758, 45.563, -28.5168>, <-11.8883, 46.4218, -29.1855>, <-12.7467, 45.2055, -28.6616> }
					triangle { <-12.7389, 44.8436, -27.761>, <-13.1429, 45.5988, -28.08167>, <-12.8758, 45.563, -28.5168> }
					triangle { <-13.1429, 45.5988, -28.08167>, <-12.02499, 46.8185, -28.9535>, <-12.8758, 45.563, -28.5168> }
					triangle { <-12.8758, 45.563, -28.5168>, <-12.02499, 46.8185, -28.9535>, <-11.8883, 46.4218, -29.1855> }
					triangle { <-12.7467, 45.2055, -28.6616>, <-11.8883, 46.4218, -29.1855>, <-11.5832, 45.9561, -29.4774> }
					triangle { <-12.02499, 46.8185, -28.9535>, <-11.6573, 47.3881, -29.6515>, <-11.8883, 46.4218, -29.1855> }
					triangle { <-11.6573, 47.3881, -29.6515>, <-9.9322, 47.8493, -30.3945>, <-11.4917, 46.8928, -29.9948> }
					triangle { <-11.8883, 46.4218, -29.1855>, <-11.6573, 47.3881, -29.6515>, <-11.4917, 46.8928, -29.9948> }
					triangle { <-11.5832, 45.9561, -29.4774>, <-11.8883, 46.4218, -29.1855>, <-11.4917, 46.8928, -29.9948> }
					triangle { <-11.5832, 45.9561, -29.4774>, <-11.4917, 46.8928, -29.9948>, <-11.1725, 46.4066, -30.2236> }
					triangle { <-11.4917, 46.8928, -29.9948>, <-9.9322, 47.8493, -30.3945>, <-9.01185, 47.4503, -30.8741> }
					triangle { <-11.1725, 46.4066, -30.2236>, <-11.4917, 46.8928, -29.9948>, <-9.01185, 47.4503, -30.8741> }
					triangle { <-12.7389, 44.8436, -27.761>, <-12.798, 44.411, -27.8883>, <-12.7658, 44.4157, -26.7284> }
					triangle { <-12.7389, 44.8436, -27.761>, <-12.5945, 44.4962, -28.4886>, <-12.798, 44.411, -27.8883> }
					triangle { <-12.7467, 45.2055, -28.6616>, <-12.8414, 44.853, -28.8279>, <-12.7389, 44.8436, -27.761> }
					triangle { <-12.7467, 45.2055, -28.6616>, <-11.4738, 45.4544, -29.6646>, <-12.8414, 44.853, -28.8279> }
					triangle { <-12.8414, 44.853, -28.8279>, <-12.5945, 44.4962, -28.4886>, <-12.7389, 44.8436, -27.761> }
					triangle { <-12.8414, 44.853, -28.8279>, <-11.2933, 44.7925, -29.774>, <-12.5945, 44.4962, -28.4886> }
					triangle { <-11.4738, 45.4544, -29.6646>, <-11.2933, 44.7925, -29.774>, <-12.8414, 44.853, -28.8279> }
					triangle { <-11.5832, 45.9561, -29.4774>, <-11.4738, 45.4544, -29.6646>, <-12.7467, 45.2055, -28.6616> }
					triangle { <-11.4738, 45.4544, -29.6646>, <-10.7001, 45.1534, -30.5169>, <-11.2933, 44.7925, -29.774> }
					triangle { <-10.8318, 45.8607, -30.4765>, <-9.1573, 46.4802, -31.08416>, <-10.7001, 45.1534, -30.5169> }
					triangle { <-10.8318, 45.8607, -30.4765>, <-10.7001, 45.1534, -30.5169>, <-11.4738, 45.4544, -29.6646> }
					triangle { <-10.8318, 45.8607, -30.4765>, <-11.4738, 45.4544, -29.6646>, <-11.5832, 45.9561, -29.4774> }
					triangle { <-11.1725, 46.4066, -30.2236>, <-10.8318, 45.8607, -30.4765>, <-11.5832, 45.9561, -29.4774> }
					triangle { <-9.01185, 47.4503, -30.8741>, <-9.1573, 46.4802, -31.08416>, <-10.8318, 45.8607, -30.4765> }
					triangle { <-9.01185, 47.4503, -30.8741>, <-10.8318, 45.8607, -30.4765>, <-11.1725, 46.4066, -30.2236> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-12.7658, 44.4157, -26.7284>, <-12.5647, 44.8597, -27.6487>, <-12.8294, 44.5486, -27.8367> }
					triangle { <-12.5647, 44.8597, -27.6487>, <-12.4673, 45.2061, -28.3591>, <-12.8294, 44.5486, -27.8367> }
					triangle { <-12.8294, 44.5486, -27.8367>, <-12.5882, 44.9439, -28.7817>, <-12.9051, 44.6893, -28.7941> }
					triangle { <-12.5882, 44.9439, -28.7817>, <-11.8076, 44.3502, -29.8763>, <-12.9051, 44.6893, -28.7941> }
					triangle { <-12.8294, 44.5486, -27.8367>, <-12.4673, 45.2061, -28.3591>, <-12.5882, 44.9439, -28.7817> }
					triangle { <-12.4673, 45.2061, -28.3591>, <-11.4238, 44.6268, -29.7989>, <-12.5882, 44.9439, -28.7817> }
					triangle { <-12.5882, 44.9439, -28.7817>, <-11.4238, 44.6268, -29.7989>, <-11.8076, 44.3502, -29.8763> }
					triangle { <-12.9051, 44.6893, -28.7941>, <-11.8076, 44.3502, -29.8763>, <-12.2168, 43.8913, -30.00747> }
					triangle { <-11.4238, 44.6268, -29.7989>, <-11.1111, 44.4985, -30.7113>, <-11.8076, 44.3502, -29.8763> }
					triangle { <-11.1111, 44.4985, -30.7113>, <-10.443, 43.07151, -31.833>, <-11.6146, 44.1575, -30.856> }
					triangle { <-11.8076, 44.3502, -29.8763>, <-11.1111, 44.4985, -30.7113>, <-11.6146, 44.1575, -30.856> }
					triangle { <-12.2168, 43.8913, -30.00747>, <-11.8076, 44.3502, -29.8763>, <-11.6146, 44.1575, -30.856> }
					triangle { <-12.2168, 43.8913, -30.00747>, <-11.6146, 44.1575, -30.856>, <-12.00983, 43.6781, -30.924> }
					triangle { <-11.6146, 44.1575, -30.856>, <-10.443, 43.07151, -31.833>, <-10.6637, 42.06717, -32.256> }
					triangle { <-12.00983, 43.6781, -30.924>, <-11.6146, 44.1575, -30.856>, <-10.6637, 42.06717, -32.256> }
					triangle { <-12.8294, 44.5486, -27.8367>, <-13.2667, 44.4402, -27.7748>, <-12.7658, 44.4157, -26.7284> }
					triangle { <-12.8294, 44.5486, -27.8367>, <-13.3768, 44.2819, -28.3846>, <-13.2667, 44.4402, -27.7748> }
					triangle { <-12.9051, 44.6893, -28.7941>, <-13.3036, 44.6438, -28.7933>, <-12.8294, 44.5486, -27.8367> }
					triangle { <-12.9051, 44.6893, -28.7941>, <-12.6795, 43.6005, -29.9992>, <-13.3036, 44.6438, -28.7933> }
					triangle { <-13.3036, 44.6438, -28.7933>, <-13.3768, 44.2819, -28.3846>, <-12.8294, 44.5486, -27.8367> }
					triangle { <-13.3036, 44.6438, -28.7933>, <-13.2199, 43.1839, -29.8688>, <-13.3768, 44.2819, -28.3846> }
					triangle { <-12.6795, 43.6005, -29.9992>, <-13.2199, 43.1839, -29.8688>, <-13.3036, 44.6438, -28.7933> }
					triangle { <-12.2168, 43.8913, -30.00747>, <-12.6795, 43.6005, -29.9992>, <-12.9051, 44.6893, -28.7941> }
					triangle { <-12.6795, 43.6005, -29.9992>, <-13.02433, 42.7678, -30.7759>, <-13.2199, 43.1839, -29.8688> }
					triangle { <-12.4578, 43.1562, -30.994>, <-11.6172, 41.8361, -32.04655>, <-13.02433, 42.7678, -30.7759> }
					triangle { <-12.4578, 43.1562, -30.994>, <-13.02433, 42.7678, -30.7759>, <-12.6795, 43.6005, -29.9992> }
					triangle { <-12.4578, 43.1562, -30.994>, <-12.6795, 43.6005, -29.9992>, <-12.2168, 43.8913, -30.00747> }
					triangle { <-12.00983, 43.6781, -30.924>, <-12.4578, 43.1562, -30.994>, <-12.2168, 43.8913, -30.00747> }
					triangle { <-10.6637, 42.06717, -32.256>, <-11.6172, 41.8361, -32.04655>, <-12.4578, 43.1562, -30.994> }
					triangle { <-10.6637, 42.06717, -32.256>, <-12.4578, 43.1562, -30.994>, <-12.00983, 43.6781, -30.924> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-12.7658, 44.4157, -26.7284>, <-12.7174, 44.3872, -27.7683>, <-13.1455, 44.5245, -27.7743> }
					triangle { <-12.7174, 44.3872, -27.7683>, <-12.6954, 44.4205, -28.5637>, <-13.1455, 44.5245, -27.7743> }
					triangle { <-13.1455, 44.5245, -27.7743>, <-13.1359, 44.4412, -28.8234>, <-13.4583, 44.6471, -28.685> }
					triangle { <-13.1359, 44.4412, -28.8234>, <-13.854, 43.5028, -29.6973>, <-13.4583, 44.6471, -28.685> }
					triangle { <-13.1455, 44.5245, -27.7743>, <-12.6954, 44.4205, -28.5637>, <-13.1359, 44.4412, -28.8234> }
					triangle { <-12.6954, 44.4205, -28.5637>, <-13.464, 43.2421, -29.7957>, <-13.1359, 44.4412, -28.8234> }
					triangle { <-13.1359, 44.4412, -28.8234>, <-13.464, 43.2421, -29.7957>, <-13.854, 43.5028, -29.6973> }
					triangle { <-13.4583, 44.6471, -28.685>, <-13.854, 43.5028, -29.6973>, <-14.4293, 43.7226, -29.5711> }
					triangle { <-13.464, 43.2421, -29.7957>, <-13.8607, 42.906, -30.6182>, <-13.854, 43.5028, -29.6973> }
					triangle { <-13.8607, 42.906, -30.6182>, <-15.3316, 41.7769, -31.1684>, <-14.3722, 43.2559, -30.5367> }
					triangle { <-13.854, 43.5028, -29.6973>, <-13.8607, 42.906, -30.6182>, <-14.3722, 43.2559, -30.5367> }
					triangle { <-14.4293, 43.7226, -29.5711>, <-13.854, 43.5028, -29.6973>, <-14.3722, 43.2559, -30.5367> }
					triangle { <-14.4293, 43.7226, -29.5711>, <-14.3722, 43.2559, -30.5367>, <-14.9335, 43.4552, -30.3474> }
					triangle { <-14.3722, 43.2559, -30.5367>, <-15.3316, 41.7769, -31.1684>, <-16.4322, 41.6274, -31.1183> }
					triangle { <-14.9335, 43.4552, -30.3474>, <-14.3722, 43.2559, -30.5367>, <-16.4322, 41.6274, -31.1183> }
					triangle { <-13.1455, 44.5245, -27.7743>, <-13.3511, 44.8947, -27.6085>, <-12.7658, 44.4157, -26.7284> }
					triangle { <-13.1455, 44.5245, -27.7743>, <-13.7799, 44.9425, -28.08059>, <-13.3511, 44.8947, -27.6085> }
					triangle { <-13.4583, 44.6471, -28.685>, <-13.6242, 45.0035, -28.6053>, <-13.1455, 44.5245, -27.7743> }
					triangle { <-13.4583, 44.6471, -28.685>, <-14.8202, 44.05194, -29.3774>, <-13.6242, 45.0035, -28.6053> }
					triangle { <-13.6242, 45.0035, -28.6053>, <-13.7799, 44.9425, -28.08059>, <-13.1455, 44.5245, -27.7743> }
					triangle { <-13.6242, 45.0035, -28.6053>, <-15.2905, 44.4088, -29.01137>, <-13.7799, 44.9425, -28.08059> }
					triangle { <-14.8202, 44.05194, -29.3774>, <-15.2905, 44.4088, -29.01137>, <-13.6242, 45.0035, -28.6053> }
					triangle { <-14.4293, 43.7226, -29.5711>, <-14.8202, 44.05194, -29.3774>, <-13.4583, 44.6471, -28.685> }
					triangle { <-14.8202, 44.05194, -29.3774>, <-15.966, 44.08009, -29.6967>, <-15.2905, 44.4088, -29.01137> }
					triangle { <-15.5486, 43.6888, -30.135>, <-16.8442, 42.4363, -30.6913>, <-15.966, 44.08009, -29.6967> }
					triangle { <-15.5486, 43.6888, -30.135>, <-15.966, 44.08009, -29.6967>, <-14.8202, 44.05194, -29.3774> }
					triangle { <-15.5486, 43.6888, -30.135>, <-14.8202, 44.05194, -29.3774>, <-14.4293, 43.7226, -29.5711> }
					triangle { <-14.9335, 43.4552, -30.3474>, <-15.5486, 43.6888, -30.135>, <-14.4293, 43.7226, -29.5711> }
					triangle { <-16.4322, 41.6274, -31.1183>, <-16.8442, 42.4363, -30.6913>, <-15.5486, 43.6888, -30.135> }
					triangle { <-16.4322, 41.6274, -31.1183>, <-15.5486, 43.6888, -30.135>, <-14.9335, 43.4552, -30.3474> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		union { // inflor. internode
			cylinder { <-2.008142, 14.1078, 0.3467>, <-2.2924, 15.3772, 0.3189>, 0.3888 }
			cylinder { <-2.2924, 15.3772, 0.3189>, <-2.5767, 16.6466, 0.2911>, 0.3888 }
			cylinder { <-2.5767, 16.6466, 0.2911>, <-2.861, 17.916, 0.2633>, 0.3888 }
			cylinder { <-2.861, 17.916, 0.2633>, <-3.1454, 19.1854, 0.2355>, 0.3888 }
			cylinder { <-3.1454, 19.1854, 0.2355>, <-3.4297, 20.4548, 0.2077>, 0.3888 }
			cylinder { <-3.4297, 20.4548, 0.2077>, <-3.714, 21.7242, 0.1799>, 0.3888 }
			cylinder { <-3.714, 21.7242, 0.1799>, <-3.9983, 22.9936, 0.1521>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.9983, 22.9936, 0.1521>, <-5.9674, 29.00844, 0.9232>, 0.3888 }
				cylinder { <-5.9674, 29.00844, 0.9232>, <-8.4545, 34.6407, 2.5787>, 0.3888 }
				cylinder { <-8.4545, 34.6407, 2.5787>, <-11.3864, 39.7247, 5.06994>, 0.3888 }
				cylinder { <-11.3864, 39.7247, 5.06994>, <-14.6767, 44.1107, 8.3235>, 0.3888 }
				cylinder { <-14.6767, 44.1107, 8.3235>, <-18.2286, 47.6695, 12.2437>, 0.3888 }
				cylinder { <-18.2286, 47.6695, 12.2437>, <-21.9374, 50.2965, 16.7151>, 0.3888 }
				cylinder { <-21.9374, 50.2965, 16.7151>, <-25.694, 51.9141, 21.6059>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-25.694, 51.9141, 21.6059>, <-25.9808, 51.926, 22.5206>, <-26.1029, 52.3169, 22.4601> }
					triangle { <-25.9808, 51.926, 22.5206>, <-26.2481, 51.9479, 23.2027>, <-26.1029, 52.3169, 22.4601> }
					triangle { <-26.1029, 52.3169, 22.4601>, <-26.3448, 52.3661, 23.3969>, <-26.4831, 52.6506, 23.1965> }
					triangle { <-26.3448, 52.3661, 23.3969>, <-25.7914, 53.09204, 24.3953>, <-26.4831, 52.6506, 23.1965> }
					triangle { <-26.1029, 52.3169, 22.4601>, <-26.2481, 51.9479, 23.2027>, <-26.3448, 52.3661, 23.3969> }
					triangle { <-26.2481, 51.9479, 23.2027>, <-25.5933, 52.7443, 24.5811>, <-26.3448, 52.3661, 23.3969> }
					triangle { <-26.3448, 52.3661, 23.3969>, <-25.5933, 52.7443, 24.5811>, <-25.7914, 53.09204, 24.3953> }
					triangle { <-26.4831, 52.6506, 23.1965>, <-25.7914, 53.09204, 24.3953>, <-25.946, 53.6092, 24.1869> }
					triangle { <-25.5933, 52.7443, 24.5811>, <-25.548, 53.1599, 25.3732>, <-25.7914, 53.09204, 24.3953> }
					triangle { <-25.548, 53.1599, 25.3732>, <-24.7331, 54.5638, 26.1043>, <-25.829, 53.6182, 25.1685> }
					triangle { <-25.7914, 53.09204, 24.3953>, <-25.548, 53.1599, 25.3732>, <-25.829, 53.6182, 25.1685> }
					triangle { <-25.946, 53.6092, 24.1869>, <-25.7914, 53.09204, 24.3953>, <-25.829, 53.6182, 25.1685> }
					triangle { <-25.946, 53.6092, 24.1869>, <-25.829, 53.6182, 25.1685>, <-25.9468, 54.1196, 24.9122> }
					triangle { <-25.829, 53.6182, 25.1685>, <-24.7331, 54.5638, 26.1043>, <-24.59, 55.5752, 26.04232> }
					triangle { <-25.9468, 54.1196, 24.9122>, <-25.829, 53.6182, 25.1685>, <-24.59, 55.5752, 26.04232> }
					triangle { <-26.1029, 52.3169, 22.4601>, <-26.3758, 52.4892, 22.1936>, <-25.694, 51.9141, 21.6059> }
					triangle { <-26.1029, 52.3169, 22.4601>, <-26.5597, 52.9076, 22.5647>, <-26.3758, 52.4892, 22.1936> }
					triangle { <-26.4831, 52.6506, 23.1965>, <-26.7697, 52.7914, 23.01126>, <-26.1029, 52.3169, 22.4601> }
					triangle { <-26.4831, 52.6506, 23.1965>, <-26.1752, 53.9511, 23.8977>, <-26.7697, 52.7914, 23.01126> }
					triangle { <-26.7697, 52.7914, 23.01126>, <-26.5597, 52.9076, 22.5647>, <-26.1029, 52.3169, 22.4601> }
					triangle { <-26.7697, 52.7914, 23.01126>, <-26.3771, 54.3562, 23.446>, <-26.5597, 52.9076, 22.5647> }
					triangle { <-26.1752, 53.9511, 23.8977>, <-26.3771, 54.3562, 23.446>, <-26.7697, 52.7914, 23.01126> }
					triangle { <-25.946, 53.6092, 24.1869>, <-26.1752, 53.9511, 23.8977>, <-26.4831, 52.6506, 23.1965> }
					triangle { <-26.1752, 53.9511, 23.8977>, <-26.2976, 55.02031, 24.1008>, <-26.3771, 54.3562, 23.446> }
					triangle { <-26.08775, 54.6684, 24.6225>, <-25.1668, 55.9142, 25.4058>, <-26.2976, 55.02031, 24.1008> }
					triangle { <-26.08775, 54.6684, 24.6225>, <-26.2976, 55.02031, 24.1008>, <-26.1752, 53.9511, 23.8977> }
					triangle { <-26.08775, 54.6684, 24.6225>, <-26.1752, 53.9511, 23.8977>, <-25.946, 53.6092, 24.1869> }
					triangle { <-25.9468, 54.1196, 24.9122>, <-26.08775, 54.6684, 24.6225>, <-25.946, 53.6092, 24.1869> }
					triangle { <-24.59, 55.5752, 26.04232>, <-25.1668, 55.9142, 25.4058>, <-26.08775, 54.6684, 24.6225> }
					triangle { <-24.59, 55.5752, 26.04232>, <-26.08775, 54.6684, 24.6225>, <-25.9468, 54.1196, 24.9122> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-25.694, 51.9141, 21.6059>, <-25.9256, 52.3728, 22.4152>, <-26.3136, 52.3944, 22.2727> }
					triangle { <-25.9256, 52.3728, 22.4152>, <-26.1386, 52.6861, 23.04276>, <-26.3136, 52.3944, 22.2727> }
					triangle { <-26.3136, 52.3944, 22.2727>, <-26.5529, 52.9098, 23.05723>, <-26.8518, 52.7862, 22.8685> }
					triangle { <-26.5529, 52.9098, 23.05723>, <-26.9199, 54.2079, 23.1595>, <-26.8518, 52.7862, 22.8685> }
					triangle { <-26.3136, 52.3944, 22.2727>, <-26.1386, 52.6861, 23.04276>, <-26.5529, 52.9098, 23.05723> }
					triangle { <-26.1386, 52.6861, 23.04276>, <-26.5344, 54.3363, 23.3317>, <-26.5529, 52.9098, 23.05723> }
					triangle { <-26.5529, 52.9098, 23.05723>, <-26.5344, 54.3363, 23.3317>, <-26.9199, 54.2079, 23.1595> }
					triangle { <-26.8518, 52.7862, 22.8685>, <-26.9199, 54.2079, 23.1595>, <-27.4205, 54.1518, 22.8748> }
					triangle { <-26.5344, 54.3363, 23.3317>, <-26.9097, 55.06226, 23.6982>, <-26.9199, 54.2079, 23.1595> }
					triangle { <-26.9097, 55.06226, 23.6982>, <-27.6772, 56.5813, 23.1757>, <-27.4315, 54.9085, 23.5109> }
					triangle { <-26.9199, 54.2079, 23.1595>, <-26.9097, 55.06226, 23.6982>, <-27.4315, 54.9085, 23.5109> }
					triangle { <-27.4205, 54.1518, 22.8748>, <-26.9199, 54.2079, 23.1595>, <-27.4315, 54.9085, 23.5109> }
					triangle { <-27.4205, 54.1518, 22.8748>, <-27.4315, 54.9085, 23.5109>, <-27.8954, 54.8365, 23.1784> }
					triangle { <-27.4315, 54.9085, 23.5109>, <-27.6772, 56.5813, 23.1757>, <-28.4344, 56.9898, 22.6216> }
					triangle { <-27.8954, 54.8365, 23.1784>, <-27.4315, 54.9085, 23.5109>, <-28.4344, 56.9898, 22.6216> }
					triangle { <-26.3136, 52.3944, 22.2727>, <-26.589, 52.1006, 22.1584>, <-25.694, 51.9141, 21.6059> }
					triangle { <-26.3136, 52.3944, 22.2727>, <-27.06385, 52.3924, 22.3479>, <-26.589, 52.1006, 22.1584> }
					triangle { <-26.8518, 52.7862, 22.8685>, <-27.1141, 52.5289, 22.8335>, <-26.3136, 52.3944, 22.2727> }
					triangle { <-26.8518, 52.7862, 22.8685>, <-27.8112, 53.9303, 22.648>, <-27.1141, 52.5289, 22.8335> }
					triangle { <-27.1141, 52.5289, 22.8335>, <-27.06385, 52.3924, 22.3479>, <-26.3136, 52.3944, 22.2727> }
					triangle { <-27.1141, 52.5289, 22.8335>, <-28.2279, 53.6359, 22.2626>, <-27.06385, 52.3924, 22.3479> }
					triangle { <-27.8112, 53.9303, 22.648>, <-28.2279, 53.6359, 22.2626>, <-27.1141, 52.5289, 22.8335> }
					triangle { <-27.4205, 54.1518, 22.8748>, <-27.8112, 53.9303, 22.648>, <-26.8518, 52.7862, 22.8685> }
					triangle { <-27.8112, 53.9303, 22.648>, <-28.7812, 54.3771, 22.4059>, <-28.2279, 53.6359, 22.2626> }
					triangle { <-28.4091, 54.744, 22.8144>, <-28.9904, 56.309, 22.3384>, <-28.7812, 54.3771, 22.4059> }
					triangle { <-28.4091, 54.744, 22.8144>, <-28.7812, 54.3771, 22.4059>, <-27.8112, 53.9303, 22.648> }
					triangle { <-28.4091, 54.744, 22.8144>, <-27.8112, 53.9303, 22.648>, <-27.4205, 54.1518, 22.8748> }
					triangle { <-27.8954, 54.8365, 23.1784>, <-28.4091, 54.744, 22.8144>, <-27.4205, 54.1518, 22.8748> }
					triangle { <-28.4344, 56.9898, 22.6216>, <-28.9904, 56.309, 22.3384>, <-28.4091, 54.744, 22.8144> }
					triangle { <-28.4344, 56.9898, 22.6216>, <-28.4091, 54.744, 22.8144>, <-27.8954, 54.8365, 23.1784> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-25.694, 51.9141, 21.6059>, <-26.2591, 52.4942, 22.1188>, <-26.4813, 52.1604, 22.2213> }
					triangle { <-26.2591, 52.4942, 22.1188>, <-26.6805, 52.908, 22.5531>, <-26.4813, 52.1604, 22.2213> }
					triangle { <-26.4813, 52.1604, 22.2213>, <-27.09613, 52.7387, 22.6966>, <-27.1453, 52.3767, 22.7786> }
					triangle { <-27.09613, 52.7387, 22.6966>, <-28.3844, 53.04458, 22.4194>, <-27.1453, 52.3767, 22.7786> }
					triangle { <-26.4813, 52.1604, 22.2213>, <-26.6805, 52.908, 22.5531>, <-27.09613, 52.7387, 22.6966> }
					triangle { <-26.6805, 52.908, 22.5531>, <-28.2903, 53.451, 22.2759>, <-27.09613, 52.7387, 22.6966> }
					triangle { <-27.09613, 52.7387, 22.6966>, <-28.2903, 53.451, 22.2759>, <-28.3844, 53.04458, 22.4194> }
					triangle { <-27.1453, 52.3767, 22.7786>, <-28.3844, 53.04458, 22.4194>, <-28.5944, 52.5139, 22.5149> }
					triangle { <-28.2903, 53.451, 22.2759>, <-29.126, 53.73, 22.4364>, <-28.3844, 53.04458, 22.4194> }
					triangle { <-29.126, 53.73, 22.4364>, <-30.7757, 53.4312, 21.8376>, <-29.2733, 53.2186, 22.6551> }
					triangle { <-28.3844, 53.04458, 22.4194>, <-29.126, 53.73, 22.4364>, <-29.2733, 53.2186, 22.6551> }
					triangle { <-28.5944, 52.5139, 22.5149>, <-28.3844, 53.04458, 22.4194>, <-29.2733, 53.2186, 22.6551> }
					triangle { <-28.5944, 52.5139, 22.5149>, <-29.2733, 53.2186, 22.6551>, <-29.4465, 52.6721, 22.7028> }
					triangle { <-29.2733, 53.2186, 22.6551>, <-30.7757, 53.4312, 21.8376>, <-31.4948, 52.7195, 21.6833> }
					triangle { <-29.4465, 52.6721, 22.7028>, <-29.2733, 53.2186, 22.6551>, <-31.4948, 52.7195, 21.6833> }
					triangle { <-26.4813, 52.1604, 22.2213>, <-26.3812, 51.8037, 22.4161>, <-25.694, 51.9141, 21.6059> }
					triangle { <-26.4813, 52.1604, 22.2213>, <-26.8989, 51.7423, 22.6896>, <-26.3812, 51.8037, 22.4161> }
					triangle { <-27.1453, 52.3767, 22.7786>, <-27.07379, 52.09624, 23.00766>, <-26.4813, 52.1604, 22.2213> }
					triangle { <-27.1453, 52.3767, 22.7786>, <-28.6102, 52.033, 22.6618>, <-27.07379, 52.09624, 23.00766> }
					triangle { <-27.07379, 52.09624, 23.00766>, <-26.8989, 51.7423, 22.6896>, <-26.4813, 52.1604, 22.2213> }
					triangle { <-27.07379, 52.09624, 23.00766>, <-28.5688, 51.3997, 22.7404>, <-26.8989, 51.7423, 22.6896> }
					triangle { <-28.6102, 52.033, 22.6618>, <-28.5688, 51.3997, 22.7404>, <-27.07379, 52.09624, 23.00766> }
					triangle { <-28.5944, 52.5139, 22.5149>, <-28.6102, 52.033, 22.6618>, <-27.1453, 52.3767, 22.7786> }
					triangle { <-28.6102, 52.033, 22.6618>, <-29.5001, 51.418, 22.8325>, <-28.5688, 51.3997, 22.7404> }
					triangle { <-29.628, 52.06533, 22.7642>, <-31.2163, 51.9317, 22.07649>, <-29.5001, 51.418, 22.8325> }
					triangle { <-29.628, 52.06533, 22.7642>, <-29.5001, 51.418, 22.8325>, <-28.6102, 52.033, 22.6618> }
					triangle { <-29.628, 52.06533, 22.7642>, <-28.6102, 52.033, 22.6618>, <-28.5944, 52.5139, 22.5149> }
					triangle { <-29.4465, 52.6721, 22.7028>, <-29.628, 52.06533, 22.7642>, <-28.5944, 52.5139, 22.5149> }
					triangle { <-31.4948, 52.7195, 21.6833>, <-31.2163, 51.9317, 22.07649>, <-29.628, 52.06533, 22.7642> }
					triangle { <-31.4948, 52.7195, 21.6833>, <-29.628, 52.06533, 22.7642>, <-29.4465, 52.6721, 22.7028> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-25.694, 51.9141, 21.6059>, <-26.5235, 52.1236, 22.03837>, <-26.3758, 51.9361, 22.3765> }
					triangle { <-26.5235, 52.1236, 22.03837>, <-27.13, 52.3089, 22.406>, <-26.3758, 51.9361, 22.3765> }
					triangle { <-26.3758, 51.9361, 22.3765>, <-27.2287, 52.08775, 22.81>, <-26.9607, 51.9842, 23.05017> }
					triangle { <-27.2287, 52.08775, 22.81>, <-28.1747, 51.1988, 23.1909>, <-26.9607, 51.9842, 23.05017> }
					triangle { <-26.3758, 51.9361, 22.3765>, <-27.13, 52.3089, 22.406>, <-27.2287, 52.08775, 22.81> }
					triangle { <-27.13, 52.3089, 22.406>, <-28.4506, 51.3037, 22.8629>, <-27.2287, 52.08775, 22.81> }
					triangle { <-27.2287, 52.08775, 22.81>, <-28.4506, 51.3037, 22.8629>, <-28.1747, 51.1988, 23.1909> }
					triangle { <-26.9607, 51.9842, 23.05017>, <-28.1747, 51.1988, 23.1909>, <-27.8562, 50.9437, 23.6012> }
					triangle { <-28.4506, 51.3037, 22.8629>, <-29.1548, 50.9918, 23.32>, <-28.1747, 51.1988, 23.1909> }
					triangle { <-29.1548, 50.9918, 23.32>, <-29.7756, 49.4374, 23.9267>, <-28.8264, 50.8682, 23.7758> }
					triangle { <-28.1747, 51.1988, 23.1909>, <-29.1548, 50.9918, 23.32>, <-28.8264, 50.8682, 23.7758> }
					triangle { <-27.8562, 50.9437, 23.6012>, <-28.1747, 51.1988, 23.1909>, <-28.8264, 50.8682, 23.7758> }
					triangle { <-27.8562, 50.9437, 23.6012>, <-28.8264, 50.8682, 23.7758>, <-28.4711, 50.5973, 24.1383> }
					triangle { <-28.8264, 50.8682, 23.7758>, <-29.7756, 49.4374, 23.9267>, <-29.5704, 48.6259, 24.5154> }
					triangle { <-28.4711, 50.5973, 24.1383>, <-28.8264, 50.8682, 23.7758>, <-29.5704, 48.6259, 24.5154> }
					triangle { <-26.3758, 51.9361, 22.3765>, <-26.03772, 52.00613, 22.613>, <-25.694, 51.9141, 21.6059> }
					triangle { <-26.3758, 51.9361, 22.3765>, <-26.2913, 51.8496, 23.1207>, <-26.03772, 52.00613, 22.613> }
					triangle { <-26.9607, 51.9842, 23.05017>, <-26.704, 52.08735, 23.2946>, <-26.3758, 51.9361, 22.3765> }
					triangle { <-26.9607, 51.9842, 23.05017>, <-27.4755, 50.8635, 23.9202>, <-26.704, 52.08735, 23.2946> }
					triangle { <-26.704, 52.08735, 23.2946>, <-26.2913, 51.8496, 23.1207>, <-26.3758, 51.9361, 22.3765> }
					triangle { <-26.704, 52.08735, 23.2946>, <-26.9319, 50.7172, 24.2234>, <-26.2913, 51.8496, 23.1207> }
					triangle { <-27.4755, 50.8635, 23.9202>, <-26.9319, 50.7172, 24.2234>, <-26.704, 52.08735, 23.2946> }
					triangle { <-27.8562, 50.9437, 23.6012>, <-27.4755, 50.8635, 23.9202>, <-26.9607, 51.9842, 23.05017> }
					triangle { <-27.4755, 50.8635, 23.9202>, <-27.4675, 50.2048, 24.7949>, <-26.9319, 50.7172, 24.2234> }
					triangle { <-28.07128, 50.3091, 24.5408>, <-28.7892, 48.7907, 24.9796>, <-27.4675, 50.2048, 24.7949> }
					triangle { <-28.07128, 50.3091, 24.5408>, <-27.4675, 50.2048, 24.7949>, <-27.4755, 50.8635, 23.9202> }
					triangle { <-28.07128, 50.3091, 24.5408>, <-27.4755, 50.8635, 23.9202>, <-27.8562, 50.9437, 23.6012> }
					triangle { <-28.4711, 50.5973, 24.1383>, <-28.07128, 50.3091, 24.5408>, <-27.8562, 50.9437, 23.6012> }
					triangle { <-29.5704, 48.6259, 24.5154>, <-28.7892, 48.7907, 24.9796>, <-28.07128, 50.3091, 24.5408> }
					triangle { <-29.5704, 48.6259, 24.5154>, <-28.07128, 50.3091, 24.5408>, <-28.4711, 50.5973, 24.1383> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <-25.694, 51.9141, 21.6059>, <-26.3489, 51.7671, 22.2903>, <-26.1385, 52.03429, 22.5263> }
					triangle { <-26.3489, 51.7671, 22.2903>, <-26.8588, 51.7066, 22.8135>, <-26.1385, 52.03429, 22.5263> }
					triangle { <-26.1385, 52.03429, 22.5263>, <-26.7574, 51.8539, 23.2494>, <-26.5453, 52.156, 23.3124> }
					triangle { <-26.7574, 51.8539, 23.2494>, <-26.548, 51.2286, 24.4305>, <-26.5453, 52.156, 23.3124> }
					triangle { <-26.1385, 52.03429, 22.5263>, <-26.8588, 51.7066, 22.8135>, <-26.7574, 51.8539, 23.2494> }
					triangle { <-26.8588, 51.7066, 22.8135>, <-26.7586, 50.8604, 24.3092>, <-26.7574, 51.8539, 23.2494> }
					triangle { <-26.7574, 51.8539, 23.2494>, <-26.7586, 50.8604, 24.3092>, <-26.548, 51.2286, 24.4305> }
					triangle { <-26.5453, 52.156, 23.3124>, <-26.548, 51.2286, 24.4305>, <-26.1947, 51.6309, 24.6501> }
					triangle { <-26.7586, 50.8604, 24.3092>, <-26.9101, 50.6341, 25.1624>, <-26.548, 51.2286, 24.4305> }
					triangle { <-26.9101, 50.6341, 25.1624>, <-25.9846, 50.148, 26.6035>, <-26.6656, 51.1189, 25.3526> }
					triangle { <-26.548, 51.2286, 24.4305>, <-26.9101, 50.6341, 25.1624>, <-26.6656, 51.1189, 25.3526> }
					triangle { <-26.1947, 51.6309, 24.6501>, <-26.548, 51.2286, 24.4305>, <-26.6656, 51.1189, 25.3526> }
					triangle { <-26.1947, 51.6309, 24.6501>, <-26.6656, 51.1189, 25.3526>, <-26.2755, 51.5054, 25.5243> }
					triangle { <-26.6656, 51.1189, 25.3526>, <-25.9846, 50.148, 26.6035>, <-25.2385, 50.4175, 27.2501> }
					triangle { <-26.2755, 51.5054, 25.5243>, <-26.6656, 51.1189, 25.3526>, <-25.2385, 50.4175, 27.2501> }
					triangle { <-26.1385, 52.03429, 22.5263>, <-26.03431, 52.4362, 22.4734>, <-25.694, 51.9141, 21.6059> }
					triangle { <-26.1385, 52.03429, 22.5263>, <-26.07859, 52.5807, 23.04241>, <-26.03431, 52.4362, 22.4734> }
					triangle { <-26.5453, 52.156, 23.3124>, <-26.5132, 52.5234, 23.2968>, <-26.1385, 52.03429, 22.5263> }
					triangle { <-26.5453, 52.156, 23.3124>, <-25.9479, 52.06698, 24.6955>, <-26.5132, 52.5234, 23.2968> }
					triangle { <-26.5132, 52.5234, 23.2968>, <-26.07859, 52.5807, 23.04241>, <-26.1385, 52.03429, 22.5263> }
					triangle { <-26.5132, 52.5234, 23.2968>, <-25.5569, 52.572, 24.6661>, <-26.07859, 52.5807, 23.04241> }
					triangle { <-25.9479, 52.06698, 24.6955>, <-25.5569, 52.572, 24.6661>, <-26.5132, 52.5234, 23.2968> }
					triangle { <-26.1947, 51.6309, 24.6501>, <-25.9479, 52.06698, 24.6955>, <-26.5453, 52.156, 23.3124> }
					triangle { <-25.9479, 52.06698, 24.6955>, <-25.4584, 52.4647, 25.5907>, <-25.5569, 52.572, 24.6661> }
					triangle { <-25.8502, 51.9422, 25.7066>, <-24.994, 51.2892, 27.06831>, <-25.4584, 52.4647, 25.5907> }
					triangle { <-25.8502, 51.9422, 25.7066>, <-25.4584, 52.4647, 25.5907>, <-25.9479, 52.06698, 24.6955> }
					triangle { <-25.8502, 51.9422, 25.7066>, <-25.9479, 52.06698, 24.6955>, <-26.1947, 51.6309, 24.6501> }
					triangle { <-26.2755, 51.5054, 25.5243>, <-25.8502, 51.9422, 25.7066>, <-26.1947, 51.6309, 24.6501> }
					triangle { <-25.2385, 50.4175, 27.2501>, <-24.994, 51.2892, 27.06831>, <-25.8502, 51.9422, 25.7066> }
					triangle { <-25.2385, 50.4175, 27.2501>, <-25.8502, 51.9422, 25.7066>, <-26.2755, 51.5054, 25.5243> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		union { // inflor. internode
			cylinder { <-3.9983, 22.9936, 0.1521>, <-4.2826, 24.2631, 0.1244>, 0.3888 }
			cylinder { <-4.2826, 24.2631, 0.1244>, <-4.5669, 25.5325, 0.09661>, 0.3888 }
			cylinder { <-4.5669, 25.5325, 0.09661>, <-4.8512, 26.8019, 0.06882>, 0.3888 }
			cylinder { <-4.8512, 26.8019, 0.06882>, <-5.1356, 28.07133, 0.04103>, 0.3888 }
			cylinder { <-5.1356, 28.07133, 0.04103>, <-5.4199, 29.3407, 0.01324>, 0.3888 }
			cylinder { <-5.4199, 29.3407, 0.01324>, <-5.7042, 30.6101, -0.01454>, 0.3888 }
			cylinder { <-5.7042, 30.6101, -0.01454>, <-5.9885, 31.8795, -0.04233>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-5.9885, 31.8795, -0.04233>, <-6.3277, 38.2337, -0.4396>, 0.3888 }
				cylinder { <-6.3277, 38.2337, -0.4396>, <-5.6031, 44.535, -1.08653>, 0.3888 }
				cylinder { <-5.6031, 44.535, -1.08653>, <-3.8359, 50.5977, -1.9638>, 0.3888 }
				cylinder { <-3.8359, 50.5977, -1.9638>, <-1.07827, 56.2434, -3.04573>, 0.3888 }
				cylinder { <-1.07827, 56.2434, -3.04573>, <2.5887, 61.3058, -4.3004>, 0.3888 }
				cylinder { <2.5887, 61.3058, -4.3004>, <7.05709, 65.6359, -5.6908>, 0.3888 }
				cylinder { <7.05709, 65.6359, -5.6908>, <12.1952, 69.1061, -7.1762>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <12.1952, 69.1061, -7.1762>, <12.9862, 69.3286, -7.6698>, <12.8871, 69.7271, -7.6176> }
					triangle { <12.9862, 69.3286, -7.6698>, <13.6068, 69.5271, -8.005764>, <12.8871, 69.7271, -7.6176> }
					triangle { <12.8871, 69.7271, -7.6176>, <13.6499, 69.9689, -8.1634>, <13.5066, 70.2607, -7.9777> }
					triangle { <13.6499, 69.9689, -8.1634>, <13.6892, 70.5308, -9.3933>, <13.5066, 70.2607, -7.9777> }
					triangle { <12.8871, 69.7271, -7.6176>, <13.6068, 69.5271, -8.005764>, <13.6499, 69.9689, -8.1634> }
					triangle { <13.6068, 69.5271, -8.005764>, <13.8061, 70.1565, -9.5955>, <13.6499, 69.9689, -8.1634> }
					triangle { <13.6499, 69.9689, -8.1634>, <13.8061, 70.1565, -9.5955>, <13.6892, 70.5308, -9.3933> }
					triangle { <13.5066, 70.2607, -7.9777>, <13.6892, 70.5308, -9.3933>, <13.468, 71.04125, -9.2337> }
					triangle { <13.8061, 70.1565, -9.5955>, <14.1535, 70.6072, -10.287>, <13.6892, 70.5308, -9.3933> }
					triangle { <14.1535, 70.6072, -10.287>, <13.6014, 71.6599, -11.6124>, <14.03908, 71.1128, -10.03758> }
					triangle { <13.6892, 70.5308, -9.3933>, <14.1535, 70.6072, -10.287>, <14.03908, 71.1128, -10.03758> }
					triangle { <13.468, 71.04125, -9.2337>, <13.6892, 70.5308, -9.3933>, <14.03908, 71.1128, -10.03758> }
					triangle { <13.468, 71.04125, -9.2337>, <14.03908, 71.1128, -10.03758>, <13.7676, 71.5892, -9.8634> }
					triangle { <14.03908, 71.1128, -10.03758>, <13.6014, 71.6599, -11.6124>, <13.1053, 72.5245, -11.8442> }
					triangle { <13.7676, 71.5892, -9.8634>, <14.03908, 71.1128, -10.03758>, <13.1053, 72.5245, -11.8442> }
					triangle { <12.8871, 69.7271, -7.6176>, <12.8282, 69.9607, -7.2753>, <12.1952, 69.1061, -7.1762> }
					triangle { <12.8871, 69.7271, -7.6176>, <13.04618, 70.4558, -7.5075>, <12.8282, 69.9607, -7.2753> }
					triangle { <13.5066, 70.2607, -7.9777>, <13.5219, 70.4797, -7.6809>, <12.8871, 69.7271, -7.6176> }
					triangle { <13.5066, 70.2607, -7.9777>, <13.3051, 71.4109, -8.9339>, <13.5219, 70.4797, -7.6809> }
					triangle { <13.5219, 70.4797, -7.6809>, <13.04618, 70.4558, -7.5075>, <12.8871, 69.7271, -7.6176> }
					triangle { <13.5219, 70.4797, -7.6809>, <12.9937, 71.8098, -8.5431>, <13.04618, 70.4558, -7.5075> }
					triangle { <13.3051, 71.4109, -8.9339>, <12.9937, 71.8098, -8.5431>, <13.5219, 70.4797, -7.6809> }
					triangle { <13.468, 71.04125, -9.2337>, <13.3051, 71.4109, -8.9339>, <13.5066, 70.2607, -7.9777> }
					triangle { <13.3051, 71.4109, -8.9339>, <13.1388, 72.4599, -9.2007>, <12.9937, 71.8098, -8.5431> }
					triangle { <13.4723, 72.1142, -9.6582>, <12.9416, 72.9871, -11.06193>, <13.1388, 72.4599, -9.2007> }
					triangle { <13.4723, 72.1142, -9.6582>, <13.1388, 72.4599, -9.2007>, <13.3051, 71.4109, -8.9339> }
					triangle { <13.4723, 72.1142, -9.6582>, <13.3051, 71.4109, -8.9339>, <13.468, 71.04125, -9.2337> }
					triangle { <13.7676, 71.5892, -9.8634>, <13.4723, 72.1142, -9.6582>, <13.468, 71.04125, -9.2337> }
					triangle { <13.1053, 72.5245, -11.8442>, <12.9416, 72.9871, -11.06193>, <13.4723, 72.1142, -9.6582> }
					triangle { <13.1053, 72.5245, -11.8442>, <13.4723, 72.1142, -9.6582>, <13.7676, 71.5892, -9.8634> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <12.1952, 69.1061, -7.1762>, <12.7206, 69.705, -7.7093>, <12.8737, 69.8586, -7.3567> }
					triangle { <12.7206, 69.705, -7.7093>, <13.1652, 70.1434, -8.0933>, <12.8737, 69.8586, -7.3567> }
					triangle { <12.8737, 69.8586, -7.3567>, <13.3676, 70.5097, -7.8768>, <13.4831, 70.4908, -7.5212> }
					triangle { <13.3676, 70.5097, -7.8768>, <13.2136, 71.8516, -7.9527>, <13.4831, 70.4908, -7.5212> }
					triangle { <12.8737, 69.8586, -7.3567>, <13.1652, 70.1434, -8.0933>, <13.3676, 70.5097, -7.8768> }
					triangle { <13.1652, 70.1434, -8.0933>, <13.02858, 71.8396, -8.353>, <13.3676, 70.5097, -7.8768> }
					triangle { <13.3676, 70.5097, -7.8768>, <13.02858, 71.8396, -8.353>, <13.2136, 71.8516, -7.9527> }
					triangle { <13.4831, 70.4908, -7.5212>, <13.2136, 71.8516, -7.9527>, <13.3742, 71.9617, -7.4077> }
					triangle { <13.02858, 71.8396, -8.353>, <13.2594, 72.6898, -8.5143>, <13.2136, 71.8516, -7.9527> }
					triangle { <13.2594, 72.6898, -8.5143>, <12.8757, 74.3195, -7.909>, <13.5333, 72.7294, -8.01> }
					triangle { <13.2136, 71.8516, -7.9527>, <13.2594, 72.6898, -8.5143>, <13.5333, 72.7294, -8.01> }
					triangle { <13.3742, 71.9617, -7.4077>, <13.2136, 71.8516, -7.9527>, <13.5333, 72.7294, -8.01> }
					triangle { <13.3742, 71.9617, -7.4077>, <13.5333, 72.7294, -8.01>, <13.6436, 72.8056, -7.4505> }
					triangle { <13.5333, 72.7294, -8.01>, <12.8757, 74.3195, -7.909>, <12.8606, 74.9244, -7.08369> }
					triangle { <13.6436, 72.8056, -7.4505>, <13.5333, 72.7294, -8.01>, <12.8606, 74.9244, -7.08369> }
					triangle { <12.8737, 69.8586, -7.3567>, <13.08384, 69.6829, -7.04018>, <12.1952, 69.1061, -7.1762> }
					triangle { <12.8737, 69.8586, -7.3567>, <13.4178, 70.1542, -6.9266>, <13.08384, 69.6829, -7.04018> }
					triangle { <13.4831, 70.4908, -7.5212>, <13.7243, 70.3523, -7.2784>, <12.8737, 69.8586, -7.3567> }
					triangle { <13.4831, 70.4908, -7.5212>, <13.5598, 71.8843, -6.9466>, <13.7243, 70.3523, -7.2784> }
					triangle { <13.7243, 70.3523, -7.2784>, <13.4178, 70.1542, -6.9266>, <12.8737, 69.8586, -7.3567> }
					triangle { <13.7243, 70.3523, -7.2784>, <13.6833, 71.7327, -6.3378>, <13.4178, 70.1542, -6.9266> }
					triangle { <13.5598, 71.8843, -6.9466>, <13.6833, 71.7327, -6.3378>, <13.7243, 70.3523, -7.2784> }
					triangle { <13.3742, 71.9617, -7.4077>, <13.5598, 71.8843, -6.9466>, <13.4831, 70.4908, -7.5212> }
					triangle { <13.5598, 71.8843, -6.9466>, <13.8779, 72.6408, -6.2215>, <13.6833, 71.7327, -6.3378> }
					triangle { <13.7731, 72.8786, -6.8318>, <13.2814, 74.4838, -6.3897>, <13.8779, 72.6408, -6.2215> }
					triangle { <13.7731, 72.8786, -6.8318>, <13.8779, 72.6408, -6.2215>, <13.5598, 71.8843, -6.9466> }
					triangle { <13.7731, 72.8786, -6.8318>, <13.5598, 71.8843, -6.9466>, <13.3742, 71.9617, -7.4077> }
					triangle { <13.6436, 72.8056, -7.4505>, <13.7731, 72.8786, -6.8318>, <13.3742, 71.9617, -7.4077> }
					triangle { <12.8606, 74.9244, -7.08369>, <13.2814, 74.4838, -6.3897>, <13.7731, 72.8786, -6.8318> }
					triangle { <12.8606, 74.9244, -7.08369>, <13.7731, 72.8786, -6.8318>, <13.6436, 72.8056, -7.4505> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <12.1952, 69.1061, -7.1762>, <12.7001, 69.912, -7.2964>, <13.03341, 69.7032, -7.1673> }
					triangle { <12.7001, 69.912, -7.2964>, <13.1178, 70.5015, -7.4208>, <13.03341, 69.7032, -7.1673> }
					triangle { <13.03341, 69.7032, -7.1673>, <13.5467, 70.5225, -7.2272>, <13.7626, 70.2189, -7.1898> }
					triangle { <13.5467, 70.5225, -7.2272>, <14.1012, 71.2686, -6.2443>, <13.7626, 70.2189, -7.1898> }
					triangle { <13.03341, 69.7032, -7.1673>, <13.1178, 70.5015, -7.4208>, <13.5467, 70.5225, -7.2272> }
					triangle { <13.1178, 70.5015, -7.4208>, <13.7991, 71.5889, -6.2734>, <13.5467, 70.5225, -7.2272> }
					triangle { <13.5467, 70.5225, -7.2272>, <13.7991, 71.5889, -6.2734>, <14.1012, 71.2686, -6.2443> }
					triangle { <13.7626, 70.2189, -7.1898>, <14.1012, 71.2686, -6.2443>, <14.4921, 70.874, -6.08211> }
					triangle { <13.7991, 71.5889, -6.2734>, <14.3558, 72.1843, -5.9025>, <14.1012, 71.2686, -6.2443> }
					triangle { <14.3558, 72.1843, -5.9025>, <15.1504, 72.4803, -4.3371>, <14.7802, 71.7968, -5.8755> }
					triangle { <14.1012, 71.2686, -6.2443>, <14.3558, 72.1843, -5.9025>, <14.7802, 71.7968, -5.8755> }
					triangle { <14.4921, 70.874, -6.08211>, <14.1012, 71.2686, -6.2443>, <14.7802, 71.7968, -5.8755> }
					triangle { <14.4921, 70.874, -6.08211>, <14.7802, 71.7968, -5.8755>, <15.1208, 71.3682, -5.6987> }
					triangle { <14.7802, 71.7968, -5.8755>, <15.1504, 72.4803, -4.3371>, <15.7751, 72.08855, -3.6274> }
					triangle { <15.1208, 71.3682, -5.6987>, <14.7802, 71.7968, -5.8755>, <15.7751, 72.08855, -3.6274> }
					triangle { <13.03341, 69.7032, -7.1673>, <13.224, 69.3593, -7.311>, <12.1952, 69.1061, -7.1762> }
					triangle { <13.03341, 69.7032, -7.1673>, <13.7679, 69.5329, -7.1672>, <13.224, 69.3593, -7.311> }
					triangle { <13.7626, 70.2189, -7.1898>, <13.9676, 69.9596, -7.3542>, <13.03341, 69.7032, -7.1673> }
					triangle { <13.7626, 70.2189, -7.1898>, <14.7715, 70.4558, -6.09262>, <13.9676, 69.9596, -7.3542> }
					triangle { <13.9676, 69.9596, -7.3542>, <13.7679, 69.5329, -7.1672>, <13.03341, 69.7032, -7.1673> }
					triangle { <13.9676, 69.9596, -7.3542>, <15.02235, 69.8684, -6.06158>, <13.7679, 69.5329, -7.1672> }
					triangle { <14.7715, 70.4558, -6.09262>, <15.02235, 69.8684, -6.06158>, <13.9676, 69.9596, -7.3542> }
					triangle { <14.4921, 70.874, -6.08211>, <14.7715, 70.4558, -6.09262>, <13.7626, 70.2189, -7.1898> }
					triangle { <14.7715, 70.4558, -6.09262>, <15.6895, 70.2543, -5.5305>, <15.02235, 69.8684, -6.06158> }
					triangle { <15.4974, 70.889, -5.5157>, <16.1337, 71.3029, -3.9544>, <15.6895, 70.2543, -5.5305> }
					triangle { <15.4974, 70.889, -5.5157>, <15.6895, 70.2543, -5.5305>, <14.7715, 70.4558, -6.09262> }
					triangle { <15.4974, 70.889, -5.5157>, <14.7715, 70.4558, -6.09262>, <14.4921, 70.874, -6.08211> }
					triangle { <15.1208, 71.3682, -5.6987>, <15.4974, 70.889, -5.5157>, <14.4921, 70.874, -6.08211> }
					triangle { <15.7751, 72.08855, -3.6274>, <16.1337, 71.3029, -3.9544>, <15.4974, 70.889, -5.5157> }
					triangle { <15.7751, 72.08855, -3.6274>, <15.4974, 70.889, -5.5157>, <15.1208, 71.3682, -5.6987> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <12.1952, 69.1061, -7.1762>, <12.9529, 69.6655, -6.9978>, <13.147, 69.4742, -7.3094> }
					triangle { <12.9529, 69.6655, -6.9978>, <13.5296, 70.1097, -6.9114>, <13.147, 69.4742, -7.3094> }
					triangle { <13.147, 69.4742, -7.3094>, <13.9415, 69.9897, -7.1062>, <13.9614, 69.8181, -7.4383> }
					triangle { <13.9415, 69.9897, -7.1062>, <15.1336, 69.5822, -6.6133>, <13.9614, 69.8181, -7.4383> }
					triangle { <13.147, 69.4742, -7.3094>, <13.5296, 70.1097, -6.9114>, <13.9415, 69.9897, -7.1062> }
					triangle { <13.5296, 70.1097, -6.9114>, <15.06012, 69.7484, -6.2112>, <13.9415, 69.9897, -7.1062> }
					triangle { <13.9415, 69.9897, -7.1062>, <15.06012, 69.7484, -6.2112>, <15.1336, 69.5822, -6.6133> }
					triangle { <13.9614, 69.8181, -7.4383>, <15.1336, 69.5822, -6.6133>, <15.2872, 69.271, -7.07639> }
					triangle { <15.06012, 69.7484, -6.2112>, <15.9378, 69.7846, -6.03678>, <15.1336, 69.5822, -6.6133> }
					triangle { <15.9378, 69.7846, -6.03678>, <17.3031, 68.667, -5.7997>, <16.06821, 69.5951, -6.5641> }
					triangle { <15.1336, 69.5822, -6.6133>, <15.9378, 69.7846, -6.03678>, <16.06821, 69.5951, -6.5641> }
					triangle { <15.2872, 69.271, -7.07639>, <15.1336, 69.5822, -6.6133>, <16.06821, 69.5951, -6.5641> }
					triangle { <15.2872, 69.271, -7.07639>, <16.06821, 69.5951, -6.5641>, <16.1716, 69.2501, -7.01264> }
					triangle { <16.06821, 69.5951, -6.5641>, <17.3031, 68.667, -5.7997>, <17.8482, 67.9095, -6.2197> }
					triangle { <16.1716, 69.2501, -7.01264>, <16.06821, 69.5951, -6.5641>, <17.8482, 67.9095, -6.2197> }
					triangle { <13.147, 69.4742, -7.3094>, <13.05649, 69.4341, -7.7161>, <12.1952, 69.1061, -7.1762> }
					triangle { <13.147, 69.4742, -7.3094>, <13.6159, 69.4446, -7.8991>, <13.05649, 69.4341, -7.7161> }
					triangle { <13.9614, 69.8181, -7.4383>, <13.9178, 69.8406, -7.8042>, <13.147, 69.4742, -7.3094> }
					triangle { <13.9614, 69.8181, -7.4383>, <15.277, 69.08613, -7.5441>, <13.9178, 69.8406, -7.8042> }
					triangle { <13.9178, 69.8406, -7.8042>, <13.6159, 69.4446, -7.8991>, <13.147, 69.4742, -7.3094> }
					triangle { <13.9178, 69.8406, -7.8042>, <15.1727, 68.776, -8.09351>, <13.6159, 69.4446, -7.8991> }
					triangle { <15.277, 69.08613, -7.5441>, <15.1727, 68.776, -8.09351>, <13.9178, 69.8406, -7.8042> }
					triangle { <15.2872, 69.271, -7.07639>, <15.277, 69.08613, -7.5441>, <13.9614, 69.8181, -7.4383> }
					triangle { <15.277, 69.08613, -7.5441>, <16.08701, 68.5762, -8.07624>, <15.1727, 68.776, -8.09351> }
					triangle { <16.2783, 68.8764, -7.5165>, <17.5834, 67.8106, -7.09884>, <16.08701, 68.5762, -8.07624> }
					triangle { <16.2783, 68.8764, -7.5165>, <16.08701, 68.5762, -8.07624>, <15.277, 69.08613, -7.5441> }
					triangle { <16.2783, 68.8764, -7.5165>, <15.277, 69.08613, -7.5441>, <15.2872, 69.271, -7.07639> }
					triangle { <16.1716, 69.2501, -7.01264>, <16.2783, 68.8764, -7.5165>, <15.2872, 69.271, -7.07639> }
					triangle { <17.8482, 67.9095, -6.2197>, <17.5834, 67.8106, -7.09884>, <16.2783, 68.8764, -7.5165> }
					triangle { <17.8482, 67.9095, -6.2197>, <16.2783, 68.8764, -7.5165>, <16.1716, 69.2501, -7.01264> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				mesh { // flower petal
					triangle { <12.1952, 69.1061, -7.1762>, <13.1324, 69.2995, -7.2321>, <13.05522, 69.4892, -7.5918> }
					triangle { <13.1324, 69.2995, -7.2321>, <13.8364, 69.4984, -7.2784>, <13.05522, 69.4892, -7.5918> }
					triangle { <13.05522, 69.4892, -7.5918>, <14.0063, 69.6425, -7.6935>, <13.8008, 69.8444, -7.9326> }
					triangle { <14.0063, 69.6425, -7.6935>, <14.8751, 69.1193, -8.5888>, <13.8008, 69.8444, -7.9326> }
					triangle { <13.05522, 69.4892, -7.5918>, <13.8364, 69.4984, -7.2784>, <14.0063, 69.6425, -7.6935> }
					triangle { <13.8364, 69.4984, -7.2784>, <15.06456, 68.8498, -8.2953>, <14.0063, 69.6425, -7.6935> }
					triangle { <14.0063, 69.6425, -7.6935>, <15.06456, 68.8498, -8.2953>, <14.8751, 69.1193, -8.5888> }
					triangle { <13.8008, 69.8444, -7.9326>, <14.8751, 69.1193, -8.5888>, <14.6448, 69.376, -9.0536> }
					triangle { <15.06456, 68.8498, -8.2953>, <15.8108, 68.7952, -8.7874>, <14.8751, 69.1193, -8.5888> }
					triangle { <15.8108, 68.7952, -8.7874>, <16.3313, 68.1523, -10.3639>, <15.6032, 69.166, -9.1751> }
					triangle { <14.8751, 69.1193, -8.5888>, <15.8108, 68.7952, -8.7874>, <15.6032, 69.166, -9.1751> }
					triangle { <14.6448, 69.376, -9.0536>, <14.8751, 69.1193, -8.5888>, <15.6032, 69.166, -9.1751> }
					triangle { <14.6448, 69.376, -9.0536>, <15.6032, 69.166, -9.1751>, <15.3226, 69.3887, -9.6253> }
					triangle { <15.6032, 69.166, -9.1751>, <16.3313, 68.1523, -10.3639>, <16.1733, 68.183, -11.3746> }
					triangle { <15.3226, 69.3887, -9.6253>, <15.6032, 69.166, -9.1751>, <16.1733, 68.183, -11.3746> }
					triangle { <13.05522, 69.4892, -7.5918>, <12.8081, 69.8114, -7.6936>, <12.1952, 69.1061, -7.1762> }
					triangle { <13.05522, 69.4892, -7.5918>, <13.1631, 70.0237, -8.1126>, <12.8081, 69.8114, -7.6936> }
					triangle { <13.8008, 69.8444, -7.9326>, <13.6382, 70.1669, -8.009192>, <13.05522, 69.4892, -7.5918> }
					triangle { <13.8008, 69.8444, -7.9326>, <14.357, 69.6853, -9.3266>, <13.6382, 70.1669, -8.009192> }
					triangle { <13.6382, 70.1669, -8.009192>, <13.1631, 70.0237, -8.1126>, <13.05522, 69.4892, -7.5918> }
					triangle { <13.6382, 70.1669, -8.009192>, <13.9, 69.994, -9.6503>, <13.1631, 70.0237, -8.1126> }
					triangle { <14.357, 69.6853, -9.3266>, <13.9, 69.994, -9.6503>, <13.6382, 70.1669, -8.009192> }
					triangle { <14.6448, 69.376, -9.0536>, <14.357, 69.6853, -9.3266>, <13.8008, 69.8444, -7.9326> }
					triangle { <14.357, 69.6853, -9.3266>, <14.4868, 69.9599, -10.3788>, <13.9, 69.994, -9.6503> }
					triangle { <15.00788, 69.645, -10.1154>, <15.5808, 68.8672, -11.5578>, <14.4868, 69.9599, -10.3788> }
					triangle { <15.00788, 69.645, -10.1154>, <14.4868, 69.9599, -10.3788>, <14.357, 69.6853, -9.3266> }
					triangle { <15.00788, 69.645, -10.1154>, <14.357, 69.6853, -9.3266>, <14.6448, 69.376, -9.0536> }
					triangle { <15.3226, 69.3887, -9.6253>, <15.00788, 69.645, -10.1154>, <14.6448, 69.376, -9.0536> }
					triangle { <16.1733, 68.183, -11.3746>, <15.5808, 68.8672, -11.5578>, <15.00788, 69.645, -10.1154> }
					triangle { <16.1733, 68.183, -11.3746>, <15.00788, 69.645, -10.1154>, <15.3226, 69.3887, -9.6253> }
					pigment { color rgb <0.92, 0.72, 0.92> }}
				}
			}
		}
	union { // internode
		cylinder { <-0.01793, 5.2219, 0.5412>, <-0.05032, 5.3689, 0.5416>, 0.4 }
		cylinder { <-0.05032, 5.3689, 0.5416>, <-0.08217, 5.516, 0.5457>, 0.4 }
		cylinder { <-0.08217, 5.516, 0.5457>, <-0.1134, 5.6631, 0.5535>, 0.4 }
		cylinder { <-0.1134, 5.6631, 0.5535>, <-0.1441, 5.8101, 0.5649>, 0.4 }
		cylinder { <-0.1441, 5.8101, 0.5649>, <-0.1743, 5.9568, 0.5799>, 0.4 }
		cylinder { <-0.1743, 5.9568, 0.5799>, <-0.2038, 6.1033, 0.5986>, 0.4 }
		cylinder { <-0.2038, 6.1033, 0.5986>, <-0.2327, 6.2494, 0.6209>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.2327, 6.2494, 0.6209>, <-1.5654, 12.00651, 0.207>, 0.4658 }
			cylinder { <-1.5654, 12.00651, 0.207>, <-3.02955, 17.4936, -1.4777>, 0.4658 }
			cylinder { <-3.02955, 17.4936, -1.4777>, <-4.5539, 22.4443, -4.3515>, 0.4658 }
			cylinder { <-4.5539, 22.4443, -4.3515>, <-6.06464, 26.6178, -8.2746>, 0.4658 }
			cylinder { <-6.06464, 26.6178, -8.2746>, <-7.488, 29.8113, -13.05653>, 0.4658 }
			cylinder { <-7.488, 29.8113, -13.05653>, <-8.7551, 31.8697, -18.4647>, 0.4658 }
			cylinder { <-8.7551, 31.8697, -18.4647>, <-9.8043, 32.693, -24.2364>, 0.4658 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-9.8043, 32.693, -24.2364>, <-12.865, 30.1514, -19.4227>, <-16.8374, 32.9413, -24.03138> }
			triangle { <-9.8043, 32.693, -24.2364>, <-16.8374, 32.9413, -24.03138>, <-16.8717, 34.1175, -28.8468> }
			triangle { <-12.865, 30.1514, -19.4227>, <-16.00644, 29.4351, -17.8451>, <-16.8374, 32.9413, -24.03138> }
			triangle { <-16.00644, 29.4351, -17.8451>, <-18.7104, 29.7037, -20.6415>, <-16.8374, 32.9413, -24.03138> }
			triangle { <-18.7104, 29.7037, -20.6415>, <-20.4006, 30.3602, -25.9693>, <-16.8374, 32.9413, -24.03138> }
			triangle { <-20.4006, 30.3602, -25.9693>, <-21.2775, 31.2157, -31.7862>, <-16.8717, 34.1175, -28.8468> }
			triangle { <-16.8374, 32.9413, -24.03138>, <-20.4006, 30.3602, -25.9693>, <-16.8717, 34.1175, -28.8468> }
			triangle { <-16.8717, 34.1175, -28.8468>, <-17.9961, 33.7287, -34.05698>, <-14.06007, 34.6358, -33.9038> }
			triangle { <-17.9961, 33.7287, -34.05698>, <-18.9467, 32.2561, -38.1597>, <-15.9339, 33.998, -38.2741> }
			triangle { <-17.9961, 33.7287, -34.05698>, <-15.9339, 33.998, -38.2741>, <-14.06007, 34.6358, -33.9038> }
			triangle { <-14.06007, 34.6358, -33.9038>, <-15.9339, 33.998, -38.2741>, <-12.1841, 34.09232, -37.8335> }
			triangle { <-18.9467, 32.2561, -38.1597>, <-15.6146, 31.4527, -43.6847>, <-15.9339, 33.998, -38.2741> }
			triangle { <-15.9339, 33.998, -38.2741>, <-15.6146, 31.4527, -43.6847>, <-12.1841, 34.09232, -37.8335> }
			triangle { <-9.8043, 32.693, -24.2364>, <-16.8717, 34.1175, -28.8468>, <-10.8751, 33.8453, -29.7909> }
			triangle { <-10.8751, 33.8453, -29.7909>, <-16.8717, 34.1175, -28.8468>, <-14.06007, 34.6358, -33.9038> }
			triangle { <-10.8751, 33.8453, -29.7909>, <-14.06007, 34.6358, -33.9038>, <-11.6723, 34.4708, -34.1766> }
			triangle { <-14.06007, 34.6358, -33.9038>, <-12.1841, 34.09232, -37.8335>, <-11.6723, 34.4708, -34.1766> }
			triangle { <-21.2775, 31.2157, -31.7862>, <-17.9961, 33.7287, -34.05698>, <-16.8717, 34.1175, -28.8468> }
			triangle { <-21.2775, 31.2157, -31.7862>, <-18.9467, 32.2561, -38.1597>, <-17.9961, 33.7287, -34.05698> }
			triangle { <-3.5066, 35.206, -26.1315>, <-4.7964, 31.5222, -20.6938>, <-9.8043, 32.693, -24.2364> }
			triangle { <-5.2949, 36.08429, -30.6706>, <-3.5066, 35.206, -26.1315>, <-9.8043, 32.693, -24.2364> }
			triangle { <-3.5066, 35.206, -26.1315>, <-1.2723, 31.9383, -20.1663>, <-4.7964, 31.5222, -20.6938> }
			triangle { <-3.5066, 35.206, -26.1315>, <0.2332, 32.9221, -23.6259>, <-1.2723, 31.9383, -20.1663> }
			triangle { <-3.5066, 35.206, -26.1315>, <-0.05362, 33.8169, -29.1748>, <0.2332, 32.9221, -23.6259> }
			triangle { <-5.2949, 36.08429, -30.6706>, <-1.2813, 34.6129, -34.9364>, <-0.05362, 33.8169, -29.1748> }
			triangle { <-5.2949, 36.08429, -30.6706>, <-0.05362, 33.8169, -29.1748>, <-3.5066, 35.206, -26.1315> }
			triangle { <-9.4995, 35.4106, -34.6223>, <-5.8941, 37.04533, -35.7837>, <-5.2949, 36.08429, -30.6706> }
			triangle { <-8.8925, 35.01425, -39.4091>, <-5.6159, 34.5208, -40.2598>, <-5.8941, 37.04533, -35.7837> }
			triangle { <-9.4995, 35.4106, -34.6223>, <-8.8925, 35.01425, -39.4091>, <-5.8941, 37.04533, -35.7837> }
			triangle { <-12.1841, 34.09232, -37.8335>, <-8.8925, 35.01425, -39.4091>, <-9.4995, 35.4106, -34.6223> }
			triangle { <-8.8925, 35.01425, -39.4091>, <-10.02684, 32.5821, -44.5393>, <-5.6159, 34.5208, -40.2598> }
			triangle { <-12.1841, 34.09232, -37.8335>, <-10.02684, 32.5821, -44.5393>, <-8.8925, 35.01425, -39.4091> }
			triangle { <-10.8751, 33.8453, -29.7909>, <-5.2949, 36.08429, -30.6706>, <-9.8043, 32.693, -24.2364> }
			triangle { <-9.4995, 35.4106, -34.6223>, <-5.2949, 36.08429, -30.6706>, <-10.8751, 33.8453, -29.7909> }
			triangle { <-11.6723, 34.4708, -34.1766>, <-9.4995, 35.4106, -34.6223>, <-10.8751, 33.8453, -29.7909> }
			triangle { <-11.6723, 34.4708, -34.1766>, <-12.1841, 34.09232, -37.8335>, <-9.4995, 35.4106, -34.6223> }
			triangle { <-5.2949, 36.08429, -30.6706>, <-5.8941, 37.04533, -35.7837>, <-1.2813, 34.6129, -34.9364> }
			triangle { <-5.8941, 37.04533, -35.7837>, <-5.6159, 34.5208, -40.2598>, <-1.2813, 34.6129, -34.9364> }
			triangle { <-12.1841, 34.09232, -37.8335>, <-15.6146, 31.4527, -43.6847>, <-12.8652, 32.1303, -44.2726> }
			triangle { <-15.6146, 31.4527, -43.6847>, <-12.89, 29.3413, -47.4378>, <-12.8652, 32.1303, -44.2726> }
			triangle { <-12.1841, 34.09232, -37.8335>, <-12.8652, 32.1303, -44.2726>, <-10.02684, 32.5821, -44.5393> }
			triangle { <-12.8652, 32.1303, -44.2726>, <-12.89, 29.3413, -47.4378>, <-10.02684, 32.5821, -44.5393> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-0.2327, 6.2494, 0.6209>, <-0.2596, 6.3963, 0.6401>, 0.4 }
		cylinder { <-0.2596, 6.3963, 0.6401>, <-0.2846, 6.5439, 0.6563>, 0.4 }
		cylinder { <-0.2846, 6.5439, 0.6563>, <-0.3077, 6.6921, 0.6695>, 0.4 }
		cylinder { <-0.3077, 6.6921, 0.6695>, <-0.3287, 6.8408, 0.6795>, 0.4 }
		cylinder { <-0.3287, 6.8408, 0.6795>, <-0.3478, 6.99, 0.6865>, 0.4 }
		cylinder { <-0.3478, 6.99, 0.6865>, <-0.3648, 7.1396, 0.6904>, 0.4 }
		cylinder { <-0.3648, 7.1396, 0.6904>, <-0.3799, 7.2894, 0.6912>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.3799, 7.2894, 0.6912>, <-0.9938, 9.9969, 1.2233>, 0.2223 }
			cylinder { <-0.9938, 9.9969, 1.2233>, <-1.9093, 12.4677, 2.2467>, 0.2223 }
			cylinder { <-1.9093, 12.4677, 2.2467>, <-3.08198, 14.5819, 3.7116>, 0.2223 }
			cylinder { <-3.08198, 14.5819, 3.7116>, <-4.4546, 16.2365, 5.5469>, 0.2223 }
			cylinder { <-4.4546, 16.2365, 5.5469>, <-5.9607, 17.3513, 7.6634>, 0.2223 }
			cylinder { <-5.9607, 17.3513, 7.6634>, <-7.527, 17.8721, 9.9581>, 0.2223 }
			cylinder { <-7.527, 17.8721, 9.9581>, <-9.07745, 17.7735, 12.3197>, 0.2223 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-9.07745, 17.7735, 12.3197>, <-6.1762, 17.6588, 11.6485>, <-6.8127, 19.00358, 14.475> }
			triangle { <-9.07745, 17.7735, 12.3197>, <-6.8127, 19.00358, 14.475>, <-8.4673, 19.00411, 16.1654> }
			triangle { <-6.1762, 17.6588, 11.6485>, <-4.5633, 18.00653, 12.1049>, <-6.8127, 19.00358, 14.475> }
			triangle { <-4.5633, 18.00653, 12.1049>, <-4.5875, 18.2449, 13.9501>, <-6.8127, 19.00358, 14.475> }
			triangle { <-4.5875, 18.2449, 13.9501>, <-5.7683, 18.2214, 16.362>, <-6.8127, 19.00358, 14.475> }
			triangle { <-5.7683, 18.2214, 16.362>, <-7.3934, 18.1051, 18.6841>, <-8.4673, 19.00411, 16.1654> }
			triangle { <-6.8127, 19.00358, 14.475>, <-5.7683, 18.2214, 16.362>, <-8.4673, 19.00411, 16.1654> }
			triangle { <-8.4673, 19.00411, 16.1654>, <-9.5971, 18.4473, 18.3829>, <-10.9811, 18.2457, 17.05457> }
			triangle { <-9.5971, 18.4473, 18.3829>, <-10.2464, 17.5084, 20.1799>, <-11.5724, 17.7877, 19.2183> }
			triangle { <-9.5971, 18.4473, 18.3829>, <-11.5724, 17.7877, 19.2183>, <-10.9811, 18.2457, 17.05457> }
			triangle { <-10.9811, 18.2457, 17.05457>, <-11.5724, 17.7877, 19.2183>, <-12.6576, 17.2905, 17.868> }
			triangle { <-10.2464, 17.5084, 20.1799>, <-12.8184, 16.03966, 21.104>, <-11.5724, 17.7877, 19.2183> }
			triangle { <-11.5724, 17.7877, 19.2183>, <-12.8184, 16.03966, 21.104>, <-12.6576, 17.2905, 17.868> }
			triangle { <-9.07745, 17.7735, 12.3197>, <-8.4673, 19.00411, 16.1654>, <-10.6176, 17.8458, 14.6026> }
			triangle { <-10.6176, 17.8458, 14.6026>, <-8.4673, 19.00411, 16.1654>, <-10.9811, 18.2457, 17.05457> }
			triangle { <-10.6176, 17.8458, 14.6026>, <-10.9811, 18.2457, 17.05457>, <-11.7957, 17.7709, 16.3971> }
			triangle { <-10.9811, 18.2457, 17.05457>, <-12.6576, 17.2905, 17.868>, <-11.7957, 17.7709, 16.3971> }
			triangle { <-7.3934, 18.1051, 18.6841>, <-9.5971, 18.4473, 18.3829>, <-8.4673, 19.00411, 16.1654> }
			triangle { <-7.3934, 18.1051, 18.6841>, <-10.2464, 17.5084, 20.1799>, <-9.5971, 18.4473, 18.3829> }
			triangle { <-12.1334, 17.6848, 10.9268>, <-9.3967, 16.8607, 9.501>, <-9.07745, 17.7735, 12.3197> }
			triangle { <-13.08797, 17.8589, 13.08422>, <-12.1334, 17.6848, 10.9268>, <-9.07745, 17.7735, 12.3197> }
			triangle { <-12.1334, 17.6848, 10.9268>, <-10.4441, 16.549, 8.1833>, <-9.3967, 16.8607, 9.501> }
			triangle { <-12.1334, 17.6848, 10.9268>, <-12.1486, 16.3709, 8.908>, <-10.4441, 16.549, 8.1833> }
			triangle { <-12.1334, 17.6848, 10.9268>, <-13.8895, 16.2086, 10.9465>, <-12.1486, 16.3709, 8.908> }
			triangle { <-13.08797, 17.8589, 13.08422>, <-15.3745, 16.1271, 13.3619>, <-13.8895, 16.2086, 10.9465> }
			triangle { <-13.08797, 17.8589, 13.08422>, <-13.8895, 16.2086, 10.9465>, <-12.1334, 17.6848, 10.9268> }
			triangle { <-12.8013, 17.7946, 15.8407>, <-14.6107, 17.8214, 15.0654>, <-13.08797, 17.8589, 13.08422> }
			triangle { <-14.3566, 17.00962, 17.3579>, <-15.5672, 16.1897, 16.6318>, <-14.6107, 17.8214, 15.0654> }
			triangle { <-12.8013, 17.7946, 15.8407>, <-14.3566, 17.00962, 17.3579>, <-14.6107, 17.8214, 15.0654> }
			triangle { <-12.6576, 17.2905, 17.868>, <-14.3566, 17.00962, 17.3579>, <-12.8013, 17.7946, 15.8407> }
			triangle { <-14.3566, 17.00962, 17.3579>, <-15.07485, 15.5685, 19.603>, <-15.5672, 16.1897, 16.6318> }
			triangle { <-12.6576, 17.2905, 17.868>, <-15.07485, 15.5685, 19.603>, <-14.3566, 17.00962, 17.3579> }
			triangle { <-10.6176, 17.8458, 14.6026>, <-13.08797, 17.8589, 13.08422>, <-9.07745, 17.7735, 12.3197> }
			triangle { <-12.8013, 17.7946, 15.8407>, <-13.08797, 17.8589, 13.08422>, <-10.6176, 17.8458, 14.6026> }
			triangle { <-11.7957, 17.7709, 16.3971>, <-12.8013, 17.7946, 15.8407>, <-10.6176, 17.8458, 14.6026> }
			triangle { <-11.7957, 17.7709, 16.3971>, <-12.6576, 17.2905, 17.868>, <-12.8013, 17.7946, 15.8407> }
			triangle { <-13.08797, 17.8589, 13.08422>, <-14.6107, 17.8214, 15.0654>, <-15.3745, 16.1271, 13.3619> }
			triangle { <-14.6107, 17.8214, 15.0654>, <-15.5672, 16.1897, 16.6318>, <-15.3745, 16.1271, 13.3619> }
			triangle { <-12.6576, 17.2905, 17.868>, <-12.8184, 16.03966, 21.104>, <-14.00182, 15.8431, 20.4217> }
			triangle { <-12.8184, 16.03966, 21.104>, <-14.4184, 14.2844, 21.6258>, <-14.00182, 15.8431, 20.4217> }
			triangle { <-12.6576, 17.2905, 17.868>, <-14.00182, 15.8431, 20.4217>, <-15.07485, 15.5685, 19.603> }
			triangle { <-14.00182, 15.8431, 20.4217>, <-14.4184, 14.2844, 21.6258>, <-15.07485, 15.5685, 19.603> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-0.3799, 7.2894, 0.6912>, <-0.3985, 7.4388, 0.6929>, 0.4 }
		cylinder { <-0.3985, 7.4388, 0.6929>, <-0.4206, 7.5877, 0.6955>, 0.4 }
		cylinder { <-0.4206, 7.5877, 0.6955>, <-0.4463, 7.736, 0.6991>, 0.4 }
		cylinder { <-0.4463, 7.736, 0.6991>, <-0.4755, 7.8837, 0.7036>, 0.4 }
		cylinder { <-0.4755, 7.8837, 0.7036>, <-0.5082, 8.03062, 0.709>, 0.4 }
		cylinder { <-0.5082, 8.03062, 0.709>, <-0.5444, 8.1766, 0.7153>, 0.4 }
		cylinder { <-0.5444, 8.1766, 0.7153>, <-0.584, 8.3217, 0.7225>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.584, 8.3217, 0.7225>, <-0.5979, 11.06761, 0.6696>, 0.216 }
			cylinder { <-0.5979, 11.06761, 0.6696>, <0.09804, 13.714, 0.4359>, 0.216 }
			cylinder { <0.09804, 13.714, 0.4359>, <1.4534, 16.06944, 0.03835>, 0.216 }
			cylinder { <1.4534, 16.06944, 0.03835>, <3.37, 17.963, -0.4943>, 0.216 }
			cylinder { <3.37, 17.963, -0.4943>, <5.709, 19.2576, -1.1236>, 0.216 }
			cylinder { <5.709, 19.2576, -1.1236>, <8.3009, 19.8595, -1.8037>, 0.216 }
			cylinder { <8.3009, 19.8595, -1.8037>, <10.9579, 19.725, -2.4855>, 0.216 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <10.9579, 19.725, -2.4855>, <8.443, 19.8838, -3.9113>, <10.8153, 21.2615, -5.3619> }
			triangle { <10.9579, 19.725, -2.4855>, <10.8153, 21.2615, -5.3619>, <13.1086, 21.1766, -5.487> }
			triangle { <8.443, 19.8838, -3.9113>, <7.6086, 20.4121, -5.2496>, <10.8153, 21.2615, -5.3619> }
			triangle { <7.6086, 20.4121, -5.2496>, <8.8517, 20.7358, -6.5216>, <10.8153, 21.2615, -5.3619> }
			triangle { <8.8517, 20.7358, -6.5216>, <11.2817, 20.7152, -7.472>, <10.8153, 21.2615, -5.3619> }
			triangle { <11.2817, 20.7152, -7.472>, <13.9652, 20.5538, -8.0789>, <13.1086, 21.1766, -5.487> }
			triangle { <10.8153, 21.2615, -5.3619>, <11.2817, 20.7152, -7.472>, <13.1086, 21.1766, -5.487> }
			triangle { <13.1086, 21.1766, -5.487>, <15.3517, 20.6368, -6.3904>, <15.4545, 20.2279, -4.5644> }
			triangle { <15.3517, 20.6368, -6.3904>, <16.9594, 19.7569, -7.3496>, <17.2825, 19.837, -5.7699> }
			triangle { <15.3517, 20.6368, -6.3904>, <17.2825, 19.837, -5.7699>, <15.4545, 20.2279, -4.5644> }
			triangle { <15.4545, 20.2279, -4.5644>, <17.2825, 19.837, -5.7699>, <17.1454, 19.1731, -4.1554> }
			triangle { <16.9594, 19.7569, -7.3496>, <19.3399, 18.1187, -6.4918>, <17.2825, 19.837, -5.7699> }
			triangle { <17.2825, 19.837, -5.7699>, <19.3399, 18.1187, -6.4918>, <17.1454, 19.1731, -4.1554> }
			triangle { <10.9579, 19.725, -2.4855>, <13.1086, 21.1766, -5.487>, <13.563, 19.7523, -3.09918> }
			triangle { <13.563, 19.7523, -3.09918>, <13.1086, 21.1766, -5.487>, <15.4545, 20.2279, -4.5644> }
			triangle { <13.563, 19.7523, -3.09918>, <15.4545, 20.2279, -4.5644>, <15.582, 19.6501, -3.6172> }
			triangle { <15.4545, 20.2279, -4.5644>, <17.1454, 19.1731, -4.1554>, <15.582, 19.6501, -3.6172> }
			triangle { <13.9652, 20.5538, -8.0789>, <15.3517, 20.6368, -6.3904>, <13.1086, 21.1766, -5.487> }
			triangle { <13.9652, 20.5538, -8.0789>, <16.9594, 19.7569, -7.3496>, <15.3517, 20.6368, -6.3904> }
			triangle { <12.2146, 19.2461, 0.4886>, <9.2899, 18.6639, -0.3701>, <10.9579, 19.725, -2.4855> }
			triangle { <14.3238, 19.4264, -0.4062>, <12.2146, 19.2461, 0.4886>, <10.9579, 19.725, -2.4855> }
			triangle { <12.2146, 19.2461, 0.4886>, <9.1552, 18.1846, 1.2168>, <9.2899, 18.6639, -0.3701> }
			triangle { <12.2146, 19.2461, 0.4886>, <10.8401, 17.8718, 1.7923>, <9.1552, 18.1846, 1.2168> }
			triangle { <12.2146, 19.2461, 0.4886>, <13.4174, 17.639, 1.4578>, <10.8401, 17.8718, 1.7923> }
			triangle { <14.3238, 19.4264, -0.4062>, <16.06408, 17.5306, 0.6969>, <13.4174, 17.639, 1.4578> }
			triangle { <14.3238, 19.4264, -0.4062>, <13.4174, 17.639, 1.4578>, <12.2146, 19.2461, 0.4886> }
			triangle { <15.9331, 19.5384, -2.5629>, <16.713, 19.3338, -0.8284>, <14.3238, 19.4264, -0.4062> }
			triangle { <18.0086, 18.6972, -2.7154>, <18.3586, 17.7415, -1.499>, <16.713, 19.3338, -0.8284> }
			triangle { <15.9331, 19.5384, -2.5629>, <18.0086, 18.6972, -2.7154>, <16.713, 19.3338, -0.8284> }
			triangle { <17.1454, 19.1731, -4.1554>, <18.0086, 18.6972, -2.7154>, <15.9331, 19.5384, -2.5629> }
			triangle { <18.0086, 18.6972, -2.7154>, <19.9394, 17.3491, -4.003725>, <18.3586, 17.7415, -1.499> }
			triangle { <17.1454, 19.1731, -4.1554>, <19.9394, 17.3491, -4.003725>, <18.0086, 18.6972, -2.7154> }
			triangle { <13.563, 19.7523, -3.09918>, <14.3238, 19.4264, -0.4062>, <10.9579, 19.725, -2.4855> }
			triangle { <15.9331, 19.5384, -2.5629>, <14.3238, 19.4264, -0.4062>, <13.563, 19.7523, -3.09918> }
			triangle { <15.582, 19.6501, -3.6172>, <15.9331, 19.5384, -2.5629>, <13.563, 19.7523, -3.09918> }
			triangle { <15.582, 19.6501, -3.6172>, <17.1454, 19.1731, -4.1554>, <15.9331, 19.5384, -2.5629> }
			triangle { <14.3238, 19.4264, -0.4062>, <16.713, 19.3338, -0.8284>, <16.06408, 17.5306, 0.6969> }
			triangle { <16.713, 19.3338, -0.8284>, <18.3586, 17.7415, -1.499>, <16.06408, 17.5306, 0.6969> }
			triangle { <17.1454, 19.1731, -4.1554>, <19.3399, 18.1187, -6.4918>, <19.7256, 17.7693, -5.2561> }
			triangle { <19.3399, 18.1187, -6.4918>, <20.7507, 16.2852, -6.01257>, <19.7256, 17.7693, -5.2561> }
			triangle { <17.1454, 19.1731, -4.1554>, <19.7256, 17.7693, -5.2561>, <19.9394, 17.3491, -4.003725> }
			triangle { <19.7256, 17.7693, -5.2561>, <20.7507, 16.2852, -6.01257>, <19.9394, 17.3491, -4.003725> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
scale 1.054
} // end violet

#declare Plant6 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.1658, 3.8287, 0.08866>, 0.5 }
		cylinder { <0.1658, 3.8287, 0.08866>, <0.4972, 7.6435, 0.2657>, 0.5 }
		cylinder { <0.4972, 7.6435, 0.2657>, <0.9933, 11.4354, 0.5309>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // internode
		cylinder { <0.9933, 11.4354, 0.5309>, <1.2659, 15.2427, 0.1776>, 0.5 }
		cylinder { <1.2659, 15.2427, 0.1776>, <1.307, 18.9532, -0.7837>, 0.5 }
		cylinder { <1.307, 18.9532, -0.7837>, <1.1154, 22.4579, -2.3249>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.1154, 22.4579, -2.3249>, <1.1004, 22.5842, -2.4028>, 0.9729 }
			cylinder { <1.1004, 22.5842, -2.4028>, <1.07808, 22.6977, -2.497>, 0.9729 }
			cylinder { <1.07808, 22.6977, -2.497>, <1.04897, 22.7959, -2.6055>, 0.9729 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <1.04897, 22.7959, -2.6055>, <-1.7833, 28.4271, -6.9648>, <-0.5247, 28.1702, -7.6585> }
			triangle { <-0.5247, 28.1702, -7.6585>, <1.3373, 28.1382, -8.3105>, <1.04897, 22.7959, -2.6055> }
			triangle { <-1.7833, 28.4271, -6.9648>, <-2.3451, 32.07238, -10.03839>, <-0.5247, 28.1702, -7.6585> }
			triangle { <-0.5247, 28.1702, -7.6585>, <-2.3451, 32.07238, -10.03839>, <-0.9959, 31.9575, -10.5046> }
			triangle { <-0.5247, 28.1702, -7.6585>, <-0.9959, 31.9575, -10.5046>, <0.5225, 31.805, -11.2967> }
			triangle { <-0.5247, 28.1702, -7.6585>, <0.5225, 31.805, -11.2967>, <1.3373, 28.1382, -8.3105> }
			triangle { <-2.3451, 32.07238, -10.03839>, <-2.2388, 33.6342, -16.1638>, <-0.9959, 31.9575, -10.5046> }
			triangle { <-0.9959, 31.9575, -10.5046>, <-2.2388, 33.6342, -16.1638>, <0.5225, 31.805, -11.2967> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.1154, 22.4579, -2.3249>, <0.6854, 26.1451, -3.2808>, 0.5 }
		cylinder { <0.6854, 26.1451, -3.2808>, <0.02973, 29.9064, -3.6234>, 0.5 }
		cylinder { <0.02973, 29.9064, -3.6234>, <-0.8324, 33.6309, -3.3425>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.8324, 33.6309, -3.3425>, <-0.873, 33.7702, -3.3076>, 0.9729 }
			cylinder { <-0.873, 33.7702, -3.3076>, <-0.9195, 33.8996, -3.2498>, 0.9729 }
			cylinder { <-0.9195, 33.8996, -3.2498>, <-0.9704, 34.01554, -3.1708>, 0.9729 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-0.9704, 34.01554, -3.1708>, <-1.81, 40.5929, 0.672>, <-3.2096, 40.2278, 0.4741> }
			triangle { <-3.2096, 40.2278, 0.4741>, <-5.05537, 39.9751, -0.1763>, <-0.9704, 34.01554, -3.1708> }
			triangle { <-1.81, 40.5929, 0.672>, <-3.4912, 44.6725, 2.5643>, <-3.2096, 40.2278, 0.4741> }
			triangle { <-3.2096, 40.2278, 0.4741>, <-3.4912, 44.6725, 2.5643>, <-4.8208, 44.3992, 2.1079> }
			triangle { <-3.2096, 40.2278, 0.4741>, <-4.8208, 44.3992, 2.1079>, <-6.4871, 44.106, 1.8014> }
			triangle { <-3.2096, 40.2278, 0.4741>, <-6.4871, 44.106, 1.8014>, <-5.05537, 39.9751, -0.1763> }
			triangle { <-3.4912, 44.6725, 2.5643>, <-7.5505, 47.03163, 6.7984>, <-4.8208, 44.3992, 2.1079> }
			triangle { <-4.8208, 44.3992, 2.1079>, <-7.5505, 47.03163, 6.7984>, <-6.4871, 44.106, 1.8014> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-0.8324, 33.6309, -3.3425>, <-1.4547, 37.4107, -3.1994>, 0.5 }
		cylinder { <-1.4547, 37.4107, -3.1994>, <-1.8336, 41.2253, -3.195>, 0.5 }
		cylinder { <-1.8336, 41.2253, -3.195>, <-1.9672, 45.05398, -3.3293>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.9672, 45.05398, -3.3293>, <-1.9501, 45.2011, -3.3469>, 0.9729 }
			cylinder { <-1.9501, 45.2011, -3.3469>, <-1.9112, 45.342, -3.3765>, 0.9729 }
			cylinder { <-1.9112, 45.342, -3.3765>, <-1.8516, 45.4726, -3.4171>, 0.9729 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-1.8516, 45.4726, -3.4171>, <-0.3652, 52.3045, -6.5559>, <0.6033, 52.3047, -5.4636> }
			triangle { <0.6033, 52.3047, -5.4636>, <1.5716, 52.4967, -3.755>, <-1.8516, 45.4726, -3.4171> }
			triangle { <-0.3652, 52.3045, -6.5559>, <1.07304, 56.8094, -7.3848>, <0.6033, 52.3047, -5.4636> }
			triangle { <0.6033, 52.3047, -5.4636>, <1.07304, 56.8094, -7.3848>, <1.8009, 56.8607, -6.1525> }
			triangle { <0.6033, 52.3047, -5.4636>, <1.8009, 56.8607, -6.1525>, <2.8734, 56.9921, -4.815> }
			triangle { <0.6033, 52.3047, -5.4636>, <2.8734, 56.9921, -4.815>, <1.5716, 52.4967, -3.755> }
			triangle { <1.07304, 56.8094, -7.3848>, <6.1659, 60.4528, -8.2561>, <1.8009, 56.8607, -6.1525> }
			triangle { <1.8009, 56.8607, -6.1525>, <6.1659, 60.4528, -8.2561>, <2.8734, 56.9921, -4.815> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-1.9672, 45.05398, -3.3293>, <-2.5569, 48.8342, -3.5664>, 0.5 }
		cylinder { <-2.5569, 48.8342, -3.5664>, <-3.594, 52.5092, -3.9029>, 0.5 }
		cylinder { <-3.594, 52.5092, -3.9029>, <-5.06281, 56.02376, -4.3336>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.06281, 56.02376, -4.3336>, <-5.1389, 56.1503, -4.3544>, 0.9729 }
			cylinder { <-5.1389, 56.1503, -4.3544>, <-5.2324, 56.2639, -4.3788>, 0.9729 }
			cylinder { <-5.2324, 56.2639, -4.3788>, <-5.3413, 56.3621, -4.4063>, 0.9729 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-5.3413, 56.3621, -4.4063>, <-10.6512, 61.8738, -4.003622>, <-10.5472, 61.7192, -5.4515> }
			triangle { <-10.5472, 61.7192, -5.4515>, <-10.08582, 61.8299, -7.3669>, <-5.3413, 56.3621, -4.4063> }
			triangle { <-10.6512, 61.8738, -4.003622>, <-13.6111, 65.535, -4.9444>, <-10.5472, 61.7192, -5.4515> }
			triangle { <-10.5472, 61.7192, -5.4515>, <-13.6111, 65.535, -4.9444>, <-13.2697, 65.5236, -6.3352> }
			triangle { <-10.5472, 61.7192, -5.4515>, <-13.2697, 65.5236, -6.3352>, <-13.1097, 65.4932, -8.04693> }
			triangle { <-10.5472, 61.7192, -5.4515>, <-13.1097, 65.4932, -8.04693>, <-10.08582, 61.8299, -7.3669> }
			triangle { <-13.6111, 65.535, -4.9444>, <-18.732, 67.2284, -8.2429>, <-13.2697, 65.5236, -6.3352> }
			triangle { <-13.2697, 65.5236, -6.3352>, <-18.732, 67.2284, -8.2429>, <-13.1097, 65.4932, -8.04693> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-5.06281, 56.02376, -4.3336>, <-6.3824, 59.6169, -4.538>, 0.5 }
		cylinder { <-6.3824, 59.6169, -4.538>, <-7.5457, 63.2694, -4.5151>, 0.5 }
		cylinder { <-7.5457, 63.2694, -4.5151>, <-8.5464, 66.9614, -4.2649>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.5464, 66.9614, -4.2649>, <-8.5699, 67.1056, -4.2348>, 0.9729 }
			cylinder { <-8.5699, 67.1056, -4.2348>, <-8.5771, 67.2461, -4.1853>, 0.9729 }
			cylinder { <-8.5771, 67.2461, -4.1853>, <-8.5678, 67.3788, -4.1178>, 0.9729 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-8.5678, 67.3788, -4.1178>, <-7.319, 74.718, -2.2978>, <-8.2403, 74.3394, -1.2305> }
			triangle { <-8.2403, 74.3394, -1.2305>, <-9.8022, 73.965, -0.08424>, <-8.5678, 67.3788, -4.1178> }
			triangle { <-7.319, 74.718, -2.2978>, <-7.6205, 79.1681, -0.5214>, <-8.2403, 74.3394, -1.2305> }
			triangle { <-8.2403, 74.3394, -1.2305>, <-7.6205, 79.1681, -0.5214>, <-8.7189, 78.813, 0.3262> }
			triangle { <-8.2403, 74.3394, -1.2305>, <-8.7189, 78.813, 0.3262>, <-9.8978, 78.4817, 1.5332> }
			triangle { <-8.2403, 74.3394, -1.2305>, <-9.8978, 78.4817, 1.5332>, <-9.8022, 73.965, -0.08424> }
			triangle { <-7.6205, 79.1681, -0.5214>, <-7.1925, 82.5744, 4.7875>, <-8.7189, 78.813, 0.3262> }
			triangle { <-8.7189, 78.813, 0.3262>, <-7.1925, 82.5744, 4.7875>, <-9.8978, 78.4817, 1.5332> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-8.5464, 66.9614, -4.2649>, <-9.512, 70.669, -4.389>, 0.5 }
		cylinder { <-9.512, 70.669, -4.389>, <-10.4332, 74.3567, -4.8861>, 0.5 }
		cylinder { <-10.4332, 74.3567, -4.8861>, <-11.301, 77.9888, -5.7514>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.301, 77.9888, -5.7514>, <-11.3304, 78.1231, -5.8092>, 0.9729 }
			cylinder { <-11.3304, 78.1231, -5.8092>, <-11.3545, 78.2465, -5.8897>, 0.9729 }
			cylinder { <-11.3545, 78.2465, -5.8897>, <-11.3726, 78.3552, -5.9902>, 0.9729 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-11.3726, 78.3552, -5.9902>, <-14.09958, 83.8808, -10.5473>, <-12.6652, 84.1147, -10.6859> }
			triangle { <-12.6652, 84.1147, -10.6859>, <-10.7904, 84.7065, -10.5171>, <-11.3726, 78.3552, -5.9902> }
			triangle { <-14.09958, 83.8808, -10.5473>, <-14.6613, 87.84, -13.2042>, <-12.6652, 84.1147, -10.6859> }
			triangle { <-12.6652, 84.1147, -10.6859>, <-14.6613, 87.84, -13.2042>, <-13.2755, 88.1811, -13.08541> }
			triangle { <-12.6652, 84.1147, -10.6859>, <-13.2755, 88.1811, -13.08541>, <-11.612, 88.6018, -13.1963> }
			triangle { <-12.6652, 84.1147, -10.6859>, <-11.612, 88.6018, -13.1963>, <-10.7904, 84.7065, -10.5171> }
			triangle { <-14.6613, 87.84, -13.2042>, <-12.8656, 90.6784, -18.5606>, <-13.2755, 88.1811, -13.08541> }
			triangle { <-13.2755, 88.1811, -13.08541>, <-12.8656, 90.6784, -18.5606>, <-11.612, 88.6018, -13.1963> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-11.301, 77.9888, -5.7514>, <-12.3807, 81.6036, -6.431>, 0.5 }
		cylinder { <-12.3807, 81.6036, -6.431>, <-13.6662, 85.1815, -6.9213>, 0.5 }
		cylinder { <-13.6662, 85.1815, -6.9213>, <-15.1508, 88.7031, -7.2195>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-15.1508, 88.7031, -7.2195>, <-15.223, 88.8336, -7.216>, 0.9729 }
			cylinder { <-15.223, 88.8336, -7.216>, <-15.3083, 88.9546, -7.1975>, 0.9729 }
			cylinder { <-15.3083, 88.9546, -7.1975>, <-15.4046, 89.06367, -7.1644>, 0.9729 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-15.4046, 89.06367, -7.1644>, <-18.8015, 95.5008, -4.7645>, <-19.8438, 94.9671, -5.6362> }
			triangle { <-19.8438, 94.9671, -5.6362>, <-21.03786, 94.4892, -7.1328>, <-15.4046, 89.06367, -7.1644> }
			triangle { <-18.8015, 95.5008, -4.7645>, <-21.6321, 99.3504, -4.2975>, <-19.8438, 94.9671, -5.6362> }
			triangle { <-19.8438, 94.9671, -5.6362>, <-21.6321, 99.3504, -4.2975>, <-22.4893, 98.9155, -5.3592> }
			triangle { <-19.8438, 94.9671, -5.6362>, <-22.4893, 98.9155, -5.3592>, <-23.7077, 98.4204, -6.4667> }
			triangle { <-19.8438, 94.9671, -5.6362>, <-23.7077, 98.4204, -6.4667>, <-21.03786, 94.4892, -7.1328> }
			triangle { <-21.6321, 99.3504, -4.2975>, <-27.5246, 101.2092, -2.9576>, <-22.4893, 98.9155, -5.3592> }
			triangle { <-22.4893, 98.9155, -5.3592>, <-27.5246, 101.2092, -2.9576>, <-23.7077, 98.4204, -6.4667> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-15.1508, 88.7031, -7.2195>, <-15.9174, 92.4465, -7.5265>, 0.5 }
		cylinder { <-15.9174, 92.4465, -7.5265>, <-15.9365, 96.2677, -7.8306>, 0.5 }
		cylinder { <-15.9365, 96.2677, -7.8306>, <-15.2076, 100.02, -8.1199>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-15.2076, 100.02, -8.1199>, <-15.1546, 100.159, -8.1303>, 0.9729 }
			cylinder { <-15.1546, 100.159, -8.1303>, <-15.07856, 100.2871, -8.1395>, 0.9729 }
			cylinder { <-15.07856, 100.2871, -8.1395>, <-14.9816, 100.4002, -8.1473>, 0.9729 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-14.9816, 100.4002, -8.1473>, <-10.7493, 106.423, -10.2802>, <-10.5046, 106.4308, -8.841> }
			triangle { <-10.5046, 106.4308, -8.841>, <-10.5387, 106.7126, -6.8883>, <-14.9816, 100.4002, -8.1473> }
			triangle { <-10.7493, 106.423, -10.2802>, <-8.2156, 110.4995, -10.3935>, <-10.5046, 106.4308, -8.841> }
			triangle { <-10.5046, 106.4308, -8.841>, <-8.2156, 110.4995, -10.3935>, <-8.2332, 110.613, -8.9659> }
			triangle { <-10.5046, 106.4308, -8.841>, <-8.2332, 110.613, -8.9659>, <-8.001753, 110.7678, -7.2692> }
			triangle { <-10.5046, 106.4308, -8.841>, <-8.001753, 110.7678, -7.2692>, <-10.5387, 106.7126, -6.8883> }
			triangle { <-8.2156, 110.4995, -10.3935>, <-2.7886, 113.1776, -8.564>, <-8.2332, 110.613, -8.9659> }
			triangle { <-8.2332, 110.613, -8.9659>, <-2.7886, 113.1776, -8.564>, <-8.001753, 110.7678, -7.2692> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-15.2076, 100.02, -8.1199>, <-14.9606, 103.7737, -8.8568>, 0.5 }
		cylinder { <-14.9606, 103.7737, -8.8568>, <-15.2029, 107.4184, -10.01964>, 0.5 }
		cylinder { <-15.2029, 107.4184, -10.01964>, <-15.9274, 110.8467, -11.574>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-15.9274, 110.8467, -11.574>, <-15.9735, 110.9677, -11.648>, 0.9729 }
			cylinder { <-15.9735, 110.9677, -11.648>, <-16.03628, 111.0729, -11.7332>, 0.9729 }
			cylinder { <-16.03628, 111.0729, -11.7332>, <-16.1137, 111.159, -11.8273>, 0.9729 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-16.1137, 111.159, -11.8273>, <-20.6773, 116.405, -15.05054>, <-19.9096, 115.9776, -16.2164> }
			triangle { <-19.9096, 115.9776, -16.2164>, <-18.5923, 115.7354, -17.6654>, <-16.1137, 111.159, -11.8273> }
			triangle { <-20.6773, 116.405, -15.05054>, <-22.6385, 119.6806, -17.9616>, <-19.9096, 115.9776, -16.2164> }
			triangle { <-19.9096, 115.9776, -16.2164>, <-22.6385, 119.6806, -17.9616>, <-21.6813, 119.4151, -18.9932> }
			triangle { <-19.9096, 115.9776, -16.2164>, <-21.6813, 119.4151, -18.9932>, <-20.7329, 119.0608, -20.383> }
			triangle { <-19.9096, 115.9776, -16.2164>, <-20.7329, 119.0608, -20.383>, <-18.5923, 115.7354, -17.6654> }
			triangle { <-22.6385, 119.6806, -17.9616>, <-25.4918, 120.4758, -23.547>, <-21.6813, 119.4151, -18.9932> }
			triangle { <-21.6813, 119.4151, -18.9932>, <-25.4918, 120.4758, -23.547>, <-20.7329, 119.0608, -20.383> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-15.9274, 110.8467, -11.574>, <-16.5967, 114.4776, -12.6051>, 0.5 }
		cylinder { <-16.5967, 114.4776, -12.6051>, <-17.1962, 118.2325, -13.09035>, 0.5 }
		cylinder { <-17.1962, 118.2325, -13.09035>, <-17.7131, 122.0302, -13.01933>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-17.7131, 122.0302, -13.01933>, <-17.7287, 122.1738, -12.9918>, 0.9592 }
			cylinder { <-17.7287, 122.1738, -12.9918>, <-17.7396, 122.3112, -12.9403>, 0.9592 }
			cylinder { <-17.7396, 122.3112, -12.9403>, <-17.7455, 122.4382, -12.8663>, 0.9592 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-17.7455, 122.4382, -12.8663>, <-16.6155, 129.4107, -10.1819>, <-17.9184, 129.1346, -9.636> }
			triangle { <-17.9184, 129.1346, -9.636>, <-19.822, 128.9429, -9.2826>, <-17.7455, 122.4382, -12.8663> }
			triangle { <-16.6155, 129.4107, -10.1819>, <-17.1502, 133.7589, -8.3889>, <-17.9184, 129.1346, -9.636> }
			triangle { <-17.9184, 129.1346, -9.636>, <-17.1502, 133.7589, -8.3889>, <-18.516, 133.5333, -8.1101> }
			triangle { <-17.9184, 129.1346, -9.636>, <-18.516, 133.5333, -8.1101>, <-20.1006, 133.3334, -7.5418> }
			triangle { <-17.9184, 129.1346, -9.636>, <-20.1006, 133.3334, -7.5418>, <-19.822, 128.9429, -9.2826> }
			triangle { <-17.1502, 133.7589, -8.3889>, <-18.6235, 136.9144, -3.2188>, <-18.516, 133.5333, -8.1101> }
			triangle { <-18.516, 133.5333, -8.1101>, <-18.6235, 136.9144, -3.2188>, <-20.1006, 133.3334, -7.5418> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-17.7131, 122.0302, -13.01933>, <-18.1276, 125.84, -13.1057>, 0.5 }
		cylinder { <-18.1276, 125.84, -13.1057>, <-18.4389, 129.653, -13.3493>, 0.5 }
		cylinder { <-18.4389, 129.653, -13.3493>, <-18.646, 133.4597, -13.7495>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-18.646, 133.4597, -13.7495>, <-18.6423, 133.5882, -13.7792>, 0.8607 }
			cylinder { <-18.6423, 133.5882, -13.7792>, <-18.6279, 133.7115, -13.8242>, 0.8607 }
			cylinder { <-18.6279, 133.7115, -13.8242>, <-18.603, 133.8267, -13.8835>, 0.8607 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-18.603, 133.8267, -13.8835>, <-18.9831, 139.7317, -17.1931>, <-17.8035, 139.8334, -16.6774> }
			triangle { <-17.8035, 139.8334, -16.6774>, <-16.4081, 140.1393, -15.6741>, <-18.603, 133.8267, -13.8835> }
			triangle { <-18.9831, 139.7317, -17.1931>, <-18.4085, 143.7149, -18.5508>, <-17.8035, 139.8334, -16.6774> }
			triangle { <-17.8035, 139.8334, -16.6774>, <-18.4085, 143.7149, -18.5508>, <-17.3732, 143.8599, -17.8352> }
			triangle { <-17.8035, 139.8334, -16.6774>, <-17.3732, 143.8599, -17.8352>, <-16.02763, 144.0954, -17.166> }
			triangle { <-17.8035, 139.8334, -16.6774>, <-16.02763, 144.0954, -17.166>, <-16.4081, 140.1393, -15.6741> }
			triangle { <-18.4085, 143.7149, -18.5508>, <-14.8676, 147.0827, -21.2716>, <-17.3732, 143.8599, -17.8352> }
			triangle { <-17.3732, 143.8599, -17.8352>, <-14.8676, 147.0827, -21.2716>, <-16.02763, 144.0954, -17.166> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-18.646, 133.4597, -13.7495>, <-19.1257, 137.2486, -14.07899>, 0.5 }
		cylinder { <-19.1257, 137.2486, -14.07899>, <-19.8754, 140.9991, -14.3358>, 0.5 }
		cylinder { <-19.8754, 140.9991, -14.3358>, <-20.891, 144.6909, -14.5186>, 0.5 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-20.891, 144.6909, -14.5186>, <-20.9277, 144.7702, -14.5188>, 0.5695 }
			cylinder { <-20.9277, 144.7702, -14.5188>, <-20.977, 144.8422, -14.5149>, 0.5695 }
			cylinder { <-20.977, 144.8422, -14.5149>, <-21.03731, 144.9049, -14.5072>, 0.5695 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-21.03731, 144.9049, -14.5072>, <-23.4637, 148.4802, -13.2995>, <-23.8235, 148.3003, -14.05359> }
			triangle { <-23.8235, 148.3003, -14.05359>, <-24.1233, 148.2224, -15.1664>, <-21.03731, 144.9049, -14.5072> }
			triangle { <-23.4637, 148.4802, -13.2995>, <-25.1255, 150.7467, -13.2696>, <-23.8235, 148.3003, -14.05359> }
			triangle { <-23.8235, 148.3003, -14.05359>, <-25.1255, 150.7467, -13.2696>, <-25.3429, 150.6366, -14.07183> }
			triangle { <-23.8235, 148.3003, -14.05359>, <-25.3429, 150.6366, -14.07183>, <-25.7443, 150.5095, -14.9861> }
			triangle { <-23.8235, 148.3003, -14.05359>, <-25.7443, 150.5095, -14.9861>, <-24.1233, 148.2224, -15.1664> }
			triangle { <-25.1255, 150.7467, -13.2696>, <-28.6223, 151.8869, -13.6829>, <-25.3429, 150.6366, -14.07183> }
			triangle { <-25.3429, 150.6366, -14.07183>, <-28.6223, 151.8869, -13.6829>, <-25.7443, 150.5095, -14.9861> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-20.891, 144.6909, -14.5186>, <-20.9524, 146.92, -14.3523>, 0.2916 }
		cylinder { <-20.9524, 146.92, -14.3523>, <-20.4782, 149.0631, -13.9251>, 0.2916 }
		cylinder { <-20.4782, 149.0631, -13.9251>, <-19.5029, 150.965, -13.2679>, 0.2916 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-19.5029, 150.965, -13.2679>, <-19.4856, 150.9879, -13.2572>, 0.2 }
			cylinder { <-19.4856, 150.9879, -13.2572>, <-19.465, 151.0071, -13.2451>, 0.2 }
			cylinder { <-19.465, 151.0071, -13.2451>, <-19.4415, 151.0219, -13.232>, 0.2 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		mesh { // leaf
			triangle { <-19.4415, 151.0219, -13.232>, <-18.1947, 151.9326, -12.9186>, <-18.2865, 151.8701, -12.6398> }
			triangle { <-18.2865, 151.8701, -12.6398>, <-18.4619, 151.8632, -12.2741>, <-19.4415, 151.0219, -13.232> }
			triangle { <-18.1947, 151.9326, -12.9186>, <-17.534, 152.5297, -12.4932>, <-18.2865, 151.8701, -12.6398> }
			triangle { <-18.2865, 151.8701, -12.6398>, <-17.534, 152.5297, -12.4932>, <-17.6656, 152.5065, -12.2309> }
			triangle { <-18.2865, 151.8701, -12.6398>, <-17.6656, 152.5065, -12.2309>, <-17.7765, 152.4647, -11.8979> }
			triangle { <-18.2865, 151.8701, -12.6398>, <-17.7765, 152.4647, -11.8979>, <-18.4619, 151.8632, -12.2741> }
			triangle { <-17.534, 152.5297, -12.4932>, <-16.6174, 152.5916, -11.5739>, <-17.6656, 152.5065, -12.2309> }
			triangle { <-17.6656, 152.5065, -12.2309>, <-16.6174, 152.5916, -11.5739>, <-17.7765, 152.4647, -11.8979> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-19.5029, 150.965, -13.2679>, <-16.159, 157.4856, -11.01457>, 0.5 }
			cylinder { <-16.159, 157.4856, -11.01457>, <-12.815, 164.0062, -8.7612>, 0.5 }
			cylinder { <-12.815, 164.0062, -8.7612>, <-9.4711, 170.5268, -6.5079>, 0.5 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-9.9753, 170.0014, -7.8573>, 0.5 }
				cylinder { <-9.9753, 170.0014, -7.8573>, <-10.4795, 169.4759, -9.2066>, 0.5 }
				cylinder { <-10.4795, 169.4759, -9.2066>, <-10.9837, 168.9505, -10.556>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-10.9837, 168.9505, -10.556>, <-11.1284, 168.3908, -12.9498>, <-11.6823, 168.0789, -12.6737> }
					triangle { <-11.1284, 168.3908, -12.9498>, <-12.02799, 167.9873, -14.7042>, <-11.6823, 168.0789, -12.6737> }
					triangle { <-11.6823, 168.0789, -12.6737>, <-12.02799, 167.9873, -14.7042>, <-12.3641, 167.5502, -14.4085> }
					triangle { <-12.02799, 167.9873, -14.7042>, <-13.6663, 168.2107, -15.7995>, <-12.3641, 167.5502, -14.4085> }
					triangle { <-13.6663, 168.2107, -15.7995>, <-13.01042, 167.4024, -14.1094>, <-12.3641, 167.5502, -14.4085> }
					triangle { <-13.01042, 167.4024, -14.1094>, <-11.6823, 168.0789, -12.6737>, <-12.3641, 167.5502, -14.4085> }
					triangle { <-13.01042, 167.4024, -14.1094>, <-12.07221, 167.716, -12.3867>, <-11.6823, 168.0789, -12.6737> }
					triangle { <-11.6823, 168.0789, -12.6737>, <-12.07221, 167.716, -12.3867>, <-10.9837, 168.9505, -10.556> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-9.648, 169.9374, -7.9123>, 0.5 }
				cylinder { <-9.648, 169.9374, -7.9123>, <-9.8248, 169.348, -9.3167>, 0.5 }
				cylinder { <-9.8248, 169.348, -9.3167>, <-10.00177, 168.7586, -10.7212>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-10.00177, 168.7586, -10.7212>, <-9.6152, 168.1508, -13.07616>, <-10.1849, 167.7951, -12.9053> }
					triangle { <-9.6152, 168.1508, -13.07616>, <-10.107, 167.6413, -14.9599>, <-10.1849, 167.7951, -12.9053> }
					triangle { <-10.1849, 167.7951, -12.9053>, <-10.107, 167.6413, -14.9599>, <-10.4575, 167.1806, -14.7224> }
					triangle { <-10.107, 167.6413, -14.9599>, <-11.505, 167.7003, -16.3655>, <-10.4575, 167.1806, -14.7224> }
					triangle { <-11.505, 167.7003, -16.3655>, <-11.1359, 166.9803, -14.5529>, <-10.4575, 167.1806, -14.7224> }
					triangle { <-11.1359, 166.9803, -14.5529>, <-10.1849, 167.7951, -12.9053>, <-10.4575, 167.1806, -14.7224> }
					triangle { <-11.1359, 166.9803, -14.5529>, <-10.5924, 167.4033, -12.6896>, <-10.1849, 167.7951, -12.9053> }
					triangle { <-10.1849, 167.7951, -12.9053>, <-10.5924, 167.4033, -12.6896>, <-10.00177, 168.7586, -10.7212> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-9.3493, 169.9045, -7.904>, 0.5 }
				cylinder { <-9.3493, 169.9045, -7.904>, <-9.2275, 169.2823, -9.3>, 0.5 }
				cylinder { <-9.2275, 169.2823, -9.3>, <-9.1057, 168.66, -10.6961>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-9.1057, 168.66, -10.6961>, <-8.2601, 168.05, -12.9271>, <-8.8227, 167.6528, -12.8497> }
					triangle { <-8.2601, 168.05, -12.9271>, <-8.3676, 167.4753, -14.8528>, <-8.8227, 167.6528, -12.8497> }
					triangle { <-8.8227, 167.6528, -12.8497>, <-8.3676, 167.4753, -14.8528>, <-8.7192, 166.9919, -14.668> }
					triangle { <-8.3676, 167.4753, -14.8528>, <-9.4924, 167.4025, -16.4847>, <-8.7192, 166.9919, -14.668> }
					triangle { <-9.4924, 167.4025, -16.4847>, <-9.3998, 166.7409, -14.6155>, <-8.7192, 166.9919, -14.668> }
					triangle { <-9.3998, 166.7409, -14.6155>, <-8.8227, 167.6528, -12.8497>, <-8.7192, 166.9919, -14.668> }
					triangle { <-9.3998, 166.7409, -14.6155>, <-9.2314, 167.2332, -12.6983>, <-8.8227, 167.6528, -12.8497> }
					triangle { <-8.8227, 167.6528, -12.8497>, <-9.2314, 167.2332, -12.6983>, <-9.1057, 168.66, -10.6961> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-9.01952, 169.8962, -7.8305>, 0.5 }
				cylinder { <-9.01952, 169.8962, -7.8305>, <-8.5678, 169.2655, -9.1532>, 0.5 }
				cylinder { <-8.5678, 169.2655, -9.1532>, <-8.1162, 168.6349, -10.4759>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-8.1162, 168.6349, -10.4759>, <-6.7915, 168.0682, -12.473>, <-7.3227, 167.6235, -12.4957> }
					triangle { <-6.7915, 168.0682, -12.473>, <-6.4614, 167.4561, -14.3615>, <-7.3227, 167.6235, -12.4957> }
					triangle { <-7.3227, 167.6235, -12.4957>, <-6.4614, 167.4561, -14.3615>, <-6.8009, 166.9461, -14.2342> }
					triangle { <-6.4614, 167.4561, -14.3615>, <-7.2256, 167.2576, -16.1809>, <-6.8009, 166.9461, -14.2342> }
					triangle { <-7.2256, 167.2576, -16.1809>, <-7.4545, 166.6362, -14.3097>, <-6.8009, 166.9461, -14.2342> }
					triangle { <-7.4545, 166.6362, -14.3097>, <-7.3227, 167.6235, -12.4957>, <-6.8009, 166.9461, -14.2342> }
					triangle { <-7.4545, 166.6362, -14.3097>, <-7.7166, 167.1715, -12.4147>, <-7.3227, 167.6235, -12.4957> }
					triangle { <-7.3227, 167.6235, -12.4957>, <-7.7166, 167.1715, -12.4147>, <-8.1162, 168.6349, -10.4759> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-8.7442, 169.9145, -7.7111>, 0.5 }
				cylinder { <-8.7442, 169.9145, -7.7111>, <-8.0174, 169.3022, -8.9144>, 0.5 }
				cylinder { <-8.0174, 169.3022, -8.9144>, <-7.2905, 168.6898, -10.1176>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.2905, 168.6898, -10.1176>, <-5.5915, 168.2004, -11.8318>, <-6.07499, 167.7148, -11.9353> }
					triangle { <-5.5915, 168.2004, -11.8318>, <-4.8841, 167.5886, -13.6137>, <-6.07499, 167.7148, -11.9353> }
					triangle { <-6.07499, 167.7148, -11.9353>, <-4.8841, 167.5886, -13.6137>, <-5.2014, 167.0553, -13.534> }
					triangle { <-4.8841, 167.5886, -13.6137>, <-5.2938, 167.3033, -15.5332>, <-5.2014, 167.0553, -13.534> }
					triangle { <-5.2938, 167.3033, -15.5332>, <-5.8058, 166.6935, -13.715>, <-5.2014, 167.0553, -13.534> }
					triangle { <-5.8058, 166.6935, -13.715>, <-6.07499, 167.7148, -11.9353>, <-5.2014, 167.0553, -13.534> }
					triangle { <-5.8058, 166.6935, -13.715>, <-6.4418, 167.2342, -11.9124>, <-6.07499, 167.7148, -11.9353> }
					triangle { <-6.07499, 167.7148, -11.9353>, <-6.4418, 167.2342, -11.9124>, <-7.2905, 168.6898, -10.1176> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-8.4685, 169.9631, -7.5218>, 0.5 }
				cylinder { <-8.4685, 169.9631, -7.5218>, <-7.4658, 169.3994, -8.5358>, 0.5 }
				cylinder { <-7.4658, 169.3994, -8.5358>, <-6.4632, 168.8358, -9.5497>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-6.4632, 168.8358, -9.5497>, <-4.4195, 168.4734, -10.8751>, <-4.8296, 167.9449, -11.05647> }
					triangle { <-4.4195, 168.4734, -10.8751>, <-3.3198, 167.8994, -12.4598>, <-4.8296, 167.9449, -11.05647> }
					triangle { <-4.8296, 167.9449, -11.05647>, <-3.3198, 167.8994, -12.4598>, <-3.6005, 167.3412, -12.427> }
					triangle { <-3.3198, 167.8994, -12.4598>, <-3.3103, 167.5487, -14.4119>, <-3.6005, 167.3412, -12.427> }
					triangle { <-3.3103, 167.5487, -14.4119>, <-4.1235, 166.924, -12.7123>, <-3.6005, 167.3412, -12.427> }
					triangle { <-4.1235, 166.924, -12.7123>, <-4.8296, 167.9449, -11.05647>, <-3.6005, 167.3412, -12.427> }
					triangle { <-4.1235, 166.924, -12.7123>, <-5.1517, 167.4339, -11.09089>, <-4.8296, 167.9449, -11.05647> }
					triangle { <-4.8296, 167.9449, -11.05647>, <-5.1517, 167.4339, -11.09089>, <-6.4632, 168.8358, -9.5497> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-8.2639, 170.0295, -7.3118>, 0.5 }
				cylinder { <-8.2639, 170.0295, -7.3118>, <-7.05668, 169.5321, -8.1158>, 0.5 }
				cylinder { <-7.05668, 169.5321, -8.1158>, <-5.8494, 169.0348, -8.9198>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-5.8494, 169.0348, -8.9198>, <-3.5805, 168.8161, -9.8517>, <-3.9106, 168.2541, -10.08756> }
					triangle { <-3.5805, 168.8161, -9.8517>, <-2.1753, 168.3077, -11.1997>, <-3.9106, 168.2541, -10.08756> }
					triangle { <-3.9106, 168.2541, -10.08756>, <-2.1753, 168.3077, -11.1997>, <-2.4144, 167.7295, -11.2011> }
					triangle { <-2.1753, 168.3077, -11.1997>, <-1.7908, 167.93, -13.1084>, <-2.4144, 167.7295, -11.2011> }
					triangle { <-1.7908, 167.93, -13.1084>, <-2.8451, 167.2681, -11.5624>, <-2.4144, 167.7295, -11.2011> }
					triangle { <-2.8451, 167.2681, -11.5624>, <-3.9106, 168.2541, -10.08756>, <-2.4144, 167.7295, -11.2011> }
					triangle { <-2.8451, 167.2681, -11.5624>, <-4.1819, 167.7187, -10.1637>, <-3.9106, 168.2541, -10.08756> }
					triangle { <-3.9106, 168.2541, -10.08756>, <-4.1819, 167.7187, -10.1637>, <-5.8494, 169.0348, -8.9198> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-8.08953, 170.1268, -7.03917>, 0.5 }
				cylinder { <-8.08953, 170.1268, -7.03917>, <-6.7079, 169.7268, -7.5704>, 0.5 }
				cylinder { <-6.7079, 169.7268, -7.5704>, <-5.3262, 169.3268, -8.1016>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-5.3262, 169.3268, -8.1016>, <-2.9062, 169.2971, -8.5567>, <-3.1336, 168.7043, -8.8345> }
					triangle { <-2.9062, 169.2971, -8.5567>, <-1.2213, 168.8953, -9.5812>, <-3.1336, 168.7043, -8.8345> }
					triangle { <-3.1336, 168.7043, -8.8345>, <-1.2213, 168.8953, -9.5812>, <-1.4056, 168.2981, -9.6108> }
					triangle { <-1.2213, 168.8953, -9.5812>, <-0.431, 168.5237, -11.3619>, <-1.4056, 168.2981, -9.6108> }
					triangle { <-0.431, 168.5237, -11.3619>, <-1.7145, 167.7944, -10.03496>, <-1.4056, 168.2981, -9.6108> }
					triangle { <-1.7145, 167.7944, -10.03496>, <-3.1336, 168.7043, -8.8345>, <-1.4056, 168.2981, -9.6108> }
					triangle { <-1.7145, 167.7944, -10.03496>, <-3.3379, 168.1457, -8.9453>, <-3.1336, 168.7043, -8.8345> }
					triangle { <-3.1336, 168.7043, -8.8345>, <-3.3379, 168.1457, -8.9453>, <-5.3262, 169.3268, -8.1016> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-7.9906, 170.2298, -6.7746>, 0.5 }
				cylinder { <-7.9906, 170.2298, -6.7746>, <-6.5102, 169.9328, -7.04137>, 0.5 }
				cylinder { <-6.5102, 169.9328, -7.04137>, <-5.02977, 169.6358, -7.3081>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-5.02977, 169.6358, -7.3081>, <-2.5721, 169.7914, -7.3267>, <-2.7009, 169.1784, -7.6233> }
					triangle { <-2.5721, 169.7914, -7.3267>, <-0.7058, 169.5094, -8.02499>, <-2.7009, 169.1784, -7.6233> }
					triangle { <-2.7009, 169.1784, -7.6233>, <-0.7058, 169.5094, -8.02499>, <-0.8363, 168.8991, -8.06965> }
					triangle { <-0.7058, 169.5094, -8.02499>, <0.4155, 169.1753, -9.6264>, <-0.8363, 168.8991, -8.06965> }
					triangle { <0.4155, 169.1753, -9.6264>, <-1.02566, 168.3663, -8.5271>, <-0.8363, 168.8991, -8.06965> }
					triangle { <-1.02566, 168.3663, -8.5271>, <-2.7009, 169.1784, -7.6233>, <-0.8363, 168.8991, -8.06965> }
					triangle { <-1.02566, 168.3663, -8.5271>, <-2.8394, 168.6037, -7.7524>, <-2.7009, 169.1784, -7.6233> }
					triangle { <-2.7009, 169.1784, -7.6233>, <-2.8394, 168.6037, -7.7524>, <-5.02977, 169.6358, -7.3081> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-7.9476, 170.3591, -6.4653>, 0.5 }
				cylinder { <-7.9476, 170.3591, -6.4653>, <-6.424, 170.1914, -6.4227>, 0.5 }
				cylinder { <-6.424, 170.1914, -6.4227>, <-4.9005, 170.0238, -6.3801>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-4.9005, 170.0238, -6.3801>, <-2.5112, 170.3979, -5.9155>, <-2.5256, 169.7713, -6.2112> }
					triangle { <-2.5112, 170.3979, -5.9155>, <-0.5258, 170.2728, -6.2194>, <-2.5256, 169.7713, -6.2112> }
					triangle { <-2.5256, 169.7713, -6.2112>, <-0.5258, 170.2728, -6.2194>, <-0.5926, 169.6527, -6.2688> }
					triangle { <-0.5258, 170.2728, -6.2194>, <0.9183, 170.0153, -7.5543>, <-0.5926, 169.6527, -6.2688> }
					triangle { <0.9183, 170.0153, -7.5543>, <-0.6406, 169.0981, -6.7368>, <-0.5926, 169.6527, -6.2688> }
					triangle { <-0.6406, 169.0981, -6.7368>, <-2.5256, 169.7713, -6.2112>, <-0.5926, 169.6527, -6.2688> }
					triangle { <-0.6406, 169.0981, -6.7368>, <-2.5864, 169.1846, -6.3461>, <-2.5256, 169.7713, -6.2112> }
					triangle { <-2.5256, 169.7713, -6.2112>, <-2.5864, 169.1846, -6.3461>, <-4.9005, 170.0238, -6.3801> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-7.9714, 170.4811, -6.1916>, 0.5 }
				cylinder { <-7.9714, 170.4811, -6.1916>, <-6.4718, 170.4354, -5.8753>, 0.5 }
				cylinder { <-6.4718, 170.4354, -5.8753>, <-4.9721, 170.3897, -5.5591>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-4.9721, 170.3897, -5.5591>, <-2.7394, 170.9589, -4.6899>, <-2.6534, 170.3288, -4.9655> }
					triangle { <-2.7394, 170.9589, -4.6899>, <-0.7279, 170.9872, -4.6341>, <-2.6534, 170.3288, -4.9655> }
					triangle { <-2.6534, 170.3288, -4.9655>, <-0.7279, 170.9872, -4.6341>, <-0.7379, 170.3631, -4.6768> }
					triangle { <-0.7279, 170.9872, -4.6341>, <0.9466, 170.8253, -5.6844>, <-0.7379, 170.3631, -4.6768> }
					triangle { <0.9466, 170.8253, -5.6844>, <-0.6596, 169.7995, -5.1298>, <-0.7379, 170.3631, -4.6768> }
					triangle { <-0.6596, 169.7995, -5.1298>, <-2.6534, 170.3288, -4.9655>, <-0.7379, 170.3631, -4.6768> }
					triangle { <-0.6596, 169.7995, -5.1298>, <-2.6448, 169.7373, -5.09218>, <-2.6534, 170.3288, -4.9655> }
					triangle { <-2.6534, 170.3288, -4.9655>, <-2.6448, 169.7373, -5.09218>, <-4.9721, 170.3897, -5.5591> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-8.0671, 170.6202, -5.8987>, 0.5 }
				cylinder { <-8.0671, 170.6202, -5.8987>, <-6.663, 170.7136, -5.2896>, 0.5 }
				cylinder { <-6.663, 170.7136, -5.2896>, <-5.259, 170.807, -4.6805>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-5.259, 170.807, -4.6805>, <-3.3023, 171.5869, -3.4047>, <-3.1099, 170.9628, -3.6366> }
					triangle { <-3.3023, 171.5869, -3.4047>, <-1.3527, 171.7957, -2.9515>, <-3.1099, 170.9628, -3.6366> }
					triangle { <-3.1099, 170.9628, -3.6366>, <-1.3527, 171.7957, -2.9515>, <-1.3012, 171.1725, -2.9745> }
					triangle { <-1.3527, 171.7957, -2.9515>, <0.5061, 171.7676, -3.6424>, <-1.3012, 171.1725, -2.9745> }
					triangle { <0.5061, 171.7676, -3.6424>, <-1.0863, 170.6112, -3.384>, <-1.3012, 171.1725, -2.9745> }
					triangle { <-1.0863, 170.6112, -3.384>, <-3.1099, 170.9628, -3.6366>, <-1.3012, 171.1725, -2.9745> }
					triangle { <-1.0863, 170.6112, -3.384>, <-3.02617, 170.3725, -3.7393>, <-3.1099, 170.9628, -3.6366> }
					triangle { <-3.1099, 170.9628, -3.6366>, <-3.02617, 170.3725, -3.7393>, <-5.259, 170.807, -4.6805> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-8.2096, 170.7402, -5.6629>, 0.5 }
				cylinder { <-8.2096, 170.7402, -5.6629>, <-6.948, 170.9537, -4.8179>, 0.5 }
				cylinder { <-6.948, 170.9537, -4.8179>, <-5.6864, 171.1671, -3.9729>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-5.6864, 171.1671, -3.9729>, <-4.05367, 172.1185, -2.3939>, <-3.7764, 171.5083, -2.5701> }
					triangle { <-4.05367, 172.1185, -2.3939>, <-2.2377, 172.4879, -1.609>, <-3.7764, 171.5083, -2.5701> }
					triangle { <-3.7764, 171.5083, -2.5701>, <-2.2377, 172.4879, -1.609>, <-2.1361, 171.8705, -1.6048> }
					triangle { <-2.2377, 172.4879, -1.609>, <-0.2885, 172.5971, -1.959>, <-2.1361, 171.8705, -1.6048> }
					triangle { <-0.2885, 172.5971, -1.959>, <-1.8097, 171.322, -1.9535>, <-2.1361, 171.8705, -1.6048> }
					triangle { <-1.8097, 171.322, -1.9535>, <-3.7764, 171.5083, -2.5701>, <-2.1361, 171.8705, -1.6048> }
					triangle { <-1.8097, 171.322, -1.9535>, <-3.6313, 170.925, -2.6394>, <-3.7764, 171.5083, -2.5701> }
					triangle { <-3.7764, 171.5083, -2.5701>, <-3.6313, 170.925, -2.6394>, <-5.6864, 171.1671, -3.9729> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-8.4275, 170.8652, -5.4367>, 0.5 }
				cylinder { <-8.4275, 170.8652, -5.4367>, <-7.3838, 171.2037, -4.3656>, 0.5 }
				cylinder { <-7.3838, 171.2037, -4.3656>, <-6.3402, 171.5422, -3.2944>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-6.3402, 171.5422, -3.2944>, <-5.1438, 172.6602, -1.4551>, <-4.7863, 172.0744, -1.5524> }
					triangle { <-5.1438, 172.6602, -1.4551>, <-3.5601, 173.2025, -0.338>, <-4.7863, 172.0744, -1.5524> }
					triangle { <-4.7863, 172.0744, -1.5524>, <-3.5601, 173.2025, -0.338>, <-3.4098, 172.5968, -0.2931> }
					triangle { <-3.5601, 173.2025, -0.338>, <-1.5967, 173.4799, -0.2973>, <-3.4098, 172.5968, -0.2931> }
					triangle { <-1.5967, 173.4799, -0.2973>, <-2.9749, 172.0743, -0.5517>, <-3.4098, 172.5968, -0.2931> }
					triangle { <-2.9749, 172.0743, -0.5517>, <-4.7863, 172.0744, -1.5524>, <-3.4098, 172.5968, -0.2931> }
					triangle { <-2.9749, 172.0743, -0.5517>, <-4.5816, 171.5054, -1.5721>, <-4.7863, 172.0744, -1.5524> }
					triangle { <-4.7863, 172.0744, -1.5524>, <-4.5816, 171.5054, -1.5721>, <-6.3402, 171.5422, -3.2944> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-8.6961, 170.9738, -5.2626>, 0.5 }
				cylinder { <-8.6961, 170.9738, -5.2626>, <-7.9211, 171.4208, -4.01744>, 0.5 }
				cylinder { <-7.9211, 171.4208, -4.01744>, <-7.146, 171.8679, -2.7722>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.146, 171.8679, -2.7722>, <-6.4419, 173.1169, -0.77>, <-6.02415, 172.5639, -0.7749> }
					triangle { <-6.4419, 173.1169, -0.77>, <-5.1663, 173.8159, 0.6207>, <-6.02415, 172.5639, -0.7749> }
					triangle { <-6.02415, 172.5639, -0.7749>, <-5.1663, 173.8159, 0.6207>, <-4.9774, 173.2269, 0.7145> }
					triangle { <-5.1663, 173.8159, 0.6207>, <-3.2816, 174.2682, 1.0412>, <-4.9774, 173.2269, 0.7145> }
					triangle { <-3.2816, 174.2682, 1.0412>, <-4.457, 172.7412, 0.565>, <-4.9774, 173.2269, 0.7145> }
					triangle { <-4.457, 172.7412, 0.565>, <-6.02415, 172.5639, -0.7749>, <-4.9774, 173.2269, 0.7145> }
					triangle { <-4.457, 172.7412, 0.565>, <-5.7723, 172.0153, -0.7347>, <-6.02415, 172.5639, -0.7749> }
					triangle { <-6.02415, 172.5639, -0.7749>, <-5.7723, 172.0153, -0.7347>, <-7.146, 171.8679, -2.7722> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-8.9669, 171.0522, -5.1585>, 0.5 }
				cylinder { <-8.9669, 171.0522, -5.1585>, <-8.4627, 171.5777, -3.8091>, 0.5 }
				cylinder { <-8.4627, 171.5777, -3.8091>, <-7.9586, 172.1031, -2.4597>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.9586, 172.1031, -2.4597>, <-7.7197, 173.4335, -0.4012>, <-7.2672, 172.9154, -0.3163> }
					triangle { <-7.7197, 173.4335, -0.4012>, <-6.7694, 174.2519, 1.1726>, <-7.2672, 172.9154, -0.3163> }
					triangle { <-7.2672, 172.9154, -0.3163>, <-6.7694, 174.2519, 1.1726>, <-6.5564, 173.6812, 1.3152> }
					triangle { <-6.7694, 174.2519, 1.1726>, <-5.02965, 174.8584, 1.9068>, <-6.5564, 173.6812, 1.3152> }
					triangle { <-5.02965, 174.8584, 1.9068>, <-5.9826, 173.2362, 1.2741>, <-6.5564, 173.6812, 1.3152> }
					triangle { <-5.9826, 173.2362, 1.2741>, <-7.2672, 172.9154, -0.3163>, <-6.5564, 173.6812, 1.3152> }
					triangle { <-5.9826, 173.2362, 1.2741>, <-6.986, 172.3891, -0.2164>, <-7.2672, 172.9154, -0.3163> }
					triangle { <-7.2672, 172.9154, -0.3163>, <-6.986, 172.3891, -0.2164>, <-7.9586, 172.1031, -2.4597> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-9.2942, 171.1162, -5.1034>, 0.5 }
				cylinder { <-9.2942, 171.1162, -5.1034>, <-9.1174, 171.7056, -3.699>, 0.5 }
				cylinder { <-9.1174, 171.7056, -3.699>, <-8.9405, 172.295, -2.2946>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-8.9405, 172.295, -2.2946>, <-9.2328, 173.6734, -0.2749>, <-8.7645, 173.1992, -0.08471> }
					triangle { <-9.2328, 173.6734, -0.2749>, <-8.6903, 174.598, 1.4282>, <-8.7645, 173.1992, -0.08471> }
					triangle { <-8.7645, 173.1992, -0.08471>, <-8.6903, 174.598, 1.4282>, <-8.463, 174.0508, 1.6292> }
					triangle { <-8.6903, 174.598, 1.4282>, <-7.1909, 175.3688, 2.4727>, <-8.463, 174.0508, 1.6292> }
					triangle { <-7.1909, 175.3688, 2.4727>, <-7.8571, 173.6583, 1.7176>, <-8.463, 174.0508, 1.6292> }
					triangle { <-7.8571, 173.6583, 1.7176>, <-8.7645, 173.1992, -0.08471>, <-8.463, 174.0508, 1.6292> }
					triangle { <-7.8571, 173.6583, 1.7176>, <-8.4657, 172.7018, 0.08642>, <-8.7645, 173.1992, -0.08471> }
					triangle { <-8.7645, 173.1992, -0.08471>, <-8.4657, 172.7018, 0.08642>, <-8.9405, 172.295, -2.2946> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-9.5929, 171.1491, -5.1118>, 0.5 }
				cylinder { <-9.5929, 171.1491, -5.1118>, <-9.7147, 171.7713, -3.7157>, 0.5 }
				cylinder { <-9.7147, 171.7713, -3.7157>, <-9.8365, 172.3936, -2.3196>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-9.8365, 172.3936, -2.3196>, <-10.588, 173.7742, -0.4239>, <-10.1268, 173.3415, -0.1403> }
					triangle { <-10.588, 173.7742, -0.4239>, <-10.4297, 174.7639, 1.3211>, <-10.1268, 173.3415, -0.1403> }
					triangle { <-10.1268, 173.3415, -0.1403>, <-10.4297, 174.7639, 1.3211>, <-10.2013, 174.2396, 1.5747> }
					triangle { <-10.4297, 174.7639, 1.3211>, <-9.2034, 175.6667, 2.5919>, <-10.2013, 174.2396, 1.5747> }
					triangle { <-9.2034, 175.6667, 2.5919>, <-9.5931, 173.8977, 1.7802>, <-10.2013, 174.2396, 1.5747> }
					triangle { <-9.5931, 173.8977, 1.7802>, <-10.1268, 173.3415, -0.1403>, <-10.2013, 174.2396, 1.5747> }
					triangle { <-9.5931, 173.8977, 1.7802>, <-9.8267, 172.8719, 0.09516>, <-10.1268, 173.3415, -0.1403> }
					triangle { <-10.1268, 173.3415, -0.1403>, <-9.8267, 172.8719, 0.09516>, <-9.8365, 172.3936, -2.3196> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-9.9227, 171.1574, -5.1852>, 0.5 }
				cylinder { <-9.9227, 171.1574, -5.1852>, <-10.3744, 171.7881, -3.8625>, 0.5 }
				cylinder { <-10.3744, 171.7881, -3.8625>, <-10.826, 172.4187, -2.5399>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-10.826, 172.4187, -2.5399>, <-12.05653, 173.7561, -0.878>, <-11.6268, 173.3708, -0.4943> }
					triangle { <-12.05653, 173.7561, -0.878>, <-12.3359, 174.7832, 0.8298>, <-11.6268, 173.3708, -0.4943> }
					triangle { <-11.6268, 173.3708, -0.4943>, <-12.3359, 174.7832, 0.8298>, <-12.1196, 174.2853, 1.141> }
					triangle { <-12.3359, 174.7832, 0.8298>, <-11.4703, 175.8116, 2.2882>, <-12.1196, 174.2853, 1.141> }
					triangle { <-11.4703, 175.8116, 2.2882>, <-11.5384, 174.0024, 1.4744>, <-12.1196, 174.2853, 1.141> }
					triangle { <-11.5384, 174.0024, 1.4744>, <-11.6268, 173.3708, -0.4943>, <-12.1196, 174.2853, 1.141> }
					triangle { <-11.5384, 174.0024, 1.4744>, <-11.3416, 172.9336, -0.1884>, <-11.6268, 173.3708, -0.4943> }
					triangle { <-11.6268, 173.3708, -0.4943>, <-11.3416, 172.9336, -0.1884>, <-10.826, 172.4187, -2.5399> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-10.198, 171.1391, -5.3046>, 0.5 }
				cylinder { <-10.198, 171.1391, -5.3046>, <-10.9249, 171.7514, -4.1014>, 0.5 }
				cylinder { <-10.9249, 171.7514, -4.1014>, <-11.6517, 172.3638, -2.8981>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.6517, 172.3638, -2.8981>, <-13.2566, 173.6238, -1.5192>, <-12.8745, 173.2795, -1.05468> }
					triangle { <-13.2566, 173.6238, -1.5192>, <-13.9132, 174.6506, 0.08212>, <-12.8745, 173.2795, -1.05468> }
					triangle { <-12.8745, 173.2795, -1.05468>, <-13.9132, 174.6506, 0.08212>, <-13.7191, 174.1762, 0.4408> }
					triangle { <-13.9132, 174.6506, 0.08212>, <-13.4021, 175.7659, 1.6405>, <-13.7191, 174.1762, 0.4408> }
					triangle { <-13.4021, 175.7659, 1.6405>, <-13.1871, 173.9452, 0.8797>, <-13.7191, 174.1762, 0.4408> }
					triangle { <-13.1871, 173.9452, 0.8797>, <-12.8745, 173.2795, -1.05468>, <-13.7191, 174.1762, 0.4408> }
					triangle { <-13.1871, 173.9452, 0.8797>, <-12.6164, 172.8709, -0.6907>, <-12.8745, 173.2795, -1.05468> }
					triangle { <-12.8745, 173.2795, -1.05468>, <-12.6164, 172.8709, -0.6907>, <-11.6517, 172.3638, -2.8981> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-10.4738, 171.0905, -5.4939>, 0.5 }
				cylinder { <-10.4738, 171.0905, -5.4939>, <-11.4764, 171.6541, -4.48>, 0.5 }
				cylinder { <-11.4764, 171.6541, -4.48>, <-12.4791, 172.2178, -3.466>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-12.4791, 172.2178, -3.466>, <-14.4285, 173.3509, -2.4759>, <-14.1198, 173.0494, -1.9335> }
					triangle { <-14.4285, 173.3509, -2.4759>, <-15.4775, 174.3398, -1.07181>, <-14.1198, 173.0494, -1.9335> }
					triangle { <-14.1198, 173.0494, -1.9335>, <-15.4775, 174.3398, -1.07181>, <-15.32, 173.8903, -0.6661> }
					triangle { <-15.4775, 174.3398, -1.07181>, <-15.3856, 175.5205, 0.5191>, <-15.32, 173.8903, -0.6661> }
					triangle { <-15.3856, 175.5205, 0.5191>, <-14.8694, 173.7146, -0.1229>, <-15.32, 173.8903, -0.6661> }
					triangle { <-14.8694, 173.7146, -0.1229>, <-14.1198, 173.0494, -1.9335>, <-15.32, 173.8903, -0.6661> }
					triangle { <-14.8694, 173.7146, -0.1229>, <-13.9064, 172.6712, -1.5122>, <-14.1198, 173.0494, -1.9335> }
					triangle { <-14.1198, 173.0494, -1.9335>, <-13.9064, 172.6712, -1.5122>, <-12.4791, 172.2178, -3.466> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-10.6783, 171.0241, -5.7039>, 0.5 }
				cylinder { <-10.6783, 171.0241, -5.7039>, <-11.8856, 171.5215, -4.8999>, 0.5 }
				cylinder { <-11.8856, 171.5215, -4.8999>, <-13.09287, 172.0188, -4.09603>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-13.09287, 172.0188, -4.09603>, <-15.2676, 173.0082, -3.4993>, <-15.03895, 172.7402, -2.9024> }
					triangle { <-15.2676, 173.0082, -3.4993>, <-16.622, 173.9315, -2.3318>, <-15.03895, 172.7402, -2.9024> }
					triangle { <-15.03895, 172.7402, -2.9024>, <-16.622, 173.9315, -2.3318>, <-16.5061, 173.5019, -1.892> }
					triangle { <-16.622, 173.9315, -2.3318>, <-16.9051, 175.1391, -0.7842>, <-16.5061, 173.5019, -1.892> }
					triangle { <-16.9051, 175.1391, -0.7842>, <-16.1478, 173.3706, -1.2728>, <-16.5061, 173.5019, -1.892> }
					triangle { <-16.1478, 173.3706, -1.2728>, <-15.03895, 172.7402, -2.9024>, <-16.5061, 173.5019, -1.892> }
					triangle { <-16.1478, 173.3706, -1.2728>, <-14.8763, 172.3864, -2.4394>, <-15.03895, 172.7402, -2.9024> }
					triangle { <-15.03895, 172.7402, -2.9024>, <-14.8763, 172.3864, -2.4394>, <-13.09287, 172.0188, -4.09603> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-10.8527, 170.9268, -5.9766>, 0.5 }
				cylinder { <-10.8527, 170.9268, -5.9766>, <-12.2344, 171.3268, -5.4454>, 0.5 }
				cylinder { <-12.2344, 171.3268, -5.4454>, <-13.616, 171.7268, -4.9141>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-13.616, 171.7268, -4.9141>, <-15.9418, 172.5272, -4.7943>, <-15.8158, 172.29, -4.1554> }
					triangle { <-15.9418, 172.5272, -4.7943>, <-17.576, 173.3439, -3.9504>, <-15.8158, 172.29, -4.1554> }
					triangle { <-15.8158, 172.29, -4.1554>, <-17.576, 173.3439, -3.9504>, <-17.5149, 172.9333, -3.4823> }
					triangle { <-17.576, 173.3439, -3.9504>, <-18.2649, 174.5455, -2.5308>, <-17.5149, 172.9333, -3.4823> }
					triangle { <-18.2649, 174.5455, -2.5308>, <-17.2785, 172.8442, -2.8003>, <-17.5149, 172.9333, -3.4823> }
					triangle { <-17.2785, 172.8442, -2.8003>, <-15.8158, 172.29, -4.1554>, <-17.5149, 172.9333, -3.4823> }
					triangle { <-17.2785, 172.8442, -2.8003>, <-15.7202, 171.9594, -3.6578>, <-15.8158, 172.29, -4.1554> }
					triangle { <-15.8158, 172.29, -4.1554>, <-15.7202, 171.9594, -3.6578>, <-13.616, 171.7268, -4.9141> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-10.9516, 170.8238, -6.2411>, 0.5 }
				cylinder { <-10.9516, 170.8238, -6.2411>, <-12.432, 171.1208, -5.9744>, 0.5 }
				cylinder { <-12.432, 171.1208, -5.9744>, <-13.9125, 171.4177, -5.7077>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-13.9125, 171.4177, -5.7077>, <-16.2759, 172.0329, -6.02436>, <-16.2486, 171.8159, -5.3666> }
					triangle { <-16.2759, 172.0329, -6.02436>, <-18.09152, 172.7299, -5.5066>, <-16.2486, 171.8159, -5.3666> }
					triangle { <-16.2486, 171.8159, -5.3666>, <-18.09152, 172.7299, -5.5066>, <-18.08422, 172.3324, -5.02356> }
					triangle { <-18.09152, 172.7299, -5.5066>, <-19.1114, 173.8939, -4.2663>, <-18.08422, 172.3324, -5.02356> }
					triangle { <-19.1114, 173.8939, -4.2663>, <-17.9673, 172.2724, -4.3081>, <-18.08422, 172.3324, -5.02356> }
					triangle { <-17.9673, 172.2724, -4.3081>, <-16.2486, 171.8159, -5.3666>, <-18.08422, 172.3324, -5.02356> }
					triangle { <-17.9673, 172.2724, -4.3081>, <-16.2187, 171.5014, -4.8507>, <-16.2486, 171.8159, -5.3666> }
					triangle { <-16.2486, 171.8159, -5.3666>, <-16.2187, 171.5014, -4.8507>, <-13.9125, 171.4177, -5.7077> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-10.9947, 170.6945, -6.5505>, 0.5 }
				cylinder { <-10.9947, 170.6945, -6.5505>, <-12.5182, 170.8622, -6.593>, 0.5 }
				cylinder { <-12.5182, 170.8622, -6.593>, <-14.04178, 171.0298, -6.6356>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-14.04178, 171.0298, -6.6356>, <-16.3368, 171.4264, -7.4355>, <-16.4238, 171.223, -6.7787> }
					triangle { <-16.3368, 171.4264, -7.4355>, <-18.2715, 171.9664, -7.3121>, <-16.4238, 171.223, -6.7787> }
					triangle { <-16.4238, 171.223, -6.7787>, <-18.2715, 171.9664, -7.3121>, <-18.3278, 171.5787, -6.8243> }
					triangle { <-18.2715, 171.9664, -7.3121>, <-19.6142, 173.0538, -6.3384>, <-18.3278, 171.5787, -6.8243> }
					triangle { <-19.6142, 173.0538, -6.3384>, <-18.3523, 171.5406, -6.09841>, <-18.3278, 171.5787, -6.8243> }
					triangle { <-18.3523, 171.5406, -6.09841>, <-16.4238, 171.223, -6.7787>, <-18.3278, 171.5787, -6.8243> }
					triangle { <-18.3523, 171.5406, -6.09841>, <-16.4717, 170.9205, -6.257>, <-16.4238, 171.223, -6.7787> }
					triangle { <-16.4238, 171.223, -6.7787>, <-16.4717, 170.9205, -6.257>, <-14.04178, 171.0298, -6.6356> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-10.9708, 170.5725, -6.8241>, 0.5 }
				cylinder { <-10.9708, 170.5725, -6.8241>, <-12.4704, 170.6182, -7.1404>, 0.5 }
				cylinder { <-12.4704, 170.6182, -7.1404>, <-13.9701, 170.6639, -7.4567>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-13.9701, 170.6639, -7.4567>, <-16.1086, 170.8653, -8.6611>, <-16.296, 170.6655, -8.0245> }
					triangle { <-16.1086, 170.8653, -8.6611>, <-18.06945, 171.252, -8.8974>, <-16.296, 170.6655, -8.0245> }
					triangle { <-16.296, 170.6655, -8.0245>, <-18.06945, 171.252, -8.8974>, <-18.1826, 170.8683, -8.4163> }
					triangle { <-18.06945, 171.252, -8.8974>, <-19.6426, 172.2438, -8.2082>, <-18.1826, 170.8683, -8.4163> }
					triangle { <-19.6426, 172.2438, -8.2082>, <-18.3334, 170.8391, -7.7054>, <-18.1826, 170.8683, -8.4163> }
					triangle { <-18.3334, 170.8391, -7.7054>, <-16.296, 170.6655, -8.0245>, <-18.1826, 170.8683, -8.4163> }
					triangle { <-18.3334, 170.8391, -7.7054>, <-16.4134, 170.3678, -7.5109>, <-16.296, 170.6655, -8.0245> }
					triangle { <-16.296, 170.6655, -8.0245>, <-16.4134, 170.3678, -7.5109>, <-13.9701, 170.6639, -7.4567> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-10.8752, 170.4334, -7.117>, 0.5 }
				cylinder { <-10.8752, 170.4334, -7.117>, <-12.2792, 170.34, -7.7261>, 0.5 }
				cylinder { <-12.2792, 170.34, -7.7261>, <-13.6833, 170.2466, -8.3352>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-13.6833, 170.2466, -8.3352>, <-15.5457, 170.2373, -9.9463>, <-15.8395, 170.0315, -9.3533> }
					triangle { <-15.5457, 170.2373, -9.9463>, <-17.4446, 170.4436, -10.5801>, <-15.8395, 170.0315, -9.3533> }
					triangle { <-15.8395, 170.0315, -9.3533>, <-17.4446, 170.4436, -10.5801>, <-17.6192, 170.0589, -10.1186> }
					triangle { <-17.4446, 170.4436, -10.5801>, <-19.2021, 171.3016, -10.2503>, <-17.6192, 170.0589, -10.1186> }
					triangle { <-19.2021, 171.3016, -10.2503>, <-17.9067, 170.0274, -9.4512>, <-17.6192, 170.0589, -10.1186> }
					triangle { <-17.9067, 170.0274, -9.4512>, <-15.8395, 170.0315, -9.3533>, <-17.6192, 170.0589, -10.1186> }
					triangle { <-17.9067, 170.0274, -9.4512>, <-16.03206, 169.7326, -8.8638>, <-15.8395, 170.0315, -9.3533> }
					triangle { <-15.8395, 170.0315, -9.3533>, <-16.03206, 169.7326, -8.8638>, <-13.6833, 170.2466, -8.3352> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-10.7327, 170.3134, -7.3529>, 0.5 }
				cylinder { <-10.7327, 170.3134, -7.3529>, <-11.9942, 170.0999, -8.1979>, 0.5 }
				cylinder { <-11.9942, 170.0999, -8.1979>, <-13.2558, 169.8865, -9.04292>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-13.2558, 169.8865, -9.04292>, <-14.7944, 169.7057, -10.9572>, <-15.173, 169.4861, -10.4198> }
					triangle { <-14.7944, 169.7057, -10.9572>, <-16.5596, 169.7513, -11.9225>, <-15.173, 169.4861, -10.4198> }
					triangle { <-15.173, 169.4861, -10.4198>, <-16.5596, 169.7513, -11.9225>, <-16.7844, 169.3609, -11.4884> }
					triangle { <-16.5596, 169.7513, -11.9225>, <-18.4073, 170.4721, -11.9336>, <-16.7844, 169.3609, -11.4884> }
					triangle { <-18.4073, 170.4721, -11.9336>, <-17.1832, 169.3166, -10.8817>, <-16.7844, 169.3609, -11.4884> }
					triangle { <-17.1832, 169.3166, -10.8817>, <-15.173, 169.4861, -10.4198>, <-16.7844, 169.3609, -11.4884> }
					triangle { <-17.1832, 169.3166, -10.8817>, <-15.4268, 169.1801, -9.9637>, <-15.173, 169.4861, -10.4198> }
					triangle { <-15.173, 169.4861, -10.4198>, <-15.4268, 169.1801, -9.9637>, <-13.2558, 169.8865, -9.04292> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-10.5148, 170.1883, -7.579>, 0.5 }
				cylinder { <-10.5148, 170.1883, -7.579>, <-11.5584, 169.8499, -8.6502>, 0.5 }
				cylinder { <-11.5584, 169.8499, -8.6502>, <-12.6021, 169.5114, -9.7213>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-12.6021, 169.5114, -9.7213>, <-13.7042, 169.1641, -11.8959>, <-14.1631, 168.9199, -11.4375> }
					triangle { <-13.7042, 169.1641, -11.8959>, <-15.2372, 169.0367, -13.1936>, <-14.1631, 168.9199, -11.4375> }
					triangle { <-14.1631, 168.9199, -11.4375>, <-15.2372, 169.0367, -13.1936>, <-15.5107, 168.6346, -12.8> }
					triangle { <-15.2372, 169.0367, -13.1936>, <-17.09919, 169.5893, -13.5953>, <-15.5107, 168.6346, -12.8> }
					triangle { <-17.09919, 169.5893, -13.5953>, <-16.01805, 168.5644, -12.2835>, <-15.5107, 168.6346, -12.8> }
					triangle { <-16.01805, 168.5644, -12.2835>, <-14.1631, 168.9199, -11.4375>, <-15.5107, 168.6346, -12.8> }
					triangle { <-16.01805, 168.5644, -12.2835>, <-14.4765, 168.5997, -11.03102>, <-14.1631, 168.9199, -11.4375> }
					triangle { <-14.1631, 168.9199, -11.4375>, <-14.4765, 168.5997, -11.03102>, <-12.6021, 169.5114, -9.7213> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-9.4711, 170.5268, -6.5079>, <-10.2461, 170.0798, -7.7531>, 0.5 }
				cylinder { <-10.2461, 170.0798, -7.7531>, <-11.02121, 169.6328, -8.9983>, 0.5 }
				cylinder { <-11.02121, 169.6328, -8.9983>, <-11.7962, 169.1857, -10.2436>, 0.5 }
				pigment { color rgb <0.4, 0.33, 0.22> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.7962, 169.1857, -10.2436>, <-12.4061, 168.7074, -12.581>, <-12.9254, 168.4303, -12.215> }
					triangle { <-12.4061, 168.7074, -12.581>, <-13.631, 168.4233, -14.1523>, <-12.9254, 168.4303, -12.215> }
					triangle { <-12.9254, 168.4303, -12.215>, <-13.631, 168.4233, -14.1523>, <-13.9431, 168.0046, -13.8078> }
					triangle { <-13.631, 168.4233, -14.1523>, <-15.4143, 168.801, -14.9339>, <-13.9431, 168.0046, -13.8078> }
					triangle { <-15.4143, 168.801, -14.9339>, <-14.5359, 167.8974, -13.4003>, <-13.9431, 168.0046, -13.8078> }
					triangle { <-14.5359, 167.8974, -13.4003>, <-12.9254, 168.4303, -12.215>, <-13.9431, 168.0046, -13.8078> }
					triangle { <-14.5359, 167.8974, -13.4003>, <-13.2858, 168.0898, -11.8684>, <-12.9254, 168.4303, -12.215> }
					triangle { <-12.9254, 168.4303, -12.215>, <-13.2858, 168.0898, -11.8684>, <-11.7962, 169.1857, -10.2436> }
					pigment { color rgb <0.83, 0.72, 0.078> }}
				}
			}
		}
scale 0.46
} // end black_eyed_Susan

#declare Plant7 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.09608, 4.4986, 0.05443>, 0.25 }
		cylinder { <-0.09608, 4.4986, 0.05443>, <-0.2882, 8.9932, 0.1632>, 0.25 }
		cylinder { <-0.2882, 8.9932, 0.1632>, <-0.5762, 13.481, 0.3264>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // internode
		cylinder { <-0.5762, 13.481, 0.3264>, <-0.541, 17.9747, 0.562>, 0.25 }
		cylinder { <-0.541, 17.9747, 0.562>, <-0.1829, 22.4499, 0.8687>, 0.25 }
		cylinder { <-0.1829, 22.4499, 0.8687>, <0.4963, 26.8824, 1.2449>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.4963, 26.8824, 1.2449>, <2.2116, 29.1905, 1.7446>, 0.4378 }
			cylinder { <2.2116, 29.1905, 1.7446>, <4.7967, 30.3865, 2.3821>, 0.4378 }
			cylinder { <4.7967, 30.3865, 2.3821>, <7.6409, 30.1881, 3.006741>, 0.4378 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <7.6409, 30.1881, 3.006741>, <11.3657, 29.09651, 1.4111>, <11.331, 30.00078, 3.8206> }
			triangle { <11.331, 30.00078, 3.8206>, <11.3657, 29.09651, 1.4111>, <13.6023, 28.5019, 2.1675> }
			triangle { <11.331, 30.00078, 3.8206>, <13.6023, 28.5019, 2.1675>, <14.7012, 28.9948, 4.5216> }
			triangle { <14.7012, 28.9948, 4.5216>, <13.6023, 28.5019, 2.1675>, <16.08449, 27.5172, 3.3182> }
			triangle { <14.7012, 28.9948, 4.5216>, <16.08449, 27.5172, 3.3182>, <16.9788, 27.7893, 4.8969> }
			triangle { <16.9788, 27.7893, 4.8969>, <16.08449, 27.5172, 3.3182>, <19.2782, 26.0172, 5.3202> }
			triangle { <15.3384, 27.3883, 6.01969>, <16.9788, 27.7893, 4.8969>, <19.2782, 26.0172, 5.3202> }
			triangle { <15.3384, 27.3883, 6.01969>, <14.7012, 28.9948, 4.5216>, <16.9788, 27.7893, 4.8969> }
			triangle { <15.3384, 27.3883, 6.01969>, <12.8098, 28.4395, 6.08362>, <14.7012, 28.9948, 4.5216> }
			triangle { <14.7012, 28.9948, 4.5216>, <12.8098, 28.4395, 6.08362>, <11.331, 30.00078, 3.8206> }
			triangle { <11.331, 30.00078, 3.8206>, <12.8098, 28.4395, 6.08362>, <10.3796, 29.2171, 5.94> }
			triangle { <11.331, 30.00078, 3.8206>, <10.3796, 29.2171, 5.94>, <7.6409, 30.1881, 3.006741> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.4963, 26.8824, 1.2449>, <0.9855, 31.3544, 1.3527>, 0.25 }
		cylinder { <0.9855, 31.3544, 1.3527>, <1.2821, 35.8418, 1.1914>, 0.25 }
		cylinder { <1.2821, 35.8418, 1.1914>, <1.3844, 40.32, 0.7619>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.3844, 40.32, 0.7619>, <0.6343, 42.7938, -0.5934>, 0.4378 }
			cylinder { <0.6343, 42.7938, -0.5934>, <-0.755, 44.2524, -2.7056>, 0.4378 }
			cylinder { <-0.755, 44.2524, -2.7056>, <-2.4556, 44.3515, -5.07574>, 0.4378 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <-2.4556, 44.3515, -5.07574>, <-6.363, 43.6602, -6.4418>, <-4.654, 44.5496, -8.1485> }
			triangle { <-4.654, 44.5496, -8.1485>, <-6.363, 43.6602, -6.4418>, <-7.5578, 43.3012, -8.5326> }
			triangle { <-4.654, 44.5496, -8.1485>, <-7.5578, 43.3012, -8.5326>, <-6.7565, 43.9005, -10.9804> }
			triangle { <-6.7565, 43.9005, -10.9804>, <-7.5578, 43.3012, -8.5326>, <-8.7014, 42.579, -11.1066> }
			triangle { <-6.7565, 43.9005, -10.9804>, <-8.7014, 42.579, -11.1066>, <-8.2851, 42.9393, -12.8568> }
			triangle { <-8.2851, 42.9393, -12.8568>, <-8.7014, 42.579, -11.1066>, <-9.8429, 41.4167, -14.8221> }
			triangle { <-6.3536, 42.3657, -12.6276>, <-8.2851, 42.9393, -12.8568>, <-9.8429, 41.4167, -14.8221> }
			triangle { <-6.3536, 42.3657, -12.6276>, <-6.7565, 43.9005, -10.9804>, <-8.2851, 42.9393, -12.8568> }
			triangle { <-6.3536, 42.3657, -12.6276>, <-4.358, 43.1461, -10.9212>, <-6.7565, 43.9005, -10.9804> }
			triangle { <-6.7565, 43.9005, -10.9804>, <-4.358, 43.1461, -10.9212>, <-4.654, 44.5496, -8.1485> }
			triangle { <-4.654, 44.5496, -8.1485>, <-4.358, 43.1461, -10.9212>, <-2.5957, 43.6652, -9.1447> }
			triangle { <-4.654, 44.5496, -8.1485>, <-2.5957, 43.6652, -9.1447>, <-2.4556, 44.3515, -5.07574> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.3844, 40.32, 0.7619>, <1.4387, 44.8197, 0.7709>, 0.25 }
		cylinder { <1.4387, 44.8197, 0.7709>, <1.4444, 49.2974, 1.2183>, 0.25 }
		cylinder { <1.4444, 49.2974, 1.2183>, <1.4017, 53.71, 2.09985>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.4017, 53.71, 2.09985>, <1.2263, 55.9649, 3.9449>, 0.4378 }
			cylinder { <1.2263, 55.9649, 3.9449>, <0.9448, 57.07997, 6.6275>, 0.4378 }
			cylinder { <0.9448, 57.07997, 6.6275>, <0.6236, 56.7919, 9.5142>, 0.4378 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <0.6236, 56.7919, 9.5142>, <2.55, 55.456, 12.9951>, <0.2075, 56.4883, 13.2624> }
			triangle { <0.2075, 56.4883, 13.2624>, <2.55, 55.456, 12.9951>, <2.008894, 54.8062, 15.2782> }
			triangle { <0.2075, 56.4883, 13.2624>, <2.008894, 54.8062, 15.2782>, <-0.1789, 55.376, 16.6499> }
			triangle { <-0.1789, 55.376, 16.6499>, <2.008894, 54.8062, 15.2782>, <1.08063, 53.7776, 17.8346> }
			triangle { <-0.1789, 55.376, 16.6499>, <1.08063, 53.7776, 17.8346>, <-0.3727, 54.09458, 18.9086> }
			triangle { <-0.3727, 54.09458, 18.9086>, <1.08063, 53.7776, 17.8346>, <-0.6446, 52.2494, 21.1733> }
			triangle { <-1.6889, 53.8256, 17.3896>, <-0.3727, 54.09458, 18.9086>, <-0.6446, 52.2494, 21.1733> }
			triangle { <-1.6889, 53.8256, 17.3896>, <-0.1789, 55.376, 16.6499>, <-0.3727, 54.09458, 18.9086> }
			triangle { <-1.6889, 53.8256, 17.3896>, <-1.9672, 54.9875, 14.9247>, <-0.1789, 55.376, 16.6499> }
			triangle { <-0.1789, 55.376, 16.6499>, <-1.9672, 54.9875, 14.9247>, <0.2075, 56.4883, 13.2624> }
			triangle { <0.2075, 56.4883, 13.2624>, <-1.9672, 54.9875, 14.9247>, <-2.04478, 55.861, 12.5242> }
			triangle { <0.2075, 56.4883, 13.2624>, <-2.04478, 55.861, 12.5242>, <0.6236, 56.7919, 9.5142> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <1.4017, 53.71, 2.09985>, <1.5243, 58.1475, 2.837>, 0.25 }
		cylinder { <1.5243, 58.1475, 2.837>, <1.8119, 62.5992, 3.4282>, 0.25 }
		cylinder { <1.8119, 62.5992, 3.4282>, <2.264, 67.05449, 3.8718>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.264, 67.05449, 3.8718>, <3.5435, 69.5912, 3.2033>, 0.4378 }
			cylinder { <3.5435, 69.5912, 3.2033>, <5.5072, 71.1759, 1.7364>, 0.4378 }
			cylinder { <5.5072, 71.1759, 1.7364>, <7.6913, 71.4344, -0.1825>, 0.4378 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <7.6913, 71.4344, -0.1825>, <8.6484, 71.08987, -4.2539>, <10.5237, 71.8384, -2.6579> }
			triangle { <10.5237, 71.8384, -2.6579>, <8.6484, 71.08987, -4.2539>, <10.6049, 70.8469, -5.6826> }
			triangle { <10.5237, 71.8384, -2.6579>, <10.6049, 70.8469, -5.6826>, <13.1236, 71.3887, -5.08693> }
			triangle { <13.1236, 71.3887, -5.08693>, <10.6049, 70.8469, -5.6826>, <13.04609, 70.2404, -7.1412> }
			triangle { <13.1236, 71.3887, -5.08693>, <13.04609, 70.2404, -7.1412>, <14.8308, 70.5733, -6.8764> }
			triangle { <14.8308, 70.5733, -6.8764>, <13.04609, 70.2404, -7.1412>, <16.6215, 69.2016, -8.7522> }
			triangle { <14.7984, 69.8343, -4.9883>, <14.8308, 70.5733, -6.8764>, <16.6215, 69.2016, -8.7522> }
			triangle { <14.7984, 69.8343, -4.9883>, <13.1236, 71.3887, -5.08693>, <14.8308, 70.5733, -6.8764> }
			triangle { <14.7984, 69.8343, -4.9883>, <13.3077, 70.4303, -2.769>, <13.1236, 71.3887, -5.08693> }
			triangle { <13.1236, 71.3887, -5.08693>, <13.3077, 70.4303, -2.769>, <10.5237, 71.8384, -2.6579> }
			triangle { <10.5237, 71.8384, -2.6579>, <13.3077, 70.4303, -2.769>, <11.7224, 70.7856, -0.7962> }
			triangle { <10.5237, 71.8384, -2.6579>, <11.7224, 70.7856, -0.7962>, <7.6913, 71.4344, -0.1825> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <2.264, 67.05449, 3.8718>, <2.1646, 71.5316, 4.3137>, 0.25 }
		cylinder { <2.1646, 71.5316, 4.3137>, <1.5152, 75.9634, 4.7471>, 0.25 }
		cylinder { <1.5152, 75.9634, 4.7471>, <0.3257, 80.2831, 5.1655>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.3257, 80.2831, 5.1655>, <-1.6816, 82.3931, 5.3596>, 0.4378 }
			cylinder { <-1.6816, 82.3931, 5.3596>, <-4.4507, 83.3129, 5.4305>, 0.4378 }
			cylinder { <-4.4507, 83.3129, 5.4305>, <-7.3276, 82.8254, 5.3615>, 0.4378 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <-7.3276, 82.8254, 5.3615>, <-10.4932, 81.07432, 7.4886>, <-11.06803, 82.2623, 5.2789> }
			triangle { <-11.06803, 82.2623, 5.2789>, <-10.4932, 81.07432, 7.4886>, <-12.768, 80.2917, 7.1132> }
			triangle { <-11.06803, 82.2623, 5.2789>, <-12.768, 80.2917, 7.1132>, <-14.3905, 80.9213, 5.1223> }
			triangle { <-14.3905, 80.9213, 5.1223>, <-12.768, 80.2917, 7.1132>, <-15.3264, 79.1414, 6.3475> }
			triangle { <-14.3905, 80.9213, 5.1223>, <-15.3264, 79.1414, 6.3475>, <-16.5615, 79.4858, 5.03516> }
			triangle { <-16.5615, 79.4858, 5.03516>, <-15.3264, 79.1414, 6.3475>, <-18.7066, 77.4957, 4.8229> }
			triangle { <-15.1682, 79.4405, 3.5624>, <-16.5615, 79.4858, 5.03516>, <-18.7066, 77.4957, 4.8229> }
			triangle { <-15.1682, 79.4405, 3.5624>, <-14.3905, 80.9213, 5.1223>, <-16.5615, 79.4858, 5.03516> }
			triangle { <-15.1682, 79.4405, 3.5624>, <-12.8319, 80.8102, 3.1515>, <-14.3905, 80.9213, 5.1223> }
			triangle { <-14.3905, 80.9213, 5.1223>, <-12.8319, 80.8102, 3.1515>, <-11.06803, 82.2623, 5.2789> }
			triangle { <-11.06803, 82.2623, 5.2789>, <-12.8319, 80.8102, 3.1515>, <-10.519, 81.8727, 2.9213> }
			triangle { <-11.06803, 82.2623, 5.2789>, <-10.519, 81.8727, 2.9213>, <-7.3276, 82.8254, 5.3615> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <0.3257, 80.2831, 5.1655>, <-0.5449, 84.6386, 5.8874>, 0.25 }
		cylinder { <-0.5449, 84.6386, 5.8874>, <-1.08856, 88.988, 6.9059>, 0.25 }
		cylinder { <-1.08856, 88.988, 6.9059>, <-1.2997, 93.2894, 8.2111>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.2997, 93.2894, 8.2111>, <-0.3804, 95.5355, 9.8326>, 0.4378 }
			cylinder { <-0.3804, 95.5355, 9.8326>, <1.3779, 96.7073, 11.8461>, 0.4378 }
			cylinder { <1.3779, 96.7073, 11.8461>, <3.5602, 96.5281, 13.776>, 0.4378 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <3.5602, 96.5281, 13.776>, <7.7022, 95.9496, 14.1239>, <6.3801, 96.3636, 16.2931> }
			triangle { <6.3801, 96.3636, 16.2931>, <7.7022, 95.9496, 14.1239>, <9.3508, 95.3274, 15.804> }
			triangle { <6.3801, 96.3636, 16.2931>, <9.3508, 95.3274, 15.804>, <9.09196, 95.4038, 18.4346> }
			triangle { <9.09196, 95.4038, 18.4346>, <9.3508, 95.3274, 15.804>, <11.07489, 94.2579, 17.887> }
			triangle { <9.09196, 95.4038, 18.4346>, <11.07489, 94.2579, 17.887>, <11.04541, 94.2595, 19.7215> }
			triangle { <11.04541, 94.2595, 19.7215>, <11.07489, 94.2579, 17.887>, <13.07318, 92.5517, 20.978> }
			triangle { <9.1404, 93.5685, 19.7985>, <11.04541, 94.2595, 19.7215>, <13.07318, 92.5517, 20.978> }
			triangle { <9.1404, 93.5685, 19.7985>, <9.09196, 95.4038, 18.4346>, <11.04541, 94.2595, 19.7215> }
			triangle { <9.1404, 93.5685, 19.7985>, <6.779, 94.4639, 18.738>, <9.09196, 95.4038, 18.4346> }
			triangle { <9.09196, 95.4038, 18.4346>, <6.779, 94.4639, 18.738>, <6.3801, 96.3636, 16.2931> }
			triangle { <6.3801, 96.3636, 16.2931>, <6.779, 94.4639, 18.738>, <4.6409, 95.1365, 17.51> }
			triangle { <6.3801, 96.3636, 16.2931>, <4.6409, 95.1365, 17.51>, <3.5602, 96.5281, 13.776> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-1.2997, 93.2894, 8.2111>, <-1.5109, 97.5907, 9.5163>, 0.25 }
		cylinder { <-1.5109, 97.5907, 9.5163>, <-1.722, 101.8922, 10.8216>, 0.25 }
		cylinder { <-1.722, 101.8922, 10.8216>, <-1.9332, 106.1935, 12.1268>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.9332, 106.1935, 12.1268>, <-2.2213, 109.0431, 11.5643>, 0.4378 }
			cylinder { <-2.2213, 109.0431, 11.5643>, <-2.5925, 111.2793, 9.7255>, 0.4378 }
			cylinder { <-2.5925, 111.2793, 9.7255>, <-2.9591, 112.374, 7.04484>, 0.4378 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <-2.9591, 112.374, 7.04484>, <-5.6393, 112.5447, 3.82>, <-3.4366, 113.8575, 3.5973> }
			triangle { <-3.4366, 113.8575, 3.5973>, <-5.6393, 112.5447, 3.82>, <-5.646, 113.0722, 1.4432> }
			triangle { <-3.4366, 113.8575, 3.5973>, <-5.646, 113.0722, 1.4432>, <-3.8498, 114.4596, 0.08616> }
			triangle { <-3.8498, 114.4596, 0.08616>, <-5.646, 113.0722, 1.4432>, <-5.3372, 113.4357, -1.4251> }
			triangle { <-3.8498, 114.4596, 0.08616>, <-5.3372, 113.4357, -1.4251>, <-4.1818, 114.3769, -2.4954> }
			triangle { <-4.1818, 114.3769, -2.4954>, <-5.3372, 113.4357, -1.4251>, <-4.4337, 113.8085, -5.3625> }
			triangle { <-2.5415, 113.6071, -1.5849>, <-4.1818, 114.3769, -2.4954>, <-4.4337, 113.8085, -5.3625> }
			triangle { <-2.5415, 113.6071, -1.5849>, <-3.8498, 114.4596, 0.08616>, <-4.1818, 114.3769, -2.4954> }
			triangle { <-2.5415, 113.6071, -1.5849>, <-1.7008, 113.547, 1.0213>, <-3.8498, 114.4596, 0.08616> }
			triangle { <-3.8498, 114.4596, 0.08616>, <-1.7008, 113.547, 1.0213>, <-3.4366, 113.8575, 3.5973> }
			triangle { <-3.4366, 113.8575, 3.5973>, <-1.7008, 113.547, 1.0213>, <-1.06758, 113.2377, 3.4778> }
			triangle { <-3.4366, 113.8575, 3.5973>, <-1.06758, 113.2377, 3.4778>, <-2.9591, 112.374, 7.04484> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-1.9332, 106.1935, 12.1268>, <-2.2713, 110.4316, 13.6013>, 0.25 }
		cylinder { <-2.2713, 110.4316, 13.6013>, <-2.7354, 114.5962, 15.2417>, 0.25 }
		cylinder { <-2.7354, 114.5962, 15.2417>, <-3.3244, 118.6772, 17.044>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.3244, 118.6772, 17.044>, <-4.4355, 120.4606, 19.06997>, 0.4378 }
			cylinder { <-4.4355, 120.4606, 19.06997>, <-6.01323, 120.959, 21.4744>, 0.4378 }
			cylinder { <-6.01323, 120.959, 21.4744>, <-7.6849, 120.0549, 23.6897>, 0.4378 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <-7.6849, 120.0549, 23.6897>, <-7.6501, 117.7877, 27.221>, <-9.8567, 118.9492, 26.5836> }
			triangle { <-9.8567, 118.9492, 26.5836>, <-7.6501, 117.7877, 27.221>, <-9.2113, 116.6908, 28.7332> }
			triangle { <-9.8567, 118.9492, 26.5836>, <-9.2113, 116.6908, 28.7332>, <-11.8049, 117.1386, 28.9893> }
			triangle { <-11.8049, 117.1386, 28.9893>, <-9.2113, 116.6908, 28.7332>, <-11.2328, 115.2012, 30.1994> }
			triangle { <-11.8049, 117.1386, 28.9893>, <-11.2328, 115.2012, 30.1994>, <-13.03294, 115.4021, 30.4921> }
			triangle { <-13.03294, 115.4021, 30.4921>, <-11.2328, 115.2012, 30.1994>, <-14.3161, 113.1252, 31.8249> }
			triangle { <-13.4398, 115.6107, 28.5165>, <-13.03294, 115.4021, 30.4921>, <-14.3161, 113.1252, 31.8249> }
			triangle { <-13.4398, 115.6107, 28.5165>, <-11.8049, 117.1386, 28.9893>, <-13.03294, 115.4021, 30.4921> }
			triangle { <-13.4398, 115.6107, 28.5165>, <-12.5213, 117.3227, 26.5856>, <-11.8049, 117.1386, 28.9893> }
			triangle { <-11.8049, 117.1386, 28.9893>, <-12.5213, 117.3227, 26.5856>, <-9.8567, 118.9492, 26.5836> }
			triangle { <-9.8567, 118.9492, 26.5836>, <-12.5213, 117.3227, 26.5856>, <-11.4503, 118.7217, 24.7343> }
			triangle { <-9.8567, 118.9492, 26.5836>, <-11.4503, 118.7217, 24.7343>, <-7.6849, 120.0549, 23.6897> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-3.3244, 118.6772, 17.044>, <-3.8067, 122.7801, 18.8282>, 0.25 }
		cylinder { <-3.8067, 122.7801, 18.8282>, <-4.182, 126.9024, 20.5934>, 0.25 }
		cylinder { <-4.182, 126.9024, 20.5934>, <-4.4499, 131.0416, 22.3384>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.4499, 131.0416, 22.3384>, <-3.2819, 133.5694, 23.06927>, 0.4318 }
			cylinder { <-3.2819, 133.5694, 23.06927>, <-1.05037, 135.38, 23.2418>, 0.4318 }
			cylinder { <-1.05037, 135.38, 23.2418>, <1.7178, 136.0457, 22.8155>, 0.4318 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <1.7178, 136.0457, 22.8155>, <4.5387, 136.7747, 19.8753>, <5.2947, 136.9708, 22.2909> }
			triangle { <5.2947, 136.9708, 22.2909>, <4.5387, 136.7747, 19.8753>, <6.9244, 136.8431, 19.6093> }
			triangle { <5.2947, 136.9708, 22.2909>, <6.9244, 136.8431, 19.6093>, <8.734, 137.0845, 21.472> }
			triangle { <8.734, 137.0845, 21.472>, <6.9244, 136.8431, 19.6093>, <9.774, 136.5536, 19.4642> }
			triangle { <8.734, 137.0845, 21.472>, <9.774, 136.5536, 19.4642>, <11.1374, 136.7187, 20.6428> }
			triangle { <11.1374, 136.7187, 20.6428>, <9.774, 136.5536, 19.4642>, <13.7083, 135.8453, 19.6422> }
			triangle { <10.2685, 135.5106, 21.9792>, <11.1374, 136.7187, 20.6428>, <13.7083, 135.8453, 19.6422> }
			triangle { <10.2685, 135.5106, 21.9792>, <8.734, 137.0845, 21.472>, <11.1374, 136.7187, 20.6428> }
			triangle { <10.2685, 135.5106, 21.9792>, <7.8634, 135.543, 23.2096>, <8.734, 137.0845, 21.472> }
			triangle { <8.734, 137.0845, 21.472>, <7.8634, 135.543, 23.2096>, <5.2947, 136.9708, 22.2909> }
			triangle { <5.2947, 136.9708, 22.2909>, <7.8634, 135.543, 23.2096>, <5.5204, 135.4179, 24.1309> }
			triangle { <5.2947, 136.9708, 22.2909>, <5.5204, 135.4179, 24.1309>, <1.7178, 136.0457, 22.8155> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-4.4499, 131.0416, 22.3384>, <-4.8142, 135.1951, 24.03137>, 0.25 }
		cylinder { <-4.8142, 135.1951, 24.03137>, <-5.2746, 139.3604, 25.671>, 0.25 }
		cylinder { <-5.2746, 139.3604, 25.671>, <-5.8307, 143.5349, 27.2566>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.8307, 143.5349, 27.2566>, <-7.1691, 145.7406, 27.4571>, 0.3881 }
			cylinder { <-7.1691, 145.7406, 27.4571>, <-9.2101, 147.2305, 26.8989>, 0.3881 }
			cylinder { <-9.2101, 147.2305, 26.8989>, <-11.4716, 147.6527, 25.7139>, 0.3881 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <-11.4716, 147.6527, 25.7139>, <-15.03692, 146.5919, 25.6298>, <-14.4048, 148.2568, 24.203> }
			triangle { <-14.4048, 148.2568, 24.203>, <-15.03692, 146.5919, 25.6298>, <-16.7476, 146.686, 24.3168> }
			triangle { <-14.4048, 148.2568, 24.203>, <-16.7476, 146.686, 24.3168>, <-17.09258, 148.1376, 22.5083> }
			triangle { <-17.09258, 148.1376, 22.5083>, <-16.7476, 146.686, 24.3168>, <-18.5675, 146.6601, 22.4909> }
			triangle { <-17.09258, 148.1376, 22.5083>, <-18.5675, 146.6601, 22.4909>, <-18.9325, 147.606, 21.2188> }
			triangle { <-18.9325, 147.606, 21.2188>, <-18.5675, 146.6601, 22.4909>, <-20.7777, 146.652, 19.6532> }
			triangle { <-17.255, 147.5498, 20.5744>, <-18.9325, 147.606, 21.2188>, <-20.7777, 146.652, 19.6532> }
			triangle { <-17.255, 147.5498, 20.5744>, <-17.09258, 148.1376, 22.5083>, <-18.9325, 147.606, 21.2188> }
			triangle { <-17.255, 147.5498, 20.5744>, <-15.0911, 148.1066, 21.5258>, <-17.09258, 148.1376, 22.5083> }
			triangle { <-17.09258, 148.1376, 22.5083>, <-15.0911, 148.1066, 21.5258>, <-14.4048, 148.2568, 24.203> }
			triangle { <-14.4048, 148.2568, 24.203>, <-15.0911, 148.1066, 21.5258>, <-13.06228, 148.3777, 22.4976> }
			triangle { <-14.4048, 148.2568, 24.203>, <-13.06228, 148.3777, 22.4976>, <-11.4716, 147.6527, 25.7139> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-5.8307, 143.5349, 27.2566>, <-6.3869, 147.7094, 28.8421>, 0.25 }
		cylinder { <-6.3869, 147.7094, 28.8421>, <-6.943, 151.884, 30.4277>, 0.25 }
		cylinder { <-6.943, 151.884, 30.4277>, <-7.4992, 156.0585, 32.01324>, 0.25 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-7.4992, 156.0585, 32.01324>, <-7.4298, 157.2316, 33.2872>, 0.2599 }
			cylinder { <-7.4298, 157.2316, 33.2872>, <-7.09314, 157.6929, 34.9237>, 0.2599 }
			cylinder { <-7.09314, 157.6929, 34.9237>, <-6.5687, 157.3335, 36.5361>, 0.2599 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <-6.5687, 157.3335, 36.5361>, <-4.5837, 156.6703, 37.8891>, <-5.8955, 156.9073, 38.6368> }
			triangle { <-5.8955, 156.9073, 38.6368>, <-4.5837, 156.6703, 37.8891>, <-4.2739, 156.1022, 39.182> }
			triangle { <-5.8955, 156.9073, 38.6368>, <-4.2739, 156.1022, 39.182>, <-5.1958, 156.0401, 40.4517> }
			triangle { <-5.1958, 156.0401, 40.4517>, <-4.2739, 156.1022, 39.182>, <-4.06481, 155.2466, 40.6671> }
			triangle { <-5.1958, 156.0401, 40.4517>, <-4.06481, 155.2466, 40.6671>, <-4.6327, 155.1617, 41.593> }
			triangle { <-4.6327, 155.1617, 41.593>, <-4.06481, 155.2466, 40.6671>, <-4.04491, 153.9484, 42.6964> }
			triangle { <-5.655, 154.8933, 41.01615>, <-4.6327, 155.1617, 41.593>, <-4.04491, 153.9484, 42.6964> }
			triangle { <-5.655, 154.8933, 41.01615>, <-5.1958, 156.0401, 40.4517>, <-4.6327, 155.1617, 41.593> }
			triangle { <-5.655, 154.8933, 41.01615>, <-6.5044, 155.6449, 39.8501>, <-5.1958, 156.0401, 40.4517> }
			triangle { <-5.1958, 156.0401, 40.4517>, <-6.5044, 155.6449, 39.8501>, <-5.8955, 156.9073, 38.6368> }
			triangle { <-5.8955, 156.9073, 38.6368>, <-6.5044, 155.6449, 39.8501>, <-7.1982, 156.2572, 38.6472> }
			triangle { <-5.8955, 156.9073, 38.6368>, <-7.1982, 156.2572, 38.6472>, <-6.5687, 157.3335, 36.5361> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-7.4992, 156.0585, 32.01324>, <-7.7885, 158.4395, 32.8564>, 0.1412 }
		cylinder { <-7.7885, 158.4395, 32.8564>, <-8.05278, 160.8414, 33.6464>, 0.1412 }
		cylinder { <-8.05278, 160.8414, 33.6464>, <-8.2918, 163.263, 34.3828>, 0.1412 }
		pigment { color rgb <0.28, 0.53, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.2918, 163.263, 34.3828>, <-8.2187, 163.9262, 34.2808>, 0.1012 }
			cylinder { <-8.2187, 163.9262, 34.2808>, <-8.02653, 164.453, 33.9053>, 0.1012 }
			cylinder { <-8.02653, 164.453, 33.9053>, <-7.7604, 164.7191, 33.345>, 0.1012 }
			pigment { color rgb <0.28, 0.58, 0.19> }}
		mesh { // leaf
			triangle { <-7.7604, 164.7191, 33.345>, <-7.9097, 164.8368, 32.3934>, <-7.4177, 165.0788, 32.6249> }
			triangle { <-7.4177, 165.0788, 32.6249>, <-7.9097, 164.8368, 32.3934>, <-7.6207, 164.9624, 31.9269> }
			triangle { <-7.4177, 165.0788, 32.6249>, <-7.6207, 164.9624, 31.9269>, <-7.07471, 165.2345, 31.8862> }
			triangle { <-7.07471, 165.2345, 31.8862>, <-7.6207, 164.9624, 31.9269>, <-7.2153, 165.0425, 31.3965> }
			triangle { <-7.07471, 165.2345, 31.8862>, <-7.2153, 165.0425, 31.3965>, <-6.8399, 165.2292, 31.3317> }
			triangle { <-6.8399, 165.2292, 31.3317>, <-7.2153, 165.0425, 31.3965>, <-6.5667, 165.1106, 30.7222> }
			triangle { <-6.639, 165.0062, 31.692>, <-6.8399, 165.2292, 31.3317>, <-6.5667, 165.1106, 30.7222> }
			triangle { <-6.639, 165.0062, 31.692>, <-7.07471, 165.2345, 31.8862>, <-6.8399, 165.2292, 31.3317> }
			triangle { <-6.639, 165.0062, 31.692>, <-6.7791, 164.965, 32.3083>, <-7.07471, 165.2345, 31.8862> }
			triangle { <-7.07471, 165.2345, 31.8862>, <-6.7791, 164.965, 32.3083>, <-7.4177, 165.0788, 32.6249> }
			triangle { <-7.4177, 165.0788, 32.6249>, <-6.7791, 164.965, 32.3083>, <-6.9484, 164.8724, 32.8668> }
			triangle { <-7.4177, 165.0788, 32.6249>, <-6.9484, 164.8724, 32.8668>, <-7.7604, 164.7191, 33.345> }
			pigment { color rgb <0.41, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-8.2918, 163.263, 34.3828>, <-8.32, 163.5488, 34.4697>, 0.5 }
			cylinder { <-8.32, 163.5488, 34.4697>, <-8.3482, 163.8345, 34.5566>, 0.5 }
			cylinder { <-8.3482, 163.8345, 34.5566>, <-8.3764, 164.1203, 34.6435>, 0.5 }
			pigment { color rgb <0.31, 0.55, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-10.3112, 161.8578, 34.2726>, 0.5 }
				cylinder { <-10.3112, 161.8578, 34.2726>, <-12.246, 159.5953, 33.9017>, 0.5 }
				cylinder { <-12.246, 159.5953, 33.9017>, <-14.1808, 157.3328, 33.5308>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-14.1808, 157.3328, 33.5308>, <-16.4593, 155.5606, 33.2236>, <-15.8009, 154.9033, 33.5074> }
					triangle { <-16.4593, 155.5606, 33.2236>, <-18.4158, 153.1122, 34.1969>, <-15.8009, 154.9033, 33.5074> }
					triangle { <-16.4593, 155.5606, 33.2236>, <-17.9921, 154.1261, 33.9547>, <-18.4158, 153.1122, 34.1969> }
					triangle { <-18.4158, 153.1122, 34.1969>, <-17.4996, 153.4995, 34.334>, <-15.8009, 154.9033, 33.5074> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-10.4489, 162.1655, 33.7037>, 0.5 }
				cylinder { <-10.4489, 162.1655, 33.7037>, <-12.5215, 160.2107, 32.7638>, 0.5 }
				cylinder { <-12.5215, 160.2107, 32.7638>, <-14.594, 158.2559, 31.8239>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-14.594, 158.2559, 31.8239>, <-16.9691, 156.8111, 30.9885>, <-16.4142, 156.0504, 31.2321> }
					triangle { <-16.9691, 156.8111, 30.9885>, <-19.2475, 154.4747, 31.3346>, <-16.4142, 156.0504, 31.2321> }
					triangle { <-16.9691, 156.8111, 30.9885>, <-18.7059, 155.4606, 31.3071>, <-19.2475, 154.4747, 31.3346> }
					triangle { <-19.2475, 154.4747, 31.3346>, <-18.3239, 154.734, 31.6313>, <-16.4142, 156.0504, 31.2321> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-10.4869, 162.5193, 33.2354>, 0.5 }
				cylinder { <-10.4869, 162.5193, 33.2354>, <-12.5974, 160.9184, 31.8274>, 0.5 }
				cylinder { <-12.5974, 160.9184, 31.8274>, <-14.7079, 159.3174, 30.4193>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-14.7079, 159.3174, 30.4193>, <-17.08762, 158.2348, 29.1576>, <-16.6275, 157.3981, 29.3427> }
					triangle { <-17.08762, 158.2348, 29.1576>, <-19.5751, 156.1052, 28.9413>, <-16.6275, 157.3981, 29.3427> }
					triangle { <-17.08762, 158.2348, 29.1576>, <-18.9542, 157.0287, 29.1083>, <-19.5751, 156.1052, 28.9413> }
					triangle { <-19.5751, 156.1052, 28.9413>, <-18.6716, 156.2316, 29.3607>, <-16.6275, 157.3981, 29.3427> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-10.4327, 162.9902, 32.7742>, 0.5 }
				cylinder { <-10.4327, 162.9902, 32.7742>, <-12.489, 161.86, 30.9049>, 0.5 }
				cylinder { <-12.489, 161.86, 30.9049>, <-14.5454, 160.7299, 29.03563>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-14.5454, 160.7299, 29.03563>, <-16.8384, 160.1168, 27.3644>, <-16.4835, 159.2163, 27.4607> }
					triangle { <-16.8384, 160.1168, 27.3644>, <-19.464, 158.3302, 26.5375>, <-16.4835, 159.2163, 27.4607> }
					triangle { <-16.8384, 160.1168, 27.3644>, <-18.7869, 159.1443, 26.9182>, <-19.464, 158.3302, 26.5375> }
					triangle { <-19.464, 158.3302, 26.5375>, <-18.6121, 158.2923, 27.06767>, <-16.4835, 159.2163, 27.4607> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-10.3005, 163.4556, 32.4399>, 0.5 }
				cylinder { <-10.3005, 163.4556, 32.4399>, <-12.2245, 162.7908, 30.2362>, 0.5 }
				cylinder { <-12.2245, 162.7908, 30.2362>, <-14.1486, 162.1261, 28.03262>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-14.1486, 162.1261, 28.03262>, <-16.2863, 161.9677, 26.07514>, <-16.01971, 161.0323, 26.07547> }
					triangle { <-16.2863, 161.9677, 26.07514>, <-18.9432, 160.5711, 24.7484>, <-16.01971, 161.0323, 26.07547> }
					triangle { <-16.2863, 161.9677, 26.07514>, <-18.2474, 161.2574, 25.3061>, <-18.9432, 160.5711, 24.7484> }
					triangle { <-18.9432, 160.5711, 24.7484>, <-18.1609, 160.3801, 25.3482>, <-16.01971, 161.0323, 26.07547> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-10.06372, 164.0087, 32.1655>, 0.5 }
				cylinder { <-10.06372, 164.0087, 32.1655>, <-11.751, 163.8972, 29.6875>, 0.5 }
				cylinder { <-11.751, 163.8972, 29.6875>, <-13.4382, 163.7856, 27.2094>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-13.4382, 163.7856, 27.2094>, <-15.3209, 164.1582, 25.03152>, <-15.1431, 163.2097, 24.9096> }
					triangle { <-15.3209, 164.1582, 25.03152>, <-17.9085, 163.2768, 23.2157>, <-15.1431, 163.2097, 24.9096> }
					triangle { <-15.3209, 164.1582, 25.03152>, <-17.2276, 163.7911, 23.9492>, <-17.9085, 163.2768, 23.2157> }
					triangle { <-17.9085, 163.2768, 23.2157>, <-17.2277, 162.9132, 23.8581>, <-15.1431, 163.2097, 24.9096> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-9.7839, 164.5058, 32.02245>, 0.5 }
				cylinder { <-9.7839, 164.5058, 32.02245>, <-11.1914, 164.8914, 29.4013>, 0.5 }
				cylinder { <-11.1914, 164.8914, 29.4013>, <-12.5989, 165.277, 26.7802>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-12.5989, 165.277, 26.7802>, <-14.1931, 166.1187, 24.5049>, <-14.08184, 165.1824, 24.2662> }
					triangle { <-14.1931, 166.1187, 24.5049>, <-16.6287, 165.7437, 22.3378>, <-14.08184, 165.1824, 24.2662> }
					triangle { <-14.1931, 166.1187, 24.5049>, <-15.9927, 166.0866, 23.2004>, <-16.6287, 165.7437, 22.3378> }
					triangle { <-16.6287, 165.7437, 22.3378>, <-16.05527, 165.233, 22.9848>, <-14.08184, 165.1824, 24.2662> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-9.4051, 165.0464, 31.982>, 0.5 }
				cylinder { <-9.4051, 165.0464, 31.982>, <-10.4339, 165.9726, 29.3204>, 0.5 }
				cylinder { <-10.4339, 165.9726, 29.3204>, <-11.4626, 166.8988, 26.6588>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.4626, 166.8988, 26.6588>, <-12.677, 168.2419, 24.39>, <-12.6231, 167.3454, 24.01664> }
					triangle { <-12.677, 168.2419, 24.39>, <-14.8478, 168.4658, 21.939>, <-12.6231, 167.3454, 24.01664> }
					triangle { <-12.677, 168.2419, 24.39>, <-14.2955, 168.6036, 22.9096>, <-14.8478, 168.4658, 21.939> }
					triangle { <-14.8478, 168.4658, 21.939>, <-14.4085, 167.8041, 22.5534>, <-12.6231, 167.3454, 24.01664> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-9.02588, 165.49, 32.05471>, 0.5 }
				cylinder { <-9.02588, 165.49, 32.05471>, <-9.6753, 166.8597, 29.4658>, 0.5 }
				cylinder { <-9.6753, 166.8597, 29.4658>, <-10.3247, 168.2294, 26.877>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-10.3247, 168.2294, 26.877>, <-11.167, 169.9757, 24.7165>, <-11.1464, 169.1363, 24.2255> }
					triangle { <-11.167, 169.9757, 24.7165>, <-13.0287, 170.7353, 22.1229>, <-11.1464, 169.1363, 24.2255> }
					triangle { <-11.167, 169.9757, 24.7165>, <-12.5771, 170.6877, 23.1525>, <-13.0287, 170.7353, 22.1229> }
					triangle { <-13.0287, 170.7353, 22.1229>, <-12.7158, 169.9578, 22.676>, <-11.1464, 169.1363, 24.2255> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-8.5701, 165.9252, 32.2551>, 0.5 }
				cylinder { <-8.5701, 165.9252, 32.2551>, <-8.7637, 167.7302, 29.8667>, 0.5 }
				cylinder { <-8.7637, 167.7302, 29.8667>, <-8.9574, 169.5352, 27.4782>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-8.9574, 169.5352, 27.4782>, <-9.3604, 171.6673, 25.55>, <-9.3558, 170.9138, 24.9349> }
					triangle { <-9.3604, 171.6673, 25.55>, <-10.8071, 173.0068, 22.9265>, <-9.3558, 170.9138, 24.9349> }
					triangle { <-9.3604, 171.6673, 25.55>, <-10.4936, 172.7561, 23.9777>, <-10.8071, 173.0068, 22.9265> }
					triangle { <-10.8071, 173.0068, 22.9265>, <-10.6381, 172.1256, 23.3773>, <-9.3558, 170.9138, 24.9349> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-8.1563, 166.2391, 32.5311>, 0.5 }
				cylinder { <-8.1563, 166.2391, 32.5311>, <-7.9363, 168.3579, 30.4187>, 0.5 }
				cylinder { <-7.9363, 168.3579, 30.4187>, <-7.7162, 170.4767, 28.3063>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.7162, 170.4767, 28.3063>, <-7.7272, 172.8768, 26.6736>, <-7.717, 172.2156, 25.9603> }
					triangle { <-7.7272, 172.8768, 26.6736>, <-8.7607, 174.6896, 24.1407>, <-7.717, 172.2156, 25.9603> }
					triangle { <-7.7272, 172.8768, 26.6736>, <-8.5867, 174.2712, 25.1707>, <-8.7607, 174.6896, 24.1407> }
					triangle { <-8.7607, 174.6896, 24.1407>, <-8.7157, 173.7438, 24.4749>, <-7.717, 172.2156, 25.9603> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-7.7018, 166.4944, 32.938>, 0.5 }
				cylinder { <-7.7018, 166.4944, 32.938>, <-7.02721, 168.8684, 31.2326>, 0.5 }
				cylinder { <-7.02721, 168.8684, 31.2326>, <-6.3526, 171.2425, 29.5271>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-6.3526, 171.2425, 29.5271>, <-5.9402, 173.8466, 28.3124>, <-5.9018, 173.3026, 27.507> }
					triangle { <-5.9402, 173.8466, 28.3124>, <-6.4797, 176.1208, 26.00885>, <-5.9018, 173.3026, 27.507> }
					triangle { <-5.9402, 173.8466, 28.3124>, <-6.4744, 175.5362, 26.9703>, <-6.4797, 176.1208, 26.00885> }
					triangle { <-6.4797, 176.1208, 26.00885>, <-6.5634, 175.1364, 26.1886>, <-5.9018, 173.3026, 27.507> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-7.3246, 166.6247, 33.37>, 0.5 }
				cylinder { <-7.3246, 166.6247, 33.37>, <-6.2728, 169.129, 32.09658>, 0.5 }
				cylinder { <-6.2728, 169.129, 32.09658>, <-5.221, 171.6334, 30.823>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-5.221, 171.6334, 30.823>, <-4.4641, 174.3243, 30.04037>, <-4.3822, 173.892, 29.1729> }
					triangle { <-4.4641, 174.3243, 30.04037>, <-4.5572, 176.9281, 28.04502>, <-4.3822, 173.892, 29.1729> }
					triangle { <-4.4641, 174.3243, 30.04037>, <-4.706, 176.2223, 28.9086>, <-4.5572, 176.9281, 28.04502> }
					triangle { <-4.5572, 176.9281, 28.04502>, <-4.7411, 175.9414, 28.07277>, <-4.3822, 173.892, 29.1729> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-6.9492, 166.6561, 33.9136>, 0.5 }
				cylinder { <-6.9492, 166.6561, 33.9136>, <-5.5221, 169.192, 33.1837>, 0.5 }
				cylinder { <-5.5221, 169.192, 33.1837>, <-4.09499, 171.7278, 32.4538>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-4.09499, 171.7278, 32.4538>, <-3.003225, 174.4059, 32.2034>, <-2.8538, 174.1019, 31.2915> }
					triangle { <-3.003225, 174.4059, 32.2034>, <-2.6081, 177.2734, 30.657>, <-2.8538, 174.1019, 31.2915> }
					triangle { <-3.003225, 174.4059, 32.2034>, <-2.9274, 176.4669, 31.3739>, <-2.6081, 177.2734, 30.657> }
					triangle { <-2.6081, 177.2734, 30.657>, <-2.8837, 176.3199, 30.5048>, <-2.8538, 174.1019, 31.2915> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-6.6432, 166.5643, 34.4927>, 0.5 }
				cylinder { <-6.6432, 166.5643, 34.4927>, <-4.9101, 169.0084, 34.3418>, 0.5 }
				cylinder { <-4.9101, 169.0084, 34.3418>, <-3.1769, 171.4525, 34.1909>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-3.1769, 171.4525, 34.1909>, <-1.8219, 174.0013, 34.4969>, <-1.5885, 173.8228, 33.5697> }
					triangle { <-1.8219, 174.0013, 34.4969>, <-0.9763, 177.007, 33.4867>, <-1.5885, 173.8228, 33.5697> }
					triangle { <-1.8219, 174.0013, 34.4969>, <-1.4549, 176.1424, 34.02478>, <-0.9763, 177.007, 33.4867> }
					triangle { <-0.9763, 177.007, 33.4867>, <-1.3169, 176.1232, 33.1533>, <-1.5885, 173.8228, 33.5697> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-6.4416, 166.3828, 35.01446>, 0.5 }
				cylinder { <-6.4416, 166.3828, 35.01446>, <-4.5068, 168.6453, 35.3853>, 0.5 }
				cylinder { <-4.5068, 168.6453, 35.3853>, <-2.5719, 170.9078, 35.7562>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-2.5719, 170.9078, 35.7562>, <-1.0533, 173.2491, 36.5551>, <-0.7347, 173.1747, 35.6391> }
					triangle { <-1.0533, 173.2491, 36.5551>, <0.1432, 176.2667, 36.07369>, <-0.7347, 173.1747, 35.6391> }
					triangle { <-1.0533, 173.2491, 36.5551>, <-0.4613, 175.3883, 36.4328>, <0.1432, 176.2667, 36.07369> }
					triangle { <0.1432, 176.2667, 36.07369>, <-0.2301, 175.4728, 35.5853>, <-0.7347, 173.1747, 35.6391> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-6.3038, 166.0751, 35.5834>, 0.5 }
				cylinder { <-6.3038, 166.0751, 35.5834>, <-4.2313, 168.0299, 36.5232>, 0.5 }
				cylinder { <-4.2313, 168.0299, 36.5232>, <-2.1588, 169.9847, 37.4631>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-2.1588, 169.9847, 37.4631>, <-0.5435, 171.9986, 38.7903>, <-0.1215, 172.0276, 37.9144> }
					triangle { <-0.5435, 171.9986, 38.7903>, <0.975, 174.9042, 38.9359>, <-0.1215, 172.0276, 37.9144> }
					triangle { <-0.5435, 171.9986, 38.7903>, <0.2524, 174.0538, 39.08055>, <0.975, 174.9042, 38.9359> }
					triangle { <0.975, 174.9042, 38.9359>, <0.5941, 174.2383, 38.288>, <-0.1215, 172.0276, 37.9144> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-6.2659, 165.7213, 36.05164>, 0.5 }
				cylinder { <-6.2659, 165.7213, 36.05164>, <-4.1554, 167.3222, 37.4597>, 0.5 }
				cylinder { <-4.1554, 167.3222, 37.4597>, <-2.04491, 168.9232, 38.8677>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-2.04491, 168.9232, 38.8677>, <-0.425, 170.5749, 40.6211>, <0.09174, 170.6799, 39.8039> }
					triangle { <-0.425, 170.5749, 40.6211>, <1.3025, 173.2737, 41.3293>, <0.09174, 170.6799, 39.8039> }
					triangle { <-0.425, 170.5749, 40.6211>, <0.5008, 172.4857, 41.2792>, <1.3025, 173.2737, 41.3293> }
					triangle { <1.3025, 173.2737, 41.3293>, <0.9418, 172.7407, 40.5585>, <0.09174, 170.6799, 39.8039> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-6.3201, 165.2504, 36.5128>, 0.5 }
				cylinder { <-6.3201, 165.2504, 36.5128>, <-4.2637, 166.3805, 38.3821>, 0.5 }
				cylinder { <-4.2637, 166.3805, 38.3821>, <-2.2074, 167.5107, 40.2515>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-2.2074, 167.5107, 40.2515>, <-0.6742, 168.6929, 42.4144>, <-0.05224, 168.8616, 41.6859> }
					triangle { <-0.6742, 168.6929, 42.4144>, <1.1915, 171.0487, 43.733>, <-0.05224, 168.8616, 41.6859> }
					triangle { <-0.6742, 168.6929, 42.4144>, <0.3335, 170.3701, 43.4694>, <1.1915, 171.0487, 43.733> }
					triangle { <1.1915, 171.0487, 43.733>, <0.8823, 170.6801, 42.8516>, <-0.05224, 168.8616, 41.6859> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-6.4523, 164.785, 36.8472>, 0.5 }
				cylinder { <-6.4523, 164.785, 36.8472>, <-4.5282, 165.4498, 39.05085>, 0.5 }
				cylinder { <-4.5282, 165.4498, 39.05085>, <-2.6042, 166.1145, 41.2544>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-2.6042, 166.1145, 41.2544>, <-1.2263, 166.8421, 43.7037>, <-0.516, 167.0457, 43.07115> }
					triangle { <-1.2263, 166.8421, 43.7037>, <0.6707, 168.8078, 45.5221>, <-0.516, 167.0457, 43.07115> }
					triangle { <-1.2263, 166.8421, 43.7037>, <-0.206, 168.257, 45.08154>, <0.6707, 168.8078, 45.5221> }
					triangle { <0.6707, 168.8078, 45.5221>, <0.4311, 168.5923, 44.5711>, <-0.516, 167.0457, 43.07115> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-6.6891, 164.2318, 37.1215>, 0.5 }
				cylinder { <-6.6891, 164.2318, 37.1215>, <-5.001871, 164.3434, 39.5996>, 0.5 }
				cylinder { <-5.001871, 164.3434, 39.5996>, <-3.3145, 164.455, 42.07764>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-3.3145, 164.455, 42.07764>, <-2.1917, 164.6515, 44.7473>, <-1.3926, 164.8683, 44.237> }
					triangle { <-2.1917, 164.6515, 44.7473>, <-0.364, 166.1021, 47.05489>, <-1.3926, 164.8683, 44.237> }
					triangle { <-2.1917, 164.6515, 44.7473>, <-1.2257, 165.7233, 46.4384>, <-0.364, 166.1021, 47.05489> }
					triangle { <-0.364, 166.1021, 47.05489>, <-0.5019, 166.0591, 46.06121>, <-1.3926, 164.8683, 44.237> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-6.9689, 163.7347, 37.2646>, 0.5 }
				cylinder { <-6.9689, 163.7347, 37.2646>, <-5.5614, 163.3492, 39.8858>, 0.5 }
				cylinder { <-5.5614, 163.3492, 39.8858>, <-4.1538, 162.9636, 42.5069>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-4.1538, 162.9636, 42.5069>, <-3.3195, 162.691, 45.2739>, <-2.4539, 162.8956, 44.8803> }
					triangle { <-3.3195, 162.691, 45.2739>, <-1.6437, 163.6352, 47.9327>, <-2.4539, 162.8956, 44.8803> }
					triangle { <-3.3195, 162.691, 45.2739>, <-2.4606, 163.4278, 47.1872>, <-1.6437, 163.6352, 47.9327> }
					triangle { <-1.6437, 163.6352, 47.9327>, <-1.6745, 163.7393, 46.9345>, <-2.4539, 162.8956, 44.8803> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-7.3476, 163.1941, 37.3051>, 0.5 }
				cylinder { <-7.3476, 163.1941, 37.3051>, <-6.3189, 162.268, 39.9666>, 0.5 }
				cylinder { <-6.3189, 162.268, 39.9666>, <-5.2902, 161.3418, 42.6282>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-5.2902, 161.3418, 42.6282>, <-4.8356, 160.5678, 45.3888>, <-3.9126, 160.7325, 45.1299> }
					triangle { <-4.8356, 160.5678, 45.3888>, <-3.4246, 160.9131, 48.3315>, <-3.9126, 160.7325, 45.1299> }
					triangle { <-4.8356, 160.5678, 45.3888>, <-4.1579, 160.9108, 47.478>, <-3.4246, 160.9131, 48.3315> }
					triangle { <-3.4246, 160.9131, 48.3315>, <-3.3212, 161.1683, 47.3659>, <-3.9126, 160.7325, 45.1299> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-7.7269, 162.7506, 37.2324>, 0.5 }
				cylinder { <-7.7269, 162.7506, 37.2324>, <-7.07754, 161.3809, 39.8212>, 0.5 }
				cylinder { <-7.07754, 161.3809, 39.8212>, <-6.428, 160.0112, 42.4101>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-6.428, 160.0112, 42.4101>, <-6.3456, 158.834, 45.0623>, <-5.3893, 158.9416, 44.921> }
					triangle { <-6.3456, 158.834, 45.0623>, <-5.2438, 158.6436, 48.1476>, <-5.3893, 158.9416, 44.921> }
					triangle { <-6.3456, 158.834, 45.0623>, <-5.8762, 158.8268, 47.2351>, <-5.2438, 158.6436, 48.1476> }
					triangle { <-5.2438, 158.6436, 48.1476>, <-5.01391, 159.0145, 47.2433>, <-5.3893, 158.9416, 44.921> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-8.1827, 162.3153, 37.03199>, 0.5 }
				cylinder { <-8.1827, 162.3153, 37.03199>, <-7.989, 160.5104, 39.4204>, 0.5 }
				cylinder { <-7.989, 160.5104, 39.4204>, <-7.7953, 158.7054, 41.8088>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.7953, 158.7054, 41.8088>, <-8.1521, 157.1424, 44.2288>, <-7.1799, 157.1642, 44.2116> }
					triangle { <-8.1521, 157.1424, 44.2288>, <-7.4653, 156.3721, 47.344>, <-7.1799, 157.1642, 44.2116> }
					triangle { <-8.1521, 157.1424, 44.2288>, <-7.9597, 156.7583, 46.4099>, <-7.4653, 156.3721, 47.344> }
					triangle { <-7.4653, 156.3721, 47.344>, <-7.09162, 156.8467, 46.542>, <-7.1799, 157.1642, 44.2116> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-8.5964, 162.0015, 36.7559>, 0.5 }
				cylinder { <-8.5964, 162.0015, 36.7559>, <-8.8165, 159.8827, 38.8683>, 0.5 }
				cylinder { <-8.8165, 159.8827, 38.8683>, <-9.03659, 157.7639, 40.9807>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-9.03659, 157.7639, 40.9807>, <-9.7854, 155.9329, 43.1052>, <-8.8186, 155.8623, 43.1862> }
					triangle { <-9.7854, 155.9329, 43.1052>, <-9.5117, 154.6893, 46.1298>, <-8.8186, 155.8623, 43.1862> }
					triangle { <-9.7854, 155.9329, 43.1052>, <-9.8666, 155.2432, 45.2169>, <-9.5117, 154.6893, 46.1298> }
					triangle { <-9.5117, 154.6893, 46.1298>, <-9.01407, 155.2285, 45.4444>, <-8.8186, 155.8623, 43.1862> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-9.05104, 161.7462, 36.349>, 0.5 }
				cylinder { <-9.05104, 161.7462, 36.349>, <-9.7256, 159.3721, 38.05453>, 0.5 }
				cylinder { <-9.7256, 159.3721, 38.05453>, <-10.4002, 156.9981, 39.76>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-10.4002, 156.9981, 39.76>, <-11.5724, 154.9632, 41.4664>, <-10.6338, 154.7754, 41.6395> }
					triangle { <-11.5724, 154.9632, 41.4664>, <-11.7927, 153.2581, 44.2617>, <-10.6338, 154.7754, 41.6395> }
					triangle { <-11.5724, 154.9632, 41.4664>, <-11.9789, 153.9782, 43.4173>, <-11.7927, 153.2581, 44.2617> }
					triangle { <-11.7927, 153.2581, 44.2617>, <-11.1662, 153.8359, 43.7307>, <-10.6338, 154.7754, 41.6395> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-9.4282, 161.6159, 35.917>, 0.5 }
				cylinder { <-9.4282, 161.6159, 35.917>, <-10.48, 159.1115, 37.1905>, 0.5 }
				cylinder { <-10.48, 159.1115, 37.1905>, <-11.5318, 156.6071, 38.464>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-11.5318, 156.6071, 38.464>, <-13.04856, 154.4854, 39.7384>, <-12.1535, 154.186, 39.9737> }
					triangle { <-13.04856, 154.4854, 39.7384>, <-13.7152, 152.4508, 42.2255>, <-12.1535, 154.186, 39.9737> }
					triangle { <-13.04856, 154.4854, 39.7384>, <-13.7473, 153.2921, 41.479>, <-13.7152, 152.4508, 42.2255> }
					triangle { <-13.7152, 152.4508, 42.2255>, <-12.9886, 153.031, 41.8465>, <-12.1535, 154.186, 39.9737> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-9.8035, 161.5844, 35.3734>, 0.5 }
				cylinder { <-9.8035, 161.5844, 35.3734>, <-11.2307, 159.0486, 36.1033>, 0.5 }
				cylinder { <-11.2307, 159.0486, 36.1033>, <-12.6578, 156.5128, 36.8332>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-12.6578, 156.5128, 36.8332>, <-14.5094, 154.4039, 37.5754>, <-13.6819, 153.976, 37.855> }
					triangle { <-14.5094, 154.4039, 37.5754>, <-15.6643, 152.1055, 39.6135>, <-13.6819, 153.976, 37.855> }
					triangle { <-14.5094, 154.4039, 37.5754>, <-15.5259, 153.0475, 39.01376>, <-15.6643, 152.1055, 39.6135> }
					triangle { <-15.6643, 152.1055, 39.6135>, <-14.846, 152.6525, 39.4145>, <-13.6819, 153.976, 37.855> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-8.3764, 164.1203, 34.6435>, <-10.1095, 161.6762, 34.7944>, 0.5 }
				cylinder { <-10.1095, 161.6762, 34.7944>, <-11.8427, 159.2322, 34.9452>, 0.5 }
				cylinder { <-11.8427, 159.2322, 34.9452>, <-13.5758, 156.7881, 35.09613>, 0.5 }
				pigment { color rgb <0.83, 0.83, 0.0> }}
			union { // flower
				mesh { // flower petal
					triangle { <-13.5758, 156.7881, 35.09613>, <-15.6907, 154.8084, 35.2819>, <-14.9472, 154.2551, 35.5769> }
					triangle { <-15.6907, 154.8084, 35.2819>, <-17.2961, 152.3718, 36.7838>, <-14.9472, 154.2551, 35.5769> }
					triangle { <-15.6907, 154.8084, 35.2819>, <-16.9984, 153.372, 36.3629>, <-17.2961, 152.3718, 36.7838> }
					triangle { <-17.2961, 152.3718, 36.7838>, <-16.4128, 152.8491, 36.766>, <-14.9472, 154.2551, 35.5769> }
					pigment { color rgb <0.99, 0.76, 0.99> }}
				}
			}
		}
scale 0.9
} // end Pink_daisy

#declare Plant8 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.0, 0.09, 0.0>, 1.0 }
		cylinder { <0.0, 0.09, 0.0>, <0.0, 0.18, 0.0>, 1.0 }
		cylinder { <0.0, 0.18, 0.0>, <0.0, 0.27, 0.0>, 1.0 }
		cylinder { <0.0, 0.27, 0.0>, <0.0, 0.36, 0.0>, 1.0 }
		cylinder { <0.0, 0.36, 0.0>, <0.0, 0.45, 0.0>, 1.0 }
		cylinder { <0.0, 0.45, 0.0>, <0.0, 0.54, 0.0>, 1.0 }
		cylinder { <0.0, 0.54, 0.0>, <0.0, 0.63, 0.0>, 1.0 }
		cylinder { <0.0, 0.63, 0.0>, <0.0, 0.72, 0.0>, 1.0 }
		pigment { color rgb <0.19, 0.56, 0.19> }}
	union { // internode
		cylinder { <0.0, 0.72, 0.0>, <0.0, 0.81, 0.0>, 1.0 }
		cylinder { <0.0, 0.81, 0.0>, <0.0, 0.9, 0.0>, 1.0 }
		cylinder { <0.0, 0.9, 0.0>, <0.0, 0.99, 0.0>, 1.0 }
		cylinder { <0.0, 0.99, 0.0>, <0.0, 1.08, 0.0>, 1.0 }
		cylinder { <0.0, 1.08, 0.0>, <0.0, 1.17, 0.0>, 1.0 }
		cylinder { <0.0, 1.17, 0.0>, <0.0, 1.26, 0.0>, 1.0 }
		cylinder { <0.0, 1.26, 0.0>, <0.0, 1.35, 0.0>, 1.0 }
		cylinder { <0.0, 1.35, 0.0>, <0.0, 1.44, 0.0>, 1.0 }
		pigment { color rgb <0.19, 0.56, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 1.44, 0.0>, <0.3688, 6.5928, 0.9562>, 0.9729 }
			cylinder { <0.3688, 6.5928, 0.9562>, <1.09246, 11.4467, 2.8321>, 0.9729 }
			cylinder { <1.09246, 11.4467, 2.8321>, <2.1429, 15.8151, 5.5553>, 0.9729 }
			cylinder { <2.1429, 15.8151, 5.5553>, <3.4799, 19.5301, 9.02145>, 0.9729 }
			cylinder { <3.4799, 19.5301, 9.02145>, <5.05211, 22.4489, 13.09713>, 0.9729 }
			cylinder { <5.05211, 22.4489, 13.09713>, <6.799, 24.4595, 17.6257>, 0.9729 }
			cylinder { <6.799, 24.4595, 17.6257>, <8.6534, 25.4844, 22.4333>, 0.9729 }
			cylinder { <8.6534, 25.4844, 22.4333>, <10.5443, 25.4844, 27.3351>, 0.9729 }
			pigment { color rgb <0.19, 0.56, 0.19> }}
		mesh { // leaf
			triangle { <9.7638, 23.7112, 40.2498>, <14.4124, 25.07884, 37.826>, <10.5443, 25.4844, 27.3351> }
			triangle { <9.7638, 23.7112, 40.2498>, <13.0937, 23.74, 47.795>, <14.4124, 25.07884, 37.826> }
			triangle { <13.0937, 23.74, 47.795>, <17.7681, 24.1152, 45.7816>, <14.4124, 25.07884, 37.826> }
			triangle { <13.0937, 23.74, 47.795>, <16.1791, 22.8053, 53.9628>, <17.7681, 24.1152, 45.7816> }
			triangle { <16.1791, 22.8053, 53.9628>, <20.2523, 23.9196, 52.1814>, <17.7681, 24.1152, 45.7816> }
			triangle { <16.1791, 22.8053, 53.9628>, <19.3241, 22.4429, 60.9486>, <20.2523, 23.9196, 52.1814> }
			triangle { <19.3241, 22.4429, 60.9486>, <23.1836, 22.3547, 59.4598>, <20.2523, 23.9196, 52.1814> }
			triangle { <19.3241, 22.4429, 60.9486>, <26.5969, 17.4788, 66.7626>, <23.1836, 22.3547, 59.4598> }
			triangle { <19.3241, 22.4429, 60.9486>, <21.5541, 18.3495, 65.3441>, <26.5969, 17.4788, 66.7626> }
			triangle { <16.1791, 22.8053, 53.9628>, <15.909, 19.358, 64.5785>, <19.3241, 22.4429, 60.9486> }
			triangle { <16.1791, 22.8053, 53.9628>, <14.6138, 20.1261, 61.9247>, <15.909, 19.358, 64.5785> }
			triangle { <13.0937, 23.74, 47.795>, <9.9518, 21.2067, 60.99>, <16.1791, 22.8053, 53.9628> }
			triangle { <13.0937, 23.74, 47.795>, <9.7047, 22.9448, 54.1478>, <9.9518, 21.2067, 60.99> }
			triangle { <9.7638, 23.7112, 40.2498>, <6.8184, 22.4237, 51.477>, <13.0937, 23.74, 47.795> }
			triangle { <9.7638, 23.7112, 40.2498>, <6.4004, 22.7492, 45.5416>, <6.8184, 22.4237, 51.477> }
			triangle { <10.5443, 25.4844, 27.3351>, <14.4124, 25.07884, 37.826>, <19.984, 24.5192, 36.3075> }
			triangle { <14.4124, 25.07884, 37.826>, <22.5973, 24.2947, 44.1291>, <19.984, 24.5192, 36.3075> }
			triangle { <14.4124, 25.07884, 37.826>, <17.7681, 24.1152, 45.7816>, <22.5973, 24.2947, 44.1291> }
			triangle { <17.7681, 24.1152, 45.7816>, <24.5339, 24.05587, 50.74>, <22.5973, 24.2947, 44.1291> }
			triangle { <17.7681, 24.1152, 45.7816>, <20.2523, 23.9196, 52.1814>, <24.5339, 24.05587, 50.74> }
			triangle { <20.2523, 23.9196, 52.1814>, <27.02968, 22.4621, 57.9762>, <24.5339, 24.05587, 50.74> }
			triangle { <20.2523, 23.9196, 52.1814>, <23.1836, 22.3547, 59.4598>, <27.02968, 22.4621, 57.9762> }
			triangle { <23.1836, 22.3547, 59.4598>, <26.5969, 17.4788, 66.7626>, <27.02968, 22.4621, 57.9762> }
			triangle { <26.5969, 17.4788, 66.7626>, <28.09732, 19.2602, 62.8201>, <27.02968, 22.4621, 57.9762> }
			triangle { <27.02968, 22.4621, 57.9762>, <33.1484, 20.5188, 58.1387>, <24.5339, 24.05587, 50.74> }
			triangle { <33.1484, 20.5188, 58.1387>, <31.2067, 21.8592, 54.4729>, <24.5339, 24.05587, 50.74> }
			triangle { <24.5339, 24.05587, 50.74>, <34.01537, 23.5026, 51.7077>, <22.5973, 24.2947, 44.1291> }
			triangle { <34.01537, 23.5026, 51.7077>, <29.4419, 24.1119, 46.5343>, <22.5973, 24.2947, 44.1291> }
			triangle { <22.5973, 24.2947, 44.1291>, <29.8408, 23.8505, 42.5963>, <19.984, 24.5192, 36.3075> }
			triangle { <29.8408, 23.8505, 42.5963>, <26.07038, 24.8943, 37.9541>, <19.984, 24.5192, 36.3075> }
			pigment { color rgb <0.55, 0.78, 0.35> }}
		}
	union { // internode
		cylinder { <0.0, 1.44, 0.0>, <0.001589, 1.5298, 0.00412>, 1.0 }
		cylinder { <0.001589, 1.5298, 0.00412>, <0.004764, 1.6194, 0.01235>, 1.0 }
		cylinder { <0.004764, 1.6194, 0.01235>, <0.009516, 1.7084, 0.02467>, 1.0 }
		cylinder { <0.009516, 1.7084, 0.02467>, <0.01583, 1.7967, 0.04105>, 1.0 }
		cylinder { <0.01583, 1.7967, 0.04105>, <0.0237, 1.884, 0.06145>, 1.0 }
		cylinder { <0.0237, 1.884, 0.06145>, <0.0331, 1.9701, 0.08583>, 1.0 }
		cylinder { <0.0331, 1.9701, 0.08583>, <0.04402, 2.05492, 0.1141>, 1.0 }
		cylinder { <0.04402, 2.05492, 0.1141>, <0.05641, 2.138, 0.1462>, 1.0 }
		pigment { color rgb <0.19, 0.56, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.05641, 2.138, 0.1462>, <0.9746, 6.1669, 2.5265>, 0.8831 }
			cylinder { <0.9746, 6.1669, 2.5265>, <2.1271, 9.7004, 5.5144>, 0.8831 }
			cylinder { <2.1271, 9.7004, 5.5144>, <3.4801, 12.6343, 9.02202>, 0.8831 }
			cylinder { <3.4801, 12.6343, 9.02202>, <4.9937, 14.8822, 12.9458>, 0.8831 }
			cylinder { <4.9937, 14.8822, 12.9458>, <6.6234, 16.3781, 17.1705>, 0.8831 }
			cylinder { <6.6234, 16.3781, 17.1705>, <8.321, 17.07788, 21.5716>, 0.8831 }
			cylinder { <8.321, 17.07788, 21.5716>, <10.03683, 16.9608, 26.01951>, 0.8831 }
			cylinder { <10.03683, 16.9608, 26.01951>, <11.7201, 16.03051, 30.3832>, 0.8831 }
			pigment { color rgb <0.19, 0.56, 0.19> }}
		mesh { // leaf
			triangle { <10.6883, 13.3319, 41.8794>, <15.07332, 13.7255, 39.6882>, <11.7201, 16.03051, 30.3832> }
			triangle { <10.6883, 13.3319, 41.8794>, <13.6544, 11.8304, 48.5866>, <15.07332, 13.7255, 39.6882> }
			triangle { <13.6544, 11.8304, 48.5866>, <17.838, 11.3094, 46.6672>, <15.07332, 13.7255, 39.6882> }
			triangle { <13.6544, 11.8304, 48.5866>, <16.1801, 9.6841, 53.9643>, <17.838, 11.3094, 46.6672> }
			triangle { <16.1801, 9.6841, 53.9643>, <20.00476, 9.9204, 52.3448>, <17.838, 11.3094, 46.6672> }
			triangle { <16.1801, 9.6841, 53.9643>, <18.8921, 7.9402, 60.1341>, <20.00476, 9.9204, 52.3448> }
			triangle { <18.8921, 7.9402, 60.1341>, <22.2565, 7.1447, 58.6668>, <20.00476, 9.9204, 52.3448> }
			triangle { <18.8921, 7.9402, 60.1341>, <24.1779, 1.3668, 64.6707>, <22.2565, 7.1447, 58.6668> }
			triangle { <18.8921, 7.9402, 60.1341>, <19.939, 3.4112, 63.6287>, <24.1779, 1.3668, 64.6707> }
			triangle { <16.1801, 9.6841, 53.9643>, <15.2053, 5.6449, 63.2071>, <18.8921, 7.9402, 60.1341> }
			triangle { <16.1801, 9.6841, 53.9643>, <14.2303, 6.8805, 60.9282>, <15.2053, 5.6449, 63.2071> }
			triangle { <13.6544, 11.8304, 48.5866>, <10.376, 8.9726, 60.3318>, <16.1801, 9.6841, 53.9643> }
			triangle { <13.6544, 11.8304, 48.5866>, <10.524, 11.2487, 54.3395>, <10.376, 8.9726, 60.3318> }
			triangle { <10.6883, 13.3319, 41.8794>, <7.8574, 11.7196, 51.9665>, <13.6544, 11.8304, 48.5866> }
			triangle { <10.6883, 13.3319, 41.8794>, <7.5377, 12.7078, 46.6583>, <7.8574, 11.7196, 51.9665> }
			triangle { <11.7201, 16.03051, 30.3832>, <15.07332, 13.7255, 39.6882>, <19.8345, 12.1349, 38.09615> }
			triangle { <15.07332, 13.7255, 39.6882>, <22.1145, 10.5456, 45.04928>, <19.8345, 12.1349, 38.09615> }
			triangle { <15.07332, 13.7255, 39.6882>, <17.838, 11.3094, 46.6672>, <22.1145, 10.5456, 45.04928> }
			triangle { <17.838, 11.3094, 46.6672>, <23.7913, 9.2208, 50.9295>, <22.1145, 10.5456, 45.04928> }
			triangle { <17.838, 11.3094, 46.6672>, <20.00476, 9.9204, 52.3448>, <23.7913, 9.2208, 50.9295> }
			triangle { <20.00476, 9.9204, 52.3448>, <25.6536, 6.5225, 57.2237>, <23.7913, 9.2208, 50.9295> }
			triangle { <20.00476, 9.9204, 52.3448>, <22.2565, 7.1447, 58.6668>, <25.6536, 6.5225, 57.2237> }
			triangle { <22.2565, 7.1447, 58.6668>, <24.1779, 1.3668, 64.6707>, <25.6536, 6.5225, 57.2237> }
			triangle { <24.1779, 1.3668, 64.6707>, <25.8842, 2.9883, 61.2452>, <25.6536, 6.5225, 57.2237> }
			triangle { <25.6536, 6.5225, 57.2237>, <30.5879, 3.4277, 56.9952>, <23.7913, 9.2208, 50.9295> }
			triangle { <30.5879, 3.4277, 56.9952>, <29.1708, 5.4129, 53.8794>, <23.7913, 9.2208, 50.9295> }
			triangle { <23.7913, 9.2208, 50.9295>, <32.00042, 6.4977, 51.4627>, <22.1145, 10.5456, 45.04928> }
			triangle { <32.00042, 6.4977, 51.4627>, <28.09768, 8.5936, 46.9946>, <22.1145, 10.5456, 45.04928> }
			triangle { <22.1145, 10.5456, 45.04928>, <28.3709, 8.6798, 43.4055>, <19.8345, 12.1349, 38.09615> }
			triangle { <28.3709, 8.6798, 43.4055>, <25.275, 10.9193, 39.4349>, <19.8345, 12.1349, 38.09615> }
			pigment { color rgb <0.55, 0.78, 0.35> }}
		}
	union { // internode
		cylinder { <0.05641, 2.138, 0.1462>, <0.06954, 2.2211, 0.1762>, 0.9925 }
		cylinder { <0.06954, 2.2211, 0.1762>, <0.0835, 2.3048, 0.2042>, 0.9925 }
		cylinder { <0.0835, 2.3048, 0.2042>, <0.09827, 2.389, 0.2302>, 0.9925 }
		cylinder { <0.09827, 2.389, 0.2302>, <0.1138, 2.4736, 0.2542>, 0.9925 }
		cylinder { <0.1138, 2.4736, 0.2542>, <0.1302, 2.5586, 0.2762>, 0.9925 }
		cylinder { <0.1302, 2.5586, 0.2762>, <0.1473, 2.644, 0.2962>, 0.9925 }
		cylinder { <0.1473, 2.644, 0.2962>, <0.1652, 2.7296, 0.3142>, 0.9925 }
		cylinder { <0.1652, 2.7296, 0.3142>, <0.1839, 2.8155, 0.3302>, 0.9925 }
		pigment { color rgb <0.19, 0.56, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.1839, 2.8155, 0.3302>, <1.3175, 6.8142, 0.3009>, 0.7696 }
			cylinder { <1.3175, 6.8142, 0.3009>, <2.6714, 10.6617, -0.498>, 0.7696 }
			cylinder { <2.6714, 10.6617, -0.498>, <4.1936, 14.2103, -2.0361>, 0.7696 }
			cylinder { <4.1936, 14.2103, -2.0361>, <5.8255, 17.3236, -4.254>, 0.7696 }
			cylinder { <5.8255, 17.3236, -4.254>, <7.5045, 19.8819, -7.06678>, 0.7696 }
			cylinder { <7.5045, 19.8819, -7.06678>, <9.166, 21.7869, -10.366>, 0.7696 }
			cylinder { <9.166, 21.7869, -10.366>, <10.7462, 22.9655, -14.02519>, 0.7696 }
			cylinder { <10.7462, 22.9655, -14.02519>, <12.1844, 23.3722, -17.9035>, 0.7696 }
			pigment { color rgb <0.19, 0.56, 0.19> }}
		mesh { // leaf
			triangle { <18.9478, 21.7507, -25.5431>, <15.2904, 23.8943, -26.1756>, <12.1844, 23.3722, -17.9035> }
			triangle { <18.9478, 21.7507, -25.5431>, <20.9267, 22.4971, -31.7153>, <15.2904, 23.8943, -26.1756> }
			triangle { <20.9267, 22.4971, -31.7153>, <17.2837, 23.894, -32.7534>, <15.2904, 23.8943, -26.1756> }
			triangle { <20.9267, 22.4971, -31.7153>, <22.1607, 22.4687, -37.081>, <17.2837, 23.894, -32.7534> }
			triangle { <22.1607, 22.4687, -37.081>, <19.1167, 24.2809, -37.8534>, <17.2837, 23.894, -32.7534> }
			triangle { <22.1607, 22.4687, -37.081>, <23.8861, 22.8805, -42.8834>, <19.1167, 24.2809, -37.8534> }
			triangle { <23.8861, 22.8805, -42.8834>, <20.8946, 23.7318, -43.9034>, <19.1167, 24.2809, -37.8534> }
			triangle { <23.8861, 22.8805, -42.8834>, <21.8023, 20.7947, -50.6929>, <20.8946, 23.7318, -43.9034> }
			triangle { <23.8861, 22.8805, -42.8834>, <24.1196, 20.2786, -47.227>, <21.8023, 20.7947, -50.6929> }
			triangle { <22.1607, 22.4687, -37.081>, <27.1428, 19.7202, -43.8364>, <23.8861, 22.8805, -42.8834> }
			triangle { <22.1607, 22.4687, -37.081>, <26.6604, 20.01645, -41.4898>, <27.1428, 19.7202, -43.8364> }
			triangle { <20.9267, 22.4971, -31.7153>, <29.04704, 19.7447, -38.4715>, <22.1607, 22.4687, -37.081> }
			triangle { <20.9267, 22.4971, -31.7153>, <25.9883, 21.05187, -33.9809>, <29.04704, 19.7447, -38.4715> }
			triangle { <18.9478, 21.7507, -25.5431>, <26.1719, 20.00064, -31.02988>, <20.9267, 22.4971, -31.7153> }
			triangle { <18.9478, 21.7507, -25.5431>, <23.4186, 20.1936, -27.2081>, <26.1719, 20.00064, -31.02988> }
			triangle { <12.1844, 23.3722, -17.9035>, <15.2904, 23.8943, -26.1756>, <11.2169, 24.792, -28.09097> }
			triangle { <15.2904, 23.8943, -26.1756>, <13.7018, 25.1766, -34.1134>, <11.2169, 24.792, -28.09097> }
			triangle { <15.2904, 23.8943, -26.1756>, <17.2837, 23.894, -32.7534>, <13.7018, 25.1766, -34.1134> }
			triangle { <17.2837, 23.894, -32.7534>, <15.949, 25.4006, -39.07697>, <13.7018, 25.1766, -34.1134> }
			triangle { <17.2837, 23.894, -32.7534>, <19.1167, 24.2809, -37.8534>, <15.949, 25.4006, -39.07697> }
			triangle { <19.1167, 24.2809, -37.8534>, <17.9493, 24.7277, -44.8912>, <15.949, 25.4006, -39.07697> }
			triangle { <19.1167, 24.2809, -37.8534>, <20.8946, 23.7318, -43.9034>, <17.9493, 24.7277, -44.8912> }
			triangle { <20.8946, 23.7318, -43.9034>, <21.8023, 20.7947, -50.6929>, <17.9493, 24.7277, -44.8912> }
			triangle { <21.8023, 20.7947, -50.6929>, <19.2422, 22.5229, -48.8003>, <17.9493, 24.7277, -44.8912> }
			triangle { <17.9493, 24.7277, -44.8912>, <14.1734, 24.6959, -48.2902>, <15.949, 25.4006, -39.07697> }
			triangle { <14.1734, 24.6959, -48.2902>, <13.6456, 25.2803, -44.9325>, <15.949, 25.4006, -39.07697> }
			triangle { <15.949, 25.4006, -39.07697>, <10.9166, 27.2026, -44.4125>, <13.7018, 25.1766, -34.1134> }
			triangle { <10.9166, 27.2026, -44.4125>, <10.9863, 26.628, -38.9592>, <13.7018, 25.1766, -34.1134> }
			triangle { <13.7018, 25.1766, -34.1134>, <8.6849, 26.5544, -36.8271>, <11.2169, 24.792, -28.09097> }
			triangle { <8.6849, 26.5544, -36.8271>, <8.6477, 26.4926, -32.02492>, <11.2169, 24.792, -28.09097> }
			pigment { color rgb <0.55, 0.78, 0.35> }}
		}
	union { // internode
		cylinder { <0.1839, 2.8155, 0.3302>, <0.1951, 2.8619, 0.3382>, 0.5371 }
		cylinder { <0.1951, 2.8619, 0.3382>, <0.2073, 2.908, 0.3457>, 0.5371 }
		cylinder { <0.2073, 2.908, 0.3457>, <0.2204, 2.954, 0.3526>, 0.5371 }
		cylinder { <0.2204, 2.954, 0.3526>, <0.2346, 2.9998, 0.3589>, 0.5371 }
		cylinder { <0.2346, 2.9998, 0.3589>, <0.2498, 3.04541, 0.3646>, 0.5371 }
		cylinder { <0.2498, 3.04541, 0.3646>, <0.266, 3.09067, 0.3697>, 0.5371 }
		cylinder { <0.266, 3.09067, 0.3697>, <0.2832, 3.1356, 0.3742>, 0.5371 }
		cylinder { <0.2832, 3.1356, 0.3742>, <0.3013, 3.1802, 0.3781>, 0.5371 }
		pigment { color rgb <0.19, 0.56, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.3013, 3.1802, 0.3781>, <0.6964, 4.8234, 0.6636>, 0.3173 }
			cylinder { <0.6964, 4.8234, 0.6636>, <0.8323, 6.4786, 1.0873>, 0.3173 }
			cylinder { <0.8323, 6.4786, 1.0873>, <0.7048, 8.09707, 1.6366>, 0.3173 }
			cylinder { <0.7048, 8.09707, 1.6366>, <0.3177, 9.6312, 2.2955>, 0.3173 }
			cylinder { <0.3177, 9.6312, 2.2955>, <-0.3175, 11.0358, 3.04463>, 0.3173 }
			cylinder { <-0.3175, 11.0358, 3.04463>, <-1.1822, 12.2695, 3.8617>, 0.3173 }
			cylinder { <-1.1822, 12.2695, 3.8617>, <-2.251, 13.296, 4.7229>, 0.3173 }
			cylinder { <-2.251, 13.296, 4.7229>, <-3.4923, 14.08509, 5.6027>, 0.3173 }
			pigment { color rgb <0.19, 0.56, 0.19> }}
		mesh { // leaf
			triangle { <-7.09474, 16.3263, 5.989>, <-6.2324, 15.6958, 7.3972>, <-3.4923, 14.08509, 5.6027> }
			triangle { <-7.09474, 16.3263, 5.989>, <-9.00219, 17.5053, 7.4757>, <-6.2324, 15.6958, 7.3972> }
			triangle { <-9.00219, 17.5053, 7.4757>, <-8.45, 16.7189, 8.8353>, <-6.2324, 15.6958, 7.3972> }
			triangle { <-9.00219, 17.5053, 7.4757>, <-10.7637, 18.2052, 8.7254>, <-8.45, 16.7189, 8.8353> }
			triangle { <-10.7637, 18.2052, 8.7254>, <-10.1116, 17.7012, 9.9728>, <-8.45, 16.7189, 8.8353> }
			triangle { <-10.7637, 18.2052, 8.7254>, <-12.6114, 19.1983, 10.08931>, <-10.1116, 17.7012, 9.9728> }
			triangle { <-12.6114, 19.1983, 10.08931>, <-12.282, 18.4894, 11.1897>, <-10.1116, 17.7012, 9.9728> }
			triangle { <-12.6114, 19.1983, 10.08931>, <-15.1526, 18.4487, 12.2867>, <-12.282, 18.4894, 11.1897> }
			triangle { <-12.6114, 19.1983, 10.08931>, <-14.5821, 18.8814, 10.7093>, <-15.1526, 18.4487, 12.2867> }
			triangle { <-10.7637, 18.2052, 8.7254>, <-14.1424, 19.5382, 8.9954>, <-12.6114, 19.1983, 10.08931> }
			triangle { <-10.7637, 18.2052, 8.7254>, <-13.3084, 19.3206, 8.4977>, <-14.1424, 19.5382, 8.9954> }
			triangle { <-9.00219, 17.5053, 7.4757>, <-12.8178, 19.8613, 7.0845>, <-10.7637, 18.2052, 8.7254> }
			triangle { <-9.00219, 17.5053, 7.4757>, <-10.7383, 18.93, 6.7402>, <-12.8178, 19.8613, 7.0845> }
			triangle { <-7.09474, 16.3263, 5.989>, <-10.1584, 18.5642, 5.6427>, <-9.00219, 17.5053, 7.4757> }
			triangle { <-7.09474, 16.3263, 5.989>, <-8.5998, 17.4966, 5.1843>, <-10.1584, 18.5642, 5.6427> }
			triangle { <-3.4923, 14.08509, 5.6027>, <-6.2324, 15.6958, 7.3972>, <-6.005341, 14.696, 8.9882> }
			triangle { <-6.2324, 15.6958, 7.3972>, <-8.03019, 15.9427, 10.2485>, <-6.005341, 14.696, 8.9882> }
			triangle { <-6.2324, 15.6958, 7.3972>, <-8.45, 16.7189, 8.8353>, <-8.03019, 15.9427, 10.2485> }
			triangle { <-8.45, 16.7189, 8.8353>, <-9.7501, 17.01235, 11.2253>, <-8.03019, 15.9427, 10.2485> }
			triangle { <-8.45, 16.7189, 8.8353>, <-10.1116, 17.7012, 9.9728>, <-9.7501, 17.01235, 11.2253> }
			triangle { <-10.1116, 17.7012, 9.9728>, <-11.9131, 17.8292, 12.3022>, <-9.7501, 17.01235, 11.2253> }
			triangle { <-10.1116, 17.7012, 9.9728>, <-12.282, 18.4894, 11.1897>, <-11.9131, 17.8292, 12.3022> }
			triangle { <-12.282, 18.4894, 11.1897>, <-15.1526, 18.4487, 12.2867>, <-11.9131, 17.8292, 12.3022> }
			triangle { <-15.1526, 18.4487, 12.2867>, <-13.8026, 17.9309, 12.6616>, <-11.9131, 17.8292, 12.3022> }
			triangle { <-11.9131, 17.8292, 12.3022>, <-12.3997, 16.7823, 14.05046>, <-9.7501, 17.01235, 11.2253> }
			triangle { <-12.3997, 16.7823, 14.05046>, <-11.1883, 16.5633, 13.3384>, <-9.7501, 17.01235, 11.2253> }
			triangle { <-9.7501, 17.01235, 11.2253>, <-10.1707, 16.1159, 14.1781>, <-8.03019, 15.9427, 10.2485> }
			triangle { <-10.1707, 16.1159, 14.1781>, <-8.7165, 15.6882, 12.5>, <-8.03019, 15.9427, 10.2485> }
			triangle { <-8.03019, 15.9427, 10.2485>, <-7.7864, 14.7984, 12.3665>, <-6.005341, 14.696, 8.9882> }
			triangle { <-7.7864, 14.7984, 12.3665>, <-6.38, 14.4988, 11.00477>, <-6.005341, 14.696, 8.9882> }
			pigment { color rgb <0.55, 0.78, 0.35> }}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <0.3013, 3.1802, 0.3781>, <0.6389, 4.01138, 0.4511>, 0.8 }
			cylinder { <0.6389, 4.01138, 0.4511>, <0.9764, 4.8424, 0.524>, 0.8 }
			cylinder { <0.9764, 4.8424, 0.524>, <1.314, 5.6735, 0.5969>, 0.8 }
			cylinder { <1.314, 5.6735, 0.5969>, <1.6516, 6.5046, 0.6698>, 0.8 }
			cylinder { <1.6516, 6.5046, 0.6698>, <1.9891, 7.3357, 0.7427>, 0.8 }
			cylinder { <1.9891, 7.3357, 0.7427>, <2.3267, 8.1669, 0.8157>, 0.8 }
			cylinder { <2.3267, 8.1669, 0.8157>, <2.6643, 8.998, 0.8886>, 0.8 }
			cylinder { <2.6643, 8.998, 0.8886>, <3.001883, 9.8291, 0.9615>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // inflor. internode
			cylinder { <3.001883, 9.8291, 0.9615>, <3.3394, 10.6602, 1.03445>, 0.8 }
			cylinder { <3.3394, 10.6602, 1.03445>, <3.677, 11.4913, 1.1073>, 0.8 }
			cylinder { <3.677, 11.4913, 1.1073>, <4.01458, 12.3224, 1.1802>, 0.8 }
			cylinder { <4.01458, 12.3224, 1.1802>, <4.3521, 13.1535, 1.2532>, 0.8 }
			cylinder { <4.3521, 13.1535, 1.2532>, <4.6897, 13.9846, 1.3261>, 0.8 }
			cylinder { <4.6897, 13.9846, 1.3261>, <5.02728, 14.8157, 1.399>, 0.8 }
			cylinder { <5.02728, 14.8157, 1.399>, <5.3648, 15.6468, 1.4719>, 0.8 }
			cylinder { <5.3648, 15.6468, 1.4719>, <5.7024, 16.4779, 1.5448>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // inflor. internode
			cylinder { <5.7024, 16.4779, 1.5448>, <6.03998, 17.309, 1.6177>, 0.8 }
			cylinder { <6.03998, 17.309, 1.6177>, <6.3775, 18.1401, 1.6907>, 0.8 }
			cylinder { <6.3775, 18.1401, 1.6907>, <6.7151, 18.9712, 1.7636>, 0.8 }
			cylinder { <6.7151, 18.9712, 1.7636>, <7.05268, 19.8023, 1.8365>, 0.8 }
			cylinder { <7.05268, 19.8023, 1.8365>, <7.3902, 20.6334, 1.9094>, 0.8 }
			cylinder { <7.3902, 20.6334, 1.9094>, <7.7278, 21.4645, 1.9823>, 0.8 }
			cylinder { <7.7278, 21.4645, 1.9823>, <8.06538, 22.2956, 2.0553>, 0.8 }
			cylinder { <8.06538, 22.2956, 2.0553>, <8.4029, 23.1267, 2.1282>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // inflor. internode
			cylinder { <8.4029, 23.1267, 2.1282>, <8.7405, 23.9578, 2.2011>, 0.8 }
			cylinder { <8.7405, 23.9578, 2.2011>, <9.07808, 24.7889, 2.274>, 0.8 }
			cylinder { <9.07808, 24.7889, 2.274>, <9.4156, 25.62, 2.3469>, 0.8 }
			cylinder { <9.4156, 25.62, 2.3469>, <9.7532, 26.4511, 2.4198>, 0.8 }
			cylinder { <9.7532, 26.4511, 2.4198>, <10.09078, 27.2822, 2.4928>, 0.8 }
			cylinder { <10.09078, 27.2822, 2.4928>, <10.4283, 28.1133, 2.5657>, 0.8 }
			cylinder { <10.4283, 28.1133, 2.5657>, <10.7659, 28.9444, 2.6386>, 0.8 }
			cylinder { <10.7659, 28.9444, 2.6386>, <11.1034, 29.7755, 2.7115>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // inflor. internode
			cylinder { <11.1034, 29.7755, 2.7115>, <11.441, 30.6066, 2.7844>, 0.8 }
			cylinder { <11.441, 30.6066, 2.7844>, <11.7786, 31.4377, 2.8574>, 0.8 }
			cylinder { <11.7786, 31.4377, 2.8574>, <12.1161, 32.2688, 2.9303>, 0.8 }
			cylinder { <12.1161, 32.2688, 2.9303>, <12.4537, 33.09998, 3.00324>, 0.8 }
			cylinder { <12.4537, 33.09998, 3.00324>, <12.7913, 33.931, 3.07615>, 0.8 }
			cylinder { <12.7913, 33.931, 3.07615>, <13.1288, 34.7621, 3.149>, 0.8 }
			cylinder { <13.1288, 34.7621, 3.149>, <13.4664, 35.5932, 3.2219>, 0.8 }
			cylinder { <13.4664, 35.5932, 3.2219>, <13.804, 36.4243, 3.2949>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <13.804, 36.4243, 3.2949>, <15.1018, 40.6357, 3.128>, 0.8 }
				cylinder { <15.1018, 40.6357, 3.128>, <16.01539, 44.895, 2.4405>, 0.8 }
				cylinder { <16.01539, 44.895, 2.4405>, <16.5248, 49.1098, 1.2473>, 0.8 }
				cylinder { <16.5248, 49.1098, 1.2473>, <16.6191, 53.189, -0.4256>, 0.8 }
				cylinder { <16.6191, 53.189, -0.4256>, <16.2962, 57.04439, -2.5423>, 0.8 }
				cylinder { <16.2962, 57.04439, -2.5423>, <15.5632, 60.5923, -5.05688>, 0.8 }
				cylinder { <15.5632, 60.5923, -5.05688>, <14.4359, 63.7561, -7.9148>, 0.8 }
				cylinder { <14.4359, 63.7561, -7.9148>, <12.9386, 66.4672, -11.05428>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <12.9386, 66.4672, -11.05428>, <10.8321, 67.6746, -10.0926>, <11.9102, 67.9331, -10.3835> }
					triangle { <9.6803, 66.7018, -10.7833>, <8.749, 68.1315, -9.8473>, <11.08595, 67.4177, -11.00686> }
					triangle { <11.08595, 67.4177, -11.00686>, <8.749, 68.1315, -9.8473>, <10.02544, 68.8679, -9.8772> }
					triangle { <10.8321, 67.6746, -10.0926>, <9.6803, 66.7018, -10.7833>, <11.08595, 67.4177, -11.00686> }
					triangle { <8.749, 68.1315, -9.8473>, <8.2025, 69.3278, -9.2964>, <10.02544, 68.8679, -9.8772> }
					triangle { <8.2025, 69.3278, -9.2964>, <9.2994, 69.8784, -9.2298>, <10.02544, 68.8679, -9.8772> }
					triangle { <8.2025, 69.3278, -9.2964>, <8.2298, 70.3486, -8.9422>, <9.2994, 69.8784, -9.2298> }
					triangle { <10.8321, 67.6746, -10.0926>, <11.08595, 67.4177, -11.00686>, <11.9102, 67.9331, -10.3835> }
					triangle { <11.08595, 67.4177, -11.00686>, <11.9066, 67.9949, -10.7855>, <11.9102, 67.9331, -10.3835> }
					triangle { <11.08595, 67.4177, -11.00686>, <10.02544, 68.8679, -9.8772>, <11.9066, 67.9949, -10.7855> }
					triangle { <10.02544, 68.8679, -9.8772>, <10.3018, 70.1634, -8.8903>, <11.9066, 67.9949, -10.7855> }
					triangle { <10.02544, 68.8679, -9.8772>, <9.2994, 69.8784, -9.2298>, <10.3018, 70.1634, -8.8903> }
					triangle { <9.2994, 69.8784, -9.2298>, <9.8648, 70.8071, -8.7546>, <10.3018, 70.1634, -8.8903> }
					triangle { <8.2298, 70.3486, -8.9422>, <8.6121, 71.1532, -8.7725>, <9.2994, 69.8784, -9.2298> }
					triangle { <9.2994, 69.8784, -9.2298>, <8.6121, 71.1532, -8.7725>, <9.8648, 70.8071, -8.7546> }
					triangle { <12.9386, 66.4672, -11.05428>, <11.5148, 66.2215, -10.8159>, <10.8321, 67.6746, -10.0926> }
					triangle { <11.5148, 66.2215, -10.8159>, <10.3566, 66.3222, -10.6337>, <10.8321, 67.6746, -10.0926> }
					triangle { <10.3566, 66.3222, -10.6337>, <9.6803, 66.7018, -10.7833>, <10.8321, 67.6746, -10.0926> }
					triangle { <9.8648, 70.8071, -8.7546>, <8.6121, 71.1532, -8.7725>, <9.4617, 71.4357, -8.8766> }
					triangle { <11.9102, 67.9331, -10.3835>, <12.525, 68.7907, -9.9361>, <12.9386, 66.4672, -11.05428> }
					triangle { <12.7789, 68.5339, -10.8503>, <12.7783, 70.7879, -9.4749>, <13.825, 69.4002, -10.3726> }
					triangle { <11.7184, 69.9841, -9.7207>, <12.7783, 70.7879, -9.4749>, <12.7789, 68.5339, -10.8503> }
					triangle { <12.7789, 68.5339, -10.8503>, <13.825, 69.4002, -10.3726>, <12.525, 68.7907, -9.9361> }
					triangle { <11.7184, 69.9841, -9.7207>, <11.7262, 71.7198, -8.9684>, <12.7783, 70.7879, -9.4749> }
					triangle { <11.7184, 69.9841, -9.7207>, <10.9924, 70.9946, -9.07334>, <11.7262, 71.7198, -8.9684> }
					triangle { <10.9924, 70.9946, -9.07334>, <10.9564, 72.1114, -8.7202>, <11.7262, 71.7198, -8.9684> }
					triangle { <11.9102, 67.9331, -10.3835>, <12.7789, 68.5339, -10.8503>, <12.525, 68.7907, -9.9361> }
					triangle { <11.9102, 67.9331, -10.3835>, <11.9066, 67.9949, -10.7855>, <12.7789, 68.5339, -10.8503> }
					triangle { <11.9066, 67.9949, -10.7855>, <11.7184, 69.9841, -9.7207>, <12.7789, 68.5339, -10.8503> }
					triangle { <11.9066, 67.9949, -10.7855>, <10.3018, 70.1634, -8.8903>, <11.7184, 69.9841, -9.7207> }
					triangle { <10.3018, 70.1634, -8.8903>, <10.9924, 70.9946, -9.07334>, <11.7184, 69.9841, -9.7207> }
					triangle { <10.3018, 70.1634, -8.8903>, <9.8648, 70.8071, -8.7546>, <10.9924, 70.9946, -9.07334> }
					triangle { <10.9924, 70.9946, -9.07334>, <10.106, 72.1374, -8.6922>, <10.9564, 72.1114, -8.7202> }
					triangle { <9.8648, 70.8071, -8.7546>, <10.106, 72.1374, -8.6922>, <10.9924, 70.9946, -9.07334> }
					triangle { <12.525, 68.7907, -9.9361>, <13.3931, 67.4947, -10.6122>, <12.9386, 66.4672, -11.05428> }
					triangle { <12.525, 68.7907, -9.9361>, <13.8441, 68.6215, -10.3114>, <13.3931, 67.4947, -10.6122> }
					triangle { <12.525, 68.7907, -9.9361>, <13.825, 69.4002, -10.3726>, <13.8441, 68.6215, -10.3114> }
					triangle { <9.4617, 71.4357, -8.8766>, <10.106, 72.1374, -8.6922>, <9.8648, 70.8071, -8.7546> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <12.9386, 66.4672, -11.05428>, <13.4753, 68.906, -10.2897>, <13.8184, 68.1646, -11.0937> }
					triangle { <11.9869, 69.2768, -9.6596>, <13.08432, 70.8797, -9.5416>, <12.7528, 68.5307, -10.8406> }
					triangle { <12.7528, 68.5307, -10.8406>, <13.08432, 70.8797, -9.5416>, <13.9556, 70.2554, -10.5534> }
					triangle { <13.4753, 68.906, -10.2897>, <11.9869, 69.2768, -9.6596>, <12.7528, 68.5307, -10.8406> }
					triangle { <13.08432, 70.8797, -9.5416>, <13.92, 72.02514, -9.6938>, <13.9556, 70.2554, -10.5534> }
					triangle { <13.92, 72.02514, -9.6938>, <14.694, 71.4435, -10.451>, <13.9556, 70.2554, -10.5534> }
					triangle { <13.92, 72.02514, -9.6938>, <14.74, 72.5955, -10.1066>, <14.694, 71.4435, -10.451> }
					triangle { <13.4753, 68.906, -10.2897>, <12.7528, 68.5307, -10.8406>, <13.8184, 68.1646, -11.0937> }
					triangle { <12.7528, 68.5307, -10.8406>, <13.5486, 68.1941, -11.3966>, <13.8184, 68.1646, -11.0937> }
					triangle { <12.7528, 68.5307, -10.8406>, <13.9556, 70.2554, -10.5534>, <13.5486, 68.1941, -11.3966> }
					triangle { <13.9556, 70.2554, -10.5534>, <15.494, 70.7931, -10.8228>, <13.5486, 68.1941, -11.3966> }
					triangle { <13.9556, 70.2554, -10.5534>, <14.694, 71.4435, -10.451>, <15.494, 70.7931, -10.8228> }
					triangle { <14.694, 71.4435, -10.451>, <15.7671, 71.523, -10.9513>, <15.494, 70.7931, -10.8228> }
					triangle { <14.74, 72.5955, -10.1066>, <15.446, 72.7471, -10.6552>, <14.694, 71.4435, -10.451> }
					triangle { <14.694, 71.4435, -10.451>, <15.446, 72.7471, -10.6552>, <15.7671, 71.523, -10.9513> }
					triangle { <12.9386, 66.4672, -11.05428>, <12.4272, 67.4981, -10.1486>, <13.4753, 68.906, -10.2897> }
					triangle { <12.4272, 67.4981, -10.1486>, <12.1624, 68.5086, -9.6068>, <13.4753, 68.906, -10.2897> }
					triangle { <12.1624, 68.5086, -9.6068>, <11.9869, 69.2768, -9.6596>, <13.4753, 68.906, -10.2897> }
					triangle { <15.7671, 71.523, -10.9513>, <15.446, 72.7471, -10.6552>, <15.8521, 72.2107, -11.255> }
					triangle { <13.8184, 68.1646, -11.0937>, <14.8522, 68.1621, -11.5887>, <12.9386, 66.4672, -11.05428> }
					triangle { <14.1297, 67.7869, -12.1396>, <16.3612, 69.1094, -12.6332>, <15.3603, 67.4369, -12.8002> }
					triangle { <15.3324, 69.5116, -11.8524>, <16.3612, 69.1094, -12.6332>, <14.1297, 67.7869, -12.1396> }
					triangle { <14.1297, 67.7869, -12.1396>, <15.3603, 67.4369, -12.8002>, <14.8522, 68.1621, -11.5887> }
					triangle { <15.3324, 69.5116, -11.8524>, <16.8242, 70.5165, -12.4388>, <16.3612, 69.1094, -12.6332> }
					triangle { <15.3324, 69.5116, -11.8524>, <16.07095, 70.6997, -11.75>, <16.8242, 70.5165, -12.4388> }
					triangle { <16.07095, 70.6997, -11.75>, <16.9164, 71.3769, -12.1969>, <16.8242, 70.5165, -12.4388> }
					triangle { <13.8184, 68.1646, -11.0937>, <14.1297, 67.7869, -12.1396>, <14.8522, 68.1621, -11.5887> }
					triangle { <13.8184, 68.1646, -11.0937>, <13.5486, 68.1941, -11.3966>, <14.1297, 67.7869, -12.1396> }
					triangle { <13.5486, 68.1941, -11.3966>, <15.3324, 69.5116, -11.8524>, <14.1297, 67.7869, -12.1396> }
					triangle { <13.5486, 68.1941, -11.3966>, <15.494, 70.7931, -10.8228>, <15.3324, 69.5116, -11.8524> }
					triangle { <15.494, 70.7931, -10.8228>, <16.07095, 70.6997, -11.75>, <15.3324, 69.5116, -11.8524> }
					triangle { <15.494, 70.7931, -10.8228>, <15.7671, 71.523, -10.9513>, <16.07095, 70.6997, -11.75> }
					triangle { <16.07095, 70.6997, -11.75>, <16.6172, 72.08916, -11.8391>, <16.9164, 71.3769, -12.1969> }
					triangle { <15.7671, 71.523, -10.9513>, <16.6172, 72.08916, -11.8391>, <16.07095, 70.6997, -11.75> }
					triangle { <14.8522, 68.1621, -11.5887>, <13.9958, 66.6934, -11.5916>, <12.9386, 66.4672, -11.05428> }
					triangle { <14.8522, 68.1621, -11.5887>, <14.9988, 66.9763, -12.2828>, <13.9958, 66.6934, -11.5916> }
					triangle { <14.8522, 68.1621, -11.5887>, <15.3603, 67.4369, -12.8002>, <14.9988, 66.9763, -12.2828> }
					triangle { <15.8521, 72.2107, -11.255>, <16.6172, 72.08916, -11.8391>, <15.7671, 71.523, -10.9513> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <12.9386, 66.4672, -11.05428>, <15.02173, 67.442, -12.2915>, <14.1589, 66.7183, -12.505> }
					triangle { <15.107, 68.8877, -11.4837>, <16.4803, 68.9098, -12.8624>, <14.125, 67.8066, -12.1203> }
					triangle { <14.125, 67.8066, -12.1203>, <16.4803, 68.9098, -12.8624>, <15.7316, 67.816, -13.507> }
					triangle { <15.02173, 67.442, -12.2915>, <15.107, 68.8877, -11.4837>, <14.125, 67.8066, -12.1203> }
					triangle { <16.4803, 68.9098, -12.8624>, <17.3046, 68.8782, -14.02559>, <15.7316, 67.816, -13.507> }
					triangle { <17.3046, 68.8782, -14.02559>, <16.7313, 67.8942, -14.4876>, <15.7316, 67.816, -13.507> }
					triangle { <17.3046, 68.8782, -14.02559>, <17.6212, 68.5243, -14.9964>, <16.7313, 67.8942, -14.4876> }
					triangle { <15.02173, 67.442, -12.2915>, <14.125, 67.8066, -12.1203>, <14.1589, 66.7183, -12.505> }
					triangle { <14.125, 67.8066, -12.1203>, <13.8415, 66.9496, -12.611>, <14.1589, 66.7183, -12.505> }
					triangle { <14.125, 67.8066, -12.1203>, <15.7316, 67.816, -13.507>, <13.8415, 66.9496, -12.611> }
					triangle { <15.7316, 67.816, -13.507>, <16.4204, 66.8579, -14.6628>, <13.8415, 66.9496, -12.611> }
					triangle { <15.7316, 67.816, -13.507>, <16.7313, 67.8942, -14.4876>, <16.4204, 66.8579, -14.6628> }
					triangle { <16.7313, 67.8942, -14.4876>, <16.8201, 67.04967, -15.3164>, <16.4204, 66.8579, -14.6628> }
					triangle { <17.6212, 68.5243, -14.9964>, <17.568, 68.02078, -15.7487>, <16.7313, 67.8942, -14.4876> }
					triangle { <16.7313, 67.8942, -14.4876>, <17.568, 68.02078, -15.7487>, <16.8201, 67.04967, -15.3164> }
					triangle { <12.9386, 66.4672, -11.05428>, <13.9657, 67.4968, -10.8834>, <15.02173, 67.442, -12.2915> }
					triangle { <13.9657, 67.4968, -10.8834>, <14.8062, 68.3048, -11.04375>, <15.02173, 67.442, -12.2915> }
					triangle { <14.8062, 68.3048, -11.04375>, <15.107, 68.8877, -11.4837>, <15.02173, 67.442, -12.2915> }
					triangle { <16.8201, 67.04967, -15.3164>, <17.568, 68.02078, -15.7487>, <16.9922, 67.3674, -15.9812> }
					triangle { <14.1589, 66.7183, -12.505>, <14.1925, 65.8592, -13.2629>, <12.9386, 66.4672, -11.05428> }
					triangle { <13.2958, 66.2238, -13.0918>, <14.5069, 65.1427, -15.1743>, <13.09761, 65.00065, -13.825> }
					triangle { <14.9024, 66.2332, -14.4784>, <14.5069, 65.1427, -15.1743>, <13.2958, 66.2238, -13.0918> }
					triangle { <13.2958, 66.2238, -13.0918>, <13.09761, 65.00065, -13.825>, <14.1925, 65.8592, -13.2629> }
					triangle { <14.9024, 66.2332, -14.4784>, <15.584, 65.5741, -16.1154>, <14.5069, 65.1427, -15.1743> }
					triangle { <14.9024, 66.2332, -14.4784>, <15.9021, 66.3114, -15.4591>, <15.584, 65.5741, -16.1154> }
					triangle { <15.9021, 66.3114, -15.4591>, <16.26, 65.997, -16.5298>, <15.584, 65.5741, -16.1154> }
					triangle { <14.1589, 66.7183, -12.505>, <13.2958, 66.2238, -13.0918>, <14.1925, 65.8592, -13.2629> }
					triangle { <14.1589, 66.7183, -12.505>, <13.8415, 66.9496, -12.611>, <13.2958, 66.2238, -13.0918> }
					triangle { <13.8415, 66.9496, -12.611>, <14.9024, 66.2332, -14.4784>, <13.2958, 66.2238, -13.0918> }
					triangle { <13.8415, 66.9496, -12.611>, <16.4204, 66.8579, -14.6628>, <14.9024, 66.2332, -14.4784> }
					triangle { <16.4204, 66.8579, -14.6628>, <15.9021, 66.3114, -15.4591>, <14.9024, 66.2332, -14.4784> }
					triangle { <16.4204, 66.8579, -14.6628>, <16.8201, 67.04967, -15.3164>, <15.9021, 66.3114, -15.4591> }
					triangle { <15.9021, 66.3114, -15.4591>, <16.7901, 66.6581, -16.6116>, <16.26, 65.997, -16.5298> }
					triangle { <16.8201, 67.04967, -15.3164>, <16.7901, 66.6581, -16.6116>, <15.9021, 66.3114, -15.4591> }
					triangle { <14.1925, 65.8592, -13.2629>, <13.07158, 65.7189, -11.9924>, <12.9386, 66.4672, -11.05428> }
					triangle { <14.1925, 65.8592, -13.2629>, <13.09818, 65.04422, -13.04486>, <13.07158, 65.7189, -11.9924> }
					triangle { <14.1925, 65.8592, -13.2629>, <13.09761, 65.00065, -13.825>, <13.09818, 65.04422, -13.04486> }
					triangle { <16.9922, 67.3674, -15.9812>, <16.7901, 66.6581, -16.6116>, <16.8201, 67.04967, -15.3164> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <12.9386, 66.4672, -11.05428>, <13.3486, 65.2921, -13.3502>, <12.4642, 65.5795, -12.6802> }
					triangle { <14.7578, 66.06855, -13.7517>, <14.2756, 64.9258, -15.2514>, <13.319, 66.2394, -13.08941> }
					triangle { <13.319, 66.2394, -13.08941>, <14.2756, 64.9258, -15.2514>, <12.9156, 64.8981, -14.6838> }
					triangle { <13.3486, 65.2921, -13.3502>, <14.7578, 66.06855, -13.7517>, <13.319, 66.2394, -13.08941> }
					triangle { <14.2756, 64.9258, -15.2514>, <13.7106, 64.2068, -16.3456>, <12.9156, 64.8981, -14.6838> }
					triangle { <13.7106, 64.2068, -16.3456>, <12.6148, 64.1023, -15.7989>, <12.9156, 64.8981, -14.6838> }
					triangle { <13.7106, 64.2068, -16.3456>, <12.9186, 63.7232, -16.8997>, <12.6148, 64.1023, -15.7989> }
					triangle { <13.3486, 65.2921, -13.3502>, <13.319, 66.2394, -13.08941>, <12.4642, 65.5795, -12.6802> }
					triangle { <13.319, 66.2394, -13.08941>, <12.3833, 65.9697, -12.7617>, <12.4642, 65.5795, -12.6802> }
					triangle { <13.319, 66.2394, -13.08941>, <12.9156, 64.8981, -14.6838>, <12.3833, 65.9697, -12.7617> }
					triangle { <12.9156, 64.8981, -14.6838>, <11.8093, 63.7594, -15.1395>, <12.3833, 65.9697, -12.7617> }
					triangle { <12.9156, 64.8981, -14.6838>, <12.6148, 64.1023, -15.7989>, <11.8093, 63.7594, -15.1395> }
					triangle { <12.6148, 64.1023, -15.7989>, <11.5785, 63.5274, -15.8583>, <11.8093, 63.7594, -15.1395> }
					triangle { <12.9186, 63.7232, -16.8997>, <12.06559, 63.4617, -17.06162>, <12.6148, 64.1023, -15.7989> }
					triangle { <12.6148, 64.1023, -15.7989>, <12.06559, 63.4617, -17.06162>, <11.5785, 63.5274, -15.8583> }
					triangle { <12.9386, 66.4672, -11.05428>, <14.01866, 66.2196, -12.0117>, <13.3486, 65.2921, -13.3502> }
					triangle { <14.01866, 66.2196, -12.0117>, <14.659, 65.9905, -12.972>, <13.3486, 65.2921, -13.3502> }
					triangle { <14.659, 65.9905, -12.972>, <14.7578, 66.06855, -13.7517>, <13.3486, 65.2921, -13.3502> }
					triangle { <11.5785, 63.5274, -15.8583>, <12.06559, 63.4617, -17.06162>, <11.3171, 63.5539, -16.5679> }
					triangle { <12.4642, 65.5795, -12.6802>, <11.4516, 65.04298, -12.6606>, <12.9386, 66.4672, -11.05428> }
					triangle { <11.4219, 65.9902, -12.3998>, <9.7606, 64.3328, -13.6102>, <10.1428, 65.4355, -12.04025> }
					triangle { <11.01859, 64.649, -13.9942>, <9.7606, 64.3328, -13.6102>, <11.4219, 65.9902, -12.3998> }
					triangle { <11.4219, 65.9902, -12.3998>, <10.1428, 65.4355, -12.04025>, <11.4516, 65.04298, -12.6606> }
					triangle { <11.01859, 64.649, -13.9942>, <9.708, 63.6769, -14.9515>, <9.7606, 64.3328, -13.6102> }
					triangle { <11.01859, 64.649, -13.9942>, <10.7177, 63.8532, -15.1093>, <9.708, 63.6769, -14.9515> }
					triangle { <10.7177, 63.8532, -15.1093>, <9.8882, 63.3563, -15.7714>, <9.708, 63.6769, -14.9515> }
					triangle { <12.4642, 65.5795, -12.6802>, <11.4219, 65.9902, -12.3998>, <11.4516, 65.04298, -12.6606> }
					triangle { <12.4642, 65.5795, -12.6802>, <12.3833, 65.9697, -12.7617>, <11.4219, 65.9902, -12.3998> }
					triangle { <12.3833, 65.9697, -12.7617>, <11.01859, 64.649, -13.9942>, <11.4219, 65.9902, -12.3998> }
					triangle { <12.3833, 65.9697, -12.7617>, <11.8093, 63.7594, -15.1395>, <11.01859, 64.649, -13.9942> }
					triangle { <11.8093, 63.7594, -15.1395>, <10.7177, 63.8532, -15.1093>, <11.01859, 64.649, -13.9942> }
					triangle { <11.8093, 63.7594, -15.1395>, <11.5785, 63.5274, -15.8583>, <10.7177, 63.8532, -15.1093> }
					triangle { <10.7177, 63.8532, -15.1093>, <10.3872, 63.2991, -16.4587>, <9.8882, 63.3563, -15.7714> }
					triangle { <11.5785, 63.5274, -15.8583>, <10.3872, 63.2991, -16.4587>, <10.7177, 63.8532, -15.1093> }
					triangle { <11.4516, 65.04298, -12.6606>, <11.889, 65.9088, -11.2644>, <12.9386, 66.4672, -11.05428> }
					triangle { <11.4516, 65.04298, -12.6606>, <10.751, 65.4772, -11.5515>, <11.889, 65.9088, -11.2644> }
					triangle { <11.4516, 65.04298, -12.6606>, <10.1428, 65.4355, -12.04025>, <10.751, 65.4772, -11.5515> }
					triangle { <11.3171, 63.5539, -16.5679>, <10.3872, 63.2991, -16.4587>, <11.5785, 63.5274, -15.8583> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <12.9386, 66.4672, -11.05428>, <10.7202, 65.438, -11.9706>, <11.05349, 66.3417, -11.3492> }
					triangle { <11.3534, 64.6972, -13.3123>, <9.4252, 64.4375, -13.3599>, <11.4124, 65.9954, -12.3908> }
					triangle { <11.4124, 65.9954, -12.3908>, <9.4252, 64.4375, -13.3599>, <9.3358, 65.5581, -12.4066> }
					triangle { <10.7202, 65.438, -11.9706>, <11.3534, 64.6972, -13.3123>, <11.4124, 65.9954, -12.3908> }
					triangle { <9.4252, 64.4375, -13.3599>, <8.000337, 64.4888, -13.3787>, <9.3358, 65.5581, -12.4066> }
					triangle { <8.000337, 64.4888, -13.3787>, <7.9523, 65.3472, -12.5003>, <9.3358, 65.5581, -12.4066> }
					triangle { <8.000337, 64.4888, -13.3787>, <7.02683, 64.8678, -13.1015>, <7.9523, 65.3472, -12.5003> }
					triangle { <10.7202, 65.438, -11.9706>, <11.4124, 65.9954, -12.3908>, <11.05349, 66.3417, -11.3492> }
					triangle { <11.4124, 65.9954, -12.3908>, <11.1694, 66.6255, -11.6165>, <11.05349, 66.3417, -11.3492> }
					triangle { <11.4124, 65.9954, -12.3908>, <9.3358, 65.5581, -12.4066>, <11.1694, 66.6255, -11.6165> }
					triangle { <9.3358, 65.5581, -12.4066>, <7.9707, 65.8331, -11.5181>, <11.1694, 66.6255, -11.6165> }
					triangle { <9.3358, 65.5581, -12.4066>, <7.9523, 65.3472, -12.5003>, <7.9707, 65.8331, -11.5181> }
					triangle { <7.9523, 65.3472, -12.5003>, <7.215, 65.8847, -11.7416>, <7.9707, 65.8331, -11.5181> }
					triangle { <7.02683, 64.8678, -13.1015>, <6.4469, 65.4269, -12.6849>, <7.9523, 65.3472, -12.5003> }
					triangle { <7.9523, 65.3472, -12.5003>, <6.4469, 65.4269, -12.6849>, <7.215, 65.8847, -11.7416> }
					triangle { <12.9386, 66.4672, -11.05428>, <12.481, 65.4195, -11.9693>, <10.7202, 65.438, -11.9706> }
					triangle { <12.481, 65.4195, -11.9693>, <11.8675, 64.7467, -12.7148>, <10.7202, 65.438, -11.9706> }
					triangle { <11.8675, 64.7467, -12.7148>, <11.3534, 64.6972, -13.3123>, <10.7202, 65.438, -11.9706> }
					triangle { <7.215, 65.8847, -11.7416>, <6.4469, 65.4269, -12.6849>, <6.5927, 66.1061, -12.1107> }
					triangle { <11.05349, 66.3417, -11.3492>, <10.4055, 66.8821, -10.5735>, <12.9386, 66.4672, -11.05428> }
					triangle { <11.09766, 67.4395, -10.9936>, <8.6761, 67.8744, -10.03466>, <10.5992, 68.1957, -9.8743> }
					triangle { <9.02104, 67.0022, -11.00948>, <8.6761, 67.8744, -10.03466>, <11.09766, 67.4395, -10.9936> }
					triangle { <11.09766, 67.4395, -10.9936>, <10.5992, 68.1957, -9.8743>, <10.4055, 66.8821, -10.5735> }
					triangle { <9.02104, 67.0022, -11.00948>, <7.2877, 67.5324, -10.4677>, <8.6761, 67.8744, -10.03466> }
					triangle { <9.02104, 67.0022, -11.00948>, <7.6375, 66.7913, -11.1031>, <7.2877, 67.5324, -10.4677> }
					triangle { <7.6375, 66.7913, -11.1031>, <6.5609, 67.1922, -10.8719>, <7.2877, 67.5324, -10.4677> }
					triangle { <11.05349, 66.3417, -11.3492>, <11.09766, 67.4395, -10.9936>, <10.4055, 66.8821, -10.5735> }
					triangle { <11.05349, 66.3417, -11.3492>, <11.1694, 66.6255, -11.6165>, <11.09766, 67.4395, -10.9936> }
					triangle { <11.1694, 66.6255, -11.6165>, <9.02104, 67.0022, -11.00948>, <11.09766, 67.4395, -10.9936> }
					triangle { <11.1694, 66.6255, -11.6165>, <7.9707, 65.8331, -11.5181>, <9.02104, 67.0022, -11.00948> }
					triangle { <7.9707, 65.8331, -11.5181>, <7.6375, 66.7913, -11.1031>, <9.02104, 67.0022, -11.00948> }
					triangle { <7.9707, 65.8331, -11.5181>, <7.215, 65.8847, -11.7416>, <7.6375, 66.7913, -11.1031> }
					triangle { <7.6375, 66.7913, -11.1031>, <6.1939, 66.7366, -11.4903>, <6.5609, 67.1922, -10.8719> }
					triangle { <7.215, 65.8847, -11.7416>, <6.1939, 66.7366, -11.4903>, <7.6375, 66.7913, -11.1031> }
					triangle { <10.4055, 66.8821, -10.5735>, <12.09077, 67.02294, -10.3985>, <12.9386, 66.4672, -11.05428> }
					triangle { <10.4055, 66.8821, -10.5735>, <11.219, 67.7215, -9.8366>, <12.09077, 67.02294, -10.3985> }
					triangle { <10.4055, 66.8821, -10.5735>, <10.5992, 68.1957, -9.8743>, <11.219, 67.7215, -9.8366> }
					triangle { <6.5927, 66.1061, -12.1107>, <6.1939, 66.7366, -11.4903>, <7.215, 65.8847, -11.7416> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <13.804, 36.4243, 3.2949>, <14.1415, 37.2555, 3.3678>, 0.8 }
			cylinder { <14.1415, 37.2555, 3.3678>, <14.4791, 38.0866, 3.4407>, 0.8 }
			cylinder { <14.4791, 38.0866, 3.4407>, <14.8167, 38.9177, 3.5136>, 0.8 }
			cylinder { <14.8167, 38.9177, 3.5136>, <15.1542, 39.7488, 3.5865>, 0.8 }
			cylinder { <15.1542, 39.7488, 3.5865>, <15.4918, 40.5799, 3.6595>, 0.8 }
			cylinder { <15.4918, 40.5799, 3.6595>, <15.8294, 41.411, 3.7324>, 0.8 }
			cylinder { <15.8294, 41.411, 3.7324>, <16.1669, 42.2421, 3.8053>, 0.8 }
			cylinder { <16.1669, 42.2421, 3.8053>, <16.5045, 43.07323, 3.8782>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <16.5045, 43.07323, 3.8782>, <18.05876, 47.07856, 4.8731>, 0.8 }
				cylinder { <18.05876, 47.07856, 4.8731>, <19.4794, 50.9301, 6.484>, 0.8 }
				cylinder { <19.4794, 50.9301, 6.484>, <20.7359, 54.5445, 8.6762>, 0.8 }
				cylinder { <20.7359, 54.5445, 8.6762>, <21.8009, 57.8435, 11.402>, 0.8 }
				cylinder { <21.8009, 57.8435, 11.402>, <22.6514, 60.7558, 14.6026>, 0.8 }
				cylinder { <22.6514, 60.7558, 14.6026>, <23.2689, 63.2181, 18.2086>, 0.8 }
				cylinder { <23.2689, 63.2181, 18.2086>, <23.6402, 65.1774, 22.142>, 0.8 }
				cylinder { <23.6402, 65.1774, 22.142>, <23.7571, 66.5911, 26.3177>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <23.7571, 66.5911, 26.3177>, <25.9148, 66.03767, 27.1926>, <25.3753, 66.8957, 26.9172> }
					triangle { <25.5232, 64.7579, 27.9124>, <27.2426, 65.06679, 28.2714>, <25.1064, 66.1174, 27.5819> }
					triangle { <25.1064, 66.1174, 27.5819>, <27.2426, 65.06679, 28.2714>, <27.01421, 66.3409, 27.8858> }
					triangle { <25.9148, 66.03767, 27.1926>, <25.5232, 64.7579, 27.9124>, <25.1064, 66.1174, 27.5819> }
					triangle { <27.2426, 65.06679, 28.2714>, <28.4322, 65.4914, 28.6061>, <27.01421, 66.3409, 27.8858> }
					triangle { <28.4322, 65.4914, 28.6061>, <28.2515, 66.52, 28.1842>, <27.01421, 66.3409, 27.8858> }
					triangle { <28.4322, 65.4914, 28.6061>, <29.1514, 66.164, 28.7126>, <28.2515, 66.52, 28.1842> }
					triangle { <25.9148, 66.03767, 27.1926>, <25.1064, 66.1174, 27.5819>, <25.3753, 66.8957, 26.9172> }
					triangle { <25.1064, 66.1174, 27.5819>, <25.16, 66.9805, 27.2094>, <25.3753, 66.8957, 26.9172> }
					triangle { <25.1064, 66.1174, 27.5819>, <27.01421, 66.3409, 27.8858>, <25.16, 66.9805, 27.2094> }
					triangle { <27.01421, 66.3409, 27.8858>, <28.1484, 67.2802, 27.5361>, <25.16, 66.9805, 27.2094> }
					triangle { <27.01421, 66.3409, 27.8858>, <28.2515, 66.52, 28.1842>, <28.1484, 67.2802, 27.5361> }
					triangle { <28.2515, 66.52, 28.1842>, <28.7544, 67.4405, 27.8978>, <28.1484, 67.2802, 27.5361> }
					triangle { <29.1514, 66.164, 28.7126>, <29.4867, 66.9237, 28.6822>, <28.2515, 66.52, 28.1842> }
					triangle { <28.2515, 66.52, 28.1842>, <29.4867, 66.9237, 28.6822>, <28.7544, 67.4405, 27.8978> }
					triangle { <23.7571, 66.5911, 26.3177>, <24.4278, 65.5394, 26.8124>, <25.9148, 66.03767, 27.1926> }
					triangle { <24.4278, 65.5394, 26.8124>, <25.1173, 64.8899, 27.3279>, <25.9148, 66.03767, 27.1926> }
					triangle { <25.1173, 64.8899, 27.3279>, <25.5232, 64.7579, 27.9124>, <25.9148, 66.03767, 27.1926> }
					triangle { <28.7544, 67.4405, 27.8978>, <29.4867, 66.9237, 28.6822>, <29.1784, 67.6396, 28.4091> }
					triangle { <25.3753, 66.8957, 26.9172>, <25.8028, 67.8007, 26.5988>, <23.7571, 66.5911, 26.3177> }
					triangle { <24.9944, 67.8805, 26.9881>, <26.9761, 69.2629, 26.8583>, <25.2491, 69.04789, 26.4283> }
					triangle { <26.9022, 68.104, 27.2921>, <26.9761, 69.2629, 26.8583>, <24.9944, 67.8805, 26.9881> }
					triangle { <24.9944, 67.8805, 26.9881>, <25.2491, 69.04789, 26.4283>, <25.8028, 67.8007, 26.5988> }
					triangle { <26.9022, 68.104, 27.2921>, <28.2353, 69.2077, 27.3928>, <26.9761, 69.2629, 26.8583> }
					triangle { <26.9022, 68.104, 27.2921>, <28.1395, 68.283, 27.5905>, <28.2353, 69.2077, 27.3928> }
					triangle { <28.1395, 68.283, 27.5905>, <28.9351, 68.9831, 27.7642>, <28.2353, 69.2077, 27.3928> }
					triangle { <25.3753, 66.8957, 26.9172>, <24.9944, 67.8805, 26.9881>, <25.8028, 67.8007, 26.5988> }
					triangle { <25.3753, 66.8957, 26.9172>, <25.16, 66.9805, 27.2094>, <24.9944, 67.8805, 26.9881> }
					triangle { <25.16, 66.9805, 27.2094>, <26.9022, 68.104, 27.2921>, <24.9944, 67.8805, 26.9881> }
					triangle { <25.16, 66.9805, 27.2094>, <28.1484, 67.2802, 27.5361>, <26.9022, 68.104, 27.2921> }
					triangle { <28.1484, 67.2802, 27.5361>, <28.1395, 68.283, 27.5905>, <26.9022, 68.104, 27.2921> }
					triangle { <28.1484, 67.2802, 27.5361>, <28.7544, 67.4405, 27.8978>, <28.1395, 68.283, 27.5905> }
					triangle { <28.1395, 68.283, 27.5905>, <29.352, 68.4854, 28.1966>, <28.9351, 68.9831, 27.7642> }
					triangle { <28.7544, 67.4405, 27.8978>, <29.352, 68.4854, 28.1966>, <28.1395, 68.283, 27.5905> }
					triangle { <25.8028, 67.8007, 26.5988>, <24.3396, 67.5158, 26.1457>, <23.7571, 66.5911, 26.3177> }
					triangle { <25.8028, 67.8007, 26.5988>, <24.8867, 68.5218, 26.1048>, <24.3396, 67.5158, 26.1457> }
					triangle { <25.8028, 67.8007, 26.5988>, <25.2491, 69.04789, 26.4283>, <24.8867, 68.5218, 26.1048> }
					triangle { <29.1784, 67.6396, 28.4091>, <29.352, 68.4854, 28.1966>, <28.7544, 67.4405, 27.8978> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <23.7571, 66.5911, 26.3177>, <25.2107, 68.4911, 26.3816>, <24.1862, 68.2822, 26.4811> }
					triangle { <26.4623, 67.7769, 26.864>, <26.8421, 69.5172, 26.7759>, <25.01073, 67.8615, 26.9941> }
					triangle { <25.01073, 67.8615, 26.9941>, <26.8421, 69.5172, 26.7759>, <25.5082, 69.7294, 26.7808> }
					triangle { <25.2107, 68.4911, 26.3816>, <26.4623, 67.7769, 26.864>, <25.01073, 67.8615, 26.9941> }
					triangle { <26.8421, 69.5172, 26.7759>, <26.9441, 70.8182, 26.8444>, <25.5082, 69.7294, 26.7808> }
					triangle { <26.9441, 70.8182, 26.8444>, <25.8329, 70.9725, 26.7445>, <25.5082, 69.7294, 26.7808> }
					triangle { <26.9441, 70.8182, 26.8444>, <26.6035, 71.7469, 26.8938>, <25.8329, 70.9725, 26.7445> }
					triangle { <25.2107, 68.4911, 26.3816>, <25.01073, 67.8615, 26.9941>, <24.1862, 68.2822, 26.4811> }
					triangle { <25.01073, 67.8615, 26.9941>, <24.1368, 68.1735, 26.8342>, <24.1862, 68.2822, 26.4811> }
					triangle { <25.01073, 67.8615, 26.9941>, <25.5082, 69.7294, 26.7808>, <24.1368, 68.1735, 26.8342> }
					triangle { <25.5082, 69.7294, 26.7808>, <24.913, 71.05271, 26.3495>, <24.1368, 68.1735, 26.8342> }
					triangle { <25.5082, 69.7294, 26.7808>, <25.8329, 70.9725, 26.7445>, <24.913, 71.05271, 26.3495> }
					triangle { <25.8329, 70.9725, 26.7445>, <25.07659, 71.7289, 26.549>, <24.913, 71.05271, 26.3495> }
					triangle { <26.6035, 71.7469, 26.8938>, <26.02057, 72.3366, 26.9467>, <25.8329, 70.9725, 26.7445> }
					triangle { <25.8329, 70.9725, 26.7445>, <26.02057, 72.3366, 26.9467>, <25.07659, 71.7289, 26.549> }
					triangle { <23.7571, 66.5911, 26.3177>, <25.06641, 66.8845, 26.3391>, <25.2107, 68.4911, 26.3816> }
					triangle { <25.06641, 66.8845, 26.3391>, <26.02895, 67.3533, 26.4684>, <25.2107, 68.4911, 26.3816> }
					triangle { <26.02895, 67.3533, 26.4684>, <26.4623, 67.7769, 26.864>, <25.2107, 68.4911, 26.3816> }
					triangle { <25.07659, 71.7289, 26.549>, <26.02057, 72.3366, 26.9467>, <25.1963, 72.2826, 26.9487> }
					triangle { <24.1862, 68.2822, 26.4811>, <23.4097, 68.9585, 26.2739>, <23.7571, 66.5911, 26.3177> }
					triangle { <23.2097, 68.3289, 26.8863>, <22.5557, 70.6295, 26.5194>, <22.067, 68.9054, 26.5657> }
					triangle { <23.7072, 70.1968, 26.673>, <22.5557, 70.6295, 26.5194>, <23.2097, 68.3289, 26.8863> }
					triangle { <23.2097, 68.3289, 26.8863>, <22.067, 68.9054, 26.5657>, <23.4097, 68.9585, 26.2739> }
					triangle { <23.7072, 70.1968, 26.673>, <23.1726, 71.8456, 26.6415>, <22.5557, 70.6295, 26.5194> }
					triangle { <23.7072, 70.1968, 26.673>, <24.03199, 71.4399, 26.6367>, <23.1726, 71.8456, 26.6415> }
					triangle { <24.03199, 71.4399, 26.6367>, <23.7124, 72.4606, 26.7331>, <23.1726, 71.8456, 26.6415> }
					triangle { <24.1862, 68.2822, 26.4811>, <23.2097, 68.3289, 26.8863>, <23.4097, 68.9585, 26.2739> }
					triangle { <24.1862, 68.2822, 26.4811>, <24.1368, 68.1735, 26.8342>, <23.2097, 68.3289, 26.8863> }
					triangle { <24.1368, 68.1735, 26.8342>, <23.7072, 70.1968, 26.673>, <23.2097, 68.3289, 26.8863> }
					triangle { <24.1368, 68.1735, 26.8342>, <24.913, 71.05271, 26.3495>, <23.7072, 70.1968, 26.673> }
					triangle { <24.913, 71.05271, 26.3495>, <24.03199, 71.4399, 26.6367>, <23.7072, 70.1968, 26.673> }
					triangle { <24.913, 71.05271, 26.3495>, <25.07659, 71.7289, 26.549>, <24.03199, 71.4399, 26.6367> }
					triangle { <24.03199, 71.4399, 26.6367>, <24.4271, 72.7258, 26.8989>, <23.7124, 72.4606, 26.7331> }
					triangle { <25.07659, 71.7289, 26.549>, <24.4271, 72.7258, 26.8989>, <24.03199, 71.4399, 26.6367> }
					triangle { <23.4097, 68.9585, 26.2739>, <23.05885, 67.442, 26.2066>, <23.7571, 66.5911, 26.3177> }
					triangle { <23.4097, 68.9585, 26.2739>, <22.3189, 68.3161, 26.2463>, <23.05885, 67.442, 26.2066> }
					triangle { <23.4097, 68.9585, 26.2739>, <22.067, 68.9054, 26.5657>, <22.3189, 68.3161, 26.2463> }
					triangle { <25.1963, 72.2826, 26.9487>, <24.4271, 72.7258, 26.8989>, <25.07659, 71.7289, 26.549> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <23.7571, 66.5911, 26.3177>, <22.5372, 68.6482, 26.4034>, <22.4339, 67.659, 26.7411> }
					triangle { <23.7234, 69.5947, 26.3252>, <22.26, 70.5908, 26.5408>, <23.2337, 68.3374, 26.8827> }
					triangle { <23.2337, 68.3374, 26.8827>, <22.26, 70.5908, 26.5408>, <21.6529, 69.4662, 26.9779> }
					triangle { <22.5372, 68.6482, 26.4034>, <23.7234, 69.5947, 26.3252>, <23.2337, 68.3374, 26.8827> }
					triangle { <22.26, 70.5908, 26.5408>, <21.152, 71.1955, 26.8788>, <21.6529, 69.4662, 26.9779> }
					triangle { <21.152, 71.1955, 26.8788>, <20.6329, 70.231, 27.1412>, <21.6529, 69.4662, 26.9779> }
					triangle { <21.152, 71.1955, 26.8788>, <20.2313, 71.2532, 27.2394>, <20.6329, 70.231, 27.1412> }
					triangle { <22.5372, 68.6482, 26.4034>, <23.2337, 68.3374, 26.8827>, <22.4339, 67.659, 26.7411> }
					triangle { <23.2337, 68.3374, 26.8827>, <22.6291, 67.6373, 27.05801>, <22.4339, 67.659, 26.7411> }
					triangle { <23.2337, 68.3374, 26.8827>, <21.6529, 69.4662, 26.9779>, <22.6291, 67.6373, 27.05801> }
					triangle { <21.6529, 69.4662, 26.9779>, <20.1452, 69.357, 27.0571>, <22.6291, 67.6373, 27.05801> }
					triangle { <21.6529, 69.4662, 26.9779>, <20.6329, 70.231, 27.1412>, <20.1452, 69.357, 27.0571> }
					triangle { <20.6329, 70.231, 27.1412>, <19.6568, 69.8014, 27.3533>, <20.1452, 69.357, 27.0571> }
					triangle { <20.2313, 71.2532, 27.2394>, <19.5384, 70.9619, 27.5936>, <20.6329, 70.231, 27.1412> }
					triangle { <20.6329, 70.231, 27.1412>, <19.5384, 70.9619, 27.5936>, <19.6568, 69.8014, 27.3533> }
					triangle { <23.7571, 66.5911, 26.3177>, <23.9132, 67.8925, 26.0302>, <22.5372, 68.6482, 26.4034> }
					triangle { <23.9132, 67.8925, 26.0302>, <23.8385, 68.9673, 25.9833>, <22.5372, 68.6482, 26.4034> }
					triangle { <23.8385, 68.9673, 25.9833>, <23.7234, 69.5947, 26.3252>, <22.5372, 68.6482, 26.4034> }
					triangle { <19.6568, 69.8014, 27.3533>, <19.5384, 70.9619, 27.5936>, <19.3283, 70.1957, 27.8195> }
					triangle { <22.4339, 67.659, 26.7411>, <21.5192, 67.1783, 26.9295>, <23.7571, 66.5911, 26.3177> }
					triangle { <22.2157, 66.8675, 27.4089>, <19.8373, 67.09251, 27.793>, <21.2387, 65.9962, 27.5738> }
					triangle { <20.635, 67.9963, 27.504>, <19.8373, 67.09251, 27.793>, <22.2157, 66.8675, 27.4089> }
					triangle { <22.2157, 66.8675, 27.4089>, <21.2387, 65.9962, 27.5738>, <21.5192, 67.1783, 26.9295> }
					triangle { <20.635, 67.9963, 27.504>, <18.9841, 68.1403, 28.01334>, <19.8373, 67.09251, 27.793> }
					triangle { <20.635, 67.9963, 27.504>, <19.615, 68.7611, 27.6673>, <18.9841, 68.1403, 28.01334> }
					triangle { <19.615, 68.7611, 27.6673>, <18.6339, 68.8819, 28.08702>, <18.9841, 68.1403, 28.01334> }
					triangle { <22.4339, 67.659, 26.7411>, <22.2157, 66.8675, 27.4089>, <21.5192, 67.1783, 26.9295> }
					triangle { <22.4339, 67.659, 26.7411>, <22.6291, 67.6373, 27.05801>, <22.2157, 66.8675, 27.4089> }
					triangle { <22.6291, 67.6373, 27.05801>, <20.635, 67.9963, 27.504>, <22.2157, 66.8675, 27.4089> }
					triangle { <22.6291, 67.6373, 27.05801>, <20.1452, 69.357, 27.0571>, <20.635, 67.9963, 27.504> }
					triangle { <20.1452, 69.357, 27.0571>, <19.615, 68.7611, 27.6673>, <20.635, 67.9963, 27.504> }
					triangle { <20.1452, 69.357, 27.0571>, <19.6568, 69.8014, 27.3533>, <19.615, 68.7611, 27.6673> }
					triangle { <19.615, 68.7611, 27.6673>, <18.6748, 69.6608, 28.09772>, <18.6339, 68.8819, 28.08702> }
					triangle { <19.6568, 69.8014, 27.3533>, <18.6748, 69.6608, 28.09772>, <19.615, 68.7611, 27.6673> }
					triangle { <21.5192, 67.1783, 26.9295>, <22.7419, 66.2658, 26.6137>, <23.7571, 66.5911, 26.3177> }
					triangle { <21.5192, 67.1783, 26.9295>, <21.7415, 65.9393, 27.06721>, <22.7419, 66.2658, 26.6137> }
					triangle { <21.5192, 67.1783, 26.9295>, <21.2387, 65.9962, 27.5738>, <21.7415, 65.9393, 27.06721> }
					triangle { <19.3283, 70.1957, 27.8195>, <18.6748, 69.6608, 28.09772>, <19.6568, 69.8014, 27.3533> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <23.7571, 66.5911, 26.3177>, <21.564, 66.2932, 27.2279>, <22.5237, 65.8816, 27.3404> }
					triangle { <21.06609, 67.716, 27.03576>, <19.7858, 66.8139, 27.8888>, <22.2145, 66.8918, 27.4007> }
					triangle { <22.2145, 66.8918, 27.4007>, <19.7858, 66.8139, 27.8888>, <20.7402, 65.9125, 28.2066> }
					triangle { <21.564, 66.2932, 27.2279>, <21.06609, 67.716, 27.03576>, <22.2145, 66.8918, 27.4007> }
					triangle { <19.7858, 66.8139, 27.8888>, <19.00635, 66.1055, 28.6622>, <20.7402, 65.9125, 28.2066> }
					triangle { <19.00635, 66.1055, 28.6622>, <19.7891, 65.3133, 28.8297>, <20.7402, 65.9125, 28.2066> }
					triangle { <19.00635, 66.1055, 28.6622>, <18.7815, 65.3606, 29.275>, <19.7891, 65.3133, 28.8297> }
					triangle { <21.564, 66.2932, 27.2279>, <22.2145, 66.8918, 27.4007>, <22.5237, 65.8816, 27.3404> }
					triangle { <22.2145, 66.8918, 27.4007>, <22.7063, 66.1078, 27.5736>, <22.5237, 65.8816, 27.3404> }
					triangle { <22.2145, 66.8918, 27.4007>, <20.7402, 65.9125, 28.2066>, <22.7063, 66.1078, 27.5736> }
					triangle { <20.7402, 65.9125, 28.2066>, <20.3895, 64.5208, 28.6876>, <22.7063, 66.1078, 27.5736> }
					triangle { <20.7402, 65.9125, 28.2066>, <19.7891, 65.3133, 28.8297>, <20.3895, 64.5208, 28.6876> }
					triangle { <19.7891, 65.3133, 28.8297>, <19.9345, 64.3038, 29.2068>, <20.3895, 64.5208, 28.6876> }
					triangle { <18.7815, 65.3606, 29.275>, <18.9379, 64.6865, 29.735>, <19.7891, 65.3133, 28.8297> }
					triangle { <19.7891, 65.3133, 28.8297>, <18.9379, 64.6865, 29.735>, <19.9345, 64.3038, 29.2068> }
					triangle { <23.7571, 66.5911, 26.3177>, <22.5512, 67.1797, 26.3096>, <21.564, 66.2932, 27.2279> }
					triangle { <22.5512, 67.1797, 26.3096>, <21.5526, 67.5164, 26.5385>, <21.564, 66.2932, 27.2279> }
					triangle { <21.5526, 67.5164, 26.5385>, <21.06609, 67.716, 27.03576>, <21.564, 66.2932, 27.2279> }
					triangle { <19.9345, 64.3038, 29.2068>, <18.9379, 64.6865, 29.735>, <19.629, 64.2434, 29.8263> }
					triangle { <22.5237, 65.8816, 27.3404>, <22.7263, 64.9037, 27.6658>, <23.7571, 66.5911, 26.3177> }
					triangle { <23.3769, 65.5023, 27.8386>, <22.5523, 63.5069, 28.9309>, <23.9012, 64.3136, 28.06888> }
					triangle { <21.9026, 64.523, 28.6444>, <22.5523, 63.5069, 28.9309>, <23.3769, 65.5023, 27.8386> }
					triangle { <23.3769, 65.5023, 27.8386>, <23.9012, 64.3136, 28.06888>, <22.7263, 64.9037, 27.6658> }
					triangle { <21.9026, 64.523, 28.6444>, <21.4191, 63.1777, 29.6252>, <22.5523, 63.5069, 28.9309> }
					triangle { <21.9026, 64.523, 28.6444>, <20.9515, 63.9238, 29.2676>, <21.4191, 63.1777, 29.6252> }
					triangle { <20.9515, 63.9238, 29.2676>, <20.6704, 63.1592, 29.9674>, <21.4191, 63.1777, 29.6252> }
					triangle { <22.5237, 65.8816, 27.3404>, <23.3769, 65.5023, 27.8386>, <22.7263, 64.9037, 27.6658> }
					triangle { <22.5237, 65.8816, 27.3404>, <22.7063, 66.1078, 27.5736>, <23.3769, 65.5023, 27.8386> }
					triangle { <22.7063, 66.1078, 27.5736>, <21.9026, 64.523, 28.6444>, <23.3769, 65.5023, 27.8386> }
					triangle { <22.7063, 66.1078, 27.5736>, <20.3895, 64.5208, 28.6876>, <21.9026, 64.523, 28.6444> }
					triangle { <20.3895, 64.5208, 28.6876>, <20.9515, 63.9238, 29.2676>, <21.9026, 64.523, 28.6444> }
					triangle { <20.3895, 64.5208, 28.6876>, <19.9345, 64.3038, 29.2068>, <20.9515, 63.9238, 29.2676> }
					triangle { <20.9515, 63.9238, 29.2676>, <19.9909, 63.4975, 30.1475>, <20.6704, 63.1592, 29.9674> }
					triangle { <19.9345, 64.3038, 29.2068>, <19.9909, 63.4975, 30.1475>, <20.9515, 63.9238, 29.2676> }
					triangle { <22.7263, 64.9037, 27.6658>, <23.824, 65.6016, 26.8082>, <23.7571, 66.5911, 26.3177> }
					triangle { <22.7263, 64.9037, 27.6658>, <23.9471, 64.654, 27.4405>, <23.824, 65.6016, 26.8082> }
					triangle { <22.7263, 64.9037, 27.6658>, <23.9012, 64.3136, 28.06888>, <23.9471, 64.654, 27.4405> }
					triangle { <19.629, 64.2434, 29.8263>, <19.9909, 63.4975, 30.1475>, <19.9345, 64.3038, 29.2068> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <23.7571, 66.5911, 26.3177>, <23.6829, 64.6554, 27.723>, <24.369, 65.4027, 27.4508> }
					triangle { <22.1952, 64.6815, 28.03147>, <22.9117, 63.3483, 28.9745>, <23.3894, 65.4991, 27.8393> }
					triangle { <23.3894, 65.4991, 27.8393>, <22.9117, 63.3483, 28.9745>, <24.1037, 63.9518, 28.7762> }
					triangle { <23.6829, 64.6554, 27.723>, <22.1952, 64.6815, 28.03147>, <23.3894, 65.4991, 27.8393> }
					triangle { <22.9117, 63.3483, 28.9745>, <23.5736, 62.527, 29.7458>, <24.1037, 63.9518, 28.7762> }
					triangle { <23.5736, 62.527, 29.7458>, <24.5687, 62.9851, 29.4841>, <24.1037, 63.9518, 28.7762> }
					triangle { <23.5736, 62.527, 29.7458>, <24.3776, 62.1678, 30.1992>, <24.5687, 62.9851, 29.4841> }
					triangle { <23.6829, 64.6554, 27.723>, <23.3894, 65.4991, 27.8393>, <24.369, 65.4027, 27.4508> }
					triangle { <23.3894, 65.4991, 27.8393>, <24.2941, 65.6958, 27.6686>, <24.369, 65.4027, 27.4508> }
					triangle { <23.3894, 65.4991, 27.8393>, <24.1037, 63.9518, 28.7762>, <24.2941, 65.6958, 27.6686> }
					triangle { <24.1037, 63.9518, 28.7762>, <25.4104, 63.2179, 28.9881>, <24.2941, 65.6958, 27.6686> }
					triangle { <24.1037, 63.9518, 28.7762>, <24.5687, 62.9851, 29.4841>, <25.4104, 63.2179, 28.9881> }
					triangle { <24.5687, 62.9851, 29.4841>, <25.642, 62.8227, 29.5484>, <25.4104, 63.2179, 28.9881> }
					triangle { <24.3776, 62.1678, 30.1992>, <25.1792, 62.1531, 30.4179>, <24.5687, 62.9851, 29.4841> }
					triangle { <24.5687, 62.9851, 29.4841>, <25.1792, 62.1531, 30.4179>, <25.642, 62.8227, 29.5484> }
					triangle { <23.7571, 66.5911, 26.3177>, <22.8741, 65.7034, 26.8004>, <23.6829, 64.6554, 27.723> }
					triangle { <22.8741, 65.7034, 26.8004>, <22.3549, 64.9584, 27.3821>, <23.6829, 64.6554, 27.723> }
					triangle { <22.3549, 64.9584, 27.3821>, <22.1952, 64.6815, 28.03147>, <23.6829, 64.6554, 27.723> }
					triangle { <25.642, 62.8227, 29.5484>, <25.1792, 62.1531, 30.4179>, <25.8085, 62.6398, 30.1962> }
					triangle { <24.369, 65.4027, 27.4508>, <25.4137, 65.2942, 27.4583>, <23.7571, 66.5911, 26.3177> }
					triangle { <25.1201, 66.1378, 27.5746>, <27.03097, 64.8685, 28.3445>, <26.4172, 66.2281, 27.3502> }
					triangle { <25.8344, 64.5905, 28.5115>, <27.03097, 64.8685, 28.3445>, <25.1201, 66.1378, 27.5746> }
					triangle { <25.1201, 66.1378, 27.5746>, <26.4172, 66.2281, 27.3502>, <25.4137, 65.2942, 27.4583> }
					triangle { <25.8344, 64.5905, 28.5115>, <27.223, 63.8474, 29.2359>, <27.03097, 64.8685, 28.3445> }
					triangle { <25.8344, 64.5905, 28.5115>, <26.2995, 63.6238, 29.2194>, <27.223, 63.8474, 29.2359> }
					triangle { <26.2995, 63.6238, 29.2194>, <27.133, 63.2227, 29.7649>, <27.223, 63.8474, 29.2359> }
					triangle { <24.369, 65.4027, 27.4508>, <25.1201, 66.1378, 27.5746>, <25.4137, 65.2942, 27.4583> }
					triangle { <24.369, 65.4027, 27.4508>, <24.2941, 65.6958, 27.6686>, <25.1201, 66.1378, 27.5746> }
					triangle { <24.2941, 65.6958, 27.6686>, <25.8344, 64.5905, 28.5115>, <25.1201, 66.1378, 27.5746> }
					triangle { <24.2941, 65.6958, 27.6686>, <25.4104, 63.2179, 28.9881>, <25.8344, 64.5905, 28.5115> }
					triangle { <25.4104, 63.2179, 28.9881>, <26.2995, 63.6238, 29.2194>, <25.8344, 64.5905, 28.5115> }
					triangle { <25.4104, 63.2179, 28.9881>, <25.642, 62.8227, 29.5484>, <26.2995, 63.6238, 29.2194> }
					triangle { <26.2995, 63.6238, 29.2194>, <26.6894, 62.76, 30.2095>, <27.133, 63.2227, 29.7649> }
					triangle { <25.642, 62.8227, 29.5484>, <26.6894, 62.76, 30.2095>, <26.2995, 63.6238, 29.2194> }
					triangle { <25.4137, 65.2942, 27.4583>, <24.8263, 66.3859, 26.5146>, <23.7571, 66.5911, 26.3177> }
					triangle { <25.4137, 65.2942, 27.4583>, <25.9203, 66.2742, 26.8368>, <24.8263, 66.3859, 26.5146> }
					triangle { <25.4137, 65.2942, 27.4583>, <26.4172, 66.2281, 27.3502>, <25.9203, 66.2742, 26.8368> }
					triangle { <25.8085, 62.6398, 30.1962>, <26.6894, 62.76, 30.2095>, <25.642, 62.8227, 29.5484> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <16.5045, 43.07323, 3.8782>, <16.8421, 43.9043, 3.9511>, 0.8 }
			cylinder { <16.8421, 43.9043, 3.9511>, <17.1796, 44.7354, 4.02409>, 0.8 }
			cylinder { <17.1796, 44.7354, 4.02409>, <17.5172, 45.5665, 4.097>, 0.8 }
			cylinder { <17.5172, 45.5665, 4.097>, <17.8548, 46.3976, 4.1699>, 0.8 }
			cylinder { <17.8548, 46.3976, 4.1699>, <18.1923, 47.2287, 4.2428>, 0.8 }
			cylinder { <18.1923, 47.2287, 4.2428>, <18.5299, 48.05985, 4.3157>, 0.8 }
			cylinder { <18.5299, 48.05985, 4.3157>, <18.8675, 48.8909, 4.3886>, 0.8 }
			cylinder { <18.8675, 48.8909, 4.3886>, <19.205, 49.722, 4.4615>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.205, 49.722, 4.4615>, <21.301, 53.6013, 4.3847>, 0.8 }
				cylinder { <21.301, 53.6013, 4.3847>, <23.7934, 57.2036, 3.8754>, 0.8 }
				cylinder { <23.7934, 57.2036, 3.8754>, <26.6284, 60.4509, 2.9447>, 0.8 }
				cylinder { <26.6284, 60.4509, 2.9447>, <29.7446, 63.2728, 1.6127>, 0.8 }
				cylinder { <29.7446, 63.2728, 1.6127>, <33.07459, 65.6083, -0.09167>, 0.8 }
				cylinder { <33.07459, 65.6083, -0.09167>, <36.5461, 67.4068, -2.1316>, 0.8 }
				cylinder { <36.5461, 67.4068, -2.1316>, <40.08419, 68.6295, -4.463>, 0.8 }
				cylinder { <40.08419, 68.6295, -4.463>, <43.6121, 69.2498, -7.03541>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <43.6121, 69.2498, -7.03541>, <42.8271, 70.1502, -9.109>, <43.3801, 70.4672, -8.2742> }
					triangle { <42.8037, 68.8536, -9.9011>, <42.362, 70.1699, -11.02034>, <43.5339, 69.6308, -8.904> }
					triangle { <43.5339, 69.6308, -8.904>, <42.362, 70.1699, -11.02034>, <42.9147, 71.01426, -10.1225> }
					triangle { <42.8271, 70.1502, -9.109>, <42.8037, 68.8536, -9.9011>, <43.5339, 69.6308, -8.904> }
					triangle { <42.362, 70.1699, -11.02034>, <42.2301, 71.2271, -11.777>, <42.9147, 71.01426, -10.1225> }
					triangle { <42.2301, 71.2271, -11.777>, <42.6, 71.9245, -10.9737>, <42.9147, 71.01426, -10.1225> }
					triangle { <42.2301, 71.2271, -11.777>, <42.314, 72.1871, -12.00566>, <42.6, 71.9245, -10.9737> }
					triangle { <42.8271, 70.1502, -9.109>, <43.5339, 69.6308, -8.904>, <43.3801, 70.4672, -8.2742> }
					triangle { <43.5339, 69.6308, -8.904>, <43.7301, 70.3532, -8.3329>, <43.3801, 70.4672, -8.2742> }
					triangle { <43.5339, 69.6308, -8.904>, <42.9147, 71.01426, -10.1225>, <43.7301, 70.3532, -8.3329> }
					triangle { <42.9147, 71.01426, -10.1225>, <42.632, 72.5009, -10.1518>, <43.7301, 70.3532, -8.3329> }
					triangle { <42.9147, 71.01426, -10.1225>, <42.6, 71.9245, -10.9737>, <42.632, 72.5009, -10.1518> }
					triangle { <42.6, 71.9245, -10.9737>, <42.6628, 72.9745, -10.6982>, <42.632, 72.5009, -10.1518> }
					triangle { <42.314, 72.1871, -12.00566>, <42.5439, 72.9762, -11.8833>, <42.6, 71.9245, -10.9737> }
					triangle { <42.6, 71.9245, -10.9737>, <42.5439, 72.9762, -11.8833>, <42.6628, 72.9745, -10.6982> }
					triangle { <43.6121, 69.2498, -7.03541>, <43.03549, 68.8484, -8.1786>, <42.8271, 70.1502, -9.109> }
					triangle { <43.03549, 68.8484, -8.1786>, <42.6841, 68.756, -9.194>, <42.8271, 70.1502, -9.109> }
					triangle { <42.6841, 68.756, -9.194>, <42.8037, 68.8536, -9.9011>, <42.8271, 70.1502, -9.109> }
					triangle { <42.6628, 72.9745, -10.6982>, <42.5439, 72.9762, -11.8833>, <42.9058, 73.3391, -11.2356> }
					triangle { <43.3801, 70.4672, -8.2742>, <43.4502, 71.46, -7.9386>, <43.6121, 69.2498, -7.03541> }
					triangle { <44.157, 70.9405, -7.7336>, <43.845, 73.2871, -8.2347>, <44.2943, 72.0442, -7.02362> }
					triangle { <43.5378, 72.324, -8.9521>, <43.845, 73.2871, -8.2347>, <44.157, 70.9405, -7.7336> }
					triangle { <44.157, 70.9405, -7.7336>, <44.2943, 72.0442, -7.02362>, <43.4502, 71.46, -7.9386> }
					triangle { <43.5378, 72.324, -8.9521>, <43.5499, 74.00888, -9.3601>, <43.845, 73.2871, -8.2347> }
					triangle { <43.5378, 72.324, -8.9521>, <43.2231, 73.2342, -9.8032>, <43.5499, 74.00888, -9.3601> }
					triangle { <43.2231, 73.2342, -9.8032>, <43.3295, 74.2567, -10.1138>, <43.5499, 74.00888, -9.3601> }
					triangle { <43.3801, 70.4672, -8.2742>, <44.157, 70.9405, -7.7336>, <43.4502, 71.46, -7.9386> }
					triangle { <43.3801, 70.4672, -8.2742>, <43.7301, 70.3532, -8.3329>, <44.157, 70.9405, -7.7336> }
					triangle { <43.7301, 70.3532, -8.3329>, <43.5378, 72.324, -8.9521>, <44.157, 70.9405, -7.7336> }
					triangle { <43.7301, 70.3532, -8.3329>, <42.632, 72.5009, -10.1518>, <43.5378, 72.324, -8.9521> }
					triangle { <42.632, 72.5009, -10.1518>, <43.2231, 73.2342, -9.8032>, <43.5378, 72.324, -8.9521> }
					triangle { <42.632, 72.5009, -10.1518>, <42.6628, 72.9745, -10.6982>, <43.2231, 73.2342, -9.8032> }
					triangle { <43.2231, 73.2342, -9.8032>, <43.1407, 74.1081, -10.8559>, <43.3295, 74.2567, -10.1138> }
					triangle { <42.6628, 72.9745, -10.6982>, <43.1407, 74.1081, -10.8559>, <43.2231, 73.2342, -9.8032> }
					triangle { <43.4502, 71.46, -7.9386>, <43.7147, 70.3414, -6.887>, <43.6121, 69.2498, -7.03541> }
					triangle { <43.4502, 71.46, -7.9386>, <43.9677, 71.4541, -6.783>, <43.7147, 70.3414, -6.887> }
					triangle { <43.4502, 71.46, -7.9386>, <44.2943, 72.0442, -7.02362>, <43.9677, 71.4541, -6.783> }
					triangle { <42.9058, 73.3391, -11.2356>, <43.1407, 74.1081, -10.8559>, <42.6628, 72.9745, -10.6982> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <43.6121, 69.2498, -7.03541>, <43.9765, 71.6106, -7.1805>, <44.437, 70.7696, -6.7517> }
					triangle { <43.2885, 71.8436, -8.5153>, <43.9955, 73.3981, -8.001467>, <44.1425, 70.9364, -7.7544> }
					triangle { <44.1425, 70.9364, -7.7544>, <43.9955, 73.3981, -8.001467>, <44.7769, 72.6785, -7.1672> }
					triangle { <43.9765, 71.6106, -7.1805>, <43.2885, 71.8436, -8.5153>, <44.1425, 70.9364, -7.7544> }
					triangle { <43.9955, 73.3981, -8.001467>, <44.7047, 74.4244, -7.6121>, <44.7769, 72.6785, -7.1672> }
					triangle { <44.7047, 74.4244, -7.6121>, <45.2734, 73.8208, -6.8499>, <44.7769, 72.6785, -7.1672> }
					triangle { <44.7047, 74.4244, -7.6121>, <45.4164, 74.8851, -7.1001>, <45.2734, 73.8208, -6.8499> }
					triangle { <43.9765, 71.6106, -7.1805>, <44.1425, 70.9364, -7.7544>, <44.437, 70.7696, -6.7517> }
					triangle { <44.1425, 70.9364, -7.7544>, <44.6395, 70.6134, -7.02294>, <44.437, 70.7696, -6.7517> }
					triangle { <44.1425, 70.9364, -7.7544>, <44.7769, 72.6785, -7.1672>, <44.6395, 70.6134, -7.02294> }
					triangle { <44.7769, 72.6785, -7.1672>, <45.5077, 73.3237, -6.009354>, <44.6395, 70.6134, -7.02294> }
					triangle { <44.7769, 72.6785, -7.1672>, <45.2734, 73.8208, -6.8499>, <45.5077, 73.3237, -6.009354> }
					triangle { <45.2734, 73.8208, -6.8499>, <45.9319, 73.9098, -5.9892>, <45.5077, 73.3237, -6.009354> }
					triangle { <45.4164, 74.8851, -7.1001>, <46.06474, 74.934, -6.5826>, <45.2734, 73.8208, -6.8499> }
					triangle { <45.2734, 73.8208, -6.8499>, <46.06474, 74.934, -6.5826>, <45.9319, 73.9098, -5.9892> }
					triangle { <43.6121, 69.2498, -7.03541>, <43.1381, 70.3261, -7.6815>, <43.9765, 71.6106, -7.1805> }
					triangle { <43.1381, 70.3261, -7.6815>, <43.00486, 71.2918, -8.1427>, <43.9765, 71.6106, -7.1805> }
					triangle { <43.00486, 71.2918, -8.1427>, <43.2885, 71.8436, -8.5153>, <43.9765, 71.6106, -7.1805> }
					triangle { <45.9319, 73.9098, -5.9892>, <46.06474, 74.934, -6.5826>, <46.4452, 74.3517, -6.1371> }
					triangle { <44.437, 70.7696, -6.7517>, <45.05372, 70.7873, -5.9017>, <43.6121, 69.2498, -7.03541> }
					triangle { <45.2197, 70.1131, -6.4756>, <46.5593, 71.4386, -4.9578>, <45.887, 69.8295, -5.3732> }
					triangle { <45.8541, 71.8552, -5.8884>, <46.5593, 71.4386, -4.9578>, <45.2197, 70.1131, -6.4756> }
					triangle { <45.2197, 70.1131, -6.4756>, <45.887, 69.8295, -5.3732>, <45.05372, 70.7873, -5.9017> }
					triangle { <45.8541, 71.8552, -5.8884>, <47.00266, 72.7337, -4.9321>, <46.5593, 71.4386, -4.9578> }
					triangle { <45.8541, 71.8552, -5.8884>, <46.3505, 72.9975, -5.5711>, <47.00266, 72.7337, -4.9321> }
					triangle { <46.3505, 72.9975, -5.5711>, <47.1339, 73.5348, -5.07021>, <47.00266, 72.7337, -4.9321> }
					triangle { <44.437, 70.7696, -6.7517>, <45.2197, 70.1131, -6.4756>, <45.05372, 70.7873, -5.9017> }
					triangle { <44.437, 70.7696, -6.7517>, <44.6395, 70.6134, -7.02294>, <45.2197, 70.1131, -6.4756> }
					triangle { <44.6395, 70.6134, -7.02294>, <45.8541, 71.8552, -5.8884>, <45.2197, 70.1131, -6.4756> }
					triangle { <44.6395, 70.6134, -7.02294>, <45.5077, 73.3237, -6.009354>, <45.8541, 71.8552, -5.8884> }
					triangle { <45.5077, 73.3237, -6.009354>, <46.3505, 72.9975, -5.5711>, <45.8541, 71.8552, -5.8884> }
					triangle { <45.5077, 73.3237, -6.009354>, <45.9319, 73.9098, -5.9892>, <46.3505, 72.9975, -5.5711> }
					triangle { <46.3505, 72.9975, -5.5711>, <47.03648, 74.1817, -5.4951>, <47.1339, 73.5348, -5.07021> }
					triangle { <45.9319, 73.9098, -5.9892>, <47.03648, 74.1817, -5.4951>, <46.3505, 72.9975, -5.5711> }
					triangle { <45.05372, 70.7873, -5.9017>, <44.3506, 69.437, -6.233>, <43.6121, 69.2498, -7.03541> }
					triangle { <45.05372, 70.7873, -5.9017>, <45.2238, 69.5957, -5.5083>, <44.3506, 69.437, -6.233> }
					triangle { <45.05372, 70.7873, -5.9017>, <45.887, 69.8295, -5.3732>, <45.2238, 69.5957, -5.5083> }
					triangle { <46.4452, 74.3517, -6.1371>, <47.03648, 74.1817, -5.4951>, <45.9319, 73.9098, -5.9892> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <43.6121, 69.2498, -7.03541>, <45.4034, 69.9671, -5.6198>, <45.1393, 69.1226, -6.1856> }
					triangle { <45.2817, 71.4604, -5.874>, <46.6991, 71.2128, -4.8204>, <45.2101, 70.1356, -6.4833> }
					triangle { <45.2101, 70.1356, -6.4833>, <46.6991, 71.2128, -4.8204>, <46.6775, 69.9242, -5.2247> }
					triangle { <45.4034, 69.9671, -5.6198>, <45.2817, 71.4604, -5.874>, <45.2101, 70.1356, -6.4833> }
					triangle { <46.6991, 71.2128, -4.8204>, <47.808, 70.893, -4.2075>, <46.6775, 69.9242, -5.2247> }
					triangle { <47.808, 70.893, -4.2075>, <47.7129, 69.8026, -4.473>, <46.6775, 69.9242, -5.2247> }
					triangle { <47.808, 70.893, -4.2075>, <48.539, 70.2868, -3.9262>, <47.7129, 69.8026, -4.473> }
					triangle { <45.4034, 69.9671, -5.6198>, <45.2101, 70.1356, -6.4833>, <45.1393, 69.1226, -6.1856> }
					triangle { <45.2101, 70.1356, -6.4833>, <45.2438, 69.1962, -6.5358>, <45.1393, 69.1226, -6.1856> }
					triangle { <45.2101, 70.1356, -6.4833>, <46.6775, 69.9242, -5.2247>, <45.2438, 69.1962, -6.5358> }
					triangle { <46.6775, 69.9242, -5.2247>, <47.4188, 68.8423, -4.469>, <45.2438, 69.1962, -6.5358> }
					triangle { <46.6775, 69.9242, -5.2247>, <47.7129, 69.8026, -4.473>, <47.4188, 68.8423, -4.469> }
					triangle { <47.7129, 69.8026, -4.473>, <48.1042, 68.8156, -4.2383>, <47.4188, 68.8423, -4.469> }
					triangle { <48.539, 70.2868, -3.9262>, <48.9613, 69.5715, -3.9029>, <47.7129, 69.8026, -4.473> }
					triangle { <47.7129, 69.8026, -4.473>, <48.9613, 69.5715, -3.9029>, <48.1042, 68.8156, -4.2383> }
					triangle { <43.6121, 69.2498, -7.03541>, <44.05516, 70.3552, -6.4168>, <45.4034, 69.9671, -5.6198> }
					triangle { <44.05516, 70.3552, -6.4168>, <44.6503, 71.111, -5.9296>, <45.4034, 69.9671, -5.6198> }
					triangle { <44.6503, 71.111, -5.9296>, <45.2817, 71.4604, -5.874>, <45.4034, 69.9671, -5.6198> }
					triangle { <48.1042, 68.8156, -4.2383>, <48.9613, 69.5715, -3.9029>, <48.7973, 68.8362, -4.2413> }
					triangle { <45.1393, 69.1226, -6.1856>, <45.4561, 68.1408, -5.9879>, <43.6121, 69.2498, -7.03541> }
					triangle { <45.2628, 68.3093, -6.8514>, <46.8245, 66.8663, -5.6966>, <45.3804, 66.999, -6.7505> }
					triangle { <46.7302, 68.09801, -5.5928>, <46.8245, 66.8663, -5.6966>, <45.2628, 68.3093, -6.8514> }
					triangle { <45.2628, 68.3093, -6.8514>, <45.3804, 66.999, -6.7505>, <45.4561, 68.1408, -5.9879> }
					triangle { <46.7302, 68.09801, -5.5928>, <47.9708, 67.05785, -4.9729>, <46.8245, 66.8663, -5.6966> }
					triangle { <46.7302, 68.09801, -5.5928>, <47.7656, 67.9763, -4.8411>, <47.9708, 67.05785, -4.9729> }
					triangle { <47.7656, 67.9763, -4.8411>, <48.601, 67.3701, -4.5446>, <47.9708, 67.05785, -4.9729> }
					triangle { <45.1393, 69.1226, -6.1856>, <45.2628, 68.3093, -6.8514>, <45.4561, 68.1408, -5.9879> }
					triangle { <45.1393, 69.1226, -6.1856>, <45.2438, 69.1962, -6.5358>, <45.2628, 68.3093, -6.8514> }
					triangle { <45.2438, 69.1962, -6.5358>, <46.7302, 68.09801, -5.5928>, <45.2628, 68.3093, -6.8514> }
					triangle { <45.2438, 69.1962, -6.5358>, <47.4188, 68.8423, -4.469>, <46.7302, 68.09801, -5.5928> }
					triangle { <47.4188, 68.8423, -4.469>, <47.7656, 67.9763, -4.8411>, <46.7302, 68.09801, -5.5928> }
					triangle { <47.4188, 68.8423, -4.469>, <48.1042, 68.8156, -4.2383>, <47.7656, 67.9763, -4.8411> }
					triangle { <47.7656, 67.9763, -4.8411>, <49.01523, 67.9749, -4.2779>, <48.601, 67.3701, -4.5446> }
					triangle { <48.1042, 68.8156, -4.2383>, <49.01523, 67.9749, -4.2779>, <47.7656, 67.9763, -4.8411> }
					triangle { <45.4561, 68.1408, -5.9879>, <44.1365, 68.3045, -6.7998>, <43.6121, 69.2498, -7.03541> }
					triangle { <45.4561, 68.1408, -5.9879>, <44.7588, 67.3489, -6.6879>, <44.1365, 68.3045, -6.7998> }
					triangle { <45.4561, 68.1408, -5.9879>, <45.3804, 66.999, -6.7505>, <44.7588, 67.3489, -6.6879> }
					triangle { <48.7973, 68.8362, -4.2413>, <49.01523, 67.9749, -4.2779>, <48.1042, 68.8156, -4.2383> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <43.6121, 69.2498, -7.03541>, <45.1492, 67.4757, -6.5692>, <44.523, 67.7869, -7.3529> }
					triangle { <46.04743, 68.2299, -5.6028>, <46.7617, 66.6136, -5.8437>, <45.2712, 68.3276, -6.8355> }
					triangle { <45.2712, 68.3276, -6.8355>, <46.7617, 66.6136, -5.8437>, <46.00772, 66.5321, -6.9613> }
					triangle { <45.1492, 67.4757, -6.5692>, <46.04743, 68.2299, -5.6028>, <45.2712, 68.3276, -6.8355> }
					triangle { <46.7617, 66.6136, -5.8437>, <47.2803, 65.4803, -6.2364>, <46.00772, 66.5321, -6.9613> }
					triangle { <47.2803, 65.4803, -6.2364>, <46.5702, 65.3854, -7.1055>, <46.00772, 66.5321, -6.9613> }
					triangle { <47.2803, 65.4803, -6.2364>, <47.3956, 64.7041, -6.8406>, <46.5702, 65.3854, -7.1055> }
					triangle { <45.1492, 67.4757, -6.5692>, <45.2712, 68.3276, -6.8355>, <44.523, 67.7869, -7.3529> }
					triangle { <45.2712, 68.3276, -6.8355>, <44.7135, 68.04692, -7.5402>, <44.523, 67.7869, -7.3529> }
					triangle { <45.2712, 68.3276, -6.8355>, <46.00772, 66.5321, -6.9613>, <44.7135, 68.04692, -7.5402> }
					triangle { <46.00772, 66.5321, -6.9613>, <45.7419, 65.2081, -7.6451>, <44.7135, 68.04692, -7.5402> }
					triangle { <46.00772, 66.5321, -6.9613>, <46.5702, 65.3854, -7.1055>, <45.7419, 65.2081, -7.6451> }
					triangle { <46.5702, 65.3854, -7.1055>, <46.198, 64.6844, -7.8488>, <45.7419, 65.2081, -7.6451> }
					triangle { <47.3956, 64.7041, -6.8406>, <47.2578, 64.2496, -7.5226>, <46.5702, 65.3854, -7.1055> }
					triangle { <46.5702, 65.3854, -7.1055>, <47.2578, 64.2496, -7.5226>, <46.198, 64.6844, -7.8488> }
					triangle { <43.6121, 69.2498, -7.03541>, <44.5278, 68.8957, -6.1205>, <45.1492, 67.4757, -6.5692> }
					triangle { <44.5278, 68.8957, -6.1205>, <45.3619, 68.4618, -5.5924>, <45.1492, 67.4757, -6.5692> }
					triangle { <45.3619, 68.4618, -5.5924>, <46.04743, 68.2299, -5.6028>, <45.1492, 67.4757, -6.5692> }
					triangle { <46.198, 64.6844, -7.8488>, <47.2578, 64.2496, -7.5226>, <46.7334, 64.3633, -8.1505> }
					triangle { <44.523, 67.7869, -7.3529>, <44.1051, 67.1533, -8.079>, <43.6121, 69.2498, -7.03541> }
					triangle { <44.2271, 68.0052, -8.3453>, <44.2766, 65.8463, -9.4369>, <43.4699, 67.4379, -9.2649> }
					triangle { <44.9635, 66.2097, -8.4711>, <44.2766, 65.8463, -9.4369>, <44.2271, 68.0052, -8.3453> }
					triangle { <44.2271, 68.0052, -8.3453>, <43.4699, 67.4379, -9.2649>, <44.1051, 67.1533, -8.079> }
					triangle { <44.9635, 66.2097, -8.4711>, <45.1255, 64.7721, -9.4265>, <44.2766, 65.8463, -9.4369> }
					triangle { <44.9635, 66.2097, -8.4711>, <45.526, 65.06303, -8.6152>, <45.1255, 64.7721, -9.4265> }
					triangle { <45.526, 65.06303, -8.6152>, <45.717, 64.2245, -9.2585>, <45.1255, 64.7721, -9.4265> }
					triangle { <44.523, 67.7869, -7.3529>, <44.2271, 68.0052, -8.3453>, <44.1051, 67.1533, -8.079> }
					triangle { <44.523, 67.7869, -7.3529>, <44.7135, 68.04692, -7.5402>, <44.2271, 68.0052, -8.3453> }
					triangle { <44.7135, 68.04692, -7.5402>, <44.9635, 66.2097, -8.4711>, <44.2271, 68.0052, -8.3453> }
					triangle { <44.7135, 68.04692, -7.5402>, <45.7419, 65.2081, -7.6451>, <44.9635, 66.2097, -8.4711> }
					triangle { <45.7419, 65.2081, -7.6451>, <45.526, 65.06303, -8.6152>, <44.9635, 66.2097, -8.4711> }
					triangle { <45.7419, 65.2081, -7.6451>, <46.198, 64.6844, -7.8488>, <45.526, 65.06303, -8.6152> }
					triangle { <45.526, 65.06303, -8.6152>, <46.3608, 64.00751, -8.8751>, <45.717, 64.2245, -9.2585> }
					triangle { <46.198, 64.6844, -7.8488>, <46.3608, 64.00751, -8.8751>, <45.526, 65.06303, -8.6152> }
					triangle { <44.1051, 67.1533, -8.079>, <43.3663, 68.4983, -7.8093>, <43.6121, 69.2498, -7.03541> }
					triangle { <44.1051, 67.1533, -8.079>, <43.211, 67.7976, -8.7025>, <43.3663, 68.4983, -7.8093> }
					triangle { <44.1051, 67.1533, -8.079>, <43.4699, 67.4379, -9.2649>, <43.211, 67.7976, -8.7025> }
					triangle { <46.7334, 64.3633, -8.1505>, <46.3608, 64.00751, -8.8751>, <46.198, 64.6844, -7.8488> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <43.6121, 69.2498, -7.03541>, <43.5329, 67.5906, -8.7582>, <43.4194, 68.6305, -8.6632> }
					triangle { <44.4928, 66.5945, -8.1293>, <44.04075, 65.9594, -9.7332>, <44.2196, 68.01093, -8.3541> }
					triangle { <44.2196, 68.01093, -8.3541>, <44.04075, 65.9594, -9.7332>, <43.647, 67.2159, -10.03411> }
					triangle { <43.5329, 67.5906, -8.7582>, <44.4928, 66.5945, -8.1293>, <44.2196, 68.01093, -8.3541> }
					triangle { <44.04075, 65.9594, -9.7332>, <43.7809, 65.6899, -10.9853>, <43.647, 67.2159, -10.03411> }
					triangle { <43.7809, 65.6899, -10.9853>, <43.3625, 66.7166, -11.1838>, <43.647, 67.2159, -10.03411> }
					triangle { <43.7809, 65.6899, -10.9853>, <43.4903, 65.8962, -11.9093>, <43.3625, 66.7166, -11.1838> }
					triangle { <43.5329, 67.5906, -8.7582>, <44.2196, 68.01093, -8.3541>, <43.4194, 68.6305, -8.6632> }
					triangle { <44.2196, 68.01093, -8.3541>, <43.7639, 68.7727, -8.6677>, <43.4194, 68.6305, -8.6632> }
					triangle { <44.2196, 68.01093, -8.3541>, <43.647, 67.2159, -10.03411>, <43.7639, 68.7727, -8.6677> }
					triangle { <43.647, 67.2159, -10.03411>, <42.7388, 67.5034, -11.2104>, <43.7639, 68.7727, -8.6677> }
					triangle { <43.647, 67.2159, -10.03411>, <43.3625, 66.7166, -11.1838>, <42.7388, 67.5034, -11.2104> }
					triangle { <43.3625, 66.7166, -11.1838>, <42.7843, 67.2936, -11.9015>, <42.7388, 67.5034, -11.2104> }
					triangle { <43.4903, 65.8962, -11.9093>, <43.2318, 66.3856, -12.5292>, <43.3625, 66.7166, -11.1838> }
					triangle { <43.3625, 66.7166, -11.1838>, <43.2318, 66.3856, -12.5292>, <42.7843, 67.2936, -11.9015> }
					triangle { <43.6121, 69.2498, -7.03541>, <43.8881, 67.9504, -7.2258>, <43.5329, 67.5906, -8.7582> }
					triangle { <43.8881, 67.9504, -7.2258>, <44.1284, 66.9844, -7.6404>, <43.5329, 67.5906, -8.7582> }
					triangle { <44.1284, 66.9844, -7.6404>, <44.4928, 66.5945, -8.1293>, <43.5329, 67.5906, -8.7582> }
					triangle { <42.7843, 67.2936, -11.9015>, <43.2318, 66.3856, -12.5292>, <43.0374, 67.1883, -12.5384> }
					triangle { <43.4194, 68.6305, -8.6632>, <42.8467, 69.2356, -9.3028>, <43.6121, 69.2498, -7.03541> }
					triangle { <43.5333, 69.6559, -8.8987>, <42.4074, 69.8745, -11.02934>, <42.7885, 70.6031, -9.4363> }
					triangle { <42.9608, 68.8609, -10.5786>, <42.4074, 69.8745, -11.02934>, <43.5333, 69.6559, -8.8987> }
					triangle { <43.5333, 69.6559, -8.8987>, <42.7885, 70.6031, -9.4363>, <42.8467, 69.2356, -9.3028> }
					triangle { <42.9608, 68.8609, -10.5786>, <42.3519, 69.133, -12.1788>, <42.4074, 69.8745, -11.02934> }
					triangle { <42.9608, 68.8609, -10.5786>, <42.6762, 68.3616, -11.7283>, <42.3519, 69.133, -12.1788> }
					triangle { <42.6762, 68.3616, -11.7283>, <42.4099, 68.545, -12.7524>, <42.3519, 69.133, -12.1788> }
					triangle { <43.4194, 68.6305, -8.6632>, <43.5333, 69.6559, -8.8987>, <42.8467, 69.2356, -9.3028> }
					triangle { <43.4194, 68.6305, -8.6632>, <43.7639, 68.7727, -8.6677>, <43.5333, 69.6559, -8.8987> }
					triangle { <43.7639, 68.7727, -8.6677>, <42.9608, 68.8609, -10.5786>, <43.5333, 69.6559, -8.8987> }
					triangle { <43.7639, 68.7727, -8.6677>, <42.7388, 67.5034, -11.2104>, <42.9608, 68.8609, -10.5786> }
					triangle { <42.7388, 67.5034, -11.2104>, <42.6762, 68.3616, -11.7283>, <42.9608, 68.8609, -10.5786> }
					triangle { <42.7388, 67.5034, -11.2104>, <42.7843, 67.2936, -11.9015>, <42.6762, 68.3616, -11.7283> }
					triangle { <42.6762, 68.3616, -11.7283>, <42.6754, 67.8552, -13.00195>, <42.4099, 68.545, -12.7524> }
					triangle { <42.7843, 67.2936, -11.9015>, <42.6754, 67.8552, -13.00195>, <42.6762, 68.3616, -11.7283> }
					triangle { <42.8467, 69.2356, -9.3028>, <43.1018, 69.7761, -7.864>, <43.6121, 69.2498, -7.03541> }
					triangle { <42.8467, 69.2356, -9.3028>, <42.7147, 70.3731, -8.7622>, <43.1018, 69.7761, -7.864> }
					triangle { <42.8467, 69.2356, -9.3028>, <42.7885, 70.6031, -9.4363>, <42.7147, 70.3731, -8.7622> }
					triangle { <43.0374, 67.1883, -12.5384>, <42.6754, 67.8552, -13.00195>, <42.7843, 67.2936, -11.9015> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <0.3013, 3.1802, 0.3781>, <0.6389, 4.01138, 0.4511>, 0.8 }
			cylinder { <0.6389, 4.01138, 0.4511>, <0.9764, 4.8424, 0.524>, 0.8 }
			cylinder { <0.9764, 4.8424, 0.524>, <1.314, 5.6735, 0.5969>, 0.8 }
			cylinder { <1.314, 5.6735, 0.5969>, <1.6516, 6.5046, 0.6698>, 0.8 }
			cylinder { <1.6516, 6.5046, 0.6698>, <1.9891, 7.3357, 0.7427>, 0.8 }
			cylinder { <1.9891, 7.3357, 0.7427>, <2.3267, 8.1669, 0.8157>, 0.8 }
			cylinder { <2.3267, 8.1669, 0.8157>, <2.6643, 8.998, 0.8886>, 0.8 }
			cylinder { <2.6643, 8.998, 0.8886>, <3.001883, 9.8291, 0.9615>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // inflor. internode
			cylinder { <3.001883, 9.8291, 0.9615>, <2.7588, 10.4603, 0.3677>, 0.8 }
			cylinder { <2.7588, 10.4603, 0.3677>, <2.5157, 11.09149, -0.2259>, 0.8 }
			cylinder { <2.5157, 11.09149, -0.2259>, <2.2727, 11.7226, -0.8196>, 0.8 }
			cylinder { <2.2727, 11.7226, -0.8196>, <2.02971, 12.3538, -1.4134>, 0.8 }
			cylinder { <2.02971, 12.3538, -1.4134>, <1.7866, 12.985, -2.007164>, 0.8 }
			cylinder { <1.7866, 12.985, -2.007164>, <1.5436, 13.6162, -2.6009>, 0.8 }
			cylinder { <1.5436, 13.6162, -2.6009>, <1.3005, 14.2474, -3.1946>, 0.8 }
			cylinder { <1.3005, 14.2474, -3.1946>, <1.05754, 14.8786, -3.7883>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.05754, 14.8786, -3.7883>, <-0.173, 18.369, -6.1864>, 0.8 }
				cylinder { <-0.173, 18.369, -6.1864>, <-1.4168, 22.1814, -8.0214>, 0.8 }
				cylinder { <-1.4168, 22.1814, -8.0214>, <-2.6466, 26.2332, -9.2534>, 0.8 }
				cylinder { <-2.6466, 26.2332, -9.2534>, <-3.836, 30.4368, -9.8559>, 0.8 }
				cylinder { <-3.836, 30.4368, -9.8559>, <-4.9592, 34.7012, -9.8159>, 0.8 }
				cylinder { <-4.9592, 34.7012, -9.8159>, <-5.9919, 38.934, -9.1341>, 0.8 }
				cylinder { <-5.9919, 38.934, -9.1341>, <-6.9117, 43.04375, -7.8253>, 0.8 }
				cylinder { <-6.9117, 43.04375, -7.8253>, <-7.6987, 46.9412, -5.918>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.6987, 46.9412, -5.918>, <-5.4712, 48.3024, -5.9933>, <-6.5094, 48.33, -6.4781> }
					triangle { <-4.9549, 47.9744, -4.4519>, <-3.6805, 49.216, -5.2404>, <-6.2228, 48.3008, -5.3598> }
					triangle { <-6.2228, 48.3008, -5.3598>, <-3.6805, 49.216, -5.2404>, <-4.7285, 49.5332, -6.2271> }
					triangle { <-5.4712, 48.3024, -5.9933>, <-4.9549, 47.9744, -4.4519>, <-6.2228, 48.3008, -5.3598> }
					triangle { <-3.6805, 49.216, -5.2404>, <-2.9401, 50.2663, -5.8585>, <-4.7285, 49.5332, -6.2271> }
					triangle { <-2.9401, 50.2663, -5.8585>, <-3.7826, 50.4343, -6.7375>, <-4.7285, 49.5332, -6.2271> }
					triangle { <-2.9401, 50.2663, -5.8585>, <-2.7703, 51.0627, -6.5693>, <-3.7826, 50.4343, -6.7375> }
					triangle { <-5.4712, 48.3024, -5.9933>, <-6.2228, 48.3008, -5.3598>, <-6.5094, 48.33, -6.4781> }
					triangle { <-6.2228, 48.3008, -5.3598>, <-6.7527, 48.5191, -6.2125>, <-6.5094, 48.33, -6.4781> }
					triangle { <-6.2228, 48.3008, -5.3598>, <-4.7285, 49.5332, -6.2271>, <-6.7527, 48.5191, -6.2125> }
					triangle { <-4.7285, 49.5332, -6.2271>, <-4.3779, 50.2993, -7.6478>, <-6.7527, 48.5191, -6.2125> }
					triangle { <-4.7285, 49.5332, -6.2271>, <-3.7826, 50.4343, -6.7375>, <-4.3779, 50.2993, -7.6478> }
					triangle { <-3.7826, 50.4343, -6.7375>, <-3.9639, 50.9574, -7.7871>, <-4.3779, 50.2993, -7.6478> }
					triangle { <-2.7703, 51.0627, -6.5693>, <-2.9894, 51.6256, -7.2456>, <-3.7826, 50.4343, -6.7375> }
					triangle { <-3.7826, 50.4343, -6.7375>, <-2.9894, 51.6256, -7.2456>, <-3.9639, 50.9574, -7.7871> }
					triangle { <-7.6987, 46.9412, -5.918>, <-6.4185, 47.03925, -5.2138>, <-5.4712, 48.3024, -5.9933> }
					triangle { <-6.4185, 47.03925, -5.2138>, <-5.3913, 47.3938, -4.7621>, <-5.4712, 48.3024, -5.9933> }
					triangle { <-5.3913, 47.3938, -4.7621>, <-4.9549, 47.9744, -4.4519>, <-5.4712, 48.3024, -5.9933> }
					triangle { <-3.9639, 50.9574, -7.7871>, <-2.9894, 51.6256, -7.2456>, <-3.7333, 51.6771, -7.752> }
					triangle { <-6.5094, 48.33, -6.4781>, <-6.7452, 48.7842, -7.5037>, <-7.6987, 46.9412, -5.918> }
					triangle { <-7.4968, 48.7827, -6.8701>, <-6.7127, 50.3628, -8.835>, <-8.05638, 49.1143, -8.1547> }
					triangle { <-6.002608, 50.01516, -7.7374>, <-6.7127, 50.3628, -8.835>, <-7.4968, 48.7827, -6.8701> }
					triangle { <-7.4968, 48.7827, -6.8701>, <-8.05638, 49.1143, -8.1547>, <-6.7452, 48.7842, -7.5037> }
					triangle { <-6.002608, 50.01516, -7.7374>, <-5.5919, 51.3306, -9.03348>, <-6.7127, 50.3628, -8.835> }
					triangle { <-6.002608, 50.01516, -7.7374>, <-5.05666, 50.9162, -8.2479>, <-5.5919, 51.3306, -9.03348> }
					triangle { <-5.05666, 50.9162, -8.2479>, <-4.8396, 51.8172, -8.965>, <-5.5919, 51.3306, -9.03348> }
					triangle { <-6.5094, 48.33, -6.4781>, <-7.4968, 48.7827, -6.8701>, <-6.7452, 48.7842, -7.5037> }
					triangle { <-6.5094, 48.33, -6.4781>, <-6.7527, 48.5191, -6.2125>, <-7.4968, 48.7827, -6.8701> }
					triangle { <-6.7527, 48.5191, -6.2125>, <-6.002608, 50.01516, -7.7374>, <-7.4968, 48.7827, -6.8701> }
					triangle { <-6.7527, 48.5191, -6.2125>, <-4.3779, 50.2993, -7.6478>, <-6.002608, 50.01516, -7.7374> }
					triangle { <-4.3779, 50.2993, -7.6478>, <-5.05666, 50.9162, -8.2479>, <-6.002608, 50.01516, -7.7374> }
					triangle { <-4.3779, 50.2993, -7.6478>, <-3.9639, 50.9574, -7.7871>, <-5.05666, 50.9162, -8.2479> }
					triangle { <-5.05666, 50.9162, -8.2479>, <-4.1486, 52.06921, -8.5364>, <-4.8396, 51.8172, -8.965> }
					triangle { <-3.9639, 50.9574, -7.7871>, <-4.1486, 52.06921, -8.5364>, <-5.05666, 50.9162, -8.2479> }
					triangle { <-6.7452, 48.7842, -7.5037>, <-7.8146, 47.5953, -6.9262>, <-7.6987, 46.9412, -5.918> }
					triangle { <-6.7452, 48.7842, -7.5037>, <-8.01585, 48.3864, -7.8734>, <-7.8146, 47.5953, -6.9262> }
					triangle { <-6.7452, 48.7842, -7.5037>, <-8.05638, 49.1143, -8.1547>, <-8.01585, 48.3864, -7.8734> }
					triangle { <-3.7333, 51.6771, -7.752>, <-4.1486, 52.06921, -8.5364>, <-3.9639, 50.9574, -7.7871> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-7.6987, 46.9412, -5.918>, <-7.7168, 48.739, -7.8121>, <-8.4607, 48.2391, -7.09763> }
					triangle { <-6.1616, 49.282, -7.6217>, <-6.9982, 50.382, -8.992>, <-7.4701, 48.7839, -6.8617> }
					triangle { <-7.4701, 48.7839, -6.8617>, <-6.9982, 50.382, -8.992>, <-8.2902, 49.9086, -8.4637> }
					triangle { <-7.7168, 48.739, -7.8121>, <-6.1616, 49.282, -7.6217>, <-7.4701, 48.7839, -6.8617> }
					triangle { <-6.9982, 50.382, -8.992>, <-7.7807, 51.2316, -9.8282>, <-8.2902, 49.9086, -8.4637> }
					triangle { <-7.7807, 51.2316, -9.8282>, <-8.8417, 50.74, -9.4496>, <-8.2902, 49.9086, -8.4637> }
					triangle { <-7.7807, 51.2316, -9.8282>, <-8.6958, 51.6527, -10.2199>, <-8.8417, 50.74, -9.4496> }
					triangle { <-7.7168, 48.739, -7.8121>, <-7.4701, 48.7839, -6.8617>, <-8.4607, 48.2391, -7.09763> }
					triangle { <-7.4701, 48.7839, -6.8617>, <-8.4317, 48.4409, -6.7456>, <-8.4607, 48.2391, -7.09763> }
					triangle { <-7.4701, 48.7839, -6.8617>, <-8.2902, 49.9086, -8.4637>, <-8.4317, 48.4409, -6.7456> }
					triangle { <-8.2902, 49.9086, -8.4637>, <-9.6871, 50.05223, -9.3334>, <-8.4317, 48.4409, -6.7456> }
					triangle { <-8.2902, 49.9086, -8.4637>, <-8.8417, 50.74, -9.4496>, <-9.6871, 50.05223, -9.3334> }
					triangle { <-8.8417, 50.74, -9.4496>, <-9.9991, 50.6764, -9.7032>, <-9.6871, 50.05223, -9.3334> }
					triangle { <-8.6958, 51.6527, -10.2199>, <-9.5932, 51.7728, -10.2712>, <-8.8417, 50.74, -9.4496> }
					triangle { <-8.8417, 50.74, -9.4496>, <-9.5932, 51.7728, -10.2712>, <-9.9991, 50.6764, -9.7032> }
					triangle { <-7.6987, 46.9412, -5.918>, <-6.7663, 47.7157, -6.7397>, <-7.7168, 48.739, -7.8121> }
					triangle { <-6.7663, 47.7157, -6.7397>, <-6.2505, 48.5227, -7.4235>, <-7.7168, 48.739, -7.8121> }
					triangle { <-6.2505, 48.5227, -7.4235>, <-6.1616, 49.282, -7.6217>, <-7.7168, 48.739, -7.8121> }
					triangle { <-9.9991, 50.6764, -9.7032>, <-9.5932, 51.7728, -10.2712>, <-10.2677, 51.373, -9.8266> }
					triangle { <-8.4607, 48.2391, -7.09763>, <-9.5818, 48.111, -7.2984>, <-7.6987, 46.9412, -5.918> }
					triangle { <-9.3351, 48.1559, -6.3479>, <-11.4368, 48.8874, -7.7693>, <-10.7049, 47.7138, -6.3858> }
					triangle { <-10.1551, 49.2806, -7.9499>, <-11.4368, 48.8874, -7.7693>, <-9.3351, 48.1559, -6.3479> }
					triangle { <-9.3351, 48.1559, -6.3479>, <-10.7049, 47.7138, -6.3858>, <-9.5818, 48.111, -7.2984> }
					triangle { <-10.1551, 49.2806, -7.9499>, <-11.719, 49.963, -8.767>, <-11.4368, 48.8874, -7.7693> }
					triangle { <-10.1551, 49.2806, -7.9499>, <-10.7067, 50.112, -8.9358>, <-11.719, 49.963, -8.767> }
					triangle { <-10.7067, 50.112, -8.9358>, <-11.6653, 50.6336, -9.3627>, <-11.719, 49.963, -8.767> }
					triangle { <-8.4607, 48.2391, -7.09763>, <-9.3351, 48.1559, -6.3479>, <-9.5818, 48.111, -7.2984> }
					triangle { <-8.4607, 48.2391, -7.09763>, <-8.4317, 48.4409, -6.7456>, <-9.3351, 48.1559, -6.3479> }
					triangle { <-8.4317, 48.4409, -6.7456>, <-10.1551, 49.2806, -7.9499>, <-9.3351, 48.1559, -6.3479> }
					triangle { <-8.4317, 48.4409, -6.7456>, <-9.6871, 50.05223, -9.3334>, <-10.1551, 49.2806, -7.9499> }
					triangle { <-9.6871, 50.05223, -9.3334>, <-10.7067, 50.112, -8.9358>, <-10.1551, 49.2806, -7.9499> }
					triangle { <-9.6871, 50.05223, -9.3334>, <-9.9991, 50.6764, -9.7032>, <-10.7067, 50.112, -8.9358> }
					triangle { <-10.7067, 50.112, -8.9358>, <-11.2271, 51.2418, -9.7663>, <-11.6653, 50.6336, -9.3627> }
					triangle { <-9.9991, 50.6764, -9.7032>, <-11.2271, 51.2418, -9.7663>, <-10.7067, 50.112, -8.9358> }
					triangle { <-9.5818, 48.111, -7.2984>, <-8.8696, 47.02671, -6.1995>, <-7.6987, 46.9412, -5.918> }
					triangle { <-9.5818, 48.111, -7.2984>, <-10.09246, 47.229, -6.3652>, <-8.8696, 47.02671, -6.1995> }
					triangle { <-9.5818, 48.111, -7.2984>, <-10.7049, 47.7138, -6.3858>, <-10.09246, 47.229, -6.3652> }
					triangle { <-10.2677, 51.373, -9.8266>, <-11.2271, 51.2418, -9.7663>, <-9.9991, 50.6764, -9.7032> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-7.6987, 46.9412, -5.918>, <-10.1269, 47.6455, -6.5721>, <-9.5553, 47.3043, -5.6391> }
					triangle { <-9.7372, 48.6595, -7.825>, <-11.666, 48.7496, -7.5822>, <-9.3202, 48.1687, -6.3679> }
					triangle { <-9.3202, 48.1687, -6.3679>, <-11.666, 48.7496, -7.5822>, <-11.4385, 48.1847, -6.24> }
					triangle { <-10.1269, 47.6455, -6.5721>, <-9.7372, 48.6595, -7.825>, <-9.3202, 48.1687, -6.3679> }
					triangle { <-11.666, 48.7496, -7.5822>, <-13.02694, 48.8737, -7.1748>, <-11.4385, 48.1847, -6.24> }
					triangle { <-13.02694, 48.8737, -7.1748>, <-12.8301, 48.2986, -6.1066>, <-11.4385, 48.1847, -6.24> }
					triangle { <-13.02694, 48.8737, -7.1748>, <-13.8604, 48.7857, -6.4924>, <-12.8301, 48.2986, -6.1066> }
					triangle { <-10.1269, 47.6455, -6.5721>, <-9.3202, 48.1687, -6.3679>, <-9.5553, 47.3043, -5.6391> }
					triangle { <-9.3202, 48.1687, -6.3679>, <-9.3736, 47.6366, -5.4906>, <-9.5553, 47.3043, -5.6391> }
					triangle { <-9.3202, 48.1687, -6.3679>, <-11.4385, 48.1847, -6.24>, <-9.3736, 47.6366, -5.4906> }
					triangle { <-11.4385, 48.1847, -6.24>, <-12.6655, 47.5086, -5.3649>, <-9.3736, 47.6366, -5.4906> }
					triangle { <-11.4385, 48.1847, -6.24>, <-12.8301, 48.2986, -6.1066>, <-12.6655, 47.5086, -5.3649> }
					triangle { <-12.8301, 48.2986, -6.1066>, <-13.3849, 47.785, -5.192>, <-12.6655, 47.5086, -5.3649> }
					triangle { <-13.8604, 48.7857, -6.4924>, <-14.2641, 48.5942, -5.7034>, <-12.8301, 48.2986, -6.1066> }
					triangle { <-12.8301, 48.2986, -6.1066>, <-14.2641, 48.5942, -5.7034>, <-13.3849, 47.785, -5.192> }
					triangle { <-7.6987, 46.9412, -5.918>, <-8.4338, 47.5265, -7.04113>, <-10.1269, 47.6455, -6.5721> }
					triangle { <-8.4338, 47.5265, -7.04113>, <-9.2171, 48.07304, -7.7286>, <-10.1269, 47.6455, -6.5721> }
					triangle { <-9.2171, 48.07304, -7.7286>, <-9.7372, 48.6595, -7.825>, <-10.1269, 47.6455, -6.5721> }
					triangle { <-13.3849, 47.785, -5.192>, <-14.2641, 48.5942, -5.7034>, <-13.9334, 48.2424, -4.9422> }
					triangle { <-9.5553, 47.3043, -5.6391>, <-10.02295, 46.7697, -4.7395>, <-7.6987, 46.9412, -5.918> }
					triangle { <-9.2162, 47.2929, -4.5352>, <-11.4184, 46.665, -3.2206>, <-9.4761, 46.4865, -3.371> }
					triangle { <-11.3345, 47.3088, -4.4074>, <-11.4184, 46.665, -3.2206>, <-9.2162, 47.2929, -4.5352> }
					triangle { <-9.2162, 47.2929, -4.5352>, <-9.4761, 46.4865, -3.371>, <-10.02295, 46.7697, -4.7395> }
					triangle { <-11.3345, 47.3088, -4.4074>, <-12.8557, 47.06298, -3.31>, <-11.4184, 46.665, -3.2206> }
					triangle { <-11.3345, 47.3088, -4.4074>, <-12.7261, 47.4228, -4.2739>, <-12.8557, 47.06298, -3.31> }
					triangle { <-12.7261, 47.4228, -4.2739>, <-13.654, 47.3918, -3.5589>, <-12.8557, 47.06298, -3.31> }
					triangle { <-9.5553, 47.3043, -5.6391>, <-9.2162, 47.2929, -4.5352>, <-10.02295, 46.7697, -4.7395> }
					triangle { <-9.5553, 47.3043, -5.6391>, <-9.3736, 47.6366, -5.4906>, <-9.2162, 47.2929, -4.5352> }
					triangle { <-9.3736, 47.6366, -5.4906>, <-11.3345, 47.3088, -4.4074>, <-9.2162, 47.2929, -4.5352> }
					triangle { <-9.3736, 47.6366, -5.4906>, <-12.6655, 47.5086, -5.3649>, <-11.3345, 47.3088, -4.4074> }
					triangle { <-12.6655, 47.5086, -5.3649>, <-12.7261, 47.4228, -4.2739>, <-11.3345, 47.3088, -4.4074> }
					triangle { <-12.6655, 47.5086, -5.3649>, <-13.3849, 47.785, -5.192>, <-12.7261, 47.4228, -4.2739> }
					triangle { <-12.7261, 47.4228, -4.2739>, <-14.1399, 47.8668, -4.0718>, <-13.654, 47.3918, -3.5589> }
					triangle { <-13.3849, 47.785, -5.192>, <-14.1399, 47.8668, -4.0718>, <-12.7261, 47.4228, -4.2739> }
					triangle { <-10.02295, 46.7697, -4.7395>, <-8.3573, 46.5381, -4.9898>, <-7.6987, 46.9412, -5.918> }
					triangle { <-10.02295, 46.7697, -4.7395>, <-9.002908, 46.2687, -3.9534>, <-8.3573, 46.5381, -4.9898> }
					triangle { <-10.02295, 46.7697, -4.7395>, <-9.4761, 46.4865, -3.371>, <-9.002908, 46.2687, -3.9534> }
					triangle { <-13.9334, 48.2424, -4.9422>, <-14.1399, 47.8668, -4.0718>, <-13.3849, 47.785, -5.192> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-7.6987, 46.9412, -5.918>, <-9.3932, 46.5229, -3.9754>, <-8.2908, 46.8087, -4.1045> }
					triangle { <-10.7737, 46.9614, -4.7827>, <-11.2768, 46.5594, -2.9462>, <-9.2334, 47.2996, -4.5562> }
					triangle { <-9.2334, 47.2996, -4.5562>, <-11.2768, 46.5594, -2.9462>, <-9.852, 46.7278, -2.6083> }
					triangle { <-9.3932, 46.5229, -3.9754>, <-10.7737, 46.9614, -4.7827>, <-9.2334, 47.2996, -4.5562> }
					triangle { <-11.2768, 46.5594, -2.9462>, <-11.4775, 46.4292, -1.5405>, <-9.852, 46.7278, -2.6083> }
					triangle { <-11.4775, 46.4292, -1.5405>, <-10.2731, 46.4613, -1.2972>, <-9.852, 46.7278, -2.6083> }
					triangle { <-11.4775, 46.4292, -1.5405>, <-11.175, 46.397, -0.5033>, <-10.2731, 46.4613, -1.2972> }
					triangle { <-9.3932, 46.5229, -3.9754>, <-9.2334, 47.2996, -4.5562>, <-8.2908, 46.8087, -4.1045> }
					triangle { <-9.2334, 47.2996, -4.5562>, <-8.2855, 47.2101, -4.1702>, <-8.2908, 46.8087, -4.1045> }
					triangle { <-9.2334, 47.2996, -4.5562>, <-9.852, 46.7278, -2.6083>, <-8.2855, 47.2101, -4.1702> }
					triangle { <-9.852, 46.7278, -2.6083>, <-9.2249, 46.1601, -1.1896>, <-8.2855, 47.2101, -4.1702> }
					triangle { <-9.852, 46.7278, -2.6083>, <-10.2731, 46.4613, -1.2972>, <-9.2249, 46.1601, -1.1896> }
					triangle { <-10.2731, 46.4613, -1.2972>, <-9.4737, 46.252, -0.4457>, <-9.2249, 46.1601, -1.1896> }
					triangle { <-11.175, 46.397, -0.5033>, <-10.5907, 46.4529, 0.1878>, <-10.2731, 46.4613, -1.2972> }
					triangle { <-10.2731, 46.4613, -1.2972>, <-10.5907, 46.4529, 0.1878>, <-9.4737, 46.252, -0.4457> }
					triangle { <-7.6987, 46.9412, -5.918>, <-9.1321, 46.7313, -5.7042>, <-9.3932, 46.5229, -3.9754> }
					triangle { <-9.1321, 46.7313, -5.7042>, <-10.219, 46.6619, -5.2586>, <-9.3932, 46.5229, -3.9754> }
					triangle { <-10.219, 46.6619, -5.2586>, <-10.7737, 46.9614, -4.7827>, <-9.3932, 46.5229, -3.9754> }
					triangle { <-9.4737, 46.252, -0.4457>, <-10.5907, 46.4529, 0.1878>, <-9.6988, 46.5827, 0.1965> }
					triangle { <-8.2908, 46.8087, -4.1045>, <-7.463, 46.6014, -3.3394>, <-7.6987, 46.9412, -5.918> }
					triangle { <-7.3032, 47.3781, -3.9202>, <-6.6828, 46.7463, -1.4326>, <-6.05671, 47.117, -3.2485> }
					triangle { <-7.9217, 46.8063, -1.9723>, <-6.6828, 46.7463, -1.4326>, <-7.3032, 47.3781, -3.9202> }
					triangle { <-7.3032, 47.3781, -3.9202>, <-6.05671, 47.117, -3.2485>, <-7.463, 46.6014, -3.3394> }
					triangle { <-7.9217, 46.8063, -1.9723>, <-7.4418, 46.6111, -0.1529>, <-6.6828, 46.7463, -1.4326> }
					triangle { <-7.9217, 46.8063, -1.9723>, <-8.3429, 46.5399, -0.6612>, <-7.4418, 46.6111, -0.1529> }
					triangle { <-8.3429, 46.5399, -0.6612>, <-8.07609, 46.5416, 0.4798>, <-7.4418, 46.6111, -0.1529> }
					triangle { <-8.2908, 46.8087, -4.1045>, <-7.3032, 47.3781, -3.9202>, <-7.463, 46.6014, -3.3394> }
					triangle { <-8.2908, 46.8087, -4.1045>, <-8.2855, 47.2101, -4.1702>, <-7.3032, 47.3781, -3.9202> }
					triangle { <-8.2855, 47.2101, -4.1702>, <-7.9217, 46.8063, -1.9723>, <-7.3032, 47.3781, -3.9202> }
					triangle { <-8.2855, 47.2101, -4.1702>, <-9.2249, 46.1601, -1.1896>, <-7.9217, 46.8063, -1.9723> }
					triangle { <-9.2249, 46.1601, -1.1896>, <-8.3429, 46.5399, -0.6612>, <-7.9217, 46.8063, -1.9723> }
					triangle { <-9.2249, 46.1601, -1.1896>, <-9.4737, 46.252, -0.4457>, <-8.3429, 46.5399, -0.6612> }
					triangle { <-8.3429, 46.5399, -0.6612>, <-8.8888, 46.5769, 0.7307>, <-8.07609, 46.5416, 0.4798> }
					triangle { <-9.4737, 46.252, -0.4457>, <-8.8888, 46.5769, 0.7307>, <-8.3429, 46.5399, -0.6612> }
					triangle { <-7.463, 46.6014, -3.3394>, <-6.9808, 46.8003, -4.9575>, <-7.6987, 46.9412, -5.918> }
					triangle { <-7.463, 46.6014, -3.3394>, <-6.2427, 46.8237, -3.9484>, <-6.9808, 46.8003, -4.9575> }
					triangle { <-7.463, 46.6014, -3.3394>, <-6.05671, 47.117, -3.2485>, <-6.2427, 46.8237, -3.9484> }
					triangle { <-9.6988, 46.5827, 0.1965>, <-8.8888, 46.5769, 0.7307>, <-9.4737, 46.252, -0.4457> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-7.6987, 46.9412, -5.918>, <-6.4724, 46.9349, -3.6122>, <-6.3799, 47.4521, -4.6309> }
					triangle { <-7.7735, 46.5316, -2.6666>, <-6.2669, 46.852, -1.4771>, <-7.2902, 47.3825, -3.9238> }
					triangle { <-7.2902, 47.3825, -3.9238>, <-6.2669, 46.852, -1.4771>, <-5.6424, 47.5738, -2.6002> }
					triangle { <-6.4724, 46.9349, -3.6122>, <-7.7735, 46.5316, -2.6666>, <-7.2902, 47.3825, -3.9238> }
					triangle { <-6.2669, 46.852, -1.4771>, <-5.1494, 47.3029, -0.7147>, <-5.6424, 47.5738, -2.6002> }
					triangle { <-5.1494, 47.3029, -0.7147>, <-4.5971, 47.8012, -1.6931>, <-5.6424, 47.5738, -2.6002> }
					triangle { <-5.1494, 47.3029, -0.7147>, <-4.2175, 47.8255, -0.5515>, <-4.5971, 47.8012, -1.6931> }
					triangle { <-6.4724, 46.9349, -3.6122>, <-7.2902, 47.3825, -3.9238>, <-6.3799, 47.4521, -4.6309> }
					triangle { <-7.2902, 47.3825, -3.9238>, <-6.6412, 47.7637, -4.6231>, <-6.3799, 47.4521, -4.6309> }
					triangle { <-7.2902, 47.3825, -3.9238>, <-5.6424, 47.5738, -2.6002>, <-6.6412, 47.7637, -4.6231> }
					triangle { <-5.6424, 47.5738, -2.6002>, <-4.02555, 47.9108, -2.6218>, <-6.6412, 47.7637, -4.6231> }
					triangle { <-5.6424, 47.5738, -2.6002>, <-4.5971, 47.8012, -1.6931>, <-4.02555, 47.9108, -2.6218> }
					triangle { <-4.5971, 47.8012, -1.6931>, <-3.5633, 48.2422, -2.07379>, <-4.02555, 47.9108, -2.6218> }
					triangle { <-4.2175, 47.8255, -0.5515>, <-3.5173, 48.3547, -0.7797>, <-4.5971, 47.8012, -1.6931> }
					triangle { <-4.5971, 47.8012, -1.6931>, <-3.5173, 48.3547, -0.7797>, <-3.5633, 48.2422, -2.07379> }
					triangle { <-7.6987, 46.9412, -5.918>, <-7.8677, 46.4256, -4.5579>, <-6.4724, 46.9349, -3.6122> }
					triangle { <-7.8677, 46.4256, -4.5579>, <-7.8188, 46.2358, -3.3975>, <-6.4724, 46.9349, -3.6122> }
					triangle { <-7.8188, 46.2358, -3.3975>, <-7.7735, 46.5316, -2.6666>, <-6.4724, 46.9349, -3.6122> }
					triangle { <-3.5633, 48.2422, -2.07379>, <-3.5173, 48.3547, -0.7797>, <-3.2996, 48.7375, -1.5661> }
					triangle { <-6.3799, 47.4521, -4.6309>, <-5.4067, 47.8652, -5.07354>, <-7.6987, 46.9412, -5.918> }
					triangle { <-6.2245, 48.3128, -5.385>, <-3.7306, 49.06618, -4.9549>, <-5.1659, 48.7656, -6.2496> }
					triangle { <-4.5767, 48.5041, -4.06152>, <-3.7306, 49.06618, -4.9549>, <-6.2245, 48.3128, -5.385> }
					triangle { <-6.2245, 48.3128, -5.385>, <-5.1659, 48.7656, -6.2496>, <-5.4067, 47.8652, -5.07354> }
					triangle { <-4.5767, 48.5041, -4.06152>, <-2.8848, 49.2885, -3.7436>, <-3.7306, 49.06618, -4.9549> }
					triangle { <-4.5767, 48.5041, -4.06152>, <-3.5314, 48.7315, -3.1543>, <-2.8848, 49.2885, -3.7436> }
					triangle { <-3.5314, 48.7315, -3.1543>, <-2.5462, 49.318, -2.9117>, <-2.8848, 49.2885, -3.7436> }
					triangle { <-6.3799, 47.4521, -4.6309>, <-6.2245, 48.3128, -5.385>, <-5.4067, 47.8652, -5.07354> }
					triangle { <-6.3799, 47.4521, -4.6309>, <-6.6412, 47.7637, -4.6231>, <-6.2245, 48.3128, -5.385> }
					triangle { <-6.6412, 47.7637, -4.6231>, <-4.5767, 48.5041, -4.06152>, <-6.2245, 48.3128, -5.385> }
					triangle { <-6.6412, 47.7637, -4.6231>, <-4.02555, 47.9108, -2.6218>, <-4.5767, 48.5041, -4.06152> }
					triangle { <-4.02555, 47.9108, -2.6218>, <-3.5314, 48.7315, -3.1543>, <-4.5767, 48.5041, -4.06152> }
					triangle { <-4.02555, 47.9108, -2.6218>, <-3.5633, 48.2422, -2.07379>, <-3.5314, 48.7315, -3.1543> }
					triangle { <-3.5314, 48.7315, -3.1543>, <-2.6206, 49.2133, -2.07021>, <-2.5462, 49.318, -2.9117> }
					triangle { <-3.5633, 48.2422, -2.07379>, <-2.6206, 49.2133, -2.07021>, <-3.5314, 48.7315, -3.1543> }
					triangle { <-5.4067, 47.8652, -5.07354>, <-6.6403, 47.4635, -6.1723>, <-7.6987, 46.9412, -5.918> }
					triangle { <-5.4067, 47.8652, -5.07354>, <-5.6235, 48.1522, -6.4077>, <-6.6403, 47.4635, -6.1723> }
					triangle { <-5.4067, 47.8652, -5.07354>, <-5.1659, 48.7656, -6.2496>, <-5.6235, 48.1522, -6.4077> }
					triangle { <-3.2996, 48.7375, -1.5661>, <-2.6206, 49.2133, -2.07021>, <-3.5633, 48.2422, -2.07379> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <1.05754, 14.8786, -3.7883>, <0.8144, 15.5098, -4.3821>, 0.8 }
			cylinder { <0.8144, 15.5098, -4.3821>, <0.5714, 16.141, -4.9758>, 0.8 }
			cylinder { <0.5714, 16.141, -4.9758>, <0.3284, 16.7722, -5.5696>, 0.8 }
			cylinder { <0.3284, 16.7722, -5.5696>, <0.08537, 17.4034, -6.1633>, 0.8 }
			cylinder { <0.08537, 17.4034, -6.1633>, <-0.1576, 18.03459, -6.757>, 0.8 }
			cylinder { <-0.1576, 18.03459, -6.757>, <-0.4007, 18.6657, -7.3508>, 0.8 }
			cylinder { <-0.4007, 18.6657, -7.3508>, <-0.6437, 19.2969, -7.9445>, 0.8 }
			cylinder { <-0.6437, 19.2969, -7.9445>, <-0.8868, 19.9281, -8.5383>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.8868, 19.9281, -8.5383>, <-1.6089, 22.7784, -11.825>, 0.8 }
				cylinder { <-1.6089, 22.7784, -11.825>, <-1.8466, 25.3245, -15.4179>, 0.8 }
				cylinder { <-1.8466, 25.3245, -15.4179>, <-1.5947, 27.5112, -19.2393>, 0.8 }
				cylinder { <-1.5947, 27.5112, -19.2393>, <-0.8588, 29.2913, -23.2064>, 0.8 }
				cylinder { <-0.8588, 29.2913, -23.2064>, <0.3453, 30.6261, -27.2333>, 0.8 }
				cylinder { <0.3453, 30.6261, -27.2333>, <1.9916, 31.4868, -31.233>, 0.8 }
				cylinder { <1.9916, 31.4868, -31.233>, <4.04434, 31.8548, -35.1187>, 0.8 }
				cylinder { <4.04434, 31.8548, -35.1187>, <6.4591, 31.722, -38.8064>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <6.4591, 31.722, -38.8064>, <5.2932, 30.3316, -40.3668>, <5.5332, 31.347, -40.2461> }
					triangle { <6.07208, 29.04984, -40.1226>, <4.9195, 28.7295, -41.4453>, <6.1694, 30.5013, -40.2449> }
					triangle { <6.1694, 30.5013, -40.2449>, <4.9195, 28.7295, -41.4453>, <4.8358, 30.06955, -41.5929> }
					triangle { <5.2932, 30.3316, -40.3668>, <6.07208, 29.04984, -40.1226>, <6.1694, 30.5013, -40.2449> }
					triangle { <4.9195, 28.7295, -41.4453>, <4.1695, 28.6698, -42.5137>, <4.8358, 30.06955, -41.5929> }
					triangle { <4.1695, 28.6698, -42.5137>, <4.03182, 29.7868, -42.555>, <4.8358, 30.06955, -41.5929> }
					triangle { <4.1695, 28.6698, -42.5137>, <3.6479, 29.04028, -43.2698>, <4.03182, 29.7868, -42.555> }
					triangle { <5.2932, 30.3316, -40.3668>, <6.1694, 30.5013, -40.2449>, <5.5332, 31.347, -40.2461> }
					triangle { <6.1694, 30.5013, -40.2449>, <5.8798, 31.3874, -40.3772>, <5.5332, 31.347, -40.2461> }
					triangle { <6.1694, 30.5013, -40.2449>, <4.8358, 30.06955, -41.5929>, <5.8798, 31.3874, -40.3772> }
					triangle { <4.8358, 30.06955, -41.5929>, <3.7011, 30.7148, -42.3592>, <5.8798, 31.3874, -40.3772> }
					triangle { <4.8358, 30.06955, -41.5929>, <4.03182, 29.7868, -42.555>, <3.7011, 30.7148, -42.3592> }
					triangle { <4.03182, 29.7868, -42.555>, <3.4368, 30.5708, -43.01743>, <3.7011, 30.7148, -42.3592> }
					triangle { <3.6479, 29.04028, -43.2698>, <3.3454, 29.6417, -43.757>, <4.03182, 29.7868, -42.555> }
					triangle { <4.03182, 29.7868, -42.555>, <3.3454, 29.6417, -43.757>, <3.4368, 30.5708, -43.01743> }
					triangle { <6.4591, 31.722, -38.8064>, <6.253, 30.4231, -39.07294>, <5.2932, 30.3316, -40.3668> }
					triangle { <6.253, 30.4231, -39.07294>, <6.03527, 29.4748, -39.538>, <5.2932, 30.3316, -40.3668> }
					triangle { <6.03527, 29.4748, -39.538>, <6.07208, 29.04984, -40.1226>, <5.2932, 30.3316, -40.3668> }
					triangle { <3.4368, 30.5708, -43.01743>, <3.3454, 29.6417, -43.757>, <3.4069, 30.4635, -43.7017> }
					triangle { <5.5332, 31.347, -40.2461>, <4.9789, 32.1485, -40.6379>, <6.4591, 31.722, -38.8064> }
					triangle { <5.8551, 32.3183, -40.5161>, <4.1716, 33.05389, -42.09076>, <5.2849, 33.4843, -40.7532> }
					triangle { <4.5216, 31.8864, -41.8641>, <4.1716, 33.05389, -42.09076>, <5.8551, 32.3183, -40.5161> }
					triangle { <5.8551, 32.3183, -40.5161>, <5.2849, 33.4843, -40.7532>, <4.9789, 32.1485, -40.6379> }
					triangle { <4.5216, 31.8864, -41.8641>, <3.4994, 32.476, -43.1341>, <4.1716, 33.05389, -42.09076> }
					triangle { <4.5216, 31.8864, -41.8641>, <3.7175, 31.6038, -42.8262>, <3.4994, 32.476, -43.1341> }
					triangle { <3.7175, 31.6038, -42.8262>, <3.1757, 31.9556, -43.684>, <3.4994, 32.476, -43.1341> }
					triangle { <5.5332, 31.347, -40.2461>, <5.8551, 32.3183, -40.5161>, <4.9789, 32.1485, -40.6379> }
					triangle { <5.5332, 31.347, -40.2461>, <5.8798, 31.3874, -40.3772>, <5.8551, 32.3183, -40.5161> }
					triangle { <5.8798, 31.3874, -40.3772>, <4.5216, 31.8864, -41.8641>, <5.8551, 32.3183, -40.5161> }
					triangle { <5.8798, 31.3874, -40.3772>, <3.7011, 30.7148, -42.3592>, <4.5216, 31.8864, -41.8641> }
					triangle { <3.7011, 30.7148, -42.3592>, <3.7175, 31.6038, -42.8262>, <4.5216, 31.8864, -41.8641> }
					triangle { <3.7011, 30.7148, -42.3592>, <3.4368, 30.5708, -43.01743>, <3.7175, 31.6038, -42.8262> }
					triangle { <3.7175, 31.6038, -42.8262>, <3.1199, 31.2477, -44.00711>, <3.1757, 31.9556, -43.684> }
					triangle { <3.4368, 30.5708, -43.01743>, <3.1199, 31.2477, -44.00711>, <3.7175, 31.6038, -42.8262> }
					triangle { <4.9789, 32.1485, -40.6379>, <5.8705, 32.4498, -39.3963>, <6.4591, 31.722, -38.8064> }
					triangle { <4.9789, 32.1485, -40.6379>, <5.3879, 33.2177, -40.09666>, <5.8705, 32.4498, -39.3963> }
					triangle { <4.9789, 32.1485, -40.6379>, <5.2849, 33.4843, -40.7532>, <5.3879, 33.2177, -40.09666> }
					triangle { <3.4069, 30.4635, -43.7017>, <3.1199, 31.2477, -44.00711>, <3.4368, 30.5708, -43.01743> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <6.4591, 31.722, -38.8064>, <5.3001, 33.00829, -40.4586>, <6.1782, 33.0735, -39.8859> }
					triangle { <4.6177, 31.8554, -41.1759>, <4.2218, 33.3478, -42.06845>, <5.8463, 32.2947, -40.521> }
					triangle { <5.8463, 32.2947, -40.521>, <4.2218, 33.3478, -42.06845>, <5.2777, 33.9105, -41.4418> }
					triangle { <5.3001, 33.00829, -40.4586>, <4.6177, 31.8554, -41.1759>, <5.8463, 32.2947, -40.521> }
					triangle { <4.2218, 33.3478, -42.06845>, <4.1517, 34.47, -42.7342>, <5.2777, 33.9105, -41.4418> }
					triangle { <4.1517, 34.47, -42.7342>, <4.9687, 34.9528, -42.1274>, <5.2777, 33.9105, -41.4418> }
					triangle { <4.1517, 34.47, -42.7342>, <4.43, 35.3866, -42.9861>, <4.9687, 34.9528, -42.1274> }
					triangle { <5.3001, 33.00829, -40.4586>, <5.8463, 32.2947, -40.521>, <6.1782, 33.0735, -39.8859> }
					triangle { <5.8463, 32.2947, -40.521>, <6.4348, 32.8729, -40.06736>, <6.1782, 33.0735, -39.8859> }
					triangle { <5.8463, 32.2947, -40.521>, <5.2777, 33.9105, -41.4418>, <6.4348, 32.8729, -40.06736> }
					triangle { <5.2777, 33.9105, -41.4418>, <5.456, 35.4123, -41.3791>, <6.4348, 32.8729, -40.06736> }
					triangle { <5.2777, 33.9105, -41.4418>, <4.9687, 34.9528, -42.1274>, <5.456, 35.4123, -41.3791> }
					triangle { <4.9687, 34.9528, -42.1274>, <5.4317, 35.9108, -41.9033>, <5.456, 35.4123, -41.3791> }
					triangle { <4.43, 35.3866, -42.9861>, <4.9106, 36.06411, -42.9632>, <4.9687, 34.9528, -42.1274> }
					triangle { <4.9687, 34.9528, -42.1274>, <4.9106, 36.06411, -42.9632>, <5.4317, 35.9108, -41.9033> }
					triangle { <6.4591, 31.722, -38.8064>, <5.4267, 31.6136, -39.6568>, <5.3001, 33.00829, -40.4586> }
					triangle { <5.4267, 31.6136, -39.6568>, <4.7308, 31.7248, -40.4731>, <5.3001, 33.00829, -40.4586> }
					triangle { <4.7308, 31.7248, -40.4731>, <4.6177, 31.8554, -41.1759>, <5.3001, 33.00829, -40.4586> }
					triangle { <5.4317, 35.9108, -41.9033>, <4.9106, 36.06411, -42.9632>, <5.5668, 36.2451, -42.4955> }
					triangle { <6.1782, 33.0735, -39.8859>, <6.6519, 33.9687, -39.6079>, <6.4591, 31.722, -38.8064> }
					triangle { <7.1982, 33.2551, -39.6703>, <7.4392, 35.6337, -40.04392>, <7.8958, 34.2001, -39.06925> }
					triangle { <6.6296, 34.8709, -40.5911>, <7.4392, 35.6337, -40.04392>, <7.1982, 33.2551, -39.6703> }
					triangle { <7.1982, 33.2551, -39.6703>, <7.8958, 34.2001, -39.06925>, <6.6519, 33.9687, -39.6079> }
					triangle { <6.6296, 34.8709, -40.5911>, <6.9955, 36.5178, -40.9903>, <7.4392, 35.6337, -40.04392> }
					triangle { <6.6296, 34.8709, -40.5911>, <6.3205, 35.9132, -41.2768>, <6.9955, 36.5178, -40.9903> }
					triangle { <6.3205, 35.9132, -41.2768>, <6.6085, 36.8914, -41.6138>, <6.9955, 36.5178, -40.9903> }
					triangle { <6.1782, 33.0735, -39.8859>, <7.1982, 33.2551, -39.6703>, <6.6519, 33.9687, -39.6079> }
					triangle { <6.1782, 33.0735, -39.8859>, <6.4348, 32.8729, -40.06736>, <7.1982, 33.2551, -39.6703> }
					triangle { <6.4348, 32.8729, -40.06736>, <6.6296, 34.8709, -40.5911>, <7.1982, 33.2551, -39.6703> }
					triangle { <6.4348, 32.8729, -40.06736>, <5.456, 35.4123, -41.3791>, <6.6296, 34.8709, -40.5911> }
					triangle { <5.456, 35.4123, -41.3791>, <6.3205, 35.9132, -41.2768>, <6.6296, 34.8709, -40.5911> }
					triangle { <5.456, 35.4123, -41.3791>, <5.4317, 35.9108, -41.9033>, <6.3205, 35.9132, -41.2768> }
					triangle { <6.3205, 35.9132, -41.2768>, <6.1362, 36.8762, -42.2345>, <6.6085, 36.8914, -41.6138> }
					triangle { <5.4317, 35.9108, -41.9033>, <6.1362, 36.8762, -42.2345>, <6.3205, 35.9132, -41.2768> }
					triangle { <6.6519, 33.9687, -39.6079>, <6.9252, 32.7213, -38.7154>, <6.4591, 31.722, -38.8064> }
					triangle { <6.6519, 33.9687, -39.6079>, <7.5156, 33.7033, -38.7208>, <6.9252, 32.7213, -38.7154> }
					triangle { <6.6519, 33.9687, -39.6079>, <7.8958, 34.2001, -39.06925>, <7.5156, 33.7033, -38.7208> }
					triangle { <5.5668, 36.2451, -42.4955>, <6.1362, 36.8762, -42.2345>, <5.4317, 35.9108, -41.9033> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <6.4591, 31.722, -38.8064>, <7.4302, 33.8901, -39.09555>, <7.741, 32.9156, -38.8569> }
					triangle { <6.4193, 34.4379, -40.08921>, <7.6877, 35.6744, -39.8826>, <7.1768, 33.2573, -39.6844> }
					triangle { <7.1768, 33.2573, -39.6844>, <7.6877, 35.6744, -39.8826>, <8.4618, 34.6859, -39.3847> }
					triangle { <7.4302, 33.8901, -39.09555>, <6.4193, 34.4379, -40.08921>, <7.1768, 33.2573, -39.6844> }
					triangle { <7.6877, 35.6744, -39.8826>, <8.758, 36.4182, -39.7881>, <8.4618, 34.6859, -39.3847> }
					triangle { <8.758, 36.4182, -39.7881>, <9.3522, 35.607, -39.2806>, <8.4618, 34.6859, -39.3847> }
					triangle { <8.758, 36.4182, -39.7881>, <9.7063, 36.6089, -39.5752>, <9.3522, 35.607, -39.2806> }
					triangle { <7.4302, 33.8901, -39.09555>, <7.1768, 33.2573, -39.6844>, <7.741, 32.9156, -38.8569> }
					triangle { <7.1768, 33.2573, -39.6844>, <7.7796, 32.7371, -39.1818>, <7.741, 32.9156, -38.8569> }
					triangle { <7.1768, 33.2573, -39.6844>, <8.4618, 34.6859, -39.3847>, <7.7796, 32.7371, -39.1818> }
					triangle { <8.4618, 34.6859, -39.3847>, <9.7084, 34.9828, -38.5791>, <7.7796, 32.7371, -39.1818> }
					triangle { <8.4618, 34.6859, -39.3847>, <9.3522, 35.607, -39.2806>, <9.7084, 34.9828, -38.5791> }
					triangle { <9.3522, 35.607, -39.2806>, <10.2657, 35.4225, -38.7204>, <9.7084, 34.9828, -38.5791> }
					triangle { <9.7063, 36.6089, -39.5752>, <10.4784, 36.4232, -39.3303>, <9.3522, 35.607, -39.2806> }
					triangle { <9.3522, 35.607, -39.2806>, <10.4784, 36.4232, -39.3303>, <10.2657, 35.4225, -38.7204> }
					triangle { <6.4591, 31.722, -38.8064>, <6.1295, 32.9468, -39.2446>, <7.4302, 33.8901, -39.09555> }
					triangle { <6.1295, 32.9468, -39.2446>, <6.1349, 33.9525, -39.6339>, <7.4302, 33.8901, -39.09555> }
					triangle { <6.1349, 33.9525, -39.6339>, <6.4193, 34.4379, -40.08921>, <7.4302, 33.8901, -39.09555> }
					triangle { <10.2657, 35.4225, -38.7204>, <10.4784, 36.4232, -39.3303>, <10.8006, 35.7165, -39.04937> }
					triangle { <7.741, 32.9156, -38.8569>, <8.5925, 32.6757, -38.2907>, <6.4591, 31.722, -38.8064> }
					triangle { <8.3392, 32.04295, -38.8796>, <10.4541, 32.7841, -37.9671>, <9.2351, 31.4759, -38.09424> }
					triangle { <9.6242, 33.4715, -38.5799>, <10.4541, 32.7841, -37.9671>, <8.3392, 32.04295, -38.8796> }
					triangle { <8.3392, 32.04295, -38.8796>, <9.2351, 31.4759, -38.09424>, <8.5925, 32.6757, -38.2907> }
					triangle { <9.6242, 33.4715, -38.5799>, <11.2401, 33.8951, -38.1165>, <10.4541, 32.7841, -37.9671> }
					triangle { <9.6242, 33.4715, -38.5799>, <10.5145, 34.3927, -38.4758>, <11.2401, 33.8951, -38.1165> }
					triangle { <10.5145, 34.3927, -38.4758>, <11.5452, 34.6376, -38.3>, <11.2401, 33.8951, -38.1165> }
					triangle { <7.741, 32.9156, -38.8569>, <8.3392, 32.04295, -38.8796>, <8.5925, 32.6757, -38.2907> }
					triangle { <7.741, 32.9156, -38.8569>, <7.7796, 32.7371, -39.1818>, <8.3392, 32.04295, -38.8796> }
					triangle { <7.7796, 32.7371, -39.1818>, <9.6242, 33.4715, -38.5799>, <8.3392, 32.04295, -38.8796> }
					triangle { <7.7796, 32.7371, -39.1818>, <9.7084, 34.9828, -38.5791>, <9.6242, 33.4715, -38.5799> }
					triangle { <9.7084, 34.9828, -38.5791>, <10.5145, 34.3927, -38.4758>, <9.6242, 33.4715, -38.5799> }
					triangle { <9.7084, 34.9828, -38.5791>, <10.2657, 35.4225, -38.7204>, <10.5145, 34.3927, -38.4758> }
					triangle { <10.5145, 34.3927, -38.4758>, <11.5008, 35.3252, -38.6658>, <11.5452, 34.6376, -38.3> }
					triangle { <10.2657, 35.4225, -38.7204>, <11.5008, 35.3252, -38.6658>, <10.5145, 34.3927, -38.4758> }
					triangle { <8.5925, 32.6757, -38.2907>, <7.4521, 31.6149, -38.3306>, <6.4591, 31.722, -38.8064> }
					triangle { <8.5925, 32.6757, -38.2907>, <8.5293, 31.4508, -37.9759>, <7.4521, 31.6149, -38.3306> }
					triangle { <8.5925, 32.6757, -38.2907>, <9.2351, 31.4759, -38.09424>, <8.5293, 31.4508, -37.9759> }
					triangle { <10.8006, 35.7165, -39.04937>, <11.5008, 35.3252, -38.6658>, <10.2657, 35.4225, -38.7204> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <6.4591, 31.722, -38.8064>, <8.7596, 31.7667, -38.1486>, <8.07657, 31.09017, -38.5715> }
					triangle { <9.003971, 33.2524, -38.3541>, <10.5598, 32.5158, -37.8882>, <8.3346, 32.06791, -38.8835> }
					triangle { <8.3346, 32.06791, -38.8835>, <10.5598, 32.5158, -37.8882>, <10.01757, 31.3314, -38.2453> }
					triangle { <8.7596, 31.7667, -38.1486>, <9.003971, 33.2524, -38.3541>, <8.3346, 32.06791, -38.8835> }
					triangle { <10.5598, 32.5158, -37.8882>, <11.6655, 31.8401, -37.7194>, <10.01757, 31.3314, -38.2453> }
					triangle { <11.6655, 31.8401, -37.7194>, <11.1653, 30.8516, -37.9222>, <10.01757, 31.3314, -38.2453> }
					triangle { <11.6655, 31.8401, -37.7194>, <12.2344, 31.02938, -37.7189>, <11.1653, 30.8516, -37.9222> }
					triangle { <8.7596, 31.7667, -38.1486>, <8.3346, 32.06791, -38.8835>, <8.07657, 31.09017, -38.5715> }
					triangle { <8.3346, 32.06791, -38.8835>, <8.06828, 31.1663, -38.9363>, <8.07657, 31.09017, -38.5715> }
					triangle { <8.3346, 32.06791, -38.8835>, <10.01757, 31.3314, -38.2453>, <8.06828, 31.1663, -38.9363> }
					triangle { <10.01757, 31.3314, -38.2453>, <10.6213, 30.01587, -37.8026>, <8.06828, 31.1663, -38.9363> }
					triangle { <10.01757, 31.3314, -38.2453>, <11.1653, 30.8516, -37.9222>, <10.6213, 30.01587, -37.8026> }
					triangle { <11.1653, 30.8516, -37.9222>, <11.3034, 29.7763, -37.8376>, <10.6213, 30.01587, -37.8026> }
					triangle { <12.2344, 31.02938, -37.7189>, <12.4062, 30.2261, -37.8449>, <11.1653, 30.8516, -37.9222> }
					triangle { <11.1653, 30.8516, -37.9222>, <12.4062, 30.2261, -37.8449>, <11.3034, 29.7763, -37.8376> }
					triangle { <6.4591, 31.722, -38.8064>, <7.3967, 32.5926, -38.4021>, <8.7596, 31.7667, -38.1486> }
					triangle { <7.3967, 32.5926, -38.4021>, <8.3201, 33.1001, -38.1723>, <8.7596, 31.7667, -38.1486> }
					triangle { <8.3201, 33.1001, -38.1723>, <9.003971, 33.2524, -38.3541>, <8.7596, 31.7667, -38.1486> }
					triangle { <11.3034, 29.7763, -37.8376>, <12.4062, 30.2261, -37.8449>, <11.9241, 29.6033, -38.09363> }
					triangle { <8.07657, 31.09017, -38.5715>, <8.137, 30.04442, -38.4943>, <6.4591, 31.722, -38.8064> }
					triangle { <7.7119, 30.3455, -39.2292>, <9.07797, 28.4166, -38.711>, <7.4643, 29.05111, -39.1665> }
					triangle { <9.3949, 29.609, -38.591>, <9.07797, 28.4166, -38.711>, <7.7119, 30.3455, -39.2292> }
					triangle { <7.7119, 30.3455, -39.2292>, <7.4643, 29.05111, -39.1665>, <8.137, 30.04442, -38.4943> }
					triangle { <9.3949, 29.609, -38.591>, <10.407, 28.2079, -38.4573>, <9.07797, 28.4166, -38.711> }
					triangle { <9.3949, 29.609, -38.591>, <10.5427, 29.1292, -38.2679>, <10.407, 28.2079, -38.4573> }
					triangle { <10.5427, 29.1292, -38.2679>, <11.2095, 28.2878, -38.2913>, <10.407, 28.2079, -38.4573> }
					triangle { <8.07657, 31.09017, -38.5715>, <7.7119, 30.3455, -39.2292>, <8.137, 30.04442, -38.4943> }
					triangle { <8.07657, 31.09017, -38.5715>, <8.06828, 31.1663, -38.9363>, <7.7119, 30.3455, -39.2292> }
					triangle { <8.06828, 31.1663, -38.9363>, <9.3949, 29.609, -38.591>, <7.7119, 30.3455, -39.2292> }
					triangle { <8.06828, 31.1663, -38.9363>, <10.6213, 30.01587, -37.8026>, <9.3949, 29.609, -38.591> }
					triangle { <10.6213, 30.01587, -37.8026>, <10.5427, 29.1292, -38.2679>, <9.3949, 29.609, -38.591> }
					triangle { <10.6213, 30.01587, -37.8026>, <11.3034, 29.7763, -37.8376>, <10.5427, 29.1292, -38.2679> }
					triangle { <10.5427, 29.1292, -38.2679>, <11.8501, 28.7236, -38.1995>, <11.2095, 28.2878, -38.2913> }
					triangle { <11.3034, 29.7763, -37.8376>, <11.8501, 28.7236, -38.1995>, <10.5427, 29.1292, -38.2679> }
					triangle { <8.137, 30.04442, -38.4943>, <6.728, 30.6494, -38.77>, <6.4591, 31.722, -38.8064> }
					triangle { <8.137, 30.04442, -38.4943>, <7.03755, 29.5521, -38.8845>, <6.728, 30.6494, -38.77> }
					triangle { <8.137, 30.04442, -38.4943>, <7.4643, 29.05111, -39.1665>, <7.03755, 29.5521, -38.8845> }
					triangle { <11.9241, 29.6033, -38.09363>, <11.8501, 28.7236, -38.1995>, <11.3034, 29.7763, -37.8376> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <6.4591, 31.722, -38.8064>, <7.4189, 29.5342, -38.9461>, <6.6914, 30.106, -39.4431> }
					triangle { <8.786, 29.8721, -38.3751>, <8.8231, 28.1588, -38.8686>, <7.7026, 30.3389, -39.2351> }
					triangle { <7.7026, 30.3389, -39.2351>, <8.8231, 28.1588, -38.8686>, <7.7427, 28.4352, -39.6306> }
					triangle { <7.4189, 29.5342, -38.9461>, <8.786, 29.8721, -38.3751>, <7.7026, 30.3389, -39.2351> }
					triangle { <8.8231, 28.1588, -38.8686>, <8.7869, 26.979, -39.4294>, <7.7427, 28.4352, -39.6306> }
					triangle { <8.7869, 26.979, -39.4294>, <7.8275, 27.2002, -39.9764>, <7.7427, 28.4352, -39.6306> }
					triangle { <8.7869, 26.979, -39.4294>, <8.4336, 26.2811, -40.03682>, <7.8275, 27.2002, -39.9764> }
					triangle { <7.4189, 29.5342, -38.9461>, <7.7026, 30.3389, -39.2351>, <6.6914, 30.106, -39.4431> }
					triangle { <7.7026, 30.3389, -39.2351>, <6.8764, 30.3196, -39.6862>, <6.6914, 30.106, -39.4431> }
					triangle { <7.7026, 30.3389, -39.2351>, <7.7427, 28.4352, -39.6306>, <6.8764, 30.3196, -39.6862> }
					triangle { <7.7427, 28.4352, -39.6306>, <6.8525, 27.3382, -40.174>, <6.8764, 30.3196, -39.6862> }
					triangle { <7.7427, 28.4352, -39.6306>, <7.8275, 27.2002, -39.9764>, <6.8525, 27.3382, -40.174> }
					triangle { <7.8275, 27.2002, -39.9764>, <7.01922, 26.7325, -40.5334>, <6.8525, 27.3382, -40.174> }
					triangle { <8.4336, 26.2811, -40.03682>, <7.9312, 25.9717, -40.622>, <7.8275, 27.2002, -39.9764> }
					triangle { <7.8275, 27.2002, -39.9764>, <7.9312, 25.9717, -40.622>, <7.01922, 26.7325, -40.5334> }
					triangle { <6.4591, 31.722, -38.8064>, <7.4742, 31.00938, -38.2943>, <7.4189, 29.5342, -38.9461> }
					triangle { <7.4742, 31.00938, -38.2943>, <8.2576, 30.291, -38.1121>, <7.4189, 29.5342, -38.9461> }
					triangle { <8.2576, 30.291, -38.1121>, <8.786, 29.8721, -38.3751>, <7.4189, 29.5342, -38.9461> }
					triangle { <7.01922, 26.7325, -40.5334>, <7.9312, 25.9717, -40.622>, <7.2856, 26.3077, -41.01238> }
					triangle { <6.6914, 30.106, -39.4431>, <5.8699, 29.7137, -39.9669>, <6.4591, 31.722, -38.8064> }
					triangle { <6.1536, 30.5183, -40.2558>, <5.1365, 28.5858, -41.298>, <4.9861, 30.311, -40.8346> }
					triangle { <6.1937, 28.6146, -40.6514>, <5.1365, 28.5858, -41.298>, <6.1536, 30.5183, -40.2558> }
					triangle { <6.1536, 30.5183, -40.2558>, <4.9861, 30.311, -40.8346>, <5.8699, 29.7137, -39.9669> }
					triangle { <6.1937, 28.6146, -40.6514>, <5.5508, 27.3176, -41.6052>, <5.1365, 28.5858, -41.298> }
					triangle { <6.1937, 28.6146, -40.6514>, <6.2785, 27.3796, -40.9972>, <5.5508, 27.3176, -41.6052> }
					triangle { <6.2785, 27.3796, -40.9972>, <5.9588, 26.6052, -41.669>, <5.5508, 27.3176, -41.6052> }
					triangle { <6.6914, 30.106, -39.4431>, <6.1536, 30.5183, -40.2558>, <5.8699, 29.7137, -39.9669> }
					triangle { <6.6914, 30.106, -39.4431>, <6.8764, 30.3196, -39.6862>, <6.1536, 30.5183, -40.2558> }
					triangle { <6.8764, 30.3196, -39.6862>, <6.1937, 28.6146, -40.6514>, <6.1536, 30.5183, -40.2558> }
					triangle { <6.8764, 30.3196, -39.6862>, <6.8525, 27.3382, -40.174>, <6.1937, 28.6146, -40.6514> }
					triangle { <6.8525, 27.3382, -40.174>, <6.2785, 27.3796, -40.9972>, <6.1937, 28.6146, -40.6514> }
					triangle { <6.8525, 27.3382, -40.174>, <7.01922, 26.7325, -40.5334>, <6.2785, 27.3796, -40.9972> }
					triangle { <6.2785, 27.3796, -40.9972>, <6.5922, 26.1655, -41.5504>, <5.9588, 26.6052, -41.669> }
					triangle { <7.01922, 26.7325, -40.5334>, <6.5922, 26.1655, -41.5504>, <6.2785, 27.3796, -40.9972> }
					triangle { <5.8699, 29.7137, -39.9669>, <5.7357, 31.1732, -39.4386>, <6.4591, 31.722, -38.8064> }
					triangle { <5.8699, 29.7137, -39.9669>, <5.06672, 30.6606, -40.2149>, <5.7357, 31.1732, -39.4386> }
					triangle { <5.8699, 29.7137, -39.9669>, <4.9861, 30.311, -40.8346>, <5.06672, 30.6606, -40.2149> }
					triangle { <7.2856, 26.3077, -41.01238>, <6.5922, 26.1655, -41.5504>, <7.01922, 26.7325, -40.5334> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <-0.8868, 19.9281, -8.5383>, <-1.1298, 20.5593, -9.132>, 0.8 }
			cylinder { <-1.1298, 20.5593, -9.132>, <-1.3728, 21.1905, -9.7257>, 0.8 }
			cylinder { <-1.3728, 21.1905, -9.7257>, <-1.6159, 21.8217, -10.3195>, 0.8 }
			cylinder { <-1.6159, 21.8217, -10.3195>, <-1.8589, 22.4529, -10.9132>, 0.8 }
			cylinder { <-1.8589, 22.4529, -10.9132>, <-2.102, 23.08412, -11.507>, 0.8 }
			cylinder { <-2.102, 23.08412, -11.507>, <-2.345, 23.7153, -12.1007>, 0.8 }
			cylinder { <-2.345, 23.7153, -12.1007>, <-2.588, 24.3465, -12.6944>, 0.8 }
			cylinder { <-2.588, 24.3465, -12.6944>, <-2.8311, 24.9777, -13.2882>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.8311, 24.9777, -13.2882>, <-4.6321, 27.9158, -16.03993>, 0.8 }
				cylinder { <-4.6321, 27.9158, -16.03993>, <-7.004252, 30.6356, -18.5744>, 0.8 }
				cylinder { <-7.004252, 30.6356, -18.5744>, <-9.8961, 33.07833, -20.8368>, 0.8 }
				cylinder { <-9.8961, 33.07833, -20.8368>, <-13.2451, 35.1909, -22.7782>, 0.8 }
				cylinder { <-13.2451, 35.1909, -22.7782>, <-16.9788, 36.9277, -24.3566>, 0.8 }
				cylinder { <-16.9788, 36.9277, -24.3566>, <-21.01635, 38.2512, -25.5377>, 0.8 }
				cylinder { <-21.01635, 38.2512, -25.5377>, <-25.2703, 39.1326, -26.296>, 0.8 }
				cylinder { <-25.2703, 39.1326, -26.296>, <-29.6486, 39.5529, -26.6151>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-29.6486, 39.5529, -26.6151>, <-30.3091, 41.2673, -25.08165>, <-30.2472, 41.1236, -26.1202> }
					triangle { <-30.7419, 40.3652, -23.9378>, <-31.1037, 42.04448, -23.4586>, <-30.7327, 40.5337, -25.388> }
					triangle { <-30.7327, 40.5337, -25.388>, <-31.1037, 42.04448, -23.4586>, <-31.01583, 42.3557, -24.7699> }
					triangle { <-30.3091, 41.2673, -25.08165>, <-30.7419, 40.3652, -23.9378>, <-30.7327, 40.5337, -25.388> }
					triangle { <-31.1037, 42.04448, -23.4586>, <-31.4846, 43.284, -23.2969>, <-31.01583, 42.3557, -24.7699> }
					triangle { <-31.4846, 43.284, -23.2969>, <-31.3057, 43.545, -24.3778>, <-31.01583, 42.3557, -24.7699> }
					triangle { <-31.4846, 43.284, -23.2969>, <-31.7129, 44.2016, -23.5912>, <-31.3057, 43.545, -24.3778> }
					triangle { <-30.3091, 41.2673, -25.08165>, <-30.7327, 40.5337, -25.388>, <-30.2472, 41.1236, -26.1202> }
					triangle { <-30.7327, 40.5337, -25.388>, <-30.5578, 40.9423, -26.218>, <-30.2472, 41.1236, -26.1202> }
					triangle { <-30.7327, 40.5337, -25.388>, <-31.01583, 42.3557, -24.7699>, <-30.5578, 40.9423, -26.218> }
					triangle { <-31.01583, 42.3557, -24.7699>, <-30.8445, 43.7853, -25.237>, <-30.5578, 40.9423, -26.218> }
					triangle { <-31.01583, 42.3557, -24.7699>, <-31.3057, 43.545, -24.3778>, <-30.8445, 43.7853, -25.237> }
					triangle { <-31.3057, 43.545, -24.3778>, <-31.2127, 44.3838, -25.06355>, <-30.8445, 43.7853, -25.237> }
					triangle { <-31.7129, 44.2016, -23.5912>, <-31.8396, 44.8088, -24.1443>, <-31.3057, 43.545, -24.3778> }
					triangle { <-31.3057, 43.545, -24.3778>, <-31.8396, 44.8088, -24.1443>, <-31.2127, 44.3838, -25.06355> }
					triangle { <-29.6486, 39.5529, -26.6151>, <-29.8774, 39.7286, -25.3046>, <-30.3091, 41.2673, -25.08165> }
					triangle { <-29.8774, 39.7286, -25.3046>, <-30.2144, 40.07782, -24.3416>, <-30.3091, 41.2673, -25.08165> }
					triangle { <-30.2144, 40.07782, -24.3416>, <-30.7419, 40.3652, -23.9378>, <-30.3091, 41.2673, -25.08165> }
					triangle { <-31.2127, 44.3838, -25.06355>, <-31.8396, 44.8088, -24.1443>, <-31.7411, 44.8216, -24.9643> }
					triangle { <-30.2472, 41.1236, -26.1202>, <-30.1221, 41.889, -26.8286>, <-29.6486, 39.5529, -26.6151> }
					triangle { <-30.5456, 41.1554, -27.135>, <-30.6586, 43.524, -27.6165>, <-30.2486, 41.8785, -28.1979> }
					triangle { <-30.8288, 42.9774, -26.517>, <-30.6586, 43.524, -27.6165>, <-30.5456, 41.1554, -27.135> }
					triangle { <-30.5456, 41.1554, -27.135>, <-30.2486, 41.8785, -28.1979>, <-30.1221, 41.889, -26.8286> }
					triangle { <-30.8288, 42.9774, -26.517>, <-31.1264, 44.628, -26.9556>, <-30.6586, 43.524, -27.6165> }
					triangle { <-30.8288, 42.9774, -26.517>, <-31.1186, 44.1666, -26.1248>, <-31.1264, 44.628, -26.9556> }
					triangle { <-31.1186, 44.1666, -26.1248>, <-31.4162, 45.1613, -26.3992>, <-31.1264, 44.628, -26.9556> }
					triangle { <-30.2472, 41.1236, -26.1202>, <-30.5456, 41.1554, -27.135>, <-30.1221, 41.889, -26.8286> }
					triangle { <-30.2472, 41.1236, -26.1202>, <-30.5578, 40.9423, -26.218>, <-30.5456, 41.1554, -27.135> }
					triangle { <-30.5578, 40.9423, -26.218>, <-30.8288, 42.9774, -26.517>, <-30.5456, 41.1554, -27.135> }
					triangle { <-30.5578, 40.9423, -26.218>, <-30.8445, 43.7853, -25.237>, <-30.8288, 42.9774, -26.517> }
					triangle { <-30.8445, 43.7853, -25.237>, <-31.1186, 44.1666, -26.1248>, <-30.8288, 42.9774, -26.517> }
					triangle { <-30.8445, 43.7853, -25.237>, <-31.2127, 44.3838, -25.06355>, <-31.1186, 44.1666, -26.1248> }
					triangle { <-31.1186, 44.1666, -26.1248>, <-31.7145, 45.3244, -25.6971>, <-31.4162, 45.1613, -26.3992> }
					triangle { <-31.2127, 44.3838, -25.06355>, <-31.7145, 45.3244, -25.6971>, <-31.1186, 44.1666, -26.1248> }
					triangle { <-30.1221, 41.889, -26.8286>, <-29.6655, 40.4598, -27.2486>, <-29.6486, 39.5529, -26.6151> }
					triangle { <-30.1221, 41.889, -26.8286>, <-29.8292, 41.3584, -27.9404>, <-29.6655, 40.4598, -27.2486> }
					triangle { <-30.1221, 41.889, -26.8286>, <-30.2486, 41.8785, -28.1979>, <-29.8292, 41.3584, -27.9404> }
					triangle { <-31.7411, 44.8216, -24.9643>, <-31.7145, 45.3244, -25.6971>, <-31.2127, 44.3838, -25.06355> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-29.6486, 39.5529, -26.6151>, <-30.08183, 41.628, -27.7257>, <-30.1662, 40.5996, -27.9217> }
					triangle { <-30.3538, 42.4701, -26.4903>, <-30.6387, 43.5052, -27.9143>, <-30.5468, 41.1625, -27.1104> }
					triangle { <-30.5468, 41.1625, -27.1104>, <-30.6387, 43.5052, -27.9143>, <-30.7338, 42.363, -28.6289> }
					triangle { <-30.08183, 41.628, -27.7257>, <-30.3538, 42.4701, -26.4903>, <-30.5468, 41.1625, -27.1104> }
					triangle { <-30.6387, 43.5052, -27.9143>, <-30.9886, 44.1043, -29.02171>, <-30.7338, 42.363, -28.6289> }
					triangle { <-30.9886, 44.1043, -29.02171>, <-30.9616, 43.15, -29.6193>, <-30.7338, 42.363, -28.6289> }
					triangle { <-30.9886, 44.1043, -29.02171>, <-31.2524, 44.1523, -29.9751>, <-30.9616, 43.15, -29.6193> }
					triangle { <-30.08183, 41.628, -27.7257>, <-30.5468, 41.1625, -27.1104>, <-30.1662, 40.5996, -27.9217> }
					triangle { <-30.5468, 41.1625, -27.1104>, <-30.4882, 40.4913, -27.7681>, <-30.1662, 40.5996, -27.9217> }
					triangle { <-30.5468, 41.1625, -27.1104>, <-30.7338, 42.363, -28.6289>, <-30.4882, 40.4913, -27.7681> }
					triangle { <-30.7338, 42.363, -28.6289>, <-30.6242, 42.3593, -30.1386>, <-30.4882, 40.4913, -27.7681> }
					triangle { <-30.7338, 42.363, -28.6289>, <-30.9616, 43.15, -29.6193>, <-30.6242, 42.3593, -30.1386> }
					triangle { <-30.9616, 43.15, -29.6193>, <-30.9622, 42.7627, -30.6354>, <-30.6242, 42.3593, -30.1386> }
					triangle { <-31.2524, 44.1523, -29.9751>, <-31.4529, 43.8447, -30.7206>, <-30.9616, 43.15, -29.6193> }
					triangle { <-30.9616, 43.15, -29.6193>, <-31.4529, 43.8447, -30.7206>, <-30.9622, 42.7627, -30.6354> }
					triangle { <-29.6486, 39.5529, -26.6151>, <-29.6913, 40.8689, -26.3564>, <-30.08183, 41.628, -27.7257> }
					triangle { <-29.6913, 40.8689, -26.3564>, <-29.889, 41.9289, -26.3678>, <-30.08183, 41.628, -27.7257> }
					triangle { <-29.889, 41.9289, -26.3678>, <-30.3538, 42.4701, -26.4903>, <-30.08183, 41.628, -27.7257> }
					triangle { <-30.9622, 42.7627, -30.6354>, <-31.4529, 43.8447, -30.7206>, <-31.4699, 43.06656, -30.997> }
					triangle { <-30.1662, 40.5996, -27.9217>, <-30.1385, 40.1632, -28.8767>, <-29.6486, 39.5529, -26.6151> }
					triangle { <-30.6035, 39.6977, -28.2614>, <-30.7737, 40.01902, -30.6536>, <-30.4552, 38.8924, -29.296> }
					triangle { <-30.7906, 40.8982, -29.7799>, <-30.7737, 40.01902, -30.6536>, <-30.6035, 39.6977, -28.2614> }
					triangle { <-30.6035, 39.6977, -28.2614>, <-30.4552, 38.8924, -29.296>, <-30.1385, 40.1632, -28.8767> }
					triangle { <-30.7906, 40.8982, -29.7799>, <-31.1404, 41.05461, -31.4706>, <-30.7737, 40.01902, -30.6536> }
					triangle { <-30.7906, 40.8982, -29.7799>, <-31.01832, 41.6852, -30.7703>, <-31.1404, 41.05461, -31.4706> }
					triangle { <-31.01832, 41.6852, -30.7703>, <-31.3475, 41.7858, -31.7875>, <-31.1404, 41.05461, -31.4706> }
					triangle { <-30.1662, 40.5996, -27.9217>, <-30.6035, 39.6977, -28.2614>, <-30.1385, 40.1632, -28.8767> }
					triangle { <-30.1662, 40.5996, -27.9217>, <-30.4882, 40.4913, -27.7681>, <-30.6035, 39.6977, -28.2614> }
					triangle { <-30.4882, 40.4913, -27.7681>, <-30.7906, 40.8982, -29.7799>, <-30.6035, 39.6977, -28.2614> }
					triangle { <-30.4882, 40.4913, -27.7681>, <-30.6242, 42.3593, -30.1386>, <-30.7906, 40.8982, -29.7799> }
					triangle { <-30.6242, 42.3593, -30.1386>, <-31.01832, 41.6852, -30.7703>, <-30.7906, 40.8982, -29.7799> }
					triangle { <-30.6242, 42.3593, -30.1386>, <-30.9622, 42.7627, -30.6354>, <-31.01832, 41.6852, -30.7703> }
					triangle { <-31.01832, 41.6852, -30.7703>, <-31.5441, 42.5365, -31.707>, <-31.3475, 41.7858, -31.7875> }
					triangle { <-30.9622, 42.7627, -30.6354>, <-31.5441, 42.5365, -31.707>, <-31.01832, 41.6852, -30.7703> }
					triangle { <-30.1385, 40.1632, -28.8767>, <-29.7505, 39.2511, -27.6746>, <-29.6486, 39.5529, -26.6151> }
					triangle { <-30.1385, 40.1632, -28.8767>, <-30.00595, 38.9115, -28.7388>, <-29.7505, 39.2511, -27.6746> }
					triangle { <-30.1385, 40.1632, -28.8767>, <-30.4552, 38.8924, -29.296>, <-30.00595, 38.9115, -28.7388> }
					triangle { <-31.4699, 43.06656, -30.997>, <-31.5441, 42.5365, -31.707>, <-30.9622, 42.7627, -30.6354> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-29.6486, 39.5529, -26.6151>, <-30.225, 39.2329, -28.9157>, <-30.3398, 38.7314, -28.00005> }
					triangle { <-30.3184, 40.6974, -29.3103>, <-30.7957, 39.731, -30.7311>, <-30.6011, 39.7233, -28.2603> }
					triangle { <-30.6011, 39.7233, -28.2603>, <-30.7957, 39.731, -30.7311>, <-30.9941, 38.708, -29.8718> }
					triangle { <-30.225, 39.2329, -28.9157>, <-30.3184, 40.6974, -29.3103>, <-30.6011, 39.7233, -28.2603> }
					triangle { <-30.7957, 39.731, -30.7311>, <-31.2947, 38.9307, -31.6356>, <-30.9941, 38.708, -29.8718> }
					triangle { <-31.2947, 38.9307, -31.6356>, <-31.3551, 38.06132, -30.9222>, <-30.9941, 38.708, -29.8718> }
					triangle { <-31.2947, 38.9307, -31.6356>, <-31.689, 38.08709, -31.9727>, <-31.3551, 38.06132, -30.9222> }
					triangle { <-30.225, 39.2329, -28.9157>, <-30.6011, 39.7233, -28.2603>, <-30.3398, 38.7314, -28.00005> }
					triangle { <-30.6011, 39.7233, -28.2603>, <-30.6376, 38.8838, -27.8355>, <-30.3398, 38.7314, -28.00005> }
					triangle { <-30.6011, 39.7233, -28.2603>, <-30.9941, 38.708, -29.8718>, <-30.6376, 38.8838, -27.8355> }
					triangle { <-30.9941, 38.708, -29.8718>, <-31.09663, 37.2761, -30.3518>, <-30.6376, 38.8838, -27.8355> }
					triangle { <-30.9941, 38.708, -29.8718>, <-31.3551, 38.06132, -30.9222>, <-31.09663, 37.2761, -30.3518> }
					triangle { <-31.3551, 38.06132, -30.9222>, <-31.4992, 36.9844, -30.8777>, <-31.09663, 37.2761, -30.3518> }
					triangle { <-31.689, 38.08709, -31.9727>, <-31.9929, 37.3162, -31.9096>, <-31.3551, 38.06132, -30.9222> }
					triangle { <-31.3551, 38.06132, -30.9222>, <-31.9929, 37.3162, -31.9096>, <-31.4992, 36.9844, -30.8777> }
					triangle { <-29.6486, 39.5529, -26.6151>, <-29.6497, 40.2223, -27.7781>, <-30.225, 39.2329, -28.9157> }
					triangle { <-29.6497, 40.2223, -27.7781>, <-29.8432, 40.5771, -28.7779>, <-30.225, 39.2329, -28.9157> }
					triangle { <-29.8432, 40.5771, -28.7779>, <-30.3184, 40.6974, -29.3103>, <-30.225, 39.2329, -28.9157> }
					triangle { <-31.4992, 36.9844, -30.8777>, <-31.9929, 37.3162, -31.9096>, <-32.05136, 36.8103, -31.2593> }
					triangle { <-30.3398, 38.7314, -28.00005>, <-30.4476, 37.6923, -27.8907>, <-29.6486, 39.5529, -26.6151> }
					triangle { <-30.8237, 38.1827, -27.2354>, <-31.3255, 36.06436, -28.2917>, <-30.8246, 36.9348, -26.8067> }
					triangle { <-31.2167, 37.1674, -28.8468>, <-31.3255, 36.06436, -28.2917>, <-30.8237, 38.1827, -27.2354> }
					triangle { <-30.8237, 38.1827, -27.2354>, <-30.8246, 36.9348, -26.8067>, <-30.4476, 37.6923, -27.8907> }
					triangle { <-31.2167, 37.1674, -28.8468>, <-31.7989, 35.6783, -29.517>, <-31.3255, 36.06436, -28.2917> }
					triangle { <-31.2167, 37.1674, -28.8468>, <-31.5777, 36.5207, -29.8973>, <-31.7989, 35.6783, -29.517> }
					triangle { <-31.5777, 36.5207, -29.8973>, <-32.04551, 35.6427, -30.3018>, <-31.7989, 35.6783, -29.517> }
					triangle { <-30.3398, 38.7314, -28.00005>, <-30.8237, 38.1827, -27.2354>, <-30.4476, 37.6923, -27.8907> }
					triangle { <-30.3398, 38.7314, -28.00005>, <-30.6376, 38.8838, -27.8355>, <-30.8237, 38.1827, -27.2354> }
					triangle { <-30.6376, 38.8838, -27.8355>, <-31.2167, 37.1674, -28.8468>, <-30.8237, 38.1827, -27.2354> }
					triangle { <-30.6376, 38.8838, -27.8355>, <-31.09663, 37.2761, -30.3518>, <-31.2167, 37.1674, -28.8468> }
					triangle { <-31.09663, 37.2761, -30.3518>, <-31.5777, 36.5207, -29.8973>, <-31.2167, 37.1674, -28.8468> }
					triangle { <-31.09663, 37.2761, -30.3518>, <-31.4992, 36.9844, -30.8777>, <-31.5777, 36.5207, -29.8973> }
					triangle { <-31.5777, 36.5207, -29.8973>, <-32.2261, 35.9847, -30.9793>, <-32.04551, 35.6427, -30.3018> }
					triangle { <-31.4992, 36.9844, -30.8777>, <-32.2261, 35.9847, -30.9793>, <-31.5777, 36.5207, -29.8973> }
					triangle { <-30.4476, 37.6923, -27.8907>, <-29.8988, 38.4761, -26.6612>, <-29.6486, 39.5529, -26.6151> }
					triangle { <-30.4476, 37.6923, -27.8907>, <-30.3017, 37.4034, -26.6665>, <-29.8988, 38.4761, -26.6612> }
					triangle { <-30.4476, 37.6923, -27.8907>, <-30.8246, 36.9348, -26.8067>, <-30.3017, 37.4034, -26.6665> }
					triangle { <-32.05136, 36.8103, -31.2593>, <-32.2261, 35.9847, -30.9793>, <-31.4992, 36.9844, -30.8777> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-29.6486, 39.5529, -26.6151>, <-30.5421, 37.3697, -27.01821>, <-30.5298, 38.08348, -26.2477> }
					triangle { <-30.6843, 37.4805, -28.527>, <-31.3592, 35.9025, -28.04256>, <-30.8211, 38.1915, -27.2593> }
					triangle { <-30.8211, 38.1915, -27.2593>, <-31.3592, 35.9025, -28.04256>, <-31.4394, 36.4077, -26.7925> }
					triangle { <-30.5421, 37.3697, -27.01821>, <-30.6843, 37.4805, -28.527>, <-30.8211, 38.1915, -27.2593> }
					triangle { <-31.3592, 35.9025, -28.04256>, <-31.9828, 34.8647, -27.5508>, <-31.4394, 36.4077, -26.7925> }
					triangle { <-31.9828, 34.8647, -27.5508>, <-31.9461, 35.2638, -26.4982>, <-31.4394, 36.4077, -26.7925> }
					triangle { <-31.9828, 34.8647, -27.5508>, <-32.4235, 34.3313, -26.8421>, <-31.9461, 35.2638, -26.4982> }
					triangle { <-30.5421, 37.3697, -27.01821>, <-30.8211, 38.1915, -27.2593>, <-30.5298, 38.08348, -26.2477> }
					triangle { <-30.8211, 38.1915, -27.2593>, <-30.801, 38.3263, -26.3277>, <-30.5298, 38.08348, -26.2477> }
					triangle { <-30.8211, 38.1915, -27.2593>, <-31.4394, 36.4077, -26.7925>, <-30.801, 38.3263, -26.3277> }
					triangle { <-31.4394, 36.4077, -26.7925>, <-31.6133, 35.5131, -25.5839>, <-30.801, 38.3263, -26.3277> }
					triangle { <-31.4394, 36.4077, -26.7925>, <-31.9461, 35.2638, -26.4982>, <-31.6133, 35.5131, -25.5839> }
					triangle { <-31.9461, 35.2638, -26.4982>, <-32.08669, 34.9803, -25.4578>, <-31.6133, 35.5131, -25.5839> }
					triangle { <-32.4235, 34.3313, -26.8421>, <-32.7185, 34.1845, -26.07928>, <-31.9461, 35.2638, -26.4982> }
					triangle { <-31.9461, 35.2638, -26.4982>, <-32.7185, 34.1845, -26.07928>, <-32.08669, 34.9803, -25.4578> }
					triangle { <-29.6486, 39.5529, -26.6151>, <-29.8098, 38.6763, -27.6183>, <-30.5421, 37.3697, -27.01821> }
					triangle { <-29.8098, 38.6763, -27.6183>, <-30.1397, 37.8779, -28.2637>, <-30.5421, 37.3697, -27.01821> }
					triangle { <-30.1397, 37.8779, -28.2637>, <-30.6843, 37.4805, -28.527>, <-30.5421, 37.3697, -27.01821> }
					triangle { <-32.08669, 34.9803, -25.4578>, <-32.7185, 34.1845, -26.07928>, <-32.6873, 34.6404, -25.3912> }
					triangle { <-30.5298, 38.08348, -26.2477>, <-30.6251, 37.8679, -25.2242>, <-29.6486, 39.5529, -26.6151> }
					triangle { <-30.904, 38.6898, -25.4653>, <-31.5566, 37.08837, -23.7728>, <-30.8497, 38.6927, -24.147> }
					triangle { <-31.5223, 36.906, -24.9985>, <-31.5566, 37.08837, -23.7728>, <-30.904, 38.6898, -25.4653> }
					triangle { <-30.904, 38.6898, -25.4653>, <-30.8497, 38.6927, -24.147>, <-30.6251, 37.8679, -25.2242> }
					triangle { <-31.5223, 36.906, -24.9985>, <-32.198, 35.8788, -23.7763>, <-31.5566, 37.08837, -23.7728> }
					triangle { <-31.5223, 36.906, -24.9985>, <-32.02904, 35.762, -24.7042>, <-32.198, 35.8788, -23.7763> }
					triangle { <-32.02904, 35.762, -24.7042>, <-32.552, 35.1643, -23.9815>, <-32.198, 35.8788, -23.7763> }
					triangle { <-30.5298, 38.08348, -26.2477>, <-30.904, 38.6898, -25.4653>, <-30.6251, 37.8679, -25.2242> }
					triangle { <-30.5298, 38.08348, -26.2477>, <-30.801, 38.3263, -26.3277>, <-30.904, 38.6898, -25.4653> }
					triangle { <-30.801, 38.3263, -26.3277>, <-31.5223, 36.906, -24.9985>, <-30.904, 38.6898, -25.4653> }
					triangle { <-30.801, 38.3263, -26.3277>, <-31.6133, 35.5131, -25.5839>, <-31.5223, 36.906, -24.9985> }
					triangle { <-31.6133, 35.5131, -25.5839>, <-32.02904, 35.762, -24.7042>, <-31.5223, 36.906, -24.9985> }
					triangle { <-31.6133, 35.5131, -25.5839>, <-32.08669, 34.9803, -25.4578>, <-32.02904, 35.762, -24.7042> }
					triangle { <-32.02904, 35.762, -24.7042>, <-32.8243, 34.6623, -24.5129>, <-32.552, 35.1643, -23.9815> }
					triangle { <-32.08669, 34.9803, -25.4578>, <-32.8243, 34.6623, -24.5129>, <-32.02904, 35.762, -24.7042> }
					triangle { <-30.6251, 37.8679, -25.2242>, <-29.9068, 39.1986, -25.5993>, <-29.6486, 39.5529, -26.6151> }
					triangle { <-30.6251, 37.8679, -25.2242>, <-30.3106, 38.9043, -24.5681>, <-29.9068, 39.1986, -25.5993> }
					triangle { <-30.6251, 37.8679, -25.2242>, <-30.8497, 38.6927, -24.147>, <-30.3106, 38.9043, -24.5681> }
					triangle { <-32.6873, 34.6404, -25.3912>, <-32.8243, 34.6623, -24.5129>, <-32.08669, 34.9803, -25.4578> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-29.6486, 39.5529, -26.6151>, <-30.5949, 38.646, -24.6128>, <-30.4716, 39.5843, -25.06846> }
					triangle { <-30.95, 37.2721, -25.1565>, <-31.5524, 37.3539, -23.48>, <-30.9036, 38.6999, -25.4573> }
					triangle { <-30.9036, 38.6999, -25.4573>, <-31.5524, 37.3539, -23.48>, <-31.453, 38.6962, -23.5918> }
					triangle { <-30.5949, 38.646, -24.6128>, <-30.95, 37.2721, -25.1565>, <-30.9036, 38.6999, -25.4573> }
					triangle { <-31.5524, 37.3539, -23.48>, <-32.1019, 37.5957, -22.3193>, <-31.453, 38.6962, -23.5918> }
					triangle { <-32.1019, 37.5957, -22.3193>, <-31.9151, 38.704, -22.3924>, <-31.453, 38.6962, -23.5918> }
					triangle { <-32.1019, 37.5957, -22.3193>, <-32.4385, 38.1674, -21.5839>, <-31.9151, 38.704, -22.3924> }
					triangle { <-30.5949, 38.646, -24.6128>, <-30.9036, 38.6999, -25.4573>, <-30.4716, 39.5843, -25.06846> }
					triangle { <-30.9036, 38.6999, -25.4573>, <-30.751, 39.6177, -25.313>, <-30.4716, 39.5843, -25.06846> }
					triangle { <-30.9036, 38.6999, -25.4573>, <-31.453, 38.6962, -23.5918>, <-30.751, 39.6177, -25.313> }
					triangle { <-31.453, 38.6962, -23.5918>, <-31.4552, 39.5968, -22.3751>, <-30.751, 39.6177, -25.313> }
					triangle { <-31.453, 38.6962, -23.5918>, <-31.9151, 38.704, -22.3924>, <-31.4552, 39.5968, -22.3751> }
					triangle { <-31.9151, 38.704, -22.3924>, <-31.9069, 39.6224, -21.8102>, <-31.4552, 39.5968, -22.3751> }
					triangle { <-32.4385, 38.1674, -21.5839>, <-32.6223, 38.8851, -21.2076>, <-31.9151, 38.704, -22.3924> }
					triangle { <-31.9151, 38.704, -22.3924>, <-32.6223, 38.8851, -21.2076>, <-31.9069, 39.6224, -21.8102> }
					triangle { <-29.6486, 39.5529, -26.6151>, <-29.9526, 38.3666, -26.06653>, <-30.5949, 38.646, -24.6128> }
					triangle { <-29.9526, 38.3666, -26.06653>, <-30.3727, 37.5646, -25.4805>, <-30.5949, 38.646, -24.6128> }
					triangle { <-30.3727, 37.5646, -25.4805>, <-30.95, 37.2721, -25.1565>, <-30.5949, 38.646, -24.6128> }
					triangle { <-31.9069, 39.6224, -21.8102>, <-32.6223, 38.8851, -21.2076>, <-32.4927, 39.6665, -21.4419> }
					triangle { <-30.4716, 39.5843, -25.06846>, <-30.4209, 40.5007, -24.5578>, <-29.6486, 39.5529, -26.6151> }
					triangle { <-30.7296, 40.5547, -25.4024>, <-31.1382, 41.7683, -23.3492>, <-30.4883, 41.7942, -25.0198> }
					triangle { <-31.2789, 40.551, -23.5368>, <-31.1382, 41.7683, -23.3492>, <-30.7296, 40.5547, -25.4024> }
					triangle { <-30.7296, 40.5547, -25.4024>, <-30.4883, 41.7942, -25.0198>, <-30.4209, 40.5007, -24.5578> }
					triangle { <-31.2789, 40.551, -23.5368>, <-31.7762, 41.4935, -22.1694>, <-31.1382, 41.7683, -23.3492> }
					triangle { <-31.2789, 40.551, -23.5368>, <-31.741, 40.5588, -22.3375>, <-31.7762, 41.4935, -22.1694> }
					triangle { <-31.741, 40.5588, -22.3375>, <-32.1572, 41.1359, -21.5331>, <-31.7762, 41.4935, -22.1694> }
					triangle { <-30.4716, 39.5843, -25.06846>, <-30.7296, 40.5547, -25.4024>, <-30.4209, 40.5007, -24.5578> }
					triangle { <-30.4716, 39.5843, -25.06846>, <-30.751, 39.6177, -25.313>, <-30.7296, 40.5547, -25.4024> }
					triangle { <-30.751, 39.6177, -25.313>, <-31.2789, 40.551, -23.5368>, <-30.7296, 40.5547, -25.4024> }
					triangle { <-30.751, 39.6177, -25.313>, <-31.4552, 39.5968, -22.3751>, <-31.2789, 40.551, -23.5368> }
					triangle { <-31.4552, 39.5968, -22.3751>, <-31.741, 40.5588, -22.3375>, <-31.2789, 40.551, -23.5368> }
					triangle { <-31.4552, 39.5968, -22.3751>, <-31.9069, 39.6224, -21.8102>, <-31.741, 40.5588, -22.3375> }
					triangle { <-31.741, 40.5588, -22.3375>, <-32.5034, 40.5217, -21.1991>, <-32.1572, 41.1359, -21.5331> }
					triangle { <-31.9069, 39.6224, -21.8102>, <-32.5034, 40.5217, -21.1991>, <-31.741, 40.5588, -22.3375> }
					triangle { <-30.4209, 40.5007, -24.5578>, <-29.7605, 40.4431, -25.9678>, <-29.6486, 39.5529, -26.6151> }
					triangle { <-30.4209, 40.5007, -24.5578>, <-30.01418, 41.3855, -25.3673>, <-29.7605, 40.4431, -25.9678> }
					triangle { <-30.4209, 40.5007, -24.5578>, <-30.4883, 41.7942, -25.0198>, <-30.01418, 41.3855, -25.3673> }
					triangle { <-32.4927, 39.6665, -21.4419>, <-32.5034, 40.5217, -21.1991>, <-31.9069, 39.6224, -21.8102> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <3.001883, 9.8291, 0.9615>, <3.3394, 10.6602, 1.03445>, 0.8 }
			cylinder { <3.3394, 10.6602, 1.03445>, <3.677, 11.4913, 1.1073>, 0.8 }
			cylinder { <3.677, 11.4913, 1.1073>, <4.01458, 12.3224, 1.1802>, 0.8 }
			cylinder { <4.01458, 12.3224, 1.1802>, <4.3521, 13.1535, 1.2532>, 0.8 }
			cylinder { <4.3521, 13.1535, 1.2532>, <4.6897, 13.9846, 1.3261>, 0.8 }
			cylinder { <4.6897, 13.9846, 1.3261>, <5.02728, 14.8157, 1.399>, 0.8 }
			cylinder { <5.02728, 14.8157, 1.399>, <5.3648, 15.6468, 1.4719>, 0.8 }
			cylinder { <5.3648, 15.6468, 1.4719>, <5.7024, 16.4779, 1.5448>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // inflor. internode
			cylinder { <5.7024, 16.4779, 1.5448>, <5.7696, 16.8597, 2.357>, 0.8 }
			cylinder { <5.7696, 16.8597, 2.357>, <5.8368, 17.2415, 3.1693>, 0.8 }
			cylinder { <5.8368, 17.2415, 3.1693>, <5.904, 17.6234, 3.9815>, 0.8 }
			cylinder { <5.904, 17.6234, 3.9815>, <5.9712, 18.00523, 4.7937>, 0.8 }
			cylinder { <5.9712, 18.00523, 4.7937>, <6.03842, 18.387, 5.6059>, 0.8 }
			cylinder { <6.03842, 18.387, 5.6059>, <6.1056, 18.7688, 6.4181>, 0.8 }
			cylinder { <6.1056, 18.7688, 6.4181>, <6.1728, 19.1507, 7.2303>, 0.8 }
			cylinder { <6.1728, 19.1507, 7.2303>, <6.24, 19.5325, 8.04259>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <6.24, 19.5325, 8.04259>, <7.1512, 21.6108, 11.8239>, 0.8 }
				cylinder { <7.1512, 21.6108, 11.8239>, <8.6245, 23.8514, 15.3249>, 0.8 }
				cylinder { <8.6245, 23.8514, 15.3249>, <10.6281, 26.206, 18.4697>, 0.8 }
				cylinder { <10.6281, 26.206, 18.4697>, <13.1186, 28.6234, 21.1903>, 0.8 }
				cylinder { <13.1186, 28.6234, 21.1903>, <16.04218, 31.05135, 23.4278>, 0.8 }
				cylinder { <16.04218, 31.05135, 23.4278>, <19.3353, 33.4373, 25.1337>, 0.8 }
				cylinder { <19.3353, 33.4373, 25.1337>, <22.9269, 35.7296, 26.2711>, 0.8 }
				cylinder { <22.9269, 35.7296, 26.2711>, <26.7392, 37.8786, 26.8155>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <26.7392, 37.8786, 26.8155>, <26.3303, 40.3644, 26.127>, <26.5342, 39.7613, 27.08023> }
					triangle { <26.9318, 40.2724, 24.5844>, <26.45, 42.1294, 24.9112>, <27.1287, 39.792, 26.09067> }
					triangle { <27.1287, 39.792, 26.09067>, <26.45, 42.1294, 24.9112>, <26.4798, 41.7963, 26.3467> }
					triangle { <26.3303, 40.3644, 26.127>, <26.9318, 40.2724, 24.5844>, <27.1287, 39.792, 26.09067> }
					triangle { <26.45, 42.1294, 24.9112>, <26.2429, 43.4724, 25.3435>, <26.4798, 41.7963, 26.3467> }
					triangle { <26.2429, 43.4724, 25.3435>, <26.1614, 43.1504, 26.5268>, <26.4798, 41.7963, 26.3467> }
					triangle { <26.2429, 43.4724, 25.3435>, <26.1172, 44.2627, 26.07005>, <26.1614, 43.1504, 26.5268> }
					triangle { <26.3303, 40.3644, 26.127>, <27.1287, 39.792, 26.09067>, <26.5342, 39.7613, 27.08023> }
					triangle { <27.1287, 39.792, 26.09067>, <26.9373, 39.7097, 27.09677>, <26.5342, 39.7613, 27.08023> }
					triangle { <27.1287, 39.792, 26.09067>, <26.4798, 41.7963, 26.3467>, <26.9373, 39.7097, 27.09677> }
					triangle { <26.4798, 41.7963, 26.3467>, <25.7699, 42.7694, 27.477>, <26.9373, 39.7097, 27.09677> }
					triangle { <26.4798, 41.7963, 26.3467>, <26.1614, 43.1504, 26.5268>, <25.7699, 42.7694, 27.477> }
					triangle { <26.1614, 43.1504, 26.5268>, <25.8318, 43.5478, 27.5952>, <25.7699, 42.7694, 27.477> }
					triangle { <26.1172, 44.2627, 26.07005>, <26.07948, 44.6195, 26.9028>, <26.1614, 43.1504, 26.5268> }
					triangle { <26.1614, 43.1504, 26.5268>, <26.07948, 44.6195, 26.9028>, <25.8318, 43.5478, 27.5952> }
					triangle { <26.7392, 37.8786, 26.8155>, <26.6319, 38.7074, 25.613>, <26.3303, 40.3644, 26.127> }
					triangle { <26.6319, 38.7074, 25.613>, <26.6209, 39.5914, 24.8363>, <26.3303, 40.3644, 26.127> }
					triangle { <26.6209, 39.5914, 24.8363>, <26.9318, 40.2724, 24.5844>, <26.3303, 40.3644, 26.127> }
					triangle { <25.8318, 43.5478, 27.5952>, <26.07948, 44.6195, 26.9028>, <26.1359, 44.2304, 27.7138> }
					triangle { <26.5342, 39.7613, 27.08023>, <26.2101, 40.06889, 28.1357>, <26.7392, 37.8786, 26.8155> }
					triangle { <27.00849, 39.4965, 28.09933>, <26.1639, 41.4261, 29.6918>, <26.6033, 39.5315, 29.4805> }
					triangle { <26.3596, 41.5008, 28.3553>, <26.1639, 41.4261, 29.6918>, <27.00849, 39.4965, 28.09933> }
					triangle { <27.00849, 39.4965, 28.09933>, <26.6033, 39.5315, 29.4805>, <26.2101, 40.06889, 28.1357> }
					triangle { <26.3596, 41.5008, 28.3553>, <26.00535, 42.9067, 29.5706>, <26.1639, 41.4261, 29.6918> }
					triangle { <26.3596, 41.5008, 28.3553>, <26.04119, 42.8549, 28.5355>, <26.00535, 42.9067, 29.5706> }
					triangle { <26.04119, 42.8549, 28.5355>, <25.9451, 43.7548, 29.2799>, <26.00535, 42.9067, 29.5706> }
					triangle { <26.5342, 39.7613, 27.08023>, <27.00849, 39.4965, 28.09933>, <26.2101, 40.06889, 28.1357> }
					triangle { <26.5342, 39.7613, 27.08023>, <26.9373, 39.7097, 27.09677>, <27.00849, 39.4965, 28.09933> }
					triangle { <26.9373, 39.7097, 27.09677>, <26.3596, 41.5008, 28.3553>, <27.00849, 39.4965, 28.09933> }
					triangle { <26.9373, 39.7097, 27.09677>, <25.7699, 42.7694, 27.477>, <26.3596, 41.5008, 28.3553> }
					triangle { <25.7699, 42.7694, 27.477>, <26.04119, 42.8549, 28.5355>, <26.3596, 41.5008, 28.3553> }
					triangle { <25.7699, 42.7694, 27.477>, <25.8318, 43.5478, 27.5952>, <26.04119, 42.8549, 28.5355> }
					triangle { <26.04119, 42.8549, 28.5355>, <26.02915, 44.3443, 28.6715>, <25.9451, 43.7548, 29.2799> }
					triangle { <25.8318, 43.5478, 27.5952>, <26.02915, 44.3443, 28.6715>, <26.04119, 42.8549, 28.5355> }
					triangle { <26.2101, 40.06889, 28.1357>, <26.477, 38.4115, 27.8667>, <26.7392, 37.8786, 26.8155> }
					triangle { <26.2101, 40.06889, 28.1357>, <26.3733, 38.9827, 28.9741>, <26.477, 38.4115, 27.8667> }
					triangle { <26.2101, 40.06889, 28.1357>, <26.6033, 39.5315, 29.4805>, <26.3733, 38.9827, 28.9741> }
					triangle { <26.1359, 44.2304, 27.7138>, <26.02915, 44.3443, 28.6715>, <25.8318, 43.5478, 27.5952> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <26.7392, 37.8786, 26.8155>, <26.4596, 39.434, 28.8946>, <27.03531, 38.4863, 28.6042> }
					triangle { <26.1142, 40.8371, 28.08107>, <26.2103, 41.2718, 29.9755>, <27.00164, 39.5139, 28.0785> }
					triangle { <27.00164, 39.5139, 28.0785>, <26.2103, 41.2718, 29.9755>, <26.9471, 40.00615, 30.1421> }
					triangle { <26.4596, 39.434, 28.8946>, <26.1142, 40.8371, 28.08107>, <27.00164, 39.5139, 28.0785> }
					triangle { <26.2103, 41.2718, 29.9755>, <26.5017, 41.4908, 31.3542>, <26.9471, 40.00615, 30.1421> }
					triangle { <26.5017, 41.4908, 31.3542>, <27.01323, 40.3817, 31.4919>, <26.9471, 40.00615, 30.1421> }
					triangle { <26.5017, 41.4908, 31.3542>, <26.9231, 41.25, 32.3199>, <27.01323, 40.3817, 31.4919> }
					triangle { <26.4596, 39.434, 28.8946>, <27.00164, 39.5139, 28.0785>, <27.03531, 38.4863, 28.6042> }
					triangle { <27.00164, 39.5139, 28.0785>, <27.3685, 38.6126, 28.4081>, <27.03531, 38.4863, 28.6042> }
					triangle { <27.00164, 39.5139, 28.0785>, <26.9471, 40.00615, 30.1421>, <27.3685, 38.6126, 28.4081> }
					triangle { <26.9471, 40.00615, 30.1421>, <27.1334, 39.3003, 31.6238>, <27.3685, 38.6126, 28.4081> }
					triangle { <26.9471, 40.00615, 30.1421>, <27.01323, 40.3817, 31.4919>, <27.1334, 39.3003, 31.6238> }
					triangle { <27.01323, 40.3817, 31.4919>, <27.3817, 39.6044, 32.3092>, <27.1334, 39.3003, 31.6238> }
					triangle { <26.9231, 41.25, 32.3199>, <27.3995, 40.7556, 32.9122>, <27.01323, 40.3817, 31.4919> }
					triangle { <27.01323, 40.3817, 31.4919>, <27.3995, 40.7556, 32.9122>, <27.3817, 39.6044, 32.3092> }
					triangle { <26.7392, 37.8786, 26.8155>, <26.1486, 39.1674, 27.182>, <26.4596, 39.434, 28.8946> }
					triangle { <26.1486, 39.1674, 27.182>, <25.8752, 40.1898, 27.6967>, <26.4596, 39.434, 28.8946> }
					triangle { <25.8752, 40.1898, 27.6967>, <26.1142, 40.8371, 28.08107>, <26.4596, 39.434, 28.8946> }
					triangle { <27.3817, 39.6044, 32.3092>, <27.3995, 40.7556, 32.9122>, <27.814, 39.9608, 32.8177> }
					triangle { <27.03531, 38.4863, 28.6042>, <27.386, 37.6784, 29.3378>, <26.7392, 37.8786, 26.8155> }
					triangle { <27.9279, 37.7584, 28.5216>, <28.4151, 37.0936, 31.03026>, <28.3393, 36.5337, 29.1573> }
					triangle { <27.8735, 38.2505, 30.5852>, <28.4151, 37.0936, 31.03026>, <27.9279, 37.7584, 28.5216> }
					triangle { <27.9279, 37.7584, 28.5216>, <28.3393, 36.5337, 29.1573>, <27.386, 37.6784, 29.3378> }
					triangle { <27.8735, 38.2505, 30.5852>, <28.4736, 37.8293, 32.3292>, <28.4151, 37.0936, 31.03026> }
					triangle { <27.8735, 38.2505, 30.5852>, <27.9395, 38.6261, 31.935>, <28.4736, 37.8293, 32.3292> }
					triangle { <27.9395, 38.6261, 31.935>, <28.4139, 38.4358, 32.9896>, <28.4736, 37.8293, 32.3292> }
					triangle { <27.03531, 38.4863, 28.6042>, <27.9279, 37.7584, 28.5216>, <27.386, 37.6784, 29.3378> }
					triangle { <27.03531, 38.4863, 28.6042>, <27.3685, 38.6126, 28.4081>, <27.9279, 37.7584, 28.5216> }
					triangle { <27.3685, 38.6126, 28.4081>, <27.8735, 38.2505, 30.5852>, <27.9279, 37.7584, 28.5216> }
					triangle { <27.3685, 38.6126, 28.4081>, <27.1334, 39.3003, 31.6238>, <27.8735, 38.2505, 30.5852> }
					triangle { <27.1334, 39.3003, 31.6238>, <27.9395, 38.6261, 31.935>, <27.8735, 38.2505, 30.5852> }
					triangle { <27.1334, 39.3003, 31.6238>, <27.3817, 39.6044, 32.3092>, <27.9395, 38.6261, 31.935> }
					triangle { <27.9395, 38.6261, 31.935>, <28.2585, 39.2251, 33.2678>, <28.4139, 38.4358, 32.9896> }
					triangle { <27.3817, 39.6044, 32.3092>, <28.2585, 39.2251, 33.2678>, <27.9395, 38.6261, 31.935> }
					triangle { <27.386, 37.6784, 29.3378>, <27.1774, 37.2066, 27.7177>, <26.7392, 37.8786, 26.8155> }
					triangle { <27.386, 37.6784, 29.3378>, <27.7835, 36.5734, 28.6096>, <27.1774, 37.2066, 27.7177> }
					triangle { <27.386, 37.6784, 29.3378>, <28.3393, 36.5337, 29.1573>, <27.7835, 36.5734, 28.6096> }
					triangle { <27.814, 39.9608, 32.8177>, <28.2585, 39.2251, 33.2678>, <27.3817, 39.6044, 32.3092> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <26.7392, 37.8786, 26.8155>, <27.8898, 36.8856, 28.9392>, <28.04712, 36.8941, 27.8039> }
					triangle { <27.4095, 38.04831, 30.01972>, <28.579, 36.8177, 30.9711>, <27.9141, 37.7802, 28.5325> }
					triangle { <27.9141, 37.7802, 28.5325>, <28.579, 36.8177, 30.9711>, <29.05973, 36.3839, 29.647> }
					triangle { <27.8898, 36.8856, 28.9392>, <27.4095, 38.04831, 30.01972>, <27.9141, 37.7802, 28.5325> }
					triangle { <28.579, 36.8177, 30.9711>, <29.5964, 35.9658, 31.4933>, <29.05973, 36.3839, 29.647> }
					triangle { <29.5964, 35.9658, 31.4933>, <29.9023, 35.5376, 30.3825>, <29.05973, 36.3839, 29.647> }
					triangle { <29.5964, 35.9658, 31.4933>, <30.4209, 35.2693, 31.4346>, <29.9023, 35.5376, 30.3825> }
					triangle { <27.8898, 36.8856, 28.9392>, <27.9141, 37.7802, 28.5325>, <28.04712, 36.8941, 27.8039> }
					triangle { <27.9141, 37.7802, 28.5325>, <28.2391, 37.2426, 27.7195>, <28.04712, 36.8941, 27.8039> }
					triangle { <27.9141, 37.7802, 28.5325>, <29.05973, 36.3839, 29.647>, <28.2391, 37.2426, 27.7195> }
					triangle { <29.05973, 36.3839, 29.647>, <29.8865, 34.9681, 29.4462>, <28.2391, 37.2426, 27.7195> }
					triangle { <29.05973, 36.3839, 29.647>, <29.9023, 35.5376, 30.3825>, <29.8865, 34.9681, 29.4462> }
					triangle { <29.9023, 35.5376, 30.3825>, <30.5113, 34.6797, 29.8338>, <29.8865, 34.9681, 29.4462> }
					triangle { <30.4209, 35.2693, 31.4346>, <31.04719, 34.7655, 31.01484>, <29.9023, 35.5376, 30.3825> }
					triangle { <29.9023, 35.5376, 30.3825>, <31.04719, 34.7655, 31.01484>, <30.5113, 34.6797, 29.8338> }
					triangle { <26.7392, 37.8786, 26.8155>, <26.669, 37.9672, 28.2755>, <27.8898, 36.8856, 28.9392> }
					triangle { <26.669, 37.9672, 28.2755>, <26.8947, 37.9422, 29.4302>, <27.8898, 36.8856, 28.9392> }
					triangle { <26.8947, 37.9422, 29.4302>, <27.4095, 38.04831, 30.01972>, <27.8898, 36.8856, 28.9392> }
					triangle { <30.5113, 34.6797, 29.8338>, <31.04719, 34.7655, 31.01484>, <31.2024, 34.6288, 30.1375> }
					triangle { <28.04712, 36.8941, 27.8039>, <28.5912, 36.07975, 27.2086>, <26.7392, 37.8786, 26.8155> }
					triangle { <28.6155, 36.9743, 26.8019>, <30.2483, 34.8997, 26.8521>, <29.08574, 36.06218, 25.7919> }
					triangle { <29.7611, 35.578, 27.9163>, <30.2483, 34.8997, 26.8521>, <28.6155, 36.9743, 26.8019> }
					triangle { <28.6155, 36.9743, 26.8019>, <29.08574, 36.06218, 25.7919>, <28.5912, 36.07975, 27.2086> }
					triangle { <29.7611, 35.578, 27.9163>, <31.1194, 34.2616, 27.8847>, <30.2483, 34.8997, 26.8521> }
					triangle { <29.7611, 35.578, 27.9163>, <30.6037, 34.7317, 28.6519>, <31.1194, 34.2616, 27.8847> }
					triangle { <30.6037, 34.7317, 28.6519>, <31.5282, 34.01166, 28.6448>, <31.1194, 34.2616, 27.8847> }
					triangle { <28.04712, 36.8941, 27.8039>, <28.6155, 36.9743, 26.8019>, <28.5912, 36.07975, 27.2086> }
					triangle { <28.04712, 36.8941, 27.8039>, <28.2391, 37.2426, 27.7195>, <28.6155, 36.9743, 26.8019> }
					triangle { <28.2391, 37.2426, 27.7195>, <29.7611, 35.578, 27.9163>, <28.6155, 36.9743, 26.8019> }
					triangle { <28.2391, 37.2426, 27.7195>, <29.8865, 34.9681, 29.4462>, <29.7611, 35.578, 27.9163> }
					triangle { <29.8865, 34.9681, 29.4462>, <30.6037, 34.7317, 28.6519>, <29.7611, 35.578, 27.9163> }
					triangle { <29.8865, 34.9681, 29.4462>, <30.5113, 34.6797, 29.8338>, <30.6037, 34.7317, 28.6519> }
					triangle { <30.6037, 34.7317, 28.6519>, <31.6846, 34.1078, 29.4761>, <31.5282, 34.01166, 28.6448> }
					triangle { <30.5113, 34.6797, 29.8338>, <31.6846, 34.1078, 29.4761>, <30.6037, 34.7317, 28.6519> }
					triangle { <28.5912, 36.07975, 27.2086>, <27.4695, 37.033, 26.3579>, <26.7392, 37.8786, 26.8155> }
					triangle { <28.5912, 36.07975, 27.2086>, <28.3395, 36.2822, 25.8651>, <27.4695, 37.033, 26.3579> }
					triangle { <28.5912, 36.07975, 27.2086>, <29.08574, 36.06218, 25.7919>, <28.3395, 36.2822, 25.8651> }
					triangle { <31.2024, 34.6288, 30.1375>, <31.6846, 34.1078, 29.4761>, <30.5113, 34.6797, 29.8338> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <26.7392, 37.8786, 26.8155>, <28.6577, 36.2172, 26.1996>, <28.1808, 37.1702, 25.7778> }
					triangle { <29.03972, 35.734, 27.7393>, <30.3047, 34.8809, 26.5313>, <28.6137, 36.9705, 26.8296> }
					triangle { <28.6137, 36.9705, 26.8296>, <30.3047, 34.8809, 26.5313>, <29.9178, 35.9017, 25.5409> }
					triangle { <28.6577, 36.2172, 26.1996>, <29.03972, 35.734, 27.7393>, <28.6137, 36.9705, 26.8296> }
					triangle { <30.3047, 34.8809, 26.5313>, <31.2791, 34.4812, 25.5698>, <29.9178, 35.9017, 25.5409> }
					triangle { <31.2791, 34.4812, 25.5698>, <30.863, 35.2672, 24.7215>, <29.9178, 35.9017, 25.5409> }
					triangle { <31.2791, 34.4812, 25.5698>, <31.8094, 34.5299, 24.6293>, <30.863, 35.2672, 24.7215> }
					triangle { <28.6577, 36.2172, 26.1996>, <28.6137, 36.9705, 26.8296>, <28.1808, 37.1702, 25.7778> }
					triangle { <28.6137, 36.9705, 26.8296>, <28.3541, 37.4802, 25.976>, <28.1808, 37.1702, 25.7778> }
					triangle { <28.6137, 36.9705, 26.8296>, <29.9178, 35.9017, 25.5409>, <28.3541, 37.4802, 25.976> }
					triangle { <29.9178, 35.9017, 25.5409>, <30.2502, 35.7192, 23.9332>, <28.3541, 37.4802, 25.976> }
					triangle { <29.9178, 35.9017, 25.5409>, <30.863, 35.2672, 24.7215>, <30.2502, 35.7192, 23.9332> }
					triangle { <30.863, 35.2672, 24.7215>, <30.9248, 35.5336, 23.5668>, <30.2502, 35.7192, 23.9332> }
					triangle { <31.8094, 34.5299, 24.6293>, <32.01546, 34.8715, 23.815>, <30.863, 35.2672, 24.7215> }
					triangle { <30.863, 35.2672, 24.7215>, <32.01546, 34.8715, 23.815>, <30.9248, 35.5336, 23.5668> }
					triangle { <26.7392, 37.8786, 26.8155>, <27.4789, 36.7542, 27.3924>, <28.6577, 36.2172, 26.1996> }
					triangle { <27.4789, 36.7542, 27.3924>, <28.28, 35.9338, 27.6573>, <28.6577, 36.2172, 26.1996> }
					triangle { <28.28, 35.9338, 27.6573>, <29.03972, 35.734, 27.7393>, <28.6577, 36.2172, 26.1996> }
					triangle { <30.9248, 35.5336, 23.5668>, <32.01546, 34.8715, 23.815>, <31.6501, 35.5533, 23.3523> }
					triangle { <28.1808, 37.1702, 25.7778>, <28.1714, 37.4672, 24.6708>, <26.7392, 37.8786, 26.8155> }
					triangle { <28.1273, 38.2205, 25.3007>, <29.1473, 37.8559, 22.8925>, <27.8179, 38.7641, 24.00385> }
					triangle { <29.4315, 37.1517, 24.01206>, <29.1473, 37.8559, 22.8925>, <28.1273, 38.2205, 25.3007> }
					triangle { <28.1273, 38.2205, 25.3007>, <27.8179, 38.7641, 24.00385>, <28.1714, 37.4672, 24.6708> }
					triangle { <29.4315, 37.1517, 24.01206>, <30.3109, 37.1008, 22.3378>, <29.1473, 37.8559, 22.8925> }
					triangle { <29.4315, 37.1517, 24.01206>, <30.3767, 36.5172, 23.1926>, <30.3109, 37.1008, 22.3378> }
					triangle { <30.3767, 36.5172, 23.1926>, <31.0133, 36.5551, 22.2095>, <30.3109, 37.1008, 22.3378> }
					triangle { <28.1808, 37.1702, 25.7778>, <28.1273, 38.2205, 25.3007>, <28.1714, 37.4672, 24.6708> }
					triangle { <28.1808, 37.1702, 25.7778>, <28.3541, 37.4802, 25.976>, <28.1273, 38.2205, 25.3007> }
					triangle { <28.3541, 37.4802, 25.976>, <29.4315, 37.1517, 24.01206>, <28.1273, 38.2205, 25.3007> }
					triangle { <28.3541, 37.4802, 25.976>, <30.2502, 35.7192, 23.9332>, <29.4315, 37.1517, 24.01206> }
					triangle { <30.2502, 35.7192, 23.9332>, <30.3767, 36.5172, 23.1926>, <29.4315, 37.1517, 24.01206> }
					triangle { <30.2502, 35.7192, 23.9332>, <30.9248, 35.5336, 23.5668>, <30.3767, 36.5172, 23.1926> }
					triangle { <30.3767, 36.5172, 23.1926>, <31.6046, 36.01662, 22.5009>, <31.0133, 36.5551, 22.2095> }
					triangle { <30.9248, 35.5336, 23.5668>, <31.6046, 36.01662, 22.5009>, <30.3767, 36.5172, 23.1926> }
					triangle { <28.1714, 37.4672, 24.6708>, <26.9522, 38.1289, 25.6537>, <26.7392, 37.8786, 26.8155> }
					triangle { <28.1714, 37.4672, 24.6708>, <27.2781, 38.5088, 24.5078>, <26.9522, 38.1289, 25.6537> }
					triangle { <28.1714, 37.4672, 24.6708>, <27.8179, 38.7641, 24.00385>, <27.2781, 38.5088, 24.5078> }
					triangle { <31.6501, 35.5533, 23.3523>, <31.6046, 36.01662, 22.5009>, <30.9248, 35.5336, 23.5668> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <26.7392, 37.8786, 26.8155>, <27.6794, 38.3996, 24.4354>, <27.2316, 38.9689, 25.3237> }
					triangle { <28.74, 37.1293, 24.3294>, <28.9691, 38.2133, 22.7295>, <28.1209, 38.2327, 25.2976> }
					triangle { <28.1209, 38.2327, 25.2976>, <28.9691, 38.2133, 22.7295>, <28.2993, 39.2973, 23.4704> }
					triangle { <27.6794, 38.3996, 24.4354>, <28.74, 37.1293, 24.3294>, <28.1209, 38.2327, 25.2976> }
					triangle { <28.9691, 38.2133, 22.7295>, <29.1752, 39.1906, 21.7117>, <28.2993, 39.2973, 23.4704> }
					triangle { <29.1752, 39.1906, 21.7117>, <28.5161, 40.04329, 22.3026>, <28.2993, 39.2973, 23.4704> }
					triangle { <29.1752, 39.1906, 21.7117>, <29.1094, 40.172, 21.2638>, <28.5161, 40.04329, 22.3026> }
					triangle { <27.6794, 38.3996, 24.4354>, <28.1209, 38.2327, 25.2976>, <27.2316, 38.9689, 25.3237> }
					triangle { <28.1209, 38.2327, 25.2976>, <27.5374, 39.02797, 25.5854>, <27.2316, 38.9689, 25.3237> }
					triangle { <28.1209, 38.2327, 25.2976>, <28.2993, 39.2973, 23.4704>, <27.5374, 39.02797, 25.5854> }
					triangle { <28.2993, 39.2973, 23.4704>, <27.6676, 40.6135, 22.6978>, <27.5374, 39.02797, 25.5854> }
					triangle { <28.2993, 39.2973, 23.4704>, <28.5161, 40.04329, 22.3026>, <27.6676, 40.6135, 22.6978> }
					triangle { <28.5161, 40.04329, 22.3026>, <27.989, 41.09717, 22.1624>, <27.6676, 40.6135, 22.6978> }
					triangle { <29.1094, 40.172, 21.2638>, <28.8989, 41.05363, 21.2352>, <28.5161, 40.04329, 22.3026> }
					triangle { <28.5161, 40.04329, 22.3026>, <28.8989, 41.05363, 21.2352>, <27.989, 41.09717, 22.1624> }
					triangle { <26.7392, 37.8786, 26.8155>, <27.4556, 37.2185, 25.7221>, <27.6794, 38.3996, 24.4354> }
					triangle { <27.4556, 37.2185, 25.7221>, <28.1083, 36.9684, 24.7753>, <27.6794, 38.3996, 24.4354> }
					triangle { <28.1083, 36.9684, 24.7753>, <28.74, 37.1293, 24.3294>, <27.6794, 38.3996, 24.4354> }
					triangle { <27.989, 41.09717, 22.1624>, <28.8989, 41.05363, 21.2352>, <28.4715, 41.577, 21.8317> }
					triangle { <27.2316, 38.9689, 25.3237>, <26.6776, 39.9698, 25.2524>, <26.7392, 37.8786, 26.8155> }
					triangle { <27.1191, 39.8029, 26.1146>, <26.5848, 41.9503, 24.674>, <26.2605, 40.9407, 26.3179> }
					triangle { <27.2975, 40.8674, 24.2874>, <26.5848, 41.9503, 24.674>, <27.1191, 39.8029, 26.1146> }
					triangle { <27.1191, 39.8029, 26.1146>, <26.2605, 40.9407, 26.3179>, <26.6776, 39.9698, 25.2524> }
					triangle { <27.2975, 40.8674, 24.2874>, <27.1025, 42.5243, 23.3955>, <26.5848, 41.9503, 24.674> }
					triangle { <27.2975, 40.8674, 24.2874>, <27.5143, 41.6134, 23.1196>, <27.1025, 42.5243, 23.3955> }
					triangle { <27.5143, 41.6134, 23.1196>, <27.5107, 42.6677, 22.6079>, <27.1025, 42.5243, 23.3955> }
					triangle { <27.2316, 38.9689, 25.3237>, <27.1191, 39.8029, 26.1146>, <26.6776, 39.9698, 25.2524> }
					triangle { <27.2316, 38.9689, 25.3237>, <27.5374, 39.02797, 25.5854>, <27.1191, 39.8029, 26.1146> }
					triangle { <27.5374, 39.02797, 25.5854>, <27.2975, 40.8674, 24.2874>, <27.1191, 39.8029, 26.1146> }
					triangle { <27.5374, 39.02797, 25.5854>, <27.6676, 40.6135, 22.6978>, <27.2975, 40.8674, 24.2874> }
					triangle { <27.6676, 40.6135, 22.6978>, <27.5143, 41.6134, 23.1196>, <27.2975, 40.8674, 24.2874> }
					triangle { <27.6676, 40.6135, 22.6978>, <27.989, 41.09717, 22.1624>, <27.5143, 41.6134, 23.1196> }
					triangle { <27.5143, 41.6134, 23.1196>, <28.05658, 42.4386, 21.9962>, <27.5107, 42.6677, 22.6079> }
					triangle { <27.989, 41.09717, 22.1624>, <28.05658, 42.4386, 21.9962>, <27.5143, 41.6134, 23.1196> }
					triangle { <26.6776, 39.9698, 25.2524>, <26.3296, 38.9937, 26.6002>, <26.7392, 37.8786, 26.8155> }
					triangle { <26.6776, 39.9698, 25.2524>, <26.04463, 40.203, 26.4584>, <26.3296, 38.9937, 26.6002> }
					triangle { <26.6776, 39.9698, 25.2524>, <26.2605, 40.9407, 26.3179>, <26.04463, 40.203, 26.4584> }
					triangle { <28.4715, 41.577, 21.8317>, <28.05658, 42.4386, 21.9962>, <27.989, 41.09717, 22.1624> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <6.24, 19.5325, 8.04259>, <6.3072, 19.9143, 8.8548>, 0.8 }
			cylinder { <6.3072, 19.9143, 8.8548>, <6.3744, 20.2961, 9.667>, 0.8 }
			cylinder { <6.3744, 20.2961, 9.667>, <6.4416, 20.678, 10.4792>, 0.8 }
			cylinder { <6.4416, 20.678, 10.4792>, <6.5088, 21.05984, 11.2914>, 0.8 }
			cylinder { <6.5088, 21.05984, 11.2914>, <6.576, 21.4416, 12.1036>, 0.8 }
			cylinder { <6.576, 21.4416, 12.1036>, <6.6432, 21.8235, 12.9158>, 0.8 }
			cylinder { <6.6432, 21.8235, 12.9158>, <6.7104, 22.2053, 13.7281>, 0.8 }
			cylinder { <6.7104, 22.2053, 13.7281>, <6.7776, 22.5871, 14.5403>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <6.7776, 22.5871, 14.5403>, <6.4873, 24.6318, 18.4368>, 0.8 }
				cylinder { <6.4873, 24.6318, 18.4368>, <5.5837, 26.8059, 22.1657>, 0.8 }
				cylinder { <5.5837, 26.8059, 22.1657>, <4.08647, 29.06249, 25.6463>, 0.8 }
				cylinder { <4.08647, 29.06249, 25.6463>, <2.02784, 31.3525, 28.8031>, 0.8 }
				cylinder { <2.02784, 31.3525, 28.8031>, <-0.5475, 33.6266, 31.5679>, 0.8 }
				cylinder { <-0.5475, 33.6266, 31.5679>, <-3.5839, 35.8354, 33.8808>, 0.8 }
				cylinder { <-3.5839, 35.8354, 33.8808>, <-7.01562, 37.9312, 35.6918>, 0.8 }
				cylinder { <-7.01562, 37.9312, 35.6918>, <-10.7683, 39.8685, 36.9616>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-10.7683, 39.8685, 36.9616>, <-12.00293, 38.2578, 38.2299>, <-11.4837, 39.156, 38.3938> }
					triangle { <-12.9281, 37.7869, 37.1202>, <-13.4223, 36.9519, 38.6165>, <-12.2624, 38.9452, 37.7088> }
					triangle { <-12.2624, 38.9452, 37.7088>, <-13.4223, 36.9519, 38.6165>, <-12.7451, 37.9114, 39.2836> }
					triangle { <-12.00293, 38.2578, 38.2299>, <-12.9281, 37.7869, 37.1202>, <-12.2624, 38.9452, 37.7088> }
					triangle { <-13.4223, 36.9519, 38.6165>, <-13.8022, 36.5444, 39.7985>, <-12.7451, 37.9114, 39.2836> }
					triangle { <-13.8022, 36.5444, 39.7985>, <-13.1488, 37.2896, 40.3336>, <-12.7451, 37.9114, 39.2836> }
					triangle { <-13.8022, 36.5444, 39.7985>, <-13.8491, 36.569, 40.7875>, <-13.1488, 37.2896, 40.3336> }
					triangle { <-12.00293, 38.2578, 38.2299>, <-12.2624, 38.9452, 37.7088>, <-11.4837, 39.156, 38.3938> }
					triangle { <-12.2624, 38.9452, 37.7088>, <-11.7217, 39.4299, 38.3082>, <-11.4837, 39.156, 38.3938> }
					triangle { <-12.2624, 38.9452, 37.7088>, <-12.7451, 37.9114, 39.2836>, <-11.7217, 39.4299, 38.3082> }
					triangle { <-12.7451, 37.9114, 39.2836>, <-12.344, 37.7384, 40.7329>, <-11.7217, 39.4299, 38.3082> }
					triangle { <-12.7451, 37.9114, 39.2836>, <-13.1488, 37.2896, 40.3336>, <-12.344, 37.7384, 40.7329> }
					triangle { <-13.1488, 37.2896, 40.3336>, <-12.7348, 37.5377, 41.308>, <-12.344, 37.7384, 40.7329> }
					triangle { <-13.8491, 36.569, 40.7875>, <-13.697, 36.8766, 41.5443>, <-13.1488, 37.2896, 40.3336> }
					triangle { <-13.1488, 37.2896, 40.3336>, <-13.697, 36.8766, 41.5443>, <-12.7348, 37.5377, 41.308> }
					triangle { <-10.7683, 39.8685, 36.9616>, <-11.558, 38.7995, 36.7765>, <-12.00293, 38.2578, 38.2299> }
					triangle { <-11.558, 38.7995, 36.7765>, <-12.2832, 38.00772, 36.8769>, <-12.00293, 38.2578, 38.2299> }
					triangle { <-12.2832, 38.00772, 36.8769>, <-12.9281, 37.7869, 37.1202>, <-12.00293, 38.2578, 38.2299> }
					triangle { <-12.7348, 37.5377, 41.308>, <-13.697, 36.8766, 41.5443>, <-13.2395, 37.5215, 41.7832> }
					triangle { <-11.4837, 39.156, 38.3938>, <-11.03281, 39.4354, 39.3003>, <-10.7683, 39.8685, 36.9616> }
					triangle { <-11.2922, 40.1228, 38.7792>, <-11.1134, 39.7545, 41.1641>, <-10.5293, 40.6438, 39.7212> }
					triangle { <-11.7749, 39.08899, 40.3541>, <-11.1134, 39.7545, 41.1641>, <-11.2922, 40.1228, 38.7792> }
					triangle { <-11.2922, 40.1228, 38.7792>, <-10.5293, 40.6438, 39.7212>, <-11.03281, 39.4354, 39.3003> }
					triangle { <-11.7749, 39.08899, 40.3541>, <-11.7993, 39.0099, 42.08572>, <-11.1134, 39.7545, 41.1641> }
					triangle { <-11.7749, 39.08899, 40.3541>, <-12.1787, 38.4672, 41.404>, <-11.7993, 39.0099, 42.08572> }
					triangle { <-12.1787, 38.4672, 41.404>, <-12.2943, 38.4769, 42.4716>, <-11.7993, 39.0099, 42.08572> }
					triangle { <-11.4837, 39.156, 38.3938>, <-11.2922, 40.1228, 38.7792>, <-11.03281, 39.4354, 39.3003> }
					triangle { <-11.4837, 39.156, 38.3938>, <-11.7217, 39.4299, 38.3082>, <-11.2922, 40.1228, 38.7792> }
					triangle { <-11.7217, 39.4299, 38.3082>, <-11.7749, 39.08899, 40.3541>, <-11.2922, 40.1228, 38.7792> }
					triangle { <-11.7217, 39.4299, 38.3082>, <-12.344, 37.7384, 40.7329>, <-11.7749, 39.08899, 40.3541> }
					triangle { <-12.344, 37.7384, 40.7329>, <-12.1787, 38.4672, 41.404>, <-11.7749, 39.08899, 40.3541> }
					triangle { <-12.344, 37.7384, 40.7329>, <-12.7348, 37.5377, 41.308>, <-12.1787, 38.4672, 41.404> }
					triangle { <-12.1787, 38.4672, 41.404>, <-12.8724, 37.9531, 42.4684>, <-12.2943, 38.4769, 42.4716> }
					triangle { <-12.7348, 37.5377, 41.308>, <-12.8724, 37.9531, 42.4684>, <-12.1787, 38.4672, 41.404> }
					triangle { <-11.03281, 39.4354, 39.3003>, <-10.4741, 40.09459, 38.00394>, <-10.7683, 39.8685, 36.9616> }
					triangle { <-11.03281, 39.4354, 39.3003>, <-10.2847, 40.4335, 39.08204>, <-10.4741, 40.09459, 38.00394> }
					triangle { <-11.03281, 39.4354, 39.3003>, <-10.5293, 40.6438, 39.7212>, <-10.2847, 40.4335, 39.08204> }
					triangle { <-13.2395, 37.5215, 41.7832>, <-12.8724, 37.9531, 42.4684>, <-12.7348, 37.5377, 41.308> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-10.7683, 39.8685, 36.9616>, <-10.5997, 40.264, 39.3158>, <-10.6141, 40.8201, 38.4249> }
					triangle { <-11.3765, 39.04543, 39.7857>, <-10.9621, 40.00349, 41.2316>, <-11.3041, 40.1001, 38.7788> }
					triangle { <-11.3041, 40.1001, 38.7788>, <-10.9621, 40.00349, 41.2316>, <-10.7554, 41.03992, 40.3905> }
					triangle { <-10.5997, 40.264, 39.3158>, <-11.3765, 39.04543, 39.7857>, <-11.3041, 40.1001, 38.7788> }
					triangle { <-10.9621, 40.00349, 41.2316>, <-10.7598, 40.8729, 42.1859>, <-10.7554, 41.03992, 40.3905> }
					triangle { <-10.7598, 40.8729, 42.1859>, <-10.4918, 41.6952, 41.4644>, <-10.7554, 41.03992, 40.3905> }
					triangle { <-10.7598, 40.8729, 42.1859>, <-10.5646, 41.7681, 42.5621>, <-10.4918, 41.6952, 41.4644> }
					triangle { <-10.5997, 40.264, 39.3158>, <-11.3041, 40.1001, 38.7788>, <-10.6141, 40.8201, 38.4249> }
					triangle { <-11.3041, 40.1001, 38.7788>, <-10.9735, 40.8618, 38.335>, <-10.6141, 40.8201, 38.4249> }
					triangle { <-11.3041, 40.1001, 38.7788>, <-10.7554, 41.03992, 40.3905>, <-10.9735, 40.8618, 38.335> }
					triangle { <-10.7554, 41.03992, 40.3905>, <-9.9778, 42.2663, 40.8176>, <-10.9735, 40.8618, 38.335> }
					triangle { <-10.7554, 41.03992, 40.3905>, <-10.4918, 41.6952, 41.4644>, <-9.9778, 42.2663, 40.8176> }
					triangle { <-10.4918, 41.6952, 41.4644>, <-10.04516, 42.6848, 41.4042>, <-9.9778, 42.2663, 40.8176> }
					triangle { <-10.5646, 41.7681, 42.5621>, <-10.4159, 42.5851, 42.5317>, <-10.4918, 41.6952, 41.4644> }
					triangle { <-10.4918, 41.6952, 41.4644>, <-10.4159, 42.5851, 42.5317>, <-10.04516, 42.6848, 41.4042> }
					triangle { <-10.7683, 39.8685, 36.9616>, <-10.888, 39.2126, 38.1261>, <-10.5997, 40.264, 39.3158> }
					triangle { <-10.888, 39.2126, 38.1261>, <-11.03129, 38.9371, 39.1589>, <-10.5997, 40.264, 39.3158> }
					triangle { <-11.03129, 38.9371, 39.1589>, <-11.3765, 39.04543, 39.7857>, <-10.5997, 40.264, 39.3158> }
					triangle { <-10.04516, 42.6848, 41.4042>, <-10.4159, 42.5851, 42.5317>, <-10.3273, 43.09428, 41.8874> }
					triangle { <-10.6141, 40.8201, 38.4249>, <-10.1709, 41.7635, 38.2954>, <-10.7683, 39.8685, 36.9616> }
					triangle { <-10.8753, 41.5996, 37.7584>, <-9.9414, 43.5723, 38.8031>, <-10.2984, 42.6878, 37.2852> }
					triangle { <-10.3266, 42.5394, 39.3702>, <-9.9414, 43.5723, 38.8031>, <-10.8753, 41.5996, 37.7584> }
					triangle { <-10.8753, 41.5996, 37.7584>, <-10.2984, 42.6878, 37.2852>, <-10.1709, 41.7635, 38.2954> }
					triangle { <-10.3266, 42.5394, 39.3702>, <-9.8733, 44.0532, 40.08319>, <-9.9414, 43.5723, 38.8031> }
					triangle { <-10.3266, 42.5394, 39.3702>, <-10.06301, 43.1947, 40.444>, <-9.8733, 44.0532, 40.08319> }
					triangle { <-10.06301, 43.1947, 40.444>, <-9.896, 44.1524, 40.9003>, <-9.8733, 44.0532, 40.08319> }
					triangle { <-10.6141, 40.8201, 38.4249>, <-10.8753, 41.5996, 37.7584>, <-10.1709, 41.7635, 38.2954> }
					triangle { <-10.6141, 40.8201, 38.4249>, <-10.9735, 40.8618, 38.335>, <-10.8753, 41.5996, 37.7584> }
					triangle { <-10.9735, 40.8618, 38.335>, <-10.3266, 42.5394, 39.3702>, <-10.8753, 41.5996, 37.7584> }
					triangle { <-10.9735, 40.8618, 38.335>, <-9.9778, 42.2663, 40.8176>, <-10.3266, 42.5394, 39.3702> }
					triangle { <-9.9778, 42.2663, 40.8176>, <-10.06301, 43.1947, 40.444>, <-10.3266, 42.5394, 39.3702> }
					triangle { <-9.9778, 42.2663, 40.8176>, <-10.04516, 42.6848, 41.4042>, <-10.06301, 43.1947, 40.444> }
					triangle { <-10.06301, 43.1947, 40.444>, <-10.0879, 43.9061, 41.6152>, <-9.896, 44.1524, 40.9003> }
					triangle { <-10.04516, 42.6848, 41.4042>, <-10.0879, 43.9061, 41.6152>, <-10.06301, 43.1947, 40.444> }
					triangle { <-10.1709, 41.7635, 38.2954>, <-10.3901, 40.907, 37.01266>, <-10.7683, 39.8685, 36.9616> }
					triangle { <-10.1709, 41.7635, 38.2954>, <-10.1478, 42.0261, 37.05694>, <-10.3901, 40.907, 37.01266> }
					triangle { <-10.1709, 41.7635, 38.2954>, <-10.2984, 42.6878, 37.2852>, <-10.1478, 42.0261, 37.05694> }
					triangle { <-10.3273, 43.09428, 41.8874>, <-10.0879, 43.9061, 41.6152>, <-10.04516, 42.6848, 41.4042> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-10.7683, 39.8685, 36.9616>, <-10.2551, 42.1544, 37.4501>, <-10.7833, 41.605, 36.7273> }
					triangle { <-10.122, 42.01809, 38.9577>, <-9.9338, 43.7463, 38.5601>, <-10.873, 41.5888, 37.7816> }
					triangle { <-10.873, 41.5888, 37.7816>, <-9.9338, 43.7463, 38.5601>, <-10.5249, 43.4596, 37.38> }
					triangle { <-10.2551, 42.1544, 37.4501>, <-10.122, 42.01809, 38.9577>, <-10.873, 41.5888, 37.7816> }
					triangle { <-9.9338, 43.7463, 38.5601>, <-9.993, 44.9915, 38.1683>, <-10.5249, 43.4596, 37.38> }
					triangle { <-9.993, 44.9915, 38.1683>, <-10.3912, 44.7172, 37.151>, <-10.5249, 43.4596, 37.38> }
					triangle { <-9.993, 44.9915, 38.1683>, <-10.2155, 45.7308, 37.5479>, <-10.3912, 44.7172, 37.151> }
					triangle { <-10.2551, 42.1544, 37.4501>, <-10.873, 41.5888, 37.7816>, <-10.7833, 41.605, 36.7273> }
					triangle { <-10.873, 41.5888, 37.7816>, <-11.1191, 41.5371, 36.8743>, <-10.7833, 41.605, 36.7273> }
					triangle { <-10.873, 41.5888, 37.7816>, <-10.5249, 43.4596, 37.38>, <-11.1191, 41.5371, 36.8743> }
					triangle { <-10.5249, 43.4596, 37.38>, <-10.4382, 44.4019, 36.1986>, <-11.1191, 41.5371, 36.8743> }
					triangle { <-10.5249, 43.4596, 37.38>, <-10.3912, 44.7172, 37.151>, <-10.4382, 44.4019, 36.1986> }
					triangle { <-10.3912, 44.7172, 37.151>, <-10.5685, 45.1124, 36.1536>, <-10.4382, 44.4019, 36.1986> }
					triangle { <-10.2155, 45.7308, 37.5479>, <-10.5356, 46.07061, 36.8604>, <-10.3912, 44.7172, 37.151> }
					triangle { <-10.3912, 44.7172, 37.151>, <-10.5356, 46.07061, 36.8604>, <-10.5685, 45.1124, 36.1536> }
					triangle { <-10.7683, 39.8685, 36.9616>, <-10.2278, 40.6159, 37.9362>, <-10.2551, 42.1544, 37.4501> }
					triangle { <-10.2278, 40.6159, 37.9362>, <-9.9408, 41.4147, 38.6015>, <-10.2551, 42.1544, 37.4501> }
					triangle { <-9.9408, 41.4147, 38.6015>, <-10.122, 42.01809, 38.9577>, <-10.2551, 42.1544, 37.4501> }
					triangle { <-10.5685, 45.1124, 36.1536>, <-10.5356, 46.07061, 36.8604>, <-10.8939, 45.7227, 36.2025> }
					triangle { <-10.7833, 41.605, 36.7273>, <-10.9562, 41.9175, 35.7396>, <-10.7683, 39.8685, 36.9616> }
					triangle { <-11.574, 41.352, 36.07111>, <-11.6023, 43.1826, 34.489>, <-11.8009, 41.4238, 34.7733> }
					triangle { <-11.226, 43.2227, 35.6694>, <-11.6023, 43.1826, 34.489>, <-11.574, 41.352, 36.07111> }
					triangle { <-11.574, 41.352, 36.07111>, <-11.8009, 41.4238, 34.7733>, <-10.9562, 41.9175, 35.7396> }
					triangle { <-11.226, 43.2227, 35.6694>, <-11.4833, 44.5437, 34.5766>, <-11.6023, 43.1826, 34.489> }
					triangle { <-11.226, 43.2227, 35.6694>, <-11.0923, 44.4804, 35.4405>, <-11.4833, 44.5437, 34.5766> }
					triangle { <-11.0923, 44.4804, 35.4405>, <-11.3509, 45.3187, 34.8212>, <-11.4833, 44.5437, 34.5766> }
					triangle { <-10.7833, 41.605, 36.7273>, <-11.574, 41.352, 36.07111>, <-10.9562, 41.9175, 35.7396> }
					triangle { <-10.7833, 41.605, 36.7273>, <-11.1191, 41.5371, 36.8743>, <-11.574, 41.352, 36.07111> }
					triangle { <-11.1191, 41.5371, 36.8743>, <-11.226, 43.2227, 35.6694>, <-11.574, 41.352, 36.07111> }
					triangle { <-11.1191, 41.5371, 36.8743>, <-10.4382, 44.4019, 36.1986>, <-11.226, 43.2227, 35.6694> }
					triangle { <-10.4382, 44.4019, 36.1986>, <-11.0923, 44.4804, 35.4405>, <-11.226, 43.2227, 35.6694> }
					triangle { <-10.4382, 44.4019, 36.1986>, <-10.5685, 45.1124, 36.1536>, <-11.0923, 44.4804, 35.4405> }
					triangle { <-11.0923, 44.4804, 35.4405>, <-11.1979, 45.8454, 35.376>, <-11.3509, 45.3187, 34.8212> }
					triangle { <-10.5685, 45.1124, 36.1536>, <-11.1979, 45.8454, 35.376>, <-11.0923, 44.4804, 35.4405> }
					triangle { <-10.9562, 41.9175, 35.7396>, <-10.9993, 40.3838, 36.01024>, <-10.7683, 39.8685, 36.9616> }
					triangle { <-10.9562, 41.9175, 35.7396>, <-11.385, 40.9268, 35.07779>, <-10.9993, 40.3838, 36.01024> }
					triangle { <-10.9562, 41.9175, 35.7396>, <-11.8009, 41.4238, 34.7733>, <-11.385, 40.9268, 35.07779> }
					triangle { <-10.8939, 45.7227, 36.2025>, <-11.1979, 45.8454, 35.376>, <-10.5685, 45.1124, 36.1536> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-10.7683, 39.8685, 36.9616>, <-11.4421, 41.3341, 35.1937>, <-11.7591, 40.4333, 35.6312> }
					triangle { <-10.8866, 42.6245, 35.7728>, <-11.7489, 43.04296, 34.2689>, <-11.5607, 41.368, 36.0861> }
					triangle { <-11.5607, 41.368, 36.0861>, <-11.7489, 43.04296, 34.2689>, <-12.37, 41.8491, 34.3844> }
					triangle { <-11.4421, 41.3341, 35.1937>, <-10.8866, 42.6245, 35.7728>, <-11.5607, 41.368, 36.0861> }
					triangle { <-11.7489, 43.04296, 34.2689>, <-12.5544, 43.2468, 33.2603>, <-12.37, 41.8491, 34.3844> }
					triangle { <-12.5544, 43.2468, 33.2603>, <-12.9851, 42.2075, 33.3142>, <-12.37, 41.8491, 34.3844> }
					triangle { <-12.5544, 43.2468, 33.2603>, <-13.281, 43.01784, 32.6275>, <-12.9851, 42.2075, 33.3142> }
					triangle { <-11.4421, 41.3341, 35.1937>, <-11.5607, 41.368, 36.0861>, <-11.7591, 40.4333, 35.6312> }
					triangle { <-11.5607, 41.368, 36.0861>, <-11.9587, 40.5289, 35.9312>, <-11.7591, 40.4333, 35.6312> }
					triangle { <-11.5607, 41.368, 36.0861>, <-12.37, 41.8491, 34.3844>, <-11.9587, 40.5289, 35.9312> }
					triangle { <-12.37, 41.8491, 34.3844>, <-13.09323, 41.2138, 33.2162>, <-11.9587, 40.5289, 35.9312> }
					triangle { <-12.37, 41.8491, 34.3844>, <-12.9851, 42.2075, 33.3142>, <-13.09323, 41.2138, 33.2162> }
					triangle { <-12.9851, 42.2075, 33.3142>, <-13.5865, 41.4884, 32.7634>, <-13.09323, 41.2138, 33.2162> }
					triangle { <-13.281, 43.01784, 32.6275>, <-13.8917, 42.5488, 32.315>, <-12.9851, 42.2075, 33.3142> }
					triangle { <-12.9851, 42.2075, 33.3142>, <-13.8917, 42.5488, 32.315>, <-13.5865, 41.4884, 32.7634> }
					triangle { <-10.7683, 39.8685, 36.9616>, <-10.4836, 41.08321, 36.4674>, <-11.4421, 41.3341, 35.1937> }
					triangle { <-10.4836, 41.08321, 36.4674>, <-10.5086, 42.03967, 35.9699>, <-11.4421, 41.3341, 35.1937> }
					triangle { <-10.5086, 42.03967, 35.9699>, <-10.8866, 42.6245, 35.7728>, <-11.4421, 41.3341, 35.1937> }
					triangle { <-13.5865, 41.4884, 32.7634>, <-13.8917, 42.5488, 32.315>, <-14.1616, 41.7989, 32.5319> }
					triangle { <-11.7591, 40.4333, 35.6312>, <-12.3108, 39.686, 35.141>, <-10.7683, 39.8685, 36.9616> }
					triangle { <-12.4294, 39.7199, 36.03333>, <-13.8164, 39.1205, 34.1433>, <-12.9744, 38.5868, 35.6333> }
					triangle { <-13.2387, 40.201, 34.3316>, <-13.8164, 39.1205, 34.1433>, <-12.4294, 39.7199, 36.03333> }
					triangle { <-12.4294, 39.7199, 36.03333>, <-12.9744, 38.5868, 35.6333>, <-12.3108, 39.686, 35.141> }
					triangle { <-13.2387, 40.201, 34.3316>, <-14.4194, 39.8081, 33.1246>, <-13.8164, 39.1205, 34.1433> }
					triangle { <-13.2387, 40.201, 34.3316>, <-13.8537, 40.5594, 33.2615>, <-14.4194, 39.8081, 33.1246> }
					triangle { <-13.8537, 40.5594, 33.2615>, <-14.6619, 40.375, 32.5787>, <-14.4194, 39.8081, 33.1246> }
					triangle { <-11.7591, 40.4333, 35.6312>, <-12.4294, 39.7199, 36.03333>, <-12.3108, 39.686, 35.141> }
					triangle { <-11.7591, 40.4333, 35.6312>, <-11.9587, 40.5289, 35.9312>, <-12.4294, 39.7199, 36.03333> }
					triangle { <-11.9587, 40.5289, 35.9312>, <-13.2387, 40.201, 34.3316>, <-12.4294, 39.7199, 36.03333> }
					triangle { <-11.9587, 40.5289, 35.9312>, <-13.09323, 41.2138, 33.2162>, <-13.2387, 40.201, 34.3316> }
					triangle { <-13.09323, 41.2138, 33.2162>, <-13.8537, 40.5594, 33.2615>, <-13.2387, 40.201, 34.3316> }
					triangle { <-13.09323, 41.2138, 33.2162>, <-13.5865, 41.4884, 32.7634>, <-13.8537, 40.5594, 33.2615> }
					triangle { <-13.8537, 40.5594, 33.2615>, <-14.6788, 41.1089, 32.315>, <-14.6619, 40.375, 32.5787> }
					triangle { <-13.5865, 41.4884, 32.7634>, <-14.6788, 41.1089, 32.315>, <-13.8537, 40.5594, 33.2615> }
					triangle { <-12.3108, 39.686, 35.141>, <-11.4656, 39.2432, 36.3726>, <-10.7683, 39.8685, 36.9616> }
					triangle { <-12.3108, 39.686, 35.141>, <-12.2981, 38.6446, 35.8612>, <-11.4656, 39.2432, 36.3726> }
					triangle { <-12.3108, 39.686, 35.141>, <-12.9744, 38.5868, 35.6333>, <-12.2981, 38.6446, 35.8612> }
					triangle { <-14.1616, 41.7989, 32.5319>, <-14.6788, 41.1089, 32.315>, <-13.5865, 41.4884, 32.7634> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <-10.7683, 39.8685, 36.9616>, <-12.5386, 38.8895, 35.683>, <-12.1985, 38.8969, 36.6767> }
					triangle { <-12.647, 39.9701, 34.62>, <-13.9375, 38.7804, 34.3043>, <-12.4323, 39.7095, 36.04041> }
					triangle { <-12.4323, 39.7095, 36.04041>, <-13.9375, 38.7804, 34.3043>, <-13.7628, 38.3683, 35.5787> }
					triangle { <-12.5386, 38.8895, 35.683>, <-12.647, 39.9701, 34.62>, <-12.4323, 39.7095, 36.04041> }
					triangle { <-13.9375, 38.7804, 34.3043>, <-14.9441, 37.9474, 34.2831>, <-13.7628, 38.3683, 35.5787> }
					triangle { <-14.9441, 37.9474, 34.2831>, <-14.7151, 37.5477, 35.3109>, <-13.7628, 38.3683, 35.5787> }
					triangle { <-14.9441, 37.9474, 34.2831>, <-15.5606, 37.27, 34.6599>, <-14.7151, 37.5477, 35.3109> }
					triangle { <-12.5386, 38.8895, 35.683>, <-12.4323, 39.7095, 36.04041>, <-12.1985, 38.8969, 36.6767> }
					triangle { <-12.4323, 39.7095, 36.04041>, <-12.3368, 39.2069, 36.8308>, <-12.1985, 38.8969, 36.6767> }
					triangle { <-12.4323, 39.7095, 36.04041>, <-13.7628, 38.3683, 35.5787>, <-12.3368, 39.2069, 36.8308> }
					triangle { <-13.7628, 38.3683, 35.5787>, <-14.2888, 37.03347, 36.06092>, <-12.3368, 39.2069, 36.8308> }
					triangle { <-13.7628, 38.3683, 35.5787>, <-14.7151, 37.5477, 35.3109>, <-14.2888, 37.03347, 36.06092> }
					triangle { <-14.7151, 37.5477, 35.3109>, <-14.9456, 36.7363, 35.997>, <-14.2888, 37.03347, 36.06092> }
					triangle { <-15.5606, 37.27, 34.6599>, <-15.8751, 36.7809, 35.2536>, <-14.7151, 37.5477, 35.3109> }
					triangle { <-14.7151, 37.5477, 35.3109>, <-15.8751, 36.7809, 35.2536>, <-14.9456, 36.7363, 35.997> }
					triangle { <-10.7683, 39.8685, 36.9616>, <-11.3181, 39.9436, 35.7398>, <-12.5386, 38.8895, 35.683> }
					triangle { <-11.3181, 39.9436, 35.7398>, <-11.9781, 39.9022, 34.888>, <-12.5386, 38.8895, 35.683> }
					triangle { <-11.9781, 39.9022, 34.888>, <-12.647, 39.9701, 34.62>, <-12.5386, 38.8895, 35.683> }
					triangle { <-14.9456, 36.7363, 35.997>, <-15.8751, 36.7809, 35.2536>, <-15.6331, 36.6538, 36.03304> }
					triangle { <-12.1985, 38.8969, 36.6767>, <-12.3588, 38.1288, 37.3749>, <-10.7683, 39.8685, 36.9616> }
					triangle { <-12.2526, 38.9488, 37.7323>, <-13.5097, 36.9698, 38.331>, <-12.1767, 38.09756, 38.7375> }
					triangle { <-13.583, 37.6076, 37.2706>, <-13.5097, 36.9698, 38.331>, <-12.2526, 38.9488, 37.7323> }
					triangle { <-12.2526, 38.9488, 37.7323>, <-12.1767, 38.09756, 38.7375>, <-12.3588, 38.1288, 37.3749> }
					triangle { <-13.583, 37.6076, 37.2706>, <-14.6176, 36.3364, 37.8355>, <-13.5097, 36.9698, 38.331> }
					triangle { <-13.583, 37.6076, 37.2706>, <-14.5353, 36.787, 37.00283>, <-14.6176, 36.3364, 37.8355> }
					triangle { <-14.5353, 36.787, 37.00283>, <-15.2537, 36.08267, 37.3783>, <-14.6176, 36.3364, 37.8355> }
					triangle { <-12.1985, 38.8969, 36.6767>, <-12.2526, 38.9488, 37.7323>, <-12.3588, 38.1288, 37.3749> }
					triangle { <-12.1985, 38.8969, 36.6767>, <-12.3368, 39.2069, 36.8308>, <-12.2526, 38.9488, 37.7323> }
					triangle { <-12.3368, 39.2069, 36.8308>, <-13.583, 37.6076, 37.2706>, <-12.2526, 38.9488, 37.7323> }
					triangle { <-12.3368, 39.2069, 36.8308>, <-14.2888, 37.03347, 36.06092>, <-13.583, 37.6076, 37.2706> }
					triangle { <-14.2888, 37.03347, 36.06092>, <-14.5353, 36.787, 37.00283>, <-13.583, 37.6076, 37.2706> }
					triangle { <-14.2888, 37.03347, 36.06092>, <-14.9456, 36.7363, 35.997>, <-14.5353, 36.787, 37.00283> }
					triangle { <-14.5353, 36.787, 37.00283>, <-15.7294, 36.1576, 36.7645>, <-15.2537, 36.08267, 37.3783> }
					triangle { <-14.9456, 36.7363, 35.997>, <-15.7294, 36.1576, 36.7645>, <-14.5353, 36.787, 37.00283> }
					triangle { <-12.3588, 38.1288, 37.3749>, <-11.136, 39.06177, 37.6234>, <-10.7683, 39.8685, 36.9616> }
					triangle { <-12.3588, 38.1288, 37.3749>, <-11.6078, 38.3351, 38.3733>, <-11.136, 39.06177, 37.6234> }
					triangle { <-12.3588, 38.1288, 37.3749>, <-12.1767, 38.09756, 38.7375>, <-11.6078, 38.3351, 38.3733> }
					triangle { <-15.6331, 36.6538, 36.03304>, <-15.7294, 36.1576, 36.7645>, <-14.9456, 36.7363, 35.997> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <6.7776, 22.5871, 14.5403>, <6.8448, 22.9689, 15.3525>, 0.8 }
			cylinder { <6.8448, 22.9689, 15.3525>, <6.912, 23.3508, 16.1647>, 0.8 }
			cylinder { <6.912, 23.3508, 16.1647>, <6.9792, 23.7326, 16.9769>, 0.8 }
			cylinder { <6.9792, 23.7326, 16.9769>, <7.04645, 24.1144, 17.7891>, 0.8 }
			cylinder { <7.04645, 24.1144, 17.7891>, <7.1136, 24.4962, 18.6013>, 0.8 }
			cylinder { <7.1136, 24.4962, 18.6013>, <7.1808, 24.8781, 19.4136>, 0.8 }
			cylinder { <7.1808, 24.8781, 19.4136>, <7.248, 25.2599, 20.2258>, 0.8 }
			cylinder { <7.248, 25.2599, 20.2258>, <7.3152, 25.6417, 21.03803>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.3152, 25.6417, 21.03803>, <7.9684, 26.9774, 25.1898>, 0.8 }
				cylinder { <7.9684, 26.9774, 25.1898>, <8.9312, 27.7488, 29.4237>, 0.8 }
				cylinder { <8.9312, 27.7488, 29.4237>, <10.183, 27.9394, 33.648>, 0.8 }
				cylinder { <10.183, 27.9394, 33.648>, <11.6965, 27.5449, 37.7713>, 0.8 }
				cylinder { <11.6965, 27.5449, 37.7713>, <13.439, 26.5739, 41.7044>, 0.8 }
				cylinder { <13.439, 26.5739, 41.7044>, <15.3728, 25.04747, 45.362>, 0.8 }
				cylinder { <15.3728, 25.04747, 45.362>, <17.456, 22.9985, 48.6651>, 0.8 }
				cylinder { <17.456, 22.9985, 48.6651>, <19.6436, 20.4716, 51.5421>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <19.6436, 20.4716, 51.5421>, <21.9439, 21.1258, 51.4532>, <21.1354, 21.186, 52.1209> }
					triangle { <22.4335, 20.03134, 50.5196>, <23.8568, 20.9839, 51.01691>, <21.5454, 20.339, 51.6366> }
					triangle { <21.5454, 20.339, 51.6366>, <23.8568, 20.9839, 51.01691>, <23.1013, 21.4327, 52.04268> }
					triangle { <21.9439, 21.1258, 51.4532>, <22.4335, 20.03134, 50.5196>, <21.5454, 20.339, 51.6366> }
					triangle { <23.8568, 20.9839, 51.01691>, <24.8345, 21.6356, 51.5886>, <23.1013, 21.4327, 52.04268> }
					triangle { <24.8345, 21.6356, 51.5886>, <24.1615, 22.07885, 52.3754>, <23.1013, 21.4327, 52.04268> }
					triangle { <24.8345, 21.6356, 51.5886>, <25.2531, 22.2037, 52.2836>, <24.1615, 22.07885, 52.3754> }
					triangle { <21.9439, 21.1258, 51.4532>, <21.5454, 20.339, 51.6366>, <21.1354, 21.186, 52.1209> }
					triangle { <21.5454, 20.339, 51.6366>, <21.1242, 20.8588, 52.2991>, <21.1354, 21.186, 52.1209> }
					triangle { <21.5454, 20.339, 51.6366>, <23.1013, 21.4327, 52.04268>, <21.1242, 20.8588, 52.2991> }
					triangle { <23.1013, 21.4327, 52.04268>, <23.4862, 22.6652, 52.8325>, <21.1242, 20.8588, 52.2991> }
					triangle { <23.1013, 21.4327, 52.04268>, <24.1615, 22.07885, 52.3754>, <23.4862, 22.6652, 52.8325> }
					triangle { <24.1615, 22.07885, 52.3754>, <24.114, 22.8471, 53.1435>, <23.4862, 22.6652, 52.8325> }
					triangle { <25.2531, 22.2037, 52.2836>, <25.2768, 22.6392, 52.9909>, <24.1615, 22.07885, 52.3754> }
					triangle { <24.1615, 22.07885, 52.3754>, <25.2768, 22.6392, 52.9909>, <24.114, 22.8471, 53.1435> }
					triangle { <19.6436, 20.4716, 51.5421>, <20.7356, 20.2924, 50.783>, <21.9439, 21.1258, 51.4532> }
					triangle { <20.7356, 20.2924, 50.783>, <21.7425, 20.2134, 50.405>, <21.9439, 21.1258, 51.4532> }
					triangle { <21.7425, 20.2134, 50.405>, <22.4335, 20.03134, 50.5196>, <21.9439, 21.1258, 51.4532> }
					triangle { <24.114, 22.8471, 53.1435>, <25.2768, 22.6392, 52.9909>, <24.6831, 22.8133, 53.5381> }
					triangle { <21.1354, 21.186, 52.1209>, <21.0164, 21.9235, 52.8592>, <19.6436, 20.4716, 51.5421> }
					triangle { <20.6178, 21.1368, 53.04266>, <21.6492, 22.8825, 54.3631>, <20.1518, 21.9991, 53.9259> }
					triangle { <22.1738, 22.2304, 53.4486>, <21.6492, 22.8825, 54.3631>, <20.6178, 21.1368, 53.04266> }
					triangle { <20.6178, 21.1368, 53.04266>, <20.1518, 21.9991, 53.9259>, <21.0164, 21.9235, 52.8592> }
					triangle { <22.1738, 22.2304, 53.4486>, <22.9316, 23.3155, 54.5682>, <21.6492, 22.8825, 54.3631> }
					triangle { <22.1738, 22.2304, 53.4486>, <23.2339, 22.8765, 53.7814>, <22.9316, 23.3155, 54.5682> }
					triangle { <23.2339, 22.8765, 53.7814>, <23.7425, 23.454, 54.5304>, <22.9316, 23.3155, 54.5682> }
					triangle { <21.1354, 21.186, 52.1209>, <20.6178, 21.1368, 53.04266>, <21.0164, 21.9235, 52.8592> }
					triangle { <21.1354, 21.186, 52.1209>, <21.1242, 20.8588, 52.2991>, <20.6178, 21.1368, 53.04266> }
					triangle { <21.1242, 20.8588, 52.2991>, <22.1738, 22.2304, 53.4486>, <20.6178, 21.1368, 53.04266> }
					triangle { <21.1242, 20.8588, 52.2991>, <23.4862, 22.6652, 52.8325>, <22.1738, 22.2304, 53.4486> }
					triangle { <23.4862, 22.6652, 52.8325>, <23.2339, 22.8765, 53.7814>, <22.1738, 22.2304, 53.4486> }
					triangle { <23.4862, 22.6652, 52.8325>, <24.114, 22.8471, 53.1435>, <23.2339, 22.8765, 53.7814> }
					triangle { <23.2339, 22.8765, 53.7814>, <24.4525, 23.2938, 54.2498>, <23.7425, 23.454, 54.5304> }
					triangle { <24.114, 22.8471, 53.1435>, <24.4525, 23.2938, 54.2498>, <23.2339, 22.8765, 53.7814> }
					triangle { <21.0164, 21.9235, 52.8592>, <19.7232, 21.2119, 52.3604>, <19.6436, 20.4716, 51.5421> }
					triangle { <21.0164, 21.9235, 52.8592>, <19.8317, 21.8567, 53.3014>, <19.7232, 21.2119, 52.3604> }
					triangle { <21.0164, 21.9235, 52.8592>, <20.1518, 21.9991, 53.9259>, <19.8317, 21.8567, 53.3014> }
					triangle { <24.6831, 22.8133, 53.5381>, <24.4525, 23.2938, 54.2498>, <24.114, 22.8471, 53.1435> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <19.6436, 20.4716, 51.5421>, <20.2494, 21.865, 53.391>, <19.5952, 21.06861, 53.1889> }
					triangle { <21.6778, 22.1621, 52.9658>, <21.4285, 22.9178, 54.5619>, <20.6388, 21.1384, 53.02806> }
					triangle { <20.6388, 21.1384, 53.02806>, <21.4285, 22.9178, 54.5619>, <20.3681, 22.09286, 54.7007> }
					triangle { <20.2494, 21.865, 53.391>, <21.6778, 22.1621, 52.9658>, <20.6388, 21.1384, 53.02806> }
					triangle { <21.4285, 22.9178, 54.5619>, <21.1854, 23.268, 55.7971>, <20.3681, 22.09286, 54.7007> }
					triangle { <21.1854, 23.268, 55.7971>, <20.2463, 22.6488, 55.8531>, <20.3681, 22.09286, 54.7007> }
					triangle { <21.1854, 23.268, 55.7971>, <20.7009, 23.2462, 56.6607>, <20.2463, 22.6488, 55.8531> }
					triangle { <20.2494, 21.865, 53.391>, <20.6388, 21.1384, 53.02806>, <19.5952, 21.06861, 53.1889> }
					triangle { <20.6388, 21.1384, 53.02806>, <19.7989, 20.7578, 53.2181>, <19.5952, 21.06861, 53.1889> }
					triangle { <20.6388, 21.1384, 53.02806>, <20.3681, 22.09286, 54.7007>, <19.7989, 20.7578, 53.2181> }
					triangle { <20.3681, 22.09286, 54.7007>, <19.2956, 22.3458, 55.7384>, <19.7989, 20.7578, 53.2181> }
					triangle { <20.3681, 22.09286, 54.7007>, <20.2463, 22.6488, 55.8531>, <19.2956, 22.3458, 55.7384> }
					triangle { <20.2463, 22.6488, 55.8531>, <19.3503, 22.484, 56.4467>, <19.2956, 22.3458, 55.7384> }
					triangle { <20.7009, 23.2462, 56.6607>, <20.1298, 22.9764, 57.2007>, <20.2463, 22.6488, 55.8531> }
					triangle { <20.2463, 22.6488, 55.8531>, <20.1298, 22.9764, 57.2007>, <19.3503, 22.484, 56.4467> }
					triangle { <19.6436, 20.4716, 51.5421>, <20.5609, 21.3907, 51.8805>, <20.2494, 21.865, 53.391> }
					triangle { <20.5609, 21.3907, 51.8805>, <21.2329, 22.05042, 52.4061>, <20.2494, 21.865, 53.391> }
					triangle { <21.2329, 22.05042, 52.4061>, <21.6778, 22.1621, 52.9658>, <20.2494, 21.865, 53.391> }
					triangle { <19.3503, 22.484, 56.4467>, <20.1298, 22.9764, 57.2007>, <19.5254, 22.4201, 57.1146> }
					triangle { <19.5952, 21.06861, 53.1889>, <18.6993, 20.8784, 53.7031>, <19.6436, 20.4716, 51.5421> }
					triangle { <19.08879, 20.1518, 53.3401>, <17.7393, 20.5697, 55.3047>, <17.877, 19.7762, 53.703> }
					triangle { <18.818, 21.1062, 55.01283>, <17.7393, 20.5697, 55.3047>, <19.08879, 20.1518, 53.3401> }
					triangle { <19.08879, 20.1518, 53.3401>, <17.877, 19.7762, 53.703>, <18.6993, 20.8784, 53.7031> }
					triangle { <18.818, 21.1062, 55.01283>, <17.9394, 21.1981, 56.5044>, <17.7393, 20.5697, 55.3047> }
					triangle { <18.818, 21.1062, 55.01283>, <18.6962, 21.6622, 56.1652>, <17.9394, 21.1981, 56.5044> }
					triangle { <18.6962, 21.6622, 56.1652>, <18.23, 21.6444, 57.1325>, <17.9394, 21.1981, 56.5044> }
					triangle { <19.5952, 21.06861, 53.1889>, <19.08879, 20.1518, 53.3401>, <18.6993, 20.8784, 53.7031> }
					triangle { <19.5952, 21.06861, 53.1889>, <19.7989, 20.7578, 53.2181>, <19.08879, 20.1518, 53.3401> }
					triangle { <19.7989, 20.7578, 53.2181>, <18.818, 21.1062, 55.01283>, <19.08879, 20.1518, 53.3401> }
					triangle { <19.7989, 20.7578, 53.2181>, <19.2956, 22.3458, 55.7384>, <18.818, 21.1062, 55.01283> }
					triangle { <19.2956, 22.3458, 55.7384>, <18.6962, 21.6622, 56.1652>, <18.818, 21.1062, 55.01283> }
					triangle { <19.2956, 22.3458, 55.7384>, <19.3503, 22.484, 56.4467>, <18.6962, 21.6622, 56.1652> }
					triangle { <18.6962, 21.6622, 56.1652>, <18.7935, 22.06357, 57.4721>, <18.23, 21.6444, 57.1325> }
					triangle { <19.3503, 22.484, 56.4467>, <18.7935, 22.06357, 57.4721>, <18.6962, 21.6622, 56.1652> }
					triangle { <18.6993, 20.8784, 53.7031>, <18.8155, 20.309, 52.2576>, <19.6436, 20.4716, 51.5421> }
					triangle { <18.6993, 20.8784, 53.7031>, <18.0397, 20.01805, 53.04902>, <18.8155, 20.309, 52.2576> }
					triangle { <18.6993, 20.8784, 53.7031>, <17.877, 19.7762, 53.703>, <18.0397, 20.01805, 53.04902> }
					triangle { <19.5254, 22.4201, 57.1146>, <18.7935, 22.06357, 57.4721>, <19.3503, 22.484, 56.4467> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <19.6436, 20.4716, 51.5421>, <18.2056, 20.1345, 53.4251>, <18.6038, 19.5747, 52.6306> }
					triangle { <18.7898, 21.2102, 54.3257>, <17.5401, 20.3505, 55.2636>, <19.1023, 20.1722, 53.3477> }
					triangle { <19.1023, 20.1722, 53.3477>, <17.5401, 20.3505, 55.2636>, <17.6557, 19.3548, 54.3583> }
					triangle { <18.2056, 20.1345, 53.4251>, <18.7898, 21.2102, 54.3257>, <19.1023, 20.1722, 53.3477> }
					triangle { <17.5401, 20.3505, 55.2636>, <16.7398, 19.5374, 55.9007>, <17.6557, 19.3548, 54.3583> }
					triangle { <16.7398, 19.5374, 55.9007>, <16.7729, 18.7644, 55.0823>, <17.6557, 19.3548, 54.3583> }
					triangle { <16.7398, 19.5374, 55.9007>, <16.2457, 18.6917, 56.04795>, <16.7729, 18.7644, 55.0823> }
					triangle { <18.2056, 20.1345, 53.4251>, <19.1023, 20.1722, 53.3477>, <18.6038, 19.5747, 52.6306> }
					triangle { <19.1023, 20.1722, 53.3477>, <18.9458, 19.4723, 52.7377>, <18.6038, 19.5747, 52.6306> }
					triangle { <19.1023, 20.1722, 53.3477>, <17.6557, 19.3548, 54.3583>, <18.9458, 19.4723, 52.7377> }
					triangle { <17.6557, 19.3548, 54.3583>, <16.5979, 18.281, 54.2194>, <18.9458, 19.4723, 52.7377> }
					triangle { <17.6557, 19.3548, 54.3583>, <16.7729, 18.7644, 55.0823>, <16.5979, 18.281, 54.2194> }
					triangle { <16.7729, 18.7644, 55.0823>, <16.2837, 17.8633, 54.72>, <16.5979, 18.281, 54.2194> }
					triangle { <16.2457, 18.6917, 56.04795>, <16.01605, 17.911, 55.8796>, <16.7729, 18.7644, 55.0823> }
					triangle { <16.7729, 18.7644, 55.0823>, <16.01605, 17.911, 55.8796>, <16.2837, 17.8633, 54.72> }
					triangle { <19.6436, 20.4716, 51.5421>, <19.2287, 21.1101, 52.647>, <18.2056, 20.1345, 53.4251> }
					triangle { <19.2287, 21.1101, 52.647>, <18.8464, 21.3684, 53.6217>, <18.2056, 20.1345, 53.4251> }
					triangle { <18.8464, 21.3684, 53.6217>, <18.7898, 21.2102, 54.3257>, <18.2056, 20.1345, 53.4251> }
					triangle { <16.2837, 17.8633, 54.72>, <16.01605, 17.911, 55.8796>, <16.2051, 17.4173, 55.245> }
					triangle { <18.6038, 19.5747, 52.6306>, <18.1607, 18.7179, 52.2149>, <19.6436, 20.4716, 51.5421> }
					triangle { <19.05743, 18.7555, 52.1376>, <17.4332, 16.9788, 52.3833>, <18.6617, 17.7748, 51.3485> }
					triangle { <17.6108, 17.9381, 53.1481>, <17.4332, 16.9788, 52.3833>, <19.05743, 18.7555, 52.1376> }
					triangle { <19.05743, 18.7555, 52.1376>, <18.6617, 17.7748, 51.3485>, <18.1607, 18.7179, 52.2149> }
					triangle { <17.6108, 17.9381, 53.1481>, <16.6316, 16.5296, 53.3982>, <17.4332, 16.9788, 52.3833> }
					triangle { <17.6108, 17.9381, 53.1481>, <16.728, 17.3477, 53.8721>, <16.6316, 16.5296, 53.3982> }
					triangle { <16.728, 17.3477, 53.8721>, <16.2062, 16.4365, 54.09708>, <16.6316, 16.5296, 53.3982> }
					triangle { <18.6038, 19.5747, 52.6306>, <19.05743, 18.7555, 52.1376>, <18.1607, 18.7179, 52.2149> }
					triangle { <18.6038, 19.5747, 52.6306>, <18.9458, 19.4723, 52.7377>, <19.05743, 18.7555, 52.1376> }
					triangle { <18.9458, 19.4723, 52.7377>, <17.6108, 17.9381, 53.1481>, <19.05743, 18.7555, 52.1376> }
					triangle { <18.9458, 19.4723, 52.7377>, <16.5979, 18.281, 54.2194>, <17.6108, 17.9381, 53.1481> }
					triangle { <16.5979, 18.281, 54.2194>, <16.728, 17.3477, 53.8721>, <17.6108, 17.9381, 53.1481> }
					triangle { <16.5979, 18.281, 54.2194>, <16.2837, 17.8633, 54.72>, <16.728, 17.3477, 53.8721> }
					triangle { <16.728, 17.3477, 53.8721>, <16.02738, 16.6544, 54.8244>, <16.2062, 16.4365, 54.09708> }
					triangle { <16.2837, 17.8633, 54.72>, <16.02738, 16.6544, 54.8244>, <16.728, 17.3477, 53.8721> }
					triangle { <18.1607, 18.7179, 52.2149>, <19.146, 19.512, 51.3061>, <19.6436, 20.4716, 51.5421> }
					triangle { <18.1607, 18.7179, 52.2149>, <18.7539, 18.45, 51.1287>, <19.146, 19.512, 51.3061> }
					triangle { <18.1607, 18.7179, 52.2149>, <18.6617, 17.7748, 51.3485>, <18.7539, 18.45, 51.1287> }
					triangle { <16.2051, 17.4173, 55.245>, <16.02738, 16.6544, 54.8244>, <16.2837, 17.8633, 54.72> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <19.6436, 20.4716, 51.5421>, <18.6179, 18.3096, 51.5087>, <19.5219, 18.7548, 51.2124> }
					triangle { <17.7337, 18.4821, 52.7325>, <17.5289, 16.806, 52.1588>, <19.04488, 18.7667, 52.1569> }
					triangle { <19.04488, 18.7667, 52.1569>, <17.5289, 16.806, 52.1588>, <18.6872, 16.977, 51.4854> }
					triangle { <18.6179, 18.3096, 51.5087>, <17.7337, 18.4821, 52.7325>, <19.04488, 18.7667, 52.1569> }
					triangle { <17.5289, 16.806, 52.1588>, <17.5998, 15.5645, 51.7572>, <18.6872, 16.977, 51.4854> }
					triangle { <17.5998, 15.5645, 51.7572>, <18.509, 15.7574, 51.121>, <18.6872, 16.977, 51.4854> }
					triangle { <17.5998, 15.5645, 51.7572>, <18.00285, 14.7919, 51.2864>, <18.509, 15.7574, 51.121> }
					triangle { <18.6179, 18.3096, 51.5087>, <19.04488, 18.7667, 52.1569>, <19.5219, 18.7548, 51.2124> }
					triangle { <19.04488, 18.7667, 52.1569>, <19.7358, 18.7669, 51.5174>, <19.5219, 18.7548, 51.2124> }
					triangle { <19.04488, 18.7667, 52.1569>, <18.6872, 16.977, 51.4854>, <19.7358, 18.7669, 51.5174> }
					triangle { <18.6872, 16.977, 51.4854>, <19.09613, 16.05039, 50.3606>, <19.7358, 18.7669, 51.5174> }
					triangle { <18.6872, 16.977, 51.4854>, <18.509, 15.7574, 51.121>, <19.09613, 16.05039, 50.3606> }
					triangle { <18.509, 15.7574, 51.121>, <19.1235, 15.3276, 50.3335>, <19.09613, 16.05039, 50.3606> }
					triangle { <18.00285, 14.7919, 51.2864>, <18.5821, 14.396, 50.8411>, <18.509, 15.7574, 51.121> }
					triangle { <18.509, 15.7574, 51.121>, <18.5821, 14.396, 50.8411>, <19.1235, 15.3276, 50.3335> }
					triangle { <19.6436, 20.4716, 51.5421>, <18.5675, 19.8358, 52.03046>, <18.6179, 18.3096, 51.5087> }
					triangle { <18.5675, 19.8358, 52.03046>, <17.8588, 19.1036, 52.3833>, <18.6179, 18.3096, 51.5087> }
					triangle { <17.8588, 19.1036, 52.3833>, <17.7337, 18.4821, 52.7325>, <18.6179, 18.3096, 51.5087> }
					triangle { <19.1235, 15.3276, 50.3335>, <18.5821, 14.396, 50.8411>, <19.2798, 14.6719, 50.4957> }
					triangle { <19.5219, 18.7548, 51.2124>, <20.1398, 18.4074, 50.4374>, <19.6436, 20.4716, 51.5421> }
					triangle { <20.5668, 18.8645, 51.08566>, <21.1511, 17.03881, 49.6091>, <21.4287, 18.7421, 50.09418> }
					triangle { <20.2091, 17.07484, 50.4141>, <21.1511, 17.03881, 49.6091>, <20.5668, 18.8645, 51.08566> }
					triangle { <20.5668, 18.8645, 51.08566>, <21.4287, 18.7421, 50.09418>, <20.1398, 18.4074, 50.4374> }
					triangle { <20.2091, 17.07484, 50.4141>, <20.8034, 15.7181, 49.5133>, <21.1511, 17.03881, 49.6091> }
					triangle { <20.2091, 17.07484, 50.4141>, <20.031, 15.8552, 50.04972>, <20.8034, 15.7181, 49.5133> }
					triangle { <20.031, 15.8552, 50.04972>, <20.4489, 14.9789, 49.5907>, <20.8034, 15.7181, 49.5133> }
					triangle { <19.5219, 18.7548, 51.2124>, <20.5668, 18.8645, 51.08566>, <20.1398, 18.4074, 50.4374> }
					triangle { <19.5219, 18.7548, 51.2124>, <19.7358, 18.7669, 51.5174>, <20.5668, 18.8645, 51.08566> }
					triangle { <19.7358, 18.7669, 51.5174>, <20.2091, 17.07484, 50.4141>, <20.5668, 18.8645, 51.08566> }
					triangle { <19.7358, 18.7669, 51.5174>, <19.09613, 16.05039, 50.3606>, <20.2091, 17.07484, 50.4141> }
					triangle { <19.09613, 16.05039, 50.3606>, <20.031, 15.8552, 50.04972>, <20.2091, 17.07484, 50.4141> }
					triangle { <19.09613, 16.05039, 50.3606>, <19.1235, 15.3276, 50.3335>, <20.031, 15.8552, 50.04972> }
					triangle { <20.031, 15.8552, 50.04972>, <19.9509, 14.4912, 49.9411>, <20.4489, 14.9789, 49.5907> }
					triangle { <19.1235, 15.3276, 50.3335>, <19.9509, 14.4912, 49.9411>, <20.031, 15.8552, 50.04972> }
					triangle { <20.1398, 18.4074, 50.4374>, <20.2611, 19.9148, 50.8121>, <19.6436, 20.4716, 51.5421> }
					triangle { <20.1398, 18.4074, 50.4374>, <20.994, 19.3051, 50.1764>, <20.2611, 19.9148, 50.8121> }
					triangle { <20.1398, 18.4074, 50.4374>, <21.4287, 18.7421, 50.09418>, <20.994, 19.3051, 50.1764> }
					triangle { <19.2798, 14.6719, 50.4957>, <19.9509, 14.4912, 49.9411>, <19.1235, 15.3276, 50.3335> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <19.6436, 20.4716, 51.5421>, <20.9632, 18.9315, 50.2716>, <21.1101, 19.7657, 50.8926> }
					triangle { <20.0197, 17.7425, 50.3447>, <21.4917, 17.2033, 49.4946>, <20.5775, 18.8714, 51.0835> }
					triangle { <20.5775, 18.8714, 51.0835>, <21.4917, 17.2033, 49.4946>, <22.1036, 18.2806, 50.03271> }
					triangle { <20.9632, 18.9315, 50.2716>, <20.0197, 17.7425, 50.3447>, <20.5775, 18.8714, 51.0835> }
					triangle { <21.4917, 17.2033, 49.4946>, <22.6782, 16.8808, 49.05199>, <22.1036, 18.2806, 50.03271> }
					triangle { <22.6782, 16.8808, 49.05199>, <23.1443, 17.8367, 49.4228>, <22.1036, 18.2806, 50.03271> }
					triangle { <22.6782, 16.8808, 49.05199>, <23.6538, 16.9952, 48.9248>, <23.1443, 17.8367, 49.4228> }
					triangle { <20.9632, 18.9315, 50.2716>, <20.5775, 18.8714, 51.0835>, <21.1101, 19.7657, 50.8926> }
					triangle { <20.5775, 18.8714, 51.0835>, <21.1024, 19.6367, 51.2423>, <21.1101, 19.7657, 50.8926> }
					triangle { <20.5775, 18.8714, 51.0835>, <22.1036, 18.2806, 50.03271>, <21.1024, 19.6367, 51.2423> }
					triangle { <22.1036, 18.2806, 50.03271>, <23.4176, 18.8008, 49.4905>, <21.1024, 19.6367, 51.2423> }
					triangle { <22.1036, 18.2806, 50.03271>, <23.1443, 17.8367, 49.4228>, <23.4176, 18.8008, 49.4905> }
					triangle { <23.1443, 17.8367, 49.4228>, <24.03596, 18.4542, 49.3444>, <23.4176, 18.8008, 49.4905> }
					triangle { <23.6538, 16.9952, 48.9248>, <24.3919, 17.3623, 49.02887>, <23.1443, 17.8367, 49.4228> }
					triangle { <23.1443, 17.8367, 49.4228>, <24.3919, 17.3623, 49.02887>, <24.03596, 18.4542, 49.3444> }
					triangle { <19.6436, 20.4716, 51.5421>, <19.5129, 19.3228, 50.861>, <20.9632, 18.9315, 50.2716> }
					triangle { <19.5129, 19.3228, 50.861>, <19.6757, 18.379, 50.3653>, <20.9632, 18.9315, 50.2716> }
					triangle { <19.6757, 18.379, 50.3653>, <20.0197, 17.7425, 50.3447>, <20.9632, 18.9315, 50.2716> }
					triangle { <24.03596, 18.4542, 49.3444>, <24.3919, 17.3623, 49.02887>, <24.5985, 18.05714, 49.4248> }
					triangle { <21.1101, 19.7657, 50.8926>, <21.9314, 20.4185, 50.8416>, <19.6436, 20.4716, 51.5421> }
					triangle { <21.5457, 20.3584, 51.6534>, <23.796, 20.7425, 50.8511>, <22.3635, 21.3923, 51.7111> }
					triangle { <23.0718, 19.7676, 50.6026>, <23.796, 20.7425, 50.8511>, <21.5457, 20.3584, 51.6534> }
					triangle { <21.5457, 20.3584, 51.6534>, <22.3635, 21.3923, 51.7111>, <21.9314, 20.4185, 50.8416> }
					triangle { <23.0718, 19.7676, 50.6026>, <24.7558, 19.9753, 50.2473>, <23.796, 20.7425, 50.8511> }
					triangle { <23.0718, 19.7676, 50.6026>, <24.1125, 19.3238, 49.9928>, <24.7558, 19.9753, 50.2473> }
					triangle { <24.1125, 19.3238, 49.9928>, <25.1769, 19.3814, 49.8626>, <24.7558, 19.9753, 50.2473> }
					triangle { <21.1101, 19.7657, 50.8926>, <21.5457, 20.3584, 51.6534>, <21.9314, 20.4185, 50.8416> }
					triangle { <21.1101, 19.7657, 50.8926>, <21.1024, 19.6367, 51.2423>, <21.5457, 20.3584, 51.6534> }
					triangle { <21.1024, 19.6367, 51.2423>, <23.0718, 19.7676, 50.6026>, <21.5457, 20.3584, 51.6534> }
					triangle { <21.1024, 19.6367, 51.2423>, <23.4176, 18.8008, 49.4905>, <23.0718, 19.7676, 50.6026> }
					triangle { <23.4176, 18.8008, 49.4905>, <24.1125, 19.3238, 49.9928>, <23.0718, 19.7676, 50.6026> }
					triangle { <23.4176, 18.8008, 49.4905>, <24.03596, 18.4542, 49.3444>, <24.1125, 19.3238, 49.9928> }
					triangle { <24.1125, 19.3238, 49.9928>, <25.2365, 18.6566, 49.5806>, <25.1769, 19.3814, 49.8626> }
					triangle { <24.03596, 18.4542, 49.3444>, <25.2365, 18.6566, 49.5806>, <24.1125, 19.3238, 49.9928> }
					triangle { <21.9314, 20.4185, 50.8416>, <20.6232, 20.9813, 51.4735>, <19.6436, 20.4716, 51.5421> }
					triangle { <21.9314, 20.4185, 50.8416>, <21.6702, 21.4423, 51.5395>, <20.6232, 20.9813, 51.4735> }
					triangle { <21.9314, 20.4185, 50.8416>, <22.3635, 21.3923, 51.7111>, <21.6702, 21.4423, 51.5395> }
					triangle { <24.5985, 18.05714, 49.4248>, <25.2365, 18.6566, 49.5806>, <24.03596, 18.4542, 49.3444> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <5.7024, 16.4779, 1.5448>, <6.03998, 17.309, 1.6177>, 0.8 }
			cylinder { <6.03998, 17.309, 1.6177>, <6.3775, 18.1401, 1.6907>, 0.8 }
			cylinder { <6.3775, 18.1401, 1.6907>, <6.7151, 18.9712, 1.7636>, 0.8 }
			cylinder { <6.7151, 18.9712, 1.7636>, <7.05268, 19.8023, 1.8365>, 0.8 }
			cylinder { <7.05268, 19.8023, 1.8365>, <7.3902, 20.6334, 1.9094>, 0.8 }
			cylinder { <7.3902, 20.6334, 1.9094>, <7.7278, 21.4645, 1.9823>, 0.8 }
			cylinder { <7.7278, 21.4645, 1.9823>, <8.06538, 22.2956, 2.0553>, 0.8 }
			cylinder { <8.06538, 22.2956, 2.0553>, <8.4029, 23.1267, 2.1282>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // inflor. internode
			cylinder { <8.4029, 23.1267, 2.1282>, <9.1257, 23.356, 1.6434>, 0.8 }
			cylinder { <9.1257, 23.356, 1.6434>, <9.8485, 23.5854, 1.1587>, 0.8 }
			cylinder { <9.8485, 23.5854, 1.1587>, <10.5713, 23.8147, 0.674>, 0.8 }
			cylinder { <10.5713, 23.8147, 0.674>, <11.2941, 24.04409, 0.1892>, 0.8 }
			cylinder { <11.2941, 24.04409, 0.1892>, <12.01693, 24.2734, -0.2954>, 0.8 }
			cylinder { <12.01693, 24.2734, -0.2954>, <12.7397, 24.5027, -0.7802>, 0.8 }
			cylinder { <12.7397, 24.5027, -0.7802>, <13.4625, 24.7321, -1.2649>, 0.8 }
			cylinder { <13.4625, 24.7321, -1.2649>, <14.1853, 24.9614, -1.7496>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <14.1853, 24.9614, -1.7496>, <17.4185, 26.646, -4.2309>, 0.8 }
				cylinder { <17.4185, 26.646, -4.2309>, <20.2732, 28.855, -6.7644>, 0.8 }
				cylinder { <20.2732, 28.855, -6.7644>, <22.6876, 31.5407, -9.2954>, 0.8 }
				cylinder { <22.6876, 31.5407, -9.2954>, <24.6095, 34.6447, -11.7691>, 0.8 }
				cylinder { <24.6095, 34.6447, -11.7691>, <25.9973, 38.1001, -14.1319>, 0.8 }
				cylinder { <25.9973, 38.1001, -14.1319>, <26.8208, 41.8319, -16.3327>, 0.8 }
				cylinder { <26.8208, 41.8319, -16.3327>, <27.06238, 45.7594, -18.3239>, 0.8 }
				cylinder { <27.06238, 45.7594, -18.3239>, <26.7166, 49.7975, -20.0623>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <26.7166, 49.7975, -20.0623>, <27.8198, 51.461, -18.3782>, <28.02938, 51.03062, -19.4196> }
					triangle { <26.4327, 51.9756, -17.6291>, <27.9103, 53.00018, -16.8846>, <27.08533, 51.5646, -19.02321> }
					triangle { <27.08533, 51.5646, -19.02321>, <27.9103, 53.00018, -16.8846>, <28.679, 52.5975, -18.07604> }
					triangle { <27.8198, 51.461, -18.3782>, <26.4327, 51.9756, -17.6291>, <27.08533, 51.5646, -19.02321> }
					triangle { <27.9103, 53.00018, -16.8846>, <29.04083, 53.8102, -16.5692>, <28.679, 52.5975, -18.07604> }
					triangle { <29.04083, 53.8102, -16.5692>, <29.701, 53.3731, -17.5093>, <28.679, 52.5975, -18.07604> }
					triangle { <29.04083, 53.8102, -16.5692>, <30.02571, 54.2268, -16.726>, <29.701, 53.3731, -17.5093> }
					triangle { <27.8198, 51.461, -18.3782>, <27.08533, 51.5646, -19.02321>, <28.02938, 51.03062, -19.4196> }
					triangle { <27.08533, 51.5646, -19.02321>, <27.8122, 51.2552, -19.6801>, <28.02938, 51.03062, -19.4196> }
					triangle { <27.08533, 51.5646, -19.02321>, <28.679, 52.5975, -18.07604>, <27.8122, 51.2552, -19.6801> }
					triangle { <28.679, 52.5975, -18.07604>, <30.3257, 52.7169, -18.1261>, <27.8122, 51.2552, -19.6801> }
					triangle { <28.679, 52.5975, -18.07604>, <29.701, 53.3731, -17.5093>, <30.3257, 52.7169, -18.1261> }
					triangle { <29.701, 53.3731, -17.5093>, <30.8016, 53.3221, -17.95>, <30.3257, 52.7169, -18.1261> }
					triangle { <30.02571, 54.2268, -16.726>, <30.8007, 54.3661, -17.1757>, <29.701, 53.3731, -17.5093> }
					triangle { <29.701, 53.3731, -17.5093>, <30.8007, 54.3661, -17.1757>, <30.8016, 53.3221, -17.95> }
					triangle { <26.7166, 49.7975, -20.0623>, <26.4152, 50.4896, -18.8074>, <27.8198, 51.461, -18.3782> }
					triangle { <26.4152, 50.4896, -18.8074>, <26.3829, 51.2342, -17.8968>, <27.8198, 51.461, -18.3782> }
					triangle { <26.3829, 51.2342, -17.8968>, <26.4327, 51.9756, -17.6291>, <27.8198, 51.461, -18.3782> }
					triangle { <30.8016, 53.3221, -17.95>, <30.8007, 54.3661, -17.1757>, <31.1051, 54.01525, -17.9481> }
					triangle { <28.02938, 51.03062, -19.4196>, <29.06928, 50.9179, -19.8882>, <26.7166, 49.7975, -20.0623> }
					triangle { <28.3347, 51.02158, -20.5333>, <30.884, 51.7075, -20.4786>, <29.4846, 50.6132, -21.2977> }
					triangle { <29.9284, 52.05441, -19.5861>, <30.884, 51.7075, -20.4786>, <28.3347, 51.02158, -20.5333> }
					triangle { <28.3347, 51.02158, -20.5333>, <29.4846, 50.6132, -21.2977>, <29.06928, 50.9179, -19.8882> }
					triangle { <29.9284, 52.05441, -19.5861>, <31.6934, 52.7191, -19.7344>, <30.884, 51.7075, -20.4786> }
					triangle { <29.9284, 52.05441, -19.5861>, <30.9505, 52.83, -19.01946>, <31.6934, 52.7191, -19.7344> }
					triangle { <30.9505, 52.83, -19.01946>, <31.9929, 53.3456, -19.1642>, <31.6934, 52.7191, -19.7344> }
					triangle { <28.02938, 51.03062, -19.4196>, <28.3347, 51.02158, -20.5333>, <29.06928, 50.9179, -19.8882> }
					triangle { <28.02938, 51.03062, -19.4196>, <27.8122, 51.2552, -19.6801>, <28.3347, 51.02158, -20.5333> }
					triangle { <27.8122, 51.2552, -19.6801>, <29.9284, 52.05441, -19.5861>, <28.3347, 51.02158, -20.5333> }
					triangle { <27.8122, 51.2552, -19.6801>, <30.3257, 52.7169, -18.1261>, <29.9284, 52.05441, -19.5861> }
					triangle { <30.3257, 52.7169, -18.1261>, <30.9505, 52.83, -19.01946>, <29.9284, 52.05441, -19.5861> }
					triangle { <30.3257, 52.7169, -18.1261>, <30.8016, 53.3221, -17.95>, <30.9505, 52.83, -19.01946> }
					triangle { <30.9505, 52.83, -19.01946>, <31.8651, 53.9132, -18.5427>, <31.9929, 53.3456, -19.1642> }
					triangle { <30.8016, 53.3221, -17.95>, <31.8651, 53.9132, -18.5427>, <30.9505, 52.83, -19.01946> }
					triangle { <29.06928, 50.9179, -19.8882>, <27.8465, 49.8935, -20.4767>, <26.7166, 49.7975, -20.0623> }
					triangle { <29.06928, 50.9179, -19.8882>, <28.9567, 50.1154, -21.0076>, <27.8465, 49.8935, -20.4767> }
					triangle { <29.06928, 50.9179, -19.8882>, <29.4846, 50.6132, -21.2977>, <28.9567, 50.1154, -21.0076> }
					triangle { <31.1051, 54.01525, -17.9481>, <31.8651, 53.9132, -18.5427>, <30.8016, 53.3221, -17.95> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <26.7166, 49.7975, -20.0623>, <29.108, 50.5175, -20.8261>, <28.1071, 50.2265, -21.3029> }
					triangle { <29.5014, 51.4328, -19.5004>, <30.9673, 51.5888, -20.7709>, <28.3337, 51.03257, -20.5075> }
					triangle { <28.3337, 51.03257, -20.5075>, <30.9673, 51.5888, -20.7709>, <30.01969, 51.1117, -21.794> }
					triangle { <29.108, 50.5175, -20.8261>, <29.5014, 51.4328, -19.5004>, <28.3337, 51.03257, -20.5075> }
					triangle { <30.9673, 51.5888, -20.7709>, <31.8708, 51.7756, -21.8583>, <30.01969, 51.1117, -21.794> }
					triangle { <31.8708, 51.7756, -21.8583>, <31.1014, 51.2703, -22.6727>, <30.01969, 51.1117, -21.794> }
					triangle { <31.8708, 51.7756, -21.8583>, <32.1797, 51.756, -22.8938>, <31.1014, 51.2703, -22.6727> }
					triangle { <29.108, 50.5175, -20.8261>, <28.3337, 51.03257, -20.5075>, <28.1071, 50.2265, -21.3029> }
					triangle { <28.3337, 51.03257, -20.5075>, <27.8791, 50.5634, -21.3006>, <28.1071, 50.2265, -21.3029> }
					triangle { <28.3337, 51.03257, -20.5075>, <30.01969, 51.1117, -21.794>, <27.8791, 50.5634, -21.3006> }
					triangle { <30.01969, 51.1117, -21.794>, <30.5374, 50.5291, -23.2504>, <27.8791, 50.5634, -21.3006> }
					triangle { <30.01969, 51.1117, -21.794>, <31.1014, 51.2703, -22.6727>, <30.5374, 50.5291, -23.2504> }
					triangle { <31.1014, 51.2703, -22.6727>, <31.04225, 50.8351, -23.775>, <30.5374, 50.5291, -23.2504> }
					triangle { <32.1797, 51.756, -22.8938>, <32.07087, 51.6295, -23.7851>, <31.1014, 51.2703, -22.6727> }
					triangle { <31.1014, 51.2703, -22.6727>, <32.07087, 51.6295, -23.7851>, <31.04225, 50.8351, -23.775> }
					triangle { <26.7166, 49.7975, -20.0623>, <27.9634, 50.3231, -19.5021>, <29.108, 50.5175, -20.8261> }
					triangle { <27.9634, 50.3231, -19.5021>, <29.00629, 50.8411, -19.3318>, <29.108, 50.5175, -20.8261> }
					triangle { <29.00629, 50.8411, -19.3318>, <29.5014, 51.4328, -19.5004>, <29.108, 50.5175, -20.8261> }
					triangle { <31.04225, 50.8351, -23.775>, <32.07087, 51.6295, -23.7851>, <31.3656, 51.3225, -24.255> }
					triangle { <28.1071, 50.2265, -21.3029>, <27.9837, 49.767, -22.3457>, <26.7166, 49.7975, -20.0623> }
					triangle { <27.2094, 50.2821, -22.02719>, <28.2914, 49.8028, -24.3876>, <26.7613, 49.5645, -23.1922> }
					triangle { <28.8953, 50.3613, -23.3136>, <28.2914, 49.8028, -24.3876>, <27.2094, 50.2821, -22.02719> }
					triangle { <27.2094, 50.2821, -22.02719>, <26.7613, 49.5645, -23.1922>, <27.9837, 49.767, -22.3457> }
					triangle { <28.8953, 50.3613, -23.3136>, <29.5403, 50.2304, -25.08731>, <28.2914, 49.8028, -24.3876> }
					triangle { <28.8953, 50.3613, -23.3136>, <29.977, 50.5198, -24.1923>, <29.5403, 50.2304, -25.08731> }
					triangle { <29.977, 50.5198, -24.1923>, <30.3471, 50.5618, -25.3034>, <29.5403, 50.2304, -25.08731> }
					triangle { <28.1071, 50.2265, -21.3029>, <27.2094, 50.2821, -22.02719>, <27.9837, 49.767, -22.3457> }
					triangle { <28.1071, 50.2265, -21.3029>, <27.8791, 50.5634, -21.3006>, <27.2094, 50.2821, -22.02719> }
					triangle { <27.8791, 50.5634, -21.3006>, <28.8953, 50.3613, -23.3136>, <27.2094, 50.2821, -22.02719> }
					triangle { <27.8791, 50.5634, -21.3006>, <30.5374, 50.5291, -23.2504>, <28.8953, 50.3613, -23.3136> }
					triangle { <30.5374, 50.5291, -23.2504>, <29.977, 50.5198, -24.1923>, <28.8953, 50.3613, -23.3136> }
					triangle { <30.5374, 50.5291, -23.2504>, <31.04225, 50.8351, -23.775>, <29.977, 50.5198, -24.1923> }
					triangle { <29.977, 50.5198, -24.1923>, <31.04454, 51.01294, -25.1167>, <30.3471, 50.5618, -25.3034> }
					triangle { <31.04225, 50.8351, -23.775>, <31.04454, 51.01294, -25.1167>, <29.977, 50.5198, -24.1923> }
					triangle { <27.9837, 49.767, -22.3457>, <26.7379, 49.4761, -21.2258>, <26.7166, 49.7975, -20.0623> }
					triangle { <27.9837, 49.767, -22.3457>, <26.6901, 49.2952, -22.4622>, <26.7379, 49.4761, -21.2258> }
					triangle { <27.9837, 49.767, -22.3457>, <26.7613, 49.5645, -23.1922>, <26.6901, 49.2952, -22.4622> }
					triangle { <31.3656, 51.3225, -24.255>, <31.04454, 51.01294, -25.1167>, <31.04225, 50.8351, -23.775> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <26.7166, 49.7975, -20.0623>, <27.0306, 49.5571, -22.6437>, <26.1931, 49.805, -21.9014> }
					triangle { <28.6338, 49.9746, -22.7152>, <28.01901, 49.7126, -24.5429>, <27.2355, 50.2879, -22.019> }
					triangle { <27.2355, 50.2879, -22.019>, <28.01901, 49.7126, -24.5429>, <26.6514, 49.8671, -24.01538> }
					triangle { <27.0306, 49.5571, -22.6437>, <28.6338, 49.9746, -22.7152>, <27.2355, 50.2879, -22.019> }
					triangle { <28.01901, 49.7126, -24.5429>, <27.3984, 49.6844, -25.8265>, <26.6514, 49.8671, -24.01538> }
					triangle { <27.3984, 49.6844, -25.8265>, <26.2642, 49.7022, -25.3533>, <26.6514, 49.8671, -24.01538> }
					triangle { <27.3984, 49.6844, -25.8265>, <26.568, 49.7156, -26.5175>, <26.2642, 49.7022, -25.3533> }
					triangle { <27.0306, 49.5571, -22.6437>, <27.2355, 50.2879, -22.019>, <26.1931, 49.805, -21.9014> }
					triangle { <27.2355, 50.2879, -22.019>, <26.2322, 50.2007, -21.8156>, <26.1931, 49.805, -21.9014> }
					triangle { <27.2355, 50.2879, -22.019>, <26.6514, 49.8671, -24.01538>, <26.2322, 50.2007, -21.8156> }
					triangle { <26.6514, 49.8671, -24.01538>, <25.3295, 49.3821, -24.8789>, <26.2322, 50.2007, -21.8156> }
					triangle { <26.6514, 49.8671, -24.01538>, <26.2642, 49.7022, -25.3533>, <25.3295, 49.3821, -24.8789> }
					triangle { <26.2642, 49.7022, -25.3533>, <25.1221, 49.5313, -25.6263>, <25.3295, 49.3821, -24.8789> }
					triangle { <26.568, 49.7156, -26.5175>, <25.6983, 49.8038, -26.759>, <26.2642, 49.7022, -25.3533> }
					triangle { <26.2642, 49.7022, -25.3533>, <25.6983, 49.8038, -26.759>, <25.1221, 49.5313, -25.6263> }
					triangle { <26.7166, 49.7975, -20.0623>, <27.7827, 49.6397, -21.05374>, <27.0306, 49.5571, -22.6437> }
					triangle { <27.7827, 49.6397, -21.05374>, <28.4343, 49.629, -22.03364>, <27.0306, 49.5571, -22.6437> }
					triangle { <28.4343, 49.629, -22.03364>, <28.6338, 49.9746, -22.7152>, <27.0306, 49.5571, -22.6437> }
					triangle { <25.1221, 49.5313, -25.6263>, <25.6983, 49.8038, -26.759>, <24.9559, 49.9109, -26.2594> }
					triangle { <26.1931, 49.805, -21.9014>, <25.07578, 49.6294, -22.08702>, <26.7166, 49.7975, -20.0623> }
					triangle { <25.2807, 50.3602, -21.4622>, <23.3665, 49.8847, -23.2179>, <23.8673, 50.1138, -21.3407> }
					triangle { <24.6966, 49.9394, -23.4586>, <23.3665, 49.8847, -23.2179>, <25.2807, 50.3602, -21.4622> }
					triangle { <25.2807, 50.3602, -21.4622>, <23.8673, 50.1138, -21.3407>, <25.07578, 49.6294, -22.08702> }
					triangle { <24.6966, 49.9394, -23.4586>, <23.2794, 49.8572, -24.7091>, <23.3665, 49.8847, -23.2179> }
					triangle { <24.6966, 49.9394, -23.4586>, <24.3094, 49.7745, -24.7966>, <23.2794, 49.8572, -24.7091> }
					triangle { <24.3094, 49.7745, -24.7966>, <23.451, 49.8476, -25.591>, <23.2794, 49.8572, -24.7091> }
					triangle { <26.1931, 49.805, -21.9014>, <25.2807, 50.3602, -21.4622>, <25.07578, 49.6294, -22.08702> }
					triangle { <26.1931, 49.805, -21.9014>, <26.2322, 50.2007, -21.8156>, <25.2807, 50.3602, -21.4622> }
					triangle { <26.2322, 50.2007, -21.8156>, <24.6966, 49.9394, -23.4586>, <25.2807, 50.3602, -21.4622> }
					triangle { <26.2322, 50.2007, -21.8156>, <25.3295, 49.3821, -24.8789>, <24.6966, 49.9394, -23.4586> }
					triangle { <25.3295, 49.3821, -24.8789>, <24.3094, 49.7745, -24.7966>, <24.6966, 49.9394, -23.4586> }
					triangle { <25.3295, 49.3821, -24.8789>, <25.1221, 49.5313, -25.6263>, <24.3094, 49.7745, -24.7966> }
					triangle { <24.3094, 49.7745, -24.7966>, <23.9857, 49.9209, -26.2494>, <23.451, 49.8476, -25.591> }
					triangle { <25.1221, 49.5313, -25.6263>, <23.9857, 49.9209, -26.2494>, <24.3094, 49.7745, -24.7966> }
					triangle { <25.07578, 49.6294, -22.08702>, <25.5825, 49.7044, -20.4658>, <26.7166, 49.7975, -20.0623> }
					triangle { <25.07578, 49.6294, -22.08702>, <24.4074, 49.778, -20.8867>, <25.5825, 49.7044, -20.4658> }
					triangle { <25.07578, 49.6294, -22.08702>, <23.8673, 50.1138, -21.3407>, <24.4074, 49.778, -20.8867> }
					triangle { <24.9559, 49.9109, -26.2594>, <23.9857, 49.9209, -26.2494>, <25.1221, 49.5313, -25.6263> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <26.7166, 49.7975, -20.0623>, <24.4391, 49.8982, -21.3362>, <24.9145, 50.3446, -20.3936> }
					triangle { <25.02085, 49.6026, -22.8607>, <23.1123, 49.9469, -23.023>, <25.2982, 50.3528, -21.4828> }
					triangle { <25.2982, 50.3528, -21.4828>, <23.1123, 49.9469, -23.023>, <23.1976, 50.572, -21.6909> }
					triangle { <24.4391, 49.8982, -21.3362>, <25.02085, 49.6026, -22.8607>, <25.2982, 50.3528, -21.4828> }
					triangle { <23.1123, 49.9469, -23.023>, <21.7626, 50.4071, -23.02706>, <23.1976, 50.572, -21.6909> }
					triangle { <21.7626, 50.4071, -23.02706>, <21.8292, 50.8213, -21.8717>, <23.1976, 50.572, -21.6909> }
					triangle { <21.7626, 50.4071, -23.02706>, <20.8932, 50.9063, -22.6231>, <21.8292, 50.8213, -21.8717> }
					triangle { <24.4391, 49.8982, -21.3362>, <25.2982, 50.3528, -21.4828>, <24.9145, 50.3446, -20.3936> }
					triangle { <25.2982, 50.3528, -21.4828>, <25.132, 50.665, -20.5182>, <24.9145, 50.3446, -20.3936> }
					triangle { <25.2982, 50.3528, -21.4828>, <23.1976, 50.572, -21.6909>, <25.132, 50.665, -20.5182> }
					triangle { <23.1976, 50.572, -21.6909>, <21.8506, 50.8504, -20.7763>, <25.132, 50.665, -20.5182> }
					triangle { <23.1976, 50.572, -21.6909>, <21.8292, 50.8213, -21.8717>, <21.8506, 50.8504, -20.7763> }
					triangle { <21.8292, 50.8213, -21.8717>, <21.1675, 51.2004, -20.9626>, <21.8506, 50.8504, -20.7763> }
					triangle { <20.8932, 50.9063, -22.6231>, <20.4303, 51.3949, -22.01536>, <21.8292, 50.8213, -21.8717> }
					triangle { <21.8292, 50.8213, -21.8717>, <20.4303, 51.3949, -22.01536>, <21.1675, 51.2004, -20.9626> }
					triangle { <26.7166, 49.7975, -20.0623>, <26.1212, 49.3774, -21.3324>, <24.4391, 49.8982, -21.3362> }
					triangle { <26.1212, 49.3774, -21.3324>, <25.4521, 49.2618, -22.2936>, <24.4391, 49.8982, -21.3362> }
					triangle { <25.4521, 49.2618, -22.2936>, <25.02085, 49.6026, -22.8607>, <24.4391, 49.8982, -21.3362> }
					triangle { <21.1675, 51.2004, -20.9626>, <20.4303, 51.3949, -22.01536>, <20.6741, 51.718, -21.21> }
					triangle { <24.9145, 50.3446, -20.3936>, <24.337, 50.694, -19.4673>, <26.7166, 49.7975, -20.0623> }
					triangle { <25.1961, 51.1486, -19.6139>, <22.8694, 51.8409, -18.575>, <24.775, 51.5071, -18.2845> }
					triangle { <23.09558, 51.3678, -19.822>, <22.8694, 51.8409, -18.575>, <25.1961, 51.1486, -19.6139> }
					triangle { <25.1961, 51.1486, -19.6139>, <24.775, 51.5071, -18.2845>, <24.337, 50.694, -19.4673> }
					triangle { <23.09558, 51.3678, -19.822>, <21.5045, 52.1118, -19.119>, <22.8694, 51.8409, -18.575> }
					triangle { <23.09558, 51.3678, -19.822>, <21.7271, 51.6171, -20.00289>, <21.5045, 52.1118, -19.119> }
					triangle { <21.7271, 51.6171, -20.00289>, <20.7704, 52.1833, -19.6322>, <21.5045, 52.1118, -19.119> }
					triangle { <24.9145, 50.3446, -20.3936>, <25.1961, 51.1486, -19.6139>, <24.337, 50.694, -19.4673> }
					triangle { <24.9145, 50.3446, -20.3936>, <25.132, 50.665, -20.5182>, <25.1961, 51.1486, -19.6139> }
					triangle { <25.132, 50.665, -20.5182>, <23.09558, 51.3678, -19.822>, <25.1961, 51.1486, -19.6139> }
					triangle { <25.132, 50.665, -20.5182>, <21.8506, 50.8504, -20.7763>, <23.09558, 51.3678, -19.822> }
					triangle { <21.8506, 50.8504, -20.7763>, <21.7271, 51.6171, -20.00289>, <23.09558, 51.3678, -19.822> }
					triangle { <21.8506, 50.8504, -20.7763>, <21.1675, 51.2004, -20.9626>, <21.7271, 51.6171, -20.00289> }
					triangle { <21.7271, 51.6171, -20.00289>, <20.3778, 52.1362, -20.3861>, <20.7704, 52.1833, -19.6322> }
					triangle { <21.1675, 51.2004, -20.9626>, <20.3778, 52.1362, -20.3861>, <21.7271, 51.6171, -20.00289> }
					triangle { <24.337, 50.694, -19.4673>, <25.9664, 50.265, -19.2399>, <26.7166, 49.7975, -20.0623> }
					triangle { <24.337, 50.694, -19.4673>, <25.2418, 50.9011, -18.4437>, <25.9664, 50.265, -19.2399> }
					triangle { <24.337, 50.694, -19.4673>, <24.775, 51.5071, -18.2845>, <25.2418, 50.9011, -18.4437> }
					triangle { <20.6741, 51.718, -21.21>, <20.3778, 52.1362, -20.3861>, <21.1675, 51.2004, -20.9626> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <26.7166, 49.7975, -20.0623>, <24.9342, 51.0926, -18.6601>, <26.06656, 51.1135, -18.8366> }
					triangle { <23.6399, 50.858, -19.6699>, <23.04415, 52.00938, -18.2184>, <25.2039, 51.1538, -19.6034> }
					triangle { <25.2039, 51.1538, -19.6034>, <23.04415, 52.00938, -18.2184>, <24.4696, 52.285, -17.9648> }
					triangle { <24.9342, 51.0926, -18.6601>, <23.6399, 50.858, -19.6699>, <25.2039, 51.1538, -19.6034> }
					triangle { <23.04415, 52.00938, -18.2184>, <22.7929, 52.9954, -17.2194>, <24.4696, 52.285, -17.9648> }
					triangle { <22.7929, 52.9954, -17.2194>, <23.9853, 53.1243, -16.9507>, <24.4696, 52.285, -17.9648> }
					triangle { <22.7929, 52.9954, -17.2194>, <23.06252, 53.7365, -16.4802>, <23.9853, 53.1243, -16.9507> }
					triangle { <24.9342, 51.0926, -18.6601>, <25.2039, 51.1538, -19.6034>, <26.06656, 51.1135, -18.8366> }
					triangle { <25.2039, 51.1538, -19.6034>, <26.1233, 51.3266, -19.1784>, <26.06656, 51.1135, -18.8366> }
					triangle { <25.2039, 51.1538, -19.6034>, <24.4696, 52.285, -17.9648>, <26.1233, 51.3266, -19.1784> }
					triangle { <24.4696, 52.285, -17.9648>, <24.985, 52.9425, -16.5398>, <26.1233, 51.3266, -19.1784> }
					triangle { <24.4696, 52.285, -17.9648>, <23.9853, 53.1243, -16.9507>, <24.985, 52.9425, -16.5398> }
					triangle { <23.9853, 53.1243, -16.9507>, <24.7306, 53.5786, -16.1468>, <24.985, 52.9425, -16.5398> }
					triangle { <23.06252, 53.7365, -16.4802>, <23.6314, 54.2571, -16.00315>, <23.9853, 53.1243, -16.9507> }
					triangle { <23.9853, 53.1243, -16.9507>, <23.6314, 54.2571, -16.00315>, <24.7306, 53.5786, -16.1468> }
					triangle { <26.7166, 49.7975, -20.0623>, <25.2633, 49.9106, -19.9232>, <24.9342, 51.0926, -18.6601> }
					triangle { <25.2633, 49.9106, -19.9232>, <24.1651, 50.2688, -19.6983>, <24.9342, 51.0926, -18.6601> }
					triangle { <24.1651, 50.2688, -19.6983>, <23.6399, 50.858, -19.6699>, <24.9342, 51.0926, -18.6601> }
					triangle { <24.7306, 53.5786, -16.1468>, <23.6314, 54.2571, -16.00315>, <24.532, 54.2929, -15.9958> }
					triangle { <26.06656, 51.1135, -18.8366>, <26.8424, 51.5023, -18.0879>, <26.7166, 49.7975, -20.0623> }
					triangle { <27.1121, 51.5635, -19.03118>, <27.5856, 52.9844, -16.8565>, <28.299, 51.8204, -18.2576> }
					triangle { <26.3778, 52.6947, -17.3925>, <27.5856, 52.9844, -16.8565>, <27.1121, 51.5635, -19.03118> }
					triangle { <27.1121, 51.5635, -19.03118>, <28.299, 51.8204, -18.2576>, <26.8424, 51.5023, -18.0879> }
					triangle { <26.3778, 52.6947, -17.3925>, <26.7832, 53.9072, -15.9981>, <27.5856, 52.9844, -16.8565> }
					triangle { <26.3778, 52.6947, -17.3925>, <25.8935, 53.534, -16.3785>, <26.7832, 53.9072, -15.9981> }
					triangle { <25.8935, 53.534, -16.3785>, <26.1293, 54.3779, -15.6002>, <26.7832, 53.9072, -15.9981> }
					triangle { <26.06656, 51.1135, -18.8366>, <27.1121, 51.5635, -19.03118>, <26.8424, 51.5023, -18.0879> }
					triangle { <26.06656, 51.1135, -18.8366>, <26.1233, 51.3266, -19.1784>, <27.1121, 51.5635, -19.03118> }
					triangle { <26.1233, 51.3266, -19.1784>, <26.3778, 52.6947, -17.3925>, <27.1121, 51.5635, -19.03118> }
					triangle { <26.1233, 51.3266, -19.1784>, <24.985, 52.9425, -16.5398>, <26.3778, 52.6947, -17.3925> }
					triangle { <24.985, 52.9425, -16.5398>, <25.8935, 53.534, -16.3785>, <26.3778, 52.6947, -17.3925> }
					triangle { <24.985, 52.9425, -16.5398>, <24.7306, 53.5786, -16.1468>, <25.8935, 53.534, -16.3785> }
					triangle { <25.8935, 53.534, -16.3785>, <25.3211, 54.6407, -15.5511>, <26.1293, 54.3779, -15.6002> }
					triangle { <24.7306, 53.5786, -16.1468>, <25.3211, 54.6407, -15.5511>, <25.8935, 53.534, -16.3785> }
					triangle { <26.8424, 51.5023, -18.0879>, <27.3867, 50.3836, -19.2467>, <26.7166, 49.7975, -20.0623> }
					triangle { <26.8424, 51.5023, -18.0879>, <28.096, 51.1128, -18.5195>, <27.3867, 50.3836, -19.2467> }
					triangle { <26.8424, 51.5023, -18.0879>, <28.299, 51.8204, -18.2576>, <28.096, 51.1128, -18.5195> }
					triangle { <24.532, 54.2929, -15.9958>, <25.3211, 54.6407, -15.5511>, <24.7306, 53.5786, -16.1468> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <14.1853, 24.9614, -1.7496>, <14.9081, 25.1907, -2.2344>, 0.8 }
			cylinder { <14.9081, 25.1907, -2.2344>, <15.6309, 25.4201, -2.7191>, 0.8 }
			cylinder { <15.6309, 25.4201, -2.7191>, <16.3537, 25.6494, -3.2039>, 0.8 }
			cylinder { <16.3537, 25.6494, -3.2039>, <17.0765, 25.8787, -3.6886>, 0.8 }
			cylinder { <17.0765, 25.8787, -3.6886>, <17.7992, 26.1081, -4.1733>, 0.8 }
			cylinder { <17.7992, 26.1081, -4.1733>, <18.522, 26.3374, -4.6581>, 0.8 }
			cylinder { <18.522, 26.3374, -4.6581>, <19.2448, 26.5667, -5.1428>, 0.8 }
			cylinder { <19.2448, 26.5667, -5.1428>, <19.9676, 26.7961, -5.6275>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <19.9676, 26.7961, -5.6275>, <23.8559, 27.6518, -7.5242>, 0.8 }
				cylinder { <23.8559, 27.6518, -7.5242>, <28.00662, 28.2211, -8.9011>, 0.8 }
				cylinder { <28.00662, 28.2211, -8.9011>, <32.3298, 28.4915, -9.7286>, 0.8 }
				cylinder { <32.3298, 28.4915, -9.7286>, <36.732, 28.4572, -9.9887>, 0.8 }
				cylinder { <36.732, 28.4572, -9.9887>, <41.1179, 28.1189, -9.6758>, 0.8 }
				cylinder { <41.1179, 28.1189, -9.6758>, <45.3924, 27.484, -8.7967>, 0.8 }
				cylinder { <45.3924, 27.484, -8.7967>, <49.4632, 26.5663, -7.3703>, 0.8 }
				cylinder { <49.4632, 26.5663, -7.3703>, <53.2421, 25.3855, -5.4277>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <53.2421, 25.3855, -5.4277>, <53.8246, 23.2218, -6.2681>, <54.1701, 24.2111, -6.3389> }
					triangle { <53.2783, 22.3983, -5.1137>, <54.07252, 21.2705, -6.244>, <53.9797, 23.6258, -5.4781> }
					triangle { <53.9797, 23.6258, -5.4781>, <54.07252, 21.2705, -6.244>, <54.7119, 22.3481, -6.7482> }
					triangle { <53.8246, 23.2218, -6.2681>, <53.2783, 22.3983, -5.1137>, <53.9797, 23.6258, -5.4781> }
					triangle { <54.07252, 21.2705, -6.244>, <54.8329, 20.5739, -7.04661>, <54.7119, 22.3481, -6.7482> }
					triangle { <54.8329, 20.5739, -7.04661>, <55.2778, 21.4925, -7.5228>, <54.7119, 22.3481, -6.7482> }
					triangle { <54.8329, 20.5739, -7.04661>, <55.5353, 20.4411, -7.7321>, <55.2778, 21.4925, -7.5228> }
					triangle { <53.8246, 23.2218, -6.2681>, <53.9797, 23.6258, -5.4781>, <54.1701, 24.2111, -6.3389> }
					triangle { <53.9797, 23.6258, -5.4781>, <54.3808, 24.2687, -6.0369>, <54.1701, 24.2111, -6.3389> }
					triangle { <53.9797, 23.6258, -5.4781>, <54.7119, 22.3481, -6.7482>, <54.3808, 24.2687, -6.0369> }
					triangle { <54.7119, 22.3481, -6.7482>, <55.3935, 22.3069, -8.09917>, <54.3808, 24.2687, -6.0369> }
					triangle { <54.7119, 22.3481, -6.7482>, <55.2778, 21.4925, -7.5228>, <55.3935, 22.3069, -8.09917> }
					triangle { <55.2778, 21.4925, -7.5228>, <55.8644, 21.8307, -8.3736>, <55.3935, 22.3069, -8.09917> }
					triangle { <55.5353, 20.4411, -7.7321>, <56.138, 20.6778, -8.2529>, <55.2778, 21.4925, -7.5228> }
					triangle { <55.2778, 21.4925, -7.5228>, <56.138, 20.6778, -8.2529>, <55.8644, 21.8307, -8.3736> }
					triangle { <53.2421, 25.3855, -5.4277>, <52.9228, 24.0939, -5.2532>, <53.8246, 23.2218, -6.2681> }
					triangle { <52.9228, 24.0939, -5.2532>, <52.9158, 23.0161, -5.2177>, <53.8246, 23.2218, -6.2681> }
					triangle { <52.9158, 23.0161, -5.2177>, <53.2783, 22.3983, -5.1137>, <53.8246, 23.2218, -6.2681> }
					triangle { <55.8644, 21.8307, -8.3736>, <56.138, 20.6778, -8.2529>, <56.4256, 21.4291, -8.4403> }
					triangle { <54.1701, 24.2111, -6.3389>, <54.7098, 24.605, -7.1493>, <53.2421, 25.3855, -5.4277> }
					triangle { <54.8649, 25.0091, -6.3593>, <56.1793, 24.5627, -8.3412>, <55.4063, 25.7835, -7.2802> }
					triangle { <55.5971, 23.7313, -7.6294>, <56.1793, 24.5627, -8.3412>, <54.8649, 25.0091, -6.3593> }
					triangle { <54.8649, 25.0091, -6.3593>, <55.4063, 25.7835, -7.2802>, <54.7098, 24.605, -7.1493> }
					triangle { <55.5971, 23.7313, -7.6294>, <56.7313, 23.4459, -8.9091>, <56.1793, 24.5627, -8.3412> }
					triangle { <55.5971, 23.7313, -7.6294>, <56.163, 22.8758, -8.404>, <56.7313, 23.4459, -8.9091> }
					triangle { <56.163, 22.8758, -8.404>, <56.9442, 22.6772, -9.1135>, <56.7313, 23.4459, -8.9091> }
					triangle { <54.1701, 24.2111, -6.3389>, <54.8649, 25.0091, -6.3593>, <54.7098, 24.605, -7.1493> }
					triangle { <54.1701, 24.2111, -6.3389>, <54.3808, 24.2687, -6.0369>, <54.8649, 25.0091, -6.3593> }
					triangle { <54.3808, 24.2687, -6.0369>, <55.5971, 23.7313, -7.6294>, <54.8649, 25.0091, -6.3593> }
					triangle { <54.3808, 24.2687, -6.0369>, <55.3935, 22.3069, -8.09917>, <55.5971, 23.7313, -7.6294> }
					triangle { <55.3935, 22.3069, -8.09917>, <56.163, 22.8758, -8.404>, <55.5971, 23.7313, -7.6294> }
					triangle { <55.3935, 22.3069, -8.09917>, <55.8644, 21.8307, -8.3736>, <56.163, 22.8758, -8.404> }
					triangle { <56.163, 22.8758, -8.404>, <56.9415, 21.908, -8.9834>, <56.9442, 22.6772, -9.1135> }
					triangle { <55.8644, 21.8307, -8.3736>, <56.9415, 21.908, -8.9834>, <56.163, 22.8758, -8.404> }
					triangle { <54.7098, 24.605, -7.1493>, <53.9217, 25.6202, -6.2686>, <53.2421, 25.3855, -5.4277> }
					triangle { <54.7098, 24.605, -7.1493>, <54.7394, 25.8656, -7.03298>, <53.9217, 25.6202, -6.2686> }
					triangle { <54.7098, 24.605, -7.1493>, <55.4063, 25.7835, -7.2802>, <54.7394, 25.8656, -7.03298> }
					triangle { <56.4256, 21.4291, -8.4403>, <56.9415, 21.908, -8.9834>, <55.8644, 21.8307, -8.3736> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <53.2421, 25.3855, -5.4277>, <54.96, 25.5041, -7.08962>, <54.6726, 26.01657, -6.219> }
					triangle { <54.9931, 24.03006, -7.4574>, <56.2863, 24.839, -8.3812>, <54.8581, 24.9844, -6.3609> }
					triangle { <54.8581, 24.9844, -6.3609>, <56.2863, 24.839, -8.3812>, <56.1862, 25.848, -7.4888> }
					triangle { <54.96, 25.5041, -7.08962>, <54.9931, 24.03006, -7.4574>, <54.8581, 24.9844, -6.3609> }
					triangle { <56.2863, 24.839, -8.3812>, <57.3052, 25.5026, -8.8599>, <56.1862, 25.848, -7.4888> }
					triangle { <57.3052, 25.5026, -8.8599>, <57.1377, 26.378, -8.1713>, <56.1862, 25.848, -7.4888> }
					triangle { <57.3052, 25.5026, -8.8599>, <57.9527, 26.2508, -8.903>, <57.1377, 26.378, -8.1713> }
					triangle { <54.96, 25.5041, -7.08962>, <54.8581, 24.9844, -6.3609>, <54.6726, 26.01657, -6.219> }
					triangle { <54.8581, 24.9844, -6.3609>, <54.8132, 25.8222, -5.9337>, <54.6726, 26.01657, -6.219> }
					triangle { <54.8581, 24.9844, -6.3609>, <56.1862, 25.848, -7.4888>, <54.8132, 25.8222, -5.9337> }
					triangle { <56.1862, 25.848, -7.4888>, <56.7607, 27.2193, -7.7728>, <54.8132, 25.8222, -5.9337> }
					triangle { <56.1862, 25.848, -7.4888>, <57.1377, 26.378, -8.1713>, <56.7607, 27.2193, -7.7728> }
					triangle { <57.1377, 26.378, -8.1713>, <57.4185, 27.4149, -8.002737>, <56.7607, 27.2193, -7.7728> }
					triangle { <57.9527, 26.2508, -8.903>, <58.3066, 26.9598, -8.6529>, <57.1377, 26.378, -8.1713> }
					triangle { <57.1377, 26.378, -8.1713>, <58.3066, 26.9598, -8.6529>, <57.4185, 27.4149, -8.002737> }
					triangle { <53.2421, 25.3855, -5.4277>, <53.7255, 24.6774, -6.46>, <54.96, 25.5041, -7.08962> }
					triangle { <53.7255, 24.6774, -6.46>, <54.3405, 24.2527, -7.2374>, <54.96, 25.5041, -7.08962> }
					triangle { <54.3405, 24.2527, -7.2374>, <54.9931, 24.03006, -7.4574>, <54.96, 25.5041, -7.08962> }
					triangle { <57.4185, 27.4149, -8.002737>, <58.3066, 26.9598, -8.6529>, <58.1083, 27.4751, -8.03866> }
					triangle { <54.6726, 26.01657, -6.219>, <54.8832, 27.02526, -6.01549>, <53.2421, 25.3855, -5.4277> }
					triangle { <54.7812, 26.5055, -5.2868>, <56.1033, 28.4594, -5.8248>, <54.7735, 27.7516, -4.853> }
					triangle { <56.1094, 27.3691, -6.4147>, <56.1033, 28.4594, -5.8248>, <54.7812, 26.5055, -5.2868> }
					triangle { <54.7812, 26.5055, -5.2868>, <54.7735, 27.7516, -4.853>, <54.8832, 27.02526, -6.01549> }
					triangle { <56.1094, 27.3691, -6.4147>, <57.1948, 28.7061, -6.6135>, <56.1033, 28.4594, -5.8248> }
					triangle { <56.1094, 27.3691, -6.4147>, <57.06089, 27.8991, -7.09723>, <57.1948, 28.7061, -6.6135> }
					triangle { <57.06089, 27.8991, -7.09723>, <57.8105, 28.6656, -7.1588>, <57.1948, 28.7061, -6.6135> }
					triangle { <54.6726, 26.01657, -6.219>, <54.7812, 26.5055, -5.2868>, <54.8832, 27.02526, -6.01549> }
					triangle { <54.6726, 26.01657, -6.219>, <54.8132, 25.8222, -5.9337>, <54.7812, 26.5055, -5.2868> }
					triangle { <54.8132, 25.8222, -5.9337>, <56.1094, 27.3691, -6.4147>, <54.7812, 26.5055, -5.2868> }
					triangle { <54.8132, 25.8222, -5.9337>, <56.7607, 27.2193, -7.7728>, <56.1094, 27.3691, -6.4147> }
					triangle { <56.7607, 27.2193, -7.7728>, <57.06089, 27.8991, -7.09723>, <56.1094, 27.3691, -6.4147> }
					triangle { <56.7607, 27.2193, -7.7728>, <57.4185, 27.4149, -8.002737>, <57.06089, 27.8991, -7.09723> }
					triangle { <57.06089, 27.8991, -7.09723>, <58.2518, 28.2694, -7.6656>, <57.8105, 28.6656, -7.1588> }
					triangle { <57.4185, 27.4149, -8.002737>, <58.2518, 28.2694, -7.6656>, <57.06089, 27.8991, -7.09723> }
					triangle { <54.8832, 27.02526, -6.01549>, <53.6586, 26.4002, -5.2826>, <53.2421, 25.3855, -5.4277> }
					triangle { <54.8832, 27.02526, -6.01549>, <54.1821, 27.3863, -5.02473>, <53.6586, 26.4002, -5.2826> }
					triangle { <54.8832, 27.02526, -6.01549>, <54.7735, 27.7516, -4.853>, <54.1821, 27.3863, -5.02473> }
					triangle { <58.1083, 27.4751, -8.03866>, <58.2518, 28.2694, -7.6656>, <57.4185, 27.4149, -8.002737> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <53.2421, 25.3855, -5.4277>, <54.5704, 27.3633, -5.2016>, <54.0446, 26.6954, -4.5846> }
					triangle { <55.4443, 27.1661, -6.4291>, <56.03146, 28.6234, -5.5853>, <54.7898, 26.4963, -5.3091> }
					triangle { <54.7898, 26.4963, -5.3091>, <56.03146, 28.6234, -5.5853>, <55.3731, 28.1651, -4.4986> }
					triangle { <54.5704, 27.3633, -5.2016>, <55.4443, 27.1661, -6.4291>, <54.7898, 26.4963, -5.3091> }
					triangle { <56.03146, 28.6234, -5.5853>, <56.4802, 29.5581, -4.79>, <55.3731, 28.1651, -4.4986> }
					triangle { <56.4802, 29.5581, -4.79>, <55.8426, 29.2161, -3.9269>, <55.3731, 28.1651, -4.4986> }
					triangle { <56.4802, 29.5581, -4.79>, <56.5786, 30.03716, -3.9287>, <55.8426, 29.2161, -3.9269> }
					triangle { <54.5704, 27.3633, -5.2016>, <54.7898, 26.4963, -5.3091>, <54.0446, 26.6954, -4.5846> }
					triangle { <54.7898, 26.4963, -5.3091>, <54.2728, 26.4064, -4.5274>, <54.0446, 26.6954, -4.5846> }
					triangle { <54.7898, 26.4963, -5.3091>, <55.3731, 28.1651, -4.4986>, <54.2728, 26.4064, -4.5274> }
					triangle { <55.3731, 28.1651, -4.4986>, <55.05191, 29.0666, -3.3259>, <54.2728, 26.4064, -4.5274> }
					triangle { <55.3731, 28.1651, -4.4986>, <55.8426, 29.2161, -3.9269>, <55.05191, 29.0666, -3.3259> }
					triangle { <55.8426, 29.2161, -3.9269>, <55.476, 29.5148, -2.9477>, <55.05191, 29.0666, -3.3259> }
					triangle { <56.5786, 30.03716, -3.9287>, <56.461, 30.163, -3.1158>, <55.8426, 29.2161, -3.9269> }
					triangle { <55.8426, 29.2161, -3.9269>, <56.461, 30.163, -3.1158>, <55.476, 29.5148, -2.9477> }
					triangle { <53.2421, 25.3855, -5.4277>, <54.04011, 26.1781, -6.1596>, <54.5704, 27.3633, -5.2016> }
					triangle { <54.04011, 26.1781, -6.1596>, <54.7836, 26.8798, -6.5025>, <54.5704, 27.3633, -5.2016> }
					triangle { <54.7836, 26.8798, -6.5025>, <55.4443, 27.1661, -6.4291>, <54.5704, 27.3633, -5.2016> }
					triangle { <55.476, 29.5148, -2.9477>, <56.461, 30.163, -3.1158>, <56.00517, 29.7487, -2.5655> }
					triangle { <54.0446, 26.6954, -4.5846>, <53.6369, 26.9343, -3.6466>, <53.2421, 25.3855, -5.4277> }
					triangle { <53.8563, 26.06734, -3.7541>, <53.8098, 27.6025, -1.8843>, <53.1347, 26.1294, -2.6512> }
					triangle { <54.4396, 27.7361, -2.9436>, <53.8098, 27.6025, -1.8843>, <53.8563, 26.06734, -3.7541> }
					triangle { <53.8563, 26.06734, -3.7541>, <53.1347, 26.1294, -2.6512>, <53.6369, 26.9343, -3.6466> }
					triangle { <54.4396, 27.7361, -2.9436>, <54.5564, 28.6822, -1.4956>, <53.8098, 27.6025, -1.8843> }
					triangle { <54.4396, 27.7361, -2.9436>, <54.9091, 28.7872, -2.3718>, <54.5564, 28.6822, -1.4956> }
					triangle { <54.9091, 28.7872, -2.3718>, <55.0805, 29.3159, -1.453>, <54.5564, 28.6822, -1.4956> }
					triangle { <54.0446, 26.6954, -4.5846>, <53.8563, 26.06734, -3.7541>, <53.6369, 26.9343, -3.6466> }
					triangle { <54.0446, 26.6954, -4.5846>, <54.2728, 26.4064, -4.5274>, <53.8563, 26.06734, -3.7541> }
					triangle { <54.2728, 26.4064, -4.5274>, <54.4396, 27.7361, -2.9436>, <53.8563, 26.06734, -3.7541> }
					triangle { <54.2728, 26.4064, -4.5274>, <55.05191, 29.0666, -3.3259>, <54.4396, 27.7361, -2.9436> }
					triangle { <55.05191, 29.0666, -3.3259>, <54.9091, 28.7872, -2.3718>, <54.4396, 27.7361, -2.9436> }
					triangle { <55.05191, 29.0666, -3.3259>, <55.476, 29.5148, -2.9477>, <54.9091, 28.7872, -2.3718> }
					triangle { <54.9091, 28.7872, -2.3718>, <55.6669, 29.7406, -1.7433>, <55.0805, 29.3159, -1.453> }
					triangle { <55.476, 29.5148, -2.9477>, <55.6669, 29.7406, -1.7433>, <54.9091, 28.7872, -2.3718> }
					triangle { <53.6369, 26.9343, -3.6466>, <52.9991, 25.7325, -4.4056>, <53.2421, 25.3855, -5.4277> }
					triangle { <53.6369, 26.9343, -3.6466>, <52.8607, 25.9962, -3.2991>, <52.9991, 25.7325, -4.4056> }
					triangle { <53.6369, 26.9343, -3.6466>, <53.1347, 26.1294, -2.6512>, <52.8607, 25.9962, -3.2991> }
					triangle { <56.00517, 29.7487, -2.5655>, <55.6669, 29.7406, -1.7433>, <55.476, 29.5148, -2.9477> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <53.2421, 25.3855, -5.4277>, <53.1905, 26.2474, -3.1957>, <53.1481, 25.316, -3.6793> }
					triangle { <54.01271, 27.5018, -3.4402>, <53.6577, 27.429, -1.694>, <53.8685, 26.0862, -3.7664> }
					triangle { <53.8685, 26.0862, -3.7664>, <53.6577, 27.429, -1.694>, <53.3886, 26.1188, -1.8821> }
					triangle { <53.1905, 26.2474, -3.1957>, <54.01271, 27.5018, -3.4402>, <53.8685, 26.0862, -3.7664> }
					triangle { <53.6577, 27.429, -1.694>, <53.4903, 27.1738, -0.4234>, <53.3886, 26.1188, -1.8821> }
					triangle { <53.4903, 27.1738, -0.4234>, <53.1701, 26.1112, -0.6156>, <53.3886, 26.1188, -1.8821> }
					triangle { <53.4903, 27.1738, -0.4234>, <53.2991, 26.6027, 0.3629>, <53.1701, 26.1112, -0.6156> }
					triangle { <53.1905, 26.2474, -3.1957>, <53.8685, 26.0862, -3.7664>, <53.1481, 25.316, -3.6793> }
					triangle { <53.8685, 26.0862, -3.7664>, <53.5014, 25.2194, -3.7483>, <53.1481, 25.316, -3.6793> }
					triangle { <53.8685, 26.0862, -3.7664>, <53.3886, 26.1188, -1.8821>, <53.5014, 25.2194, -3.7483> }
					triangle { <53.3886, 26.1188, -1.8821>, <52.6126, 25.3131, -0.8624>, <53.5014, 25.2194, -3.7483> }
					triangle { <53.3886, 26.1188, -1.8821>, <53.1701, 26.1112, -0.6156>, <52.6126, 25.3131, -0.8624> }
					triangle { <53.1701, 26.1112, -0.6156>, <52.7031, 25.248, -0.1473>, <52.6126, 25.3131, -0.8624> }
					triangle { <53.2991, 26.6027, 0.3629>, <53.1344, 25.8905, 0.758>, <53.1701, 26.1112, -0.6156> }
					triangle { <53.1701, 26.1112, -0.6156>, <53.1344, 25.8905, 0.758>, <52.7031, 25.248, -0.1473> }
					triangle { <53.2421, 25.3855, -5.4277>, <53.4347, 26.536, -4.7644>, <53.1905, 26.2474, -3.1957> }
					triangle { <53.4347, 26.536, -4.7644>, <53.6369, 27.2914, -4.02187>, <53.1905, 26.2474, -3.1957> }
					triangle { <53.6369, 27.2914, -4.02187>, <54.01271, 27.5018, -3.4402>, <53.1905, 26.2474, -3.1957> }
					triangle { <52.7031, 25.248, -0.1473>, <53.1344, 25.8905, 0.758>, <53.00297, 25.129, 0.4663> }
					triangle { <53.1481, 25.316, -3.6793>, <52.6818, 24.4571, -3.2943>, <53.2421, 25.3855, -5.4277> }
					triangle { <53.3598, 24.2959, -3.865>, <52.4469, 23.1681, -1.9285>, <52.7394, 23.1436, -3.697> }
					triangle { <52.8798, 24.3286, -1.9807>, <52.4469, 23.1681, -1.9285>, <53.3598, 24.2959, -3.865> }
					triangle { <53.3598, 24.2959, -3.865>, <52.7394, 23.1436, -3.697>, <52.6818, 24.4571, -3.2943> }
					triangle { <52.8798, 24.3286, -1.9807>, <52.4376, 23.407, -0.5805>, <52.4469, 23.1681, -1.9285> }
					triangle { <52.8798, 24.3286, -1.9807>, <52.6613, 24.3209, -0.7141>, <52.4376, 23.407, -0.5805> }
					triangle { <52.6613, 24.3209, -0.7141>, <52.5014, 23.7355, 0.1718>, <52.4376, 23.407, -0.5805> }
					triangle { <53.1481, 25.316, -3.6793>, <53.3598, 24.2959, -3.865>, <52.6818, 24.4571, -3.2943> }
					triangle { <53.1481, 25.316, -3.6793>, <53.5014, 25.2194, -3.7483>, <53.3598, 24.2959, -3.865> }
					triangle { <53.5014, 25.2194, -3.7483>, <52.8798, 24.3286, -1.9807>, <53.3598, 24.2959, -3.865> }
					triangle { <53.5014, 25.2194, -3.7483>, <52.6126, 25.3131, -0.8624>, <52.8798, 24.3286, -1.9807> }
					triangle { <52.6126, 25.3131, -0.8624>, <52.6613, 24.3209, -0.7141>, <52.8798, 24.3286, -1.9807> }
					triangle { <52.6126, 25.3131, -0.8624>, <52.7031, 25.248, -0.1473>, <52.6613, 24.3209, -0.7141> }
					triangle { <52.6613, 24.3209, -0.7141>, <52.735, 24.3023, 0.6543>, <52.5014, 23.7355, 0.1718> }
					triangle { <52.7031, 25.248, -0.1473>, <52.735, 24.3023, 0.6543>, <52.6613, 24.3209, -0.7141> }
					triangle { <52.6818, 24.4571, -3.2943>, <52.8486, 24.5337, -4.8414>, <53.2421, 25.3855, -5.4277> }
					triangle { <52.6818, 24.4571, -3.2943>, <52.5889, 23.6034, -4.2248>, <52.8486, 24.5337, -4.8414> }
					triangle { <52.6818, 24.4571, -3.2943>, <52.7394, 23.1436, -3.697>, <52.5889, 23.6034, -4.2248> }
					triangle { <53.00297, 25.129, 0.4663>, <52.735, 24.3023, 0.6543>, <52.7031, 25.248, -0.1473> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <53.2421, 25.3855, -5.4277>, <52.7226, 23.6492, -3.8648>, <53.2268, 23.7574, -4.7798> }
					triangle { <52.6538, 24.5107, -2.6149>, <52.4288, 22.816, -2.1072>, <53.3603, 24.2853, -3.8724> }
					triangle { <53.3603, 24.2853, -3.8724>, <52.4288, 22.816, -2.1072>, <52.9738, 22.4695, -3.2935> }
					triangle { <52.7226, 23.6492, -3.8648>, <52.6538, 24.5107, -2.6149>, <53.3603, 24.2853, -3.8724> }
					triangle { <52.4288, 22.816, -2.1072>, <52.4569, 21.5374, -1.839>, <52.9738, 22.4695, -3.2935> }
					triangle { <52.4569, 21.5374, -1.839>, <52.8157, 21.2657, -2.8715>, <52.9738, 22.4695, -3.2935> }
					triangle { <52.4569, 21.5374, -1.839>, <52.6446, 20.5825, -2.02317>, <52.8157, 21.2657, -2.8715> }
					triangle { <52.7226, 23.6492, -3.8648>, <53.3603, 24.2853, -3.8724>, <53.2268, 23.7574, -4.7798> }
					triangle { <53.3603, 24.2853, -3.8724>, <53.5692, 23.8783, -4.6953>, <53.2268, 23.7574, -4.7798> }
					triangle { <53.3603, 24.2853, -3.8724>, <52.9738, 22.4695, -3.2935>, <53.5692, 23.8783, -4.6953> }
					triangle { <52.9738, 22.4695, -3.2935>, <52.8269, 21.07235, -3.857>, <53.5692, 23.8783, -4.6953> }
					triangle { <52.9738, 22.4695, -3.2935>, <52.8157, 21.2657, -2.8715>, <52.8269, 21.07235, -3.857> }
					triangle { <52.8157, 21.2657, -2.8715>, <52.9468, 20.4273, -3.5514>, <52.8269, 21.07235, -3.857> }
					triangle { <52.6446, 20.5825, -2.02317>, <52.9318, 19.9398, -2.4647>, <52.8157, 21.2657, -2.8715> }
					triangle { <52.8157, 21.2657, -2.8715>, <52.9318, 19.9398, -2.4647>, <52.9468, 20.4273, -3.5514> }
					triangle { <53.2421, 25.3855, -5.4277>, <52.7337, 25.2285, -4.1958>, <52.7226, 23.6492, -3.8648> }
					triangle { <52.7337, 25.2285, -4.1958>, <52.4651, 24.8674, -3.2158>, <52.7226, 23.6492, -3.8648> }
					triangle { <52.4651, 24.8674, -3.2158>, <52.6538, 24.5107, -2.6149>, <52.7226, 23.6492, -3.8648> }
					triangle { <52.9468, 20.4273, -3.5514>, <52.9318, 19.9398, -2.4647>, <53.2667, 19.9096, -3.2192> }
					triangle { <53.2268, 23.7574, -4.7798>, <53.3549, 22.9958, -5.4918>, <53.2421, 25.3855, -5.4277> }
					triangle { <53.9926, 23.632, -5.4994>, <53.9335, 21.2611, -5.9794>, <54.1645, 22.9266, -6.6011> }
					triangle { <53.606, 21.8161, -4.9204>, <53.9335, 21.2611, -5.9794>, <53.9926, 23.632, -5.4994> }
					triangle { <53.9926, 23.632, -5.4994>, <54.1645, 22.9266, -6.6011>, <53.3549, 22.9958, -5.4918> }
					triangle { <53.606, 21.8161, -4.9204>, <53.802, 20.122, -5.2314>, <53.9335, 21.2611, -5.9794> }
					triangle { <53.606, 21.8161, -4.9204>, <53.448, 20.6124, -4.4984>, <53.802, 20.122, -5.2314> }
					triangle { <53.448, 20.6124, -4.4984>, <53.6707, 19.5706, -4.6341>, <53.802, 20.122, -5.2314> }
					triangle { <53.2268, 23.7574, -4.7798>, <53.9926, 23.632, -5.4994>, <53.3549, 22.9958, -5.4918> }
					triangle { <53.2268, 23.7574, -4.7798>, <53.5692, 23.8783, -4.6953>, <53.9926, 23.632, -5.4994> }
					triangle { <53.5692, 23.8783, -4.6953>, <53.606, 21.8161, -4.9204>, <53.9926, 23.632, -5.4994> }
					triangle { <53.5692, 23.8783, -4.6953>, <52.8269, 21.07235, -3.857>, <53.606, 21.8161, -4.9204> }
					triangle { <52.8269, 21.07235, -3.857>, <53.448, 20.6124, -4.4984>, <53.606, 21.8161, -4.9204> }
					triangle { <52.8269, 21.07235, -3.857>, <52.9468, 20.4273, -3.5514>, <53.448, 20.6124, -4.4984> }
					triangle { <53.448, 20.6124, -4.4984>, <53.5346, 19.3884, -3.8878>, <53.6707, 19.5706, -4.6341> }
					triangle { <52.9468, 20.4273, -3.5514>, <53.5346, 19.3884, -3.8878>, <53.448, 20.6124, -4.4984> }
					triangle { <53.3549, 22.9958, -5.4918>, <53.4274, 24.4633, -6.01019>, <53.2421, 25.3855, -5.4277> }
					triangle { <53.3549, 22.9958, -5.4918>, <53.7675, 23.5215, -6.5673>, <53.4274, 24.4633, -6.01019> }
					triangle { <53.3549, 22.9958, -5.4918>, <54.1645, 22.9266, -6.6011>, <53.7675, 23.5215, -6.5673> }
					triangle { <53.2667, 19.9096, -3.2192>, <53.5346, 19.3884, -3.8878>, <52.9468, 20.4273, -3.5514> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <19.9676, 26.7961, -5.6275>, <20.6904, 27.02545, -6.1123>, 0.8 }
			cylinder { <20.6904, 27.02545, -6.1123>, <21.4132, 27.2547, -6.597>, 0.8 }
			cylinder { <21.4132, 27.2547, -6.597>, <22.136, 27.4841, -7.08181>, 0.8 }
			cylinder { <22.136, 27.4841, -7.08181>, <22.8588, 27.7134, -7.5665>, 0.8 }
			cylinder { <22.8588, 27.7134, -7.5665>, <23.5816, 27.9428, -8.05128>, 0.8 }
			cylinder { <23.5816, 27.9428, -8.05128>, <24.3044, 28.1721, -8.536>, 0.8 }
			cylinder { <24.3044, 28.1721, -8.536>, <25.02725, 28.4014, -9.02076>, 0.8 }
			cylinder { <25.02725, 28.4014, -9.02076>, <25.75, 28.6308, -9.5055>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <25.75, 28.6308, -9.5055>, <28.9531, 29.5484, -12.3944>, 0.8 }
				cylinder { <28.9531, 29.5484, -12.3944>, <31.7484, 30.2401, -15.7345>, 0.8 }
				cylinder { <31.7484, 30.2401, -15.7345>, <34.07525, 30.6909, -19.4535>, 0.8 }
				cylinder { <34.07525, 30.6909, -19.4535>, <35.8833, 30.891, -23.4708>, 0.8 }
				cylinder { <35.8833, 30.891, -23.4708>, <37.1334, 30.8361, -27.6995>, 0.8 }
				cylinder { <37.1334, 30.8361, -27.6995>, <37.7986, 30.5274, -32.04819>, 0.8 }
				cylinder { <37.7986, 30.5274, -32.04819>, <37.8643, 29.9715, -36.4225>, 0.8 }
				cylinder { <37.8643, 29.9715, -36.4225>, <37.3293, 29.1805, -40.7278>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <37.3293, 29.1805, -40.7278>, <36.4874, 31.19, -41.7178>, <37.3709, 30.6221, -41.7233> }
					triangle { <35.01575, 30.8116, -41.7327>, <35.167, 32.3952, -42.5388>, <36.3769, 30.3207, -41.9262> }
					triangle { <36.3769, 30.3207, -41.9262>, <35.167, 32.3952, -42.5388>, <36.4784, 32.1075, -42.6871> }
					triangle { <36.4874, 31.19, -41.7178>, <35.01575, 30.8116, -41.7327>, <36.3769, 30.3207, -41.9262> }
					triangle { <35.167, 32.3952, -42.5388>, <35.4244, 33.453, -43.2615>, <36.4784, 32.1075, -42.6871> }
					triangle { <35.4244, 33.453, -43.2615>, <36.5309, 33.2444, -43.2843>, <36.4784, 32.1075, -42.6871> }
					triangle { <35.4244, 33.453, -43.2615>, <35.9962, 34.06621, -43.7888>, <36.5309, 33.2444, -43.2843> }
					triangle { <36.4874, 31.19, -41.7178>, <36.3769, 30.3207, -41.9262>, <37.3709, 30.6221, -41.7233> }
					triangle { <36.3769, 30.3207, -41.9262>, <37.3169, 30.3497, -41.972>, <37.3709, 30.6221, -41.7233> }
					triangle { <36.3769, 30.3207, -41.9262>, <36.4784, 32.1075, -42.6871>, <37.3169, 30.3497, -41.972> }
					triangle { <36.4784, 32.1075, -42.6871>, <37.4952, 33.181, -43.01072>, <37.3169, 30.3497, -41.972> }
					triangle { <36.4784, 32.1075, -42.6871>, <36.5309, 33.2444, -43.2843>, <37.4952, 33.181, -43.01072> }
					triangle { <36.5309, 33.2444, -43.2843>, <37.4929, 33.6911, -43.5241>, <37.4952, 33.181, -43.01072> }
					triangle { <35.9962, 34.06621, -43.7888>, <36.6994, 34.3196, -44.1518>, <36.5309, 33.2444, -43.2843> }
					triangle { <36.5309, 33.2444, -43.2843>, <36.6994, 34.3196, -44.1518>, <37.4929, 33.6911, -43.5241> }
					triangle { <37.3293, 29.1805, -40.7278>, <36.1785, 29.8575, -40.8619>, <36.4874, 31.19, -41.7178> }
					triangle { <36.1785, 29.8575, -40.8619>, <35.3813, 30.5066, -41.1876>, <36.4874, 31.19, -41.7178> }
					triangle { <35.3813, 30.5066, -41.1876>, <35.01575, 30.8116, -41.7327>, <36.4874, 31.19, -41.7178> }
					triangle { <37.4929, 33.6911, -43.5241>, <36.6994, 34.3196, -44.1518>, <37.4577, 33.9921, -44.1477> }
					triangle { <37.3709, 30.6221, -41.7233>, <38.3314, 31.00253, -41.9125>, <37.3293, 29.1805, -40.7278> }
					triangle { <38.221, 30.1331, -42.1209>, <39.5558, 31.9488, -43.00221>, <39.5197, 30.3606, -42.1714> }
					triangle { <38.3224, 31.92, -42.8818>, <39.5558, 31.9488, -43.00221>, <38.221, 30.1331, -42.1209> }
					triangle { <38.221, 30.1331, -42.1209>, <39.5197, 30.3606, -42.1714>, <38.3314, 31.00253, -41.9125> }
					triangle { <38.3224, 31.92, -42.8818>, <39.2953, 33.08899, -43.7138>, <39.5558, 31.9488, -43.00221> }
					triangle { <38.3224, 31.92, -42.8818>, <38.375, 33.05692, -43.479>, <39.2953, 33.08899, -43.7138> }
					triangle { <38.375, 33.05692, -43.479>, <38.9437, 33.7296, -44.09329>, <39.2953, 33.08899, -43.7138> }
					triangle { <37.3709, 30.6221, -41.7233>, <38.221, 30.1331, -42.1209>, <38.3314, 31.00253, -41.9125> }
					triangle { <37.3709, 30.6221, -41.7233>, <37.3169, 30.3497, -41.972>, <38.221, 30.1331, -42.1209> }
					triangle { <37.3169, 30.3497, -41.972>, <38.3224, 31.92, -42.8818>, <38.221, 30.1331, -42.1209> }
					triangle { <37.3169, 30.3497, -41.972>, <37.4952, 33.181, -43.01072>, <38.3224, 31.92, -42.8818> }
					triangle { <37.4952, 33.181, -43.01072>, <38.375, 33.05692, -43.479>, <38.3224, 31.92, -42.8818> }
					triangle { <37.4952, 33.181, -43.01072>, <37.4929, 33.6911, -43.5241>, <38.375, 33.05692, -43.479> }
					triangle { <38.375, 33.05692, -43.479>, <38.3147, 34.1113, -44.3525>, <38.9437, 33.7296, -44.09329> }
					triangle { <37.4929, 33.6911, -43.5241>, <38.3147, 34.1113, -44.3525>, <38.375, 33.05692, -43.479> }
					triangle { <38.3314, 31.00253, -41.9125>, <38.2468, 29.6839, -41.0871>, <37.3293, 29.1805, -40.7278> }
					triangle { <38.3314, 31.00253, -41.9125>, <39.18, 30.1203, -41.5886>, <38.2468, 29.6839, -41.0871> }
					triangle { <38.3314, 31.00253, -41.9125>, <39.5197, 30.3606, -42.1714>, <39.18, 30.1203, -41.5886> }
					triangle { <37.4577, 33.9921, -44.1477>, <38.3147, 34.1113, -44.3525>, <37.4929, 33.6911, -43.5241> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <37.3293, 29.1805, -40.7278>, <39.03774, 30.3901, -41.8878>, <38.7892, 29.3924, -41.6736> }
					triangle { <38.206, 31.6018, -42.2743>, <39.8184, 31.8058, -43.00857>, <38.2016, 30.1499, -42.1216> }
					triangle { <38.2016, 30.1499, -42.1216>, <39.8184, 31.8058, -43.00857>, <39.9853, 30.4783, -42.8236> }
					triangle { <39.03774, 30.3901, -41.8878>, <38.206, 31.6018, -42.2743>, <38.2016, 30.1499, -42.1216> }
					triangle { <39.8184, 31.8058, -43.00857>, <40.9625, 31.7562, -43.6379>, <39.9853, 30.4783, -42.8236> }
					triangle { <40.9625, 31.7562, -43.6379>, <41.1264, 30.6715, -43.3827>, <39.9853, 30.4783, -42.8236> }
					triangle { <40.9625, 31.7562, -43.6379>, <41.7721, 31.3164, -44.00142>, <41.1264, 30.6715, -43.3827> }
					triangle { <39.03774, 30.3901, -41.8878>, <38.2016, 30.1499, -42.1216>, <38.7892, 29.3924, -41.6736> }
					triangle { <38.2016, 30.1499, -42.1216>, <38.5374, 29.2916, -41.9293>, <38.7892, 29.3924, -41.6736> }
					triangle { <38.2016, 30.1499, -42.1216>, <39.9853, 30.4783, -42.8236>, <38.5374, 29.2916, -41.9293> }
					triangle { <39.9853, 30.4783, -42.8236>, <41.3545, 29.8351, -42.8755>, <38.5374, 29.2916, -41.9293> }
					triangle { <39.9853, 30.4783, -42.8236>, <41.1264, 30.6715, -43.3827>, <41.3545, 29.8351, -42.8755> }
					triangle { <41.1264, 30.6715, -43.3827>, <41.8799, 29.8877, -43.3705>, <41.3545, 29.8351, -42.8755> }
					triangle { <41.7721, 31.3164, -44.00142>, <42.2708, 30.6746, -44.1745>, <41.1264, 30.6715, -43.3827> }
					triangle { <41.1264, 30.6715, -43.3827>, <42.2708, 30.6746, -44.1745>, <41.8799, 29.8877, -43.3705> }
					triangle { <37.3293, 29.1805, -40.7278>, <37.6063, 30.4259, -41.1438>, <39.03774, 30.3901, -41.8878> }
					triangle { <37.6063, 30.4259, -41.1438>, <37.9886, 31.2943, -41.6563>, <39.03774, 30.3901, -41.8878> }
					triangle { <37.9886, 31.2943, -41.6563>, <38.206, 31.6018, -42.2743>, <39.03774, 30.3901, -41.8878> }
					triangle { <41.8799, 29.8877, -43.3705>, <42.2708, 30.6746, -44.1745>, <42.2075, 29.8741, -43.9814> }
					triangle { <38.7892, 29.3924, -41.6736>, <39.4754, 28.5995, -41.6132>, <37.3293, 29.1805, -40.7278> }
					triangle { <38.6393, 28.3592, -41.847>, <40.8602, 27.5439, -42.355>, <39.2786, 27.2392, -41.5679> }
					triangle { <40.423, 28.6876, -42.549>, <40.8602, 27.5439, -42.355>, <38.6393, 28.3592, -41.847> }
					triangle { <38.6393, 28.3592, -41.847>, <39.2786, 27.2392, -41.5679>, <39.4754, 28.5995, -41.6132> }
					triangle { <40.423, 28.6876, -42.549>, <41.9132, 27.9969, -43.1036>, <40.8602, 27.5439, -42.355> }
					triangle { <40.423, 28.6876, -42.549>, <41.5641, 28.8808, -43.1081>, <41.9132, 27.9969, -43.1036> }
					triangle { <41.5641, 28.8808, -43.1081>, <42.4365, 28.4434, -43.5561>, <41.9132, 27.9969, -43.1036> }
					triangle { <38.7892, 29.3924, -41.6736>, <38.6393, 28.3592, -41.847>, <39.4754, 28.5995, -41.6132> }
					triangle { <38.7892, 29.3924, -41.6736>, <38.5374, 29.2916, -41.9293>, <38.6393, 28.3592, -41.847> }
					triangle { <38.5374, 29.2916, -41.9293>, <40.423, 28.6876, -42.549>, <38.6393, 28.3592, -41.847> }
					triangle { <38.5374, 29.2916, -41.9293>, <41.3545, 29.8351, -42.8755>, <40.423, 28.6876, -42.549> }
					triangle { <41.3545, 29.8351, -42.8755>, <41.5641, 28.8808, -43.1081>, <40.423, 28.6876, -42.549> }
					triangle { <41.3545, 29.8351, -42.8755>, <41.8799, 29.8877, -43.3705>, <41.5641, 28.8808, -43.1081> }
					triangle { <41.5641, 28.8808, -43.1081>, <42.6155, 29.0843, -43.9634>, <42.4365, 28.4434, -43.5561> }
					triangle { <41.8799, 29.8877, -43.3705>, <42.6155, 29.0843, -43.9634>, <41.5641, 28.8808, -43.1081> }
					triangle { <39.4754, 28.5995, -41.6132>, <38.1325, 28.4282, -40.8422>, <37.3293, 29.1805, -40.7278> }
					triangle { <39.4754, 28.5995, -41.6132>, <38.8904, 27.6055, -41.09068>, <38.1325, 28.4282, -40.8422> }
					triangle { <39.4754, 28.5995, -41.6132>, <39.2786, 27.2392, -41.5679>, <38.8904, 27.6055, -41.09068> }
					triangle { <42.2075, 29.8741, -43.9814>, <42.6155, 29.0843, -43.9634>, <41.8799, 29.8877, -43.3705> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <37.3293, 29.1805, -40.7278>, <39.1251, 27.7555, -41.4146>, <38.08579, 27.6975, -41.2748> }
					triangle { <40.03162, 28.8299, -41.9919>, <40.8111, 27.255, -42.2958>, <38.6489, 28.3824, -41.8524> }
					triangle { <38.6489, 28.3824, -41.8524>, <40.8111, 27.255, -42.2958>, <39.5982, 26.7006, -42.08147> }
					triangle { <39.1251, 27.7555, -41.4146>, <40.03162, 28.8299, -41.9919>, <38.6489, 28.3824, -41.8524> }
					triangle { <40.8111, 27.255, -42.2958>, <41.1909, 26.0467, -42.6174>, <39.5982, 26.7006, -42.08147> }
					triangle { <41.1909, 26.0467, -42.6174>, <40.1995, 25.5931, -42.3345>, <39.5982, 26.7006, -42.08147> }
					triangle { <41.1909, 26.0467, -42.6174>, <41.07115, 25.07509, -42.7676>, <40.1995, 25.5931, -42.3345> }
					triangle { <39.1251, 27.7555, -41.4146>, <38.6489, 28.3824, -41.8524>, <38.08579, 27.6975, -41.2748> }
					triangle { <38.6489, 28.3824, -41.8524>, <37.932, 27.8332, -41.5861>, <38.08579, 27.6975, -41.2748> }
					triangle { <38.6489, 28.3824, -41.8524>, <39.5982, 26.7006, -42.08147>, <37.932, 27.8332, -41.5861> }
					triangle { <39.5982, 26.7006, -42.08147>, <39.4404, 25.2236, -41.7904>, <37.932, 27.8332, -41.5861> }
					triangle { <39.5982, 26.7006, -42.08147>, <40.1995, 25.5931, -42.3345>, <39.4404, 25.2236, -41.7904> }
					triangle { <40.1995, 25.5931, -42.3345>, <39.7041, 24.6455, -42.137>, <39.4404, 25.2236, -41.7904> }
					triangle { <41.07115, 25.07509, -42.7676>, <40.6435, 24.364, -42.8129>, <40.1995, 25.5931, -42.3345> }
					triangle { <40.1995, 25.5931, -42.3345>, <40.6435, 24.364, -42.8129>, <39.7041, 24.6455, -42.137> }
					triangle { <37.3293, 29.1805, -40.7278>, <38.6291, 29.2482, -41.05456>, <39.1251, 27.7555, -41.4146> }
					triangle { <38.6291, 29.2482, -41.05456>, <39.6165, 29.07042, -41.45>, <39.1251, 27.7555, -41.4146> }
					triangle { <39.6165, 29.07042, -41.45>, <40.03162, 28.8299, -41.9919>, <39.1251, 27.7555, -41.4146> }
					triangle { <39.7041, 24.6455, -42.137>, <40.6435, 24.364, -42.8129>, <39.8517, 24.1983, -42.6459> }
					triangle { <38.08579, 27.6975, -41.2748>, <37.5557, 26.8196, -41.04772>, <37.3293, 29.1805, -40.7278> }
					triangle { <37.07956, 27.4465, -41.4855>, <37.07592, 25.02769, -41.4224>, <36.2067, 26.5531, -41.0602> }
					triangle { <38.02887, 25.7648, -41.7145>, <37.07592, 25.02769, -41.4224>, <37.07956, 27.4465, -41.4855> }
					triangle { <37.07956, 27.4465, -41.4855>, <36.2067, 26.5531, -41.0602>, <37.5557, 26.8196, -41.04772> }
					triangle { <38.02887, 25.7648, -41.7145>, <37.9101, 24.0432, -41.8798>, <37.07592, 25.02769, -41.4224> }
					triangle { <38.02887, 25.7648, -41.7145>, <38.63, 24.6573, -41.9675>, <37.9101, 24.0432, -41.8798> }
					triangle { <38.63, 24.6573, -41.9675>, <38.5404, 23.6092, -42.1838>, <37.9101, 24.0432, -41.8798> }
					triangle { <38.08579, 27.6975, -41.2748>, <37.07956, 27.4465, -41.4855>, <37.5557, 26.8196, -41.04772> }
					triangle { <38.08579, 27.6975, -41.2748>, <37.932, 27.8332, -41.5861>, <37.07956, 27.4465, -41.4855> }
					triangle { <37.932, 27.8332, -41.5861>, <38.02887, 25.7648, -41.7145>, <37.07956, 27.4465, -41.4855> }
					triangle { <37.932, 27.8332, -41.5861>, <39.4404, 25.2236, -41.7904>, <38.02887, 25.7648, -41.7145> }
					triangle { <39.4404, 25.2236, -41.7904>, <38.63, 24.6573, -41.9675>, <38.02887, 25.7648, -41.7145> }
					triangle { <39.4404, 25.2236, -41.7904>, <39.7041, 24.6455, -42.137>, <38.63, 24.6573, -41.9675> }
					triangle { <38.63, 24.6573, -41.9675>, <39.2383, 23.5653, -42.5297>, <38.5404, 23.6092, -42.1838> }
					triangle { <39.7041, 24.6455, -42.137>, <39.2383, 23.5653, -42.5297>, <38.63, 24.6573, -41.9675> }
					triangle { <37.5557, 26.8196, -41.04772>, <36.8909, 28.1685, -40.6402>, <37.3293, 29.1805, -40.7278> }
					triangle { <37.5557, 26.8196, -41.04772>, <36.3835, 27.1425, -40.6941>, <36.8909, 28.1685, -40.6402> }
					triangle { <37.5557, 26.8196, -41.04772>, <36.2067, 26.5531, -41.0602>, <36.3835, 27.1425, -40.6941> }
					triangle { <39.8517, 24.1983, -42.6459>, <39.2383, 23.5653, -42.5297>, <39.7041, 24.6455, -42.137> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <37.3293, 29.1805, -40.7278>, <36.6296, 26.9025, -40.9478>, <36.2261, 27.8639, -41.07434> }
					triangle { <37.9865, 26.3006, -41.2731>, <36.7825, 24.9893, -41.3789>, <37.1049, 27.4443, -41.4882> }
					triangle { <37.1049, 27.4443, -41.4882>, <36.7825, 24.9893, -41.3789>, <35.8486, 25.9599, -41.4794> }
					triangle { <36.6296, 26.9025, -40.9478>, <37.9865, 26.3006, -41.2731>, <37.1049, 27.4443, -41.4882> }
					triangle { <36.7825, 24.9893, -41.3789>, <35.7959, 24.1616, -41.6006>, <35.8486, 25.9599, -41.4794> }
					triangle { <35.7959, 24.1616, -41.6006>, <35.02261, 24.9801, -41.5785>, <35.8486, 25.9599, -41.4794> }
					triangle { <35.7959, 24.1616, -41.6006>, <34.8554, 23.9092, -41.781>, <35.02261, 24.9801, -41.5785> }
					triangle { <36.6296, 26.9025, -40.9478>, <37.1049, 27.4443, -41.4882>, <36.2261, 27.8639, -41.07434> }
					triangle { <37.1049, 27.4443, -41.4882>, <36.3318, 27.9764, -41.4136>, <36.2261, 27.8639, -41.07434> }
					triangle { <37.1049, 27.4443, -41.4882>, <35.8486, 25.9599, -41.4794>, <36.3318, 27.9764, -41.4136> }
					triangle { <35.8486, 25.9599, -41.4794>, <34.3803, 25.6764, -41.2448>, <36.3318, 27.9764, -41.4136> }
					triangle { <35.8486, 25.9599, -41.4794>, <35.02261, 24.9801, -41.5785>, <34.3803, 25.6764, -41.2448> }
					triangle { <35.02261, 24.9801, -41.5785>, <33.952, 25.1602, -41.5168>, <34.3803, 25.6764, -41.2448> }
					triangle { <34.8554, 23.9092, -41.781>, <34.05119, 24.04986, -41.936>, <35.02261, 24.9801, -41.5785> }
					triangle { <35.02261, 24.9801, -41.5785>, <34.05119, 24.04986, -41.936>, <33.952, 25.1602, -41.5168> }
					triangle { <37.3293, 29.1805, -40.7278>, <37.843, 27.9409, -40.7166>, <36.6296, 26.9025, -40.9478> }
					triangle { <37.843, 27.9409, -40.7166>, <38.03046, 26.8875, -40.8519>, <36.6296, 26.9025, -40.9478> }
					triangle { <38.03046, 26.8875, -40.8519>, <37.9865, 26.3006, -41.2731>, <36.6296, 26.9025, -40.9478> }
					triangle { <33.952, 25.1602, -41.5168>, <34.05119, 24.04986, -41.936>, <33.6239, 24.7556, -41.9744> }
					triangle { <36.2261, 27.8639, -41.07434>, <35.2073, 28.1061, -40.9922>, <37.3293, 29.1805, -40.7278> }
					triangle { <35.6826, 28.6478, -41.5326>, <33.3974, 27.8538, -41.4845>, <34.5206, 29.244, -41.345> }
					triangle { <34.4262, 27.1634, -41.5237>, <33.3974, 27.8538, -41.4845>, <35.6826, 28.6478, -41.5326> }
					triangle { <35.6826, 28.6478, -41.5326>, <34.5206, 29.244, -41.345>, <35.2073, 28.1061, -40.9922> }
					triangle { <34.4262, 27.1634, -41.5237>, <32.7809, 26.6547, -41.7222>, <33.3974, 27.8538, -41.4845> }
					triangle { <34.4262, 27.1634, -41.5237>, <33.6002, 26.1837, -41.6229>, <32.7809, 26.6547, -41.7222> }
					triangle { <33.6002, 26.1837, -41.6229>, <32.6033, 25.8626, -41.86>, <32.7809, 26.6547, -41.7222> }
					triangle { <36.2261, 27.8639, -41.07434>, <35.6826, 28.6478, -41.5326>, <35.2073, 28.1061, -40.9922> }
					triangle { <36.2261, 27.8639, -41.07434>, <36.3318, 27.9764, -41.4136>, <35.6826, 28.6478, -41.5326> }
					triangle { <36.3318, 27.9764, -41.4136>, <34.4262, 27.1634, -41.5237>, <35.6826, 28.6478, -41.5326> }
					triangle { <36.3318, 27.9764, -41.4136>, <34.3803, 25.6764, -41.2448>, <34.4262, 27.1634, -41.5237> }
					triangle { <34.3803, 25.6764, -41.2448>, <33.6002, 26.1837, -41.6229>, <34.4262, 27.1634, -41.5237> }
					triangle { <34.3803, 25.6764, -41.2448>, <33.952, 25.1602, -41.5168>, <33.6002, 26.1837, -41.6229> }
					triangle { <33.6002, 26.1837, -41.6229>, <32.8186, 25.1299, -42.01949>, <32.6033, 25.8626, -41.86> }
					triangle { <33.952, 25.1602, -41.5168>, <32.8186, 25.1299, -42.01949>, <33.6002, 26.1837, -41.6229> }
					triangle { <35.2073, 28.1061, -40.9922>, <36.2263, 29.2612, -40.7583>, <37.3293, 29.1805, -40.7278> }
					triangle { <35.2073, 28.1061, -40.9922>, <35.1004, 29.3669, -40.9433>, <36.2263, 29.2612, -40.7583> }
					triangle { <35.2073, 28.1061, -40.9922>, <34.5206, 29.244, -41.345>, <35.1004, 29.3669, -40.9433> }
					triangle { <33.6239, 24.7556, -41.9744>, <32.8186, 25.1299, -42.01949>, <33.952, 25.1602, -41.5168> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <37.3293, 29.1805, -40.7278>, <34.9748, 29.05728, -41.138>, <35.7776, 29.6987, -41.3556> }
					triangle { <34.8398, 27.5439, -41.1105>, <33.2416, 28.2141, -41.5314>, <35.6796, 28.6603, -41.5345> }
					triangle { <35.6796, 28.6603, -41.5345>, <33.2416, 28.2141, -41.5314>, <33.8912, 29.352, -41.8593> }
					triangle { <34.9748, 29.05728, -41.138>, <34.8398, 27.5439, -41.1105>, <35.6796, 28.6603, -41.5345> }
					triangle { <33.2416, 28.2141, -41.5314>, <32.1783, 28.8081, -42.00477>, <33.8912, 29.352, -41.8593> }
					triangle { <32.1783, 28.8081, -42.00477>, <32.7211, 29.7803, -42.1744>, <33.8912, 29.352, -41.8593> }
					triangle { <32.1783, 28.8081, -42.00477>, <31.6715, 29.5499, -42.4217>, <32.7211, 29.7803, -42.1744> }
					triangle { <34.9748, 29.05728, -41.138>, <35.6796, 28.6603, -41.5345>, <35.7776, 29.6987, -41.3556> }
					triangle { <35.6796, 28.6603, -41.5345>, <35.9459, 29.5552, -41.6556>, <35.7776, 29.6987, -41.3556> }
					triangle { <35.6796, 28.6603, -41.5345>, <33.8912, 29.352, -41.8593>, <35.9459, 29.5552, -41.6556> }
					triangle { <33.8912, 29.352, -41.8593>, <33.16, 30.6686, -42.01041>, <35.9459, 29.5552, -41.6556> }
					triangle { <33.8912, 29.352, -41.8593>, <32.7211, 29.7803, -42.1744>, <33.16, 30.6686, -42.01041> }
					triangle { <32.7211, 29.7803, -42.1744>, <32.5648, 30.8351, -42.387>, <33.16, 30.6686, -42.01041> }
					triangle { <31.6715, 29.5499, -42.4217>, <31.5768, 30.2956, -42.776>, <32.7211, 29.7803, -42.1744> }
					triangle { <32.7211, 29.7803, -42.1744>, <31.5768, 30.2956, -42.776>, <32.5648, 30.8351, -42.387> }
					triangle { <37.3293, 29.1805, -40.7278>, <36.3055, 28.3231, -40.5958>, <34.9748, 29.05728, -41.138> }
					triangle { <36.3055, 28.3231, -40.5958>, <35.3734, 27.7886, -40.6872>, <34.9748, 29.05728, -41.138> }
					triangle { <35.3734, 27.7886, -40.6872>, <34.8398, 27.5439, -41.1105>, <34.9748, 29.05728, -41.138> }
					triangle { <32.5648, 30.8351, -42.387>, <31.5768, 30.2956, -42.776>, <32.122, 30.8999, -42.9166> }
					triangle { <35.7776, 29.6987, -41.3556>, <35.694, 30.7302, -41.5348>, <37.3293, 29.1805, -40.7278> }
					triangle { <36.3987, 30.3333, -41.9312>, <34.9532, 32.1959, -42.4756>, <36.599, 31.6327, -42.04218> }
					triangle { <34.6104, 31.02502, -42.2561>, <34.9532, 32.1959, -42.4756>, <36.3987, 30.3333, -41.9312> }
					triangle { <36.3987, 30.3333, -41.9312>, <36.599, 31.6327, -42.04218>, <35.694, 30.7302, -41.5348> }
					triangle { <34.6104, 31.02502, -42.2561>, <33.6499, 32.3297, -42.8728>, <34.9532, 32.1959, -42.4756> }
					triangle { <34.6104, 31.02502, -42.2561>, <33.4402, 31.4533, -42.5712>, <33.6499, 32.3297, -42.8728> }
					triangle { <33.4402, 31.4533, -42.5712>, <32.8563, 32.2117, -43.05797>, <33.6499, 32.3297, -42.8728> }
					triangle { <35.7776, 29.6987, -41.3556>, <36.3987, 30.3333, -41.9312>, <35.694, 30.7302, -41.5348> }
					triangle { <35.7776, 29.6987, -41.3556>, <35.9459, 29.5552, -41.6556>, <36.3987, 30.3333, -41.9312> }
					triangle { <35.9459, 29.5552, -41.6556>, <34.6104, 31.02502, -42.2561>, <36.3987, 30.3333, -41.9312> }
					triangle { <35.9459, 29.5552, -41.6556>, <33.16, 30.6686, -42.01041>, <34.6104, 31.02502, -42.2561> }
					triangle { <33.16, 30.6686, -42.01041>, <33.4402, 31.4533, -42.5712>, <34.6104, 31.02502, -42.2561> }
					triangle { <33.16, 30.6686, -42.01041>, <32.5648, 30.8351, -42.387>, <33.4402, 31.4533, -42.5712> }
					triangle { <33.4402, 31.4533, -42.5712>, <32.2392, 31.7461, -43.163>, <32.8563, 32.2117, -43.05797> }
					triangle { <32.5648, 30.8351, -42.387>, <32.2392, 31.7461, -43.163>, <33.4402, 31.4533, -42.5712> }
					triangle { <35.694, 30.7302, -41.5348>, <37.07696, 30.2119, -41.03873>, <37.3293, 29.1805, -40.7278> }
					triangle { <35.694, 30.7302, -41.5348>, <36.8549, 31.235, -41.5045>, <37.07696, 30.2119, -41.03873> }
					triangle { <35.694, 30.7302, -41.5348>, <36.599, 31.6327, -42.04218>, <36.8549, 31.235, -41.5045> }
					triangle { <32.122, 30.8999, -42.9166>, <32.2392, 31.7461, -43.163>, <32.5648, 30.8351, -42.387> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				}
			}
		union { // inflor. internode
			cylinder { <8.4029, 23.1267, 2.1282>, <8.7405, 23.9578, 2.2011>, 0.8 }
			cylinder { <8.7405, 23.9578, 2.2011>, <9.07808, 24.7889, 2.274>, 0.8 }
			cylinder { <9.07808, 24.7889, 2.274>, <9.4156, 25.62, 2.3469>, 0.8 }
			cylinder { <9.4156, 25.62, 2.3469>, <9.7532, 26.4511, 2.4198>, 0.8 }
			cylinder { <9.7532, 26.4511, 2.4198>, <10.09078, 27.2822, 2.4928>, 0.8 }
			cylinder { <10.09078, 27.2822, 2.4928>, <10.4283, 28.1133, 2.5657>, 0.8 }
			cylinder { <10.4283, 28.1133, 2.5657>, <10.7659, 28.9444, 2.6386>, 0.8 }
			cylinder { <10.7659, 28.9444, 2.6386>, <11.1034, 29.7755, 2.7115>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // inflor. internode
			cylinder { <11.1034, 29.7755, 2.7115>, <10.5445, 30.4802, 2.7428>, 0.8 }
			cylinder { <10.5445, 30.4802, 2.7428>, <9.9855, 31.1849, 2.774>, 0.8 }
			cylinder { <9.9855, 31.1849, 2.774>, <9.4265, 31.8896, 2.8053>, 0.8 }
			cylinder { <9.4265, 31.8896, 2.8053>, <8.8675, 32.5942, 2.8366>, 0.8 }
			cylinder { <8.8675, 32.5942, 2.8366>, <8.3086, 33.2989, 2.8678>, 0.8 }
			cylinder { <8.3086, 33.2989, 2.8678>, <7.7496, 34.00363, 2.8991>, 0.8 }
			cylinder { <7.7496, 34.00363, 2.8991>, <7.1906, 34.7083, 2.9304>, 0.8 }
			cylinder { <7.1906, 34.7083, 2.9304>, <6.6316, 35.4129, 2.9616>, 0.8 }
			pigment { color rgb <0.46, 0.68, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <6.6316, 35.4129, 2.9616>, <4.282, 39.09309, 3.5815>, 0.8 }
				cylinder { <4.282, 39.09309, 3.5815>, <2.3726, 42.9207, 4.6546>, 0.8 }
				cylinder { <2.3726, 42.9207, 4.6546>, <0.9448, 46.813, 6.1577>, 0.8 }
				cylinder { <0.9448, 46.813, 6.1577>, <0.02943, 50.6857, 8.05841>, 0.8 }
				cylinder { <0.02943, 50.6857, 8.05841>, <-0.3536, 54.4549, 10.3153>, 0.8 }
				cylinder { <-0.3536, 54.4549, 10.3153>, <-0.1962, 58.03925, 12.8798>, 0.8 }
				cylinder { <-0.1962, 58.03925, 12.8798>, <0.4984, 61.3609, 15.6962>, 0.8 }
				cylinder { <0.4984, 61.3609, 15.6962>, <1.7151, 64.348, 18.7036>, 0.8 }
				pigment { color rgb <0.37, 0.71, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <1.7151, 64.348, 18.7036>, <3.2139, 66.1054, 17.4849>, <2.173, 66.04984, 17.9614> }
					triangle { <4.6885, 65.4852, 17.922>, <5.01872, 67.1279, 16.9321>, <3.201, 65.7781, 18.4117> }
					triangle { <3.201, 65.7781, 18.4117>, <5.01872, 67.1279, 16.9321>, <3.6146, 67.4787, 17.2114> }
					triangle { <3.2139, 66.1054, 17.4849>, <4.6885, 65.4852, 17.922>, <3.201, 65.7781, 18.4117> }
					triangle { <5.01872, 67.1279, 16.9321>, <5.1145, 68.4351, 16.3704>, <3.6146, 67.4787, 17.2114> }
					triangle { <5.1145, 68.4351, 16.3704>, <3.9146, 68.6585, 16.5147>, <3.6146, 67.4787, 17.2114> }
					triangle { <5.1145, 68.4351, 16.3704>, <4.7491, 69.4115, 16.08533>, <3.9146, 68.6585, 16.5147> }
					triangle { <3.2139, 66.1054, 17.4849>, <3.201, 65.7781, 18.4117>, <2.173, 66.04984, 17.9614> }
					triangle { <3.201, 65.7781, 18.4117>, <2.2286, 66.1058, 18.3604>, <2.173, 66.04984, 17.9614> }
					triangle { <3.201, 65.7781, 18.4117>, <3.6146, 67.4787, 17.2114>, <2.2286, 66.1058, 18.3604> }
					triangle { <3.6146, 67.4787, 17.2114>, <2.8296, 68.6562, 16.3595>, <2.2286, 66.1058, 18.3604> }
					triangle { <3.6146, 67.4787, 17.2114>, <3.9146, 68.6585, 16.5147>, <2.8296, 68.6562, 16.3595> }
					triangle { <3.9146, 68.6585, 16.5147>, <3.04411, 69.3977, 16.1923>, <2.8296, 68.6562, 16.3595> }
					triangle { <4.7491, 69.4115, 16.08533>, <4.1383, 70.07929, 16.02702>, <3.9146, 68.6585, 16.5147> }
					triangle { <3.9146, 68.6585, 16.5147>, <4.1383, 70.07929, 16.02702>, <3.04411, 69.3977, 16.1923> }
					triangle { <1.7151, 64.348, 18.7036>, <3.08888, 64.5119, 18.2236>, <3.2139, 66.1054, 17.4849> }
					triangle { <3.08888, 64.5119, 18.2236>, <4.1263, 64.9336, 17.8622>, <3.2139, 66.1054, 17.4849> }
					triangle { <4.1263, 64.9336, 17.8622>, <4.6885, 65.4852, 17.922>, <3.2139, 66.1054, 17.4849> }
					triangle { <3.04411, 69.3977, 16.1923>, <4.1383, 70.07929, 16.02702>, <3.275, 70.1124, 16.2837> }
					triangle { <2.173, 66.04984, 17.9614>, <1.2799, 66.7066, 17.6703>, <1.7151, 64.348, 18.7036> }
					triangle { <1.2669, 66.3793, 18.5971>, <0.4155, 68.5587, 17.3733>, <-0.04188, 66.9245, 18.3465> }
					triangle { <1.6805, 68.07993, 17.3968>, <0.4155, 68.5587, 17.3733>, <1.2669, 66.3793, 18.5971> }
					triangle { <1.2669, 66.3793, 18.5971>, <-0.04188, 66.9245, 18.3465>, <1.2799, 66.7066, 17.6703> }
					triangle { <1.6805, 68.07993, 17.3968>, <1.06989, 69.7525, 16.7579>, <0.4155, 68.5587, 17.3733> }
					triangle { <1.6805, 68.07993, 17.3968>, <1.9805, 69.2597, 16.7>, <1.06989, 69.7525, 16.7579> }
					triangle { <1.9805, 69.2597, 16.7>, <1.6488, 70.346, 16.4114>, <1.06989, 69.7525, 16.7579> }
					triangle { <2.173, 66.04984, 17.9614>, <1.2669, 66.3793, 18.5971>, <1.2799, 66.7066, 17.6703> }
					triangle { <2.173, 66.04984, 17.9614>, <2.2286, 66.1058, 18.3604>, <1.2669, 66.3793, 18.5971> }
					triangle { <2.2286, 66.1058, 18.3604>, <1.6805, 68.07993, 17.3968>, <1.2669, 66.3793, 18.5971> }
					triangle { <2.2286, 66.1058, 18.3604>, <2.8296, 68.6562, 16.3595>, <1.6805, 68.07993, 17.3968> }
					triangle { <2.8296, 68.6562, 16.3595>, <1.9805, 69.2597, 16.7>, <1.6805, 68.07993, 17.3968> }
					triangle { <2.8296, 68.6562, 16.3595>, <3.04411, 69.3977, 16.1923>, <1.9805, 69.2597, 16.7> }
					triangle { <1.9805, 69.2597, 16.7>, <2.4419, 70.6084, 16.2473>, <1.6488, 70.346, 16.4114> }
					triangle { <3.04411, 69.3977, 16.1923>, <2.4419, 70.6084, 16.2473>, <1.9805, 69.2597, 16.7> }
					triangle { <1.2799, 66.7066, 17.6703>, <0.9283, 65.2126, 18.4017>, <1.7151, 64.348, 18.7036> }
					triangle { <1.2799, 66.7066, 17.6703>, <0.1421, 66.1721, 18.244>, <0.9283, 65.2126, 18.4017> }
					triangle { <1.2799, 66.7066, 17.6703>, <-0.04188, 66.9245, 18.3465>, <0.1421, 66.1721, 18.244> }
					triangle { <3.275, 70.1124, 16.2837>, <2.4419, 70.6084, 16.2473>, <3.04411, 69.3977, 16.1923> }
					pigment { color rgb <0.99, 0.99, 0.0> }}
				mesh { // flower petal
					triangle { <1.7151, 64.348, 18.7036>, <0.4098, 66.5484, 18.1795>, <0.4257, 65.732, 18.9839> }
					triangle { <1.609, 67.3265, 17.339>, <0.1123, 68.5608, 17.4939>, <1.2908, 66.3836, 18.5831> }
					triangle { <1.2908, 66.3836, 18.5831>, <0.1123, 68.5608, 17.4939>, <-0.3678, 67.7074, 18.5955> }
					triangle { <0.4098, 66.5484, 18.1795>, <1.609, 67.3265, 17.339>, <1.2908, 66.3836, 18.5831> }
					triangle { <0.1123, 68.5608, 17.4939>, <-0.9651, 69.4259, 17.846>, <-0.3678, 67.7074, 18.5955> }
					triangle { <-0.9651, 69.4259, 17.846>, <-1.4088, 68.6433, 18.6835>, <-0.3678, 67.7074, 18.5955> }
					triangle { <-0.9651, 69.4259, 17.846>, <-1.826, 69.7404, 18.4188>, <-1.4088, 68.6433, 18.6835> }
					triangle { <0.4098, 66.5484, 18.1795>, <1.2908, 66.3836, 18.5831>, <0.4257, 65.732, 18.9839> }
					triangle { <1.2908, 66.3836, 18.5831>, <0.7252, 65.8324, 19.2402>, <0.4257, 65.732, 18.9839> }
					triangle { <1.2908, 66.3836, 18.5831>, <-0.3678, 67.7074, 18.5955>, <0.7252, 65.8324, 19.2402> }
					triangle { <-0.3678, 67.7074, 18.5955>, <-1.9244, 67.7916, 19.1417>, <0.7252, 65.8324, 19.2402> }
					triangle { <-0.3678, 67.7074, 18.5955>, <-1.4088, 68.6433, 18.6835>, <-1.9244, 67.7916, 19.1417> }
					triangle { <-1.4088, 68.6433, 18.6835>, <-2.3601, 68.4149, 19.355>, <-1.9244, 67.7916, 19.1417> }
					triangle { <-1.826, 69.7404, 18.4188>, <-2.4413, 69.6831, 19.08252>, <-1.4088, 68.6433, 18.6835> }
					triangle { <-1.4088, 68.6433, 18.6835>, <-2.4413, 69.6831, 19.08252>, <-2.3601, 68.4149, 19.355> }
					triangle { <1.7151, 64.348, 18.7036>, <1.762, 65.4903, 17.7886>, <0.4098, 66.5484, 18.1795> }
					triangle { <1.762, 65.4903, 17.7886>, <1.6435, 66.5404, 17.2707>, <0.4098, 66.5484, 18.1795> }
					triangle { <1.6435, 66.5404, 17.2707>, <1.609, 67.3265, 17.339>, <0.4098, 66.5484, 18.1795> }
					triangle { <-2.3601, 68.4149, 19.355>, <-2.4413, 69.6831, 19.08252>, <-2.5762, 69.04832, 19.7079> }
					triangle { <0.4257, 65.732, 18.9839>, <-0.4669, 65.436, 19.6391>, <1.7151, 64.348, 18.7036> }
					triangle { <0.4141, 65.2713, 20.04276>, <-1.9743, 65.9133, 20.9678>, <-0.5414, 64.5848, 20.8726> }
					triangle { <-1.2446, 66.595, 20.05519>, <-1.9743, 65.9133, 20.9678>, <0.4141, 65.2713, 20.042