// Persistence of Vision Ray Tracer Scene Description File
// Vers: 3.0
// Date: 06/30/99
// Auth: Bob Franke
// email: bobfranke@halcyon.com

#version 3.0;

#include "colors.inc"
#include "textures.inc"
#declare useFlare=true


global_settings{
  assumed_gamma 2.2
}

// ----------------------------------------
camera{
  location  <-26811, 12000, 22497>
  direction 1.0*z
  right     4/3*x
  look_at   <-5000,7000,0>
}


#declare Ice = texture {
  pigment {
    bozo
    turbulence 0.1
    color_map {
      [0.00 0.90 color rgbf <1.00, 1.00, 1.00, 0.0>*.8
                 color rgbf <1.00, 1.00, 1.00, 0.1>*.8]
      [0.90 0.99 color rgbf <1.00, 1.00, 1.00, 0.1>*.8
                 color rgbf <0.95, 0.95, 1.00, 0.1>*.8]
      [0.99 1.00 color rgbf <0.95, 0.95, 1.00, 0.1>*.8
                 color rgbf <1.00, 1.00, 1.00, 0.0>*.8]
    }
  }
  finish {
    ambient 0.3
    refraction 1.0
    ior 1.5
    reflection 0.05
  }
}

#declare f=0.5;
#declare Mountains_Snow = texture {
  pigment {
    bozo
    turbulence 0.15
    color_map {
      [0.00 0.29 color rgb <0.79, 0.71, 0.66>*.5
                 color rgb <0.83, 0.69, 0.62>*.5]
      [0.29 0.31 color rgb <0.83, 0.69, 0.62>*.5
                 color rgb <0.76, 0.66, 0.61>*.5]
      [0.31 0.43 color rgb <0.76, 0.66, 0.61>*.5
                 color rgb <0.88, 0.76, 0.73>*.5]
      [0.43 0.64 color rgb <0.88, 0.76, 0.73>*.5
                 color rgb <0.70, 0.60, 0.55>*.5]
      [0.64 0.69 color rgb <0.70, 0.60, 0.55>*.5
                 color rgb <0.87, 0.71, 0.66>*.5]
      [0.69 1.00 color rgb <0.87, 0.71, 0.66>*.5
                 color rgb <0.79, 0.71, 0.66>*.5]
    }
  }
  normal {bumps 0.2 scale <1, 0.2*5, 1>}
}


texture {
  pigment {
    marble
    turbulence .15
    color_map {
      [0.00 0.20 color rgbf <0.79*f, 0.71*f, 0.66*f, 0.5>
                 color rgbf <0.53*f, 0.39*f, 0.32*f, 0.5>]
      [0.20 0.40 color rgbf <0.53*f, 0.39*f, 0.32*f, 0.5>
                 color rgbf <0.76*f, 0.66*f, 0.61*f, 0.5>]
      [0.40 0.60 color rgbf <0.76*f, 0.66*f, 0.61*f, 0.5>
                 color rgbf <0.88*f, 0.76*f, 0.73*f, 0.5>]
      [0.60 0.80 color rgbf <0.88*f, 0.76*f, 0.73*f, 0.5>
                 color rgbf <0.50*f, 0.40*f, 0.25*f, 0.5>]
      [0.80 1.00 color rgbf <0.50*f, 0.40*f, 0.25*f, 0.5>
                 color rgbf <0.79*f, 0.71*f, 0.66*f, 0.5>]
    }
  }
  normal {wrinkles 0.9}
  scale 10
  rotate <0,0,90>
}  

texture {
  pigment {
    bozo
    turbulence 0.7
    color_map {
      [0.0 0.5 color rgbf <1.00, 1.00, 1.00, 1.0>*.6
               color rgbf <1.00, 1.00, 1.00, 1.0>*.6]
      [0.5 0.6 color rgbf <1.00, 1.00, 1.00, 0.2>*.6
               color rgbf <1.00, 1.00, 1.00, 0.2>*.6]
      [0.6 1.0 color rgbf <1.00, 1.00, 1.00, 0.0>*.6
               color rgbf <1.00, 1.00, 1.00, 0.0>*.6]
    }
  }
  scale <0.3 0.3 0.3>
}

#declare rocks2=
texture {
  pigment {
    bozo
    turbulence 0.7
    color_map {
      [0.00 0.29 color rgb <0.79, 0.71, 0.66>*.5
                 color rgb <0.83, 0.69, 0.62>*.5]
      [0.29 0.31 color rgb <0.83, 0.69, 0.62>*.5
                 color rgb <0.76, 0.66, 0.61>*.5]
      [0.31 0.43 color rgb <0.76, 0.66, 0.61>*.5
                 color rgb <0.88, 0.76, 0.73>*.5]
      [0.43 0.64 color rgb <0.88, 0.76, 0.73>*.5
                 color rgb <0.70, 0.60, 0.55>*.5]
      [0.64 0.69 color rgb <0.70, 0.60, 0.55>*.5
                 color rgb <0.87, 0.71, 0.66>*.5]
      [0.69 1.00 color rgb <0.87, 0.71, 0.66>*.5
                 color rgb <0.79, 0.71, 0.66>*.5]
    }
    scale 50
  }
  normal{
    bumps .4
    scale<1,1000,1>
 }
}


#declare trees=
 texture{
    pigment{
      bozo
      color_map{
        [0.4 color rgb <0.000, 0.3, 0.18>*.85]
        [0.8 color rgb <0.000, 0.3, 0.18>]
      }
      scale 50
    }
    normal{
      bumps .4
      scale<1,10000,1>
    }
  }



#declare Rocks =
texture{
  pigment{
    crackle
    color_map {
      [0 color rgb <0.42, 0.33, 0.392>]
      [1 color rgb <0.42, 0.33, 0.392>*1.25]
    }
    turbulence 0.4
    scale <1000,100,1000>
  }
  finish {roughness 0.15 crand 0.3}
  normal {bumps 0.25 scale<1,10,1>}
}

#declare snow=
  texture{
    pigment{White*.8}
  }


#declare wing=

union{
  difference{
    cylinder{<2,0,0>,<20,0,0>,2 scale<1,.2,1> texture{ Soft_Silver }}
    box{<-5,-10,-3>, <25,0,3>}
    box{<5,-3,.5>, <18,3,2>}
    cylinder{<10,.5,-1.25>,<10,0,-1.25>,1.75/12}
    cylinder{<10,.5,.25>,<10,-5,.25>,1.75/12 }
    union{
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,0+45,0>}
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,90+45,0>}
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,180+45,0>}
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,270+45,0>}
      translate <10,0,.25>
    }
    texture{ Soft_Silver }
  }

  box{<5,0,0>, <17.95,-.25/12,1.25>
    rotate<0,0,0>
    translate<0,.4,.55>
    texture{ Soft_Silver }
  }


  cylinder{<2,3,0>,<10.275,.3,.25>,0.25/12  texture{ Chrome_Metal }}
  cylinder{<2,3,0>,<10,.3,-1.25>,0.25/12  texture{ Chrome_Metal }}

  difference{
    cylinder{<10,.4,-1.25>,<10,0,-1.25>,1.75/12  }
    cylinder{<2,0,0>,<20,0,0>,2 scale<1,.2,1> inverse}
    translate<0,-0.03/12,0>
    texture{Aluminum}
  }

  difference{
     cylinder{<10,.5,.25>,<10,0,.25>,1.75/12 }
    cylinder{<2,0,0>,<20,0,0>,2 scale<1,.2,1> inverse}
    translate<0,-0.03/12,0>
    texture{Aluminum}
  }

  difference{
    union{
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,0+45,0>}
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,90+45,0>}
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,180+45,0>}
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,270+45,0>}
      translate <10,0,.25>
    }
    cylinder{<2,0,0>,<20,0,0>,2 scale<1,.2,1> inverse}
    pigment{White*.4}
    translate<0,-.015/12,0>
  }


  difference{
    union{
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,0+45,0>}
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,90+45,0>}
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,180+45,0>}
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,270+45,0>}
      translate <10.0,0,-1.25>
    }
    cylinder{<2,0,0>,<20,0,0>,2 scale<1,.2,1> inverse}
    pigment{White*.4}
    translate<0,-.015/12,0>
  }
  sphere{<0,0,0>, 2.75 scale<.2,.2,1> translate<20,0,0> texture{ Soft_Silver }}
}



object{wing
  rotate<0,-8,10>
  translate <-35000, 12000-6, 0>
rotate<0,40,0>
}

light_source{
  0*x // light's position (translated below)
  color White*2  // light's color
  translate <100000, 300000, 100000>*1000
}

fog{
  color rgbft <.4, 0.4,.7,0, 0>
  fog_type 2
  fog_alt 10000
  fog_offset -30000
  distance 15000
}

// make the landscape
union{ 
  height_field{
    tga
    "yak-w.tga"
    smooth 
    translate<-.5,0,-.5>
    rotate<0,-90,0>
    scale<250000,210000,250000>
    translate<65000,0,-87430>
  }

  height_field{
    tga
    "wen-w.tga"
    translate<-.5,0,-.5>
    rotate<0,-90,0>
    translate<0,0,1>
    scale<250000,210000,250000>
    translate<65000,0,-87430>
  }


  height_field{
    tga
    "dall-w.tga"
    translate<-.5,0,-.5>
    rotate<0,-90,0>
    translate<0,0,-1>
    scale<250000,210000,250000>
    translate<65000,0,-87430>
  }

  texture {
    gradient y     
    texture_map {
      [0.0 trees ]
      [0.47 trees ]   
      [0.49 trees ]   
      [0.495 rocks2 ]    
      [0.505 rocks2 ]   
      [0.515 Mountains_Snow scale<20,1,20>]
      [0.52 Mountains_Snow scale<20,1,20>] 
      [0.54 Ice]
      [1.0  Ice]
    }
 	  scale<50,28000,50>
   	translate<0,-6800,0>
  }
}


sky_sphere{pigment{color blue 0.15}}


#declare ufo=
union{
  difference{
    sphere { <0.0.0>,100}
    box{<35,250,250>,<150,-250,-250>}
    cylinder{<50,250,0>, <50,-250,0>, 100}
    texture {New_Penny}
  }

  #declare yy=-70;
  #while (yy < 60)
    box{<-100.5,10,-10>,<-90,-10,10> rotate<0,yy,-30> pigment{Black}}
    #declare yy = yy + 20;
  #end
  scale<1.3,.15,1>
}


#declare R1 = seed(345);
#declare ufoFormation=
union{
  object{ufo scale 20  rotate<-20-rand(R1)*20,160,0> }
  object{ufo scale 20  rotate<-20-rand(R1)*20,160,0> translate<(4000*1)+rand(R1)*2000,rand(R1)*500,(700*1)+rand(R1)*500>}
  object{ufo scale 20  rotate<-20-rand(R1)*20,160,0> translate<(4000*2)+rand(R1)*2000,rand(R1)*500,(700*2)+rand(R1)*500>}
  object{ufo scale 20  rotate<-20-rand(R1)*20,160,0> translate<(4000*3)+rand(R1)*2000,rand(R1)*500,(700*3)+rand(R1)*500>}
  object{ufo scale 20  rotate<-20-rand(R1)*20,160,0> translate<(4000*4)+rand(R1)*2000,rand(R1)*500,(700*4)+rand(R1)*500>}
  object{ufo scale 20  rotate<-20-rand(R1)*20,160,0> translate<(4000*5)+rand(R1)*2000,rand(R1)*500,(700*5)+rand(R1)*500>}

  #declare rr = -20-rand(R1)*20;
  #declare xx = rand(R1)*2000;
  #declare yy = rand(R1)*500;
  #declare zz = rand(R1)*500;

  object{ufo scale 20  rotate<rr,160,0> translate<(4000*6)+xx,yy,(700*6)+zz>}
  object{ufo scale 20  rotate<-20-rand(R1)*20,160,0> translate<(4000*7)+rand(R1)*2000,rand(R1)*500,(700*7)+rand(R1)*500>}
  object{ufo scale 20  rotate<-20-rand(R1)*20,160,0> translate<(4000*8)+rand(R1)*2000,rand(R1)*500,(700*8)+rand(R1)*500>}
}

object{ufoFormation rotate<0,0,10> translate <10000*2,15000,-40000*2>}

#if (useFlare)
  #declare cam_loc = <-26811, 12000, 22497>
  #declare light_loc = <20000+24000+xx,19000+yy,-80000+7000>
  #declare lookat = <-5000,7000,0>
  #declare sky_vect = y
  #declare flare_type = "SmallStar"
  #declare flare_type = "35mm"
  #include "lnsflare.inc"
#end
