#include "colors.inc"
#include "shapes2.inc"
#include "metals.inc"
#include "stones.inc"


camera {
  location <0,0,-10>
  look_at <0,0,0>
}

light_source{<-200,10,-400> color rgb<.5,.5,.5>}
light_source{<500,200,2400> color rgb<1,1,1>}

background{color rgb<0.9,0.4,0.4>}

#declare SkyRadius = 80

sphere
{
   <0,0,0>, SkyRadius
   pigment
   {
      bozo
      turbulence 0.6
         octaves 6
         omega 0.7
         lambda 2.2
      color_map
      {
         [0.0 0.2 color rgb <0.00, 0.00, 0.00>
                  color rgb <0.25, 0.25, 0.25>]
         [0.2 0.4 color rgb <0.25, 0.25, 0.25>
                  color rgb <0.75, 0.75, 0.75>]
         [0.4 0.6 color rgb <0.75, 0.75, 0.75>
                  color rgbt <1, 1, 1, 1>]
         [0.6 1.0 color rgbt <1, 1, 1, 1>
                  color rgbt <1, 1, 1, 1>]
      }
      scale <0.2*SkyRadius, 2*SkyRadius, 0.2*SkyRadius>
   }
   hollow
   scale <30, 1, 40>
   rotate y*70
   //rotate x*-20
  // clipped_by { box { <-3000,10,-40000> <3000,1000,40000> } }
}

plane {y, -3
  texture {
    hexagon
      texture {T_Stone26
        finish {
          ambient 0
          diffuse 1
          specular 1
          roughness .001
          ior 1.33
          reflection .3
        }
  },
      texture {T_Stone8
        finish {
          ambient 0
          diffuse 1
          specular 1
          roughness .001
          ior 1.33
          reflection .3
        }
      },
      texture {T_Stone26
        finish {
          ambient 0
          diffuse 1
          specular 1
          roughness .001
          ior 1.33
          reflection .3
        }
      }

  }

}

#declare conething =
union {
  cone{<0,0,0>,1 <0,3,0>,0 pigment{Green}}
  clipped_by {sphere{<0,0,0>,1} translate <1,1,0>}
}


#declare shape1 =
  julia_fractal {
    <-0.083,0.0,-0.83,-0.025>
    quaternion
    sqr
    max_iteration 12
    precision 30
  }

#declare shape2=
  julia_fractal {
    <-.08,0,-1,-.045>
    quaternion
    sqr
    max_iteration 8
    precision 15
  }

#declare shape3 =
union {
  object {
    shape1
      texture {T_Chrome_5E}
      translate <0,0,0>
      scale <4,2,1>
      clipped_by{plane{x,-1}}
      rotate z*-90

  }

  object {
    shape2
      texture {T_Gold_5E}
      scale <5,1,1>
      clipped_by{plane{x,0}}
      rotate z*-90
      translate <0,0,0>
  }
}

#declare other_shape =
julia_fractal {
    <-.08,0,1.1,-.025>
    quaternion
    sqr
    max_iteration 6
    precision 15
  }

object {
  other_shape
  texture{T_Brass_5E}
  scale<9,3,3>
  clipped_by{plane{x,0}}
  rotate x*90
  rotate y*-90
  rotate x*-20
  translate <-15,10,20>

}

object {
  other_shape
  texture{T_Brass_5E}
  scale<9,3,3>
  clipped_by{plane{x,0}}
  rotate x*90
  rotate y*-90
  rotate x*-20
  translate <15,10,20>

}


object {
  shape3
  translate <0,-4,0>
  scale .8
 // rotate y*90
}


object {
shape3
rotate y*90
translate <10,-3,20>
}

object {
shape3
rotate y*-90
translate <-10,-3,20>
}

#declare foothang =
  union {
    sphere {<0,0,0>,2 scale<3,1,1>}
    sphere {<0,1,0>,2 }
    sphere {<-3,0,0>,2 }
    sphere {<3,0,0>,2 }
    cylinder{<-20,0,0><20,0,0>,.2}
  }
  
#declare foothang_grp =
  union {
    object {
      foothang
      rotate z*45
      rotate x*-45
    }   
    object {
      foothang
      rotate z*-45
      rotate x*45
    }
    object {
     foothang
    }
  }
  
object {
  foothang_grp
  scale .5
  translate<0,12,20>
  texture{T_Chrome_5E}
}

sphere { <0,0,10>,5
  pigment {White filter 1}
    finish {
      ambient 0
      diffuse 0
      reflection .3
      refraction 1
      ior 1.33
      specular 1
      roughness .001
    }
}

sphere {<0,0,0>2.5
  pigment {
    image_map {
       gif "earth"
       map_type 1
    }
  }
  rotate y*-20
  translate<0,0,10>
}
