/***************************************************************************
  Bugs7a   Bug Collection
****************************************************************************/


#include "colors.inc"   
#include "textures.inc" 
#include "stones.inc"

//Scene Control
#declare SmoothOn = 1 ;
#declare PlaqueOn = 1;
#declare TableOn = 1 ;
#declare CorkBoardOn = 1 ;
#declare Bug3On = 1 ;
#declare MothOn = 1 ;
#declare BeatleOn = 1 ;
#declare MandelBugOn = 1 ;
#declare Buta7On = 1 ;

camera {
   location <0, 100, -50>  //<--- Final View
   //location <0,25,-50>  //<--- Low View
   direction <0, 0, 2>
   up <0, 1, 0>
   right <1.33333, 0, 0>
   look_at <0,0,0>  //<--- Final View
   //look_at <0,10,0>  //<--- Low View 
}

light_source { <50, 150, -100> color White }  //Camera Light
light_source { <-100, 100, -100> color White }

//Mounting Pin
#declare Pin = union {
                      cylinder { <0,0,0>, <0,15,0>, .2
                                 texture { Polished_Chrome }
                               }
                      sphere { <0,15,0>, .5
                               texture { Polished_Chrome }
                             }
                     }

//The Legs
#declare Leg = union {
                      cylinder {<0,0,0>,<.1,-.07,0>,.005 texture{pigment{color Gray50}}}
                      cylinder {<.1,-.07,0>,<.05,-.21,0>,.005 texture{pigment{color Gray50}}}
                      sphere {<.1,-.07,0>,.01 texture {pigment {color Gray40 }}}
                      sphere {<0,0,0>,.025
                              texture{pigment{color Gray30}}
                              scale <1,.3,1>
                              translate <.05,-.21,0>        
                             }
                     }       

#if (Bug3On=1)
#declare Bugs3c = union {
   height_field { gif "bugs3c.gif" water_level .015625
                 texture { pigment { image_map { gif "bugs3c.gif" interpolate 2 }
                 rotate x*90 }
                 finish {crand 0.05 reflection 0.2 diffuse 0.7 ambient 0.3}
                }
                #if (SmoothOn=1)
                  smooth   
                #end
                translate <-.5, 0, -.5>
                scale <30, 10, 30> 
                translate <-5, 10, 0>
             }
   object { Pin }
 }
 object { Bugs3c
          rotate <0,-90,0>
          translate <-14,0,11>
        }     
#end // Bug3


#if (MothOn=1)
#declare Moth = union {
   height_field { gif "bugmoth.gif" water_level .01176470
                 texture { pigment { image_map { gif "bugmoth.gif" interpolate 2 }
                 rotate x*90 }
                 finish {crand 0.05 reflection 0.2 diffuse 0.7 ambient 0.3}
                }
                #if (SmoothOn=1) smooth #end
                translate <-.5, 0, -.5>
                scale <23, 2, 23> 
                translate <-1.5, 10, 0>
                }
   object { Pin }
 }
 object { Moth
          rotate <0,-90,0>
          translate <15,0,10>
        }                 
#end  //Moth


#if (BeatleOn=1)
#declare Beatle = union {
   height_field { gif "beatle0.gif" water_level .003922
                 texture { pigment { image_map { gif "beatle15.gif" interpolate 2 }
                 rotate x*90 }
                 finish { crand 0.05 //reflection 0.3
                         diffuse 0.7 ambient 0.3}
                }
                #if (SmoothOn=1) smooth #end
                translate <-.5, 0, -.5>
                rotate <180,0,0>
                scale <20, 3, 20> 
                translate <-3, 12, 0>
                }
   object { Pin }
 }
 object { Beatle 
          rotate <0,-90,0>
          translate <-17,0,-10>
        }               
#end //Beatle




#if (MandelBugOn=1)
#declare MandelBug = union {
                       object { Leg  //Leg1l
                                translate <.190,.398,.290>
                              }                        
                       object { Leg  //Leg1r
                                rotate <0, 180, 0>
                                translate <-.190,.398,.290>
                              }                        
                       object { Leg  //Leg2l
                                translate <.175,.398,.205>
                              }                        
                       object { Leg  //Leg2r
                                rotate <0, 180, 0>
                                translate <-.175,.398,.205>
                              }                        
                       object { Leg  //Leg3l
                                translate <.180,.398,.100>
                              }                        
                       object { Leg  //Leg3r
                                rotate <0, 180, 0>
                                translate <-.180,.398,.100>
                              }                        
                       object { Leg  //Leg4l
                                translate <.170,.398,.000>
                              }                        
                       object { Leg  //Leg4r
                                rotate <0, 180, 0>
                                translate <-.170,.398,.000>
                              }                        
                       height_field { gif "bugmand.gif" water_level .05098
                                      texture { pigment { image_map { gif "bugmand.gif" interpolate 2 }
                                                          rotate x*90 }
                                                finish {crand 0.05 reflection 0.2 diffuse 0.7 ambient 0.3}
                                              }
                                      #if (SmoothOn=1) smooth #end 
                                      translate <-.5, 0, -.5>
                                      scale <.75, .1, .75> 
                                      rotate <0, -90, 0>
                                      translate <0, .3, 0>
                                    }
                      }
object { union {
                object { MandelBug
                         scale <20,20,20>
                         translate <0,5,0> }
                object { Pin }
               } 
         translate <-1, 0, -13>
       }                                      
#end //MandelBug 

        


#if (Buta7On = 1)
#declare Buta7 = union {
   height_field { gif "bug6hf07.gif" water_level .03137
                 texture { pigment { image_map { gif "buta7.gif" interpolate 2 }
                 rotate x*90 }
                 finish { crand 0.05 //reflection 0.3
                         diffuse 0.7 ambient 0.3}
                }
                #if (SmoothOn=1) smooth #end        
                translate <-.5, 0, -.5>
                scale <22, 11, 22> 
                translate <0, 10, 0>
                }
   object { Pin }
 }
 object { Buta7 
          rotate <0,-180,0>
          translate <16,0,-14>}               
#end // Buta7



// A Marble Table
#if (TableOn=1)
plane { <0,1,0>, 0
        texture { T_Stone16  scale <6 6 6>
                  finish {ambient 0.25  diffuse 0.7
                          specular 0.75  roughness 0.01
                         } 
                }
      }
#end  //Table
 


// CorkBoard
#if (CorkBoardOn=1)
box { < -32, 0, -27 >, < 32, 5, 27 >       
      texture { pigment { image_map { gif "cork.gif" interpolate 2 } }
                finish { specular 0.1 roughness 0.5 }
                rotate <90,0,0>
                scale 10                
              }   
    }
#end  //Corkboard
               

//The Plaque
#if (PlaqueOn=1)
box { <0,0,-.5>, <1,1,.5>
      texture { pigment { image_map { gif "bug7text.gif" interpolate 2 once } }
                finish { SilverFinish }
              }  
      translate <-.5,-.5,0>
      scale <30,5,1>
      rotate <90, 0, 0>
      translate < 0, 5, -23 >
    }
#end  //Plaque
                      
