#include "colors.inc"
#include "lochmon2.pov"

#declare PuffyClouds =
pigment
  {
  granite
  color_map
    {
    [0.0 color rgbt 1] 
    [0.2 color rgbt 1] 
    [0.5 color rgb <1, .7, .7>]
    [1.0 color rgb <1, .7, .7>]
    }  
  scale 3   
  }                   
  
#declare ClearPig = 
pigment
  {
  color rgbt 1
  }

#declare LightClouds = 
texture
  {
  pigment
    {      
    wrinkles
    pigment_map
      {
      [0.0 ClearPig]
      [0.45 ClearPig] 
      [1.0 PuffyClouds]
      }   
    
    }
  finish
    {
    ambient 0.6
    }
  }

      
camera
  {
  location <60, 5, 10>
  look_at  <-50, 10, -10>
  }      

light_source
{
  0*x // light's position (translated below)
  color rgb <2.0, 1.2, 0.4>  // light's color
  
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <-200, 50, -120>   // <x y z> position of light
}

sky_sphere 
  {        
  pigment {
      gradient y
      color_map {
        [0.000 0.0005 color rgb <3, 3, 2.5>
                     color rgb <2, 2, 2>]
        [0.001 0.1 color rgb <.9, 0.8, 0.6>
                     color rgb <0.3, 0.3, 1>]
      }           
      scale 2
      translate -1
    
    rotate <0, 0, -100>
    }  
    rotate <0, -25, 0>
  }

 
fog
  {
  color rgbf <1, .4, .1, 0.25>
  distance 160
  fog_type 2
  fog_offset 10
  fog_alt 7
  }       
                  
                   
plane
  {
  <0, 1, 0>, 0  
  pigment 
    {
    color rgb <.7, .7, .9>
    }       
  normal
    {
    bumps 0.25
    scale <2, 2, 3>
    }
  finish
    {
    ambient 0.1   
    reflection 0.5  
    phong 1
    phong_size 60
    }
  hollow
  }  
             
height_field
{
  tga               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "c:\\images\\lochmap.tga"     // the file name to read
  texture
  {
    pigment
    {
      image_map { tga "c:\\images\\lochcolr.tga" map_type 0 interpolate 2 once }
      rotate x*90 // lay X-Y image map down onto X-Z height field plane
    }
    normal 
    {
      bumps 1
      scale 0.25
    }
    finish
    {
      ambient 0.2
    }
    
  } 
  hollow         
  translate <-0.5, -0.5, -0.5>
  rotate <0, 270, 0>
  scale <100, 15, 170> 
  translate <-40, 6.25, -30> 
}
  
difference
  {  
                        
union
  {
  box
    {
    <-.5, 0, -.5>, <.5, 1, .5>
    scale <2.5, 4, 2.5>  
    rotate <0, 65, 0>
    translate <-45, 2, 12>
    }                        
  
  box
    {
    <-.4, 0, -.4>, <.4, 1, .4>
    scale <2.5, 1.5, 2.5>  
    rotate <0, 65, 0>
    translate <-48, 1.5, 10>
    }         
  
  box
    {
    <-.3, 0, -.3>, <.3, 1, .3>
    scale <2.5, 1.5, 2.5>  
    rotate <0, 65, 0>
    translate <-43, 1.25, 15>
    }             

  box
    {
    <-.3, 0, .3>, <-.2, 1, .2>
    scale <2.5, 1.5, 2.5>  
    rotate <0, 65, 0>
    translate <-43, 1.5, 15>
    }             
 
  box
    {
    <.3, 0, -.3>, <.2, 1, -.2>
    scale <2.5, 1.5, 2.5>  
    rotate <0, 65, 0>
    translate <-43, 1.5, 15>
    }             
  
  box
    {
    <.5, 0, .5>, <.4, 1, .4>
    scale <2.5, 1.5, 2.5>  
    rotate <0, 65, 0>
    translate <-48, 6, 12>
    }      
 
  box
    {
    <.5, 0, .5>, <.3, 1, .3>
    scale <2.5, 1.5, 2.5>  
    rotate <0, 65, 0>
    translate <-48, 5.5, 12>
    }             

  box
    {
    <.5, 0, .5>, <0, 1, -.5>
    scale <2.5, 1.5, 2.5>  
    rotate <0, 65, 0>
    translate <-48, 5.05, 12>
    }      
  
  box
    {
    <-.3, 0, .3>, <-.5, 1, .5>
    scale <2.5, 1.5, 2.5>  
    rotate <0, 65, 0>
    translate <-48, 5.5, 12>
    }    
  
  box
    {
    <.5, 0, -.5>, <.3, 1, 0>
    scale <2.5, 1.5, 2.5>  
    rotate <0, 65, 0>
    translate <-48, 5.5, 12>
    }          
    
  box
    {
    <-.2, 0, -.2>, <.2, 1, .2>
    scale <2.5, 1.5, 2.5>
    rotate <0, 65, 0>
    translate <-46, 2, 19>
    }
pigment
  {
  color rgb .8
  }         
normal
  {
  granite 0.5
  scale .25
  }         
finish
  {
  ambient 0.1
  }             

  }         

union
  {  
  box
    {
    <-.2, 0, -.6>, <-.1, 0.8, .6> 
    scale <2.5, 1.5, 2.5>
    rotate <0, 65, 0>
    translate <-45, 2.5, 12>
    }       
  
  box
    {
    <.2, 0, -.6>, <.1, 0.8, .6> 
    scale <2.5, 1.5, 2.5>
    rotate <0, 65, 0>
    translate <-45, 4, 12>
    }  
  
  box
    {
    <-.6, 0, -.1>, <.6, 0.8, 0> 
    scale <2.5, 1.5, 2.5>
    rotate <0, 65, 0>
    translate <-45, 4, 12>
    }   
    pigment
    {
    color rgb .2
    } 
  }  
}                     

#declare Monster =
object
{
LochNessMonster
scale 2.5           
rotate <0, -130, -90>
translate <25, -2, 0>
}
                  
object
{
Monster
rotate <0, -60, 0>
translate <0, 0, -25>
}                  
                  
plane
{
<0, 1, 0>, 1000
texture
{
LightClouds
scale 2000    
translate <0, 0, 2000>
}
hollow 
no_shadow
} 

