// IRTC entry 3 - Unbelievable

// development switches
#declare Detailed = 1;
#declare FillLights = 1;
#declare Media = 1;
#declare Ship = 1;
#declare Background = 1;
#declare RedCells = 1;
#declare WhiteCells = 1;

#declare R1 = seed(2637);

#include "legacy.inc"
#include "bloodcell.inc"

#declare CameraTop =
camera {
    location <0,30,0>
    look_at <0,0,0>
}

#declare CameraSide =
camera {
    location <40,0,0>
    look_at <0,0,0>
}

// port bow view
#declare Camera1 =
camera {
    location <15,4,0>
    look_at <0,0,0>
}

// port stern view
#declare Camera2 =
camera {
    location <20,6,20>
    look_at <0,0,0>
}

// port bow under view
#declare Camera3 =
camera {
    location <20,-6,-20>
    look_at <0,0,0>
}

camera {
    Camera1
}

background { <0.7,0.6,0.4> }

#if (FillLights)
#declare Bright = 1;
//light_source { <0,10,0> rgb <1,1,1> }
light_source { <10,2,-20> rgb <Bright,Bright,Bright>  shadowless }
light_source { <10,4, 20> rgb <Bright,Bright,Bright> shadowless }
//light_source { <0,-10,0> rgb <1,1,1> }
#end

#if (Ship)
Legacy(Detailed, 0.4, 0,0,2, 0,-30,0)
#end

// red blood cells
#if (RedCells)
#declare RedSize = 0.3;
#declare R2 = seed(27384);
RedCell(RedSize, 0,-4,0,    rand(R2)*360,rand(R2)*360,rand(R2)*360)
RedCell(RedSize, 0,2,6.5,   rand(R2)*360,rand(R2)*360,rand(R2)*360)
RedCell(RedSize, 0,1,-6,    rand(R2)*360,rand(R2)*360,rand(R2)*360)
RedCell(RedSize, 10,-0.2,1, rand(R2)*360,rand(R2)*360,rand(R2)*360)
RedCell(RedSize, -3,-2,3.5, rand(R2)*360,rand(R2)*360,rand(R2)*360)
RedCell(RedSize, -5,3,-7,   rand(R2)*360,rand(R2)*360,rand(R2)*360)
#declare i = 0;
#while (i < 50)
    RedCell(RedSize, (rand(R2)-0.25)*10,(rand(R2)-0.5)*15,(rand(R2)-0.5)*15, rand(R2)*360,rand(R2)*360,rand(R2)*360)
    #declare i = i + 1;
#end // #while
#end

// white blood cells
#if (WhiteCells)
WhiteCell(Detailed, 1.5, -5,6,10, 0,0,-30,R1) // above ship, upper right
WhiteCell(Detailed, 1,   0,0,8,   0,0,-20,R1) // attacking rear of ship
WhiteCell(Detailed, 1.5, 10,0,-3, 0,0,-50,R1) // foreground lower left
WhiteCell(Detailed, 1.3, 2,4,-4,  0,0,-50,R1) // upper left
WhiteCell(Detailed, 1.2, -1,-7,5, 0,0,-50,R1) // lower right
#end

#if (Background)
// blood vessel background
blob { threshold 0.5
    sphere { <0,0,0> 1, 1
        scale <50,30,100>
    }
    sphere { <0,0,0> 1, 1
        scale <5,8,30>
        rotate <5,40,0>
        translate <-15,1,-5>
    }
    sphere { <0,0,0> 1, 1
        scale <10,8,30>
        rotate <120,30,10>
        translate <-15,-9,-5>
    }
    sphere { <0,0,0> 1, 1
        scale <6,4,40>
        rotate <-5,-40,10>
        translate <-15,-6,10>
    }
    sphere { <0,0,0> 1, 1
        scale <6,4,40>
        rotate <-50,-60,-13>
        translate <-8,-21,4>
    }
    sphere { <0,0,0> 1, 1
        scale <3,4,40>
        rotate <-3,75,-13>
        translate <-15,3,4>
    }
    // negatives
    sphere { <0,0,0> 1, -1
        scale <4,12,30>
        rotate <-3,1,20>
        translate <-20,-6,-1>
    }
    sphere { <0,0,0> 1, -1
        scale <4,12,30>
        rotate <5,-13,8>
        translate <-25,6,-1>
    }
    sphere { <0,0,0> 1, -1
        scale <3,22,20>
        rotate <5,-3,-38>
        translate <-23,9,16>
    }
    sphere { <0,0,0> 1, -1
        scale <4,12,8>
        rotate <5,-13,8>
        translate <-23,5,-18>
    }
    sphere { <0,0,0> 1, -1
        scale <4,12,10>
        rotate <5,-3,8>
        translate <-15,-12,10>
    }
    sphere { <0,0,0> 1, -1
        scale <2,8,10>
        rotate <75,-3,8>
        translate <-22,3,21>
    }
    hollow
    //sturm
    texture {
        pigment { onion
            colour_map {
                [0.0 rgb <0.81,0.61,0.40>]
                [0.2 rgb <0.85,0.63,0.32>]
                [0.4 rgb <0.83,0.68,0.47>]
                [0.6 rgb <0.78,0.65,0.43>]
                [0.8 rgb <0.98,0.65,0.32>]
                [1.0 rgb <0.82,0.59,0.45>]
            }
            scale 5
            turbulence 0.7
            lambda 3.0
        }
        normal { bumps 0.5
            scale 1.7
        }
        finish {
            ambient 0.05
        }
    }
    #if (Media)
    interior {
        media {
            scattering { 1, rgb <0.02,0.02,0.02> }
        }
    }
    #end
}
#end // if (Background)