#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

#declare Indice_De_Reflection = 0.5

//--------------------------------------------------- COMMENCEMENT DU MERDIER ---------------------------------------------------//

//------------------------------------ FIN HALO PLUS FLAMMECHE BLANCHE --------------------------------------------//
#declare Pos_C_X = 655.0
#declare Pos_C_Y = 60.0
#declare Pos_C_Z = 356.0

light_source { <Pos_C_X, Pos_C_Y-40.0, Pos_C_Z> color rgb 1.7*<1.1, 0.4, 0.0> atmosphere off }
light_source
{
    <0.0, 2.0, 0.0> //<4.0, 4.0, -8.0>
    color <1.5, 0.5, 0.15>
    fade_distance 30.0
    fade_power 2.0
    atmosphere off
    area_light
    <0.05, 0.0, 0.0> <0.0, 0.0, 0.05>
    2, 2
    adaptive 0
    jitter
    looks_like
{
        sphere
        {
            <0.0, 0.0, 0.0>
            1.0
            pigment { color rgbt <1, 1, 1, 1> }
            halo {
                 emitting
                 spherical_mapping
                 linear
                 turbulence 1.0
                 color_map {

                           [ 0.0 color rgbt <1, 1, 1,  1> ]
                           [ 0.1 color rgbt <1, 0.5, 0.0, -1.0> ]
                           //[ 0.2 color rgbt <1, 1, 1, 1> ]
                           [ 0.25 color rgbt <1.0, 0.5, 0.0, 1.0> ]
                           [ 0.3 color rgbt <1, 1, 1, 1> ]
                           //[ 0.4 color rgbt <1, 0.5, 0.0, -1.0> ]
                           [ 0.45 color rgbt <2.0, 0.0, 0.0, -1.0> ]
                           [ 0.5 color rgbt <1.0, 0.0, 0.0, -1.0> ]
                           //[ 0.6 color rgbt <1, 0.5, 0.0, -1.0> ]
                           [ 0.75 color rgbt <1.0, 0.5, 0.0, -1.0> ]
                           [ 0.8 color rgbt <1.0, 0.0, 0.0, -1.0> ]
                           //[ 0.9 color rgbt <1.0, 0.5, 0.0, -1.0> ]
                           [ 1.0 color rgbt <1, 1, 1,  1> ]

                           }
                 frequency 2
                 samples 50
                 scale 1.5
                 //translate 1.0*x
                 }
            hollow
            scale <2.0, 6.0, 2.0>
            //rotate <0.0, 41.0, 20.0>
            scale 10
            translate 10.0*y
            rotate 52*z
            rotate -65*y
            translate <685.0, 0.0, 436.0>
            translate <-30.0, 60.0, -80.0>
        }
}
}

//--------------------------------------------------------------------------------------------//


union
{
sphere
{
    <0.0, 0.0, 0.0>, 1.0
            pigment { color rgbt <1, 1, 1, 1> }
            halo {
                 emitting
                 spherical_mapping
                 linear
                 turbulence 1.0
                 color_map {

                           [ 0.0 color rgbt <1, 1, 1,  1> ]
                           [ 0.1 color rgbt <1, 0.5, 0.0, -1.0> ]
                           //[ 0.2 color rgbt <1, 1, 1, 1> ]
                           [ 0.25 color rgbt <1.0, 0.5, 0.0, 1.0> ]
                           [ 0.3 color rgbt <1, 1, 1, 1> ]
                           //[ 0.4 color rgbt <1, 0.5, 0.0, -1.0> ]
                           [ 0.45 color rgbt <2.0, 0.0, 0.0, -1.0> ]
                           [ 0.5 color rgbt <1.0, 0.0, 0.0, -1.0> ]
                           //[ 0.6 color rgbt <1, 0.5, 0.0, -1.0> ]
                           [ 0.75 color rgbt <1.0, 0.5, 0.0, -1.0> ]
                           [ 0.8 color rgbt <1.0, 0.0, 0.0, -1.0> ]
                           //[ 0.9 color rgbt <1.0, 0.5, 0.0, -1.0> ]
                           [ 1.0 color rgbt <1, 1, 1,  1> ]

                           }
                 frequency 2
                 samples 50
                 scale 1.5
                 //translate 1.0*x
                 }
            hollow
}
        //------------------- FUMEES BLANCHE ------------------------// en theorie

difference
{
union
{
cylinder { <0.0, 0.0, 0.0>, <0.0, 1.1, 0.0>, 0.1
           rotate 15*z translate 1.0*x

            pigment { colour rgbt <1, 1, 1, 1> }
            halo {
                dust
                dust_type 1
                spherical_mapping
                linear
                turbulence 1
                colour_map {
                            [ 0 color rgbt <1.0, 0.7, 0.7, 1.0> ]
                            [ 0.5 color rgbt <1.0, 0.7, 0.7, -1.0> ]
                            [ 1 color rgbt <1.0, 0.7, 0.7, 0.5> ]
                           }
                frequency 5
                samples 10
                //aa_level 3
                //aa_threshold 0.2
                jitter 0.1
                scale 0.75
                 }
            hollow

         }
cylinder { <0.0, 0.0, 0.0>, <0.0, 1.1, 0.0>, 0.1

            pigment { colour rgbt <1, 1, 1, 1> }
            halo {
                dust
                dust_type 1
                spherical_mapping
                linear
                turbulence 1
                colour_map {
                            [ 0 color rgbt <1.0, 0.7, 0.7, 1.0> ]
                            [ 0.5 color rgbt <1.0, 0.7, 0.7, -1.0> ]
                            [ 1 color rgbt <1.0, 0.7, 0.7, 0.5> ]
                           }
                frequency 5
                samples 10
                //aa_level 3
                //aa_threshold 0.2
                jitter 0.1
                scale 0.75
                 }
            hollow

           rotate -15*x translate -1.0*z
         }
/*cone { <0.0, -0.5 0.0>, 0.40, <0.0, 0.5, 0.0>, 0.15

            pigment { colour rgbt <1, 1, 1, 1> }
            halo {
                dust
                dust_type 1
                spherical_mapping
                linear
                turbulence 1
                colour_map {
                            [ 0 color rgbt <1.0, 0.7, 0.7, 1.0> ]
                            [ 0.5 color rgbt <1.0, 0.7, 0.7, -1.0> ]
                            [ 1 color rgbt <1.0, 0.7, 0.7, 0.5> ]
                           }
                frequency 2
                samples 10
                //aa_level 3
                //aa_threshold 0.2
                jitter 0.1
                scale 0.75
                 }
            hollow

       translate 1.0*y
     }
*/
//cylinder { <0.0, -0.5, 0.0>, <0.0, 1.0, 0.0>, 1.5
  cone { <0.0, 0.0, 0.0>, 0.01, <0.0, 1.0, 0.0>, 0.5
            pigment { colour rgbt <1, 1, 1, 1> }
            halo {
                dust
                dust_type 1
                planar_mapping
                linear
                turbulence 1
                colour_map {
                            [ 0 color rgbt <1.0, 0.7, 0.7, 1.0> ]
                            //[ 0.5 color rgbt <1.0, 0.7, 0.7, -1.0> ]
                            [ 1 color rgbt <1.0, 0.7, 0.7, 0.5> ]
                           }
                frequency 5
                samples 10
                //aa_level 3
                //aa_threshold 0.2
                jitter 0.1
                scale 1.0
                translate 0.25*y
                 }
            hollow
            scale 1.5
//            pigment { Green }
        }
}
//sphere { <0.0, 0.0, 0.0>, 1.0 pigment { White }}
}
//pigment { Green }

    //---------------- INITIAL TRAITEMENT ROTATION / TRANSLATION --------------------//

    scale <2.0, 6.0, 2.0>
    scale 10
    translate 10.0*y
    rotate 52*z
    rotate -65*y
    translate <685.0, 0.0, 436.0>
    translate <-30.0, 60.0, -80.0>

    //-------------------------------------------------------------------------------//
}

//-----------------------------------------------------------------------------------------------------------------//
#declare Pos_C_X = 0.0
#declare Pos_C_Y = 280.0
#declare Pos_C_Z = -90.0

#declare Pos_A_X = 685.0
#declare Pos_A_Y = 0.0
#declare Pos_A_Z = 436.0

/*
sphere { <Pos_C_X, Pos_C_Y, Pos_C_Z>, 5.0 pigment { Blue } }
cylinder { <Pos_C_X, Pos_C_Y, Pos_C_Z>, <Pos_A_X, Pos_A_Y, Pos_A_Z>, 2.0 pigment { Yellow } }
sphere { <Pos_A_X, Pos_A_Y, Pos_A_Z>, 5.0 pigment { Red } }

cylinder { <0.0, 0.0, -4000.0>, <0.0, 0.0, 4000.0>, 1.0 pigment { Green } }
cylinder { <0.0, -4000.0, 0.0>, <0.0, 4000.0, 0.0>, 1.0 pigment { Sienna } }
cylinder { <-4000.0, 0.0, 0.0>, <4000.0, 0.0, 0.0>, 1.0 pigment { Pink } }
*/
#declare Hh = 280.0
#declare Pp = -90.0
/*
cylinder { <0.0, Hh, 1000.0>, <0.0, Hh, -1000.0>, 1.0 pigment { Yellow } }
cylinder { <0.0, -1000.0, Pp>, <0.0, 1000.0, Pp>, 1.0 pigment { Yellow } }
*/

#declare Rotate_Y_2 = -40

#declare Pos_C_X = 655.0
#declare Pos_C_Y = 60.0
#declare Pos_C_Z = 356.0

#declare Pos_A_X = 685.0
#declare Pos_A_Y = 0.0
#declare Pos_A_Z = 436.0

//cylinder { <Pos_C_X, Pos_C_Y, Pos_C_Z>, <Pos_A_X, Pos_A_Y, Pos_A_Z>, 2.0 pigment { Yellow } translate -Pos_C_Z*z translate -Pos_C_Y*y }

//light_source { <Pos_C_X, Pos_C_Y-40.0, Pos_C_Z> color rgb 0.8*<1.0, 0.5, 0.0> atmosphere off }

/*
light_source
{
    <0.0, 2.0, 0.0> //<4.0, 4.0, -8.0>
    color <1.5, 0.5, 0.15>
    fade_distance 30.0
    fade_power 2.0
    atmosphere off
    area_light
    <0.05, 0.0, 0.0> <0.0, 0.0, 0.05>
    2, 2
    adaptive 0
    jitter
    looks_like
{
        sphere
        {
            <0.0, 0.0, 0.0>
            1.0
            pigment { color rgbt <1, 1, 1, 1> }
            halo {
                 emitting
                 spherical_mapping
                 linear
                 turbulence 1.0
                 color_map {

                           [ 0.0 color rgbt <1, 1, 1,  1> ]
                           //[ 0.1 color rgbt <1, 0.5, 0.0, -1.0> ]
                           [ 0.2 color rgbt <1, 1, 1, 1> ]
                           [ 0.25 color rgbt <1.0, 0.5, 0.0, 1.0> ]
                           //[ 0.3 color rgbt <1, 1, 1, 1> ]
                           //[ 0.4 color rgbt <1, 0.5, 0.0, -1.0> ]
                           [ 0.45 color rgbt <2.0, 0.0, 0.0, -1.0> ]
                           [ 0.5 color rgbt <1.0, 0.0, 0.0, -1.0> ]
                           //[ 0.6 color rgbt <1, 0.5, 0.0, -1.0> ]
                           [ 0.75 color rgbt <1.0, 0.5, 0.0, -1.0> ]
                           //[ 0.8 color rgbt <1.0, 0.0, 0.0, -1.0> ]
                           //[ 0.9 color rgbt <1.0, 0.5, 0.0, -1.0> ]
                           [ 1.0 color rgbt <1, 1, 1,  1> ]

                           }
                 frequency 2
                 samples 50
                 scale 1.5
                 //translate 1.0*x
                 }
            hollow
            scale <2.0, 6.0, 2.0>
            //rotate <0.0, 41.0, 20.0>
            scale 10
            translate 10.0*y
            rotate 52*z
            rotate -65*y
            translate <685.0, 0.0, 436.0>
            translate <-30.0, 60.0, -80.0>
        }
}
}
*/
/*
sphere
        {
            <0.0, 0.0, 0.0>
            1.0
            pigment { colour rgbt <1, 1, 1, 1> }
            halo {
                dust
                dust_type 1
                spherical_mapping
                linear
                turbulence 1
                colour_map {
                            [ 0 color rgbt <1.0, 0.7, 0.7, 1.0> ]
                            [ 1 color rgbt <1.0, 0.7, 0.7, 0.5> ]
                           }
                frequency 2
                samples 10
                //aa_level 3
                //aa_threshold 0.2
                jitter 0.1
                scale <2.0, 4.0, 2.0>
                translate -1.0*x
                 }
            hollow
            scale <2.0, 4.0, 2.0>
            //rotate <0.0, 41.0, 20.0>
            scale 15
            translate -10.0*x
            rotate 52*z
            rotate -65*y
            translate <685.0, 0.0, 436.0>
            translate <-30.0, 60.0, -80.0>
        }
*/
/*        sphere
        {
            <0.0, 0.0, 0.0>
            1.0
            pigment { color rgbt <1, 1, 1, 1> }
            halo {
                 emitting
                 spherical_mapping
                 linear
                 turbulence 1.0
                 color_map {

                           [ 0.0 color rgbt <1, 1, 1,  1> ]
                           [ 0.1 color rgbt <1, 0.5, 0.0, -1.0> ]
                           //[ 0.2 color rgbt <1, 1, 1, 1> ]
                           [ 0.25 color rgbt <1.0, 0.5, 0.0, 1.0> ]
                           [ 0.3 color rgbt <1, 1, 1, 1> ]
                           //[ 0.4 color rgbt <1, 0.5, 0.0, -1.0> ]
                           [ 0.45 color rgbt <2.0, 0.0, 0.0, -1.0> ]
                           [ 0.5 color rgbt <1.0, 0.0, 0.0, -1.0> ]
                           //[ 0.6 color rgbt <1, 0.5, 0.0, -1.0> ]
                           [ 0.75 color rgbt <1.0, 0.5, 0.0, -1.0> ]
                           [ 0.8 color rgbt <1.0, 0.0, 0.0, -1.0> ]
                           //[ 0.9 color rgbt <1.0, 0.5, 0.0, -1.0> ]
                           [ 1.0 color rgbt <1, 1, 1,  1> ]

                           }
                 frequency 2
                 samples 50
                 scale 1.5
                 //translate 1.0*x
                 }
            hollow
            scale <2.0, 6.0, 2.0>
            //rotate <0.0, 41.0, 20.0>
            scale 10
            translate 10.0*y
            rotate 52*z
            rotate -65*y
            translate <685.0, 0.0, 436.0>
            translate <-30.0, 60.0, -80.0>
        }
*/
//----------------------------------------------------- FIN DU MERDIER ----------------------------------------------------------------------------//

#declare L_1_Dep = 0.25

#declare CARGO_PROGRESS = union
{
cylinder { <0.0, 0.0, 0.0>, <0.25, 0.0, 0.0>, 2.7 }
cylinder { <0.25, 0.0, 0.0>, <2.25, 0.0, 0.0>, 2.5 }
cone { <2.25, 0.0, 0.0>, 2.0, <3.25, 0.0, 0.0>, 2.5 }
cone { <3.5, 0.0, 0.0>, 2.5, <4.75, 0.0, 0.0>, 1.75 }
difference
{
sphere { 0.0, 2.7 scale <1.25, 1.0, 1.0> translate 7.0*x }
box { <7.0, 4.0, 4.0> <12.0, -4.0, -4.0> }
}
}

#declare Pan_Sol_CARGO_PROGRESS = box { <0.3, -10.0, -0.1> <2.2, 10.0, 0.1>
      texture
      {
       pigment
       {
        image_map
        {
            gif "pan.gif"
            interpolate 2 // smooth it
            //once   // don't tile image, just one copy
            //filter 0 0.8  // make 1st color mostly transparent
            //filter 1 0.8  // make 2nd color mostly transparent
        }
        // transform it to unit-size (-1 to +1)
        translate -0.5*(x+y) // center on the origin
        scale 0.15              // make it unit-sized
      }
      finish { ambient 0.3 reflection Indice_De_Reflection }
      }
    }

/******************************************************************************************************************************************/

#declare L_dep = 7.0
#declare L_arv = 9.0
#declare H_max = 1.75
#declare P_min = 0.5

#declare KVANT_1 = union
{
union
{
mesh
{
    triangle { <L_dep, H_max, P_min>, <L_dep, P_min, P_min>, <L_dep, P_min, H_max> }
    triangle { <L_dep, H_max, -P_min>, <L_dep, P_min, -P_min>, <L_dep, P_min, -H_max> }
    triangle { <L_dep, -H_max, P_min>, <L_dep, -P_min, P_min>, <L_dep, -P_min, H_max> }
    triangle { <L_dep, -H_max, -P_min>, <L_dep, -P_min, -P_min>, <L_dep, -P_min, -H_max> }

    triangle { <L_arv, H_max, P_min>, <L_arv, P_min, P_min>, <L_arv, P_min, H_max> }
    triangle { <L_arv, H_max, -P_min>, <L_arv, P_min, -P_min>, <L_arv, P_min, -H_max> }
    triangle { <L_arv, -H_max, P_min>, <L_arv, -P_min, P_min>, <L_arv, -P_min, H_max> }
    triangle { <L_arv, -H_max, -P_min>, <L_arv, -P_min, -P_min>, <L_arv, -P_min, -H_max> }

    triangle { <L_dep, H_max, P_min>, <L_arv, H_max, P_min>, <L_dep, P_min, H_max> }
    triangle { <L_dep, P_min, H_max>, <L_arv, P_min, H_max>, <L_arv, H_max, P_min> }

    triangle { <L_dep, -H_max, P_min>, <L_arv, -H_max, P_min>, <L_dep, -P_min, H_max> }
    triangle { <L_dep, -P_min, H_max>, <L_arv, -P_min, H_max>, <L_arv, -H_max, P_min> }

    triangle { <L_dep, H_max, -P_min>, <L_arv, H_max, -P_min>, <L_dep, P_min, -H_max> }
    triangle { <L_dep, P_min, -H_max>, <L_arv, P_min, -H_max>, <L_arv, H_max, -P_min> }

    triangle { <L_dep, -H_max, -P_min>, <L_arv, -H_max, -P_min>, <L_dep, -P_min, -H_max> }
    triangle { <L_dep, -P_min, -H_max>, <L_arv, -P_min, -H_max>, <L_arv, -H_max, -P_min> }
}

box { <L_dep, P_min, H_max> <L_arv, -P_min, -H_max> }
box { <L_dep, H_max, P_min> <L_arv, -H_max, -P_min> }
scale <1.0, 2.0, 2.0>
}
cylinder { <L_arv, 0.0, 0.0>, <14.0, 0.0, 0.0>, 4.0 }
cone { <14.0, 0.0, 0.0>, 4.0, <15.0, 0.0, 0.0>, 3.0 }

box { <7.75, 0.25, 0.0> <8.25, -0.25, -10.0> }
}

#declare Ligne = union
{
box { <-0.05, -0.15, -2.0> <0.05, 0.15, 2.0> rotate 15*z }
box { <-0.05, -0.15, -2.0> <0.05, 0.15, 2.0> rotate -51*z translate 0.2*y translate 0.03*x }
texture
{
    pigment
    {
        bozo
        pigment_map
        {
            [ 0.0 Blue ]
            [ 0.5 Black ]
            [ 0.75 Blue ]
            [ 1.0 Blue ]
        }
        turbulence 1.75
    }
    normal { crackle 15.0 }
    finish { ambient 0.3 reflection Indice_De_Reflection }
}
}

#declare PAN = union
{
#declare NbPan = 20.0
#declare Count = 1.0
#while (Count <= NbPan)
       object { Ligne }
       object { Ligne translate 0.4*Count*y }
#declare Count = Count + 1.0
#end
}

#declare Pan_Sol_KVANT_1 = union
{
object { PAN translate L_arv+2.5*x translate -7.0*y translate -10.0*z translate 2.0*y rotate 45*z }
object { PAN translate L_arv+2.5*x translate -28.0*y translate -10.0*z translate -0.75*y rotate -45*z rotate -15*y }
}

#declare Mature = union
{
    cylinder { <-0.5, 0.5, 0.5>, <-0.5, 0.5, -0.5>, 0.1 }
    cylinder { <0.5, 0.5, 0.5>, <0.5, 0.5, -0.5>, 0.1 }
    cylinder { <-0.5, -0.5, 0.5>, <-0.5, -0.5, -0.5>, 0.1 }
    cylinder { <0.5, -0.5, 0.5>, <0.5, -0.5, -0.5>, 0.1 }
    cylinder { <-0.5, 0.5, -0.5>, <0.5, 0.5, -0.5>, 0.1 }
    cylinder { <-0.5, -0.5, -0.5>, <0.5, -0.5, -0.5>, 0.1 }
    cylinder { <-0.5, 0.5, -0.5>, <-0.5, -0.5, -0.5>, 0.1 }
    cylinder { <0.5, -0.5, -0.5>, <0.5, 0.5, -0.5>, 0.1 }

    sphere { <-0.5, 0.5, -0.5>, 0.1 }
    sphere { <0.5, 0.5, -0.5>, 0.1 }
    sphere { <-0.5, -0.5, -0.5>, 0.1 }
    sphere { <0.5, -0.5, -0.5>, 0.1 }

    texture { T_Silver_2B }
}

#declare Armature_KVANT_1 = union
{
#declare NbMat = 7.0
#declare Iter = 1.0
#while (Iter <= NbMat)
       object { Mature translate L_arv+2.5*x translate -3.95*z }
       object { Mature translate L_arv+2.5*x translate -3.95*z translate -1.0*Iter*z }
#declare Iter = Iter + 1.0
#end
}
#declare Volet_Armature = union
{
#declare NbMat_2 = 5.0
#declare Alter = 1.0
#while (Alter <= NbMat_2)
       object { Mature translate L_arv*x translate -1.0*Alter*z }
#declare Alter = Alter + 1.0
#end
}

/******************************************************************************************************************************************/

#declare CORPS_CENTRAL = union
{
cylinder { <15.0, 0.0, 0.0>, <22.0, 0.0, 0.0>, 4.15 }
cone { <22.0, 0.0, 0.0>, 4.15, <24.0, 0.0, 0.0>, 3.5 }
cylinder { <24.0, 0.0, 0.0>, <28.0, 0.0, 0.0>, 3.5 }
cylinder { <28.0, 0.0, 0.0>, <32.0, 0.0, 0.0>, 3.0 }
cone { <32.0, 0.0, 0.0>, 3.0, <34.0, 0.0, 0.0>, 2.0 }
sphere { <36.0, 0.0, 0.0>, 2.5 }
}

#declare Pan_Sol_Base_CORPS_CENTRAL = union
{
box { <-0.5, 3.4, -0.5> <0.5, 5.0, 0.5> pigment { White }}
union
{
box { <-0.1, -1.0, -2.0> <0.1, 1.0, 2.0> rotate 20*z translate 5.9*y rotate 45*z }
box { <-0.1, -1.0, -2.0> <0.1, 1.0, 2.0> rotate -20*z translate 7.5*y rotate 45*z }
box { <-0.1, -1.0, -2.0> <0.1, 1.0, 2.0> rotate 20*z translate 9.1*y rotate 45*z }
//box { <-0.1, -1.0, -2.0> <0.1, 1.0, 2.0> rotate -20*z translate 10.7*y }
box { <-0.1, -1.0, -2.0> <0.1, 1.0, 2.0> rotate 20*z translate 12.3*y rotate 45*z }
box { <-0.1, -1.0, -2.0> <0.1, 1.0, 2.0> rotate -20*z translate 13.9*y rotate 45*z }
//box { <-0.1, -1.0, -2.0> <0.1, 1.0, 2.0> rotate 20*z translate 15.5*y }
box { <-0.1, -1.0, -2.0> <0.1, 1.0, 2.0> rotate -20*z translate 17.1*y rotate 45*z }
//box { <-0.1, -1.0, -2.0> <0.1, 1.0, 2.0> rotate 20*z translate 18.7*y }
      texture
      {
       pigment
       {
        image_map
        {
            gif "pan.gif"
            interpolate 2 // smooth it
            //once   // don't tile image, just one copy
            //filter 0 0.8  // make 1st color mostly transparent
            //filter 1 0.8  // make 2nd color mostly transparent
        }
        // transform it to unit-size (-1 to +1)
        translate -0.5*(x+y) // center on the origin
        scale 0.15              // make it unit-sized
      }
      finish { ambient 0.3 reflection Indice_De_Reflection }
      }

}
}

#declare Pan_Sol_CORPS_CENTRAL = union
{
object { Pan_Sol_Base_CORPS_CENTRAL }
object { Pan_Sol_Base_CORPS_CENTRAL rotate 90*x }
object { Pan_Sol_Base_CORPS_CENTRAL rotate -90*x }
object { Pan_Sol_Base_CORPS_CENTRAL rotate 180*x }
}

/******************************************************************************************************************************************/

#declare PRIRODA = union
{
cylinder { <36.0, 2.0, 0.0>, <36.0, 3.0, 0.0>, 2.0 }
cone { <36.0, 3.0, 0.0>, 2.0, <36.0, 5.0, 0.0>, 4.3 }
cylinder { <36.0, 5.0, 0.0>, <36.0, 5.5, 0.0>, 4.3 }
cylinder { <36.0, 5.5, 0.0>, <36.0, 13.0, 0.0>, 2.0 }
box { <35.0, 13.0, -2.0> <37.0, 15.0, 2.0> }
box { <34.0, 13.0, -0.5> <35.0, 15.0, 0.5> }
box { <-0.5, 0.0, -1.0> <0.5, 5.0, 1.0> rotate 35*y translate <37.0, 5.5, -2.5> }
box { <38.0, 5.5, -1.5> <38.5, 9.0, 1.0> }
box { <34.0, 7.0, -1.5> <33.5, 11.0, 1.5> }
}

/******************************************************************************************************************************************/

#declare VAISSEAU_SOYOUZ =union
{
cylinder { <38.0, 0.0, 0.0>, <39.0, 0.0, 0.0>, 2.0 rotate 152*z translate -1*x }
difference
{
sphere { <0.0, 0.0, 0.0>, 2.7 scale <1.25, 1.0, 1.0> translate 41*x }
box { <39.0, 4.0, -4.0> <35.0, -4.0, 4.0> }
rotate 30*z rotate 15*x translate -15*x
}
cylinder { <43.0, 0.0, 0.0>, <43.2, 0.0, 0.0>, 2.2 rotate -152*z rotate 10*y translate -1*x }
cylinder { <43.2, 0.0, 0.0>, <43.5, 0.0, 0.0>, 2.35 rotate 17*z rotate -30*x translate -21*x }
cone { <43.5, 0.0, 0.0>, 2.35, <46.0, 0.0, 0.0>, 2.7 rotate 17*z rotate -30*x translate -21*x }
cylinder { <46.0, 0.0, 0.0>, <49.0, 0.0, 0.0>, 2.7 rotate 17*z rotate -30*x translate -21*x }
cylinder { <49.0, 0.0, 0.0>, <49.25, 0.0, 0.0>, 2.9 rotate 17*z rotate -30*x translate -21*x }
}

/******************************************************************************************************************************************/

#declare KRISTALL = union
{
cylinder { <36.0, -2.0, 0.0>, <36.0, -3.0, 0.0>, 2.0 }
cone { <36.0, -3.0, 0.0>, 2.0, <36.0, -5.0, 0.0>, 4.0 }
cone { <36.0, -5.0, 0.0>, 4.0, <36.0, -7.0, 0.0>, 3.0 }
cylinder { <36.0, -7.0, 0.0>, <36.0, -8.5, 0.0>, 3.0 }
cylinder { <36.0, -8.5, 0.0>, <36.0, -9.0, 0.0>, 2.85 }
cylinder { <36.0, -9.0, 0.0>, <36.0, -10.5, 0.0>, 3.0 }
cylinder { <36.0, -10.5, 0.0>, <36.0, -11.0, 0.0>, 2.85 }
cylinder { <36.0, -11.0, 0.0>, <36.0, -12.5, 0.0>, 3.0 }
cylinder { <36.0, -12.5, 0.0>, <36.0, -16.0, 0.0>, 2.5 }
cone { <36.0, -16.0, 0.0>, 2.5, <36.0, -18.0, 0.0>, 1.8 }
cylinder { <36.0, -18.0, 0.0>, <36.0, -19.0, 0.0>, 1.5 }
sphere { <36.0, -21.5, 0.0>, 3.0 }
cylinder { <36.0, -21.5, -2.5>, <36.0, -21.5, -3.5>, 1.5 }
cylinder { <36.0, -21.5, 2.5>, <36.0, -21.5, 3.5>, 1.5 }
cylinder { <36.0, -24.0, 0.0>, <36.0, -25.0, 0.0>, 1.5 }
}

#declare Pan_Sol_KRISTAL = box { <38.5, -13.0, 0.1> <43.0, -15.5, 0.0>
      texture
      {
       pigment
       {
        image_map
        {
            gif "pan.gif"
            interpolate 2 // smooth it
            //once   // don't tile image, just one copy
            //filter 0 0.8  // make 1st color mostly transparent
            //filter 1 0.8  // make 2nd color mostly transparent
        }
        // transform it to unit-size (-1 to +1)
        translate -0.5*(x+y) // center on the origin
        scale 0.15              // make it unit-sized
      }
      finish { ambient 0.3 reflection Indice_De_Reflection }
      }

    }

/******************************************************************************************************************************************/

#declare KVANT_2 = union
{
cylinder { <36.0, 0.0, -2.0>, <36.0, 0.0, -3.0>, 2.0 }
cone { <36.0, 0.0, -3.0>, 4.0, <36.0, 0.0, -5.0>, 3.6 }
cylinder { <36.0, 0.0, -5.0>, <36.0, 0.0, -8.0>, 3.6 }
cylinder { <36.0, 0.0, -8.0>, <36.0, 0.0, -10.0>, 3.45 }
cylinder { <36.0, 0.0, -10.0>, <36.0, 0.0, -12.5>, 3.3 }
cylinder { <36.0, 0.0, -12.5>, <36.0, 0.0, -15.5>, 3.0 }
cone { <36.0, 0.0, -15.5>, 3.0, <36.0, 0.0, -17.0>, 2.35 scale <0.8, 1.2, 1.0> }
box { <31.0, 0.5, -10.0> <42.0, -0.5, -11.5> }
box { <-0.25, 0.5, -2.0> <0.25, -1.5, 2.0> rotate 17*z translate <39.3, 2.0, -7.0> rotate 3.14*x translate -15.0*x }
box { <-0.25, 1.5, -2.0> <0.25, -0.5, 2.0> rotate -17*z translate <39.3, -2.0, -7.0> translate -10.0*x }
}

#declare Rien = seed(100)

#declare Pan_Sol_KVANT_2 = union
{
box { <35.9, 3.3, -10.625> <36.1, 4.3, -11.25> rotate -53*x translate <-15.0, -10.0, 0.0> rotate -50*z }
//box { <35.9, 4.3, -10.1> <36.1, 10.0, -12.4> }
//box { <35.9, 10.0, -9.0> <36.1, 15.0, -13.5> }

//box { <35.9, -3.3, -10.625> <36.1, -4.3, -11.25> }
//box { <35.9, -4.3, -10.1> <36.1, -10.0, -12.4> }
box { <35.9, -10.0, -9.0> <36.1, -15.0, -13.5> rotate 4*rand(Rien)/2.0 translate -rand(Rien)-4*(x+y) rotate -50*z }

      texture
      {
       pigment
       {
        image_map
        {
            gif "pan.gif"
            interpolate 2 // smooth it
            //once   // don't tile image, just one copy
            //filter 0 0.8  // make 1st color mostly transparent
            //filter 1 0.8  // make 2nd color mostly transparent
        }
        // transform it to unit-size (-1 to +1)
        translate -0.5*(x+y) // center on the origin
        scale 0.15              // make it unit-sized
      }
      normal { crackle 3.5 }
      finish { ambient 0.3 reflection Indice_De_Reflection }
      }

}

/******************************************************************************************************************************************/

#declare SPECTRE = union
{
cylinder { <36.0, 0.0, 2.0>, <36.0, 0.0, 3.0>, 2.0 }
cone { <36.0, 0.0, 3.0>, 2.0, <36.0, 0.0, 6.0>, 4.0 }
cone { <36.0, 0.0, 6.0>, 4.0, <36.0, 0.0, 9.0>, 3.0 }
cylinder { <36.0, 0.0, 9.0>, <36.0, 0.0, 15.0>, 3.0 }
cone { <36.0, 0.0, 15.0>, 3.0, <36.0, 0.0, 17.0>, 1.0 }
box { <35.0, 4.0, 9.0> <37.0, -4.0, 12.0> }
box { <39.0, 1.0, 9.0> <39.5, -1.0, 13.0> }
}

#declare Pan_Sol_SPECTRE = union
{
box { <35.9, 3.0, 11.375> <36.1, 4.0, 12.625> translate -36.0*x rotate -15*x rotate 15*z }
box { <35.9, 4.0, 10.85> <36.1, 9.7, 13.775> translate -36.0*x rotate -15*x rotate 15*z translate -5*y }
box { <35.9, 9.7, 9.75> <36.1, 14.7, 14.875> translate -36.0*x rotate -15*x translate -0.15*x rotate 15*z }

box { <35.9, -3.0, 11.375> <36.1, -4.0, 12.625> translate 36.0*x rotate -15*x translate -0.15*x rotate -15*z }
box { <35.9, -4.0, 10.85> <36.1, -9.7, 13.775> translate 36.0*x rotate -15*x translate -0.15*x rotate 15*z }
box { <35.9, -9.7, 9.75> <36.1, -14.7, 14.875> translate 36.0*x rotate -15*x translate -0.15*x rotate -15*z }

      texture
      {
       pigment
       {
        image_map
        {
            gif "pan.gif"
            interpolate 2 // smooth it
            //once   // don't tile image, just one copy
            //filter 0 0.8  // make 1st color mostly transparent
            //filter 1 0.8  // make 2nd color mostly transparent
        }
        // transform it to unit-size (-1 to +1)
        translate -0.5*(x+y) // center on the origin
        scale 0.15              // make it unit-sized
      }
      finish { ambient 0.3 reflection Indice_De_Reflection }
      }
translate 2.0*z
}

/******************************************************************************************************************************************/

#declare MIR = union
{
object { CARGO_PROGRESS /*pigment { Blue }*/ translate -36.0*x }
object { KVANT_1 /*pigment { Red }*/ translate -36.0*x }
object { CORPS_CENTRAL /*pigment { Green }*/ translate -36.0*x }
difference
{
    object { PRIRODA /*pigment { Magenta }*/ translate -36.0*x rotate 45*z }
    object { CORPS_CENTRAL /*pigment { Green }*/ translate -36.0*x }
}

object { VAISSEAU_SOYOUZ /*pigment { Yellow }*/ translate -36.0*x }

difference
{
    object { KRISTALL /*pigment { Pink }*/ translate -36.0*x rotate -45*z }
    object { CORPS_CENTRAL /*pigment { Green }*/ translate -36.0*x }
}
difference
{
    object { KVANT_2 /*pigment { White }*/ translate -36.0*x rotate 45*y }
    object { CORPS_CENTRAL /*pigment { Green }*/ translate -36.0*x }
}
difference
{
    object { SPECTRE /*pigment { Brown }*/ translate -36.0*x rotate -45*y }
    object { CORPS_CENTRAL /*pigment { Green }*/ translate -36.0*x }
}
}

#declare Pan_MIR = union
{
object { Pan_Sol_CARGO_PROGRESS }
object { Armature_KVANT_1 translate -8.0*y translate -10.0*z }
object { Volet_Armature rotate -65*y rotate 35*z translate -50.0*z }
object { Pan_Sol_KVANT_1 }
object { Pan_Sol_CORPS_CENTRAL translate 26.0*x }
//object { Pan_Sol_KRISTAL }
object { Pan_Sol_KVANT_2 }
object { Pan_Sol_SPECTRE }
}

object { MIR translate 20*x
             scale 1
             rotate -52*z
             rotate -65*y
translate <685.0, 0.0, 436.0>
             //translate Pos_C_Y*y
             //translate Pos_C_Z*z
translate <-30.0, 60.0, -80.0>
             texture
             {
                pigment
                {
                    bozo
                    pigment_map
                    {
                        [ 0.0 Black ]
                        [ 0.5 White ]
                        [ 0.75 Orange ]
                        [ 0.9 color rgb <0.9, 0.1, 0.1> ]
                        [ 1.0 color rgb <0.9, 0.2, 0.2> ]
                    }
                    turbulence 2.5
                }
                normal { crackle 2.5 }
                scale 4
             }
       }


object { Pan_MIR translate -36.0*x translate 20.0*x scale 1
             rotate -52*z
             rotate -65*y
             translate <685.0, 0.0, 436.0>
             translate <-30.0, 60.0, -80.0>
       }

#declare Truc = mesh
{
    triangle { <-0.1, 0.0, -0.1>, <0.0, 0.1, 0.0>, <0.1, 0.0, -0.1> }
    triangle { <-0.1, 0.0, -0.1>, <0.0, 0.1, 0.0>, <-0.1, 0.0, 0.1> }
    triangle { <-0.1, 0.0, 0.1>, <0.0, 0.1, 0.0>, <0.1, 0.0, 0.1> }
    triangle { <0.1, 0.0, 0.1>, <0.0, 0.1, 0.0>, <0.1, 0.0, -0.1> }
    triangle { <-0.1, 0.0, -0.1>, <-0.1, 0.0, 0.1>, <0.1, 0.0, 0.1> }
    triangle { <0.1, 0.0, 0.1>, <0.1, 0.0, -0.1>, <-0.1, 0.0, -0.1> }

    texture
    {
        T_Silver_2B
        finish { reflection 0.09 phong 0.8 }
    }

}

#declare AlphaR1 = seed(100)
#declare AlphaR2 = seed(200)
#declare AlphaR3 = seed(300)
#declare BetaR1  = seed(400)
#declare BetaR2  = seed(1)
#declare BetaR3  = seed(1000)
#declare NbDebris = 20000 //11000.0

#declare Trainee = union
{
#declare Unreal = 1.0
#while (Unreal <= NbDebris/2.0)
       #declare X = 4*rand(AlphaR1)
       #declare Y = 40*rand(AlphaR2)
       #declare Z = 70*rand(AlphaR3)

       #declare Xx = 50*rand(BetaR1)
       #declare Yy = 75*rand(BetaR2)
       #declare Zz = 100*rand(BetaR3)

            object { Truc translate <-X, Y, Z> rotate <Xx, Yy, Zz> }
#declare Unreal = Unreal + 1.0
#end
}

object { Trainee rotate 90*y translate <685.0, 0.0, 436.0> translate <-30.0, 60.0, -80.0> }

#declare Trainee2 = union
{
#declare UNREAL = 1.0
#while (UNREAL <= NbDebris/6.0)
       #declare XX = 4*rand(AlphaR1)
       #declare YY = 40*rand(AlphaR2)
       #declare ZZ = 70*rand(AlphaR3)

       #declare XXx = 50*rand(BetaR1)
       #declare YYy = 75*rand(BetaR2)
       #declare ZZz = 100*rand(BetaR3)

            object { Truc translate <-XX, YY, ZZ> rotate <XXx, YYy, ZZz> }

#declare UNREAL = UNREAL + 1.0
#end
}

object { Trainee2 /*rotate 90*y*/ rotate 90*x translate <685.0, 0.0, 436.0> translate <-30.0, 60.0, -80.0> }
