
#declare Arc_Largeur    = 34.0
#declare Arc_Hauteur    = 37.0
#declare Arc_Profondeur = 16.0
#declare Retrait        =  0.7
#declare Nb_Plots       = 50.0
#declare D_Plots        =  1.0

#declare Arc = union
{
  difference
  {
    box
    {
      <-Arc_Largeur/2.0, 0.0, -Arc_Profondeur/2.0>
      <Arc_Largeur/2.0, Arc_Hauteur, Arc_Profondeur/2.0>
    }
    box
    {
      <-Arc_Largeur/6.0, -0.01, -Arc_Profondeur>
      <Arc_Largeur/6.0, Arc_Hauteur/2.0, Arc_Profondeur>
    }
    cylinder
    {
      <0.0, Arc_Hauteur/2.0, -Arc_Profondeur>
      <0.0, Arc_Hauteur/2.0, Arc_Profondeur>
      Arc_Largeur/6.0
    }
    box
    {
      <-Arc_Largeur, -0.01, -Arc_Profondeur/6.0>
      <Arc_Largeur, Arc_Hauteur/2.0-Arc_Profondeur/6.0, Arc_Profondeur/6.0>
    }
    cylinder
    {
      <-Arc_Largeur, Arc_Hauteur/2.0-Arc_Profondeur/6.0, 0.0>
      <Arc_Largeur, Arc_Hauteur/2.0-Arc_Profondeur/6.0, 0.0>
      Arc_Profondeur/6.0
    }
    // 3 sculptures hautes
    box
    {
      <-Arc_Largeur/2.0+2.0*Retrait, Arc_Hauteur/2.0+3.0*Retrait, -Arc_Profondeur>
      <-Arc_Largeur/6.0-2.0*Retrait, Arc_Hauteur/2.0+10.0*Retrait, -Arc_Profondeur/2.0+Retrait/2.0>
    }
    box
    {
      <Arc_Largeur/2.0-2.0*Retrait, Arc_Hauteur/2.0+3.0*Retrait, -Arc_Profondeur>
      <Arc_Largeur/6.0+2.0*Retrait, Arc_Hauteur/2.0+10.0*Retrait, -Arc_Profondeur/2.0+Retrait/2.0>
    }
    box
    {
      <Arc_Largeur, Arc_Hauteur/2.0+3.0*Retrait, -Arc_Profondeur/2.0+2.0*Retrait>
      <Arc_Largeur/2.0-Retrait/2.0, Arc_Hauteur/2.0+10.0*Retrait, Arc_Profondeur/2.0-2.0*Retrait>
    }
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/2.0, Arc_Hauteur/2.0, -Arc_Profondeur/2.0-Retrait/2.0>
      <-Arc_Largeur/6.0+Retrait/2.0, Arc_Hauteur/2.0+Retrait, Arc_Profondeur/2.0+Retrait/2.0>
  }
  box
  {
      <Arc_Largeur/2.0+Retrait/2.0, Arc_Hauteur/2.0, -Arc_Profondeur/2.0-Retrait/2.0>
      <Arc_Largeur/6.0-Retrait/2.0, Arc_Hauteur/2.0+Retrait, Arc_Profondeur/2.0+Retrait/2.0>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/4.0, Arc_Hauteur/2.0+Retrait, -Arc_Profondeur/2.0-Retrait/4.0>
      <-Arc_Largeur/6.0+Retrait/4.0, Arc_Hauteur/2.0+2.0*Retrait, Arc_Profondeur/2.0+Retrait/4.0>
  }
  box
  {
      <Arc_Largeur/2.0+Retrait/4.0, Arc_Hauteur/2.0+Retrait, -Arc_Profondeur/2.0-Retrait/4.0>
      <Arc_Largeur/6.0-Retrait/4.0, Arc_Hauteur/2.0+2.0*Retrait, Arc_Profondeur/2.0+Retrait/4.0>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/4.0, Arc_Hauteur/2.0, -Arc_Profondeur/2.0-Retrait/4.0>
      <-Arc_Largeur/6.0+Retrait/4.0, Arc_Hauteur/2.0-Retrait, Arc_Profondeur/2.0+Retrait/4.0>
  }
  box
  {
      <Arc_Largeur/2.0+Retrait/4.0, Arc_Hauteur/2.0, -Arc_Profondeur/2.0-Retrait/4.0>
      <Arc_Largeur/6.0-Retrait/4.0, Arc_Hauteur/2.0-Retrait, Arc_Profondeur/2.0+Retrait/4.0>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/4.0, Arc_Hauteur/2.0+Arc_Largeur/6.0+5.0*Retrait, -Arc_Profondeur/2.0-Retrait/4.0>
      <Arc_Largeur/2.0+Retrait/4.0, Arc_Hauteur-3.0*Retrait, Arc_Profondeur/2.0+Retrait/4.0>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/2.0, Arc_Hauteur-2.0*Retrait, -Arc_Profondeur/2.0-Retrait/2.0>
      <Arc_Largeur/2.0+Retrait/2.0, Arc_Hauteur-3.0*Retrait, Arc_Profondeur/2.0+Retrait/2.0>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/3.0, Arc_Hauteur-3.0*Retrait, -Arc_Profondeur/2.0-Retrait/3.0>
      <Arc_Largeur/2.0+Retrait/3.0, Arc_Hauteur-4.0*Retrait, Arc_Profondeur/2.0+Retrait/3.0>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/6.0, Arc_Hauteur/2.0+Arc_Largeur/6.0+5.0*Retrait, -Arc_Profondeur/2.0-Retrait/6.0>
      <Arc_Largeur/2.0+Retrait/6.0, Arc_Hauteur/2.0+Arc_Largeur/6.0+4.0*Retrait, Arc_Profondeur/2.0+Retrait/6.0>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/8.0, Arc_Hauteur/2.0+Arc_Largeur/6.0+4.0*Retrait, -Arc_Profondeur/2.0-Retrait/8.0>
      <Arc_Largeur/2.0+Retrait/8.0, Arc_Hauteur/2.0+Arc_Largeur/6.0+3.0*Retrait, Arc_Profondeur/2.0+Retrait/8.0>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait, Arc_Hauteur-8.0*Retrait, -Arc_Profondeur/2.0-Retrait>
      <Arc_Largeur/2.0+Retrait, Arc_Hauteur-9.0*Retrait, Arc_Profondeur/2.0+Retrait>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/1.5, Arc_Hauteur-9.0*Retrait, -Arc_Profondeur/2.0-Retrait/1.5>
      <Arc_Largeur/2.0+Retrait/1.5, Arc_Hauteur-10.0*Retrait, Arc_Profondeur/2.0+Retrait/1.5>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/3.0, Arc_Hauteur-8.0*Retrait, -Arc_Profondeur/2.0-Retrait/3.0>
      <Arc_Largeur/2.0+Retrait/3.0, Arc_Hauteur-7.0*Retrait, Arc_Profondeur/2.0+Retrait/3.0>
  }

  box
  {
      <-Arc_Largeur/2.0-Retrait/4.0, Arc_Hauteur/7.0, -Arc_Profondeur/2.0-Retrait/4.0>
      <-Arc_Largeur/6.0+Retrait/4.0, Arc_Hauteur/7.0+Retrait, -Arc_Profondeur/6.0+Retrait/4.0>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/4.0, Arc_Hauteur/7.0, Arc_Profondeur/2.0+Retrait/4.0>
      <-Arc_Largeur/6.0+Retrait/4.0, Arc_Hauteur/7.0+Retrait, Arc_Profondeur/6.0-Retrait/4.0>
  }
  box
  {
      <Arc_Largeur/2.0+Retrait/4.0, Arc_Hauteur/7.0, -Arc_Profondeur/2.0-Retrait/4.0>
      <Arc_Largeur/6.0-Retrait/4.0, Arc_Hauteur/7.0+Retrait, -Arc_Profondeur/6.0+Retrait/4.0>
  }
  box
  {
      <Arc_Largeur/2.0+Retrait/4.0, Arc_Hauteur/7.0, Arc_Profondeur/2.0+Retrait/4.0>
      <Arc_Largeur/6.0-Retrait/4.0, Arc_Hauteur/7.0+Retrait, Arc_Profondeur/6.0-Retrait/4.0>
  }

  box
  {
      <-Arc_Largeur/2.0-Retrait, 0.0, -Arc_Profondeur/2.0-Retrait>
      <-Arc_Largeur/6.0+Retrait, 2.0*Retrait, -Arc_Profondeur/6.0+Retrait>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait, 0.0, Arc_Profondeur/2.0+Retrait>
      <-Arc_Largeur/6.0+Retrait, 2.0*Retrait, Arc_Profondeur/6.0-Retrait>
  }
  box
  {
      <Arc_Largeur/2.0+Retrait, 0.0, -Arc_Profondeur/2.0-Retrait>
      <Arc_Largeur/6.0-Retrait, 2.0*Retrait, -Arc_Profondeur/6.0+Retrait>
  }
  box
  {
      <Arc_Largeur/2.0+Retrait, 0.0, Arc_Profondeur/2.0+Retrait>
      <Arc_Largeur/6.0-Retrait, 2.0*Retrait, Arc_Profondeur/6.0-Retrait>
  }

  box
  {
      <-Arc_Largeur/2.0-Retrait/2.0, 0.0, -Arc_Profondeur/2.0-Retrait/2.0>
      <-Arc_Largeur/6.0+Retrait/2.0, 3.0*Retrait, -Arc_Profondeur/6.0+Retrait/2.0>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/2.0, 0.0, Arc_Profondeur/2.0+Retrait/2.0>
      <-Arc_Largeur/6.0+Retrait/2.0, 3.0*Retrait, Arc_Profondeur/6.0-Retrait/2.0>
  }
  box
  {
      <Arc_Largeur/2.0+Retrait/2.0, 0.0, -Arc_Profondeur/2.0-Retrait/2.0>
      <Arc_Largeur/6.0-Retrait/2.0, 3.0*Retrait, -Arc_Profondeur/6.0+Retrait/2.0>
  }
  box
  {
      <Arc_Largeur/2.0+Retrait/2.0, 0.0, Arc_Profondeur/2.0+Retrait/2.0>
      <Arc_Largeur/6.0-Retrait/2.0, 3.0*Retrait, Arc_Profondeur/6.0-Retrait/2.0>
  }

  box
  {
      <-Arc_Largeur/2.0-Retrait/4.0, 0.0, -Arc_Profondeur/2.0-Retrait/4.0>
      <-Arc_Largeur/6.0+Retrait/4.0, 4.0*Retrait, -Arc_Profondeur/6.0+Retrait/4.0>
  }
  box
  {
      <-Arc_Largeur/2.0-Retrait/4.0, 0.0, Arc_Profondeur/2.0+Retrait/4.0>
      <-Arc_Largeur/6.0+Retrait/4.0, 4.0*Retrait, Arc_Profondeur/6.0-Retrait/4.0>
  }
  box
  {
      <Arc_Largeur/2.0+Retrait/4.0, 0.0, -Arc_Profondeur/2.0-Retrait/4.0>
      <Arc_Largeur/6.0-Retrait/4.0, 4.0*Retrait, -Arc_Profondeur/6.0+Retrait/4.0>
  }
  box
  {
      <Arc_Largeur/2.0+Retrait/4.0, 0.0, Arc_Profondeur/2.0+Retrait/4.0>
      <Arc_Largeur/6.0-Retrait/4.0, 4.0*Retrait, Arc_Profondeur/6.0-Retrait/4.0>
  }

  box
  {
      <-Arc_Largeur/2.0+Arc_Largeur/9.0, 0.0, -Arc_Profondeur/2.0-2.0*Retrait>
      <-Arc_Largeur/2.0+2.0*Arc_Largeur/9.0, Arc_Hauteur/7.0+2.0*Retrait, -Arc_Profondeur/2.0>
  }
  box
  {
      <Arc_Largeur/2.0-Arc_Largeur/9.0, 0.0, -Arc_Profondeur/2.0-2.0*Retrait>
      <Arc_Largeur/2.0-2.0*Arc_Largeur/9.0, Arc_Hauteur/7.0+2.0*Retrait, -Arc_Profondeur/2.0>
  }
  box
  {
      <-Arc_Largeur/2.0+Arc_Largeur/9.0-Retrait, 0.0, -Arc_Profondeur/2.0-2.0*Retrait-Retrait>
      <-Arc_Largeur/2.0+2.0*Arc_Largeur/9.0+Retrait, 2.0*Retrait, -Arc_Profondeur/2.0>
  }
  box
  {
      <Arc_Largeur/2.0-Arc_Largeur/9.0+Retrait, 0.0, -Arc_Profondeur/2.0-2.0*Retrait-Retrait>
      <Arc_Largeur/2.0-2.0*Arc_Largeur/9.0-Retrait, 2.0*Retrait, -Arc_Profondeur/2.0>
  }
  box
  {
      <-Arc_Largeur/2.0+Arc_Largeur/9.0-Retrait/2.0, 0.0, -Arc_Profondeur/2.0-2.0*Retrait-Retrait/2.0>
      <-Arc_Largeur/2.0+2.0*Arc_Largeur/9.0+Retrait/2.0, 3.0*Retrait, -Arc_Profondeur/2.0>
  }
  box
  {
      <Arc_Largeur/2.0-Arc_Largeur/9.0+Retrait/2.0, 0.0, -Arc_Profondeur/2.0-2.0*Retrait-Retrait/2.0>
      <Arc_Largeur/2.0-2.0*Arc_Largeur/9.0-Retrait/2.0, 3.0*Retrait, -Arc_Profondeur/2.0>
  }
  box
  {
      <-Arc_Largeur/2.0+Arc_Largeur/9.0-Retrait/4.0, 0.0, -Arc_Profondeur/2.0-2.0*Retrait-Retrait/4.0>
      <-Arc_Largeur/2.0+2.0*Arc_Largeur/9.0+Retrait/4.0, 4.0*Retrait, -Arc_Profondeur/2.0>
  }
  box
  {
      <Arc_Largeur/2.0-Arc_Largeur/9.0+Retrait/4.0, 0.0, -Arc_Profondeur/2.0-2.0*Retrait-Retrait/4.0>
      <Arc_Largeur/2.0-2.0*Arc_Largeur/9.0-Retrait/4.0, 4.0*Retrait, -Arc_Profondeur/2.0>
  }
  box
  {
      <-Arc_Largeur/2.0+Arc_Largeur/9.0-Retrait/4.0, Arc_Hauteur/7.0, -Arc_Profondeur/2.0-2.0*Retrait-Retrait/4.0>
      <-Arc_Largeur/2.0+2.0*Arc_Largeur/9.0+Retrait/4.0, Arc_Hauteur/7.0+Retrait, -Arc_Profondeur/2.0>
  }
  box
  {
      <Arc_Largeur/2.0-Arc_Largeur/9.0+Retrait/4.0, Arc_Hauteur/7.0, -Arc_Profondeur/2.0-2.0*Retrait-Retrait/4.0>
      <Arc_Largeur/2.0-2.0*Arc_Largeur/9.0-Retrait/4.0, Arc_Hauteur/7.0+Retrait, -Arc_Profondeur/2.0>
  }
  box
  {
    <-Arc_Largeur/2.0+2.0*Retrait, Arc_Hauteur, -Arc_Profondeur/2.0+2.0*Retrait>
    <Arc_Largeur/2.0-2.0*Retrait, Arc_Hauteur+2.0*Retrait, Arc_Profondeur/2.0-2.0*Retrait>
  }
  texture { T13 }
}

/*******************************************/

height_field
{
  gif "..\Data\sculpture.gif"
  texture
  {
    pigment
    {
      image_map { gif "..\Data\sculpture.gif" map_type 0 interpolate 2 }
      rotate x*90
    }
    finish { ambient 0.35 }
  }
  rotate -90.0*x
  scale <1.5, 1.5*250.0/170.0, 1.0>
  scale <Arc_Largeur/9.0, Arc_Largeur/9.0, 0.2>
  translate <-Arc_Largeur/2.0+0.5*Arc_Largeur/9.0, Arc_Hauteur/7.0+2.0*Retrait, -Arc_Profondeur/2.0+0.1>
  rotate -20.0*y
  translate <685.0, 0.0, 436.0>
}

height_field
{
  gif "..\Data\sculpture.gif"
  texture
  {
    pigment
    {
      image_map { gif "..\Data\sculpture.gif" map_type 0 interpolate 2 }
      rotate x*90
    }
    finish { ambient 0.35 }
  }
  rotate -90.0*x
  scale <1.5, 1.5*250.0/170.0, 1.0>
  scale <Arc_Largeur/9.0, Arc_Largeur/9.0, 0.2>
  translate <Arc_Largeur/2.0-2.5*Arc_Largeur/9.0, Arc_Hauteur/7.0+2.0*Retrait, -Arc_Profondeur/2.0+0.1>
  rotate -20.0*y
  translate <685.0, 0.0, 436.0>
}


height_field
{
  gif "..\Data\fresque.gif"
  texture
  {
    pigment
    {
      image_map { gif "..\Data\fresque.gif" map_type 0 interpolate 2 }
      rotate x*90
    }
    finish { ambient 0.35 }
  }
  rotate -90.0*x
  scale <(-Arc_Largeur/6.0-2.0*Retrait)-(-Arc_Largeur/2.0+2.0*Retrait), 7.0*Retrait, 0.001>
  translate <-Arc_Largeur/2.0+2.0*Retrait, Arc_Hauteur/2.0+3.0*Retrait, -Arc_Profondeur/2.0+Retrait/4.0+0.1>
  rotate -20.0*y
  translate <685.0, 0.0, 436.0>
}

height_field
{
  gif "..\Data\fresque.gif"
  texture
  {
    pigment
    {
      image_map { gif "..\Data\fresque.gif" map_type 0 interpolate 2 }
      rotate x*90
    }
    finish { ambient 0.35 }
  }
  rotate -90.0*x
  scale <(-Arc_Largeur/6.0-2.0*Retrait)-(-Arc_Largeur/2.0+2.0*Retrait), 7.0*Retrait, 0.001>
  translate <Arc_Largeur/6.0+2.0*Retrait, Arc_Hauteur/2.0+3.0*Retrait, -Arc_Profondeur/2.0+Retrait/4.0+0.1>
  rotate -20.0*y
  translate <685.0, 0.0, 436.0>
}

height_field
{
  gif "..\Data\fresque.gif"
  texture
  {
    pigment
    {
      image_map { gif "..\Data\fresque.gif" map_type 0 interpolate 2 }
      rotate x*90
    }
    finish { ambient 0.35 }
  }
  rotate -90.0*x
  rotate -90.0*y
  scale <0.001, 7.0*Retrait, Arc_Profondeur-4.0*Retrait>
  translate <Arc_Largeur/2.0-Retrait/4.0-0.1, Arc_Hauteur/2.0+3.0*Retrait, -Arc_Profondeur/2.0+2.0*Retrait>
  rotate -20.0*y
  translate <685.0, 0.0, 436.0>
}

/*******************************************/

cylinder
{
  <0.0, 0.0, 0.0>
  <0.0, 0.11, 0.0>
  64.0/2.0
  texture { T12 }
  translate <685.0, 0.0, 436.0>
}

cylinder
{
  <0.0, 0.0, 0.0>
  <0.0, 0.1, 0.0>
  5.0+64.0/2.0
  texture { T04 }
  translate <685.0, 0.0, 436.0>
}

#declare Count = 1.0
#while (Count <= Nb_Plots)
  cone
  {
    <64.0/2.0, 0.0, 0.0>, D_Plots/2.0
    <64.0/2.0, D_Plots, 0.0>, D_Plots/3.0
    rotate 360.0*(Count/Nb_Plots)*y
    translate <685.0, 0.0, 436.0>
    texture { T13 }
  }
  sphere
  {
    <64.0/2.0, D_Plots, 0.0>
    D_Plots/4.0
    rotate 360.0*(Count/Nb_Plots)*y
    translate <685.0, 0.0, 436.0>
    texture { T10 }
  }
  cylinder
  {
    <64.0/2.0, D_Plots*0.8, 0.0>
    <(64.0/2.0)*cos(2.0*pi/Nb_Plots), D_Plots*0.8, (64.0/2.0)*sin(2.0*pi/Nb_Plots)>
    D_Plots/7.0
    rotate 360.0*(Count/Nb_Plots)*y
    translate <685.0, 0.0, 436.0>
    texture { T10 }
  }
  #declare Count = Count+1.0
#end

object
{
  Arc
  rotate -20.0*y
  translate <685.0, 0.0, 436.0>
}

light_source
{
  <Arc_Largeur/2.0+7.0*Retrait, 0.5, -Arc_Profondeur/2.0-7.0*Retrait>
  color rgb 0.5*<1.5, 0.8, 0.4>
  spotlight
  point_at <Arc_Largeur/2.0, Arc_Hauteur, -Arc_Profondeur/2.0>
  radius 45.0
  tightness 1.0
  falloff 50.0
  fade_distance 10.0
  fade_power 1.7
  atmosphere on
  rotate -20.0*y
  translate <685.0, 0.0, 436.0>
}

light_source
{
  <-Arc_Largeur/2.0-7.0*Retrait, 0.5, -Arc_Profondeur/2.0-7.0*Retrait>
  color rgb 0.5*<1.5, 0.8, 0.4>
  spotlight
  point_at <-Arc_Largeur/2.0, Arc_Hauteur, -Arc_Profondeur/2.0>
  radius 45.0
  tightness 1.0
  falloff 50.0
  fade_distance 10.0
  fade_power 1.7
  atmosphere on
  rotate -20.0*y
  translate <685.0, 0.0, 436.0>
}

light_source
{
  <Arc_Largeur/2.0+7.0*Retrait, 0.5, Arc_Profondeur/2.0+7.0*Retrait>
  color rgb 0.5*<1.5, 0.8, 0.4>
  spotlight
  point_at <Arc_Largeur/2.0, Arc_Hauteur, Arc_Profondeur/2.0>
  radius 45.0
  tightness 1.0
  falloff 50.0
  fade_distance 10.0
  fade_power 1.7
  atmosphere on
  rotate -20.0*y
  translate <685.0, 0.0, 436.0>
}

light_source
{
  <-Arc_Largeur/2.0-7.0*Retrait, 0.5, Arc_Profondeur/2.0+7.0*Retrait>
  color rgb 0.5*<1.5, 0.8, 0.4>
  spotlight
  point_at <-Arc_Largeur/2.0, Arc_Hauteur, Arc_Profondeur/2.0>
  radius 45.0
  tightness 1.0
  falloff 50.0
  fade_distance 10.0
  fade_power 1.7
  atmosphere on
  rotate -20.0*y
  translate <685.0, 0.0, 436.0>
}
