
#declare HAUTEUR_LAMPADAIRE = 10.0
#declare RAYON_LAMPADAIRE = 0.2

#declare Lampadaire = union
{
  cylinder { <0.0, 0.0, 0.0> <0.0, HAUTEUR_LAMPADAIRE, 0.0> RAYON_LAMPADAIRE texture { T11 } }
  difference
  {
    torus
    {
      HAUTEUR_LAMPADAIRE/4.0
      RAYON_LAMPADAIRE
      rotate 90.0*x
    }
    box
    {
      <-HAUTEUR_LAMPADAIRE, 0.0, -HAUTEUR_LAMPADAIRE>
      <HAUTEUR_LAMPADAIRE, -HAUTEUR_LAMPADAIRE, HAUTEUR_LAMPADAIRE>
    }
    translate <HAUTEUR_LAMPADAIRE/4.0, HAUTEUR_LAMPADAIRE, 0.0>
    texture { T11 }
  }
  difference
  {
    sphere { <0.0, 0.0, 0.0> RAYON_LAMPADAIRE*2.0 }
    cylinder { <0.0, RAYON_LAMPADAIRE*1.5, 0.0> <0.0, -3.0*RAYON_LAMPADAIRE, 0.0> RAYON_LAMPADAIRE }
    translate <HAUTEUR_LAMPADAIRE/2.0, HAUTEUR_LAMPADAIRE-RAYON_LAMPADAIRE, 0.0>
    texture { T11 }
  }
  light_source
  {
    <HAUTEUR_LAMPADAIRE/2.0, HAUTEUR_LAMPADAIRE-RAYON_LAMPADAIRE*1.9, 0.0>
    color rgb 1.2*<1.5, 1.3, 1.0>
    spotlight
    point_at <HAUTEUR_LAMPADAIRE/2.0, 0.0, 0.0>
    radius 45.0
    tightness 1.0           // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 50.0
    atmosphere on
  }
}
