#include "kolors.inc"
#include "chip.inc"
#include "plate2.pov"
#include "orange.pov"
#include "metals.inc"
#include "knife.inc"
#include "salad.inc"


camera {
 location <5,75*1.5,-112.5*1.5>
 look_at  <0,30,0>
 angle 60
 }

global_settings{ max_trace_level 15 }


light_source {<0,4000,0> White}
light_source {<-2000,4000,-4000> White}
//light_source {<0,4000,-4000> rgb<1,1,1>}
//light_source {<200,200,-400> White}

background {colour rgb <2,2,2>}

// ************************************* declarations

#declare fried = pigment { rgb<244/255,155/255,22/255>}

#declare R1 = seed(42);


#declare DoorWoodBr = pigment {rgb<0.62745098,0.25098039,0>}
#declare DoorWoodDa = pigment {rgb<0.78431372,0.31372549,0>}

#declare DoorTex = texture{

pigment{
wood
pigment_map {
 [0.3   bumps pigment_map{
        [0.3 DoorWoodBr]
        [0.7 DoorWoodDa]} scale <2,2,20> turbulence 0.3]
 [3.03  Black]}
 scale 0.1
 rotate <80,0,0>
 turbulence 0.07
 warp {
  black_hole <1,0,1>, 0.5
 } 
}

finish {diffuse 0.2
        brilliance 0.4
        diffuse 0.3
        ambient 0.2
        specular 0.35
        roughness 0.5
        reflection 0.05
}


normal{wood 
        scale <0.1,0.1,0.005>
        rotate <87,0,0>
        turbulence 0.07}


}

// ************************************* first layer of chips

object {chip 
        rotate <0,0.6*359,0> 
        translate <(0.6-0.5)*50+10,3.5,(0.1334-0.5)*50> }

object {chip 
        rotate <0,0*359,0> 
        translate <(0.543-0.5)*50,3.5,(0.567-0.5)*50+8> }

object {chip 
        rotate <0,0.7835*359,0> 
        translate <(0.1-0.5)*50+30,3.5,(0.78345-0.5)*50+10> }


object {chip 
        rotate <180,210,0> 
        translate <35,3,(-0.2)*70> }

object {chip 
        rotate <180,0.7835*359,0> 
        translate <-40,3,13> }

object {chip 
        rotate <180,0.7835*359,0> 
        translate <17,3,-40> }

object {chip
        rotate <0,0.23*359,0> 
        translate <31,3.5,25>}

object {chip
        rotate <0,70,0> 
        translate <-21,3,34>}

object {chip
        rotate <0,112,0> 
        translate <41,3,-5>}

object {chip
        rotate <180,5,0> 
        translate <-21,3.5,9>}

object {chip
        rotate <-90,30,0> 
        translate <5,0,-2>}


// second layer


object {chip
        rotate <180,280,0> 
        translate <13,7,0.2>}

object {chip
        rotate <180,0.73*359,0> 
        translate <1.564,7,12>}

object {chip
        rotate <0,-101,0> 
        translate <45.7,8,-14>}

object {chip
        rotate <0,10,10> 
        translate <-17,8,25>}

object {chip 
       rotate <0,175,-8> 
        translate <43,9,22>}

object {chip
       rotate <90,98,0> 
       translate <-22,9,32>}

// ************************************* plate


object{plate scale <22,20,22>}

// ************************************* fried fish

height_field {tga "fried.tga" 
              smooth 
              water_level 0.05
              texture {pigment{bozo pigment_map{
                                [0.3  Tan2]
                                [0.4  Salmon2]
                                [0.56 Sienna5]
//                                  [0.2  Tan2]   
//								  [0.3  Salmon2]
//								  [0.46 Sienna5]
												}
                                turbulence 0.5
                                scale 0.005}
                       normal{bumps scale 3}
                       finish{ambient 0.1 
                              specular 0.1
                              roughness 0.1
                              diffuse 0.3
                              crand 0.05
                              reflection 0.05}}
		      translate <-0.5,0,-0.5>
              scale <100,8,75>
              rotate <0,10,0>
              translate <-20,3,-25>}

// ************************************* ketchup

blob {
  threshold 0.5
  sphere {<0,0,0>,20,1 scale <1,0.4,1> }
  sphere {<-4,0,-13>,20,1 scale <1,0.4,1> }
  sphere {<-12,0,3>,10,1 scale <1,0.4,1> }
  sphere {<6,0,-13>,14,1 scale <1,0.4,1> }
  sphere {<-14,0,-20>,24,1 scale <1,0.4,1> }
  sphere {<-20,0,9>,18,1 scale <1,0.4,1> }
  sphere {<-12,3,2>,10,1 scale <1,0.3,1> }
  sphere {<-11,5,-0>,6,1 scale <1,0.3,1> }
  translate <22,0,-29>
  rotate <0,-5,0>  
  texture{
    pigment {Red       }
    finish {diffuse 0.4
            ambient 0.2
            specular 0.5
            roughness 0.01
            reflection 0.01
            crand 0.1}
    normal {bumps scale 0.25}
  }
 }

// ***************************************************** table


#declare i = 0;
#declare rd = seed(210371);

#while (i < 7)
 
 box {<-250,0,190 - i*40>,<250,-40,150 - i*40> 
        texture {DoorTex 
                   scale 100 
                   translate <100 * rand(rd) - 50,0,400 * rand(rd) -200>}
 }

 #declare i = i + 1;

#end

// ************************************************* glass with lemonade

union{
   object{o_glass interior{I_Glass} texture{T_Glass3}}

   object{juice
              texture {
                pigment{Gold transmit 0.2}
                finish {diffuse 0.1
                        ambient 1.6}
                       }
                interior{ior 1.33}
                }

  translate <80,3,105>
}

// ************************************************* Water drops

sphere {0,10 
         scale <1,0.125,1> 
         pigment {rgbt<1,1,1,1>}
         translate <70,3.5,65>
         interior {ior 1.33} }
sphere {0,4 
         scale <1,0.125,1> 
         pigment {rgbt<1,1,1,1>}
         translate <124,3.3,110>
         interior {ior 1.33}}

// ************************************************* panel

#declare screwhead = object{
difference{
  intersection{
    sphere {0,2}
    cone {<0,0,-3>,2,<0,0,1>,1}
  }
  box {<-0.5,2.5,-4>,<0.5,-2.5,-1>}
}
texture {T_Brass_4C}
}

difference{
  union{
   box {<-250,0,190>,<250,25,210>}
   cylinder {<-250,25,200>,<250,25,200>,10}
   pigment {Gray50}
  }
  cone {<0,0,-6>,4,<0,0,1>,1 scale 2 translate <0,20,192> }
  cone {<0,0,-6>,4,<0,0,1>,1 scale 2 translate <-170,20,192> }
  cone {<0,0,-6>,4,<0,0,1>,1 scale 2 translate <170,20,192> }
}

object {screwhead  scale 2
        rotate <0,0,rand(R1)*170>
        translate <0,20,194>
        }

object {screwhead  scale 2
        rotate <0,0,rand(R1)*170>
        translate <-170,20,194>
        }

object {screwhead  scale 2
        rotate <0,0,rand(R1)*1070>
        translate <170,20,194>
        }

// **************************************************** panel #2


#declare panel2 = object{
  union{
    box {<0,-1000,0>,<80,1000,30>}
    box {<70,-1000,10>,<100,1000,20>}
  }
}

#declare i = 0;

#while (i < 10)
 object{panel2 
          translate<-500+i*100,0,200>
          texture {DoorTex 
				     scale 100
                     rotate <90,0,0> 
                     translate <1000*rand(R1)-500,
                                1000*rand(R1)-500,
                                200*rand(R1)-100>
                  }
       }
 #declare i = i + 1;

#end
            
// ********************************************************* salt

union{
difference{                                    // glass body
  merge{
  cylinder {<0,0,0>,<0,5,0>,16}
  cylinder {<0,4,0>,<0,52,0>,20}
  torus    {16,4 translate <0,52,0>}
  cylinder {<0,55,0>,<0,60,0>,15}
 }
 #declare i = 0;
 #while (i<8)
  union{
   sphere{<20,12,0>,4}
   sphere{<20,52,0>,4}
   cylinder {<20,12,0>,<20,52,0>,4}
   rotate <0,i*45,0>
  }
  #declare i = i + 1;
 #end
 cylinder {<0,8,0>,<0,51,0>,15}
 cylinder {<0,50,0>,<0,61,0>,12}
 interior{I_Glass} 
 texture{T_Glass3}
}

difference{                             // metallic cap
 union{
  cylinder {<0,60,0>,<0,68,0>,14}
  cylinder {<0,68,0>,<0,70,0>,12}
  torus    {12,2 translate <0,68,0>}
 }
 cylinder {<0,67,0>,<0,71,0>,0.5}
 #declare i = 0;
 #while (i<6)
  cylinder {<0,67,0>,<0,71,0>,0.5
            translate <4,0,0>
            rotate <0,60*i,0>}
  #declare i = i + 1;
 #end 
 #declare i = 0;
 #while (i<12)
  cylinder {<0,67,0>,<0,71,0>,0.5
            translate <8,0,0>
            rotate <0,30*i+15,0>}
  #declare i = i + 1;
 #end
 texture {pigment {Gray95}
           finish  {ambient 0.1
           diffuse 0.1
           reflection 0.5
           specular   0.5
           roughness 0.01
           metallic}
         }  
} 
 cylinder {<0,8.001,0>,<0,34,0>,14.999 // salt part 1
             pigment{rgb<3,3,3>} 
             finish{crand 0.3}
          }
 cone {<0,34,0>,14.999,<0,37,0>,2.2    // salt part 2
             pigment{rgb<3,3,3>} 
             finish{crand 0.1 
                    ambient 1.0
                    diffuse 0.8
                   }
          }

 scale 0.7
 translate <-120,3,91>
}

// ************************************************* vinegar

union{
 difference{
   merge{
   sphere   {<0,75,0>,25}                     // glass body
   cylinder {<0,4,0>,<0,75,0>,25}
   torus    {21,4 translate <0,4,0>}
   cone     {<0,75,0>,12.5,<0,120,0>,8}
  }
 cylinder {<0,6,0>,<0,75,0>,23}
 sphere   {<0,75,0>,23}
 cone {<0,74,0>,11,<0,121,0>,6}
 interior{I_Glass}
 texture {T_Glass3} 
 } 
 difference{
  merge{
   cone {<0,124,0>,9,<0,144,0>,3}            // red cap
   cylinder {<0,120,0>,<0,124,0>,9}
  }
 cylinder {<0,115,0>,<0,175,0>,2}
 texture {pigment{Firebrick2}
          finish {ambient 0.4
                  diffuse 0.3
                  phong 1.4
                  phong_size 150}
          }
}
cylinder {<0,6.001,0>,<0,62,0>,22.999 
             texture {
//                 pigment{rgbt<151/255,34/255,34/255,0.5>}
				   pigment{DarkRed transmit 0.4}
//                 finish {diffuse 3
//                        ambient 0.1}
               }
                interior{ior 1.33}}
scale 0.65
translate <-60,3,63>
}

