// Sand08.POV    3/6/99                      Ian & Ethel MacKay

#include "colors.inc"



background { color rgb < 0.2, 0, 0.2 > }

light_source { < 0, 50, 300 > color rgb < 0.4, 0.25, 0.13 >  }   
light_source { < 0, 150, -300 > color rgb < 0.3, 0.3, 0.5 > shadowless  }  
light_source { < 0, 5, 30 > color  rgb < 0.4, 0.25, 0.13 > 
                                     
                spotlight
                point_at < 0, 0, -15 >
                falloff 10
                radius 5
                tightness 10
             }
 
camera {
        location  < 0, 5, -20 > 
        look_at   < -1, 0, -3 >       
        angle 35
       }

#declare Sand =
           texture {
              pigment {  color  rgb < 0.9, 0.6, 0.4 > }   
              finish { ambient 0.2 }
                   }
#declare Toe =       
              sphere { < 0, 0, 0 >,0.55
                     texture { Sand }
                      }
#declare Foot =
           union {
sphere { < 0, 0, 0 >,1               // ball of foot
         scale < 1.8, 0.5, 1 >
         rotate 20*y
          texture { Sand } 
       }
sphere { < 0, 0, 0 >,1                 // heel
         scale < 1, 0.5, 1.25 > 
         translate -5*z
          texture { Sand } 
       }
cylinder { < 0.6, 0, -3.35 >,< 0.8, 0, -2.3 >,0.5         // instep
             scale < 1, 0.5, 1 >
              texture { Sand } 
        }
cone { < 0.6, 0, -3.25 >,0.5,< 0, 0, -5 >,1               // instep
             scale < 1, 0.5, 1 >
              texture { Sand } 
        }
cone { < 0.8, 0, -2.5 >,0.5,< 0.8, 0, -0.5 >,0.8             // instep
             scale < 1, 0.5, 1 >
              texture { Sand } 
        }
object { Toe rotate -10*y 
         translate < -1.25, 0, 2.27 >
       }
object { Toe  scale 0.75
         translate < 0, 0, 2.02 >
       }
object { Toe  scale 0.5 rotate 5*y 
         translate < 0.7, 0, 1.52 >
       }
object { Toe scale 0.4 rotate 10*y 
         translate < 1.25, 0, 1.2 >
       }
object { Toe scale 0.3 rotate 15*y 
         translate < 1.75, 0, 0.52 >
       }
       rotate 180*y
       scale 0.18
            }
#declare Lfoot =
           object { Foot rotate 180*z  }

#declare Prints =
           union { 
object { Lfoot rotate 40*y translate < 4, 0, 44 > }  
object { Foot rotate 30*y translate < 2, 0, 42.5 > }  
object { Lfoot rotate 20*y translate < 1.2, 0, 40 > }  
object { Foot rotate 10*y translate < -0.5, 0, 38 > } 
object { Lfoot translate < 0, 0, 35.5 > }  
object { Foot translate < -1, 0, 32.5 > }  
object { Lfoot rotate -10*y translate < 0.5, 0, 28 > }  
object { Foot rotate -20*y translate < 0, 0, 25.3 > }  
object { Lfoot rotate < 3, -20, 0 > translate < 1.8, 0, 23 > }  
object { Foot rotate -20*y translate < 1.8, 0, 20 > }  
object { Lfoot rotate -45*y translate < 3.5, 0, 17.5 > }   
object { Foot rotate -15*y translate < 2.7, 0, 14.8 > } 
object { Lfoot rotate -5*y translate < 3.8, 0, 12.3 > }   
object { Foot  translate < 2.8, 0, 9.5 > } 
object { Lfoot rotate 5*y translate < 4, 0, 7 > }  
object { Foot rotate 5*y translate < 3, 0, 4.5 > }  
object { Lfoot rotate 15*y  translate < 3, 0, 1.8 > }
object { Foot rotate 30*y translate < 1.5, 0, -0.5 > }  
object { Lfoot rotate 20*y translate < 1.3, 0, -3.3 > }  
object { Foot rotate 45*y translate < -0.7, 0, -5 > }
object { Lfoot rotate  20*y translate < 0.1, 0, -6 > } 
               }
#declare Near =
height_field {                                
              tga "wrinc2.tga"
              translate < -0.5, -0.5, -0.5 >
              rotate 180*y
              scale < 30, 3, 45 >
              pigment {  
                       gradient y
                       color_map {
                                  [ 0.0 color rgb < 0.7, 0.6, 0.4 > ]
                                  [ 0.3 color rgb < 0.9, 0.8, 0.4 > ]
                                  [ 0.6 color rgb < 0.7, 0.5, 0.3 > ]
                                  [ 1.0 color rgb < 0.9, 0.8, 0.4 > ]
                                  }
                            scale 0.1
                         }
              normal { granite scale 0.001 }
              finish { ambient 0.2 }
              }
#declare Closer =
height_field {                                       
              tga "wrinc2.tga"
              translate < -0.5, -0.5, -0.5 >
              scale < 30, 15, 35 >
              pigment {  
                       bozo
                       turbulence 0.75
                       color_map {
                                  [ 0.0 color rgb < 0.9, 0.8, 0.4 > ]  
                                  [ 0.5 color rgb < 0.2, 0.6, 0.2 > ]
                                  [ 1.0 color rgb < 0.8, 0.5, 0.5 > ]
                                  }
                         scale 0.5
                      }
              normal { granite scale 0.05 }
              finish { ambient 0.3 }
              }
object { Near translate < -1, 0, 25 > }
object { Closer translate < 0, 0, -5 >  } 
plane { y, -0.025                  
        pigment { color rgb < 0.6, 0.5, 0.3 > }
        normal { wrinkles 0.1 scale 0.1 }
        finish { ambient 0.2
                 reflection 0.6
                 phong 1 }
     }
difference {
           plane { y, 0
             texture {
              pigment {  color rgb < 0.9, 0.6, 0.4 > }  
              normal { waves 0.05 turbulence 0.8 scale 0.5 
                        translate -13*z }
              finish { ambient 0.2 
                       phong 1 
                       phong_size 80 }
                     }
              texture {
                      pigment { color Clear }
                      normal { wrinkles 0.25 scale 0.5 }
                      finish { ambient 0.2
                               phong 1 
                               phong_size 80 }
                      }
               }
           object { Prints translate < -1, 0, 0 > }
           }
#declare Spear =
          union {
          sphere { < 0, 0, 0 >,0.12
                    scale < 3, 0.3, 1 >
                    translate -2.2*x
                    pigment { color White }
                    finish { ambient 0.2 }
                 }   
          cylinder { < -2, 0, 0 >,< -1.25, 0, -0.05 >,0.04 }
          sphere { < -1.25, 0, -0.05 >,0.04 }  
          cylinder { < -1.25, 0, -0.05 >,< 0, 0, 0 >,0.04 } 
          sphere { < 0, 0, 0 >,0.04 } 
          cylinder { < 0, 0, 0 >,< 1.25, 0, 0.05 >,0.04 } 
          sphere { < 1.25, 0, 0.05 >,0.04 } 
          cylinder { < 1.25, 0, 0.05 >,< 2.3, 0.07, 0 >,0.04 } 
          sphere { < 2.3, 0.07, 0 >,0.04 } 
          cylinder { < 2.3, 0.07, 0 >,< 3.5, 0.17, -0.05 >,0.04 }  
          sphere { < 3.5, 0.17, -0.05 >,0.04 } 
          cylinder { < 3.5, 0.17, -0.05 >,< 5, 0.28, 0 >,0.04  }
                    pigment { color rgb < 0.8, 0.6, 0.3 > }
                    finish { ambient 0.3 }
                 }
object { Spear rotate < 0, -65, -5 > translate < -3, 0, -5 > }
