
// Persistence of Vision Ray Tracer Scene Description File
// File: mg_cwg.pov
// Vers: 3.1e
// Desc: IRTC unbelievable/There is no time
// Date: June 29, 1999
// Auth:Marjorie Graterol


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	
#include "textures.inc"
#include "mg_cwgtx.inc"

 
global_settings {  assumed_gamma 1.8  }	
global_settings {
radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.3
    gray_threshold   0.1
    low_error_factor 0.4
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  2
  }}
camera
{
  location  <14 , 2, -30>
  look_at   <6 ,0.40 , 30>
  
}

light_source
{
    <-20,100,20>
    color MediumTurquoise
    fade_power 10
 }

light_source {
    <10,50,5>
    color Very_Light_Purple
    spotlight
    radius 10
    falloff 12
    tightness 10
    point_at <1,12,1>
  } 

  light_source {
    <15,50,-10.2>
    color SummerSky
    spotlight
    radius 40
    falloff 10
    tightness 50
    point_at <12,0.80,-25>
  } 


light_source {
    <-15, 50,8>
    color Light_Purple
    spotlight
    radius 30
    falloff 10
    tightness 50
    point_at <-10, 2,10>
  } 
  
light_source {
    <-15, 50,8>
    color Light_Purple
    spotlight
    radius 30
    falloff 10
    tightness 50
    point_at <50, 2.0, 70>
  } 

light_source {
    <15,50,-20.2>
    color SummerSky
    spotlight
    radius 30
    falloff 10
    tightness 50
    point_at <15,3,-15>
  } 
 //ilumina arcada derecha
 light_source {
    <23,10,-100>
    color Gray10
    spotlight
    radius 10
    falloff 10
    
    tightness 70
    point_at<24,4,-2>
  }
 // ilumina reloj de arena

 light_source {
    <12,10,-100>
    color Gray05
    spotlight
    radius 5
    falloff 10
    
    tightness 70
    point_at<15,5,-15>
  } 
  
  //luz lantern
  light_source {
    <8,10,-24>
    color Gray70
    spotlight
    radius 10
    falloff 10
    
    tightness 70
    point_at<6.5,2.0,-20>
  } 
  
  
  
  //agua
  plane { y, 1
   pigment { CornflowerBlue filter 0.80 transmit 0.20}
   normal {
      waves 0.06
      frequency 300.0
      scale 125}
   finish {
      ambient 0.1
      diffuse 0.1
      reflection 0.8
   }
   interior {caustics 0.6}
}
 
 
 
 //
plane { y, -1
   pigment {CornflowerBlue}
   normal {
      bump_map
{
  tga "mayacal.tga"
  map_type 1
  interpolate 2//4
    once
  bump_size 3.0
}}
finish {
ambient .2
diffuse .6
phong 5
phong_size 120
   }
rotate -90*x


}

#include "reloj.inc"
 object{reloj
 scale 2
 translate <15,3,-15> }
 
 light_source {
    <-10,50,-5>
    color rj16 filter 0.5
    spotlight
    radius 20
    falloff 12
    tightness 10
    point_at <12,0.50,-25>
  } 
#include "maya3.inc" 
object {mayan
translate <12,0.50,-25>
} 
#include "golds.inc"
#include "maya4.inc"

#declare arcada=
 union{
  object{arco scale 4 rotate -90*x  translate <22,4,-2>}
  object{arco scale 4 rotate -90*x  rotate 90*y translate <24,4,-4>}
  object{arco scale 4 rotate -90*x  rotate 90*y translate <24,4,-9>}
  
  } 
  object{arcada }
    
  object{arco scale 4 rotate -90*x translate <12,4,-2>} 
  object{arco scale 4 rotate -90*x translate <7,4,-2>}
  object{arco scale 4 rotate -90*x translate <2,4,-2>}
 

#include "mundo.inc"
union{  
object {mundo1 
scale 3
translate <10,1,-20> } 

sphere{<0,0,0> 1
hollow

texture {Glass3}
translate <10,1,-20>
}
}

#include "golds.inc"
#include "jlant.inc" 
object{lantern scale 1.25 rotate -45*y translate <6.5,2.75,-20>}

// >>> AberGranitePR (from File "povlab.inc") <<<
#declare AberGranitePR = texture {
  pigment {
    granite
    turbulence 0.70
    color_map {
      [0.00 color rgb<0.20, 0.20, 0.20>]
      [0.31 color rgb<0.57, 0.53, 0.51>]
      [1.00 color rgb<0.77, 0.66, 0.64>]
    }
  }
  normal {
    bumps 0.10
    scale <0.20,0.20,0.20>
  }
  finish {
    ambient 0.50
    diffuse 1.00
    crand 0.250
  }
}


#include "sol.inc"
object {sol texture {AberGranitePR} 
//scale 2 
translate <16,0.75,-24>}




#declare infinite=
merge{
torus
{
  0.1,
  0.025

translate <0,0,0>}

torus
{
  0.1,
  0.025

translate <0.2,0,0>}
 }
 
 object {infinite 
 texture {chains} 
 rotate 90*x 
 rotate 30*y 
 translate
 <15,0.95,-27>}
