#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "stones.inc"
#include "stars.inc"
#include "rdgranit.map"


#declare KOD           = 0;
#declare FENYEK        = 0;
#declare ALMA_GOMBBEN  = 1;
#declare TALAPZAT      = 1;
#declare CSILLAGOK     = 0;
#declare ALATET        = 1;
#declare PEZSGOSPOHAR  = 0;
#declare GYERTYA       = 1;
#declare BILLENTYUZET  = 1;

#declare MINOSEG       = 1;


global_settings  { assumed_gamma 1.0 
                   //ambient_light White *0.75
                  }
camera {
        location <0, 30, -150> // 0 30 -100
        up y
        right x*1.33
        direction z
        look_at <16 0 -15> // 0 5 0           0 20 0
        angle 39 // 57
}
                        


                        
#declare every_first_key        = 0;
#declare Z_diff                 = array[13] { 0.0  ,   // feher
                                             -0.3  ,   //   fekete
                                             -2.3  ,   // feher
                                             -3.15 ,   //   fekete
                                             -4.6  ,   // feher
                                             -6.9  ,   // feher
                                             -7.15 ,   //   fekete
                                             -9.2  ,   // feher
                                             -9.8  ,   //   fekete
                                             -11.45,   // feher
                                             -12.55,   //   fekete
                                             -13.8 ,   // feher
                                             -16.1     // ??????
                                            }
       
#declare feher_billentyu_texture =
        #if (MINOSEG = 0)
                texture { pigment { White }}
        #else
        texture {  
                pigment {
                        wrinkles
                        turbulence .8
                        octaves 7
                        omega 1
                        lambda 1.5
                        scale <3.0, 1, 1>
                        colour_map      {
                                        [0.33 color red 1.0 green 1.0 blue 1.0]  // red 0.8 green 0.8 blue 0.6
                                        [0.66 color red 0.9 green 0.9 blue 0.8]  // red 0.7 green 0.7 blue 0.4
                                        [1.0  color red 0.7 green 0.7 blue 0.4]  // red 0.7 green 0.7 blue 0.0
                                        }
                }
                finish  {
                        phong            1.0 
                        phong_size       200
                        roughness        0.001
                        ambient          0.05
                        diffuse          0.6
                        crand            0.05
                        specular         1.00
                        reflection       0.25 
                        }
                }
         #end       

  
#declare fekete_billentyu_texture =
        #if (MINOSEG = 0)
                pigment {color Black } // <0.05 0.05 0.05>}                 
        #else
        texture {
                
                pigment { color < 0.001 0.001 0.001> }        
                finish  { 
                        phong            1.0
                        phong_size       200
                        roughness        0.001
                        ambient          0.05
                        diffuse          0.6
                        crand            0.05
                        specular         0.05
                        reflection       0.25
                        }     
                 }
        #end        


#declare feher_bal_szelso  = 
       merge 
        {
                
                box 
                {       
                        < 0.3 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                        < 4.8 , 2.1 , 2.2>
                //        pigment { Blue }
                }
                
                box 
                {       
                        < 0.4 , 2.1 , 0.1>     // a billenytu uj reszenek felso lapos kisebb resze
                        < 4.8 , 2.2 , 2.1>
                //        pigment { Red }
                }                    

                box 
                {       
                        < 0.1 , 2.0 , 0.1>     // a billenytu uj reszenek elso kinyulo resze
                        < 0.4 , 2.2 , 2.1>
                //        pigment { Yellow }
                }
                
                box 
                {       
                        < 4.8 , 0.0 , 1.0>     // a billenytu szara also nagy resze
                        <13.8 , 2.1 , 2.2>
                //        pigment { Brown }
                }

                box 
                {       
                        < 4.8 , 2.1 , 1.1>     // a billenytu szara felso lapos resze
                        <13.8 , 2.2 , 2.1>
                //        pigment { Pink }
                }

                cylinder
                {       
                        < 0.1 , 2.1 , 2.1>    // lekerekites a bal oldalon
                        <13.8 , 2.1 , 2.1>
                        0.10             
                //        pigment { Cyan }
                }                      

                cylinder
                {       
                        < 0.1 , 2.1 , 0.1>    // lekerekites a jobb oldalon
                        < 4.8 , 2.1 , 0.1>
                        0.10             
                //        pigment { Cyan }
                }                      
                cylinder
                {       
                        < 4.8 , 2.1 , 1.1>     // a billenytu szara felso jobb oldalank lekerekitese
                        <13.8 , 2.1 , 1.1>
                        0.10
                //        pigment { Blue }
                }

                cylinder
                {       
                        < 0.1 , 2.10 , 0.1>    // lekerekites az elejen
                        < 0.1 , 2.10 , 2.1>
                        0.1             
                //        pigment { Cyan }
                }                       
                
                sphere {<0.1 , 2.10 , 0.1> 0.1 // jobb oldalon kerekito gomb
                //        pigment {Red}
                       }
                
                sphere {<0.1 , 2.10 , 2.1> 0.1 // bal oldalon kerekito gomb
                //        pigment {Red}
                       }
                                          
                bounded_by { box 
                                {       
                                < 0.0 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                                <13.8 , 2.2 , 2.2>
                             //   pigment { Blue }
                                }
                           }                                          
        
        texture {feher_billentyu_texture}
        }       
        

#declare feher_jobb_szelso = 
       merge 
        {
                
                box 
                {       
                        < 0.3 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                        < 4.8 , 2.1 , 2.2>
                //        pigment { Blue }
                }
                
                box 
                {       
                        < 0.4 , 2.1 , 0.1>     // a billenytu uj reszenek felso lapos kisebb resze
                        < 4.8 , 2.2 , 2.1>
                //        pigment { Red }
                }                    

                box 
                {       
                        < 0.1 , 2.0 , 0.1>     // a billenytu uj reszenek elso kinyulo resze
                        < 0.4 , 2.2 , 2.1>
                //        pigment { Yellow }
                }
                
                box 
                {       
                        < 4.8 , 0.0 , 0.0>    //1.0 a billenytu szara also nagy resze
                        <13.8 , 2.1 , 1.2>    //1.2
                //        pigment { Brown }
                }

                box 
                {       
                        < 4.8 , 2.1 , 0.1>     //1.1 a billenytu szara felso lapos resze
                        <13.8 , 2.2 , 1.1>     //2.1
                //        pigment { Pink }
                }

                cylinder
                {       
                        < 0.1 , 2.1 , 2.1>    // lekerekites a bal oldalon
                        < 4.8 , 2.1 , 2.1>    // 13.8
                        0.10             
                //        pigment { Cyan }
                }                      

                cylinder
                {       
                        < 0.1 , 2.1 , 0.1>    // lekerekites a jobb oldalon
                        <13.8 , 2.1 , 0.1>   // 4.8
                        0.10             
                //        pigment { Cyan }
                }                      
                cylinder
                {       
                        < 4.8 , 2.1 , 1.1>     // a billenytu szara felso jobb oldalank lekerekitese
                        <13.8 , 2.1 , 1.1>
                        0.10
                //        pigment { Blue }
                }

                cylinder
                {       
                        < 0.1 , 2.10 , 0.1>    // lekerekites az elejen
                        < 0.1 , 2.10 , 2.1>
                        0.1             
                //        pigment { Cyan }
                }                       
                
                sphere {<0.1 , 2.10 , 0.1> 0.1 // jobb oldalon kerekito gomb
                //        pigment {Red}
                       }
                
                sphere {<0.1 , 2.10 , 2.1> 0.1 // bal oldalon kerekito gomb
                //      pigment {Red}
                       }
                bounded_by { box 
                                {       
                                < 0.0 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                                <13.8 , 2.2 , 2.2>
                             //   pigment { Blue }
                                }
                           }                                          
                
        texture {feher_billentyu_texture}
        }       

#declare feher_bal_kozepso = 
       merge 
        {
                
                box 
                {       
                        < 0.3 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                        < 4.8 , 2.1 , 2.2>
                //        pigment { Blue }
                }
                
                box 
                {       
                        < 0.4 , 2.1 , 0.1>     // a billenytu uj reszenek felso lapos kisebb resze
                        < 4.8 , 2.2 , 2.1>
                //        pigment { Red }
                }                    

                box 
                {       
                        < 0.1 , 2.0 , 0.1>     // a billenytu uj reszenek elso kinyulo resze
                        < 0.4 , 2.2 , 2.1>
                //        pigment { Yellow }
                }
                
                box 
                {       
                        < 4.8 , 0.0 , 0.7>    //0.0 a billenytu szara also nagy resze
                        <13.8 , 2.2 , 1.9>    //1.2
                //        pigment { Brown }
                }

                cylinder
                {       
                        < 0.1 , 2.1 , 2.1>    // lekerekites a bal oldalon
                        < 4.8 , 2.1 , 2.1>    // 13.8
                        0.10             
                //        pigment { Cyan }
                }                      

                cylinder
                {       
                        < 0.1 , 2.1 , 0.1>    // lekerekites a jobb oldalon
                        < 4.8 , 2.1 , 0.1>   // 13.8
                        0.10             
                //        pigment { Cyan }
                }                      

                cylinder
                {       
                        < 0.1 , 2.10 , 0.1>    // lekerekites az elejen
                        < 0.1 , 2.10 , 2.1>
                        0.1             
                //        pigment { Cyan }
                }                       
                
                sphere {<0.1 , 2.10 , 0.1> 0.1 // jobb oldalon kerekito gomb
                //        pigment {Red}
                       }
                
                sphere {<0.1 , 2.10 , 2.1> 0.1 // bal oldalon kerekito gomb
                //        pigment {Red}
                       }
                bounded_by { box 
                                {       
                                < 0.0 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                                <13.8 , 2.2 , 2.2>
                             //   pigment { Blue }
                                }
                           }                                          
                
        
        texture {feher_billentyu_texture}        
        }       

#declare feher_jobb_kozepso = 
       merge 
        {
                
                box 
                {       
                        < 0.3 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                        < 4.8 , 2.1 , 2.2>
                //        pigment { Blue }
                }
                
                box 
                {       
                        < 0.4 , 2.1 , 0.1>     // a billenytu uj reszenek felso lapos kisebb resze
                        < 4.8 , 2.2 , 2.1>
                //        pigment { Red }
                }                    

                box 
                {       
                        < 0.1 , 2.0 , 0.1>     // a billenytu uj reszenek elso kinyulo resze
                        < 0.4 , 2.2 , 2.1>
                //        pigment { Yellow }
                }
                
                box 
                {       
                        < 4.8 , 0.0 , 0.3>    //0.0 a billenytu szara also nagy resze
                        <13.8 , 2.2 , 1.6>    //1.2
                //        pigment { Brown }
                }

                cylinder
                {       
                        < 0.1 , 2.1 , 2.1>    // lekerekites a bal oldalon
                        < 4.8 , 2.1 , 2.1>    // 13.8
                        0.10             
                //        pigment { Cyan }
                }                      

                cylinder
                {       
                        < 0.1 , 2.1 , 0.1>    // lekerekites a jobb oldalon
                        < 4.8 , 2.1 , 0.1>   // 13.8
                        0.10             
                //        pigment { Cyan }
                }                      

                cylinder
                {       
                        < 0.1 , 2.10 , 0.1>    // lekerekites az elejen
                        < 0.1 , 2.10 , 2.1>
                        0.1             
                //        pigment { Cyan }
                }                       
                
                sphere {<0.1 , 2.10 , 0.1> 0.1 // jobb oldalon kerekito gomb
                //        pigment {Red}
                       }
                
                sphere {<0.1 , 2.10 , 2.1> 0.1 // bal oldalon kerekito gomb
                //        pigment {Red}
                       }
                bounded_by { box 
                                {       
                                < 0.0 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                                <13.8 , 2.2 , 2.2>
                             //   pigment { Blue }
                                }
                           }                                          
                
        
        texture {feher_billentyu_texture}        
        }       

#declare feher_kozepso = 
       merge 
        {
                
                box 
                {       
                        < 0.3 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                        < 4.8 , 2.1 , 2.2>
                //        pigment { Blue }
                }
                
                box 
                {       
                        < 0.4 , 2.1 , 0.1>     // a billenytu uj reszenek felso lapos kisebb resze
                        < 4.8 , 2.2 , 2.1>
                //        pigment { Red }
                }                    

                box 
                {       
                        < 0.1 , 2.0 , 0.1>     // a billenytu uj reszenek elso kinyulo resze
                        < 0.4 , 2.2 , 2.1>
                //        pigment { Yellow }
                }
                
                box 
                {       
                        < 4.8 , 0.0 , 0.4>    //0.0 a billenytu szara also nagy resze
                        <13.8 , 2.2 , 1.8>    //1.2
                //        pigment { Brown }
                }

                cylinder
                {       
                        < 0.1 , 2.1 , 2.1>    // lekerekites a bal oldalon
                        < 4.8 , 2.1 , 2.1>    // 13.8
                        0.10             
                //        pigment { Cyan }
                }                      

                cylinder
                {       
                        < 0.1 , 2.1 , 0.1>    // lekerekites a jobb oldalon
                        < 4.8 , 2.1 , 0.1>   // 13.8
                        0.10             
                //        pigment { Cyan }
                }                      

                cylinder
                {       
                        < 0.1 , 2.10 , 0.1>    // lekerekites az elejen
                        < 0.1 , 2.10 , 2.1>
                        0.1             
                //        pigment { Cyan }
                }                       
                
                sphere {<0.1 , 2.10 , 0.1> 0.1 // jobb oldalon kerekito gomb
                //        pigment {Red}
                       }
                
                sphere {<0.1 , 2.10 , 2.1> 0.1 // bal oldalon kerekito gomb
                //        pigment {Red}
                       }
                bounded_by { box 
                                {       
                                < 0.0 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                                <13.8 , 2.2 , 2.2>
                             //   pigment { Blue }
                                }
                           }                                          
                
        
        texture {feher_billentyu_texture}        
        }       

#declare feher_legszelso = 
       merge 
        {
                
                box 
                {       
                        < 0.3 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                        <13.8 , 2.1 , 2.2>
                //        pigment { Blue }
                }
                
                box 
                {       
                        < 0.4 , 2.1 , 0.1>     // a billenytu uj reszenek felso lapos kisebb resze
                        <13.8 , 2.2 , 2.1>
                //        pigment { Red }
                }                    

                box 
                {       
                        < 0.1 , 2.0 , 0.1>     // a billenytu uj reszenek elso kinyulo resze
                        < 0.4 , 2.2 , 2.1>
                //        pigment { Yellow }
                }
                
                cylinder
                {       
                        < 0.1 , 2.1 , 2.1>    // lekerekites a bal oldalon
                        <13.8 , 2.1 , 2.1>    // 13.8
                        0.10             
                //        pigment { Cyan }
                }                      

                cylinder
                {       
                        < 0.1 , 2.1 , 0.1>    // lekerekites a jobb oldalon
                        <13.8 , 2.1 , 0.1>   // 13.8
                        0.10             
                //        pigment { Cyan }
                }                      

                cylinder
                {       
                        < 0.1 , 2.10 , 0.1>    // lekerekites az elejen
                        < 0.1 , 2.10 , 2.1>
                        0.1             
                //        pigment { Cyan }
                }                       
                
                sphere {<0.1 , 2.10 , 0.1> 0.1 // jobb oldalon kerekito gomb
                //        pigment {Red}
                       }
                
                sphere {<0.1 , 2.10 , 2.1> 0.1 // bal oldalon kerekito gomb
                //        pigment {Red}
                       }
                bounded_by { box 
                                {       
                                < 0.0 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                                <13.8 , 2.2 , 2.2>
                             //   pigment { Blue }
                                }
                           }                                          
                
                     
        texture {feher_billentyu_texture}        
        }              
        
#declare fekete = 
        intersection 
        {       
        box
                {       
                        < 0.0 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                        < 8.8 , 3.2 , 1.1>
                        //pigment { Yellow }
                        //finish{phong 1.0 phong_size 200}
                }

        disc    {       <4.4 0.0 0.0>,
                        -z,
                        5.0
                        //pigment {Red}       
                        //finish{phong 1.0 phong_size 200}
                        rotate < degrees(tan(0.1/1.0)) 0 0>        
                        translate < 0.0 2.2 0.0>
                }

        disc    {       <4.4 0.0 1.1>,
                        z,
                        5.0
                        //pigment {Red}       
                        //finish{phong 1.0 phong_size 200}
                        //rotate < -degrees(tan(0.1/1.0)) 0 0>        
                        translate < 0.0 2.2 0.0>
                }
        disc    {       <0.0 0.0 0.0>,
                        -x,
                        5.0
                        //pigment {Red}       
                        //finish{phong 1.0 phong_size 200}
                        rotate < 0 0 degrees(tan(-0.6/1.0))>        
                        translate < 0.0 2.2 0.55>
                }       
        texture {fekete_billentyu_texture}                
                bounded_by { box 
                                {       
                                < 0.0 , 0.0 , 0.0>     // a billenytu uj reszenek also nagy resze
                                < 8.8 , 3.2 , 1.1>
                             //   pigment { Blue }
                                }
                           }                                          
        
        
        translate < 4.85 0 0>
                                                          
        }
        
#declare keyboard = 
        merge
        {
        
        #declare i = 0;
        #while (i < 4 )
        
                object  
                { 
                        feher_bal_szelso
                        translate <0.0 0.0 i*(-16.1)+Z_diff[0]>
                        
                }                                   
                        object  
                        { 
                                fekete
                                translate <0.1 0.0 i*(-16.1)+Z_diff[1] >
                                
                        }                                   
                
        #if (every_first_key)
        }
        #else
                
                object  
                { 
                        feher_kozepso
                        translate <0.0 0.0 i*(-16.1)+Z_diff[2] >
                        
                }                                   
                        object  
                        { 
                                fekete
                                translate <0.0 0.0 i*(-16.1)+Z_diff[3]>
                                
                        }                                   
                object  
                { 
                        feher_jobb_szelso
                        translate <0.0 0.0 i*(-16.1)+Z_diff[4] >           
                        
                }                                   
                
                
                object  
                { 
                        feher_bal_szelso
                        translate <0.0 0.0 i*(-16.1)+Z_diff[5] >          
                        
                }                                   
                        object  
                        { 
                                fekete
                                translate <0.0 0.0 i*(-16.1)+Z_diff[6] > 
                                
                        }                                   
                object  
                { 
                        feher_bal_kozepso
                        translate <0.0 0.0 i*(-16.1)+Z_diff[7] >         
                        
                }                                   
                        object  
                        { 
                                fekete
                                translate <0.0 0.0 i*(-16.1)+Z_diff[8]> //o
                                
                        }                                   
                object  
                { 
                        feher_jobb_kozepso
                        translate <0.0 0.0 i*(-16.1)+Z_diff[9]>
                        
                }                                   
                        object  
                        { 
                                fekete
                                translate <0.0 0.0 i*(-16.1)+Z_diff[10]>
                                
                        }                                   
                object  
                { 
                        feher_jobb_szelso
                        translate <0.0 0.0 i*(-16.1)+Z_diff[11]>
                        
                }                                   

        
        #end
        
        #declare i = i + 1;
        
        #end
        bounded_by { box 
                        {       
                        < 0.0 , 0.0 , 5.0>     // a billenytu uj reszenek also nagy resze
                        <13.8 , 3.2 , i*7*(-2.4)>
                     //   pigment { Blue }
                        }
                   }   
        
        }
                        

#declare ALMA_SZARA_TEXTURE = texture {
            pigment { 
                        gradient x       
                        color_map {
                                        [0.5   color  < 0.5 0.6 0.0 >]
                                        [1.00   color  < 0.3 0.4 0.0 >]
                                  }
        
                        scale           < 6   6   1 >
                        translate       < 0.0 0.0 0.0>
                    }
            normal  {   bumps  0.75 // 0.75
                        scale  < 0.75 0.75 0.75 > 
                    }
           finish   { ambient .4 diffuse .6 }
}
       

#declare ALMA_SZARA = object {
        merge {
        #local cx1 = 0           
        #local cy1 = 50.75
        #local cx2 = 0.5
        #local cy2 = 51.125
        #local darab = 6
        #while ( darab <=10 )
                  cylinder { < cx1     cy1      0 >
                            < cx2     cy2      0 > 1.5 }
                  #if (darab < 10 )
                        sphere   { < cx2     cy2      0 > 1.5 }
                  #end 
                 #local cx1 = cx2
                 #local cy1 = cy2
                 #local cx2 = cx2 * darab / 4
                 #local cy2 = cy2 + 2
                 #local darab = darab + 1
        #end       
        }
}        


        

       
#declare ALMA_ALJA =
        lathe {
        #if (MINOSEG = 1)
          cubic_spline
         #else 
          linear_spline
        #end
        
        24,
        <  0.0   , 50.75 >,         
        <  0.6   , 51.0  >,         
        <  1.1   , 51.5  >,         
        <  2.1   , 52.0  >,         
        <  4.0   , 53.0  >,         
        <  6.8   , 54.0  >,         
        < 13.0   , 55.75 >,         
        < 19.0   , 53.6  >,         
        < 24.3   , 48.9  >,         
        < 27.2   , 44.0  >,         
        < 28.475 , 40.0  >,         
        < 29.0775, 36.0  >,         
        < 29.2   , 32.0  >,         
        < 28.75  , 28.0  >,         
        < 27.8   , 24.0  >,         
        < 26.2   , 20.0  >,         
        < 24.2   , 16.0  >,         
        < 21.5   , 12.0  >,         
        < 18.6   ,  8.5  >,         
        < 13.2   ,  5.0  >, // 15.2 
        <  6.0   ,  1.0  >, // 10   
        <  3.7   ,  0.8  >, // 6.7  
        <  1.0   ,  2.4  >, // 3    
        <  0.0   ,  3.0  >          
        bounded_by { sphere {< 0.0 0.0 0.0 > 55 } }
        }                          
        
#declare ALMA_ALJA_ALSO_TEXTURE =  texture {         // Also textura
            pigment { 
                        gradient y      // szine
                        color_map {
                                        [0.15  color < 1.0  1.0 0.0  >]
                                        [0.8   color < 1.0  0.0 0.0  >]
                                        [1.0   color < 0.8  0.0 0.0  >]
                                  }
                        turbulence      < .2 .1 .2 >
                        lambda          2.0  // 2.0 
        
        
                        scale           < 0.85 13.0 1.0 >
                        translate       < 0.0 12.0 0.0>
                    }
            normal  {   bumps  0.065    // 0.075 hogy ne legyen annyira tokeletes a formaja
                        scale  < 0.85 0.85 0.85 >
                    }    
            finish  {
                        ambient .2
                        diffuse .65
                        specular .05
                        reflection .01 // .1
                        phong 0.2   
                        phong_size 125
                    } 
            }        

#declare ALMA_ALJA_FELSO_TEXTURE = texture {         // Felso textura : pottyosseg
            pigment { 
                        gradient y       
                        color_map {
                                        [0.95   color rgbf < 1.0 1.0 0.0 1.00>]
                                        [0.975  color rgbf < 0.8 0.8 0.0 0.50>]
                                        [1.00   color rgbf < 1.0 1.0 0.0 0.50>]
                                  }
                        turbulence      < 1 1 1 >
                        lambda          2.0  // 2.0 
   
        
                        scale           < 0.5 1.0 0.5 >
                        translate       < 0.0 0.0 0.0>
                    }
            normal  {   bumps  0.075 
                        scale  < 0.75 0.75 0.75 > 
                    }
            finish  {
                        ambient .2
                        diffuse .65
                        specular .05
                        reflection .01 //.1
                        phong 0.2   
                        phong_size 125
                    } 
                    
}             
        

#declare POHAR =
        lathe {
        #if (MINOSEG = 1)
          cubic_spline
         #else 
          linear_spline
        #end
          12,
          <0.000000, 0.000000>,
          <0.000000, 0.000000>,
          <0.193050, 0.003861>,
          <0.193050, 0.019305>,
          <0.073359, 0.038610>,
          <0.027027, 0.135135>,
          <0.023166, 0.559846>,
          <0.100386, 0.679537>,
          <0.309073, 0.996139>,
          <0.096525, 0.725869>,
          <0.000000, 0.691120>,
          <0.000000, 0.691120>
        
//          scale <1.5, 1.5, 1.5>
        }
        
  
 



#if ( CSILLAGOK = 1 )
 sky_sphere { 
     pigment {
        granite  
        color_map {
            [0.72 rgb 0.00 ] // No Stars in this area
            [0.72 rgb 0.20 ] // Very Very Faint Stars
            [0.75 rgb 0.40 ] // Very Very Faint Stars
            [0.78 rgb 0.60 ] // Very Faint Stars
            [0.81 rgb 0.80 ] // Faint Stars
            [0.85 rgb 0.95 ] // Medium White Stars
            [0.91 rgb 1.00 ] // White Stars 
            [0.91 rgb 0.00 ] // No Stars in this area
        }
    scale .015
    }
    
            }
           
  #else           
   background {color <0.0 0.0 0.0>}
#end          


#if ( TALAPZAT = 1 )    


 plane { y , 0
 
         #if (MINOSEG = 1 )
                texture{ pigment {color <0.1 0.1 0.1> }
                         /*PinkAlabaster 
                         scale < 10 , 0 , 10>
                         translate < 0 0 -5>*/
                }
                finish { 
                         //phong      0.5
                         //phong_size 1000
                
                         ambient    0.1
                         diffuse    0.3
                         specular   0.2   
                         reflection 0.5
                         roughness  0.1 }
             #else
                pigment {color White }
         #end              
 
 
 }

#end



#if ( ALMA_GOMBBEN = 1 )  

object { 

  merge {  
  
    object { ALMA_ALJA  
             scale < 0.2 0.2 0.2 >
             rotate < 0 -10 0 >

             texture { ALMA_ALJA_ALSO_TEXTURE }
             texture { ALMA_ALJA_FELSO_TEXTURE }
           }
    
    object { ALMA_SZARA          
             scale < 0.2 0.2 0.2 >
             rotate < 0 -10 0 >
             texture { ALMA_SZARA_TEXTURE }
           }  

  }    
  
 scale < 0.7 0.7 0.7>
 translate < 10, 0, -65>      

 
}
  
#end  



#if (PEZSGOSPOHAR = 1)
        object { POHAR
                 texture {Green_Glass}
                 scale < 14 14 14 >
                 rotate < -60 0 0 >       
                 rotate < 0 0 -90 >
                 rotate <-100 0 0 >
                 
                 //translate < 20, 16.75, -10>                                                              
                 translate < -10, 21.75, 5>                                
                 rotate < 0 0 10 >
                }                 
#end  



#if (GYERTYA = 1)

    merge {

        object { 
                 lathe { 
                        #if (MINOSEG = 1)
                          cubic_spline
                         #else 
                          linear_spline
                        #end
                       11,
                
                        <0.25	,0    >,          
                        <0.22	,0.2  >,          
                        <0.2	,0.4  >,          
                        <0.19	,0.6  >,          
                        <0.195	,0.8  >,          
                        <0.18	,0.9  >,          
                        <0.195	,1.0  >,
                        <0.1	,0.98 >,          
                        <0.05	,0.97 >,
                        <0.0	,1.0  >,
                        <0.0	,1.0 >
                        sturm
                        }

                 scale < 6 13 6 >     
                 texture{normal{ wrinkles 0.1}}  
                 pigment { color < 0.89, 0.89, 0.8, 0.7 > 
                         }
                   finish { ambient 0.3
                            diffuse 0.7
                            phong   0.3
                            phong_size 50
                   
                          }
                 interior {  
                             media{
                                    emission   White*0.75
                                    absorption White*0.0
                                    scattering {1, <0.98, 0.98, 0.90,> }
                                    }
                                  
                          }
                 finish  { ambient    .6 
                           diffuse    .2
                           specular   .1
                           crand      .0
                           phong      .025
                           phong_size 40
                         }
                 rotate <0 0 0 >
                 //translate < 0, 5.5, 0>     
                 hollow    
                 translate < 18, 8.5, -40>     
                }          
                
                
       object {     cylinder { < 72.1, 29,   -160 >     // kanc
                               < 72.1, 29+1, -160 >
                               0.4                 
                               no_shadow 
                                pigment {
                                 gradient y    
                                 color_map {
                                        [0.0 rgb 0.0            ]
                                        [0.4 rgb <0.25, 0.0, 0.25>]
                                        [0.6 rgb <1.0, 0.0, 0.0>]
                                        [0.9 rgb <4.0, 0.5, 0.5>]
                                        [1.0 rgb <4.0, 1.0, 1.0>]
                                             
                                    }        
                                    scale < .1 1.305 .1>    
                                }                               
                             }

                    scale < 0.25 0.74 0.25 >                    
       }
       
      sphere{ <0 0 0> 1.75 // Srga fels 
                 no_shadow
                 texture{ 
                          pigment{ color rgbf < 1.0, 1.0, 1.0, 1.0 > } }
                 interior {  
                             media{
                                    emission 1.0 //0.35
                                    scattering {1, <0.99  ,0.76   ,0.32 , 0.5> }
                                    density { spherical
                                      color_map{
                                        [0.0 rgb <0.0   ,0.0    ,0.0  , 0.5>]
                                        [0.3 rgb <1.0   ,0.70   ,0.33 , 0.5>]
                                        [0.5 rgb <0.91  ,0.89   ,0.48 , 0.5>]
                                        [0.8 rgb <0.99  ,0.76   ,0.32 , 0.5>]
                                        [0.9 rgb <1.0   ,1.0    ,1.0  , 0.5>]
                                        [1.0 rgb <3.0   ,3.0    ,3.0  , 0.5>]
                                      }
                                    scale < 2.5 2.5 2.5 >  
                                    }
                                  }
                          }
               hollow
               scale <0.225,1,0.225>
              translate <18.1, 23.75,   -41>
       } 

       sphere{ <0 0 0> .6 // Kk als
                 no_shadow
                 texture{ pigment{ color rgbf < 1.0, 1.0, 1.0, 1.0 > } }
                 interior {
                             media{
                                    emission 1.0
                                    scattering {1, <0.0  ,0.0    ,1.0, 0.5>}
                                    density { spherical
                                      color_map{
                                        [0.0 rgb <0.0   ,0.0    ,0.0 , 0.5>]
                                        [0.2 rgb <0.01  ,0.0    ,0.71, 0.5>]
                                        [1.0 rgb <0.0  ,0.00   ,1.0 , 0.5>]
                                      }
                                    //scale < 0.5 0.5 0.5 >  
                                    }
                                  }
                          }
               hollow
               scale <0.475,1,0.475>

               translate <18.12525, 22.5,   -41>
       }     
       
    light_source { <17.8, 23.75,   -40.23> 
                    color <0.99  ,0.76   ,0.32>*1.45 
                    fade_distance   80
                    fade_power      2
                    
                  } //17.725, 28.0, -40.5
       
  translate < -26, -10.0, -31>
  
    }
        
#end  

#if ( ALATET = 1)
  
object {
  superellipsoid {
    <1, 0.5>
   texture { pigment { P_WoodGrain1A color_map { M_Wood1A }}}
   texture { pigment { P_WoodGrain1B color_map { M_Wood1B }}}
   }
   
   scale        <  8,   8, 0.9>
   rotate       <-90,   0, 0  >
   translate    < -8, 0.5, -40-30>        // 18
}  
#end  


#if (BILLENTYUZET  = 1)

 object {                                   // hatso
        keyboard 
       // rotate     < 0, -110, 0    >
       // rotate     < -10, 0, 0    >
        rotate     < 0, -110, 0    >
        rotate     < 0, 0, 0    >
        rotate     <  0, 0, 0    >
       // translate  < -15. 11.65, -32   >
        translate  < -20. 0.2, -55   >
 
 }
 object {                                   // elso
        keyboard 
       // rotate     < 0, -110, 0    >
       // rotate     < -10, 0, 0    >
        rotate     < 0, -155, 0    >
        rotate     < 0, 0, 0    >
        rotate     <  0, 0, 0    >
       // translate  < -15. 11.65, -32   >
        translate  < 22. 0.2, -100   >
 
 }


#end

#if (KOD = 1)
        fog {
        distance 260
        color Turquoise
        fog_type 2
        fog_offset 25
        fog_alt 3
        turbulence 0.1
        turb_depth 0.2
        }
     /*   fog {
        distance 150
        color rgb<0.5, 0.1, 0.1>
        fog_type 2
        fog_offset 15
        fog_alt 4
        turbulence 0.2
        turb_depth 0.2
        }
        fog {
        distance 150
        color rgb<0.1, 0.1, 0.6>
        fog_type 2
        fog_offset 10
        fog_alt 2
        }*/
#end

 // translate <-20, 11.8, -27>                        