// *****************************************************************************
// This file is written by Micha Riser, 1999
// email: micha@micha.virtualave.net
// homepage: http://micha.virtualave.net
// 
// POV-Ray 3.1 Scene Description File
// *****************************************************************************


//-------------------------------- Standard includes

#include "colors.inc"
#include "golds.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "glass.inc"

//-------------------------------- Scene render settings
#declare mauernrendern=1;
#declare Tuermchen=1;
#declare Hauptgebaeude=1;
#declare wolken=1;
#declare feuerlicht=1;
#declare lightmedias=1;
#declare nebenwolken=0;
#declare fensterrendern=1; 
#declare baum1=1;
#declare baum2=1;
#declare bfr=0;
 
//---------------------------------------------------------------------

#include "backgroundsky3.pov"    // Background sky



global_settings{max_intersections 500 max_trace_level 150
                adc_bailout 1/64}

camera{
right 4/3*x
up y 
location<2,18,-28>
look_at <0,1.5,5.5>     // <- Original Value
angle 70        // <- Original Value
}

light_source{<1000,1000,-1000>
color rgb<.4,.4,.6>
}

//----------- textures

#declare Hauben_Texture=texture{T_Gold_1B}

#declare HG_texture=texture{
pigment{White}
finish{ambient .35
diffuse 0.55
}
}

#declare Wall_Texture=texture{
pigment{White} 

normal{agate .07 rotate x*90 scale <.8,1.4,.8> translate -20}
}

#declare Door_Texture=material{
 texture { pigment { P_WoodGrain3A color_map { M_Wood8A }}
 finish {ambient .25} }     
 texture { pigment { P_WoodGrain3B color_map { M_Wood8B }} 
 finish {ambient .25} }   //<- neu!
 
scale .5
rotate x*94

}

#declare Torbefestigungsstaebe=material
{
texture{T_Chrome_1B
normal{bumps .4 scale .005}
}

}

//--------------------- Wolke (cloud)

#if (wolken=1) #include "wolke.final.pov" #end

#if (lightmedias=1) #include "lightmedias4.pov" #end

//#if (nebenwolken=1) #include "nebenwolken2.pov" #end

//--------------------- Haube

#include "haubeinc3.pov"

//--------------------- Fenster (windows)

#include "fensterinclude2.pov"

//--------------------  Trees

#if (baum1=1)
  #include "baum1.final.pov"
#end

#if (baum2=1)
  #include "baum2.final.pov"
#end


//------------------ Mauern INCLUDE (walls)

//#include "mauer.final.inc"

//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//----------------- Basic shapes (TOWERS) ---------------------------------


#macro make_circle2square_subsegment(a,b,Points,Height,Scalefakt)


#declare a0=1-a;

#declare sx=1/sqrt(a+0.0001);

intersection{

cone{<0,0,0>,1,<0,Height,0>,Scalefakt scale <sx,1,1>}
cone{<0,-.0001,0>,1,<0,Height+0.0001,0>,Scalefakt scale <sx,1,1> rotate y*90}

}

#end


//-------------------------

#declare Entry_Tower=
union{


#declare ystepsize=.1; // .025 // <- Take this for better quality
#declare iy=0;
#while(iy<15)



#declare prism_object=object{
	make_circle2square_subsegment( iy/15,1,10,ystepsize,0.982)//0.995)  // <- Take this for better quality 
	}
  difference{
  object{prism_object} 
  object{prism_object scale <.95,1.01,.95> translate <0,-(ystepsize/200),0>}
  bounded_by{box{<-1,0,-1>,<1,ystepsize,1>}}
  scale <1+pow((15-iy)/15,2)*10,1,1>
  translate <0,iy,0>
}

	#declare iy=iy+ystepsize;
#end

object{Haube
scale .6
scale <1,20/4,1>
translate<0,15,0>
texture{Hauben_Texture}
}

}


#declare subunion_anz=20;

#declare TowerBIG_Ground=
union{

#declare subunion=0;
  union{     //<- SUBUNION

#declare ystepsize=.1//.1;
#declare iy=0;
#while(iy<15)

#declare prism_object=object{
	make_circle2square_subsegment( iy/15,1,10,ystepsize,0.9978)//0.9980)//0.9975)//0.9989) // -> Original Value: 0.9979
	}
  difference{
  object{prism_object} 
  object{prism_object scale <.9,1.01,.9> translate <0,-(ystepsize/200),0>}
  bounded_by{box{<-1,0,-1>,<1,ystepsize,1>}}
  scale <1-iy/100,1,1-iy/100>
  translate <0,iy,0>
}

#declare subunion=subunion+1;
#if (subunion=subunion_anz)
 bounded_by{box{<-1,iy+ystepsize,-1>,<1,iy-(subunion_anz-1)*ystepsize,1>}}
 } // <- SUBUNION END
#declare subunion=0;
 union{
#end

	#declare iy=iy+ystepsize;
#end


 } //<- SUBUNION END

bounded_by{box{<-1,0,-1>,<1,iy+ystepsize,1>}} // diese Linie eventuell entfernen!

}

#declare TowerBIG=union{


difference{
 union{
  object{TowerBIG_Ground}
  cone{<0,15,0>,1-15/100,<0,17,0,>1-17/100}
  }
 cone{<0,15,0>,1-15/100,<0,17,0,>1-17/100 scale <.95,1.01,.95>}
 
 object{Haube_Grund               //Fenster
  scale<.15,.8,.8>
  translate<0,13,-1.2>
  }
 object{Haube_Grund               //Fenster
  scale<.15,.8,.8>
  translate<0,13,-1.2>
  rotate y*90
  }
 object{Haube_Grund               //Fenster
  scale<.15,.8,.8>
  translate<0,13,-1.2>
  rotate y*-90
  }
 object{Haube_Grund               //Fenster
  scale<.15,.8,.8>
  translate<0,13,-1.2>
  rotate y*180
  }

pigment{White}
normal{agate .1}
scale <1,1/3,1>
}


object{Haube
scale .6
translate<0,17/3,0>
texture{Hauben_Texture}
}

}

#declare TowerSMALL=union
{

#declare ystepsize=.7;
union{
cone{<0,15,0>,1-15/100,<0,17,0,>1-17/100}
#declare iy=0;
#while(iy<15)
	object{
	make_circle2square_subsegment(iy/15,1,7,ystepsize,1)  
        bounded_by{box{<-1,0,-1>,<1,ystepsize,1>}}
	scale <1-iy/100,1,1-iy/100>
	translate <0,iy,0>
	}
	#declare iy=iy+ystepsize;
#end

scale <1,1/8,1>
}

scale .09
}




//------------------ Mauern INCLUDE (walls)

#include "mauer.final.inc"
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//---------------------------- Surrounding walls ---------------------------

#if (mauernrendern=1)

union{

#declare y_minus=.3;

#declare E_TowerBIG=union{
 object{TowerBIG}
 box{ <-1,-y_minus,-1>,<1,0,1> }

texture{
 pigment{White}
 normal{agate .1}
 scale <1,1/3,1>
 }
}

object{E_TowerBIG translate <-17,0,-10>}
object{E_TowerBIG translate <17,0,-10>}
object{E_TowerBIG translate <17,0,15>}
object{E_TowerBIG translate <-17,0,15>}


union{

object{
make_Wall(3.5,1,.5,-17,17,1)
 translate <0,0,-10>
 }


object{
make_Wall(3.5,1,.5,-17,17,0)
rotate y*180
translate <0,0,15>
}

object{
make_Wall(3.5,1,.5,-10,15,0)
rotate y*90
translate <-17,0,0>
}

object{
make_Wall(3.5,1,.5,-10,15,0)
rotate y*90
scale <-1,1,1>
translate <17,0,0>
}

scale<1,.9,1>
texture{Wall_Texture}
}

}
#end

////////////////////////////////////////////////////////////////////////////
//------------------------- Main Building --------------------------------//
////////////////////////////////////////////////////////////////////////////

#if (Hauptgebaeude=1)

union{

#if (fensterrendern=1)

#declare zPosition=array[8] {-.8325,-0.758,-.89,-.87,-.87,-.89,-.758,-.8325}
#declare yRotation=array[8] {50,30,42,38,38,42,30,50} 

 #declare Fenster_Fenster_oben=union{
 
 #declare iz=-1;
 #declare i=-.833;
  #while(i<.3) //.3)
  #declare i=i+.3286666;
  #declare iz=iz+1;

  object{FensterRahmen
     translate<2,0,0>
     rotate y*yRotation[iz]
		 rotate x*20
     translate<2.05,0,-0.015>    
     scale <.05,.1,.05>*.85
     translate<i,.95,zPosition[iz]>//-.05>    
     }
 #declare iz=iz+1;
 object{FensterRahmen
     translate<2,0,0>
     rotate y*yRotation[iz]
		 rotate x*20
     translate<2.05,0,-0.015>
     scale <-.05,.1,.05>*.85
     translate<i,.95,zPosition[iz]>//-.05>    
	   }
  #end
  }

object{Fenster_Fenster_oben}
object{Fenster_Fenster_oben rotate y*90}
object{Fenster_Fenster_oben rotate y*-90}
object{Fenster_Fenster_oben rotate y*180}

#declare SeitenWinkel=0;

#declare zPosition_u=array[8] {-.96,-.94,-.97,-.963,-.963,-.97,-.94,-.96}
#declare yRotation_u=array[8] {10,10,10,10,10,10,10,10}

#while(SeitenWinkel<360)

 #declare iz=-1;
 #declare i=-.96666;
  #while(i<.3)
  #declare i=i+.386666;
  #declare iz=iz+1;

  #if (SeitenWinkel!=180|i<-.5|i>.5)
  object{FensterRahmen
     translate<2,0,0>
		 rotate x*-20
     rotate y*-yRotation_u[iz]
     translate<2.05,0,0>
     scale <.05,.1,.05>*.95
     translate<i,.2,-zPosition_u[iz]>//-.05>    
     rotate y*SeitenWinkel
     }
 #end

 #declare iz=iz+1;

 #if (SeitenWinkel!=180|i<-.5|i>.5)
 object{FensterRahmen
     translate<2,0,0>
		 rotate x*-20
     rotate y*-yRotation_u[iz]
     translate<2.05,0,0>
     scale <-.05,.1,.05>*.95
     translate<i,.2,-zPosition_u[iz]>//-.05>    
     rotate y*SeitenWinkel
     }
  #end

  #end

#declare SeitenWinkel=SeitenWinkel+90;
#end           // END while

#end          // END if (fensterrendern=1)

//////

box{<-1,-.5,-1>,<1,0,1>
texture{HG_texture}}

difference{
object{TowerBIG_Ground
scale <1,1/10,1>
 }

object{HauptHaube_Grund        //Eingangstre
// scale <.045,.09,.5>       // <- Originalwerte
scale <.045,.14,.5> 
translate<0,0.06,0>
scale 1.3
translate<0,0,-.9>
}


//Fenster:

#declare Fensterfrontoben=
union{
  #declare i=-.833;
  #while(i<.3)
  #declare i=i+.3286666;
  object{Haube_Grund
  scale<.05,0.1,1>*.85
  translate<i,.95,-.9>
  }
/*
  object{FensterRahmen
     scale <.05,.1,1>*.85
     translate<i,.95,-.9>
     }
*/
  #end
}

#declare Fensterfrontunten=
union{
  #declare i=-.96666;
  #while(i<.3)
  #declare i=i+.386666;
  object{Haube_Grund
  scale<.05,0.1,1>*.95
  translate<i,.2,-.9>
  }
  #end
}

object{Fensterfrontoben}   // Vordeseite
  object{Haube_Grund
  scale<.05,0.1,1>*.95
  translate<-.58,.2,-.9>
  }

  object{Haube_Grund
  scale<.05,0.1,1>*.95
  translate<.58,.2,-.9>
  }

#declare Fensterfront=union{object{Fensterfrontoben} object{Fensterfrontunten}}
object{Fensterfront rotate y*90}
object{Fensterfront rotate y*-90}
object{Fensterfront rotate y*180}

pigment{White}
}

object{HauptHaube
 scale .5//.45
 translate<0,15/10,0>
 texture{Hauben_Texture}
 }



union{       //Eingang

object{HauptHaube
  scale <1,.4,1>*.13
  translate<0,4.5/10,0>
  texture{T_Gold_3B}
  }

#declare saeulen=union{

#declare anz_saeulen=2;
#declare walpha=20;

#declare wbeta=(180-walpha)/2/(anz_saeulen+1);

#declare i=0;
#while(i<180)
 #declare i=i+wbeta;
 #if (i<(90-walpha/2))
//  #debug str(i,3,3)
  object{TowerBIG_Ground
  scale <1,1.1,1>*.03
  translate <-1.7,0,0>*.13
  rotate y*-i
//  translate<0,0,-.9>
  }
 #end
#end

pigment{White}
}

object{saeulen}
object{saeulen scale<-1,1,1>}

union{
cylinder{<0,-.5,0>,<0,.0,0>,-2.4*.13}
cylinder{<0,.0,0>,<0,.06,0>,-2.1*.13}
pigment{White}
//translate<0,0,-.9>
}
scale 1.3
translate<0,0,-.9>
} //Eingang Ende


 ////////

//rotate y*180           /// zum Testen !!


scale <6,4,6>*1.1
//rotate y*3
translate<0,.7,10>

}

//---------------------------------------------------
//Seitentrme:

//#declare Seitenturm=union{

#macro make_Seitenturm(richtung)
union{

 object{FensterRahmen
     translate<2,0,0>
		 rotate x*14
     translate<2.05,0,0>
     scale <.075,0.1,0.075>*2*0.8
     translate<0,.35,-.965>
     }

 object{FensterRahmen
     translate<2,0,0>
		 rotate x*14
     translate<2.05,0,0>
     scale <-.075,0.1,0.075>*2*0.8
     translate<0,.35,-.965>
     }

object{FensterRahmen
     translate<2,0,0>
		 rotate x*14
     translate<2.05,0,0>
     scale <.075,0.1,0.075>*2*0.8
     translate<0,.35,.965>
     }

 object{FensterRahmen
     translate<2,0,0>
		 rotate x*14
     translate<2.05,0,0>
     scale <-.075,0.1,0.075>*2*0.8
     translate<0,.35,.965>
     }


box{<-1,-1,-1>,<1,0,0>}

object{HauptHaube
 scale .5
 #if (richtung=1) scale <-1,1,1> #end
 translate<0,15/10,0>
 texture{Hauben_Texture}
 }


difference{

object{TowerBIG_Ground
scale <1,1/10,1>}

object{Haube_Grund                      // <- modified
  scale<.075,0.1,.45>*2 *0.8
  translate<0,.35,-.9>
  }

object{Haube_Grund                      // <- modified
  scale<.075,0.1,.45>*2 *0.8
rotate y*180
  translate<0,.35,.9>
  }


}




scale <2,2,3>
translate <9,.4,7>
pigment{White}

}

#end


object{make_Seitenturm(0)}
object{make_Seitenturm(1) scale<-1,1,1>}

#end

// End Main building
////////////////////////////////////////////////////////////////////////////

