

#include "schriftband4.pov"   // Schriftzug entlang des Tores


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

#declare randomstreem=seed(81923)

//--------------------------------------------------------------------------
//--------------------- WANDLEUCHTE MACRO ----------------------------------
//--------------------------------------------------------------------------


#macro wandleuchte()

   union{

      intersection{
         difference{
            object{Haube
               rotate x*180
               }
            object{Haube
               rotate x*180
               scale .9
               translate <0,.3,0>
               }
            }                        // END difference
         box{<-2,-4,-2>,<2,-.7,0>}

         texture{T_Gold_3B}
         scale <1,0.4,1>
         }                           // END intersection


      intersection{

         object{Haube
            rotate x*180
            scale .8999999
            translate <0,.3000001,0>
            }
         box{<-2,-4,-2>,<2,-1,0>}

         interior{ior 1.33}
         pigment{rgbf <.9,.9,.9,.9>}
         normal{bumps .3 scale .2}
         finish{reflection .3}
         scale <1,0.4,1>
         }                           // END intersection


      // -------------------------------------       Beginn Flamme !!!

      #local randomvalue=rand(randomstreem)*10;
      cylinder{0,<0,2.7,0>,.75
         pigment{rgbf 1}
         hollow
				 
				 no_shadow // <-neu!!
				 
         interior {
            media{
               intervals 50
               samples 1,1
               emission rgb <1,1,0>

               density{
                  cylindrical
                  density_map{
                     [0 color 0]
                     [0.3 color <.5,.5,0>]
										 [0.8 color <1,.5,0>]     //<- neu!
                     [1 color <1,.5,0>*3]       //<- neu!
                     }
                  scale .5
                  translate randomvalue*10
                  warp{
                     turbulence <.3,0,.3>
                     omega .8 
                     }
                  translate randomvalue*-10    
                  translate <0,-.2,0>
                  }

               density{
                  planar
                  density_map{
                     [0 color 0]
                     [0.5 color <.5,.5,0>*1.2]
                     [1 color <1,.5,0>*2.8]
                     }   
                  translate randomvalue*-7
                  warp{
                     turbulence <0,.5,0>
                     omega .9
                     }
                  translate randomvalue*7
                  scale <1,2,1>
                  translate <0,-.2,0>   
                  }

               }              // END media
            }                 // END interior
         scale 2
         translate <0,-.4,-.9>
         }                    // END cylinder
     }                        // END union


#end                          // END macro


//-----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------



//--------------------------------------------------------------------------//
//--------------------------- MAUER MACRO ----------------------------------//
//--------------------------------------------------------------------------//

#macro make_Wall(Height,Thickness,Thicknesstop,xStart,xStop,Loch)



#local y_minus=.3;
#local Thickness_n=Thicknesstop+(Thickness-Thicknesstop)/Height*(Height+y_minus);



#local Torfluegel=

intersection{
  object{Haube_Grund               //Torfluegelgrund
   translate <0,-.4,0>
   scale<.6,.7,15>*1.1
   }
  prism{linear_spline linear_sweep xStart,xStop,5
   <Thickness_n/2-Thickness_n*.1,-y_minus>
   <Thickness_n/2,-y_minus>
   <Thicknesstop/2,Height>
   <Thicknesstop/2-Thickness_n*.1,Height>
   <Thickness_n/2-Thickness_n*.1,-y_minus>
   rotate x*-90
   rotate y*90 
   }
  box{<0,-y_minus,-10>,<5,Height,10>}
 }



#local fertiges_Tor=
   union{
      difference{
         object{Torfluegel} //Goldrahmen
         intersection{
            object{Haube_Grund     
              translate<0,-0.4,0>        
              scale<.6,.7,15>*1.1
              scale 0.95
              translate<0,0.05,0>
              }
            box{<0.04,-y_minus+0.05,-10>,<10,10,10>}
            }    // end intersection
         texture{T_Gold_3B}
         }     // end difference
      union{    // Trbefestigung
         cylinder{<1,1,0>,<2*0.6*1.1+0.15,1,0>,0.03
            translate<0,0,-Thickness/2+(Thickness-Thicknesstop)/2/Height*1+Thickness*0.05>
            }
         cylinder{<1,.5,0>,<2*0.6*1.1+0.15,.5,0>,0.03
            translate<0,0,-Thickness/2+(Thickness-Thicknesstop)/2/Height*.5+Thickness*0.05>
            }
         cylinder{#declare hvon=0.425; #declare hbis=0.575;
            <2*0.6*1.1+0.15,hvon,-Thickness/2+(Thickness-Thicknesstop)/2/Height*hvon+Thickness*0.05>,
            <2*0.6*1.1+0.15,hbis,-Thickness/2+(Thickness-Thicknesstop)/2/Height*hbis+Thickness*0.05>,
            0.04
            }
         cylinder{#declare hvon=0.925; #declare hbis=1.075;
            <2*0.6*1.1+0.15,hvon,-Thickness/2+(Thickness-Thicknesstop)/2/Height*hvon+Thickness*0.05>,
            <2*0.6*1.1+0.15,hbis,-Thickness/2+(Thickness-Thicknesstop)/2/Height*hbis+Thickness*0.05>,
            0.04
            }
         cylinder{#declare hvon=0.3; #declare hbis=1.2;
            <2*0.6*1.1+0.15,hvon,-Thickness/2+(Thickness-Thicknesstop)/2/Height*hvon+Thickness*0.05>,
            <2*0.6*1.1+0.15,hbis,-Thickness/2+(Thickness-Thicknesstop)/2/Height*hbis+Thickness*0.05>,
            0.03
            material{Torbefestigungsstaebe}
            }
         cylinder{
            <2*0.6*1.1+0.15,0.85,-Thickness/2+(Thickness-Thicknesstop)/2/Height*0.85+Thickness*0.05>,
            <2*0.6*1.1+0.15,0.85,0>,
            0.03
            material{Torbefestigungsstaebe}
            }
         cylinder{
            <2*0.6*1.1+0.15,0.65,-Thickness/2+(Thickness-Thicknesstop)/2/Height*0.65+Thickness*0.05>,
            <2*0.6*1.1+0.15,0.65,0>,
            0.03
            material{Torbefestigungsstaebe}
            }
         texture{T_Gold_3B}
         } //end union
      object{Torfluegel scale 0.99999}
      translate<-2*0.6*1.1*2-.3 ,0,0>
      translate<0,0,-.21>
			
			no_shadow // <-neu!
			
      }  //end union


//----------------------------------------------------------------------------
//----------------------- BEGINN EIGENTLICHES OBJEKT -------------------------
//----------------------------------------------------------------------------
                             


/*#declare Height=4;          // Standard-Einstellungen fr Tests
#declare Thickness=1;
#declare Thicknesstop=.5;
#declare xStart=0;
#declare xStop=10;
*/

#declare wechsel=0;

union{

   #if (Loch=1)                                                  ////Loch////
       difference{						 ////Loch////
          union{                                                 ////Loch////
       #end                                                      ////Loch////

   prism{linear_spline linear_sweep xStart,xStop,5
      <-Thickness_n/2,-y_minus>
      <Thickness_n/2,-y_minus>
      <Thicknesstop/2,Height>
      <-Thicknesstop/2,Height>
      <-Thickness_n/2,-y_minus>
      rotate x*-90
      rotate y*90
//scale 0.00001 //prov!!!
      }

   #if (Loch=1)                                                  ////Loch////
             intersection{					 ////Loch////
                prism{linear_spline linear_sweep xStart,xStop,5  ////Loch////
                   <-Thickness_n/2-Thickness_n*0.1,-y_minus>     ////Loch////
                   <Thickness_n/2+Thickness_n*0.1,-y_minus>      ////Loch////
                   <Thicknesstop/2+Thickness_n*0.1,Height>       ////Loch//// 
                   <-Thicknesstop/2-Thickness_n*0.1,Height>      ////Loch//// 
                   <-Thickness_n/2-Thickness_n*0.1,-y_minus>     ////Loch////  
                   rotate x*-90					 ////Loch////
                   rotate y*90					 ////Loch////
                   }  						 ////Loch////
                object{Haube					 ////Loch//// 
                   translate <0,-.4,0>				 ////Loch//// 
                   scale<.6,.7,15>*1.3				 ////Loch////  
                   }						 ////Loch//// 
                }  // END intersection		                 ////Loch////
             } // END union					 ////Loch////

          intersection{						 ////Loch////
             object{Haube_Grund               //Loch in der Mauer      ////Loch//// 
                translate <0,-.4,0>				 ////Loch//// 
                scale<.6,.7,15>*1.1				 ////Loch//// 
                }						 ////Loch////   
             box{<-5,-y_minus-0.001,-Thickness_n>,<5,Height,Thickness_n>}
             } // END intersection 				 ////Loch////
          object{make_Schriftband(Thickness,Thicknesstop,Height)}////Loch////
          } //END difference
				
       //--------------------------				  

       object{Entry_Tower				 	 ////Loch//// 
          scale <Thicknesstop/2,.05,Thicknesstop/2>		 ////Loch//// 
          translate<0,Height,0>					 ////Loch////
          }							 ////Loch//// 
       object{fertiges_Tor					 ////Loch//// 
          material{Door_Texture}				 ////Loch////
          }							 ////Loch////
       object{fertiges_Tor					 ////Loch////
          scale<-1,1,1>						 ////Loch//// 
          material{Door_Texture}				 ////Loch////
          }							 ////Loch////  
								 ////Loch//// 
       #end							  

   #if (Loch=1)							////Loch//// 
     object{wandleuchte()					////Loch//// 
        scale .35						////Loch//// 
        #declare wHeight=2.5;					////Loch//// 
        translate <-4,wHeight, +(-Thickness/2+(Thickness-Thicknesstop)/2/wHeight*0.65)>     
        }							////Loch//// 
     light_source{<0,0.55,-.7>					////Loch//// 		  
                color <1,.7,.14>*.28*2.4  				////Loch//// 			  
                fade_distance 10					////Loch//// 			  
                fade_power 1.5	//2				////Loch//// 			  
                scale .35					////Loch//// 				  
                translate <-4,wHeight, +(-Thickness/2+(Thickness-Thicknesstop)/2/wHeight*0.65)>
                }						////Loch//// 
     object{wandleuchte()					////Loch//// 
        scale .35						////Loch//// 
        #declare wHeight=2.1;					////Loch//// 
        translate <4,wHeight, +(-Thickness/2+(Thickness-Thicknesstop)/2/wHeight*0.65)>     
        }							////Loch//// 
     light_source{<0,0.55,-.7>					////Loch//// 		  
                color <1,.7,.14>*.28*2.4	 			////Loch//// 			  
                fade_distance 10					////Loch//// 			  
                fade_power 1.5	//2				////Loch//// 			  
                scale .35					////Loch//// 				  
                translate <4,wHeight, +(-Thickness/2+(Thickness-Thicknesstop)/2/wHeight*0.65)>
                }						////Loch//// 	
     #end // end if						////Loch//// 	

   #declare aseite=4;
   #declare dmin=3.7;     //3;    <-Original
   #declare stepsize=(xStop-xStart-2*aseite)/ int( (xStop-xStart-2*aseite)/dmin );

   // #debug str(stepsize,2,2)
   // #debug " <-stepsize \n"

   #declare i=xStart+aseite;
   #while(i<xStop-aseite+.01)

       #if ( (Loch!=1) | (i!=0) )                                
           object{wandleuchte()					  
              scale .35						  
              rotate y*180					  
              #declare wHeight=2.3;				 
              translate <-i,wHeight, -(-Thickness/2+(Thickness-Thicknesstop)/2/wHeight*0.65)>
              }	
						  
           #if (feuerlicht=1)
//					   #if (wechsel=0)
             light_source{<0,0.55,-.7>				  
                color <1,.7,.14>*.28*.7   *1.2
								
							  
//                fade_distance 5     // <- Original Value !!!
//                fade_power 2				

                fade_distance 7
                fade_power 1.5	
	  
                scale .35						  
                rotate y*180					 
                translate <-i,wHeight, -(-Thickness/2+(Thickness-Thicknesstop)/2/wHeight*0.65)>
                }					
//								#declare wechsel=1;	
//								#else // wechsel<>0	 
//								#declare wechsel=0;
//								#end
              #end // END if

          #end // END if					 

       #declare i=i+stepsize;
       #end  // END while


   union{     // UNION II
      #declare i=xStart;
      #if (Tuermchen=0) #declare i=xStop; #end

      #while (i<xStop)
          #declare i=i+.4;
          object{TowerSMALL 

             #if (Loch=1)                                     // IF1   ////Loch////                		  
                  #if (i>-5.5*Thicknesstop)                   // IF2   ////Loch////
                       #if (i<5.5*Thicknesstop)               // IF3   ////Loch////
                           #if (abs(i)/Thicknesstop*2-1<0)    // IF4   ////Loch////
                               scale 0.000001   		       ////Loch////
                              #else                           // IF4   ////Loch//// 
                               scale <1, (.2+(15-15*sqrt((abs(i)+0.09)/Thicknesstop*2/10-.1))/20) /.2  ,1> 
                              #end                            // IF4   ////Loch////
                         #end                                 // IF3   ////Loch////
                    #end                                      // IF2   ////Loch////
               #end                                           // IF1   ////Loch////  

              translate<-i,Height,-Thicknesstop/2+0.09>
              }

          object{Haube
             scale .6
             translate<0,17/8,0>
             texture{T_Gold_3B}
             scale .09
             translate<-i,Height,-Thicknesstop/2+0.09>

             #if (Loch=1)					////Loch////     
                 #if (i>-5.5*Thicknesstop) 			////Loch////    
                     #if (i<5.5*Thicknesstop) 	 		////Loch////	    
                         #if (abs(i)/Thicknesstop*2-1<0) 	////Loch////	     
                             scale 0.000001 			////Loch////	   
                           #else				////Loch////             
                             translate <0,(15-15*sqrt((abs(i)+0.09)/Thicknesstop*2/10-.1))/20,0> 
                           #end 				////Loch////          
                       #end					////Loch////         
                   #end						////Loch////          
               #end						////Loch////        

             }
              
	  object{TowerSMALL 

             #if (Loch=1)					////Loch//// 
                #if (i>-5.5*Thicknesstop) 			////Loch////
                    #if (i<5.5*Thicknesstop) 			////Loch////
                        #if (abs(i)/Thicknesstop*2-1<0) 	////Loch////
                            scale 0.000001 			////Loch////
                          #else					////Loch////
                            scale <1, (.2+(15-15*sqrt((abs(i)+0.09)/Thicknesstop*2/10-.1))/20) /.2  ,1> 
                          #end 					////Loch////
                       #end					////Loch////
                   #end						////Loch////
               #end   						////Loch////
             translate<-i,Height,Thicknesstop/2-0.09>
             }
          object{Haube
             scale .6
             translate<0,17/8,0>
             texture{T_Gold_3B}
             scale .09
             translate<-i,Height,Thicknesstop/2-0.09>

             #if (Loch=1)					////Loch////
                 #if (i>-5.5*Thicknesstop) 			////Loch////
                      #if (i<5.5*Thicknesstop) 			////Loch////
                          #if (abs(i)/Thicknesstop*2-1<0) 	////Loch////
                              scale 0.000001 			////Loch////
                            #else				////Loch////
                              translate <0,(15-15*sqrt((abs(i)+0.09)/Thicknesstop*2/10-.1))/20,0> 
                            #end 				////Loch////
                        #end					////Loch////
                    #end					////Loch////
                #end						////Loch////

             }

      #end  // END while !!
      //bounded_by{box{<-1.2*0.09-xStop,0+Height,-1.2*0.09-Thicknesstop/2>,<1.2*0.09-xStart,4.6*0.09+Height,1.2*0.09+Thicknesstop/2>}}

      }  //END UNION II

}

#end  // END MACRO

//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
