 pdmhouse.pov`pdmhouse.pov   m L     TEXTPOV3        9  `                         // POV-Ray file
// Standard pre-defined colors
#include "colors.inc"
#include "textures.inc"

/*
Time For Parse:    0 hours  6 minutes   5.0 seconds (365 seconds)
Time For Trace:    4 hours  8 minutes   8.0 seconds (14888 seconds)
    Total Time:    4 hours 14 minutes  13.0 seconds (15253 seconds)
*/

// Flags - not all implemented yet.
#declare Detailed  = 1;
//#declare Glazed    = 0;
//#declare Doors     = 0;
#declare People    = 1;
#declare HouseOnly = 0;
#declare RoomFill  = 1;
#declare LitLights = 0;

// Units
#declare in = 1;
#declare ft = 12;
#declare yd = 36;
#declare sx = 1/16;

#declare LAfence   = <27.5*ft,29*ft,75*ft>;  //checking fence by pool
#declare LAimage   =<-27.5*ft,20*ft,-10*ft>;//
#declare LAstreet1 =<0,3,-40>*ft;
#declare LAstreet2 =<0,3,240>*ft;
#declare VPstreet3 =<85,6,185>*ft;
#declare LAstreets =<-42.5*ft,5*ft,100*ft>;//Context of house
#declare LAtest    =<-31*ft,26*ft,37.5*ft>;  //overview, looking down
#declare LAtest2   =<-32.5*ft,26*ft,47.5*ft>;//overview, front of house

#declare VPtest2b  =<80*ft,66*ft,37.5*ft>;
#declare LAtest2b  =<-32.5*ft,26*ft,47.5*ft>;
#declare VPtest2r  =<-42.5*ft,66*ft,155*ft>;
#declare LAtest2r  =<-32.5*ft,26*ft,47.5*ft>;

//#declare ViewPoint=LAfence+<-25*ft,0*ft,0*ft>;#declare LookAt=LAfence;
#declare ViewPoint=LAimage+<-20*ft,-5*ft,-90*ft>;#declare LookAt=LAimage;
//#declare ViewPoint=LAimage+<70*ft,-20*ft,-90*ft>;#declare LookAt=LAimage;
//#declare ViewPoint=LAstreet1+<-60,5,0>*ft;#declare LookAt=LAstreet1;
//#declare ViewPoint=LAstreet2+<-60,5,0>*ft;#declare LookAt=LAstreet2;
//#declare ViewPoint=VPstreet3;#declare LookAt=VPstreet3+<0,-1,100>*ft;
//#declare ViewPoint=LAstreets+<-10*ft,600*ft,-550*ft>;#declare LookAt=LAstreets;
//#declare ViewPoint=LAtest+<0,96*ft,-52.5*ft>;#declare LookAt=LAtest;
//#declare ViewPoint=LAtest2+<-10,40,-137.5>*ft;#declare LookAt=LAtest2;
//#declare ViewPoint=LAtest2+<-107.5,40,-10>*ft;#declare LookAt=LAtest2;
//#declare ViewPoint=VPtest2b;#declare LookAt=LAtest2b;
//#declare ViewPoint=VPtest2r;#declare LookAt=LAtest2r;

//Debbie
//#declare ViewPoint=<-20*ft,5.5*ft,80*ft>+<1*ft,26*ft,0>;#declare LookAt=ViewPoint+<10*ft,-1*ft,0>;
//Sheldon
//#declare ViewPoint=<-52.5*ft,5.5*ft,72.5*ft>+<0,26*ft,-1*ft>;#declare LookAt=ViewPoint+<0,-1*ft,-10*ft>;

// debug VP/LA
//sphere{LAfence,5*ft texture{pigment{colour rgb<1,0,0>}}}
//sphere{LAfence+<-10*ft,0*ft,0*ft>,5*ft texture{pigment{colour rgb<1,1,0>}}}

sky_sphere {
  pigment {
    gradient y
    colour_map {
      [0.500 colour rgb <0.75, 0.75, 1.0>]
      [1.000 colour rgb <0.0, 0.0, 0.6>]
    }
    scale 2
    translate -1
  }
  pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.8
    lambda 2
    colour_map {
      [0.0 0.1 colour rgb <0.88, 0.88, 0.93>
               colour rgb <0.90, 0.90, 0.90>]
      [0.1 0.3 colour rgb <0.90, 0.90, 0.90>
               colour rgbt <1, 1, 1, 1>]
      [0.3 1.0 colour rgbt <1, 1, 1, 1>
               colour rgbt <1, 1, 1, 1>]
    }
    scale <0.2, 0.5, 0.2>
    rotate 80*z
    rotate y*57
  }
}

// Most of the textures
#include "unbtex.inc"

camera{
  perspective
  location    ViewPoint
  look_at     LookAt
}

light_source{// Light on camera
  ViewPoint
  colour rgb <1,1,1>
}

light_source{// Sun
  <200*ft,200*ft,-150*ft>
  colour rgb 2.5
}

// Separate objects
#include "rhouse.mcr"
#if (Detailed = 1)
  #include "gazebo.obj"
  #include "tedbearm.inc"
  //#include "streetlight.obj"
  #declare Streetlight=
  cylinder{
    <0,0,0>,<0,20*ft,0>,6*in
    texture{Highlight}//{pigment{rgb <.4,.6,.4>}}
  }
#else
  #declare Streetlight=
  cylinder{
    <0,0,0>,<0,20*ft,0>,6*in
    texture{Highlight}//{pigment{rgb <.4,.6,.4>}}
  }
#end

#if (People = 1)
  #include "Bodies.inc"
  #include "Adam.mcr"
  #include "Debbie.mcr"
  #include "Sheldon.mcr"
#end

// "Island"
#declare Island=
//union{
  blob{
    threshold .4
    sphere{< 50*ft,    0,40*ft>,15*ft,3.0}
    sphere{< 40*ft,-6*in,40*ft>,15*ft,3.0}
    sphere{< 30*ft,    0,40*ft>,15*ft,3.0}
    sphere{< 20*ft,-9*in,40*ft>,15*ft,3.0}
    sphere{< 10*ft,    0,40*ft>,15*ft,3.0}
    sphere{<  0*ft,-1.5*ft,40*ft>,15*ft,3.0}
    sphere{<-10*ft,    0,40*ft>,15*ft,3.0}
    sphere{<-20*ft,-9*in,40*ft>,15*ft,3.0}
    sphere{<-30*ft,    0,40*ft>,15*ft,3.0}
    sphere{<-40*ft,-6*in,40*ft>,15*ft,3.0}
    sphere{<-50*ft,    0,40*ft>,15*ft,3.0}
    
    sphere{< 50*ft,0,30*ft>,15*ft,3.0}
    sphere{< 40*ft,0,30*ft>,15*ft,3.0}
    sphere{< 30*ft,0,30*ft>,15*ft,3.0}
    sphere{< 20*ft,0,30*ft>,15*ft,3.0}
    sphere{< 10*ft,0,30*ft>,15*ft,3.0}
    sphere{<  0*ft,-2*ft,30*ft>,15*ft,3.0}
    sphere{<-10*ft,0,30*ft>,15*ft,3.0}
    sphere{<-20*ft,0,30*ft>,15*ft,3.0}
    sphere{<-30*ft,0,30*ft>,15*ft,3.0}
    sphere{<-40*ft,0,30*ft>,15*ft,3.0}
    sphere{<-50*ft,0,30*ft>,15*ft,3.0}
    
    sphere{< 50*ft,0,20*ft>,15*ft,3.0}
    sphere{< 40*ft,0,20*ft>,15*ft,3.0}
    sphere{< 30*ft,0,20*ft>,15*ft,3.0}
    sphere{< 20*ft,0,20*ft>,15*ft,3.0}
    sphere{< 10*ft,0,20*ft>,15*ft,3.0}
    sphere{<  0*ft,-2.5*ft,20*ft>,15*ft,3.0}
    sphere{<-10*ft,0,20*ft>,15*ft,3.0}
    sphere{<-20*ft,0,20*ft>,15*ft,3.0}
    sphere{<-30*ft,0,20*ft>,15*ft,3.0}
    sphere{<-40*ft,0,20*ft>,15*ft,3.0}
    sphere{<-50*ft,0,20*ft>,15*ft,3.0}
    
    sphere{< 50*ft,-9*in,10*ft>,15*ft,3.0}
    sphere{< 40*ft,-1*ft,10*ft>,15*ft,3.0}
    sphere{< 30*ft,-1.5*ft,10*ft>,15*ft,3.0}
    sphere{< 20*ft,-2*ft,10*ft>,15*ft,3.0}
    sphere{< 10*ft,-2.5*ft,10*ft>,15*ft,3.0}
    sphere{<  0*ft,-3*ft,10*ft>,15*ft,3.0}
    sphere{<-10*ft,-2.5*ft,10*ft>,15*ft,3.0}
    sphere{<-20*ft,-2*ft,10*ft>,15*ft,3.0}
    sphere{<-30*ft,-1.5*ft,10*ft>,15*ft,3.0}
    sphere{<-40*ft,-1*ft,10*ft>,15*ft,3.0}
    sphere{<-50*ft,-9*in,10*ft>,15*ft,3.0}
    
    sphere{< 50*ft,-1*ft, 0*ft>,15*ft,3.0}
    sphere{< 40*ft,-1.5*ft, 0*ft>,15*ft,3.0}
    sphere{< 30*ft,-2*ft, 0*ft>,15*ft,3.0}
    sphere{< 20*ft,-2.5*ft, 0*ft>,15*ft,3.0}
    sphere{< 10*ft,-3*ft, 0*ft>,15*ft,3.0}
    sphere{<  0*ft,-4*ft, 0*ft>,15*ft,3.0}
    sphere{<-10*ft,-3*ft, 0*ft>,15*ft,3.0}
    sphere{<-20*ft,-2.5*ft, 0*ft>,15*ft,3.0}
    sphere{<-30*ft,-2*ft, 0*ft>,15*ft,3.0}
    sphere{<-40*ft,-1.5*ft, 0*ft>,15*ft,3.0}
    sphere{<-50*ft,-1*ft, 0*ft>,15*ft,3.0}
    
    sphere{< 50*ft,-9*in,-10*ft>,15*ft,3.0}
    sphere{< 40*ft,-1*ft,-10*ft>,15*ft,3.0}
    sphere{< 30*ft,-1.5*ft,-10*ft>,15*ft,3.0}
    sphere{< 20*ft,-2*ft,-10*ft>,15*ft,3.0}
    sphere{< 10*ft,-2.5*ft,-10*ft>,15*ft,3.0}
    sphere{<  0*ft,-3*ft,-10*ft>,15*ft,3.0}
    sphere{<-10*ft,-2.5*ft,-10*ft>,15*ft,3.0}
    sphere{<-20*ft,-2*ft,-10*ft>,15*ft,3.0}
    sphere{<-30*ft,-1.5*ft,-10*ft>,15*ft,3.0}
    sphere{<-40*ft,-1*ft,-10*ft>,15*ft,3.0}
    sphere{<-50*ft,-9*in,-10*ft>,15*ft,3.0}
    
    sphere{< 50*ft,0,-20*ft>,15*ft,3.0}
    sphere{< 40*ft,0,-20*ft>,15*ft,3.0}
    sphere{< 30*ft,0,-20*ft>,15*ft,3.0}
    sphere{< 20*ft,0,-20*ft>,15*ft,3.0}
    sphere{< 10*ft,0,-20*ft>,15*ft,3.0}
    sphere{<  0*ft,-2.5*ft,-20*ft>,15*ft,3.0}
    sphere{<-10*ft,0,-20*ft>,15*ft,3.0}
    sphere{<-20*ft,0,-20*ft>,15*ft,3.0}
    sphere{<-30*ft,0,-20*ft>,15*ft,3.0}
    sphere{<-40*ft,0,-20*ft>,15*ft,3.0}
    sphere{<-50*ft,0,-20*ft>,15*ft,3.0}
    
    sphere{< 50*ft,0,-30*ft>,15*ft,3.0}
    sphere{< 40*ft,0,-30*ft>,15*ft,3.0}
    sphere{< 30*ft,0,-30*ft>,15*ft,3.0}
    sphere{< 20*ft,0,-30*ft>,15*ft,3.0}
    sphere{< 10*ft,0,-30*ft>,15*ft,3.0}
    sphere{<  0*ft,-2*ft,-30*ft>,15*ft,3.0}
    sphere{<-10*ft,0,-30*ft>,15*ft,3.0}
    sphere{<-20*ft,0,-30*ft>,15*ft,3.0}
    sphere{<-30*ft,0,-30*ft>,15*ft,3.0}
    sphere{<-40*ft,0,-30*ft>,15*ft,3.0}
    sphere{<-50*ft,0,-30*ft>,15*ft,3.0}
    
    sphere{< 50*ft,    0,-40*ft>,15*ft,3.0}
    sphere{< 40*ft,-6*in,-40*ft>,15*ft,3.0}
    sphere{< 30*ft,    0,-40*ft>,15*ft,3.0}
    sphere{< 20*ft,-9*in,-40*ft>,15*ft,3.0}
    sphere{< 10*ft,    0,-40*ft>,15*ft,3.0}
    sphere{<  0*ft,-1.5*ft,-40*ft>,15*ft,3.0}
    sphere{<-10*ft,    0,-40*ft>,15*ft,3.0}
    sphere{<-20*ft,-9*in,-40*ft>,15*ft,3.0}
    sphere{<-30*ft,    0,-40*ft>,15*ft,3.0}
    sphere{<-40*ft,-6*in,-40*ft>,15*ft,3.0}
    sphere{<-50*ft,    0,-40*ft>,15*ft,3.0}
    
    sphere{< 15*ft,    0,-47.5*ft>,15*ft,4.0}
    sphere{< 15*ft,-1.5*ft,-45*ft>,15*ft,3.0}
  //}
  //box{
  //  <-60*ft,-6*in,-47.5*ft>,<60*ft,6*in,47.5*ft>
  //}
  //rotate x*180
  //scale <1,2,1>
  translate <-32.5*ft,0*ft,47.5*ft>
  texture{Earth}
}

//Ground

difference{
  plane{
    y,0
  }
  object{Island}
  #if (HouseOnly=0)
    box{
      <-7*120-62.5,.5,-15>*ft,<7*120-62.5,-1,-95>*ft
      texture{Earth}
    }
    box{
      <-7*120-62.5,.5,295>*ft,<7*120-62.5,-1,185>*ft
      texture{Earth}
    }
    #declare j=-3;
    #while (j<4)
      box{
        <30+290*j,.5,280>*ft,<140+290*j,-1,1400>*ft
        texture{Earth}
      }
      #declare j=j+1;
    #end
  #end
  texture{Grass}
}

#if (Detailed=1)
  #include "unbehouse.inc"
#else
  #declare House=
  RHouse(
    <-62.5*ft,0,0>,<0,0,0>,
    <90*ft,2,50*ft>,<120*ft,-1*ft,95*ft>,<30*ft,0,0>,
    2,
    Housewall,Flooring,WindowFrame,Roof,MownLawn,PicketTex,Stone
  )
#end

union{
  difference{
    object{Island}
    box{<-95*ft,-1*in,-15*ft>,<30*ft,50*ft,100*ft> texture{Earth}}
    box{
      <-17.5*ft,-7*ft,90*ft>,<22.5*ft,1*in,60*ft>
      texture{pigment{colour rgb <.4,.6,.8>}}
    }
  }
  object{House}
  translate <0,26*ft,0>
}

#if (HouseOnly=0)
  #declare i=-6;
  #while (i<7)
    #if (i!=0)
      RandHouse(// The side of the street containing this house:
        <i*120*ft-62.5*ft,0,15*ft>,<0,0,0>,
        <90*ft,2,50*ft>,<120*ft,-1*ft,95*ft>,<30*ft,0,15*ft>,
        2
        //Housewall,Flooring,WindowFrame,Roof,MownLawn,PicketTex,Stone
      )
    #end
    RandHouse(// The other side of this street
      <i*120*ft,0,-115*ft>,<0,180,0>,
      <90*ft,2,50*ft>,<120*ft,-1*ft,95*ft>,<30*ft,0,20*ft>,
      2
      //Housewall,Flooring,WindowFrame,Roof,MownLawn,PicketTex,Stone
    )
    RandHouse(// Houses behind the house, on the main street.
      <i*120*ft-35*ft,0,170*ft>,<0,180,0>,
      <90*ft,2,50*ft>,<120*ft,-1*ft,95*ft>,<30*ft,0,20*ft>,
      2
      //Housewall,Flooring,WindowFrame,Roof,MownLawn,PicketTex,Stone
    )
      #if (mod(i,6)=2)
        object{Streetlight translate <i*120-170,0,-24.5>*ft}
        object{Streetlight rotate 90 translate <i*120+30,0,-85.5>*ft}
      #end
    #declare i=i+1;
  #end
  
  //Next-door neighbour
  object{CrSHELDON(<-52*ft,0,62*ft>,<0,-90,0>)}
  
  //This road
  union{
    box{
      <-7*120,0,0>*ft,<7*120,-.5,-10>*ft
      texture{Pavement}
    }
    box{
      <-7*120,-1,-10>*ft,<7*120,-.5,-70>*ft
      texture{RoadTar}
    }
    box{
      <-7*120,0,-70>*ft,<7*120,-.5,-80>*ft
      texture{Pavement}
    }
    box{//centre-line markings
      <-7*120,-0.51,-40-1/12>*ft,<7*120,-0.49,-40+1/12>*ft
      texture{Roadmarks}
    }
    translate <0,0,-15*ft>
  }

  //Nearest main road
  union{
    //there was a <-7*120,0,295>*ft,,<7*120,-.5,285>*ft but it moved
    box{
      <-7*120,-1,285>*ft,<7*120,-.5,195>*ft
      texture{RoadTar}
    }
    box{
      <-7*120,0,195>*ft,<7*120,-.5,185>*ft
      texture{Pavement}
    }
    box{//centre-line markings
      <-7*120,-0.51,240-1/12>*ft,<7*120,-0.48,240+1/12>*ft
      texture{Roadmarks}
    }
  }
 
  //side roads
  #declare j=2;
  #while (j<4)
    union{
      box{
        <30+290*j,0,280>*ft,<40+290*j,-.5,1400>*ft
        texture{Pavement}
      }
      box{//grass verge
        <40+290*j,0,1400>*ft,<50+290*j,-.5,1400>*ft
        texture{Lawn}
      }
      box{
        <50+290*j,-1,280>*ft,<120+290*j,-.5,1400>*ft
        texture{RoadTar}
      }
      box{//grass verge
        <120+290*j,0,1400>*ft,<130+290*j,-.5,1400>*ft
        texture{Lawn}
      }
      box{
        <130+290*j,0,280>*ft,<140+290*j,-.5,1400>*ft
        texture{Pavement}
      }
      box{//centre-line markings
        <85+290*j-1/12,-0.51,280>*ft,<85+290*j+1/12,-0.48,1400>*ft
        texture{Roadmarks rotate y*90}
      }
      box{//end of road/yield
        <85+290*j,-0.51,280>*ft,<50+290*j,-0.48,279.75>*ft
        texture{pigment{White}}//{Roadmarks2 rotate y*90}
      }
      box{
        <85+290*j,-0.51,280>*ft,<120+290*j,-0.48,279.5>*ft
        texture{pigment{White}}//{Roadmarks2 rotate y*90}
      }
      box{
        <85+290*j,-0.51,279>*ft,<120+290*j,-0.48,278.5>*ft
        texture{pigment{White}}//{Roadmarks2 rotate y*90}
      }
    }
    box{
      <-60+290*j,0,295>*ft,<50+290*j,-.5,285>*ft
      texture{Pavement}
    }
    box{
      <120+290*j,0,295>*ft,<230+290*j,-.5,285>*ft
      texture{Pavement}
    }
    RandHouse(//corner house on right
      <152+290*j,0,380>*ft,<0,90,0>,
      <60*ft,3,60*ft>,<90*ft,-1*ft,90*ft>,<5*ft,0,12*ft>,
      2
      //Housewall,Flooring,WindowFrame,Roof,MownLawn,PicketTex,Stone
    )
    RandHouse(//corner house on left
      <18+290*j,0,320>*ft,<0,-90,0>,
      <60*ft,3,60*ft>,<90*ft,-1*ft,90*ft>,<25*ft,0,12*ft>,
      2
      //Housewall,Flooring,WindowFrame,Roof,MownLawn,PicketTex,Stone
    )
    #declare i=1;
    #while (i<4) //was 16, but parsing took forever and you never see them!
      #declare Offset=5*mod(i,2);
      RandHouse(//normal house on right - semidetached
        <152+290*j,0,380+60*i-5+Offset>*ft,<0,90,0>,
        <55*ft,3,30*ft>,<60*ft,-1*ft,90*ft>,<5-Offset,0,12>*ft,
        2
        //Housewall,Flooring,WindowFrame,Roof,MownLawn,PicketTex,Stone
      )
      RandHouse(//normal house on left
        <18+290*j,0,325+60*i+Offset>*ft,<0,-90,0>,
        <55*ft,3,30*ft>,<60*ft,-1*ft,90*ft>,<Offset,0,12>*ft,
        2
        //Housewall,Flooring,WindowFrame,Roof,MownLawn,PicketTex,Stone
      )
      #if (mod(j,6)=1)
        object{Streetlight rotate -90 translate <42+290*j,0,325+60*i>}
      #end
      #if (mod(j,6)=4)
        object{Streetlight rotate 90 translate <128+290*j,0,325+60*i>}
      #end
      #declare i=i+1;
    #end
    #declare j=j+1;
  #end
#end

/*
// Credits - imagemap on newspaper
bicubic_patch{
  type 1 flatness 0.1
  u_steps 3 v_steps 3
  <  0.0,  0.0,  0.0> <  4.0,  0.0,  0.0> <  7.5,  0.0,  0.0> < 11.5,  0.0,  0.0>
  <  0.0, -5.0,  0.0> <  4.0, -5.0,  0.0> <  7.5, -5.0,  0.0> < 11.5, -5.0,  0.0>
  <  0.0,-10.0,  0.0> <  4.0,-10.0,  0.0> <  7.5,-10.0,  0.0> < 11.5,-10.0,  0.0>
  <  0.0,-15.0,  0.0> <  4.0,-15.0,  0.0> <  7.5,-15.0,  0.0> < 11.5,-15.0,  0.0>
  scale 2*in
  texture{
    pigment{
      colour rgb <1,1,1>
    }
  }
  texture{
    pigment{
      image_map{
        //sys "credits.pict"
        gif "credits.gif"
        once interpolate 2
      }
      rotate x*90
      scale <11.5,1,15>
      translate <0,0,-30*in>
    }
  }
  rotate x*90 rotate 75*y
  translate <-55,-.47,-54>*ft
}
*/                                                                                                                         6  6   e u i l t - i n )        s0pdmhouse.pov998)onsrrr.htmletioiTEXTPOV3                      9  r                                                                                                                         H 	Monaco  N     ^ N(F ^ N(FP  $  $  L     ^ N(F ^ N(F  L              X   ; <ttxt8BIMGKONGKONTVOD     	                         >                               ?  rpza                  > 
0  {      d     F       6  6   eL    R MPSR  FPRF   *           L    6     nPOV-Ray File Prefs                                                                                                     