//***************************************************************************
// Two different types of office chairs.
// ***************************************************************************
// Objects provided by this file are:
//	moebelrolle
//	rollenkreuz
//	BUEROHOCKER
//	BUEROSTUHL
//
// Textures provided by this file are:
//	black_plastic
//	turquois_plastic
// ***************************************************************************
// Scale: 1 millimeter per POV unit.
// ***************************************************************************
// *               Manfred.Agne@munich.netsurf.de  (1998)                    *
// *                     Feel free to use this file.                         *
// ***************************************************************************

#include "metals.inc"

//############################################################################
// Mbelrolle fr Brostuhl; Mae in mm; steht auf z=0 -Ebene, Befestigung an
// Bolzen an (0,60,0), beliebig rotierbar um z-Achse.
//----------------------------------------------------------------------------
#declare black_plastic =
texture {
  pigment { color Brown/5+<0.1,0,0>}
}
#declare turquois_plastic =
texture {
  pigment { color Brown/2}
  normal { bumps 0.2 scale 0.15 }
  finish { phong 0.5 phong_size 30 }
}
//----------------------------------------------------------------------------
#declare moebelrolle =
union {
  cylinder {<25,25, 25>,<25,25, 5>, 25}
  cylinder {<25,25,-25>,<25,25,-5>, 25}
  cylinder {<25,25,-20>,<25,25,20>,  5}
  difference {
    cylinder {<25,25,25>,<25,25,-25>,30}
    cylinder {<25,25,26>,<25,25,-26>,27}
    plane {<0,1,0> 25 }
  }
  difference {
    cylinder {<0,25,0>,<0,55,0>,25}
    cylinder {<25,25,26>,<25,25,-26>,27}
    plane {<0,1,0> 25 }
  }
  cylinder {<0,55,0>,<0,60,0>,25}
}
//----------------------------------------------------------------------------
#declare rollenkreuz =
union {
  difference {
    union {
      sphere { <300,70,0>,30 }
      cylinder { <0,70,0>,<300,70,0>,30 }
    }
    plane {<0,1,0>, 60}
  }
  object {moebelrolle rotate <0,60,0> translate <300,0,0>}
}
//----------------------------------------------------------------------------
#ifndef (addh)
  #declare addh = 0;
#end
#declare BUEROHOCKER =
union {
  object { rollenkreuz texture {black_plastic}}
  object { rollenkreuz rotate <0, 72,0> texture {black_plastic}}
  object { rollenkreuz rotate <0,144,0> texture {black_plastic}}
  object { rollenkreuz rotate <0,216,0> texture {black_plastic}}
  object { rollenkreuz rotate <0,288,0> texture {black_plastic}}
  cone { <0,70,0>,60,<0,110,0>,50 texture {black_plastic}}
  cone { <0,70,0>,45,<0,240,0>,35 texture {black_plastic}}
  cylinder { <0,240,0>,<0,400+addh,0>,20 texture {T_Chrome_5A}}
  // Sitzflche:
  cone { <0,400+addh,0>,40,<0,450+addh,0>,230 texture {black_plastic}}
  torus{ 200,30 translate <0,450+addh,0> texture {black_plastic}}
  torus{ 200,28 translate <0,470+addh,0> texture {turquois_plastic}}
  cylinder {<0,470+addh,0>,<0,498+addh,0>,200 texture {turquois_plastic}}
}
//----------------------------------------------------------------------------
#declare BUEROSTUHL =
union {
  object { BUEROHOCKER }
  // Rckenlehne:
  cone { <280,700+addh,0>,40,<260,700+addh,0>,150 texture {black_plastic}}
  torus{ 150,30 rotate <0,0,90> translate <230,700+addh,0> texture {black_plastic}}
  torus{ 150,28 rotate <0,0,90> translate <210,700+addh,0> texture {turquois_plastic}}
  cylinder {<210,700+addh,0>,<182,700+addh,0>,150 texture {turquois_plastic}}
  difference{
    torus{ 50,8 rotate <0,0,90> translate <285,700+addh,0> }
    plane{ <0,1,0> 700+addh }
    texture {T_Chrome_5A}
  }
  cylinder{ <285,700+addh, 50>,<285,480+addh, 50>,8 texture {T_Chrome_5A}}
  cylinder{ <285,700+addh,-50>,<285,480+addh,-50>,8 texture {T_Chrome_5A}}
  difference{
    torus{ 50,8 rotate <90,0,0> translate <235,480+addh,50> }
    plane{ <0,-1,0>,-480-addh }
    plane{ <1,0,0>,235 }
    texture {T_Chrome_5A}
  }
  difference{
    torus{ 50,8 rotate <90,0,0> translate <235,480+addh,-50> }
    plane{ <0,-1,0>,-480-addh }
    plane{ <1,0,0>,235 }
    texture {T_Chrome_5A}
  }
  cylinder{ <235,430+addh, 50>,<0,430+addh, 50>,8 texture {T_Chrome_5A}}
  cylinder{ <235,430+addh,-50>,<0,430+addh,-50>,8 texture {T_Chrome_5A}}
}
//**************************************************************************
//*** EOF *** EOF *** EOF *** EOF *** EOF *** EOF *** EOF *** EOF *** EOF **
//**************************************************************************
